function supdofs = applyBC(nodes,type,geometry)

% Find boundary nodes
nodes_bot = find(nodes(:,2)==geometry.ymin);
nodes_top = find(nodes(:,2)==geometry.ymax);
nodes_left = find(nodes(:,1)==geometry.xmin);
nodes_right = find(nodes(:,1)==geometry.xmax);
% Find nodes of columns
column.botleft = intersect(nodes_bot,nodes_left);
column.botright = intersect(nodes_bot,nodes_right);
column.topright = intersect(nodes_top,nodes_right);
column.topleft = intersect(nodes_top,nodes_left);

switch type
    case 'simply_supp'
        % Vertical supports
        nodes_SS = union(nodes_right,union(nodes_top,union(nodes_bot,nodes_left))); % All edges
        supdofs_SS = 6*nodes_SS-3;
        % Stability
        node_stabil = intersect(nodes_bot,nodes_left); % Corner
        supdofs_stabil = [6*node_stabil-5,6*node_stabil-4,6*node_stabil];
        % All
        supdofs = union(supdofs_SS,supdofs_stabil);
    case 'simply_supp_SYM'
        % Left edge
        supdofs_left = 6*nodes_left-3; % TZ
        % Bottom edge
        supdofs_bot = 6*nodes_bot-3; % TZ
        % Symmetry: right edge
        supdofs_right = 6*nodes_right-1; % RY
        % Symmetry: top edge
        supdofs_top = 6*nodes_top-2; % RX
        % Stability
        node_stabil = intersect(nodes_bot,nodes_left); % Corner
        supdofs_stabil = [6*node_stabil-5,6*node_stabil-4,6*node_stabil];
        % All
        supdofs = union(supdofs_left,union(supdofs_bot,union...
            (supdofs_right,union(supdofs_top,supdofs_stabil))));
    case '4corners_fixed'
        % Fixed columns: DOFs 3,4,5
        nodes_fix = [column.botleft,column.botright,column.topright,column.topleft];
        supdofs_fix = union(6*nodes_fix-3,union(6*nodes_fix-2,6*nodes_fix-1));
        % Stability
        node_stabil = intersect(nodes_bot,nodes_left); % Corner
        supdofs_stabil = [6*node_stabil-5,6*node_stabil-4,6*node_stabil];
        % All
        supdofs = union(supdofs_fix,supdofs_stabil);
    case '4corners_fixed_SYM'
        % Fixed column: DOFs 3,4,5
        nodes_fix = intersect(nodes_bot,nodes_left);
        supdofs_fix = union(6*nodes_fix-3,union(6*nodes_fix-2,6*nodes_fix-1));
        % Symmetry: right edge
        supdofs_right = 6*nodes_right-1; % RY
        % Symmetry: top edge
        supdofs_top = 6*nodes_top-2; % RX
        % Stability
        node_stabil = intersect(nodes_bot,nodes_left); % Corner
        supdofs_stabil = [6*node_stabil-5,6*node_stabil-4,6*node_stabil];
        % All
        supdofs = union(supdofs_fix,union(supdofs_right,union(supdofs_top,supdofs_stabil)));
    case 'cantiplate'
        % Columns
        nodes1 = find(nodes(:,1)==1.875);
        nodes2 = find(nodes(:,1)==8.125);
        nodes3 = find(nodes(:,2)==1.875);
        nodes4 = find(nodes(:,2)==8.125);
        column1 = intersect(nodes1,nodes3);
        column2 = intersect(nodes1,nodes4);
        column3 = intersect(nodes2,nodes3);
        column4 = intersect(nodes2,nodes4);
        nodes_columns = union(column1,union(column2,union(column3,column4)));
        supdofs_columns = 6*nodes_columns-3;
        % Stability
        node_stabil = intersect(nodes_bot,nodes_left); % Corner
        supdofs_stabil = [6*node_stabil-5,6*node_stabil-4,6*node_stabil];
        % All
        supdofs = union(supdofs_columns,supdofs_stabil);
    case 'cantiplate_SYM'
        % Column
        nodes1 = find(nodes(:,1)==1.875);
        nodes2 = find(nodes(:,2)==1.875);
        node_column1 = intersect(nodes1,nodes2);
        supdofs_column = 6*node_column1-3;
        % Symmetry: right edge
        supdofs_right = 6*nodes_right-1; % RY
        % Symmetry: top edge
        supdofs_top = 6*nodes_top-2; % RX
        % Stability
        node_stabil = intersect(nodes_bot,nodes_left); % Corner
        supdofs_stabil = [6*node_stabil-5,6*node_stabil-4,6*node_stabil];
        % All
        supdofs = union(supdofs_column,union(supdofs_right,union(supdofs_top,supdofs_stabil))); 
end
end