      SUBROUTINE W3RTVEDS(IUNIT,IBDATE,IBUFTN,ISATOB,PBOT,DSNAME,IDSDAT,
     $ IDSDMP,IERR)
C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:    W3RTVEDS    DECODES RTOVS BUFR DATA, REFORMATS TO EDS
C   PRGMMR: KEYSER           ORG: NP22       DATE: 1999-01-20
C
C ABSTRACT: READS AND UNPACKS ONE REPORT FROM INPUT RTOVS RETRIEVAL
C   JBUFR FILE INTO SPECIFIED FORMAT. RETURNS INFORMATION IN THE
C   FORMAT OF AN UNPACKED NMCEDS FILE.  ONLY THOSE ELEMENTS OF NMCEDS
C   NEEDED BY THE PREPDATA PROGRAM ARE ACTUALLY PROCESSED INTO NMCEDS
C   FORMAT, THE REMAINING WORDS OF THE 140-WORD ARRAY ARE SET TO 7777
C   "MISSING". THERE IS SOME OTHER RETRIEVAL INFORMATION RETURNED.
C   ALSO, INFORMATION ABOUT THE INPUT DATA SET ITSELF (NAME, CENTER
C   DATE, DUMP TIME) IS RETURNED.
C
C PROGRAM HISTORY LOG:
C 1998-03-10  BERT B. KATZ
C 1998-05-05  D.A. KEYSER/NP22 -- STREAMLINED, CORRECTED ERRORS
C 1998-06-15  D.A. KEYSER/NP22 -- ADDED CALL TO W3FI04 FIRST TIME IN
C      TO OBTAIN MACHINE WORD LENGTH (USED TO HARDWIRE WORD LENGTH
C      OF 8 BYTES AS USED IN XMOVEX SUBROUTINE); FILTER FLAG RETURNED
C      IN IBUFTN(20) NOW HAS SAME MEANING AS FOR TOVS (250KM SUB-
C      SAMPLING), IT'S ACTUAL VALUE IS NOW RETURNED (WAS HARDWIRED
C      TO 0)
C 1998-09-21  D.A. KEYSER/NP22 -- SUBROUTINE NOW Y2K AND FORTRAN 90
C      COMPLIANT
C 1999-01-20 D. A. KEYSER -- INCORPORATED BOB KISTLER'S CHANGES NEEDED
C      TO PORT THE CODE TO THE IBM SP
C
C USAGE :   CALL W3RTVEDS(IUNIT,IBDATE,IBUFTN,ISATOB,PBOT,DSNAME,
C                         IDSDAT,IDSDMP,IERR)
C   INPUT ARGUMENT LIST:
C     IUNIT    - UNIT NUMBER OF INPUT FILE CONTAINING RETRIEVAL DATA
C              - IN BUFR FORMAT.
C
C   OUTPUT ARGUMENT LIST:
C     IBDATE   - DATE IN SECTION 1 OF BUFR MESSAGE CONTAINING THIS
C              - RETRIEVAL (IN FORM YYYYMMDDHH)
C     IBUFTN   - CONTAINS A SINGLE DECODED RETRIEVAL IN NMCEDS FORMAT
C              - (140 MACHINE WORD LENGTH INTEGER WORDS)
C     ISATOB   - 3-WORD INTEGER ARRAY CONTAINING RETURNED DATA
C              - (SEE REMARKS FOR CONTENTS)
C     PBOT     - FIRST ABOVE-GROUND TOVS PRESSURE LEVEL IN MB
C              - (MISSING IS 99999.)
C     DSNAME   - CHARACTER*8 DATA SET NAME (SAME FOR ALL REPORTS IN
C              - A COMMON INPUT DATA SET - SEE REMARKS FOR IERR=1)
C     IDSDAT   - INTEGER DATA SET CENTER DATE IN FORM YYYYMMDDHH (SAME
C              - FOR ALL REPORTS IN A COMMON INPUT DATA SET - SEE
C              - REMARKS FOR IERR=1)
C     IDSDMP   - INTEGER DATA SET DUMP TIME IN FORM YYYYMMDDHHMM (SAME
C              - FOR ALL REPORTS IN A COMMON INPUT DATA SET - SEE
C              - REMARKS FOR IERR=1)
C     IERR     - ERROR RETURN CODE
C                 =  0 OBSERVATION READ AND UNPACKED INTO LOCATIONS
C                        'IBUFTN', 'ISATOB', AND 'PBOT'.  SEE REMARKS
C                        FOR CONTENTS. NEXT CALL TO W3RTVEDS WILL
C                        RETURN NEXT OBSERVATION IN DATA SET.
C                 =  1 INFORMATION ABOUT THE BUFR DATASET IS RETURNED
C                        IN THE OUTPUT ARGUMENTS DSNAME, IDSDAT, IDSDMP
C                        (SEE OUTPUT ARGUMENT LIST ABOVE)
C
C                        THIS SHOULD ALWAYS OCCUR AFTER THE FIRST CALL
C                        TO THIS SUBROUTINE.  NO REPORT IS UNPACKED AT
C                        THIS POINT, AND ONLY DSNAME, IDSDAT, AND
C                        IDSDMP CONTAIN INFORMATION.  ALL SUBSEQUENT
C                        CALLS TO W3RTVEDS SHOULD RETURN THE
C                        OBSERVATIONS IN THIS DATA SET, SEQUENTIALLY,
C                        (IERR=0) UNTIL THE END OF FILE IS ENCOUNTERED
C                        (IERR=2).  THE VALUES STORED IN DSNAME,
C                        IDSDAT, AND IDSDMP WILL CONTINUE TO BE
C                        RETURNED ALONG WITH EACH REPORT WHEN IERR = 0.
C                 =  2 FOR NORMAL END-OF-FILE ENCOUNTERED.)
C                 = -1 FOR END-OF-FILE ON FIRST READ -- EMPTY FILE
C                 = -2 FOR INPUT BUFR FILE NOT Y2K COMPLIANT -- NO
C                        PROCESSING DONE
C                 = -3 CENTER DATE COULD NOT BE OBTAINED FROM INPUT
C                        FILE -- NO PROCESSING DONE
C
C   INPUT FILES:
C     UNIT "IUNIT" - FILE CONTAINING BUFR RTOVS DATA
C
C   OUTPUT FILES:
C     UNIT 06 - STANDARD OUTPUT PRINT
C
C REMARKS:
C
C     CONTENTS OF OUTPUT ARGUMENT IBUFTN {140 INTEGER WORDS - IN NMCEDS
C       FORMAT EXCEPT WHERE NOTED -- ONLY THE WORDS NOTED BELOW
C       ARE FILLED WITH DATA (THAT NEEDED BY THE PREPDATA PROGRAM) -
C       ALL OTHER WORDS ARE SET TO MISSING - 7777)}:
C        WORD 1 - Satellite ID  (NOAA-11 - 1; NOAA-12 - 2; NOAA-14 - 3)
C             3 - Day of month * 256 plus hour of day (UTC)
C             4 - Minute * 256 plus second (UTC)
C             5 - Latitude (degrees * 100, N+, S-)
C             6 - Longitude (degrees * 100, E+, W-)
C             8 - Land/sea indicator (Land - elev in meters, Sea - 0)
C             9 - Surface (skin) temperature (K * 10)
C            12 - Retrieval method
C        * - 16 - Nadir proximity indicator (Range: 1-9, where 1
C                  is at Nadir and 9 is at limb)
C            20 - Filter Flag (good - 0; redundant - 1)
C            23 - Layer 1 - pressure at lower boundary (mb * 10)
C            24 - Layer 1 - pressure at upper boundary (mb * 10)
C            25 - Layer 1 - mean virtual temperature (K * 10)
C            26 - Layer 1 - always missing (7777)
C            27 - 82 - Repeat 23-27 for Layers 2 - 15
C
C        * - Definition changed from original NMCEDS documentation
C         Missings are set to 7777
C
C     CONTENTS OF OUTPUT ARGUMENT ISATOB (3 INTEGER WORDS) FOR EACH
C      RETRIEVAL:
C        WORD  1 - ORBIT NUMBER
C              2 - DAY/NIGHT QUALIFIER (=0 FOR NIGHT)
C                                      (=1 FOR DAY)
C              3 - SNOW/ICE FLAGS (TERRAIN TYPE)
C                                      (BUFR C.T. 0-13-039)
C         Missings are set to 99999
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 90
C   MACHINE:  IBM-SP, CRAY, SGI
C
C$$$

      DATA IFIRST/0/,KOUNTR/0/

      REAL GEOOPR(18),TMPOPR(40),WOPR(15),TLAYER(15),PLAYER(16)

      INTEGER IBUFTN(140),ISATOB(3),JDATE(5),JDUMP(5)

      INTEGER(8) IDSDMP

      CHARACTER*8 SUBSET,DSNAME

      CHARACTER*50 IDTSTR
      DATA IDTSTR/'FOVN SAID CLAT CLON DAYS HOUR MINU SECO ORBN DNQL '/

      CHARACTER*5 IDTST2
      DATA IDTST2/'TOFF '/

      CHARACTER*10 SATSTR
      DATA SATSTR/'SDPT LSQL '/

      CHARACTER*15 SRFSTR
      DATA SRFSTR/'PRES SELV TERR '/

      CHARACTER*10 RETSTR
      DATA RETSTR/'TMDB MIXR '/

      REAL(8) XIDENT(11),SATDAT(2),SRFDAT(3),RETDAT(2,40)

      REAL TOVLEV(40)

      DATA TOVLEV/0.1,0.2,0.5,1.0,1.5,2.0,3.0,4.0,5.0,7.0,10.0,15.0,
     $            20.0,25.0,30.0,50.0,60.0,70.0,85.0,100.0,115.0,135.0,
     $            150.0,200.0,250.0,300.0,350.0,400.0,430.0,475.0,500.0,
     $            570.0,620.0,670.0,700.0,780.0,850.0,920.0,950.0,
     $            1000.0/
      DATA  BMISS/10.E10/,XMSG/99999./,IMSG/99999/

      IF(IFIRST.EQ.0) THEN

cvvvvvy2ky2k
C  FIRST TIME IN, SET DATELEN AND GET CENTER AND DUMP TIME FOR FILE
C  ----------------------------------------------------------------

         PRINT *, ' ==> W3RTVEDS -- Y2K/F90 VERSION 01-20-1999'
         IFIRST = 1
         call datelen(10)
         CALL DUMPBF(IUNIT,JDATE,JDUMP)
cppppp
         print *, 'CENTER DATE (JDATE) = ',jdate
         print *, 'DUMP DATE (JDUMP) = ',jdump
         print *, ' '
cppppp
         IF(JDATE(1).LE.0)  then
            PRINT *, '##W3RTVEDS - CENTER DATE COULD NOT BE ',
     $       'OBTAINED FROM INPUT FILE ON UNIT ',IUNIT,' -- IERR = -3'
            ierr = -3
            return
         END IF
         IF(JDATE(1).LT.100)  THEN

C IF 2-DIGIT YEAR RETURNED IN JDATE(1), MUST USE "WINDOWING" TECHNIQUE
C  TO CREATE A 4-DIGIT YEAR

C IMPORTANT: IF DATELEN(10) IS CALLED, THE DATE HERE SHOULD ALWAYS
C            CONTAIN A 4-DIGIT YEAR, EVEN IF INPUT FILE IS NOT
C            Y2K COMPLIANT (BUFRLIB DOES THE WINDOWING HERE)

            PRINT *, '##W3RTVEDS - THE FOLLOWING SHOULD NEVER ',
     $       'HAPPEN!!!!!'
            PRINT *, '##W3RTVEDS - 2-DIGIT YEAR IN JDATE(1) RETURNED ',
     $       'FROM DUMPBF (JDATE IS: ',JDATE,') - USE WINDOWING ',
     $       'TECHNIQUE TO OBTAIN 4-DIGIT YEAR'
            IF(JDATE(1).GT.20)  THEN
               JDATE(1) = 1900 + JDATE(1)
            ELSE
               JDATE(1) = 2000 + JDATE(1)
            ENDIF
            PRINT *, '##W3RTVEDS - CORRECTED JDATE(1) WITH 4-DIGIT ',
     $       'YEAR, JDATE NOW IS: ',JDATE
         ENDIF
         IDSDAT = JDATE(1)*1E6+JDATE(2)*1E4+JDATE(3)*1E2+JDATE(4)
         IF(JDUMP(1).LE.0)  THEN
            IDSDMP = 999999999999_8
         ELSE
            IF(JDUMP(1).LT.100)  THEN

C IF 2-DIGIT YEAR RETURNED IN JDUMP(1), MUST USE "WINDOWING" TECHNIQUE
C  TO CREATE A 4-DIGIT YEAR

C IMPORTANT: IF DATELEN(10) IS CALLED, THE DATE HERE SHOULD ALWAYS
C            CONTAIN A 4-DIGIT YEAR, EVEN IF INPUT FILE IS NOT
C            Y2K COMPLIANT (BUFRLIB DOES THE WINDOWING HERE)

               PRINT *, '##W3RTVEDS - THE FOLLOWING SHOULD NEVER ',
     $          'HAPPEN!!!!!'
               PRINT *, '##W3RTVEDS - 2-DIGIT YEAR IN JDUMP(1) ',
     $          'RETURNED FROM DUMPBF (JDUMP IS: ',JDUMP,') - USE ',
     $          'WINDWOING TECHNIQUE TO OBTAIN 4-DIGIT YEAR'
               IF(JDUMP(1).GT.20)  THEN
                  JDUMP(1) = 1900 + JDUMP(1)
               ELSE
                  JDUMP(1) = 2000 + JDUMP(1)
               ENDIF
               PRINT *, '##W3RTVEDS - CORRECTED JDUMP(1) WITH 4-DIGIT ',
     $          'YEAR, JDUMP NOW IS: ',JDUMP
            END IF
            IDSDMP = JDUMP(1)*1E8+JDUMP(2)*1E6+JDUMP(3)*1E4+
     $       JDUMP(4)*1E2+JDUMP(5)
         ENDIF
         DSNAME = 'RTOVS   '
         IERR = 1
         RETURN
      ELSE  IF(IFIRST.EQ.1) THEN

C  SECOND TIME IN, OPEN BUFR DATASET FOR INPUT AND DECODE FIRST MESSAGE
C  --------------------------------------------------------------------

         IFIRST = 2
         CALL OPENBF(IUNIT,'IN',IUNIT)
         CALL READMG(IUNIT,SUBSET,IBDATE,IRET)
         IF(IRET.NE.0) THEN
            WRITE(6,1009) IUNIT
 1009       FORMAT('##W3RTVEDS ERROR: EMPTY FILE IN UNIT ',I5)
            IERR = -1
            RETURN
         ENDIF
         IF(IBDATE.LT.100000000)  THEN
c IF INPUT BUFR FILE DOES NOT RETURN MESSAGES WITH A 4-DIGIT YEAR,
c  SOMETHING IS WRONG (EVEN NON-COMPLIANT BUFR MESSAGES SHOULD
c  CONSTRUCT A 4-DIGIT YEAR AS LONG AS DATELEN(10) HAS BEEN CALLED
            WRITE(6,1209) IUNIT
 1209       FORMAT('##W3RTVEDS ERROR: A 10-DIGIT SECT. 1 BUFR MESSAGE ',
     $       'DATE WAS NOT RETURNED IN UNIT',I5,' - PROBLEM WITH BUFR ',
     $       'FILE')
            IERR = -2
            RETURN
         END IF

      ENDIF

 1000 CONTINUE

C  EACH CALL TO READSB INCREASES "KOUNTR" BY 1 (REGARDLESS OF RESULT)
C  ------------------------------------------------------------------

      KOUNTR = KOUNTR + 1

      CALL READSB(IUNIT,IRET)
      IF(IRET.NE.0) THEN
         CALL READMG(IUNIT,SUBSET,IBDATE,IRET)
         IF(IRET.NE.0) THEN

C  ALL BUFR MESSAGES HAVE BEEN READ AND DECODED -- ALL DONE
C  --------------------------------------------------------

            WRITE(6,1001) IUNIT
 1001 FORMAT(//' ==> W3RTVEDS: END OF FILE ON UNIT',I3,' -- ALL DONE'/)
            IERR = 2
            RETURN
         ENDIF
         IF(IBDATE.LT.100000000)  THEN
c IF INPUT BUFR FILE DOES NOT RETURN MESSAGES WITH A 4-DIGIT YEAR,
c  SOMETHING IS WRONG (EVEN NON-COMPLIANT BUFR MESSAGES SHOULD
c  CONSTRUCT A 4-DIGIT YEAR AS LONG AS DATELEN(10) HAS BEEN CALLED
            WRITE(6,1209) IUNIT
            IERR = -2
            RETURN
         END IF
         GO TO 1000
      ENDIF

      IBUFTN = 7777
cppppp
cdak  print *, 'INITIALLY -- IBUFTN = .....'
cdak  print *, IBUFTN
cppppp

      PBOT = XMSG
      ISATOB = IMSG

      XIDENT = BMISS
      CALL UFBINT(IUNIT,XIDENT,11, 1,IRET,IDTSTR//IDTST2)

      SATDAT = BMISS
      CALL UFBINT(IUNIT,SATDAT,2, 1,IRET,SATSTR)

      SRFDAT = BMISS
      CALL UFBINT(IUNIT,SRFDAT,3, 1,IRET,SRFSTR)

      RETDAT = BMISS
      CALL UFBINT(IUNIT,RETDAT,2,40,NLEV,RETSTR)

C  NADIR PROXIMITY INDICATOR {IBUFTN(16)}
C  --------------------------------------

      IF(XIDENT(1).LT.BMISS)  THEN
         NADIR = INT(ABS(FLOAT(NINT(XIDENT(1))) - 28.5)) / 3
         IF(NADIR.LT.9) NADIR = NADIR + 1
      ENDIF
      IF(NADIR.GT.0.AND.NADIR.LT.10)  THEN
         IBUFTN(16) = NADIR
      ELSE
         WRITE(6,2070) KOUNTR,NADIR
 2070 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS ',
     $ 'AN INVALID NADIR PROX. IND. (=',I5,') - SKIP IT')
         GO TO 1000
      ENDIF

C  SATELLITE ID {IBUFTN(1)}
C  ------------------------

      IF(XIDENT(2).LT.BMISS)  THEN
         IF(NINT(XIDENT(2)).EQ.203) THEN
            IBUFTN(1)   = 1
         ELSE IF(NINT(XIDENT(2)).EQ.204) THEN
            IBUFTN(1)   = 2
         ELSE IF(NINT(XIDENT(2)).EQ.205) THEN
            IBUFTN(1)   = 3
         ELSE
            WRITE(6,2071) KOUNTR,NINT(XIDENT(2))
 2071 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS ',
     $ 'AN UNRECOGNIZED SATELLITE ID (=',I5,') - SKIP IT')
            GO TO 1000
         ENDIF
      ELSE
         WRITE(6,2072) KOUNTR
 2072 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS A',
     $ ' MISSING SATELLITE ID - SKIP IT')
         GO TO 1000
      ENDIF

C  LATITUDE {IBUFTN(5)}
C  --------------------

      IF(XIDENT(3).LT.BMISS)  THEN
         IBUFTN(5)  = NINT(XIDENT(3) * 100.)
      ELSE
         WRITE(6,2073) KOUNTR
 2073 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS A',
     $ ' MISSING LATITUDE - SKIP IT')
         GO TO 1000
      ENDIF

C  LONGITUDE {IBUFTN(6)}
C  ---------------------

      IF(XIDENT(4).LT.BMISS) THEN
         IBUFTN(6)  = NINT(XIDENT(4) * 100.)
      ELSE
         WRITE(6,2074) KOUNTR
 2074 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS A',
     $ ' MISSING LONGITUDE - SKIP IT')
         GO TO 1000
      ENDIF

      IF(MAX(XIDENT(5),XIDENT(6),XIDENT(7),XIDENT(8)).LT.BMISS) THEN

C  DAY OF MONTH (* 256) + HOUR (UTC) {IBUFTN(3)}
C  ---------------------------------------------

         IBUFTN(3)  = (256 * NINT(XIDENT(5))) + NINT(XIDENT(6))

C  MINUTE (* 256) + SECOND (UTC) {IBUFTN(4)}
C  -----------------------------------------

         IBUFTN(4)  = (256 * NINT(XIDENT(7))) + NINT(XIDENT(8))
      ELSE
         WRITE(6,2075) KOUNTR
 2075 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS ',
     $ 'ONE OR MORE MISSING TIME UNITS - SKIP IT')
         GO TO 1000
      ENDIF

C  RETRIEVAL METHOD {IBUFTN(12)}
C  -----------------------------

      IF(SATDAT(1).GE.BMISS)  THEN
         WRITE(6,2076) KOUNTR
 2076 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS A',
     $ ' MISSING SATELLITE DATA PROCESSING TECHNIQUE - SKIP IT')
         GO TO 1000
      ENDIF
      IF(NINT(SATDAT(1)).GE.32) THEN

C  --> Clear path

         MCL = 1
         ICCMVS = 1
      ELSE IF(NINT(SATDAT(1)).GE.16) THEN

C  --> NSTAR path (NOT VALID FOR RTOVS!! - SHOULD NEVER SEE THIS)

         WRITE(6,2077) KOUNTR
 2077 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS A',
     $ ' SATELLITE DATA PROCESSING TECHNIQUE ASSIGNED TO NSTAR PATH'/
     $ '    THIS IS NOT VALID FOR RTOVS - SKIP IT')
         GO TO 1000
      ELSE IF(NINT(SATDAT(1)).GE.8) THEN

C  --> Cloudy path

         MCL = 2
         IF(NINT(SATDAT(2)).EQ.1) THEN
            ICCMVS = 2
         ELSE
            ICCMVS = 3
         ENDIF
      ELSE

C  --> Unknown path

         WRITE(6,2078) KOUNTR
 2078 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS ',
     $ 'AN UNKNOWN SATELLITE DATA PROCESSING TECHNIQUE - SKIP IT')
         GO TO 1000
      ENDIF

      IBUFTN(12) = (256 * MCL) + (16 * MCL) + 1

C  FILTER FLAG {IBUFTN(20)}
C  ------------------------

      IF(XIDENT(11).LT.BMISS)   IBUFTN(20) = NINT(XIDENT(11))

C  LAND/SEA INDICATOR (IF LAND ELEV, IF SEA 0) {IBUFTN(8)}
C  -------------------------------------------------------

      IF(SRFDAT(2).LT.BMISS)   IBUFTN(8) = NINT(SRFDAT(2))
      IF(NINT(SATDAT(2)).EQ.0) IBUFTN(8) = 0

C  SURFACE (SKIN) TEMPERATURE {IBUFTN(9)}
C  --------------------------------------

C Must set to 7777 (missing) - it is used by PREPDATA (subr. W3FA07)
C  only to the extent that if it is missing, then the surface
C  temperature is obtained from the lowest layer mean virtual temp.
c  only, rather than from the avg. of the lowest layer mean virt.
C  temperature and this surface (skin) temp. {IBUFTN(9)}.
C   - This may not be correct, but it is consistent with the TOVS
C     processing from before, where even though the skin temp.
C     in IBUFTN(9) was not missing, the 7'th bit (counting from right,
C     where rightmost bit is position 0) of the value in IBUFTN(11)
C     was always 0 (the largest value for IBUFTN(11) in TOVS was 64).
C
C  This test in W3FA07 is:
C
C      TSFC  = IBUFTN(9)/10.0
C                 ....
C                 ....
C      IF(.NOT.(BTEST(IBUFTN(11),7)).OR.IBUFTN(9).EQ.7777)
C    $ TSFC = TBAR(1) + (.0555 * (IP1(1) - PMID(1)))
C     TSFC = (TSFC + TBAR(1) + (.0555 * (IP1(1) - PMID(1))))/2
C
C  This allows us to ignore IBUFTN(11) here (set to 7777, which
C   actually yields a 0 in bit 7 anyway!!)

      IBUFTN(9) = 7777

      IF(NLEV.EQ.40)  THEN

C  FILL IN THE LEVEL SOUNDING DATA - MUST HAVE 40 TEMP LEVELS TO ACCEPT
C  --------------------------------------------------------------------

         DO  L = 1,NLEV
            IF(RETDAT(1,L).GE.BMISS)  THEN
               WRITE(6,2082) KOUNTR
 2082 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') ',
     $ 'CONTAINS 1 OR MORE MISSING TEMERATURES IN ITS SOUNDING - SKIP ',
     $ 'IT')
               GO TO 1000
            ENDIF
            TMPOPR(L) = RETDAT(1,L)
cppppp
cdak           print *, 'AT L = ',L,'; RETDAT(2,L) = ',RETDAT(2,L)
cppppp
            TMP=RETDAT(2,L)*1000._8
            IF(L.GT.25) WOPR(L-25) = MIN(BMISS,TMP)
         ENDDO
      ELSE
         WRITE(6,2081) KOUNTR,NLEV
 2081 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') DOES ',
     $ 'NOT CONTAIN 40 SOUNDING LEVELS (HAS ',I3,' LEVELS) - SKIP IT')
         GO TO 1000
      ENDIF

      IF(SRFDAT(1).LT.BMISS) THEN
         PBOT = 0.01 * SRFDAT(1)
         DO  L = 40,1,-1
            IF(NINT(PBOT*100.).GT.NINT(TOVLEV(L)*100.)) THEN
               LST = L
               GO TO 1850
            ENDIF
         ENDDO
         WRITE(6,3079) KOUNTR,PBOT
 3079 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS A',
     $ ' STRANGE BOTTOM PRESSURE (=',F8.2,' MB)  - SKIP IT')
         GO TO 1000
 1850    CONTINUE
         PLST = TOVLEV(LST)
      ELSE
         WRITE(6,2079) KOUNTR
 2079 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') HAS A',
     $ ' MISSING BOTTOM PRESSURE - SKIP IT')
         GO TO 1000
      ENDIF

C For now set PTRP (trop pressure) to 0.0 as we can't determine this
C  (this means we may not want to throw out superadiabatic retr. as
C   determined by subr. RTVEDS02 since the entire column is checked,
C   when the logic expects to only check sfc to trop for supers)

      PTRP = 0.0
cppppp
cdak  print *, 'Going into RTVEDS02 -- IBUFTN = .....'
cdak  print *, IBUFTN
cdak  print *, 'TMPOPR = ',TMPOPR
cdak  print *, 'WOPR = ',WOPR
cdak  print *, 'PLST = ',PLST
cdak  print *, 'ICCMVS = ',ICCMVS
cdak  print *, 'PTRP = ',PTRP
cppppp
      CALL RTVEDS02(TMPOPR,WOPR,PLST,ICCMVS,PTRP,TLAYER,GEOOPR,PLAYER,
     $ ISUPER)

      IF(ISUPER.EQ.1)  THEN
         WRITE(6,2080) KOUNTR
 2080 FORMAT(/'##W3RTVEDS WARNING: A DECODED RETRIEVAL (#',I5,') IS ',
     $ 'SUPERADIABATIC ACCORDING TO SUBR. RTVEDS02- SKIP IT')
         GO TO 1000
      ENDIF

      DO  L = 1,15
        LREV = 16 - L
        IF(TLAYER(L).LT.999.99) THEN
          IBUFTN(4*L+19) = NINT(PLAYER(LREV+1) * 10.)
          IBUFTN(4*L+20) = NINT(PLAYER(LREV) * 10.)
          IBUFTN(4*L+21) = NINT((TLAYER(L) * 10.) + 0.0000001)
        ENDIF
      ENDDO

C  ORBIT NUMBER
C  ------------

      IF(XIDENT(9).LT.BMISS)  ISATOB(1) = NINT(XIDENT(9))

C  DAY-NIGHT INDICATOR
C  -------------------

      IF(XIDENT(10).LT.BMISS)  ISATOB(2) = NINT(XIDENT(10))

C  TERRAIN INDICATOR
C  -----------------

      IF(SRFDAT(3).LT.BMISS)  ISATOB(3) = NINT(SRFDAT(3))


      IERR = 0

      RETURN

      END

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C                .      .    .                                       .
C SUBPROGRAM:    RTVEDS02    CONVERTS 40-LVL RTOVS TO 15-LAYER AVGS
C   PRGMMR: BERT B. KATZ     ORG: W/NMC23    DATE: 1994-03-22
C                                 GENERAL
C                                 SCIENCES CORP.
C
C ABSTRACT: USES RTOVS 18 MANDATORY-LEVEL GEOPOTENTIAL HEIGHTS AND
C   40-LEVEL TEMPERATURES TO ARRIVE AT 15-LAYER AVERAGED VIRTUAL
C   TEMPERATURES. IF THE LOW LEVELS ARE MISSING, THEN FILLER (999.99)
C   INSERTED IN PLACE OF THE TEMPERATURES.
C
C PROGRAM HISTORY LOG:
C 1985-06-07  E. BURDSALL (NESDIS)
C 1990-04-30  T. GARDNER (NESDIS/STX)
C 1994-03-22  BERT B. KATZ   ADPATED FOR USE IN CDAS/RE-ANALYSIS
C
C USAGE:    CALL RTVEDS02(TMPOPR,WOPR,PSFC,ICCMVS,
C                         PTRP,TKLNMC,GPHGT,PNMC,ISUPER)
C   INPUT ARGUMENT LIST:
C     TMPOPR   - RTOVS 40-LEVEL RETRIEVED TEMPERATURES (DEG. K).
C     WOPR     - RTOVS 15-LEVEL RETRIEVED MIXING RATIOS (G / KG).
C     PSFC     - RTOVS MODEL SURFACE LEVEL (MB).
C     ICCMVS   - NESDIS CHANNEL COMBINATION FLAG FOR MVS RETRIEVALS.
C     PTRP     - TROPOPAUSE PRESSURE (MB).
C
C   OUTPUT ARGUMENT LIST:
C     TKLNMC   - RTOVS 15-LAYER RETRIEVED VIRTUAL TEMPERATURES (DEG. K).
C     GPHGT    - RTOVS 18 MANDATORY-LEVEL GEOPOTENTIAL HEIGHTS (M).
C     PNMC     - PRESSURES AT LAYER INTERFACES (MB).
C     ISUPER   - NESDIS SUPERADIABATIC FLAG.
C
C REMARKS: CALLED BY SUBROUTINE W3RTVEDS.
C
C   KEY LOCAL PARAMETERS-
C      VARIABLE                TYPE  FUNCTION
C      --------                ----  --------
C      NPMAN                   I*4   NUMBER OF MANDATORY LEVELS (18)
C      NPRET                   I*4   NUMBER OF RTOVS TEMPERATURE
C                                    RETRIEVAL LEVELS (40)
C      NPMIX                   I*4   NUMBER OF RTOVS MOISTURE RETRIEVAL
C                                    LEVELS (15)
C      C0 - C14                R*4   CONSTANTS USED TO CALCULATE
C                                    LAYER-MEAN TEMPERATURES
C      THK                     R*4   GEOPOTENTIAL THICKNESS (M) BETWEEN
C                                    SELECTED MANDATORY PRESSURE LEVELS
C      PLOC(16)                R*4   NCEP PRESSURE LEVELS
C      NPNMC                   I*4   NUMBER OF NCEP PRESSURE LEVELS (16)
C
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 90
C   MACHINE:  IBM-SP, CRAY, SGI
C
C$$$
      SUBROUTINE RTVEDS02(TMPOPR,WOPR,PSFC,ICCMVS,PTRP,TKLNMC,
     $ GPHGT,PNMC,ISUPER)

      REAL PLOC(16),TMPOPR(40),WOPR(15),GPHGT(18),PMAN(18),PRET(40)
      REAL DLP(39),TKLNMC(15),PNMC(16),TVIRT(40),ZHGT(40)

      DATA C0/0.257286585/,C1/0.5/,C2/0.242713415/,C3/0.20751875/,
     $ C4/0.5/,C5/0.29248125/,C6/0.3782354/,C7/0.5/,C8/0.1217646/,
     $ C9/0.1217646/,C10/0.278746475/,C11/0.3782354/,C12/0.221253525/,
     $ C13/0.2435292/,C14/0.034164751/

      LOGICAL L1,L3,L4,L5,L6

      DATA LNMC1/4/,LNMC2/5/,LNMC3/6/,LNMC4/7/,LNMC5/8/,LNMC6/9/,
     $ LNMC7/11/,LNMC8/12/,LNMC9/13/,LNMC10/14/
      DATA NPRET/40/,NPMAN/18/,NPNMC/16/,NLT/15/,FILL/999.99/,NPMIX/15/
      DATA PRET/0.1,0.2,0.5,1.0,1.5,2.0,3.0,4.0,5.0,7.0,10.0,15.0,20.0,
     $ 25.0,30.0,50.0,60.0,70.0,85.0,100.0,115.0,135.0,150.0,200.0,
     $ 250.0,300.0,350.0,400.0,430.0,475.0,500.0,570.0,620.0,670.0,
     $ 700.0,780.0,850.0,920.0,950.0,1000.0/
      DATA DLP/0.69315,0.91629,0.69315,0.40546,0.28768,0.40546,
     $ 0.28768,0.22314,0.33647,0.35667,0.40546,0.28768,0.22314,0.18232,
     $ 0.51083,0.18232,0.15415,0.19416,0.16252,0.13976,0.16034,0.10536,
     $ 0.28768,0.22314,0.18232,0.15415,0.13353,0.07232,0.09953,0.05129,
     $ 0.13103,0.08408,0.07756,0.04380,0.10821,0.08594,0.07914,0.03209,
     $ 0.05129/
      DATA PMAN/1.,3.,7.,10.,20.,30.,50.,70.,100.,150.,200.,250.,300.,
     $ 400.,500.,700.,850.,1000./
      DATA PLOC/0.4,1.0,2.0,5.0,10.0,30.0,50.0,70.0,100.0,200.0,
     $ 300.0,400.0,500.0,700.0,850.0,1000.0/

      DATA CONS/14.6435/
      DATA TSUPLM/10.0/

      INTEGER CCHLKP(7,2),CCLLKP(7),CCWLKP(7)
      DATA CCHLKP/0,2,2,2,6,6,5,0,1,1,1,3,3,4/
      DATA CCLLKP/0,1,2,5,4,6,3/
      DATA CCWLKP/0,1,0,0,0,0,2/

      INTEGER IDXSUP(18)
      DATA IDXSUP/4,7,10,11,13,15,16,18,20,23,24,25,26,28,31,35,37,40/

      DATA NTPRET/0/
      DATA  BMISS/10.E10/

      PNMC = PLOC

      L1=ANINT(PSFC).GE.ANINT(PRET(32))

      DO  I = 1,40
         IF(ANINT(PSFC).EQ.ANINT(PRET(I))) THEN
           LST = I
           GO TO 315
         ENDIF
      ENDDO
  315 CONTINUE

C  INITILIZE DO-LOOP LIMITS FOR COMPUTING GEOPOTENTIAL HEIGHTS.

      JSTRT=2
      JSTOP=LST

C  INITIALIZE VIRTUAL TEMPERATURE ARRAY.

      TVIRT = TMPOPR

C  ADJUST GEOPOTENTIAL HEIGHT DO-LOOP LIMITS

      ZHGT = 0.0
 
      IF(.NOT.L1) THEN
         JSTOP=NPRET-NPMIX
         GO TO 350
      ENDIF

C  COMPUTE VIRTUAL TEMPERATURES (K).

      LSTART=NPRET-NPMIX+1
      DO  L = LSTART,LST
cppppp
cdak  print *, 'WOPR(L-NPRET+NPMIX)  = ',WOPR(L-NPRET+NPMIX)
cdak  print *, 'TVIRT(L) = ',tvirt(l)
cppppp
         IF(WOPR(L-NPRET+NPMIX).LT.BMISS) TVIRT(L)=
     $    TMPOPR(L)*(1.0+.61*WOPR(L-NPRET+NPMIX)/
     $             (1000.0+WOPR(L-NPRET+NPMIX)))
cppppp
cdak  print *, 'TVIRT(L) = ',tvirt(l)
cppppp
      ENDDO

  350 CONTINUE

C  COMPUTE GEOPOTENTIAL HEIGHTS (METERS) AT RTOVS LEVELS.

      DO  J = JSTRT,JSTOP
         I=JSTOP+1-J
         ZHGT(I)=ZHGT(I+1)+(TVIRT(I)+TVIRT(I+1))*DLP(I)*CONS
      ENDDO

      GPHGT(1:NPMAN) = ZHGT(IDXSUP(1:NPMAN))

      ISUPER=0
      L5=ANINT(PSFC).LT.ANINT(PRET(32))

C  DETERMINE IF NECESSARY TO CHECK FOR SUPERADIABATIC LAPSE RATES.

      IF (L5) GO TO 450

C  DETERMINE FIRST RTOVS PRESSURE LEVEL HIGHER THAN OR AT THE TROPOPAUSE
C    PRESSURE.

      LTROP=2
      DO  I = 2,LST
         J=NPRET+1-I
         IF (PRET(J).GT.PTRP) GO TO 420
         LTROP=J
         GO TO 425
  420    CONTINUE
      ENDDO
  425 CONTINUE
cppppp
cdak  print *, 'After trop loop, LTROP = ',LTROP,' (should be 2)'
cppppp

C  DETERMINE FIRST MANDATORY PRESSURE LEVEL AT OR BELOW THE RTOVS LEVEL
C   DETERMINED IN THE PREVIOUS STEP.

      DO  I = 1,NPMAN
         IF (PMAN(I).LT.PRET(LTROP)) GO TO 427
         LTROP=I
         GO TO 430
  427    CONTINUE
      ENDDO

  430 CONTINUE
cppppp
cdak  print *, 'After pman loop, LTROP = ',LTROP,' (should be 1)'
cppppp

C DETERMINE FIRST MANDATORY PRESSURE LEVEL AT OR HIGHER THAN THE SURFACE
C  PRESSURE LEVEL.

      DO  I = 1,NPMAN
         J=NPMAN+1-I
         IF (ANINT(PMAN(J)).GT.ANINT(PSFC)) GO TO 433
         LSURF=J
         GO TO 435
  433    CONTINUE
      ENDDO
  435 CONTINUE

C  CHECK FOR SUPERADIABATIC LAPSE RATES BETWEEN MANDATORY PRESSURE
C   LEVELS 'LTROP' AND 'LSURF'.

      LSTOP=LSURF-1
      DO  J = LTROP,LSTOP

C  IF PRESSURE LEVEL AT OR ABOVE 100MB, CHANGE UNITS OF GEOPOTENTIAL
C   HEIGHTS FROM DECAMETERS TO METERS.

         GPHIGH=GPHGT(J)
         GPLOW=GPHGT(J+1)
         DZ=ABS(GPLOW-GPHIGH)
         IF (DZ.LT.0.000001) GO TO 440
         K=J+1
         TMPVAL=(TMPOPR(IDXSUP(K))-TMPOPR(IDXSUP(J)))*(1000.0/DZ)
         IF (TMPVAL.LE.TSUPLM) GO TO 440
         ISUPER=1
         GO TO 450
  440    CONTINUE
      ENDDO

C  CHECK FOR SUPERADIABATIC LAPSE RATE BETWEEN LEVELS 'LSURF' AND 'LST',
C   IF NECESSARY.

      IF (ANINT(PMAN(LSURF)).GE.ANINT(PSFC)) GO TO 450
      DO  I = 21,LST
         IF (PRET(I).NE.PMAN(LSURF)) GO TO 445
         LEVEL=I
         GO TO 447
  445    CONTINUE
      ENDDO
  447 CONTINUE
      DZ=ABS(ZHGT(LEVEL)-ZHGT(LST))
      IF (DZ.LT.0.000001) GO TO 450
      TMPVAL=(TMPOPR(LST)-TMPOPR(LEVEL))*(1000.0/DZ)
      IF (TMPVAL.LE.TSUPLM) GO TO 450
      ISUPER=1

  450 CONTINUE
      IF(ISUPER.EQ.1) RETURN

      TKLNMC = FILL

      ICCTHI = CCHLKP(ICCMVS+1,2)
      ICCTLO = CCLLKP(ICCMVS+1)
      ICCW = CCWLKP(ICCMVS+1)
      IF(ICCTHI.LT.1 .OR. ICCTHI.GT.6) ICCTHI = 6
      IF(ICCTLO.LT.0 .OR. ICCTLO.GT.6) ICCTLO = 0
      IF(ICCW.LT.0 .OR. ICCW.GT.2) ICCW = 0
      L1=ISUPER.EQ.1
      L3=ICCTLO.EQ.0
      L4=ICCW.EQ.0.AND.ICCTLO.NE.0.AND.LST.LT.32
      L5=ICCTHI.NE.6
      L6=ICCTHI.EQ.6

C  CHECK FOR AVAILABILITY OF GEOPOTENTIAL HEIGHTS FROM THE SURFACE TO
C   100 MB. IF FOLLOWING TESTS ARE SATISFIED GEOPOTENTIAL HEIGHTS ARE
C   NOT AVAILABLE.

      IF (L1) GO TO 510

C  CHECK IF TROPOSPHERIC TEMPERATURES SOUTH OF 10N ARE NOT TO BE
C   COMPUTED

      IF (L3) GO TO 510

C  CHECK IF SURFACE DATA IS RELIABLE. IF TEST NOT  SATISFIED,
C   GEOPOTENTIAL HEIGHTS ARE AVAILABLE FROM THE SURFACE TO 0.4 MB.

      IF (.NOT.L4) GO TO 530

C  DATA ONLY AVAILABLE TO COMPUTE LAYER-MEAN TEMPERATURES BETWEEN
C   SELECTED NCEP PRESSURE LEVELS FROM 200 TO 0.4 MB. SET POINTER(NUMT)
C   DENOTING NUMBER OF LAYER-MEAN TEMPERATURES  TO BE CALCULATED.

      NUMT=LNMC6
      NTPRET=NTPRET+1

C  SET POINTER(NT) SPECIFYING ATMOSPHERIC LAYER AT WHICH TEMPERATURE
C   CALCULATIONS BEGIN(100-200MB LAYER).

      NT=LNMC4

C  CHECK FOR AVAILABILITY OF RETRIEVAL DATA ABOVE 10 MB.

C  DATA AVAILABLE TO COMPUTE LAYER-MEAN TEMPERATURES ONLY BETWEEN
C   SELECTED NCEP PRESSURE LEVELS FROM 200 TO 10 MB. RESET POINTER(NUMT)
C   FOR NUMBER OF MEAN-LAYER TEMPERATURES TO BE CALCULATED.

      IF (.NOT.L5) NUMT=LNMC2
      GO TO 570

  510 CONTINUE

C  RETRIEVAL DATA IS ONLY AVAILABLE TO COMPUTE LAYER-MEAN TEMPERATURES
C   BETWEEN SELECTED NCEP PRESSURE LEVELS FROM 100 TO 0.4 MB.  SET
C   POINTER(NUMT) FOR NUMBER OF LAYER-MEAN TEMPERATURES TO BE CALCULATED

      NUMT=LNMC5
      NTPRET=NTPRET+1

C  SET POINTER(NT) SPECIFYING ATMOSPHERIC LAYER AT WHICH TEMPERATURE
C   CALCULATIONS BEGIN(70-100 MB LAYER).

      NT=LNMC5

C  CHECK FOR AVAILABILITY OF RETRIEVAL DATA ABOVE 10 MB.

C  DATA AVAILABLE TO COMPUTE LAYER-MEAN TEMPERATURES ONLY BETWEEN
C   SELECTED NCEP PRESSURE LEVELS FROM 100 TO 10 MB. RESET POINTER(NUMT)
C   FOR NUMBER OF TEMPERATURES TO BE CALCULATED.

      IF (.NOT.L5) NUMT=LNMC1

C  INITIALIZE POINTER(M): SPECIFIES THE STARTING MANDATORY PRESSURE
C   LEVEL AT WHICH GEOPOTENTIAL HEIGHT DATA IS USED FOR CALCULATION OF
C   LAYER-MEAN TEMPERATURES.

      M=LNMC6
      GO TO 580

  530 CONTINUE

C  DATA AVAILABLE TO COMPUTE LAYER-MEAN TEMPERATURES BETWEEN SELECTED
C   NCEP PRESSURE LEVELS FROM THE SURFACE TO 0.4 MB. SET POINTER(NUMT)
C   FOR NUMBER OF LAYER-MEAN TEMPERATURES TO BE CALCULATED.

      NUMT=NPNMC-1

C  SET POINTER(NT) SPECIFYING ATMOSPHERIC LAYER AT WHICH TEMPERATURE
C   CALCULATIONS ARE TO BEGIN(1000-850 MB LAYER).

      NT=1

C  CHECK FOR AVAILABILITY OF RETRIEVAL DATA ABOVE 10 MB.

      IF (.NOT.L5) THEN

C  DATA AVAILABLE TO COMPUTE LAYER-MEAN TEMPERATURES BETWEEN SELECTED
C   NCEP PRESSURE LEVELS FROM THE SURFACE TO 10 MB.  RESET POINTER(NUMT)
C   FOR NUMBER OF TEMPERATURES TO BE CALCULATED.

         NUMT=LNMC7
      ENDIF

C  INITIALIZE POINTER(M): SPECIFIES STARTING MANDATORY PRESSURE LEVEL
C   AT WHICH GEOPOTENTIAL HEIGHT DATA IS TO BE USED FOR CALCULATION OF
C   LAYER-MEAN TEMPERATURES.

      M=NPMAN

C  CHECK TO DETERMINE IF SURFACE PRESSURE IS LESS THAN 1000 MB.

      IF(ANINT(PNMC(NPNMC)).EQ.ANINT(PSFC)) GO TO 580

C  ADJUST NUMBER OF NCEP PRESSURE LEVELS WHEN SURFACE PRESSURE IS LESS
C   THAN 1000 MB.

      DO  I = 1,NPNMC-1

C  REVERSE ORDERING SEQUENCE OF NCEP PRESSURE LEVELS (START WITH LEVEL
C   15: E.G. PNMC(15)=850 MB).

         J=NPNMC-I

C  RESET POINTER(NT) SPECIFYING FIRST LAYER WHERE LAYER-MEAN TEMPERATURE
C   CALCULATIONS ARE TO BEGIN.

         NT=I

C  CHECK TO DETERMINE NEW NCEP SURFACE PRESSURE.

         IF(ANINT(PSFC).GT.ANINT(PNMC(J))) GO TO 560
      ENDDO

  560 CONTINUE

C  DEFINE NEW NCEP SURFACE PRESSURE.

      PNMC(J+1)=PSFC

C  RESET POINTER(NUMT) FOR NUMBER OF LAYER-MEAN TEMPERATURES TO BE
C   CALCULATED.

      NUMT=J
      IF (L6) NUMT=NUMT-LNMC1

C  RESET POINTER(M) FOR MANDATORY PRESSURE LEVEL.

      M=J+3
      GO TO 580

  570 CONTINUE

C  RESET POINTER(M) FOR MANDATORY PRESSURE LEVELS( FOR CASES WHEN DATA
C   ONLY AVAILABLE BETWEEN 200-0.4 OR 200-10 MB.

      M=LNMC7

  580 CONTINUE

C  DEFINE LOWER AND UPPER DO-LOOP LIMITS FOR ERROR ESTIMATE CALCULATIONS
C   (USED IN SUBROUTINE CALERR).

      NTL=NT
      NTU=NTL+NUMT-1

C  CALCULATE LAYER-MEAN TEMPERATURES
C  ---------------------------------

      DO I = NTL,NTU

C  REVERSE ORDERING SEQUENCE OF NCEP PRESSURE LEVELS.

         J=NLT-I+1

C  CHECK FOR SPECIAL CASES WHEN GEOPOTENTIAL THICKNESSES MUST BE SUMMED
C   TO COMPUTE LAYER-MEAN TEMPERATURES.

         IF(I.EQ.LNMC3) GO TO 590
         IF(I.EQ.LNMC4) GO TO 600
         IF(I.EQ.LNMC7) GO TO 610

C  CHECK TO ENSURE IF DATA AVAILABLE ABOVE 10 MB. IF TEST SATISFIED
C   CALCULATION OF LAYER-MEAN TEMPERATURES NOT REQUIRED USING RETRIEVAL
C   TEMPERATURE DATA.

         IF(L6) GO TO 690
         GO TO 640

  590    CONTINUE

C  DEFINE LOWER(ML) AND UPPER(MU) DO-LOOP LIMITS FOR SUMMATION OF
C   THICKNESSES BETWEEN 300-200 MB LEVELS.

         ML=11
         MU=12
         GO TO 620

  600    CONTINUE

C  DEFINE ML AND MU FOR SUMMATION OF THICKNESSES BETWEEN 200-100 MB LVLS

         ML=9
         MU=10
         GO TO 620

  610    CONTINUE

C  DEFINE ML AND MU FOR SUMMATION OF THICKNESSES BETWEEN 30-10 MB LEVELS

         ML=4
         MU=5

  620    CONTINUE

C  INITIALIZE SUMMATION OF THICKNESSES.

         SUMTHK=0.

C  SUM THICKNESSES.

         DO  L = ML,MU
            THK=GPHGT(L)-GPHGT(L+1)
            SUMTHK=SUMTHK+THK
         ENDDO
         THK=SUMTHK

C  RESET POINTER(M) TO MANDATORY PRESSURE LEVEL FOR NEXT THICKNESS
C   CALCULATION.

         M=M-1
         GO TO 700

  640    CONTINUE

C  CHECK FOR SPECIAL CASES WHEN RTOVS RETRIEVAL TEMPERATURES ARE
C   REQUIRED TO COMPUTE LAYER-MEAN TEMPERATURES.

         IF(I.EQ.LNMC8) GO TO 650
         IF(I.EQ.LNMC9) GO TO 660
         IF(I.EQ.LNMC10) GO TO 670
         JJ=NPNMC-1
         IF(I.EQ.JJ) GO TO 680
         GO TO 690

  650    CONTINUE

C  COMPUTE LAYER-MEAN TEMPERATURE BETWEEN 10-5 MB LEVELS.

         TKLNMC(I)=C0*TMPOPR(11)+C1*TMPOPR(10)+C2*TMPOPR(9)
         GO TO 710

  660    CONTINUE

C  COMPUTE LAYER-MEAN TEMPERATURE BETWEEN 5-2 MB LEVELS.

         TKLNMC(I)=C9*TMPOPR(9)+C10*TMPOPR(8)+C11*TMPOPR(7)+
     $     C12*TMPOPR(6)
         GO TO 710

  670    CONTINUE

C  COMPUTE LAYER-MEAN TEMPERATURE BETWEEN 2-1 MB LEVELS.

         TKLNMC(I)=C3*TMPOPR(6)+C4*TMPOPR(5)+C5*TMPOPR(4)
         GO TO 710

  680    CONTINUE

C  INTERPOLATE RTOVS RETRIEVAL TEMPERATURE TO 0.4 MB LEVEL.

         TEMP=TMPOPR(3)+C13*(TMPOPR(2)-TMPOPR(3))

C  CALCULATE LAYER-MEAN TEMPERATURE BETWEEN 1-0.4 MB LEVEL.

         TKLNMC(I)=C6*TMPOPR(4)+C7*TMPOPR(3)+C8*TEMP
         GO TO 710

  690    CONTINUE

C  COMPUTE GEOPOTENTIAL THICKNESSES.

         THK=GPHGT(M-1)-GPHGT(M)

  700    CONTINUE

C  COMPUTE LAYER-MEAN TEMPERATURE USING HYPSOMETRIC EQUATION.

         TKLNMC(I)=-C14*THK*(1./ALOG(PNMC(J)/PNMC(J+1)))

  710    CONTINUE

C  RESET POINTER(M) TO MANDATORY PRESSURE LEVEL FOR NEXT THICKNESS
C   CALCULATION.

         M=M-1
      ENDDO

      RETURN

      END
