      SUBROUTINE W3FI04(IENDN,ITYPEC,LW)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FI04         FIND WORD SIZE, ENDIAN, CHARACTER SET
C   PRGMNR: JONES,R.E.       ORG: W/NMC42       DATE: 94-10-07
C
C ABSTRACT: SUBROUTINE COMPUTES WORD SIZE, THE TYPE OF CHARACTER
C   SET, ASCII OR EBCDIC, AND IF THE COMPUTER IS BIG-ENDIAN, OR
C   LITTLE-ENDIAN.
C
C PROGRAM HISTORY LOG:
C   94-10-07  R.E.JONES
C   98-07-08  Gilbert    -  Removed the Fortran SAVE Statement.
C                           The SAVE statement is not needed for this
C                           routine, and may have been causing errors
C                           using the f90 compiler under the 2.0
C                           Programming Environment.
C
C USAGE:  CALL W3FI04 (IENDN, ITYPEC, LW)
C
C   OUTPUT ARGUMENT LIST:
C     IENDN     -  INTEGER FOR BIG-ENDIAN OR LITTLE-ENDIAN
C                  = 0   BIG-ENDIAN
C                  = 1   LITTLE-ENDIAN
C                  = 2   CANNOT COMPUTE
C     ITYPEC    -  INTEGER FOR TYPE OF CHARACTER SET
C                  = 0   ASCII  CHARACTER SET
C                  = 1   EBCDIC CHARACTER SET
C                  = 2   NOT ASCII OR EBCDIC
C     LW        -  INTEGER FOR WORDS SIZE OF COMPUTER IN BYTES 
C                  = 4   FOR 32 BIT COMPUTERS
C                  = 8   FOR 64 BIT COMPUTERS  
C
C ATTRIBUTES:
C  LANGUAGE: CRAY CFT77 FORTRAN
C  MACHINE:  CRAY C916/256, Y-MP8/64, Y-MP EL92/256, J916/2048
C
C$$$
C
      INTEGER       ITEST1
      INTEGER       ITEST2
      INTEGER       ITEST3
      INTEGER       IENDN
      INTEGER       ITYPEC
      INTEGER       LW
C
      CHARACTER * 8 CTEST1
      CHARACTER * 8 CTEST2
      CHARACTER * 1 CTEST3(8)
      CHARACTER * 1 BLANK
C
      EQUIVALENCE   (CTEST1,ITEST1),(CTEST2,ITEST2)
C
      EQUIVALENCE   (ITEST3,CTEST3(1))
C
      DATA  CTEST1/'12345678'/
      DATA  ITEST3/Z'01020304'/
      DATA  BLANK /' '/
C
C     SAVE
C
C     TEST FOR TYPE OF CHARACTER SET
C     BLANK IS 32 (20 HEX) IN ASCII, 64 (40 HEX) IN EBCDEC
C
      IF (ICHAR(BLANK).EQ.32) THEN
        ITYPEC = 0
      ELSE IF (ICHAR(BLANK).EQ.64) THEN
C
C     COMPUTER IS PROBABLY AN IBM360, 370, OR 390 WITH
C     A 32 BIT WORD SIZE, AND BIG-ENDIAN.
C
        ITYPEC = 1
      ELSE
        ITYPEC = 2
      END IF
C
C     TEST FOR WORD SIZE, SET LW TO 4 FOR 32 BIT COMPUTER,
C     8 FOR FOR 64 BIT COMPUTERS
C
      ITEST2 = ITEST1
      IF (CTEST1 .EQ. CTEST2) THEN
C
C     COMPUTER MAY BE A CRAY, OR COULD BE DEC VAX ALPHA
C     OR SGI WITH R4000, R4400, R8800 AFTER THEY CHANGE
C     FORTRAN COMPILERS FOR 64 BIT INTEGER.
C
        LW = 8
      ELSE
        LW = 4
      ENDIF
C 
C     USING ITEST3 WITH Z'01020304' EQUIVALNCED TO CTEST3
C     ON A 32 BIT BIG-ENDIAN COMPUTER 03 IS IN THE 3RD 
C     BYTE OF A 4 BYTE WORD. ON A 32 BIT LITTLE-ENDIAN 
C     COMPUTER IT IS IN 2ND BYTE.
C     ON A 64 BIT COMPUTER Z'01020304' IS RIGHT ADJUSTED IN
C     A 64 BIT WORD, 03 IS IN THE 7TH BYTE.  ON A LITTLE-
C     ENDIAN 64 BIT COMPUTER IT IS IN THE 2ND BYTE.
C 
      IF (LW.EQ.4) THEN           
        IF (ICHAR(CTEST3(3)).EQ.3) THEN
          IENDN = 0
        ELSE IF (ICHAR(CTEST3(3)).EQ.2) THEN 
          IENDN = 1
        ELSE
          IENDN = 2
        END IF
      ELSE IF (LW.EQ.8) THEN           
        IF (ICHAR(CTEST3(7)).EQ.3) THEN
          IENDN = 0
        ELSE IF (ICHAR(CTEST3(2)).EQ.3) THEN
          IENDN = 1
        ELSE
          IENDN = 2
        END IF
      ELSE
        IENDN = 2
      END IF
C
      RETURN
      END
