       SUBROUTINE W3FA04(HEIGHT,PRESS,TEMP,THETA)
C$$$   SUBPROGRAM  DOCUMENTATION  BLOCK
C
C SUBPROGRAM: W3FA04         COMPUTE STADARD PRESSURE, TEMP, POT TEMP
C   AUTHOR: MCDONELL, J.     ORG: W345       DATE: JUL 74
C
C ABSTRACT: COMPUTES THE STANDARD PRESSURE, TEMPERATURE, AND POTEN-
C   TIAL TEMPERATURE GIVEN THE HEIGHT IN METERS ( < 32 KM ).    FOR
C   THE PRESSURE AND TEMPERATURE THE RESULTS DUPLICATE THE VALUES IN
C   THE U.S. STANDARD ATMOSPHERE (1962), WHICH IS THE ICAO STANDARD
C   ATMOSPHERE TO 54.7487 MB (20 KM) AND THE PROPOSED EXTENSION TO
C   8.68 MB (32 KM).  FOR POTENTIAL TEMPERATURE A VALUE OF  2/7  IS
C   USED FOR  RD/CP.
C
C PROGRAM HISTORY LOG:
C   74-06-01  J.MCDONELL
C   84-07-05  R.E.JONES   CHANGE TO IBM VS FORTRAN
C   90-04-27  R.E.JONES   CHANGE TO CRAY CFT77 FORTRAN
C
C USAGE:  CALL W3FA04 (HEIGHT, PRESS, TEMP, THETA)
C
C   INPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     HEIGHT ARG LIST  HEIGHT IN METERS
C
C   OUTPUT VARIABLES:
C     NAMES  INTERFACE DESCRIPTION OF VARIABLES AND TYPES
C     ------ --------- -----------------------------------------------
C     PRESS  ARG LIST  STANDARD PRESSURE IN MILLIBARS
C     TEMP   ARG LIST  TEMPERATURE IN DEGREES KELVIN
C     THETA  ARG LIST  POTENTIAL TEMPERATURE IN DEGREES KELVIN
C
C   SUBPROGRAMS CALLED:
C     NAMES                                                   LIBRARY
C     ------------------------------------------------------- --------
C     EXP                                                     SYSTEM
C
C   REMARKS: NOT VALID FOR HEIGHTS GREATER THAN 32 KM.
C     DECLARE ALL PARAMETERS AS TYPE REAL*4
C
C ATTRIBUTES:
C   LANGUAGE: INCLUDE VENDOR EXTENSIONS USED.
C
C ATTRIBUTES:
C   LANGUAGE: CRAY CFT77 FORTRAN
C   MACHINE:  CRAY Y-MP/832
C
C$$$
C
      REAL  M0
C
      DATA
     *G     /9.80665/,
     *RSTAR /8314.32/,
     *M0    /28.9644/,
     *PISO  /54.7487/,
     *ZISO  /20000./,
     *SALP  /-.0010/,
     *TSTR  /216.65/,
     *PTROP /226.321/,
     *ALP   /.0065/,
     *T0    /288.15/,
     *PZERO /1013.25/
C
      ROVCP = 2.0 / 7.0
      R     = RSTAR/M0
      IF (HEIGHT.GT.ZISO)   GO TO 100
      IF (HEIGHT.GT.11000.) GO TO 200
C
C     COMPUTE IN TROPOSPHERE
C
      TEMP = T0 - HEIGHT * ALP
      PRESS = PZERO * ((1.0 - ((ALP/T0) * HEIGHT)) ** (G/(ALP * R)))
      GO TO 300
C
C     COMPUTE LAPSE RATE = -.0010 CASES
C
 100  CONTINUE
      D     = HEIGHT - ZISO
      PRESS = PISO * ((1.-(( SALP /TSTR) * D  )) ** (G/( SALP * R)))
      TEMP  = TSTR - D * SALP
      GO TO 300
C
C     COMPUTE ISOTHERMAL CASES
C
 200  CONTINUE
      D     = EXP((HEIGHT - 11000.0) / ((R / G) * TSTR))
      PRESS = PTROP / D
      TEMP  = TSTR
C
 300  CONTINUE
      THETA = TEMP * ((1000.0 / PRESS) ** ROVCP)
      RETURN
      END
