      SUBROUTINE UFBCNT(LUNIT,KMSG,KSUB)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    UFBCNT
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE RETURNS A COUNT OF THE CURRENT MESSAGE
C   NUMBER AND SUBSET NUMBER, WHERE THE MESSAGE NUMBER IS RELATIVE TO
C   ALL MESSAGES IN THE BUFR FILE AND THE SUBSET NUMBER IS RELATIVE TO
C   ALL SUBSETS IN THE MESSAGE.  IF THE MESSAGE/SUBSET ARE BEING READ,
C   THE MESSAGE COUNT ADVANCES EACH TIME BUFR ARCHIVE LIBRARY
C   SUBROUTINE READMG (OR EQUIVALENT) IS CALLED AND THE SUBSET COUNT
C   ADVANCES EACH TIME BUFR ARCHIVE LIBRARY SUBROUTINE READSB (OR
C   EQUIVALENT) IS CALLED FOR A PARTICULAR MESSAGE.  IF THE MESSAGE/
C   SUBSET ARE BEING WRITTEN, THE MESSAGE COUNT ADVANCES EACH TIME
C   BUFR ARCHIVE LIBRARY SUBROUTINE OPENMG (OR EQUIVALENT) IS CALLED
C   AND THE SUBSET COUNT ADVANCES EACH TIME BUFR ARCHIVE LIBRARY
C   SUBROUTINE WRITSB (OR EQUIVALENT) IS CALLED.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 1998-07-08  J. WOOLLEN -- REPLACED CALL TO CRAY LIBRARY ROUTINE
C                           "ABORT" WITH CALL TO NEW INTERNAL BUFRLIB
C                           ROUTINE "BORT"
C 1999-11-18  J. WOOLLEN -- THE NUMBER OF BUFR FILES WHICH CAN BE
C                           OPENED AT ONE TIME INCREASED FROM 10 TO 32
C                           (NECESSARY IN ORDER TO PROCESS MULTIPLE
C                           BUFR FILES UNDER THE MPI)
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED
C                           DOCUMENTATION (INCLUDING HISTORY); OUTPUTS
C                           MORE COMPLETE DIAGNOSTIC INFO WHEN ROUTINE
C                           TERMINATES ABNORMALLY
C 2014-12-10  J. ATOR    -- USE MODULES INSTEAD OF COMMON BLOCKS
C
C USAGE:    CALL UFBCNT (LUNIT, KMSG, KSUB)
C   INPUT ARGUMENT LIST:
C     LUNIT    - INTEGER: FORTRAN LOGICAL UNIT NUMBER FOR BUFR FILE
C
C   OUTPUT ARGUMENT LIST:
C     KMSG     - INTEGER: POINTER TO MESSAGE COUNT IN BUFR FILE
C                (INCLUDING MESSAGE CURRENTLY OPEN FOR READING/WRITING)
C     KSUB     - INTEGER: POINTER TO SUBSET COUNT IN BUFR MESSAGE
C                (INCLUDING SUBSET CURRENTLY OPEN FOR READING/WRITING)
C
C REMARKS:
C    IF AN APPLICATION PROGRAM DESIRES TO KNOW THE NUMBER OF SUBSETS IN
C    A BUFR MESSAGES JUST OPENED, IT MUST USE THE FUNCTION NMSUB RATHER
C    THAN THIS SUBROUTINE BECAUSE KSUB ONLY INCREMENTS BY ONE FOR EACH
C    CALL TO READSB (I.E., KSUB = 0 IMMEDIATELY AFTER READMG IS
C    CALLED).
C
C    THIS ROUTINE CALLS:        BORT     STATUS
C    THIS ROUTINE IS CALLED BY: UFBPOS
C                               Also called by application programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      USE MODA_MSGCWD

      INCLUDE 'bufrlib.prm'

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

C  CHECK THE FILE STATUS - RETURN THE MESSAGE AND SUBSET COUNTERS
C  --------------------------------------------------------------

      CALL STATUS(LUNIT,LUN,IL,IM)
      IF(IL.EQ.0) GOTO 900
      KMSG = NMSG(LUN)
      KSUB = NSUB(LUN)

C  EXITS
C  -----

      RETURN
900   CALL BORT('BUFRLIB: STATUS - BUFR FILE IS CLOSED, IT MUST BE '//
     . 'OPEN FOR EITHER INPUT OR OUTPUT')
      END
