      SUBROUTINE PKB(NVAL,NBITS,IBAY,IBIT)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    PKB
C   PRGMMR: WOOLLEN          ORG: NP20       DATE: 1994-01-06
C
C ABSTRACT: THIS SUBROUTINE PACKS AN INTEGER VALUE (NVAL) INTO NBITS
C   BITS OF AN INTEGER ARRAY (IBAY), STARTING WITH BIT (IBIT+1).  ON
C   OUTPUT, IBIT IS UPDATED TO POINT TO THE LAST BIT THAT WAS PACKED.
C
C   NOTE THAT THIS SUBROUTINE WILL NOT WORK PROPERLY IF NBITS IS
C   GREATER THAN NBITW (I.E. THE NUMBER OF BITS IN A MACHINE WORD);
C   IN SUCH CASES SUBROUTINE PKX SHOULD BE CALLED INSTEAD TO ENSURE
C   THAT ALL BITS PRIOR TO THE LAST MACHINE WORD ARE PROPERLY
C   ZERO'ED OUT.
C
C PROGRAM HISTORY LOG:
C 1994-01-06  J. WOOLLEN -- ORIGINAL AUTHOR
C 2003-11-04  J. ATOR    -- ADDED DOCUMENTATION
C 2003-11-04  J. WOOLLEN -- BIG-ENDIAN/LITTLE-ENDIAN INDEPENDENT (WAS
C                           IN DECODER VERSION)
C 2003-11-04  S. BENDER  -- ADDED REMARKS/BUFRLIB ROUTINE
C                           INTERDEPENDENCIES
C 2003-11-04  D. KEYSER  -- UNIFIED/PORTABLE FOR WRF; ADDED HISTORY
C                           DOCUMENTATION
C 2014-12-03  J. ATOR    -- CALL BORT IF NBITS > NBITW
C
C USAGE:    CALL PKB (NVAL, NBITS, IBAY, IBIT)
C   INPUT ARGUMENT LIST:
C     NVAL     - INTEGER: INTEGER TO BE PACKED
C     NBITS    - INTEGER: NUMBER OF BITS OF IBAY WITHIN WHICH TO PACK
C                NVAL
C     IBAY     - INTEGER: *-WORD PACKED BINARY ARRAY NOT YET CONTAINING
C                PACKED NVAL
C     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING BIT AFTER
C                WHICH TO START PACKING
C
C   OUTPUT ARGUMENT LIST:
C     IBAY     - INTEGER: *-WORD PACKED BINARY ARRAY NOW CONTAINING
C                PACKED NVAL
C     IBIT     - INTEGER: BIT POINTER WITHIN IBAY INDICATING LAST BIT
C                THAT WAS PACKED
C
C REMARKS:
C    THIS SUBROUTINE IS THE INVERSE OF BUFR ARCHIVE LIBRARY ROUTINE
C    UPB.
C
C    THIS ROUTINE CALLS:        BORT     IREV
C    THIS ROUTINE IS CALLED BY: ATRCPT   CMSGINI  CNVED4   CPYUPD
C                               DXMINI   MSGINI   MSGUPD   MSGWRT
C                               MVB      PAD      PADMSG   PKBS1
C                               PKX      STNDRD   WRCMPS   WRDXTB
C                               WRTREE
C                               Normally not called by any application
C                               programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$

      COMMON /HRDWRD/ NBYTW,NBITW,IORD(8)

      DIMENSION IBAY(*)

      CHARACTER*156 BORT_STR

C----------------------------------------------------------------------
C----------------------------------------------------------------------

      IF(NBITS.GT.NBITW) GOTO 900

      NWD  = IBIT/NBITW + 1
      NBT  = MOD(IBIT,NBITW)
      IVAL = NVAL
      IF(ISHFT(IVAL,-NBITS).GT.0) IVAL = -1
      INT = ISHFT(IVAL,NBITW-NBITS)
      INT = ISHFT(INT,-NBT)
      MSK = ISHFT(  -1,NBITW-NBITS)
      MSK = ISHFT(MSK,-NBT)
      IBAY(NWD) = IREV(IOR(IAND(IREV(IBAY(NWD)),NOT(MSK)),INT))
      IF(NBT+NBITS.GT.NBITW) THEN

C        There are less than NBITS bits remaining within the current
C        word (i.e. array member) of IBAY, so store as many bits as
C        will fit within the current word and then store the remaining
C        bits within the next word.

         INT = ISHFT(IVAL,2*NBITW-(NBT+NBITS))
         MSK = ISHFT(  -1,2*NBITW-(NBT+NBITS))
         IBAY(NWD+1) = IREV(IOR(IAND(IREV(IBAY(NWD+1)),NOT(MSK)),INT))
      ENDIF

      IBIT = IBIT + NBITS

      RETURN
900   WRITE(BORT_STR,'("BUFRLIB: PKB - NUMBER OF BITS BEING PACKED '//
     . ', NBITS (",I4,"), IS > THE INTEGER WORD LENGTH ON THIS '//
     . 'MACHINE, NBITW (",I3,"); USE SUBROUTINE PKX INSTEAD")')
     . NBITS,NBITW
      CALL BORT(BORT_STR)
      END
