	FUNCTION NMWRD(MBAY)

C$$$  SUBPROGRAM DOCUMENTATION BLOCK
C
C SUBPROGRAM:    NMWRD
C   PRGMMR: ATOR             ORG: NP12       DATE: 2005-11-29
C
C ABSTRACT: GIVEN AN INTEGER ARRAY CONTAINING SECTION ZERO FROM A
C   BUFR MESSAGE, THIS FUNCTION DETERMINES A COUNT OF MACHINE WORDS
C   (I.E. INTEGER ARRAY MEMBERS) THAT WILL HOLD THE ENTIRE MESSAGE.
C   NOTE THAT THIS COUNT MAY BE GREATER THAN THE MINIMUM NUMBER
C   OF WORDS REQUIRED TO HOLD THE MESSAGE.
C
C PROGRAM HISTORY LOG:
C 2005-11-29  J. ATOR    -- ORIGINAL AUTHOR
C
C USAGE:    NMWRD (MBAY)
C   INPUT ARGUMENT LIST:
C     MBAY     - INTEGER: *-WORD ARRAY CONTAINING SECTION ZERO
C                FROM A BUFR MESSAGE
C
C   OUTPUT ARGUMENT LIST:
C     NMWRD    - INTEGER: BUFR MESSAGE LENGTH (IN MACHINE WORDS)
C
C REMARKS:
C    THIS ROUTINE CALLS:        IUPBS01
C    THIS ROUTINE IS CALLED BY: CNVED4   CPDXMM   LMSG     MSGWRT
C                               PADMSG   UFBMEM   UFBMEX
C                               Also called by application programs.
C
C ATTRIBUTES:
C   LANGUAGE: FORTRAN 77
C   MACHINE:  PORTABLE TO ALL PLATFORMS
C
C$$$
	
	COMMON /HRDWRD/ NBYTW,NBITW,IORD(8)

	DIMENSION MBAY(*)

C-----------------------------------------------------------------------
C-----------------------------------------------------------------------

	LENM = IUPBS01(MBAY,'LENM')
	IF(LENM.EQ.0) THEN
	    NMWRD = 0
	ELSE
	    NMWRD = ((LENM/8)+1)*(8/NBYTW)
	ENDIF

	RETURN
	END
