!******************************************************************************
  program sfc_regrid
!******************************************************************************
!
! sfc_regrid
!
! description: reads/regrids fv surface data to generate a
!              surface file for the SSI
!
! input :
!   surface data file generated by the SSI
!
! output :
!   surface data file used by the SSI
!
! history:
!    6/2003  C. Cruz created
!
!-------------------------------------------------------------------------

   use m_dyn 
   use m_ioutil, only : luavail, opnieee, clsieee

   implicit none

! part I

   character (len = 132) :: myname   ! routine name
   real undef

   integer iid, & ! file id for input surface file
           oid, & ! file id for output surface file
           rc, err
   integer i,j,k,l

! part II

   real, allocatable, dimension(:)   :: dlam,dphi
   real, allocatable, dimension(:,:) :: lons,lats
   integer :: idate(4), im,jm,glon,glat,glat2
   real :: hourg
   real*4, allocatable, dimension (:,:) :: fld4, ifld4
   real(8), allocatable, dimension (:,:) :: fld8, ifld8
   integer, allocatable, dimension (:,:) :: ifld, iifld
   real(4) fhour4

! start

   myname='sfc_regrid'

   write (*,*)
   write (*,*) "###############################################"
   write (*,*) "      SSI SURFACE File Regrid Application "
   write (*,*) "###############################################"
   write(*,'(/)')

   call init (im,jm,glon,glat)

   allocate(fld4(im,jm))
   allocate(fld8(im,jm))
   allocate (dlam(im))
   allocate (dphi(jm))
   glat2 = glat
   allocate(ifld8(glon,glat2))
   allocate(ifld4(glon,glat2))
   allocate (lons(glon,glat2))
   allocate (lats(glon,glat2))

!  call comput_gaus(im,jm,glon,glat2,dphi,dlam,lons,lats,.false.) ! original code
   call comput_gaus(im,jm,glon,glat2,dphi,dlam,lons,lats,.true.)  ! what I think should be (RT)

   open(unit=30,file='sfcanl',form='unformatted')
   open(unit=32,file='sfcanl.new',form='unformatted')

   read(30)
   read(30)fhour4,idate
   write(*,*) 'read : ',fhour4, idate
   !write(32)
   !write(32) fhour4, idate

   read(30)fld4 
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !tskin
  
   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !soil moisture
  
   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !snow cover
  
   read(30)fld4 
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !tground
 
   read(30)fld4 
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !?

   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !?

   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !?
 
   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !?
 
   read(30)fld4 
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !?
 
   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !?
 
   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !sli mask
 
   read(30)fld4 
   write(34) fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !veg frac
 
   read(30)fld4
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !?
 
   read(30)fld4 
   fld8=fld4
   if(im/=glon) call interp_h (fld8,im,jm,1,dlam,dphi,0.0,90.0,0.0,ifld8, &
   glon*glat2,lons,lats,1,3,.true.,undef)
   ifld4=ifld8 ; write(32) ifld4 !10mwfrac
 
   read(30)fld4 
   write(34) fld4
   ifld4 = 1.
   write(32) ifld4 ! veg type
 
   read(30)fld4 
   write(34) fld4
   ifld4 = 1.
   write(32) fld4 !soil type

   close(30); close(32)

   contains

!-------------------------------------------------------------------------
!       NASA/GSFC, Data Assimilation Office, Code 910.3, GEOS/DAS      !
!-----------------------------------------------------------------------
!BOP
! !IROUTINE: init ---
!
! !DESCRIPTION: parses command line.
!
! !INTERFACE:
!
   subroutine init ( im, jm, glon, glat )

   implicit NONE

   integer, intent(out) :: im,jm,glon,glat

!
! !REVISION HISTORY:
!
!! 2003.05.30  C. Cruz:   Initial Code

!
!EOP

!BOC

   character*4, parameter :: myname = 'init'
   integer :: n,iargc,nargs
   character*255 :: argv
   character*255, allocatable :: arg(:)

   nargs =  iargc()
   if( nargs.eq.0 ) then
      print *, ' Usage : sfc_regrid im1 jm1 im2 jm2'
      print *, ' SSI surface file is (expected) to be sfcanl'
      stop
   end if
   allocate ( arg(nargs) )

! defaults

   do n=1,nargs
     call getarg(n,arg(n))
   enddo

   do n=1,nargs
     call getarg(n,arg(n))
   enddo
   do n=1,nargs
     if( trim(arg(n)).eq.'-time' ) read(arg(n+1), * ) im
     if( trim(arg(n)).eq.'-time' ) read(arg(n+1), * ) jm
     if( trim(arg(n)).eq.'-time' ) read(arg(n+1), * ) glon
     if( trim(arg(n)).eq.'-time' ) read(arg(n+1), * ) glat
   enddo

   deallocate(arg)
   rc = 0

   end subroutine init

   end program 



