c                                                   02/06/93 - xyz2reg.f
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c.... Compute region index from (x,y,z) coordinates.

      subroutine xyz2reg( nnobs, x, y, z, iregn )

c.......................................................................
c.... Argument declarations.

      integer      nnobs
      real         x(nnobs)
      real         y(nnobs)
      real         z(nnobs)
      integer      iregn(nnobs)

c.......................................................................
c.... Icosahedral grid definition.

      include "maxreg.h"
      include "icosdef.h"

	integer	   ipick
	external   ipick

c.......................................................................
c.... Statement function definitions.

      logical      test1, test2, test3, test4, test5

c  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
c  new logical declaration for CRAY compilation:
      logical      testi
c  xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

      vx(i) = xyzicos(1,i)
      vy(i) = xyzicos(2,i)
      vz(i) = xyzicos(3,i)

      testi(i,xx,yy) = ( (xx*vx(i) + yy*vy(i) ).ge. zzz )

c     test1 --->>  (x,y,z)dot{(v1+v6)cross(v1+v2)} .ge. 0.0
c     test1 --->>  (x,y,z)dot(v4) .ge. 0.0
      test1(xx,yy) = testi(4,xx,yy)

c     test2 --->>  (x,y,z)dot{(v1+v2)cross(v1+v3)} .ge. 0.0
c     test2 --->>  (x,y,z)dot(v5) .ge. 0.0
      test2(xx,yy) = testi(5,xx,yy)

c     test3 --->>  (x,y,z)dot{(v1+v3)cross(v1+v4)} .ge. 0.0
c     test3 --->>  (x,y,z)dot(v6) .ge. 0.0
      test3(xx,yy) = testi(6,xx,yy)

c     test4 --->>  (x,y,z)dot{(v1+v4)cross(v1+v5)} .ge. 0.0
c     test4 --->>  (x,y,z)dot(v2) .ge. 0.0
      test4(xx,yy) = testi(2,xx,yy)

c     test5 --->>  (x,y,z)dot{(v1+v5)cross(v1+v6)} .ge. 0.0
c     test5 --->>  (x,y,z)dot(v3) .ge. 0.0
      test5(xx,yy) = testi(3,xx,yy)

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc


      xold  = 0.0
      yold  = 0.0
      zold  = 0.0
      irold = 0

c.......................................................................
c.... Loop over the set of points on the sphere.

      do 500 n = 1, nnobs

c.......................................................................
c...... Test whether current point (n) is the same as point (n-1). This
c...... saves work when profile data is being processed.

        if( x(n).eq.xold ) then
          if( y(n).eq.yold ) then
            if( z(n).eq.zold ) then
               iregn(n) = irold
               goto 500
            endif
          endif
        endif
        xold  = x(n)
        yold  = y(n)
        zold  = z(n)

        zzz   =  - zold * vz(2)
 
        if( zold.ge.0.0 ) then
c.......................................................................
c........ point is in Northern Hemisphere, i.e. the point is in
c........ {1-20,22-24,26-28,30-32,34-36,38-40,41,45,49,53,57}

          if( test1(xold,yold) ) then
c.......................................................................
c.......... point is in {1,5,6,8-17,19,20,27,30-32,34-36,38,45,49,53}

            if( test2(xold,yold) ) then
c.......................................................................
c............ point is in {1,5,9,10,12-17,19,20,31,34-36,38,49,53}

              if( test3(xold,yold) ) then
c.......................................................................
c.............. point is in {1,5,9,13,14,16,17,19,20,35,38,53}

                if( test4(xold,yold) ) then
c.......................................................................
c................ point is in {1,5,9,13,17,20}

                  if( test5(xold,yold) ) then
c.......................................................................
c................... point is in {1,5,9,13,17}

                     iregn(n) = ipick( xold, yold, zold,
     $                                 1, 5, 9,13,17,  2, 3, 4, 5, 6 )
                  else
c.......................................................................
c................... point is in {20}

                     iregn(n) = 20

                  endif

                else
c.......................................................................
c................ point is in {14,16,19,35,38,53}

                  if( test5(xold,yold) ) then
c.......................................................................
c................... point is in {16}

                     iregn(n) = 16

                  else
c.......................................................................
c................... point is in {14,19,35,38,53}

                     iregn(n) = ipick( xold, yold, zold,
     $                                14,35,53,38,19,  4,10,11, 6, 1 )

                  endif

                endif

              else
c.......................................................................
c.............. point is in {10,12,15,31,34,36,49}

                if( test4(xold,yold) ) then
c.......................................................................
c................. point is in {12}

                   iregn(n) = 12

                else
c.......................................................................
c................ point is in {10,15,31,34,36,49}

                  if( test5(xold,yold) ) then
c.......................................................................
c................... point is in {10,15,31,34,49}

                     iregn(n) = ipick( xold, yold, zold,
     $                                10,31,49,34,15,  3, 9,10, 5, 1 )

                  else
c.......................................................................
c................... point is in {36}

                     iregn(n) = 36

                  endif

                endif

              endif

            else
c.......................................................................
c............ point is in {6,8,11,27,30,32,45}

              if( test3(xold,yold) ) then
c.......................................................................
c............... point is in {8}

                 iregn(n) = 8

              else
c.......................................................................
c.............. point is in {6,11,27,30,32,45}

                if( test4(xold,yold) ) then
c.......................................................................
c................. point is in {6,11,27,30,45}

                   iregn(n) = ipick( xold, yold, zold,
     $                               6,27,45,30,11,  2, 8, 9, 4, 1 )

                else
c.......................................................................
c................. point is in {32}

                   iregn(n) = 32

                endif

              endif

            endif

          else
c.......................................................................
c.......... point is in {2-4,7,18,22-24,26,28,39,40,41,57}

            if( test2(xold,yold) ) then
c.......................................................................
c............. point is in {3,4,18,22,39,40,57}

               if( test4(xold,yold) ) then
c.......................................................................
c................ point is in {3,4,18,22,39,57}

                  if( test5(xold,yold) ) then
c.......................................................................
c................... point is in {4}

                     iregn(n) = 4

                  else
c.......................................................................
c................... point is in {3,18,22,39,57}

                     iregn(n) = ipick( xold, yold, zold,
     $                                 3,18,39,57,22,  1, 5,11, 7, 2 )

                  endif

               else
c.......................................................................
c................ point is in {40}

                  iregn(n) = 40

               endif

            else
c.......................................................................
c............ point is in {2,7,23,24,26,28,41}

              if( test3(xold,yold) ) then
c.......................................................................
c.............. point is in {2,7,23,24,26,41}

                if( test5(xold,yold) ) then
c.......................................................................
c................. point is in {2,7,23,26,41}

                   iregn(n) = ipick( xold, yold, zold,
     $                               2,23,41,26, 7,  6, 7, 8, 3, 1 )

                else
c.......................................................................
c................. point is in {24}

                   iregn(n) = 24

                endif

              else
c.......................................................................
c............... point is in {28}

                 iregn(n) = 28

              endif

            endif

          endif

        else
c.......................................................................
c...... point is in Southern Hemisphere, i.e.
c...... point is in {21,42-44,25,46-48,29,50-52,33,54-56,37,58-60,61-80}
c...... antipode in {1-20,22-24,26-28,30-32,34-36,38-40,41,45,49,53,57}

          zzz = - zzz

          if( test1(-xold,-yold) ) then
c.......................................................................
c.......... antipode is in {1,5,6,8-17,19,20,27,30-32,34-36,38,45,49,53}

            if( test2(-xold,-yold) ) then
c.......................................................................
c............ antipode is in {1,5,9,10,12-17,19,20,31,34-36,38,49,53}

              if( test3(-xold,-yold) ) then
c.......................................................................
c.............. antipode is in {1,5,9,13,14,16,17,19,20,35,38,53}

                if( test4(-xold,-yold) ) then
c.......................................................................
c................ antipode is in {1,5,9,13,17,20}

                  if( test5(-xold,-yold) ) then
c.......................................................................
c................... antipode is in {1,5,9,13,17}
c................... point is in {61,77,73,69,65}

                     iregn(n) = ipick( xold, yold, zold,
     $                                61,77,73,69,65,  7,11,10, 9, 8 )

                  else
c.......................................................................
c................... antipode is in {20}

                     iregn(n) = 68

                  endif

                else
c.......................................................................
c................ antipode is in {14,16,19,35,38,53}

                  if( test5(-xold,-yold) ) then
c.......................................................................
c................... antipode is in {16}

                     iregn(n) = 64

                  else
c.......................................................................
c................... antipode is in {14,19,35,38,53}
c................... point is in {25,42,63,66,47}

                     iregn(n) = ipick( xold, yold, zold,
     $                                25,42,63,66,47,  2, 7,12, 9, 3 )

                  endif

                endif

              else
c.......................................................................
c.............. antipode is in {10,12,15,31,34,36,49}

                if( test4(-xold,-yold) ) then
c.......................................................................
c................. antipode is in {12}

                   iregn(n) = 80

                else
c.......................................................................
c................ antipode is in {10,15,31,34,36,49}

                  if( test5(-xold,-yold) ) then
c.......................................................................
c................... antipode is in {10,15,31,34,49}
c................... point is in {21,58,79,62,43}

                     iregn(n) = ipick( xold, yold, zold,
     $                                21,58,79,62,43,  6,11,12, 8, 2 )

                  else
c.......................................................................
c................... antipode is in {36}

                     iregn(n) = 44

                  endif

                endif

              endif

            else
c.......................................................................
c............ antipode is in {6,8,11,27,30,32,45}

              if( test3(-xold,-yold) ) then
c.......................................................................
c............... antipode is in {8}

                 iregn(n) = 76

              else
c.......................................................................
c.............. antipode is in {6,11,27,30,32,45}

                if( test4(-xold,-yold) ) then
c.......................................................................
c................. antipode is in {6,11,27,30,45}
c................. point is in {37,54,75,78,59}

                   iregn(n) = ipick( xold, yold, zold,
     $                              37,54,75,78,59,  5,10,12, 7, 6 )

                else
c.......................................................................
c................. antipode is in {32}

                   iregn(n) = 60

                endif

              endif

            endif

          else
c.......................................................................
c.......... antipode is in {2-4,7,18,22-24,26,28,39,40,41,57}

            if( test2(-xold,-yold) ) then
c.......................................................................
c............. antipode is in {3,4,18,22,39,40,57}

               if( test4(-xold,-yold) ) then
c.......................................................................
c................ antipode is in {3,4,18,22,39,57)

                  if( test5(-xold,-yold) ) then
c.......................................................................
c................... antipode is in {4}

                     iregn(n) = 72

                  else
c.......................................................................
c................... antipode is in {3,18,22,39,57}
c................... point is in {29,46,67,70,51}

                     iregn(n) = ipick( xold, yold, zold,
     $                                29,46,67,70,51,  3, 8,12,10, 4 )

                  endif

               else
c.......................................................................
c................ antipode is in {40}

                  iregn(n) = 48

               endif

            else
c.......................................................................
c............ antipode is in {2,7,23,24,26,28,41}

              if( test3(-xold,-yold) ) then
c.......................................................................
c.............. antipode is in {2,7,23,24,26,41}

                if( test5(-xold,-yold) ) then
c.......................................................................
c................. antipode is in {2,7,23,26,41}
c................. point is in {33,50,71,74,55}

                   iregn(n) = ipick( xold, yold, zold,
     $                              33,50,71,74,55,  4, 9,12,11, 5 )

                else
c.......................................................................
c................. antipode is in {24}

                   iregn(n) = 52

                endif

              else
c.......................................................................
c............... antipode is in {28}

                 iregn(n) = 56

              endif

            endif

          endif

        endif

        irold = iregn(n)

  500 continue

      return

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      end
