
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c.... Set parameters for regular icosahedron used in region definitions.

      subroutine seticos

c.......................................................................
c.... Tables to hold region definition parameters.

      include     "maxreg.h"
      include     "icosdef.h"

c.......................................................................
c.... Vertex indices for the 20 faces of the icosahedron.

      DATA icostri /
     1        1,  2,  6,     1,  3,  2,     1,  4,  3,     1,  5,  4,
     2        1,  6,  5,     7,  6,  2,     8,  2,  3,     9,  3,  4,
     3       10,  4,  5,    11,  5,  6,     2,  8,  7,     3,  9,  8,
     4        4, 10,  9,     5, 11, 10,     6,  7, 11,    12,  7,  8,
     5       12,  8,  9,    12,  9, 10,    12, 10, 11,    12, 11,  7 /

c.......................................................................
c.... Permutation for a rotation about vertex 1.

      DATA it1 /
     1       5, 6, 7, 8, 9,10,11,12,13,14,15,16,17,18,19,20, 1, 2, 3, 4,
     2      25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,21,22,23,24,
     3      45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,41,42,43,44,
     4      65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,61,62,63,64/

c.......................................................................
c.... Permutation for a rotation about vertex 2.

      DATA it2 /
     1      22,23,21,24, 3, 1, 2, 4,18,19,17,20,39,37,38,40,57,58,59,60,
     2      42,43,41,44, 6, 7, 5, 8,15,13,14,16,55,53,54,56,77,78,79,80,
     3      26,27,25,28, 9,10,11,12,35,33,34,36,75,73,74,76,62,63,61,64,
     4      46,47,45,48,29,30,31,32,51,49,50,52,70,71,69,72,67,65,66,68/

c.......................................................................
c.... Permutation for a rotation about vertex 7.

      DATA it7 /
     1      27,25,26,28,45,46,47,48,30,31,29,32,11, 9,10,12, 6, 7, 5, 8,
     2      43,41,42,44,65,66,67,68,50,51,49,52,14,15,13,16, 3, 1, 2, 4,
     3      63,61,62,64,70,71,69,72,34,35,33,36,17,18,19,20,23,21,22,24,
     4      78,79,77,80,75,73,74,76,54,55,53,56,37,38,39,40,59,57,58,60/

c.......................................................................
c.... Permutation for a rotation about face 4.

      DATA if4 /
     1       3, 1, 2, 4,18,19,17,20,39,37,38,40,57,58,59,60,22,23,21,24,
     2       6, 7, 5, 8,15,13,14,16,55,53,54,56,77,78,79,80,42,43,41,44,
     3       9,10,11,12,35,33,34,36,75,73,74,76,62,63,61,64,26,27,25,28,
     4      29,30,31,32,51,49,50,52,70,71,69,72,67,65,66,68,46,47,45,48/

c.......................................................................
c.... Central angle (degrees) separating region 1 from all the others.

      DATA sep1j /
     $        0.00,  0.01,  0.01,  0.00,  0.00, 30.00,  0.01,  0.01,
     $        0.01, 31.72, 30.00, 26.57,  0.01, 30.00, 31.72, 26.57,
     $        0.00,  0.01, 30.00,  0.01, 60.00, 30.00, 30.00, 31.72,
     $       60.00, 30.00, 36.00, 36.00, 90.00, 58.28, 58.28, 58.28,
     $       90.00, 58.28, 58.28, 58.28, 60.00, 36.00, 30.00, 36.00,
     $       31.72, 60.00, 60.00, 58.28, 58.28, 90.00, 72.00, 72.00,
     $       63.43, 90.00, 90.00, 90.00, 58.28, 72.00, 90.00, 72.00,
     $       31.72, 60.00, 60.00, 58.28,120.00, 90.00, 90.00, 90.00,
     $      120.00, 90.00,108.00,108.00,144.00,116.57,116.57,121.72,
     $      120.00,108.00, 90.00,108.00,120.00, 90.00, 90.00, 90.00 /

c.......................................................................
c.... Central angle (degrees) separating region 4 from all the others.

      DATA sep4j /
     $        0.00,  0.00,  0.00,  0.00,  0.01, 31.72,  0.01,  0.01,
     $       26.57, 58.28, 36.00, 36.00, 26.57, 36.00, 58.28, 36.00,
     $        0.01,  0.01, 31.72,  0.01, 31.72,  0.01,  0.01,  0.01,
     $       58.28, 26.57, 36.00, 36.00, 90.00, 58.28, 72.00, 72.00,
     $       90.00, 72.00, 58.28, 72.00, 58.28, 36.00, 26.57, 36.00,
     $       26.57, 58.28, 36.00, 36.00, 58.28, 90.00, 72.00, 72.00,
     $       90.00,108.00,108.00,108.00, 58.28, 72.00, 90.00, 72.00,
     $       26.57, 36.00, 58.28, 36.00, 90.00, 58.28, 72.00, 72.00,
     $      108.00, 90.00,108.00,108.00,121.72,121.72,121.72,144.00,
     $      108.00,108.00, 90.00,108.00, 90.00, 72.00, 58.28, 72.00 /

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

c.......................................................................
c.... Compute the (x,y,z) coordinates of the 20 icosahedral vertices.

      sinzz = sin( atan(0.5) )
      coszz = cos( atan(0.5) )
      pi    = 4.0 * atan(1.0)

      xyzicos(1, 1) =  0.0
      xyzicos(2, 1) =  0.0
      xyzicos(3, 1) =  1.0
      xyzicos(1,12) =  0.0
      xyzicos(2,12) =  0.0
      xyzicos(3,12) = -1.0

      ang           =  0.0
      dang          =  pi / 5.0

      do 100 i = 1, 5
         xyzicos(1,i+6) =  coszz * cos(ang)
         xyzicos(2,i+6) =  coszz * sin(ang)
         xyzicos(3,i+6) = -sinzz
         ang = ang + dang
         xyzicos(1,i+1) =  coszz * cos(ang)
         xyzicos(2,i+1) =  coszz * sin(ang)
         xyzicos(3,i+1) =  sinzz
         ang = ang + dang
  100 continue

      return

cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
      end
