!
! This same files resides in 2 different standard places, with different names:
!
!  shared/hermes/m_set_eta.F90
!  fvgcm/misc/set_eta.F90
!
! When compiled under Hermes it becomes a module; otherwise it is a regular
! f77 routine.
! 
! !HISTORY:
!   18May2005  Todling  added (un)set_sigma routines to allow sigma levs setup
!   13Jun2005  Todling  defined new 72-eta levs (gAdas-1_5beta3p2 and later)
!   17Apr2006  Elena N. 72-lev bug fix for ks definition
!   ?????2008  Ravi     Added 91 levs for ECMWF Nature run
!   13Oct2008  Todling  Ravi's addition using wrong version of this file (fixed)
!   24Nov2008  Takacs/RT Fix ks for ECMWF 91 level-case
!   31Jul2009  Ravi      Updated NCEP 64 Layer ak and bk (source Dr.da silva Arlindo)
!   20Oct2009  Todling   Multiplied NCEP 64 ak levels by 10 (should be in Pa)
!   07Jul2012  Todling   Create a 72-level set from NCEP's 64-level set
!   04Apr2018  Todling   Overload for r4/r8 support
!
#ifdef HERMES

      module m_set_eta
      use, intrinsic :: iso_fortran_env, only: REAL32, REAL64
      PRIVATE
      PUBLIC set_eta
      PUBLIC get_ref_plevs
      PUBLIC set_sigma
      PUBLIC unset_sigma
      PUBLIC set_ncep72
      PUBLIC unset_ncep72

      logical :: SIGMA_LEVS  = .false.   ! controls whether levs are sigma or eta
      logical :: NCEP72_4GMAO= .false.   ! controls whether levs are 72, but largely as NCEP's 64
      
      interface set_eta
         module procedure set_eta_r8_    ! double precision (original) version
         module procedure set_eta_r4_    ! single precision support
      end interface
      interface get_ref_plevs
         module procedure get_ref_plevs_r8_   ! double precision (original) version
         module procedure get_ref_plevs_r4_   ! single precision support
      end interface
CONTAINS

      subroutine set_eta_r8_ (km, ks, ptop, pint, ak, bk)
      use m_realkinds, only : r8 => kind_r8  ! from mpeu
      use m_realkinds, only : r4 => kind_r4  ! from mpeu

#else

      subroutine set_eta_r8_(km, ks, ptop, pint, ak, bk)
      use shr_kind_mod, only : r8 => shr_kind_r8 ! from gvgcm
      use shr_kind_mod, only : r4 => shr_kind_r4 ! from gvgcm

#endif

      implicit none

! Choices for vertical resolutions are as follows:
! NCAR: 18, 26, and 30
! NASA DAO: smoothed version of CCM4's 30-level, 32, 48, 55
! Revised 32-layer setup with top at 0.4 mb for high horizontal
! resolution runs. (sjl: 04/01/2002)
! Revised 55-level eta with pint at 176.93 mb  SJL: 2000-03-20
!
! NCEP 64-level sigma and hybrid eta

! NCAR specific
      real(r8) a18(19),b18(19)              ! CCM3
      real(r8) a26(27),b26(27)              ! CCM4
      real(r8) a30(31),b30(31)              ! CCM4

! NASA only
      real(r8) a01(2),b01(2)                ! to allow single-level utils to rely on sim code
      real(r8) a30m(31),b30m(31)            ! smoothed CCM4 30-L
      real(r8) a32(33),b32(33)
      real(r8) a44(45),b44(45)
      real(r8) a48(49),b48(49)
      real(r8) a55(56),b55(56)
      real(r8) a72(73),b72(73)   ! geos-5
      real(r8) a91_EC(92),b91_EC(92)   ! Nature EC
      real(r8) a96(97),b96(97)   ! not sure
      real(r8) a72_ncep(73),b72_ncep(73)  ! mainly NCEP's 64 with the GMAO-72 top levels
      real(r8) a144(145), b144(145)
      real(r8) a132(133), b132(133)

! ECMWF 137L Based levels
      real(r8) a71(72), b71(72)
      real(r8) a91(92), b91(92)
      real(r8) a137(138), b137(138)
      real(r8) a181(182), b181(182)
      
! NCEP
      real(r8) a64(65),b64(65), a64_sig(65),b64_sig(65)
      real(r8) a127(128),b127(128)

      integer ks, k, km
      real(r8) ak(km+1),bk(km+1)
      real(r8) ptop                      ! model top (Pa)
      real(r8) pint                      ! transition to p (Pa)

! *** NCAR settings ***

      data a18 /291.70,  792.92,  2155.39,  4918.34,  8314.25,      &
               7993.08, 7577.38,  7057.52,  6429.63,  5698.38,      &
               4879.13, 3998.95,  3096.31,  2219.02,  1420.39,      &
               754.13,  268.38,   0.0000,   0.0000 /

      data b18 /0.0000,    0.0000,    0.0000,   0.0000,   0.0000,   &
                0.0380541, 0.0873088, 0.1489307, 0.2232996,         &
                0.3099406, 0.4070096, 0.5112977, 0.6182465,         &
                0.7221927, 0.8168173, 0.8957590, 0.9533137,         &
                0.9851122, 1.0  /
     
      data a26 /219.4067,  489.5209,   988.2418,   1805.201,        &
                2983.724,  4462.334,   6160.587,   7851.243,        &
                7731.271,  7590.131,   7424.086,   7228.744,        &
                6998.933,  6728.574,   6410.509,   6036.322,        &
                5596.111,  5078.225,   4468.96,    3752.191,        &
                2908.949,  2084.739,   1334.443,   708.499,         &
                252.136,   0.,         0. /

      data b26 /0.,         0.,         0.,         0.,             &
                0.,         0.,         0.,         0.,             &
                0.01505309, 0.03276228, 0.05359622, 0.07810627,     &
                0.1069411,  0.14086370, 0.180772,   0.227722,       &
                0.2829562,  0.3479364,  0.4243822,  0.5143168,      &
                0.6201202,  0.7235355,  0.8176768,  0.8962153,      &
                0.9534761,  0.9851122,  1.        /

      data a30 /225.523952394724, 503.169186413288, 1015.79474285245, &
               1855.53170740604, 3066.91229343414,  4586.74766123295, &
               6332.34828710556, 8070.14182209969,  9494.10423636436, &
              11169.321089983,  13140.1270627975,  15458.6806893349,  &
              18186.3352656364, 17459.799349308,   16605.0657629967,  &
              15599.5160341263, 14416.541159153,   13024.8308181763,  &
              11387.5567913055,  9461.38575673103,  7534.44507718086, &
               5765.89405536652, 4273.46378564835,  3164.26791250706, &
               2522.12174236774, 1919.67375576496,  1361.80268600583, &
                853.108894079924, 397.881818935275,    0.,            &
                  0.  /

      data b30 /0.,                 0.,                                  &
                0.,                 0.,                0.,               &
                0.,                 0.,                0.,               &
                0.,                 0.,                0.,               &
                0.,                 0.,                0.03935482725501, &
                0.085653759539127,  0.140122056007385, 0.20420117676258, &
                0.279586911201477,  0.368274360895157, 0.47261056303978, &
                0.576988518238068,  0.672786951065063, 0.75362843275070, &
                0.813710987567902,  0.848494648933411, 0.88112789392471, &
                0.911346435546875,  0.938901245594025, 0.96355980634689, &
                0.985112190246582,  1.   /

! *** NASA DAO settings ***

! Smoothed CCM4's 30-Level setup
      data a30m / 300.00000,     725.00000,    1500.00000,       &
             2600.00000,    3800.00000,    5050.00000,           &
             6350.00000,    7750.00000,    9300.00000,           &
            11100.00000,   13140.00000,   15458.00000,           &
            18186.33580,   20676.23761,   22275.23783,           &
            23025.65071,   22947.33569,   22038.21991,           &
            20274.24578,   17684.31619,   14540.98138,           &
            11389.69990,    8795.97971,    6962.67963,           &
             5554.86684,    4376.83633,    3305.84967,           &     
             2322.63910,    1437.78398,     660.76994,           &
                0.00000 /

      data b30m / 0.00000,       0.00000,       0.00000,         &
                  0.00000,       0.00000,       0.00000,         &
                  0.00000,       0.00000,       0.00000,         &
                  0.00000,       0.00000,       0.00000,         &
                  0.00000,       0.00719,       0.02895,         &
                  0.06586,       0.11889,       0.18945,         &
                  0.27941,       0.38816,       0.50692,         &
                  0.61910,       0.70840,       0.77037,         &
                  0.81745,       0.85656,       0.89191,         &
                  0.92421,       0.95316,       0.97850,         &
                  1.00000 /

      data a32/40.00000,     106.00000,     224.00000,     &
              411.00000,     685.00000,    1065.00000,     &
             1565.00000,    2179.80000,    2900.00000,     &
             3680.00000,    4550.00000,    5515.00000,     &
             6607.00000,    7844.00000,    9236.56616,     &
            10866.34280,   12783.70000,   15039.29900,     &
            17693.00000,   20815.20900,   24487.49020,     &
            28808.28710,   32368.63870,   33739.96480,     &
            32958.54300,   30003.29880,   24930.12700,     &
            18568.89060,   12249.20510,    6636.21191,     &
             2391.51416,       0.00000,       0.00000 /

      data b32/ 0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.00000,       0.00000,     &
                0.00000,       0.01523,       0.06132,     &
                0.13948,       0.25181,       0.39770,     &
                0.55869,       0.70853,       0.83693,     &
                0.93208,       0.98511,       1.00000 /

      data a48/40.00000,     100.00000,     200.00000,     &
              350.00000,     550.00000,     800.00000,     &
             1085.00000,    1390.00000,    1720.00000,     &
             2080.00000,    2470.00000,    2895.00000,     &
             3365.00000,    3890.00000,    4475.00000,     &
             5120.00000,    5830.00000,    6608.00000,     &
             7461.00000,    8395.00000,    9424.46289,     &
            10574.46900,   11864.80330,   13312.58850,     &
            14937.03770,   16759.70760,   18804.78670,     &
            21099.41250,   23674.03720,   26562.82650,     &
            29804.11680,   32627.31601,   34245.89759,     &
            34722.29104,   34155.20062,   32636.50533,     &
            30241.08406,   27101.45052,   23362.20912,     &
            19317.04955,   15446.17194,   12197.45091,     &
             9496.39912,    7205.66920,    5144.64339,     &
             3240.79521,    1518.62245,       0.00000,     &
                0.00000  /

      data b48/0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00813,       0.03224,      &
               0.07128,       0.12445,       0.19063,      &
               0.26929,       0.35799,       0.45438,      &
               0.55263,       0.64304,       0.71703,      &
               0.77754,       0.82827,       0.87352,      &
               0.91502,       0.95235,       0.98511,      &
               1.00000      /

      data a55/ 1.00000,       2.00000,       3.27000,                   &
              4.75850,       6.60000,       8.93450,                     &
             11.97030,      15.94950,      21.13490,                     &
             27.85260,      36.50410,      47.58060,                     &
             61.67790,      79.51340,     101.94420,                     &
            130.05080,     165.07920,     208.49720,                     &
            262.02120,     327.64330,     407.65670,                     &
            504.68050,     621.68000,     761.98390,                     &
            929.29430,    1127.68880,    1364.33920,                     &
           1645.70720,    1979.15540,    2373.03610,                     &
           2836.78160,    3380.99550,    4017.54170,                     &
           4764.39320,    5638.79380,    6660.33770,                     &
           7851.22980,    9236.56610,   10866.34270,                     &
          12783.70000,   15039.30000,   17693.00000,                     &
          20119.20876,   21686.49129,   22436.28749,                     &
          22388.46844,   21541.75227,   19873.78342,                     &
          17340.31831,   13874.44006,   10167.16551,                     &
           6609.84274,    3546.59643,    1270.49390,                     &
              0.00000,       0.00000   /

      data b55 /0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           & 
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00000,       0.00000,       0.00000,           &
                0.00696,       0.02801,       0.06372,           &
                0.11503,       0.18330,       0.27033,           &
                0.37844,       0.51046,       0.64271,           &
                0.76492,       0.86783,       0.94329,           &
                0.98511,       1.00000  /


! NCEP's 64 sigma layers

      data a64_sig/1.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000,       0.00000,      &
               0.00000,       0.00000 /
                                                                                                                                                             
      data b64_sig/0.00000       , 6.419999991E-4, 1.378000015E-3, &
               2.219999908E-3, 3.183000023E-3, 4.284000024E-3, &
               5.54399984E-3 , 6.984999869E-3, 8.631000295E-3, &
               1.051099971E-2, 1.265799999E-2, 1.510700025E-2, &
               1.790099964E-2, 2.108399943E-2, 2.470799908E-2, &
               2.882999927E-2, 3.351499885E-2, 3.883099928E-2, &
               4.485499859E-2, 5.167099833E-2, 5.936999992E-2, &
               6.804899871E-2, 7.780800015E-2, 8.875600249E-2, &
               0.101002      , 0.114655003   , 0.129822999   , &
               0.146607995   , 0.165098995   , 0.185371995   , &
               0.207481995   , 0.231454      , 0.257283986   , &
               0.284927994   , 0.314300001   , 0.345268995   , &
               0.377658993   , 0.411249012   , 0.445778012   , &
               0.480955005   , 0.516462982   , 0.551973999   , &
               0.587159991   , 0.621704996   , 0.655315995   , &
               0.687731028   , 0.718729019   , 0.748133004   , &
               0.775811017   , 0.801676989   , 0.825685024   , &
               0.847829998   , 0.868139029   , 0.88666302    , &
               0.903479993   , 0.918677986   , 0.932359993   , &
               0.94463098    , 0.955603004   , 0.96538502    , &
               0.974083006   , 0.98180002    , 0.988632023   , &
               0.994670987   , 1.0            /
                                                                                                                                                             

!      data a64/1.00000,       3.90000,       8.70000,      &
!              15.42000,      24.00000,      34.50000,      &
!              47.00000,      61.50000,      78.60000,      &
!              99.13500,     124.12789,     154.63770,      &
!             191.69700,     236.49300,     290.38000,      &
!             354.91000,     431.82303,     523.09300,      &
!             630.92800,     757.79000,     906.45000,      &
!            1079.85000,    1281.00000,    1515.00000,      &
!            1788.00000,    2105.00000,    2470.00000,      &
!            2889.00000,    3362.00000,    3890.00000,      &
!            4475.00000,    5120.00000,    5830.00000,      &
!            6608.00000,    7461.00000,    8395.00000,      &
!            9424.46289,   10574.46880,   11864.80270,      &
!           13312.58890,   14937.03710,   16759.70700,      &
!           18804.78710,   21099.41210,   23674.03710,      &
!           26562.82810,   29804.11720,   32627.31640,      &
!           34245.89840,   34722.28910,   34155.19920,      &
!           32636.50390,   30241.08200,   27101.44920,      &
!           23362.20700,   19317.05270,   15446.17090,      &
!           12197.45210,    9496.39941,    7205.66992,      &
!            5144.64307,    3240.79346,    1518.62134,      &
!               0.00000,       0.00000 /


!      data b64/0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00000,      &
!               0.00000,       0.00000,       0.00813,      &
!               0.03224,       0.07128,       0.12445,      &
!               0.19063,       0.26929,       0.35799,      &
!               0.45438,       0.55263,       0.64304,      &
!               0.71703,       0.77754,       0.82827,      &
!               0.87352,       0.91502,       0.95235,      &
!               0.98511,       1.00000 /

!  NCEP updated ak and bk.

       data a64/       0.000000,       64.24700,      137.78999,   &
                      221.95799,      318.26601,      428.43403,   &
                      554.42398,      698.45703,      863.05794,   &
                     1051.08002,     1265.75195,     1510.71091,   &
                     1790.05096,     2108.36609,     2470.78796,   &
                     2883.03802,     3351.45996,     3883.05206,   &
                     4485.49316,     5167.14600,     5937.04956,   &
                     6804.87366,     7777.15027,     8832.53662,   &
                     9936.61377,    11054.85352,    12152.93701,   &
                    13197.06543,    14154.31641,    14993.07495,   &
                    15683.48877,    16197.96753,    16511.73584,   &
                    16611.60522,    16503.14575,    16197.31567,   &
                    15708.89282,    15056.34155,    14261.43433,   &
                    13348.67065,    12344.48975,    11276.34766,   &
                    10171.71204,     9057.05078,     7956.90796,   &
                     6893.11707,     5884.20593,     4945.02869,   &
                     4086.61407,     3316.21704,     2637.55310,   &
                     2051.15005,     1554.78897,     1143.98804,   &
                      812.48894,      552.71999,      356.22299,   &
                      214.01501,      116.89899,       55.71200,   &
                       21.51600,       5.741000,       0.575000,   &
                       0.000000,       0.000000 /

       data b64/0.00000,       0.00000,       0.00000,      &
                0.00000,       0.00000,       0.00000,      &
                0.00000,       0.00000,       0.00000,      &
                0.00000,       0.00000,       0.00000,      &
                0.00000,       0.00000,       0.00000,      &
                0.00000,       0.00000,       0.00000,      &
                0.00000,       0.00000,       0.00000,      &
                0.00000,       0.000036970,   0.00043106,   &
                0.0016359,     0.0041067,     0.0082940,    &
                0.014637,      0.023556,      0.035442,     &
                0.050647,      0.069475,      0.092167,     &
                0.11881,       0.14927,       0.18330,      &
                0.22057,       0.26069,       0.30316,      &
                0.34747,       0.39302,       0.43921,      &
                0.48544,       0.53113,       0.57575,      &
                0.61880,       0.65989,       0.69868,      &
                0.73495,       0.76851,       0.79931,      &
                0.82732,       0.85259,       0.87522,      &
                0.89535,       0.91315,       0.92880,      &
                0.94249,       0.95443,       0.96483,      &
                0.97387,       0.98174,       0.98863,      &
                0.99467,       1.00000/
                
!  NCEP levels adapted to 72-level GMAO-like:
!  all levels below ak=137.78999 are identical to the 64-NCEP levels 
!  levels above that were fix as top=gmao-72, and others interpololated
!  somewhat at will (RTodling)

       data a72_ncep/ 1.0000000,      2.6350000,                   &
                      5.6792510,      10.452402,      13.959903,   &
                      18.542203,      24.493755,      42.042359,   &
                      70.595662,      101.94402,      137.78999,   &
                      221.95799,      318.26601,      428.43403,   &
                      554.42398,      698.45703,      863.05794,   &
                     1051.08002,     1265.75195,     1510.71091,   &
                     1790.05096,     2108.36609,     2470.78796,   &
                     2883.03802,     3351.45996,     3883.05206,   &
                     4485.49316,     5167.14600,     5937.04956,   &
                     6804.87366,     7777.15027,     8832.53662,   &
                     9936.61377,    11054.85352,    12152.93701,   &
                    13197.06543,    14154.31641,    14993.07495,   &
                    15683.48877,    16197.96753,    16511.73584,   &
                    16611.60522,    16503.14575,    16197.31567,   &
                    15708.89282,    15056.34155,    14261.43433,   &
                    13348.67065,    12344.48975,    11276.34766,   &
                    10171.71204,     9057.05078,     7956.90796,   &
                     6893.11707,     5884.20593,     4945.02869,   &
                     4086.61407,     3316.21704,     2637.55310,   &
                     2051.15005,     1554.78897,     1143.98804,   &
                      812.48894,      552.71999,      356.22299,   &
                      214.01501,      116.89899,       55.71200,   &
                       21.51600,       5.741000,       0.575000,   &
                       0.000000,       0.000000 /

       data b72_ncep/0.00000,       0.00000,                     &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.00000,       0.00000,      &
                     0.00000,       0.000036970,   0.00043106,   &
                     0.0016359,     0.0041067,     0.0082940,    &
                     0.014637,      0.023556,      0.035442,     &
                     0.050647,      0.069475,      0.092167,     &
                     0.11881,       0.14927,       0.18330,      &
                     0.22057,       0.26069,       0.30316,      &
                     0.34747,       0.39302,       0.43921,      &
                     0.48544,       0.53113,       0.57575,      &
                     0.61880,       0.65989,       0.69868,      &
                     0.73495,       0.76851,       0.79931,      &
                     0.82732,       0.85259,       0.87522,      &
                     0.89535,       0.91315,       0.92880,      &
                     0.94249,       0.95443,       0.96483,      &
                     0.97387,       0.98174,       0.98863,      &
                     0.99467,       1.00000/
                

#ifdef _BETA3P1_N_EARLIER_

      data a72 / &
         1.00000,     2.00000,     3.27000,     4.75850,     6.60000,     8.93450, &
         11.9703,     15.9495,     21.1349,     27.8526,     36.5041,     47.5806, &
         61.6779,     79.5134,     101.944,     130.051,     165.079,     208.497, &
         262.021,     327.643,     407.657,     504.680,     621.680,     761.984, &
         929.294,     1127.69,     1364.34,     1645.71,     1979.16,     2373.04, &
         2836.78,     3381.00,     4017.54,     4764.39,     5638.79,     6660.34, &
         7851.23,     9236.57,     10866.3,     12783.7,     15039.3,     17693.0, &
         20119.2,     21686.5,     22436.3,     22389.8,     21877.6,     21215.0, &
         20325.9,     19309.7,     18161.9,     16960.9,     15626.0,     14291.0, &
         12869.6,     11409.0,     9936.52,     8909.99,     7883.42,     6856.90, &
         5805.32,     5169.61,     4533.90,     3898.20,     3257.08,     2609.20, &
         1961.31,     1313.48,     659.375,     332.086,     4.80469,     0.00000, &
         0.00000 /
       
      data b72 / &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000, &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000, &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000, &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000, &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000, &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000, &
         0.00000,     0.00000,     0.00000,     0.00000,     0.00000,     0.00000, &
        0.00696000,   0.0280100,   0.0637200,   0.113602,    0.156224,    0.200350, &
         0.246741,    0.294403,    0.343381,    0.392891,    0.443740,    0.494590, &
         0.546304,    0.598410,    0.650635,    0.685900,    0.721166,    0.756431, &
         0.791947,    0.813304,    0.834661,    0.856018,    0.877429,    0.898908, &
         0.920387,    0.941865,    0.963406,    0.974179,    0.984952,    0.992500, &
         1.00000 /
#else

        data a72 / &
         1.0000000,       2.0000002,       3.2700005,       4.7585009,       6.6000011, &
         8.9345014,       11.970302,       15.949503,       21.134903,       27.852606, &
         36.504108,       47.580610,       61.677911,       79.513413,       101.94402, &
         130.05102,       165.07903,       208.49704,       262.02105,       327.64307, &
         407.65710,       504.68010,       621.68012,       761.98417,       929.29420, &
         1127.6902,       1364.3402,       1645.7103,       1979.1604,       2373.0405, &
         2836.7806,       3381.0007,       4017.5409,       4764.3911,       5638.7912, &
         6660.3412,       7851.2316,       9236.5722,       10866.302,       12783.703, &
         15039.303,       17693.003,       20119.201,       21686.501,       22436.301, &
         22389.800,       21877.598,       21214.998,       20325.898,       19309.696, &
         18161.897,       16960.896,       15625.996,       14290.995,       12869.594, &
         11895.862,       10918.171,       9936.5219,       8909.9925,       7883.4220, &
         7062.1982,       6436.2637,       5805.3211,       5169.6110,       4533.9010, &
         3898.2009,       3257.0809,       2609.2006,       1961.3106,       1313.4804, &
         659.37527,       4.8048257,       0.0000000 /


        data b72 / &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,       0.0000000,       0.0000000,       0.0000000,       0.0000000, &
         0.0000000,   8.1754130e-09,    0.0069600246,     0.028010041,     0.063720063, &
        0.11360208,      0.15622409,      0.20035011,      0.24674112,      0.29440312, &
        0.34338113,      0.39289115,      0.44374018,      0.49459020,      0.54630418, &
        0.58104151,      0.61581843,      0.65063492,      0.68589990,      0.72116594, &
        0.74937819,      0.77063753,      0.79194696,      0.81330397,      0.83466097, &
        0.85601798,      0.87742898,      0.89890800,      0.92038701,      0.94186501, &
        0.96340602,      0.98495195,       1.0000000 /

#endif

! Fake single-level for util codes - mimic lowest lev of 72 GMAO case
      data a01 /  4.8048257,       0.0000000 /
      data b01 /  0.98495195,      1.0000000 /

!  ECMWF Nature
!
      data a91_EC/    0.000000000000,    2.000040054321,      3.980832099915,     7.387186050415, &
                  12.908319473267,   21.413604736328,     33.952865600586,    51.746597290039, &
                  76.167663574219,  108.715560913086,    150.986022949219,   204.637451171875, &
                 271.356445312500,  352.824462890625,    450.685791015625,   566.519287109375, & 
                 701.813232421875,  857.945800781250,                                          &
                1036.166503906250, 1237.585449218750,   1463.163818359375,  1713.709716796875, &
                1989.874511718750, 2292.155517578125,   2620.898437500000,  2976.302246093750, &
                3358.425781250000, 3767.196044921875,   4202.417968750000,  4663.777343750000, &
                5150.859375000000, 5663.156250000000,   6199.839843750000,  6759.726562500000, &
                7341.468750000000, 7942.925781250000,   8564.625000000000,  9208.304687500000, &
                9873.562500000000, 10558.882812500000,  11262.484375000000, 11982.660156250000, &
               12713.898437500000, 13453.226562500000,  14192.011718750000, 14922.687500000000, &
               15638.054687500000, 16329.562500000000,  16990.625000000000, 17613.281250000000, &
               18191.031250000000, 18716.968750000000,  19184.546875000000, 19587.515625000000, &
               19919.796875000000, 20175.394531250000,  20348.917968750000, 20434.156250000000, &
               20426.218750000000, 20319.011718750000,  20107.031250000000, 19785.359375000000, &
               19348.777343750000, 18798.824218750000,  18141.296875000000, 17385.593750000000, &
               16544.585937500000, 15633.566406250000,  14665.644531250000, 13653.218750000000, &
               12608.382812500000, 11543.167968750000,  10471.312500000000,  9405.222656250000, &
                8356.253906250000,  7335.164062500000,   6353.921875000000,  5422.800781250000, &
                4550.214843750000,  3743.464355468750,   3010.146972656250,  2356.202636718750, &
                1784.854492187500,  1297.656250000000,    895.193603515625,   576.314208984375, &
                 336.772460937500,   162.043426513672,     54.208343505859 ,    6.575628280640, &
                   0.003160000080,     0.000000000000/

       data b91_EC/  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000272400,     0.000013911600, &
                  0.000054667194,     0.000131364097,      0.000278884778,     0.000548384152, &
                  0.001000134507,     0.001701075351,      0.002764719306,     0.004267048091, &
                  0.006322167814,     0.009034991264,      0.012508261949,     0.016859579831, &
                  0.022188644856,     0.028610348701,      0.036226909608,     0.045146133751, &
                  0.055474229157,     0.067316174507,      0.080777287483,     0.095964074135, &
                  0.112978994846,     0.131934821606,      0.152933537960,     0.176091074944, &
                  0.201520144939,     0.229314863682,      0.259554445744,     0.291993439198, &
                  0.326329410076,     0.362202584743,      0.399204790592,     0.436906337738, &
                  0.475016415119,     0.513279736042,      0.551458477974,     0.589317142963, &
                  0.626558899879,     0.662933588028,      0.698223590851,     0.732223808765, &
                  0.764679491520,     0.795384764671,      0.824185431004,     0.850950419903, &
                  0.875518381596,     0.897767245770,      0.917650938034,     0.935157060623, &
                  0.950273811817,     0.963007092476,      0.973466038704,     0.982238113880, &
                  0.989152967930,     0.994204163551,      0.997630119324,     1.000000000000/


      data a96/  1.00000,       2.32782,       3.34990, &
               4.49484,       5.62336,       6.93048, &
               8.41428,      10.06365,      11.97630, &
              14.18138,      16.70870,      19.58824, &
              22.84950,      26.52080,      30.62845, &
              35.19588,      40.24273,      45.78375, &
              51.82793,      58.43583,      65.62319, &
              73.40038,      81.77154,      90.73373, &
             100.27628,     110.82243,     122.47773, &
             135.35883,     149.59464,     165.32764, &
             182.71530,     201.93164,     223.16899, &
             246.63988,     272.57922,     301.24661, &
             332.92902,     367.94348,     406.64044, &
             449.40720,     496.67181,     548.90723, &
             606.63629,     670.43683,     740.94727, &
             818.87329,     904.99493,    1000.17395, &
            1105.36304,    1221.61499,    1350.09326, &
            1492.08362,    1649.00745,    1822.43469, &
            2014.10168,    2225.92627,    2460.02905, &
            2718.75195,    3004.68530,    3320.69092, &
            3669.93066,    4055.90015,    4482.46240, &
            4953.88672,    5474.89111,    6050.68994, &
            6687.04492,    7390.32715,    8167.57373, &
            9026.56445,    9975.89648,   11025.06934, &
           12184.58398,   13466.04785,   14882.28320, &
           16447.46289,   18177.25781,   20088.97461, &
           21886.89453,   23274.16602,   24264.66602, &
           24868.31641,   25091.15430,   24935.41016, &
           24399.52148,   23478.13281,   22162.01758, &
           20438.00586,   18288.83984,   15693.01172, &
           12624.54199,    9584.35352,    6736.55713, &
            4231.34326,    2199.57910,     747.11890, &
              0.00000 /

      data b96/0.00000,       0.00000,       0.00000,&
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00000,       0.00000,       0.00000, &
              0.00315,       0.01263,       0.02853, &
              0.05101,       0.08030,       0.11669, &
              0.16055,       0.21231,       0.27249, &
              0.34169,       0.42062,       0.51005, &
              0.61088,       0.70748,       0.79593, &
              0.87253,       0.93400,       0.97764, &
              1.00000 /

! ECMWF 91-Levels reduced to 44
! -----------------------------
      data a44 / 2.000040 ,     12.90832 ,     33.95286 ,     76.16766 ,     150.9860   ,      &
                 271.3565 ,     450.6858 ,     701.8134 ,     1036.167 ,     1463.164   ,      &
                 1989.874 ,     2620.898 ,     3358.426 ,     4202.417 ,     5150.860   ,      &
                 6199.839 ,     7341.470 ,     8564.624 ,     9873.561 ,     11262.48   ,      &
                 12713.90 ,     14192.01 ,     15638.05 ,     16990.62 ,     18191.03   ,      &
                 19184.54 ,     19919.80 ,     20348.92 ,     20426.22 ,     20107.03   ,      &
                 19348.78 ,     18141.30 ,     16544.59 ,     14665.65 ,     12608.38   ,      &
                 10471.31 ,     8356.253 ,     6353.921 ,     4550.216 ,     3010.147   ,      &
                 1784.855 ,     895.1935 ,     336.7724 ,     54.20834 ,     0.0000000E+00 /

      data b44 / 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00 ,   &
                 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00 ,   &
                 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00, 0.0000000E+00 ,   &
                 0.0000000E+00, 0.0000000E+00, 5.5000000E-05, 2.7900000E-04, 1.0000000E-03 ,   &
                 2.7650001E-03, 6.3220002E-03, 1.2508000E-02, 2.2189001E-02, 3.6226999E-02 ,   &
                 5.5473998E-02, 8.0776997E-02, 0.1129790    , 0.1529340    , 0.2015200     ,   &
                 0.2595540    , 0.3263290    , 0.3992050    , 0.4750160    , 0.5514580     ,   &
                 0.6265590    , 0.6982240    , 0.7646790    , 0.8241850    , 0.8755180     ,   &
                 0.9176510    , 0.9502740    , 0.9734660    , 0.9891530    , 1.000000      /


! ECMWF 137-Levels
! --------------
       data a137 &
         /1.000000, 2.000365, 3.102241, 4.666084, 6.827977, 9.746966, 13.605424, 18.608931, 24.985718, 32.985710,  &
          42.879242, 54.955463, 69.520576, 86.895882, 107.415741, 131.425507, 159.279404, 191.338562, 227.968948, 269.539581,  &
          316.420746, 368.982361, 427.592499, 492.616028, 564.413452, 643.339905, 729.744141, 823.967834, 926.344910, 1037.20117,  &
          1156.853638, 1285.610352, 1423.770142, 1571.622925, 1729.448975, 1897.519287, 2076.095947, 2265.431641, 2465.770508, 2677.348145,  &
          2900.391357, 3135.119385, 3381.743652, 3640.468262, 3911.490479, 4194.930664, 4490.817383, 4799.149414, 5119.895020, 5452.990723,  &
          5798.344727, 6156.074219, 6526.946777, 6911.870605, 7311.869141, 7727.412109, 8159.354004, 8608.525391, 9076.400391, 9562.682617,  &
          10065.978516, 10584.631836, 11116.662109, 11660.067383, 12211.547852, 12766.873047, 13324.668945, 13881.331055, 14432.139648, 14975.615234,  &
          15508.256836, 16026.115234, 16527.322266, 17008.789062, 17467.613281, 17901.621094, 18308.433594, 18685.718750, 19031.289062, 19343.511719,  &
          19620.042969, 19859.390625, 20059.931641, 20219.664062, 20337.863281, 20412.308594, 20442.078125, 20425.718750, 20361.816406, 20249.511719,  &
          20087.085938, 19874.025391, 19608.572266, 19290.226562, 18917.460938, 18489.707031, 18006.925781, 17471.839844, 16888.687500, 16262.046875,  &
          15596.695312, 14898.453125, 14173.324219, 13427.769531, 12668.257812, 11901.339844, 11133.304688, 10370.175781, 9617.515625, 8880.453125,  &
          8163.375000, 7470.343750, 6804.421875, 6168.531250, 5564.382812, 4993.796875, 4457.375000, 3955.960938, 3489.234375, 3057.265625,  &
          2659.140625, 2294.242188, 1961.500000, 1659.476562, 1387.546875, 1143.250000, 926.507812, 734.992188, 568.062500, 424.414062,  &
          302.476562, 202.484375, 122.101562, 62.781250, 22.835938, 3.757813, 0.000000, 0.000000/

       data b137 &
         /0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,  &
          0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000007, 0.000024, 0.000059, 0.000112, 0.000199,  &
          0.000340, 0.000562, 0.000890, 0.001353, 0.001992, 0.002857, 0.003971, 0.005378, 0.007133, 0.009261,  &
          0.011806, 0.014816, 0.018318, 0.022355, 0.026964, 0.032176, 0.038026, 0.044548, 0.051773, 0.059728,  &
          0.068448, 0.077958, 0.088286, 0.099462, 0.111505, 0.124448, 0.138313, 0.153125, 0.168910, 0.185689,  &
          0.203491, 0.222333, 0.242244, 0.263242, 0.285354, 0.308598, 0.332939, 0.358254, 0.384363, 0.411125,  &
          0.438391, 0.466003, 0.493800, 0.521619, 0.549301, 0.576692, 0.603648, 0.630036, 0.655736, 0.680643,  &
          0.704669, 0.727739, 0.749797, 0.770798, 0.790717, 0.809536, 0.827256, 0.843881, 0.859432, 0.873929,  &
          0.887408, 0.899900, 0.911448, 0.922096, 0.931881, 0.940860, 0.949064, 0.956550, 0.963352, 0.969513,  &
          0.975078, 0.980072, 0.984542, 0.988500, 0.991984, 0.995003, 0.997630, 1.000000/

! ECMWF 137L-based model levels reconfigured for 71, 91, and 181 levels
      data a71 /1.0000000, 2.1400490, 3.7795095, 6.5821114, 11.133507,  &
               18.193396, 28.796295, 44.111816, 65.644745, 95.026543,  &
               134.11357, 184.99437, 249.84717, 330.97958, 430.81647,  &
               551.86511, 696.59869, 867.53271, 1067.1637, 1297.9674,  &
               1562.3615, 1862.7079, 2201.2708, 2580.2649, 3001.8269,  &
               3468.0142, 3980.8032, 4541.6880, 5151.2964, 5809.7905,  &
               6518.5034, 7283.7021, 8111.8613, 9010.0674, 9982.7041,  &
               11020.098, 12106.675, 13217.646, 14329.455, 15415.117,  &
               16448.746, 17406.846, 18266.801, 19008.264, 19612.848,  &
               20063.504, 20344.801, 20442.561, 20343.570, 20035.299,  &
               19505.855, 18743.820, 17742.197, 16519.598, 15116.528,  &
               13583.868, 11980.041, 10364.496, 8792.0713, 7307.6230,  &
               5944.9585, 4725.7383, 3660.7056, 2751.4771, 1992.9993,  &
               1375.7263, 887.20703, 515.41748, 249.22485, 80.236816,  &
               5.5175781, 0.0000000 /
      data b71 /0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 2.16796e-05, 0.000103533, 0.000313309,  &
               0.000823264, 0.00185771, 0.00373837, 0.00677792, 0.0113269,  &
               0.0177283, 0.0263068, 0.0373788, 0.0512474, 0.0681955,  &
               0.0884997, 0.112422, 0.140215, 0.172128, 0.208407,  &
               0.249289, 0.295016, 0.345651, 0.400271, 0.457481,  &
               0.515855, 0.573907, 0.630231, 0.683616, 0.733139,  &
               0.778173, 0.818387, 0.853709, 0.884270, 0.910347,  &
               0.932311, 0.950579, 0.965569, 0.977672, 0.987236,  &
               0.994526, 1.00000 /
      data a91 /1.0000000, 1.7500000, 2.7500000, 4.1000000, 5.9895105,  &
               8.6293297, 12.257263, 17.151091, 23.654547, 32.162769,  &
               43.131092, 57.110043, 74.659576, 96.447098, 123.16977,  &
               155.60132, 194.59401, 241.04753, 295.87384, 360.04697,  &
               434.60483, 520.62872, 619.15485, 731.29602, 858.24091,  &
               1001.0656, 1160.9286, 1339.0399, 1536.5001, 1754.4894,  &
               1994.1783, 2256.6741, 2543.1714, 2854.7639, 3192.5857,  &
               3557.7537, 3951.3511, 4374.2866, 4827.1108, 5310.2217,  &
               5823.8779, 6369.0425, 6948.7524, 7566.9199, 8226.3428,  &
               8931.2100, 9684.4619, 10482.272, 11318.279, 12184.077,  &
               13065.567, 13953.221, 14830.729, 15687.262, 16508.064,  &
               17281.100, 17994.299, 18636.322, 19196.180, 19664.072,  &
               20030.191, 20285.369, 20421.525, 20430.068, 20302.873,  &
               20032.371, 19611.066, 19031.385, 18286.643, 17377.793,  &
               16322.464, 15144.403, 13872.567, 12540.479, 11183.417,  &
               9835.3271, 8526.3066, 7282.2451, 6123.2607, 5063.5068,  &
               4111.2490, 3270.0012, 2539.2273, 1915.3076, 1392.4500,  &
               963.13477, 620.59937, 357.98950, 169.42139, 51.031494,  &
               2.4841309, 0.0000000 /
      data b91 /0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 3.50124e-06, 2.81484e-05,  &
               9.38667e-05, 0.000228562, 0.000512343, 0.00104713, 0.00195625,  &
               0.00342318, 0.00558632, 0.00865429, 0.0127844, 0.0181720,  &
               0.0249935, 0.0334199, 0.0436249, 0.0557769, 0.0700352,  &
               0.0865636, 0.105520, 0.127052, 0.151320, 0.178477,  &
               0.208676, 0.242069, 0.278814, 0.319043, 0.362559,  &
               0.408596, 0.456385, 0.505112, 0.553903, 0.601903,  &
               0.648333, 0.692535, 0.733981, 0.772292, 0.807236,  &
               0.838725, 0.866775, 0.891497, 0.913065, 0.931703,  &
               0.947658, 0.961176, 0.972495, 0.981844, 0.989411,  &
               0.995342, 1.00000 /
      data a181 /1.0000000, 1.325725, 1.7250000, 2.2000000, 2.7500000,  &
               3.3860855, 4.1233277, 4.9958706, 6.0387363, 7.2610245,  &
               8.7148447, 10.408404, 12.397021, 14.698566, 17.369101,  &
               20.446402, 23.983353, 28.038151, 32.642284, 37.900143,  &
               43.822773, 50.539959, 58.071102, 66.521347, 75.967796,  &
               86.479813, 98.193451, 111.13642, 125.46181, 141.23837,  &
               158.56229, 177.59976, 198.39230, 221.10054, 245.82892,  &
               272.67422, 301.81915, 333.33337, 367.35645, 404.06665,  &
               443.53485, 485.93210, 531.39905, 580.03564, 632.03076,  &
               687.51086, 746.59155, 809.46063, 876.24243, 947.05927,  &
               1022.1003, 1101.4973, 1185.3728, 1273.9043, 1367.2411,  &
               1465.4983, 1568.8376, 1677.4410, 1791.4093, 1910.8951,  &
               2036.0768, 2167.0686, 2304.0112, 2447.0752, 2596.4036,  &
               2752.1150, 2914.3584, 3083.3037, 3259.0642, 3441.7800,  &
               3631.6067, 3828.6858, 4033.1138, 4245.0000, 4464.4087,  &
               4691.3931, 4926.0132, 5168.3125, 5418.3120, 5676.0361,  &
               5941.5762, 6215.1167, 6497.1655, 6788.2124, 7088.6963,  &
               7399.0981, 7719.6548, 8050.9492, 8393.3418, 8747.4395,  &
               9114.0293, 9492.8174, 9883.1836, 10284.514, 10696.003,  &
               11116.694, 11545.480, 11981.056, 12421.522, 12864.947,  &
               13310.971, 13757.272, 14201.801, 14642.882, 15079.733,  &
               15510.191, 15931.703, 16343.536, 16744.199, 17131.818,  &
               17504.734, 17861.605, 18201.016, 18521.611, 18821.934,  &
               19100.689, 19356.793, 19588.516, 19794.955, 19975.031,  &
               20127.486, 20251.057, 20345.215, 20408.137, 20439.193,  &
               20437.375, 20401.547, 20330.734, 20224.135, 20080.361,  &
               19898.953, 19678.531, 19418.391, 19117.633, 18775.178,  &
               18390.545, 17963.656, 17496.461, 16991.633, 16451.850,  &
               15880.094, 15279.755, 14654.828, 14009.356, 13347.754,  &
               12674.469, 11994.299, 11311.212, 10629.535, 9953.3809,  &
               9286.5479, 8632.5986, 7994.6167, 7375.5801, 6777.6978,  &
               6203.3325, 5653.7783, 5130.5054, 4634.3564, 4165.9609,  &
               3725.7202, 3313.5742, 2929.5410, 2573.0042, 2243.6401,  &
               1940.7349, 1663.2080, 1410.8154, 1181.8054, 975.88501,  &
               791.96167, 628.96118, 486.34033, 362.99438, 258.23364,  &
               171.97876, 102.78320, 51.965332, 18.139648, 2.5878906,  &
               0.0000000, 0.0000000 /
      data b181 /0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               9.04550e-07, 6.80873e-06, 1.88624e-05, 4.01559e-05, 7.30653e-05,  &
               0.000117618, 0.000184636, 0.000283122, 0.000424446, 0.000622510,  &
               0.000890024, 0.00124501, 0.00170468, 0.00229318, 0.00303516,  &
               0.00394072, 0.00503879, 0.00635444, 0.00791055, 0.00972184,  &
               0.0118162, 0.0142258, 0.0169629, 0.0200500, 0.0235133,  &
               0.0273754, 0.0316569, 0.0363798, 0.0415651, 0.0472346,  &
               0.0534086, 0.0601060, 0.0673534, 0.0751669, 0.0835657,  &
               0.0925711, 0.102204, 0.112478, 0.123421, 0.135049,  &
               0.147381, 0.160437, 0.174237, 0.188798, 0.204144,  &
               0.220291, 0.237262, 0.255072, 0.273744, 0.293296,  &
               0.313739, 0.335044, 0.357121, 0.379850, 0.403144,  &
               0.426909, 0.451043, 0.475437, 0.499982, 0.524566,  &
               0.549077, 0.573402, 0.597446, 0.621112, 0.644309,  &
               0.666953, 0.688972, 0.710301, 0.730885, 0.750681,  &
               0.769650, 0.787772, 0.805026, 0.821406, 0.836910,  &
               0.851542, 0.865314, 0.878240, 0.890344, 0.901645,  &
               0.912175, 0.921963, 0.931035, 0.939429, 0.947170,  &
               0.954294, 0.960833, 0.966813, 0.972267, 0.977224,  &
               0.981703, 0.985739, 0.989336, 0.992526, 0.995314,  &
               0.997766, 1.00000 /

! GFS 127-levels
      data a127 /1.0000000, 1.6100000, 2.5300000, 3.9200001, 5.9800000,  &
               8.9499998, 13.179999, 19.100000, 27.240000, 38.280003,  &
               52.980000, 72.290001, 97.269997, 129.11000, 169.14000,  &
               218.77000, 279.51001, 352.88998, 440.47998, 543.77997,  &
               664.23999, 803.15997, 961.72998, 1140.9299, 1341.5399,  &
               1564.1200, 1809.0299, 2076.4199, 2366.2500, 2678.3701,  &
               3012.5100, 3368.3601, 3745.6501, 4144.1602, 4563.8804,  &
               5005.0000, 5468.0200, 5953.8501, 6463.8604, 7000.0000,  &
               7563.5171, 8150.7026, 8756.4961, 9376.1182, 10004.557,  &
               10636.895, 11268.173, 11893.664, 12508.522, 13108.113,  &
               13687.715, 14242.850, 14769.191, 15262.231, 15717.814,  &
               16132.047, 16500.980, 16820.900, 17088.295, 17299.904,  &
               17453.115, 17548.350, 17586.785, 17569.723, 17498.691,  &
               17375.541, 17202.287, 16981.139, 16714.516, 16405.027,  &
               16055.521, 15668.872, 15248.242, 14796.859, 14318.048,  &
               13815.177, 13291.669, 12750.928, 12196.481, 11631.684,  &
               11059.848, 10484.204, 9907.9648, 9333.9902, 8765.1973,  &
               8204.0957, 7653.3325, 7115.1245, 6591.4185, 6084.1494,  &
               5594.9097, 5124.9634, 4675.5557, 4247.6562, 3841.9678,  &
               3458.9355, 3098.9746, 2762.3169, 2448.7793, 2158.2642,  &
               1890.3931, 1644.7205, 1420.6238, 1217.4927, 1034.4971,  &
               870.80078, 725.32959, 597.25952, 485.43091, 388.70239,  &
               306.18896, 236.47461, 178.62549, 131.43311, 93.756104,  &
               64.392090, 42.272949, 26.287842, 15.301514, 8.2702637,  &
               4.2297363, 1.9714355, 0.76293945, 0.24414062, 0.018310547,  &
               0.0000000, 0.018310547, 0.0000000 /
      data b127 /0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               0.00000, 0.00000, 0.00000, 0.00000, 0.00000,  &
               1.00000e-05, 8.10000e-05, 0.000275000, 0.000651000, 0.00127000,  &
               0.00219200, 0.00347700, 0.00518200, 0.00736500, 0.0100810,  &
               0.0133850, 0.0173290, 0.0219620, 0.0273340, 0.0334900,  &
               0.0404710, 0.0483170, 0.0570640, 0.0667440, 0.0773850,  &
               0.0890060, 0.101594, 0.115126, 0.129576, 0.144913,  &
               0.161101, 0.178100, 0.195866, 0.214351, 0.233503,  &
               0.253266, 0.273582, 0.294389, 0.315623, 0.337218,  &
               0.359107, 0.381222, 0.403495, 0.425857, 0.448241,  &
               0.470581, 0.492813, 0.514874, 0.536706, 0.558252,  &
               0.579461, 0.600282, 0.620671, 0.640588, 0.659996,  &
               0.678863, 0.697163, 0.714872, 0.731971, 0.748446,  &
               0.764287, 0.779487, 0.794042, 0.807954, 0.821226,  &
               0.833865, 0.845880, 0.857283, 0.868087, 0.878308,  &
               0.887963, 0.897072, 0.905653, 0.913728, 0.921319,  &
               0.928446, 0.935134, 0.941404, 0.947279, 0.952782,  &
               0.957936, 0.962763, 0.967285, 0.971524, 0.975501,  &
               0.979236, 0.982751, 0.986063, 0.989185, 0.992130,  &
               0.994908, 0.997528, 1.00000 /


! GEOS-5 144 levels
! --------------

       data a144 / &
       1.000000, 1.960339, 3.018127, 4.519399, 6.594791, 9.396987, 13.101062, 17.904371,    &
       24.026014, 31.705914, 41.203591, 52.796624, 66.778966, 83.459060, 103.157888, 126.206988,    &
       152.946409, 183.722832, 218.887582, 258.794912, 303.800291, 354.258838, 410.523897, 472.945737,    &
       541.870439, 617.638927, 700.586001, 791.039663, 889.320479, 995.741215, 1110.606209, 1234.211175,    &
       1366.842986, 1508.779958, 1660.291153, 1821.636721, 1993.068262, 2174.828352, 2367.151362, 2570.263462,    &
       2784.382383, 3009.718592, 3246.475054, 3494.847707, 3755.025920, 4027.125241, 4311.173090, 4607.168297,    &
       4915.080393, 5234.848439, 5566.384314, 5909.800516, 6265.833909, 6635.356361, 7019.350358, 7418.266832,    &
       7832.926088, 8264.125457, 8713.280080, 9180.105429, 9663.263708, 10161.164935, 10671.907883, 11193.570701,    &
       11722.985614, 12256.091419, 12791.569071, 13325.958299, 13854.728219, 14376.458535, 14887.788352, 15384.926463,    &
       15866.079454, 16328.282045, 16768.748022, 17185.390535, 17575.925860, 17938.115274, 18269.858802, 18569.588965,    &
       18835.055787, 19064.826786, 19257.343857, 19410.685145, 19524.155037, 19595.621682, 19624.200090, 19608.495278,    &
       19547.149762, 19439.338553, 19283.411670, 19078.875993, 18824.044044, 18518.435827, 18160.585111, 17749.946276,    &
       17286.481825, 16772.805474, 16212.985926, 15611.418127, 14972.688273, 14685.145246, 14343.270330, 13949.485200,    &
       13506.727241, 13018.449574, 12488.621027, 11921.726145, 11322.765171, 10701.274117, 10064.717511, 9415.890690,    &
       8757.741793, 8093.371764, 7426.034348, 6759.136076, 6096.236214, 5441.046941, 4797.433388, 4167.668812,    &
       3553.036489, 2953.887909, 2369.719063, 1802.141374, 1252.799272, 723.370122, 215.564278, -268.874847,    &
       -728.170839, -1160.514171, -1564.062288, -1936.939948, -2277.238943, -2583.017359, -2852.300196, -3083.080054,    &
       -3273.316548, -3420.936755, -3523.834829, -3579.870938, -3586.872187, -3542.632607, -3444.913165, -3291.442693,    &
       0.000000/

       data b144 / &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,    &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,    &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,    &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,    &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,    &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000,    &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000007,    &
       0.000023, 0.000057, 0.000108, 0.000191, 0.000326, 0.000540, 0.000854, 0.001299,    &
       0.001912, 0.002743, 0.003812, 0.005163, 0.006848, 0.008890, 0.011334, 0.014223,    &
       0.017585, 0.021461, 0.025885, 0.030889, 0.036505, 0.042766, 0.049701, 0.057338,    &
       0.065709, 0.074839, 0.084754, 0.095482, 0.107044, 0.119469, 0.132779, 0.146998,    &
       0.162152, 0.178259, 0.195349, 0.213437, 0.232551, 0.252709, 0.273937, 0.296251,    &
       0.319618, 0.343920, 0.368984, 0.394675, 0.420850, 0.440673, 0.460647, 0.480716,    &
       0.500823, 0.520907, 0.540908, 0.560763, 0.580407, 0.599826, 0.619030, 0.637990,    &
       0.656675, 0.675052, 0.693090, 0.710758, 0.728021, 0.744846, 0.761201, 0.777101,    &
       0.792575, 0.807657, 0.822389, 0.836759, 0.850752, 0.864358, 0.877561, 0.890349,    &
       0.902708, 0.914625, 0.926086, 0.937078, 0.947586, 0.957597, 0.967096, 0.976070,    &
       0.984504, 0.992384, 0.999696, 1.006424, 1.012554, 1.018072, 1.022962, 1.027209,    &
       1.000000/

! GEOS-5 132 levels
! --------------
       data a132 / &
       1.000000,     1.996276,     3.093648,     4.651099,     6.804155,     9.711212,     13.553898,    18.536953,    &
       24.887674,    32.854966,    42.708057,    54.734916,    69.240493,    86.544776,    106.980758,   130.892382,   &
       158.632424,   190.560538,   227.041195,   268.441904,   315.131439,   367.478204,   425.848769,   490.606509,   &
       562.110455,   640.714290,   726.765342,   820.603888,   922.562490,   1032.965616,  1152.128995,  1280.359406,  &
       1417.954457,  1565.202880,  1722.383803,  1889.767115,  2067.613829,  2256.175598,  2455.695564,  2666.408361,  &
       2888.539866,  3122.308425,  3367.924596,  3625.591648,  3895.506041,  4177.787642,  4472.464900,  4779.536600,  &
       5098.971133,  5430.705281,  5774.647623,  6130.914868,  6500.271455,  6883.621876,  7281.985387,  7695.829790,  &
       8126.006088,  8573.341452,  9039.303976,  9523.598485,  10024.837122, 10541.370406, 11071.225963, 11612.410025, &
       12161.636274, 12714.691534, 13270.207397, 13824.594107, 14373.151226, 14914.405313, 15444.869700, 15960.611311, &
       16459.769620, 16939.268383, 17396.217121, 17828.450893, 18233.600515, 18609.343488, 18953.501254, 19264.447677, &
       19539.848583, 19778.217887, 19977.939176, 20137.018678, 20254.734748, 20328.875760, 20358.523606, 20342.231101, &
       20278.589963, 20166.744330, 20004.982477, 19792.792832, 19528.424768, 19211.380327, 18840.138412, 18414.132983, &
       17933.325139, 17400.426408, 16819.657745, 16195.578563, 15532.946677, 14837.558610, 14115.393726, 13372.886551, &
       12616.479397, 11852.696266, 11087.800514, 10327.790957, 9578.207359,  8844.157660,  8129.832058,  7440.098773,  &
       6777.003948,  6143.217998,  5541.186971,  4972.725810,  4438.905073,  3940.077056,  3475.984433,  3045.886238,  &
       2648.697264,  2283.946319,  1951.862407,  1652.526827,  1385.902714,  1151.874101,  950.288155,   780.991556,   &
       643.875906,   538.919476,   466.225293,   426.071190,   0.000000      /

       data b132 / &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, &
       0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000000, 0.000007, &
       0.000024, 0.000059, 0.000112, 0.000198, 0.000339, 0.000560, 0.000886, 0.001347, &
       0.001984, 0.002845, 0.003955, 0.005356, 0.007104, 0.009223, 0.011758, 0.014755, &
       0.018243, 0.022264, 0.026854, 0.032044, 0.037871, 0.044366, 0.051561, 0.059484, &
       0.068168, 0.077639, 0.087925, 0.099055, 0.111049, 0.123939, 0.137748, 0.152499, &
       0.168220, 0.184930, 0.202659, 0.221424, 0.241254, 0.262166, 0.284188, 0.307337, &
       0.331578, 0.356790, 0.382792, 0.409444, 0.436599, 0.464098, 0.491782, 0.519487, &
       0.547056, 0.574335, 0.601181, 0.627461, 0.653056, 0.677861, 0.701765, 0.724759, &
       0.746767, 0.767710, 0.787535, 0.806224, 0.823790, 0.840276, 0.855742, 0.870260, &
       0.883905, 0.896733, 0.908781, 0.920085, 0.930681, 0.940600, 0.949868, 0.958500, &
       0.966498, 0.973850, 0.980526, 0.986474, 1.000000 /

      select case (km)

! Fake single-level for util codes
        case (1)
          ks = 1
          do k=1,km+1
            ak(k) = a01(k)
            bk(k) = b01(k)
          enddo

! *** Original CCM3 18-Level setup ***
        case (18)
          ks = 4
          do k=1,km+1
            ak(k) = a18(k)
            bk(k) = b18(k)
          enddo

        case (26)
! CCM4 26-Level setup ***
          ks = 7
          do k=1,km+1
            ak(k) = a26(k)
            bk(k) = b26(k)
          enddo

        case (30)
! CCM4 30-Level setup ***
          ks = 12
          do k=1,km+1
            ak(k) = a30(k)
            bk(k) = b30(k)
          enddo

! *** Revised 32-L setup with ptop at 0.4 mb ***
! SJL: 04/01/2002
        case (32)
          ks = 21
          do k=1,km+1
            ak(k) = a32(k)
            bk(k) = b32(k)
          enddo

        case (48)                   ! adeed Aug 21, 2002
          ks = 30
          do k=1,km+1
            ak(k) = a48(k)
            bk(k) = b48(k)
          enddo

! *** Revised 55-L setup with ptop at 0.01 mb ***
        case (55)
          ks = 41
          do k=1,km+1
            ak(k) = a55(k)
            bk(k) = b55(k)
          enddo

        case (64)                       !NCEP sigma and hybrid eta levels
          if ( SIGMA_LEVS ) then
            print *, 'set_eta: setting up sigma levels instead of eta levels'
            ks = 0
            do k=1,km+1
              ak(k) = a64_sig(k)
              bk(k) = b64_sig(k)
            enddo
          else
            ks = 21
            do k=1,km+1
              ak(k) = a64(k)
              bk(k) = b64(k)
            enddo
          endif

! *** GEOS-5
        case (44)
          ks = 16
          do k=1,km+1
            ak(k) = a44(k)
            bk(k) = b44(k)
          enddo

        case (71)
        ks = 31
        do k=1,km+1
          ak(k) = a71(k)
          bk(k) = b71(k)
        end do

        case (72)
          if ( NCEP72_4GMAO ) then
             ks = 29
             do k=1,km+1
               ak(k) = a72_ncep(k)
               bk(k) = b72_ncep(k)
             enddo
          else
             ks = 40
             do k=1,km+1
               ak(k) = a72(k)
               bk(k) = b72(k)
             enddo
          endif

#ifdef ECMWF_91L_NR
        case (91)
        ks = 33
        do k=1,km+1
          ak(k) = a91_EC(k)
          bk(k) = b91_EC(k)
        end do
#else
        case (91)
        ks = 39
        do k=1,km+1
          ak(k) = a91(k)
          bk(k) = b91(k)
        end do
#endif

        case (96)
          ks = 77
          do k=1,km+1
            ak(k) = a96(k)
            bk(k) = b96(k)
          enddo

        case (137 )
          ks = 54
          do k=1,km+1
            ak(k) = a137(k)
            bk(k) = b137(k)
          enddo

        case (127 )
          ks = 39
          do k=1,km+1
            ak(k) = a127(k)
            bk(k) = b127(k)
          enddo

        case (144 )
          ks = 56
          do k=1,km+1
            ak(k) = a144(k)
            bk(k) = b144(k)
          enddo

        case (132 )
          ks = 54
          do k=1,km+1
            ak(k) = a132(k)
            bk(k) = b132(k)
          enddo

        case (181)
        ks = 71
        do k=1,km+1
          ak(k) = a181(k)
          bk(k) = b181(k)
        end do


      end select

          ptop = ak(1)
          pint = ak(ks+1) 

      return
    end subroutine set_eta_r8_

    subroutine set_eta_r4_ (km, ks, ptop, pint, ak, bk)

#ifdef HERMES
      use m_realkinds, only : r8 => kind_r8  ! from mpeu
      use m_realkinds, only : r4 => kind_r4  ! from mpeu
#else
      subroutine set_eta_r8_(km, ks, ptop, pint, ak, bk)
      use shr_kind_mod, only : r8 => shr_kind_r8 ! from gvgcm
      use shr_kind_mod, only : r4 => shr_kind_r4 ! from gvgcm
#endif
      implicit none
      integer ks, k, km
      real(r4) ak(km+1),bk(km+1)
      real(r4) ptop                      ! model top (Pa)
      real(r4) pint                      ! transition to p (Pa)
      real(r8),allocatable,dimension(:) :: r8_ak, r8_bk
      real(r8) r8_ptop
      real(r8) r8_pint
      allocate(r8_ak(km+1),r8_bk(km+1))
      call set_eta_r8_ (km, ks, r8_ptop, r8_pint, r8_ak, r8_bk)
      ptop = r8_ptop
      pint = r8_pint
      ak   = r8_ak
      bk   = r8_bk
      deallocate(r8_ak,r8_bk)
      
    end subroutine set_eta_r4_

    subroutine set_sigma ()
    implicit none
       SIGMA_LEVS = .true.
    end subroutine set_sigma
    subroutine unset_sigma ()
    implicit none
       SIGMA_LEVS = .false.
    end subroutine unset_sigma

    subroutine set_ncep72 ()
    implicit none
       NCEP72_4GMAO = .true.
       print*, 'Setting eta 72-levels with NCEP-64-like characteristics'
    end subroutine set_ncep72
    subroutine unset_ncep72 ()
    implicit none
       NCEP72_4GMAO = .false.
       print*, 'Unsetting eta 72-levels with NCEP-64-like characteristics'
    end subroutine unset_ncep72

    subroutine get_ref_plevs_r4_ ( ak, bk, ptop, plev, p0 )
    implicit none
    real(kind=REAL32), intent(in) :: ak(:), bk(:)
    real(kind=REAL32), intent(in) :: ptop
    real(kind=REAL32), intent(inout) :: plev(:)
    real(kind=REAL32), intent(in), optional :: p0

    integer k,nlev
    real(kind=REAL32) p0_

    p0_=98400.
    if(present(p0)) then
      p0_=p0
    endif

    nlev = size(plev)
    plev(1) = ptop + 0.5 * dpref_(1,p0_)
    do k = 2, nlev
       plev(k) = plev(k-1) + 0.5 * ( dpref_(k-1,p0_) + dpref_(k,p0_) )
    enddo
    plev(1:nlev) = plev(1:nlev) / 100.

      contains
      real(kind=REAL32) function dpref_ (k,pbot)
      integer k
      real(kind=REAL32) pbot
      dpref_   = ( ak(k+1) - ak(k) ) + &
                 ( bk(k+1) - bk(k) ) * pbot
      end function dpref_
    end subroutine get_ref_plevs_r4_

    subroutine get_ref_plevs_r8_ ( ak, bk, ptop, plev, p0 )
    implicit none
    real(kind=REAL64), intent(in) :: ak(:), bk(:)
    real(kind=REAL64), intent(in) :: ptop
    real(kind=REAL64), intent(inout) :: plev(:)
    real(kind=REAL64), intent(in), optional :: p0

    integer k,nlev
    real(kind=REAL64) p0_
    p0_=98400.d0
    if(present(p0)) then
      p0_=p0
    endif
    nlev = size(plev)
    plev(1) = ptop + 0.5 * dpref_(1,p0_)
    do k = 2, nlev
       plev(k) = plev(k-1) + 0.5 * ( dpref_(k-1,p0_) + dpref_(k,p0_) )
    enddo
    plev(1:nlev) = plev(1:nlev) / 100.

      contains
      real(kind=REAL64) function dpref_ (k,pbot)
      integer k
      real(kind=REAL64) pbot
      dpref_   = ( ak(k+1) - ak(k) ) + &
                 ( bk(k+1) - bk(k) ) * pbot
      end function dpref_
    end subroutine get_ref_plevs_r8_

#ifdef HERMES
  end module m_set_eta
#endif
