!
      module m_ec_set_eta
      PRIVATE
      PUBLIC ec_set_eta

 CONTAINS
      subroutine ec_set_eta(n_interface,ptop,a_interface,b_interface )
                                                                                                         
!     Returns the 61 interface level "a" coefficents of the ERA-40
!     model vertical coordinate.
                                                                                                         
!      IN/OUT:  
!                       n_interface: integer, number of interface levels (61)
!                       a_interface: real, array to store 61 interface level "a"
!                       coefficents, arranged top to bottom. Units
!                       are Pa.
                                                                                                         
      integer           :: n_interface
      real              :: a_interface(:)
      real              :: a_tmp(62),atmp(92)
      real              :: b_interface(:)
      real              :: b_tmp(62),btmp(92)
      real              :: ptop
      integer ilev
                                                                                                         
!     if ( n_interface .ne. 61 .or.  n_interface .ne. 91) then
!       write(*,*) "n_interface does not equal 61 or 91 in"
!       write(*,*) "subroutine get_a_interface"
!       stop
!     end if
                                                                                                         
      data a_tmp / 0.00000,    20.00000,    38.42530,    63.64780,    95.63700, &
                 134.48300,   180.58400,   234.77900,   298.49600,   373.97200, &
                 464.61800,   575.65100,   713.21800,   883.66000,  1094.83000, &
                1356.47000,  1680.64000,  2082.27000,  2579.89000,  3196.42000, &
                3960.29000,  4906.71000,  6018.02000,  7306.63000,  8765.05000, &
               10376.12000, 12077.40000, 13775.30000, 15379.80000, 16819.50000, &
               18045.20000, 19027.70000, 19755.10000, 20222.20000, 20429.90000, &
               20384.50000, 20097.40000, 19584.30000, 18864.80000, 17961.40000, &
               16899.50000, 15706.40000, 14411.10000, 13043.20000, 11632.80000, &
               10209.50000,  8802.36000,  7438.80000,  6144.32000,  4941.78000, &
                3850.91000,  2887.70000,  2063.78000,  1385.91000,   855.36200, &
                 467.33300,   210.39400,    65.88920,     7.36774,     0.00000, &
                   0.00000,0.00000 /

      data b_tmp / 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, &
                   0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, &
                   0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, &
                   0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, &
                   0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, &
                   0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, &
                   0.0000758235, 0.0004613950, 0.0018151600, 0.0050811200, &
                   0.0111429000, 0.0206779000, 0.0341212000, 0.0516904000, &
                   0.0735338000, 0.0996747000, 0.1300230000, 0.1643840000, &
                   0.2024760000, 0.2439330000, 0.2883230000, 0.3351550000, &
                   0.3838920000, 0.4339630000, 0.4847720000, 0.5357100000, &
                   0.5861680000, 0.6355470000, 0.6832690000, 0.7287860000, &
                   0.7715970000, 0.8112530000, 0.8473750000, 0.8796570000, &
                   0.9078840000, 0.9319400000, 0.9518220000, 0.9676450000, &
                   0.9796630000, 0.9882700000, 0.9940190000, 0.9976300000, &
                   1.0000000000 /

!           
!              Nature run coefficients.
!

      data atmp/   0.000000000000,    2.000040054321,      3.980832099915,     7.387186050415, &
                  12.908319473267,   21.413604736328,     33.952865600586,    51.746597290039, &
                  76.167663574219,  108.715560913086,    150.986022949219,   204.637451171875, &
                 271.356445312500,  352.824462890625,    450.685791015625,   566.519287109375, & 
                 701.813232421875,  857.945800781250,                                          &
                1036.166503906250, 1237.585449218750,   1463.163818359375,  1713.709716796875, &
                1989.874511718750, 2292.155517578125,   2620.898437500000,  2976.302246093750, &
                3358.425781250000, 3767.196044921875,   4202.417968750000,  4663.777343750000, &
                5150.859375000000, 5663.156250000000,   6199.839843750000,  6759.726562500000, &
                7341.468750000000, 7942.925781250000,   8564.625000000000,  9208.304687500000, &
                9873.562500000000, 10558.882812500000,  11262.484375000000, 11982.660156250000, &
               12713.898437500000, 13453.226562500000,  14192.011718750000, 14922.687500000000, &
               15638.054687500000, 16329.562500000000,  16990.625000000000, 17613.281250000000, &
               18191.031250000000, 18716.968750000000,  19184.546875000000, 19587.515625000000, &
               19919.796875000000, 20175.394531250000,  20348.917968750000, 20434.156250000000, &
               20426.218750000000, 20319.011718750000,  20107.031250000000, 19785.359375000000, &
               19348.777343750000, 18798.824218750000,  18141.296875000000, 17385.593750000000, &
               16544.585937500000, 15633.566406250000,  14665.644531250000, 13653.218750000000, &
               12608.382812500000, 11543.167968750000,  10471.312500000000,  9405.222656250000, &
                8356.253906250000,  7335.164062500000,   6353.921875000000,  5422.800781250000, &
                4550.214843750000,  3743.464355468750,   3010.146972656250,  2356.202636718750, &
                1784.854492187500,  1297.656250000000,    895.193603515625,   576.314208984375, &
                 336.772460937500,   162.043426513672,     54.208343505859 ,    6.575628280640, &
                   0.003160000080,     0.000000000000/

       data btmp/ 0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000000000,     0.000000000000, &
                  0.000000000000,     0.000000000000,      0.000000272400,     0.000013911600, &
                  0.000054667194,     0.000131364097,      0.000278884778,     0.000548384152, &
                  0.001000134507,     0.001701075351,      0.002764719306,     0.004267048091, &
                  0.006322167814,     0.009034991264,      0.012508261949,     0.016859579831, &
                  0.022188644856,     0.028610348701,      0.036226909608,     0.045146133751, &
                  0.055474229157,     0.067316174507,      0.080777287483,     0.095964074135, &
                  0.112978994846,     0.131934821606,      0.152933537960,     0.176091074944, &
                  0.201520144939,     0.229314863682,      0.259554445744,     0.291993439198, &
                  0.326329410076,     0.362202584743,      0.399204790592,     0.436906337738, &
                  0.475016415119,     0.513279736042,      0.551458477974,     0.589317142963, &
                  0.626558899879,     0.662933588028,      0.698223590851,     0.732223808765, &
                  0.764679491520,     0.795384764671,      0.824185431004,     0.850950419903, &
                  0.875518381596,     0.897767245770,      0.917650938034,     0.935157060623, &
                  0.950273811817,     0.963007092476,      0.973466038704,     0.982238113880, &
                  0.989152967930,     0.994204163551,      0.997630119324,     1.000000000000/

                                                                                                         
      if(n_interface .eq. 62) then
       ptop =  a_tmp(1)
       if(ptop == 0.0) ptop = 0.01
      endif

      if(n_interface .eq. 92) then
       ptop =  atmp(1)
       if(ptop == 0.0) ptop = 0.001
      endif

     if(n_interface .eq. 62) then
      do  ilev = 1, n_interface
        a_interface(ilev) = a_tmp(ilev)
        b_interface(ilev) = b_tmp(ilev)
      end do
     elseif(n_interface .eq. 92) then
      print *,' ec_set_eta:n_interface ',n_interface
      do  ilev = 1, n_interface
        a_interface(ilev) = atmp(ilev)
        b_interface(ilev) = btmp(ilev)
      end do
     endif

      return
    end subroutine ec_set_eta
   end module m_ec_set_eta
