program dyn_iupd

use m_dyn, only: dyn_vect
use m_dyn, only: dyn_init
use m_dyn, only: dyn_clean
use m_dyn, only: dyn_get
use m_dyn, only: dyn_getdim
use m_dyn, only: dyn_put
use m_maph_pert, only: h_map_pert
use m_die, only: die

implicit none

character(len=*), parameter :: myname="dyn_iupd"

character(len=256)  ifile
character(len=256)  iofile
integer, parameter :: dyntype=5
integer :: nymd, nhms, freq, rc
integer :: im1,jm1,km1,lm1
integer :: im2,jm2,km2,lm2
integer :: k
real :: rscale
real,allocatable :: ak(:),bk(:)
type(dyn_vect) :: xi
type(dyn_vect) :: yi
type(dyn_vect) :: zi
logical, parameter :: pncf=.true.
character(len=*), parameter :: ovars(11)=(/'    u','    v',' delp','   tv','   ps','   ts', ' sphu','qitot','qltot','qrtot','qstot'/)

rscale = -1.0e15

call init_()

call dyn_getdim ( trim(ifile) , im1, jm1, km1, lm1, rc )
call dyn_getdim ( trim(iofile), im2, jm2, km2, lm2, rc )
print *, im1, jm1, km1, lm1
print *, im2, jm2, km2, lm2

! Number of levels and tracers must equal for now
! -----------------------------------------------
if ( km1 /= km2 ) then
   call die (myname,'number of levs not consistent (error), aborting ... ')
endif
if ( lm1 /= lm2  ) then
   print *, trim(myname),' number of tracers not consistent (warning), updating what possible ... '
endif

! Read latest increment
! ---------------------
call dyn_get ( trim(iofile),  nymd, nhms, yi, rc, freq=freq, vectype=dyntype, pncf=pncf )

! Handle horizontal resolution difference ...
! will interpolate fields of old increment (first file)
! to the resulution of latest increments (second file)
! ----------------------------------------------------
if ( im1 /= im2 .or. &  ! when horizontal res not consistent, 
     jm1 /= jm2  ) then ! interpolate to hi-res

!    Read previous increment
!    ----------------------
     call dyn_get ( trim(ifile), nymd, nhms, zi, rc, freq=freq, vectype=dyntype, pncf=pncf )

!    Initialize dimension of output (interpolated) vector
!    ----------------------------------------------------
     call dyn_init ( im2, jm2, km2, lm2, xi, rc, &
                     zi%grid%ptop, zi%grid%ks, zi%grid%ak, zi%grid%bk, vectype=dyntype )
          if ( rc/=0 ) then
               call die (myname, ': Error initializing dyn vector(x_e)')
          endif
     print *, 'debug ',xi%grid%lm,yi%grid%lm,zi%grid%lm

!    Interpolate to required resolution
!    ----------------------------------
     lm1=min(zi%grid%lm,xi%grid%lm)
     xi%grid%lm=lm1
     zi%grid%lm=lm1
     call h_map_pert ( zi, xi, rc )
          if ( rc/=0 ) then
               call dyn_clean ( zi )
               call dyn_clean ( xi )
               print *, 'h_map error code = ', rc
               call die(myname,' failed in h_map')
          else
               call dyn_clean ( zi )
          endif

else
!    Read previous increment
!    -----------------------
     call dyn_get ( trim(ifile), nymd, nhms, xi, rc, freq=freq, vectype=dyntype, pncf=pncf )
     lm1=min(yi%grid%lm,xi%grid%lm)
endif

! update
yi%u = yi%u + xi%u
yi%v = yi%v + xi%v
yi%pt= yi%pt+ xi%pt
yi%q(:,:,:,1:lm1) = yi%q(:,:,:,1:lm1) + xi%q(:,:,:,1:lm1)
yi%ps= yi%ps+ xi%ps
yi%ts= yi%ts+ xi%ts
if ( rscale > -1.0e15 ) then ! split to avoid round off diffs in DAS when rscale=1.
   yi%u = rscale*yi%u
   yi%v = rscale*yi%v
   yi%pt= rscale*yi%pt
   yi%q(:,:,:,1:lm1) = rscale*yi%q(:,:,:,1:lm1)
   yi%ps= rscale*yi%ps
   yi%ts= rscale*yi%ts
endif

! reconstruct delp increment from ps increment
allocate(ak(km2+1),bk(km2+1))
do k=1,km2
   yi%delp(:,:,k)= (yi%grid%bk(k+1) - yi%grid%bk(k))*yi%ps(:,:)
enddo
deallocate(ak,bk)

! write out updated incremet - will overwrite original file
call dyn_put ( trim(iofile), nymd, nhms, 0, yi, rc, new=.true., freq=freq, vectype=dyntype, &
                               verbose=.true. )
!             only_vars=ovars, verbose=.true. )

! clean up
call dyn_clean ( yi )
call dyn_clean ( xi )

contains
  subroutine init_

  integer, parameter :: mfiles=2
  integer iargc,argc,nfiles,iarg,i
  character(len=256) str,argv

  argc = iargc()
  if ( argc < 2 ) then
     print *, "Usage: dyn_iupd.x [-scale SCALE] finput foutput"
     print *, "   "
     stop
  end if

  iarg = 0
  nfiles = 0

  do i = 1, 32767
     iarg = iarg + 1
     if ( iarg .gt. argc ) exit
     call GetArg ( iarg, argv )
     select case (argv)
       case ('-scale')
         if ( iarg+1 .gt. argc ) then
             print *, "See usage, aborting"
             stop
         endif
           iarg = iarg + 1
           call GetArg ( iarg, str )
           read(str,*) rscale
       case default
           nfiles = nfiles + 1
           if ( nfiles .gt. mfiles ) call die(myname,'too many eta files')
           if ( nfiles==1 )  ifile = argv
           if ( nfiles==2 ) iofile = argv
       end select
   enddo

   print * , "input increment: ", trim(ifile)
   print * , "increment to update: ", trim(iofile)
   if ( rscale > -1.e15 ) then 
      print *, "scaling perturbation by: ", rscale
   endif

  end subroutine init_
end program dyn_iupd
