#!/bin/csh -f
#
#  Simple aliases to emulate user functions in csh. You must source
#  this file before defining your functions. See utFunctions.csh
#  for an example. Basically, we define function declarations thru
#  the alias 'Sub' and function invocation thru alias 'Call'
#  (with parentheses and commas), or true alias Call_ (naked call).
#  Functions must end with "\end", and this must be the only word
#  on that line. The alias 'Clean" delete temporary files created 
#  in the process. Once you call Clean, your function definitions
#  are lost.
#
#  Limitations:
#  -----------
#  0) I am not kidding, this is not perl.
#  1) There is only one name space: all variables are global.
#     However, you can use Run to execute function as separate
#     script, this way preserving your name space.
#  2) Named arguments define global variables - be careful
#  3) Only simple alpha-numeric words as value of arguments for 
#     regular Call statements. Use naked Call_ to pass strings.
#  4) If declaration of function does not use named arguments, you
#     can still pass arguments and retrieve them thru $1, $2, $3,
#     etc. 
#  5) Some of these may be improved in the future but do not count
#     on it.  Contributions are welcome.
#  6) Reserved keywords: ARGV___, ARGC___, NAME___, ARG___, FILE___ RC___
#
# ---
#  Author: arlindo.dasilva@nasa.gov, November 2006.
# 
#  --------------------------------------------------------------------

# Short-hand to make fortran/perl programmers happy
# Syntax:  Use module_name
# Example: Use utFunctions
# Module files are required to have extension ".csm",
# but the extension is not required in the module name.
# -----------------------------------------------------
  alias Use \
'unset echo; set FILE___ = "\!*"\
if ( "$FILE___:e" != "csm" ) set FILE___ = $FILE___.csm\
set ARG___ = `which $FILE___`\
set RC___ = $status\
if ( $RC___ ) then\
   echo "error: cannot find module $FILE___"\
else\
   source $ARG___[1]\
   set RC___ = $status\
endif\
if ( $?Verify && $RC___ ) then\
     echo "error: aborting <Use> with rc = $RC___"\
     exit $RC___\
endif\
if ( $?ECHO___ ) set echo\
set status = $RC___'

# Sub declaration: un-quoted here documents save to tmp file
# ---------------------------------------------------------------
  alias Sub \
'unset echo; set ARGV___ = (`echo "\!*"|sed -e "s/(//g" -e "s/)//g" -e "s/,/ /g"`)\
set NAME___=$ARGV___[1]\
shift ARGV___\
echo "# Auto-generated by Functions.csh" > $TMPDIR/.cshFunctions.$$.$NAME___\
chmod +x $TMPDIR/.cshFunctions.$$.$NAME___\
echo "shift" >> $TMPDIR/.cshFunctions.$$.$NAME___\
set ARGC___ = 1\
foreach ARG___ ( $ARGV___ )\
  echo "set $ARG___ =" \"{\$}argv\[$ARGC___\]\" >> $TMPDIR/.cshFunctions.$$.$NAME___\
@ ARGC___++\
end\
if ( $?ECHO___ ) set echo\
cat <<\end>>$TMPDIR/.cshFunctions.$$.$NAME___'


# Function call of the form: Call function ( arg1, arg2, ... ) 
# -----------------------------------------------------------
  alias Call \
'unset echo; set ARGV___ = (`echo "\!*"|sed -e "s/(//g" -e "s/)//g" -e "s/,/ /g"`)\
set NAME___=$ARGV___[1]; set FILE___ = "$TMPDIR/.cshFunctions.$$.$NAME___"\
if ( $?Trace ) echo "---------------> Entering <$NAME___>"\
if ( -e $FILE___ ) then\
   source $FILE___ $ARGV___\
   set RC___ = $status\
else\
   echo "error: function <$NAME___> not defined"\
   set RC___ = 1\
endif\
if ( $?Verify && $RC___ ) then\
       echo "error: aborting <$NAME___> with rc = $RC___"\
       /bin/rm -rf $TMPDIR/.cshFunctions.$$.*\
       exit $RC___\
endif\
if ( $?ECHO___ ) set echo\
set status = $RC___'

# Naked function call: Call_ function  arg1 arg2  ... argn 
# -----------------------------------------------------------
  alias Call_ \
'unset echo; set ARGV___ = ( \!* ); set NAME___ = "$ARGV___[1]"; set FILE___ = "$TMPDIR/.cshFunctions.$$.$NAME___"; if ( -e $FILE___ ) source $FILE___ \!*\
set RC___ = $status\
if ( $?Trace ) echo "---------------> Entering <$NAME___>"\
if ( ! -e $FILE___ ) then\
   echo "error: function <$NAME___> not defined"\
   set RC___ = 1\
endif\
if ( $?Verify && $RC___ ) then\
       echo "error: aborting <$NAME___> with rc = $RC___"\
       /bin/rm -rf $TMPDIR/.cshFunctions.$$.*\
       exit $RC___\
endif\
if ( $?ECHO___ ) set echo\
set status = $RC___'

# Run: Like Call_ but run function as a separate shell script
# This is useful to preserve your name space.
# -----------------------------------------------------------
  alias Run \
'unset echo; set ARGV___ = ( \!* ); set NAME___ = "$ARGV___[1]"; set FILE___ = "$TMPDIR/.cshFunctions.$$.$NAME___"; if ( -e $FILE___ ) $FILE___ \!*\
set RC___ = $status\
if ( $?Trace ) echo "---------------> Entering <$NAME___>"\
if ( ! -e $FILE___ ) then\
   echo "error: function <$NAME___> not defined"\
   set RC___ = 1\
endif\
if ( $?Verify && $RC___ ) then\
       echo "error: aborting <$NAME___> with rc = $RC___"\
       /bin/rm -rf $TMPDIR/.cshFunctions.$$.*\
       exit $RC___\
endif\
if ( $?ECHO___ ) set echo\
set status = $RC___'


# Verify status, sort of like GEOS-5
# ----------------------------------
  alias Verify_ 'if ( $status ) exit $status'

# Delete temp files: Clean [all]
# ------------------------------
  alias Clean \
'unset echo; if ( "\!*" == "all" ) then\
    /bin/rm -rf $TMPDIR/.cshFunctions.*\
else\
    /bin/rm -rf $TMPDIR/.cshFunctions.$$.*\
endif\
if ( $?ECHO___ ) set echo'

# Set echo on
# -----------
  alias Echo    'set   ECHO___; set   echo'
  alias noEcho  'unset ECHO___; unset echo'
