function rad_1 (args)

expid  = subwrd(args,1)
season = subwrd(args,2)
output = subwrd(args,3)
num    = subwrd(args,4)
ptop   = subwrd(args,5)


'set xlopts 1 3 .14'
'set ylopts 1 3 .14'
'set x 1'
'rgbset'

* RADSW 1000-ptop'
* ---------------'
'vpage 1 1 2 2'
'set lev 1000 'ptop
'setlevs'
'set gxout shaded'
'black 0.999'
'set cint 1.0'
'set rbrange 0 16'
'd radswz'season'*86400'
'cbarn'
'set gxout contour'
'black 0.999'
'set cint  1.0'
'set ccolor 1'
'd radswz'season'*86400'
'draw ylab Pressure (mb)'
'draw title Heating from Shortwave Radiation (K/day)'

* RADLW 1000-ptop'
* ---------------'
'vpage 2 1 2 2'
'set lev 1000 'ptop
'setlevs'
'set gxout shaded'
'black 0.999'
'set cint 1.0'
'set rbrange -16 0'
'd radlwz'season'*86400'
'cbarn'
'set gxout contour'
'black 0.999'
'set cint  1.0'
'set ccolor 1'
'd radlwz'season'*86400'
'draw title Heating from Longwave Radiation (K/day)'

* RADSW 1000-10'
* -------------'
'vpage 1 2 2 2'
'set lev 1000 10'
'set zlog off'
'set gxout shaded'
'black 0.199'
'set cint 0.2'
'set rbrange 0 2'
'd radswz'season'*86400'
'cbarn'
'set gxout contour'
'black 0.199'
'set cint  0.2'
'set ccolor 1'
'd radswz'season'*86400'
'draw ylab Pressure (mb)'
'draw title Heating from Shortwave Radiation (K/day)'

* RADLW 1000-10'
* -------------'
'vpage 2 2 2 2'
'set lev 1000 10'
'set zlog off'
'set gxout shaded'
'black'
'set cint 0.5'
'set rbrange -6 0'
'd radlwz'season'*86400'
'cbarn'
'set gxout contour'
'black 0.499'
'set cint  0.5'
'set ccolor 1'
'd radlwz'season'*86400'
'draw title Heating from Longwave Radiation (K/day)'

'set vpage off'
'set strsiz .13'
'set string 1 c 6'

'xlabel 1 5.5 8.3'
'draw string 5.5 8.1 'season' ('num')'

'myprint -name 'output'/radz.'season
'c'

* Net RAD 1000-ptop'
* -----------------'
'vpage 1 1 2 2'
'set lev 1000 'ptop
'setlevs'
'set gxout shaded'
'black 0.499'
'set cint 0.5'
'set rbrange -8 4'
'd (radswz'season'+radlwz'season')*86400'
'cbarn'
'set gxout contour'
'black 0.499'
'set cint  0.5'
'set ccolor 1'
'd (radswz'season'+radlwz'season')*86400'
'draw ylab Pressure (mb)'
'draw title Net Heating from Radiation (K/day)'

* Net RAD 1000-ptop'
* -----------------'
'vpage 1 2 2 2'
'set lev 1000 10'
'set zlog off'
'set gxout shaded'
'black 0.499'
'set cint 0.5'
'set rbrange -8 2'
'd (radswz'season'+radlwz'season')*86400'
'cbarn'
'set gxout contour'
'black 0.499'
'set cint  0.5'
'set ccolor 1'
'd (radswz'season'+radlwz'season')*86400'
'draw ylab Pressure (mb)'
'draw title Net Heating from Radiation (K/day)'

'set vpage off'
'set strsiz .13'
'set string 1 c 6'

'xlabel 1 5.5 8.3'
'draw string 5.5 8.1 'season' ('num')'

'myprint -name 'output'/radz2.'season
'c'

* Ozone 1000-ptop'
* ---------------'
'vpage 1 1 2 2'
'set lev 1000 'ptop
'setlevs'
'set gxout shaded'
'black'
'set clevs   1    2    3    4    5    6    7    8   9    10    12   14  16   18   20   40    60   80  100  200  300  400  500 '
'set ccols  0  59   58   57   56   55   49   47   45   44   37   36   34   33   32   31   21   22   23   24    25   26   27   28'
'd o3z'season'*1e6'
'cbarn'
'set gxout contour'
'black'
'set clevs   1    2    3    4    5    6    7    8   9    10    12   14  16   18   20   40    60   80  100  200  300  400  500 '
'set ccolor 1'
'd o3z'season'*1e6'
'draw ylab Pressure (mb)'
'draw title Total Ozone'

* Ozone 1000-10 mb'
* ----------------'
'vpage 1 2 2 2'
'set lev 1000 10'
'set zlog off'
'set gxout shaded'
'black'
'set cint 0.2'
'set rbrange 0 2'
'set cmax 2'
'set clevs   .01 .02  .03    .04    .05    .06    .07    .08   .09    .10    .12   .14  .16   .18   .20   .40    .60   .80  1.00  2.00  3.00  4.00  5.00 '
'set ccols  0  59   58   57   56   55   49   47   45   44   37   36   34   33   32   31   21   22   23   24    25   26   27   28'
'd o3z'season'*1e6'
'cbarn'
'set gxout contour'
'black'
'set clevs   .01 .02  .03    .04    .05    .06    .07    .08   .09    .10    .12   .14  .16   .18   .20   .40    .60   .80  1.00  2.00  3.00  4.00  5.00 '
'set ccolor 1'
'd o3z'season'*1e6'
'draw ylab Pressure (mb)'
'draw title Total Ozone'

'set vpage off'
'set strsiz .13'
'set string 1 c 6'

'xlabel 1 5.5 8.3'
'draw string 5.5 8.1 'season' ('num')'

'myprint -name 'output'/ozone.'season
'c'
