#include <preproc.h>
      block data vegconi

#include <vartyp.h>
#include <lsmpar.h>

* ------------------------ code history ---------------------------
* source file:       vegconi.F
* purpose:           initialize vegetation constants 
* date last revised: March 1996 - lsm version 1
* author:            Gordon Bonan
* standardized:      J. Truesdale, Feb. 1996
* reviewed:          G. Bonan, Feb. 1996
* -----------------------------------------------------------------

#include <vegcon.h>

      integer i         !loop index

* plant types are:
*  1 = needleleaf evergreen tree
*  2 = needleleaf deciduous tree
*  3 = broadleaf evergreen tree
*  4 = broadleaf deciduous tree
*  5 = tropical seasonal tree
*  6 = cool grass (c3)
*  7 = evergreen shrub
*  8 = deciduous shrub
*  9 = arctic deciduous shrub
* 10 = arctic grass
* 11 = crop
* 12 = irrigated crop
* 13 = warm grass (c4)
* 14 = not vegetated

* note: there are two types of crops: non-irrigated and irrigated.
* this is strictly for the purposes of soil hydrology (need to know 
* when to irrigate). for convenience, this is keyed off vegetation 
* type. however, plant physiology does not vary between irrigated 
* and non-irrigated varieties. 

* value for irrigated crop 
      data nic /12/

* value for not vegetated 
      data noveg /14/

* exponent when calculating btran: [(h2osoi-watdry)/(watopt-watdry)]**vw 
      data vw /14*1.0/

* binvvt = 1/vkc*ln(z0m/z0h)
      data binvvt /14* 0.0/

* momentum roughness length (m) 
      data z0mvt /0.94,0.77,2.62,1.10,0.99,0.06,0.06,
     &            0.06,0.06,0.06,0.06,0.06,0.06,0.00/

* displacement height (m) 
      data zpdvt /11.39,9.38,23.45,13.40,12.06,0.34,0.34, 
     &             0.34,0.34, 0.34, 0.34, 0.34,0.34,0.00/

* characteristic leaf dimension (m) 
      data dleaf /13*0.04, 0.00/

* photosynthetic pathway: c3 = 1, c4 = 0
      data c3psn /12*1., 0., 1./

* co2 michaelis-menten constant at 25c (pa) 
      data kc25 /14*30./

* q10 for kc25 
      data akc /14*2.1/

* o2 michaelis-menten constant at 25c (pa) 
      data ko25 /14*30000./

* q10 for ko25 
      data ako /14*1.2/

* maximum rate of carboxylation at 25c (umol co2/m**2/s)
      data vcmx25 /33.,33.,50.,33.,50.,33.,17.,17.,
     &             33.,33.,50.,50.,33., 0./

* q10 for vcmx25 
      data avcmx /14*2.4/

* minimum leaf conductance (umol/m**2/s) 
      data bp /13*2000., 1.e15/

* slope for conductance-to-photosynthesis relationship 
      data mp /6.,6.,9.,9.,9.,9.,9.,9.,9.,9.,9.,9.,5.,9./

* quantum efficiency at 25c (umol co2 / umol photon)
      data qe25 /12*0.06, 0.04, 0.00/

* q10 for qe25 
      data aqe /14*1.0/

* foliage maintenance respiration rate at 25c (umol co2 /m**2 /s)
      data rmf25 /0.50,0.50,0.75,0.50,0.75,0.50,0.26,
     &            0.26,0.50,0.50,0.75,0.75,0.82,0.00/

* stem maintenance respiration at 25c (umol co2/kg biomass/s)
      data rms25 /0.9396,0.1364,0.1622,0.0198,0.0227,0.0000,0.0000,
     &            0.0000,1.0230,1.0230,0.0000,0.0000,0.0000,0.0000/

* stem biomass (kg /m**2)
      data stembvt / 3.6, 3.6, 9.0, 6.2, 4.5, 0.0, 0.0,
     &               0.0, 0.1, 0.1, 0.0, 0.0, 0.0, 0.0/

* root maintenance respiration at 25c (umol co2/kg biomass/s)
      data rmr25 /0.3637,0.0530,0.0455,0.0088,0.2091,0.5911,0.0000,
     &            0.0000,2.1142,2.1142,0.0000,0.0000,2.2733,0.0000/

* root biomass (kg /m**2)
      data rootbvt /7.2, 7.2,18.0,12.4, 9.0, 0.3, 0.0,
     &              0.0, 0.4, 0.4, 0.0, 0.0, 0.3, 0.0/

* q10 for maintenance respiration
      data arm /14*2.0/

* co2-to-biomass conversion factor (ug biomass / umol co2) 
      data dmcf /13*28.5, 0./

* foliage nitrogen concentration (%)
      data folnvt /13*2.0, 0.0/

* foliage nitrogen concentration when f(n)=1 (%) 
      data folnmx /13*1.5, 0.0/

* minimum temperature for photosynthesis (kelvin) 
      data tmin /268.16,268.16,278.16,273.16,278.16,273.16,268.16,
     &           273.16,273.16,273.16,273.16,273.16,273.16,  0.00/

* empirical parameter that defines root fraction decrease with depth 
      data rdp /0.94,0.94,0.94,0.94,0.97,0.97,0.97,
     &          0.97,0.94,0.94,0.94,0.94,0.97,1.00/

* microbial respiration parameter (umol co2 /kg c /s)
      data mrp /0.3727, 0.3727, 0.2333, 0.4000, 0.1250, 0.1700, 0.1909,
     &          0.1909, 0.0500, 0.0500, 0.2273, 0.2273, 0.1700, 0.0000/

* soil carbon (kg c /m**2)
      data soilcvt /11.0, 11.0, 15.0, 11.0,  8.0, 10.0, 11.0,
     &              11.0, 18.0, 18.0, 11.0, 11.0, 10.0,  0.0/

* leaf reflectance: 1=vis, 2=nir 
      data (rhol(i,1),i=1,mvt) /0.07,0.07,0.10,0.10,0.10,0.11,
     &                          0.07,0.10,0.10,0.11,0.11,0.11,
     &                          0.11,0.00/
      data (rhol(i,2),i=1,mvt) /0.35,0.35,0.45,0.45,0.45,0.58,
     &                          0.35,0.45,0.45,0.58,0.58,0.58,
     &                          0.58,0.00/

* stem reflectance: 1=vis, 2=nir 
      data (rhos(i,1),i=1,mvt) /0.16,0.16,0.16,0.16,0.16,0.36,
     &                          0.16,0.16,0.16,0.36,0.36,0.36,
     &                          0.36,0.00/
      data (rhos(i,2),i=1,mvt) /0.39,0.39,0.39,0.39,0.39,0.58,
     &                          0.39,0.39,0.39,0.58,0.58,0.58,
     &                          0.58,0.00/

* leaf transmittance: 1=vis, 2=nir 
      data (taul(i,1),i=1,mvt) /0.05,0.05,0.05,0.05,0.05,0.07,
     &                          0.05,0.05,0.05,0.07,0.07,0.07,
     &                          0.07,0.00/
      data (taul(i,2),i=1,mvt) /0.10,0.10,0.25,0.25,0.25,0.25,
     &                          0.10,0.25,0.25,0.25,0.25,0.25,
     &                          0.25,0.00/

* stem transmittance: 1=vis, 2=nir 
      data (taus(i,1),i=1,mvt) /0.001,0.001,0.001,0.001,0.001,
     &                          0.220,0.001,0.001,0.001,0.220,
     &                          0.220,0.220,0.220,0.000/
      data (taus(i,2),i=1,mvt) /0.001,0.001,0.001,0.001,0.001,
     &                          0.380,0.001,0.001,0.001,0.380,
     &                          0.380,0.380,0.380,0.000/

* leaf/stem orientation index: valid range = -0.4 to 0.6 
      data xl / 0.01, 0.01, 0.10, 0.25, 0.01,-0.30, 0.01,
     &          0.25, 0.25,-0.30,-0.30,-0.30,-0.30, 0.00/

* empirical canopy wind parameter
      data cwpvt /14*3.0/

* maximum intercepted h2o per unit lai+sai (mm) 
      data ch2op /14*0.1/

* monthly leaf area index + stem area index, one-sided
      data (tai(1,i),i=1,12) 
     &   /4.5,4.7,5.0,5.1,5.3,5.5,5.3,5.3,5.2,4.9,4.6,4.5/
      data (tai(2,i),i=1,12) 
     &   /0.3,0.3,0.3,1.0,1.6,2.4,4.3,2.9,2.0,1.3,0.8,0.5/
      data (tai(3,i),i=1,12) 
     &   /5.0,5.0,5.0,5.0,5.0,5.0,5.0,5.0,5.0,5.0,5.0,5.0/
      data (tai(4,i),i=1,12) 
     &   /0.4,0.4,0.7,1.6,3.5,5.1,5.4,4.8,3.8,1.7,0.6,0.4/
      data (tai(5,i),i=1,12) 
     &   /1.2,1.0,0.9,0.8,0.8,1.0,2.0,3.7,3.2,2.7,1.9,1.2/
      data (tai(6,i),i=1,12) 
     &   /0.7,0.8,0.9,1.0,1.5,3.4,4.3,3.8,1.8,1.0,0.9,0.8/
      data (tai(7,i),i=1,12) 
     &   /1.3,1.3,1.3,1.3,1.3,1.3,1.3,1.3,1.3,1.3,1.3,1.3/
      data (tai(8,i),i=1,12) 
     &   /1.0,1.0,0.8,0.3,0.6,0.0,0.1,0.3,0.5,0.6,0.7,0.9/
      data (tai(9,i),i=1,12) 
     &   /0.1,0.1,0.1,0.1,0.1,0.3,1.5,1.7,1.4,0.1,0.1,0.1/
      data (tai(10,i),i=1,12) 
     &   /0.7,0.8,0.9,1.0,1.5,3.4,4.3,3.8,1.8,1.0,0.9,0.8/
      data (tai(11,i),i=1,12) 
     &   /0.0,0.0,0.0,0.0,1.0,2.0,3.0,3.0,1.5,0.0,0.0,0.0/
      data (tai(12,i),i=1,12) 
     &   /0.0,0.0,0.0,0.0,1.0,2.0,3.0,3.0,1.5,0.0,0.0,0.0/
      data (tai(13,i),i=1,12) 
     &   /0.7,0.8,0.9,1.0,1.5,3.4,4.3,3.8,1.8,1.0,0.9,0.8/
      data (tai(14,i),i=1,12) 
     &   /0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0/

* monthly leaf area index, one-sided
      data (gai(1,i),i=1,12) 
     &   /4.1,4.2,4.6,4.8,4.9,5.0,4.8,4.7,4.6,4.2,4.0,4.0/
      data (gai(2,i),i=1,12) 
     &   /0.0,0.0,0.0,0.6,1.2,2.0,2.6,1.7,1.0,0.5,0.2,0.0/
      data (gai(3,i),i=1,12) 
     &   /4.5,4.5,4.5,4.5,4.5,4.5,4.5,4.5,4.5,4.5,4.5,4.5/
      data (gai(4,i),i=1,12) 
     &   /0.0,0.0,0.3,1.2,3.0,4.7,4.5,3.4,1.2,0.3,0.0,0.0/
      data (gai(5,i),i=1,12) 
     &   /0.8,0.7,0.4,0.5,0.5,0.7,1.7,3.0,2.5,1.6,1.0,1.0/
      data (gai(6,i),i=1,12) 
     &   /0.4,0.5,0.6,0.7,1.2,3.0,3.5,1.5,0.7,0.6,0.5,0.4/
      data (gai(7,i),i=1,12) 
     &   /1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0/
      data (gai(8,i),i=1,12) 
     &   /0.9,0.8,0.2,0.2,0.0,0.0,0.0,0.2,0.4,0.5,0.6,0.8/
      data (gai(9,i),i=1,12) 
     &   /0.0,0.0,0.0,0.0,0.0,0.2,1.4,1.2,0.0,0.0,0.0,0.0/
      data (gai(10,i),i=1,12) 
     &   /0.4,0.5,0.6,0.7,1.2,3.0,3.5,1.5,0.7,0.6,0.5,0.4/
      data (gai(11,i),i=1,12) 
     &   /0.0,0.0,0.0,0.0,1.0,2.0,3.0,3.0,1.5,0.0,0.0,0.0/
      data (gai(12,i),i=1,12) 
     &   /0.0,0.0,0.0,0.0,1.0,2.0,3.0,3.0,1.5,0.0,0.0,0.0/
      data (gai(13,i),i=1,12) 
     &   /0.4,0.5,0.6,0.7,1.2,3.0,3.5,1.5,0.7,0.6,0.5,0.4/
      data (gai(14,i),i=1,12) 
     &   /0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0/

* top of canopy (m)
      data hvt /17.0,14.0,35.0,20.0,18.0, 0.5, 0.5,
     &           0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.0/

* bottom of canopy (m)
      data hvb / 8.50, 7.00, 1.00,11.50,10.00, 0.01, 0.10,
     &           0.10, 0.10, 0.01, 0.01, 0.01, 0.01, 0.00/

      end
 
