#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tp_core_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_tl( im, c, c_tl, mfx, mfx_tl, p, p_tl, dm, dm_tl, fx, fx_tl, iord, al, al_tl, ar, ar_tl, a6, a6_tl, iuw, iue, &
&ffsl, isave )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_tl(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_tl(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_tl(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_tl(im)
integer :: iord
integer :: isave(im)
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_tl(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
real(kind=r8) :: ru_tl
logical :: steep

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al_tl(i) = dm_tl(i-1)*r3-dm_tl(i)*r3+0.5*p_tl(i-1)+0.5*p_tl(i)
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx_tl( im,p,p_tl,al(1),al_tl(1),dm,dm_tl )
endif
do i = 1, im-1
  ar_tl(i) = al_tl(i+1)
  ar(i) = al(i+1)
end do
ar_tl(im) = al_tl(1)
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh_tl( im,ar(1),ar_tl(1),al(1),al_tl(1),p(1),p_tl(1),a6(1),a6_tl(1),dm(1),dm_tl(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6_tl(i) = (-3)*al_tl(i)-3*ar_tl(i)+6*p_tl(i)
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm_tl( dm(1),dm_tl(1),a6(1),a6_tl(1),ar(1),ar_tl(1),al(1),al_tl(1),p(1),p_tl(1),im,lmt )
endif
if (ffsl) then
  do i = iuw, 0
    al_tl(i) = al_tl(im+i)
    al(i) = al(im+i)
    ar_tl(i) = ar_tl(im+i)
    ar(i) = ar(im+i)
    a6_tl(i) = a6_tl(im+i)
    a6(i) = a6(im+i)
  end do
  do i = im+1, iue
    al_tl(i) = al_tl(i-im)
    al(i) = al(i-im)
    ar_tl(i) = ar_tl(i-im)
    ar(i) = ar(i-im)
    a6_tl(i) = a6_tl(i-im)
    a6(i) = a6(i-im)
  end do
  do i = 1, im
    iu = c(i)
    ru_tl = c_tl(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      isave(i) = itmp+1
      fx_tl(i) = 0.5*a6_tl(itmp)*ru*ru*(1.-r23*ru)+0.5*al_tl(itmp)*ru*ru+ar_tl(itmp)*ru*(1+(-0.5)*ru)+ru_tl*(ru*((-(0.5*ru*a6(itmp)&
&*r23))+0.5*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))+ar(itmp)+0.5*ru*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))
      fx(i) = ru*(ar(itmp)+0.5*ru*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))
    else
      itmp = i-iu
      isave(i) = itmp-1
      fx_tl(i) = (-(0.5*a6_tl(itmp)*ru*ru*(1+r23*ru)))+al_tl(itmp)*ru*(1-(-0.5)*ru)-0.5*ar_tl(itmp)*ru*ru+ru_tl*((-(ru*(0.5*ru*&
&a6(itmp)*r23+0.5*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))))+al(itmp)-0.5*ru*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))
      fx(i) = ru*(al(itmp)-0.5*ru*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))
    endif
  end do
else
  al_tl(0) = al_tl(im)
  al(0) = al(im)
  ar_tl(0) = ar_tl(im)
  ar(0) = ar(im)
  a6_tl(0) = a6_tl(im)
  a6(0) = a6(im)
  do i = 1, im
    if (c(i) .gt. 0.) then
      fx_tl(i) = 0.5*a6_tl(i-1)*c(i)*(1.-r23*c(i))+0.5*al_tl(i-1)*c(i)+ar_tl(i-1)*(1+(-0.5)*c(i))+c_tl(i)*((-(0.5*c(i)*a6(i-1)*r23)&
&)+0.5*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i))))
      fx(i) = ar(i-1)+0.5*c(i)*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i)))
    else
      fx_tl(i) = (-(0.5*a6_tl(i)*c(i)*(1+r23*c(i))))+al_tl(i)*(1-(-0.5)*c(i))-0.5*ar_tl(i)*c(i)-c_tl(i)*(0.5*c(i)*a6(i)*r23+0.5*&
&(ar(i)-al(i)+a6(i)*(1.+r23*c(i))))
      fx(i) = al(i)-0.5*c(i)*(ar(i)-al(i)+a6(i)*(1.+r23*c(i)))
    endif
    fx_tl(i) = fx_tl(i)*mfx(i)+mfx_tl(i)*fx(i)
    fx(i) = mfx(i)*fx(i)
  end do
endif

end subroutine fxppm_tl


subroutine fyppm_tl( c, c_tl, q, q_tm, dm, dm_tl, flux, flux_tl, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_tl(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux(im,jfirst:jlast+1)
real(kind=r8) :: flux_tl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_tl(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_tl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al_tl(i,j) = dm_tl(i,j-1)*r3-dm_tl(i,j)*r3+0.5*q_tm(i,j-1)+0.5*q_tm(i,j)
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar_tl(i,j) = al_tl(i,j+1)
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tl(i,1) = al_tl(i+imh,2)
      al(i,1) = al(i+imh,2)
      al_tl(i+imh,1) = al_tl(i,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_tl(i,jm) = ar_tl(i+imh,jm1)
      ar(i,jm) = ar(i+imh,jm1)
      ar_tl(i+imh,jm) = ar_tl(i,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tl(i,1) = -al_tl(i+imh,2)
      al(i,1) = -al(i+imh,2)
      al_tl(i+imh,1) = -al_tl(i,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_tl(i,jm) = -ar_tl(i+imh,jm1)
      ar(i,jm) = -ar(i+imh,jm1)
      ar_tl(i+imh,jm) = -ar_tl(i,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6_tl(i,j) = (-3)*al_tl(i,j)-3*ar_tl(i,j)+6*q_tm(i,j)
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
call lmppm_tl( dm(1,js1g1),dm_tl(1,js1g1),a6(1,js1g1),a6_tl(1,js1g1),ar(1,js1g1),ar_tl(1,js1g1),al(1,js1g1),al_tl(1,js1g1),q(1,&
&js1g1),q_tm(1,js1g1),help_h,lmt )
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      flux_tl(i,j) = 0.5*a6_tl(i,j-1)*c(i,j)*(1.-r23*c(i,j))+0.5*al_tl(i,j-1)*c(i,j)+ar_tl(i,j-1)*(1+(-0.5)*c(i,j))+c_tl(i,j)*((-&
&(0.5*c(i,j)*a6(i,j-1)*r23))+0.5*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j))))
      flux(i,j) = ar(i,j-1)+0.5*c(i,j)*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j)))
    else
      flux_tl(i,j) = (-(0.5*a6_tl(i,j)*c(i,j)*(1+r23*c(i,j))))+al_tl(i,j)*(1-(-0.5)*c(i,j))-0.5*ar_tl(i,j)*c(i,j)-c_tl(i,j)*(0.5*&
&c(i,j)*a6(i,j)*r23+0.5*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j))))
      flux(i,j) = al(i,j)-0.5*c(i,j)*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j)))
    endif
  end do
end do

end subroutine fyppm_tl


subroutine huynh_tl( im, ar, ar_tl, al, al_tl, p, p_tl, d2, d2_tl, d1, d1_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_tl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tl(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_tl(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_tl(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_tl(im)

!==============================================
! declare local variables
!==============================================
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_tl
real(kind=r8) :: pmax
real(kind=r8) :: pmax_tl
real(kind=r8) :: pmin
real(kind=r8) :: pmin_tl
real(kind=r8) :: pmp
real(kind=r8) :: pmp_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
d1_tl(1) = (-p_tl(im))+p_tl(1)
d1(1) = p(1)-p(im)
do i = 2, im
  d1_tl(i) = (-p_tl(i-1))+p_tl(i)
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2_tl(i) = d1_tl(i+1)-d1_tl(i)
  d2(i) = d1(i+1)-d1(i)
end do
d2_tl(im) = (-d1_tl(im))+d1_tl(1)
d2(im) = d1(1)-d1(im)
pmp_tl = 2*d1_tl(1)+p_tl(1)
pmp = p(1)+2.*d1(1)
lac_tl = 0.5*d1_tl(1)+1.5*d2_tl(im)+p_tl(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin_tl = p_tl(1)*(0.5+sign(0.5d0,pmp-p(1)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(1)))
pmin = min(p(1),pmp,lac)
pmax_tl = p_tl(1)*(0.5+sign(0.5d0,p(1)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(1)-pmp))
pmax = max(p(1),pmp,lac)
ar_tl(1) = ar_tl(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(ar(1),pmin)-&
&pmax))+pmin_tl*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar(1) = min(pmax,max(ar(1),pmin))
do i = 2, im
  pmp_tl = 2*d1_tl(i)+p_tl(i)
  pmp = p(i)+2.*d1(i)
  lac_tl = 0.5*d1_tl(i)+1.5*d2_tl(i-1)+p_tl(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin_tl = p_tl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_tl = p_tl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  ar_tl(i) = ar_tl(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(ar(i),pmin)-&
&pmax))+pmin_tl*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar(i) = min(pmax,max(ar(i),pmin))
end do
do i = 1, im-1
  pmp_tl = (-2)*d1_tl(i+1)+p_tl(i)
  pmp = p(i)-2.*d1(i+1)
  lac_tl = (-0.5)*d1_tl(i+1)+1.5*d2_tl(i+1)+p_tl(i)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin_tl = p_tl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_tl = p_tl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  al_tl(i) = al_tl(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(al(i),pmin)-&
&pmax))+pmin_tl*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp_tl = (-2)*d1_tl(1)+p_tl(im)
pmp = p(im)-2.*d1(1)
lac_tl = (-0.5)*d1_tl(1)+1.5*d2_tl(1)+p_tl(im)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin_tl = p_tl(im)*(0.5+sign(0.5d0,pmp-p(im)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(im)))
pmin = min(p(im),pmp,lac)
pmax_tl = p_tl(im)*(0.5+sign(0.5d0,p(im)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(im)-pmp))
pmax = max(p(im),pmp,lac)
al_tl(im) = al_tl(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(al(im),&
&pmin)-pmax))+pmin_tl*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al(im) = min(pmax,max(al(im),pmin))
do i = 1, im
  d2_tl(i) = (-3)*al_tl(i)-3*ar_tl(i)+6*p_tl(i)
  d2(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
end do

end subroutine huynh_tl


subroutine lmppm_tl( dm, dm_tl, a6, a6_tl, ar, ar_tl, al, al_tl, p, p_tl, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_tl(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_tl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tl(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_tl(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_tl(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_tl
real(kind=r8) :: da1
real(kind=r8) :: da1_tl
real(kind=r8) :: da2
real(kind=r8) :: da2_tl
real(kind=r8) :: dl
real(kind=r8) :: dl_tl
real(kind=r8) :: dr
real(kind=r8) :: dr_tl
real(kind=r8) :: fmin
real(kind=r8) :: fmin_tl
integer :: i

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    if (dm(i) .eq. 0.) then
      ar_tl(i) = p_tl(i)
      ar(i) = p(i)
      al_tl(i) = p_tl(i)
      al(i) = p(i)
      a6_tl(i) = 0.d0
      a6(i) = 0.
    else
      da1_tl = (-al_tl(i))+ar_tl(i)
      da1 = ar(i)-al(i)
      da2_tl = 2*da1_tl*da1
      da2 = da1**2
      a6da_tl = a6_tl(i)*da1+da1_tl*a6(i)
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_tl(i) = 3*al_tl(i)-3*p_tl(i)
        a6(i) = 3.*(al(i)-p(i))
        ar_tl(i) = (-a6_tl(i))+al_tl(i)
        ar(i) = al(i)-a6(i)
      else if (a6da .gt. da2) then
        a6_tl(i) = 3*ar_tl(i)-3*p_tl(i)
        a6(i) = 3.*(ar(i)-p(i))
        al_tl(i) = (-a6_tl(i))+ar_tl(i)
        al(i) = ar(i)-a6(i)
      endif
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_tl = 2*dm_tl(i)
      da1 = dm(i)+dm(i)
      dl_tl = (al_tl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_tl(i)*(0.5-sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
      dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
      dr_tl = (ar_tl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_tl(i)*(0.5-sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
      dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
      ar_tl(i) = dr_tl+p_tl(i)
      ar(i) = p(i)+dr
      al_tl(i) = (-dl_tl)+p_tl(i)
      al(i) = p(i)-dl
      a6_tl(i) = 3*dl_tl-3*dr_tl
      a6(i) = 3.*(dl-dr)
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin_tl = a6_tl(i)*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)+al_tl(i)*((-0.5)*(ar(i)-al(i))/a6(i))+ar_tl(i)*(0.5*&
&(ar(i)-al(i))/a6(i))+p_tl(i)
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar_tl(i) = p_tl(i)
              ar(i) = p(i)
              al_tl(i) = p_tl(i)
              al(i) = p(i)
              a6_tl(i) = 0.d0
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6_tl(i) = 3*al_tl(i)-3*p_tl(i)
              a6(i) = 3.*(al(i)-p(i))
              ar_tl(i) = (-a6_tl(i))+al_tl(i)
              ar(i) = al(i)-a6(i)
            else
              a6_tl(i) = 3*ar_tl(i)-3*p_tl(i)
              a6(i) = 3.*(ar(i)-p(i))
              al_tl(i) = (-a6_tl(i))+ar_tl(i)
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_tl = 4*dm_tl(i)
          da1 = 4.*dm(i)
          dl_tl = (al_tl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_tl(i)*(0.5-&
&sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
          dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
          dr_tl = (ar_tl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_tl(i)*(0.5-&
&sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
          dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
          ar_tl(i) = dr_tl+p_tl(i)
          ar(i) = p(i)+dr
          al_tl(i) = (-dl_tl)+p_tl(i)
          al(i) = p(i)-dl
          a6_tl(i) = 3*dl_tl-3*dr_tl
          a6(i) = 3.*(dl-dr)
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_tl


subroutine steepx_tl( im, p, p_tl, al, al_tl, dm, dm_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_tl(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb
real(kind=r8) :: bbb_tl
real(kind=r8) :: ccc
real(kind=r8) :: ccc_tl
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_tl(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_tl(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_tl(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do i = 0, im
  dh_tl(i) = p_tl(i+1)-p_tl(i)
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2_tl(i) = (-dh_tl(i-1))+dh_tl(i)
  d2(i) = dh(i)-dh(i-1)
end do
d2_tl(0) = d2_tl(im)
d2(0) = d2(im)
d2_tl(im+1) = d2_tl(1)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx_tl = (-(p_tl(i-2)*((-0.5)/(p(i+1)-p(i-1)))))+p_tl(i-1)*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))-p_tl(i+2)&
&*(0.5/(p(i+1)-p(i-1)))+p_tl(i+1)*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta_tl(i) = xxx_tl*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta_tl(i) = 0.d0
    eta(i) = 0.
  endif
end do
eta_tl(0) = eta_tl(im)
eta(0) = eta(im)
do i = 1, im
  bbb_tl = dm_tl(i-1)*(2.*eta(i)-eta(i-1))-eta_tl(i-1)*dm(i-1)+2*eta_tl(i)*dm(i-1)
  bbb = (2.*eta(i)-eta(i-1))*dm(i-1)
  ccc_tl = dm_tl(i)*(2.*eta(i-1)-eta(i))+2*eta_tl(i-1)*dm(i)-eta_tl(i)*dm(i)
  ccc = (2.*eta(i-1)-eta(i))*dm(i)
  al_tl(i) = al_tl(i)+bbb_tl*r3-ccc_tl*r3+0.5*dh_tl(i-1)*(eta(i-1)-eta(i))+0.5*eta_tl(i-1)*dh(i-1)-0.5*eta_tl(i)*dh(i-1)
  al(i) = al(i)+0.5*(eta(i-1)-eta(i))*dh(i-1)+(bbb-ccc)*r3
end do

end subroutine steepx_tl


subroutine tp2c_tl( dh, dh_tl, va, va_tl, h, h_tl, crx, crx_tl, cry, cry_tl, im, jm, iord, jord, ng, fx, fx_tl, fy, fy_tl, ffsl, &
&rcap, acosp, xfx, xfx_tl, yfx, yfx_tl, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst:jlast+1)
real(kind=r8) :: dh(im,jfirst:jlast)
real(kind=r8) :: dh_tl(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_tl(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_tl(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1
real(kind=r8) :: sum1_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call tp2d_tl( va,va_tl,h,h_tl,crx,crx_tl,cry,cry_tl,im,jm,iord,jord,ng,fx,fx_tl,fy,fy_tl,ffsl,xfx,xfx_tl,yfx,yfx_tl,cosp,id,jfirst,&
&jlast )
do j = js2g0, jn2g0
  do i = 1, im-1
    dh_tl(i,j) = (-fx_tl(i+1,j))+fx_tl(i,j)-fy_tl(i,j+1)*acosp(j)+fy_tl(i,j)*acosp(j)
    dh(i,j) = fx(i,j)-fx(i+1,j)+(fy(i,j)-fy(i,j+1))*acosp(j)
  end do
end do
do j = js2g0, jn2g0
  dh_tl(im,j) = fx_tl(im,j)-fx_tl(1,j)-fy_tl(im,j+1)*acosp(j)+fy_tl(im,j)*acosp(j)
  dh(im,j) = fx(im,j)-fx(1,j)+(fy(im,j)-fy(im,j+1))*acosp(j)
end do
if (jfirst .eq. 1) then
  sum1_tl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_tl = fy_tl(i,2)+sum1_tl
    sum1 = sum1+fy(i,2)
  end do
  sum1_tl = -(sum1_tl*rcap)
  sum1 = -(sum1*rcap)
  do i = 1, im
    dh_tl(i,1) = sum1_tl
    dh(i,1) = sum1
  end do
endif
if (jlast .eq. jm) then
  sum1_tl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_tl = fy_tl(i,jm)+sum1_tl
    sum1 = sum1+fy(i,jm)
  end do
  sum1_tl = sum1_tl*rcap
  sum1 = sum1*rcap
  do i = 1, im
    dh_tl(i,jm) = sum1_tl
    dh(i,jm) = sum1
  end do
endif

end subroutine tp2c_tl


subroutine tp2d_tl( va, va_tl, q, q_tm, crx, crx_tl, cry, cry_tl, im, jm, iord, jord, ng, fx, fx_tl, fy, fy_tl, ffsl, xfx, xfx_tl, &
&yfx, yfx_tl, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_tl(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_tl(1+im+2*(im/3))
real(kind=r8) :: dmk_tl(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_tl(1+im+2*(im/3))
real(kind=r8) :: qtmpk_tl(1+im+2*(im/3))
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_tl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
do j = js2gng, jn2gng
  call xtp_tl( im,ffsl(j),wk1,wk1_tl,q(1,j),q_tm(1,j),crx(1,j),crx_tl(1,j),iad,crx(1,j),crx_tl(1,j),cosp(j),0,dm,dmk_tl,qtmp,&
&qtmpk_tl,al,ar,a6,a6_tl )
  do i = 1, im-1
    adx_tl(i,j) = 0.5*crx_tl(i+1,j)*q(i,j)-0.5*crx_tl(i,j)*q(i,j)+q_tm(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))-0.5*wk1_tl(i+1)+0.5*&
&wk1_tl(i)
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx_tl(im,j) = (-(0.5*crx_tl(im,j)*q(im,j)))+0.5*crx_tl(1,j)*q(im,j)+q_tm(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))+0.5*wk1_tl(im)-0.5*&
&wk1_tl(1)
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx_tl(i,1) = q_tm(i,1)
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx_tl(i,jm) = q_tm(i,jm)
    adx(i,jm) = q(i,jm)
  end do
endif
call ytp_tl( im,jm,fy,fy_tl,adx,adx_tl,cry,cry_tl,yfx,yfx_tl,ng,jord,0,jfirst,jlast )
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    wk1_tl(i) = (-0.5)*q_tm(i,jp+1)*va(i,j)+q_tm(i,j)+0.5*q_tm(i,jp)*va(i,j)+0.5*va_tl(i,j)*(q(i,jp)-q(i,jp+1))
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_tl( im,ffsl(j),fx(1,j),fx_tl(1,j),wk1,wk1_tl,crx(1,j),crx_tl(1,j),iord,xfx(1,j),xfx_tl(1,j),cosp(j),id,dm,dmh_tl,qtmp,&
&qtmph_tl,al,ar,a6,a6_tl )
end do

end subroutine tp2d_tl


subroutine tpcc_tl( va, va_tl, ymass, ymass_tl, q, q_tm, crx, crx_tl, cry, cry_tl, im, jm, ng, iord, jord, fx, fx_tl, fy, fy_tl, &
&ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6, a6_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: crx_tl(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: cry_tl(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
real(kind=r8) :: fy_tl(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_tl(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)
real(kind=r8) :: ymass_tl(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adx_tl(im,jfirst-1:jlast+2)
real(kind=r8) :: dmj_tl(-(im/3):im+im/3)
real(kind=r8) :: dmm_tl(-(im/3):im+im/3)
real(kind=r8) :: fx1(im)
real(kind=r8) :: fx1_tl(im)
integer :: i
integer :: im2
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qtmpj_tl(-(im/3):im+im/3)
real(kind=r8) :: qtmpm_tl(-(im/3):im+im/3)
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_tl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  call xtp_tl( im,ffsl(j),wk1,wk1_tl,q(1,j),q_tm(1,j),crx(1,j),crx_tl(1,j),1,crx(1,j),crx_tl(1,j),cose(j),0,dm,dmm_tl,qtmp,&
&qtmpm_tl,al,ar,a6,a6_tl )
  do i = 1, im-1
    adx_tl(i,j) = 0.5*crx_tl(i+1,j)*q(i,j)-0.5*crx_tl(i,j)*q(i,j)+q_tm(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))-0.5*wk1_tl(i+1)+0.5*&
&wk1_tl(i)
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx_tl(im,j) = (-(0.5*crx_tl(im,j)*q(im,j)))+0.5*crx_tl(1,j)*q(im,j)+q_tm(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))+0.5*wk1_tl(im)-0.5*&
&wk1_tl(1)
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc_tl( im,jm,fy,fy_tl,adx,adx_tl,cry,cry_tl,ymass,ymass_tl,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q_tm(i,1) = q_tm(i+im2,2)
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q_tm(i,1) = q_tm(i-im2,2)
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1_tl(i) = q_tm(i+im2,jm)
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1_tl(i) = q_tm(i-im2,jm)
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx_tl(i,jm) = 0.5*q_tm(i,jm-1)*va(i,jm)+q_tm(i,jm)*(1+(-0.5)*va(i,jm))+0.5*va_tl(i,jm)*(q(i,jm-1)-q(i,jm))
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx_tl(i,jm) = (-0.5)*fx1_tl(i)*va(i,jm)+q_tm(i,jm)*(1+0.5*va(i,jm))+0.5*va_tl(i,jm)*(q(i,jm)-fx1(i))
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx_tl(i,j) = (-0.5)*q_tm(i,jp+1)*va(i,j)+q_tm(i,j)+0.5*q_tm(i,jp)*va(i,j)+0.5*va_tl(i,j)*(q(i,jp)-q(i,jp+1))
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  call xtp_tl( im,ffsl(j),fx(1,j),fx_tl(1,j),adx(1,j),adx_tl(1,j),crx(1,j),crx_tl(1,j),iord,crx(1,j),crx_tl(1,j),cose(j),0,dm,&
&dmj_tl,qtmp,qtmpj_tl,al,ar,a6,a6_tl )
end do

end subroutine tpcc_tl


subroutine xmist_tl( im, q, q_tm, dm, dm_tl, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_tm(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dml
double precision :: dmm
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxj
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qminj

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm_tl(i) = q_tm(i-2)*r24-8*q_tm(i-1)*r24-q_tm(i+2)*r24+8*q_tm(i+1)*r24
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm_tl(i) = (-0.25)*q_tm(i-1)+0.25*q_tm(i+1)
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmaxj = max(q(i-1),q(i))
    qmax_tl = (-q_tm(i))+q_tm(i+1)*(0.5-sign(0.5d0,qmaxj-q(i+1)))+(q_tm(i-1)*(0.5+sign(0.5d0,q(i-1)-q(i)))+q_tm(i)*(0.5-sign(0.5d0,&
&q(i-1)-q(i))))*(0.5+sign(0.5d0,qmaxj-q(i+1)))
    qmax = max(qmaxj,q(i+1))-q(i)
    qminj = min(q(i-1),q(i))
    qmin_tl = q_tm(i)-(q_tm(i+1)*(0.5-sign(0.5d0,q(i+1)-qminj))+(q_tm(i-1)*(0.5+sign(0.5d0,q(i)-q(i-1)))+q_tm(i)*(0.5-sign(0.5d0,&
&q(i)-q(i-1))))*(0.5+sign(0.5d0,q(i+1)-qminj)))
    qmin = q(i)-min(qminj,q(i+1))
    dml = min(abs(dm(i)),qmax)
    dmm = min(dml,qmin)
    dm_tl(i) = ((dm_tl(i)*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))+qmax_tl*(0.5-sign(0.5d0,qmax-abs(dm(i)))))*(0.5+&
&sign(0.5d0,qmin-dml))+qmin_tl*(0.5-sign(0.5d0,qmin-dml)))*sign(1.d0,dmm)*sign(1.d0,dm(i))
    dm(i) = sign(dmm,dm(i))
  end do
endif

end subroutine xmist_tl


subroutine xtp_tl( im, ffsl, fx, fx_tl, q, q_tm, c, c_tl, iord, mfx, mfx_tl, cosa, id, dm, dm_tl, qtmp, qtmp_tl, al, ar, a6, a6_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_tl(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_tl(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_tl(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_tm(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_tl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh_tl(-(im/3):im+im/3)
real(kind=r8) :: ali_tl(-(im/3):im+im/3)
real(kind=r8) :: arh_tl(-(im/3):im+im/3)
real(kind=r8) :: ari_tl(-(im/3):im+im/3)
double precision :: dmj
double precision :: dmk
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxi
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qmini
real(kind=r8) :: rut
real(kind=r8) :: rut_tl
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp_tl(i) = q_tm(i)
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp_tl(i) = q_tm(im+i)
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp_tl(i) = q_tm(i-im)
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
      fx_tl(i) = c_tl(i)*qtmp(itmp)+qtmp_tl(itmp)*(c(i)-iu)
      fx(i) = (c(i)-iu)*qtmp(itmp)
    end do
  else
    do i = 1, im
      tmp_tl = (-0.25)*qtmp_tl(i-1)+0.25*qtmp_tl(i+1)
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmaxi = max(qtmp(i-1),qtmp(i))
      qmax_tl = (qtmp_tl(i-1)*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))+qtmp_tl(i)*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i))))*(0.5+sign(0.5d0,&
&qmaxi-qtmp(i+1)))+qtmp_tl(i+1)*(0.5-sign(0.5d0,qmaxi-qtmp(i+1)))-qtmp_tl(i)
      qmax = max(qmaxi,qtmp(i+1))-qtmp(i)
      qmini = min(qtmp(i-1),qtmp(i))
      qmin_tl = (-((qtmp_tl(i-1)*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))+qtmp_tl(i)*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1))))*(0.5+&
&sign(0.5d0,qtmp(i+1)-qmini))+qtmp_tl(i+1)*(0.5-sign(0.5d0,qtmp(i+1)-qmini))))+qtmp_tl(i)
      qmin = qtmp(i)-min(qmini,qtmp(i+1))
      dmj = min(abs(tmp),qmax)
      dmk = min(dmj,qmin)
      dm_tl(i) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+sign(0.5d0,&
&qmin-dmj))+qmin_tl*(0.5-sign(0.5d0,qmin-dmj)))*sign(1.d0,dmk)*sign(1.d0,tmp)
      dm(i) = sign(dmk,tmp)
    end do
    do i = iuw, 0
      dm_tl(i) = dm_tl(im+i)
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm_tl(i) = dm_tl(i-im)
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_tl( im,c,c_tl,mfx,mfx_tl,qtmp,qtmp_tl,dm,dm_tl,fx,fx_tl,iord,al,ali_tl,ar,ari_tl,a6,a6_tl,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        rut_tl = c_tl(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
          fx_tl(i) = (-(dm_tl(itmp)*rut*(1+rut)))+qtmp_tl(itmp)*rut+rut_tl*((-(rut*dm(itmp)))+qtmp(itmp)-dm(itmp)*(1.+rut))
          fx(i) = rut*(qtmp(itmp)-dm(itmp)*(1.+rut))
        else
          itmp = i-iu-1
          isave(i) = itmp+1
          fx_tl(i) = dm_tl(itmp)*rut*(1.-rut)+qtmp_tl(itmp)*rut+rut_tl*((-(rut*dm(itmp)))+qtmp(itmp)+dm(itmp)*(1.-rut))
          fx(i) = rut*(qtmp(itmp)+dm(itmp)*(1.-rut))
        endif
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        fx_tl(i) = fx_tl(i)+qtmp_tl(ist)
        fx(i) = fx(i)+qtmp(ist)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        fx_tl(i) = fx_tl(i)-qtmp_tl(ist)
        fx(i) = fx(i)-qtmp(ist)
      end do
    endif
  end do
  if (id .ne. 0) then
    do i = 1, im
      fx_tl(i) = fx_tl(i)*mfx(i)+mfx_tl(i)*fx(i)
      fx(i) = fx(i)*mfx(i)
    end do
  endif
else
  qtmp_tl(imp) = q_tm(1)
  qtmp(imp) = q(1)
  qtmp_tl(0) = q_tm(im)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = float(i)-c(i)
      fx_tl(i) = mfx_tl(i)*qtmp(iu)+qtmp_tl(iu)*mfx(i)
      fx(i) = mfx(i)*qtmp(iu)
    end do
  else
    qtmp_tl(-1) = q_tm(im-1)
    qtmp(-1) = q(im-1)
    qtmp_tl(imp+1) = q_tm(2)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_tl( im,qtmp,qtmp_tl,dm,dm_tl,2 )
    else
      call xmist_tl( im,qtmp,qtmp_tl,dm,dm_tl,iord )
    endif
    dm_tl(0) = dm_tl(im)
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      do i = 1, im
        iu = float(i)-c(i)
        fx_tl(i) = (-(c_tl(i)*mfx(i)*dm(iu)))+dm_tl(iu)*mfx(i)*(sign(1.d0,c(i))-c(i))+mfx_tl(i)*(qtmp(iu)+dm(iu)*(sign(1.d0,c(i))-&
&c(i)))+qtmp_tl(iu)*mfx(i)
        fx(i) = mfx(i)*(qtmp(iu)+dm(iu)*(sign(1._8,c(i))-c(i)))
      end do
    else
      call fxppm_tl( im,c,c_tl,mfx,mfx_tl,qtmp,qtmp_tl,dm,dm_tl,fx,fx_tl,iord,al,alh_tl,ar,arh_tl,a6,a6_tl,iuw,iue,ffsl,isave )
    endif
  endif
endif

end subroutine xtp_tl


subroutine ycc_tl( im, jm, fy, fy_tl, q, q_tm, vc, vc_tl, ymass, ymass_tl, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: iv
integer :: jfirst
integer :: jlast
real(kind=r8) :: fy(im,jfirst-iv:jlast)
real(kind=r8) :: fy_tl(im,jfirst-iv:jlast)
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: q_tm(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: vc(im,jfirst-iv:jlast)
real(kind=r8) :: vc_tl(im,jfirst-iv:jlast)
real(kind=r8) :: ymass(im,jfirst-iv:jlast)
real(kind=r8) :: ymass_tl(im,jfirst-iv:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dc(im,jfirst-iv:jlast+1)
real(kind=r8) :: dc_tl(im,jfirst-iv:jlast+1)
double precision :: dcp
double precision :: dcq
integer :: i
integer :: im2
integer :: j
integer :: jn2g0
integer :: jn2g1
integer :: js2giv
integer :: js3giv
integer :: jt
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxl
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qminl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
js2giv = max(2,jfirst-iv)
js3giv = max(3,jfirst-iv)
jn2g1 = min(jm-1,jlast+1)
jn2g0 = min(jm-1,jlast)
if (jord .eq. 1) then
  do j = js2giv, jn2g0
    do i = 1, im
      jt = float(j+1)-vc(i,j)
      fy_tl(i,j) = q_tm(i,jt)*ymass(i,j)+ymass_tl(i,j)*q(i,jt)
      fy(i,j) = q(i,jt)*ymass(i,j)
    end do
  end do
else
  do j = js3giv, jn2g1
    do i = 1, im
      dc_tl(i,j) = (-0.25)*q_tm(i,j-1)+0.25*q_tm(i,j+1)
      dc(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
    end do
  end do
  if (iv .eq. 0) then
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc_tl(i,2) = 0.25*q_tm(i,3)-0.25*q_tm(i+im2,2)
        dc(i,2) = 0.25*(q(i,3)-q(i+im2,2))
      end do
      do i = im2+1, im
        dc_tl(i,2) = 0.25*q_tm(i,3)-0.25*q_tm(i-im2,2)
        dc(i,2) = 0.25*(q(i,3)-q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)+0.25*q_tm(i+im2,jm)
        dc(i,jm) = 0.25*(q(i+im2,jm)-q(i,jm-1))
      end do
      do i = im2+1, im
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)+0.25*q_tm(i-im2,jm)
        dc(i,jm) = 0.25*(q(i-im2,jm)-q(i,jm-1))
      end do
    endif
  else
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc_tl(i,2) = 0.25*q_tm(i,3)+0.25*q_tm(i+im2,2)
        dc(i,2) = 0.25*(q(i,3)+q(i+im2,2))
      end do
      do i = im2+1, im
        dc_tl(i,2) = 0.25*q_tm(i,3)+0.25*q_tm(i-im2,2)
        dc(i,2) = 0.25*(q(i,3)+q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)-0.25*q_tm(i+im2,jm)
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i+im2,jm)))
      end do
      do i = im2+1, im
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)-0.25*q_tm(i-im2,jm)
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i-im2,jm)))
      end do
    endif
  endif
  if (jord .gt. 0) then
    do j = js3giv, jn2g1
      do i = 1, im
        qmaxl = max(q(i,j-1),q(i,j))
        qmax_tl = (-q_tm(i,j))+q_tm(i,j+1)*(0.5-sign(0.5d0,qmaxl-q(i,j+1)))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))+q_tm(i,&
&j)*(0.5-sign(0.5d0,q(i,j-1)-q(i,j))))*(0.5+sign(0.5d0,qmaxl-q(i,j+1)))
        qmax = max(qmaxl,q(i,j+1))-q(i,j)
        qminl = min(q(i,j-1),q(i,j))
        qmin_tl = q_tm(i,j)-(q_tm(i,j+1)*(0.5-sign(0.5d0,q(i,j+1)-qminl))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))+q_tm(i,j)*&
&(0.5-sign(0.5d0,q(i,j)-q(i,j-1))))*(0.5+sign(0.5d0,q(i,j+1)-qminl)))
        qmin = q(i,j)-min(qminl,q(i,j+1))
        dcp = min(abs(dc(i,j)),qmin)
        dcq = min(dcp,qmax)
        dc_tl(i,j) = ((dc_tl(i,j)*(0.5+sign(0.5d0,qmin-abs(dc(i,j))))*sign(1.d0,dc(i,j))+qmin_tl*(0.5-sign(0.5d0,qmin-abs(dc(i,j)))&
&))*(0.5+sign(0.5d0,qmax-dcp))+qmax_tl*(0.5-sign(0.5d0,qmax-dcp)))*sign(1.d0,dcq)*sign(1.d0,dc(i,j))
        dc(i,j) = sign(dcq,dc(i,j))
      end do
    end do
    if (jfirst .eq. 1) then
      do i = 1, im
        dc_tl(i,2) = 0.d0
        dc(i,2) = 0.
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im
        dc_tl(i,jm) = 0.d0
        dc(i,jm) = 0.
      end do
    endif
  endif
  do j = js2giv, jn2g0
    do i = 1, im
      jt = float(j+1)-vc(i,j)
      fy_tl(i,j) = dc_tl(i,jt)*(sign(1.d0,vc(i,j))-vc(i,j))*ymass(i,j)+q_tm(i,jt)*ymass(i,j)-vc_tl(i,j)*dc(i,jt)*ymass(i,j)+&
&ymass_tl(i,j)*(q(i,jt)+(sign(1.d0,vc(i,j))-vc(i,j))*dc(i,jt))
      fy(i,j) = (q(i,jt)+(sign(1._8,vc(i,j))-vc(i,j))*dc(i,jt))*ymass(i,j)
    end do
  end do
endif

end subroutine ycc_tl


subroutine ymist_tl( im, jm, q, q_tm, dm, dm_tl, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tl(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dmt
double precision :: dmu
double precision :: dmz
double precision :: dmza
double precision :: dmzd
double precision :: dmze
double precision :: dmzj
double precision :: dmzk
double precision :: dmzn
double precision :: dmzo
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxn
double precision :: qmaxq
double precision :: qmaxs
double precision :: qmaxv
double precision :: qmaxx
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qminn
double precision :: qminq
double precision :: qmins
double precision :: qminv
double precision :: qminx
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm_tl(i,j) = (-0.25)*q_tm(i,j-1)+0.25*q_tm(i,j+1)
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_tl = (-0.25)*q_tm(i+im2,2)+0.25*q_tm(i,2)
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmaxx = max(q(i,2),q(i,1))
      qmax_tl = (-q_tm(i,1))+q_tm(i+im2,2)*(0.5-sign(0.5d0,qmaxx-q(i+im2,2)))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+q_tm(i,1)*&
&(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxx-q(i+im2,2)))
      qmax = max(qmaxx,q(i+im2,2))-q(i,1)
      qminx = min(q(i,2),q(i,1))
      qmin_tl = q_tm(i,1)-(q_tm(i+im2,2)*(0.5-sign(0.5d0,q(i+im2,2)-qminx))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+q_tm(i,1)*&
&(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,q(i+im2,2)-qminx)))
      qmin = q(i,1)-min(qminx,q(i+im2,2))
      dmzn = min(abs(tmp),qmax)
      dmzo = min(dmzn,qmin)
      dm_tl(i,1) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmzn))+qmin_tl*(0.5-sign(0.5d0,qmin-dmzn)))*sign(1.d0,dmzo)*sign(1.d0,tmp)
      dm(i,1) = sign(dmzo,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,1) = -dm_tl(i-im2,1)
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_tl = 0.25*q_tm(i+im2,jm1)-0.25*q_tm(i,jm1)
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmaxv = max(q(i+im2,jm1),q(i,jm))
      qmax_tl = (-q_tm(i,jm))+q_tm(i,jm1)*(0.5-sign(0.5d0,qmaxv-q(i,jm1)))+(q_tm(i,jm)*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))+&
&q_tm(i+im2,jm1)*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm))))*(0.5+sign(0.5d0,qmaxv-q(i,jm1)))
      qmax = max(qmaxv,q(i,jm1))-q(i,jm)
      qminv = min(q(i+im2,jm1),q(i,jm))
      qmin_tl = q_tm(i,jm)-(q_tm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qminv))+(q_tm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))+q_tm(i+&
&im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1))))*(0.5+sign(0.5d0,q(i,jm1)-qminv)))
      qmin = q(i,jm)-min(qminv,q(i,jm1))
      dmzj = min(abs(tmp),qmax)
      dmzk = min(dmzj,qmin)
      dm_tl(i,jm) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmzj))+qmin_tl*(0.5-sign(0.5d0,qmin-dmzj)))*sign(1.d0,dmzk)*sign(1.d0,tmp)
      dm(i,jm) = sign(dmzk,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,jm) = -dm_tl(i-im2,jm)
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_tl = 0.25*q_tm(i+im2,2)+0.25*q_tm(i,2)
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmaxs = max(q(i,2),q(i,1))
      qmax_tl = (-q_tm(i,1))-q_tm(i+im2,2)*(0.5-sign(0.5d0,qmaxs-(-q(i+im2,2))))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+q_tm(i,&
&1)*(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxs-(-q(i+im2,2))))
      qmax = max(qmaxs,-q(i+im2,2))-q(i,1)
      qmins = min(q(i,2),q(i,1))
      qmin_tl = q_tm(i,1)-((-(q_tm(i+im2,2)*(0.5-sign(0.5d0,(-q(i+im2,2))-qmins))))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+&
&q_tm(i,1)*(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,(-q(i+im2,2))-qmins)))
      qmin = q(i,1)-min(qmins,-q(i+im2,2))
      dmzd = min(abs(tmp),qmax)
      dmze = min(dmzd,qmin)
      dm_tl(i,1) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmzd))+qmin_tl*(0.5-sign(0.5d0,qmin-dmzd)))*sign(1.d0,dmze)*sign(1.d0,tmp)
      dm(i,1) = sign(dmze,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,1) = dm_tl(i-im2,1)
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_tl = (-0.25)*q_tm(i+im2,jm1)-0.25*q_tm(i,jm1)
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmaxq = max(-q(i+im2,jm1),q(i,jm))
      qmax_tl = (-q_tm(i,jm))+q_tm(i,jm1)*(0.5-sign(0.5d0,qmaxq-q(i,jm1)))+(q_tm(i,jm)*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))-&
&q_tm(i+im2,jm1)*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm))))*(0.5+sign(0.5d0,qmaxq-q(i,jm1)))
      qmax = max(qmaxq,q(i,jm1))-q(i,jm)
      qminq = min(-q(i+im2,jm1),q(i,jm))
      qmin_tl = q_tm(i,jm)-(q_tm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qminq))+(q_tm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))-&
&q_tm(i+im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1)))))*(0.5+sign(0.5d0,q(i,jm1)-qminq)))
      qmin = q(i,jm)-min(qminq,q(i,jm1))
      dmz = min(abs(tmp),qmax)
      dmza = min(dmz,qmin)
      dm_tl(i,jm) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmz))+qmin_tl*(0.5-sign(0.5d0,qmin-dmz)))*sign(1.d0,dmza)*sign(1.d0,tmp)
      dm(i,jm) = sign(dmza,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,jm) = dm_tl(i-im2,jm)
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    do i = 1, im
      qmaxn = max(q(i,j-1),q(i,j))
      qmax_tl = (-q_tm(i,j))+q_tm(i,j+1)*(0.5-sign(0.5d0,qmaxn-q(i,j+1)))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))+q_tm(i,j)*&
&(0.5-sign(0.5d0,q(i,j-1)-q(i,j))))*(0.5+sign(0.5d0,qmaxn-q(i,j+1)))
      qmax = max(qmaxn,q(i,j+1))-q(i,j)
      qminn = min(q(i,j-1),q(i,j))
      qmin_tl = q_tm(i,j)-(q_tm(i,j+1)*(0.5-sign(0.5d0,q(i,j+1)-qminn))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))+q_tm(i,j)*&
&(0.5-sign(0.5d0,q(i,j)-q(i,j-1))))*(0.5+sign(0.5d0,q(i,j+1)-qminn)))
      qmin = q(i,j)-min(qminn,q(i,j+1))
      dmt = min(abs(dm(i,j)),qmin)
      dmu = min(dmt,qmax)
      dm_tl(i,j) = ((dm_tl(i,j)*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))+qmin_tl*(0.5-sign(0.5d0,qmin-abs(dm(i,j)))))&
&*(0.5+sign(0.5d0,qmax-dmt))+qmax_tl*(0.5-sign(0.5d0,qmax-dmt)))*sign(1.d0,dmu)*sign(1.d0,dm(i,j))
      dm(i,j) = sign(dmu,dm(i,j))
    end do
  end do
endif

end subroutine ymist_tl


subroutine ytp_tl( im, jm, fy, fy_tl, q, q_tm, c, c_tl, yfx, yfx_tl, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_tl(im,jfirst:jlast+1)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tl(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      fy_tl(i,j) = q_tm(i,jt)
      fy(i,j) = q(i,jt)
    end do
  end do
else
  call ymist_tl( im,jm,q,q_tm,dm,dm_tl,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm_tl( c,c_tl,q,q_tm,dm,dm_tl,fy,fy_tl,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        fy_tl(i,j) = (-(c_tl(i,j)*dm(i,jt)))+dm_tl(i,jt)*(sign(1.d0,c(i,j))-c(i,j))+q_tm(i,jt)
        fy(i,j) = q(i,jt)+(sign(1._8,c(i,j))-c(i,j))*dm(i,jt)
      end do
    end do
  endif
endif
do j = js2g0, jn1g1
  do i = 1, im
    fy_tl(i,j) = fy_tl(i,j)*yfx(i,j)+yfx_tl(i,j)*fy(i,j)
    fy(i,j) = fy(i,j)*yfx(i,j)
  end do
end do

end subroutine ytp_tl


end module     tp_core_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tp_core_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_tl( im, c, c_tl, mfx, mfx_tl, p, p_tl, dm, dm_tl, fx, fx_tl, iord, al, al_tl, ar, ar_tl, a6, a6_tl, iuw, iue, &
&ffsl, isave )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_tl(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_tl(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_tl(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_tl(im)
integer :: iord
integer :: isave(im)
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_tl(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
real(kind=r8) :: ru_tl
logical :: steep

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al_tl(i) = dm_tl(i-1)*r3-dm_tl(i)*r3+0.5*p_tl(i-1)+0.5*p_tl(i)
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx_tl( im,p,p_tl,al(1),al_tl(1),dm,dm_tl )
endif
do i = 1, im-1
  ar_tl(i) = al_tl(i+1)
  ar(i) = al(i+1)
end do
ar_tl(im) = al_tl(1)
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh_tl( im,ar(1),ar_tl(1),al(1),al_tl(1),p(1),p_tl(1),a6(1),a6_tl(1),dm(1),dm_tl(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6_tl(i) = (-3)*al_tl(i)-3*ar_tl(i)+6*p_tl(i)
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm_tl( dm(1),dm_tl(1),a6(1),a6_tl(1),ar(1),ar_tl(1),al(1),al_tl(1),p(1),p_tl(1),im,lmt )
endif
if (ffsl) then
  do i = iuw, 0
    al_tl(i) = al_tl(im+i)
    al(i) = al(im+i)
    ar_tl(i) = ar_tl(im+i)
    ar(i) = ar(im+i)
    a6_tl(i) = a6_tl(im+i)
    a6(i) = a6(im+i)
  end do
  do i = im+1, iue
    al_tl(i) = al_tl(i-im)
    al(i) = al(i-im)
    ar_tl(i) = ar_tl(i-im)
    ar(i) = ar(i-im)
    a6_tl(i) = a6_tl(i-im)
    a6(i) = a6(i-im)
  end do
  do i = 1, im
    iu = c(i)
    ru_tl = c_tl(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      isave(i) = itmp+1
      fx_tl(i) = 0.5*a6_tl(itmp)*ru*ru*(1.-r23*ru)+0.5*al_tl(itmp)*ru*ru+ar_tl(itmp)*ru*(1+(-0.5)*ru)+ru_tl*(ru*((-(0.5*ru*a6(itmp)&
&*r23))+0.5*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))+ar(itmp)+0.5*ru*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))
      fx(i) = ru*(ar(itmp)+0.5*ru*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))
    else
      itmp = i-iu
      isave(i) = itmp-1
      fx_tl(i) = (-(0.5*a6_tl(itmp)*ru*ru*(1+r23*ru)))+al_tl(itmp)*ru*(1-(-0.5)*ru)-0.5*ar_tl(itmp)*ru*ru+ru_tl*((-(ru*(0.5*ru*&
&a6(itmp)*r23+0.5*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))))+al(itmp)-0.5*ru*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))
      fx(i) = ru*(al(itmp)-0.5*ru*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))
    endif
  end do
else
  al_tl(0) = al_tl(im)
  al(0) = al(im)
  ar_tl(0) = ar_tl(im)
  ar(0) = ar(im)
  a6_tl(0) = a6_tl(im)
  a6(0) = a6(im)
  do i = 1, im
    if (c(i) .gt. 0.) then
      fx_tl(i) = 0.5*a6_tl(i-1)*c(i)*(1.-r23*c(i))+0.5*al_tl(i-1)*c(i)+ar_tl(i-1)*(1+(-0.5)*c(i))+c_tl(i)*((-(0.5*c(i)*a6(i-1)*r23)&
&)+0.5*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i))))
      fx(i) = ar(i-1)+0.5*c(i)*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i)))
    else
      fx_tl(i) = (-(0.5*a6_tl(i)*c(i)*(1+r23*c(i))))+al_tl(i)*(1-(-0.5)*c(i))-0.5*ar_tl(i)*c(i)-c_tl(i)*(0.5*c(i)*a6(i)*r23+0.5*&
&(ar(i)-al(i)+a6(i)*(1.+r23*c(i))))
      fx(i) = al(i)-0.5*c(i)*(ar(i)-al(i)+a6(i)*(1.+r23*c(i)))
    endif
    fx_tl(i) = fx_tl(i)*mfx(i)+mfx_tl(i)*fx(i)
    fx(i) = mfx(i)*fx(i)
  end do
endif

end subroutine fxppm_tl


subroutine fyppm_tl( c, c_tl, q, q_tm, dm, dm_tl, flux, flux_tl, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_tl(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux(im,jfirst:jlast+1)
real(kind=r8) :: flux_tl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_tl(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_tl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al_tl(i,j) = dm_tl(i,j-1)*r3-dm_tl(i,j)*r3+0.5*q_tm(i,j-1)+0.5*q_tm(i,j)
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar_tl(i,j) = al_tl(i,j+1)
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tl(i,1) = al_tl(i+imh,2)
      al(i,1) = al(i+imh,2)
      al_tl(i+imh,1) = al_tl(i,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_tl(i,jm) = ar_tl(i+imh,jm1)
      ar(i,jm) = ar(i+imh,jm1)
      ar_tl(i+imh,jm) = ar_tl(i,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tl(i,1) = -al_tl(i+imh,2)
      al(i,1) = -al(i+imh,2)
      al_tl(i+imh,1) = -al_tl(i,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_tl(i,jm) = -ar_tl(i+imh,jm1)
      ar(i,jm) = -ar(i+imh,jm1)
      ar_tl(i+imh,jm) = -ar_tl(i,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6_tl(i,j) = (-3)*al_tl(i,j)-3*ar_tl(i,j)+6*q_tm(i,j)
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
call lmppm_tl( dm(1,js1g1),dm_tl(1,js1g1),a6(1,js1g1),a6_tl(1,js1g1),ar(1,js1g1),ar_tl(1,js1g1),al(1,js1g1),al_tl(1,js1g1),q(1,&
&js1g1),q_tm(1,js1g1),help_h,lmt )
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      flux_tl(i,j) = 0.5*a6_tl(i,j-1)*c(i,j)*(1.-r23*c(i,j))+0.5*al_tl(i,j-1)*c(i,j)+ar_tl(i,j-1)*(1+(-0.5)*c(i,j))+c_tl(i,j)*((-&
&(0.5*c(i,j)*a6(i,j-1)*r23))+0.5*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j))))
      flux(i,j) = ar(i,j-1)+0.5*c(i,j)*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j)))
    else
      flux_tl(i,j) = (-(0.5*a6_tl(i,j)*c(i,j)*(1+r23*c(i,j))))+al_tl(i,j)*(1-(-0.5)*c(i,j))-0.5*ar_tl(i,j)*c(i,j)-c_tl(i,j)*(0.5*&
&c(i,j)*a6(i,j)*r23+0.5*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j))))
      flux(i,j) = al(i,j)-0.5*c(i,j)*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j)))
    endif
  end do
end do

end subroutine fyppm_tl


subroutine huynh_tl( im, ar, ar_tl, al, al_tl, p, p_tl, d2, d2_tl, d1, d1_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_tl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tl(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_tl(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_tl(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_tl(im)

!==============================================
! declare local variables
!==============================================
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_tl
real(kind=r8) :: pmax
real(kind=r8) :: pmax_tl
real(kind=r8) :: pmin
real(kind=r8) :: pmin_tl
real(kind=r8) :: pmp
real(kind=r8) :: pmp_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
d1_tl(1) = (-p_tl(im))+p_tl(1)
d1(1) = p(1)-p(im)
do i = 2, im
  d1_tl(i) = (-p_tl(i-1))+p_tl(i)
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2_tl(i) = d1_tl(i+1)-d1_tl(i)
  d2(i) = d1(i+1)-d1(i)
end do
d2_tl(im) = (-d1_tl(im))+d1_tl(1)
d2(im) = d1(1)-d1(im)
pmp_tl = 2*d1_tl(1)+p_tl(1)
pmp = p(1)+2.*d1(1)
lac_tl = 0.5*d1_tl(1)+1.5*d2_tl(im)+p_tl(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin_tl = p_tl(1)*(0.5+sign(0.5d0,pmp-p(1)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(1)))
pmin = min(p(1),pmp,lac)
pmax_tl = p_tl(1)*(0.5+sign(0.5d0,p(1)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(1)-pmp))
pmax = max(p(1),pmp,lac)
ar_tl(1) = ar_tl(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(ar(1),pmin)-&
&pmax))+pmin_tl*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar(1) = min(pmax,max(ar(1),pmin))
do i = 2, im
  pmp_tl = 2*d1_tl(i)+p_tl(i)
  pmp = p(i)+2.*d1(i)
  lac_tl = 0.5*d1_tl(i)+1.5*d2_tl(i-1)+p_tl(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin_tl = p_tl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_tl = p_tl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  ar_tl(i) = ar_tl(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(ar(i),pmin)-&
&pmax))+pmin_tl*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar(i) = min(pmax,max(ar(i),pmin))
end do
do i = 1, im-1
  pmp_tl = (-2)*d1_tl(i+1)+p_tl(i)
  pmp = p(i)-2.*d1(i+1)
  lac_tl = (-0.5)*d1_tl(i+1)+1.5*d2_tl(i+1)+p_tl(i)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin_tl = p_tl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_tl = p_tl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  al_tl(i) = al_tl(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(al(i),pmin)-&
&pmax))+pmin_tl*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp_tl = (-2)*d1_tl(1)+p_tl(im)
pmp = p(im)-2.*d1(1)
lac_tl = (-0.5)*d1_tl(1)+1.5*d2_tl(1)+p_tl(im)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin_tl = p_tl(im)*(0.5+sign(0.5d0,pmp-p(im)))+pmp_tl*(0.5-sign(0.5d0,pmp-p(im)))
pmin = min(p(im),pmp,lac)
pmax_tl = p_tl(im)*(0.5+sign(0.5d0,p(im)-pmp))+pmp_tl*(0.5-sign(0.5d0,p(im)-pmp))
pmax = max(p(im),pmp,lac)
al_tl(im) = al_tl(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))+pmax_tl*(0.5+sign(0.5d0,max(al(im),&
&pmin)-pmax))+pmin_tl*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al(im) = min(pmax,max(al(im),pmin))
do i = 1, im
  d2_tl(i) = (-3)*al_tl(i)-3*ar_tl(i)+6*p_tl(i)
  d2(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
end do

end subroutine huynh_tl


subroutine lmppm_tl( dm, dm_tl, a6, a6_tl, ar, ar_tl, al, al_tl, p, p_tl, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_tl(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_tl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tl(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_tl(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_tl(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_tl
real(kind=r8) :: da1
real(kind=r8) :: da1_tl
real(kind=r8) :: da2
real(kind=r8) :: da2_tl
real(kind=r8) :: dl
real(kind=r8) :: dl_tl
real(kind=r8) :: dr
real(kind=r8) :: dr_tl
real(kind=r8) :: fmin
real(kind=r8) :: fmin_tl
integer :: i

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    if (dm(i) .eq. 0.) then
      ar_tl(i) = p_tl(i)
      ar(i) = p(i)
      al_tl(i) = p_tl(i)
      al(i) = p(i)
      a6_tl(i) = 0.d0
      a6(i) = 0.
    else
      da1_tl = (-al_tl(i))+ar_tl(i)
      da1 = ar(i)-al(i)
      da2_tl = 2*da1_tl*da1
      da2 = da1**2
      a6da_tl = a6_tl(i)*da1+da1_tl*a6(i)
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_tl(i) = 3*al_tl(i)-3*p_tl(i)
        a6(i) = 3.*(al(i)-p(i))
        ar_tl(i) = (-a6_tl(i))+al_tl(i)
        ar(i) = al(i)-a6(i)
      else if (a6da .gt. da2) then
        a6_tl(i) = 3*ar_tl(i)-3*p_tl(i)
        a6(i) = 3.*(ar(i)-p(i))
        al_tl(i) = (-a6_tl(i))+ar_tl(i)
        al(i) = ar(i)-a6(i)
      endif
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_tl = 2*dm_tl(i)
      da1 = dm(i)+dm(i)
      dl_tl = (al_tl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_tl(i)*(0.5-sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
      dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
      dr_tl = (ar_tl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_tl(i)*(0.5-sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
      dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
      ar_tl(i) = dr_tl+p_tl(i)
      ar(i) = p(i)+dr
      al_tl(i) = (-dl_tl)+p_tl(i)
      al(i) = p(i)-dl
      a6_tl(i) = 3*dl_tl-3*dr_tl
      a6(i) = 3.*(dl-dr)
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin_tl = a6_tl(i)*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)+al_tl(i)*((-0.5)*(ar(i)-al(i))/a6(i))+ar_tl(i)*(0.5*&
&(ar(i)-al(i))/a6(i))+p_tl(i)
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar_tl(i) = p_tl(i)
              ar(i) = p(i)
              al_tl(i) = p_tl(i)
              al(i) = p(i)
              a6_tl(i) = 0.d0
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6_tl(i) = 3*al_tl(i)-3*p_tl(i)
              a6(i) = 3.*(al(i)-p(i))
              ar_tl(i) = (-a6_tl(i))+al_tl(i)
              ar(i) = al(i)-a6(i)
            else
              a6_tl(i) = 3*ar_tl(i)-3*p_tl(i)
              a6(i) = 3.*(ar(i)-p(i))
              al_tl(i) = (-a6_tl(i))+ar_tl(i)
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_tl = 4*dm_tl(i)
          da1 = 4.*dm(i)
          dl_tl = (al_tl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_tl(i)*(0.5-&
&sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
          dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
          dr_tl = (ar_tl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_tl*(0.5+sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_tl(i)*(0.5-&
&sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
          dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
          ar_tl(i) = dr_tl+p_tl(i)
          ar(i) = p(i)+dr
          al_tl(i) = (-dl_tl)+p_tl(i)
          al(i) = p(i)-dl
          a6_tl(i) = 3*dl_tl-3*dr_tl
          a6(i) = 3.*(dl-dr)
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_tl


subroutine steepx_tl( im, p, p_tl, al, al_tl, dm, dm_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_tl(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb
real(kind=r8) :: bbb_tl
real(kind=r8) :: ccc
real(kind=r8) :: ccc_tl
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_tl(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_tl(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_tl(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do i = 0, im
  dh_tl(i) = p_tl(i+1)-p_tl(i)
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2_tl(i) = (-dh_tl(i-1))+dh_tl(i)
  d2(i) = dh(i)-dh(i-1)
end do
d2_tl(0) = d2_tl(im)
d2(0) = d2(im)
d2_tl(im+1) = d2_tl(1)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx_tl = (-(p_tl(i-2)*((-0.5)/(p(i+1)-p(i-1)))))+p_tl(i-1)*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))-p_tl(i+2)&
&*(0.5/(p(i+1)-p(i-1)))+p_tl(i+1)*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta_tl(i) = xxx_tl*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta_tl(i) = 0.d0
    eta(i) = 0.
  endif
end do
eta_tl(0) = eta_tl(im)
eta(0) = eta(im)
do i = 1, im
  bbb_tl = dm_tl(i-1)*(2.*eta(i)-eta(i-1))-eta_tl(i-1)*dm(i-1)+2*eta_tl(i)*dm(i-1)
  bbb = (2.*eta(i)-eta(i-1))*dm(i-1)
  ccc_tl = dm_tl(i)*(2.*eta(i-1)-eta(i))+2*eta_tl(i-1)*dm(i)-eta_tl(i)*dm(i)
  ccc = (2.*eta(i-1)-eta(i))*dm(i)
  al_tl(i) = al_tl(i)+bbb_tl*r3-ccc_tl*r3+0.5*dh_tl(i-1)*(eta(i-1)-eta(i))+0.5*eta_tl(i-1)*dh(i-1)-0.5*eta_tl(i)*dh(i-1)
  al(i) = al(i)+0.5*(eta(i-1)-eta(i))*dh(i-1)+(bbb-ccc)*r3
end do

end subroutine steepx_tl


subroutine tp2c_tl( dh, dh_tl, va, va_tl, h, h_tl, crx, crx_tl, cry, cry_tl, im, jm, iord, jord, ng, fx, fx_tl, fy, fy_tl, ffsl, &
&rcap, acosp, xfx, xfx_tl, yfx, yfx_tl, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst:jlast+1)
real(kind=r8) :: dh(im,jfirst:jlast)
real(kind=r8) :: dh_tl(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_tl(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_tl(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1
real(kind=r8) :: sum1_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call tp2d_tl( va,va_tl,h,h_tl,crx,crx_tl,cry,cry_tl,im,jm,iord,jord,ng,fx,fx_tl,fy,fy_tl,ffsl,xfx,xfx_tl,yfx,yfx_tl,cosp,id,jfirst,&
&jlast )
do j = js2g0, jn2g0
  do i = 1, im-1
    dh_tl(i,j) = (-fx_tl(i+1,j))+fx_tl(i,j)-fy_tl(i,j+1)*acosp(j)+fy_tl(i,j)*acosp(j)
    dh(i,j) = fx(i,j)-fx(i+1,j)+(fy(i,j)-fy(i,j+1))*acosp(j)
  end do
end do
do j = js2g0, jn2g0
  dh_tl(im,j) = fx_tl(im,j)-fx_tl(1,j)-fy_tl(im,j+1)*acosp(j)+fy_tl(im,j)*acosp(j)
  dh(im,j) = fx(im,j)-fx(1,j)+(fy(im,j)-fy(im,j+1))*acosp(j)
end do
if (jfirst .eq. 1) then
  sum1_tl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_tl = fy_tl(i,2)+sum1_tl
    sum1 = sum1+fy(i,2)
  end do
  sum1_tl = -(sum1_tl*rcap)
  sum1 = -(sum1*rcap)
  do i = 1, im
    dh_tl(i,1) = sum1_tl
    dh(i,1) = sum1
  end do
endif
if (jlast .eq. jm) then
  sum1_tl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_tl = fy_tl(i,jm)+sum1_tl
    sum1 = sum1+fy(i,jm)
  end do
  sum1_tl = sum1_tl*rcap
  sum1 = sum1*rcap
  do i = 1, im
    dh_tl(i,jm) = sum1_tl
    dh(i,jm) = sum1
  end do
endif

end subroutine tp2c_tl


subroutine tp2d_tl( va, va_tl, q, q_tm, crx, crx_tl, cry, cry_tl, im, jm, iord, jord, ng, fx, fx_tl, fy, fy_tl, ffsl, xfx, xfx_tl, &
&yfx, yfx_tl, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_tl(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_tl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_tl(1+im+2*(im/3))
real(kind=r8) :: dmk_tl(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_tl(1+im+2*(im/3))
real(kind=r8) :: qtmpk_tl(1+im+2*(im/3))
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_tl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
do j = js2gng, jn2gng
  call xtp_tl( im,ffsl(j),wk1,wk1_tl,q(1,j),q_tm(1,j),crx(1,j),crx_tl(1,j),iad,crx(1,j),crx_tl(1,j),cosp(j),0,dm,dmk_tl,qtmp,&
&qtmpk_tl,al,ar,a6,a6_tl )
  do i = 1, im-1
    adx_tl(i,j) = 0.5*crx_tl(i+1,j)*q(i,j)-0.5*crx_tl(i,j)*q(i,j)+q_tm(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))-0.5*wk1_tl(i+1)+0.5*&
&wk1_tl(i)
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx_tl(im,j) = (-(0.5*crx_tl(im,j)*q(im,j)))+0.5*crx_tl(1,j)*q(im,j)+q_tm(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))+0.5*wk1_tl(im)-0.5*&
&wk1_tl(1)
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx_tl(i,1) = q_tm(i,1)
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx_tl(i,jm) = q_tm(i,jm)
    adx(i,jm) = q(i,jm)
  end do
endif
call ytp_tl( im,jm,fy,fy_tl,adx,adx_tl,cry,cry_tl,yfx,yfx_tl,ng,jord,0,jfirst,jlast )
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    wk1_tl(i) = (-0.5)*q_tm(i,jp+1)*va(i,j)+q_tm(i,j)+0.5*q_tm(i,jp)*va(i,j)+0.5*va_tl(i,j)*(q(i,jp)-q(i,jp+1))
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_tl( im,ffsl(j),fx(1,j),fx_tl(1,j),wk1,wk1_tl,crx(1,j),crx_tl(1,j),iord,xfx(1,j),xfx_tl(1,j),cosp(j),id,dm,dmh_tl,qtmp,&
&qtmph_tl,al,ar,a6,a6_tl )
end do

end subroutine tp2d_tl


subroutine tpcc_tl( va, va_tl, ymass, ymass_tl, q, q_tm, crx, crx_tl, cry, cry_tl, im, jm, ng, iord, jord, fx, fx_tl, fy, fy_tl, &
&ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6, a6_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: crx_tl(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: cry_tl(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
real(kind=r8) :: fy_tl(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_tl(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)
real(kind=r8) :: ymass_tl(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adx_tl(im,jfirst-1:jlast+2)
real(kind=r8) :: dmj_tl(-(im/3):im+im/3)
real(kind=r8) :: dmm_tl(-(im/3):im+im/3)
real(kind=r8) :: fx1(im)
real(kind=r8) :: fx1_tl(im)
integer :: i
integer :: im2
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qtmpj_tl(-(im/3):im+im/3)
real(kind=r8) :: qtmpm_tl(-(im/3):im+im/3)
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_tl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  call xtp_tl( im,ffsl(j),wk1,wk1_tl,q(1,j),q_tm(1,j),crx(1,j),crx_tl(1,j),1,crx(1,j),crx_tl(1,j),cose(j),0,dm,dmm_tl,qtmp,&
&qtmpm_tl,al,ar,a6,a6_tl )
  do i = 1, im-1
    adx_tl(i,j) = 0.5*crx_tl(i+1,j)*q(i,j)-0.5*crx_tl(i,j)*q(i,j)+q_tm(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))-0.5*wk1_tl(i+1)+0.5*&
&wk1_tl(i)
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx_tl(im,j) = (-(0.5*crx_tl(im,j)*q(im,j)))+0.5*crx_tl(1,j)*q(im,j)+q_tm(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))+0.5*wk1_tl(im)-0.5*&
&wk1_tl(1)
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc_tl( im,jm,fy,fy_tl,adx,adx_tl,cry,cry_tl,ymass,ymass_tl,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q_tm(i,1) = q_tm(i+im2,2)
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q_tm(i,1) = q_tm(i-im2,2)
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1_tl(i) = q_tm(i+im2,jm)
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1_tl(i) = q_tm(i-im2,jm)
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx_tl(i,jm) = 0.5*q_tm(i,jm-1)*va(i,jm)+q_tm(i,jm)*(1+(-0.5)*va(i,jm))+0.5*va_tl(i,jm)*(q(i,jm-1)-q(i,jm))
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx_tl(i,jm) = (-0.5)*fx1_tl(i)*va(i,jm)+q_tm(i,jm)*(1+0.5*va(i,jm))+0.5*va_tl(i,jm)*(q(i,jm)-fx1(i))
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx_tl(i,j) = (-0.5)*q_tm(i,jp+1)*va(i,j)+q_tm(i,j)+0.5*q_tm(i,jp)*va(i,j)+0.5*va_tl(i,j)*(q(i,jp)-q(i,jp+1))
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  call xtp_tl( im,ffsl(j),fx(1,j),fx_tl(1,j),adx(1,j),adx_tl(1,j),crx(1,j),crx_tl(1,j),iord,crx(1,j),crx_tl(1,j),cose(j),0,dm,&
&dmj_tl,qtmp,qtmpj_tl,al,ar,a6,a6_tl )
end do

end subroutine tpcc_tl


subroutine xmist_tl( im, q, q_tm, dm, dm_tl, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_tm(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dml
double precision :: dmm
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxj
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qminj

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm_tl(i) = q_tm(i-2)*r24-8*q_tm(i-1)*r24-q_tm(i+2)*r24+8*q_tm(i+1)*r24
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm_tl(i) = (-0.25)*q_tm(i-1)+0.25*q_tm(i+1)
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmaxj = max(q(i-1),q(i))
    qmax_tl = (-q_tm(i))+q_tm(i+1)*(0.5-sign(0.5d0,qmaxj-q(i+1)))+(q_tm(i-1)*(0.5+sign(0.5d0,q(i-1)-q(i)))+q_tm(i)*(0.5-sign(0.5d0,&
&q(i-1)-q(i))))*(0.5+sign(0.5d0,qmaxj-q(i+1)))
    qmax = max(qmaxj,q(i+1))-q(i)
    qminj = min(q(i-1),q(i))
    qmin_tl = q_tm(i)-(q_tm(i+1)*(0.5-sign(0.5d0,q(i+1)-qminj))+(q_tm(i-1)*(0.5+sign(0.5d0,q(i)-q(i-1)))+q_tm(i)*(0.5-sign(0.5d0,&
&q(i)-q(i-1))))*(0.5+sign(0.5d0,q(i+1)-qminj)))
    qmin = q(i)-min(qminj,q(i+1))
    dml = min(abs(dm(i)),qmax)
    dmm = min(dml,qmin)
    dm_tl(i) = ((dm_tl(i)*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))+qmax_tl*(0.5-sign(0.5d0,qmax-abs(dm(i)))))*(0.5+&
&sign(0.5d0,qmin-dml))+qmin_tl*(0.5-sign(0.5d0,qmin-dml)))*sign(1.d0,dmm)*sign(1.d0,dm(i))
    dm(i) = sign(dmm,dm(i))
  end do
endif

end subroutine xmist_tl


subroutine xtp_tl( im, ffsl, fx, fx_tl, q, q_tm, c, c_tl, iord, mfx, mfx_tl, cosa, id, dm, dm_tl, qtmp, qtmp_tl, al, ar, a6, a6_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_tl(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_tl(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_tl(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_tm(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_tl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh_tl(-(im/3):im+im/3)
real(kind=r8) :: ali_tl(-(im/3):im+im/3)
real(kind=r8) :: arh_tl(-(im/3):im+im/3)
real(kind=r8) :: ari_tl(-(im/3):im+im/3)
double precision :: dmj
double precision :: dmk
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxi
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qmini
real(kind=r8) :: rut
real(kind=r8) :: rut_tl
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp_tl(i) = q_tm(i)
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp_tl(i) = q_tm(im+i)
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp_tl(i) = q_tm(i-im)
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
      fx_tl(i) = c_tl(i)*qtmp(itmp)+qtmp_tl(itmp)*(c(i)-iu)
      fx(i) = (c(i)-iu)*qtmp(itmp)
    end do
  else
    do i = 1, im
      tmp_tl = (-0.25)*qtmp_tl(i-1)+0.25*qtmp_tl(i+1)
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmaxi = max(qtmp(i-1),qtmp(i))
      qmax_tl = (qtmp_tl(i-1)*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))+qtmp_tl(i)*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i))))*(0.5+sign(0.5d0,&
&qmaxi-qtmp(i+1)))+qtmp_tl(i+1)*(0.5-sign(0.5d0,qmaxi-qtmp(i+1)))-qtmp_tl(i)
      qmax = max(qmaxi,qtmp(i+1))-qtmp(i)
      qmini = min(qtmp(i-1),qtmp(i))
      qmin_tl = (-((qtmp_tl(i-1)*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))+qtmp_tl(i)*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1))))*(0.5+&
&sign(0.5d0,qtmp(i+1)-qmini))+qtmp_tl(i+1)*(0.5-sign(0.5d0,qtmp(i+1)-qmini))))+qtmp_tl(i)
      qmin = qtmp(i)-min(qmini,qtmp(i+1))
      dmj = min(abs(tmp),qmax)
      dmk = min(dmj,qmin)
      dm_tl(i) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+sign(0.5d0,&
&qmin-dmj))+qmin_tl*(0.5-sign(0.5d0,qmin-dmj)))*sign(1.d0,dmk)*sign(1.d0,tmp)
      dm(i) = sign(dmk,tmp)
    end do
    do i = iuw, 0
      dm_tl(i) = dm_tl(im+i)
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm_tl(i) = dm_tl(i-im)
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_tl( im,c,c_tl,mfx,mfx_tl,qtmp,qtmp_tl,dm,dm_tl,fx,fx_tl,iord,al,ali_tl,ar,ari_tl,a6,a6_tl,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        rut_tl = c_tl(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
          fx_tl(i) = (-(dm_tl(itmp)*rut*(1+rut)))+qtmp_tl(itmp)*rut+rut_tl*((-(rut*dm(itmp)))+qtmp(itmp)-dm(itmp)*(1.+rut))
          fx(i) = rut*(qtmp(itmp)-dm(itmp)*(1.+rut))
        else
          itmp = i-iu-1
          isave(i) = itmp+1
          fx_tl(i) = dm_tl(itmp)*rut*(1.-rut)+qtmp_tl(itmp)*rut+rut_tl*((-(rut*dm(itmp)))+qtmp(itmp)+dm(itmp)*(1.-rut))
          fx(i) = rut*(qtmp(itmp)+dm(itmp)*(1.-rut))
        endif
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        fx_tl(i) = fx_tl(i)+qtmp_tl(ist)
        fx(i) = fx(i)+qtmp(ist)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        fx_tl(i) = fx_tl(i)-qtmp_tl(ist)
        fx(i) = fx(i)-qtmp(ist)
      end do
    endif
  end do
  if (id .ne. 0) then
    do i = 1, im
      fx_tl(i) = fx_tl(i)*mfx(i)+mfx_tl(i)*fx(i)
      fx(i) = fx(i)*mfx(i)
    end do
  endif
else
  qtmp_tl(imp) = q_tm(1)
  qtmp(imp) = q(1)
  qtmp_tl(0) = q_tm(im)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = float(i)-c(i)
      fx_tl(i) = mfx_tl(i)*qtmp(iu)+qtmp_tl(iu)*mfx(i)
      fx(i) = mfx(i)*qtmp(iu)
    end do
  else
    qtmp_tl(-1) = q_tm(im-1)
    qtmp(-1) = q(im-1)
    qtmp_tl(imp+1) = q_tm(2)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_tl( im,qtmp,qtmp_tl,dm,dm_tl,2 )
    else
      call xmist_tl( im,qtmp,qtmp_tl,dm,dm_tl,iord )
    endif
    dm_tl(0) = dm_tl(im)
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      do i = 1, im
        iu = float(i)-c(i)
        fx_tl(i) = (-(c_tl(i)*mfx(i)*dm(iu)))+dm_tl(iu)*mfx(i)*(sign(1.d0,c(i))-c(i))+mfx_tl(i)*(qtmp(iu)+dm(iu)*(sign(1.d0,c(i))-&
&c(i)))+qtmp_tl(iu)*mfx(i)
        fx(i) = mfx(i)*(qtmp(iu)+dm(iu)*(sign(1._8,c(i))-c(i)))
      end do
    else
      call fxppm_tl( im,c,c_tl,mfx,mfx_tl,qtmp,qtmp_tl,dm,dm_tl,fx,fx_tl,iord,al,alh_tl,ar,arh_tl,a6,a6_tl,iuw,iue,ffsl,isave )
    endif
  endif
endif

end subroutine xtp_tl


subroutine ycc_tl( im, jm, fy, fy_tl, q, q_tm, vc, vc_tl, ymass, ymass_tl, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: iv
integer :: jfirst
integer :: jlast
real(kind=r8) :: fy(im,jfirst-iv:jlast)
real(kind=r8) :: fy_tl(im,jfirst-iv:jlast)
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: q_tm(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: vc(im,jfirst-iv:jlast)
real(kind=r8) :: vc_tl(im,jfirst-iv:jlast)
real(kind=r8) :: ymass(im,jfirst-iv:jlast)
real(kind=r8) :: ymass_tl(im,jfirst-iv:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dc(im,jfirst-iv:jlast+1)
real(kind=r8) :: dc_tl(im,jfirst-iv:jlast+1)
double precision :: dcp
double precision :: dcq
integer :: i
integer :: im2
integer :: j
integer :: jn2g0
integer :: jn2g1
integer :: js2giv
integer :: js3giv
integer :: jt
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxl
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qminl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
js2giv = max(2,jfirst-iv)
js3giv = max(3,jfirst-iv)
jn2g1 = min(jm-1,jlast+1)
jn2g0 = min(jm-1,jlast)
if (jord .eq. 1) then
  do j = js2giv, jn2g0
    do i = 1, im
      jt = float(j+1)-vc(i,j)
      fy_tl(i,j) = q_tm(i,jt)*ymass(i,j)+ymass_tl(i,j)*q(i,jt)
      fy(i,j) = q(i,jt)*ymass(i,j)
    end do
  end do
else
  do j = js3giv, jn2g1
    do i = 1, im
      dc_tl(i,j) = (-0.25)*q_tm(i,j-1)+0.25*q_tm(i,j+1)
      dc(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
    end do
  end do
  if (iv .eq. 0) then
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc_tl(i,2) = 0.25*q_tm(i,3)-0.25*q_tm(i+im2,2)
        dc(i,2) = 0.25*(q(i,3)-q(i+im2,2))
      end do
      do i = im2+1, im
        dc_tl(i,2) = 0.25*q_tm(i,3)-0.25*q_tm(i-im2,2)
        dc(i,2) = 0.25*(q(i,3)-q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)+0.25*q_tm(i+im2,jm)
        dc(i,jm) = 0.25*(q(i+im2,jm)-q(i,jm-1))
      end do
      do i = im2+1, im
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)+0.25*q_tm(i-im2,jm)
        dc(i,jm) = 0.25*(q(i-im2,jm)-q(i,jm-1))
      end do
    endif
  else
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc_tl(i,2) = 0.25*q_tm(i,3)+0.25*q_tm(i+im2,2)
        dc(i,2) = 0.25*(q(i,3)+q(i+im2,2))
      end do
      do i = im2+1, im
        dc_tl(i,2) = 0.25*q_tm(i,3)+0.25*q_tm(i-im2,2)
        dc(i,2) = 0.25*(q(i,3)+q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)-0.25*q_tm(i+im2,jm)
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i+im2,jm)))
      end do
      do i = im2+1, im
        dc_tl(i,jm) = (-0.25)*q_tm(i,jm-1)-0.25*q_tm(i-im2,jm)
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i-im2,jm)))
      end do
    endif
  endif
  if (jord .gt. 0) then
    do j = js3giv, jn2g1
      do i = 1, im
        qmaxl = max(q(i,j-1),q(i,j))
        qmax_tl = (-q_tm(i,j))+q_tm(i,j+1)*(0.5-sign(0.5d0,qmaxl-q(i,j+1)))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))+q_tm(i,&
&j)*(0.5-sign(0.5d0,q(i,j-1)-q(i,j))))*(0.5+sign(0.5d0,qmaxl-q(i,j+1)))
        qmax = max(qmaxl,q(i,j+1))-q(i,j)
        qminl = min(q(i,j-1),q(i,j))
        qmin_tl = q_tm(i,j)-(q_tm(i,j+1)*(0.5-sign(0.5d0,q(i,j+1)-qminl))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))+q_tm(i,j)*&
&(0.5-sign(0.5d0,q(i,j)-q(i,j-1))))*(0.5+sign(0.5d0,q(i,j+1)-qminl)))
        qmin = q(i,j)-min(qminl,q(i,j+1))
        dcp = min(abs(dc(i,j)),qmin)
        dcq = min(dcp,qmax)
        dc_tl(i,j) = ((dc_tl(i,j)*(0.5+sign(0.5d0,qmin-abs(dc(i,j))))*sign(1.d0,dc(i,j))+qmin_tl*(0.5-sign(0.5d0,qmin-abs(dc(i,j)))&
&))*(0.5+sign(0.5d0,qmax-dcp))+qmax_tl*(0.5-sign(0.5d0,qmax-dcp)))*sign(1.d0,dcq)*sign(1.d0,dc(i,j))
        dc(i,j) = sign(dcq,dc(i,j))
      end do
    end do
    if (jfirst .eq. 1) then
      do i = 1, im
        dc_tl(i,2) = 0.d0
        dc(i,2) = 0.
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im
        dc_tl(i,jm) = 0.d0
        dc(i,jm) = 0.
      end do
    endif
  endif
  do j = js2giv, jn2g0
    do i = 1, im
      jt = float(j+1)-vc(i,j)
      fy_tl(i,j) = dc_tl(i,jt)*(sign(1.d0,vc(i,j))-vc(i,j))*ymass(i,j)+q_tm(i,jt)*ymass(i,j)-vc_tl(i,j)*dc(i,jt)*ymass(i,j)+&
&ymass_tl(i,j)*(q(i,jt)+(sign(1.d0,vc(i,j))-vc(i,j))*dc(i,jt))
      fy(i,j) = (q(i,jt)+(sign(1._8,vc(i,j))-vc(i,j))*dc(i,jt))*ymass(i,j)
    end do
  end do
endif

end subroutine ycc_tl


subroutine ymist_tl( im, jm, q, q_tm, dm, dm_tl, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tl(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dmt
double precision :: dmu
double precision :: dmz
double precision :: dmza
double precision :: dmzd
double precision :: dmze
double precision :: dmzj
double precision :: dmzk
double precision :: dmzn
double precision :: dmzo
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tl
double precision :: qmaxn
double precision :: qmaxq
double precision :: qmaxs
double precision :: qmaxv
double precision :: qmaxx
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tl
double precision :: qminn
double precision :: qminq
double precision :: qmins
double precision :: qminv
double precision :: qminx
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm_tl(i,j) = (-0.25)*q_tm(i,j-1)+0.25*q_tm(i,j+1)
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_tl = (-0.25)*q_tm(i+im2,2)+0.25*q_tm(i,2)
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmaxx = max(q(i,2),q(i,1))
      qmax_tl = (-q_tm(i,1))+q_tm(i+im2,2)*(0.5-sign(0.5d0,qmaxx-q(i+im2,2)))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+q_tm(i,1)*&
&(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxx-q(i+im2,2)))
      qmax = max(qmaxx,q(i+im2,2))-q(i,1)
      qminx = min(q(i,2),q(i,1))
      qmin_tl = q_tm(i,1)-(q_tm(i+im2,2)*(0.5-sign(0.5d0,q(i+im2,2)-qminx))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+q_tm(i,1)*&
&(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,q(i+im2,2)-qminx)))
      qmin = q(i,1)-min(qminx,q(i+im2,2))
      dmzn = min(abs(tmp),qmax)
      dmzo = min(dmzn,qmin)
      dm_tl(i,1) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmzn))+qmin_tl*(0.5-sign(0.5d0,qmin-dmzn)))*sign(1.d0,dmzo)*sign(1.d0,tmp)
      dm(i,1) = sign(dmzo,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,1) = -dm_tl(i-im2,1)
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_tl = 0.25*q_tm(i+im2,jm1)-0.25*q_tm(i,jm1)
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmaxv = max(q(i+im2,jm1),q(i,jm))
      qmax_tl = (-q_tm(i,jm))+q_tm(i,jm1)*(0.5-sign(0.5d0,qmaxv-q(i,jm1)))+(q_tm(i,jm)*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))+&
&q_tm(i+im2,jm1)*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm))))*(0.5+sign(0.5d0,qmaxv-q(i,jm1)))
      qmax = max(qmaxv,q(i,jm1))-q(i,jm)
      qminv = min(q(i+im2,jm1),q(i,jm))
      qmin_tl = q_tm(i,jm)-(q_tm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qminv))+(q_tm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))+q_tm(i+&
&im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1))))*(0.5+sign(0.5d0,q(i,jm1)-qminv)))
      qmin = q(i,jm)-min(qminv,q(i,jm1))
      dmzj = min(abs(tmp),qmax)
      dmzk = min(dmzj,qmin)
      dm_tl(i,jm) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmzj))+qmin_tl*(0.5-sign(0.5d0,qmin-dmzj)))*sign(1.d0,dmzk)*sign(1.d0,tmp)
      dm(i,jm) = sign(dmzk,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,jm) = -dm_tl(i-im2,jm)
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_tl = 0.25*q_tm(i+im2,2)+0.25*q_tm(i,2)
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmaxs = max(q(i,2),q(i,1))
      qmax_tl = (-q_tm(i,1))-q_tm(i+im2,2)*(0.5-sign(0.5d0,qmaxs-(-q(i+im2,2))))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+q_tm(i,&
&1)*(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxs-(-q(i+im2,2))))
      qmax = max(qmaxs,-q(i+im2,2))-q(i,1)
      qmins = min(q(i,2),q(i,1))
      qmin_tl = q_tm(i,1)-((-(q_tm(i+im2,2)*(0.5-sign(0.5d0,(-q(i+im2,2))-qmins))))+(q_tm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+&
&q_tm(i,1)*(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,(-q(i+im2,2))-qmins)))
      qmin = q(i,1)-min(qmins,-q(i+im2,2))
      dmzd = min(abs(tmp),qmax)
      dmze = min(dmzd,qmin)
      dm_tl(i,1) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmzd))+qmin_tl*(0.5-sign(0.5d0,qmin-dmzd)))*sign(1.d0,dmze)*sign(1.d0,tmp)
      dm(i,1) = sign(dmze,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,1) = dm_tl(i-im2,1)
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_tl = (-0.25)*q_tm(i+im2,jm1)-0.25*q_tm(i,jm1)
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmaxq = max(-q(i+im2,jm1),q(i,jm))
      qmax_tl = (-q_tm(i,jm))+q_tm(i,jm1)*(0.5-sign(0.5d0,qmaxq-q(i,jm1)))+(q_tm(i,jm)*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))-&
&q_tm(i+im2,jm1)*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm))))*(0.5+sign(0.5d0,qmaxq-q(i,jm1)))
      qmax = max(qmaxq,q(i,jm1))-q(i,jm)
      qminq = min(-q(i+im2,jm1),q(i,jm))
      qmin_tl = q_tm(i,jm)-(q_tm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qminq))+(q_tm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))-&
&q_tm(i+im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1)))))*(0.5+sign(0.5d0,q(i,jm1)-qminq)))
      qmin = q(i,jm)-min(qminq,q(i,jm1))
      dmz = min(abs(tmp),qmax)
      dmza = min(dmz,qmin)
      dm_tl(i,jm) = ((qmax_tl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_tl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmz))+qmin_tl*(0.5-sign(0.5d0,qmin-dmz)))*sign(1.d0,dmza)*sign(1.d0,tmp)
      dm(i,jm) = sign(dmza,tmp)
    end do
    do i = im2+1, im
      dm_tl(i,jm) = dm_tl(i-im2,jm)
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    do i = 1, im
      qmaxn = max(q(i,j-1),q(i,j))
      qmax_tl = (-q_tm(i,j))+q_tm(i,j+1)*(0.5-sign(0.5d0,qmaxn-q(i,j+1)))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))+q_tm(i,j)*&
&(0.5-sign(0.5d0,q(i,j-1)-q(i,j))))*(0.5+sign(0.5d0,qmaxn-q(i,j+1)))
      qmax = max(qmaxn,q(i,j+1))-q(i,j)
      qminn = min(q(i,j-1),q(i,j))
      qmin_tl = q_tm(i,j)-(q_tm(i,j+1)*(0.5-sign(0.5d0,q(i,j+1)-qminn))+(q_tm(i,j-1)*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))+q_tm(i,j)*&
&(0.5-sign(0.5d0,q(i,j)-q(i,j-1))))*(0.5+sign(0.5d0,q(i,j+1)-qminn)))
      qmin = q(i,j)-min(qminn,q(i,j+1))
      dmt = min(abs(dm(i,j)),qmin)
      dmu = min(dmt,qmax)
      dm_tl(i,j) = ((dm_tl(i,j)*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))+qmin_tl*(0.5-sign(0.5d0,qmin-abs(dm(i,j)))))&
&*(0.5+sign(0.5d0,qmax-dmt))+qmax_tl*(0.5-sign(0.5d0,qmax-dmt)))*sign(1.d0,dmu)*sign(1.d0,dm(i,j))
      dm(i,j) = sign(dmu,dm(i,j))
    end do
  end do
endif

end subroutine ymist_tl


subroutine ytp_tl( im, jm, fy, fy_tl, q, q_tm, c, c_tl, yfx, yfx_tl, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_tl(im,jfirst:jlast+1)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tl(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      fy_tl(i,j) = q_tm(i,jt)
      fy(i,j) = q(i,jt)
    end do
  end do
else
  call ymist_tl( im,jm,q,q_tm,dm,dm_tl,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm_tl( c,c_tl,q,q_tm,dm,dm_tl,fy,fy_tl,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        fy_tl(i,j) = (-(c_tl(i,j)*dm(i,jt)))+dm_tl(i,jt)*(sign(1.d0,c(i,j))-c(i,j))+q_tm(i,jt)
        fy(i,j) = q(i,jt)+(sign(1._8,c(i,j))-c(i,j))*dm(i,jt)
      end do
    end do
  endif
endif
do j = js2g0, jn1g1
  do i = 1, im
    fy_tl(i,j) = fy_tl(i,j)*yfx(i,j)+yfx_tl(i,j)*fy(i,j)
    fy(i,j) = fy(i,j)*yfx(i,j)
  end do
end do

end subroutine ytp_tl


end module     tp_core_tl


#endif /* SPMD */
