#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     sw_core_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use sw_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine c_sw_tl( u, u_tm, v, v_tm, pt, pt_tm, delp, delp_tm, uc, uc_tl, vc, vc_tl, ptc, ptc_tl, delpf, delpf_tl, ptk, ptk_tl, &
&cosp, acosp, cose, coslon, sinlon, dxdt, dxe, dtdx2, dtdx4, dtxe5, rdxe, dycp, dydt, dtdy5, cye, fc, ifax, trigs, dc, sc, zt_c, &
&tiny, rcap, im, jm, jfirst, jlast, ng_c, ng_d, ng_s, js2g0, jn2g0, js2gc, jn1gc, iord, jord, cosl5, sinl5 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
real(kind=r8), intent(in) :: cye(jm)
integer, intent(in) :: jn2g0
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: dc(im,js2g0:jn2g0)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
real(kind=r8), intent(in) :: delp(im,jfirst:jlast)
real(kind=r8), intent(in) :: delp_tm(im,jfirst:jlast)
integer, intent(in) :: ng_d
real(kind=r8), intent(in) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: delpf_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx2(jm)
real(kind=r8), intent(in) :: dtdx4(jm)
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dxdt(jm)
real(kind=r8), intent(in) :: dxe(jm)
real(kind=r8), intent(in) :: dycp(jm)
real(kind=r8), intent(in) :: dydt
integer, intent(in) :: jn1gc
integer, intent(in) :: js2gc
real(kind=r8), intent(in) :: fc(js2gc:jn1gc)
integer, intent(in) :: ifax(13)
integer, intent(in) :: iord
integer, intent(in) :: jord
integer, intent(in) :: ng_c
integer, intent(in) :: ng_s
real(kind=r8), intent(in) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: pt_tm(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(out) :: ptc(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptc_tl(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptk(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptk_tl(im,jfirst:jlast)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdxe(jm)
real(kind=r8), intent(in) :: sc(js2g0:jn2g0)
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: trigs(3*im/2+1)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(in) :: u_tm(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(out) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(out) :: uc_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(in) :: v_tm(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(out) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(out) :: vc_tl(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_c

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: crx(im,jfirst-max(1,ng_c):jlast+max(2,ng_c))
real(kind=r8) :: crx_tl(im,jfirst-max(1,ng_c):jlast+max(2,ng_c))
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: cx1(im)
real(kind=r8) :: cx1_tl(im)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxj_tl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: help_i
integer :: i
integer :: im2
integer :: j
integer :: jn1g1
integer :: jn2gc
integer :: js1g1
integer :: js2g1
integer :: js2gc1
integer :: js2gcp1
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_tl(im)
real(kind=r8) :: p1ke
real(kind=r8) :: p1ke_tl
real(kind=r8) :: p2ke
real(kind=r8) :: p2ke_tl
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpk_tl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopek_tl(1+im+2*(im/3))
real(kind=r8) :: tm2(im,jfirst:jlast)
real(kind=r8) :: tm2_tl(im,jfirst:jlast)
real(kind=r8) :: u2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: u2_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: un
real(kind=r8) :: un_tl
real(kind=r8) :: us
real(kind=r8) :: us_tl
real(kind=r8) :: v2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: v2_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: va_tl(im,jfirst-1:jlast)
real(kind=r8) :: vn
real(kind=r8) :: vn_tl
real(kind=r8) :: vs
real(kind=r8) :: vs_tl
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk1_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)
real(kind=r8) :: ymass(im,jfirst:jlast+1)
real(kind=r8) :: ymass_tl(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
js1g1 = max(1,jfirst-1)
js2g1 = max(2,jfirst-1)
js2gcp1 = max(2,jfirst-ng_c-1)
jn1g1 = min(jm,jlast+1)
jn2gc = min(jm-1,jlast+ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc1 = js2gc
else
  js2gc1 = max(2,jfirst-ng_c+1)
endif
call vpol5_tl( u(1,jfirst),u_tm(1,jfirst),v(1,jfirst),v_tm(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gcp1, jn2gc
  do i = 1, im-1
    v2_tl(i,j) = v_tm(i+1,j)+v_tm(i,j)
    v2(i,j) = v(i,j)+v(i+1,j)
  end do
  v2_tl(im,j) = v_tm(im,j)+v_tm(1,j)
  v2(im,j) = v(im,j)+v(1,j)
end do
do j = js2gc, jn2gc
  do i = 1, im
    u2_tl(i,j) = u_tm(i,j+1)+u_tm(i,j)
    u2(i,j) = u(i,j)+u(i,j+1)
  end do
end do
if (jfirst .eq. 1) then
  us_tl = 0.d0
  us = 0.
  vs_tl = 0.d0
  vs = 0.
  do i = 1, im2
    us_tl = u2_tl(i+im2,2)*sinlon(i)-u2_tl(i,2)*sinlon(i)+us_tl-v2_tl(i+im2,2)*coslon(i)+v2_tl(i,2)*coslon(i)
    us = us+(u2(i+im2,2)-u2(i,2))*sinlon(i)+(v2(i,2)-v2(i+im2,2))*coslon(i)
    vs_tl = u2_tl(i+im2,2)*coslon(i)-u2_tl(i,2)*coslon(i)+v2_tl(i+im2,2)*sinlon(i)-v2_tl(i,2)*sinlon(i)+vs_tl
    vs = vs+(u2(i+im2,2)-u2(i,2))*coslon(i)+(v2(i+im2,2)-v2(i,2))*sinlon(i)
  end do
  us_tl = us_tl/dble(im)
  us = us/im
  vs_tl = vs_tl/dble(im)
  vs = vs/im
  do i = 1, im2
    u2_tl(i,1) = (-(us_tl*sinlon(i)))-vs_tl*coslon(i)
    u2(i,1) = (-(us*sinlon(i)))-vs*coslon(i)
    v2_tl(i,1) = us_tl*coslon(i)-vs_tl*sinlon(i)
    v2(i,1) = us*coslon(i)-vs*sinlon(i)
    u2_tl(i+im2,1) = -u2_tl(i,1)
    u2(i+im2,1) = -u2(i,1)
    v2_tl(i+im2,1) = -v2_tl(i,1)
    v2(i+im2,1) = -v2(i,1)
  end do
  p1ke_tl = 0.25*u2_tl(1,1)*u2(1,1)+0.25*v2_tl(1,1)*v2(1,1)
  p1ke = 0.125*(u2(1,1)**2+v2(1,1)**2)
endif
if (jlast .eq. jm) then
  un_tl = 0.d0
  un = 0.
  vn_tl = 0.d0
  vn = 0.
  j = jm-1
  do i = 1, im2
    un_tl = u2_tl(i+im2,j)*sinlon(i)-u2_tl(i,j)*sinlon(i)+un_tl+v2_tl(i+im2,j)*coslon(i)-v2_tl(i,j)*coslon(i)
    un = un+(u2(i+im2,j)-u2(i,j))*sinlon(i)+(v2(i+im2,j)-v2(i,j))*coslon(i)
    vn_tl = (-(u2_tl(i+im2,j)*coslon(i)))+u2_tl(i,j)*coslon(i)+v2_tl(i+im2,j)*sinlon(i)-v2_tl(i,j)*sinlon(i)+vn_tl
    vn = vn+(u2(i,j)-u2(i+im2,j))*coslon(i)+(v2(i+im2,j)-v2(i,j))*sinlon(i)
  end do
  un_tl = un_tl/dble(im)
  un = un/im
  vn_tl = vn_tl/dble(im)
  vn = vn/im
  do i = 1, im2
    u2_tl(i,jm) = (-(un_tl*sinlon(i)))+vn_tl*coslon(i)
    u2(i,jm) = (-(un*sinlon(i)))+vn*coslon(i)
    v2_tl(i,jm) = (-(un_tl*coslon(i)))-vn_tl*sinlon(i)
    v2(i,jm) = (-(un*coslon(i)))-vn*sinlon(i)
    u2_tl(i+im2,jm) = -u2_tl(i,jm)
    u2(i+im2,jm) = -u2(i,jm)
    v2_tl(i+im2,jm) = -v2_tl(i,jm)
    v2(i+im2,jm) = -v2(i,jm)
  end do
  p2ke_tl = 0.25*u2_tl(1,jm)*u2(1,jm)+0.25*v2_tl(1,jm)*v2(1,jm)
  p2ke = 0.125*(u2(1,jm)**2+v2(1,jm)**2)
endif
do j = js2gc, jn2gc
  uc_tl(1,j) = 0.25*u2_tl(im,j)+0.25*u2_tl(1,j)
  uc(1,j) = 0.25*(u2(1,j)+u2(im,j))
  do i = 2, im
    uc_tl(i,j) = 0.25*u2_tl(i-1,j)+0.25*u2_tl(i,j)
    uc(i,j) = 0.25*(u2(i,j)+u2(i-1,j))
  end do
end do
do i = 1, im
  vc_tl(i,jfirst-2) = 0.
  vc(i,jfirst-2) = 0.
  vc_tl(i,jfirst-1) = 0.
  vc(i,jfirst-1) = 0.
  vc_tl(i,jfirst) = 0.
  vc(i,jfirst) = 0.
  vc_tl(i,jlast+1) = 0.
  vc(i,jlast+1) = 0.
  vc_tl(i,jlast+2) = 0.
  vc(i,jlast+2) = 0.
end do
do j = js2gc, jn1gc
  do i = 1, im
    vc_tl(i,j) = 0.25*v2_tl(i,j-1)+0.25*v2_tl(i,j)
    vc(i,j) = 0.25*(v2(i,j)+v2(i,j-1))
  end do
end do
do j = js2g1, jn1g1
  do i = 1, im
    cry_tl(i,j) = vc_tl(i,j)*dtdy5
    cry(i,j) = dtdy5*vc(i,j)
  end do
end do
do j = js2g0, jn1g1
  do i = 1, im
    ymass_tl(i,j) = cry_tl(i,j)*cose(j)
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g1, jn2g0
  do i = 1, im
    va_tl(i,j) = 0.5*cry_tl(i,j+1)+0.5*cry_tl(i,j)
    va(i,j) = 0.5*(cry(i,j)+cry(i,j+1))
  end do
end do
do j = jfirst-1, jlast
  do i = 1, im
    crx_tl(i,j) = 0.d0
    crx(i,j) = 0.
  end do
end do
do j = js2gc, jn2gc
  do i = 1, im
    crx_tl(i,j) = uc_tl(i,j)*dtdx2(j)
    crx(i,j) = uc(i,j)*dtdx2(j)
  end do
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
call tp2c_tl( ptk,ptk_tl,va(1,jfirst),va_tl(1,jfirst),delpf(1,jfirst-ng_c),delpf_tl(1,jfirst-ng_c),crx(1,jfirst-ng_c),crx_tl(1,&
&jfirst-ng_c),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_c,xfx,xfx_tl,yfx,yfx_tl,ffsl,rcap,acosp,crx(1,jfirst),crx_tl(1,&
&jfirst),ymass,ymass_tl,cosp,0,jfirst,jlast )
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx_tl(i,j) = (-(crx_tl(i,j)*(xfx(i,j)*(0.5+sign(0.5d0,abs(crx(i,j))-tiny))*sign(1.d0,crx(i,j))*sign(1.d0,crx(i,j))*&
&sign(1.d0,max(abs(crx(i,j)),tiny))/(sign(max(abs(crx(i,j)),tiny),crx(i,j))*sign(max(abs(crx(i,j)),tiny),crx(i,j))))))+&
&xfx_tl(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
call tp2c_tl( tm2,tm2_tl,va(1,jfirst),va_tl(1,jfirst),pt(1,jfirst-ng_c),pt_tm(1,jfirst-ng_c),crx(1,jfirst-ng_c),crx_tl(1,jfirst-&
&ng_c),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_c,fx,fx_tl,fy(1,jfirst),fy_tl(1,jfirst),ffsl,rcap,acosp,xfx,xfx_tl,yfx,&
&yfx_tl,cosp,1,jfirst,jlast )
help_h = jn2g0-js2g0+1
call pft2d_tl( ptk(1,js2g0),ptk_tl(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,v2,v2_tl,crx )
help_i = jn2g0-js2g0+1
call pft2d_tl( tm2(1,js2g0),tm2_tl(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_i,ifax,trigs,v2,v2_tl,crx )
do j = jfirst, jlast
  do i = 1, im
    ptk_tl(i,j) = delp_tm(i,j)+ptk_tl(i,j)
    ptk(i,j) = delp(i,j)+ptk(i,j)
    ptc_tl(i,j) = delp_tm(i,j)*(pt(i,j)/ptk(i,j))+pt_tm(i,j)*(delp(i,j)/ptk(i,j))-ptk_tl(i,j)*((pt(i,j)*delp(i,j)+tm2(i,j))/(ptk(i,&
&j)*ptk(i,j)))+tm2_tl(i,j)/ptk(i,j)
    ptc(i,j) = (pt(i,j)*delp(i,j)+tm2(i,j))/ptk(i,j)
  end do
end do
call ycc_tl( im,jm,fy,fy_tl,vc(1,jfirst-2),vc_tl(1,jfirst-2),va(1,jfirst-1),va_tl(1,jfirst-1),va(1,jfirst-1),va_tl(1,jfirst-1),&
&jord,1,jfirst,jlast )
do j = js2g1, jn2g0
  do i = 1, im
    cx1_tl(i) = u2_tl(i,j)*dtdx4(j)
    cx1(i) = dtdx4(j)*u2(i,j)
  end do
  sld =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(cx1(i)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  p1d_tl(im) = uc_tl(1,j)
  p1d(im) = uc(1,j)
  do i = 1, im-1
    p1d_tl(i) = uc_tl(i+1,j)
    p1d(i) = uc(i+1,j)
  end do
  call xtp_tl( im,sld,fxj,fxj_tl,p1d,p1d_tl,cx1,cx1_tl,iord,cx1,cx1_tl,cosp(j),0,slope,slopek_tl,qtmp,qtmpk_tl,al,ar,a6,a6_tl )
  do i = 1, im
    wk1_tl(i,j) = fxj_tl(i)*dxdt(j)+fy_tl(i,j)*dydt
    wk1(i,j) = dxdt(j)*fxj(i)+dydt*fy(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1_tl(i,1) = p1ke_tl
    wk1(i,1) = p1ke
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    wk1_tl(i,jm) = p2ke_tl
    wk1(i,jm) = p2ke
  end do
endif
do j = js2gc1, jn1gc
  crx_tl(1,j) = u_tm(im,j)*dtxe5(j)
  crx(1,j) = dtxe5(j)*u(im,j)
  do i = 2, im
    crx_tl(i,j) = u_tm(i-1,j)*dtxe5(j)
    crx(i,j) = dtxe5(j)*u(i-1,j)
  end do
end do
do j = js1g1, jlast
  do i = 1, im
    cry_tl(i,j) = v_tm(i,j)*dtdy5
    cry(i,j) = dtdy5*v(i,j)
  end do
end do
do j = jfirst, jlast
  do i = 1, im
    ymass_tl(i,j) = cry_tl(i,j)*cosp(j)
    ymass(i,j) = cry(i,j)*cosp(j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im
    tm2_tl(i,j) = 0.5*cry_tl(i,j-1)+0.5*cry_tl(i,j)
    tm2(i,j) = 0.5*(cry(i,j)+cry(i,j-1))
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    u2_tl(i,1) = 0.d0
    u2(i,1) = 0.
  end do
endif
do j = js2gc, jn2gc
  do i = 1, im
    u2_tl(i,j) = uc_tl(i,j)*cosp(j)
    u2(i,j) = uc(i,j)*cosp(j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    u2_tl(i,jm) = 0.d0
    u2(i,jm) = 0.
  end do
endif
do j = js2gc1, jn1gc
  v2_tl(1,j) = u2_tl(1,j-1)*cye(j)-u2_tl(1,j)*cye(j)-vc_tl(im,j)*rdxe(j)+vc_tl(1,j)*rdxe(j)
  v2(1,j) = fc(j)+(u2(1,j-1)-u2(1,j))*cye(j)+(vc(1,j)-vc(im,j))*rdxe(j)
  do i = 2, im
    v2_tl(i,j) = u2_tl(i,j-1)*cye(j)-u2_tl(i,j)*cye(j)-vc_tl(i-1,j)*rdxe(j)+vc_tl(i,j)*rdxe(j)
    v2(i,j) = fc(j)+(u2(i,j-1)-u2(i,j))*cye(j)+(vc(i,j)-vc(i-1,j))*rdxe(j)
  end do
end do
do j = js2gc1, jn1gc
  ffsl(j) =  .false. 
  if (cose(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
call tpcc_tl( tm2,tm2_tl,ymass,ymass_tl,v2(1,jfirst-ng_d),v2_tl(1,jfirst-ng_d),crx(1:im,jfirst-1:jlast+2),crx_tl(1:im,jfirst-1:&
&jlast+2),cry(1:im,jfirst:jlast),cry_tl(1:im,jfirst:jlast),im,jm,ng_d,iord,jord,fx,fx_tl,fy(1:im,jfirst:jlast),fy_tl(1:im,jfirst:&
&jlast),ffsl,cose,jfirst,jlast,slope,qtmp,al,ar,a6,a6_tl )
do j = js2g0, jn2g0
  uc_tl(1,j) = fy_tl(1,j)*dycp(j)+uc_tl(1,j)+wk1_tl(im,j)*dtdx2(j)-wk1_tl(1,j)*dtdx2(j)
  uc(1,j) = uc(1,j)+dtdx2(j)*(wk1(im,j)-wk1(1,j))+dycp(j)*fy(1,j)
  do i = 2, im
    uc_tl(i,j) = fy_tl(i,j)*dycp(j)+uc_tl(i,j)+wk1_tl(i-1,j)*dtdx2(j)-wk1_tl(i,j)*dtdx2(j)
    uc(i,j) = uc(i,j)+dtdx2(j)*(wk1(i-1,j)-wk1(i,j))+dycp(j)*fy(i,j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im-1
    vc_tl(i,j) = (-(fx_tl(i+1,j)*dxe(j)))+vc_tl(i,j)+wk1_tl(i,j-1)*dtdy5-wk1_tl(i,j)*dtdy5
    vc(i,j) = vc(i,j)+dtdy5*(wk1(i,j-1)-wk1(i,j))-dxe(j)*fx(i+1,j)
  end do
  vc_tl(im,j) = (-(fx_tl(1,j)*dxe(j)))+vc_tl(im,j)+wk1_tl(im,j-1)*dtdy5-wk1_tl(im,j)*dtdy5
  vc(im,j) = vc(im,j)+dtdy5*(wk1(im,j-1)-wk1(im,j))-dxe(j)*fx(1,j)
end do

end subroutine c_sw_tl


subroutine d_sw_tl( u, u_tm, v, v_tm, uc, uc_tl, vc, vc_tl, pt, pt_tm, delp, delp_tm, delpf, delpf_tl, cx3, cx3_tl, cy3, cy3_tl, &
&mfx, mfx_tl, mfy, mfy_tl, cdx, cdy, dtdx, dtdxe, dtxe5, txe5, dyce, rdx, cy, dx, f0, js2g0, jn1g1, im, jm, jfirst, jlast, ng_d, &
&ng_s, nq, iord, jord, zt_d, rcap, tiny, dtdy, dtdy5, tdy5, rdy, cosp, acosp, cose, coslon, sinlon, cosl5, sinl5 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
integer, intent(in) :: jn1g1
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: cdx(js2g0:jn1g1)
real(kind=r8), intent(in) :: cdy(js2g0:jn1g1)
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
integer, intent(in) :: ng_d
real(kind=r8), intent(inout) :: cx3(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: cx3_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: cy(jm)
real(kind=r8), intent(inout) :: cy3(im,jfirst:jlast+1)
real(kind=r8), intent(inout) :: cy3_tl(im,jfirst:jlast+1)
real(kind=r8), intent(inout) :: delp(im,jfirst:jlast)
real(kind=r8), intent(inout) :: delp_tm(im,jfirst:jlast)
real(kind=r8), intent(inout) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: delpf_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx(jm)
real(kind=r8), intent(in) :: dtdxe(jm)
real(kind=r8), intent(in) :: dtdy
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dx(jm)
real(kind=r8), intent(in) :: dyce(jm)
real(kind=r8), intent(in) :: f0(jfirst-ng_d:jlast+ng_d)
integer, intent(in) :: iord
integer, intent(in) :: jord
real(kind=r8), intent(inout) :: mfx(im,jfirst:jlast)
real(kind=r8), intent(inout) :: mfx_tl(im,jfirst:jlast)
real(kind=r8), intent(inout) :: mfy(im,jfirst:jlast+1)
real(kind=r8), intent(inout) :: mfy_tl(im,jfirst:jlast+1)
integer, intent(in) :: ng_s
integer, intent(in) :: nq
real(kind=r8), intent(inout) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: pt_tm(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdx(jm)
real(kind=r8), intent(in) :: rdy
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tdy5
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: txe5(jm)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(in) :: u_tm(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(inout) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: uc_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(in) :: v_tm(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(inout) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(inout) :: vc_tl(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_d

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c1
real(kind=r8) :: c1_tl
real(kind=r8) :: c2
real(kind=r8) :: c2_tl
real(kind=r8) :: crx(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: crx_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst-1:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxj_tl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst-1:jlast+1)
integer :: i
integer :: j
integer :: jn1gd
integer :: jn2g0
integer :: jn2g1
integer :: jn2gd
integer :: js2gd
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpi_tl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopei_tl(1+im+2*(im/3))
real(kind=r8) :: ub(im,jfirst:jlast+1)
real(kind=r8) :: ub_tl(im,jfirst:jlast+1)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: va_tl(im,jfirst-1:jlast)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk1_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)
real(kind=r8) :: ymass(im,jfirst:jlast+1)
real(kind=r8) :: ymass_tl(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
jn2g0 = min(jm-1,jlast)
jn2g1 = min(jm-1,jlast+1)
js2gd = max(2,jfirst-ng_d)
jn2gd = min(jm-1,jlast+ng_d)
jn1gd = min(jm,jlast+ng_d)
call upol5_tl( uc(1,jfirst),uc_tl(1,jfirst),vc(1,jfirst),vc_tl(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gd, jn2gd
  do i = 1, im
    crx_tl(i,j) = uc_tl(i,j)*dtdx(j)
    crx(i,j) = dtdx(j)*uc(i,j)
  end do
end do
do j = js2gd, jn2gd
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_d) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
do j = js2g0, jn1g1
  do i = 1, im
    cry_tl(i,j) = vc_tl(i,j)*dtdy
    cry(i,j) = dtdy*vc(i,j)
    ymass_tl(i,j) = cry_tl(i,j)*cose(j)
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g0, jn2g0
  do i = 1, im
    if (cry(i,j)*cry(i,j+1) .gt. 0.) then
      if (cry(i,j) .gt. 0.) then
        va_tl(i,j) = cry_tl(i,j)
        va(i,j) = cry(i,j)
      else
        va_tl(i,j) = cry_tl(i,j+1)
        va(i,j) = cry(i,j+1)
      endif
    else
      va_tl(i,j) = 0.d0
      va(i,j) = 0.
    endif
  end do
end do
call tp2c_tl( ub(1,jfirst),ub_tl(1,jfirst),va(1,jfirst),va_tl(1,jfirst),delpf(1,jfirst-ng_d),delpf_tl(1,jfirst-ng_d),crx(1,jfirst-&
&ng_d),crx_tl(1,jfirst-ng_d),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_d,xfx,xfx_tl,yfx,yfx_tl,ffsl,rcap,acosp,crx(1,&
&jfirst),crx_tl(1,jfirst),ymass,ymass_tl,cosp,0,jfirst,jlast )
if (nq .gt. 0) then
  do j = js2g0, jn2g0
    do i = 1, im
      cx3_tl(i,j) = crx_tl(i,j)+cx3_tl(i,j)
      cx3(i,j) = cx3(i,j)+crx(i,j)
      mfx_tl(i,j) = mfx_tl(i,j)+xfx_tl(i,j)
      mfx(i,j) = mfx(i,j)+xfx(i,j)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      cy3_tl(i,j) = cry_tl(i,j)+cy3_tl(i,j)
      cy3(i,j) = cy3(i,j)+cry(i,j)
      mfy_tl(i,j) = mfy_tl(i,j)+yfx_tl(i,j)
      mfy(i,j) = mfy(i,j)+yfx(i,j)
    end do
  end do
endif
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx_tl(i,j) = (-(crx_tl(i,j)*(xfx(i,j)*(0.5+sign(0.5d0,abs(crx(i,j))-tiny))*sign(1.d0,crx(i,j))*sign(1.d0,crx(i,j))*&
&sign(1.d0,max(abs(crx(i,j)),tiny))/(sign(max(abs(crx(i,j)),tiny),crx(i,j))*sign(max(abs(crx(i,j)),tiny),crx(i,j))))))+&
&xfx_tl(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
do j = jfirst, jlast
  do i = 1, im
    wk1_tl(i,j) = delp_tm(i,j)
    wk1(i,j) = delp(i,j)
    delp_tm(i,j) = ub_tl(i,j)+wk1_tl(i,j)
    delp(i,j) = wk1(i,j)+ub(i,j)
  end do
end do
call tp2c_tl( ub(1,jfirst),ub_tl(1,jfirst),va(1,jfirst),va_tl(1,jfirst),pt(1,jfirst-ng_d),pt_tm(1,jfirst-ng_d),crx(1,jfirst-ng_d),&
&crx_tl(1,jfirst-ng_d),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_d,fx,fx_tl,fy(1:im,jfirst:jlast+1),fy_tl(1:im,jfirst:&
&jlast+1),ffsl,rcap,acosp,xfx,xfx_tl,yfx(1,jfirst),yfx_tl(1,jfirst),cosp,1,jfirst,jlast )
do j = jfirst, jlast
  do i = 1, im
    pt_tm(i,j) = (-(delp_tm(i,j)*((pt(i,j)*wk1(i,j)+ub(i,j))/(delp(i,j)*delp(i,j)))))+pt_tm(i,j)*(wk1(i,j)/delp(i,j))+ub_tl(i,j)/&
&delp(i,j)+wk1_tl(i,j)*(pt(i,j)/delp(i,j))
    pt(i,j) = (pt(i,j)*wk1(i,j)+ub(i,j))/delp(i,j)
  end do
end do
do j = js2g0, jn1g1
  ub_tl(1,j) = (vc_tl(im,j)+vc_tl(1,j))*dtdy5
  ub(1,j) = dtdy5*(vc(1,j)+vc(im,j))
  do i = 2, im
    ub_tl(i,j) = (vc_tl(i-1,j)+vc_tl(i,j))*dtdy5
    ub(i,j) = dtdy5*(vc(i,j)+vc(i-1,j))
  end do
end do
call ytp_tl( im,jm,fy(1:im,jfirst:jlast+1),fy_tl(1:im,jfirst:jlast+1),v(1,jfirst-ng_d),v_tm(1,jfirst-ng_d),ub(1,jfirst),ub_tl(1,&
&jfirst),ub(1,jfirst),ub_tl(1,jfirst),ng_d,jord,1,jfirst,jlast )
do j = js2g0, jn1g1
  do i = 1, im
    ub_tl(i,j) = (uc_tl(i,j-1)+uc_tl(i,j))*dtxe5(j)
    ub(i,j) = dtxe5(j)*(uc(i,j)+uc(i,j-1))
  end do
end do
do j = js2g0, jn1g1
  sld =  .false. 
  if (cose(j) .lt. zt_d) then
    do i = 1, im
      if (abs(ub(i,j)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  call xtp_tl( im,sld,fxj,fxj_tl,u(1,j),u_tm(1,j),ub(1,j),ub_tl(1,j),iord,ub(1,j),ub_tl(1,j),cose(j),0,slope,slopei_tl,qtmp,&
&qtmpi_tl,al,ar,a6,a6_tl )
  do i = 1, im
    wk1_tl(i,j) = fxj_tl(i)*txe5(j)+fy_tl(i,j)*tdy5
    wk1(i,j) = txe5(j)*fxj(i)+tdy5*fy(i,j)
  end do
end do
do j = max(2,jfirst-1), jn2g1
  do i = 1, im
    fy_tl(i,j) = v_tm(i,j)*cosp(j)
    fy(i,j) = v(i,j)*cosp(j)
  end do
end do
do j = js2g0, jn1g1
  uc_tl(1,j) = u_tm(im,j)-u_tm(1,j)
  uc(1,j) = u(im,j)-u(1,j)
  do i = 2, im
    uc_tl(i,j) = u_tm(i-1,j)-u_tm(i,j)
    uc(i,j) = u(i-1,j)-u(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1_tl(i,2) = (-(fy_tl(i,2)*cdy(2)))+uc_tl(i,2)*cdx(2)+wk1_tl(i,2)
    wk1(i,2) = wk1(i,2)-cdy(2)*fy(i,2)+cdx(2)*uc(i,2)
  end do
endif
do j = max(3,jfirst), jn2g1
  do i = 1, im
    wk1_tl(i,j) = fy_tl(i,j-1)*cdy(j)-fy_tl(i,j)*cdy(j)+uc_tl(i,j)*cdx(j)+wk1_tl(i,j)
    wk1(i,j) = wk1(i,j)+cdy(j)*(fy(i,j-1)-fy(i,j))+cdx(j)*uc(i,j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    wk1_tl(i,jm) = fy_tl(i,jm-1)*cdy(jm)+uc_tl(i,jm)*cdx(jm)+wk1_tl(i,jm)
    wk1(i,jm) = wk1(i,jm)+cdy(jm)*fy(i,jm-1)+cdx(jm)*uc(i,jm)
  end do
endif
do j = js2gd, jn1gd
  do i = 1, im
    delpf_tl(i,j) = u_tm(i,j)*cose(j)
    delpf(i,j) = u(i,j)*cose(j)
  end do
end do
if (jfirst .eq. 1) then
  c1_tl = 0.d0
  c1 = 0.
  do i = 1, im
    c1_tl = c1_tl+delpf_tl(i,2)
    c1 = c1+delpf(i,2)
  end do
  c1_tl = -(c1_tl*rdy*rcap)
  c1 = -(c1*rdy*rcap)
  do i = 1, im
    uc_tl(i,1) = c1_tl
    uc(i,1) = c1
  end do
endif
if (jlast .eq. jm) then
  c2_tl = 0.d0
  c2 = 0.
  do i = 1, im
    c2_tl = c2_tl+delpf_tl(i,jm)
    c2 = c2+delpf(i,jm)
  end do
  c2_tl = c2_tl*rdy*rcap
  c2 = c2*rdy*rcap
  do i = 1, im
    uc_tl(i,jm) = c2_tl
    uc(i,jm) = c2
  end do
else
  do i = 1, im
    uc_tl(i,jn2gd) = 0.
    uc(i,jn2gd) = 1.e+30
  end do
endif
do j = js2gd, min(jm-1,jlast+ng_d-1)
  do i = 1, im-1
    uc_tl(i,j) = (-(delpf_tl(i,j+1)*cy(j)))+delpf_tl(i,j)*cy(j)+v_tm(i+1,j)*rdx(j)-v_tm(i,j)*rdx(j)
    uc(i,j) = (delpf(i,j)-delpf(i,j+1))*cy(j)+(v(i+1,j)-v(i,j))*rdx(j)
  end do
  uc_tl(im,j) = (-(delpf_tl(im,j+1)*cy(j)))+delpf_tl(im,j)*cy(j)-v_tm(im,j)*rdx(j)+v_tm(1,j)*rdx(j)
  uc(im,j) = (delpf(im,j)-delpf(im,j+1))*cy(j)+(v(1,j)-v(im,j))*rdx(j)
end do
do j = max(1,jfirst-ng_d), jn1gd
  do i = 1, im
    uc(i,j) = uc(i,j)+f0(j)
  end do
end do
call tp2d_tl( va(1,jfirst),va_tl(1,jfirst),uc(1,jfirst-ng_d),uc_tl(1,jfirst-ng_d),crx(1,jfirst-ng_d),crx_tl(1,jfirst-ng_d),cry(1,&
&jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_d,fx,fx_tl,fy(1:im,jfirst:jlast+1),fy_tl(1:im,jfirst:jlast+1),ffsl,crx(1,jfirst),&
&crx_tl(1,jfirst),ymass,ymass_tl,cosp,0,jfirst,jlast )
do j = js2g0, jlast
  do i = 1, im-1
    uc_tl(i,j) = fy_tl(i,j)*dyce(j)-wk1_tl(i+1,j)*dtdxe(j)+wk1_tl(i,j)*dtdxe(j)
    uc(i,j) = dtdxe(j)*(wk1(i,j)-wk1(i+1,j))+dyce(j)*fy(i,j)
  end do
  uc_tl(im,j) = fy_tl(im,j)*dyce(j)+wk1_tl(im,j)*dtdxe(j)-wk1_tl(1,j)*dtdxe(j)
  uc(im,j) = dtdxe(j)*(wk1(im,j)-wk1(1,j))+dyce(j)*fy(im,j)
end do
do j = js2g0, jn2g0
  do i = 1, im
    vc_tl(i,j) = (-(fx_tl(i,j)*dx(j)))-wk1_tl(i,j+1)*dtdy+wk1_tl(i,j)*dtdy
    vc(i,j) = dtdy*(wk1(i,j)-wk1(i,j+1))-dx(j)*fx(i,j)
  end do
end do

end subroutine d_sw_tl


end module     sw_core_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     sw_core_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use sw_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine c_sw_tl( u, u_tm, v, v_tm, pt, pt_tm, delp, delp_tm, uc, uc_tl, vc, vc_tl, ptc, ptc_tl, delpf, delpf_tl, ptk, ptk_tl, &
&cosp, acosp, cose, coslon, sinlon, dxdt, dxe, dtdx2, dtdx4, dtxe5, rdxe, dycp, dydt, dtdy5, cye, fc, ifax, trigs, dc, sc, zt_c, &
&tiny, rcap, im, jm, jfirst, jlast, ng_c, ng_d, ng_s, js2g0, jn2g0, js2gc, jn1gc, iord, jord, cosl5, sinl5 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
real(kind=r8), intent(in) :: cye(jm)
integer, intent(in) :: jn2g0
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: dc(im,js2g0:jn2g0)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
real(kind=r8), intent(in) :: delp(im,jfirst:jlast)
real(kind=r8), intent(in) :: delp_tm(im,jfirst:jlast)
integer, intent(in) :: ng_d
real(kind=r8), intent(in) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: delpf_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx2(jm)
real(kind=r8), intent(in) :: dtdx4(jm)
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dxdt(jm)
real(kind=r8), intent(in) :: dxe(jm)
real(kind=r8), intent(in) :: dycp(jm)
real(kind=r8), intent(in) :: dydt
integer, intent(in) :: jn1gc
integer, intent(in) :: js2gc
real(kind=r8), intent(in) :: fc(js2gc:jn1gc)
integer, intent(in) :: ifax(13)
integer, intent(in) :: iord
integer, intent(in) :: jord
integer, intent(in) :: ng_c
integer, intent(in) :: ng_s
real(kind=r8), intent(in) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: pt_tm(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(out) :: ptc(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptc_tl(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptk(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptk_tl(im,jfirst:jlast)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdxe(jm)
real(kind=r8), intent(in) :: sc(js2g0:jn2g0)
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: trigs(3*im/2+1)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(in) :: u_tm(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(out) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(out) :: uc_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(in) :: v_tm(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(out) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(out) :: vc_tl(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_c

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: crx(im,jfirst-max(1,ng_c):jlast+max(2,ng_c))
real(kind=r8) :: crx_tl(im,jfirst-max(1,ng_c):jlast+max(2,ng_c))
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: cx1(im)
real(kind=r8) :: cx1_tl(im)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxj_tl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: help_i
integer :: i
integer :: im2
integer :: j
integer :: jn1g1
integer :: jn2gc
integer :: js1g1
integer :: js2g1
integer :: js2gc1
integer :: js2gcp1
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_tl(im)
real(kind=r8) :: p1ke
real(kind=r8) :: p1ke_tl
real(kind=r8) :: p2ke
real(kind=r8) :: p2ke_tl
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpk_tl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopek_tl(1+im+2*(im/3))
real(kind=r8) :: tm2(im,jfirst:jlast)
real(kind=r8) :: tm2_tl(im,jfirst:jlast)
real(kind=r8) :: u2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: u2_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: un
real(kind=r8) :: un_tl
real(kind=r8) :: us
real(kind=r8) :: us_tl
real(kind=r8) :: v2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: v2_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: va_tl(im,jfirst-1:jlast)
real(kind=r8) :: vn
real(kind=r8) :: vn_tl
real(kind=r8) :: vs
real(kind=r8) :: vs_tl
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk1_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)
real(kind=r8) :: ymass(im,jfirst:jlast+1)
real(kind=r8) :: ymass_tl(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
js1g1 = max(1,jfirst-1)
js2g1 = max(2,jfirst-1)
js2gcp1 = max(2,jfirst-ng_c-1)
jn1g1 = min(jm,jlast+1)
jn2gc = min(jm-1,jlast+ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc1 = js2gc
else
  js2gc1 = max(2,jfirst-ng_c+1)
endif
call vpol5_tl( u(1,jfirst),u_tm(1,jfirst),v(1,jfirst),v_tm(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gcp1, jn2gc
  do i = 1, im-1
    v2_tl(i,j) = v_tm(i+1,j)+v_tm(i,j)
    v2(i,j) = v(i,j)+v(i+1,j)
  end do
  v2_tl(im,j) = v_tm(im,j)+v_tm(1,j)
  v2(im,j) = v(im,j)+v(1,j)
end do
do j = js2gc, jn2gc
  do i = 1, im
    u2_tl(i,j) = u_tm(i,j+1)+u_tm(i,j)
    u2(i,j) = u(i,j)+u(i,j+1)
  end do
end do
if (jfirst .eq. 1) then
  us_tl = 0.d0
  us = 0.
  vs_tl = 0.d0
  vs = 0.
  do i = 1, im2
    us_tl = u2_tl(i+im2,2)*sinlon(i)-u2_tl(i,2)*sinlon(i)+us_tl-v2_tl(i+im2,2)*coslon(i)+v2_tl(i,2)*coslon(i)
    us = us+(u2(i+im2,2)-u2(i,2))*sinlon(i)+(v2(i,2)-v2(i+im2,2))*coslon(i)
    vs_tl = u2_tl(i+im2,2)*coslon(i)-u2_tl(i,2)*coslon(i)+v2_tl(i+im2,2)*sinlon(i)-v2_tl(i,2)*sinlon(i)+vs_tl
    vs = vs+(u2(i+im2,2)-u2(i,2))*coslon(i)+(v2(i+im2,2)-v2(i,2))*sinlon(i)
  end do
  us_tl = us_tl/dble(im)
  us = us/im
  vs_tl = vs_tl/dble(im)
  vs = vs/im
  do i = 1, im2
    u2_tl(i,1) = (-(us_tl*sinlon(i)))-vs_tl*coslon(i)
    u2(i,1) = (-(us*sinlon(i)))-vs*coslon(i)
    v2_tl(i,1) = us_tl*coslon(i)-vs_tl*sinlon(i)
    v2(i,1) = us*coslon(i)-vs*sinlon(i)
    u2_tl(i+im2,1) = -u2_tl(i,1)
    u2(i+im2,1) = -u2(i,1)
    v2_tl(i+im2,1) = -v2_tl(i,1)
    v2(i+im2,1) = -v2(i,1)
  end do
  p1ke_tl = 0.25*u2_tl(1,1)*u2(1,1)+0.25*v2_tl(1,1)*v2(1,1)
  p1ke = 0.125*(u2(1,1)**2+v2(1,1)**2)
endif
if (jlast .eq. jm) then
  un_tl = 0.d0
  un = 0.
  vn_tl = 0.d0
  vn = 0.
  j = jm-1
  do i = 1, im2
    un_tl = u2_tl(i+im2,j)*sinlon(i)-u2_tl(i,j)*sinlon(i)+un_tl+v2_tl(i+im2,j)*coslon(i)-v2_tl(i,j)*coslon(i)
    un = un+(u2(i+im2,j)-u2(i,j))*sinlon(i)+(v2(i+im2,j)-v2(i,j))*coslon(i)
    vn_tl = (-(u2_tl(i+im2,j)*coslon(i)))+u2_tl(i,j)*coslon(i)+v2_tl(i+im2,j)*sinlon(i)-v2_tl(i,j)*sinlon(i)+vn_tl
    vn = vn+(u2(i,j)-u2(i+im2,j))*coslon(i)+(v2(i+im2,j)-v2(i,j))*sinlon(i)
  end do
  un_tl = un_tl/dble(im)
  un = un/im
  vn_tl = vn_tl/dble(im)
  vn = vn/im
  do i = 1, im2
    u2_tl(i,jm) = (-(un_tl*sinlon(i)))+vn_tl*coslon(i)
    u2(i,jm) = (-(un*sinlon(i)))+vn*coslon(i)
    v2_tl(i,jm) = (-(un_tl*coslon(i)))-vn_tl*sinlon(i)
    v2(i,jm) = (-(un*coslon(i)))-vn*sinlon(i)
    u2_tl(i+im2,jm) = -u2_tl(i,jm)
    u2(i+im2,jm) = -u2(i,jm)
    v2_tl(i+im2,jm) = -v2_tl(i,jm)
    v2(i+im2,jm) = -v2(i,jm)
  end do
  p2ke_tl = 0.25*u2_tl(1,jm)*u2(1,jm)+0.25*v2_tl(1,jm)*v2(1,jm)
  p2ke = 0.125*(u2(1,jm)**2+v2(1,jm)**2)
endif
do j = js2gc, jn2gc
  uc_tl(1,j) = 0.25*u2_tl(im,j)+0.25*u2_tl(1,j)
  uc(1,j) = 0.25*(u2(1,j)+u2(im,j))
  do i = 2, im
    uc_tl(i,j) = 0.25*u2_tl(i-1,j)+0.25*u2_tl(i,j)
    uc(i,j) = 0.25*(u2(i,j)+u2(i-1,j))
  end do
end do
do i = 1, im
  vc_tl(i,jfirst-2) = 0.
  vc(i,jfirst-2) = 0.
  vc_tl(i,jfirst-1) = 0.
  vc(i,jfirst-1) = 0.
  vc_tl(i,jfirst) = 0.
  vc(i,jfirst) = 0.
  vc_tl(i,jlast+1) = 0.
  vc(i,jlast+1) = 0.
  vc_tl(i,jlast+2) = 0.
  vc(i,jlast+2) = 0.
end do
do j = js2gc, jn1gc
  do i = 1, im
    vc_tl(i,j) = 0.25*v2_tl(i,j-1)+0.25*v2_tl(i,j)
    vc(i,j) = 0.25*(v2(i,j)+v2(i,j-1))
  end do
end do
do j = js2g1, jn1g1
  do i = 1, im
    cry_tl(i,j) = vc_tl(i,j)*dtdy5
    cry(i,j) = dtdy5*vc(i,j)
  end do
end do
do j = js2g0, jn1g1
  do i = 1, im
    ymass_tl(i,j) = cry_tl(i,j)*cose(j)
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g1, jn2g0
  do i = 1, im
    va_tl(i,j) = 0.5*cry_tl(i,j+1)+0.5*cry_tl(i,j)
    va(i,j) = 0.5*(cry(i,j)+cry(i,j+1))
  end do
end do
do j = jfirst-1, jlast
  do i = 1, im
    crx_tl(i,j) = 0.d0
    crx(i,j) = 0.
  end do
end do
do j = js2gc, jn2gc
  do i = 1, im
    crx_tl(i,j) = uc_tl(i,j)*dtdx2(j)
    crx(i,j) = uc(i,j)*dtdx2(j)
  end do
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
call tp2c_tl( ptk,ptk_tl,va(1,jfirst),va_tl(1,jfirst),delpf(1,jfirst-ng_c),delpf_tl(1,jfirst-ng_c),crx(1,jfirst-ng_c),crx_tl(1,&
&jfirst-ng_c),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_c,xfx,xfx_tl,yfx,yfx_tl,ffsl,rcap,acosp,crx(1,jfirst),crx_tl(1,&
&jfirst),ymass,ymass_tl,cosp,0,jfirst,jlast )
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx_tl(i,j) = (-(crx_tl(i,j)*(xfx(i,j)*(0.5+sign(0.5d0,abs(crx(i,j))-tiny))*sign(1.d0,crx(i,j))*sign(1.d0,crx(i,j))*&
&sign(1.d0,max(abs(crx(i,j)),tiny))/(sign(max(abs(crx(i,j)),tiny),crx(i,j))*sign(max(abs(crx(i,j)),tiny),crx(i,j))))))+&
&xfx_tl(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
call tp2c_tl( tm2,tm2_tl,va(1,jfirst),va_tl(1,jfirst),pt(1,jfirst-ng_c),pt_tm(1,jfirst-ng_c),crx(1,jfirst-ng_c),crx_tl(1,jfirst-&
&ng_c),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_c,fx,fx_tl,fy(1,jfirst),fy_tl(1,jfirst),ffsl,rcap,acosp,xfx,xfx_tl,yfx,&
&yfx_tl,cosp,1,jfirst,jlast )
help_h = jn2g0-js2g0+1
call pft2d_tl( ptk(1,js2g0),ptk_tl(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,v2,v2_tl,crx )
help_i = jn2g0-js2g0+1
call pft2d_tl( tm2(1,js2g0),tm2_tl(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_i,ifax,trigs,v2,v2_tl,crx )
do j = jfirst, jlast
  do i = 1, im
    ptk_tl(i,j) = delp_tm(i,j)+ptk_tl(i,j)
    ptk(i,j) = delp(i,j)+ptk(i,j)
    ptc_tl(i,j) = delp_tm(i,j)*(pt(i,j)/ptk(i,j))+pt_tm(i,j)*(delp(i,j)/ptk(i,j))-ptk_tl(i,j)*((pt(i,j)*delp(i,j)+tm2(i,j))/(ptk(i,&
&j)*ptk(i,j)))+tm2_tl(i,j)/ptk(i,j)
    ptc(i,j) = (pt(i,j)*delp(i,j)+tm2(i,j))/ptk(i,j)
  end do
end do
call ycc_tl( im,jm,fy,fy_tl,vc(1,jfirst-2),vc_tl(1,jfirst-2),va(1,jfirst-1),va_tl(1,jfirst-1),va(1,jfirst-1),va_tl(1,jfirst-1),&
&jord,1,jfirst,jlast )
do j = js2g1, jn2g0
  do i = 1, im
    cx1_tl(i) = u2_tl(i,j)*dtdx4(j)
    cx1(i) = dtdx4(j)*u2(i,j)
  end do
  sld =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(cx1(i)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  p1d_tl(im) = uc_tl(1,j)
  p1d(im) = uc(1,j)
  do i = 1, im-1
    p1d_tl(i) = uc_tl(i+1,j)
    p1d(i) = uc(i+1,j)
  end do
  call xtp_tl( im,sld,fxj,fxj_tl,p1d,p1d_tl,cx1,cx1_tl,iord,cx1,cx1_tl,cosp(j),0,slope,slopek_tl,qtmp,qtmpk_tl,al,ar,a6,a6_tl )
  do i = 1, im
    wk1_tl(i,j) = fxj_tl(i)*dxdt(j)+fy_tl(i,j)*dydt
    wk1(i,j) = dxdt(j)*fxj(i)+dydt*fy(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1_tl(i,1) = p1ke_tl
    wk1(i,1) = p1ke
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    wk1_tl(i,jm) = p2ke_tl
    wk1(i,jm) = p2ke
  end do
endif
do j = js2gc1, jn1gc
  crx_tl(1,j) = u_tm(im,j)*dtxe5(j)
  crx(1,j) = dtxe5(j)*u(im,j)
  do i = 2, im
    crx_tl(i,j) = u_tm(i-1,j)*dtxe5(j)
    crx(i,j) = dtxe5(j)*u(i-1,j)
  end do
end do
do j = js1g1, jlast
  do i = 1, im
    cry_tl(i,j) = v_tm(i,j)*dtdy5
    cry(i,j) = dtdy5*v(i,j)
  end do
end do
do j = jfirst, jlast
  do i = 1, im
    ymass_tl(i,j) = cry_tl(i,j)*cosp(j)
    ymass(i,j) = cry(i,j)*cosp(j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im
    tm2_tl(i,j) = 0.5*cry_tl(i,j-1)+0.5*cry_tl(i,j)
    tm2(i,j) = 0.5*(cry(i,j)+cry(i,j-1))
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    u2_tl(i,1) = 0.d0
    u2(i,1) = 0.
  end do
endif
do j = js2gc, jn2gc
  do i = 1, im
    u2_tl(i,j) = uc_tl(i,j)*cosp(j)
    u2(i,j) = uc(i,j)*cosp(j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    u2_tl(i,jm) = 0.d0
    u2(i,jm) = 0.
  end do
endif
do j = js2gc1, jn1gc
  v2_tl(1,j) = u2_tl(1,j-1)*cye(j)-u2_tl(1,j)*cye(j)-vc_tl(im,j)*rdxe(j)+vc_tl(1,j)*rdxe(j)
  v2(1,j) = fc(j)+(u2(1,j-1)-u2(1,j))*cye(j)+(vc(1,j)-vc(im,j))*rdxe(j)
  do i = 2, im
    v2_tl(i,j) = u2_tl(i,j-1)*cye(j)-u2_tl(i,j)*cye(j)-vc_tl(i-1,j)*rdxe(j)+vc_tl(i,j)*rdxe(j)
    v2(i,j) = fc(j)+(u2(i,j-1)-u2(i,j))*cye(j)+(vc(i,j)-vc(i-1,j))*rdxe(j)
  end do
end do
do j = js2gc1, jn1gc
  ffsl(j) =  .false. 
  if (cose(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
call tpcc_tl( tm2,tm2_tl,ymass,ymass_tl,v2(1,jfirst-ng_d),v2_tl(1,jfirst-ng_d),crx(1:im,jfirst-1:jlast+2),crx_tl(1:im,jfirst-1:&
&jlast+2),cry(1:im,jfirst:jlast),cry_tl(1:im,jfirst:jlast),im,jm,ng_d,iord,jord,fx,fx_tl,fy(1:im,jfirst:jlast),fy_tl(1:im,jfirst:&
&jlast),ffsl,cose,jfirst,jlast,slope,qtmp,al,ar,a6,a6_tl )
do j = js2g0, jn2g0
  uc_tl(1,j) = fy_tl(1,j)*dycp(j)+uc_tl(1,j)+wk1_tl(im,j)*dtdx2(j)-wk1_tl(1,j)*dtdx2(j)
  uc(1,j) = uc(1,j)+dtdx2(j)*(wk1(im,j)-wk1(1,j))+dycp(j)*fy(1,j)
  do i = 2, im
    uc_tl(i,j) = fy_tl(i,j)*dycp(j)+uc_tl(i,j)+wk1_tl(i-1,j)*dtdx2(j)-wk1_tl(i,j)*dtdx2(j)
    uc(i,j) = uc(i,j)+dtdx2(j)*(wk1(i-1,j)-wk1(i,j))+dycp(j)*fy(i,j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im-1
    vc_tl(i,j) = (-(fx_tl(i+1,j)*dxe(j)))+vc_tl(i,j)+wk1_tl(i,j-1)*dtdy5-wk1_tl(i,j)*dtdy5
    vc(i,j) = vc(i,j)+dtdy5*(wk1(i,j-1)-wk1(i,j))-dxe(j)*fx(i+1,j)
  end do
  vc_tl(im,j) = (-(fx_tl(1,j)*dxe(j)))+vc_tl(im,j)+wk1_tl(im,j-1)*dtdy5-wk1_tl(im,j)*dtdy5
  vc(im,j) = vc(im,j)+dtdy5*(wk1(im,j-1)-wk1(im,j))-dxe(j)*fx(1,j)
end do

end subroutine c_sw_tl


subroutine d_sw_tl( u, u_tm, v, v_tm, uc, uc_tl, vc, vc_tl, pt, pt_tm, delp, delp_tm, delpf, delpf_tl, cx3, cx3_tl, cy3, cy3_tl, &
&mfx, mfx_tl, mfy, mfy_tl, cdx, cdy, dtdx, dtdxe, dtxe5, txe5, dyce, rdx, cy, dx, f0, js2g0, jn1g1, im, jm, jfirst, jlast, ng_d, &
&ng_s, nq, iord, jord, zt_d, rcap, tiny, dtdy, dtdy5, tdy5, rdy, cosp, acosp, cose, coslon, sinlon, cosl5, sinl5 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
integer, intent(in) :: jn1g1
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: cdx(js2g0:jn1g1)
real(kind=r8), intent(in) :: cdy(js2g0:jn1g1)
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
integer, intent(in) :: ng_d
real(kind=r8), intent(inout) :: cx3(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: cx3_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: cy(jm)
real(kind=r8), intent(inout) :: cy3(im,jfirst:jlast+1)
real(kind=r8), intent(inout) :: cy3_tl(im,jfirst:jlast+1)
real(kind=r8), intent(inout) :: delp(im,jfirst:jlast)
real(kind=r8), intent(inout) :: delp_tm(im,jfirst:jlast)
real(kind=r8), intent(inout) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: delpf_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx(jm)
real(kind=r8), intent(in) :: dtdxe(jm)
real(kind=r8), intent(in) :: dtdy
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dx(jm)
real(kind=r8), intent(in) :: dyce(jm)
real(kind=r8), intent(in) :: f0(jfirst-ng_d:jlast+ng_d)
integer, intent(in) :: iord
integer, intent(in) :: jord
real(kind=r8), intent(inout) :: mfx(im,jfirst:jlast)
real(kind=r8), intent(inout) :: mfx_tl(im,jfirst:jlast)
real(kind=r8), intent(inout) :: mfy(im,jfirst:jlast+1)
real(kind=r8), intent(inout) :: mfy_tl(im,jfirst:jlast+1)
integer, intent(in) :: ng_s
integer, intent(in) :: nq
real(kind=r8), intent(inout) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: pt_tm(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdx(jm)
real(kind=r8), intent(in) :: rdy
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tdy5
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: txe5(jm)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(in) :: u_tm(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(inout) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(inout) :: uc_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(in) :: v_tm(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(inout) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(inout) :: vc_tl(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_d

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c1
real(kind=r8) :: c1_tl
real(kind=r8) :: c2
real(kind=r8) :: c2_tl
real(kind=r8) :: crx(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: crx_tl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: cry_tl(im,jfirst-1:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tl(im,jfirst:jlast)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxj_tl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fy_tl(im,jfirst-1:jlast+1)
integer :: i
integer :: j
integer :: jn1gd
integer :: jn2g0
integer :: jn2g1
integer :: jn2gd
integer :: js2gd
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpi_tl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopei_tl(1+im+2*(im/3))
real(kind=r8) :: ub(im,jfirst:jlast+1)
real(kind=r8) :: ub_tl(im,jfirst:jlast+1)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: va_tl(im,jfirst-1:jlast)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk1_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_tl(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_tl(im,jfirst:jlast+1)
real(kind=r8) :: ymass(im,jfirst:jlast+1)
real(kind=r8) :: ymass_tl(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
jn2g0 = min(jm-1,jlast)
jn2g1 = min(jm-1,jlast+1)
js2gd = max(2,jfirst-ng_d)
jn2gd = min(jm-1,jlast+ng_d)
jn1gd = min(jm,jlast+ng_d)
call upol5_tl( uc(1,jfirst),uc_tl(1,jfirst),vc(1,jfirst),vc_tl(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gd, jn2gd
  do i = 1, im
    crx_tl(i,j) = uc_tl(i,j)*dtdx(j)
    crx(i,j) = dtdx(j)*uc(i,j)
  end do
end do
do j = js2gd, jn2gd
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_d) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
do j = js2g0, jn1g1
  do i = 1, im
    cry_tl(i,j) = vc_tl(i,j)*dtdy
    cry(i,j) = dtdy*vc(i,j)
    ymass_tl(i,j) = cry_tl(i,j)*cose(j)
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g0, jn2g0
  do i = 1, im
    if (cry(i,j)*cry(i,j+1) .gt. 0.) then
      if (cry(i,j) .gt. 0.) then
        va_tl(i,j) = cry_tl(i,j)
        va(i,j) = cry(i,j)
      else
        va_tl(i,j) = cry_tl(i,j+1)
        va(i,j) = cry(i,j+1)
      endif
    else
      va_tl(i,j) = 0.d0
      va(i,j) = 0.
    endif
  end do
end do
call tp2c_tl( ub(1,jfirst),ub_tl(1,jfirst),va(1,jfirst),va_tl(1,jfirst),delpf(1,jfirst-ng_d),delpf_tl(1,jfirst-ng_d),crx(1,jfirst-&
&ng_d),crx_tl(1,jfirst-ng_d),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_d,xfx,xfx_tl,yfx,yfx_tl,ffsl,rcap,acosp,crx(1,&
&jfirst),crx_tl(1,jfirst),ymass,ymass_tl,cosp,0,jfirst,jlast )
if (nq .gt. 0) then
  do j = js2g0, jn2g0
    do i = 1, im
      cx3_tl(i,j) = crx_tl(i,j)+cx3_tl(i,j)
      cx3(i,j) = cx3(i,j)+crx(i,j)
      mfx_tl(i,j) = mfx_tl(i,j)+xfx_tl(i,j)
      mfx(i,j) = mfx(i,j)+xfx(i,j)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      cy3_tl(i,j) = cry_tl(i,j)+cy3_tl(i,j)
      cy3(i,j) = cy3(i,j)+cry(i,j)
      mfy_tl(i,j) = mfy_tl(i,j)+yfx_tl(i,j)
      mfy(i,j) = mfy(i,j)+yfx(i,j)
    end do
  end do
endif
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx_tl(i,j) = (-(crx_tl(i,j)*(xfx(i,j)*(0.5+sign(0.5d0,abs(crx(i,j))-tiny))*sign(1.d0,crx(i,j))*sign(1.d0,crx(i,j))*&
&sign(1.d0,max(abs(crx(i,j)),tiny))/(sign(max(abs(crx(i,j)),tiny),crx(i,j))*sign(max(abs(crx(i,j)),tiny),crx(i,j))))))+&
&xfx_tl(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
do j = jfirst, jlast
  do i = 1, im
    wk1_tl(i,j) = delp_tm(i,j)
    wk1(i,j) = delp(i,j)
    delp_tm(i,j) = ub_tl(i,j)+wk1_tl(i,j)
    delp(i,j) = wk1(i,j)+ub(i,j)
  end do
end do
call tp2c_tl( ub(1,jfirst),ub_tl(1,jfirst),va(1,jfirst),va_tl(1,jfirst),pt(1,jfirst-ng_d),pt_tm(1,jfirst-ng_d),crx(1,jfirst-ng_d),&
&crx_tl(1,jfirst-ng_d),cry(1,jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_d,fx,fx_tl,fy(1:im,jfirst:jlast+1),fy_tl(1:im,jfirst:&
&jlast+1),ffsl,rcap,acosp,xfx,xfx_tl,yfx(1,jfirst),yfx_tl(1,jfirst),cosp,1,jfirst,jlast )
do j = jfirst, jlast
  do i = 1, im
    pt_tm(i,j) = (-(delp_tm(i,j)*((pt(i,j)*wk1(i,j)+ub(i,j))/(delp(i,j)*delp(i,j)))))+pt_tm(i,j)*(wk1(i,j)/delp(i,j))+ub_tl(i,j)/&
&delp(i,j)+wk1_tl(i,j)*(pt(i,j)/delp(i,j))
    pt(i,j) = (pt(i,j)*wk1(i,j)+ub(i,j))/delp(i,j)
  end do
end do
do j = js2g0, jn1g1
  ub_tl(1,j) = (vc_tl(im,j)+vc_tl(1,j))*dtdy5
  ub(1,j) = dtdy5*(vc(1,j)+vc(im,j))
  do i = 2, im
    ub_tl(i,j) = (vc_tl(i-1,j)+vc_tl(i,j))*dtdy5
    ub(i,j) = dtdy5*(vc(i,j)+vc(i-1,j))
  end do
end do
call ytp_tl( im,jm,fy(1:im,jfirst:jlast+1),fy_tl(1:im,jfirst:jlast+1),v(1,jfirst-ng_d),v_tm(1,jfirst-ng_d),ub(1,jfirst),ub_tl(1,&
&jfirst),ub(1,jfirst),ub_tl(1,jfirst),ng_d,jord,1,jfirst,jlast )
do j = js2g0, jn1g1
  do i = 1, im
    ub_tl(i,j) = (uc_tl(i,j-1)+uc_tl(i,j))*dtxe5(j)
    ub(i,j) = dtxe5(j)*(uc(i,j)+uc(i,j-1))
  end do
end do
do j = js2g0, jn1g1
  sld =  .false. 
  if (cose(j) .lt. zt_d) then
    do i = 1, im
      if (abs(ub(i,j)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  call xtp_tl( im,sld,fxj,fxj_tl,u(1,j),u_tm(1,j),ub(1,j),ub_tl(1,j),iord,ub(1,j),ub_tl(1,j),cose(j),0,slope,slopei_tl,qtmp,&
&qtmpi_tl,al,ar,a6,a6_tl )
  do i = 1, im
    wk1_tl(i,j) = fxj_tl(i)*txe5(j)+fy_tl(i,j)*tdy5
    wk1(i,j) = txe5(j)*fxj(i)+tdy5*fy(i,j)
  end do
end do
do j = max(2,jfirst-1), jn2g1
  do i = 1, im
    fy_tl(i,j) = v_tm(i,j)*cosp(j)
    fy(i,j) = v(i,j)*cosp(j)
  end do
end do
do j = js2g0, jn1g1
  uc_tl(1,j) = u_tm(im,j)-u_tm(1,j)
  uc(1,j) = u(im,j)-u(1,j)
  do i = 2, im
    uc_tl(i,j) = u_tm(i-1,j)-u_tm(i,j)
    uc(i,j) = u(i-1,j)-u(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1_tl(i,2) = (-(fy_tl(i,2)*cdy(2)))+uc_tl(i,2)*cdx(2)+wk1_tl(i,2)
    wk1(i,2) = wk1(i,2)-cdy(2)*fy(i,2)+cdx(2)*uc(i,2)
  end do
endif
do j = max(3,jfirst), jn2g1
  do i = 1, im
    wk1_tl(i,j) = fy_tl(i,j-1)*cdy(j)-fy_tl(i,j)*cdy(j)+uc_tl(i,j)*cdx(j)+wk1_tl(i,j)
    wk1(i,j) = wk1(i,j)+cdy(j)*(fy(i,j-1)-fy(i,j))+cdx(j)*uc(i,j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    wk1_tl(i,jm) = fy_tl(i,jm-1)*cdy(jm)+uc_tl(i,jm)*cdx(jm)+wk1_tl(i,jm)
    wk1(i,jm) = wk1(i,jm)+cdy(jm)*fy(i,jm-1)+cdx(jm)*uc(i,jm)
  end do
endif
do j = js2gd, jn1gd
  do i = 1, im
    delpf_tl(i,j) = u_tm(i,j)*cose(j)
    delpf(i,j) = u(i,j)*cose(j)
  end do
end do
if (jfirst .eq. 1) then
  c1_tl = 0.d0
  c1 = 0.
  do i = 1, im
    c1_tl = c1_tl+delpf_tl(i,2)
    c1 = c1+delpf(i,2)
  end do
  c1_tl = -(c1_tl*rdy*rcap)
  c1 = -(c1*rdy*rcap)
  do i = 1, im
    uc_tl(i,1) = c1_tl
    uc(i,1) = c1
  end do
endif
if (jlast .eq. jm) then
  c2_tl = 0.d0
  c2 = 0.
  do i = 1, im
    c2_tl = c2_tl+delpf_tl(i,jm)
    c2 = c2+delpf(i,jm)
  end do
  c2_tl = c2_tl*rdy*rcap
  c2 = c2*rdy*rcap
  do i = 1, im
    uc_tl(i,jm) = c2_tl
    uc(i,jm) = c2
  end do
else
  do i = 1, im
    uc_tl(i,jn2gd) = 0.
    uc(i,jn2gd) = 1.e+30
  end do
endif
do j = js2gd, min(jm-1,jlast+ng_d-1)
  do i = 1, im-1
    uc_tl(i,j) = (-(delpf_tl(i,j+1)*cy(j)))+delpf_tl(i,j)*cy(j)+v_tm(i+1,j)*rdx(j)-v_tm(i,j)*rdx(j)
    uc(i,j) = (delpf(i,j)-delpf(i,j+1))*cy(j)+(v(i+1,j)-v(i,j))*rdx(j)
  end do
  uc_tl(im,j) = (-(delpf_tl(im,j+1)*cy(j)))+delpf_tl(im,j)*cy(j)-v_tm(im,j)*rdx(j)+v_tm(1,j)*rdx(j)
  uc(im,j) = (delpf(im,j)-delpf(im,j+1))*cy(j)+(v(1,j)-v(im,j))*rdx(j)
end do
do j = max(1,jfirst-ng_d), jn1gd
  do i = 1, im
    uc(i,j) = uc(i,j)+f0(j)
  end do
end do
call tp2d_tl( va(1,jfirst),va_tl(1,jfirst),uc(1,jfirst-ng_d),uc_tl(1,jfirst-ng_d),crx(1,jfirst-ng_d),crx_tl(1,jfirst-ng_d),cry(1,&
&jfirst),cry_tl(1,jfirst),im,jm,iord,jord,ng_d,fx,fx_tl,fy(1:im,jfirst:jlast+1),fy_tl(1:im,jfirst:jlast+1),ffsl,crx(1,jfirst),&
&crx_tl(1,jfirst),ymass,ymass_tl,cosp,0,jfirst,jlast )
do j = js2g0, jlast
  do i = 1, im-1
    uc_tl(i,j) = fy_tl(i,j)*dyce(j)-wk1_tl(i+1,j)*dtdxe(j)+wk1_tl(i,j)*dtdxe(j)
    uc(i,j) = dtdxe(j)*(wk1(i,j)-wk1(i+1,j))+dyce(j)*fy(i,j)
  end do
  uc_tl(im,j) = fy_tl(im,j)*dyce(j)+wk1_tl(im,j)*dtdxe(j)-wk1_tl(1,j)*dtdxe(j)
  uc(im,j) = dtdxe(j)*(wk1(im,j)-wk1(1,j))+dyce(j)*fy(im,j)
end do
do j = js2g0, jn2g0
  do i = 1, im
    vc_tl(i,j) = (-(fx_tl(i,j)*dx(j)))-wk1_tl(i,j+1)*dtdy+wk1_tl(i,j)*dtdy
    vc(i,j) = dtdy*(wk1(i,j)-wk1(i,j+1))-dx(j)*fx(i,j)
  end do
end do

end subroutine d_sw_tl


end module     sw_core_tl


#endif /* SPMD */
