#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine pkez_tl( nx, im, km, jfirst, jlast, pe, pe_tm, pk, pk_tm, akap, ks, peln, peln_tl, pkz, pkz_tm, eta )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: eta
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ks
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: peln_tl(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pk_tm(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_tm(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
real(kind=r8) :: lnp
real(kind=r8) :: lnp_tl
real(kind=r8) :: pek
real(kind=r8) :: pek_tl
real(kind=r8) :: pk2(im,km+1)
real(kind=r8) :: pk2_tl(im,km+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do private(i,i1,i2,ixj,j,k,lnp,lnp_tl,pek,pek_tl,pk2,pk2_tl)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  if (eta) then
    pek_tl = pk_tm(i1,j,1)
    pek = pk(i1,j,1)
    lnp_tl = pe_tm(i1,1,j)*(1./pe(i1,1,j))
    lnp = log(pe(i1,1,j))
    do i = i1, i2
      pk2_tl(i,1) = pek_tl
      pk2(i,1) = pek
      peln_tl(i,1,j) = lnp_tl
      peln(i,1,j) = lnp
    end do
    if (ks .ne. 0) then
      do k = 2, ks+1
        pek_tl = pe_tm(i1,k,j)*akap*pe(i1,k,j)**(akap-1)
        pek = pe(i1,k,j)**akap
        lnp_tl = pe_tm(i1,k,j)*(1./pe(i1,k,j))
        lnp = log(pe(i1,k,j))
        do i = i1, i2
          pk2_tl(i,k) = pek_tl
          pk2(i,k) = pek
          peln_tl(i,k,j) = lnp_tl
          peln(i,k,j) = lnp
        end do
      end do
      do k = 1, ks
        pek_tl = (-(peln_tl(i1,k+1,j)*((pk2(i1,k+1)-pk2(i1,k))*akap/(akap*(peln(i1,k+1,j)-peln(i1,k,j))*akap*(peln(i1,k+1,j)-&
&peln(i1,k,j))))))+peln_tl(i1,k,j)*((pk2(i1,k+1)-pk2(i1,k))*akap/(akap*(peln(i1,k+1,j)-peln(i1,k,j))*akap*(peln(i1,k+1,j)-&
&peln(i1,k,j))))+pk2_tl(i1,k+1)/(akap*(peln(i1,k+1,j)-peln(i1,k,j)))-pk2_tl(i1,k)/(akap*(peln(i1,k+1,j)-peln(i1,k,j)))
        pek = (pk2(i1,k+1)-pk2(i1,k))/(akap*(peln(i1,k+1,j)-peln(i1,k,j)))
        do i = i1, i2
          pkz_tm(i,j,k) = pek_tl
          pkz(i,j,k) = pek
        end do
      end do
    endif
    do k = ks+2, km
      do i = i1, i2
        pk2_tl(i,k) = pe_tm(i,k,j)*akap*pe(i,k,j)**(akap-1)
        pk2(i,k) = pe(i,k,j)**akap
      end do
    end do
    do i = i1, i2
      pk2_tl(i,km+1) = pk_tm(i,j,km+1)
      pk2(i,km+1) = pk(i,j,km+1)
    end do
    do k = ks+2, km+1
      do i = i1, i2
        peln_tl(i,k,j) = pe_tm(i,k,j)*(1./pe(i,k,j))
        peln(i,k,j) = log(pe(i,k,j))
      end do
    end do
    do k = ks+1, km
      do i = i1, i2
        pkz_tm(i,j,k) = (-(peln_tl(i,k+1,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-&
&peln(i,k,j))))))+peln_tl(i,k,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-peln(i,&
&k,j))))+pk2_tl(i,k+1)/(akap*(peln(i,k+1,j)-peln(i,k,j)))-pk2_tl(i,k)/(akap*(peln(i,k+1,j)-peln(i,k,j)))
        pkz(i,j,k) = (pk2(i,k+1)-pk2(i,k))/(akap*(peln(i,k+1,j)-peln(i,k,j)))
      end do
    end do
    do k = 2, km
      do i = i1, i2
        pk_tm(i,j,k) = pk2_tl(i,k)
        pk(i,j,k) = pk2(i,k)
      end do
    end do
  else
    pek_tl = pk_tm(i1,j,1)
    pek = pk(i1,j,1)
    lnp_tl = pe_tm(i1,1,j)*(1./pe(i1,1,j))
    lnp = log(pe(i1,1,j))
    do i = i1, i2
      pk2_tl(i,1) = pek_tl
      pk2(i,1) = pek
      peln_tl(i,1,j) = lnp_tl
      peln(i,1,j) = lnp
    end do
    do k = 2, km+1
      do i = i1, i2
        peln_tl(i,k,j) = pe_tm(i,k,j)*(1./pe(i,k,j))
        peln(i,k,j) = log(pe(i,k,j))
        pk2_tl(i,k) = pk_tm(i,j,k)
        pk2(i,k) = pk(i,j,k)
      end do
    end do
    do k = 1, km
      do i = i1, i2
        pkz_tm(i,j,k) = (-(peln_tl(i,k+1,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-&
&peln(i,k,j))))))+peln_tl(i,k,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-peln(i,&
&k,j))))+pk2_tl(i,k+1)/(akap*(peln(i,k+1,j)-peln(i,k,j)))-pk2_tl(i,k)/(akap*(peln(i,k+1,j)-peln(i,k,j)))
        pkz(i,j,k) = (pk2(i,k+1)-pk2(i,k))/(akap*(peln(i,k+1,j)-peln(i,k,j)))
      end do
    end do
  endif
end do

end subroutine pkez_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine pkez_tl( nx, im, km, jfirst, jlast, pe, pe_tm, pk, pk_tm, akap, ks, peln, peln_tl, pkz, pkz_tm, eta )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: eta
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ks
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: peln_tl(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pk_tm(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_tm(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
real(kind=r8) :: lnp
real(kind=r8) :: lnp_tl
real(kind=r8) :: pek
real(kind=r8) :: pek_tl
real(kind=r8) :: pk2(im,km+1)
real(kind=r8) :: pk2_tl(im,km+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do private(i,i1,i2,ixj,j,k,lnp,lnp_tl,pek,pek_tl,pk2,pk2_tl)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  if (eta) then
    pek_tl = pk_tm(i1,j,1)
    pek = pk(i1,j,1)
    lnp_tl = pe_tm(i1,1,j)*(1./pe(i1,1,j))
    lnp = log(pe(i1,1,j))
    do i = i1, i2
      pk2_tl(i,1) = pek_tl
      pk2(i,1) = pek
      peln_tl(i,1,j) = lnp_tl
      peln(i,1,j) = lnp
    end do
    if (ks .ne. 0) then
      do k = 2, ks+1
        pek_tl = pe_tm(i1,k,j)*akap*pe(i1,k,j)**(akap-1)
        pek = pe(i1,k,j)**akap
        lnp_tl = pe_tm(i1,k,j)*(1./pe(i1,k,j))
        lnp = log(pe(i1,k,j))
        do i = i1, i2
          pk2_tl(i,k) = pek_tl
          pk2(i,k) = pek
          peln_tl(i,k,j) = lnp_tl
          peln(i,k,j) = lnp
        end do
      end do
      do k = 1, ks
        pek_tl = (-(peln_tl(i1,k+1,j)*((pk2(i1,k+1)-pk2(i1,k))*akap/(akap*(peln(i1,k+1,j)-peln(i1,k,j))*akap*(peln(i1,k+1,j)-&
&peln(i1,k,j))))))+peln_tl(i1,k,j)*((pk2(i1,k+1)-pk2(i1,k))*akap/(akap*(peln(i1,k+1,j)-peln(i1,k,j))*akap*(peln(i1,k+1,j)-&
&peln(i1,k,j))))+pk2_tl(i1,k+1)/(akap*(peln(i1,k+1,j)-peln(i1,k,j)))-pk2_tl(i1,k)/(akap*(peln(i1,k+1,j)-peln(i1,k,j)))
        pek = (pk2(i1,k+1)-pk2(i1,k))/(akap*(peln(i1,k+1,j)-peln(i1,k,j)))
        do i = i1, i2
          pkz_tm(i,j,k) = pek_tl
          pkz(i,j,k) = pek
        end do
      end do
    endif
    do k = ks+2, km
      do i = i1, i2
        pk2_tl(i,k) = pe_tm(i,k,j)*akap*pe(i,k,j)**(akap-1)
        pk2(i,k) = pe(i,k,j)**akap
      end do
    end do
    do i = i1, i2
      pk2_tl(i,km+1) = pk_tm(i,j,km+1)
      pk2(i,km+1) = pk(i,j,km+1)
    end do
    do k = ks+2, km+1
      do i = i1, i2
        peln_tl(i,k,j) = pe_tm(i,k,j)*(1./pe(i,k,j))
        peln(i,k,j) = log(pe(i,k,j))
      end do
    end do
    do k = ks+1, km
      do i = i1, i2
        pkz_tm(i,j,k) = (-(peln_tl(i,k+1,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-&
&peln(i,k,j))))))+peln_tl(i,k,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-peln(i,&
&k,j))))+pk2_tl(i,k+1)/(akap*(peln(i,k+1,j)-peln(i,k,j)))-pk2_tl(i,k)/(akap*(peln(i,k+1,j)-peln(i,k,j)))
        pkz(i,j,k) = (pk2(i,k+1)-pk2(i,k))/(akap*(peln(i,k+1,j)-peln(i,k,j)))
      end do
    end do
    do k = 2, km
      do i = i1, i2
        pk_tm(i,j,k) = pk2_tl(i,k)
        pk(i,j,k) = pk2(i,k)
      end do
    end do
  else
    pek_tl = pk_tm(i1,j,1)
    pek = pk(i1,j,1)
    lnp_tl = pe_tm(i1,1,j)*(1./pe(i1,1,j))
    lnp = log(pe(i1,1,j))
    do i = i1, i2
      pk2_tl(i,1) = pek_tl
      pk2(i,1) = pek
      peln_tl(i,1,j) = lnp_tl
      peln(i,1,j) = lnp
    end do
    do k = 2, km+1
      do i = i1, i2
        peln_tl(i,k,j) = pe_tm(i,k,j)*(1./pe(i,k,j))
        peln(i,k,j) = log(pe(i,k,j))
        pk2_tl(i,k) = pk_tm(i,j,k)
        pk2(i,k) = pk(i,j,k)
      end do
    end do
    do k = 1, km
      do i = i1, i2
        pkz_tm(i,j,k) = (-(peln_tl(i,k+1,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-&
&peln(i,k,j))))))+peln_tl(i,k,j)*((pk2(i,k+1)-pk2(i,k))*akap/(akap*(peln(i,k+1,j)-peln(i,k,j))*akap*(peln(i,k+1,j)-peln(i,&
&k,j))))+pk2_tl(i,k+1)/(akap*(peln(i,k+1,j)-peln(i,k,j)))-pk2_tl(i,k)/(akap*(peln(i,k+1,j)-peln(i,k,j)))
        pkz(i,j,k) = (pk2(i,k+1)-pk2(i,k))/(akap*(peln(i,k+1,j)-peln(i,k,j)))
      end do
    end do
  endif
end do

end subroutine pkez_tl


#endif /* SPMD */
