#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
!  
! !REVISION HISTORY:
!
!  14May2007 Todling Introduced dyn_prog; global change.
!  17May2007 Todling Largely revampped from original code:
!                    - turned into model
!                    - interfaces 1 and 2
!  31May2007 Todling Add hook to handle g5-perturbation
!  11Dec2009 Todling Add tlfirst/last to allow incremental and
!                    single-shot integrations to be the same
!  
!
module m_model_tl

!==============================================
! referencing used modules
!==============================================
use precision
use prognostics, only : prognostics_zero
use prognostics, only : prognostics_dup
use prognostics, only : prognostics_initial
use prognostics, only : prognostics_final
use prognostics, only : dyn_prog
use prognostics_tl, only : prognostics_initial_tl
use prognostics_tl, only : prognostics_final_tl
use stepon, only : stepon_set
use stepon, only : nymd
use stepon, only : nhms
use stepon, only : ninner
use stepon, only : nouter
use stepon, only : nstep
use stepon_tl, only : stepon_do_tl
use stepon_tl, only : stepon_set_tl
use mapz_module_tl, only : mapz_module_initial_tl
use mapz_module_tl, only : mapz_module_final_tl
use m_zeit, only : zeit_ci
use m_zeit, only : zeit_co

implicit none

PRIVATE
PUBLIC amodel_tl
PUBLIC initial_tl
PUBLIC final_tl

interface amodel_tl; module procedure &
          model_tl1_, &
          model_tl2_
end interface amodel_tl

contains
subroutine model_tl1_( pert_tl, nymdi, nhmsi, ntsteps, g5pert, tlfirst,tllast )

implicit none

!==============================================
! declare arguments
!==============================================
type(dyn_prog) :: pert_tl
integer,optional,intent(in)::nymdi   ! initial date
integer,optional,intent(in)::nhmsi   ! initial time
integer,optional,intent(in)::ntsteps ! number of time steps
logical,optional,intent(in)::g5pert  ! specifies whether or not i/o is GEOS-5 perturbation
logical,optional,intent(in)::tlfirst ! if g5pert=.t.: when .t. converts input vector to g5type
logical,optional,intent(in)::tllast  ! if g5pert=.t.: when .t. converts output to g5pert type

type(dyn_prog) :: prog
type(dyn_prog) :: xpert
type(dyn_prog) :: ypert

logical, save :: setup = .true.
integer i,nymds,nhmss,nouters,nstepsv
logical reset

!----------------------------------------------
! RESET TIME IN TLM
!----------------------------------------------
reset = present(nymdi) .and. present(nhmsi) .and. present(ntsteps)
if ( reset ) then
     nstepsv= ninner+(nouter-1)*ninner
     nymds  = nymd ; nhmss=nhms ; nouters=nouter
     nymd   = nymdi; nhms =nhmsi; nouter =ntsteps
     setup  = .false.
endif

!----------------------------------------------
! RESET GLOBAL TANGENT VARIABLES
!----------------------------------------------
call prognostics_initial ( xpert )
call prognostics_initial ( ypert )

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------

call prognostics_dup ( pert_tl, xpert )

call model_tl2_ ( xpert, ypert, setup=setup, g5pert=g5pert, tlfirst=tlfirst, tllast=tllast )

call prognostics_zero ( pert_tl )
call prognostics_dup  ( ypert, pert_tl )

!----------------------------------------------
! FINALIZE GLOBAL TANGENT VARIABLES
!----------------------------------------------
call prognostics_final ( ypert )
call prognostics_final ( xpert )

!----------------------------------------------
! RESET TIME BACK TO ORIGINAL IN TLM
!----------------------------------------------
if ( reset ) then
     nstep  = nstepsv
     nymd   = nymds; nhms =nhmss; nouter =nouters
     setup  = .true.
endif

end subroutine model_tl1_

subroutine model_tl2_( xpert, ypert, setup, g5pert, tlfirst, tllast )

implicit none

!==============================================
! declare arguments
!==============================================
type(dyn_prog) :: xpert
type(dyn_prog) :: ypert
logical,optional,intent(in) :: setup
logical,optional,intent(in) :: g5pert
logical,optional,intent(in) :: tlfirst
logical,optional,intent(in) :: tllast

type(dyn_prog) :: prog
logical, save :: setup_  = .true.
logical, save :: g5pert_ = .false.
logical, save :: tlfirst_= .true.
logical, save :: tllast_ = .true.
integer i

if (present(setup)) then
    setup_ = setup
endif
if (present(g5pert)) then
    g5pert_ = g5pert
endif
if (present(tlfirst)) then
    tlfirst_ = tlfirst
endif
if (present(tllast)) then
    tllast_ = tllast
endif
!----------------------------------------------
! RESET GLOBAL TANGENT VARIABLES
!----------------------------------------------
call prognostics_initial ( prog )
if(setup_) call initial_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (setup_) then
    call stepon_set ( prog )
    call stepon_set_tl ( ypert )
endif

   call zeit_ci('stptlm')
call stepon_do_tl  ( g5pert_, tlfirst_, tllast_, prog, xpert, ypert )
   call zeit_co('stptlm')

!----------------------------------------------
! FINALIZE GLOBAL TANGENT VARIABLES
!----------------------------------------------
if(setup_) call final_tl
call prognostics_final ( prog )

end subroutine model_tl2_

subroutine initial_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!----------------------------------------------
! reset tangent module variables
!----------------------------------------------
call mapz_module_initial_tl
call prognostics_initial_tl

end subroutine initial_tl

subroutine final_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!----------------------------------------------
! reset tangent module variables
!----------------------------------------------
call mapz_module_final_tl
call prognostics_final_tl

end subroutine final_tl

end module m_model_tl

#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine model_tl( n, x, x_tl, fc, fc_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use prognostics
use prognostics_tl
use stepon, only : ninner,nouter,stepon_do, stepon_set
use stepon, only : stepon_tape_rec
use timingmodule
use stepon_tl, only : stepon_do_tl, stepon_set_tl
use control_tl, only : cont2mod_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: fc
real(kind=r8) :: fc_tl
integer :: n
real(kind=r8) :: x(n)
real(kind=r8) :: x_tl(n)

!----------------------------------------------
! RESET GLOBAL TANGENT VARIABLES
!----------------------------------------------
call zero_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
call g_timing_on( 'TOTAL' )
call stepon_set_tl
call stepon_set
call cont2mod_tl( n,x,x_tl )
call g_timing_on( 'stepon' )
call stepon_do_tl
call g_timing_off( 'stepon' )
call cost_tl( fc,fc_tl )
call g_timing_off( 'TOTAL' )

!----------------------------------------------
! FINALIZE GLOBAL TANGENT VARIABLES
!----------------------------------------------
call final_tl

end subroutine model_tl


subroutine zero_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use prognostics
use stepon, only : ninner,nouter,stepon_do, stepon_set
use stepon, only : stepon_tape_rec
use timingmodule
use prognostics_tl, only : prognostics_initial_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none


!----------------------------------------------
! reset tangent module variables
!----------------------------------------------
call prognostics_initial_tl

end subroutine zero_tl


subroutine final_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use prognostics
use stepon, only : ninner,nouter,stepon_do, stepon_set
use stepon, only : stepon_tape_rec
use timingmodule
use prognostics_tl, only : prognostics_final_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none


!----------------------------------------------
! reset tangent module variables
!----------------------------------------------
call prognostics_final_tl

end subroutine final_tl


#endif /* SPMD */
