#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     hswf_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use hswf

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine hswf_do_tl( im, jm, km, jfirst, jlast, u, u_tm, v, v_tm, pt, pt_tm, pe, pe_tm, pkz, pkz_tm, pdt, akap, dcaf, strat, &
&rayf, cosp, coslon, sinlon, ng_s, ng_d )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use mod_comm, only : gid,gsize,mp_barrier, mp_recv_n, mp_recv_pe, mp_recv_ua, mp_send_pe, mp_send_s, mp_send_ua

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
integer :: im
real(kind=r8) :: coslon(im)
integer :: jm
real(kind=r8) :: cosp(jm)
logical :: dcaf
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
integer :: ng_s
integer :: pdt
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_tm(im,jfirst:jlast,km)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_tm(im,jfirst-ng_d:jlast+ng_d,km)
logical :: rayf
real(kind=r8) :: sinlon(im)
logical :: strat
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_tm(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_tm(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: algpk
real(kind=r8) :: ap0k
real(kind=r8) :: dp(im,km)
real(kind=r8) :: dp_tl(im,km)
real(kind=r8) :: dt_tropic
real(kind=r8) :: dt_tropic_tl
real(kind=r8) :: dz
real(kind=r8) :: dz_tl
real(kind=r8) :: f1
real(kind=r8) :: f1_tl
real(kind=r8) :: fac
real(kind=r8) :: fac_tl
real(kind=r8) :: frac(im,jm)
real(kind=r8) :: frac_tl(im,jm)
real(kind=r8) :: fu(im,km)
real(kind=r8) :: fu_tl(im,km)
real(kind=r8) :: fv(im,km)
real(kind=r8) :: fv_tl(im,km)
real(kind=r8) :: h0
integer :: help_h
integer :: help_i
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
integer :: js2gm1
integer :: k
real(kind=r8) :: p0
real(kind=r8), allocatable :: pesouth(:,:)
real(kind=r8), allocatable :: pesouth_tm(:,:)
real(kind=r8) :: pl(im,km+1)
real(kind=r8) :: pl_tl(im,km+1)
real(kind=r8) :: rdt
real(kind=r8) :: relx
real(kind=r8) :: relx_tl
real(kind=r8) :: rka
real(kind=r8) :: rks
real(kind=r8) :: rkt
real(kind=r8) :: rkt_tl
real(kind=r8) :: rkv
real(kind=r8) :: rmr
real(kind=r8) :: rms
real(kind=r8) :: rsgb
real(kind=r8) :: sday
real(kind=r8) :: sigb
real(kind=r8) :: sigl
real(kind=r8) :: sigl_tl
real(kind=r8) :: t0
real(kind=r8) :: t2(im,km)
real(kind=r8) :: t2_tl(im,km)
real(kind=r8) :: t_ms
real(kind=r8) :: t_st
real(kind=r8) :: tau
real(kind=r8) :: teq(im,km)
real(kind=r8) :: teq_tl(im,km)
real(kind=r8) :: tey
real(kind=r8) :: tez
real(kind=r8) :: tmin
real(kind=r8) :: tmin_tl
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tl
real(kind=r8) :: u2(im,km)
real(kind=r8) :: u2_tl(im,km)
real(kind=r8) :: ua(im,jfirst:jlast,km)
real(kind=r8) :: ua_tl(im,jfirst:jlast,km)
real(kind=r8), allocatable :: uasouth(:,:)
real(kind=r8), allocatable :: uasouth_tl(:,:)
real(kind=r8) :: v2(im,km)
real(kind=r8) :: v2_tl(im,km)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_tl(im,jfirst:jlast,km)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gm1 = max(2,jfirst+1)
jn2g0 = min(jm-1,jlast)
p0 = 1.e+5
t0 = 200.
h0 = 7.
sday = 24*3600
rkv = 0.5*pdt/sday
rka = pdt/(40.*sday)
rks = pdt/(4.*sday)
t_ms = 10.
t_st = 40.
tau = (t_st-t_ms)/log(100.)
rms = pdt/(t_ms*sday)
rmr = 1./(1.+rms)
sigb = 0.7
rsgb = 1./(1.-sigb)
ap0k = 1./p0**akap
algpk = log(ap0k)
if (dcaf) then
  call d2a3d_tl( u,u_tm,v,v_tm,ua,ua_tl,va,va_tl,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif
#ifdef USE_OPENMP
!$omp parallel do private(dp,dp_tl,dt_tropic,dt_tropic_tl,dz,dz_tl,f1,f1_tl,fu,fu_tl,fv,fv_tl,i,j,k,pl,pl_tl,rdt,relx,relx_tl,rkt,&
!$omp& rkt_tl,sigl,sigl_tl,t2,t2_tl,teq,teq_tl,tey,tez,tmin,tmin_tl,tmp,tmp_tl,u2,u2_tl,v2,v2_tl)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl_tl(i,k) = 0.5*pe_tm(i,k+1,j)+0.5*pe_tm(i,k,j)
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl_tl(i,km+1) = pl_tl(i,km)
    pl(i,km+1) = pl(i,km)
  end do
  teq_tl = 0.d0
  teq = 0.
  do k = km, 1, -1
    do i = 1, im
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz_tl = pl_tl(i,k+1)*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))-pl_tl(i,k)*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx_tl = 0.01*pl_tl(i,k)*tau*(1./(0.01*pl(i,k)))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx_tl = -(relx_tl*(pdt*sday/(relx*sday*relx*sday)))
        relx = pdt/(relx*sday)
        dt_tropic_tl = 2.25*dz_tl*cosp(j)
        dt_tropic = 2.25*cosp(j)*dz
        teq_tl(i,k) = dt_tropic_tl/pkz(i,j,k)+pkz_tm(i,j,k+1)*(teq(i,k+1)/pkz(i,j,k))-pkz_tm(i,j,k)*((teq(i,k+1)*pkz(i,j,k+1)+&
&dt_tropic)/(pkz(i,j,k)*pkz(i,j,k)))+teq_tl(i,k+1)*(pkz(i,j,k+1)/pkz(i,j,k))
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        pt_tm(i,j,k) = pt_tm(i,j,k)/(1.+relx)+relx_tl*(teq(i,k)/(1.+relx)-(pt(i,j,k)+relx*teq(i,k))/((1.+relx)*(1.+relx)))+&
&teq_tl(i,k)*(relx/(1.+relx))
        pt(i,j,k) = (pt(i,j,k)+relx*teq(i,k))/(1.+relx)
      else if (strat .and. pl(i,k) .le. 100.) then
        dz_tl = pl_tl(i,k+1)*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))-pl_tl(i,k)*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic_tl = -(2.25*dz_tl*cosp(j))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp_tl = dt_tropic_tl+pkz_tm(i,j,k+1)*teq(i,k+1)+teq_tl(i,k+1)*pkz(i,j,k+1)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq_tl(i,k) = (-(pkz_tm(i,j,k)*(tmp/(pkz(i,j,k)*pkz(i,j,k)))))+tmp_tl/pkz(i,j,k)
        teq(i,k) = tmp/pkz(i,j,k)
        pt_tm(i,j,k) = pt_tm(i,j,k)*rmr+teq_tl(i,k)*rms*rmr
        pt(i,j,k) = (pt(i,j,k)+rms*teq(i,k))*rmr
      else
        sigl_tl = (-(pe_tm(i,km+1,j)*(pl(i,k)/(pe(i,km+1,j)*pe(i,km+1,j)))))+pl_tl(i,k)/pe(i,km+1,j)
        sigl = pl(i,k)/pe(i,km+1,j)
        f1_tl = sigl_tl*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin_tl = -(pkz_tm(i,j,k)*(t0/(pkz(i,j,k)*pkz(i,j,k))))
        tmin = t0/pkz(i,j,k)
        teq_tl(i,k) = -(pkz_tm(i,j,k)*tez*(1./pkz(i,j,k)))
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq_tl(i,k) = teq_tl(i,k)*(0.5-sign(0.5d0,tmin-teq(i,k)))+tmin_tl*(0.5+sign(0.5d0,tmin-teq(i,k)))
        teq(i,k) = max(tmin,teq(i,k))
        rkt_tl = f1_tl*(rks-rka)*cosp4(j)
        rkt = rka+(rks-rka)*f1*cosp4(j)
        pt_tm(i,j,k) = pt_tm(i,j,k)/(1.+rkt)+rkt_tl*(teq(i,k)/(1.+rkt)-(pt(i,j,k)+rkt*teq(i,k))/((1.+rkt)*(1.+rkt)))+teq_tl(i,k)*&
&(rkt/(1.+rkt))
        pt(i,j,k) = (pt(i,j,k)+rkt*teq(i,k))/(1.+rkt)
      endif
    end do
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        dp_tl(i,k) = pe_tm(i,k+1,j)-pe_tm(i,k,j)
        dp(i,k) = pe(i,k+1,j)-pe(i,k,j)
        fu_tl(i,k) = 0.d0
        fu(i,k) = 0.
        fv_tl(i,k) = 0.d0
        fv(i,k) = 0.
        u2_tl(i,k) = ua_tl(i,j,k)
        u2(i,k) = ua(i,j,k)
        v2_tl(i,k) = va_tl(i,j,k)
        v2(i,k) = va(i,j,k)
        t2_tl(i,k) = pt_tm(i,j,k)
        t2(i,k) = pt(i,j,k)
      end do
    end do
    rdt = 1./pdt
    call dry_adj_tl( im,km,rdt,t2,t2_tl,fu,fu_tl,fv,fv_tl,u2,u2_tl,v2,v2_tl,dp,dp_tl )
    do k = 1, km
      v_tm(1,j,k) = 0.5*fv_tl(im,k)+0.5*fv_tl(1,k)+v_tm(1,j,k)
      v(1,j,k) = v(1,j,k)+0.5*(fv(1,k)+fv(im,k))
      do i = 2, im
        v_tm(i,j,k) = 0.5*fv_tl(i-1,k)+0.5*fv_tl(i,k)+v_tm(i,j,k)
        v(i,j,k) = v(i,j,k)+0.5*(fv(i,k)+fv(i-1,k))
      end do
      do i = 1, im
        ua_tl(i,j,k) = fu_tl(i,k)
        ua(i,j,k) = fu(i,k)
        pt_tm(i,j,k) = t2_tl(i,k)
        pt(i,j,k) = t2(i,k)
      end do
    end do
  endif
end do
allocate( uasouth_tl(im,km) )
allocate( uasouth(im,km) )
allocate( pesouth_tm(im,km+1) )
allocate( pesouth(im,km+1) )
if (dcaf) then
  call mp_send_ua( im,jm,jfirst,jlast,1,km,ua_tl )
  call mp_send_ua( im,jm,jfirst,jlast,1,km,ua )
  call mp_recv_ua( im,jm,jfirst,jlast,1,km,uasouth_tl )
  call mp_recv_ua( im,jm,jfirst,jlast,1,km,uasouth )
endif
help_h = km+1
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe_tm )
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe )
help_i = km+1
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth_tm )
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth )
#ifdef USE_OPENMP
!$omp parallel do private(fac,fac_tl,frac,frac_tl,i,j,k,sigl,sigl_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (dcaf) then
    do j = js2gm1, jlast
      do i = 1, im
        u_tm(i,j,k) = u_tm(i,j,k)+0.5*ua_tl(i,j-1,k)+0.5*ua_tl(i,j,k)
        u(i,j,k) = u(i,j,k)+0.5*(ua(i,j,k)+ua(i,j-1,k))
      end do
    end do
    if (jfirst .gt. 1) then
      do i = 1, im
        u_tm(i,jfirst,k) = u_tm(i,jfirst,k)+0.5*ua_tl(i,jfirst,k)+0.5*uasouth_tl(i,k)
        u(i,jfirst,k) = u(i,jfirst,k)+0.5*(ua(i,jfirst,k)+uasouth(i,k))
      end do
    endif
  endif
  if (rayf .and. k .le. ks) then
    do j = js2g0, jlast
      do i = 1, im
        u_tm(i,j,k) = u_tm(i,j,k)*rf(k)
        u(i,j,k) = u(i,j,k)*rf(k)
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        v_tm(i,j,k) = v_tm(i,j,k)*rf(k)
        v(i,j,k) = v(i,j,k)*rf(k)
      end do
    end do
  else
    do j = jfirst, jlast
      do i = 1, im
        sigl_tl = pe_tm(i,k+1,j)*(0.5/pe(i,km+1,j))-pe_tm(i,km+1,j)*(0.5*(pe(i,k,j)+pe(i,k+1,j))/(pe(i,km+1,j)*pe(i,km+1,j)))+&
&pe_tm(i,k,j)*(0.5/pe(i,km+1,j))
        sigl = 0.5*(pe(i,k,j)+pe(i,k+1,j))/pe(i,km+1,j)
        frac_tl(i,j) = sigl_tl*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        frac(i,j) = max(0._8,(sigl-sigb)*rsgb)
      end do
    end do
    if (jfirst .gt. 1) then
      do i = 1, im
        sigl_tl = pesouth_tm(i,k+1)*(0.5/pesouth(i,km+1))-pesouth_tm(i,km+1)*(0.5*(pesouth(i,k)+pesouth(i,k+1))/(pesouth(i,km+1)*&
&pesouth(i,km+1)))+pesouth_tm(i,k)*(0.5/pesouth(i,km+1))
        sigl = 0.5*(pesouth(i,k)+pesouth(i,k+1))/pesouth(i,km+1)
        frac_tl(i,jfirst-1) = sigl_tl*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        frac(i,jfirst-1) = max(0._8,(sigl-sigb)*rsgb)
      end do
    endif
    do j = js2g0, jlast
      do i = 1, im
        fac_tl = frac_tl(i,j-1)+frac_tl(i,j)
        fac = frac(i,j)+frac(i,j-1)
        if (fac .gt. 0.) then
          u_tm(i,j,k) = (-(fac_tl*(u(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))))+u_tm(i,j,k)/(1.+rkv*fac)
          u(i,j,k) = u(i,j,k)/(1.+rkv*fac)
        endif
      end do
    end do
    do j = js2g0, jn2g0
      do i = 2, im
        fac_tl = frac_tl(i-1,j)+frac_tl(i,j)
        fac = frac(i,j)+frac(i-1,j)
        if (fac .gt. 0.) then
          v_tm(i,j,k) = (-(fac_tl*(v(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))))+v_tm(i,j,k)/(1.+rkv*fac)
          v(i,j,k) = v(i,j,k)/(1.+rkv*fac)
        endif
      end do
    end do
    do j = js2g0, jn2g0
      fac_tl = frac_tl(im,j)+frac_tl(1,j)
      fac = frac(1,j)+frac(im,j)
      if (fac .gt. 0.) then
        v_tm(1,j,k) = (-(fac_tl*(v(1,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))))+v_tm(1,j,k)/(1.+rkv*fac)
        v(1,j,k) = v(1,j,k)/(1.+rkv*fac)
      endif
    end do
  endif
end do
deallocate( pesouth_tm )
deallocate( pesouth )
deallocate( uasouth_tl )
deallocate( uasouth )

end subroutine hswf_do_tl


end module     hswf_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     hswf_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use hswf

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine hswf_do_tl( im, jm, km, jfirst, jlast, u, u_tm, v, v_tm, pt, pt_tm, pe, pe_tm, pkz, pkz_tm, pdt, akap, dcaf, strat, &
&rayf, cosp, coslon, sinlon, ng_s, ng_d )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
integer :: im
real(kind=r8) :: coslon(im)
integer :: jm
real(kind=r8) :: cosp(jm)
logical :: dcaf
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
integer :: ng_s
integer :: pdt
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_tm(im,jfirst:jlast,km)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_tm(im,jfirst-ng_d:jlast+ng_d,km)
logical :: rayf
real(kind=r8) :: sinlon(im)
logical :: strat
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_tm(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_tm(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: algpk
real(kind=r8) :: ap0k
real(kind=r8) :: dp(im,km)
real(kind=r8) :: dp_tl(im,km)
real(kind=r8) :: dt_tropic
real(kind=r8) :: dt_tropic_tl
real(kind=r8) :: dz
real(kind=r8) :: dz_tl
real(kind=r8) :: f1
real(kind=r8) :: f1_tl
real(kind=r8) :: fac
real(kind=r8) :: fac_tl
real(kind=r8) :: frac(im,jm)
real(kind=r8) :: frac_tl(im,jm)
real(kind=r8) :: fu(im,km)
real(kind=r8) :: fu_tl(im,km)
real(kind=r8) :: fv(im,km)
real(kind=r8) :: fv_tl(im,km)
real(kind=r8) :: h0
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
integer :: js2gm1
integer :: k
real(kind=r8) :: p0
real(kind=r8) :: pl(im,km+1)
real(kind=r8) :: pl_tl(im,km+1)
real(kind=r8) :: rdt
real(kind=r8) :: relx
real(kind=r8) :: relx_tl
real(kind=r8) :: rka
real(kind=r8) :: rks
real(kind=r8) :: rkt
real(kind=r8) :: rkt_tl
real(kind=r8) :: rkv
real(kind=r8) :: rmr
real(kind=r8) :: rms
real(kind=r8) :: rsgb
real(kind=r8) :: sday
real(kind=r8) :: sigb
real(kind=r8) :: sigl
real(kind=r8) :: sigl_tl
real(kind=r8) :: t0
real(kind=r8) :: t2(im,km)
real(kind=r8) :: t2_tl(im,km)
real(kind=r8) :: t_ms
real(kind=r8) :: t_st
real(kind=r8) :: tau
real(kind=r8) :: teq(im,km)
real(kind=r8) :: teq_tl(im,km)
real(kind=r8) :: tey
real(kind=r8) :: tez
real(kind=r8) :: tmin
real(kind=r8) :: tmin_tl
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tl
real(kind=r8) :: u2(im,km)
real(kind=r8) :: u2_tl(im,km)
real(kind=r8) :: ua(im,jfirst:jlast,km)
real(kind=r8) :: ua_tl(im,jfirst:jlast,km)
real(kind=r8) :: v2(im,km)
real(kind=r8) :: v2_tl(im,km)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_tl(im,jfirst:jlast,km)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gm1 = max(2,jfirst+1)
jn2g0 = min(jm-1,jlast)
p0 = 1.e+5
t0 = 200.
h0 = 7.
sday = 24*3600
rkv = 0.5*pdt/sday
rka = pdt/(40.*sday)
rks = pdt/(4.*sday)
t_ms = 10.
t_st = 40.
tau = (t_st-t_ms)/log(100.)
rms = pdt/(t_ms*sday)
rmr = 1./(1.+rms)
sigb = 0.7
rsgb = 1./(1.-sigb)
ap0k = 1./p0**akap
algpk = log(ap0k)
if (dcaf) then
  call d2a3d_tl( u,u_tm,v,v_tm,ua,ua_tl,va,va_tl,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif
#ifdef USE_OPENMP
!$omp parallel do private(dp,dp_tl,dt_tropic,dt_tropic_tl,dz,dz_tl,f1,f1_tl,fu,fu_tl,fv,fv_tl,i,j,k,pl,pl_tl,rdt,relx,relx_tl,rkt,&
!$omp& rkt_tl,sigl,sigl_tl,t2,t2_tl,teq,teq_tl,tey,tez,tmin,tmin_tl,tmp,tmp_tl,u2,u2_tl,v2,v2_tl)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl_tl(i,k) = 0.5*pe_tm(i,k+1,j)+0.5*pe_tm(i,k,j)
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl_tl(i,km+1) = pl_tl(i,km)
    pl(i,km+1) = pl(i,km)
  end do
  teq_tl = 0.d0
  teq = 0.
  do k = km, 1, -1
    do i = 1, im
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz_tl = pl_tl(i,k+1)*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))-pl_tl(i,k)*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx_tl = 0.01*pl_tl(i,k)*tau*(1./(0.01*pl(i,k)))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx_tl = -(relx_tl*(pdt*sday/(relx*sday*relx*sday)))
        relx = pdt/(relx*sday)
        dt_tropic_tl = 2.25*dz_tl*cosp(j)
        dt_tropic = 2.25*cosp(j)*dz
        teq_tl(i,k) = dt_tropic_tl/pkz(i,j,k)+pkz_tm(i,j,k+1)*(teq(i,k+1)/pkz(i,j,k))-pkz_tm(i,j,k)*((teq(i,k+1)*pkz(i,j,k+1)+&
&dt_tropic)/(pkz(i,j,k)*pkz(i,j,k)))+teq_tl(i,k+1)*(pkz(i,j,k+1)/pkz(i,j,k))
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        pt_tm(i,j,k) = pt_tm(i,j,k)/(1.+relx)+relx_tl*(teq(i,k)/(1.+relx)-(pt(i,j,k)+relx*teq(i,k))/((1.+relx)*(1.+relx)))+&
&teq_tl(i,k)*(relx/(1.+relx))
        pt(i,j,k) = (pt(i,j,k)+relx*teq(i,k))/(1.+relx)
      else if (strat .and. pl(i,k) .le. 100.) then
        dz_tl = pl_tl(i,k+1)*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))-pl_tl(i,k)*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic_tl = -(2.25*dz_tl*cosp(j))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp_tl = dt_tropic_tl+pkz_tm(i,j,k+1)*teq(i,k+1)+teq_tl(i,k+1)*pkz(i,j,k+1)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq_tl(i,k) = (-(pkz_tm(i,j,k)*(tmp/(pkz(i,j,k)*pkz(i,j,k)))))+tmp_tl/pkz(i,j,k)
        teq(i,k) = tmp/pkz(i,j,k)
        pt_tm(i,j,k) = pt_tm(i,j,k)*rmr+teq_tl(i,k)*rms*rmr
        pt(i,j,k) = (pt(i,j,k)+rms*teq(i,k))*rmr
      else
        sigl_tl = (-(pe_tm(i,km+1,j)*(pl(i,k)/(pe(i,km+1,j)*pe(i,km+1,j)))))+pl_tl(i,k)/pe(i,km+1,j)
        sigl = pl(i,k)/pe(i,km+1,j)
        f1_tl = sigl_tl*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin_tl = -(pkz_tm(i,j,k)*(t0/(pkz(i,j,k)*pkz(i,j,k))))
        tmin = t0/pkz(i,j,k)
        teq_tl(i,k) = -(pkz_tm(i,j,k)*tez*(1./pkz(i,j,k)))
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq_tl(i,k) = teq_tl(i,k)*(0.5-sign(0.5d0,tmin-teq(i,k)))+tmin_tl*(0.5+sign(0.5d0,tmin-teq(i,k)))
        teq(i,k) = max(tmin,teq(i,k))
        rkt_tl = f1_tl*(rks-rka)*cosp4(j)
        rkt = rka+(rks-rka)*f1*cosp4(j)
        pt_tm(i,j,k) = pt_tm(i,j,k)/(1.+rkt)+rkt_tl*(teq(i,k)/(1.+rkt)-(pt(i,j,k)+rkt*teq(i,k))/((1.+rkt)*(1.+rkt)))+teq_tl(i,k)*&
&(rkt/(1.+rkt))
        pt(i,j,k) = (pt(i,j,k)+rkt*teq(i,k))/(1.+rkt)
      endif
    end do
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        dp_tl(i,k) = pe_tm(i,k+1,j)-pe_tm(i,k,j)
        dp(i,k) = pe(i,k+1,j)-pe(i,k,j)
        fu_tl(i,k) = 0.d0
        fu(i,k) = 0.
        fv_tl(i,k) = 0.d0
        fv(i,k) = 0.
        u2_tl(i,k) = ua_tl(i,j,k)
        u2(i,k) = ua(i,j,k)
        v2_tl(i,k) = va_tl(i,j,k)
        v2(i,k) = va(i,j,k)
        t2_tl(i,k) = pt_tm(i,j,k)
        t2(i,k) = pt(i,j,k)
      end do
    end do
    rdt = 1./pdt
    call dry_adj_tl( im,km,rdt,t2,t2_tl,fu,fu_tl,fv,fv_tl,u2,u2_tl,v2,v2_tl,dp,dp_tl )
    do k = 1, km
      v_tm(1,j,k) = 0.5*fv_tl(im,k)+0.5*fv_tl(1,k)+v_tm(1,j,k)
      v(1,j,k) = v(1,j,k)+0.5*(fv(1,k)+fv(im,k))
      do i = 2, im
        v_tm(i,j,k) = 0.5*fv_tl(i-1,k)+0.5*fv_tl(i,k)+v_tm(i,j,k)
        v(i,j,k) = v(i,j,k)+0.5*(fv(i,k)+fv(i-1,k))
      end do
      do i = 1, im
        ua_tl(i,j,k) = fu_tl(i,k)
        ua(i,j,k) = fu(i,k)
        pt_tm(i,j,k) = t2_tl(i,k)
        pt(i,j,k) = t2(i,k)
      end do
    end do
  endif
end do
#ifdef USE_OPENMP
!$omp parallel do private(fac,fac_tl,frac,frac_tl,i,j,k,sigl,sigl_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (dcaf) then
    do j = js2gm1, jlast
      do i = 1, im
        u_tm(i,j,k) = u_tm(i,j,k)+0.5*ua_tl(i,j-1,k)+0.5*ua_tl(i,j,k)
        u(i,j,k) = u(i,j,k)+0.5*(ua(i,j,k)+ua(i,j-1,k))
      end do
    end do
  endif
  if (rayf .and. k .le. ks) then
    do j = js2g0, jlast
      do i = 1, im
        u_tm(i,j,k) = u_tm(i,j,k)*rf(k)
        u(i,j,k) = u(i,j,k)*rf(k)
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        v_tm(i,j,k) = v_tm(i,j,k)*rf(k)
        v(i,j,k) = v(i,j,k)*rf(k)
      end do
    end do
  else
    do j = jfirst, jlast
      do i = 1, im
        sigl_tl = pe_tm(i,k+1,j)*(0.5/pe(i,km+1,j))-pe_tm(i,km+1,j)*(0.5*(pe(i,k,j)+pe(i,k+1,j))/(pe(i,km+1,j)*pe(i,km+1,j)))+&
&pe_tm(i,k,j)*(0.5/pe(i,km+1,j))
        sigl = 0.5*(pe(i,k,j)+pe(i,k+1,j))/pe(i,km+1,j)
        frac_tl(i,j) = sigl_tl*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        frac(i,j) = max(0._8,(sigl-sigb)*rsgb)
      end do
    end do
    do j = js2g0, jlast
      do i = 1, im
        fac_tl = frac_tl(i,j-1)+frac_tl(i,j)
        fac = frac(i,j)+frac(i,j-1)
        if (fac .gt. 0.) then
          u_tm(i,j,k) = (-(fac_tl*(u(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))))+u_tm(i,j,k)/(1.+rkv*fac)
          u(i,j,k) = u(i,j,k)/(1.+rkv*fac)
        endif
      end do
    end do
    do j = js2g0, jn2g0
      do i = 2, im
        fac_tl = frac_tl(i-1,j)+frac_tl(i,j)
        fac = frac(i,j)+frac(i-1,j)
        if (fac .gt. 0.) then
          v_tm(i,j,k) = (-(fac_tl*(v(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))))+v_tm(i,j,k)/(1.+rkv*fac)
          v(i,j,k) = v(i,j,k)/(1.+rkv*fac)
        endif
      end do
    end do
    do j = js2g0, jn2g0
      fac_tl = frac_tl(im,j)+frac_tl(1,j)
      fac = frac(1,j)+frac(im,j)
      if (fac .gt. 0.) then
        v_tm(1,j,k) = (-(fac_tl*(v(1,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))))+v_tm(1,j,k)/(1.+rkv*fac)
        v(1,j,k) = v(1,j,k)/(1.+rkv*fac)
      endif
    end do
  endif
end do

end subroutine hswf_do_tl


end module     hswf_tl


#endif /* SPMD */
