#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine geopk_tl( ptop, pe, pe_tm, delp, delp_tm, pk, pk_tm, wz, wz_tl, hs, pt, pt_tm, im, km, jfirst, jlast, nd, cp, akap, nx, &
&id, dp_check )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: dpmin = 0.1

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_tm(im,jfirst:jlast,km)
logical :: dp_check
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: id
integer :: nd
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pk_tm(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: pt_tm(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: ptop
real(kind=r8) :: wz(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: wz_tl(im,jfirst-1:jlast+1,km+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dp
real(kind=r8) :: dp_tl
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_tl(im)
real(kind=r8) :: ptk

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
it = im/nx
jp = nx*(jlast-jfirst+1)
do k = 1, km+1
  do j = jfirst-1, jlast+1
    do i = 1, im
      pk_tm(i,j,k) = 0.d0
      pk(i,j,k) = 0.
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(dp,dp_tl,i,i1,i2,ixj,j,k,p1d,p1d_tl,ptk)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  ptk = ptop**akap
  do i = i1, i2
    p1d_tl(i) = 0.d0
    p1d(i) = ptop
    pk_tm(i,j,1) = 0.d0
    pk(i,j,1) = ptk
    wz_tl(i,j,km+1) = 0.d0
    wz(i,j,km+1) = hs(i,j)
  end do
  if (id .eq. 1) then
    do i = i1, i2
      pe_tm(i,1,j) = 0.d0
      pe(i,1,j) = ptop
    end do
  endif
  if (dp_check) then
    do k = 1, km-1
      do i = i1, i2
        if (delp(i,j,k) .lt. dpmin) then
          dp_tl = -delp_tm(i,j,k)
          dp = dpmin-delp(i,j,k)
          pt_tm(i,j,k) = delp_tm(i,j,k)*(pt(i,j,k)/dpmin)+dp_tl*(pt(i,j,k+1)/dpmin)+pt_tm(i,j,k+1)*(dp/dpmin)+pt_tm(i,j,k)*(delp(i,&
&j,k)/dpmin)
          pt(i,j,k) = (pt(i,j,k)*delp(i,j,k)+pt(i,j,k+1)*dp)/dpmin
          delp_tm(i,j,k) = 0.d0
          delp(i,j,k) = dpmin
          delp_tm(i,j,k+1) = delp_tm(i,j,k+1)-dp_tl
          delp(i,j,k+1) = delp(i,j,k+1)-dp
        endif
      end do
    end do
    do i = i1, i2
      if (delp(i,j,km) .lt. dpmin) then
        dp_tl = -delp_tm(i,j,km)
        dp = dpmin-delp(i,j,km)
        pt_tm(i,j,km) = delp_tm(i,j,km)*(pt(i,j,km)/dpmin)+dp_tl*(pt(i,j,km-1)/dpmin)+pt_tm(i,j,km-1)*(dp/dpmin)+pt_tm(i,j,km)*&
&(delp(i,j,km)/dpmin)
        pt(i,j,km) = (pt(i,j,km)*delp(i,j,km)+pt(i,j,km-1)*dp)/dpmin
        delp_tm(i,j,km) = 0.d0
        delp(i,j,km) = dpmin
        delp_tm(i,j,km-1) = delp_tm(i,j,km-1)-dp_tl
        delp(i,j,km-1) = delp(i,j,km-1)-dp
      endif
    end do
  endif
  do k = 2, km+1
    do i = i1, i2
      p1d_tl(i) = delp_tm(i,j,k-1)+p1d_tl(i)
      p1d(i) = p1d(i)+delp(i,j,k-1)
      pk_tm(i,j,k) = p1d_tl(i)*akap*p1d(i)**(akap-1)
      pk(i,j,k) = p1d(i)**akap
    end do
    if (id .eq. 1) then
      do i = i1, i2
        pe_tm(i,k,j) = p1d_tl(i)
        pe(i,k,j) = p1d(i)
      end do
    endif
  end do
  do k = km, 1, -1
    do i = i1, i2
      wz_tl(i,j,k) = pk_tm(i,j,k+1)*cp*pt(i,j,k)-pk_tm(i,j,k)*cp*pt(i,j,k)+pt_tm(i,j,k)*cp*(pk(i,j,k+1)-pk(i,j,k))+wz_tl(i,j,k+1)
      wz(i,j,k) = wz(i,j,k+1)+cp*pt(i,j,k)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do

end subroutine geopk_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine geopk_tl( ptop, pe, pe_tm, delp, delp_tm, pk, pk_tm, wz, wz_tl, hs, pt, pt_tm, im, km, jfirst, jlast, nd, cp, akap, nx, &
&id, dp_check )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: dpmin = 0.1

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_tm(im,jfirst:jlast,km)
logical :: dp_check
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: id
integer :: nd
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pk_tm(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: pt_tm(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: ptop
real(kind=r8) :: wz(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: wz_tl(im,jfirst-1:jlast+1,km+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dp
real(kind=r8) :: dp_tl
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_tl(im)
real(kind=r8) :: ptk

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
it = im/nx
jp = nx*(jlast-jfirst+1)
do k = 1, km+1
  do j = jfirst-1, jlast+1
    do i = 1, im
      pk_tm(i,j,k) = 0.d0
      pk(i,j,k) = 0.
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(dp,dp_tl,i,i1,i2,ixj,j,k,p1d,p1d_tl,ptk)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  ptk = ptop**akap
  do i = i1, i2
    p1d_tl(i) = 0.d0
    p1d(i) = ptop
    pk_tm(i,j,1) = 0.d0
    pk(i,j,1) = ptk
    wz_tl(i,j,km+1) = 0.d0
    wz(i,j,km+1) = hs(i,j)
  end do
  if (id .eq. 1) then
    do i = i1, i2
      pe_tm(i,1,j) = 0.d0
      pe(i,1,j) = ptop
    end do
  endif
  if (dp_check) then
    do k = 1, km-1
      do i = i1, i2
        if (delp(i,j,k) .lt. dpmin) then
          dp_tl = -delp_tm(i,j,k)
          dp = dpmin-delp(i,j,k)
          pt_tm(i,j,k) = delp_tm(i,j,k)*(pt(i,j,k)/dpmin)+dp_tl*(pt(i,j,k+1)/dpmin)+pt_tm(i,j,k+1)*(dp/dpmin)+pt_tm(i,j,k)*(delp(i,&
&j,k)/dpmin)
          pt(i,j,k) = (pt(i,j,k)*delp(i,j,k)+pt(i,j,k+1)*dp)/dpmin
          delp_tm(i,j,k) = 0.d0
          delp(i,j,k) = dpmin
          delp_tm(i,j,k+1) = delp_tm(i,j,k+1)-dp_tl
          delp(i,j,k+1) = delp(i,j,k+1)-dp
        endif
      end do
    end do
    do i = i1, i2
      if (delp(i,j,km) .lt. dpmin) then
        dp_tl = -delp_tm(i,j,km)
        dp = dpmin-delp(i,j,km)
        pt_tm(i,j,km) = delp_tm(i,j,km)*(pt(i,j,km)/dpmin)+dp_tl*(pt(i,j,km-1)/dpmin)+pt_tm(i,j,km-1)*(dp/dpmin)+pt_tm(i,j,km)*&
&(delp(i,j,km)/dpmin)
        pt(i,j,km) = (pt(i,j,km)*delp(i,j,km)+pt(i,j,km-1)*dp)/dpmin
        delp_tm(i,j,km) = 0.d0
        delp(i,j,km) = dpmin
        delp_tm(i,j,km-1) = delp_tm(i,j,km-1)-dp_tl
        delp(i,j,km-1) = delp(i,j,km-1)-dp
      endif
    end do
  endif
  do k = 2, km+1
    do i = i1, i2
      p1d_tl(i) = delp_tm(i,j,k-1)+p1d_tl(i)
      p1d(i) = p1d(i)+delp(i,j,k-1)
      pk_tm(i,j,k) = p1d_tl(i)*akap*p1d(i)**(akap-1)
      pk(i,j,k) = p1d(i)**akap
    end do
    if (id .eq. 1) then
      do i = i1, i2
        pe_tm(i,k,j) = p1d_tl(i)
        pe(i,k,j) = p1d(i)
      end do
    endif
  end do
  do k = km, 1, -1
    do i = i1, i2
      wz_tl(i,j,k) = pk_tm(i,j,k+1)*cp*pt(i,j,k)-pk_tm(i,j,k)*cp*pt(i,j,k)+pt_tm(i,j,k)*cp*(pk(i,j,k+1)-pk(i,j,k))+wz_tl(i,j,k+1)
      wz(i,j,k) = wz(i,j,k+1)+cp*pt(i,j,k)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do

end subroutine geopk_tl


#endif /* SPMD */
