#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine d2a3d_tl( u, u_tm, v, v_tm, ua, ua_tl, va, va_tl, im, jm, km, jfirst, jlast, ng_d, ng_s, coslon, sinlon )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mod_comm, only : mp_barrier, mp_recv_n, mp_send_s

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: coslon(im)
integer :: jfirst
integer :: jlast
integer :: jm
integer :: km
integer :: ng_d
integer :: ng_s
real(kind=r8) :: sinlon(im)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_tm(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: ua(im,jfirst:jlast,km)
real(kind=r8) :: ua_tl(im,jfirst:jlast,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_tm(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_tl(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: k

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_tm )
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
#ifdef USE_OPENMP
!$omp parallel do private(k)
#endif /* ! USE_OPENMP */
do k = 1, km
  call d2a2_tl( u(1,jfirst,k),u_tm(1,jfirst,k),v(1,jfirst,k),v_tm(1,jfirst,k),ua(1,jfirst,k),ua_tl(1,jfirst,k),va(1,jfirst,k),&
&va_tl(1,jfirst,k),im,jm,jfirst,jlast,coslon,sinlon )
end do
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_tm )
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
if (jlast .lt. jm) then
#ifdef USE_OPENMP
  !$omp parallel do private(i,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do i = 1, im
      ua_tl(i,jlast,k) = 0.5*u_tm(i,jlast+1,k)+0.5*u_tm(i,jlast,k)
      ua(i,jlast,k) = 0.5*(u(i,jlast,k)+u(i,jlast+1,k))
    end do
  end do
endif

end subroutine d2a3d_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine d2a3d_tl( u, u_tm, v, v_tm, ua, ua_tl, va, va_tl, im, jm, km, jfirst, jlast, ng_d, ng_s, coslon, sinlon )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: coslon(im)
integer :: jfirst
integer :: jlast
integer :: jm
integer :: km
integer :: ng_d
integer :: ng_s
real(kind=r8) :: sinlon(im)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_tm(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: ua(im,jfirst:jlast,km)
real(kind=r8) :: ua_tl(im,jfirst:jlast,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_tm(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_tl(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
integer :: k

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
#ifdef USE_OPENMP
!$omp parallel do private(k)
#endif /* ! USE_OPENMP */
do k = 1, km
  call d2a2_tl( u(1,jfirst,k),u_tm(1,jfirst,k),v(1,jfirst,k),v_tm(1,jfirst,k),ua(1,jfirst,k),ua_tl(1,jfirst,k),va(1,jfirst,k),&
&va_tl(1,jfirst,k),im,jm,jfirst,jlast,coslon,sinlon )
end do

end subroutine d2a3d_tl


#endif /* SPMD */
