#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
!  14May2007  Todling   Introduced dyn_prog; global change.
!
module     control_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use control

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

PRIVATE
PUBLIC cont2mod_tl

      real(r8), pointer ::    u   (:,:,:)   ! zonal wind on D-grid
      real(r8), pointer ::    v   (:,:,:)   ! meridional wind
      real(r8), pointer ::   pt   (:,:,:)   ! virtual potential temperature
      real(r8), pointer :: delp   (:,:,:)   ! pressure thickness (pascal)
      real(r8), pointer ::    q   (:,:,:,:) ! specific humidity & tracer mixing ratios

      real(r8), pointer ::    u_tl(:,:,:)   ! zonal wind on D-grid
      real(r8), pointer ::    v_tl(:,:,:)   ! meridional wind
      real(r8), pointer ::   pt_tl(:,:,:)   ! virtual potential temperature
      real(r8), pointer :: delp_tl(:,:,:)   ! pressure thickness (pascal)
      real(r8), pointer ::    q_tl(:,:,:,:) ! specific humidity & tracer mixing ratios

contains

subroutine cont2mod_tl( n, x, x_tl, prog, prog_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use prognostics
use stepon, only : ng_d,ng_s
use mod_comm, only : gid,mp_scatter4d
use control, only : ibeg_tr  , iend_tr

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: n, m_nc
real(kind=r8) :: x(n)
real(kind=r8) :: x_tl(n)

type(dyn_prog), TARGET :: prog
type(dyn_prog), TARGET :: prog_tl

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: qhelp(imr,jfirst:jlast,nl)
real(kind=r8) :: qhelp_tl(imr,jfirst:jlast,nl)

! Set pointers
! ------------
       u_tl   => prog_tl%u
       v_tl   => prog_tl%v
      pt_tl   => prog_tl%pt
      delp_tl => prog_tl%delp
      q_tl    => prog_tl%q

! Set pointers
! ------------
       u   => prog%u
       v   => prog%v
      pt   => prog%pt
      delp => prog%delp
      q    => prog%q

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
call mp_scatter4d( x_tl(ibeg_u),qhelp_tl,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
call mp_scatter4d( x(ibeg_u),qhelp,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
u_tl(:,jfirst:jlast,:) = qhelp_tl(:,jfirst:jlast,:)
u(:,jfirst:jlast,:) = qhelp(:,jfirst:jlast,:)
call mp_scatter4d( x_tl(ibeg_v),qhelp_tl,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
call mp_scatter4d( x(ibeg_v),qhelp,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
v_tl(:,jfirst:jlast,:) = qhelp_tl(:,jfirst:jlast,:)
v(:,jfirst:jlast,:) = qhelp(:,jfirst:jlast,:)
call mp_scatter4d( x_tl(ibeg_pt),qhelp_tl,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
call mp_scatter4d( x(ibeg_pt),qhelp,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
pt_tl(:,jfirst:jlast,:) = qhelp_tl(:,jfirst:jlast,:)
pt(:,jfirst:jlast,:) = qhelp(:,jfirst:jlast,:)


call mp_scatter4d( x_tl(ibeg_q),qhelp_tl,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
call mp_scatter4d( x(ibeg_q),qhelp,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
q_tl(:,jfirst:jlast,:,1) = qhelp_tl(:,jfirst:jlast,:)
q(:,jfirst:jlast,:,1) = qhelp(:,jfirst:jlast,:)

call mp_scatter4d( x_tl(ibeg_delp),qhelp_tl,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
call mp_scatter4d( x(ibeg_delp),qhelp,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
delp_tl(:,jfirst:jlast,:) = qhelp_tl(:,jfirst:jlast,:)
delp(:,jfirst:jlast,:) = qhelp(:,jfirst:jlast,:)

if (nc .gt. 1) then
do m_nc = 2, nc
call mp_scatter4d( x_tl(ibeg_tr(m_nc-1)),qhelp_tl,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
q_tl(:,jfirst:jlast,:,m_nc) = qhelp_tl(:,jfirst:jlast,:)
call mp_scatter4d( x(ibeg_tr(m_nc-1)),qhelp,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
q   (:,jfirst:jlast,:,m_nc) = qhelp(:,jfirst:jlast,:)
enddo
endif

end subroutine cont2mod_tl


end module     control_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     control_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use control

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine cont2mod_tl( n, x, x_tl, prog, prog_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use prognostics
use stepon, only : ng_d,ng_s

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: n
real(kind=r8) :: x(n)
real(kind=r8) :: x_tl(n)
type(dyn_prog), TARGET :: prog
type(dyn_prog), TARGET :: prog_tl

! Set pointers
! ------------
       u_tl   => prog_tl%u
       v_tl   => prog_tl%v
      pt_tl   => prog_tl%pt
      delp_tl => prog_tl%delp
      q_tl    => prog_tl%q
                                                                                                                       
! Set pointers
! ------------
       u   => prog%u
       v   => prog%v
      pt   => prog%pt
      delp => prog%delp
      q    => prog%q


!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
u_tl(:,jfirst:jlast,:) = reshape(x_tl(ibeg_u:iend_u),(/imr,jnp,nl/))
u(:,jfirst:jlast,:) = reshape(x(ibeg_u:iend_u),(/imr,jnp,nl/))
v_tl(:,jfirst:jlast,:) = reshape(x_tl(ibeg_v:iend_v),(/imr,jnp,nl/))
v(:,jfirst:jlast,:) = reshape(x(ibeg_v:iend_v),(/imr,jnp,nl/))
pt_tl(:,jfirst:jlast,:) = reshape(x_tl(ibeg_pt:iend_pt),(/imr,jnp,nl/))
pt(:,jfirst:jlast,:) = reshape(x(ibeg_pt:iend_pt),(/imr,jnp,nl/))
q_tl(:,jfirst:jlast,:,1) = reshape(x_tl(ibeg_q:iend_q),(/imr,jnp,nl/))
q(:,jfirst:jlast,:,1) = reshape(x(ibeg_q:iend_q),(/imr,jnp,nl/))
delp_tl(:,jfirst:jlast,:) = reshape(x_tl(ibeg_delp:iend_delp),(/imr,jnp,nl/))
delp(:,jfirst:jlast,:) = reshape(x(ibeg_delp:iend_delp),(/imr,jnp,nl/))

end subroutine cont2mod_tl


end module     control_tl


#endif /* SPMD */
