#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     cd_core_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use cd_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine cd_core_do_tl( im, jm, km, nq, nx, jfirst, jlast, u, u_tm, v, v_tm, pt, pt_tm, delp, delp_tm, pe, pe_tm, pk, pk_tm, ns, &
&ptop, rcap, cp, akap, iord_c, jord_c, iord_d, jord_d, ng_c, ng_d, ng_s, ipe, hs, cosp, cose, acosp, sinlon, coslon, cosl5, sinl5, &
&cx3, cx3_tl, cy3, cy3_tl, mfx, mfx_tl, mfy, mfy_tl, delpf, delpf_tl, uc, uc_tl, vc, vc_tl, ptc, ptc_tl, dpt, dpt_tl, ptk, ptk_tl, &
&wz3, wz3_tl, pkc, pkc_tl, wz, wz_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use sw_core_tl
use tp_core
use tp_core_tl
#ifdef TIMING
use timingmodule
#endif
use mod_comm, only : gid,gsize,mp_barrier, mp_recv2_ns, mp_recv2_s, mp_recv3d_ns, mp_recv3d_ns2, mp_recv_n, mp_send2_n, &
&mp_send2_ns, mp_send3d_ns, mp_send3d_ns2, mp_send_s

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: akap
real(kind=r8) :: cose(jm)
integer :: im
real(kind=r8) :: cosl5(im)
real(kind=r8) :: coslon(im)
real(kind=r8) :: cosp(jm)
real(kind=r8) :: cp
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
real(kind=r8) :: cx3(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: cx3_tl(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: cy3(im,jfirst:jlast+1,km)
real(kind=r8) :: cy3_tl(im,jfirst:jlast+1,km)
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_tm(im,jfirst:jlast,km)
real(kind=r8) :: delpf(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: delpf_tl(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: dpt(im,jfirst-1:jlast+1,km)
real(kind=r8) :: dpt_tl(im,jfirst-1:jlast+1,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: iord_c
integer :: iord_d
integer :: ipe
integer :: jord_c
integer :: jord_d
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfx_tl(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
real(kind=r8) :: mfy_tl(im,jfirst:jlast+1,km)
integer :: ng_c
integer :: ng_s
integer :: nq
integer :: ns
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pk_tm(im,jfirst:jlast,km+1)
real(kind=r8) :: pkc(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pkc_tl(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_tm(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: ptc(im,jfirst:jlast,km)
real(kind=r8) :: ptc_tl(im,jfirst:jlast,km)
real(kind=r8) :: ptk(im,jfirst:jlast,km)
real(kind=r8) :: ptk_tl(im,jfirst:jlast,km)
real(kind=r8) :: ptop
real(kind=r8) :: rcap
real(kind=r8) :: sinl5(im)
real(kind=r8) :: sinlon(im)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_tm(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uc(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: uc_tl(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_tm(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: vc(im,jfirst-2:jlast+2,km)
real(kind=r8) :: vc_tl(im,jfirst-2:jlast+2,km)
real(kind=r8) :: wz(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: wz3(im,jfirst-1:jlast,km+1)
real(kind=r8) :: wz3_tl(im,jfirst-1:jlast,km+1)
real(kind=r8) :: wz_tl(im,jfirst-1:jlast+1,km+1)

!==============================================
! declare local variables
!==============================================
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: help_l
integer :: help_m
integer :: help_n
integer :: help_o
integer :: help_p
integer :: help_q
integer :: i
integer :: iord
integer :: j
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: jord
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: js2gc
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_tl(im)
real(kind=r8) :: pk4
real(kind=r8) :: pkchelp(im,jfirst-1:jlast+1)
real(kind=r8) :: pkchelp_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: wk(im,jfirst:jlast+2)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk1_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: wk2(im,jfirst:jlast+1)
real(kind=r8) :: wk2_tl(im,jfirst:jlast+1)
real(kind=r8) :: wk3(im,jfirst-1:jlast+1)
real(kind=r8) :: wk3_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: wk_tl(im,jfirst:jlast+2)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
wz3_tl = 0.d0
wz3 = 0.
uc_tl = 0.d0
uc = 0.
vc_tl = 0.d0
vc = 0.
#ifdef TIMING
call g_timing_on( 'Send_uv' )
#endif
call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_tm,1 )
call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u,1 )
call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_s,ng_d,v_tm,2 )
call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_s,ng_d,v,2 )
#ifdef TIMING
call g_timing_off( 'Send_uv' )
#endif
if (ipe .eq. (-1) .or. ns .eq. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_h,i,j,k,wk,wk2,wk_tl)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf_tl(i,j,k) = delp_tm(i,j,k)
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_h = jn2g0-js2g0+1
    call pft2d_tl( delpf(1,js2g0,k),delpf_tl(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,wk,wk_tl,wk2 )
  end do
endif
#ifdef TIMING
call g_timing_on( 'Recv_uv' )
#endif
call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_tm,1 )
call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u,1 )
call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_s,ng_d,v_tm,2 )
call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_s,ng_d,v,2 )
#ifdef TIMING
call g_timing_off( 'Recv_uv' )
#endif
if (ipe .eq. (-1) .or. ns .eq. 1) then
#ifdef TIMING
  call g_timing_on( 'Ghost_pt&delpf' )
#endif
  call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt_tm,1 )
  call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf_tl,2 )
  call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
  call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt_tm,1 )
  call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf_tl,2 )
  call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
#ifdef TIMING
  call g_timing_off( 'Ghost_pt&delpf' )
#endif
endif
#ifdef TIMING
call g_timing_on( 'C_CORE' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    iord = 1
    jord = 1
  else
    iord = iord_c
    jord = jord_c
  endif
  call c_sw_tl( u(1,jfirst-ng_d,k),u_tm(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),v_tm(1,jfirst-ng_s,k),pt(1,jfirst-ng_d,k),pt_tm(1,&
&jfirst-ng_d,k),delp(1,jfirst,k),delp_tm(1,jfirst,k),uc(1,jfirst-ng_d,k),uc_tl(1,jfirst-ng_d,k),vc(1,jfirst-2,k),vc_tl(1,jfirst-&
&2,k),ptc(1,jfirst,k),ptc_tl(1,jfirst,k),delpf(1,jfirst-ng_d,k),delpf_tl(1,jfirst-ng_d,k),ptk(1:im,jfirst:jlast,k),ptk_tl(1:im,&
&jfirst:jlast,k),cosp,acosp,cose,coslon,sinlon,dxdt,dxe,dtdx2,dtdx4,dtxe5,rdxe,dycp,dydt,dtdy5,cye,fc,ifax,trigs,dc(1,js2g0),sc,&
&zt_c,tiny,rcap,im,jm,jfirst,jlast,ng_c,ng_d,ng_s,js2g0,jn2g0,js2gc,jn1gc,iord,jord,cosl5,sinl5 )
end do
#ifdef TIMING
call g_timing_off( 'C_CORE' )
call g_timing_on( 'C_GEOP' )
#endif
call geopk_tl( ptop,pe,pe_tm,ptk,ptk_tl,pkc,pkc_tl,wz,wz_tl,hs,ptc,ptc_tl,im,km,jfirst,jlast,0,cp,akap,nx,0, .false.  )
#ifdef TIMING
call g_timing_off( 'C_GEOP' )
call g_timing_on( 'Send_pkc_wz' )
#endif
help_i = km+1
call mp_send2_n( im,jm,jfirst,jlast,1,help_i,1,1,pkc_tl,wz_tl )
call mp_send2_n( im,jm,jfirst,jlast,1,help_i,1,1,pkc,wz )
#ifdef TIMING
call g_timing_off( 'Send_pkc_wz' )
call g_timing_on( 'C_U_LOOP' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(help_j,i,j,k,p1d,p1d_tl,wk,wk2,wk_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, jn2g0
    do i = 1, im
      p1d_tl(i) = pkc_tl(i,j,k+1)-pkc_tl(i,j,k)
      p1d(i) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
    uc_tl(1,j,k) = (-(p1d_tl(im)*(dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,&
&k+1)-pkc(1,j,k)))/((p1d(1)+p1d(im))*(p1d(1)+p1d(im))))))-p1d_tl(1)*(dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,&
&k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,k+1)-pkc(1,j,k)))/((p1d(1)+p1d(im))*(p1d(1)+p1d(im))))+pkc_tl(im,j,k+1)*(dtdx2(j)*&
&(wz(im,j,k)-wz(1,j,k+1))/(p1d(1)+p1d(im)))+pkc_tl(1,j,k+1)*(dtdx2(j)*(wz(im,j,k+1)-wz(1,j,k))/(p1d(1)+p1d(im)))-pkc_tl(im,j,k)&
&*(dtdx2(j)*(wz(im,j,k+1)-wz(1,j,k))/(p1d(1)+p1d(im)))-pkc_tl(1,j,k)*(dtdx2(j)*(wz(im,j,k)-wz(1,j,k+1))/(p1d(1)+p1d(im)))+&
&uc_tl(1,j,k)+wz_tl(im,j,k+1)*(dtdx2(j)*(pkc(1,j,k+1)-pkc(im,j,k))/(p1d(1)+p1d(im)))-wz_tl(1,j,k+1)*(dtdx2(j)*(pkc(im,j,k+1)-&
&pkc(1,j,k))/(p1d(1)+p1d(im)))+wz_tl(im,j,k)*(dtdx2(j)*(pkc(im,j,k+1)-pkc(1,j,k))/(p1d(1)+p1d(im)))-wz_tl(1,j,k)*(dtdx2(j)*&
&(pkc(1,j,k+1)-pkc(im,j,k))/(p1d(1)+p1d(im)))
    uc(1,j,k) = uc(1,j,k)+dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,k+1)-&
&pkc(1,j,k)))/(p1d(1)+p1d(im))
    do i = 2, im
      uc_tl(i,j,k) = (-(p1d_tl(i-1)*(dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*&
&(pkc(i-1,j,k+1)-pkc(i,j,k)))/((p1d(i)+p1d(i-1))*(p1d(i)+p1d(i-1))))))-p1d_tl(i)*(dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,&
&j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*(pkc(i-1,j,k+1)-pkc(i,j,k)))/((p1d(i)+p1d(i-1))*(p1d(i)+p1d(i-1))))+pkc_tl(i-&
&1,j,k+1)*(dtdx2(j)*(wz(i-1,j,k)-wz(i,j,k+1))/(p1d(i)+p1d(i-1)))+pkc_tl(i,j,k+1)*(dtdx2(j)*(wz(i-1,j,k+1)-wz(i,j,k))/(p1d(i)+&
&p1d(i-1)))-pkc_tl(i-1,j,k)*(dtdx2(j)*(wz(i-1,j,k+1)-wz(i,j,k))/(p1d(i)+p1d(i-1)))-pkc_tl(i,j,k)*(dtdx2(j)*(wz(i-1,j,k)-wz(i,&
&j,k+1))/(p1d(i)+p1d(i-1)))+uc_tl(i,j,k)+wz_tl(i-1,j,k+1)*(dtdx2(j)*(pkc(i,j,k+1)-pkc(i-1,j,k))/(p1d(i)+p1d(i-1)))-wz_tl(i,j,&
&k+1)*(dtdx2(j)*(pkc(i-1,j,k+1)-pkc(i,j,k))/(p1d(i)+p1d(i-1)))+wz_tl(i-1,j,k)*(dtdx2(j)*(pkc(i-1,j,k+1)-pkc(i,j,k))/(p1d(i)+&
&p1d(i-1)))-wz_tl(i,j,k)*(dtdx2(j)*(pkc(i,j,k+1)-pkc(i-1,j,k))/(p1d(i)+p1d(i-1)))
      uc(i,j,k) = uc(i,j,k)+dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*(pkc(i-1,j,k+&
&1)-pkc(i,j,k)))/(p1d(i)+p1d(i-1))
    end do
  end do
  help_j = jn2g0-js2g0+1
  call pft2d_tl( uc(1,js2g0,k),uc_tl(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_j,ifax,trigs,wk,wk_tl,wk2 )
end do
#ifdef TIMING
call g_timing_off( 'C_U_LOOP' )
call g_timing_on( 'Recv_pkc_wz' )
#endif
help_k = km+1
call mp_recv2_s( im,jm,jfirst,jlast,1,help_k,1,1,pkc_tl,wz_tl )
call mp_recv2_s( im,jm,jfirst,jlast,1,help_k,1,1,pkc,wz )
#ifdef TIMING
call g_timing_off( 'Recv_pkc_wz' )
call g_timing_on( 'Send_uc' )
#endif
call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uc_tl,2 )
call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uc,2 )
#ifdef TIMING
call g_timing_off( 'Send_uc' )
call g_timing_on( 'C_V_LOOP' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(help_l,i,j,k,wk,wk1,wk1_tl,wk_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jlast
    do i = 1, im
      wk1_tl(i,j) = pkc_tl(i,j,k+1)-pkc_tl(i,j,k)
      wk1(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      vc_tl(i,j,k) = pkc_tl(i,j-1,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(wz(i,j-1,k)-wz(i,j,k+1))-pkc_tl(i,j-1,k)*dtdy5/(wk1(i,j)+wk1(i,&
&j-1))*(wz(i,j-1,k+1)-wz(i,j,k))+pkc_tl(i,j,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(wz(i,j-1,k+1)-wz(i,j,k))-pkc_tl(i,j,k)*dtdy5/&
&(wk1(i,j)+wk1(i,j-1))*(wz(i,j-1,k)-wz(i,j,k+1))+vc_tl(i,j,k)-wk1_tl(i,j-1)*dtdy5/((wk1(i,j)+wk1(i,j-1))*(wk1(i,j)+wk1(i,j-1)&
&))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-wz(i,j,k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))-wk1_tl(i,j)&
&*dtdy5/((wk1(i,j)+wk1(i,j-1))*(wk1(i,j)+wk1(i,j-1)))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-&
&wz(i,j,k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))+wz_tl(i,j-1,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j,k+1)-pkc(i,j-1,k))+wz_tl(i,&
&j-1,k)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j-1,k+1)-pkc(i,j,k))-wz_tl(i,j,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j-1,k+1)-&
&pkc(i,j,k))-wz_tl(i,j,k)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j,k+1)-pkc(i,j-1,k))
      vc(i,j,k) = vc(i,j,k)+dtdy5/(wk1(i,j)+wk1(i,j-1))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-wz(i,j,&
&k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))
    end do
  end do
  help_l = jlast-js2g0+1
  call pft2d_tl( vc(1,js2g0,k),vc_tl(1,js2g0,k),se(js2g0),de(1,js2g0),im,help_l,ifax,trigs,wk,wk_tl,wk1 )
end do
#ifdef TIMING
call g_timing_off( 'C_V_LOOP' )
call g_timing_on( 'Recv_uc' )
#endif
call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uc_tl,2 )
call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uc,2 )
#ifdef TIMING
call g_timing_off( 'Recv_uc' )
call g_timing_on( 'Ghost_vc' )
#endif
call mp_send_s( im,jm,jfirst,jlast,1,km,2,2,vc_tl )
call mp_send_s( im,jm,jfirst,jlast,1,km,2,2,vc )
call mp_recv_n( im,jm,jfirst,jlast,1,km,2,2,vc_tl )
call mp_recv_n( im,jm,jfirst,jlast,1,km,2,2,vc )
#ifdef TIMING
call g_timing_off( 'Ghost_vc' )
call g_timing_on( 'D_CORE' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    if (k .eq. 1) then
      iord = 1
      jord = 1
    else
      iord = min(2,iord_d)
      jord = min(2,jord_d)
    endif
  else
    iord = iord_d
    jord = jord_d
  endif
  call d_sw_tl( u(1,jfirst-ng_d,k),u_tm(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),v_tm(1,jfirst-ng_s,k),uc(1,jfirst-ng_d,k),uc_tl(1,&
&jfirst-ng_d,k),vc(1,jfirst-2,k),vc_tl(1,jfirst-2,k),pt(1,jfirst-ng_d,k),pt_tm(1,jfirst-ng_d,k),delp(1,jfirst,k),delp_tm(1,&
&jfirst,k),delpf(1,jfirst-ng_d,k),delpf_tl(1,jfirst-ng_d,k),cx3(1,jfirst-ng_d,k),cx3_tl(1,jfirst-ng_d,k),cy3(1,jfirst,k),&
&cy3_tl(1,jfirst,k),mfx(1,jfirst,k),mfx_tl(1,jfirst,k),mfy(1,jfirst,k),mfy_tl(1,jfirst,k),cdx(js2g0,k),cdy(js2g0,k),dtdx,dtdxe,&
&dtxe5,txe5,dyce,rdx,cyy,dx,f0(jfirst-ng_d),js2g0,jn1g1,im,jm,jfirst,jlast,ng_d,ng_s,nq,iord,jord,zt_d,rcap,tiny,dtdy,dtdy5,tdy5,&
&rdy,cosp,acosp,cose,coslon,sinlon,cosl5,sinl5 )
end do
#ifdef TIMING
call g_timing_off( 'D_CORE' )
call g_timing_on( 'D_GEOP' )
#endif
call geopk_tl( ptop,pe,pe_tm,delp,delp_tm,pkc,pkc_tl,wz,wz_tl,hs,pt,pt_tm,im,km,jfirst,jlast,ng_d,cp,akap,nx,ipe, .true.  )
#ifdef TIMING
call g_timing_off( 'D_GEOP' )
call g_timing_on( 'Send_pkc_wz' )
#endif
help_m = km+1
call mp_send2_ns( im,jm,jfirst,jlast,1,help_m,1,pkc_tl,wz_tl )
call mp_send2_ns( im,jm,jfirst,jlast,1,help_m,1,pkc,wz )
#ifdef TIMING
call g_timing_off( 'Send_pkc_wz' )
#endif
if (ipe .ne. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_n,i,j,k,wk,wk2,wk_tl)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf_tl(i,j,k) = delp_tm(i,j,k)
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_n = jn2g0-js2g0+1
    call pft2d_tl( delpf(1,js2g0,k),delpf_tl(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_n,ifax,trigs,wk,wk_tl,wk2 )
  end do
else
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km+1
    do j = jfirst, jlast
      do i = 1, im
        pk_tm(i,j,k) = pkc_tl(i,j,k)
        pk(i,j,k) = pkc(i,j,k)
      end do
    end do
  end do
endif
#ifdef TIMING
call g_timing_on( 'Recv_pkc_wz' )
#endif
help_o = km+1
call mp_recv2_ns( im,jm,jfirst,jlast,1,help_o,1,pkc_tl,wz_tl )
call mp_recv2_ns( im,jm,jfirst,jlast,1,help_o,1,pkc,wz )
#ifdef TIMING
call g_timing_off( 'Recv_pkc_wz' )
#endif
if (ipe .ne. 1) then
#ifdef TIMING
  call g_timing_on( 'Send_pt&delpf' )
#endif
  call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt_tm,1 )
  call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf_tl,2 )
  call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
#ifdef TIMING
  call g_timing_off( 'Send_pt&delpf' )
#endif
endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jn1g1
    do i = 1, im
      dpt_tl(i,j,k) = pkc_tl(i,j,k+1)*(wz(i,j,k+1)+wz(i,j,k))-pkc_tl(i,j,k)*(wz(i,j,k+1)+wz(i,j,k))+(wz_tl(i,j,k+1)+wz_tl(i,j,k))*&
&(pkc(i,j,k+1)-pkc(i,j,k))
      dpt(i,j,k) = (wz(i,j,k+1)+wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j,k))
    end do
  end do
end do
#ifdef TIMING
call g_timing_on( 'D-4500' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,pkchelp,pkchelp_tl,wk1,wk1_tl,wk3,wk3_tl)
#endif /* ! USE_OPENMP */
do k = 2, km+1
  do j = js2g1, jn2g0
    wk3_tl(1,j) = (-(pkc_tl(im,j,k)*(wz(1,j,k)+wz(im,j,k))))+pkc_tl(1,j,k)*(wz(1,j,k)+wz(im,j,k))+(wz_tl(im,j,k)+wz_tl(1,j,k))*&
&(pkc(1,j,k)-pkc(im,j,k))
    wk3(1,j) = (wz(1,j,k)+wz(im,j,k))*(pkc(1,j,k)-pkc(im,j,k))
    do i = 2, im
      wk3_tl(i,j) = (-(pkc_tl(i-1,j,k)*(wz(i,j,k)+wz(i-1,j,k))))+pkc_tl(i,j,k)*(wz(i,j,k)+wz(i-1,j,k))+(wz_tl(i-1,j,k)+wz_tl(i,j,k)&
&)*(pkc(i,j,k)-pkc(i-1,j,k))
      wk3(i,j) = (wz(i,j,k)+wz(i-1,j,k))*(pkc(i,j,k)-pkc(i-1,j,k))
    end do
  end do
  do j = js2g1, jn2g0
    do i = 1, im-1
      wk1_tl(i,j) = wk3_tl(i+1,j)+wk3_tl(i,j)
      wk1(i,j) = wk3(i,j)+wk3(i+1,j)
    end do
    wk1_tl(im,j) = wk3_tl(im,j)+wk3_tl(1,j)
    wk1(im,j) = wk3(im,j)+wk3(1,j)
  end do
  if (jfirst .eq. 1) then
    do i = 1, im
      wk1_tl(i,1) = 0.d0
      wk1(i,1) = 0.
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im
      wk1_tl(i,jm) = 0.d0
      wk1(i,jm) = 0.
    end do
  endif
  do j = js2g0, jlast
    do i = 1, im
      wz3_tl(i,j,k) = wk1_tl(i,j-1)+wk1_tl(i,j)
      wz3(i,j,k) = wk1(i,j)+wk1(i,j-1)
    end do
  end do
  do j = js2g0, jn1g1
    do i = 1, im
      wk1_tl(i,j) = (-(pkc_tl(i,j-1,k)*(wz(i,j,k)+wz(i,j-1,k))))+pkc_tl(i,j,k)*(wz(i,j,k)+wz(i,j-1,k))+(wz_tl(i,j-1,k)+wz_tl(i,j,k)&
&)*(pkc(i,j,k)-pkc(i,j-1,k))
      wk1(i,j) = (wz(i,j,k)+wz(i,j-1,k))*(pkc(i,j,k)-pkc(i,j-1,k))
    end do
  end do
  do j = js2g0, jn1g1
    wk3_tl(1,j) = wk1_tl(im,j)+wk1_tl(1,j)
    wk3(1,j) = wk1(1,j)+wk1(im,j)
    do i = 2, im
      wk3_tl(i,j) = wk1_tl(i-1,j)+wk1_tl(i,j)
      wk3(i,j) = wk1(i,j)+wk1(i-1,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wz_tl(i,j,k) = wk3_tl(i,j+1)+wk3_tl(i,j)
      wz(i,j,k) = wk3(i,j)+wk3(i,j+1)
    end do
  end do
  do j = jfirst-1, jlast+1
    do i = 1, im
      pkchelp_tl(i,j) = pkc_tl(i,j,k)
      pkchelp(i,j) = pkc(i,j,k)
    end do
  end do
  call avgc_tl( pkchelp,pkchelp_tl,pkc(1,jfirst,k),pkc_tl(1,jfirst,k),im,jm,jfirst,jlast,wk1,wk1_tl )
end do
#ifdef TIMING
call g_timing_off( 'D-4500' )
#endif
do j = js2g0, jlast
  do i = 1, im
    wz3_tl(i,j,1) = 0.d0
    wz3(i,j,1) = 0.
    wz_tl(i,j,1) = 0.d0
    wz(i,j,1) = 0.
  end do
end do
pk4 = 4.*ptop**akap
do j = js2g0, jn1g1
  do i = 1, im
    pkc_tl(i,j,1) = 0.d0
    pkc(i,j,1) = pk4
  end do
end do
#ifdef TIMING
call g_timing_on( 'D-6000' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(help_p,help_q,i,j,k,wk,wk1,wk1_tl,wk2,wk2_tl,wk3,wk3_tl,wk_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  call avgc_tl( dpt(1,jfirst-1,k),dpt_tl(1,jfirst-1,k),wk2(1,jfirst),wk2_tl(1,jfirst),im,jm,jfirst,jlast,wk1,wk1_tl )
  do j = js2g0, jn1g1
    do i = 1, im
      wk_tl(i,j) = pkc_tl(i,j,k+1)-pkc_tl(i,j,k)
      wk(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im-1
      wk3_tl(i,j) = uc_tl(i,j,k)-wk_tl(i+1,j)*dtdxe(j)/((wk(i,j)+wk(i+1,j))*(wk(i,j)+wk(i+1,j)))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-&
&wz3(i,j,k))-wk_tl(i,j)*dtdxe(j)/((wk(i,j)+wk(i+1,j))*(wk(i,j)+wk(i+1,j)))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-wz3(i,j,k))-&
&wk2_tl(i+1,j)*(dtdxe(j)/(wk(i,j)+wk(i+1,j)))+(wk2_tl(i,j)+wz3_tl(i,j,k+1))*(dtdxe(j)/(wk(i,j)+wk(i+1,j)))-wz3_tl(i,j,k)*&
&(dtdxe(j)/(wk(i,j)+wk(i+1,j)))
      wk3(i,j) = uc(i,j,k)+dtdxe(j)/(wk(i,j)+wk(i+1,j))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-wz3(i,j,k))
    end do
    wk3_tl(im,j) = uc_tl(im,j,k)-wk_tl(im,j)*dtdxe(j)/((wk(im,j)+wk(1,j))*(wk(im,j)+wk(1,j)))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-&
&wz3(im,j,k))-wk_tl(1,j)*dtdxe(j)/((wk(im,j)+wk(1,j))*(wk(im,j)+wk(1,j)))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-wz3(im,j,k))+&
&wk2_tl(im,j)*(dtdxe(j)/(wk(im,j)+wk(1,j)))-wk2_tl(1,j)*(dtdxe(j)/(wk(im,j)+wk(1,j)))+wz3_tl(im,j,k+1)*(dtdxe(j)/(wk(im,j)+&
&wk(1,j)))-wz3_tl(im,j,k)*(dtdxe(j)/(wk(im,j)+wk(1,j)))
    wk3(im,j) = uc(im,j,k)+dtdxe(j)/(wk(im,j)+wk(1,j))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-wz3(im,j,k))
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wk1_tl(i,j) = vc_tl(i,j,k)-wk_tl(i,j+1)*dtdy/((wk(i,j)+wk(i,j+1))*(wk(i,j)+wk(i,j+1)))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,&
&j,k))-wk_tl(i,j)*dtdy/((wk(i,j)+wk(i,j+1))*(wk(i,j)+wk(i,j+1)))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,j,k))-wk2_tl(i,j+1)*&
&(dtdy/(wk(i,j)+wk(i,j+1)))+(wk2_tl(i,j)+wz_tl(i,j,k+1))*(dtdy/(wk(i,j)+wk(i,j+1)))-wz_tl(i,j,k)*(dtdy/(wk(i,j)+wk(i,j+1)))
      wk1(i,j) = vc(i,j,k)+dtdy/(wk(i,j)+wk(i,j+1))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,j,k))
    end do
  end do
  help_p = jlast-js2g0+1
  call pft2d_tl( wk3(1,js2g0),wk3_tl(1,js2g0),se(js2g0),de(1,js2g0),im,help_p,ifax,trigs,wk,wk_tl,wk2 )
  help_q = jn2g0-js2g0+1
  call pft2d_tl( wk1(1,js2g0),wk1_tl(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_q,ifax,trigs,wk,wk_tl,wk2 )
  do j = js2g0, jlast
    do i = 1, im
      u_tm(i,j,k) = u_tm(i,j,k)+wk3_tl(i,j)
      u(i,j,k) = u(i,j,k)+wk3(i,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v_tm(i,j,k) = v_tm(i,j,k)+wk1_tl(i,j)
      v(i,j,k) = v(i,j,k)+wk1(i,j)
    end do
  end do
end do
#ifdef TIMING
call g_timing_off( 'D-6000' )
#endif
if (ipe .ne. 1) then
#ifdef TIMING
  call g_timing_on( 'Recv_pt&delpf' )
#endif
  call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt_tm,1 )
  call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf_tl,2 )
  call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
#ifdef TIMING
  call g_timing_off( 'Recv_pt&delpf' )
#endif
endif

end subroutine cd_core_do_tl


subroutine cd_core_initialize_tl( im, jm, km, jfirst, jlast, ng_c, ng_d, ng_s, dt, ae, om, ptop, umax, sinp, cosp, cose, acosp )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use sw_core_tl
use tp_core
use tp_core_tl
use mod_comm, only : gid,gsize,mp_barrier, mp_recv2_ns, mp_recv2_s, mp_recv3d_ns, mp_recv_n, mp_send2_n, mp_send2_ns, mp_send3d_ns,&
& mp_send_s

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: ae
real(kind=r8) :: cose(jm)
real(kind=r8) :: cosp(jm)
real(kind=r8) :: dt
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_c
integer :: ng_d
integer :: ng_s
real(kind=r8) :: om
real(kind=r8) :: ptop
real(kind=r8) :: sinp(jm)
real(kind=r8) :: umax

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: ak(km+1)
real(kind=r8) :: bk(km+1)
real(kind=r8) :: dl
real(kind=r8) :: dp
real(kind=r8) :: dt5
real(kind=r8) :: fac
integer :: j
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: js2g0
integer :: js2gc
integer :: k
integer :: ks
double precision :: pi
real(kind=r8) :: pint
real(kind=r8) :: press
real(kind=r8) :: ptmp
real(kind=r8) :: rat
real(kind=r8) :: tau
real(kind=r8) :: ycrit

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
call fftfax( im,ifax,trigs )
pi = 4.d0*datan(1.d0)
rat = float(im)/float(2*(jm-1))
ycrit = acos(min(0.81_8,rat))*(180./pi)
call pft_cf( im,jm,js2g0,jn2g0,jn1g1,sc,se,dc,de,cosp,cose,ycrit )
do j = max(1,jfirst-ng_s), min(jm,jlast+ng_d)
  f0(j) = (om+om)*sinp(j)
end do
do j = js2gc, jn1gc
  fc(j) = 0.5*(f0(j)+f0(j-1))
end do
dt5 = 0.5*dt
pi = 4.d0*datan(1.d0)
dl = (pi+pi)/im
dp = pi/(jm-1)
rdy = 1./(ae*dp)
dtdy = dt*rdy
dtdy5 = dt5*rdy
dydt = ae*dp/dt
tdy5 = 0.5/dtdy
do j = 2, jm-1
  dx(j) = dl*ae*cosp(j)
  rdx(j) = 1./dx(j)
  dtdx(j) = dt/dx(j)
  dxdt(j) = dx(j)/dt
  dtdx2(j) = 0.5*dtdx(j)
  dtdx4(j) = 0.5*dtdx2(j)
  dycp(j) = ae*dp/cosp(j)
  cyy(j) = rdy*acosp(j)
end do
do j = 2, jm
  dxe(j) = ae*dl*cose(j)
  rdxe(j) = 1./dxe(j)
  dtdxe(j) = dt/dxe(j)
  dtxe5(j) = 0.5*dtdxe(j)
  txe5(j) = 0.5/dtdxe(j)
  cye(j) = 1./(ae*cose(j)*dp)
  dyce(j) = ae*dp/cose(j)
end do
zt_c = abs(umax*dt5)/(dl*ae)
zt_d = abs(umax*dt)/(dl*ae)
call set_eta( km,ks,ptmp,pint,ak,bk )
if (ptop .ne. ptmp) then
  stop
endif
do k = 1, km
  press = 0.5*(ak(k)+ak(k+1)+(bk(k)+bk(k+1))*1.e+5)
  tau = 8.*(1.+tanh(1.*log(max(ptop,2._8)/press)))
  tau = max(1._8,tau)/(128.*max(abs(dt),225._8))
  do j = js2g0, jn1g1
    fac = tau*ae/cose(j)
    cdx(j,k) = fac*dp
    cdy(j,k) = fac*dl
  end do
end do

end subroutine cd_core_initialize_tl


end module     cd_core_tl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     cd_core_tl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use cd_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine cd_core_do_tl( im, jm, km, nq, nx, jfirst, jlast, u, u_tm, v, v_tm, pt, pt_tm, delp, delp_tm, pe, pe_tm, pk, pk_tm, ns, &
&ptop, rcap, cp, akap, iord_c, jord_c, iord_d, jord_d, ng_c, ng_d, ng_s, ipe, hs, cosp, cose, acosp, sinlon, coslon, cosl5, sinl5, &
&cx3, cx3_tl, cy3, cy3_tl, mfx, mfx_tl, mfy, mfy_tl, delpf, delpf_tl, uc, uc_tl, vc, vc_tl, ptc, ptc_tl, dpt, dpt_tl, ptk, ptk_tl, &
&wz3, wz3_tl, pkc, pkc_tl, wz, wz_tl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use sw_core_tl
use tp_core
use tp_core_tl
#ifdef TIMING
use timingmodule
#endif

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: akap
real(kind=r8) :: cose(jm)
integer :: im
real(kind=r8) :: cosl5(im)
real(kind=r8) :: coslon(im)
real(kind=r8) :: cosp(jm)
real(kind=r8) :: cp
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
real(kind=r8) :: cx3(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: cx3_tl(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: cy3(im,jfirst:jlast+1,km)
real(kind=r8) :: cy3_tl(im,jfirst:jlast+1,km)
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_tm(im,jfirst:jlast,km)
real(kind=r8) :: delpf(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: delpf_tl(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: dpt(im,jfirst-1:jlast+1,km)
real(kind=r8) :: dpt_tl(im,jfirst-1:jlast+1,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: iord_c
integer :: iord_d
integer :: ipe
integer :: jord_c
integer :: jord_d
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfx_tl(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
real(kind=r8) :: mfy_tl(im,jfirst:jlast+1,km)
integer :: ng_c
integer :: ng_s
integer :: nq
integer :: ns
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_tm(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pk_tm(im,jfirst:jlast,km+1)
real(kind=r8) :: pkc(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pkc_tl(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_tm(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: ptc(im,jfirst:jlast,km)
real(kind=r8) :: ptc_tl(im,jfirst:jlast,km)
real(kind=r8) :: ptk(im,jfirst:jlast,km)
real(kind=r8) :: ptk_tl(im,jfirst:jlast,km)
real(kind=r8) :: ptop
real(kind=r8) :: rcap
real(kind=r8) :: sinl5(im)
real(kind=r8) :: sinlon(im)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_tm(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uc(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: uc_tl(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_tm(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: vc(im,jfirst-2:jlast+2,km)
real(kind=r8) :: vc_tl(im,jfirst-2:jlast+2,km)
real(kind=r8) :: wz(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: wz3(im,jfirst-1:jlast,km+1)
real(kind=r8) :: wz3_tl(im,jfirst-1:jlast,km+1)
real(kind=r8) :: wz_tl(im,jfirst-1:jlast+1,km+1)

!==============================================
! declare local variables
!==============================================
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: help_l
integer :: help_m
integer :: i
integer :: iord
integer :: j
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: jord
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: js2gc
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_tl(im)
real(kind=r8) :: pk4
real(kind=r8) :: pkchelp(im,jfirst-1:jlast+1)
real(kind=r8) :: pkchelp_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: wk(im,jfirst:jlast+2)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk1_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: wk2(im,jfirst:jlast+1)
real(kind=r8) :: wk2_tl(im,jfirst:jlast+1)
real(kind=r8) :: wk3(im,jfirst-1:jlast+1)
real(kind=r8) :: wk3_tl(im,jfirst-1:jlast+1)
real(kind=r8) :: wk_tl(im,jfirst:jlast+2)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
wz_tl = 0.d0
wz = 0.
wz3_tl = 0.d0
wz3 = 0.
uc_tl = 0.d0
uc = 0.
vc_tl = 0.d0
vc = 0.
if (ipe .eq. (-1) .or. ns .eq. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_h,i,j,k,wk,wk2,wk_tl)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf_tl(i,j,k) = delp_tm(i,j,k)
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_h = jn2g0-js2g0+1
    call pft2d_tl( delpf(1,js2g0,k),delpf_tl(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,wk,wk_tl,wk2 )
  end do
endif
#ifdef TIMING
call g_timing_on( 'C_CORE' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    iord = 1
    jord = 1
  else
    iord = iord_c
    jord = jord_c
  endif
  call c_sw_tl( u(1,jfirst-ng_d,k),u_tm(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),v_tm(1,jfirst-ng_s,k),pt(1,jfirst-ng_d,k),pt_tm(1,&
&jfirst-ng_d,k),delp(1,jfirst,k),delp_tm(1,jfirst,k),uc(1,jfirst-ng_d,k),uc_tl(1,jfirst-ng_d,k),vc(1,jfirst-2,k),vc_tl(1,jfirst-&
&2,k),ptc(1,jfirst,k),ptc_tl(1,jfirst,k),delpf(1,jfirst-ng_d,k),delpf_tl(1,jfirst-ng_d,k),ptk(1:im,jfirst:jlast,k),ptk_tl(1:im,&
&jfirst:jlast,k),cosp,acosp,cose,coslon,sinlon,dxdt,dxe,dtdx2,dtdx4,dtxe5,rdxe,dycp,dydt,dtdy5,cye,fc,ifax,trigs,dc(1,js2g0),sc,&
&zt_c,tiny,rcap,im,jm,jfirst,jlast,ng_c,ng_d,ng_s,js2g0,jn2g0,js2gc,jn1gc,iord,jord,cosl5,sinl5 )
end do
#ifdef TIMING
call g_timing_off( 'C_CORE' )
call g_timing_on( 'C_GEOP' )
#endif
call geopk_tl( ptop,pe,pe_tm,ptk,ptk_tl,pkc,pkc_tl,wz,wz_tl,hs,ptc,ptc_tl,im,km,jfirst,jlast,0,cp,akap,nx,0, .false.  )
#ifdef TIMING
call g_timing_off( 'C_GEOP' )
call g_timing_on( 'C_U_LOOP' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(help_i,i,j,k,p1d,p1d_tl,wk,wk2,wk_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, jn2g0
    do i = 1, im
      p1d_tl(i) = pkc_tl(i,j,k+1)-pkc_tl(i,j,k)
      p1d(i) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
    uc_tl(1,j,k) = (-(p1d_tl(im)*(dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,&
&k+1)-pkc(1,j,k)))/((p1d(1)+p1d(im))*(p1d(1)+p1d(im))))))-p1d_tl(1)*(dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,&
&k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,k+1)-pkc(1,j,k)))/((p1d(1)+p1d(im))*(p1d(1)+p1d(im))))+pkc_tl(im,j,k+1)*(dtdx2(j)*&
&(wz(im,j,k)-wz(1,j,k+1))/(p1d(1)+p1d(im)))+pkc_tl(1,j,k+1)*(dtdx2(j)*(wz(im,j,k+1)-wz(1,j,k))/(p1d(1)+p1d(im)))-pkc_tl(im,j,k)&
&*(dtdx2(j)*(wz(im,j,k+1)-wz(1,j,k))/(p1d(1)+p1d(im)))-pkc_tl(1,j,k)*(dtdx2(j)*(wz(im,j,k)-wz(1,j,k+1))/(p1d(1)+p1d(im)))+&
&uc_tl(1,j,k)+wz_tl(im,j,k+1)*(dtdx2(j)*(pkc(1,j,k+1)-pkc(im,j,k))/(p1d(1)+p1d(im)))-wz_tl(1,j,k+1)*(dtdx2(j)*(pkc(im,j,k+1)-&
&pkc(1,j,k))/(p1d(1)+p1d(im)))+wz_tl(im,j,k)*(dtdx2(j)*(pkc(im,j,k+1)-pkc(1,j,k))/(p1d(1)+p1d(im)))-wz_tl(1,j,k)*(dtdx2(j)*&
&(pkc(1,j,k+1)-pkc(im,j,k))/(p1d(1)+p1d(im)))
    uc(1,j,k) = uc(1,j,k)+dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,k+1)-&
&pkc(1,j,k)))/(p1d(1)+p1d(im))
    do i = 2, im
      uc_tl(i,j,k) = (-(p1d_tl(i-1)*(dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*&
&(pkc(i-1,j,k+1)-pkc(i,j,k)))/((p1d(i)+p1d(i-1))*(p1d(i)+p1d(i-1))))))-p1d_tl(i)*(dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,&
&j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*(pkc(i-1,j,k+1)-pkc(i,j,k)))/((p1d(i)+p1d(i-1))*(p1d(i)+p1d(i-1))))+pkc_tl(i-&
&1,j,k+1)*(dtdx2(j)*(wz(i-1,j,k)-wz(i,j,k+1))/(p1d(i)+p1d(i-1)))+pkc_tl(i,j,k+1)*(dtdx2(j)*(wz(i-1,j,k+1)-wz(i,j,k))/(p1d(i)+&
&p1d(i-1)))-pkc_tl(i-1,j,k)*(dtdx2(j)*(wz(i-1,j,k+1)-wz(i,j,k))/(p1d(i)+p1d(i-1)))-pkc_tl(i,j,k)*(dtdx2(j)*(wz(i-1,j,k)-wz(i,&
&j,k+1))/(p1d(i)+p1d(i-1)))+uc_tl(i,j,k)+wz_tl(i-1,j,k+1)*(dtdx2(j)*(pkc(i,j,k+1)-pkc(i-1,j,k))/(p1d(i)+p1d(i-1)))-wz_tl(i,j,&
&k+1)*(dtdx2(j)*(pkc(i-1,j,k+1)-pkc(i,j,k))/(p1d(i)+p1d(i-1)))+wz_tl(i-1,j,k)*(dtdx2(j)*(pkc(i-1,j,k+1)-pkc(i,j,k))/(p1d(i)+&
&p1d(i-1)))-wz_tl(i,j,k)*(dtdx2(j)*(pkc(i,j,k+1)-pkc(i-1,j,k))/(p1d(i)+p1d(i-1)))
      uc(i,j,k) = uc(i,j,k)+dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*(pkc(i-1,j,k+&
&1)-pkc(i,j,k)))/(p1d(i)+p1d(i-1))
    end do
  end do
  help_i = jn2g0-js2g0+1
  call pft2d_tl( uc(1,js2g0,k),uc_tl(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_i,ifax,trigs,wk,wk_tl,wk2 )
end do
#ifdef TIMING
call g_timing_off( 'C_U_LOOP' )
call g_timing_on( 'C_V_LOOP' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(help_j,i,j,k,wk,wk1,wk1_tl,wk_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jlast
    do i = 1, im
      wk1_tl(i,j) = pkc_tl(i,j,k+1)-pkc_tl(i,j,k)
      wk1(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      vc_tl(i,j,k) = pkc_tl(i,j-1,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(wz(i,j-1,k)-wz(i,j,k+1))-pkc_tl(i,j-1,k)*dtdy5/(wk1(i,j)+wk1(i,&
&j-1))*(wz(i,j-1,k+1)-wz(i,j,k))+pkc_tl(i,j,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(wz(i,j-1,k+1)-wz(i,j,k))-pkc_tl(i,j,k)*dtdy5/&
&(wk1(i,j)+wk1(i,j-1))*(wz(i,j-1,k)-wz(i,j,k+1))+vc_tl(i,j,k)-wk1_tl(i,j-1)*dtdy5/((wk1(i,j)+wk1(i,j-1))*(wk1(i,j)+wk1(i,j-1)&
&))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-wz(i,j,k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))-wk1_tl(i,j)&
&*dtdy5/((wk1(i,j)+wk1(i,j-1))*(wk1(i,j)+wk1(i,j-1)))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-&
&wz(i,j,k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))+wz_tl(i,j-1,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j,k+1)-pkc(i,j-1,k))+wz_tl(i,&
&j-1,k)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j-1,k+1)-pkc(i,j,k))-wz_tl(i,j,k+1)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j-1,k+1)-&
&pkc(i,j,k))-wz_tl(i,j,k)*dtdy5/(wk1(i,j)+wk1(i,j-1))*(pkc(i,j,k+1)-pkc(i,j-1,k))
      vc(i,j,k) = vc(i,j,k)+dtdy5/(wk1(i,j)+wk1(i,j-1))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-wz(i,j,&
&k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))
    end do
  end do
  help_j = jlast-js2g0+1
  call pft2d_tl( vc(1,js2g0,k),vc_tl(1,js2g0,k),se(js2g0),de(1,js2g0),im,help_j,ifax,trigs,wk,wk_tl,wk1 )
end do
#ifdef TIMING
call g_timing_off( 'C_V_LOOP' )
call g_timing_on( 'D_CORE' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    if (k .eq. 1) then
      iord = 1
      jord = 1
    else
      iord = min(2,iord_d)
      jord = min(2,jord_d)
    endif
  else
    iord = iord_d
    jord = jord_d
  endif
  call d_sw_tl( u(1,jfirst-ng_d,k),u_tm(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),v_tm(1,jfirst-ng_s,k),uc(1,jfirst-ng_d,k),uc_tl(1,&
&jfirst-ng_d,k),vc(1,jfirst-2,k),vc_tl(1,jfirst-2,k),pt(1,jfirst-ng_d,k),pt_tm(1,jfirst-ng_d,k),delp(1,jfirst,k),delp_tm(1,&
&jfirst,k),delpf(1,jfirst-ng_d,k),delpf_tl(1,jfirst-ng_d,k),cx3(1,jfirst-ng_d,k),cx3_tl(1,jfirst-ng_d,k),cy3(1,jfirst,k),&
&cy3_tl(1,jfirst,k),mfx(1,jfirst,k),mfx_tl(1,jfirst,k),mfy(1,jfirst,k),mfy_tl(1,jfirst,k),cdx(js2g0,k),cdy(js2g0,k),dtdx,dtdxe,&
&dtxe5,txe5,dyce,rdx,cyy,dx,f0(jfirst-ng_d),js2g0,jn1g1,im,jm,jfirst,jlast,ng_d,ng_s,nq,iord,jord,zt_d,rcap,tiny,dtdy,dtdy5,tdy5,&
&rdy,cosp,acosp,cose,coslon,sinlon,cosl5,sinl5 )
end do
#ifdef TIMING
call g_timing_off( 'D_CORE' )
call g_timing_on( 'D_GEOP' )
#endif
call geopk_tl( ptop,pe,pe_tm,delp,delp_tm,pkc,pkc_tl,wz,wz_tl,hs,pt,pt_tm,im,km,jfirst,jlast,ng_d,cp,akap,nx,ipe, .true.  )
#ifdef TIMING
call g_timing_off( 'D_GEOP' )
#endif
if (ipe .ne. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_k,i,j,k,wk,wk2,wk_tl)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf_tl(i,j,k) = delp_tm(i,j,k)
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_k = jn2g0-js2g0+1
    call pft2d_tl( delpf(1,js2g0,k),delpf_tl(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_k,ifax,trigs,wk,wk_tl,wk2 )
  end do
else
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km+1
    do j = jfirst, jlast
      do i = 1, im
        pk_tm(i,j,k) = pkc_tl(i,j,k)
        pk(i,j,k) = pkc(i,j,k)
      end do
    end do
  end do
endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jn1g1
    do i = 1, im
      dpt_tl(i,j,k) = pkc_tl(i,j,k+1)*(wz(i,j,k+1)+wz(i,j,k))-pkc_tl(i,j,k)*(wz(i,j,k+1)+wz(i,j,k))+(wz_tl(i,j,k+1)+wz_tl(i,j,k))*&
&(pkc(i,j,k+1)-pkc(i,j,k))
      dpt(i,j,k) = (wz(i,j,k+1)+wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j,k))
    end do
  end do
end do
#ifdef TIMING
call g_timing_on( 'D-4500' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,pkchelp,pkchelp_tl,wk1,wk1_tl,wk3,wk3_tl)
#endif /* ! USE_OPENMP */
do k = 2, km+1
  do j = js2g1, jn2g0
    wk3_tl(1,j) = (-(pkc_tl(im,j,k)*(wz(1,j,k)+wz(im,j,k))))+pkc_tl(1,j,k)*(wz(1,j,k)+wz(im,j,k))+(wz_tl(im,j,k)+wz_tl(1,j,k))*&
&(pkc(1,j,k)-pkc(im,j,k))
    wk3(1,j) = (wz(1,j,k)+wz(im,j,k))*(pkc(1,j,k)-pkc(im,j,k))
    do i = 2, im
      wk3_tl(i,j) = (-(pkc_tl(i-1,j,k)*(wz(i,j,k)+wz(i-1,j,k))))+pkc_tl(i,j,k)*(wz(i,j,k)+wz(i-1,j,k))+(wz_tl(i-1,j,k)+wz_tl(i,j,k)&
&)*(pkc(i,j,k)-pkc(i-1,j,k))
      wk3(i,j) = (wz(i,j,k)+wz(i-1,j,k))*(pkc(i,j,k)-pkc(i-1,j,k))
    end do
  end do
  do j = js2g1, jn2g0
    do i = 1, im-1
      wk1_tl(i,j) = wk3_tl(i+1,j)+wk3_tl(i,j)
      wk1(i,j) = wk3(i,j)+wk3(i+1,j)
    end do
    wk1_tl(im,j) = wk3_tl(im,j)+wk3_tl(1,j)
    wk1(im,j) = wk3(im,j)+wk3(1,j)
  end do
  if (jfirst .eq. 1) then
    do i = 1, im
      wk1_tl(i,1) = 0.d0
      wk1(i,1) = 0.
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im
      wk1_tl(i,jm) = 0.d0
      wk1(i,jm) = 0.
    end do
  endif
  do j = js2g0, jlast
    do i = 1, im
      wz3_tl(i,j,k) = wk1_tl(i,j-1)+wk1_tl(i,j)
      wz3(i,j,k) = wk1(i,j)+wk1(i,j-1)
    end do
  end do
  do j = js2g0, jn1g1
    do i = 1, im
      wk1_tl(i,j) = (-(pkc_tl(i,j-1,k)*(wz(i,j,k)+wz(i,j-1,k))))+pkc_tl(i,j,k)*(wz(i,j,k)+wz(i,j-1,k))+(wz_tl(i,j-1,k)+wz_tl(i,j,k)&
&)*(pkc(i,j,k)-pkc(i,j-1,k))
      wk1(i,j) = (wz(i,j,k)+wz(i,j-1,k))*(pkc(i,j,k)-pkc(i,j-1,k))
    end do
  end do
  do j = js2g0, jn1g1
    wk3_tl(1,j) = wk1_tl(im,j)+wk1_tl(1,j)
    wk3(1,j) = wk1(1,j)+wk1(im,j)
    do i = 2, im
      wk3_tl(i,j) = wk1_tl(i-1,j)+wk1_tl(i,j)
      wk3(i,j) = wk1(i,j)+wk1(i-1,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wz_tl(i,j,k) = wk3_tl(i,j+1)+wk3_tl(i,j)
      wz(i,j,k) = wk3(i,j)+wk3(i,j+1)
    end do
  end do
  do j = jfirst-1, jlast+1
    do i = 1, im
      pkchelp_tl(i,j) = pkc_tl(i,j,k)
      pkchelp(i,j) = pkc(i,j,k)
    end do
  end do
  call avgc_tl( pkchelp,pkchelp_tl,pkc(1,jfirst,k),pkc_tl(1,jfirst,k),im,jm,jfirst,jlast,wk1,wk1_tl )
end do
#ifdef TIMING
call g_timing_off( 'D-4500' )
#endif
do j = js2g0, jlast
  do i = 1, im
    wz3_tl(i,j,1) = 0.d0
    wz3(i,j,1) = 0.
    wz_tl(i,j,1) = 0.d0
    wz(i,j,1) = 0.
  end do
end do
pk4 = 4.*ptop**akap
do j = js2g0, jn1g1
  do i = 1, im
    pkc_tl(i,j,1) = 0.d0
    pkc(i,j,1) = pk4
  end do
end do
#ifdef TIMING
call g_timing_on( 'D-6000' )
#endif
#ifdef USE_OPENMP
!$omp parallel do private(help_l,help_m,i,j,k,wk,wk1,wk1_tl,wk2,wk2_tl,wk3,wk3_tl,wk_tl)
#endif /* ! USE_OPENMP */
do k = 1, km
  call avgc_tl( dpt(1,jfirst-1,k),dpt_tl(1,jfirst-1,k),wk2(1,jfirst),wk2_tl(1,jfirst),im,jm,jfirst,jlast,wk1,wk1_tl )
  do j = js2g0, jn1g1
    do i = 1, im
      wk_tl(i,j) = pkc_tl(i,j,k+1)-pkc_tl(i,j,k)
      wk(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im-1
      wk3_tl(i,j) = uc_tl(i,j,k)-wk_tl(i+1,j)*dtdxe(j)/((wk(i,j)+wk(i+1,j))*(wk(i,j)+wk(i+1,j)))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-&
&wz3(i,j,k))-wk_tl(i,j)*dtdxe(j)/((wk(i,j)+wk(i+1,j))*(wk(i,j)+wk(i+1,j)))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-wz3(i,j,k))-&
&wk2_tl(i+1,j)*(dtdxe(j)/(wk(i,j)+wk(i+1,j)))+(wk2_tl(i,j)+wz3_tl(i,j,k+1))*(dtdxe(j)/(wk(i,j)+wk(i+1,j)))-wz3_tl(i,j,k)*&
&(dtdxe(j)/(wk(i,j)+wk(i+1,j)))
      wk3(i,j) = uc(i,j,k)+dtdxe(j)/(wk(i,j)+wk(i+1,j))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-wz3(i,j,k))
    end do
    wk3_tl(im,j) = uc_tl(im,j,k)-wk_tl(im,j)*dtdxe(j)/((wk(im,j)+wk(1,j))*(wk(im,j)+wk(1,j)))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-&
&wz3(im,j,k))-wk_tl(1,j)*dtdxe(j)/((wk(im,j)+wk(1,j))*(wk(im,j)+wk(1,j)))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-wz3(im,j,k))+&
&wk2_tl(im,j)*(dtdxe(j)/(wk(im,j)+wk(1,j)))-wk2_tl(1,j)*(dtdxe(j)/(wk(im,j)+wk(1,j)))+wz3_tl(im,j,k+1)*(dtdxe(j)/(wk(im,j)+&
&wk(1,j)))-wz3_tl(im,j,k)*(dtdxe(j)/(wk(im,j)+wk(1,j)))
    wk3(im,j) = uc(im,j,k)+dtdxe(j)/(wk(im,j)+wk(1,j))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-wz3(im,j,k))
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wk1_tl(i,j) = vc_tl(i,j,k)-wk_tl(i,j+1)*dtdy/((wk(i,j)+wk(i,j+1))*(wk(i,j)+wk(i,j+1)))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,&
&j,k))-wk_tl(i,j)*dtdy/((wk(i,j)+wk(i,j+1))*(wk(i,j)+wk(i,j+1)))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,j,k))-wk2_tl(i,j+1)*&
&(dtdy/(wk(i,j)+wk(i,j+1)))+(wk2_tl(i,j)+wz_tl(i,j,k+1))*(dtdy/(wk(i,j)+wk(i,j+1)))-wz_tl(i,j,k)*(dtdy/(wk(i,j)+wk(i,j+1)))
      wk1(i,j) = vc(i,j,k)+dtdy/(wk(i,j)+wk(i,j+1))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,j,k))
    end do
  end do
  help_l = jlast-js2g0+1
  call pft2d_tl( wk3(1,js2g0),wk3_tl(1,js2g0),se(js2g0),de(1,js2g0),im,help_l,ifax,trigs,wk,wk_tl,wk2 )
  help_m = jn2g0-js2g0+1
  call pft2d_tl( wk1(1,js2g0),wk1_tl(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_m,ifax,trigs,wk,wk_tl,wk2 )
  do j = js2g0, jlast
    do i = 1, im
      u_tm(i,j,k) = u_tm(i,j,k)+wk3_tl(i,j)
      u(i,j,k) = u(i,j,k)+wk3(i,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v_tm(i,j,k) = v_tm(i,j,k)+wk1_tl(i,j)
      v(i,j,k) = v(i,j,k)+wk1(i,j)
    end do
  end do
end do
#ifdef TIMING
call g_timing_off( 'D-6000' )
#endif

end subroutine cd_core_do_tl


subroutine cd_core_initialize_tl( im, jm, km, jfirst, jlast, ng_c, ng_d, ng_s, dt, ae, om, ptop, umax, sinp, cosp, cose, acosp )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use sw_core_tl
use tp_core
use tp_core_tl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: ae
real(kind=r8) :: cose(jm)
real(kind=r8) :: cosp(jm)
real(kind=r8) :: dt
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_c
integer :: ng_d
integer :: ng_s
real(kind=r8) :: om
real(kind=r8) :: ptop
real(kind=r8) :: sinp(jm)
real(kind=r8) :: umax

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: ak(km+1)
real(kind=r8) :: bk(km+1)
real(kind=r8) :: dl
real(kind=r8) :: dp
real(kind=r8) :: dt5
real(kind=r8) :: fac
integer :: j
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: js2g0
integer :: js2gc
integer :: k
integer :: ks
double precision :: pi
real(kind=r8) :: pint
real(kind=r8) :: press
real(kind=r8) :: ptmp
real(kind=r8) :: rat
real(kind=r8) :: tau
real(kind=r8) :: ycrit

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
call fftfax( im,ifax,trigs )
pi = 4.d0*datan(1.d0)
rat = float(im)/float(2*(jm-1))
ycrit = acos(min(0.81_8,rat))*(180./pi)
call pft_cf( im,jm,js2g0,jn2g0,jn1g1,sc,se,dc,de,cosp,cose,ycrit )
do j = max(1,jfirst-ng_s), min(jm,jlast+ng_d)
  f0(j) = (om+om)*sinp(j)
end do
do j = js2gc, jn1gc
  fc(j) = 0.5*(f0(j)+f0(j-1))
end do
dt5 = 0.5*dt
pi = 4.d0*datan(1.d0)
dl = (pi+pi)/im
dp = pi/(jm-1)
rdy = 1./(ae*dp)
dtdy = dt*rdy
dtdy5 = dt5*rdy
dydt = ae*dp/dt
tdy5 = 0.5/dtdy
do j = 2, jm-1
  dx(j) = dl*ae*cosp(j)
  rdx(j) = 1./dx(j)
  dtdx(j) = dt/dx(j)
  dxdt(j) = dx(j)/dt
  dtdx2(j) = 0.5*dtdx(j)
  dtdx4(j) = 0.5*dtdx2(j)
  dycp(j) = ae*dp/cosp(j)
  cyy(j) = rdy*acosp(j)
end do
do j = 2, jm
  dxe(j) = ae*dl*cose(j)
  rdxe(j) = 1./dxe(j)
  dtdxe(j) = dt/dxe(j)
  dtxe5(j) = 0.5*dtdxe(j)
  txe5(j) = 0.5/dtdxe(j)
  cye(j) = 1./(ae*cose(j)*dp)
  dyce(j) = ae*dp/cose(j)
end do
zt_c = abs(umax*dt5)/(dl*ae)
zt_d = abs(umax*dt)/(dl*ae)
call set_eta( km,ks,ptmp,pint,ak,bk )
if (ptop .ne. ptmp) then
  stop
endif
do k = 1, km
  press = 0.5*(ak(k)+ak(k+1)+(bk(k)+bk(k+1))*1.e+5)
  tau = 8.*(1.+tanh(1.*log(max(ptop,2._8)/press)))
  tau = max(1._8,tau)/(128.*max(abs(dt),225._8))
  do j = js2g0, jn1g1
    fac = tau*ae/cose(j)
    cdx(j,k) = fac*dp
    cdy(j,k) = fac*dl
  end do
end do

end subroutine cd_core_initialize_tl


end module     cd_core_tl


#endif /* SPMD */
