#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine trac2d_tad( dp1, q, q_tae, nq, cx, cy, mfx, mfy, iord, jord, ng, sine, cosp, acosp, acap, rcap, fill, im, jm, km, &
&jfirst, jlast, va, flx )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_tad
use fill_module
use fill_module_tad
use mod_comm, only : mp_barrier, mp_recv2_n, mp_recv2_n_ad, mp_recv3d_ns, mp_recv3d_ns_ad, mp_recv4d_ns, mp_recv4d_ns_ad, &
&mp_reduce_max, mp_send2_s, mp_send2_s_ad, mp_send3d_ns, mp_send3d_ns_ad, mp_send4d_ns, mp_send4d_ns_ad

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng
real(kind=r8) :: cx(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: cy(im,jfirst:jlast+1,km)
real(kind=r8) :: dp1(im,jfirst:jlast,km)
logical :: fill
real(kind=r8) :: flx(im,jfirst:jlast,km)
integer :: iord
integer :: jord
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
integer :: nq
real(kind=r8) :: q(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: rcap
real(kind=r8) :: sine(jm)
real(kind=r8) :: va(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a2(im,jfirst:jlast)
real(kind=r8) :: a2_tad(im,jfirst:jlast)
real(kind=r8) :: cmax
real(kind=r8) :: cxh_tad(im,1+jlast+ng-(jfirst-ng),km)
real(kind=r8) :: cxi_tad(im,1+jlast+ng-(jfirst-ng),km)
real(kind=r8) :: cxj_tad(im,1+jlast+ng-(jfirst-ng),km)
real(kind=r8) :: cxk_tad(im,1+jlast+ng-(jfirst-ng),km)
real(kind=r8) :: cy_global
real(kind=r8) :: cyh_tad(im,1+1+jlast-jfirst,km)
real(kind=r8) :: cyi_tad(im,1+1+jlast-jfirst,km)
real(kind=r8) :: cyj_tad(im,1+1+jlast-jfirst,km)
real(kind=r8) :: cyk_tad(im,1+1+jlast-jfirst,km)
real(kind=r8) :: cymax(km)
real(kind=r8) :: dp2(im,jfirst:jlast,km)
logical :: ffsl(jm,km)
real(kind=r8) :: frac
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_tad(im,1+jlast-jfirst)
real(kind=r8) :: fxi_tad(im,1+jlast-jfirst)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fyh_tad(im,1+1+jlast-jfirst)
real(kind=r8) :: fyi_tad(im,1+1+jlast-jfirst)
integer :: i
integer :: iq
integer :: it
integer :: j
integer :: jn1g1
integer :: jn2g0
integer :: jn2gd
integer :: js2g0
integer :: js2gd
integer :: k
real(kind=r8) :: mfyh_tad(im,1+1+jlast-jfirst,km)
real(kind=r8) :: mfyi_tad(im,1+1+jlast-jfirst,km)
real(kind=r8) :: mfyj_tad(im,1+1+jlast-jfirst,km)
real(kind=r8) :: mfyk_tad(im,1+1+jlast-jfirst,km)
integer :: nsplt
real(kind=r8) :: sum1
real(kind=r8) :: sum2
real(kind=r8) :: trac2d_tape_cx_1h(im,1+jlast+ng-(jfirst-ng),km,1)
real(kind=r8) :: trac2d_tape_cy_2h(im,1+1+jlast-jfirst,km,1)
real(kind=r8), allocatable :: trac2d_tape_cymax_4h(:,:)
real(kind=r8) :: trac2d_tape_flx_5h(im,1+jlast-jfirst,km,1)
real(kind=r8) :: trac2d_tape_mfy_3h(im,1+1+jlast-jfirst,km,1)
real(kind=r8) :: trac2d_tape_ns_dp1_1h(im,1+jlast-jfirst,km,5)
real(kind=r8) :: trac2d_tape_ns_q_2h(im,1+jlast+ng-(jfirst-ng),km,nq,5)
integer :: trac2d_tape_rec
integer :: trac2d_tape_trac2d

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a2_tad(:,:) = 0.d0
cxh_tad(:,:,:) = 0.d0
cxi_tad(:,:,:) = 0.d0
cxj_tad(:,:,:) = 0.d0
cxk_tad(:,:,:) = 0.d0
cyh_tad(:,:,:) = 0.d0
cyi_tad(:,:,:) = 0.d0
cyj_tad(:,:,:) = 0.d0
cyk_tad(:,:,:) = 0.d0
fxh_tad(:,:) = 0.d0
fxi_tad(:,:) = 0.d0
fyh_tad(:,:) = 0.d0
fyi_tad(:,:) = 0.d0
mfyh_tad(:,:,:) = 0.d0
mfyi_tad(:,:,:) = 0.d0
mfyj_tad(:,:,:) = 0.d0
mfyk_tad(:,:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
!----------------------------------------------
! OPEN TAPE trac2d_tape
!----------------------------------------------
trac2d_tape_trac2d = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
trac2d_tape_rec = 0
call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng,ng,cx,1 )
call mp_send2_s( im,jm,jfirst,jlast,1,km,0,1,cy,mfy )
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gd = max(2,jfirst-ng)
jn2gd = min(jm-1,jlast+ng)
#ifdef USE_OPENMP
!$omp parallel do private(cmax,i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  cymax(k) = 0.
  do j = js2g0, jlast
    cmax = 0.
    do i = 1, im
      cmax = max(abs(cy(i,j,k)),cmax)
    end do
    cymax(k) = max(cymax(k),cmax*(1.+sine(j)**16))
  end do
end do
call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng,ng,cx,1 )
call mp_recv2_n( im,jm,jfirst,jlast,1,km,0,1,cy,mfy )
call mp_reduce_max( km,cymax )
trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1) = cx
trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1) = cy
trac2d_tape_mfy_3h(:,:,:,trac2d_tape_rec+1) = mfy
if ( .not. allocated(trac2d_tape_cymax_4h)) then
  allocate( trac2d_tape_cymax_4h(1:km,trac2d_tape_trac2d) )
endif
trac2d_tape_cymax_4h(:,trac2d_tape_rec+1) = cymax
call mp_send4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
cy_global = cymax(1)
if (km .ne. 1) then
  do k = 2, km
    cy_global = max(cymax(k),cy_global)
  end do
endif
nsplt = int(1.+cy_global)
frac = 1./float(nsplt)
do k = 1, km
  if (nsplt .ne. 1) then
    do j = js2gd, jn2gd
      do i = 1, im
        cx(i,j,k) = cx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        mfx(i,j,k) = mfx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn1g1
      do i = 1, im
        cy(i,j,k) = cy(i,j,k)*frac
        mfy(i,j,k) = mfy(i,j,k)*frac
      end do
    end do
  endif
  do j = js2g0, jn2g0
    do i = 1, im
      if (cy(i,j,k)*cy(i,j+1,k) .gt. 0.) then
        if (cy(i,j,k) .gt. 0.) then
          va(i,j,k) = cy(i,j,k)
        else
          va(i,j,k) = cy(i,j+1,k)
        endif
      else
        va(i,j,k) = 0.
      endif
    end do
  end do
  do j = js2gd, jn2gd
    ffsl(j,k) =  .false. 
    do i = 1, im
      if (abs(cx(i,j,k)) .gt. 1.) then
        ffsl(j,k) =  .true. 
        exit
      endif
    end do
  end do
  do j = js2g0, jn2g0
    if (ffsl(j,k)) then
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)/sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))
      end do
    else
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)
      end do
    endif
  end do
end do
trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1) = flx
do it = 1, nsplt-1
  if (it .ne. 1) then
    call mp_send4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
  endif
  trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  call mp_recv4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
  trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q
#ifdef USE_OPENMP
  !$omp parallel do private(a2,fx,fy,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy( q(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp,acosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
    end do
    if (it .ne. nsplt) then
      do j = jfirst, jlast
        do i = 1, im
          dp1(i,j,k) = dp2(i,j,k)
        end do
      end do
    endif
  end do
end do
it = nsplt
if (it .ne. 1) then
  call mp_send4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
endif
trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
call mp_recv4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
flx = trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1)
do it = nsplt, 1, -1
  dp1 = trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
  !$omp parallel do shared(acap,acosp,cosp,cx,cy,dp1,dp2,ffsl,fill,flx,im,iord,it,jfirst,jlast,jm,jord,km,mfy,ng,nq,nsplt,q,q_tae,&
!$omp& rcap,va) private(a2,a2_tad,fx,fxi_tad,fy,fyi_tad,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    a2_tad(:,:) = 0.d0
#ifdef USE_OPENMP
    fxi_tad(:,:) = 0.d0
    fyi_tad(:,:) = 0.d0
#endif /* ! USE_OPENMP */
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      do j = jfirst, jlast
        do i = 1, im
          q_tae(i,j,k,iq) = q_tae(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
      if (fill) then
        call fillxy_tad( q(1,jfirst,k,iq),q_tae(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          a2_tad(i,j) = a2_tad(i,j)+q_tae(i,j,k,iq)
          q_tae(i,j,k,iq) = q_tae(i,j,k,iq)*dp1(i,j,k)
        end do
      end do
!     q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)  ! Todling: per Oloso's fix in full adm
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      call tp2c_tad( a2_tad,va(1,jfirst,k),q(1,jfirst-ng,k,iq),q_tae(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,&
&jord,ng,fx,fxi_tad,fyi_tad,ffsl(1,k),rcap,acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
    end do
  end do
  call mp_recv4d_ns_ad( im,jm,jfirst,jlast,1,km,nq,ng,ng,q_tae )
  if (it .ne. 1) then
    call mp_send4d_ns_ad( im,jm,jfirst,jlast,1,km,nq,ng,ng,q_tae )
  endif
end do
call mp_send4d_ns_ad( im,jm,jfirst,jlast,1,km,nq,ng,ng,q_tae )
call mp_recv2_n_ad( im,jm,jfirst,jlast,1,km,0,1,cyj_tad,mfyj_tad )
call mp_recv3d_ns_ad( im,jm,jfirst,jlast,1,km,ng,ng,cxj_tad,1 )
call mp_send2_s_ad( im,jm,jfirst,jlast,1,km,0,1,cyk_tad,mfyk_tad )
call mp_send3d_ns_ad( im,jm,jfirst,jlast,1,km,ng,ng,cxk_tad,1 )

!----------------------------------------------
! CLOSE TAPE trac2d_tape
!----------------------------------------------
if (allocated(trac2d_tape_cymax_4h)) then
  deallocate( trac2d_tape_cymax_4h )
endif


end subroutine trac2d_tad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine trac2d_tad( dp1, q, q_tae, nq, cx, cy, mfx, mfy, iord, jord, ng, sine, cosp, acosp, acap, rcap, fill, im, jm, km, &
&jfirst, jlast, va, flx )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_tad
use fill_module
use fill_module_tad

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng
real(kind=r8) :: cx(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: cy(im,jfirst:jlast+1,km)
real(kind=r8) :: dp1(im,jfirst:jlast,km)
logical :: fill
real(kind=r8) :: flx(im,jfirst:jlast,km)
integer :: iord
integer :: jord
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
integer :: nq
real(kind=r8) :: q(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: rcap
real(kind=r8) :: sine(jm)
real(kind=r8) :: va(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a2(im,jfirst:jlast)
real(kind=r8) :: a2_tad(im,jfirst:jlast)
real(kind=r8) :: cmax
real(kind=r8) :: cy_global
real(kind=r8) :: cymax(km)
real(kind=r8) :: dp2(im,jfirst:jlast,km)
logical :: ffsl(jm,km)
real(kind=r8) :: frac
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_tad(im,1+jlast-jfirst)
real(kind=r8) :: fxi_tad(im,1+jlast-jfirst)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fyh_tad(im,1+1+jlast-jfirst)
real(kind=r8) :: fyi_tad(im,1+1+jlast-jfirst)
integer :: i
integer :: iq
integer :: it
integer :: j
integer :: jn1g1
integer :: jn2g0
integer :: jn2gd
integer :: js2g0
integer :: js2gd
integer :: k
integer :: nsplt
real(kind=r8) :: sum1
real(kind=r8) :: sum2
real(kind=r8) :: trac2d_tape_cx_1h(im,1+jlast+ng-(jfirst-ng),km,1)
real(kind=r8) :: trac2d_tape_cy_2h(im,1+1+jlast-jfirst,km,1)
real(kind=r8), allocatable :: trac2d_tape_cymax_4h(:,:)
real(kind=r8) :: trac2d_tape_flx_5h(im,1+jlast-jfirst,km,1)
real(kind=r8) :: trac2d_tape_mfy_3h(im,1+1+jlast-jfirst,km,1)
real(kind=r8) :: trac2d_tape_ns_dp1_1h(im,1+jlast-jfirst,km,5)
real(kind=r8) :: trac2d_tape_ns_q_2h(im,1+jlast+ng-(jfirst-ng),km,nq,5)
integer :: trac2d_tape_rec
integer :: trac2d_tape_trac2d

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a2_tad(:,:) = 0.d0
fxh_tad(:,:) = 0.d0
fxi_tad(:,:) = 0.d0
fyh_tad(:,:) = 0.d0
fyi_tad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
!----------------------------------------------
! OPEN TAPE trac2d_tape
!----------------------------------------------
trac2d_tape_trac2d = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
trac2d_tape_rec = 0
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gd = max(2,jfirst-ng)
jn2gd = min(jm-1,jlast+ng)
#ifdef USE_OPENMP
!$omp parallel do private(cmax,i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  cymax(k) = 0.
  do j = js2g0, jlast
    cmax = 0.
    do i = 1, im
      cmax = max(abs(cy(i,j,k)),cmax)
    end do
    cymax(k) = max(cymax(k),cmax*(1.+sine(j)**16))
  end do
end do
trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1) = cx
trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1) = cy
trac2d_tape_mfy_3h(:,:,:,trac2d_tape_rec+1) = mfy
if ( .not. allocated(trac2d_tape_cymax_4h)) then
  allocate( trac2d_tape_cymax_4h(1:km,trac2d_tape_trac2d) )
endif
trac2d_tape_cymax_4h(:,trac2d_tape_rec+1) = cymax
cy_global = cymax(1)
if (km .ne. 1) then
  do k = 2, km
    cy_global = max(cymax(k),cy_global)
  end do
endif
nsplt = int(1.+cy_global)
frac = 1./float(nsplt)
do k = 1, km
  if (nsplt .ne. 1) then
    do j = js2gd, jn2gd
      do i = 1, im
        cx(i,j,k) = cx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        mfx(i,j,k) = mfx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn1g1
      do i = 1, im
        cy(i,j,k) = cy(i,j,k)*frac
        mfy(i,j,k) = mfy(i,j,k)*frac
      end do
    end do
  endif
  do j = js2g0, jn2g0
    do i = 1, im
      if (cy(i,j,k)*cy(i,j+1,k) .gt. 0.) then
        if (cy(i,j,k) .gt. 0.) then
          va(i,j,k) = cy(i,j,k)
        else
          va(i,j,k) = cy(i,j+1,k)
        endif
      else
        va(i,j,k) = 0.
      endif
    end do
  end do
  do j = js2gd, jn2gd
    ffsl(j,k) =  .false. 
    do i = 1, im
      if (abs(cx(i,j,k)) .gt. 1.) then
        ffsl(j,k) =  .true. 
        exit
      endif
    end do
  end do
  do j = js2g0, jn2g0
    if (ffsl(j,k)) then
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)/sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))
      end do
    else
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)
      end do
    endif
  end do
end do
trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1) = flx
do it = 1, nsplt-1
  trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q
#ifdef USE_OPENMP
  !$omp parallel do private(a2,fx,fy,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy( q(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp,acosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
    end do
    if (it .ne. nsplt) then
      do j = jfirst, jlast
        do i = 1, im
          dp1(i,j,k) = dp2(i,j,k)
        end do
      end do
    endif
  end do
end do
it = nsplt
trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
flx = trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1)
do it = nsplt, 1, -1
  dp1 = trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
  !$omp parallel do shared(acap,acosp,cosp,cx,cy,dp1,dp2,ffsl,fill,flx,im,iord,it,jfirst,jlast,jm,jord,km,mfy,ng,nq,nsplt,q,q_tae,&
!$omp& rcap,va) private(a2,a2_tad,fx,fxi_tad,fy,fyi_tad,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    a2_tad(:,:) = 0.d0
#ifdef USE_OPENMP
    fxi_tad(:,:) = 0.d0
    fyi_tad(:,:) = 0.d0
#endif /* ! USE_OPENMP */
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      do j = jfirst, jlast
        do i = 1, im
          q_tae(i,j,k,iq) = q_tae(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
      if (fill) then
        call fillxy_tad( q(1,jfirst,k,iq),q_tae(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          a2_tad(i,j) = a2_tad(i,j)+q_tae(i,j,k,iq)
          q_tae(i,j,k,iq) = q_tae(i,j,k,iq)*dp1(i,j,k)
        end do
      end do
!     q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)  ! Todling: per Oloso's fix in full adm
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      call tp2c_tad( a2_tad,va(1,jfirst,k),q(1,jfirst-ng,k,iq),q_tae(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,&
&jord,ng,fx,fxi_tad,fyi_tad,ffsl(1,k),rcap,acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
    end do
  end do
end do

!----------------------------------------------
! CLOSE TAPE trac2d_tape
!----------------------------------------------
if (allocated(trac2d_tape_cymax_4h)) then
  deallocate( trac2d_tape_cymax_4h )
endif


end subroutine trac2d_tad


#endif /* SPMD */
