#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tp_core_ttl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_ttl( im, c, mfx, p, p_ttl, dm, dm_ttl, fx, fx_ttl, iord, al, al_ttl, ar, ar_ttl, a6, a6_ttl, iuw, iue, ffsl, &
&isave )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ttl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_ttl(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_ttl(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ttl(im)
integer :: iord
integer :: isave(im)
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ttl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
logical :: steep

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al_ttl(i) = dm_ttl(i-1)*r3-dm_ttl(i)*r3+0.5*p_ttl(i-1)+0.5*p_ttl(i)
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx_ttl( im,p,p_ttl,al(1),al_ttl(1),dm,dm_ttl )
endif
do i = 1, im-1
  ar_ttl(i) = al_ttl(i+1)
  ar(i) = al(i+1)
end do
ar_ttl(im) = al_ttl(1)
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh_ttl( im,ar(1),ar_ttl(1),al(1),al_ttl(1),p(1),p_ttl(1),a6(1),a6_ttl(1),dm(1),dm_ttl(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6_ttl(i) = (-3)*al_ttl(i)-3*ar_ttl(i)+6*p_ttl(i)
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm_ttl( dm(1),dm_ttl(1),a6(1),a6_ttl(1),ar(1),ar_ttl(1),al(1),al_ttl(1),p(1),p_ttl(1),im,lmt )
endif
if (ffsl) then
  do i = iuw, 0
    al_ttl(i) = al_ttl(im+i)
    al(i) = al(im+i)
    ar_ttl(i) = ar_ttl(im+i)
    ar(i) = ar(im+i)
    a6_ttl(i) = a6_ttl(im+i)
    a6(i) = a6(im+i)
  end do
  do i = im+1, iue
    al_ttl(i) = al_ttl(i-im)
    al(i) = al(i-im)
    ar_ttl(i) = ar_ttl(i-im)
    ar(i) = ar(i-im)
    a6_ttl(i) = a6_ttl(i-im)
    a6(i) = a6(i-im)
  end do
  do i = 1, im
    iu = c(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      isave(i) = itmp+1
      fx_ttl(i) = 0.5*a6_ttl(itmp)*ru*ru*(1.-r23*ru)+0.5*al_ttl(itmp)*ru*ru+ar_ttl(itmp)*ru*(1+(-0.5)*ru)
      fx(i) = ru*(ar(itmp)+0.5*ru*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))
    else
      itmp = i-iu
      isave(i) = itmp-1
      fx_ttl(i) = (-(0.5*a6_ttl(itmp)*ru*ru*(1+r23*ru)))+al_ttl(itmp)*ru*(1-(-0.5)*ru)-0.5*ar_ttl(itmp)*ru*ru
      fx(i) = ru*(al(itmp)-0.5*ru*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))
    endif
  end do
else
  al_ttl(0) = al_ttl(im)
  al(0) = al(im)
  ar_ttl(0) = ar_ttl(im)
  ar(0) = ar(im)
  a6_ttl(0) = a6_ttl(im)
  a6(0) = a6(im)
  do i = 1, im
    if (c(i) .gt. 0.) then
      fx_ttl(i) = 0.5*a6_ttl(i-1)*c(i)*(1.-r23*c(i))+0.5*al_ttl(i-1)*c(i)+ar_ttl(i-1)*(1+(-0.5)*c(i))
      fx(i) = ar(i-1)+0.5*c(i)*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i)))
    else
      fx_ttl(i) = (-(0.5*a6_ttl(i)*c(i)*(1+r23*c(i))))+al_ttl(i)*(1-(-0.5)*c(i))-0.5*ar_ttl(i)*c(i)
      fx(i) = al(i)-0.5*c(i)*(ar(i)-al(i)+a6(i)*(1.+r23*c(i)))
    endif
    fx_ttl(i) = fx_ttl(i)*mfx(i)
    fx(i) = mfx(i)*fx(i)
  end do
endif

end subroutine fxppm_ttl


subroutine fyppm_ttl( c, q, q_ttm, dm, dm_ttl, flux, flux_ttl, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ttl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux(im,jfirst:jlast+1)
real(kind=r8) :: flux_ttl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_ttl(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_ttl(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_ttl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al_ttl(i,j) = dm_ttl(i,j-1)*r3-dm_ttl(i,j)*r3+0.5*q_ttm(i,j-1)+0.5*q_ttm(i,j)
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar_ttl(i,j) = al_ttl(i,j+1)
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ttl(i,1) = al_ttl(i+imh,2)
      al(i,1) = al(i+imh,2)
      al_ttl(i+imh,1) = al_ttl(i,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_ttl(i,jm) = ar_ttl(i+imh,jm1)
      ar(i,jm) = ar(i+imh,jm1)
      ar_ttl(i+imh,jm) = ar_ttl(i,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ttl(i,1) = -al_ttl(i+imh,2)
      al(i,1) = -al(i+imh,2)
      al_ttl(i+imh,1) = -al_ttl(i,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_ttl(i,jm) = -ar_ttl(i+imh,jm1)
      ar(i,jm) = -ar(i+imh,jm1)
      ar_ttl(i+imh,jm) = -ar_ttl(i,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6_ttl(i,j) = (-3)*al_ttl(i,j)-3*ar_ttl(i,j)+6*q_ttm(i,j)
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
call lmppm_ttl( dm(1,js1g1),dm_ttl(1,js1g1),a6(1,js1g1),a6_ttl(1,js1g1),ar(1,js1g1),ar_ttl(1,js1g1),al(1,js1g1),al_ttl(1,js1g1),&
&q(1,js1g1),q_ttm(1,js1g1),help_h,lmt )
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      flux_ttl(i,j) = 0.5*a6_ttl(i,j-1)*c(i,j)*(1.-r23*c(i,j))+0.5*al_ttl(i,j-1)*c(i,j)+ar_ttl(i,j-1)*(1+(-0.5)*c(i,j))
      flux(i,j) = ar(i,j-1)+0.5*c(i,j)*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j)))
    else
      flux_ttl(i,j) = (-(0.5*a6_ttl(i,j)*c(i,j)*(1+r23*c(i,j))))+al_ttl(i,j)*(1-(-0.5)*c(i,j))-0.5*ar_ttl(i,j)*c(i,j)
      flux(i,j) = al(i,j)-0.5*c(i,j)*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j)))
    endif
  end do
end do

end subroutine fyppm_ttl


subroutine huynh_ttl( im, ar, ar_ttl, al, al_ttl, p, p_ttl, d2, d2_ttl, d1, d1_ttl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_ttl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ttl(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_ttl(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_ttl(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_ttl(im)

!==============================================
! declare local variables
!==============================================
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_ttl
real(kind=r8) :: pmax
real(kind=r8) :: pmax_ttl
real(kind=r8) :: pmin
real(kind=r8) :: pmin_ttl
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
d1_ttl(1) = (-p_ttl(im))+p_ttl(1)
d1(1) = p(1)-p(im)
do i = 2, im
  d1_ttl(i) = (-p_ttl(i-1))+p_ttl(i)
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2_ttl(i) = d1_ttl(i+1)-d1_ttl(i)
  d2(i) = d1(i+1)-d1(i)
end do
d2_ttl(im) = (-d1_ttl(im))+d1_ttl(1)
d2(im) = d1(1)-d1(im)
pmp_ttl = 2*d1_ttl(1)+p_ttl(1)
pmp = p(1)+2.*d1(1)
lac_ttl = 0.5*d1_ttl(1)+1.5*d2_ttl(im)+p_ttl(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin_ttl = p_ttl(1)*(0.5+sign(0.5d0,pmp-p(1)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(1)))
pmin = min(p(1),pmp,lac)
pmax_ttl = p_ttl(1)*(0.5+sign(0.5d0,p(1)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(1)-pmp))
pmax = max(p(1),pmp,lac)
ar_ttl(1) = ar_ttl(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(ar(1),pmin)-&
&pmax))+pmin_ttl*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar(1) = min(pmax,max(ar(1),pmin))
do i = 2, im
  pmp_ttl = 2*d1_ttl(i)+p_ttl(i)
  pmp = p(i)+2.*d1(i)
  lac_ttl = 0.5*d1_ttl(i)+1.5*d2_ttl(i-1)+p_ttl(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin_ttl = p_ttl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_ttl = p_ttl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  ar_ttl(i) = ar_ttl(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(ar(i),&
&pmin)-pmax))+pmin_ttl*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar(i) = min(pmax,max(ar(i),pmin))
end do
do i = 1, im-1
  pmp_ttl = (-2)*d1_ttl(i+1)+p_ttl(i)
  pmp = p(i)-2.*d1(i+1)
  lac_ttl = (-0.5)*d1_ttl(i+1)+1.5*d2_ttl(i+1)+p_ttl(i)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin_ttl = p_ttl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_ttl = p_ttl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  al_ttl(i) = al_ttl(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(al(i),&
&pmin)-pmax))+pmin_ttl*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp_ttl = (-2)*d1_ttl(1)+p_ttl(im)
pmp = p(im)-2.*d1(1)
lac_ttl = (-0.5)*d1_ttl(1)+1.5*d2_ttl(1)+p_ttl(im)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin_ttl = p_ttl(im)*(0.5+sign(0.5d0,pmp-p(im)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(im)))
pmin = min(p(im),pmp,lac)
pmax_ttl = p_ttl(im)*(0.5+sign(0.5d0,p(im)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(im)-pmp))
pmax = max(p(im),pmp,lac)
al_ttl(im) = al_ttl(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(al(im),&
&pmin)-pmax))+pmin_ttl*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al(im) = min(pmax,max(al(im),pmin))
do i = 1, im
  d2_ttl(i) = (-3)*al_ttl(i)-3*ar_ttl(i)+6*p_ttl(i)
  d2(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
end do

end subroutine huynh_ttl


subroutine lmppm_ttl( dm, dm_ttl, a6, a6_ttl, ar, ar_ttl, al, al_ttl, p, p_ttl, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_ttl(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_ttl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ttl(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ttl(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_ttl(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ttl
real(kind=r8) :: da1
real(kind=r8) :: da1_ttl
real(kind=r8) :: da2
real(kind=r8) :: da2_ttl
real(kind=r8) :: dl
real(kind=r8) :: dl_ttl
real(kind=r8) :: dr
real(kind=r8) :: dr_ttl
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ttl
integer :: i

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    if (dm(i) .eq. 0.) then
      ar_ttl(i) = p_ttl(i)
      ar(i) = p(i)
      al_ttl(i) = p_ttl(i)
      al(i) = p(i)
      a6_ttl(i) = 0.d0
      a6(i) = 0.
    else
      da1_ttl = (-al_ttl(i))+ar_ttl(i)
      da1 = ar(i)-al(i)
      da2_ttl = 2*da1_ttl*da1
      da2 = da1**2
      a6da_ttl = a6_ttl(i)*da1+da1_ttl*a6(i)
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_ttl(i) = 3*al_ttl(i)-3*p_ttl(i)
        a6(i) = 3.*(al(i)-p(i))
        ar_ttl(i) = (-a6_ttl(i))+al_ttl(i)
        ar(i) = al(i)-a6(i)
      else if (a6da .gt. da2) then
        a6_ttl(i) = 3*ar_ttl(i)-3*p_ttl(i)
        a6(i) = 3.*(ar(i)-p(i))
        al_ttl(i) = (-a6_ttl(i))+ar_ttl(i)
        al(i) = ar(i)-a6(i)
      endif
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_ttl = 2*dm_ttl(i)
      da1 = dm(i)+dm(i)
      dl_ttl = (al_ttl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_ttl*(0.5+sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_ttl(i)*(0.5-sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
      dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
      dr_ttl = (ar_ttl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_ttl*(0.5+sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_ttl(i)*(0.5-sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
      dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
      ar_ttl(i) = dr_ttl+p_ttl(i)
      ar(i) = p(i)+dr
      al_ttl(i) = (-dl_ttl)+p_ttl(i)
      al(i) = p(i)-dl
      a6_ttl(i) = 3*dl_ttl-3*dr_ttl
      a6(i) = 3.*(dl-dr)
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin_ttl = a6_ttl(i)*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)+al_ttl(i)*((-0.5)*(ar(i)-al(i))/a6(i))+ar_ttl(i)*&
&(0.5*(ar(i)-al(i))/a6(i))+p_ttl(i)
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar_ttl(i) = p_ttl(i)
              ar(i) = p(i)
              al_ttl(i) = p_ttl(i)
              al(i) = p(i)
              a6_ttl(i) = 0.d0
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6_ttl(i) = 3*al_ttl(i)-3*p_ttl(i)
              a6(i) = 3.*(al(i)-p(i))
              ar_ttl(i) = (-a6_ttl(i))+al_ttl(i)
              ar(i) = al(i)-a6(i)
            else
              a6_ttl(i) = 3*ar_ttl(i)-3*p_ttl(i)
              a6(i) = 3.*(ar(i)-p(i))
              al_ttl(i) = (-a6_ttl(i))+ar_ttl(i)
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_ttl = 4*dm_ttl(i)
          da1 = 4.*dm(i)
          dl_ttl = (al_ttl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_ttl*(0.5+&
&sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_ttl(i)*&
&(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
          dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
          dr_ttl = (ar_ttl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_ttl*(0.5+&
&sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_ttl(i)*&
&(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
          dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
          ar_ttl(i) = dr_ttl+p_ttl(i)
          ar(i) = p(i)+dr
          al_ttl(i) = (-dl_ttl)+p_ttl(i)
          al(i) = p(i)-dl
          a6_ttl(i) = 3*dl_ttl-3*dr_ttl
          a6(i) = 3.*(dl-dr)
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_ttl


subroutine steepx_ttl( im, p, p_ttl, al, al_ttl, dm, dm_ttl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_ttl(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ttl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb
real(kind=r8) :: bbb_ttl
real(kind=r8) :: ccc
real(kind=r8) :: ccc_ttl
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_ttl(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_ttl(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_ttl(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do i = 0, im
  dh_ttl(i) = p_ttl(i+1)-p_ttl(i)
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2_ttl(i) = (-dh_ttl(i-1))+dh_ttl(i)
  d2(i) = dh(i)-dh(i-1)
end do
d2_ttl(0) = d2_ttl(im)
d2(0) = d2(im)
d2_ttl(im+1) = d2_ttl(1)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx_ttl = (-(p_ttl(i-2)*((-0.5)/(p(i+1)-p(i-1)))))+p_ttl(i-1)*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))-&
&p_ttl(i+2)*(0.5/(p(i+1)-p(i-1)))+p_ttl(i+1)*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta_ttl(i) = xxx_ttl*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta_ttl(i) = 0.d0
    eta(i) = 0.
  endif
end do
eta_ttl(0) = eta_ttl(im)
eta(0) = eta(im)
do i = 1, im
  bbb_ttl = dm_ttl(i-1)*(2.*eta(i)-eta(i-1))-eta_ttl(i-1)*dm(i-1)+2*eta_ttl(i)*dm(i-1)
  bbb = (2.*eta(i)-eta(i-1))*dm(i-1)
  ccc_ttl = dm_ttl(i)*(2.*eta(i-1)-eta(i))+2*eta_ttl(i-1)*dm(i)-eta_ttl(i)*dm(i)
  ccc = (2.*eta(i-1)-eta(i))*dm(i)
  al_ttl(i) = al_ttl(i)+bbb_ttl*r3-ccc_ttl*r3+0.5*dh_ttl(i-1)*(eta(i-1)-eta(i))+0.5*eta_ttl(i-1)*dh(i-1)-0.5*eta_ttl(i)*dh(i-1)
  al(i) = al(i)+0.5*(eta(i-1)-eta(i))*dh(i-1)+(bbb-ccc)*r3
end do

end subroutine steepx_ttl


subroutine tp2c_ttl( dh, dh_ttl, va, h, h_ttl, crx, cry, im, jm, iord, jord, ng, fx, fx_ttl, fy, fy_ttl, ffsl, rcap, acosp, xfx, &
&yfx, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: dh(im,jfirst:jlast)
real(kind=r8) :: dh_ttl(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ttl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ttl(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_ttl(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1
real(kind=r8) :: sum1_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call tp2d_ttl( va,h,h_ttl,crx,cry,im,jm,iord,jord,ng,fx,fx_ttl,fy,fy_ttl,ffsl,xfx,yfx,cosp,id,jfirst,jlast )
do j = js2g0, jn2g0
  do i = 1, im-1
    dh_ttl(i,j) = (-fx_ttl(i+1,j))+fx_ttl(i,j)-fy_ttl(i,j+1)*acosp(j)+fy_ttl(i,j)*acosp(j)
    dh(i,j) = fx(i,j)-fx(i+1,j)+(fy(i,j)-fy(i,j+1))*acosp(j)
  end do
end do
do j = js2g0, jn2g0
  dh_ttl(im,j) = fx_ttl(im,j)-fx_ttl(1,j)-fy_ttl(im,j+1)*acosp(j)+fy_ttl(im,j)*acosp(j)
  dh(im,j) = fx(im,j)-fx(1,j)+(fy(im,j)-fy(im,j+1))*acosp(j)
end do
if (jfirst .eq. 1) then
  sum1_ttl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_ttl = fy_ttl(i,2)+sum1_ttl
    sum1 = sum1+fy(i,2)
  end do
  sum1_ttl = -(sum1_ttl*rcap)
  sum1 = -(sum1*rcap)
  do i = 1, im
    dh_ttl(i,1) = sum1_ttl
    dh(i,1) = sum1
  end do
endif
if (jlast .eq. jm) then
  sum1_ttl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_ttl = fy_ttl(i,jm)+sum1_ttl
    sum1 = sum1+fy(i,jm)
  end do
  sum1_ttl = sum1_ttl*rcap
  sum1 = sum1*rcap
  do i = 1, im
    dh_ttl(i,jm) = sum1_ttl
    dh(i,jm) = sum1
  end do
endif

end subroutine tp2c_ttl


subroutine tp2d_ttl( va, q, q_ttm, crx, cry, im, jm, iord, jord, ng, fx, fx_ttl, fy, fy_ttl, ffsl, xfx, yfx, cosp, id, jfirst, &
&jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ttl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ttl(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ttl(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_ttl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_ttl(1+im+2*(im/3))
real(kind=r8) :: dmk_ttl(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_ttl(1+im+2*(im/3))
real(kind=r8) :: qtmpk_ttl(1+im+2*(im/3))
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_ttl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
do j = js2gng, jn2gng
  call xtp_ttl( im,ffsl(j),wk1,wk1_ttl,q(1,j),q_ttm(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,dmk_ttl,qtmp,qtmpk_ttl,al,ar,a6,a6_ttl )
  do i = 1, im-1
    adx_ttl(i,j) = q_ttm(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))-0.5*wk1_ttl(i+1)+0.5*wk1_ttl(i)
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx_ttl(im,j) = q_ttm(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))+0.5*wk1_ttl(im)-0.5*wk1_ttl(1)
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx_ttl(i,1) = q_ttm(i,1)
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx_ttl(i,jm) = q_ttm(i,jm)
    adx(i,jm) = q(i,jm)
  end do
endif
call ytp_ttl( im,jm,fy,fy_ttl,adx,adx_ttl,cry,yfx,ng,jord,0,jfirst,jlast )
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    wk1_ttl(i) = (-0.5)*q_ttm(i,jp+1)*va(i,j)+q_ttm(i,j)+0.5*q_ttm(i,jp)*va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_ttl( im,ffsl(j),fx(1,j),fx_ttl(1,j),wk1,wk1_ttl,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,dmh_ttl,qtmp,qtmph_ttl,al,ar,a6,&
&a6_ttl )
end do

end subroutine tp2d_ttl


subroutine tpcc_ttl( va, ymass, q, crx, cry, im, jm, ng, iord, jord, fx, fy, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6j_ttl(-(im/3):im+im/3)
real(kind=r8) :: a6m_ttl(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adxj_ttl(im,jfirst-1:jlast+2)
real(kind=r8) :: dmj_ttl(-(im/3):im+im/3)
real(kind=r8) :: dmm_ttl(-(im/3):im+im/3)
real(kind=r8) :: fx1(im)
real(kind=r8) :: fxj_ttl(im,jfirst:jlast)
integer :: i
integer :: im2
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qj_ttl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmpj_ttl(-(im/3):im+im/3)
real(kind=r8) :: qtmpm_ttl(-(im/3):im+im/3)
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1j_ttl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  qj_ttl(:,:) = 0.d0
  a6m_ttl(:) = 0.d0
  call xtp_ttl( im,ffsl(j),wk1,wk1j_ttl,q(1,j),qj_ttl,crx(1,j),1,crx(1,j),cose(j),0,dm,dmm_ttl,qtmp,qtmpm_ttl,al,ar,a6,a6m_ttl )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc( im,jm,fy,adx,cry,ymass,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  adxj_ttl(:,:) = 0.d0
  a6j_ttl(:) = 0.d0
  call xtp_ttl( im,ffsl(j),fx(1,j),fxj_ttl,adx(1,j),adxj_ttl,crx(1,j),iord,crx(1,j),cose(j),0,dm,dmj_ttl,qtmp,qtmpj_ttl,al,ar,a6,&
&a6j_ttl )
end do

end subroutine tpcc_ttl


subroutine xmist_ttl( im, q, q_ttm, dm, dm_ttl, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_ttm(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmi
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxh
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminh

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm_ttl(i) = q_ttm(i-2)*r24-8*q_ttm(i-1)*r24-q_ttm(i+2)*r24+8*q_ttm(i+1)*r24
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm_ttl(i) = (-0.25)*q_ttm(i-1)+0.25*q_ttm(i+1)
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmaxh = max(q(i-1),q(i))
    qmax_ttl = (-q_ttm(i))+q_ttm(i+1)*(0.5-sign(0.5d0,qmaxh-q(i+1)))+(q_ttm(i-1)*(0.5+sign(0.5d0,q(i-1)-q(i)))+q_ttm(i)*(0.5-&
&sign(0.5d0,q(i-1)-q(i))))*(0.5+sign(0.5d0,qmaxh-q(i+1)))
    qmax = max(qmaxh,q(i+1))-q(i)
    qminh = min(q(i-1),q(i))
    qmin_ttl = q_ttm(i)-(q_ttm(i+1)*(0.5-sign(0.5d0,q(i+1)-qminh))+(q_ttm(i-1)*(0.5+sign(0.5d0,q(i)-q(i-1)))+q_ttm(i)*(0.5-&
&sign(0.5d0,q(i)-q(i-1))))*(0.5+sign(0.5d0,q(i+1)-qminh)))
    qmin = q(i)-min(qminh,q(i+1))
    dmh = min(abs(dm(i)),qmax)
    dmi = min(dmh,qmin)
    dm_ttl(i) = ((dm_ttl(i)*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))+qmax_ttl*(0.5-sign(0.5d0,qmax-abs(dm(i)))))*(0.5+&
&sign(0.5d0,qmin-dmh))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmh)))*sign(1.d0,dmi)*sign(1.d0,dm(i))
    dm(i) = sign(dmi,dm(i))
  end do
endif

end subroutine xmist_ttl


subroutine xtp_ttl( im, ffsl, fx, fx_ttl, q, q_ttm, c, iord, mfx, cosa, id, dm, dm_ttl, qtmp, qtmp_ttl, al, ar, a6, a6_ttl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ttl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ttl(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_ttm(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_ttl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh_ttl(-(im/3):im+im/3)
real(kind=r8) :: ali_ttl(-(im/3):im+im/3)
real(kind=r8) :: arh_ttl(-(im/3):im+im/3)
real(kind=r8) :: ari_ttl(-(im/3):im+im/3)
double precision :: dmh
double precision :: dmi
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxh
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminh
real(kind=r8) :: rut
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp_ttl(i) = q_ttm(i)
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp_ttl(i) = q_ttm(im+i)
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp_ttl(i) = q_ttm(i-im)
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
      fx_ttl(i) = qtmp_ttl(itmp)*(c(i)-iu)
      fx(i) = (c(i)-iu)*qtmp(itmp)
    end do
  else
    do i = 1, im
      tmp_ttl = (-0.25)*qtmp_ttl(i-1)+0.25*qtmp_ttl(i+1)
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmaxh = max(qtmp(i-1),qtmp(i))
      qmax_ttl = (qtmp_ttl(i-1)*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))+qtmp_ttl(i)*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i))))*(0.5+&
&sign(0.5d0,qmaxh-qtmp(i+1)))+qtmp_ttl(i+1)*(0.5-sign(0.5d0,qmaxh-qtmp(i+1)))-qtmp_ttl(i)
      qmax = max(qmaxh,qtmp(i+1))-qtmp(i)
      qminh = min(qtmp(i-1),qtmp(i))
      qmin_ttl = (-((qtmp_ttl(i-1)*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))+qtmp_ttl(i)*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1))))*(0.5+&
&sign(0.5d0,qtmp(i+1)-qminh))+qtmp_ttl(i+1)*(0.5-sign(0.5d0,qtmp(i+1)-qminh))))+qtmp_ttl(i)
      qmin = qtmp(i)-min(qminh,qtmp(i+1))
      dmh = min(abs(tmp),qmax)
      dmi = min(dmh,qmin)
      dm_ttl(i) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmh))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmh)))*sign(1.d0,dmi)*sign(1.d0,tmp)
      dm(i) = sign(dmi,tmp)
    end do
    do i = iuw, 0
      dm_ttl(i) = dm_ttl(im+i)
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm_ttl(i) = dm_ttl(i-im)
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_ttl( im,c,mfx,qtmp,qtmp_ttl,dm,dm_ttl,fx,fx_ttl,iord,al,ali_ttl,ar,ari_ttl,a6,a6_ttl,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
          fx_ttl(i) = (-(dm_ttl(itmp)*rut*(1+rut)))+qtmp_ttl(itmp)*rut
          fx(i) = rut*(qtmp(itmp)-dm(itmp)*(1.+rut))
        else
          itmp = i-iu-1
          isave(i) = itmp+1
          fx_ttl(i) = dm_ttl(itmp)*rut*(1.-rut)+qtmp_ttl(itmp)*rut
          fx(i) = rut*(qtmp(itmp)+dm(itmp)*(1.-rut))
        endif
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        fx_ttl(i) = fx_ttl(i)+qtmp_ttl(ist)
        fx(i) = fx(i)+qtmp(ist)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        fx_ttl(i) = fx_ttl(i)-qtmp_ttl(ist)
        fx(i) = fx(i)-qtmp(ist)
      end do
    endif
  end do
  if (id .ne. 0) then
    do i = 1, im
      fx_ttl(i) = fx_ttl(i)*mfx(i)
      fx(i) = fx(i)*mfx(i)
    end do
  endif
else
  qtmp_ttl(imp) = q_ttm(1)
  qtmp(imp) = q(1)
  qtmp_ttl(0) = q_ttm(im)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = float(i)-c(i)
      fx_ttl(i) = qtmp_ttl(iu)*mfx(i)
      fx(i) = mfx(i)*qtmp(iu)
    end do
  else
    qtmp_ttl(-1) = q_ttm(im-1)
    qtmp(-1) = q(im-1)
    qtmp_ttl(imp+1) = q_ttm(2)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_ttl( im,qtmp,qtmp_ttl,dm,dm_ttl,2 )
    else
      call xmist_ttl( im,qtmp,qtmp_ttl,dm,dm_ttl,iord )
    endif
    dm_ttl(0) = dm_ttl(im)
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      do i = 1, im
        iu = float(i)-c(i)
        fx_ttl(i) = dm_ttl(iu)*mfx(i)*(sign(1.d0,c(i))-c(i))+qtmp_ttl(iu)*mfx(i)
        fx(i) = mfx(i)*(qtmp(iu)+dm(iu)*(sign(1._8,c(i))-c(i)))
      end do
    else
      call fxppm_ttl( im,c,mfx,qtmp,qtmp_ttl,dm,dm_ttl,fx,fx_ttl,iord,al,alh_ttl,ar,arh_ttl,a6,a6_ttl,iuw,iue,ffsl,isave )
    endif
  endif
endif

end subroutine xtp_ttl


subroutine ymist_ttl( im, jm, q, q_ttm, dm, dm_ttl, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ttl(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dml
double precision :: dmm
double precision :: dmn
double precision :: dmo
double precision :: dmp
double precision :: dmq
double precision :: dmr
double precision :: dms
double precision :: dmt
double precision :: dmu
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxj
double precision :: qmaxk
double precision :: qmaxl
double precision :: qmaxm
double precision :: qmaxn
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminj
double precision :: qmink
double precision :: qminl
double precision :: qminm
double precision :: qminn
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm_ttl(i,j) = (-0.25)*q_ttm(i,j-1)+0.25*q_ttm(i,j+1)
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_ttl = (-0.25)*q_ttm(i+im2,2)+0.25*q_ttm(i,2)
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmaxn = max(q(i,2),q(i,1))
      qmax_ttl = (-q_ttm(i,1))+q_ttm(i+im2,2)*(0.5-sign(0.5d0,qmaxn-q(i+im2,2)))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+&
&q_ttm(i,1)*(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxn-q(i+im2,2)))
      qmax = max(qmaxn,q(i+im2,2))-q(i,1)
      qminn = min(q(i,2),q(i,1))
      qmin_ttl = q_ttm(i,1)-(q_ttm(i+im2,2)*(0.5-sign(0.5d0,q(i+im2,2)-qminn))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+q_ttm(i,&
&1)*(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,q(i+im2,2)-qminn)))
      qmin = q(i,1)-min(qminn,q(i+im2,2))
      dmt = min(abs(tmp),qmax)
      dmu = min(dmt,qmin)
      dm_ttl(i,1) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmt))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmt)))*sign(1.d0,dmu)*sign(1.d0,tmp)
      dm(i,1) = sign(dmu,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,1) = -dm_ttl(i-im2,1)
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_ttl = 0.25*q_ttm(i+im2,jm1)-0.25*q_ttm(i,jm1)
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmaxm = max(q(i+im2,jm1),q(i,jm))
      qmax_ttl = (-q_ttm(i,jm))+q_ttm(i,jm1)*(0.5-sign(0.5d0,qmaxm-q(i,jm1)))+(q_ttm(i,jm)*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))+&
&q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm))))*(0.5+sign(0.5d0,qmaxm-q(i,jm1)))
      qmax = max(qmaxm,q(i,jm1))-q(i,jm)
      qminm = min(q(i+im2,jm1),q(i,jm))
      qmin_ttl = q_ttm(i,jm)-(q_ttm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qminm))+(q_ttm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))+&
&q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1))))*(0.5+sign(0.5d0,q(i,jm1)-qminm)))
      qmin = q(i,jm)-min(qminm,q(i,jm1))
      dmr = min(abs(tmp),qmax)
      dms = min(dmr,qmin)
      dm_ttl(i,jm) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmr))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmr)))*sign(1.d0,dms)*sign(1.d0,tmp)
      dm(i,jm) = sign(dms,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,jm) = -dm_ttl(i-im2,jm)
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_ttl = 0.25*q_ttm(i+im2,2)+0.25*q_ttm(i,2)
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmaxl = max(q(i,2),q(i,1))
      qmax_ttl = (-q_ttm(i,1))-q_ttm(i+im2,2)*(0.5-sign(0.5d0,qmaxl-(-q(i+im2,2))))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+&
&q_ttm(i,1)*(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxl-(-q(i+im2,2))))
      qmax = max(qmaxl,-q(i+im2,2))-q(i,1)
      qminl = min(q(i,2),q(i,1))
      qmin_ttl = q_ttm(i,1)-((-(q_ttm(i+im2,2)*(0.5-sign(0.5d0,(-q(i+im2,2))-qminl))))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+&
&q_ttm(i,1)*(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,(-q(i+im2,2))-qminl)))
      qmin = q(i,1)-min(qminl,-q(i+im2,2))
      dmp = min(abs(tmp),qmax)
      dmq = min(dmp,qmin)
      dm_ttl(i,1) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmp))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmp)))*sign(1.d0,dmq)*sign(1.d0,tmp)
      dm(i,1) = sign(dmq,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,1) = dm_ttl(i-im2,1)
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_ttl = (-0.25)*q_ttm(i+im2,jm1)-0.25*q_ttm(i,jm1)
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmaxk = max(-q(i+im2,jm1),q(i,jm))
      qmax_ttl = (-q_ttm(i,jm))+q_ttm(i,jm1)*(0.5-sign(0.5d0,qmaxk-q(i,jm1)))+(q_ttm(i,jm)*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm))&
&)-q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm))))*(0.5+sign(0.5d0,qmaxk-q(i,jm1)))
      qmax = max(qmaxk,q(i,jm1))-q(i,jm)
      qmink = min(-q(i+im2,jm1),q(i,jm))
      qmin_ttl = q_ttm(i,jm)-(q_ttm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qmink))+(q_ttm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))-&
&q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1)))))*(0.5+sign(0.5d0,q(i,jm1)-qmink)))
      qmin = q(i,jm)-min(qmink,q(i,jm1))
      dmn = min(abs(tmp),qmax)
      dmo = min(dmn,qmin)
      dm_ttl(i,jm) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmn))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmn)))*sign(1.d0,dmo)*sign(1.d0,tmp)
      dm(i,jm) = sign(dmo,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,jm) = dm_ttl(i-im2,jm)
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    do i = 1, im
      qmaxj = max(q(i,j-1),q(i,j))
      qmax_ttl = (-q_ttm(i,j))+q_ttm(i,j+1)*(0.5-sign(0.5d0,qmaxj-q(i,j+1)))+(q_ttm(i,j-1)*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))+&
&q_ttm(i,j)*(0.5-sign(0.5d0,q(i,j-1)-q(i,j))))*(0.5+sign(0.5d0,qmaxj-q(i,j+1)))
      qmax = max(qmaxj,q(i,j+1))-q(i,j)
      qminj = min(q(i,j-1),q(i,j))
      qmin_ttl = q_ttm(i,j)-(q_ttm(i,j+1)*(0.5-sign(0.5d0,q(i,j+1)-qminj))+(q_ttm(i,j-1)*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))+q_ttm(i,&
&j)*(0.5-sign(0.5d0,q(i,j)-q(i,j-1))))*(0.5+sign(0.5d0,q(i,j+1)-qminj)))
      qmin = q(i,j)-min(qminj,q(i,j+1))
      dml = min(abs(dm(i,j)),qmin)
      dmm = min(dml,qmax)
      dm_ttl(i,j) = ((dm_ttl(i,j)*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))+qmin_ttl*(0.5-sign(0.5d0,qmin-abs(dm(i,j))&
&)))*(0.5+sign(0.5d0,qmax-dml))+qmax_ttl*(0.5-sign(0.5d0,qmax-dml)))*sign(1.d0,dmm)*sign(1.d0,dm(i,j))
      dm(i,j) = sign(dmm,dm(i,j))
    end do
  end do
endif

end subroutine ymist_ttl


subroutine ytp_ttl( im, jm, fy, fy_ttl, q, q_ttm, c, yfx, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ttl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ttl(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      fy_ttl(i,j) = q_ttm(i,jt)
      fy(i,j) = q(i,jt)
    end do
  end do
else
  call ymist_ttl( im,jm,q,q_ttm,dm,dm_ttl,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm_ttl( c,q,q_ttm,dm,dm_ttl,fy,fy_ttl,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        fy_ttl(i,j) = dm_ttl(i,jt)*(sign(1.d0,c(i,j))-c(i,j))+q_ttm(i,jt)
        fy(i,j) = q(i,jt)+(sign(1._8,c(i,j))-c(i,j))*dm(i,jt)
      end do
    end do
  endif
endif
do j = js2g0, jn1g1
  do i = 1, im
    fy_ttl(i,j) = fy_ttl(i,j)*yfx(i,j)
    fy(i,j) = fy(i,j)*yfx(i,j)
  end do
end do

end subroutine ytp_ttl


end module     tp_core_ttl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tp_core_ttl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_ttl( im, c, mfx, p, p_ttl, dm, dm_ttl, fx, fx_ttl, iord, al, al_ttl, ar, ar_ttl, a6, a6_ttl, iuw, iue, ffsl, &
&isave )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ttl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_ttl(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_ttl(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ttl(im)
integer :: iord
integer :: isave(im)
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ttl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
logical :: steep

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al_ttl(i) = dm_ttl(i-1)*r3-dm_ttl(i)*r3+0.5*p_ttl(i-1)+0.5*p_ttl(i)
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx_ttl( im,p,p_ttl,al(1),al_ttl(1),dm,dm_ttl )
endif
do i = 1, im-1
  ar_ttl(i) = al_ttl(i+1)
  ar(i) = al(i+1)
end do
ar_ttl(im) = al_ttl(1)
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh_ttl( im,ar(1),ar_ttl(1),al(1),al_ttl(1),p(1),p_ttl(1),a6(1),a6_ttl(1),dm(1),dm_ttl(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6_ttl(i) = (-3)*al_ttl(i)-3*ar_ttl(i)+6*p_ttl(i)
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm_ttl( dm(1),dm_ttl(1),a6(1),a6_ttl(1),ar(1),ar_ttl(1),al(1),al_ttl(1),p(1),p_ttl(1),im,lmt )
endif
if (ffsl) then
  do i = iuw, 0
    al_ttl(i) = al_ttl(im+i)
    al(i) = al(im+i)
    ar_ttl(i) = ar_ttl(im+i)
    ar(i) = ar(im+i)
    a6_ttl(i) = a6_ttl(im+i)
    a6(i) = a6(im+i)
  end do
  do i = im+1, iue
    al_ttl(i) = al_ttl(i-im)
    al(i) = al(i-im)
    ar_ttl(i) = ar_ttl(i-im)
    ar(i) = ar(i-im)
    a6_ttl(i) = a6_ttl(i-im)
    a6(i) = a6(i-im)
  end do
  do i = 1, im
    iu = c(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      isave(i) = itmp+1
      fx_ttl(i) = 0.5*a6_ttl(itmp)*ru*ru*(1.-r23*ru)+0.5*al_ttl(itmp)*ru*ru+ar_ttl(itmp)*ru*(1+(-0.5)*ru)
      fx(i) = ru*(ar(itmp)+0.5*ru*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))
    else
      itmp = i-iu
      isave(i) = itmp-1
      fx_ttl(i) = (-(0.5*a6_ttl(itmp)*ru*ru*(1+r23*ru)))+al_ttl(itmp)*ru*(1-(-0.5)*ru)-0.5*ar_ttl(itmp)*ru*ru
      fx(i) = ru*(al(itmp)-0.5*ru*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))
    endif
  end do
else
  al_ttl(0) = al_ttl(im)
  al(0) = al(im)
  ar_ttl(0) = ar_ttl(im)
  ar(0) = ar(im)
  a6_ttl(0) = a6_ttl(im)
  a6(0) = a6(im)
  do i = 1, im
    if (c(i) .gt. 0.) then
      fx_ttl(i) = 0.5*a6_ttl(i-1)*c(i)*(1.-r23*c(i))+0.5*al_ttl(i-1)*c(i)+ar_ttl(i-1)*(1+(-0.5)*c(i))
      fx(i) = ar(i-1)+0.5*c(i)*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i)))
    else
      fx_ttl(i) = (-(0.5*a6_ttl(i)*c(i)*(1+r23*c(i))))+al_ttl(i)*(1-(-0.5)*c(i))-0.5*ar_ttl(i)*c(i)
      fx(i) = al(i)-0.5*c(i)*(ar(i)-al(i)+a6(i)*(1.+r23*c(i)))
    endif
    fx_ttl(i) = fx_ttl(i)*mfx(i)
    fx(i) = mfx(i)*fx(i)
  end do
endif

end subroutine fxppm_ttl


subroutine fyppm_ttl( c, q, q_ttm, dm, dm_ttl, flux, flux_ttl, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ttl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux(im,jfirst:jlast+1)
real(kind=r8) :: flux_ttl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_ttl(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_ttl(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_ttl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al_ttl(i,j) = dm_ttl(i,j-1)*r3-dm_ttl(i,j)*r3+0.5*q_ttm(i,j-1)+0.5*q_ttm(i,j)
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar_ttl(i,j) = al_ttl(i,j+1)
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ttl(i,1) = al_ttl(i+imh,2)
      al(i,1) = al(i+imh,2)
      al_ttl(i+imh,1) = al_ttl(i,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_ttl(i,jm) = ar_ttl(i+imh,jm1)
      ar(i,jm) = ar(i+imh,jm1)
      ar_ttl(i+imh,jm) = ar_ttl(i,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ttl(i,1) = -al_ttl(i+imh,2)
      al(i,1) = -al(i+imh,2)
      al_ttl(i+imh,1) = -al_ttl(i,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar_ttl(i,jm) = -ar_ttl(i+imh,jm1)
      ar(i,jm) = -ar(i+imh,jm1)
      ar_ttl(i+imh,jm) = -ar_ttl(i,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6_ttl(i,j) = (-3)*al_ttl(i,j)-3*ar_ttl(i,j)+6*q_ttm(i,j)
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
call lmppm_ttl( dm(1,js1g1),dm_ttl(1,js1g1),a6(1,js1g1),a6_ttl(1,js1g1),ar(1,js1g1),ar_ttl(1,js1g1),al(1,js1g1),al_ttl(1,js1g1),&
&q(1,js1g1),q_ttm(1,js1g1),help_h,lmt )
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      flux_ttl(i,j) = 0.5*a6_ttl(i,j-1)*c(i,j)*(1.-r23*c(i,j))+0.5*al_ttl(i,j-1)*c(i,j)+ar_ttl(i,j-1)*(1+(-0.5)*c(i,j))
      flux(i,j) = ar(i,j-1)+0.5*c(i,j)*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j)))
    else
      flux_ttl(i,j) = (-(0.5*a6_ttl(i,j)*c(i,j)*(1+r23*c(i,j))))+al_ttl(i,j)*(1-(-0.5)*c(i,j))-0.5*ar_ttl(i,j)*c(i,j)
      flux(i,j) = al(i,j)-0.5*c(i,j)*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j)))
    endif
  end do
end do

end subroutine fyppm_ttl


subroutine huynh_ttl( im, ar, ar_ttl, al, al_ttl, p, p_ttl, d2, d2_ttl, d1, d1_ttl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_ttl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ttl(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_ttl(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_ttl(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_ttl(im)

!==============================================
! declare local variables
!==============================================
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_ttl
real(kind=r8) :: pmax
real(kind=r8) :: pmax_ttl
real(kind=r8) :: pmin
real(kind=r8) :: pmin_ttl
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
d1_ttl(1) = (-p_ttl(im))+p_ttl(1)
d1(1) = p(1)-p(im)
do i = 2, im
  d1_ttl(i) = (-p_ttl(i-1))+p_ttl(i)
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2_ttl(i) = d1_ttl(i+1)-d1_ttl(i)
  d2(i) = d1(i+1)-d1(i)
end do
d2_ttl(im) = (-d1_ttl(im))+d1_ttl(1)
d2(im) = d1(1)-d1(im)
pmp_ttl = 2*d1_ttl(1)+p_ttl(1)
pmp = p(1)+2.*d1(1)
lac_ttl = 0.5*d1_ttl(1)+1.5*d2_ttl(im)+p_ttl(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin_ttl = p_ttl(1)*(0.5+sign(0.5d0,pmp-p(1)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(1)))
pmin = min(p(1),pmp,lac)
pmax_ttl = p_ttl(1)*(0.5+sign(0.5d0,p(1)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(1)-pmp))
pmax = max(p(1),pmp,lac)
ar_ttl(1) = ar_ttl(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(ar(1),pmin)-&
&pmax))+pmin_ttl*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar(1) = min(pmax,max(ar(1),pmin))
do i = 2, im
  pmp_ttl = 2*d1_ttl(i)+p_ttl(i)
  pmp = p(i)+2.*d1(i)
  lac_ttl = 0.5*d1_ttl(i)+1.5*d2_ttl(i-1)+p_ttl(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin_ttl = p_ttl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_ttl = p_ttl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  ar_ttl(i) = ar_ttl(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(ar(i),&
&pmin)-pmax))+pmin_ttl*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar(i) = min(pmax,max(ar(i),pmin))
end do
do i = 1, im-1
  pmp_ttl = (-2)*d1_ttl(i+1)+p_ttl(i)
  pmp = p(i)-2.*d1(i+1)
  lac_ttl = (-0.5)*d1_ttl(i+1)+1.5*d2_ttl(i+1)+p_ttl(i)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin_ttl = p_ttl(i)*(0.5+sign(0.5d0,pmp-p(i)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(i)))
  pmin = min(p(i),pmp,lac)
  pmax_ttl = p_ttl(i)*(0.5+sign(0.5d0,p(i)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(i)-pmp))
  pmax = max(p(i),pmp,lac)
  al_ttl(i) = al_ttl(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(al(i),&
&pmin)-pmax))+pmin_ttl*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp_ttl = (-2)*d1_ttl(1)+p_ttl(im)
pmp = p(im)-2.*d1(1)
lac_ttl = (-0.5)*d1_ttl(1)+1.5*d2_ttl(1)+p_ttl(im)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin_ttl = p_ttl(im)*(0.5+sign(0.5d0,pmp-p(im)))+pmp_ttl*(0.5-sign(0.5d0,pmp-p(im)))
pmin = min(p(im),pmp,lac)
pmax_ttl = p_ttl(im)*(0.5+sign(0.5d0,p(im)-pmp))+pmp_ttl*(0.5-sign(0.5d0,p(im)-pmp))
pmax = max(p(im),pmp,lac)
al_ttl(im) = al_ttl(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))+pmax_ttl*(0.5+sign(0.5d0,max(al(im),&
&pmin)-pmax))+pmin_ttl*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al(im) = min(pmax,max(al(im),pmin))
do i = 1, im
  d2_ttl(i) = (-3)*al_ttl(i)-3*ar_ttl(i)+6*p_ttl(i)
  d2(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
end do

end subroutine huynh_ttl


subroutine lmppm_ttl( dm, dm_ttl, a6, a6_ttl, ar, ar_ttl, al, al_ttl, p, p_ttl, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_ttl(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_ttl(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ttl(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ttl(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_ttl(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ttl
real(kind=r8) :: da1
real(kind=r8) :: da1_ttl
real(kind=r8) :: da2
real(kind=r8) :: da2_ttl
real(kind=r8) :: dl
real(kind=r8) :: dl_ttl
real(kind=r8) :: dr
real(kind=r8) :: dr_ttl
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ttl
integer :: i

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    if (dm(i) .eq. 0.) then
      ar_ttl(i) = p_ttl(i)
      ar(i) = p(i)
      al_ttl(i) = p_ttl(i)
      al(i) = p(i)
      a6_ttl(i) = 0.d0
      a6(i) = 0.
    else
      da1_ttl = (-al_ttl(i))+ar_ttl(i)
      da1 = ar(i)-al(i)
      da2_ttl = 2*da1_ttl*da1
      da2 = da1**2
      a6da_ttl = a6_ttl(i)*da1+da1_ttl*a6(i)
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_ttl(i) = 3*al_ttl(i)-3*p_ttl(i)
        a6(i) = 3.*(al(i)-p(i))
        ar_ttl(i) = (-a6_ttl(i))+al_ttl(i)
        ar(i) = al(i)-a6(i)
      else if (a6da .gt. da2) then
        a6_ttl(i) = 3*ar_ttl(i)-3*p_ttl(i)
        a6(i) = 3.*(ar(i)-p(i))
        al_ttl(i) = (-a6_ttl(i))+ar_ttl(i)
        al(i) = ar(i)-a6(i)
      endif
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_ttl = 2*dm_ttl(i)
      da1 = dm(i)+dm(i)
      dl_ttl = (al_ttl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_ttl*(0.5+sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_ttl(i)*(0.5-sign(0.5d0,&
&abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
      dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
      dr_ttl = (ar_ttl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_ttl*(0.5+sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_ttl(i)*(0.5-sign(0.5d0,&
&abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
      dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
      ar_ttl(i) = dr_ttl+p_ttl(i)
      ar(i) = p(i)+dr
      al_ttl(i) = (-dl_ttl)+p_ttl(i)
      al(i) = p(i)-dl
      a6_ttl(i) = 3*dl_ttl-3*dr_ttl
      a6(i) = 3.*(dl-dr)
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin_ttl = a6_ttl(i)*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)+al_ttl(i)*((-0.5)*(ar(i)-al(i))/a6(i))+ar_ttl(i)*&
&(0.5*(ar(i)-al(i))/a6(i))+p_ttl(i)
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar_ttl(i) = p_ttl(i)
              ar(i) = p(i)
              al_ttl(i) = p_ttl(i)
              al(i) = p(i)
              a6_ttl(i) = 0.d0
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6_ttl(i) = 3*al_ttl(i)-3*p_ttl(i)
              a6(i) = 3.*(al(i)-p(i))
              ar_ttl(i) = (-a6_ttl(i))+al_ttl(i)
              ar(i) = al(i)-a6(i)
            else
              a6_ttl(i) = 3*ar_ttl(i)-3*p_ttl(i)
              a6(i) = 3.*(ar(i)-p(i))
              al_ttl(i) = (-a6_ttl(i))+ar_ttl(i)
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_ttl = 4*dm_ttl(i)
          da1 = 4.*dm(i)
          dl_ttl = (al_ttl(i)*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))+da1_ttl*(0.5+&
&sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))-p_ttl(i)*&
&(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,min(abs(da1),abs(al(i)-p(i))))
          dl = sign(min(abs(da1),abs(al(i)-p(i))),da1)
          dr_ttl = (ar_ttl(i)*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))+da1_ttl*(0.5+&
&sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))-p_ttl(i)*&
&(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,min(abs(da1),abs(ar(i)-p(i))))
          dr = sign(min(abs(da1),abs(ar(i)-p(i))),da1)
          ar_ttl(i) = dr_ttl+p_ttl(i)
          ar(i) = p(i)+dr
          al_ttl(i) = (-dl_ttl)+p_ttl(i)
          al(i) = p(i)-dl
          a6_ttl(i) = 3*dl_ttl-3*dr_ttl
          a6(i) = 3.*(dl-dr)
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_ttl


subroutine steepx_ttl( im, p, p_ttl, al, al_ttl, dm, dm_ttl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_ttl(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ttl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb
real(kind=r8) :: bbb_ttl
real(kind=r8) :: ccc
real(kind=r8) :: ccc_ttl
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_ttl(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_ttl(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_ttl(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do i = 0, im
  dh_ttl(i) = p_ttl(i+1)-p_ttl(i)
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2_ttl(i) = (-dh_ttl(i-1))+dh_ttl(i)
  d2(i) = dh(i)-dh(i-1)
end do
d2_ttl(0) = d2_ttl(im)
d2(0) = d2(im)
d2_ttl(im+1) = d2_ttl(1)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx_ttl = (-(p_ttl(i-2)*((-0.5)/(p(i+1)-p(i-1)))))+p_ttl(i-1)*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))-&
&p_ttl(i+2)*(0.5/(p(i+1)-p(i-1)))+p_ttl(i+1)*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta_ttl(i) = xxx_ttl*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta_ttl(i) = 0.d0
    eta(i) = 0.
  endif
end do
eta_ttl(0) = eta_ttl(im)
eta(0) = eta(im)
do i = 1, im
  bbb_ttl = dm_ttl(i-1)*(2.*eta(i)-eta(i-1))-eta_ttl(i-1)*dm(i-1)+2*eta_ttl(i)*dm(i-1)
  bbb = (2.*eta(i)-eta(i-1))*dm(i-1)
  ccc_ttl = dm_ttl(i)*(2.*eta(i-1)-eta(i))+2*eta_ttl(i-1)*dm(i)-eta_ttl(i)*dm(i)
  ccc = (2.*eta(i-1)-eta(i))*dm(i)
  al_ttl(i) = al_ttl(i)+bbb_ttl*r3-ccc_ttl*r3+0.5*dh_ttl(i-1)*(eta(i-1)-eta(i))+0.5*eta_ttl(i-1)*dh(i-1)-0.5*eta_ttl(i)*dh(i-1)
  al(i) = al(i)+0.5*(eta(i-1)-eta(i))*dh(i-1)+(bbb-ccc)*r3
end do

end subroutine steepx_ttl


subroutine tp2c_ttl( dh, dh_ttl, va, h, h_ttl, crx, cry, im, jm, iord, jord, ng, fx, fx_ttl, fy, fy_ttl, ffsl, rcap, acosp, xfx, &
&yfx, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: dh(im,jfirst:jlast)
real(kind=r8) :: dh_ttl(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ttl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ttl(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_ttl(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1
real(kind=r8) :: sum1_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call tp2d_ttl( va,h,h_ttl,crx,cry,im,jm,iord,jord,ng,fx,fx_ttl,fy,fy_ttl,ffsl,xfx,yfx,cosp,id,jfirst,jlast )
do j = js2g0, jn2g0
  do i = 1, im-1
    dh_ttl(i,j) = (-fx_ttl(i+1,j))+fx_ttl(i,j)-fy_ttl(i,j+1)*acosp(j)+fy_ttl(i,j)*acosp(j)
    dh(i,j) = fx(i,j)-fx(i+1,j)+(fy(i,j)-fy(i,j+1))*acosp(j)
  end do
end do
do j = js2g0, jn2g0
  dh_ttl(im,j) = fx_ttl(im,j)-fx_ttl(1,j)-fy_ttl(im,j+1)*acosp(j)+fy_ttl(im,j)*acosp(j)
  dh(im,j) = fx(im,j)-fx(1,j)+(fy(im,j)-fy(im,j+1))*acosp(j)
end do
if (jfirst .eq. 1) then
  sum1_ttl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_ttl = fy_ttl(i,2)+sum1_ttl
    sum1 = sum1+fy(i,2)
  end do
  sum1_ttl = -(sum1_ttl*rcap)
  sum1 = -(sum1*rcap)
  do i = 1, im
    dh_ttl(i,1) = sum1_ttl
    dh(i,1) = sum1
  end do
endif
if (jlast .eq. jm) then
  sum1_ttl = 0.d0
  sum1 = 0.
  do i = 1, im
    sum1_ttl = fy_ttl(i,jm)+sum1_ttl
    sum1 = sum1+fy(i,jm)
  end do
  sum1_ttl = sum1_ttl*rcap
  sum1 = sum1*rcap
  do i = 1, im
    dh_ttl(i,jm) = sum1_ttl
    dh(i,jm) = sum1
  end do
endif

end subroutine tp2c_ttl


subroutine tp2d_ttl( va, q, q_ttm, crx, cry, im, jm, iord, jord, ng, fx, fx_ttl, fy, fy_ttl, ffsl, xfx, yfx, cosp, id, jfirst, &
&jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ttl(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ttl(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ttl(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_ttl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_ttl(1+im+2*(im/3))
real(kind=r8) :: dmk_ttl(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_ttl(1+im+2*(im/3))
real(kind=r8) :: qtmpk_ttl(1+im+2*(im/3))
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_ttl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
do j = js2gng, jn2gng
  call xtp_ttl( im,ffsl(j),wk1,wk1_ttl,q(1,j),q_ttm(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,dmk_ttl,qtmp,qtmpk_ttl,al,ar,a6,a6_ttl )
  do i = 1, im-1
    adx_ttl(i,j) = q_ttm(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))-0.5*wk1_ttl(i+1)+0.5*wk1_ttl(i)
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx_ttl(im,j) = q_ttm(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))+0.5*wk1_ttl(im)-0.5*wk1_ttl(1)
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx_ttl(i,1) = q_ttm(i,1)
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx_ttl(i,jm) = q_ttm(i,jm)
    adx(i,jm) = q(i,jm)
  end do
endif
call ytp_ttl( im,jm,fy,fy_ttl,adx,adx_ttl,cry,yfx,ng,jord,0,jfirst,jlast )
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    wk1_ttl(i) = (-0.5)*q_ttm(i,jp+1)*va(i,j)+q_ttm(i,j)+0.5*q_ttm(i,jp)*va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_ttl( im,ffsl(j),fx(1,j),fx_ttl(1,j),wk1,wk1_ttl,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,dmh_ttl,qtmp,qtmph_ttl,al,ar,a6,&
&a6_ttl )
end do

end subroutine tp2d_ttl


subroutine tpcc_ttl( va, ymass, q, crx, cry, im, jm, ng, iord, jord, fx, fy, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6j_ttl(-(im/3):im+im/3)
real(kind=r8) :: a6m_ttl(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adxj_ttl(im,jfirst-1:jlast+2)
real(kind=r8) :: dmj_ttl(-(im/3):im+im/3)
real(kind=r8) :: dmm_ttl(-(im/3):im+im/3)
real(kind=r8) :: fx1(im)
real(kind=r8) :: fxj_ttl(im,jfirst:jlast)
integer :: i
integer :: im2
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qj_ttl(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmpj_ttl(-(im/3):im+im/3)
real(kind=r8) :: qtmpm_ttl(-(im/3):im+im/3)
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1j_ttl(im)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  qj_ttl(:,:) = 0.d0
  a6m_ttl(:) = 0.d0
  call xtp_ttl( im,ffsl(j),wk1,wk1j_ttl,q(1,j),qj_ttl,crx(1,j),1,crx(1,j),cose(j),0,dm,dmm_ttl,qtmp,qtmpm_ttl,al,ar,a6,a6m_ttl )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc( im,jm,fy,adx,cry,ymass,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  adxj_ttl(:,:) = 0.d0
  a6j_ttl(:) = 0.d0
  call xtp_ttl( im,ffsl(j),fx(1,j),fxj_ttl,adx(1,j),adxj_ttl,crx(1,j),iord,crx(1,j),cose(j),0,dm,dmj_ttl,qtmp,qtmpj_ttl,al,ar,a6,&
&a6j_ttl )
end do

end subroutine tpcc_ttl


subroutine xmist_ttl( im, q, q_ttm, dm, dm_ttl, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_ttm(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmi
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxh
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminh

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm_ttl(i) = q_ttm(i-2)*r24-8*q_ttm(i-1)*r24-q_ttm(i+2)*r24+8*q_ttm(i+1)*r24
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm_ttl(i) = (-0.25)*q_ttm(i-1)+0.25*q_ttm(i+1)
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmaxh = max(q(i-1),q(i))
    qmax_ttl = (-q_ttm(i))+q_ttm(i+1)*(0.5-sign(0.5d0,qmaxh-q(i+1)))+(q_ttm(i-1)*(0.5+sign(0.5d0,q(i-1)-q(i)))+q_ttm(i)*(0.5-&
&sign(0.5d0,q(i-1)-q(i))))*(0.5+sign(0.5d0,qmaxh-q(i+1)))
    qmax = max(qmaxh,q(i+1))-q(i)
    qminh = min(q(i-1),q(i))
    qmin_ttl = q_ttm(i)-(q_ttm(i+1)*(0.5-sign(0.5d0,q(i+1)-qminh))+(q_ttm(i-1)*(0.5+sign(0.5d0,q(i)-q(i-1)))+q_ttm(i)*(0.5-&
&sign(0.5d0,q(i)-q(i-1))))*(0.5+sign(0.5d0,q(i+1)-qminh)))
    qmin = q(i)-min(qminh,q(i+1))
    dmh = min(abs(dm(i)),qmax)
    dmi = min(dmh,qmin)
    dm_ttl(i) = ((dm_ttl(i)*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))+qmax_ttl*(0.5-sign(0.5d0,qmax-abs(dm(i)))))*(0.5+&
&sign(0.5d0,qmin-dmh))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmh)))*sign(1.d0,dmi)*sign(1.d0,dm(i))
    dm(i) = sign(dmi,dm(i))
  end do
endif

end subroutine xmist_ttl


subroutine xtp_ttl( im, ffsl, fx, fx_ttl, q, q_ttm, c, iord, mfx, cosa, id, dm, dm_ttl, qtmp, qtmp_ttl, al, ar, a6, a6_ttl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ttl(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ttl(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ttl(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_ttm(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_ttl(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh_ttl(-(im/3):im+im/3)
real(kind=r8) :: ali_ttl(-(im/3):im+im/3)
real(kind=r8) :: arh_ttl(-(im/3):im+im/3)
real(kind=r8) :: ari_ttl(-(im/3):im+im/3)
double precision :: dmh
double precision :: dmi
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxh
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminh
real(kind=r8) :: rut
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp_ttl(i) = q_ttm(i)
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp_ttl(i) = q_ttm(im+i)
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp_ttl(i) = q_ttm(i-im)
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
      fx_ttl(i) = qtmp_ttl(itmp)*(c(i)-iu)
      fx(i) = (c(i)-iu)*qtmp(itmp)
    end do
  else
    do i = 1, im
      tmp_ttl = (-0.25)*qtmp_ttl(i-1)+0.25*qtmp_ttl(i+1)
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmaxh = max(qtmp(i-1),qtmp(i))
      qmax_ttl = (qtmp_ttl(i-1)*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))+qtmp_ttl(i)*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i))))*(0.5+&
&sign(0.5d0,qmaxh-qtmp(i+1)))+qtmp_ttl(i+1)*(0.5-sign(0.5d0,qmaxh-qtmp(i+1)))-qtmp_ttl(i)
      qmax = max(qmaxh,qtmp(i+1))-qtmp(i)
      qminh = min(qtmp(i-1),qtmp(i))
      qmin_ttl = (-((qtmp_ttl(i-1)*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))+qtmp_ttl(i)*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1))))*(0.5+&
&sign(0.5d0,qtmp(i+1)-qminh))+qtmp_ttl(i+1)*(0.5-sign(0.5d0,qtmp(i+1)-qminh))))+qtmp_ttl(i)
      qmin = qtmp(i)-min(qminh,qtmp(i+1))
      dmh = min(abs(tmp),qmax)
      dmi = min(dmh,qmin)
      dm_ttl(i) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmh))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmh)))*sign(1.d0,dmi)*sign(1.d0,tmp)
      dm(i) = sign(dmi,tmp)
    end do
    do i = iuw, 0
      dm_ttl(i) = dm_ttl(im+i)
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm_ttl(i) = dm_ttl(i-im)
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_ttl( im,c,mfx,qtmp,qtmp_ttl,dm,dm_ttl,fx,fx_ttl,iord,al,ali_ttl,ar,ari_ttl,a6,a6_ttl,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
          fx_ttl(i) = (-(dm_ttl(itmp)*rut*(1+rut)))+qtmp_ttl(itmp)*rut
          fx(i) = rut*(qtmp(itmp)-dm(itmp)*(1.+rut))
        else
          itmp = i-iu-1
          isave(i) = itmp+1
          fx_ttl(i) = dm_ttl(itmp)*rut*(1.-rut)+qtmp_ttl(itmp)*rut
          fx(i) = rut*(qtmp(itmp)+dm(itmp)*(1.-rut))
        endif
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        fx_ttl(i) = fx_ttl(i)+qtmp_ttl(ist)
        fx(i) = fx(i)+qtmp(ist)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        fx_ttl(i) = fx_ttl(i)-qtmp_ttl(ist)
        fx(i) = fx(i)-qtmp(ist)
      end do
    endif
  end do
  if (id .ne. 0) then
    do i = 1, im
      fx_ttl(i) = fx_ttl(i)*mfx(i)
      fx(i) = fx(i)*mfx(i)
    end do
  endif
else
  qtmp_ttl(imp) = q_ttm(1)
  qtmp(imp) = q(1)
  qtmp_ttl(0) = q_ttm(im)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = float(i)-c(i)
      fx_ttl(i) = qtmp_ttl(iu)*mfx(i)
      fx(i) = mfx(i)*qtmp(iu)
    end do
  else
    qtmp_ttl(-1) = q_ttm(im-1)
    qtmp(-1) = q(im-1)
    qtmp_ttl(imp+1) = q_ttm(2)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_ttl( im,qtmp,qtmp_ttl,dm,dm_ttl,2 )
    else
      call xmist_ttl( im,qtmp,qtmp_ttl,dm,dm_ttl,iord )
    endif
    dm_ttl(0) = dm_ttl(im)
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      do i = 1, im
        iu = float(i)-c(i)
        fx_ttl(i) = dm_ttl(iu)*mfx(i)*(sign(1.d0,c(i))-c(i))+qtmp_ttl(iu)*mfx(i)
        fx(i) = mfx(i)*(qtmp(iu)+dm(iu)*(sign(1._8,c(i))-c(i)))
      end do
    else
      call fxppm_ttl( im,c,mfx,qtmp,qtmp_ttl,dm,dm_ttl,fx,fx_ttl,iord,al,alh_ttl,ar,arh_ttl,a6,a6_ttl,iuw,iue,ffsl,isave )
    endif
  endif
endif

end subroutine xtp_ttl


subroutine ymist_ttl( im, jm, q, q_ttm, dm, dm_ttl, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ttl(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dml
double precision :: dmm
double precision :: dmn
double precision :: dmo
double precision :: dmp
double precision :: dmq
double precision :: dmr
double precision :: dms
double precision :: dmt
double precision :: dmu
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxj
double precision :: qmaxk
double precision :: qmaxl
double precision :: qmaxm
double precision :: qmaxn
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminj
double precision :: qmink
double precision :: qminl
double precision :: qminm
double precision :: qminn
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm_ttl(i,j) = (-0.25)*q_ttm(i,j-1)+0.25*q_ttm(i,j+1)
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_ttl = (-0.25)*q_ttm(i+im2,2)+0.25*q_ttm(i,2)
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmaxn = max(q(i,2),q(i,1))
      qmax_ttl = (-q_ttm(i,1))+q_ttm(i+im2,2)*(0.5-sign(0.5d0,qmaxn-q(i+im2,2)))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+&
&q_ttm(i,1)*(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxn-q(i+im2,2)))
      qmax = max(qmaxn,q(i+im2,2))-q(i,1)
      qminn = min(q(i,2),q(i,1))
      qmin_ttl = q_ttm(i,1)-(q_ttm(i+im2,2)*(0.5-sign(0.5d0,q(i+im2,2)-qminn))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+q_ttm(i,&
&1)*(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,q(i+im2,2)-qminn)))
      qmin = q(i,1)-min(qminn,q(i+im2,2))
      dmt = min(abs(tmp),qmax)
      dmu = min(dmt,qmin)
      dm_ttl(i,1) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmt))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmt)))*sign(1.d0,dmu)*sign(1.d0,tmp)
      dm(i,1) = sign(dmu,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,1) = -dm_ttl(i-im2,1)
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_ttl = 0.25*q_ttm(i+im2,jm1)-0.25*q_ttm(i,jm1)
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmaxm = max(q(i+im2,jm1),q(i,jm))
      qmax_ttl = (-q_ttm(i,jm))+q_ttm(i,jm1)*(0.5-sign(0.5d0,qmaxm-q(i,jm1)))+(q_ttm(i,jm)*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))+&
&q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm))))*(0.5+sign(0.5d0,qmaxm-q(i,jm1)))
      qmax = max(qmaxm,q(i,jm1))-q(i,jm)
      qminm = min(q(i+im2,jm1),q(i,jm))
      qmin_ttl = q_ttm(i,jm)-(q_ttm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qminm))+(q_ttm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))+&
&q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1))))*(0.5+sign(0.5d0,q(i,jm1)-qminm)))
      qmin = q(i,jm)-min(qminm,q(i,jm1))
      dmr = min(abs(tmp),qmax)
      dms = min(dmr,qmin)
      dm_ttl(i,jm) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmr))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmr)))*sign(1.d0,dms)*sign(1.d0,tmp)
      dm(i,jm) = sign(dms,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,jm) = -dm_ttl(i-im2,jm)
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp_ttl = 0.25*q_ttm(i+im2,2)+0.25*q_ttm(i,2)
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmaxl = max(q(i,2),q(i,1))
      qmax_ttl = (-q_ttm(i,1))-q_ttm(i+im2,2)*(0.5-sign(0.5d0,qmaxl-(-q(i+im2,2))))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,2)-q(i,1)))+&
&q_ttm(i,1)*(0.5-sign(0.5d0,q(i,2)-q(i,1))))*(0.5+sign(0.5d0,qmaxl-(-q(i+im2,2))))
      qmax = max(qmaxl,-q(i+im2,2))-q(i,1)
      qminl = min(q(i,2),q(i,1))
      qmin_ttl = q_ttm(i,1)-((-(q_ttm(i+im2,2)*(0.5-sign(0.5d0,(-q(i+im2,2))-qminl))))+(q_ttm(i,2)*(0.5+sign(0.5d0,q(i,1)-q(i,2)))+&
&q_ttm(i,1)*(0.5-sign(0.5d0,q(i,1)-q(i,2))))*(0.5+sign(0.5d0,(-q(i+im2,2))-qminl)))
      qmin = q(i,1)-min(qminl,-q(i+im2,2))
      dmp = min(abs(tmp),qmax)
      dmq = min(dmp,qmin)
      dm_ttl(i,1) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmp))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmp)))*sign(1.d0,dmq)*sign(1.d0,tmp)
      dm(i,1) = sign(dmq,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,1) = dm_ttl(i-im2,1)
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp_ttl = (-0.25)*q_ttm(i+im2,jm1)-0.25*q_ttm(i,jm1)
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmaxk = max(-q(i+im2,jm1),q(i,jm))
      qmax_ttl = (-q_ttm(i,jm))+q_ttm(i,jm1)*(0.5-sign(0.5d0,qmaxk-q(i,jm1)))+(q_ttm(i,jm)*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm))&
&)-q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm))))*(0.5+sign(0.5d0,qmaxk-q(i,jm1)))
      qmax = max(qmaxk,q(i,jm1))-q(i,jm)
      qmink = min(-q(i+im2,jm1),q(i,jm))
      qmin_ttl = q_ttm(i,jm)-(q_ttm(i,jm1)*(0.5-sign(0.5d0,q(i,jm1)-qmink))+(q_ttm(i,jm)*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))-&
&q_ttm(i+im2,jm1)*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1)))))*(0.5+sign(0.5d0,q(i,jm1)-qmink)))
      qmin = q(i,jm)-min(qmink,q(i,jm1))
      dmn = min(abs(tmp),qmax)
      dmo = min(dmn,qmin)
      dm_ttl(i,jm) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dmn))+qmin_ttl*(0.5-sign(0.5d0,qmin-dmn)))*sign(1.d0,dmo)*sign(1.d0,tmp)
      dm(i,jm) = sign(dmo,tmp)
    end do
    do i = im2+1, im
      dm_ttl(i,jm) = dm_ttl(i-im2,jm)
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    do i = 1, im
      qmaxj = max(q(i,j-1),q(i,j))
      qmax_ttl = (-q_ttm(i,j))+q_ttm(i,j+1)*(0.5-sign(0.5d0,qmaxj-q(i,j+1)))+(q_ttm(i,j-1)*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))+&
&q_ttm(i,j)*(0.5-sign(0.5d0,q(i,j-1)-q(i,j))))*(0.5+sign(0.5d0,qmaxj-q(i,j+1)))
      qmax = max(qmaxj,q(i,j+1))-q(i,j)
      qminj = min(q(i,j-1),q(i,j))
      qmin_ttl = q_ttm(i,j)-(q_ttm(i,j+1)*(0.5-sign(0.5d0,q(i,j+1)-qminj))+(q_ttm(i,j-1)*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))+q_ttm(i,&
&j)*(0.5-sign(0.5d0,q(i,j)-q(i,j-1))))*(0.5+sign(0.5d0,q(i,j+1)-qminj)))
      qmin = q(i,j)-min(qminj,q(i,j+1))
      dml = min(abs(dm(i,j)),qmin)
      dmm = min(dml,qmax)
      dm_ttl(i,j) = ((dm_ttl(i,j)*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))+qmin_ttl*(0.5-sign(0.5d0,qmin-abs(dm(i,j))&
&)))*(0.5+sign(0.5d0,qmax-dml))+qmax_ttl*(0.5-sign(0.5d0,qmax-dml)))*sign(1.d0,dmm)*sign(1.d0,dm(i,j))
      dm(i,j) = sign(dmm,dm(i,j))
    end do
  end do
endif

end subroutine ymist_ttl


subroutine ytp_ttl( im, jm, fy, fy_ttl, q, q_ttm, c, yfx, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ttl(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ttm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ttl(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      fy_ttl(i,j) = q_ttm(i,jt)
      fy(i,j) = q(i,jt)
    end do
  end do
else
  call ymist_ttl( im,jm,q,q_ttm,dm,dm_ttl,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm_ttl( c,q,q_ttm,dm,dm_ttl,fy,fy_ttl,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        fy_ttl(i,j) = dm_ttl(i,jt)*(sign(1.d0,c(i,j))-c(i,j))+q_ttm(i,jt)
        fy(i,j) = q(i,jt)+(sign(1._8,c(i,j))-c(i,j))*dm(i,jt)
      end do
    end do
  endif
endif
do j = js2g0, jn1g1
  do i = 1, im
    fy_ttl(i,j) = fy_ttl(i,j)*yfx(i,j)
    fy(i,j) = fy(i,j)*yfx(i,j)
  end do
end do

end subroutine ytp_ttl


end module     tp_core_ttl


#endif /* SPMD */
