#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tpcc_tad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: tpcc1_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc1_tape_dm_2h(:,:)
integer :: tpcc1_tape_tpcc
real(kind=8), allocatable :: tpcc2_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc2_tape_dm_2h(:,:)
integer :: tpcc2_tape_tpcc

end module     tpcc_tad_store


module     tp_core_tad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_tad( im, c, mfx, p, p_tad, dm, dm_tad, fx_tad, iord, al, al_tad, ar, ar_tad, a6, a6_tad, iuw, iue, ffsl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_tad(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_tad(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx_tad(im)
integer :: iord
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: a6h_tad
double precision :: a6i_tad
double precision :: alh_tad
double precision :: ali_tad
double precision :: arh_tad
double precision :: ari_tad
real(kind=r8) :: dmh(-(im/3):im+im/3)
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
logical :: steep

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmh(:) = dm(:)

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx( im,p,al(1),dm )
endif
do i = 1, im-1
  ar(i) = al(i+1)
end do
ar(im) = al(1)
if (ffsl) then
  do i = 1, im
    iu = c(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      a6_tad(itmp) = a6_tad(itmp)+0.5*fx_tad(i)*ru*ru*(1.-r23*ru)
      al_tad(itmp) = al_tad(itmp)+0.5*fx_tad(i)*ru*ru
      ar_tad(itmp) = ar_tad(itmp)+fx_tad(i)*ru*(1+(-0.5)*ru)
      fx_tad(i) = 0.d0
    else
      itmp = i-iu
      a6_tad(itmp) = a6_tad(itmp)-0.5*fx_tad(i)*ru*ru*(1+r23*ru)
      al_tad(itmp) = al_tad(itmp)+fx_tad(i)*ru*(1-(-0.5)*ru)
      ar_tad(itmp) = ar_tad(itmp)-0.5*fx_tad(i)*ru*ru
      fx_tad(i) = 0.d0
    endif
  end do
  do i = iue, im+1, -1
    a6h_tad = a6_tad(i)
    a6_tad(i) = 0.d0
    a6_tad(i-im) = a6_tad(i-im)+a6h_tad
    arh_tad = ar_tad(i)
    ar_tad(i) = 0.d0
    ar_tad(i-im) = ar_tad(i-im)+arh_tad
    alh_tad = al_tad(i)
    al_tad(i) = 0.d0
    al_tad(i-im) = al_tad(i-im)+alh_tad
  end do
  do i = 0, iuw, -1
    a6i_tad = a6_tad(i)
    a6_tad(i) = 0.d0
    a6_tad(im+i) = a6_tad(im+i)+a6i_tad
    ari_tad = ar_tad(i)
    ar_tad(i) = 0.d0
    ar_tad(im+i) = ar_tad(im+i)+ari_tad
    ali_tad = al_tad(i)
    al_tad(i) = 0.d0
    al_tad(im+i) = al_tad(im+i)+ali_tad
  end do
else
  do i = 1, im
    fx_tad(i) = fx_tad(i)*mfx(i)
    if (c(i) .gt. 0.) then
      a6_tad(i-1) = a6_tad(i-1)+0.5*fx_tad(i)*c(i)*(1.-r23*c(i))
      al_tad(i-1) = al_tad(i-1)+0.5*fx_tad(i)*c(i)
      ar_tad(i-1) = ar_tad(i-1)+fx_tad(i)*(1+(-0.5)*c(i))
      fx_tad(i) = 0.d0
    else
      a6_tad(i) = a6_tad(i)-0.5*fx_tad(i)*c(i)*(1+r23*c(i))
      al_tad(i) = al_tad(i)+fx_tad(i)*(1-(-0.5)*c(i))
      ar_tad(i) = ar_tad(i)-0.5*fx_tad(i)*c(i)
      fx_tad(i) = 0.d0
    endif
  end do
  a6_tad(im) = a6_tad(im)+a6_tad(0)
  a6_tad(0) = 0.d0
  ar_tad(im) = ar_tad(im)+ar_tad(0)
  ar_tad(0) = 0.d0
  al_tad(im) = al_tad(im)+al_tad(0)
  al_tad(0) = 0.d0
endif
if (iord .eq. 7) then
  call huynh_tad( im,ar(1),ar_tad(1),al(1),al_tad(1),p(1),p_tad(1),a6(1),a6_tad(1),dm(1),dm_tad(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm_tad( dm(1),dm_tad(1),a6(1),a6_tad(1),ar(1),ar_tad(1),al(1),al_tad(1),p(1),p_tad(1),im,lmt )
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      al_tad(i) = al_tad(i)-3*a6_tad(i)
      ar_tad(i) = ar_tad(i)-3*a6_tad(i)
      p_tad(i) = p_tad(i)+6*a6_tad(i)
      a6_tad(i) = 0.d0
    end do
  endif
endif
al_tad(1) = al_tad(1)+ar_tad(im)
ar_tad(im) = 0.d0
do i = 1, im-1
  al_tad(i+1) = al_tad(i+1)+ar_tad(i)
  ar_tad(i) = 0.d0
end do
dm(:) = dmh(:)
if (steep) then
  call steepx_tad( im,p,p_tad,al_tad(1),dm,dm_tad )
endif
do i = 1, im
  dm_tad(i-1) = dm_tad(i-1)+al_tad(i)*r3
  dm_tad(i) = dm_tad(i)-al_tad(i)*r3
  p_tad(i-1) = p_tad(i-1)+0.5*al_tad(i)
  p_tad(i) = p_tad(i)+0.5*al_tad(i)
  al_tad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine fxppm_tad


subroutine fyppm_tad( c, q, q_tae, dm, dm_tad, flux_tad, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux_tad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_tad(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_tad(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_tad(im,jfirst-1:jlast+1)
double precision :: arh_tad
double precision :: ari_tad
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_tad(:,:) = 0.d0
al_tad(:,:) = 0.d0
ar_tad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = al(i+imh,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = ar(i+imh,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = -al(i+imh,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = -ar(i+imh,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      a6_tad(i,j-1) = a6_tad(i,j-1)+0.5*flux_tad(i,j)*c(i,j)*(1.-r23*c(i,j))
      al_tad(i,j-1) = al_tad(i,j-1)+0.5*flux_tad(i,j)*c(i,j)
      ar_tad(i,j-1) = ar_tad(i,j-1)+flux_tad(i,j)*(1+(-0.5)*c(i,j))
      flux_tad(i,j) = 0.d0
    else
      a6_tad(i,j) = a6_tad(i,j)-0.5*flux_tad(i,j)*c(i,j)*(1+r23*c(i,j))
      al_tad(i,j) = al_tad(i,j)+flux_tad(i,j)*(1-(-0.5)*c(i,j))
      ar_tad(i,j) = ar_tad(i,j)-0.5*flux_tad(i,j)*c(i,j)
      flux_tad(i,j) = 0.d0
    endif
  end do
end do
call lmppm_tad( dm(1,js1g1),dm_tad(1,js1g1),a6(1,js1g1),a6_tad(1,js1g1),ar(1,js1g1),ar_tad(1,js1g1),al(1,js1g1),al_tad(1,js1g1),&
&q(1,js1g1),q_tae(1,js1g1),help_h,lmt )
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      al_tad(i,j) = al_tad(i,j)-3*a6_tad(i,j)
      ar_tad(i,j) = ar_tad(i,j)-3*a6_tad(i,j)
      q_tae(i,j) = q_tae(i,j)+6*a6_tad(i,j)
      a6_tad(i,j) = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_tad(i,jm1) = ar_tad(i,jm1)+ar_tad(i+imh,jm)
      ar_tad(i+imh,jm) = 0.d0
      arh_tad = ar_tad(i,jm)
      ar_tad(i,jm) = 0.d0
      ar_tad(i+imh,jm1) = ar_tad(i+imh,jm1)+arh_tad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tad(i,2) = al_tad(i,2)+al_tad(i+imh,1)
      al_tad(i+imh,1) = 0.d0
      al_tad(i+imh,2) = al_tad(i+imh,2)+al_tad(i,1)
      al_tad(i,1) = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_tad(i,jm1) = ar_tad(i,jm1)-ar_tad(i+imh,jm)
      ar_tad(i+imh,jm) = 0.d0
      ari_tad = ar_tad(i,jm)
      ar_tad(i,jm) = 0.d0
      ar_tad(i+imh,jm1) = ar_tad(i+imh,jm1)-ari_tad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tad(i,2) = al_tad(i,2)-al_tad(i+imh,1)
      al_tad(i+imh,1) = 0.d0
      al_tad(i+imh,2) = al_tad(i+imh,2)-al_tad(i,1)
      al_tad(i,1) = 0.d0
    end do
  endif
endif
do j = js1g1, jn2g1
  do i = 1, im
    al_tad(i,j+1) = al_tad(i,j+1)+ar_tad(i,j)
    ar_tad(i,j) = 0.d0
  end do
end do
do j = js2g1, jn1g2
  do i = 1, im
    dm_tad(i,j-1) = dm_tad(i,j-1)+al_tad(i,j)*r3
    dm_tad(i,j) = dm_tad(i,j)-al_tad(i,j)*r3
    q_tae(i,j-1) = q_tae(i,j-1)+0.5*al_tad(i,j)
    q_tae(i,j) = q_tae(i,j)+0.5*al_tad(i,j)
    al_tad(i,j) = 0.d0
  end do
end do

end subroutine fyppm_tad


subroutine huynh_tad( im, ar, ar_tad, al, al_tad, p, p_tad, d2, d2_tad, d1, d1_tad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_tad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tad(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_tad(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_tad(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_tad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh(im)
real(kind=r8) :: arh(im)
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_tad
real(kind=r8) :: pmax
real(kind=r8) :: pmax_tad
real(kind=r8) :: pmin
real(kind=r8) :: pmin_tad
real(kind=r8) :: pmp
real(kind=r8) :: pmp_tad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
arh(:) = ar(:)
alh(:) = al(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
lac_tad = 0.d0
pmax_tad = 0.d0
pmin_tad = 0.d0
pmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
d1(1) = p(1)-p(im)
do i = 2, im
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2(i) = d1(i+1)-d1(i)
end do
d2(im) = d1(1)-d1(im)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
ar(1) = min(pmax,max(ar(1),pmin))
do i = 1, im-1
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp = p(im)-2.*d1(1)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin = min(p(im),pmp,lac)
pmax = max(p(im),pmp,lac)
do i = 1, im
  al_tad(i) = al_tad(i)-3*d2_tad(i)
  ar_tad(i) = ar_tad(i)-3*d2_tad(i)
  p_tad(i) = p_tad(i)+6*d2_tad(i)
  d2_tad(i) = 0.d0
end do
pmax_tad = pmax_tad+al_tad(im)*(0.5+sign(0.5d0,max(al(im),pmin)-pmax))
pmin_tad = pmin_tad+al_tad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al_tad(im) = al_tad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))
p_tad(im) = p_tad(im)+pmax_tad*(0.5+sign(0.5d0,p(im)-pmp))
pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(im)-pmp))
pmax_tad = 0.d0
p_tad(im) = p_tad(im)+pmin_tad*(0.5+sign(0.5d0,pmp-p(im)))
pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(im)))
pmin_tad = 0.d0
d1_tad(1) = d1_tad(1)-0.5*lac_tad
d2_tad(1) = d2_tad(1)+1.5*lac_tad
p_tad(im) = p_tad(im)+lac_tad
lac_tad = 0.d0
d1_tad(1) = d1_tad(1)-2*pmp_tad
p_tad(im) = p_tad(im)+pmp_tad
pmp_tad = 0.d0
al(:) = alh(:)
do i = 1, im-1
  lac_tad = 0.d0
  pmax_tad = 0.d0
  pmin_tad = 0.d0
  pmp_tad = 0.d0
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_tad = pmax_tad+al_tad(i)*(0.5+sign(0.5d0,max(al(i),pmin)-pmax))
  pmin_tad = pmin_tad+al_tad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al_tad(i) = al_tad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))
  p_tad(i) = p_tad(i)+pmax_tad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_tad = 0.d0
  p_tad(i) = p_tad(i)+pmin_tad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_tad = 0.d0
  d1_tad(i+1) = d1_tad(i+1)-0.5*lac_tad
  d2_tad(i+1) = d2_tad(i+1)+1.5*lac_tad
  p_tad(i) = p_tad(i)+lac_tad
  lac_tad = 0.d0
  d1_tad(i+1) = d1_tad(i+1)-2*pmp_tad
  p_tad(i) = p_tad(i)+pmp_tad
  pmp_tad = 0.d0
end do
do i = 2, im
  lac_tad = 0.d0
  pmax_tad = 0.d0
  pmin_tad = 0.d0
  pmp_tad = 0.d0
  pmp = p(i)+2.*d1(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_tad = pmax_tad+ar_tad(i)*(0.5+sign(0.5d0,max(ar(i),pmin)-pmax))
  pmin_tad = pmin_tad+ar_tad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar_tad(i) = ar_tad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))
  p_tad(i) = p_tad(i)+pmax_tad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_tad = 0.d0
  p_tad(i) = p_tad(i)+pmin_tad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_tad = 0.d0
  d1_tad(i) = d1_tad(i)+0.5*lac_tad
  d2_tad(i-1) = d2_tad(i-1)+1.5*lac_tad
  p_tad(i) = p_tad(i)+lac_tad
  lac_tad = 0.d0
  d1_tad(i) = d1_tad(i)+2*pmp_tad
  p_tad(i) = p_tad(i)+pmp_tad
  pmp_tad = 0.d0
end do
ar(:) = arh(:)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
pmax_tad = pmax_tad+ar_tad(1)*(0.5+sign(0.5d0,max(ar(1),pmin)-pmax))
pmin_tad = pmin_tad+ar_tad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar_tad(1) = ar_tad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))
pmp = p(1)+2.*d1(1)
p_tad(1) = p_tad(1)+pmax_tad*(0.5+sign(0.5d0,p(1)-pmp))
pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(1)-pmp))
pmax_tad = 0.d0
pmp = p(1)+2.*d1(1)
p_tad(1) = p_tad(1)+pmin_tad*(0.5+sign(0.5d0,pmp-p(1)))
pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(1)))
pmin_tad = 0.d0
d1_tad(1) = d1_tad(1)+0.5*lac_tad
d2_tad(im) = d2_tad(im)+1.5*lac_tad
p_tad(1) = p_tad(1)+lac_tad
lac_tad = 0.d0
d1_tad(1) = d1_tad(1)+2*pmp_tad
p_tad(1) = p_tad(1)+pmp_tad
pmp_tad = 0.d0
d1_tad(im) = d1_tad(im)-d2_tad(im)
d1_tad(1) = d1_tad(1)+d2_tad(im)
d2_tad(im) = 0.d0
do i = 1, im-1
  d1_tad(i+1) = d1_tad(i+1)+d2_tad(i)
  d1_tad(i) = d1_tad(i)-d2_tad(i)
  d2_tad(i) = 0.d0
end do
do i = 2, im
  p_tad(i-1) = p_tad(i-1)-d1_tad(i)
  p_tad(i) = p_tad(i)+d1_tad(i)
  d1_tad(i) = 0.d0
end do
p_tad(im) = p_tad(im)-d1_tad(1)
p_tad(1) = p_tad(1)+d1_tad(1)
d1_tad(1) = 0.d0

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine huynh_tad


subroutine lmppm_tad( dm, dm_tad, a6, a6_tad, ar, ar_tad, al, al_tad, p, p_tad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_tad(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_tad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tad(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_tad(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_tad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_tad
real(kind=r8) :: da1
real(kind=r8) :: da1_tad
real(kind=r8) :: da2
real(kind=r8) :: da2_tad
real(kind=r8) :: dl_tad
real(kind=r8) :: dr_tad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_tad
integer :: i

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_tad = 0.d0
da1_tad = 0.d0
da2_tad = 0.d0
dl_tad = 0.d0
dr_tad = 0.d0
fmin_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    a6da_tad = 0.d0
    da1_tad = 0.d0
    da2_tad = 0.d0
    if (dm(i) .eq. 0.) then
      a6_tad(i) = 0.d0
      p_tad(i) = p_tad(i)+al_tad(i)
      al_tad(i) = 0.d0
      p_tad(i) = p_tad(i)+ar_tad(i)
      ar_tad(i) = 0.d0
    else
      da1 = ar(i)-al(i)
      da2 = da1**2
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_tad(i) = a6_tad(i)-ar_tad(i)
        al_tad(i) = al_tad(i)+ar_tad(i)
        ar_tad(i) = 0.d0
        al_tad(i) = al_tad(i)+3*a6_tad(i)
        p_tad(i) = p_tad(i)-3*a6_tad(i)
        a6_tad(i) = 0.d0
      else if (a6da .gt. da2) then
        a6_tad(i) = a6_tad(i)-al_tad(i)
        ar_tad(i) = ar_tad(i)+al_tad(i)
        al_tad(i) = 0.d0
        ar_tad(i) = ar_tad(i)+3*a6_tad(i)
        p_tad(i) = p_tad(i)-3*a6_tad(i)
        a6_tad(i) = 0.d0
      endif
      a6_tad(i) = a6_tad(i)+a6da_tad*da1
      da1_tad = da1_tad+a6da_tad*a6(i)
      a6da_tad = 0.d0
      da1_tad = da1_tad+2*da2_tad*da1
      da2_tad = 0.d0
      al_tad(i) = al_tad(i)-da1_tad
      ar_tad(i) = ar_tad(i)+da1_tad
      da1_tad = 0.d0
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_tad = 0.d0
      dl_tad = 0.d0
      dr_tad = 0.d0
      da1 = dm(i)+dm(i)
      dl_tad = dl_tad+3*a6_tad(i)
      dr_tad = dr_tad-3*a6_tad(i)
      a6_tad(i) = 0.d0
      dl_tad = dl_tad-al_tad(i)
      p_tad(i) = p_tad(i)+al_tad(i)
      al_tad(i) = 0.d0
      dr_tad = dr_tad+ar_tad(i)
      p_tad(i) = p_tad(i)+ar_tad(i)
      ar_tad(i) = 0.d0
      ar_tad(i) = ar_tad(i)+dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      da1_tad = da1_tad+dr_tad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
      p_tad(i) = p_tad(i)-dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      dr_tad = 0.d0
      al_tad(i) = al_tad(i)+dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      da1_tad = da1_tad+dl_tad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
      p_tad(i) = p_tad(i)-dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      dl_tad = 0.d0
      dm_tad(i) = dm_tad(i)+2*da1_tad
      da1_tad = 0.d0
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im-1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar(i) = p(i)
              al(i) = p(i)
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6(i) = 3.*(al(i)-p(i))
              ar(i) = al(i)-a6(i)
            else
              a6(i) = 3.*(ar(i)-p(i))
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
      do i = im, 1, -1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              a6_tad(i) = 0.d0
              p_tad(i) = p_tad(i)+al_tad(i)
              al_tad(i) = 0.d0
              p_tad(i) = p_tad(i)+ar_tad(i)
              ar_tad(i) = 0.d0
            else if (ar(i) .gt. al(i)) then
              a6_tad(i) = a6_tad(i)-ar_tad(i)
              al_tad(i) = al_tad(i)+ar_tad(i)
              ar_tad(i) = 0.d0
              al_tad(i) = al_tad(i)+3*a6_tad(i)
              p_tad(i) = p_tad(i)-3*a6_tad(i)
              a6_tad(i) = 0.d0
            else
              a6_tad(i) = a6_tad(i)-al_tad(i)
              ar_tad(i) = ar_tad(i)+al_tad(i)
              al_tad(i) = 0.d0
              ar_tad(i) = ar_tad(i)+3*a6_tad(i)
              p_tad(i) = p_tad(i)-3*a6_tad(i)
              a6_tad(i) = 0.d0
            endif
          endif
          a6_tad(i) = a6_tad(i)+fmin_tad*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)
          al_tad(i) = al_tad(i)+fmin_tad*((-0.5)*(ar(i)-al(i))/a6(i))
          ar_tad(i) = ar_tad(i)+fmin_tad*(0.5*(ar(i)-al(i))/a6(i))
          p_tad(i) = p_tad(i)+fmin_tad
          fmin_tad = 0.d0
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_tad = 0.d0
          dl_tad = 0.d0
          dr_tad = 0.d0
          da1 = 4.*dm(i)
          dl_tad = dl_tad+3*a6_tad(i)
          dr_tad = dr_tad-3*a6_tad(i)
          a6_tad(i) = 0.d0
          dl_tad = dl_tad-al_tad(i)
          p_tad(i) = p_tad(i)+al_tad(i)
          al_tad(i) = 0.d0
          dr_tad = dr_tad+ar_tad(i)
          p_tad(i) = p_tad(i)+ar_tad(i)
          ar_tad(i) = 0.d0
          ar_tad(i) = ar_tad(i)+dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          da1_tad = da1_tad+dr_tad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
          p_tad(i) = p_tad(i)-dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          dr_tad = 0.d0
          al_tad(i) = al_tad(i)+dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          da1_tad = da1_tad+dl_tad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
          p_tad(i) = p_tad(i)-dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          dl_tad = 0.d0
          dm_tad(i) = dm_tad(i)+4*da1_tad
          da1_tad = 0.d0
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_tad


subroutine steepx_tad( im, p, p_tad, al_tad, dm, dm_tad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al_tad(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb_tad
real(kind=r8) :: ccc_tad
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_tad(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_tad(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_tad(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
bbb_tad = 0.d0
ccc_tad = 0.d0
d2_tad(:) = 0.d0
dh_tad(:) = 0.d0
eta_tad(:) = 0.d0
xxx_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do i = 0, im
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2(i) = dh(i)-dh(i-1)
end do
d2(0) = d2(im)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta(i) = 0.
  endif
end do
eta(0) = eta(im)
do i = 1, im
  bbb_tad = 0.d0
  ccc_tad = 0.d0
  bbb_tad = bbb_tad+al_tad(i)*r3
  ccc_tad = ccc_tad-al_tad(i)*r3
  dh_tad(i-1) = dh_tad(i-1)+0.5*al_tad(i)*(eta(i-1)-eta(i))
  eta_tad(i-1) = eta_tad(i-1)+0.5*al_tad(i)*dh(i-1)
  eta_tad(i) = eta_tad(i)-0.5*al_tad(i)*dh(i-1)
  dm_tad(i) = dm_tad(i)+ccc_tad*(2.*eta(i-1)-eta(i))
  eta_tad(i-1) = eta_tad(i-1)+2*ccc_tad*dm(i)
  eta_tad(i) = eta_tad(i)-ccc_tad*dm(i)
  ccc_tad = 0.d0
  dm_tad(i-1) = dm_tad(i-1)+bbb_tad*(2.*eta(i)-eta(i-1))
  eta_tad(i-1) = eta_tad(i-1)-bbb_tad*dm(i-1)
  eta_tad(i) = eta_tad(i)+2*bbb_tad*dm(i-1)
  bbb_tad = 0.d0
end do
eta_tad(im) = eta_tad(im)+eta_tad(0)
eta_tad(0) = 0.d0
do i = 1, im
  xxx_tad = 0.d0
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    xxx_tad = xxx_tad+eta_tad(i)*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta_tad(i) = 0.d0
    p_tad(i-2) = p_tad(i-2)-xxx_tad*((-0.5)/(p(i+1)-p(i-1)))
    p_tad(i-1) = p_tad(i-1)+xxx_tad*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    p_tad(i+2) = p_tad(i+2)-xxx_tad*(0.5/(p(i+1)-p(i-1)))
    p_tad(i+1) = p_tad(i+1)+xxx_tad*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx_tad = 0.d0
  else
    eta_tad(i) = 0.d0
  endif
end do
d2_tad(1) = d2_tad(1)+d2_tad(im+1)
d2_tad(im+1) = 0.d0
d2_tad(im) = d2_tad(im)+d2_tad(0)
d2_tad(0) = 0.d0
do i = 1, im
  dh_tad(i-1) = dh_tad(i-1)-d2_tad(i)
  dh_tad(i) = dh_tad(i)+d2_tad(i)
  d2_tad(i) = 0.d0
end do
do i = 0, im
  p_tad(i+1) = p_tad(i+1)+dh_tad(i)
  p_tad(i) = p_tad(i)-dh_tad(i)
  dh_tad(i) = 0.d0
end do

end subroutine steepx_tad


subroutine tp2c_tad( dh_tad, va, h, h_tad, crx, cry, im, jm, iord, jord, ng, fx, fx_tad, fy_tad, ffsl, rcap, acosp, xfx, yfx, cosp,&
& id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: dh_tad(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tad(im,jfirst:jlast)
real(kind=r8) :: fy_tad(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_tad(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
sum1_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
if (jlast .eq. jm) then
  do i = 1, im
    sum1_tad = sum1_tad+dh_tad(i,jm)
    dh_tad(i,jm) = 0.d0
  end do
  sum1_tad = sum1_tad*rcap
  do i = 1, im
    fy_tad(i,jm) = fy_tad(i,jm)+sum1_tad
  end do
  sum1_tad = 0.d0
endif
if (jfirst .eq. 1) then
  do i = 1, im
    sum1_tad = sum1_tad+dh_tad(i,1)
    dh_tad(i,1) = 0.d0
  end do
  sum1_tad = -(sum1_tad*rcap)
  do i = 1, im
    fy_tad(i,2) = fy_tad(i,2)+sum1_tad
  end do
endif
do j = js2g0, jn2g0
  fx_tad(im,j) = fx_tad(im,j)+dh_tad(im,j)
  fx_tad(1,j) = fx_tad(1,j)-dh_tad(im,j)
  fy_tad(im,j+1) = fy_tad(im,j+1)-dh_tad(im,j)*acosp(j)
  fy_tad(im,j) = fy_tad(im,j)+dh_tad(im,j)*acosp(j)
  dh_tad(im,j) = 0.d0
end do
do j = js2g0, jn2g0
  do i = 1, im-1
    fx_tad(i+1,j) = fx_tad(i+1,j)-dh_tad(i,j)
    fx_tad(i,j) = fx_tad(i,j)+dh_tad(i,j)
    fy_tad(i,j+1) = fy_tad(i,j+1)-dh_tad(i,j)*acosp(j)
    fy_tad(i,j) = fy_tad(i,j)+dh_tad(i,j)*acosp(j)
    dh_tad(i,j) = 0.d0
  end do
end do
call tp2d_tad( va,h,h_tad,crx,cry,im,jm,iord,jord,ng,fx,fx_tad,fy_tad,ffsl,xfx,yfx,cosp,id,jfirst,jlast )

end subroutine tp2c_tad


subroutine tp2d_tad( va, q, q_tae, crx, cry, im, jm, iord, jord, ng, fx, fx_tad, fy_tad, ffsl, xfx, yfx, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tad(im,jfirst:jlast)
real(kind=r8) :: fy_tad(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tad(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_tad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_tad(1+im+2*(im/3))
real(kind=r8) :: dmi_tad(1+im+2*(im/3))
real(kind=r8) :: dmj_tad(1+im+2*(im/3))
real(kind=r8) :: dmk_tad(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpj_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpk_tad(1+im+2*(im/3))
real(kind=8), allocatable :: tp2d_tape1_a6_1h(:,:)
real(kind=8), allocatable :: tp2d_tape1_dm_2h(:,:)
integer :: tp2d_tape1_tp2d
real(kind=8), allocatable :: tp2d_tape2_a6_2h(:,:)
real(kind=8), allocatable :: tp2d_tape2_adx_1h(:,:,:)
real(kind=8), allocatable :: tp2d_tape2_dm_3h(:,:)
integer :: tp2d_tape2_tp2d
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_tad(im)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_tad(:) = 0.d0
adx_tad(:,:) = 0.d0
dmh_tad(:) = 0.d0
dmi_tad(:) = 0.d0
dmj_tad(:) = 0.d0
dmk_tad(:) = 0.d0
qtmph_tad(:) = 0.d0
qtmpi_tad(:) = 0.d0
qtmpj_tad(:) = 0.d0
qtmpk_tad(:) = 0.d0
wk1_tad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
!----------------------------------------------
! OPEN TAPE tp2d_tape1
!----------------------------------------------
tp2d_tape1_tp2d = jn2gng-js2gng+1

!----------------------------------------------
! OPEN TAPE tp2d_tape2
!----------------------------------------------
tp2d_tape2_tp2d = jn2g0-js2g0+1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do j = js2gng, jn2gng
  if ( .not. allocated(tp2d_tape1_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_a6_1h)) then
      allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_a6_1h(:,1+j-js2gng) = a6
  if ( .not. allocated(tp2d_tape1_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_dm_2h)) then
      allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_dm_2h(:,1+j-js2gng) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx(i,jm) = q(i,jm)
  end do
endif
if ( .not. allocated(tp2d_tape2_adx_1h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_adx_1h)) then
    allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_adx_1h(:,:,1) = adx
do j = js2g0, jn2g0-1
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_a6_2h)) then
      allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_dm_3h)) then
      allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_dm_3h(:,1+j-js2g0) = dm
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp( im,ffsl(j),fx(1,j),wk1,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,qtmp,al,ar,a6 )
end do
j = jn2g0
if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_dm_3h(:,1+j-js2g0) = dm

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
adx = tp2d_tape2_adx_1h(:,:,1)
do j = jn2g0, js2g0, -1
  a6 = tp2d_tape2_a6_2h(:,1+j-js2g0)
  dm = tp2d_tape2_dm_3h(:,1+j-js2g0)
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_tad( im,ffsl(j),fx(1,j),fx_tad(1,j),wk1,wk1_tad,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,dmj_tad,qtmp,qtmpj_tad,al,ar,a6,&
&a6_tad )
  do i = 1, im
    jp = j-va(i,j)
    q_tae(i,jp+1) = q_tae(i,jp+1)-0.5*wk1_tad(i)*va(i,j)
    q_tae(i,j) = q_tae(i,j)+wk1_tad(i)
    q_tae(i,jp) = q_tae(i,jp)+0.5*wk1_tad(i)*va(i,j)
    wk1_tad(i) = 0.d0
  end do
end do
call ytp_tad( im,jm,fy_tad,adx,adx_tad,cry,yfx,ng,jord,0,jfirst,jlast )
if (jlast .eq. jm) then
  do i = 1, im
    q_tae(i,jm) = q_tae(i,jm)+adx_tad(i,jm)
    adx_tad(i,jm) = 0.d0
  end do
endif
if (jfirst .eq. 1) then
  do i = 1, im
    q_tae(i,1) = q_tae(i,1)+adx_tad(i,1)
    adx_tad(i,1) = 0.d0
  end do
endif
do j = jn2gng, js2gng, -1
  a6 = tp2d_tape1_a6_1h(:,1+j-js2gng)
  dm = tp2d_tape1_dm_2h(:,1+j-js2gng)
  q_tae(im,j) = q_tae(im,j)+adx_tad(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))
  wk1_tad(im) = wk1_tad(im)+0.5*adx_tad(im,j)
  wk1_tad(1) = wk1_tad(1)-0.5*adx_tad(im,j)
  adx_tad(im,j) = 0.d0
  do i = 1, im-1
    q_tae(i,j) = q_tae(i,j)+adx_tad(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))
    wk1_tad(i+1) = wk1_tad(i+1)-0.5*adx_tad(i,j)
    wk1_tad(i) = wk1_tad(i)+0.5*adx_tad(i,j)
    adx_tad(i,j) = 0.d0
  end do
  call xtp_tad( im,ffsl(j),wk1,wk1_tad,q(1,j),q_tae(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,dmk_tad,qtmp,qtmpk_tad,al,ar,a6,a6_tad )
end do

!----------------------------------------------
! CLOSE TAPE tp2d_tape1
!----------------------------------------------
if (allocated(tp2d_tape1_a6_1h)) then
  deallocate( tp2d_tape1_a6_1h )
endif
if (allocated(tp2d_tape1_dm_2h)) then
  deallocate( tp2d_tape1_dm_2h )
endif

!----------------------------------------------
! CLOSE TAPE tp2d_tape2
!----------------------------------------------
if (allocated(tp2d_tape2_adx_1h)) then
  deallocate( tp2d_tape2_adx_1h )
endif
if (allocated(tp2d_tape2_a6_2h)) then
  deallocate( tp2d_tape2_a6_2h )
endif
if (allocated(tp2d_tape2_dm_3h)) then
  deallocate( tp2d_tape2_dm_3h )
endif


end subroutine tp2d_tad


subroutine tpcc_tad( va, q, crx, im, jm, ng, iord, jord, fx, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_tad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h_tad(1+im+2*(im/3))
real(kind=r8) :: a6i_tad(1+im+2*(im/3))
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adxh_tad(im,jfirst-1:jlast+2)
real(kind=r8) :: dmh_tad(1+im+2*(im/3))
real(kind=r8) :: dmi_tad(1+im+2*(im/3))
real(kind=r8) :: fx1(im)
real(kind=r8) :: fxh_tad(im,jfirst:jlast)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qh_tad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qi(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmph_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_tad(1+im+2*(im/3))
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1h_tad(im)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
qi(:,:) = q(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6h_tad(:) = 0.d0
a6i_tad(:) = 0.d0
adxh_tad(:,:) = 0.d0
dmh_tad(:) = 0.d0
dmi_tad(:) = 0.d0
fxh_tad(:,:) = 0.d0
qh_tad(:,:) = 0.d0
qtmph_tad(:) = 0.d0
qtmpi_tad(:) = 0.d0
wk1h_tad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = jn1g0, js2g0, -1
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  a6 = tpcc2_tape_a6_1h(:,irec)
  dm = tpcc2_tape_dm_2h(:,irec)
  call xtp_tad( im,ffsl(j),fx(1,j),fxh_tad,adx(1,j),adxh_tad,crx(1,j),iord,crx(1,j),cose(j),0,dm,dmh_tad,qtmp,qtmph_tad,al,ar,a6,&
&a6h_tad )
end do
q(:,:) = qi(:,:)
do j = jn1gn, js2gs, -1
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  a6 = tpcc1_tape_a6_1h(:,irec)
  dm = tpcc1_tape_dm_2h(:,irec)
  call xtp_tad( im,ffsl(j),wk1,wk1h_tad,q(1,j),qh_tad,crx(1,j),1,crx(1,j),cose(j),0,dm,dmi_tad,qtmp,qtmpi_tad,al,ar,a6,a6i_tad )
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine tpcc_tad


subroutine tpccmd( va, ymass, q, crx, cry, im, jm, ng, iord, jord, fx, fy, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_tad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: fx1(im)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
integer :: south
real(kind=r8) :: wk1(im)

!**********************************************
! executable statements of routine
!**********************************************
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  if ( .not. allocated(tpcc1_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_a6_1h)) then
      allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc1_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_dm_2h)) then
      allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc( im,jm,fy,adx,cry,ymass,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  if ( .not. allocated(tpcc2_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_a6_1h)) then
      allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc2_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_dm_2h)) then
      allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),fx(1,j),adx(1,j),crx(1,j),iord,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
end do
end subroutine tpccmd


subroutine xmist_tad( im, q, q_tae, dm, dm_tad, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_tae(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_tad
double precision :: dmi_tad
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxh
double precision :: qmaxh_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminh
double precision :: qminh_tad
double precision :: qmini_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_tad = 0.d0
qmin_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmax_tad = 0.d0
    qmin_tad = 0.d0
    qmax = max(q(i-1),q(i),q(i+1))-q(i)
    qmin = q(i)-min(q(i-1),q(i),q(i+1))
    dmh = min(abs(dm(i)),qmax)
    dmi_tad = dm_tad(i)*sign(1.d0,min(dmh,qmin))*sign(1.d0,dm(i))
    dmh_tad = dmi_tad*(0.5+sign(0.5d0,qmin-dmh))
    qmin_tad = qmin_tad+dmi_tad*(0.5-sign(0.5d0,qmin-dmh))
    qmax_tad = qmax_tad+dmh_tad*(0.5-sign(0.5d0,qmax-abs(dm(i))))
    dm_tad(i) = dmh_tad*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))
    qminh = min(q(i-1),q(i))
    q_tae(i) = q_tae(i)+qmin_tad
    qmini_tad = -qmin_tad
    q_tae(i+1) = q_tae(i+1)+qmini_tad*(0.5-sign(0.5d0,q(i+1)-qminh))
    qminh_tad = qmini_tad*(0.5+sign(0.5d0,q(i+1)-qminh))
    q_tae(i-1) = q_tae(i-1)+qminh_tad*(0.5+sign(0.5d0,q(i)-q(i-1)))
    q_tae(i) = q_tae(i)+qminh_tad*(0.5-sign(0.5d0,q(i)-q(i-1)))
    qmin_tad = 0.d0
    qmaxh = max(q(i-1),q(i))
    q_tae(i) = q_tae(i)-qmax_tad
    q_tae(i+1) = q_tae(i+1)+qmax_tad*(0.5-sign(0.5d0,qmaxh-q(i+1)))
    qmaxh_tad = qmax_tad*(0.5+sign(0.5d0,qmaxh-q(i+1)))
    q_tae(i-1) = q_tae(i-1)+qmaxh_tad*(0.5+sign(0.5d0,q(i-1)-q(i)))
    q_tae(i) = q_tae(i)+qmaxh_tad*(0.5-sign(0.5d0,q(i-1)-q(i)))
    qmax_tad = 0.d0
  end do
endif
if (id .le. 2) then
  do i = 1, im
    q_tae(i-2) = q_tae(i-2)+dm_tad(i)*r24
    q_tae(i-1) = q_tae(i-1)-8*dm_tad(i)*r24
    q_tae(i+2) = q_tae(i+2)-dm_tad(i)*r24
    q_tae(i+1) = q_tae(i+1)+8*dm_tad(i)*r24
    dm_tad(i) = 0.d0
  end do
else
  do i = 1, im
    q_tae(i-1) = q_tae(i-1)-0.25*dm_tad(i)
    q_tae(i+1) = q_tae(i+1)+0.25*dm_tad(i)
    dm_tad(i) = 0.d0
  end do
endif

end subroutine xmist_tad


subroutine xtp_tad( im, ffsl, fx, fx_tad, q, q_tae, c, iord, mfx, cosa, id, dm, dm_tad, qtmp, qtmp_tad, al, ar, a6, a6_tad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_tad(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_tae(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_tad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h(-(im/3):im+im/3)
real(kind=r8) :: alh_tad(1+im+2*(im/3))
real(kind=r8) :: ali_tad(1+im+2*(im/3))
real(kind=r8) :: arh_tad(1+im+2*(im/3))
real(kind=r8) :: ari_tad(1+im+2*(im/3))
double precision :: dmh_tad
double precision :: dmi_tad
double precision :: dmj
double precision :: dmj_tad
real(kind=r8) :: dmk(-(im/3):im+im/3)
double precision :: dmk_tad
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxh
double precision :: qmaxh_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminh
double precision :: qminh_tad
double precision :: qmini_tad
real(kind=r8) :: rut
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmk(:) = dm(:)
a6h(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alh_tad(:) = 0.d0
ali_tad(:) = 0.d0
arh_tad(:) = 0.d0
ari_tad(:) = 0.d0
qmax_tad = 0.d0
qmin_tad = 0.d0
tmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm( im,c,mfx,qtmp,dm,fx,iord,al,ar,a6,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
        else
          itmp = i-iu-1
          isave(i) = itmp+1
        endif
      end do
    endif
  endif
  if (id .ne. 0) then
    do i = 1, im
      fx_tad(i) = fx_tad(i)*mfx(i)
    end do
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        qtmp_tad(ist) = qtmp_tad(ist)+fx_tad(i)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        qtmp_tad(ist) = qtmp_tad(ist)-fx_tad(i)
      end do
    endif
  end do
  a6(:) = a6h(:)
  dm(:) = dmk(:)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
      else
        itmp = i-iu-1
      endif
      qtmp_tad(itmp) = qtmp_tad(itmp)+fx_tad(i)*(c(i)-iu)
      fx_tad(i) = 0.d0
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_tad( im,c,mfx,qtmp,qtmp_tad,dm,dm_tad,fx_tad,iord,al,alh_tad,ar,arh_tad,a6,a6_tad,iuw,iue,ffsl )
    else
      do i = 1, im
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          dm_tad(itmp) = dm_tad(itmp)-fx_tad(i)*rut*(1+rut)
          qtmp_tad(itmp) = qtmp_tad(itmp)+fx_tad(i)*rut
          fx_tad(i) = 0.d0
        else
          itmp = i-iu-1
          dm_tad(itmp) = dm_tad(itmp)+fx_tad(i)*rut*(1.-rut)
          qtmp_tad(itmp) = qtmp_tad(itmp)+fx_tad(i)*rut
          fx_tad(i) = 0.d0
        endif
      end do
    endif
    do i = iue, imp, -1
      dmh_tad = dm_tad(i)
      dm_tad(i) = 0.d0
      dm_tad(i-im) = dm_tad(i-im)+dmh_tad
    end do
    do i = 0, iuw, -1
      dmi_tad = dm_tad(i)
      dm_tad(i) = 0.d0
      dm_tad(im+i) = dm_tad(im+i)+dmi_tad
    end do
    do i = 1, im
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dmj = min(abs(tmp),qmax)
      dmk_tad = dm_tad(i)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_tad = dmk_tad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_tad = qmin_tad+dmk_tad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_tad = qmax_tad+dmj_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmj_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i) = 0.d0
      qminh = min(qtmp(i-1),qtmp(i))
      qmini_tad = -qmin_tad
      qtmp_tad(i) = qtmp_tad(i)+qmin_tad
      qminh_tad = qmini_tad*(0.5+sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_tad(i+1) = qtmp_tad(i+1)+qmini_tad*(0.5-sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_tad(i-1) = qtmp_tad(i-1)+qminh_tad*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qtmp_tad(i) = qtmp_tad(i)+qminh_tad*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qmin_tad = 0.d0
      qmaxh = max(qtmp(i-1),qtmp(i))
      qtmp_tad(i) = qtmp_tad(i)-qmax_tad
      qmaxh_tad = qmax_tad*(0.5+sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_tad(i+1) = qtmp_tad(i+1)+qmax_tad*(0.5-sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_tad(i-1) = qtmp_tad(i-1)+qmaxh_tad*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qtmp_tad(i) = qtmp_tad(i)+qmaxh_tad*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qmax_tad = 0.d0
      qtmp_tad(i-1) = qtmp_tad(i-1)-0.25*tmp_tad
      qtmp_tad(i+1) = qtmp_tad(i+1)+0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
  do i = imp, iue
    q_tae(i-im) = q_tae(i-im)+qtmp_tad(i)
    qtmp_tad(i) = 0.d0
  end do
  do i = iuw, 0
    q_tae(im+i) = q_tae(im+i)+qtmp_tad(i)
    qtmp_tad(i) = 0.d0
  end do
else
  qtmp(imp) = q(1)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = float(i)-c(i)
      qtmp_tad(iu) = qtmp_tad(iu)+fx_tad(i)*mfx(i)
      fx_tad(i) = 0.d0
    end do
  else
    qtmp(-1) = q(im-1)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist( im,qtmp,dm,2 )
    else
      call xmist( im,qtmp,dm,iord )
    endif
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      do i = 1, im
        iu = float(i)-c(i)
        dm_tad(iu) = dm_tad(iu)+fx_tad(i)*mfx(i)*(sign(1.d0,c(i))-c(i))
        qtmp_tad(iu) = qtmp_tad(iu)+fx_tad(i)*mfx(i)
        fx_tad(i) = 0.d0
      end do
    else
      call fxppm_tad( im,c,mfx,qtmp,qtmp_tad,dm,dm_tad,fx_tad,iord,al,ali_tad,ar,ari_tad,a6,a6_tad,iuw,iue,ffsl )
    endif
    dm_tad(im) = dm_tad(im)+dm_tad(0)
    dm_tad(0) = 0.d0
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_tad( im,qtmp,qtmp_tad,dm,dm_tad,2 )
    else
      call xmist_tad( im,qtmp,qtmp_tad,dm,dm_tad,iord )
    endif
    q_tae(2) = q_tae(2)+qtmp_tad(imp+1)
    qtmp_tad(imp+1) = 0.d0
    q_tae(im-1) = q_tae(im-1)+qtmp_tad(-1)
    qtmp_tad(-1) = 0.d0
  endif
  q_tae(im) = q_tae(im)+qtmp_tad(0)
  qtmp_tad(0) = 0.d0
  q_tae(1) = q_tae(1)+qtmp_tad(imp)
  qtmp_tad(imp) = 0.d0
endif
do i = 1, im
  q_tae(i) = q_tae(i)+qtmp_tad(i)
  qtmp_tad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine xtp_tad


subroutine ymist_tad( im, jm, q, q_tae, dm, dm_tad, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tad(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_tad
double precision :: dmi_tad
double precision :: dmi_tae
double precision :: dmj
double precision :: dmj_tad
double precision :: dmk_tad
double precision :: dmk_tae
double precision :: dml
double precision :: dml_tad
double precision :: dmm_tad
double precision :: dmm_tae
double precision :: dmn
double precision :: dmn_tad
double precision :: dmo_tad
double precision :: dmo_tae
double precision :: dmp
double precision :: dmp_tad
double precision :: dmq_tad
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxh
double precision :: qmaxh_tad
double precision :: qmaxj
double precision :: qmaxj_tad
double precision :: qmaxl
double precision :: qmaxl_tad
double precision :: qmaxn
double precision :: qmaxn_tad
double precision :: qmaxp
double precision :: qmaxp_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminh
double precision :: qminh_tad
double precision :: qmini_tad
double precision :: qminj
double precision :: qminj_tad
double precision :: qmink_tad
double precision :: qminl
double precision :: qminl_tad
double precision :: qminm_tad
double precision :: qminn
double precision :: qminn_tad
double precision :: qmino_tad
double precision :: qminp
double precision :: qminp_tad
double precision :: qminq_tad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_tad = 0.d0
qmin_tad = 0.d0
tmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    qmax_tad = 0.d0
    qmin_tad = 0.d0
    do i = 1, im
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
      qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
      dmh = min(abs(dm(i,j)),qmin)
      dmi_tad = dm_tad(i,j)*sign(1.d0,min(dmh,qmax))*sign(1.d0,dm(i,j))
      dmh_tad = dmi_tad*(0.5+sign(0.5d0,qmax-dmh))
      qmax_tad = qmax_tad+dmi_tad*(0.5-sign(0.5d0,qmax-dmh))
      qmin_tad = qmin_tad+dmh_tad*(0.5-sign(0.5d0,qmin-abs(dm(i,j))))
      dm_tad(i,j) = dmh_tad*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))
      qminh = min(q(i,j-1),q(i,j))
      q_tae(i,j) = q_tae(i,j)+qmin_tad
      qmini_tad = -qmin_tad
      q_tae(i,j+1) = q_tae(i,j+1)+qmini_tad*(0.5-sign(0.5d0,q(i,j+1)-qminh))
      qminh_tad = qmini_tad*(0.5+sign(0.5d0,q(i,j+1)-qminh))
      q_tae(i,j-1) = q_tae(i,j-1)+qminh_tad*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))
      q_tae(i,j) = q_tae(i,j)+qminh_tad*(0.5-sign(0.5d0,q(i,j)-q(i,j-1)))
      qmin_tad = 0.d0
      qmaxh = max(q(i,j-1),q(i,j))
      q_tae(i,j) = q_tae(i,j)-qmax_tad
      q_tae(i,j+1) = q_tae(i,j+1)+qmax_tad*(0.5-sign(0.5d0,qmaxh-q(i,j+1)))
      qmaxh_tad = qmax_tad*(0.5+sign(0.5d0,qmaxh-q(i,j+1)))
      q_tae(i,j-1) = q_tae(i,j-1)+qmaxh_tad*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))
      q_tae(i,j) = q_tae(i,j)+qmaxh_tad*(0.5-sign(0.5d0,q(i,j-1)-q(i,j)))
      qmax_tad = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmi_tae = dm_tad(i,jm)
      dm_tad(i,jm) = 0.d0
      dm_tad(i-im2,jm) = dm_tad(i-im2,jm)-dmi_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmj = min(abs(tmp),qmax)
      dmk_tad = dm_tad(i,jm)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_tad = dmk_tad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_tad = qmin_tad+dmk_tad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_tad = qmax_tad+dmj_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmj_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,jm) = 0.d0
      qminj = min(q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)+qmin_tad
      qmink_tad = -qmin_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmink_tad*(0.5-sign(0.5d0,q(i,jm1)-qminj))
      qminj_tad = qmink_tad*(0.5+sign(0.5d0,q(i,jm1)-qminj))
      q_tae(i,jm) = q_tae(i,jm)+qminj_tad*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)+qminj_tad*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      qmin_tad = 0.d0
      qmaxj = max(q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)-qmax_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmax_tad*(0.5-sign(0.5d0,qmaxj-q(i,jm1)))
      qmaxj_tad = qmax_tad*(0.5+sign(0.5d0,qmaxj-q(i,jm1)))
      q_tae(i,jm) = q_tae(i,jm)+qmaxj_tad*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)+qmaxj_tad*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      qmax_tad = 0.d0
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)+0.25*tmp_tad
      q_tae(i,jm1) = q_tae(i,jm1)-0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmk_tae = dm_tad(i,1)
      dm_tad(i,1) = 0.d0
      dm_tad(i-im2,1) = dm_tad(i-im2,1)-dmk_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dml = min(abs(tmp),qmax)
      dmm_tad = dm_tad(i,1)*sign(1.d0,min(dml,qmin))*sign(1.d0,tmp)
      dml_tad = dmm_tad*(0.5+sign(0.5d0,qmin-dml))
      qmin_tad = qmin_tad+dmm_tad*(0.5-sign(0.5d0,qmin-dml))
      qmax_tad = qmax_tad+dml_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dml_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,1) = 0.d0
      qminl = min(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)+qmin_tad
      qminm_tad = -qmin_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)+qminm_tad*(0.5-sign(0.5d0,q(i+im2,2)-qminl))
      qminl_tad = qminm_tad*(0.5+sign(0.5d0,q(i+im2,2)-qminl))
      q_tae(i,2) = q_tae(i,2)+qminl_tad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_tae(i,1) = q_tae(i,1)+qminl_tad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_tad = 0.d0
      qmaxl = max(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)-qmax_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)+qmax_tad*(0.5-sign(0.5d0,qmaxl-q(i+im2,2)))
      qmaxl_tad = qmax_tad*(0.5+sign(0.5d0,qmaxl-q(i+im2,2)))
      q_tae(i,2) = q_tae(i,2)+qmaxl_tad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_tae(i,1) = q_tae(i,1)+qmaxl_tad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_tad = 0.d0
      q_tae(i+im2,2) = q_tae(i+im2,2)-0.25*tmp_tad
      q_tae(i,2) = q_tae(i,2)+0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmm_tae = dm_tad(i,jm)
      dm_tad(i,jm) = 0.d0
      dm_tad(i-im2,jm) = dm_tad(i-im2,jm)+dmm_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmn = min(abs(tmp),qmax)
      dmo_tad = dm_tad(i,jm)*sign(1.d0,min(dmn,qmin))*sign(1.d0,tmp)
      dmn_tad = dmo_tad*(0.5+sign(0.5d0,qmin-dmn))
      qmin_tad = qmin_tad+dmo_tad*(0.5-sign(0.5d0,qmin-dmn))
      qmax_tad = qmax_tad+dmn_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmn_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,jm) = 0.d0
      qminn = min(-q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)+qmin_tad
      qmino_tad = -qmin_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmino_tad*(0.5-sign(0.5d0,q(i,jm1)-qminn))
      qminn_tad = qmino_tad*(0.5+sign(0.5d0,q(i,jm1)-qminn))
      q_tae(i,jm) = q_tae(i,jm)+qminn_tad*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)-qminn_tad*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      qmin_tad = 0.d0
      qmaxn = max(-q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)-qmax_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmax_tad*(0.5-sign(0.5d0,qmaxn-q(i,jm1)))
      qmaxn_tad = qmax_tad*(0.5+sign(0.5d0,qmaxn-q(i,jm1)))
      q_tae(i,jm) = q_tae(i,jm)+qmaxn_tad*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)-qmaxn_tad*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      qmax_tad = 0.d0
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)-0.25*tmp_tad
      q_tae(i,jm1) = q_tae(i,jm1)-0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmo_tae = dm_tad(i,1)
      dm_tad(i,1) = 0.d0
      dm_tad(i-im2,1) = dm_tad(i-im2,1)+dmo_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dmp = min(abs(tmp),qmax)
      dmq_tad = dm_tad(i,1)*sign(1.d0,min(dmp,qmin))*sign(1.d0,tmp)
      dmp_tad = dmq_tad*(0.5+sign(0.5d0,qmin-dmp))
      qmin_tad = qmin_tad+dmq_tad*(0.5-sign(0.5d0,qmin-dmp))
      qmax_tad = qmax_tad+dmp_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmp_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,1) = 0.d0
      qminp = min(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)+qmin_tad
      qminq_tad = -qmin_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)-qminq_tad*(0.5-sign(0.5d0,(-q(i+im2,2))-qminp))
      qminp_tad = qminq_tad*(0.5+sign(0.5d0,(-q(i+im2,2))-qminp))
      q_tae(i,2) = q_tae(i,2)+qminp_tad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_tae(i,1) = q_tae(i,1)+qminp_tad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_tad = 0.d0
      qmaxp = max(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)-qmax_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)-qmax_tad*(0.5-sign(0.5d0,qmaxp-(-q(i+im2,2))))
      qmaxp_tad = qmax_tad*(0.5+sign(0.5d0,qmaxp-(-q(i+im2,2))))
      q_tae(i,2) = q_tae(i,2)+qmaxp_tad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_tae(i,1) = q_tae(i,1)+qmaxp_tad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_tad = 0.d0
      q_tae(i+im2,2) = q_tae(i+im2,2)+0.25*tmp_tad
      q_tae(i,2) = q_tae(i,2)+0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
endif
do j = js2gng1, jn2gng1
  do i = 1, im
    q_tae(i,j-1) = q_tae(i,j-1)-0.25*dm_tad(i,j)
    q_tae(i,j+1) = q_tae(i,j+1)+0.25*dm_tad(i,j)
    dm_tad(i,j) = 0.d0
  end do
end do

end subroutine ymist_tad


subroutine ytp_tad( im, jm, fy_tad, q, q_tae, c, yfx, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: fy_tad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tad(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dm_tad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
do j = js2g0, jn1g1
  do i = 1, im
    fy_tad(i,j) = fy_tad(i,j)*yfx(i,j)
  end do
end do
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      q_tae(i,jt) = q_tae(i,jt)+fy_tad(i,j)
      fy_tad(i,j) = 0.d0
    end do
  end do
else
  call ymist( im,jm,q,dm,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm_tad( c,q,q_tae,dm,dm_tad,fy_tad,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        dm_tad(i,jt) = dm_tad(i,jt)+fy_tad(i,j)*(sign(1.d0,c(i,j))-c(i,j))
        q_tae(i,jt) = q_tae(i,jt)+fy_tad(i,j)
        fy_tad(i,j) = 0.d0
      end do
    end do
  endif
  call ymist_tad( im,jm,q,q_tae,dm,dm_tad,ng,jord,iv,jfirst,jlast )
endif

end subroutine ytp_tad


end module     tp_core_tad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tpcc_tad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: tpcc1_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc1_tape_dm_2h(:,:)
integer :: tpcc1_tape_tpcc
real(kind=8), allocatable :: tpcc2_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc2_tape_dm_2h(:,:)
integer :: tpcc2_tape_tpcc

end module     tpcc_tad_store


module     tp_core_tad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_tad( im, c, mfx, p, p_tad, dm, dm_tad, fx_tad, iord, al, al_tad, ar, ar_tad, a6, a6_tad, iuw, iue, ffsl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_tad(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_tad(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx_tad(im)
integer :: iord
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: a6h_tad
double precision :: a6i_tad
double precision :: alh_tad
double precision :: ali_tad
double precision :: arh_tad
double precision :: ari_tad
real(kind=r8) :: dmh(-(im/3):im+im/3)
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
logical :: steep

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmh(:) = dm(:)

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx( im,p,al(1),dm )
endif
do i = 1, im-1
  ar(i) = al(i+1)
end do
ar(im) = al(1)
if (ffsl) then
  do i = 1, im
    iu = c(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      a6_tad(itmp) = a6_tad(itmp)+0.5*fx_tad(i)*ru*ru*(1.-r23*ru)
      al_tad(itmp) = al_tad(itmp)+0.5*fx_tad(i)*ru*ru
      ar_tad(itmp) = ar_tad(itmp)+fx_tad(i)*ru*(1+(-0.5)*ru)
      fx_tad(i) = 0.d0
    else
      itmp = i-iu
      a6_tad(itmp) = a6_tad(itmp)-0.5*fx_tad(i)*ru*ru*(1+r23*ru)
      al_tad(itmp) = al_tad(itmp)+fx_tad(i)*ru*(1-(-0.5)*ru)
      ar_tad(itmp) = ar_tad(itmp)-0.5*fx_tad(i)*ru*ru
      fx_tad(i) = 0.d0
    endif
  end do
  do i = iue, im+1, -1
    a6h_tad = a6_tad(i)
    a6_tad(i) = 0.d0
    a6_tad(i-im) = a6_tad(i-im)+a6h_tad
    arh_tad = ar_tad(i)
    ar_tad(i) = 0.d0
    ar_tad(i-im) = ar_tad(i-im)+arh_tad
    alh_tad = al_tad(i)
    al_tad(i) = 0.d0
    al_tad(i-im) = al_tad(i-im)+alh_tad
  end do
  do i = 0, iuw, -1
    a6i_tad = a6_tad(i)
    a6_tad(i) = 0.d0
    a6_tad(im+i) = a6_tad(im+i)+a6i_tad
    ari_tad = ar_tad(i)
    ar_tad(i) = 0.d0
    ar_tad(im+i) = ar_tad(im+i)+ari_tad
    ali_tad = al_tad(i)
    al_tad(i) = 0.d0
    al_tad(im+i) = al_tad(im+i)+ali_tad
  end do
else
  do i = 1, im
    fx_tad(i) = fx_tad(i)*mfx(i)
    if (c(i) .gt. 0.) then
      a6_tad(i-1) = a6_tad(i-1)+0.5*fx_tad(i)*c(i)*(1.-r23*c(i))
      al_tad(i-1) = al_tad(i-1)+0.5*fx_tad(i)*c(i)
      ar_tad(i-1) = ar_tad(i-1)+fx_tad(i)*(1+(-0.5)*c(i))
      fx_tad(i) = 0.d0
    else
      a6_tad(i) = a6_tad(i)-0.5*fx_tad(i)*c(i)*(1+r23*c(i))
      al_tad(i) = al_tad(i)+fx_tad(i)*(1-(-0.5)*c(i))
      ar_tad(i) = ar_tad(i)-0.5*fx_tad(i)*c(i)
      fx_tad(i) = 0.d0
    endif
  end do
  a6_tad(im) = a6_tad(im)+a6_tad(0)
  a6_tad(0) = 0.d0
  ar_tad(im) = ar_tad(im)+ar_tad(0)
  ar_tad(0) = 0.d0
  al_tad(im) = al_tad(im)+al_tad(0)
  al_tad(0) = 0.d0
endif
if (iord .eq. 7) then
  call huynh_tad( im,ar(1),ar_tad(1),al(1),al_tad(1),p(1),p_tad(1),a6(1),a6_tad(1),dm(1),dm_tad(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm_tad( dm(1),dm_tad(1),a6(1),a6_tad(1),ar(1),ar_tad(1),al(1),al_tad(1),p(1),p_tad(1),im,lmt )
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      al_tad(i) = al_tad(i)-3*a6_tad(i)
      ar_tad(i) = ar_tad(i)-3*a6_tad(i)
      p_tad(i) = p_tad(i)+6*a6_tad(i)
      a6_tad(i) = 0.d0
    end do
  endif
endif
al_tad(1) = al_tad(1)+ar_tad(im)
ar_tad(im) = 0.d0
do i = 1, im-1
  al_tad(i+1) = al_tad(i+1)+ar_tad(i)
  ar_tad(i) = 0.d0
end do
dm(:) = dmh(:)
if (steep) then
  call steepx_tad( im,p,p_tad,al_tad(1),dm,dm_tad )
endif
do i = 1, im
  dm_tad(i-1) = dm_tad(i-1)+al_tad(i)*r3
  dm_tad(i) = dm_tad(i)-al_tad(i)*r3
  p_tad(i-1) = p_tad(i-1)+0.5*al_tad(i)
  p_tad(i) = p_tad(i)+0.5*al_tad(i)
  al_tad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine fxppm_tad


subroutine fyppm_tad( c, q, q_tae, dm, dm_tad, flux_tad, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux_tad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_tad(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_tad(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_tad(im,jfirst-1:jlast+1)
double precision :: arh_tad
double precision :: ari_tad
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_tad(:,:) = 0.d0
al_tad(:,:) = 0.d0
ar_tad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = al(i+imh,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = ar(i+imh,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = -al(i+imh,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = -ar(i+imh,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      a6_tad(i,j-1) = a6_tad(i,j-1)+0.5*flux_tad(i,j)*c(i,j)*(1.-r23*c(i,j))
      al_tad(i,j-1) = al_tad(i,j-1)+0.5*flux_tad(i,j)*c(i,j)
      ar_tad(i,j-1) = ar_tad(i,j-1)+flux_tad(i,j)*(1+(-0.5)*c(i,j))
      flux_tad(i,j) = 0.d0
    else
      a6_tad(i,j) = a6_tad(i,j)-0.5*flux_tad(i,j)*c(i,j)*(1+r23*c(i,j))
      al_tad(i,j) = al_tad(i,j)+flux_tad(i,j)*(1-(-0.5)*c(i,j))
      ar_tad(i,j) = ar_tad(i,j)-0.5*flux_tad(i,j)*c(i,j)
      flux_tad(i,j) = 0.d0
    endif
  end do
end do
call lmppm_tad( dm(1,js1g1),dm_tad(1,js1g1),a6(1,js1g1),a6_tad(1,js1g1),ar(1,js1g1),ar_tad(1,js1g1),al(1,js1g1),al_tad(1,js1g1),&
&q(1,js1g1),q_tae(1,js1g1),help_h,lmt )
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      al_tad(i,j) = al_tad(i,j)-3*a6_tad(i,j)
      ar_tad(i,j) = ar_tad(i,j)-3*a6_tad(i,j)
      q_tae(i,j) = q_tae(i,j)+6*a6_tad(i,j)
      a6_tad(i,j) = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_tad(i,jm1) = ar_tad(i,jm1)+ar_tad(i+imh,jm)
      ar_tad(i+imh,jm) = 0.d0
      arh_tad = ar_tad(i,jm)
      ar_tad(i,jm) = 0.d0
      ar_tad(i+imh,jm1) = ar_tad(i+imh,jm1)+arh_tad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tad(i,2) = al_tad(i,2)+al_tad(i+imh,1)
      al_tad(i+imh,1) = 0.d0
      al_tad(i+imh,2) = al_tad(i+imh,2)+al_tad(i,1)
      al_tad(i,1) = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_tad(i,jm1) = ar_tad(i,jm1)-ar_tad(i+imh,jm)
      ar_tad(i+imh,jm) = 0.d0
      ari_tad = ar_tad(i,jm)
      ar_tad(i,jm) = 0.d0
      ar_tad(i+imh,jm1) = ar_tad(i+imh,jm1)-ari_tad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_tad(i,2) = al_tad(i,2)-al_tad(i+imh,1)
      al_tad(i+imh,1) = 0.d0
      al_tad(i+imh,2) = al_tad(i+imh,2)-al_tad(i,1)
      al_tad(i,1) = 0.d0
    end do
  endif
endif
do j = js1g1, jn2g1
  do i = 1, im
    al_tad(i,j+1) = al_tad(i,j+1)+ar_tad(i,j)
    ar_tad(i,j) = 0.d0
  end do
end do
do j = js2g1, jn1g2
  do i = 1, im
    dm_tad(i,j-1) = dm_tad(i,j-1)+al_tad(i,j)*r3
    dm_tad(i,j) = dm_tad(i,j)-al_tad(i,j)*r3
    q_tae(i,j-1) = q_tae(i,j-1)+0.5*al_tad(i,j)
    q_tae(i,j) = q_tae(i,j)+0.5*al_tad(i,j)
    al_tad(i,j) = 0.d0
  end do
end do

end subroutine fyppm_tad


subroutine huynh_tad( im, ar, ar_tad, al, al_tad, p, p_tad, d2, d2_tad, d1, d1_tad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_tad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tad(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_tad(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_tad(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_tad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh(im)
real(kind=r8) :: arh(im)
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_tad
real(kind=r8) :: pmax
real(kind=r8) :: pmax_tad
real(kind=r8) :: pmin
real(kind=r8) :: pmin_tad
real(kind=r8) :: pmp
real(kind=r8) :: pmp_tad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
arh(:) = ar(:)
alh(:) = al(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
lac_tad = 0.d0
pmax_tad = 0.d0
pmin_tad = 0.d0
pmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
d1(1) = p(1)-p(im)
do i = 2, im
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2(i) = d1(i+1)-d1(i)
end do
d2(im) = d1(1)-d1(im)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
ar(1) = min(pmax,max(ar(1),pmin))
do i = 1, im-1
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp = p(im)-2.*d1(1)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin = min(p(im),pmp,lac)
pmax = max(p(im),pmp,lac)
do i = 1, im
  al_tad(i) = al_tad(i)-3*d2_tad(i)
  ar_tad(i) = ar_tad(i)-3*d2_tad(i)
  p_tad(i) = p_tad(i)+6*d2_tad(i)
  d2_tad(i) = 0.d0
end do
pmax_tad = pmax_tad+al_tad(im)*(0.5+sign(0.5d0,max(al(im),pmin)-pmax))
pmin_tad = pmin_tad+al_tad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al_tad(im) = al_tad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))
p_tad(im) = p_tad(im)+pmax_tad*(0.5+sign(0.5d0,p(im)-pmp))
pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(im)-pmp))
pmax_tad = 0.d0
p_tad(im) = p_tad(im)+pmin_tad*(0.5+sign(0.5d0,pmp-p(im)))
pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(im)))
pmin_tad = 0.d0
d1_tad(1) = d1_tad(1)-0.5*lac_tad
d2_tad(1) = d2_tad(1)+1.5*lac_tad
p_tad(im) = p_tad(im)+lac_tad
lac_tad = 0.d0
d1_tad(1) = d1_tad(1)-2*pmp_tad
p_tad(im) = p_tad(im)+pmp_tad
pmp_tad = 0.d0
al(:) = alh(:)
do i = 1, im-1
  lac_tad = 0.d0
  pmax_tad = 0.d0
  pmin_tad = 0.d0
  pmp_tad = 0.d0
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_tad = pmax_tad+al_tad(i)*(0.5+sign(0.5d0,max(al(i),pmin)-pmax))
  pmin_tad = pmin_tad+al_tad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al_tad(i) = al_tad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))
  p_tad(i) = p_tad(i)+pmax_tad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_tad = 0.d0
  p_tad(i) = p_tad(i)+pmin_tad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_tad = 0.d0
  d1_tad(i+1) = d1_tad(i+1)-0.5*lac_tad
  d2_tad(i+1) = d2_tad(i+1)+1.5*lac_tad
  p_tad(i) = p_tad(i)+lac_tad
  lac_tad = 0.d0
  d1_tad(i+1) = d1_tad(i+1)-2*pmp_tad
  p_tad(i) = p_tad(i)+pmp_tad
  pmp_tad = 0.d0
end do
do i = 2, im
  lac_tad = 0.d0
  pmax_tad = 0.d0
  pmin_tad = 0.d0
  pmp_tad = 0.d0
  pmp = p(i)+2.*d1(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_tad = pmax_tad+ar_tad(i)*(0.5+sign(0.5d0,max(ar(i),pmin)-pmax))
  pmin_tad = pmin_tad+ar_tad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar_tad(i) = ar_tad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))
  p_tad(i) = p_tad(i)+pmax_tad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_tad = 0.d0
  p_tad(i) = p_tad(i)+pmin_tad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_tad = 0.d0
  d1_tad(i) = d1_tad(i)+0.5*lac_tad
  d2_tad(i-1) = d2_tad(i-1)+1.5*lac_tad
  p_tad(i) = p_tad(i)+lac_tad
  lac_tad = 0.d0
  d1_tad(i) = d1_tad(i)+2*pmp_tad
  p_tad(i) = p_tad(i)+pmp_tad
  pmp_tad = 0.d0
end do
ar(:) = arh(:)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
pmax_tad = pmax_tad+ar_tad(1)*(0.5+sign(0.5d0,max(ar(1),pmin)-pmax))
pmin_tad = pmin_tad+ar_tad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar_tad(1) = ar_tad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))
pmp = p(1)+2.*d1(1)
p_tad(1) = p_tad(1)+pmax_tad*(0.5+sign(0.5d0,p(1)-pmp))
pmp_tad = pmp_tad+pmax_tad*(0.5-sign(0.5d0,p(1)-pmp))
pmax_tad = 0.d0
pmp = p(1)+2.*d1(1)
p_tad(1) = p_tad(1)+pmin_tad*(0.5+sign(0.5d0,pmp-p(1)))
pmp_tad = pmp_tad+pmin_tad*(0.5-sign(0.5d0,pmp-p(1)))
pmin_tad = 0.d0
d1_tad(1) = d1_tad(1)+0.5*lac_tad
d2_tad(im) = d2_tad(im)+1.5*lac_tad
p_tad(1) = p_tad(1)+lac_tad
lac_tad = 0.d0
d1_tad(1) = d1_tad(1)+2*pmp_tad
p_tad(1) = p_tad(1)+pmp_tad
pmp_tad = 0.d0
d1_tad(im) = d1_tad(im)-d2_tad(im)
d1_tad(1) = d1_tad(1)+d2_tad(im)
d2_tad(im) = 0.d0
do i = 1, im-1
  d1_tad(i+1) = d1_tad(i+1)+d2_tad(i)
  d1_tad(i) = d1_tad(i)-d2_tad(i)
  d2_tad(i) = 0.d0
end do
do i = 2, im
  p_tad(i-1) = p_tad(i-1)-d1_tad(i)
  p_tad(i) = p_tad(i)+d1_tad(i)
  d1_tad(i) = 0.d0
end do
p_tad(im) = p_tad(im)-d1_tad(1)
p_tad(1) = p_tad(1)+d1_tad(1)
d1_tad(1) = 0.d0

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine huynh_tad


subroutine lmppm_tad( dm, dm_tad, a6, a6_tad, ar, ar_tad, al, al_tad, p, p_tad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_tad(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_tad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_tad(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_tad(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_tad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_tad
real(kind=r8) :: da1
real(kind=r8) :: da1_tad
real(kind=r8) :: da2
real(kind=r8) :: da2_tad
real(kind=r8) :: dl_tad
real(kind=r8) :: dr_tad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_tad
integer :: i

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_tad = 0.d0
da1_tad = 0.d0
da2_tad = 0.d0
dl_tad = 0.d0
dr_tad = 0.d0
fmin_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    a6da_tad = 0.d0
    da1_tad = 0.d0
    da2_tad = 0.d0
    if (dm(i) .eq. 0.) then
      a6_tad(i) = 0.d0
      p_tad(i) = p_tad(i)+al_tad(i)
      al_tad(i) = 0.d0
      p_tad(i) = p_tad(i)+ar_tad(i)
      ar_tad(i) = 0.d0
    else
      da1 = ar(i)-al(i)
      da2 = da1**2
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_tad(i) = a6_tad(i)-ar_tad(i)
        al_tad(i) = al_tad(i)+ar_tad(i)
        ar_tad(i) = 0.d0
        al_tad(i) = al_tad(i)+3*a6_tad(i)
        p_tad(i) = p_tad(i)-3*a6_tad(i)
        a6_tad(i) = 0.d0
      else if (a6da .gt. da2) then
        a6_tad(i) = a6_tad(i)-al_tad(i)
        ar_tad(i) = ar_tad(i)+al_tad(i)
        al_tad(i) = 0.d0
        ar_tad(i) = ar_tad(i)+3*a6_tad(i)
        p_tad(i) = p_tad(i)-3*a6_tad(i)
        a6_tad(i) = 0.d0
      endif
      a6_tad(i) = a6_tad(i)+a6da_tad*da1
      da1_tad = da1_tad+a6da_tad*a6(i)
      a6da_tad = 0.d0
      da1_tad = da1_tad+2*da2_tad*da1
      da2_tad = 0.d0
      al_tad(i) = al_tad(i)-da1_tad
      ar_tad(i) = ar_tad(i)+da1_tad
      da1_tad = 0.d0
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_tad = 0.d0
      dl_tad = 0.d0
      dr_tad = 0.d0
      da1 = dm(i)+dm(i)
      dl_tad = dl_tad+3*a6_tad(i)
      dr_tad = dr_tad-3*a6_tad(i)
      a6_tad(i) = 0.d0
      dl_tad = dl_tad-al_tad(i)
      p_tad(i) = p_tad(i)+al_tad(i)
      al_tad(i) = 0.d0
      dr_tad = dr_tad+ar_tad(i)
      p_tad(i) = p_tad(i)+ar_tad(i)
      ar_tad(i) = 0.d0
      ar_tad(i) = ar_tad(i)+dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      da1_tad = da1_tad+dr_tad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
      p_tad(i) = p_tad(i)-dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      dr_tad = 0.d0
      al_tad(i) = al_tad(i)+dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      da1_tad = da1_tad+dl_tad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
      p_tad(i) = p_tad(i)-dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      dl_tad = 0.d0
      dm_tad(i) = dm_tad(i)+2*da1_tad
      da1_tad = 0.d0
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im-1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar(i) = p(i)
              al(i) = p(i)
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6(i) = 3.*(al(i)-p(i))
              ar(i) = al(i)-a6(i)
            else
              a6(i) = 3.*(ar(i)-p(i))
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
      do i = im, 1, -1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              a6_tad(i) = 0.d0
              p_tad(i) = p_tad(i)+al_tad(i)
              al_tad(i) = 0.d0
              p_tad(i) = p_tad(i)+ar_tad(i)
              ar_tad(i) = 0.d0
            else if (ar(i) .gt. al(i)) then
              a6_tad(i) = a6_tad(i)-ar_tad(i)
              al_tad(i) = al_tad(i)+ar_tad(i)
              ar_tad(i) = 0.d0
              al_tad(i) = al_tad(i)+3*a6_tad(i)
              p_tad(i) = p_tad(i)-3*a6_tad(i)
              a6_tad(i) = 0.d0
            else
              a6_tad(i) = a6_tad(i)-al_tad(i)
              ar_tad(i) = ar_tad(i)+al_tad(i)
              al_tad(i) = 0.d0
              ar_tad(i) = ar_tad(i)+3*a6_tad(i)
              p_tad(i) = p_tad(i)-3*a6_tad(i)
              a6_tad(i) = 0.d0
            endif
          endif
          a6_tad(i) = a6_tad(i)+fmin_tad*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)
          al_tad(i) = al_tad(i)+fmin_tad*((-0.5)*(ar(i)-al(i))/a6(i))
          ar_tad(i) = ar_tad(i)+fmin_tad*(0.5*(ar(i)-al(i))/a6(i))
          p_tad(i) = p_tad(i)+fmin_tad
          fmin_tad = 0.d0
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_tad = 0.d0
          dl_tad = 0.d0
          dr_tad = 0.d0
          da1 = 4.*dm(i)
          dl_tad = dl_tad+3*a6_tad(i)
          dr_tad = dr_tad-3*a6_tad(i)
          a6_tad(i) = 0.d0
          dl_tad = dl_tad-al_tad(i)
          p_tad(i) = p_tad(i)+al_tad(i)
          al_tad(i) = 0.d0
          dr_tad = dr_tad+ar_tad(i)
          p_tad(i) = p_tad(i)+ar_tad(i)
          ar_tad(i) = 0.d0
          ar_tad(i) = ar_tad(i)+dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          da1_tad = da1_tad+dr_tad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
          p_tad(i) = p_tad(i)-dr_tad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          dr_tad = 0.d0
          al_tad(i) = al_tad(i)+dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          da1_tad = da1_tad+dl_tad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
          p_tad(i) = p_tad(i)-dl_tad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          dl_tad = 0.d0
          dm_tad(i) = dm_tad(i)+4*da1_tad
          da1_tad = 0.d0
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_tad


subroutine steepx_tad( im, p, p_tad, al_tad, dm, dm_tad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al_tad(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_tad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb_tad
real(kind=r8) :: ccc_tad
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_tad(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_tad(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_tad(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
bbb_tad = 0.d0
ccc_tad = 0.d0
d2_tad(:) = 0.d0
dh_tad(:) = 0.d0
eta_tad(:) = 0.d0
xxx_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do i = 0, im
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2(i) = dh(i)-dh(i-1)
end do
d2(0) = d2(im)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta(i) = 0.
  endif
end do
eta(0) = eta(im)
do i = 1, im
  bbb_tad = 0.d0
  ccc_tad = 0.d0
  bbb_tad = bbb_tad+al_tad(i)*r3
  ccc_tad = ccc_tad-al_tad(i)*r3
  dh_tad(i-1) = dh_tad(i-1)+0.5*al_tad(i)*(eta(i-1)-eta(i))
  eta_tad(i-1) = eta_tad(i-1)+0.5*al_tad(i)*dh(i-1)
  eta_tad(i) = eta_tad(i)-0.5*al_tad(i)*dh(i-1)
  dm_tad(i) = dm_tad(i)+ccc_tad*(2.*eta(i-1)-eta(i))
  eta_tad(i-1) = eta_tad(i-1)+2*ccc_tad*dm(i)
  eta_tad(i) = eta_tad(i)-ccc_tad*dm(i)
  ccc_tad = 0.d0
  dm_tad(i-1) = dm_tad(i-1)+bbb_tad*(2.*eta(i)-eta(i-1))
  eta_tad(i-1) = eta_tad(i-1)-bbb_tad*dm(i-1)
  eta_tad(i) = eta_tad(i)+2*bbb_tad*dm(i-1)
  bbb_tad = 0.d0
end do
eta_tad(im) = eta_tad(im)+eta_tad(0)
eta_tad(0) = 0.d0
do i = 1, im
  xxx_tad = 0.d0
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    xxx_tad = xxx_tad+eta_tad(i)*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta_tad(i) = 0.d0
    p_tad(i-2) = p_tad(i-2)-xxx_tad*((-0.5)/(p(i+1)-p(i-1)))
    p_tad(i-1) = p_tad(i-1)+xxx_tad*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    p_tad(i+2) = p_tad(i+2)-xxx_tad*(0.5/(p(i+1)-p(i-1)))
    p_tad(i+1) = p_tad(i+1)+xxx_tad*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx_tad = 0.d0
  else
    eta_tad(i) = 0.d0
  endif
end do
d2_tad(1) = d2_tad(1)+d2_tad(im+1)
d2_tad(im+1) = 0.d0
d2_tad(im) = d2_tad(im)+d2_tad(0)
d2_tad(0) = 0.d0
do i = 1, im
  dh_tad(i-1) = dh_tad(i-1)-d2_tad(i)
  dh_tad(i) = dh_tad(i)+d2_tad(i)
  d2_tad(i) = 0.d0
end do
do i = 0, im
  p_tad(i+1) = p_tad(i+1)+dh_tad(i)
  p_tad(i) = p_tad(i)-dh_tad(i)
  dh_tad(i) = 0.d0
end do

end subroutine steepx_tad


subroutine tp2c_tad( dh_tad, va, h, h_tad, crx, cry, im, jm, iord, jord, ng, fx, fx_tad, fy_tad, ffsl, rcap, acosp, xfx, yfx, cosp,&
& id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: dh_tad(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tad(im,jfirst:jlast)
real(kind=r8) :: fy_tad(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_tad(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
sum1_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
if (jlast .eq. jm) then
  do i = 1, im
    sum1_tad = sum1_tad+dh_tad(i,jm)
    dh_tad(i,jm) = 0.d0
  end do
  sum1_tad = sum1_tad*rcap
  do i = 1, im
    fy_tad(i,jm) = fy_tad(i,jm)+sum1_tad
  end do
  sum1_tad = 0.d0
endif
if (jfirst .eq. 1) then
  do i = 1, im
    sum1_tad = sum1_tad+dh_tad(i,1)
    dh_tad(i,1) = 0.d0
  end do
  sum1_tad = -(sum1_tad*rcap)
  do i = 1, im
    fy_tad(i,2) = fy_tad(i,2)+sum1_tad
  end do
endif
do j = js2g0, jn2g0
  fx_tad(im,j) = fx_tad(im,j)+dh_tad(im,j)
  fx_tad(1,j) = fx_tad(1,j)-dh_tad(im,j)
  fy_tad(im,j+1) = fy_tad(im,j+1)-dh_tad(im,j)*acosp(j)
  fy_tad(im,j) = fy_tad(im,j)+dh_tad(im,j)*acosp(j)
  dh_tad(im,j) = 0.d0
end do
do j = js2g0, jn2g0
  do i = 1, im-1
    fx_tad(i+1,j) = fx_tad(i+1,j)-dh_tad(i,j)
    fx_tad(i,j) = fx_tad(i,j)+dh_tad(i,j)
    fy_tad(i,j+1) = fy_tad(i,j+1)-dh_tad(i,j)*acosp(j)
    fy_tad(i,j) = fy_tad(i,j)+dh_tad(i,j)*acosp(j)
    dh_tad(i,j) = 0.d0
  end do
end do
call tp2d_tad( va,h,h_tad,crx,cry,im,jm,iord,jord,ng,fx,fx_tad,fy_tad,ffsl,xfx,yfx,cosp,id,jfirst,jlast )

end subroutine tp2c_tad


subroutine tp2d_tad( va, q, q_tae, crx, cry, im, jm, iord, jord, ng, fx, fx_tad, fy_tad, ffsl, xfx, yfx, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_tad(im,jfirst:jlast)
real(kind=r8) :: fy_tad(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tad(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_tad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_tad(1+im+2*(im/3))
real(kind=r8) :: dmi_tad(1+im+2*(im/3))
real(kind=r8) :: dmj_tad(1+im+2*(im/3))
real(kind=r8) :: dmk_tad(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpj_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpk_tad(1+im+2*(im/3))
real(kind=8), allocatable :: tp2d_tape1_a6_1h(:,:)
real(kind=8), allocatable :: tp2d_tape1_dm_2h(:,:)
integer :: tp2d_tape1_tp2d
real(kind=8), allocatable :: tp2d_tape2_a6_2h(:,:)
real(kind=8), allocatable :: tp2d_tape2_adx_1h(:,:,:)
real(kind=8), allocatable :: tp2d_tape2_dm_3h(:,:)
integer :: tp2d_tape2_tp2d
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_tad(im)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_tad(:) = 0.d0
adx_tad(:,:) = 0.d0
dmh_tad(:) = 0.d0
dmi_tad(:) = 0.d0
dmj_tad(:) = 0.d0
dmk_tad(:) = 0.d0
qtmph_tad(:) = 0.d0
qtmpi_tad(:) = 0.d0
qtmpj_tad(:) = 0.d0
qtmpk_tad(:) = 0.d0
wk1_tad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
!----------------------------------------------
! OPEN TAPE tp2d_tape1
!----------------------------------------------
tp2d_tape1_tp2d = jn2gng-js2gng+1

!----------------------------------------------
! OPEN TAPE tp2d_tape2
!----------------------------------------------
tp2d_tape2_tp2d = jn2g0-js2g0+1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do j = js2gng, jn2gng
  if ( .not. allocated(tp2d_tape1_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_a6_1h)) then
      allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_a6_1h(:,1+j-js2gng) = a6
  if ( .not. allocated(tp2d_tape1_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_dm_2h)) then
      allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_dm_2h(:,1+j-js2gng) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx(i,jm) = q(i,jm)
  end do
endif
if ( .not. allocated(tp2d_tape2_adx_1h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_adx_1h)) then
    allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_adx_1h(:,:,1) = adx
do j = js2g0, jn2g0-1
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_a6_2h)) then
      allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_dm_3h)) then
      allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_dm_3h(:,1+j-js2g0) = dm
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp( im,ffsl(j),fx(1,j),wk1,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,qtmp,al,ar,a6 )
end do
j = jn2g0
if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_dm_3h(:,1+j-js2g0) = dm

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
adx = tp2d_tape2_adx_1h(:,:,1)
do j = jn2g0, js2g0, -1
  a6 = tp2d_tape2_a6_2h(:,1+j-js2g0)
  dm = tp2d_tape2_dm_3h(:,1+j-js2g0)
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_tad( im,ffsl(j),fx(1,j),fx_tad(1,j),wk1,wk1_tad,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,dmj_tad,qtmp,qtmpj_tad,al,ar,a6,&
&a6_tad )
  do i = 1, im
    jp = j-va(i,j)
    q_tae(i,jp+1) = q_tae(i,jp+1)-0.5*wk1_tad(i)*va(i,j)
    q_tae(i,j) = q_tae(i,j)+wk1_tad(i)
    q_tae(i,jp) = q_tae(i,jp)+0.5*wk1_tad(i)*va(i,j)
    wk1_tad(i) = 0.d0
  end do
end do
call ytp_tad( im,jm,fy_tad,adx,adx_tad,cry,yfx,ng,jord,0,jfirst,jlast )
if (jlast .eq. jm) then
  do i = 1, im
    q_tae(i,jm) = q_tae(i,jm)+adx_tad(i,jm)
    adx_tad(i,jm) = 0.d0
  end do
endif
if (jfirst .eq. 1) then
  do i = 1, im
    q_tae(i,1) = q_tae(i,1)+adx_tad(i,1)
    adx_tad(i,1) = 0.d0
  end do
endif
do j = jn2gng, js2gng, -1
  a6 = tp2d_tape1_a6_1h(:,1+j-js2gng)
  dm = tp2d_tape1_dm_2h(:,1+j-js2gng)
  q_tae(im,j) = q_tae(im,j)+adx_tad(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))
  wk1_tad(im) = wk1_tad(im)+0.5*adx_tad(im,j)
  wk1_tad(1) = wk1_tad(1)-0.5*adx_tad(im,j)
  adx_tad(im,j) = 0.d0
  do i = 1, im-1
    q_tae(i,j) = q_tae(i,j)+adx_tad(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))
    wk1_tad(i+1) = wk1_tad(i+1)-0.5*adx_tad(i,j)
    wk1_tad(i) = wk1_tad(i)+0.5*adx_tad(i,j)
    adx_tad(i,j) = 0.d0
  end do
  call xtp_tad( im,ffsl(j),wk1,wk1_tad,q(1,j),q_tae(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,dmk_tad,qtmp,qtmpk_tad,al,ar,a6,a6_tad )
end do

!----------------------------------------------
! CLOSE TAPE tp2d_tape1
!----------------------------------------------
if (allocated(tp2d_tape1_a6_1h)) then
  deallocate( tp2d_tape1_a6_1h )
endif
if (allocated(tp2d_tape1_dm_2h)) then
  deallocate( tp2d_tape1_dm_2h )
endif

!----------------------------------------------
! CLOSE TAPE tp2d_tape2
!----------------------------------------------
if (allocated(tp2d_tape2_adx_1h)) then
  deallocate( tp2d_tape2_adx_1h )
endif
if (allocated(tp2d_tape2_a6_2h)) then
  deallocate( tp2d_tape2_a6_2h )
endif
if (allocated(tp2d_tape2_dm_3h)) then
  deallocate( tp2d_tape2_dm_3h )
endif


end subroutine tp2d_tad


subroutine tpcc_tad( va, q, crx, im, jm, ng, iord, jord, fx, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_tad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h_tad(1+im+2*(im/3))
real(kind=r8) :: a6i_tad(1+im+2*(im/3))
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adxh_tad(im,jfirst-1:jlast+2)
real(kind=r8) :: dmh_tad(1+im+2*(im/3))
real(kind=r8) :: dmi_tad(1+im+2*(im/3))
real(kind=r8) :: fx1(im)
real(kind=r8) :: fxh_tad(im,jfirst:jlast)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qh_tad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qi(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmph_tad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_tad(1+im+2*(im/3))
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1h_tad(im)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
qi(:,:) = q(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6h_tad(:) = 0.d0
a6i_tad(:) = 0.d0
adxh_tad(:,:) = 0.d0
dmh_tad(:) = 0.d0
dmi_tad(:) = 0.d0
fxh_tad(:,:) = 0.d0
qh_tad(:,:) = 0.d0
qtmph_tad(:) = 0.d0
qtmpi_tad(:) = 0.d0
wk1h_tad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = jn1g0, js2g0, -1
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  a6 = tpcc2_tape_a6_1h(:,irec)
  dm = tpcc2_tape_dm_2h(:,irec)
  call xtp_tad( im,ffsl(j),fx(1,j),fxh_tad,adx(1,j),adxh_tad,crx(1,j),iord,crx(1,j),cose(j),0,dm,dmh_tad,qtmp,qtmph_tad,al,ar,a6,&
&a6h_tad )
end do
q(:,:) = qi(:,:)
do j = jn1gn, js2gs, -1
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  a6 = tpcc1_tape_a6_1h(:,irec)
  dm = tpcc1_tape_dm_2h(:,irec)
  call xtp_tad( im,ffsl(j),wk1,wk1h_tad,q(1,j),qh_tad,crx(1,j),1,crx(1,j),cose(j),0,dm,dmi_tad,qtmp,qtmpi_tad,al,ar,a6,a6i_tad )
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine tpcc_tad


subroutine tpccmd( va, ymass, q, crx, cry, im, jm, ng, iord, jord, fx, fy, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_tad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: fx1(im)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
integer :: south
real(kind=r8) :: wk1(im)

!**********************************************
! executable statements of routine
!**********************************************
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  if ( .not. allocated(tpcc1_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_a6_1h)) then
      allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc1_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_dm_2h)) then
      allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc( im,jm,fy,adx,cry,ymass,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  if ( .not. allocated(tpcc2_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_a6_1h)) then
      allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc2_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_dm_2h)) then
      allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),fx(1,j),adx(1,j),crx(1,j),iord,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
end do
end subroutine tpccmd


subroutine xmist_tad( im, q, q_tae, dm, dm_tad, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_tae(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_tad
double precision :: dmi_tad
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxh
double precision :: qmaxh_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminh
double precision :: qminh_tad
double precision :: qmini_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_tad = 0.d0
qmin_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmax_tad = 0.d0
    qmin_tad = 0.d0
    qmax = max(q(i-1),q(i),q(i+1))-q(i)
    qmin = q(i)-min(q(i-1),q(i),q(i+1))
    dmh = min(abs(dm(i)),qmax)
    dmi_tad = dm_tad(i)*sign(1.d0,min(dmh,qmin))*sign(1.d0,dm(i))
    dmh_tad = dmi_tad*(0.5+sign(0.5d0,qmin-dmh))
    qmin_tad = qmin_tad+dmi_tad*(0.5-sign(0.5d0,qmin-dmh))
    qmax_tad = qmax_tad+dmh_tad*(0.5-sign(0.5d0,qmax-abs(dm(i))))
    dm_tad(i) = dmh_tad*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))
    qminh = min(q(i-1),q(i))
    q_tae(i) = q_tae(i)+qmin_tad
    qmini_tad = -qmin_tad
    q_tae(i+1) = q_tae(i+1)+qmini_tad*(0.5-sign(0.5d0,q(i+1)-qminh))
    qminh_tad = qmini_tad*(0.5+sign(0.5d0,q(i+1)-qminh))
    q_tae(i-1) = q_tae(i-1)+qminh_tad*(0.5+sign(0.5d0,q(i)-q(i-1)))
    q_tae(i) = q_tae(i)+qminh_tad*(0.5-sign(0.5d0,q(i)-q(i-1)))
    qmin_tad = 0.d0
    qmaxh = max(q(i-1),q(i))
    q_tae(i) = q_tae(i)-qmax_tad
    q_tae(i+1) = q_tae(i+1)+qmax_tad*(0.5-sign(0.5d0,qmaxh-q(i+1)))
    qmaxh_tad = qmax_tad*(0.5+sign(0.5d0,qmaxh-q(i+1)))
    q_tae(i-1) = q_tae(i-1)+qmaxh_tad*(0.5+sign(0.5d0,q(i-1)-q(i)))
    q_tae(i) = q_tae(i)+qmaxh_tad*(0.5-sign(0.5d0,q(i-1)-q(i)))
    qmax_tad = 0.d0
  end do
endif
if (id .le. 2) then
  do i = 1, im
    q_tae(i-2) = q_tae(i-2)+dm_tad(i)*r24
    q_tae(i-1) = q_tae(i-1)-8*dm_tad(i)*r24
    q_tae(i+2) = q_tae(i+2)-dm_tad(i)*r24
    q_tae(i+1) = q_tae(i+1)+8*dm_tad(i)*r24
    dm_tad(i) = 0.d0
  end do
else
  do i = 1, im
    q_tae(i-1) = q_tae(i-1)-0.25*dm_tad(i)
    q_tae(i+1) = q_tae(i+1)+0.25*dm_tad(i)
    dm_tad(i) = 0.d0
  end do
endif

end subroutine xmist_tad


subroutine xtp_tad( im, ffsl, fx, fx_tad, q, q_tae, c, iord, mfx, cosa, id, dm, dm_tad, qtmp, qtmp_tad, al, ar, a6, a6_tad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_tad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_tad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_tad(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_tae(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_tad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h(-(im/3):im+im/3)
real(kind=r8) :: alh_tad(1+im+2*(im/3))
real(kind=r8) :: ali_tad(1+im+2*(im/3))
real(kind=r8) :: arh_tad(1+im+2*(im/3))
real(kind=r8) :: ari_tad(1+im+2*(im/3))
double precision :: dmh_tad
double precision :: dmi_tad
double precision :: dmj
double precision :: dmj_tad
real(kind=r8) :: dmk(-(im/3):im+im/3)
double precision :: dmk_tad
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxh
double precision :: qmaxh_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminh
double precision :: qminh_tad
double precision :: qmini_tad
real(kind=r8) :: rut
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmk(:) = dm(:)
a6h(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alh_tad(:) = 0.d0
ali_tad(:) = 0.d0
arh_tad(:) = 0.d0
ari_tad(:) = 0.d0
qmax_tad = 0.d0
qmin_tad = 0.d0
tmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm( im,c,mfx,qtmp,dm,fx,iord,al,ar,a6,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
        else
          itmp = i-iu-1
          isave(i) = itmp+1
        endif
      end do
    endif
  endif
  if (id .ne. 0) then
    do i = 1, im
      fx_tad(i) = fx_tad(i)*mfx(i)
    end do
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        qtmp_tad(ist) = qtmp_tad(ist)+fx_tad(i)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        qtmp_tad(ist) = qtmp_tad(ist)-fx_tad(i)
      end do
    endif
  end do
  a6(:) = a6h(:)
  dm(:) = dmk(:)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
      else
        itmp = i-iu-1
      endif
      qtmp_tad(itmp) = qtmp_tad(itmp)+fx_tad(i)*(c(i)-iu)
      fx_tad(i) = 0.d0
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_tad( im,c,mfx,qtmp,qtmp_tad,dm,dm_tad,fx_tad,iord,al,alh_tad,ar,arh_tad,a6,a6_tad,iuw,iue,ffsl )
    else
      do i = 1, im
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          dm_tad(itmp) = dm_tad(itmp)-fx_tad(i)*rut*(1+rut)
          qtmp_tad(itmp) = qtmp_tad(itmp)+fx_tad(i)*rut
          fx_tad(i) = 0.d0
        else
          itmp = i-iu-1
          dm_tad(itmp) = dm_tad(itmp)+fx_tad(i)*rut*(1.-rut)
          qtmp_tad(itmp) = qtmp_tad(itmp)+fx_tad(i)*rut
          fx_tad(i) = 0.d0
        endif
      end do
    endif
    do i = iue, imp, -1
      dmh_tad = dm_tad(i)
      dm_tad(i) = 0.d0
      dm_tad(i-im) = dm_tad(i-im)+dmh_tad
    end do
    do i = 0, iuw, -1
      dmi_tad = dm_tad(i)
      dm_tad(i) = 0.d0
      dm_tad(im+i) = dm_tad(im+i)+dmi_tad
    end do
    do i = 1, im
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dmj = min(abs(tmp),qmax)
      dmk_tad = dm_tad(i)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_tad = dmk_tad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_tad = qmin_tad+dmk_tad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_tad = qmax_tad+dmj_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmj_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i) = 0.d0
      qminh = min(qtmp(i-1),qtmp(i))
      qmini_tad = -qmin_tad
      qtmp_tad(i) = qtmp_tad(i)+qmin_tad
      qminh_tad = qmini_tad*(0.5+sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_tad(i+1) = qtmp_tad(i+1)+qmini_tad*(0.5-sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_tad(i-1) = qtmp_tad(i-1)+qminh_tad*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qtmp_tad(i) = qtmp_tad(i)+qminh_tad*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qmin_tad = 0.d0
      qmaxh = max(qtmp(i-1),qtmp(i))
      qtmp_tad(i) = qtmp_tad(i)-qmax_tad
      qmaxh_tad = qmax_tad*(0.5+sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_tad(i+1) = qtmp_tad(i+1)+qmax_tad*(0.5-sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_tad(i-1) = qtmp_tad(i-1)+qmaxh_tad*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qtmp_tad(i) = qtmp_tad(i)+qmaxh_tad*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qmax_tad = 0.d0
      qtmp_tad(i-1) = qtmp_tad(i-1)-0.25*tmp_tad
      qtmp_tad(i+1) = qtmp_tad(i+1)+0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
  do i = imp, iue
    q_tae(i-im) = q_tae(i-im)+qtmp_tad(i)
    qtmp_tad(i) = 0.d0
  end do
  do i = iuw, 0
    q_tae(im+i) = q_tae(im+i)+qtmp_tad(i)
    qtmp_tad(i) = 0.d0
  end do
else
  qtmp(imp) = q(1)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = float(i)-c(i)
      qtmp_tad(iu) = qtmp_tad(iu)+fx_tad(i)*mfx(i)
      fx_tad(i) = 0.d0
    end do
  else
    qtmp(-1) = q(im-1)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist( im,qtmp,dm,2 )
    else
      call xmist( im,qtmp,dm,iord )
    endif
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      do i = 1, im
        iu = float(i)-c(i)
        dm_tad(iu) = dm_tad(iu)+fx_tad(i)*mfx(i)*(sign(1.d0,c(i))-c(i))
        qtmp_tad(iu) = qtmp_tad(iu)+fx_tad(i)*mfx(i)
        fx_tad(i) = 0.d0
      end do
    else
      call fxppm_tad( im,c,mfx,qtmp,qtmp_tad,dm,dm_tad,fx_tad,iord,al,ali_tad,ar,ari_tad,a6,a6_tad,iuw,iue,ffsl )
    endif
    dm_tad(im) = dm_tad(im)+dm_tad(0)
    dm_tad(0) = 0.d0
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_tad( im,qtmp,qtmp_tad,dm,dm_tad,2 )
    else
      call xmist_tad( im,qtmp,qtmp_tad,dm,dm_tad,iord )
    endif
    q_tae(2) = q_tae(2)+qtmp_tad(imp+1)
    qtmp_tad(imp+1) = 0.d0
    q_tae(im-1) = q_tae(im-1)+qtmp_tad(-1)
    qtmp_tad(-1) = 0.d0
  endif
  q_tae(im) = q_tae(im)+qtmp_tad(0)
  qtmp_tad(0) = 0.d0
  q_tae(1) = q_tae(1)+qtmp_tad(imp)
  qtmp_tad(imp) = 0.d0
endif
do i = 1, im
  q_tae(i) = q_tae(i)+qtmp_tad(i)
  qtmp_tad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine xtp_tad


subroutine ymist_tad( im, jm, q, q_tae, dm, dm_tad, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tad(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_tad
double precision :: dmi_tad
double precision :: dmi_tae
double precision :: dmj
double precision :: dmj_tad
double precision :: dmk_tad
double precision :: dmk_tae
double precision :: dml
double precision :: dml_tad
double precision :: dmm_tad
double precision :: dmm_tae
double precision :: dmn
double precision :: dmn_tad
double precision :: dmo_tad
double precision :: dmo_tae
double precision :: dmp
double precision :: dmp_tad
double precision :: dmq_tad
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxh
double precision :: qmaxh_tad
double precision :: qmaxj
double precision :: qmaxj_tad
double precision :: qmaxl
double precision :: qmaxl_tad
double precision :: qmaxn
double precision :: qmaxn_tad
double precision :: qmaxp
double precision :: qmaxp_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminh
double precision :: qminh_tad
double precision :: qmini_tad
double precision :: qminj
double precision :: qminj_tad
double precision :: qmink_tad
double precision :: qminl
double precision :: qminl_tad
double precision :: qminm_tad
double precision :: qminn
double precision :: qminn_tad
double precision :: qmino_tad
double precision :: qminp
double precision :: qminp_tad
double precision :: qminq_tad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_tad = 0.d0
qmin_tad = 0.d0
tmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    qmax_tad = 0.d0
    qmin_tad = 0.d0
    do i = 1, im
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
      qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
      dmh = min(abs(dm(i,j)),qmin)
      dmi_tad = dm_tad(i,j)*sign(1.d0,min(dmh,qmax))*sign(1.d0,dm(i,j))
      dmh_tad = dmi_tad*(0.5+sign(0.5d0,qmax-dmh))
      qmax_tad = qmax_tad+dmi_tad*(0.5-sign(0.5d0,qmax-dmh))
      qmin_tad = qmin_tad+dmh_tad*(0.5-sign(0.5d0,qmin-abs(dm(i,j))))
      dm_tad(i,j) = dmh_tad*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))
      qminh = min(q(i,j-1),q(i,j))
      q_tae(i,j) = q_tae(i,j)+qmin_tad
      qmini_tad = -qmin_tad
      q_tae(i,j+1) = q_tae(i,j+1)+qmini_tad*(0.5-sign(0.5d0,q(i,j+1)-qminh))
      qminh_tad = qmini_tad*(0.5+sign(0.5d0,q(i,j+1)-qminh))
      q_tae(i,j-1) = q_tae(i,j-1)+qminh_tad*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))
      q_tae(i,j) = q_tae(i,j)+qminh_tad*(0.5-sign(0.5d0,q(i,j)-q(i,j-1)))
      qmin_tad = 0.d0
      qmaxh = max(q(i,j-1),q(i,j))
      q_tae(i,j) = q_tae(i,j)-qmax_tad
      q_tae(i,j+1) = q_tae(i,j+1)+qmax_tad*(0.5-sign(0.5d0,qmaxh-q(i,j+1)))
      qmaxh_tad = qmax_tad*(0.5+sign(0.5d0,qmaxh-q(i,j+1)))
      q_tae(i,j-1) = q_tae(i,j-1)+qmaxh_tad*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))
      q_tae(i,j) = q_tae(i,j)+qmaxh_tad*(0.5-sign(0.5d0,q(i,j-1)-q(i,j)))
      qmax_tad = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmi_tae = dm_tad(i,jm)
      dm_tad(i,jm) = 0.d0
      dm_tad(i-im2,jm) = dm_tad(i-im2,jm)-dmi_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmj = min(abs(tmp),qmax)
      dmk_tad = dm_tad(i,jm)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_tad = dmk_tad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_tad = qmin_tad+dmk_tad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_tad = qmax_tad+dmj_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmj_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,jm) = 0.d0
      qminj = min(q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)+qmin_tad
      qmink_tad = -qmin_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmink_tad*(0.5-sign(0.5d0,q(i,jm1)-qminj))
      qminj_tad = qmink_tad*(0.5+sign(0.5d0,q(i,jm1)-qminj))
      q_tae(i,jm) = q_tae(i,jm)+qminj_tad*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)+qminj_tad*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      qmin_tad = 0.d0
      qmaxj = max(q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)-qmax_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmax_tad*(0.5-sign(0.5d0,qmaxj-q(i,jm1)))
      qmaxj_tad = qmax_tad*(0.5+sign(0.5d0,qmaxj-q(i,jm1)))
      q_tae(i,jm) = q_tae(i,jm)+qmaxj_tad*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)+qmaxj_tad*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      qmax_tad = 0.d0
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)+0.25*tmp_tad
      q_tae(i,jm1) = q_tae(i,jm1)-0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmk_tae = dm_tad(i,1)
      dm_tad(i,1) = 0.d0
      dm_tad(i-im2,1) = dm_tad(i-im2,1)-dmk_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dml = min(abs(tmp),qmax)
      dmm_tad = dm_tad(i,1)*sign(1.d0,min(dml,qmin))*sign(1.d0,tmp)
      dml_tad = dmm_tad*(0.5+sign(0.5d0,qmin-dml))
      qmin_tad = qmin_tad+dmm_tad*(0.5-sign(0.5d0,qmin-dml))
      qmax_tad = qmax_tad+dml_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dml_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,1) = 0.d0
      qminl = min(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)+qmin_tad
      qminm_tad = -qmin_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)+qminm_tad*(0.5-sign(0.5d0,q(i+im2,2)-qminl))
      qminl_tad = qminm_tad*(0.5+sign(0.5d0,q(i+im2,2)-qminl))
      q_tae(i,2) = q_tae(i,2)+qminl_tad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_tae(i,1) = q_tae(i,1)+qminl_tad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_tad = 0.d0
      qmaxl = max(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)-qmax_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)+qmax_tad*(0.5-sign(0.5d0,qmaxl-q(i+im2,2)))
      qmaxl_tad = qmax_tad*(0.5+sign(0.5d0,qmaxl-q(i+im2,2)))
      q_tae(i,2) = q_tae(i,2)+qmaxl_tad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_tae(i,1) = q_tae(i,1)+qmaxl_tad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_tad = 0.d0
      q_tae(i+im2,2) = q_tae(i+im2,2)-0.25*tmp_tad
      q_tae(i,2) = q_tae(i,2)+0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmm_tae = dm_tad(i,jm)
      dm_tad(i,jm) = 0.d0
      dm_tad(i-im2,jm) = dm_tad(i-im2,jm)+dmm_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmn = min(abs(tmp),qmax)
      dmo_tad = dm_tad(i,jm)*sign(1.d0,min(dmn,qmin))*sign(1.d0,tmp)
      dmn_tad = dmo_tad*(0.5+sign(0.5d0,qmin-dmn))
      qmin_tad = qmin_tad+dmo_tad*(0.5-sign(0.5d0,qmin-dmn))
      qmax_tad = qmax_tad+dmn_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmn_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,jm) = 0.d0
      qminn = min(-q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)+qmin_tad
      qmino_tad = -qmin_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmino_tad*(0.5-sign(0.5d0,q(i,jm1)-qminn))
      qminn_tad = qmino_tad*(0.5+sign(0.5d0,q(i,jm1)-qminn))
      q_tae(i,jm) = q_tae(i,jm)+qminn_tad*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)-qminn_tad*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      qmin_tad = 0.d0
      qmaxn = max(-q(i+im2,jm1),q(i,jm))
      q_tae(i,jm) = q_tae(i,jm)-qmax_tad
      q_tae(i,jm1) = q_tae(i,jm1)+qmax_tad*(0.5-sign(0.5d0,qmaxn-q(i,jm1)))
      qmaxn_tad = qmax_tad*(0.5+sign(0.5d0,qmaxn-q(i,jm1)))
      q_tae(i,jm) = q_tae(i,jm)+qmaxn_tad*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)-qmaxn_tad*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      qmax_tad = 0.d0
      q_tae(i+im2,jm1) = q_tae(i+im2,jm1)-0.25*tmp_tad
      q_tae(i,jm1) = q_tae(i,jm1)-0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmo_tae = dm_tad(i,1)
      dm_tad(i,1) = 0.d0
      dm_tad(i-im2,1) = dm_tad(i-im2,1)+dmo_tae
    end do
    do i = 1, im2
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      tmp_tad = 0.d0
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dmp = min(abs(tmp),qmax)
      dmq_tad = dm_tad(i,1)*sign(1.d0,min(dmp,qmin))*sign(1.d0,tmp)
      dmp_tad = dmq_tad*(0.5+sign(0.5d0,qmin-dmp))
      qmin_tad = qmin_tad+dmq_tad*(0.5-sign(0.5d0,qmin-dmp))
      qmax_tad = qmax_tad+dmp_tad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_tad = tmp_tad+dmp_tad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_tad(i,1) = 0.d0
      qminp = min(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)+qmin_tad
      qminq_tad = -qmin_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)-qminq_tad*(0.5-sign(0.5d0,(-q(i+im2,2))-qminp))
      qminp_tad = qminq_tad*(0.5+sign(0.5d0,(-q(i+im2,2))-qminp))
      q_tae(i,2) = q_tae(i,2)+qminp_tad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_tae(i,1) = q_tae(i,1)+qminp_tad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_tad = 0.d0
      qmaxp = max(q(i,2),q(i,1))
      q_tae(i,1) = q_tae(i,1)-qmax_tad
      q_tae(i+im2,2) = q_tae(i+im2,2)-qmax_tad*(0.5-sign(0.5d0,qmaxp-(-q(i+im2,2))))
      qmaxp_tad = qmax_tad*(0.5+sign(0.5d0,qmaxp-(-q(i+im2,2))))
      q_tae(i,2) = q_tae(i,2)+qmaxp_tad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_tae(i,1) = q_tae(i,1)+qmaxp_tad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_tad = 0.d0
      q_tae(i+im2,2) = q_tae(i+im2,2)+0.25*tmp_tad
      q_tae(i,2) = q_tae(i,2)+0.25*tmp_tad
      tmp_tad = 0.d0
    end do
  endif
endif
do j = js2gng1, jn2gng1
  do i = 1, im
    q_tae(i,j-1) = q_tae(i,j-1)-0.25*dm_tad(i,j)
    q_tae(i,j+1) = q_tae(i,j+1)+0.25*dm_tad(i,j)
    dm_tad(i,j) = 0.d0
  end do
end do

end subroutine ymist_tad


subroutine ytp_tad( im, jm, fy_tad, q, q_tae, c, yfx, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: fy_tad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_tad(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dm_tad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
do j = js2g0, jn1g1
  do i = 1, im
    fy_tad(i,j) = fy_tad(i,j)*yfx(i,j)
  end do
end do
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      q_tae(i,jt) = q_tae(i,jt)+fy_tad(i,j)
      fy_tad(i,j) = 0.d0
    end do
  end do
else
  call ymist( im,jm,q,dm,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm_tad( c,q,q_tae,dm,dm_tad,fy_tad,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        dm_tad(i,jt) = dm_tad(i,jt)+fy_tad(i,j)*(sign(1.d0,c(i,j))-c(i,j))
        q_tae(i,jt) = q_tae(i,jt)+fy_tad(i,j)
        fy_tad(i,j) = 0.d0
      end do
    end do
  endif
  call ymist_tad( im,jm,q,q_tae,dm,dm_tad,ng,jord,iv,jfirst,jlast )
endif

end subroutine ytp_tad


end module     tp_core_tad


#endif /* SPMD */
