#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     sw_core_ttl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use sw_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine c_sw_ttl( u, v, pt, delp, uc, vc, ptc, delpf, ptk, cosp, acosp, cose, coslon, sinlon, dxdt, dxe, dtdx2, dtdx4, dtxe5, &
&rdxe, dycp, dydt, dtdy5, cye, fc, ifax, trigs, dc, sc, zt_c, tiny, rcap, im, jm, jfirst, jlast, ng_c, ng_d, ng_s, js2g0, jn2g0, &
&js2gc, jn1gc, iord, jord, cosl5, sinl5, c_sw_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_ttl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
integer :: c_sw_tape_rec
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
real(kind=r8), intent(in) :: cye(jm)
integer, intent(in) :: jn2g0
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: dc(im,js2g0:jn2g0)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
real(kind=r8), intent(in) :: delp(im,jfirst:jlast)
integer, intent(in) :: ng_d
real(kind=r8), intent(in) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx2(jm)
real(kind=r8), intent(in) :: dtdx4(jm)
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dxdt(jm)
real(kind=r8), intent(in) :: dxe(jm)
real(kind=r8), intent(in) :: dycp(jm)
real(kind=r8), intent(in) :: dydt
integer, intent(in) :: jn1gc
integer, intent(in) :: js2gc
real(kind=r8), intent(in) :: fc(js2gc:jn1gc)
integer, intent(in) :: ifax(13)
integer, intent(in) :: iord
integer, intent(in) :: jord
integer, intent(in) :: ng_c
integer, intent(in) :: ng_s
real(kind=r8), intent(in) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(out) :: ptc(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptk(im,jfirst:jlast)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdxe(jm)
real(kind=r8), intent(in) :: sc(js2g0:jn2g0)
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: trigs(3*im/2+1)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(out) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(out) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_c

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6j_ttl(1+im+2*(im/3))
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: crx(im,jfirst-max(1,ng_c):jlast+max(2,ng_c))
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: cx1(im)
real(kind=r8) :: delpfh_ttl(im,jfirst-ng_d:jlast+ng_d)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxjj_ttl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fyh_ttl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: help_i
integer :: i
integer :: im2
integer :: j
integer :: jn1g1
integer :: jn2gc
integer :: js1g1
integer :: js2g1
integer :: js2gc1
integer :: js2gcp1
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1dj_ttl(im)
real(kind=r8) :: p1ke
real(kind=r8) :: p2ke
real(kind=r8) :: pth_ttl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: ptkh_ttl(im,jfirst:jlast)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpj_ttl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopej_ttl(1+im+2*(im/3))
real(kind=r8) :: tm2(im,jfirst:jlast)
real(kind=r8) :: tm2h_ttl(im,1+jlast-jfirst)
real(kind=r8) :: u2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: un
real(kind=r8) :: us
real(kind=r8) :: v2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: vn
real(kind=r8) :: vs
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfxh_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: ymass(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
js1g1 = max(1,jfirst-1)
js2g1 = max(2,jfirst-1)
js2gcp1 = max(2,jfirst-ng_c-1)
jn1g1 = min(jm,jlast+1)
jn2gc = min(jm-1,jlast+ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc1 = js2gc
else
  js2gc1 = max(2,jfirst-ng_c+1)
endif
call vpol5( u(1,jfirst),v(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gcp1, jn2gc
  do i = 1, im-1
    v2(i,j) = v(i,j)+v(i+1,j)
  end do
  v2(im,j) = v(im,j)+v(1,j)
end do
do j = js2gc, jn2gc
  do i = 1, im
    u2(i,j) = u(i,j)+u(i,j+1)
  end do
end do
if (jfirst .eq. 1) then
  us = 0.
  vs = 0.
  do i = 1, im2
    us = us+(u2(i+im2,2)-u2(i,2))*sinlon(i)+(v2(i,2)-v2(i+im2,2))*coslon(i)
    vs = vs+(u2(i+im2,2)-u2(i,2))*coslon(i)+(v2(i+im2,2)-v2(i,2))*sinlon(i)
  end do
  us = us/im
  vs = vs/im
  do i = 1, im2
    u2(i,1) = (-(us*sinlon(i)))-vs*coslon(i)
    v2(i,1) = us*coslon(i)-vs*sinlon(i)
    u2(i+im2,1) = -u2(i,1)
    v2(i+im2,1) = -v2(i,1)
  end do
  p1ke = 0.125*(u2(1,1)**2+v2(1,1)**2)
endif
if (jlast .eq. jm) then
  un = 0.
  vn = 0.
  j = jm-1
  do i = 1, im2
    un = un+(u2(i+im2,j)-u2(i,j))*sinlon(i)+(v2(i+im2,j)-v2(i,j))*coslon(i)
    vn = vn+(u2(i,j)-u2(i+im2,j))*coslon(i)+(v2(i+im2,j)-v2(i,j))*sinlon(i)
  end do
  un = un/im
  vn = vn/im
  do i = 1, im2
    u2(i,jm) = (-(un*sinlon(i)))+vn*coslon(i)
    v2(i,jm) = (-(un*coslon(i)))-vn*sinlon(i)
    u2(i+im2,jm) = -u2(i,jm)
    v2(i+im2,jm) = -v2(i,jm)
  end do
  p2ke = 0.125*(u2(1,jm)**2+v2(1,jm)**2)
endif
do j = js2gc, jn2gc
  uc(1,j) = 0.25*(u2(1,j)+u2(im,j))
  do i = 2, im
    uc(i,j) = 0.25*(u2(i,j)+u2(i-1,j))
  end do
end do
do i = 1, im
  vc(i,jfirst-2) = 0.
  vc(i,jfirst-1) = 0.
  vc(i,jfirst) = 0.
  vc(i,jlast+1) = 0.
  vc(i,jlast+2) = 0.
end do
do j = js2gc, jn1gc
  do i = 1, im
    vc(i,j) = 0.25*(v2(i,j)+v2(i,j-1))
  end do
end do
do j = js2g1, jn1g1
  do i = 1, im
    cry(i,j) = dtdy5*vc(i,j)
  end do
end do
do j = js2g0, jn1g1
  do i = 1, im
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g1, jn2g0
  do i = 1, im
    va(i,j) = 0.5*(cry(i,j)+cry(i,j+1))
  end do
end do
do j = jfirst-1, jlast
  do i = 1, im
    crx(i,j) = 0.
  end do
end do
do j = js2gc, jn2gc
  do i = 1, im
    crx(i,j) = uc(i,j)*dtdx2(j)
  end do
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
delpfh_ttl(:,:) = 0.
call tp2c_ttl( ptk,ptkh_ttl,va(1,jfirst),delpf(1,jfirst-ng_c),delpfh_ttl,crx(1,jfirst-ng_c),cry(1,jfirst),im,jm,iord,jord,ng_c,xfx,&
&xfxh_ttl,yfx,yfxh_ttl,ffsl,rcap,acosp,crx(1,jfirst),ymass,cosp,0,jfirst,jlast )
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
pth_ttl(:,:) = 0.
call tp2c_ttl( tm2,tm2h_ttl,va(1,jfirst),pt(1,jfirst-ng_c),pth_ttl,crx(1,jfirst-ng_c),cry(1,jfirst),im,jm,iord,jord,ng_c,fx,&
&fxh_ttl,fy(1,jfirst),fyh_ttl,ffsl,rcap,acosp,xfx,yfx,cosp,1,jfirst,jlast )
help_h = jn2g0-js2g0+1
call pft2d( ptk(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,v2,crx )
help_i = jn2g0-js2g0+1
call pft2d( tm2(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_i,ifax,trigs,v2,crx )
do j = jfirst, jlast
  do i = 1, im
    ptk(i,j) = delp(i,j)+ptk(i,j)
    ptc(i,j) = (pt(i,j)*delp(i,j)+tm2(i,j))/ptk(i,j)
  end do
end do
call ycc( im,jm,fy,vc(1,jfirst-2),va(1,jfirst-1),va(1,jfirst-1),jord,1,jfirst,jlast )
do j = js2g1, jn2g0
  do i = 1, im
    cx1(i) = dtdx4(j)*u2(i,j)
  end do
  sld =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(cx1(i)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  p1d(im) = uc(1,j)
  do i = 1, im-1
    p1d(i) = uc(i+1,j)
  end do
  p1dj_ttl(:) = 0.d0
  a6j_ttl(:) = 0.d0
  call xtp_ttl( im,sld,fxj,fxjj_ttl,p1d,p1dj_ttl,cx1,iord,cx1,cosp(j),0,slope,slopej_ttl,qtmp,qtmpj_ttl,al,ar,a6,a6j_ttl )
  do i = 1, im
    wk1(i,j) = dxdt(j)*fxj(i)+dydt*fy(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1(i,1) = p1ke
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    wk1(i,jm) = p2ke
  end do
endif
do j = js2gc1, jn1gc
  crx(1,j) = dtxe5(j)*u(im,j)
  do i = 2, im
    crx(i,j) = dtxe5(j)*u(i-1,j)
  end do
end do
do j = js1g1, jlast
  do i = 1, im
    cry(i,j) = dtdy5*v(i,j)
  end do
end do
do j = jfirst, jlast
  do i = 1, im
    ymass(i,j) = cry(i,j)*cosp(j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im
    tm2(i,j) = 0.5*(cry(i,j)+cry(i,j-1))
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    u2(i,1) = 0.
  end do
endif
do j = js2gc, jn2gc
  do i = 1, im
    u2(i,j) = uc(i,j)*cosp(j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    u2(i,jm) = 0.
  end do
endif
do j = js2gc1, jn1gc
  v2(1,j) = fc(j)+(u2(1,j-1)-u2(1,j))*cye(j)+(vc(1,j)-vc(im,j))*rdxe(j)
  do i = 2, im
    v2(i,j) = fc(j)+(u2(i,j-1)-u2(i,j))*cye(j)+(vc(i,j)-vc(i-1,j))*rdxe(j)
  end do
end do
do j = js2gc1, jn1gc
  ffsl(j) =  .false. 
  if (cose(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
call tpcc_ttl( tm2,ymass,v2(1,jfirst-ng_d),crx(1:im,jfirst-1:jlast+2),cry(1:im,jfirst:jlast),im,jm,ng_d,iord,jord,fx,fy(1:im,&
&jfirst:jlast),ffsl,cose,jfirst,jlast,slope,qtmp,al,ar,a6 )
do j = js2g0, jn2g0
  uc(1,j) = uc(1,j)+dtdx2(j)*(wk1(im,j)-wk1(1,j))+dycp(j)*fy(1,j)
  do i = 2, im
    uc(i,j) = uc(i,j)+dtdx2(j)*(wk1(i-1,j)-wk1(i,j))+dycp(j)*fy(i,j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im-1
    vc(i,j) = vc(i,j)+dtdy5*(wk1(i,j-1)-wk1(i,j))-dxe(j)*fx(i+1,j)
  end do
  vc(im,j) = vc(im,j)+dtdy5*(wk1(im,j-1)-wk1(im,j))-dxe(j)*fx(1,j)
end do

end subroutine c_sw_ttl


subroutine d_sw_ttl( u, v, uc, vc, pt, delp, delpf, cx3, cy3, mfx, mfy, cdx, cdy, dtdx, dtdxe, dtxe5, txe5, dyce, rdx, cy, dx, f0, &
&js2g0, jn1g1, im, jm, jfirst, jlast, ng_d, ng_s, nq, iord, jord, zt_d, rcap, tiny, dtdy, dtdy5, tdy5, rdy, cosp, acosp, cose, &
&coslon, sinlon, cosl5, sinl5, d_sw_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_ttl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
integer, intent(in) :: jn1g1
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: cdx(js2g0:jn1g1)
real(kind=r8), intent(in) :: cdy(js2g0:jn1g1)
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
integer, intent(in) :: ng_d
real(kind=r8), intent(inout) :: cx3(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: cy(jm)
real(kind=r8), intent(inout) :: cy3(im,jfirst:jlast+1)
integer :: d_sw_tape_rec
real(kind=r8), intent(inout) :: delp(im,jfirst:jlast)
real(kind=r8), intent(inout) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx(jm)
real(kind=r8), intent(in) :: dtdxe(jm)
real(kind=r8), intent(in) :: dtdy
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dx(jm)
real(kind=r8), intent(in) :: dyce(jm)
real(kind=r8), intent(in) :: f0(jfirst-ng_d:jlast+ng_d)
integer, intent(in) :: iord
integer, intent(in) :: jord
real(kind=r8), intent(inout) :: mfx(im,jfirst:jlast)
real(kind=r8), intent(inout) :: mfy(im,jfirst:jlast+1)
integer, intent(in) :: ng_s
integer, intent(in) :: nq
real(kind=r8), intent(inout) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdx(jm)
real(kind=r8), intent(in) :: rdy
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tdy5
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: txe5(jm)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(inout) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(inout) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_d

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6i_ttl(1+im+2*(im/3))
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c1
real(kind=r8) :: c2
real(kind=r8) :: crx(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: delpfh_ttl(im,jfirst-ng_d:jlast+ng_d)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: fxi_ttl(im,1+jlast-jfirst)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxji_ttl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fyh_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: fyi_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: fyj_ttl(im,1+1+jlast-jfirst)
integer :: i
integer :: j
integer :: jn1gd
integer :: jn2g0
integer :: jn2g1
integer :: jn2gd
integer :: js2gd
real(kind=r8) :: pth_ttl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpi_ttl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopei_ttl(1+im+2*(im/3))
real(kind=r8) :: ub(im,jfirst:jlast+1)
real(kind=r8) :: ubh_ttl(im,jfirst:jlast+1)
real(kind=r8) :: ubi_ttl(im,jfirst:jlast+1)
real(kind=r8) :: uch_ttl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: ui_ttl(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: vh_ttl(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfxh_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: ymass(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
jn2g0 = min(jm-1,jlast)
jn2g1 = min(jm-1,jlast+1)
js2gd = max(2,jfirst-ng_d)
jn2gd = min(jm-1,jlast+ng_d)
jn1gd = min(jm,jlast+ng_d)
call upol5( uc(1,jfirst),vc(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gd, jn2gd
  do i = 1, im
    crx(i,j) = dtdx(j)*uc(i,j)
  end do
end do
do j = js2gd, jn2gd
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_d) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
do j = js2g0, jn1g1
  do i = 1, im
    cry(i,j) = dtdy*vc(i,j)
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g0, jn2g0
  do i = 1, im
    if (cry(i,j)*cry(i,j+1) .gt. 0.) then
      if (cry(i,j) .gt. 0.) then
        va(i,j) = cry(i,j)
      else
        va(i,j) = cry(i,j+1)
      endif
    else
      va(i,j) = 0.
    endif
  end do
end do
delpfh_ttl(:,:) = 0.
call tp2c_ttl( ub(1,jfirst),ubi_ttl,va(1,jfirst),delpf(1,jfirst-ng_d),delpfh_ttl,crx(1,jfirst-ng_d),cry(1,jfirst),im,jm,iord,jord,&
&ng_d,xfx,xfxh_ttl,yfx,yfxh_ttl,ffsl,rcap,acosp,crx(1,jfirst),ymass,cosp,0,jfirst,jlast )
if (nq .gt. 0) then
  do j = js2g0, jn2g0
    do i = 1, im
      cx3(i,j) = cx3(i,j)+crx(i,j)
      mfx(i,j) = mfx(i,j)+xfx(i,j)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      cy3(i,j) = cy3(i,j)+cry(i,j)
      mfy(i,j) = mfy(i,j)+yfx(i,j)
    end do
  end do
endif
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
do j = jfirst, jlast
  do i = 1, im
    wk1(i,j) = delp(i,j)
    delp(i,j) = wk1(i,j)+ub(i,j)
  end do
end do
pth_ttl(:,:) = 0.
call tp2c_ttl( ub(1,jfirst),ubh_ttl,va(1,jfirst),pt(1,jfirst-ng_d),pth_ttl,crx(1,jfirst-ng_d),cry(1,jfirst),im,jm,iord,jord,ng_d,&
&fx,fxi_ttl,fy(1:im,jfirst:jlast+1),fyj_ttl,ffsl,rcap,acosp,xfx,yfx(1,jfirst),cosp,1,jfirst,jlast )
do j = jfirst, jlast
  do i = 1, im
    pt(i,j) = (pt(i,j)*wk1(i,j)+ub(i,j))/delp(i,j)
  end do
end do
do j = js2g0, jn1g1
  ub(1,j) = dtdy5*(vc(1,j)+vc(im,j))
  do i = 2, im
    ub(i,j) = dtdy5*(vc(i,j)+vc(i-1,j))
  end do
end do
vh_ttl(:,:) = 0.
call ytp_ttl( im,jm,fy(1:im,jfirst:jlast+1),fyi_ttl,v(1,jfirst-ng_d),vh_ttl,ub(1,jfirst),ub(1,jfirst),ng_d,jord,1,jfirst,jlast )
do j = js2g0, jn1g1
  do i = 1, im
    ub(i,j) = dtxe5(j)*(uc(i,j)+uc(i,j-1))
  end do
end do
do j = js2g0, jn1g1
  sld =  .false. 
  if (cose(j) .lt. zt_d) then
    do i = 1, im
      if (abs(ub(i,j)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  ui_ttl(:,:) = 0.
  a6i_ttl(:) = 0.d0
  call xtp_ttl( im,sld,fxj,fxji_ttl,u(1,j),ui_ttl,ub(1,j),iord,ub(1,j),cose(j),0,slope,slopei_ttl,qtmp,qtmpi_ttl,al,ar,a6,a6i_ttl )
  do i = 1, im
    wk1(i,j) = txe5(j)*fxj(i)+tdy5*fy(i,j)
  end do
end do
do j = max(2,jfirst-1), jn2g1
  do i = 1, im
    fy(i,j) = v(i,j)*cosp(j)
  end do
end do
do j = js2g0, jn1g1
  uc(1,j) = u(im,j)-u(1,j)
  do i = 2, im
    uc(i,j) = u(i-1,j)-u(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1(i,2) = wk1(i,2)-cdy(2)*fy(i,2)+cdx(2)*uc(i,2)
  end do
endif
do j = max(3,jfirst), jn2g1
  do i = 1, im
    wk1(i,j) = wk1(i,j)+cdy(j)*(fy(i,j-1)-fy(i,j))+cdx(j)*uc(i,j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    wk1(i,jm) = wk1(i,jm)+cdy(jm)*fy(i,jm-1)+cdx(jm)*uc(i,jm)
  end do
endif
do j = js2gd, jn1gd
  do i = 1, im
    delpf(i,j) = u(i,j)*cose(j)
  end do
end do
if (jfirst .eq. 1) then
  c1 = 0.
  do i = 1, im
    c1 = c1+delpf(i,2)
  end do
  c1 = -(c1*rdy*rcap)
  do i = 1, im
    uc(i,1) = c1
  end do
endif
if (jlast .eq. jm) then
  c2 = 0.
  do i = 1, im
    c2 = c2+delpf(i,jm)
  end do
  c2 = c2*rdy*rcap
  do i = 1, im
    uc(i,jm) = c2
  end do
else
  do i = 1, im
    uc(i,jn2gd) = 1.e+30
  end do
endif
do j = js2gd, min(jm-1,jlast+ng_d-1)
  do i = 1, im-1
    uc(i,j) = (delpf(i,j)-delpf(i,j+1))*cy(j)+(v(i+1,j)-v(i,j))*rdx(j)
  end do
  uc(im,j) = (delpf(im,j)-delpf(im,j+1))*cy(j)+(v(1,j)-v(im,j))*rdx(j)
end do
do j = max(1,jfirst-ng_d), jn1gd
  do i = 1, im
    uc(i,j) = uc(i,j)+f0(j)
  end do
end do
uch_ttl(:,:) = 0.
call tp2d_ttl( va(1,jfirst),uc(1,jfirst-ng_d),uch_ttl,crx(1,jfirst-ng_d),cry(1,jfirst),im,jm,iord,jord,ng_d,fx,fxh_ttl,fy(1:im,&
&jfirst:jlast+1),fyh_ttl,ffsl,crx(1,jfirst),ymass,cosp,0,jfirst,jlast )
do j = js2g0, jlast
  do i = 1, im-1
    uc(i,j) = dtdxe(j)*(wk1(i,j)-wk1(i+1,j))+dyce(j)*fy(i,j)
  end do
  uc(im,j) = dtdxe(j)*(wk1(im,j)-wk1(1,j))+dyce(j)*fy(im,j)
end do
do j = js2g0, jn2g0
  do i = 1, im
    vc(i,j) = dtdy*(wk1(i,j)-wk1(i,j+1))-dx(j)*fx(i,j)
  end do
end do

end subroutine d_sw_ttl


end module     sw_core_ttl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     sw_core_ttl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use sw_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine c_sw_ttl( u, v, pt, delp, uc, vc, ptc, delpf, ptk, cosp, acosp, cose, coslon, sinlon, dxdt, dxe, dtdx2, dtdx4, dtxe5, &
&rdxe, dycp, dydt, dtdy5, cye, fc, ifax, trigs, dc, sc, zt_c, tiny, rcap, im, jm, jfirst, jlast, ng_c, ng_d, ng_s, js2g0, jn2g0, &
&js2gc, jn1gc, iord, jord, cosl5, sinl5, c_sw_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_ttl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
integer :: c_sw_tape_rec
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
real(kind=r8), intent(in) :: cye(jm)
integer, intent(in) :: jn2g0
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: dc(im,js2g0:jn2g0)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
real(kind=r8), intent(in) :: delp(im,jfirst:jlast)
integer, intent(in) :: ng_d
real(kind=r8), intent(in) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx2(jm)
real(kind=r8), intent(in) :: dtdx4(jm)
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dxdt(jm)
real(kind=r8), intent(in) :: dxe(jm)
real(kind=r8), intent(in) :: dycp(jm)
real(kind=r8), intent(in) :: dydt
integer, intent(in) :: jn1gc
integer, intent(in) :: js2gc
real(kind=r8), intent(in) :: fc(js2gc:jn1gc)
integer, intent(in) :: ifax(13)
integer, intent(in) :: iord
integer, intent(in) :: jord
integer, intent(in) :: ng_c
integer, intent(in) :: ng_s
real(kind=r8), intent(in) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(out) :: ptc(im,jfirst:jlast)
real(kind=r8), intent(out) :: ptk(im,jfirst:jlast)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdxe(jm)
real(kind=r8), intent(in) :: sc(js2g0:jn2g0)
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: trigs(3*im/2+1)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(out) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(out) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_c

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6j_ttl(1+im+2*(im/3))
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: crx(im,jfirst-max(1,ng_c):jlast+max(2,ng_c))
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: cx1(im)
real(kind=r8) :: delpfh_ttl(im,jfirst-ng_d:jlast+ng_d)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxjj_ttl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fyh_ttl(im,jfirst-1:jlast+1)
integer :: help_h
integer :: help_i
integer :: i
integer :: im2
integer :: j
integer :: jn1g1
integer :: jn2gc
integer :: js1g1
integer :: js2g1
integer :: js2gc1
integer :: js2gcp1
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1dj_ttl(im)
real(kind=r8) :: p1ke
real(kind=r8) :: p2ke
real(kind=r8) :: pth_ttl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: ptkh_ttl(im,jfirst:jlast)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpj_ttl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopej_ttl(1+im+2*(im/3))
real(kind=r8) :: tm2(im,jfirst:jlast)
real(kind=r8) :: tm2h_ttl(im,1+jlast-jfirst)
real(kind=r8) :: u2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: un
real(kind=r8) :: us
real(kind=r8) :: v2(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: vn
real(kind=r8) :: vs
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfxh_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: ymass(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
im2 = im/2
js1g1 = max(1,jfirst-1)
js2g1 = max(2,jfirst-1)
js2gcp1 = max(2,jfirst-ng_c-1)
jn1g1 = min(jm,jlast+1)
jn2gc = min(jm-1,jlast+ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc1 = js2gc
else
  js2gc1 = max(2,jfirst-ng_c+1)
endif
call vpol5( u(1,jfirst),v(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gcp1, jn2gc
  do i = 1, im-1
    v2(i,j) = v(i,j)+v(i+1,j)
  end do
  v2(im,j) = v(im,j)+v(1,j)
end do
do j = js2gc, jn2gc
  do i = 1, im
    u2(i,j) = u(i,j)+u(i,j+1)
  end do
end do
if (jfirst .eq. 1) then
  us = 0.
  vs = 0.
  do i = 1, im2
    us = us+(u2(i+im2,2)-u2(i,2))*sinlon(i)+(v2(i,2)-v2(i+im2,2))*coslon(i)
    vs = vs+(u2(i+im2,2)-u2(i,2))*coslon(i)+(v2(i+im2,2)-v2(i,2))*sinlon(i)
  end do
  us = us/im
  vs = vs/im
  do i = 1, im2
    u2(i,1) = (-(us*sinlon(i)))-vs*coslon(i)
    v2(i,1) = us*coslon(i)-vs*sinlon(i)
    u2(i+im2,1) = -u2(i,1)
    v2(i+im2,1) = -v2(i,1)
  end do
  p1ke = 0.125*(u2(1,1)**2+v2(1,1)**2)
endif
if (jlast .eq. jm) then
  un = 0.
  vn = 0.
  j = jm-1
  do i = 1, im2
    un = un+(u2(i+im2,j)-u2(i,j))*sinlon(i)+(v2(i+im2,j)-v2(i,j))*coslon(i)
    vn = vn+(u2(i,j)-u2(i+im2,j))*coslon(i)+(v2(i+im2,j)-v2(i,j))*sinlon(i)
  end do
  un = un/im
  vn = vn/im
  do i = 1, im2
    u2(i,jm) = (-(un*sinlon(i)))+vn*coslon(i)
    v2(i,jm) = (-(un*coslon(i)))-vn*sinlon(i)
    u2(i+im2,jm) = -u2(i,jm)
    v2(i+im2,jm) = -v2(i,jm)
  end do
  p2ke = 0.125*(u2(1,jm)**2+v2(1,jm)**2)
endif
do j = js2gc, jn2gc
  uc(1,j) = 0.25*(u2(1,j)+u2(im,j))
  do i = 2, im
    uc(i,j) = 0.25*(u2(i,j)+u2(i-1,j))
  end do
end do
do i = 1, im
  vc(i,jfirst-2) = 0.
  vc(i,jfirst-1) = 0.
  vc(i,jfirst) = 0.
  vc(i,jlast+1) = 0.
  vc(i,jlast+2) = 0.
end do
do j = js2gc, jn1gc
  do i = 1, im
    vc(i,j) = 0.25*(v2(i,j)+v2(i,j-1))
  end do
end do
do j = js2g1, jn1g1
  do i = 1, im
    cry(i,j) = dtdy5*vc(i,j)
  end do
end do
do j = js2g0, jn1g1
  do i = 1, im
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g1, jn2g0
  do i = 1, im
    va(i,j) = 0.5*(cry(i,j)+cry(i,j+1))
  end do
end do
do j = jfirst-1, jlast
  do i = 1, im
    crx(i,j) = 0.
  end do
end do
do j = js2gc, jn2gc
  do i = 1, im
    crx(i,j) = uc(i,j)*dtdx2(j)
  end do
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
delpfh_ttl(:,:) = 0.
call tp2c_ttl( ptk,ptkh_ttl,va(1,jfirst),delpf(1,jfirst-ng_c),delpfh_ttl,crx(1,jfirst-ng_c),cry(1,jfirst),im,jm,iord,jord,ng_c,xfx,&
&xfxh_ttl,yfx,yfxh_ttl,ffsl,rcap,acosp,crx(1,jfirst),ymass,cosp,0,jfirst,jlast )
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
pth_ttl(:,:) = 0.
call tp2c_ttl( tm2,tm2h_ttl,va(1,jfirst),pt(1,jfirst-ng_c),pth_ttl,crx(1,jfirst-ng_c),cry(1,jfirst),im,jm,iord,jord,ng_c,fx,&
&fxh_ttl,fy(1,jfirst),fyh_ttl,ffsl,rcap,acosp,xfx,yfx,cosp,1,jfirst,jlast )
help_h = jn2g0-js2g0+1
call pft2d( ptk(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,v2,crx )
help_i = jn2g0-js2g0+1
call pft2d( tm2(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_i,ifax,trigs,v2,crx )
do j = jfirst, jlast
  do i = 1, im
    ptk(i,j) = delp(i,j)+ptk(i,j)
    ptc(i,j) = (pt(i,j)*delp(i,j)+tm2(i,j))/ptk(i,j)
  end do
end do
call ycc( im,jm,fy,vc(1,jfirst-2),va(1,jfirst-1),va(1,jfirst-1),jord,1,jfirst,jlast )
do j = js2g1, jn2g0
  do i = 1, im
    cx1(i) = dtdx4(j)*u2(i,j)
  end do
  sld =  .false. 
  if (cosp(j) .lt. zt_c) then
    do i = 1, im
      if (abs(cx1(i)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  p1d(im) = uc(1,j)
  do i = 1, im-1
    p1d(i) = uc(i+1,j)
  end do
  p1dj_ttl(:) = 0.d0
  a6j_ttl(:) = 0.d0
  call xtp_ttl( im,sld,fxj,fxjj_ttl,p1d,p1dj_ttl,cx1,iord,cx1,cosp(j),0,slope,slopej_ttl,qtmp,qtmpj_ttl,al,ar,a6,a6j_ttl )
  do i = 1, im
    wk1(i,j) = dxdt(j)*fxj(i)+dydt*fy(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1(i,1) = p1ke
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    wk1(i,jm) = p2ke
  end do
endif
do j = js2gc1, jn1gc
  crx(1,j) = dtxe5(j)*u(im,j)
  do i = 2, im
    crx(i,j) = dtxe5(j)*u(i-1,j)
  end do
end do
do j = js1g1, jlast
  do i = 1, im
    cry(i,j) = dtdy5*v(i,j)
  end do
end do
do j = jfirst, jlast
  do i = 1, im
    ymass(i,j) = cry(i,j)*cosp(j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im
    tm2(i,j) = 0.5*(cry(i,j)+cry(i,j-1))
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    u2(i,1) = 0.
  end do
endif
do j = js2gc, jn2gc
  do i = 1, im
    u2(i,j) = uc(i,j)*cosp(j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    u2(i,jm) = 0.
  end do
endif
do j = js2gc1, jn1gc
  v2(1,j) = fc(j)+(u2(1,j-1)-u2(1,j))*cye(j)+(vc(1,j)-vc(im,j))*rdxe(j)
  do i = 2, im
    v2(i,j) = fc(j)+(u2(i,j-1)-u2(i,j))*cye(j)+(vc(i,j)-vc(i-1,j))*rdxe(j)
  end do
end do
do j = js2gc1, jn1gc
  ffsl(j) =  .false. 
  if (cose(j) .lt. zt_c) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
call tpcc_ttl( tm2,ymass,v2(1,jfirst-ng_d),crx(1:im,jfirst-1:jlast+2),cry(1:im,jfirst:jlast),im,jm,ng_d,iord,jord,fx,fy(1:im,&
&jfirst:jlast),ffsl,cose,jfirst,jlast,slope,qtmp,al,ar,a6 )
do j = js2g0, jn2g0
  uc(1,j) = uc(1,j)+dtdx2(j)*(wk1(im,j)-wk1(1,j))+dycp(j)*fy(1,j)
  do i = 2, im
    uc(i,j) = uc(i,j)+dtdx2(j)*(wk1(i-1,j)-wk1(i,j))+dycp(j)*fy(i,j)
  end do
end do
do j = js2g0, jlast
  do i = 1, im-1
    vc(i,j) = vc(i,j)+dtdy5*(wk1(i,j-1)-wk1(i,j))-dxe(j)*fx(i+1,j)
  end do
  vc(im,j) = vc(im,j)+dtdy5*(wk1(im,j-1)-wk1(im,j))-dxe(j)*fx(1,j)
end do

end subroutine c_sw_ttl


subroutine d_sw_ttl( u, v, uc, vc, pt, delp, delpf, cx3, cy3, mfx, mfy, cdx, cdy, dtdx, dtdxe, dtxe5, txe5, dyce, rdx, cy, dx, f0, &
&js2g0, jn1g1, im, jm, jfirst, jlast, ng_d, ng_s, nq, iord, jord, zt_d, rcap, tiny, dtdy, dtdy5, tdy5, rdy, cosp, acosp, cose, &
&coslon, sinlon, cosl5, sinl5, d_sw_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_ttl

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer, intent(in) :: jm
real(kind=r8), intent(in) :: acosp(jm)
integer, intent(in) :: jn1g1
integer, intent(in) :: js2g0
real(kind=r8), intent(in) :: cdx(js2g0:jn1g1)
real(kind=r8), intent(in) :: cdy(js2g0:jn1g1)
real(kind=r8), intent(in) :: cose(jm)
integer, intent(in) :: im
real(kind=r8), intent(in) :: cosl5(im)
real(kind=r8), intent(in) :: coslon(im)
real(kind=r8), intent(in) :: cosp(jm)
integer, intent(in) :: jfirst
integer, intent(in) :: jlast
integer, intent(in) :: ng_d
real(kind=r8), intent(inout) :: cx3(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: cy(jm)
real(kind=r8), intent(inout) :: cy3(im,jfirst:jlast+1)
integer :: d_sw_tape_rec
real(kind=r8), intent(inout) :: delp(im,jfirst:jlast)
real(kind=r8), intent(inout) :: delpf(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: dtdx(jm)
real(kind=r8), intent(in) :: dtdxe(jm)
real(kind=r8), intent(in) :: dtdy
real(kind=r8), intent(in) :: dtdy5
real(kind=r8), intent(in) :: dtxe5(jm)
real(kind=r8), intent(in) :: dx(jm)
real(kind=r8), intent(in) :: dyce(jm)
real(kind=r8), intent(in) :: f0(jfirst-ng_d:jlast+ng_d)
integer, intent(in) :: iord
integer, intent(in) :: jord
real(kind=r8), intent(inout) :: mfx(im,jfirst:jlast)
real(kind=r8), intent(inout) :: mfy(im,jfirst:jlast+1)
integer, intent(in) :: ng_s
integer, intent(in) :: nq
real(kind=r8), intent(inout) :: pt(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: rcap
real(kind=r8), intent(in) :: rdx(jm)
real(kind=r8), intent(in) :: rdy
real(kind=r8), intent(in) :: sinl5(im)
real(kind=r8), intent(in) :: sinlon(im)
real(kind=r8), intent(in) :: tdy5
real(kind=r8), intent(in) :: tiny
real(kind=r8), intent(in) :: txe5(jm)
real(kind=r8), intent(in) :: u(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8), intent(inout) :: uc(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8), intent(in) :: v(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8), intent(inout) :: vc(im,jfirst-2:jlast+2)
real(kind=r8), intent(in) :: zt_d

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6i_ttl(1+im+2*(im/3))
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c1
real(kind=r8) :: c2
real(kind=r8) :: crx(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: cry(im,jfirst-1:jlast+1)
real(kind=r8) :: delpfh_ttl(im,jfirst-ng_d:jlast+ng_d)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: fxi_ttl(im,1+jlast-jfirst)
real(kind=r8) :: fxj(im)
real(kind=r8) :: fxji_ttl(im)
real(kind=r8) :: fy(im,jfirst-1:jlast+1)
real(kind=r8) :: fyh_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: fyi_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: fyj_ttl(im,1+1+jlast-jfirst)
integer :: i
integer :: j
integer :: jn1gd
integer :: jn2g0
integer :: jn2g1
integer :: jn2gd
integer :: js2gd
real(kind=r8) :: pth_ttl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmpi_ttl(1+im+2*(im/3))
logical :: sld
real(kind=r8) :: slope(-(im/3):im+im/3)
real(kind=r8) :: slopei_ttl(1+im+2*(im/3))
real(kind=r8) :: ub(im,jfirst:jlast+1)
real(kind=r8) :: ubh_ttl(im,jfirst:jlast+1)
real(kind=r8) :: ubi_ttl(im,jfirst:jlast+1)
real(kind=r8) :: uch_ttl(im,jfirst-ng_d:jlast+ng_d)
real(kind=r8) :: ui_ttl(im,jfirst-ng_d:jlast+ng_s)
real(kind=r8) :: va(im,jfirst-1:jlast)
real(kind=r8) :: vh_ttl(im,jfirst-ng_s:jlast+ng_d)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfxh_ttl(im,1+jlast-jfirst)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfxh_ttl(im,1+1+jlast-jfirst)
real(kind=r8) :: ymass(im,jfirst:jlast+1)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
jn2g0 = min(jm-1,jlast)
jn2g1 = min(jm-1,jlast+1)
js2gd = max(2,jfirst-ng_d)
jn2gd = min(jm-1,jlast+ng_d)
jn1gd = min(jm,jlast+ng_d)
call upol5( uc(1,jfirst),vc(1,jfirst),im,jm,coslon,sinlon,cosl5,sinl5,jfirst,jlast )
do j = js2gd, jn2gd
  do i = 1, im
    crx(i,j) = dtdx(j)*uc(i,j)
  end do
end do
do j = js2gd, jn2gd
  ffsl(j) =  .false. 
  if (cosp(j) .lt. zt_d) then
    do i = 1, im
      if (abs(crx(i,j)) .gt. 1.) then
        ffsl(j) =  .true. 
        exit
      endif
    end do
  endif
end do
do j = js2g0, jn1g1
  do i = 1, im
    cry(i,j) = dtdy*vc(i,j)
    ymass(i,j) = cry(i,j)*cose(j)
  end do
end do
do j = js2g0, jn2g0
  do i = 1, im
    if (cry(i,j)*cry(i,j+1) .gt. 0.) then
      if (cry(i,j) .gt. 0.) then
        va(i,j) = cry(i,j)
      else
        va(i,j) = cry(i,j+1)
      endif
    else
      va(i,j) = 0.
    endif
  end do
end do
delpfh_ttl(:,:) = 0.
call tp2c_ttl( ub(1,jfirst),ubi_ttl,va(1,jfirst),delpf(1,jfirst-ng_d),delpfh_ttl,crx(1,jfirst-ng_d),cry(1,jfirst),im,jm,iord,jord,&
&ng_d,xfx,xfxh_ttl,yfx,yfxh_ttl,ffsl,rcap,acosp,crx(1,jfirst),ymass,cosp,0,jfirst,jlast )
if (nq .gt. 0) then
  do j = js2g0, jn2g0
    do i = 1, im
      cx3(i,j) = cx3(i,j)+crx(i,j)
      mfx(i,j) = mfx(i,j)+xfx(i,j)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      cy3(i,j) = cy3(i,j)+cry(i,j)
      mfy(i,j) = mfy(i,j)+yfx(i,j)
    end do
  end do
endif
do j = js2g0, jn2g0
  if (ffsl(j)) then
    do i = 1, im
      xfx(i,j) = xfx(i,j)/sign(max(abs(crx(i,j)),tiny),crx(i,j))
    end do
  endif
end do
do j = jfirst, jlast
  do i = 1, im
    wk1(i,j) = delp(i,j)
    delp(i,j) = wk1(i,j)+ub(i,j)
  end do
end do
pth_ttl(:,:) = 0.
call tp2c_ttl( ub(1,jfirst),ubh_ttl,va(1,jfirst),pt(1,jfirst-ng_d),pth_ttl,crx(1,jfirst-ng_d),cry(1,jfirst),im,jm,iord,jord,ng_d,&
&fx,fxi_ttl,fy(1:im,jfirst:jlast+1),fyj_ttl,ffsl,rcap,acosp,xfx,yfx(1,jfirst),cosp,1,jfirst,jlast )
do j = jfirst, jlast
  do i = 1, im
    pt(i,j) = (pt(i,j)*wk1(i,j)+ub(i,j))/delp(i,j)
  end do
end do
do j = js2g0, jn1g1
  ub(1,j) = dtdy5*(vc(1,j)+vc(im,j))
  do i = 2, im
    ub(i,j) = dtdy5*(vc(i,j)+vc(i-1,j))
  end do
end do
vh_ttl(:,:) = 0.
call ytp_ttl( im,jm,fy(1:im,jfirst:jlast+1),fyi_ttl,v(1,jfirst-ng_d),vh_ttl,ub(1,jfirst),ub(1,jfirst),ng_d,jord,1,jfirst,jlast )
do j = js2g0, jn1g1
  do i = 1, im
    ub(i,j) = dtxe5(j)*(uc(i,j)+uc(i,j-1))
  end do
end do
do j = js2g0, jn1g1
  sld =  .false. 
  if (cose(j) .lt. zt_d) then
    do i = 1, im
      if (abs(ub(i,j)) .gt. 1.) then
        sld =  .true. 
        exit
      endif
    end do
  endif
  ui_ttl(:,:) = 0.
  a6i_ttl(:) = 0.d0
  call xtp_ttl( im,sld,fxj,fxji_ttl,u(1,j),ui_ttl,ub(1,j),iord,ub(1,j),cose(j),0,slope,slopei_ttl,qtmp,qtmpi_ttl,al,ar,a6,a6i_ttl )
  do i = 1, im
    wk1(i,j) = txe5(j)*fxj(i)+tdy5*fy(i,j)
  end do
end do
do j = max(2,jfirst-1), jn2g1
  do i = 1, im
    fy(i,j) = v(i,j)*cosp(j)
  end do
end do
do j = js2g0, jn1g1
  uc(1,j) = u(im,j)-u(1,j)
  do i = 2, im
    uc(i,j) = u(i-1,j)-u(i,j)
  end do
end do
if (jfirst .eq. 1) then
  do i = 1, im
    wk1(i,2) = wk1(i,2)-cdy(2)*fy(i,2)+cdx(2)*uc(i,2)
  end do
endif
do j = max(3,jfirst), jn2g1
  do i = 1, im
    wk1(i,j) = wk1(i,j)+cdy(j)*(fy(i,j-1)-fy(i,j))+cdx(j)*uc(i,j)
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    wk1(i,jm) = wk1(i,jm)+cdy(jm)*fy(i,jm-1)+cdx(jm)*uc(i,jm)
  end do
endif
do j = js2gd, jn1gd
  do i = 1, im
    delpf(i,j) = u(i,j)*cose(j)
  end do
end do
if (jfirst .eq. 1) then
  c1 = 0.
  do i = 1, im
    c1 = c1+delpf(i,2)
  end do
  c1 = -(c1*rdy*rcap)
  do i = 1, im
    uc(i,1) = c1
  end do
endif
if (jlast .eq. jm) then
  c2 = 0.
  do i = 1, im
    c2 = c2+delpf(i,jm)
  end do
  c2 = c2*rdy*rcap
  do i = 1, im
    uc(i,jm) = c2
  end do
else
  do i = 1, im
    uc(i,jn2gd) = 1.e+30
  end do
endif
do j = js2gd, min(jm-1,jlast+ng_d-1)
  do i = 1, im-1
    uc(i,j) = (delpf(i,j)-delpf(i,j+1))*cy(j)+(v(i+1,j)-v(i,j))*rdx(j)
  end do
  uc(im,j) = (delpf(im,j)-delpf(im,j+1))*cy(j)+(v(1,j)-v(im,j))*rdx(j)
end do
do j = max(1,jfirst-ng_d), jn1gd
  do i = 1, im
    uc(i,j) = uc(i,j)+f0(j)
  end do
end do
uch_ttl(:,:) = 0.
call tp2d_ttl( va(1,jfirst),uc(1,jfirst-ng_d),uch_ttl,crx(1,jfirst-ng_d),cry(1,jfirst),im,jm,iord,jord,ng_d,fx,fxh_ttl,fy(1:im,&
&jfirst:jlast+1),fyh_ttl,ffsl,crx(1,jfirst),ymass,cosp,0,jfirst,jlast )
do j = js2g0, jlast
  do i = 1, im-1
    uc(i,j) = dtdxe(j)*(wk1(i,j)-wk1(i+1,j))+dyce(j)*fy(i,j)
  end do
  uc(im,j) = dtdxe(j)*(wk1(im,j)-wk1(1,j))+dyce(j)*fy(im,j)
end do
do j = js2g0, jn2g0
  do i = 1, im
    vc(i,j) = dtdy*(wk1(i,j)-wk1(i,j+1))-dx(j)*fx(i,j)
  end do
end do

end subroutine d_sw_ttl


end module     sw_core_ttl


#endif /* SPMD */
