#ifdef    SPMD
C                           DISCLAIMER
C
C   This file was generated by TAF version 1.6.1
C
C   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
C   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
C   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
C   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
C   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
C   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
C   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
C   OF THE POSSIBILITY OF SUCH DAMAGES.
C
C                           Haftungsbeschraenkung
C   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
C   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
C   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
C   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
C   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
C   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
C   Mitteilung darueber an FastOpt.
!
!   !REVISION HISTORY:
!
!    25Sep2007 Todling  Add trajectory recall; various adaptations
!                       and testing - working code now.
C
      module     stepon_ttl
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use precision
      use prognostics
      use prognostics_q
      use mod_comm, only : gid,mp_exit, mp_init, y_decomp
      use mod_comm, only : numcpu
      use m_strtemplate
      use timingmodule, only : timing_init, timing_off, timing_on
      use stepon
      use mapz_module, only : te_map

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

      contains
      subroutine stepon_do_ttl ( prog, xpertq, ypertq )
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use m_iostate, only : getstate
      use fvcore, only : ns,fvcore_do
      use fvcore, only : fvcore_tape_rec
      use fvcore, only : dynpkg_n2,dynpkg_nsplit
      use fvcore, only : ng_c
      use hswf, only : hswf_do
      use fvcore_ttl, only : fvcore_do_ttl

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

C==============================================
C declare local variables
C==============================================
      real(kind=r8) :: ae
      real(kind=r8) :: akap
      real(kind=r8) :: cp
      real(kind=r8) :: grav
      real(kind=r8) :: te0
      integer :: iinner
      integer :: iouter
      integer :: nymd_trj, nhms_trj
      integer :: nx
      real(kind=r8) :: om
      real(kind=r8) :: rg
      logical :: doremap
      type(dyn_prog) :: prog
      type(dynq) :: xpertq
      type(dynq) :: ypertq
      
      real(r8), pointer ::q_ttl(:,:,:,:) ! perturbation tracer mixing ratios

! Set pointers
! ------------
       u   => prog%u
       v   => prog%v
      pt   => prog%pt
      delp => prog%delp
      q    => prog%q

      q_ttl => xpertq%q

      if ( (jlast-jfirst+1)/numcpu >= 4 ) then
          nx = 1
      else
          nx = 4
      endif

C----------------------------------------------
C TANGENT LINEAR AND FUNCTION STATEMENTS
C----------------------------------------------
      do iinner = 1, ninner
        nstep = iinner-1+(iouter-1)*ninner
#ifdef TIMING
        call g_timing_on( 'FVCORE' )
#endif
        om = omega
        cp = cpair
        rg = rair
        ae = rearth

        nymd_trj = nymd
        nhms_trj = nhms
        call getstate( nymd_trj, nhms_trj, prog, doremap )
        if (doremap) then
           te0 = 1.0
           call te_map(.false., .false., ps, omga, pe, delp, pkz, pk, mpdt,
     &                  imr, jnp, nl, nx, jfirst, jlast, nq,  u,  v,
     &                  pt, q, phis,  cpair, cappa, kord, peln, te0,
     &                  ng_d, ng_s, 0 )
        endif
 
        call fvcore_do_ttl( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,q_ttl,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,
     $ae,iord,jord,kord,umax,omga,peln,consv,convt )
        call g_timing_off( 'FVCORE' )

        nstep = nstep+1
        call tick( nymd,nhms,pdt )
        mcsec = nsecf(nhms)
        if (force_dycore) then
          akap = cappa
          call hswf_do( imr,jnp,nl,jfirst,jlast,u,v,pt,pe,pkz,pdt,akap,grav,rg,dcaf, .true. ,rayf,sinp,cosp,sine,cose,coslon,sinlon,
     $ng_s,ng_d )
        endif
        if (aoa) then
          model_time = nstep*pdt
          call age_of_air_ttl( imr,jnp,nl,jfirst,jlast,ng_d,model_time,pe,q(1,jfirst-ng_d,1,nq),q_ttl(1,jfirst-ng_d,1,nq) )
        endif
      end do ! < iinner >
      call g_timing_off( 'TOTAL' )

      ypertq%q = q_ttl

      end subroutine stepon_do_ttl


      end module     stepon_ttl


#else  /* SPMD */
C                           DISCLAIMER
C
C   This file was generated by TAF version 1.6.1
C
C   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
C   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
C   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
C   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
C   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
C   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
C   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
C   OF THE POSSIBILITY OF SUCH DAMAGES.
C
C                           Haftungsbeschraenkung
C   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
C   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
C   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
C   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
C   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
C   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
C   Mitteilung darueber an FastOpt.
C
      module     stepon_ttl
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use precision
      use prognostics
      use prognostics_ttl
      use reference
      use m_strtemplate
#ifdef TIMING
      use timingmodule, only : timing_init, timing_off, timing_on
#endif
      use stepon
      use m_strtemplate

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

      contains
      subroutine stepon_do_ttl
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use fvcore, only : ns,fvcore_do
      use fvcore, only : fvcore_tape_rec
      use fvcore, only : dynpkg_n2,dynpkg_nsplit
      use fvcore, only : ng_c
      use hswf, only : hswf_do
      use fvcore_ttl, only : fvcore_do_ttl
      use m_iostate, only : getstate
      use mapz_module, only : te_map

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

C==============================================
C declare local variables
C==============================================
      real(kind=r8) :: ae
      real(kind=r8) :: akap
      real(kind=r8) :: cp
      real(kind=r8) :: grav
      integer :: iinner
      integer :: iouter
      real(kind=r8) :: om
      real(kind=r8) :: rg
      real(kind=r8) :: te0

      character*255 :: fnametrj
      integer :: nhms_trj
      integer :: nymd_trj
      integer :: rmaptfrq
      integer :: nx
      integer :: ierr

C----------------------------------------------
C TANGENT LINEAR AND FUNCTION STATEMENTS
C----------------------------------------------
      iouter = 1
      do iinner = 1, ninner

        nymd_trj = nymd
        nhms_trj = nhms
        call tick( nymd_trj,nhms_trj,pdt )
        if (trajfrq>0) then
          strajfrq = nsecf(trajfrq)
          snhms    = nsecf(nhms_trj)
          if (mod(snhms,strajfrq)==0) then
            call strTemplate( fnametrj, trajtmpl,
     &                        xid=trim(job), nymd=nymd_trj, nhms=nhms_trj )
            call getstate(  .true. ,fnametrj,job,nymd_trj,nhms_trj,ptop,ks,stat=ierr )
                                                                                                                       
            rmaptfrq = nsecf(rmaptrj)
            if (mod(snhms,rmaptfrq)==0) then
              nx = 4
              te0 = 1.0
              call te_map(.false., .false., ps, omga, pe, delp, pkz, pk, mpdt,
     &                     imr, jnp, nl, nx, jfirst, jlast, nq,  u,  v,
     &                     pt, q, phis,  cpair, cappa, kord, peln, te0,
     &                     ng_d, ng_s, 0 )
            endif
          endif
        endif

        nstep = iinner-1+(iouter-1)*ninner
#ifdef TIMING
        call g_timing_on( 'FVCORE' )
#endif
        om = omega
        cp = cpair
        rg = rair
        ae = rearth

        call fvcore_do_ttl( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,q_ttl,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,
     $ae,iord,jord,kord,umax,omga,peln,consv,convt )
#ifdef TIMING
        call g_timing_off( 'FVCORE' )
#endif
        nstep = nstep+1
        call tick( nymd,nhms,pdt )
        mcsec = nsecf(nhms)
        if (force_dycore) then
          akap = cappa
          call hswf_do( imr,jnp,nl,jfirst,jlast,u,v,pt,pe,pkz,pdt,akap,grav,rg,dcaf, .true. ,rayf,sinp,cosp,sine,cose,coslon,sinlon,
     $ng_s,ng_d )
        endif
        if (aoa) then
          model_time = nstep*pdt
          call age_of_air_ttl( imr,jnp,nl,jfirst,jlast,ng_d,model_time,pe,q(1,jfirst-ng_d,1,nq),q_ttl(1,jfirst-ng_d,1,nq) )
        endif
      end do
#ifdef TIMING
      call g_timing_off( 'TOTAL' )
#endif

      end subroutine stepon_do_ttl


      subroutine stepon_set_ttl
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use prognostics_ttl

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

C----------------------------------------------
C RESET TANGENT MODULE VARIABLES
C----------------------------------------------
      q_ttl(:,:,:,:) = 0.

      end subroutine stepon_set_ttl


      end module     stepon_ttl


#endif /* SPMD */
