#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     mapz_module_ttl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mapz_module

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine kmppm_ttl( dm, dm_ttl, a4, a4_ttl, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a4(4,im)
real(kind=r8) :: a4_ttl(4,im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ttl(im)
integer :: lmt

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ttl
real(kind=r8) :: da1
real(kind=r8) :: da1_ttl
real(kind=r8) :: da2
real(kind=r8) :: da2_ttl
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ttl
integer :: i
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (lmt .ne. 3) then
  if (lmt .eq. 0) then
    do i = 1, im
      if (dm(i) .eq. 0.) then
        a4_ttl(2,i) = a4_ttl(1,i)
        a4(2,i) = a4(1,i)
        a4_ttl(3,i) = a4_ttl(1,i)
        a4(3,i) = a4(1,i)
        a4_ttl(4,i) = 0.d0
        a4(4,i) = 0.
      else
        da1_ttl = a4_ttl(3,i)-a4_ttl(2,i)
        da1 = a4(3,i)-a4(2,i)
        da2_ttl = 2*da1_ttl*da1
        da2 = da1**2
        a6da_ttl = a4_ttl(4,i)*da1+da1_ttl*a4(4,i)
        a6da = a4(4,i)*da1
        if (a6da .lt. (-da2)) then
          a4_ttl(4,i) = 3*a4_ttl(2,i)-3*a4_ttl(1,i)
          a4(4,i) = 3.*(a4(2,i)-a4(1,i))
          a4_ttl(3,i) = (-a4_ttl(4,i))+a4_ttl(2,i)
          a4(3,i) = a4(2,i)-a4(4,i)
        else if (a6da .gt. da2) then
          a4_ttl(4,i) = 3*a4_ttl(3,i)-3*a4_ttl(1,i)
          a4(4,i) = 3.*(a4(3,i)-a4(1,i))
          a4_ttl(2,i) = (-a4_ttl(4,i))+a4_ttl(3,i)
          a4(2,i) = a4(3,i)-a4(4,i)
        endif
      endif
    end do
  else if (lmt .eq. 1) then
    do i = 1, im
      qmp_ttl = 2*dm_ttl(i)
      qmp = 2.*dm(i)
      a4_ttl(2,i) = (-(a4_ttl(2,i)*(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i))))))+a4_ttl(1,i)*(1+(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,&
&qmp)*sign(1.d0,a4(2,i)-a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))-qmp_ttl*(0.5+sign(0.5d0,abs(a4(2,i)-a4(1,i))-&
&abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i))))
      a4(2,i) = a4(1,i)-sign(min(abs(qmp),abs(a4(2,i)-a4(1,i))),qmp)
      a4_ttl(3,i) = a4_ttl(3,i)*(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i))))+a4_ttl(1,i)*(1-(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*&
&sign(1.d0,a4(3,i)-a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i)))))+qmp_ttl*(0.5+sign(0.5d0,abs(a4(3,i)-a4(1,i))-&
&abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4(3,i) = a4(1,i)+sign(min(abs(qmp),abs(a4(3,i)-a4(1,i))),qmp)
      a4_ttl(4,i) = (-3)*a4_ttl(3,i)-3*a4_ttl(2,i)+6*a4_ttl(1,i)
      a4(4,i) = 3.*(2.*a4(1,i)-(a4(2,i)+a4(3,i)))
    end do
  else if (lmt .eq. 2) then
    do i = 1, im
      if (abs(a4(3,i)-a4(2,i)) .lt. (-a4(4,i))) then
        fmin_ttl = a4_ttl(4,i)*((-(0.25*(a4(3,i)-a4(2,i))**2/(a4(4,i)*a4(4,i))))+r12)+a4_ttl(3,i)*(0.5*(a4(3,i)-a4(2,i))/a4(4,i))+&
&a4_ttl(2,i)*((-0.5)*(a4(3,i)-a4(2,i))/a4(4,i))+a4_ttl(1,i)
        fmin = a4(1,i)+0.25*(a4(3,i)-a4(2,i))**2/a4(4,i)+a4(4,i)*r12
        if (fmin .lt. 0.) then
          if (a4(1,i) .lt. a4(3,i) .and. a4(1,i) .lt. a4(2,i)) then
            a4_ttl(3,i) = a4_ttl(1,i)
            a4(3,i) = a4(1,i)
            a4_ttl(2,i) = a4_ttl(1,i)
            a4(2,i) = a4(1,i)
            a4_ttl(4,i) = 0.d0
            a4(4,i) = 0.
          else if (a4(3,i) .gt. a4(2,i)) then
            a4_ttl(4,i) = 3*a4_ttl(2,i)-3*a4_ttl(1,i)
            a4(4,i) = 3.*(a4(2,i)-a4(1,i))
            a4_ttl(3,i) = (-a4_ttl(4,i))+a4_ttl(2,i)
            a4(3,i) = a4(2,i)-a4(4,i)
          else
            a4_ttl(4,i) = 3*a4_ttl(3,i)-3*a4_ttl(1,i)
            a4(4,i) = 3.*(a4(3,i)-a4(1,i))
            a4_ttl(2,i) = (-a4_ttl(4,i))+a4_ttl(3,i)
            a4(2,i) = a4(3,i)-a4(4,i)
          endif
        endif
      endif
    end do
  endif
endif

end subroutine kmppm_ttl


subroutine map1_ppm_ttl( km, pe1, q1, kn, pe2, q2, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km)
real(kind=r8) :: q2(im,jfirst-ng_s:jlast+ng_n,kn)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: esl
integer :: i
integer :: ikind
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pr
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4h_ttl(4,1+i2-i1,km)
real(kind=r8) :: qsum

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
    q4(1,i,k) = q1(i,j,k)
  end do
end do
q4h_ttl(:,:,:) = 0.d0
call ppm2m_ttl( q4,q4h_ttl,dp1,km,i1,i2,iv,kord )
do i = i1, i2
  k0 = 1
  do k = 1, kn
    ikind = 0
    do l = k0, km
      if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
        if (pe2(i,k+1) .le. pe1(i,l+1)) then
          ikind = 1
          exit
        else
          ikind = 2
          exit
        endif
      endif
    end do
    if (ikind .eq. 0) then
      stop 'error'
    else if (ikind .eq. 1) then
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
      q2(i,j,k) = q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(pr+pl)-q4(4,i,l)*r3*(pr*(pr+pl)+pl**2)
    else
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      do ll = l+1, km
        if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
        else
          lf = ll
          exit
        endif
      end do
      if (lf .eq. 0) then
        do ll = l+1, km
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
      else
        do ll = l+1, lf-1
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
        ll = lf
        delp = pe2(i,k+1)-pe1(i,ll)
        esl = delp/dp1(i,ll)
        qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
      endif
      q2(i,j,k) = qsum/(pe2(i,k+1)-pe2(i,k))
    endif
  end do
end do

end subroutine map1_ppm_ttl


subroutine mapn_ppm_ttl( km, pe1, q1, q1_ttl, nq, kn, pe2, q2, q2_ttl, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
integer :: nq
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q1_ttl(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q2(im,jfirst-ng_s:jlast+ng_n,kn,nq)
real(kind=r8) :: q2_ttl(im,jfirst-ng_s:jlast+ng_n,kn,nq)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: esl
integer :: i
integer :: ikind
integer :: iq
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pr
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_ttl(4,i1:i2,km)
real(kind=r8) :: qsum
real(kind=r8) :: qsum_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
  end do
end do
do iq = 1, nq
  do k = 1, km
    do i = i1, i2
      q4_ttl(1,i,k) = q1_ttl(i,j,k,iq)
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  call ppm2m_ttl( q4,q4_ttl,dp1,km,i1,i2,iv,kord )
  do i = i1, i2
    k0 = 1
    do k = 1, kn
      ikind = 0
      do l = k0, km
        if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
          if (pe2(i,k+1) .le. pe1(i,l+1)) then
            ikind = 1
            exit
          else
            ikind = 2
            exit
          endif
        endif
      end do
      if (ikind .eq. 0) then
        stop 'error'
      else if (ikind .eq. 1) then
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
        q2_ttl(i,j,k,iq) = q4_ttl(4,i,l)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))+0.5*q4_ttl(3,i,l)*(pr+pl)+q4_ttl(2,i,l)*(1+(-0.5)*(pr+&
&pl))
        q2(i,j,k,iq) = q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(pr+pl)-q4(4,i,l)*r3*(pr*(pr+pl)+pl**2)
      else
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        qsum_ttl = q4_ttl(4,i,l)*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))+0.5*q4_ttl(3,i,l)*(pe1(i,l+1)-pe2(i,k))*&
&(1.+pl)+q4_ttl(2,i,l)*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
        qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        do ll = l+1, km
          if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
          else
            lf = ll
            exit
          endif
        end do
        if (lf .eq. 0) then
          do ll = l+1, km
            qsum_ttl = q4_ttl(1,i,ll)*dp1(i,ll)+qsum_ttl
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
        else
          do ll = l+1, lf-1
            qsum_ttl = q4_ttl(1,i,ll)*dp1(i,ll)+qsum_ttl
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
          ll = lf
          delp = pe2(i,k+1)-pe1(i,ll)
          esl = delp/dp1(i,ll)
          qsum_ttl = 0.5*q4_ttl(4,i,ll)*delp*esl*(1.-r23*esl)+0.5*q4_ttl(3,i,ll)*delp*esl+q4_ttl(2,i,ll)*delp*(1+(-0.5)*esl)+&
&qsum_ttl
          qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        endif
        q2_ttl(i,j,k,iq) = qsum_ttl/(pe2(i,k+1)-pe2(i,k))
        q2(i,j,k,iq) = qsum/(pe2(i,k+1)-pe2(i,k))
      endif
    end do
  end do
end do

end subroutine mapn_ppm_ttl


subroutine ppm2m_ttl( a4, a4_ttl, delp, km, i1, i2, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ttl(4,i1:i2,km)
real(kind=r8) :: delp(i1:i2,km)
integer :: iv
integer :: kord

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a1
real(kind=r8) :: a2
real(kind=r8) :: c1
real(kind=r8) :: c1_ttl
real(kind=r8) :: c2
real(kind=r8) :: c3
real(kind=r8) :: c3_ttl
real(kind=r8) :: cmax
real(kind=r8) :: cmax_ttl
real(kind=r8) :: cmin
real(kind=r8) :: cmin_ttl
real(kind=r8) :: d1
real(kind=r8) :: d2
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: dc(i1:i2,km)
real(kind=r8) :: dc_ttl(i1:i2,km)
double precision :: dch
double precision :: dci
real(kind=r8) :: delq(i1:i2,km)
real(kind=r8) :: delq_ttl(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ttl(i1:i2,km)
real(kind=r8) :: dq
real(kind=r8) :: dq_ttl
real(kind=r8) :: fac
real(kind=r8) :: h2(i1:i2,km)
real(kind=r8) :: h2_ttl(i1:i2,km)
integer :: i
integer :: it
integer :: k
integer :: km1
real(kind=r8) :: lac
real(kind=r8) :: lac_ttl
integer :: lmt
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ttl
real(kind=r8) :: qm
real(kind=r8) :: qm_ttl
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxh
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminh
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ttl
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
km1 = km-1
it = i2-i1+1
do k = 2, km
  do i = i1, i2
    delq_ttl(i,k-1) = (-a4_ttl(1,i,k-1))+a4_ttl(1,i,k)
    delq(i,k-1) = a4(1,i,k)-a4(1,i,k-1)
    d4(i,k) = delp(i,k-1)+delp(i,k)
  end do
end do
do k = 2, km1
  do i = i1, i2
    c1_ttl = 0.d0
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp_ttl = c1_ttl*(delp(i,k)*delq(i,k)/(d4(i,k)+delp(i,k+1)))+delq_ttl(i,k-1)*(delp(i,k)*c2/(d4(i,k)+delp(i,k+1)))+delq_ttl(i,k)&
&*(delp(i,k)*c1/(d4(i,k)+delp(i,k+1)))
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmaxh = max(a4(1,i,k-1),a4(1,i,k))
    qmax_ttl = (-a4_ttl(1,i,k))+a4_ttl(1,i,k+1)*(0.5-sign(0.5d0,qmaxh-a4(1,i,k+1)))+(a4_ttl(1,i,k-1)*(0.5+sign(0.5d0,a4(1,i,k-1)-&
&a4(1,i,k)))+a4_ttl(1,i,k)*(0.5-sign(0.5d0,a4(1,i,k-1)-a4(1,i,k))))*(0.5+sign(0.5d0,qmaxh-a4(1,i,k+1)))
    qmax = max(qmaxh,a4(1,i,k+1))-a4(1,i,k)
    qminh = min(a4(1,i,k-1),a4(1,i,k))
    qmin_ttl = a4_ttl(1,i,k)-(a4_ttl(1,i,k+1)*(0.5-sign(0.5d0,a4(1,i,k+1)-qminh))+(a4_ttl(1,i,k-1)*(0.5+sign(0.5d0,a4(1,i,k)-a4(1,&
&i,k-1)))+a4_ttl(1,i,k)*(0.5-sign(0.5d0,a4(1,i,k)-a4(1,i,k-1))))*(0.5+sign(0.5d0,a4(1,i,k+1)-qminh)))
    qmin = a4(1,i,k)-min(qminh,a4(1,i,k+1))
    dch = min(abs(tmp),qmax)
    dci = min(dch,qmin)
    dc_ttl(i,k) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dch))+qmin_ttl*(0.5-sign(0.5d0,qmin-dch)))*sign(1.d0,dci)*sign(1.d0,tmp)
    dc(i,k) = sign(dci,tmp)
    df2_ttl(i,k) = tmp_ttl
    df2(i,k) = tmp
  end do
end do
do k = 3, km1
  do i = i1, i2
    c1_ttl = delq_ttl(i,k-1)*(delp(i,k-1)/d4(i,k))
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a4_ttl(2,i,k) = a4_ttl(1,i,k-1)+c1_ttl*(1+2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*(a1-a2))+dc_ttl(i,k-1)*2./(d4(i,k-1)+d4(i,k+1))*&
&delp(i,k)*a2-dc_ttl(i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k-1)*a1
    a4(2,i,k) = a4(1,i,k-1)+c1+2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-delp(i,k-1)*a1*dc(i,k))
  end do
end do
call steepz_ttl( i1,i2,km,a4,a4_ttl,df2,df2_ttl,dc,dc_ttl,delq,delq_ttl,delp,d4 )
do i = i1, i2
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm_ttl = a4_ttl(1,i,2)*(d1/(d1+d2))+a4_ttl(1,i,1)*(d2/(d1+d2))
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq_ttl = a4_ttl(1,i,2)*(2/(d1+d2))+a4_ttl(1,i,1)*((-2)/(d1+d2))
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1_ttl = a4_ttl(2,i,3)*(4/(d2*(2.*d2*d2+d1*(d2+3.*d1))))-dq_ttl*(4.*d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))+qm_ttl*((-4)/(d2*(2.*d2*d2+&
&d1*(d2+3.*d1))))
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3_ttl = (-(0.5*c1_ttl*(d2*(5.*d1+d2)-3.*d1**2)))+dq_ttl
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4_ttl(2,i,2) = (-(0.25*c1_ttl*d1*d2*(d2+3.*d1)))+qm_ttl
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4_ttl(2,i,1) = a4_ttl(2,i,2)+2*c1_ttl*d1*d1**2-c3_ttl*d1
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  dc_ttl(i,1) = (-a4_ttl(2,i,1))+a4_ttl(1,i,1)
  dc(i,1) = a4(1,i,1)-a4(2,i,1)
  cmax_ttl = a4_ttl(1,i,2)*(0.5-sign(0.5d0,a4(1,i,1)-a4(1,i,2)))+a4_ttl(1,i,1)*(0.5+sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin_ttl = a4_ttl(1,i,2)*(0.5-sign(0.5d0,a4(1,i,2)-a4(1,i,1)))+a4_ttl(1,i,1)*(0.5+sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4_ttl(2,i,2) = a4_ttl(2,i,2)*(0.5-sign(0.5d0,cmin-a4(2,i,2)))+cmin_ttl*(0.5+sign(0.5d0,cmin-a4(2,i,2)))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  a4_ttl(2,i,2) = a4_ttl(2,i,2)*(0.5-sign(0.5d0,a4(2,i,2)-cmax))+cmax_ttl*(0.5+sign(0.5d0,a4(2,i,2)-cmax))
  a4(2,i,2) = min(cmax,a4(2,i,2))
end do
if (iv .eq. 0) then
  do i = i1, i2
    a4_ttl(2,i,1) = a4_ttl(1,i,1)
    a4(2,i,1) = a4(1,i,1)
    a4_ttl(3,i,1) = a4_ttl(1,i,1)
    a4(3,i,1) = a4(1,i,1)
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4_ttl(2,i,1) = a4_ttl(1,i,1)
      a4(2,i,1) = a4(1,i,1)
      a4_ttl(3,i,1) = a4_ttl(1,i,1)
      a4(3,i,1) = a4(1,i,1)
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4_ttl(2,i,1) = 0.d0
        a4(2,i,1) = 0.
      else
        a4_ttl(2,i,1) = (a4_ttl(2,i,1)*(0.5-sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(2,i,1))+&
&a4_ttl(1,i,1)*(0.5+sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(1,i,1)))*sign(1.d0,&
&min(abs(a4(1,i,1)),abs(a4(2,i,1))))
        a4(2,i,1) = sign(min(abs(a4(1,i,1)),abs(a4(2,i,1))),a4(1,i,1))
      endif
    end do
  endif
endif
do i = i1, i2
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm_ttl = a4_ttl(1,i,km)*(d2/(d1+d2))+a4_ttl(1,i,km1)*(d1/(d1+d2))
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq_ttl = a4_ttl(1,i,km)*((-2)/(d1+d2))+a4_ttl(1,i,km1)*(2/(d1+d2))
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1_ttl = a4_ttl(2,i,km1)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))-dq_ttl*(d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))-qm_ttl/(d2*(2.*d2*d2+d1*(d2+3.*&
&d1)))
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3_ttl = (-(2*c1_ttl*(d2*(5.*d1+d2)-3.*d1**2)))+dq_ttl
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4_ttl(2,i,km) = (-(c1_ttl*d1*d2*(d2+3.*d1)))+qm_ttl
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4_ttl(3,i,km) = a4_ttl(2,i,km)+8*c1_ttl*d1*d1**2-c3_ttl*d1
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  dc_ttl(i,km) = a4_ttl(3,i,km)-a4_ttl(1,i,km)
  dc(i,km) = a4(3,i,km)-a4(1,i,km)
  cmax_ttl = a4_ttl(1,i,km)*(0.5+sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))+a4_ttl(1,i,km1)*(0.5-sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin_ttl = a4_ttl(1,i,km)*(0.5+sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))+a4_ttl(1,i,km1)*(0.5-sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4_ttl(2,i,km) = a4_ttl(2,i,km)*(0.5-sign(0.5d0,cmin-a4(2,i,km)))+cmin_ttl*(0.5+sign(0.5d0,cmin-a4(2,i,km)))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  a4_ttl(2,i,km) = a4_ttl(2,i,km)*(0.5-sign(0.5d0,a4(2,i,km)-cmax))+cmax_ttl*(0.5+sign(0.5d0,a4(2,i,km)-cmax))
  a4(2,i,km) = min(cmax,a4(2,i,km))
end do
if (iv .eq. 0) then
  do i = i1, i2
    a4_ttl(3,i,km) = a4_ttl(3,i,km)*(0.5-sign(0.5d0,0._8-a4(3,i,km)))
    a4(3,i,km) = max(0._8,a4(3,i,km))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4_ttl(3,i,km) = 0.d0
      a4(3,i,km) = 0.
    else
      a4_ttl(3,i,km) = (a4_ttl(3,i,km)*(0.5-sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(3,i,km)&
&)+a4_ttl(1,i,km)*(0.5+sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(1,i,km)))*sign(1.d0,&
&min(abs(a4(1,i,km)),abs(a4(3,i,km))))
      a4(3,i,km) = sign(min(abs(a4(1,i,km)),abs(a4(3,i,km))),a4(1,i,km))
    endif
  end do
endif
do k = 1, km1
  do i = i1, i2
    a4_ttl(3,i,k) = a4_ttl(2,i,k+1)
    a4(3,i,k) = a4(2,i,k+1)
  end do
end do
do k = 1, 2
  do i = i1, i2
    a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,0 )
end do
if (kord .ge. 7) then
  do k = 2, km1
    do i = i1, i2
      h2_ttl(i,k) = (-dc_ttl(i,k-1))+dc_ttl(i,k+1)
      h2(i,k) = dc(i,k+1)-dc(i,k-1)
    end do
  end do
  if (kord .eq. 7) then
    fac = 1.5
  else
    fac = 0.125
  endif
  do k = 3, km-2
    do i = i1, i2
      pmp_ttl = 2*dc_ttl(i,k)
      pmp = 2.*dc(i,k)
      qmp_ttl = a4_ttl(1,i,k)+pmp_ttl
      qmp = a4(1,i,k)+pmp
      lac_ttl = a4_ttl(1,i,k)+dc_ttl(i,k)+h2_ttl(i,k-1)*fac
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,qmp-a4(1,i,k)))+qmp_ttl*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin = min(a4(1,i,k),qmp,lac)
      qmax_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,a4(1,i,k)-qmp))+qmp_ttl*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax = max(a4(1,i,k),qmp,lac)
      a4_ttl(3,i,k) = a4_ttl(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5+sign(0.5d0,a4(3,i,k)-qmin))+qmax_ttl*(0.5-&
&sign(0.5d0,qmax-max(a4(3,i,k),qmin)))+qmin_ttl*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5-sign(0.5d0,a4(3,i,k)-qmin))
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp_ttl = 2*dc_ttl(i,k)
      pmp = 2.*dc(i,k)
      qmp_ttl = a4_ttl(1,i,k)-pmp_ttl
      qmp = a4(1,i,k)-pmp
      lac_ttl = a4_ttl(1,i,k)-dc_ttl(i,k)+h2_ttl(i,k+1)*fac
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,qmp-a4(1,i,k)))+qmp_ttl*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin = min(a4(1,i,k),qmp,lac)
      qmax_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,a4(1,i,k)-qmp))+qmp_ttl*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax = max(a4(1,i,k),qmp,lac)
      a4_ttl(2,i,k) = a4_ttl(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5+sign(0.5d0,a4(2,i,k)-qmin))+qmax_ttl*(0.5-&
&sign(0.5d0,qmax-max(a4(2,i,k),qmin)))+qmin_ttl*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5-sign(0.5d0,a4(2,i,k)-qmin))
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,2 )
    endif
  end do
else
  lmt = kord-3
  lmt = max(0,lmt)
  if (iv .eq. 0) then
    lmt = min(2,lmt)
  endif
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,lmt )
  end do
endif
do k = km1, km
  do i = i1, i2
    a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,0 )
end do

end subroutine ppm2m_ttl


subroutine steepz_ttl( i1, i2, km, a4, a4_ttl, df2, df2_ttl, dm, dm_ttl, dq, dq_ttl, dp, d4 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ttl(4,i1:i2,km)
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ttl(i1:i2,km)
real(kind=r8) :: dm(i1:i2,km)
real(kind=r8) :: dm_ttl(i1:i2,km)
real(kind=r8) :: dp(i1:i2,km)
real(kind=r8) :: dq(i1:i2,km)
real(kind=r8) :: dq_ttl(i1:i2,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alfa(i1:i2,km)
real(kind=r8) :: alfa_ttl(i1:i2,km)
real(kind=r8) :: dg2
real(kind=r8) :: dg2_ttl
real(kind=r8) :: f(i1:i2,km)
real(kind=r8) :: f_ttl(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: rat(i1:i2,km)
real(kind=r8) :: rat_ttl(i1:i2,km)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    rat_ttl(i,k) = dq_ttl(i,k-1)/d4(i,k)
    rat(i,k) = dq(i,k-1)/d4(i,k)
  end do
end do
do k = 2, km-1
  do i = i1, i2
    f_ttl(i,k) = rat_ttl(i,k+1)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))-rat_ttl(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    f(i,k) = (rat(i,k+1)-rat(i,k))/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
  end do
end do
do k = 3, km-2
  do i = i1, i2
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2_ttl = (-(f_ttl(i,k-1)*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))))+f_ttl(i,k+1)*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,&
&k+1))
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      alfa_ttl(i,k) = df2_ttl(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*dg2/df2(i,k))&
&)-0.5_8))*(0.1875*dg2/(df2(i,k)*df2(i,k)))-dg2_ttl*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,&
&(-(0.1875*dg2/df2(i,k)))-0.5_8))*(0.1875/df2(i,k))
      alfa(i,k) = max(0._8,min(0.5_8,-(0.1875*dg2/df2(i,k))))
    else
      alfa_ttl(i,k) = 0.d0
      alfa(i,k) = 0.
    endif
  end do
end do
do k = 4, km-2
  do i = i1, i2
    a4_ttl(2,i,k) = a4_ttl(1,i,k-1)*alfa(i,k)+a4_ttl(2,i,k)*(1.-alfa(i,k-1)-alfa(i,k))+a4_ttl(1,i,k)*alfa(i,k-1)+alfa_ttl(i,k-1)*&
&((-a4(2,i,k))+a4(1,i,k)-dm(i,k))+alfa_ttl(i,k)*((-a4(2,i,k))+a4(1,i,k-1)+dm(i,k-1))+dm_ttl(i,k-1)*alfa(i,k)-dm_ttl(i,k)*alfa(i,k-1)
    a4(2,i,k) = (1.-alfa(i,k-1)-alfa(i,k))*a4(2,i,k)+alfa(i,k-1)*(a4(1,i,k)-dm(i,k))+alfa(i,k)*(a4(1,i,k-1)+dm(i,k-1))
  end do
end do

end subroutine steepz_ttl


subroutine te_map_ttl( consv, convt, ps, omga, pe, delp, pkz, pk, mdt, im, jm, km, nx, jfirst, jlast, nq, u, v, pt, q, q_ttm, hs, &
&cp, akap, kord, peln, te0, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mod_comm, only : mp_barrier, mp_recv_n, mp_recv_pe, mp_send_pe, mp_send_s

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: mdt
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: omga(im,km,jfirst:jlast)
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: q_ttm(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: dak
real(kind=r8) :: dlnp
real(kind=r8) :: dtmp
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: peh_ttl(im,km+1,jfirst:jlast)
real(kind=r8), allocatable :: pesouthh_ttl(:,:)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te_np
real(kind=r8) :: te_sp
real(kind=r8) :: tsum
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: u2(im,jfirst:jlast+1)
real(kind=r8) :: uh_ttl(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: ui_ttl(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uj_ttl(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uk_ttl(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v2(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: ysum

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,uk_ttl )
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .false.  )
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,uj_ttl )
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
help_h = km+1
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,peh_ttl )
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe )
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,t2,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = 0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))+t2(i,j)*pkz(i,j,k)
    end do
    te(im,j,k) = 0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))+t2(im,j)*pkz(im,j,k)
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = 0.5*te_sp/float(im)+t2(1,1)*pkz(1,1,k)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = 0.5*te_np/float(im)+t2(1,jm)*pkz(1,jm,k)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
  do j = jfirst, jlast
    do i = 1, im
      dz(i,j,k) = t2(i,j)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do
help_i = km+1
allocate( pesouthh_ttl(1:size(pesouth,1),1:size(pesouth,2)) )
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouthh_ttl )
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth )
deallocate( pesouthh_ttl )
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do private(bkh,dak,help_j,help_k,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,pe2w,pe3,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    ps(i,j) = pe1(i,km+1)
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      dak = ak(k+1)-ak(k)
      do i = i1, i2
        delp(i,j,k) = dak
      end do
    end do
  endif
  do k = ks+1, km
    do i = i1, i2
      delp(i,j,k) = pe2(i,k+1)-pe2(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  call map1_ppm_ttl( km,pe1,te,km,pe2,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm_ttl( km,pe1,q,q_ttm,nq,km,pe2,q,q_ttm,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    else
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pesouth(i,k))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pesouth(i,km+1))
        end do
      end do
    endif
    help_j = -1
    call map1_ppm_ttl( km,pe0,u,km,pe3,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_j,kord )
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_k = -1
    call map1_ppm_ttl( km,pe0,v,km,pe3,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_k,kord )
  endif
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,ui_ttl )
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .true.  )
if (consv) then
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,xsum,ysum)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = te_acap*cp*(ps(1,1)-2.*te_ptop-akap*te_ptop*(peln(1,km+1,1)-peln(1,1,1)))
    else if (j .eq. jm) then
      tte(jm) = te_acap*cp*(ps(1,jm)-akap*te_ptop*(peln(1,km+1,jm)-peln(1,1,jm)))
    else
      xsum = 0.
      ysum = 0.
      do i = 1, im
        xsum = xsum+ps(i,j)
        ysum = ysum+peln(i,km+1,j)
      end do
      tte(j) = cp*te_cosp(j)*(xsum-te_ptop*im-akap*te_ptop*(ysum-peln(1,1,j)*im))
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,tsum )
  dtmp = (te0-te1)/tsum
else
  dtmp = 0.
endif
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,uh_ttl )
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = te(i,j,k)-0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))
    end do
    te(im,j,k) = te(im,j,k)-0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = te(1,1,k)-0.5*te_sp/float(im)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = te(1,jm,k)-0.5*te_np/float(im)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
end do
#ifdef USE_OPENMP
!$omp parallel do private(dlnp,gz,i,i1,i2,ixj,j,k,rg,tvm)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)/pkz(i,j,k)
      end do
    endif
  end do
end do

end subroutine te_map_ttl


end module     mapz_module_ttl


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     mapz_module_ttl
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mapz_module

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine kmppm_ttl( dm, dm_ttl, a4, a4_ttl, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a4(4,im)
real(kind=r8) :: a4_ttl(4,im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ttl(im)
integer :: lmt

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ttl
real(kind=r8) :: da1
real(kind=r8) :: da1_ttl
real(kind=r8) :: da2
real(kind=r8) :: da2_ttl
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ttl
integer :: i
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
if (lmt .ne. 3) then
  if (lmt .eq. 0) then
    do i = 1, im
      if (dm(i) .eq. 0.) then
        a4_ttl(2,i) = a4_ttl(1,i)
        a4(2,i) = a4(1,i)
        a4_ttl(3,i) = a4_ttl(1,i)
        a4(3,i) = a4(1,i)
        a4_ttl(4,i) = 0.d0
        a4(4,i) = 0.
      else
        da1_ttl = a4_ttl(3,i)-a4_ttl(2,i)
        da1 = a4(3,i)-a4(2,i)
        da2_ttl = 2*da1_ttl*da1
        da2 = da1**2
        a6da_ttl = a4_ttl(4,i)*da1+da1_ttl*a4(4,i)
        a6da = a4(4,i)*da1
        if (a6da .lt. (-da2)) then
          a4_ttl(4,i) = 3*a4_ttl(2,i)-3*a4_ttl(1,i)
          a4(4,i) = 3.*(a4(2,i)-a4(1,i))
          a4_ttl(3,i) = (-a4_ttl(4,i))+a4_ttl(2,i)
          a4(3,i) = a4(2,i)-a4(4,i)
        else if (a6da .gt. da2) then
          a4_ttl(4,i) = 3*a4_ttl(3,i)-3*a4_ttl(1,i)
          a4(4,i) = 3.*(a4(3,i)-a4(1,i))
          a4_ttl(2,i) = (-a4_ttl(4,i))+a4_ttl(3,i)
          a4(2,i) = a4(3,i)-a4(4,i)
        endif
      endif
    end do
  else if (lmt .eq. 1) then
    do i = 1, im
      qmp_ttl = 2*dm_ttl(i)
      qmp = 2.*dm(i)
      a4_ttl(2,i) = (-(a4_ttl(2,i)*(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i))))))+a4_ttl(1,i)*(1+(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,&
&qmp)*sign(1.d0,a4(2,i)-a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))-qmp_ttl*(0.5+sign(0.5d0,abs(a4(2,i)-a4(1,i))-&
&abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i))))
      a4(2,i) = a4(1,i)-sign(min(abs(qmp),abs(a4(2,i)-a4(1,i))),qmp)
      a4_ttl(3,i) = a4_ttl(3,i)*(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i))))+a4_ttl(1,i)*(1-(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*&
&sign(1.d0,a4(3,i)-a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i)))))+qmp_ttl*(0.5+sign(0.5d0,abs(a4(3,i)-a4(1,i))-&
&abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4(3,i) = a4(1,i)+sign(min(abs(qmp),abs(a4(3,i)-a4(1,i))),qmp)
      a4_ttl(4,i) = (-3)*a4_ttl(3,i)-3*a4_ttl(2,i)+6*a4_ttl(1,i)
      a4(4,i) = 3.*(2.*a4(1,i)-(a4(2,i)+a4(3,i)))
    end do
  else if (lmt .eq. 2) then
    do i = 1, im
      if (abs(a4(3,i)-a4(2,i)) .lt. (-a4(4,i))) then
        fmin_ttl = a4_ttl(4,i)*((-(0.25*(a4(3,i)-a4(2,i))**2/(a4(4,i)*a4(4,i))))+r12)+a4_ttl(3,i)*(0.5*(a4(3,i)-a4(2,i))/a4(4,i))+&
&a4_ttl(2,i)*((-0.5)*(a4(3,i)-a4(2,i))/a4(4,i))+a4_ttl(1,i)
        fmin = a4(1,i)+0.25*(a4(3,i)-a4(2,i))**2/a4(4,i)+a4(4,i)*r12
        if (fmin .lt. 0.) then
          if (a4(1,i) .lt. a4(3,i) .and. a4(1,i) .lt. a4(2,i)) then
            a4_ttl(3,i) = a4_ttl(1,i)
            a4(3,i) = a4(1,i)
            a4_ttl(2,i) = a4_ttl(1,i)
            a4(2,i) = a4(1,i)
            a4_ttl(4,i) = 0.d0
            a4(4,i) = 0.
          else if (a4(3,i) .gt. a4(2,i)) then
            a4_ttl(4,i) = 3*a4_ttl(2,i)-3*a4_ttl(1,i)
            a4(4,i) = 3.*(a4(2,i)-a4(1,i))
            a4_ttl(3,i) = (-a4_ttl(4,i))+a4_ttl(2,i)
            a4(3,i) = a4(2,i)-a4(4,i)
          else
            a4_ttl(4,i) = 3*a4_ttl(3,i)-3*a4_ttl(1,i)
            a4(4,i) = 3.*(a4(3,i)-a4(1,i))
            a4_ttl(2,i) = (-a4_ttl(4,i))+a4_ttl(3,i)
            a4(2,i) = a4(3,i)-a4(4,i)
          endif
        endif
      endif
    end do
  endif
endif

end subroutine kmppm_ttl


subroutine map1_ppm_ttl( km, pe1, q1, kn, pe2, q2, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km)
real(kind=r8) :: q2(im,jfirst-ng_s:jlast+ng_n,kn)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: esl
integer :: i
integer :: ikind
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pr
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4h_ttl(4,1+i2-i1,km)
real(kind=r8) :: qsum

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
    q4(1,i,k) = q1(i,j,k)
  end do
end do
q4h_ttl(:,:,:) = 0.d0
call ppm2m_ttl( q4,q4h_ttl,dp1,km,i1,i2,iv,kord )
do i = i1, i2
  k0 = 1
  do k = 1, kn
    ikind = 0
    do l = k0, km
      if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
        if (pe2(i,k+1) .le. pe1(i,l+1)) then
          ikind = 1
          exit
        else
          ikind = 2
          exit
        endif
      endif
    end do
    if (ikind .eq. 0) then
      stop 'error'
    else if (ikind .eq. 1) then
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
      q2(i,j,k) = q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(pr+pl)-q4(4,i,l)*r3*(pr*(pr+pl)+pl**2)
    else
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      do ll = l+1, km
        if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
        else
          lf = ll
          exit
        endif
      end do
      if (lf .eq. 0) then
        do ll = l+1, km
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
      else
        do ll = l+1, lf-1
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
        ll = lf
        delp = pe2(i,k+1)-pe1(i,ll)
        esl = delp/dp1(i,ll)
        qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
      endif
      q2(i,j,k) = qsum/(pe2(i,k+1)-pe2(i,k))
    endif
  end do
end do

end subroutine map1_ppm_ttl


subroutine mapn_ppm_ttl( km, pe1, q1, q1_ttl, nq, kn, pe2, q2, q2_ttl, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
integer :: nq
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q1_ttl(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q2(im,jfirst-ng_s:jlast+ng_n,kn,nq)
real(kind=r8) :: q2_ttl(im,jfirst-ng_s:jlast+ng_n,kn,nq)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: esl
integer :: i
integer :: ikind
integer :: iq
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pr
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_ttl(4,i1:i2,km)
real(kind=r8) :: qsum
real(kind=r8) :: qsum_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
  end do
end do
do iq = 1, nq
  do k = 1, km
    do i = i1, i2
      q4_ttl(1,i,k) = q1_ttl(i,j,k,iq)
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  call ppm2m_ttl( q4,q4_ttl,dp1,km,i1,i2,iv,kord )
  do i = i1, i2
    k0 = 1
    do k = 1, kn
      ikind = 0
      do l = k0, km
        if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
          if (pe2(i,k+1) .le. pe1(i,l+1)) then
            ikind = 1
            exit
          else
            ikind = 2
            exit
          endif
        endif
      end do
      if (ikind .eq. 0) then
        stop 'error'
      else if (ikind .eq. 1) then
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
        q2_ttl(i,j,k,iq) = q4_ttl(4,i,l)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))+0.5*q4_ttl(3,i,l)*(pr+pl)+q4_ttl(2,i,l)*(1+(-0.5)*(pr+&
&pl))
        q2(i,j,k,iq) = q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(pr+pl)-q4(4,i,l)*r3*(pr*(pr+pl)+pl**2)
      else
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        qsum_ttl = q4_ttl(4,i,l)*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))+0.5*q4_ttl(3,i,l)*(pe1(i,l+1)-pe2(i,k))*&
&(1.+pl)+q4_ttl(2,i,l)*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
        qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        do ll = l+1, km
          if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
          else
            lf = ll
            exit
          endif
        end do
        if (lf .eq. 0) then
          do ll = l+1, km
            qsum_ttl = q4_ttl(1,i,ll)*dp1(i,ll)+qsum_ttl
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
        else
          do ll = l+1, lf-1
            qsum_ttl = q4_ttl(1,i,ll)*dp1(i,ll)+qsum_ttl
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
          ll = lf
          delp = pe2(i,k+1)-pe1(i,ll)
          esl = delp/dp1(i,ll)
          qsum_ttl = 0.5*q4_ttl(4,i,ll)*delp*esl*(1.-r23*esl)+0.5*q4_ttl(3,i,ll)*delp*esl+q4_ttl(2,i,ll)*delp*(1+(-0.5)*esl)+&
&qsum_ttl
          qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        endif
        q2_ttl(i,j,k,iq) = qsum_ttl/(pe2(i,k+1)-pe2(i,k))
        q2(i,j,k,iq) = qsum/(pe2(i,k+1)-pe2(i,k))
      endif
    end do
  end do
end do

end subroutine mapn_ppm_ttl


subroutine ppm2m_ttl( a4, a4_ttl, delp, km, i1, i2, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ttl(4,i1:i2,km)
real(kind=r8) :: delp(i1:i2,km)
integer :: iv
integer :: kord

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a1
real(kind=r8) :: a2
real(kind=r8) :: c1
real(kind=r8) :: c1_ttl
real(kind=r8) :: c2
real(kind=r8) :: c3
real(kind=r8) :: c3_ttl
real(kind=r8) :: cmax
real(kind=r8) :: cmax_ttl
real(kind=r8) :: cmin
real(kind=r8) :: cmin_ttl
real(kind=r8) :: d1
real(kind=r8) :: d2
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: dc(i1:i2,km)
real(kind=r8) :: dc_ttl(i1:i2,km)
double precision :: dch
double precision :: dci
real(kind=r8) :: delq(i1:i2,km)
real(kind=r8) :: delq_ttl(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ttl(i1:i2,km)
real(kind=r8) :: dq
real(kind=r8) :: dq_ttl
real(kind=r8) :: fac
real(kind=r8) :: h2(i1:i2,km)
real(kind=r8) :: h2_ttl(i1:i2,km)
integer :: i
integer :: it
integer :: k
integer :: km1
real(kind=r8) :: lac
real(kind=r8) :: lac_ttl
integer :: lmt
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ttl
real(kind=r8) :: qm
real(kind=r8) :: qm_ttl
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ttl
double precision :: qmaxh
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ttl
double precision :: qminh
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ttl
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ttl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
km1 = km-1
it = i2-i1+1
do k = 2, km
  do i = i1, i2
    delq_ttl(i,k-1) = (-a4_ttl(1,i,k-1))+a4_ttl(1,i,k)
    delq(i,k-1) = a4(1,i,k)-a4(1,i,k-1)
    d4(i,k) = delp(i,k-1)+delp(i,k)
  end do
end do
do k = 2, km1
  do i = i1, i2
    c1_ttl = 0.d0
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp_ttl = c1_ttl*(delp(i,k)*delq(i,k)/(d4(i,k)+delp(i,k+1)))+delq_ttl(i,k-1)*(delp(i,k)*c2/(d4(i,k)+delp(i,k+1)))+delq_ttl(i,k)&
&*(delp(i,k)*c1/(d4(i,k)+delp(i,k+1)))
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmaxh = max(a4(1,i,k-1),a4(1,i,k))
    qmax_ttl = (-a4_ttl(1,i,k))+a4_ttl(1,i,k+1)*(0.5-sign(0.5d0,qmaxh-a4(1,i,k+1)))+(a4_ttl(1,i,k-1)*(0.5+sign(0.5d0,a4(1,i,k-1)-&
&a4(1,i,k)))+a4_ttl(1,i,k)*(0.5-sign(0.5d0,a4(1,i,k-1)-a4(1,i,k))))*(0.5+sign(0.5d0,qmaxh-a4(1,i,k+1)))
    qmax = max(qmaxh,a4(1,i,k+1))-a4(1,i,k)
    qminh = min(a4(1,i,k-1),a4(1,i,k))
    qmin_ttl = a4_ttl(1,i,k)-(a4_ttl(1,i,k+1)*(0.5-sign(0.5d0,a4(1,i,k+1)-qminh))+(a4_ttl(1,i,k-1)*(0.5+sign(0.5d0,a4(1,i,k)-a4(1,&
&i,k-1)))+a4_ttl(1,i,k)*(0.5-sign(0.5d0,a4(1,i,k)-a4(1,i,k-1))))*(0.5+sign(0.5d0,a4(1,i,k+1)-qminh)))
    qmin = a4(1,i,k)-min(qminh,a4(1,i,k+1))
    dch = min(abs(tmp),qmax)
    dci = min(dch,qmin)
    dc_ttl(i,k) = ((qmax_ttl*(0.5-sign(0.5d0,qmax-abs(tmp)))+tmp_ttl*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp))*(0.5+&
&sign(0.5d0,qmin-dch))+qmin_ttl*(0.5-sign(0.5d0,qmin-dch)))*sign(1.d0,dci)*sign(1.d0,tmp)
    dc(i,k) = sign(dci,tmp)
    df2_ttl(i,k) = tmp_ttl
    df2(i,k) = tmp
  end do
end do
do k = 3, km1
  do i = i1, i2
    c1_ttl = delq_ttl(i,k-1)*(delp(i,k-1)/d4(i,k))
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a4_ttl(2,i,k) = a4_ttl(1,i,k-1)+c1_ttl*(1+2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*(a1-a2))+dc_ttl(i,k-1)*2./(d4(i,k-1)+d4(i,k+1))*&
&delp(i,k)*a2-dc_ttl(i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k-1)*a1
    a4(2,i,k) = a4(1,i,k-1)+c1+2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-delp(i,k-1)*a1*dc(i,k))
  end do
end do
call steepz_ttl( i1,i2,km,a4,a4_ttl,df2,df2_ttl,dc,dc_ttl,delq,delq_ttl,delp,d4 )
do i = i1, i2
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm_ttl = a4_ttl(1,i,2)*(d1/(d1+d2))+a4_ttl(1,i,1)*(d2/(d1+d2))
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq_ttl = a4_ttl(1,i,2)*(2/(d1+d2))+a4_ttl(1,i,1)*((-2)/(d1+d2))
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1_ttl = a4_ttl(2,i,3)*(4/(d2*(2.*d2*d2+d1*(d2+3.*d1))))-dq_ttl*(4.*d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))+qm_ttl*((-4)/(d2*(2.*d2*d2+&
&d1*(d2+3.*d1))))
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3_ttl = (-(0.5*c1_ttl*(d2*(5.*d1+d2)-3.*d1**2)))+dq_ttl
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4_ttl(2,i,2) = (-(0.25*c1_ttl*d1*d2*(d2+3.*d1)))+qm_ttl
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4_ttl(2,i,1) = a4_ttl(2,i,2)+2*c1_ttl*d1*d1**2-c3_ttl*d1
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  dc_ttl(i,1) = (-a4_ttl(2,i,1))+a4_ttl(1,i,1)
  dc(i,1) = a4(1,i,1)-a4(2,i,1)
  cmax_ttl = a4_ttl(1,i,2)*(0.5-sign(0.5d0,a4(1,i,1)-a4(1,i,2)))+a4_ttl(1,i,1)*(0.5+sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin_ttl = a4_ttl(1,i,2)*(0.5-sign(0.5d0,a4(1,i,2)-a4(1,i,1)))+a4_ttl(1,i,1)*(0.5+sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4_ttl(2,i,2) = a4_ttl(2,i,2)*(0.5-sign(0.5d0,cmin-a4(2,i,2)))+cmin_ttl*(0.5+sign(0.5d0,cmin-a4(2,i,2)))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  a4_ttl(2,i,2) = a4_ttl(2,i,2)*(0.5-sign(0.5d0,a4(2,i,2)-cmax))+cmax_ttl*(0.5+sign(0.5d0,a4(2,i,2)-cmax))
  a4(2,i,2) = min(cmax,a4(2,i,2))
end do
if (iv .eq. 0) then
  do i = i1, i2
    a4_ttl(2,i,1) = a4_ttl(1,i,1)
    a4(2,i,1) = a4(1,i,1)
    a4_ttl(3,i,1) = a4_ttl(1,i,1)
    a4(3,i,1) = a4(1,i,1)
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4_ttl(2,i,1) = a4_ttl(1,i,1)
      a4(2,i,1) = a4(1,i,1)
      a4_ttl(3,i,1) = a4_ttl(1,i,1)
      a4(3,i,1) = a4(1,i,1)
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4_ttl(2,i,1) = 0.d0
        a4(2,i,1) = 0.
      else
        a4_ttl(2,i,1) = (a4_ttl(2,i,1)*(0.5-sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(2,i,1))+&
&a4_ttl(1,i,1)*(0.5+sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(1,i,1)))*sign(1.d0,&
&min(abs(a4(1,i,1)),abs(a4(2,i,1))))
        a4(2,i,1) = sign(min(abs(a4(1,i,1)),abs(a4(2,i,1))),a4(1,i,1))
      endif
    end do
  endif
endif
do i = i1, i2
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm_ttl = a4_ttl(1,i,km)*(d2/(d1+d2))+a4_ttl(1,i,km1)*(d1/(d1+d2))
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq_ttl = a4_ttl(1,i,km)*((-2)/(d1+d2))+a4_ttl(1,i,km1)*(2/(d1+d2))
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1_ttl = a4_ttl(2,i,km1)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))-dq_ttl*(d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))-qm_ttl/(d2*(2.*d2*d2+d1*(d2+3.*&
&d1)))
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3_ttl = (-(2*c1_ttl*(d2*(5.*d1+d2)-3.*d1**2)))+dq_ttl
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4_ttl(2,i,km) = (-(c1_ttl*d1*d2*(d2+3.*d1)))+qm_ttl
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4_ttl(3,i,km) = a4_ttl(2,i,km)+8*c1_ttl*d1*d1**2-c3_ttl*d1
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  dc_ttl(i,km) = a4_ttl(3,i,km)-a4_ttl(1,i,km)
  dc(i,km) = a4(3,i,km)-a4(1,i,km)
  cmax_ttl = a4_ttl(1,i,km)*(0.5+sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))+a4_ttl(1,i,km1)*(0.5-sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin_ttl = a4_ttl(1,i,km)*(0.5+sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))+a4_ttl(1,i,km1)*(0.5-sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4_ttl(2,i,km) = a4_ttl(2,i,km)*(0.5-sign(0.5d0,cmin-a4(2,i,km)))+cmin_ttl*(0.5+sign(0.5d0,cmin-a4(2,i,km)))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  a4_ttl(2,i,km) = a4_ttl(2,i,km)*(0.5-sign(0.5d0,a4(2,i,km)-cmax))+cmax_ttl*(0.5+sign(0.5d0,a4(2,i,km)-cmax))
  a4(2,i,km) = min(cmax,a4(2,i,km))
end do
if (iv .eq. 0) then
  do i = i1, i2
    a4_ttl(3,i,km) = a4_ttl(3,i,km)*(0.5-sign(0.5d0,0._8-a4(3,i,km)))
    a4(3,i,km) = max(0._8,a4(3,i,km))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4_ttl(3,i,km) = 0.d0
      a4(3,i,km) = 0.
    else
      a4_ttl(3,i,km) = (a4_ttl(3,i,km)*(0.5-sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(3,i,km)&
&)+a4_ttl(1,i,km)*(0.5+sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(1,i,km)))*sign(1.d0,&
&min(abs(a4(1,i,km)),abs(a4(3,i,km))))
      a4(3,i,km) = sign(min(abs(a4(1,i,km)),abs(a4(3,i,km))),a4(1,i,km))
    endif
  end do
endif
do k = 1, km1
  do i = i1, i2
    a4_ttl(3,i,k) = a4_ttl(2,i,k+1)
    a4(3,i,k) = a4(2,i,k+1)
  end do
end do
do k = 1, 2
  do i = i1, i2
    a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,0 )
end do
if (kord .ge. 7) then
  do k = 2, km1
    do i = i1, i2
      h2_ttl(i,k) = (-dc_ttl(i,k-1))+dc_ttl(i,k+1)
      h2(i,k) = dc(i,k+1)-dc(i,k-1)
    end do
  end do
  if (kord .eq. 7) then
    fac = 1.5
  else
    fac = 0.125
  endif
  do k = 3, km-2
    do i = i1, i2
      pmp_ttl = 2*dc_ttl(i,k)
      pmp = 2.*dc(i,k)
      qmp_ttl = a4_ttl(1,i,k)+pmp_ttl
      qmp = a4(1,i,k)+pmp
      lac_ttl = a4_ttl(1,i,k)+dc_ttl(i,k)+h2_ttl(i,k-1)*fac
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,qmp-a4(1,i,k)))+qmp_ttl*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin = min(a4(1,i,k),qmp,lac)
      qmax_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,a4(1,i,k)-qmp))+qmp_ttl*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax = max(a4(1,i,k),qmp,lac)
      a4_ttl(3,i,k) = a4_ttl(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5+sign(0.5d0,a4(3,i,k)-qmin))+qmax_ttl*(0.5-&
&sign(0.5d0,qmax-max(a4(3,i,k),qmin)))+qmin_ttl*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5-sign(0.5d0,a4(3,i,k)-qmin))
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp_ttl = 2*dc_ttl(i,k)
      pmp = 2.*dc(i,k)
      qmp_ttl = a4_ttl(1,i,k)-pmp_ttl
      qmp = a4(1,i,k)-pmp
      lac_ttl = a4_ttl(1,i,k)-dc_ttl(i,k)+h2_ttl(i,k+1)*fac
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,qmp-a4(1,i,k)))+qmp_ttl*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin = min(a4(1,i,k),qmp,lac)
      qmax_ttl = a4_ttl(1,i,k)*(0.5+sign(0.5d0,a4(1,i,k)-qmp))+qmp_ttl*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax = max(a4(1,i,k),qmp,lac)
      a4_ttl(2,i,k) = a4_ttl(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5+sign(0.5d0,a4(2,i,k)-qmin))+qmax_ttl*(0.5-&
&sign(0.5d0,qmax-max(a4(2,i,k),qmin)))+qmin_ttl*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5-sign(0.5d0,a4(2,i,k)-qmin))
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,2 )
    endif
  end do
else
  lmt = kord-3
  lmt = max(0,lmt)
  if (iv .eq. 0) then
    lmt = min(2,lmt)
  endif
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,lmt )
  end do
endif
do k = km1, km
  do i = i1, i2
    a4_ttl(4,i,k) = (-3)*a4_ttl(3,i,k)-3*a4_ttl(2,i,k)+6*a4_ttl(1,i,k)
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ttl( dc(i1,k),dc_ttl(i1,k),a4(1,i1,k),a4_ttl(1,i1,k),it,0 )
end do

end subroutine ppm2m_ttl


subroutine steepz_ttl( i1, i2, km, a4, a4_ttl, df2, df2_ttl, dm, dm_ttl, dq, dq_ttl, dp, d4 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ttl(4,i1:i2,km)
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ttl(i1:i2,km)
real(kind=r8) :: dm(i1:i2,km)
real(kind=r8) :: dm_ttl(i1:i2,km)
real(kind=r8) :: dp(i1:i2,km)
real(kind=r8) :: dq(i1:i2,km)
real(kind=r8) :: dq_ttl(i1:i2,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alfa(i1:i2,km)
real(kind=r8) :: alfa_ttl(i1:i2,km)
real(kind=r8) :: dg2
real(kind=r8) :: dg2_ttl
real(kind=r8) :: f(i1:i2,km)
real(kind=r8) :: f_ttl(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: rat(i1:i2,km)
real(kind=r8) :: rat_ttl(i1:i2,km)

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    rat_ttl(i,k) = dq_ttl(i,k-1)/d4(i,k)
    rat(i,k) = dq(i,k-1)/d4(i,k)
  end do
end do
do k = 2, km-1
  do i = i1, i2
    f_ttl(i,k) = rat_ttl(i,k+1)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))-rat_ttl(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    f(i,k) = (rat(i,k+1)-rat(i,k))/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
  end do
end do
do k = 3, km-2
  do i = i1, i2
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2_ttl = (-(f_ttl(i,k-1)*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))))+f_ttl(i,k+1)*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,&
&k+1))
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      alfa_ttl(i,k) = df2_ttl(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*dg2/df2(i,k))&
&)-0.5_8))*(0.1875*dg2/(df2(i,k)*df2(i,k)))-dg2_ttl*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,&
&(-(0.1875*dg2/df2(i,k)))-0.5_8))*(0.1875/df2(i,k))
      alfa(i,k) = max(0._8,min(0.5_8,-(0.1875*dg2/df2(i,k))))
    else
      alfa_ttl(i,k) = 0.d0
      alfa(i,k) = 0.
    endif
  end do
end do
do k = 4, km-2
  do i = i1, i2
    a4_ttl(2,i,k) = a4_ttl(1,i,k-1)*alfa(i,k)+a4_ttl(2,i,k)*(1.-alfa(i,k-1)-alfa(i,k))+a4_ttl(1,i,k)*alfa(i,k-1)+alfa_ttl(i,k-1)*&
&((-a4(2,i,k))+a4(1,i,k)-dm(i,k))+alfa_ttl(i,k)*((-a4(2,i,k))+a4(1,i,k-1)+dm(i,k-1))+dm_ttl(i,k-1)*alfa(i,k)-dm_ttl(i,k)*alfa(i,k-1)
    a4(2,i,k) = (1.-alfa(i,k-1)-alfa(i,k))*a4(2,i,k)+alfa(i,k-1)*(a4(1,i,k)-dm(i,k))+alfa(i,k)*(a4(1,i,k-1)+dm(i,k-1))
  end do
end do

end subroutine steepz_ttl


subroutine te_map_ttl( consv, convt, ps, omga, pe, delp, pkz, pk, mdt, im, jm, km, nx, jfirst, jlast, nq, u, v, pt, q, q_ttm, hs, &
&cp, akap, kord, peln, te0, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: mdt
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: omga(im,km,jfirst:jlast)
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: q_ttm(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: dak
real(kind=r8) :: dlnp
real(kind=r8) :: dtmp
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
integer :: help_h
integer :: help_i
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te_np
real(kind=r8) :: te_sp
real(kind=r8) :: tsum
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: u2(im,jfirst:jlast+1)
real(kind=r8) :: v2(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: ysum

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .false.  )
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,t2,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = 0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))+t2(i,j)*pkz(i,j,k)
    end do
    te(im,j,k) = 0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))+t2(im,j)*pkz(im,j,k)
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = 0.5*te_sp/float(im)+t2(1,1)*pkz(1,1,k)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = 0.5*te_np/float(im)+t2(1,jm)*pkz(1,jm,k)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
  do j = jfirst, jlast
    do i = 1, im
      dz(i,j,k) = t2(i,j)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do private(bkh,dak,help_h,help_i,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,pe2w,pe3,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    ps(i,j) = pe1(i,km+1)
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      dak = ak(k+1)-ak(k)
      do i = i1, i2
        delp(i,j,k) = dak
      end do
    end do
  endif
  do k = ks+1, km
    do i = i1, i2
      delp(i,j,k) = pe2(i,k+1)-pe2(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  call map1_ppm_ttl( km,pe1,te,km,pe2,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm_ttl( km,pe1,q,q_ttm,nq,km,pe2,q,q_ttm,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    endif
    help_h = -1
    call map1_ppm_ttl( km,pe0,u,km,pe3,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_h,kord )
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_i = -1
    call map1_ppm_ttl( km,pe0,v,km,pe3,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_i,kord )
  endif
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .true.  )
if (consv) then
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,xsum,ysum)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = te_acap*cp*(ps(1,1)-2.*te_ptop-akap*te_ptop*(peln(1,km+1,1)-peln(1,1,1)))
    else if (j .eq. jm) then
      tte(jm) = te_acap*cp*(ps(1,jm)-akap*te_ptop*(peln(1,km+1,jm)-peln(1,1,jm)))
    else
      xsum = 0.
      ysum = 0.
      do i = 1, im
        xsum = xsum+ps(i,j)
        ysum = ysum+peln(i,km+1,j)
      end do
      tte(j) = cp*te_cosp(j)*(xsum-te_ptop*im-akap*te_ptop*(ysum-peln(1,1,j)*im))
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,tsum )
  dtmp = (te0-te1)/tsum
else
  dtmp = 0.
endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = te(i,j,k)-0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))
    end do
    te(im,j,k) = te(im,j,k)-0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = te(1,1,k)-0.5*te_sp/float(im)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = te(1,jm,k)-0.5*te_np/float(im)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
end do
#ifdef USE_OPENMP
!$omp parallel do private(dlnp,gz,i,i1,i2,ixj,j,k,rg,tvm)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)/pkz(i,j,k)
      end do
    endif
  end do
end do

end subroutine te_map_ttl


end module     mapz_module_ttl


#endif /* SPMD */
