#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     te_map_tad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: te_map_tape_dz_8h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_9h(:,:,:,:)
integer :: te_map_tape_te_map
real(kind=8), allocatable :: te_map_tape_u_6h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_v_7h(:,:,:,:)

end module     te_map_tad_store


module     mapz_module_tad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mapz_module

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine kmppm_tad( dm, dm_tad, a4, a4_tad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a4(4,im)
real(kind=r8) :: a4_tad(4,im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_tad(im)
integer :: lmt

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a4h(4,im)
real(kind=r8) :: a6da
real(kind=r8) :: a6da_tad
real(kind=r8) :: da1
real(kind=r8) :: da1_tad
real(kind=r8) :: da2
real(kind=r8) :: da2_tad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_tad
integer :: i
real(kind=r8) :: qmp
real(kind=r8) :: qmp_tad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
a4h(:,:) = a4(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_tad = 0.d0
da1_tad = 0.d0
da2_tad = 0.d0
fmin_tad = 0.d0
qmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .ne. 3) then
  if (lmt .eq. 0) then
    do i = 1, im
      a6da_tad = 0.d0
      da1_tad = 0.d0
      da2_tad = 0.d0
      if (dm(i) .eq. 0.) then
        a4_tad(4,i) = 0.d0
        a4_tad(1,i) = a4_tad(1,i)+a4_tad(3,i)
        a4_tad(3,i) = 0.d0
        a4_tad(1,i) = a4_tad(1,i)+a4_tad(2,i)
        a4_tad(2,i) = 0.d0
      else
        da1 = a4(3,i)-a4(2,i)
        da2 = da1**2
        a6da = a4(4,i)*da1
        if (a6da .lt. (-da2)) then
          a4_tad(4,i) = a4_tad(4,i)-a4_tad(3,i)
          a4_tad(2,i) = a4_tad(2,i)+a4_tad(3,i)
          a4_tad(3,i) = 0.d0
          a4_tad(2,i) = a4_tad(2,i)+3*a4_tad(4,i)
          a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
          a4_tad(4,i) = 0.d0
        else if (a6da .gt. da2) then
          a4_tad(4,i) = a4_tad(4,i)-a4_tad(2,i)
          a4_tad(3,i) = a4_tad(3,i)+a4_tad(2,i)
          a4_tad(2,i) = 0.d0
          a4_tad(3,i) = a4_tad(3,i)+3*a4_tad(4,i)
          a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
          a4_tad(4,i) = 0.d0
        endif
        a4_tad(4,i) = a4_tad(4,i)+a6da_tad*da1
        da1_tad = da1_tad+a6da_tad*a4(4,i)
        a6da_tad = 0.d0
        da1_tad = da1_tad+2*da2_tad*da1
        da2_tad = 0.d0
        a4_tad(3,i) = a4_tad(3,i)+da1_tad
        a4_tad(2,i) = a4_tad(2,i)-da1_tad
        da1_tad = 0.d0
      endif
    end do
  else if (lmt .eq. 1) then
    do i = 1, im
      qmp_tad = 0.d0
      qmp = 2.*dm(i)
      a4(2,i) = a4(1,i)-sign(min(abs(qmp),abs(a4(2,i)-a4(1,i))),qmp)
      a4_tad(3,i) = a4_tad(3,i)-3*a4_tad(4,i)
      a4_tad(2,i) = a4_tad(2,i)-3*a4_tad(4,i)
      a4_tad(1,i) = a4_tad(1,i)+6*a4_tad(4,i)
      a4_tad(4,i) = 0.d0
      qmp_tad = qmp_tad+a4_tad(3,i)*(0.5+sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4_tad(1,i) = a4_tad(1,i)+a4_tad(3,i)*(1-(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-&
&a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i)))))
      a4_tad(3,i) = a4_tad(3,i)*(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4(:,:) = a4h(:,:)
      qmp_tad = qmp_tad-a4_tad(2,i)*(0.5+sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(2,i)-a4(1,i))))
      a4_tad(1,i) = a4_tad(1,i)+a4_tad(2,i)*(1+(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-&
&a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      a4_tad(2,i) = -(a4_tad(2,i)*(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      dm_tad(i) = dm_tad(i)+2*qmp_tad
      qmp_tad = 0.d0
    end do
  else if (lmt .eq. 2) then
    do i = 1, im
      fmin_tad = 0.d0
      if (abs(a4(3,i)-a4(2,i)) .lt. (-a4(4,i))) then
        fmin = a4(1,i)+0.25*(a4(3,i)-a4(2,i))**2/a4(4,i)+a4(4,i)*r12
        if (fmin .lt. 0.) then
          if (a4(1,i) .lt. a4(3,i) .and. a4(1,i) .lt. a4(2,i)) then
            a4_tad(4,i) = 0.d0
            a4_tad(1,i) = a4_tad(1,i)+a4_tad(2,i)
            a4_tad(2,i) = 0.d0
            a4_tad(1,i) = a4_tad(1,i)+a4_tad(3,i)
            a4_tad(3,i) = 0.d0
          else if (a4(3,i) .gt. a4(2,i)) then
            a4_tad(4,i) = a4_tad(4,i)-a4_tad(3,i)
            a4_tad(2,i) = a4_tad(2,i)+a4_tad(3,i)
            a4_tad(3,i) = 0.d0
            a4_tad(2,i) = a4_tad(2,i)+3*a4_tad(4,i)
            a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
            a4_tad(4,i) = 0.d0
          else
            a4_tad(4,i) = a4_tad(4,i)-a4_tad(2,i)
            a4_tad(3,i) = a4_tad(3,i)+a4_tad(2,i)
            a4_tad(2,i) = 0.d0
            a4_tad(3,i) = a4_tad(3,i)+3*a4_tad(4,i)
            a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
            a4_tad(4,i) = 0.d0
          endif
        endif
        a4_tad(4,i) = a4_tad(4,i)+fmin_tad*((-(0.25*(a4(3,i)-a4(2,i))**2/(a4(4,i)*a4(4,i))))+r12)
        a4_tad(3,i) = a4_tad(3,i)+fmin_tad*(0.5*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_tad(2,i) = a4_tad(2,i)+fmin_tad*((-0.5)*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_tad(1,i) = a4_tad(1,i)+fmin_tad
        fmin_tad = 0.d0
      endif
    end do
  endif
endif

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine kmppm_tad


subroutine map1_ppm_tad( km, pe1, q1, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kord
integer :: ng_n
integer :: ng_s
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dp1(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4h_tad(4,1+i2-i1,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
q4h_tad(:,:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
    q4(1,i,k) = q1(i,j,k)
  end do
end do
call ppm2m_tad( q4,q4h_tad,dp1,km,i1,i2,iv,kord )

end subroutine map1_ppm_tad


subroutine mapn_ppm_tad( km, pe1, q1, q1_tad, nq, kn, pe2, q2_tad, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
integer :: nq
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q1_tad(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q2_tad(im,jfirst-ng_s:jlast+ng_n,kn,nq)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: esl
integer :: i
integer :: ikind
integer :: iq
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pr
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_tad(4,i1:i2,km)
real(kind=r8) :: qsum_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
q4_tad(:,:,:) = 0.d0
qsum_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
  end do
end do
do iq = nq, 1, -1
  do k = 1, km
    do i = i1, i2
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  do i = i1, i2
    k0 = 1
    do k = 1, kn
      ikind = 0
      do l = k0, km
        if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
          if (pe2(i,k+1) .le. pe1(i,l+1)) then
            ikind = 1
            exit
          else
            ikind = 2
            exit
          endif
        endif
      end do
      if (ikind .eq. 0) then
      else if (ikind .eq. 1) then
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
        q4_tad(4,i,l) = q4_tad(4,i,l)+q2_tad(i,j,k,iq)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))
        q4_tad(3,i,l) = q4_tad(3,i,l)+0.5*q2_tad(i,j,k,iq)*(pr+pl)
        q4_tad(2,i,l) = q4_tad(2,i,l)+q2_tad(i,j,k,iq)*(1+(-0.5)*(pr+pl))
        q2_tad(i,j,k,iq) = 0.d0
      else
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        do ll = l+1, km
          if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
          else
            lf = ll
            exit
          endif
        end do
        qsum_tad = qsum_tad+q2_tad(i,j,k,iq)/(pe2(i,k+1)-pe2(i,k))
        q2_tad(i,j,k,iq) = 0.d0
        if (lf .eq. 0) then
          do ll = l+1, km
            q4_tad(1,i,ll) = q4_tad(1,i,ll)+qsum_tad*dp1(i,ll)
          end do
        else
          ll = lf
          delp = pe2(i,k+1)-pe1(i,ll)
          esl = delp/dp1(i,ll)
          q4_tad(4,i,ll) = q4_tad(4,i,ll)+0.5*qsum_tad*delp*esl*(1.-r23*esl)
          q4_tad(3,i,ll) = q4_tad(3,i,ll)+0.5*qsum_tad*delp*esl
          q4_tad(2,i,ll) = q4_tad(2,i,ll)+qsum_tad*delp*(1+(-0.5)*esl)
          do ll = l+1, lf-1
            q4_tad(1,i,ll) = q4_tad(1,i,ll)+qsum_tad*dp1(i,ll)
          end do
        endif
        q4_tad(4,i,l) = q4_tad(4,i,l)+qsum_tad*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))
        q4_tad(3,i,l) = q4_tad(3,i,l)+0.5*qsum_tad*(pe1(i,l+1)-pe2(i,k))*(1.+pl)
        q4_tad(2,i,l) = q4_tad(2,i,l)+qsum_tad*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
        qsum_tad = 0.d0
      endif
    end do
  end do
  call ppm2m_tad( q4,q4_tad,dp1,km,i1,i2,iv,kord )
  do k = 1, km
    do i = i1, i2
      q1_tad(i,j,k,iq) = q1_tad(i,j,k,iq)+q4_tad(1,i,k)
      q4_tad(1,i,k) = 0.d0
    end do
  end do
end do

end subroutine mapn_ppm_tad


subroutine ppm2m_tad( a4, a4_tad, delp, km, i1, i2, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_tad(4,i1:i2,km)
real(kind=r8) :: delp(i1:i2,km)
integer :: iv
integer :: kord

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a1
real(kind=r8) :: a2
real(kind=r8) :: c1
real(kind=r8) :: c1_tad
real(kind=r8) :: c2
real(kind=r8) :: c3
real(kind=r8) :: c3_tad
real(kind=r8) :: cmax
real(kind=r8) :: cmax_tad
real(kind=r8) :: cmin
real(kind=r8) :: cmin_tad
real(kind=r8) :: d1
real(kind=r8) :: d2
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: dc(i1:i2,km)
real(kind=r8) :: dc_tad(i1:i2,km)
double precision :: dci
double precision :: dci_tae
double precision :: dcj_tad
real(kind=r8) :: delq(i1:i2,km)
real(kind=r8) :: delq_tad(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_tad(i1:i2,km)
real(kind=r8) :: dq
real(kind=r8) :: dq_tad
real(kind=r8) :: fac
real(kind=r8) :: h2(i1:i2,km)
real(kind=r8) :: h2_tad(i1:i2,km)
integer :: i
integer :: it
integer :: k
integer :: km1
real(kind=r8) :: lac
real(kind=r8) :: lac_tad
integer :: lmt
real(kind=r8) :: pmp
real(kind=r8) :: pmp_tad
real(kind=8) :: ppm2m_a4_10h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_11h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_12h(4,1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_13h(4,1+i2-i1,(-4)+km,1)
real(kind=8), allocatable :: ppm2m_a4_14h(:,:,:,:)
real(kind=8) :: ppm2m_a4_1h(1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_2h(2,1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_3h(1+i2-i1,3,1)
real(kind=8) :: ppm2m_a4_4h(1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_5h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_6h(1+i2-i1,2,1)
real(kind=8), allocatable :: ppm2m_a4_7h(:,:,:)
real(kind=8), allocatable :: ppm2m_a4_8h(:,:,:)
real(kind=8) :: ppm2m_a4_9h(1+i2-i1,1)
integer :: ppm2m_ppm2m
real(kind=r8) :: qm
real(kind=r8) :: qm_tad
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxj
double precision :: qmaxj_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminj
double precision :: qminj_tad
double precision :: qmink_tad
real(kind=r8) :: qmp
real(kind=r8) :: qmp_tad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
c1_tad = 0.d0
c3_tad = 0.d0
cmax_tad = 0.d0
cmin_tad = 0.d0
dc_tad(:,:) = 0.d0
delq_tad(:,:) = 0.d0
df2_tad(:,:) = 0.d0
dq_tad = 0.d0
h2_tad(:,:) = 0.d0
lac_tad = 0.d0
pmp_tad = 0.d0
qm_tad = 0.d0
qmax_tad = 0.d0
qmin_tad = 0.d0
qmp_tad = 0.d0
tmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
km1 = km-1
it = i2-i1+1
!----------------------------------------------
! OPEN TAPE ppm2m
!----------------------------------------------
ppm2m_ppm2m = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    delq(i,k-1) = a4(1,i,k)-a4(1,i,k-1)
    d4(i,k) = delp(i,k-1)+delp(i,k)
  end do
end do
ppm2m_a4_1h(:,:,1) = a4(1,i1:i2,:)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
    df2(i,k) = tmp
  end do
end do
do k = 3, km1
  do i = i1, i2
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a4(2,i,k) = a4(1,i,k-1)+c1+2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-delp(i,k-1)*a1*dc(i,k))
  end do
end do
ppm2m_a4_2h(:,:,:,1) = a4(1:2,i1:i2,:)
call steepz( i1,i2,km,a4,df2,dc,delq,delp,d4 )
ppm2m_a4_3h(:,:,1) = a4(2,i1:i2,1:3)
ppm2m_a4_4h(:,:,1) = a4(1,i1:i2,1:2)
do i = i1, i2
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  dc(i,1) = a4(1,i,1)-a4(2,i,1)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  a4(2,i,2) = min(cmax,a4(2,i,2))
end do
ppm2m_a4_5h(:,1) = a4(1,i1:i2,1)
ppm2m_a4_6h(:,:,1) = a4(2,i1:i2,1:2)
if (iv .eq. 0) then
  do i = i1, i2
    a4(2,i,1) = a4(1,i,1)
    a4(3,i,1) = a4(1,i,1)
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4(2,i,1) = a4(1,i,1)
      a4(3,i,1) = a4(1,i,1)
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4(2,i,1) = 0.
      else
        a4(2,i,1) = sign(min(abs(a4(1,i,1)),abs(a4(2,i,1))),a4(1,i,1))
      endif
    end do
  endif
endif
if ( .not. allocated(ppm2m_a4_7h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_7h)) then
    allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_7h(:,:,1) = a4(1,i1:i2,km1:km)
if ( .not. allocated(ppm2m_a4_8h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_8h)) then
    allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_8h(:,:,1) = a4(2,i1:i2,km1:km)
ppm2m_a4_9h(:,1) = a4(3,i1:i2,km)
do i = i1, i2
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  dc(i,km) = a4(3,i,km)-a4(1,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  a4(2,i,km) = min(cmax,a4(2,i,km))
end do
ppm2m_a4_10h(:,1) = a4(1,i1:i2,km)
ppm2m_a4_11h(:,1) = a4(3,i1:i2,km)
if (iv .eq. 0) then
  do i = i1, i2
    a4(3,i,km) = max(0._8,a4(3,i,km))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4(3,i,km) = 0.
    else
      a4(3,i,km) = sign(min(abs(a4(1,i,km)),abs(a4(3,i,km))),a4(1,i,km))
    endif
  end do
endif
do k = 1, km1
  do i = i1, i2
    a4(3,i,k) = a4(2,i,k+1)
  end do
end do
ppm2m_a4_12h(:,:,:,1) = a4(:,i1:i2,1:2)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm( dc(i1,k),a4(1,i1,k),it,0 )
end do
ppm2m_a4_13h(:,:,:,1) = a4(:,i1:i2,3:km-2)
if (kord .ge. 7) then
  do k = 2, km1
    do i = i1, i2
      h2(i,k) = dc(i,k+1)-dc(i,k-1)
    end do
  end do
  if (kord .eq. 7) then
    fac = 1.5
  else
    fac = 0.125
  endif
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm( dc(i1,k),a4(1,i1,k),it,2 )
    endif
  end do
else
  lmt = kord-3
  lmt = max(0,lmt)
  if (iv .eq. 0) then
    lmt = min(2,lmt)
  endif
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm( dc(i1,k),a4(1,i1,k),it,lmt )
  end do
endif
if ( .not. allocated(ppm2m_a4_14h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_14h)) then
    allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_14h(:,:,:,1) = a4(:,i1:i2,km1:km)

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
a4(:,i1:i2,km1:km) = ppm2m_a4_14h(:,:,:,1)
do k = km1, km
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,0 )
  do i = i1, i2
    a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
    a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
    a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
    a4_tad(4,i,k) = 0.d0
  end do
end do
a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
if (kord .ge. 7) then
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,2 )
    endif
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      lac_tad = 0.d0
      pmp_tad = 0.d0
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      qmp_tad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
      a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
      a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
      a4_tad(4,i,k) = 0.d0
      qmax_tad = qmax_tad+a4_tad(2,i,k)*(0.5-sign(0.5d0,qmax-max(a4(2,i,k),qmin)))
      qmin_tad = qmin_tad+a4_tad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5-sign(0.5d0,a4(2,i,k)-qmin))
      a4_tad(2,i,k) = a4_tad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5+sign(0.5d0,a4(2,i,k)-qmin))
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmax_tad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_tad = qmp_tad+qmax_tad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmin_tad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_tad = qmp_tad+qmin_tad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+lac_tad
      dc_tad(i,k) = dc_tad(i,k)-lac_tad
      h2_tad(i,k+1) = h2_tad(i,k+1)+lac_tad*fac
      lac_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmp_tad
      pmp_tad = pmp_tad-qmp_tad
      qmp_tad = 0.d0
      dc_tad(i,k) = dc_tad(i,k)+2*pmp_tad
      pmp_tad = 0.d0
    end do
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      lac_tad = 0.d0
      pmp_tad = 0.d0
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      qmp_tad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      qmax_tad = qmax_tad+a4_tad(3,i,k)*(0.5-sign(0.5d0,qmax-max(a4(3,i,k),qmin)))
      qmin_tad = qmin_tad+a4_tad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5-sign(0.5d0,a4(3,i,k)-qmin))
      a4_tad(3,i,k) = a4_tad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5+sign(0.5d0,a4(3,i,k)-qmin))
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmax_tad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_tad = qmp_tad+qmax_tad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmin_tad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_tad = qmp_tad+qmin_tad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+lac_tad
      dc_tad(i,k) = dc_tad(i,k)+lac_tad
      h2_tad(i,k-1) = h2_tad(i,k-1)+lac_tad*fac
      lac_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmp_tad
      pmp_tad = pmp_tad+qmp_tad
      qmp_tad = 0.d0
      dc_tad(i,k) = dc_tad(i,k)+2*pmp_tad
      pmp_tad = 0.d0
    end do
  end do
  do k = 2, km1
    do i = i1, i2
      dc_tad(i,k-1) = dc_tad(i,k-1)-h2_tad(i,k)
      dc_tad(i,k+1) = dc_tad(i,k+1)+h2_tad(i,k)
      h2_tad(i,k) = 0.d0
    end do
  end do
else
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,lmt )
    if (kord .ne. 4) then
      do i = i1, i2
        a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
        a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
        a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
        a4_tad(4,i,k) = 0.d0
      end do
    endif
  end do
endif
a4(:,i1:i2,1:2) = ppm2m_a4_12h(:,:,:,1)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,0 )
  do i = i1, i2
    a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
    a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
    a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
    a4_tad(4,i,k) = 0.d0
  end do
end do
do k = 1, km1
  do i = i1, i2
    a4_tad(2,i,k+1) = a4_tad(2,i,k+1)+a4_tad(3,i,k)
    a4_tad(3,i,k) = 0.d0
  end do
end do
a4(1,i1:i2,km) = ppm2m_a4_10h(:,1)
a4(3,i1:i2,km) = ppm2m_a4_11h(:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_tad(3,i,km) = a4_tad(3,i,km)*(0.5-sign(0.5d0,0._8-a4(3,i,km)))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4_tad(3,i,km) = 0.d0
    else
      a4_tad(1,i,km) = a4_tad(1,i,km)+a4_tad(3,i,km)*(0.5+sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*&
&sign(1.d0,a4(1,i,km))*sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
      a4_tad(3,i,km) = a4_tad(3,i,km)*(0.5-sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(3,i,km))&
&*sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
    endif
  end do
endif
a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
do i = i1, i2
  c1_tad = 0.d0
  c3_tad = 0.d0
  cmax_tad = 0.d0
  cmin_tad = 0.d0
  dq_tad = 0.d0
  qm_tad = 0.d0
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  cmax_tad = cmax_tad+a4_tad(2,i,km)*(0.5+sign(0.5d0,a4(2,i,km)-cmax))
  a4_tad(2,i,km) = a4_tad(2,i,km)*(0.5-sign(0.5d0,a4(2,i,km)-cmax))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmin_tad = cmin_tad+a4_tad(2,i,km)*(0.5+sign(0.5d0,cmin-a4(2,i,km)))
  a4_tad(2,i,km) = a4_tad(2,i,km)*(0.5-sign(0.5d0,cmin-a4(2,i,km)))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_tad(1,i,km) = a4_tad(1,i,km)+cmin_tad*(0.5+sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+cmin_tad*(0.5-sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  cmin_tad = 0.d0
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_tad(1,i,km) = a4_tad(1,i,km)+cmax_tad*(0.5+sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+cmax_tad*(0.5-sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  cmax_tad = 0.d0
  a4_tad(3,i,km) = a4_tad(3,i,km)+dc_tad(i,km)
  a4_tad(1,i,km) = a4_tad(1,i,km)-dc_tad(i,km)
  dc_tad(i,km) = 0.d0
  c1_tad = c1_tad+8*a4_tad(3,i,km)*d1*d1**2
  c3_tad = c3_tad-a4_tad(3,i,km)*d1
  a4_tad(2,i,km) = a4_tad(2,i,km)+a4_tad(3,i,km)
  a4_tad(3,i,km) = 0.d0
  c1_tad = c1_tad-a4_tad(2,i,km)*d1*d2*(d2+3.*d1)
  qm_tad = qm_tad+a4_tad(2,i,km)
  a4_tad(2,i,km) = 0.d0
  c1_tad = c1_tad-2*c3_tad*(d2*(5.*d1+d2)-3.*d1**2)
  dq_tad = dq_tad+c3_tad
  c3_tad = 0.d0
  a4_tad(2,i,km1) = a4_tad(2,i,km1)+c1_tad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  dq_tad = dq_tad-c1_tad*(d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_tad = qm_tad-c1_tad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c1_tad = 0.d0
  a4_tad(1,i,km) = a4_tad(1,i,km)+dq_tad*((-2)/(d1+d2))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+dq_tad*(2/(d1+d2))
  dq_tad = 0.d0
  a4_tad(1,i,km) = a4_tad(1,i,km)+qm_tad*(d2/(d1+d2))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+qm_tad*(d1/(d1+d2))
  qm_tad = 0.d0
end do
a4(1,i1:i2,1) = ppm2m_a4_5h(:,1)
a4(2,i1:i2,1:2) = ppm2m_a4_6h(:,:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(3,i,1)
    a4_tad(3,i,1) = 0.d0
    a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(2,i,1)
    a4_tad(2,i,1) = 0.d0
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(3,i,1)
      a4_tad(3,i,1) = 0.d0
      a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(2,i,1)
      a4_tad(2,i,1) = 0.d0
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4_tad(2,i,1) = 0.d0
      else
        a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(2,i,1)*(0.5+sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,&
&a4(1,i,1))*sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
        a4_tad(2,i,1) = a4_tad(2,i,1)*(0.5-sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(2,i,1))*&
&sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
      endif
    end do
  endif
endif
a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
do i = i1, i2
  c1_tad = 0.d0
  c3_tad = 0.d0
  cmax_tad = 0.d0
  cmin_tad = 0.d0
  dq_tad = 0.d0
  qm_tad = 0.d0
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  cmax_tad = cmax_tad+a4_tad(2,i,2)*(0.5+sign(0.5d0,a4(2,i,2)-cmax))
  a4_tad(2,i,2) = a4_tad(2,i,2)*(0.5-sign(0.5d0,a4(2,i,2)-cmax))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmin_tad = cmin_tad+a4_tad(2,i,2)*(0.5+sign(0.5d0,cmin-a4(2,i,2)))
  a4_tad(2,i,2) = a4_tad(2,i,2)*(0.5-sign(0.5d0,cmin-a4(2,i,2)))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_tad(1,i,2) = a4_tad(1,i,2)+cmin_tad*(0.5-sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  a4_tad(1,i,1) = a4_tad(1,i,1)+cmin_tad*(0.5+sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  cmin_tad = 0.d0
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_tad(1,i,2) = a4_tad(1,i,2)+cmax_tad*(0.5-sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  a4_tad(1,i,1) = a4_tad(1,i,1)+cmax_tad*(0.5+sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  cmax_tad = 0.d0
  a4_tad(2,i,1) = a4_tad(2,i,1)-dc_tad(i,1)
  a4_tad(1,i,1) = a4_tad(1,i,1)+dc_tad(i,1)
  dc_tad(i,1) = 0.d0
  c1_tad = c1_tad+2*a4_tad(2,i,1)*d1*d1**2
  c3_tad = c3_tad-a4_tad(2,i,1)*d1
  a4_tad(2,i,2) = a4_tad(2,i,2)+a4_tad(2,i,1)
  a4_tad(2,i,1) = 0.d0
  c1_tad = c1_tad-0.25*a4_tad(2,i,2)*d1*d2*(d2+3.*d1)
  qm_tad = qm_tad+a4_tad(2,i,2)
  a4_tad(2,i,2) = 0.d0
  c1_tad = c1_tad-0.5*c3_tad*(d2*(5.*d1+d2)-3.*d1**2)
  dq_tad = dq_tad+c3_tad
  c3_tad = 0.d0
  a4_tad(2,i,3) = a4_tad(2,i,3)+c1_tad*(4/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  dq_tad = dq_tad-c1_tad*(4.*d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_tad = qm_tad+c1_tad*((-4)/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  c1_tad = 0.d0
  a4_tad(1,i,2) = a4_tad(1,i,2)+dq_tad*(2/(d1+d2))
  a4_tad(1,i,1) = a4_tad(1,i,1)+dq_tad*((-2)/(d1+d2))
  dq_tad = 0.d0
  a4_tad(1,i,2) = a4_tad(1,i,2)+qm_tad*(d1/(d1+d2))
  a4_tad(1,i,1) = a4_tad(1,i,1)+qm_tad*(d2/(d1+d2))
  qm_tad = 0.d0
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
  end do
end do
a4(1:2,i1:i2,:) = ppm2m_a4_2h(:,:,:,1)
call steepz_tad( i1,i2,km,a4,a4_tad,df2,df2_tad,dc,dc_tad,delq,delq_tad,delp,d4 )
do k = 3, km1
  c1_tad = 0.d0
  do i = i1, i2
    c1_tad = 0.d0
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    c1_tad = c1_tad+a4_tad(2,i,k)*(1+2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*(a1-a2))
    dc_tad(i,k-1) = dc_tad(i,k-1)+a4_tad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*a2
    dc_tad(i,k) = dc_tad(i,k)-a4_tad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k-1)*a1
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+a4_tad(2,i,k)
    a4_tad(2,i,k) = 0.d0
    delq_tad(i,k-1) = delq_tad(i,k-1)+c1_tad*(delp(i,k-1)/d4(i,k))
    c1_tad = 0.d0
  end do
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  c1_tad = 0.d0
  qmax_tad = 0.d0
  qmin_tad = 0.d0
  tmp_tad = 0.d0
  do i = i1, i2
    c1_tad = 0.d0
    qmax_tad = 0.d0
    qmin_tad = 0.d0
    tmp_tad = 0.d0
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    tmp_tad = tmp_tad+df2_tad(i,k)
    df2_tad(i,k) = 0.d0
    dci = min(abs(tmp),qmax)
    dcj_tad = dc_tad(i,k)*sign(1.d0,min(dci,qmin))*sign(1.d0,tmp)
    dci_tae = dcj_tad*(0.5+sign(0.5d0,qmin-dci))
    qmin_tad = qmin_tad+dcj_tad*(0.5-sign(0.5d0,qmin-dci))
    qmax_tad = qmax_tad+dci_tae*(0.5-sign(0.5d0,qmax-abs(tmp)))
    tmp_tad = tmp_tad+dci_tae*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
    dc_tad(i,k) = 0.d0
    qminj = min(a4(1,i,k-1),a4(1,i,k))
    a4_tad(1,i,k) = a4_tad(1,i,k)+qmin_tad
    qmink_tad = -qmin_tad
    a4_tad(1,i,k+1) = a4_tad(1,i,k+1)+qmink_tad*(0.5-sign(0.5d0,a4(1,i,k+1)-qminj))
    qminj_tad = qmink_tad*(0.5+sign(0.5d0,a4(1,i,k+1)-qminj))
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+qminj_tad*(0.5+sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    a4_tad(1,i,k) = a4_tad(1,i,k)+qminj_tad*(0.5-sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    qmin_tad = 0.d0
    qmaxj = max(a4(1,i,k-1),a4(1,i,k))
    a4_tad(1,i,k) = a4_tad(1,i,k)-qmax_tad
    a4_tad(1,i,k+1) = a4_tad(1,i,k+1)+qmax_tad*(0.5-sign(0.5d0,qmaxj-a4(1,i,k+1)))
    qmaxj_tad = qmax_tad*(0.5+sign(0.5d0,qmaxj-a4(1,i,k+1)))
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+qmaxj_tad*(0.5+sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    a4_tad(1,i,k) = a4_tad(1,i,k)+qmaxj_tad*(0.5-sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    qmax_tad = 0.d0
    c1_tad = c1_tad+tmp_tad*(delp(i,k)*delq(i,k)/(d4(i,k)+delp(i,k+1)))
    delq_tad(i,k-1) = delq_tad(i,k-1)+tmp_tad*(delp(i,k)*c2/(d4(i,k)+delp(i,k+1)))
    delq_tad(i,k) = delq_tad(i,k)+tmp_tad*(delp(i,k)*c1/(d4(i,k)+delp(i,k+1)))
    tmp_tad = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)-delq_tad(i,k-1)
    a4_tad(1,i,k) = a4_tad(1,i,k)+delq_tad(i,k-1)
    delq_tad(i,k-1) = 0.d0
  end do
end do

!----------------------------------------------
! CLOSE TAPE ppm2m
!----------------------------------------------
if (allocated(ppm2m_a4_7h)) then
  deallocate( ppm2m_a4_7h )
endif
if (allocated(ppm2m_a4_8h)) then
  deallocate( ppm2m_a4_8h )
endif
if (allocated(ppm2m_a4_14h)) then
  deallocate( ppm2m_a4_14h )
endif


end subroutine ppm2m_tad


subroutine steepz_tad( i1, i2, km, a4, a4_tad, df2, df2_tad, dm, dm_tad, dq, dq_tad, dp, d4 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_tad(4,i1:i2,km)
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_tad(i1:i2,km)
real(kind=r8) :: dm(i1:i2,km)
real(kind=r8) :: dm_tad(i1:i2,km)
real(kind=r8) :: dp(i1:i2,km)
real(kind=r8) :: dq(i1:i2,km)
real(kind=r8) :: dq_tad(i1:i2,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alfa(i1:i2,km)
real(kind=r8) :: alfa_tad(i1:i2,km)
real(kind=r8) :: dg2
real(kind=r8) :: dg2_tad
real(kind=r8) :: f(i1:i2,km)
real(kind=r8) :: f_tad(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: rat(i1:i2,km)
real(kind=r8) :: rat_tad(i1:i2,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alfa_tad(:,:) = 0.d0
dg2_tad = 0.d0
f_tad(:,:) = 0.d0
rat_tad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    rat(i,k) = dq(i,k-1)/d4(i,k)
  end do
end do
do k = 2, km-1
  do i = i1, i2
    f(i,k) = (rat(i,k+1)-rat(i,k))/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
  end do
end do
do k = 3, km-2
  do i = i1, i2
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      alfa(i,k) = max(0._8,min(0.5_8,-(0.1875*dg2/df2(i,k))))
    else
      alfa(i,k) = 0.
    endif
  end do
end do
do k = 4, km-2
  do i = i1, i2
    alfa_tad(i,k-1) = alfa_tad(i,k-1)+a4_tad(2,i,k)*((-a4(2,i,k))+a4(1,i,k)-dm(i,k))
    alfa_tad(i,k) = alfa_tad(i,k)+a4_tad(2,i,k)*((-a4(2,i,k))+a4(1,i,k-1)+dm(i,k-1))
    dm_tad(i,k-1) = dm_tad(i,k-1)+a4_tad(2,i,k)*alfa(i,k)
    dm_tad(i,k) = dm_tad(i,k)-a4_tad(2,i,k)*alfa(i,k-1)
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+a4_tad(2,i,k)*alfa(i,k)
    a4_tad(1,i,k) = a4_tad(1,i,k)+a4_tad(2,i,k)*alfa(i,k-1)
    a4_tad(2,i,k) = a4_tad(2,i,k)*(1.-alfa(i,k-1)-alfa(i,k))
  end do
end do
do k = 3, km-2
  dg2_tad = 0.d0
  do i = i1, i2
    dg2_tad = 0.d0
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      df2_tad(i,k) = df2_tad(i,k)+alfa_tad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*&
&dg2/df2(i,k)))-0.5_8))*(0.1875*dg2/(df2(i,k)*df2(i,k)))
      dg2_tad = dg2_tad-alfa_tad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*dg2/df2(i,&
&k)))-0.5_8))*(0.1875/df2(i,k))
      alfa_tad(i,k) = 0.d0
      f_tad(i,k-1) = f_tad(i,k-1)-dg2_tad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      f_tad(i,k+1) = f_tad(i,k+1)+dg2_tad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      dg2_tad = 0.d0
    else
      alfa_tad(i,k) = 0.d0
    endif
  end do
end do
do k = 2, km-1
  do i = i1, i2
    rat_tad(i,k+1) = rat_tad(i,k+1)+f_tad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    rat_tad(i,k) = rat_tad(i,k)-f_tad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    f_tad(i,k) = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    dq_tad(i,k-1) = dq_tad(i,k-1)+rat_tad(i,k)/d4(i,k)
    rat_tad(i,k) = 0.d0
  end do
end do

end subroutine steepz_tad


subroutine te_map_tad( ps, pe, im, jm, km, nx, jfirst, jlast, nq, u, v, q, q_tae, hs, kord, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mod_comm, only : mp_barrier, mp_recv_n, mp_recv_n_ad, mp_recv_pe, mp_recv_pe_ad, mp_send_pe, mp_send_pe_ad, mp_send_s, &
&mp_send_s_ad
use te_map_tad_store, only : te_map_tape_dz_8h,te_map_tape_te_9h,te_map_tape_te_map,te_map_tape_u_6h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: km
integer :: kord
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: q_tae(im,jfirst-ng_d:jlast+ng_d,km,nq)
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dz(im,jfirst:jlast,km)
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: peh_tad(im,1+km,1+jlast-jfirst)
real(kind=r8), allocatable :: pesouthh_tad(:,:)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: uh_tad(im,1+jlast+ng_s-(jfirst-ng_d),km)
real(kind=r8) :: ui_tad(im,1+jlast+ng_s-(jfirst-ng_d),km)
real(kind=r8) :: uj_tad(im,1+jlast+ng_s-(jfirst-ng_d),km)
real(kind=r8) :: uk_tad(im,1+jlast+ng_s-(jfirst-ng_d),km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
peh_tad(:,:,:) = 0.d0
uh_tad(:,:,:) = 0.d0
ui_tad(:,:,:) = 0.d0
uj_tad(:,:,:) = 0.d0
uk_tad(:,:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
help_h = km+1
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe )
u = te_map_tape_u_6h(:,:,:,te_map_tape_rec+1)
v = te_map_tape_v_7h(:,:,:,te_map_tape_rec+1)
dz = te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1)
te = te_map_tape_te_9h(:,:,:,te_map_tape_rec+1)
help_i = km+1
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth )
it = im/nx
jp = nx*(jlast-jfirst+1)
call mp_recv_n_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,uh_tad )
call mp_send_s_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,ui_tad )
#ifdef USE_OPENMP
!$omp parallel do shared(ak,bk,dz,hs,im,it,jfirst,jlast,jm,jp,km,kord,ks,ng_d,ng_s,nq,nx,pe,pesouth,ps,q,q_tae,te,u,v) &
!$omp& private(help_j,help_k,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
    else
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pesouth(i,k))
        end do
      end do
    endif
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    help_k = -1
    call map1_ppm_tad( km,pe0,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_k,kord )
  endif
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
  end do
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
    else
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pesouth(i,k))
        end do
      end do
    endif
    help_j = -1
    call map1_ppm_tad( km,pe0,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_j,kord )
  endif
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm_tad( km,pe1,q,q_tae,nq,km,pe2,q_tae,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  call map1_ppm_tad( km,pe1,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
end do
allocate( pesouthh_tad(1:size(pesouth,1),1:size(pesouth,2)) )
pesouthh_tad(:,:) = 0.
call mp_recv_pe_ad( im,jm,jfirst,jlast,1,help_i,pesouthh_tad )
deallocate( pesouthh_tad )
call mp_send_pe_ad( im,jm,jfirst,jlast,1,help_h,peh_tad )
call mp_recv_n_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,uj_tad )
call mp_send_s_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,uk_tad )

end subroutine te_map_tad


subroutine te_mapmd( consv, convt, ps, omga, pe, delp, pkz, pk, mdt, im, jm, km, nx, jfirst, jlast, nq, u, v, pt, q, hs, cp, akap, &
&kord, peln, te0, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mod_comm, only : mp_barrier, mp_recv_n, mp_recv_pe, mp_send_pe, mp_send_s
use te_map_tad_store, only : te_map_tape_dz_8h,te_map_tape_te_9h,te_map_tape_te_map,te_map_tape_u_6h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: mdt
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: omga(im,km,jfirst:jlast)
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: dak
real(kind=r8) :: dlnp
real(kind=r8) :: dtmp
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te_np
real(kind=r8) :: te_sp
real(kind=r8) :: tsum
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: u2(im,jfirst:jlast+1)
real(kind=r8) :: v2(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: ysum

!**********************************************
! executable statements of routine
!**********************************************
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .false.  )
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
help_h = km+1
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe )
if ( .not. allocated(te_map_tape_u_6h)) then
  allocate( te_map_tape_u_6h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,te_map_tape_te_map) )
endif
te_map_tape_u_6h(:,:,:,te_map_tape_rec+1) = u
if ( .not. allocated(te_map_tape_v_7h)) then
  allocate( te_map_tape_v_7h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,te_map_tape_te_map) )
endif
te_map_tape_v_7h(:,:,:,te_map_tape_rec+1) = v
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,t2,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = 0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))+t2(i,j)*pkz(i,j,k)
    end do
    te(im,j,k) = 0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))+t2(im,j)*pkz(im,j,k)
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = 0.5*te_sp/float(im)+t2(1,1)*pkz(1,1,k)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = 0.5*te_np/float(im)+t2(1,jm)*pkz(1,jm,k)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
  do j = jfirst, jlast
    do i = 1, im
      dz(i,j,k) = t2(i,j)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do
if ( .not. allocated(te_map_tape_dz_8h)) then
  allocate( te_map_tape_dz_8h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1) = dz
if ( .not. allocated(te_map_tape_te_9h)) then
  allocate( te_map_tape_te_9h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_9h(:,:,:,te_map_tape_rec+1) = te
help_i = km+1
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth )
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do private(bkh,dak,help_j,help_k,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,pe2w,pe3,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    ps(i,j) = pe1(i,km+1)
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      dak = ak(k+1)-ak(k)
      do i = i1, i2
        delp(i,j,k) = dak
      end do
    end do
  endif
  do k = ks+1, km
    do i = i1, i2
      delp(i,j,k) = pe2(i,k+1)-pe2(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  call map1_ppm( km,pe1,te,km,pe2,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm( km,pe1,q,nq,km,pe2,q,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    else
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pesouth(i,k))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pesouth(i,km+1))
        end do
      end do
    endif
    help_j = -1
    call map1_ppm( km,pe0,u,km,pe3,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_j,kord )
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_k = -1
    call map1_ppm( km,pe0,v,km,pe3,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_k,kord )
  endif
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .true.  )
if (consv) then
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,xsum,ysum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = te_acap*cp*(ps(1,1)-2.*te_ptop-akap*te_ptop*(peln(1,km+1,1)-peln(1,1,1)))
    else if (j .eq. jm) then
      tte(jm) = te_acap*cp*(ps(1,jm)-akap*te_ptop*(peln(1,km+1,jm)-peln(1,1,jm)))
    else
      xsum = 0.
      ysum = 0.
      do i = 1, im
        xsum = xsum+ps(i,j)
        ysum = ysum+peln(i,km+1,j)
      end do
      tte(j) = cp*te_cosp(j)*(xsum-te_ptop*im-akap*te_ptop*(ysum-peln(1,1,j)*im))
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,tsum )
  dtmp = (te0-te1)/tsum
else
  dtmp = 0.
endif
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = te(i,j,k)-0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))
    end do
    te(im,j,k) = te(im,j,k)-0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = te(1,1,k)-0.5*te_sp/float(im)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = te(1,jm,k)-0.5*te_np/float(im)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
end do
#ifdef USE_OPENMP
!$omp parallel do private(dlnp,gz,i,i1,i2,ixj,j,k,rg,tvm) ! broadcast()
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)/pkz(i,j,k)
      end do
    endif
  end do
end do
end subroutine te_mapmd


end module     mapz_module_tad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     te_map_tad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: te_map_tape_dz_8h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_9h(:,:,:,:)
integer :: te_map_tape_te_map
real(kind=8), allocatable :: te_map_tape_u_6h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_v_7h(:,:,:,:)

end module     te_map_tad_store


module     mapz_module_tad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mapz_module

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine kmppm_tad( dm, dm_tad, a4, a4_tad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a4(4,im)
real(kind=r8) :: a4_tad(4,im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_tad(im)
integer :: lmt

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a4h(4,im)
real(kind=r8) :: a6da
real(kind=r8) :: a6da_tad
real(kind=r8) :: da1
real(kind=r8) :: da1_tad
real(kind=r8) :: da2
real(kind=r8) :: da2_tad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_tad
integer :: i
real(kind=r8) :: qmp
real(kind=r8) :: qmp_tad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
a4h(:,:) = a4(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_tad = 0.d0
da1_tad = 0.d0
da2_tad = 0.d0
fmin_tad = 0.d0
qmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .ne. 3) then
  if (lmt .eq. 0) then
    do i = 1, im
      a6da_tad = 0.d0
      da1_tad = 0.d0
      da2_tad = 0.d0
      if (dm(i) .eq. 0.) then
        a4_tad(4,i) = 0.d0
        a4_tad(1,i) = a4_tad(1,i)+a4_tad(3,i)
        a4_tad(3,i) = 0.d0
        a4_tad(1,i) = a4_tad(1,i)+a4_tad(2,i)
        a4_tad(2,i) = 0.d0
      else
        da1 = a4(3,i)-a4(2,i)
        da2 = da1**2
        a6da = a4(4,i)*da1
        if (a6da .lt. (-da2)) then
          a4_tad(4,i) = a4_tad(4,i)-a4_tad(3,i)
          a4_tad(2,i) = a4_tad(2,i)+a4_tad(3,i)
          a4_tad(3,i) = 0.d0
          a4_tad(2,i) = a4_tad(2,i)+3*a4_tad(4,i)
          a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
          a4_tad(4,i) = 0.d0
        else if (a6da .gt. da2) then
          a4_tad(4,i) = a4_tad(4,i)-a4_tad(2,i)
          a4_tad(3,i) = a4_tad(3,i)+a4_tad(2,i)
          a4_tad(2,i) = 0.d0
          a4_tad(3,i) = a4_tad(3,i)+3*a4_tad(4,i)
          a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
          a4_tad(4,i) = 0.d0
        endif
        a4_tad(4,i) = a4_tad(4,i)+a6da_tad*da1
        da1_tad = da1_tad+a6da_tad*a4(4,i)
        a6da_tad = 0.d0
        da1_tad = da1_tad+2*da2_tad*da1
        da2_tad = 0.d0
        a4_tad(3,i) = a4_tad(3,i)+da1_tad
        a4_tad(2,i) = a4_tad(2,i)-da1_tad
        da1_tad = 0.d0
      endif
    end do
  else if (lmt .eq. 1) then
    do i = 1, im
      qmp_tad = 0.d0
      qmp = 2.*dm(i)
      a4(2,i) = a4(1,i)-sign(min(abs(qmp),abs(a4(2,i)-a4(1,i))),qmp)
      a4_tad(3,i) = a4_tad(3,i)-3*a4_tad(4,i)
      a4_tad(2,i) = a4_tad(2,i)-3*a4_tad(4,i)
      a4_tad(1,i) = a4_tad(1,i)+6*a4_tad(4,i)
      a4_tad(4,i) = 0.d0
      qmp_tad = qmp_tad+a4_tad(3,i)*(0.5+sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4_tad(1,i) = a4_tad(1,i)+a4_tad(3,i)*(1-(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-&
&a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i)))))
      a4_tad(3,i) = a4_tad(3,i)*(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4(:,:) = a4h(:,:)
      qmp_tad = qmp_tad-a4_tad(2,i)*(0.5+sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(2,i)-a4(1,i))))
      a4_tad(1,i) = a4_tad(1,i)+a4_tad(2,i)*(1+(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-&
&a4(1,i))*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      a4_tad(2,i) = -(a4_tad(2,i)*(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      dm_tad(i) = dm_tad(i)+2*qmp_tad
      qmp_tad = 0.d0
    end do
  else if (lmt .eq. 2) then
    do i = 1, im
      fmin_tad = 0.d0
      if (abs(a4(3,i)-a4(2,i)) .lt. (-a4(4,i))) then
        fmin = a4(1,i)+0.25*(a4(3,i)-a4(2,i))**2/a4(4,i)+a4(4,i)*r12
        if (fmin .lt. 0.) then
          if (a4(1,i) .lt. a4(3,i) .and. a4(1,i) .lt. a4(2,i)) then
            a4_tad(4,i) = 0.d0
            a4_tad(1,i) = a4_tad(1,i)+a4_tad(2,i)
            a4_tad(2,i) = 0.d0
            a4_tad(1,i) = a4_tad(1,i)+a4_tad(3,i)
            a4_tad(3,i) = 0.d0
          else if (a4(3,i) .gt. a4(2,i)) then
            a4_tad(4,i) = a4_tad(4,i)-a4_tad(3,i)
            a4_tad(2,i) = a4_tad(2,i)+a4_tad(3,i)
            a4_tad(3,i) = 0.d0
            a4_tad(2,i) = a4_tad(2,i)+3*a4_tad(4,i)
            a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
            a4_tad(4,i) = 0.d0
          else
            a4_tad(4,i) = a4_tad(4,i)-a4_tad(2,i)
            a4_tad(3,i) = a4_tad(3,i)+a4_tad(2,i)
            a4_tad(2,i) = 0.d0
            a4_tad(3,i) = a4_tad(3,i)+3*a4_tad(4,i)
            a4_tad(1,i) = a4_tad(1,i)-3*a4_tad(4,i)
            a4_tad(4,i) = 0.d0
          endif
        endif
        a4_tad(4,i) = a4_tad(4,i)+fmin_tad*((-(0.25*(a4(3,i)-a4(2,i))**2/(a4(4,i)*a4(4,i))))+r12)
        a4_tad(3,i) = a4_tad(3,i)+fmin_tad*(0.5*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_tad(2,i) = a4_tad(2,i)+fmin_tad*((-0.5)*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_tad(1,i) = a4_tad(1,i)+fmin_tad
        fmin_tad = 0.d0
      endif
    end do
  endif
endif

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine kmppm_tad


subroutine map1_ppm_tad( km, pe1, q1, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kord
integer :: ng_n
integer :: ng_s
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dp1(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4h_tad(4,1+i2-i1,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
q4h_tad(:,:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
    q4(1,i,k) = q1(i,j,k)
  end do
end do
call ppm2m_tad( q4,q4h_tad,dp1,km,i1,i2,iv,kord )

end subroutine map1_ppm_tad


subroutine mapn_ppm_tad( km, pe1, q1, q1_tad, nq, kn, pe2, q2_tad, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
integer :: nq
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q1_tad(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q2_tad(im,jfirst-ng_s:jlast+ng_n,kn,nq)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: esl
integer :: i
integer :: ikind
integer :: iq
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pr
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_tad(4,i1:i2,km)
real(kind=r8) :: qsum_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
q4_tad(:,:,:) = 0.d0
qsum_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
  end do
end do
do iq = nq, 1, -1
  do k = 1, km
    do i = i1, i2
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  do i = i1, i2
    k0 = 1
    do k = 1, kn
      ikind = 0
      do l = k0, km
        if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
          if (pe2(i,k+1) .le. pe1(i,l+1)) then
            ikind = 1
            exit
          else
            ikind = 2
            exit
          endif
        endif
      end do
      if (ikind .eq. 0) then
      else if (ikind .eq. 1) then
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
        q4_tad(4,i,l) = q4_tad(4,i,l)+q2_tad(i,j,k,iq)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))
        q4_tad(3,i,l) = q4_tad(3,i,l)+0.5*q2_tad(i,j,k,iq)*(pr+pl)
        q4_tad(2,i,l) = q4_tad(2,i,l)+q2_tad(i,j,k,iq)*(1+(-0.5)*(pr+pl))
        q2_tad(i,j,k,iq) = 0.d0
      else
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        do ll = l+1, km
          if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
          else
            lf = ll
            exit
          endif
        end do
        qsum_tad = qsum_tad+q2_tad(i,j,k,iq)/(pe2(i,k+1)-pe2(i,k))
        q2_tad(i,j,k,iq) = 0.d0
        if (lf .eq. 0) then
          do ll = l+1, km
            q4_tad(1,i,ll) = q4_tad(1,i,ll)+qsum_tad*dp1(i,ll)
          end do
        else
          ll = lf
          delp = pe2(i,k+1)-pe1(i,ll)
          esl = delp/dp1(i,ll)
          q4_tad(4,i,ll) = q4_tad(4,i,ll)+0.5*qsum_tad*delp*esl*(1.-r23*esl)
          q4_tad(3,i,ll) = q4_tad(3,i,ll)+0.5*qsum_tad*delp*esl
          q4_tad(2,i,ll) = q4_tad(2,i,ll)+qsum_tad*delp*(1+(-0.5)*esl)
          do ll = l+1, lf-1
            q4_tad(1,i,ll) = q4_tad(1,i,ll)+qsum_tad*dp1(i,ll)
          end do
        endif
        q4_tad(4,i,l) = q4_tad(4,i,l)+qsum_tad*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))
        q4_tad(3,i,l) = q4_tad(3,i,l)+0.5*qsum_tad*(pe1(i,l+1)-pe2(i,k))*(1.+pl)
        q4_tad(2,i,l) = q4_tad(2,i,l)+qsum_tad*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
        qsum_tad = 0.d0
      endif
    end do
  end do
  call ppm2m_tad( q4,q4_tad,dp1,km,i1,i2,iv,kord )
  do k = 1, km
    do i = i1, i2
      q1_tad(i,j,k,iq) = q1_tad(i,j,k,iq)+q4_tad(1,i,k)
      q4_tad(1,i,k) = 0.d0
    end do
  end do
end do

end subroutine mapn_ppm_tad


subroutine ppm2m_tad( a4, a4_tad, delp, km, i1, i2, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_tad(4,i1:i2,km)
real(kind=r8) :: delp(i1:i2,km)
integer :: iv
integer :: kord

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a1
real(kind=r8) :: a2
real(kind=r8) :: c1
real(kind=r8) :: c1_tad
real(kind=r8) :: c2
real(kind=r8) :: c3
real(kind=r8) :: c3_tad
real(kind=r8) :: cmax
real(kind=r8) :: cmax_tad
real(kind=r8) :: cmin
real(kind=r8) :: cmin_tad
real(kind=r8) :: d1
real(kind=r8) :: d2
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: dc(i1:i2,km)
real(kind=r8) :: dc_tad(i1:i2,km)
double precision :: dci
double precision :: dci_tae
double precision :: dcj_tad
real(kind=r8) :: delq(i1:i2,km)
real(kind=r8) :: delq_tad(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_tad(i1:i2,km)
real(kind=r8) :: dq
real(kind=r8) :: dq_tad
real(kind=r8) :: fac
real(kind=r8) :: h2(i1:i2,km)
real(kind=r8) :: h2_tad(i1:i2,km)
integer :: i
integer :: it
integer :: k
integer :: km1
real(kind=r8) :: lac
real(kind=r8) :: lac_tad
integer :: lmt
real(kind=r8) :: pmp
real(kind=r8) :: pmp_tad
real(kind=8) :: ppm2m_a4_10h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_11h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_12h(4,1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_13h(4,1+i2-i1,(-4)+km,1)
real(kind=8), allocatable :: ppm2m_a4_14h(:,:,:,:)
real(kind=8) :: ppm2m_a4_1h(1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_2h(2,1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_3h(1+i2-i1,3,1)
real(kind=8) :: ppm2m_a4_4h(1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_5h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_6h(1+i2-i1,2,1)
real(kind=8), allocatable :: ppm2m_a4_7h(:,:,:)
real(kind=8), allocatable :: ppm2m_a4_8h(:,:,:)
real(kind=8) :: ppm2m_a4_9h(1+i2-i1,1)
integer :: ppm2m_ppm2m
real(kind=r8) :: qm
real(kind=r8) :: qm_tad
real(kind=r8) :: qmax
real(kind=r8) :: qmax_tad
double precision :: qmaxj
double precision :: qmaxj_tad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_tad
double precision :: qminj
double precision :: qminj_tad
double precision :: qmink_tad
real(kind=r8) :: qmp
real(kind=r8) :: qmp_tad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_tad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
c1_tad = 0.d0
c3_tad = 0.d0
cmax_tad = 0.d0
cmin_tad = 0.d0
dc_tad(:,:) = 0.d0
delq_tad(:,:) = 0.d0
df2_tad(:,:) = 0.d0
dq_tad = 0.d0
h2_tad(:,:) = 0.d0
lac_tad = 0.d0
pmp_tad = 0.d0
qm_tad = 0.d0
qmax_tad = 0.d0
qmin_tad = 0.d0
qmp_tad = 0.d0
tmp_tad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
km1 = km-1
it = i2-i1+1
!----------------------------------------------
! OPEN TAPE ppm2m
!----------------------------------------------
ppm2m_ppm2m = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    delq(i,k-1) = a4(1,i,k)-a4(1,i,k-1)
    d4(i,k) = delp(i,k-1)+delp(i,k)
  end do
end do
ppm2m_a4_1h(:,:,1) = a4(1,i1:i2,:)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
    df2(i,k) = tmp
  end do
end do
do k = 3, km1
  do i = i1, i2
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a4(2,i,k) = a4(1,i,k-1)+c1+2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-delp(i,k-1)*a1*dc(i,k))
  end do
end do
ppm2m_a4_2h(:,:,:,1) = a4(1:2,i1:i2,:)
call steepz( i1,i2,km,a4,df2,dc,delq,delp,d4 )
ppm2m_a4_3h(:,:,1) = a4(2,i1:i2,1:3)
ppm2m_a4_4h(:,:,1) = a4(1,i1:i2,1:2)
do i = i1, i2
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  dc(i,1) = a4(1,i,1)-a4(2,i,1)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  a4(2,i,2) = min(cmax,a4(2,i,2))
end do
ppm2m_a4_5h(:,1) = a4(1,i1:i2,1)
ppm2m_a4_6h(:,:,1) = a4(2,i1:i2,1:2)
if (iv .eq. 0) then
  do i = i1, i2
    a4(2,i,1) = a4(1,i,1)
    a4(3,i,1) = a4(1,i,1)
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4(2,i,1) = a4(1,i,1)
      a4(3,i,1) = a4(1,i,1)
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4(2,i,1) = 0.
      else
        a4(2,i,1) = sign(min(abs(a4(1,i,1)),abs(a4(2,i,1))),a4(1,i,1))
      endif
    end do
  endif
endif
if ( .not. allocated(ppm2m_a4_7h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_7h)) then
    allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_7h(:,:,1) = a4(1,i1:i2,km1:km)
if ( .not. allocated(ppm2m_a4_8h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_8h)) then
    allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_8h(:,:,1) = a4(2,i1:i2,km1:km)
ppm2m_a4_9h(:,1) = a4(3,i1:i2,km)
do i = i1, i2
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  dc(i,km) = a4(3,i,km)-a4(1,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  a4(2,i,km) = min(cmax,a4(2,i,km))
end do
ppm2m_a4_10h(:,1) = a4(1,i1:i2,km)
ppm2m_a4_11h(:,1) = a4(3,i1:i2,km)
if (iv .eq. 0) then
  do i = i1, i2
    a4(3,i,km) = max(0._8,a4(3,i,km))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4(3,i,km) = 0.
    else
      a4(3,i,km) = sign(min(abs(a4(1,i,km)),abs(a4(3,i,km))),a4(1,i,km))
    endif
  end do
endif
do k = 1, km1
  do i = i1, i2
    a4(3,i,k) = a4(2,i,k+1)
  end do
end do
ppm2m_a4_12h(:,:,:,1) = a4(:,i1:i2,1:2)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm( dc(i1,k),a4(1,i1,k),it,0 )
end do
ppm2m_a4_13h(:,:,:,1) = a4(:,i1:i2,3:km-2)
if (kord .ge. 7) then
  do k = 2, km1
    do i = i1, i2
      h2(i,k) = dc(i,k+1)-dc(i,k-1)
    end do
  end do
  if (kord .eq. 7) then
    fac = 1.5
  else
    fac = 0.125
  endif
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm( dc(i1,k),a4(1,i1,k),it,2 )
    endif
  end do
else
  lmt = kord-3
  lmt = max(0,lmt)
  if (iv .eq. 0) then
    lmt = min(2,lmt)
  endif
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm( dc(i1,k),a4(1,i1,k),it,lmt )
  end do
endif
if ( .not. allocated(ppm2m_a4_14h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_14h)) then
    allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_14h(:,:,:,1) = a4(:,i1:i2,km1:km)

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
a4(:,i1:i2,km1:km) = ppm2m_a4_14h(:,:,:,1)
do k = km1, km
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,0 )
  do i = i1, i2
    a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
    a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
    a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
    a4_tad(4,i,k) = 0.d0
  end do
end do
a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
if (kord .ge. 7) then
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,2 )
    endif
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      lac_tad = 0.d0
      pmp_tad = 0.d0
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      qmp_tad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
      a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
      a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
      a4_tad(4,i,k) = 0.d0
      qmax_tad = qmax_tad+a4_tad(2,i,k)*(0.5-sign(0.5d0,qmax-max(a4(2,i,k),qmin)))
      qmin_tad = qmin_tad+a4_tad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5-sign(0.5d0,a4(2,i,k)-qmin))
      a4_tad(2,i,k) = a4_tad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5+sign(0.5d0,a4(2,i,k)-qmin))
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmax_tad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_tad = qmp_tad+qmax_tad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmin_tad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_tad = qmp_tad+qmin_tad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+lac_tad
      dc_tad(i,k) = dc_tad(i,k)-lac_tad
      h2_tad(i,k+1) = h2_tad(i,k+1)+lac_tad*fac
      lac_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmp_tad
      pmp_tad = pmp_tad-qmp_tad
      qmp_tad = 0.d0
      dc_tad(i,k) = dc_tad(i,k)+2*pmp_tad
      pmp_tad = 0.d0
    end do
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      lac_tad = 0.d0
      pmp_tad = 0.d0
      qmax_tad = 0.d0
      qmin_tad = 0.d0
      qmp_tad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      qmax_tad = qmax_tad+a4_tad(3,i,k)*(0.5-sign(0.5d0,qmax-max(a4(3,i,k),qmin)))
      qmin_tad = qmin_tad+a4_tad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5-sign(0.5d0,a4(3,i,k)-qmin))
      a4_tad(3,i,k) = a4_tad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5+sign(0.5d0,a4(3,i,k)-qmin))
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmax_tad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_tad = qmp_tad+qmax_tad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmin_tad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_tad = qmp_tad+qmin_tad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+lac_tad
      dc_tad(i,k) = dc_tad(i,k)+lac_tad
      h2_tad(i,k-1) = h2_tad(i,k-1)+lac_tad*fac
      lac_tad = 0.d0
      a4_tad(1,i,k) = a4_tad(1,i,k)+qmp_tad
      pmp_tad = pmp_tad+qmp_tad
      qmp_tad = 0.d0
      dc_tad(i,k) = dc_tad(i,k)+2*pmp_tad
      pmp_tad = 0.d0
    end do
  end do
  do k = 2, km1
    do i = i1, i2
      dc_tad(i,k-1) = dc_tad(i,k-1)-h2_tad(i,k)
      dc_tad(i,k+1) = dc_tad(i,k+1)+h2_tad(i,k)
      h2_tad(i,k) = 0.d0
    end do
  end do
else
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,lmt )
    if (kord .ne. 4) then
      do i = i1, i2
        a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
        a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
        a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
        a4_tad(4,i,k) = 0.d0
      end do
    endif
  end do
endif
a4(:,i1:i2,1:2) = ppm2m_a4_12h(:,:,:,1)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_tad( dc(i1,k),dc_tad(i1,k),a4(1,i1,k),a4_tad(1,i1,k),it,0 )
  do i = i1, i2
    a4_tad(3,i,k) = a4_tad(3,i,k)-3*a4_tad(4,i,k)
    a4_tad(2,i,k) = a4_tad(2,i,k)-3*a4_tad(4,i,k)
    a4_tad(1,i,k) = a4_tad(1,i,k)+6*a4_tad(4,i,k)
    a4_tad(4,i,k) = 0.d0
  end do
end do
do k = 1, km1
  do i = i1, i2
    a4_tad(2,i,k+1) = a4_tad(2,i,k+1)+a4_tad(3,i,k)
    a4_tad(3,i,k) = 0.d0
  end do
end do
a4(1,i1:i2,km) = ppm2m_a4_10h(:,1)
a4(3,i1:i2,km) = ppm2m_a4_11h(:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_tad(3,i,km) = a4_tad(3,i,km)*(0.5-sign(0.5d0,0._8-a4(3,i,km)))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4_tad(3,i,km) = 0.d0
    else
      a4_tad(1,i,km) = a4_tad(1,i,km)+a4_tad(3,i,km)*(0.5+sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*&
&sign(1.d0,a4(1,i,km))*sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
      a4_tad(3,i,km) = a4_tad(3,i,km)*(0.5-sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(3,i,km))&
&*sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
    endif
  end do
endif
a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
do i = i1, i2
  c1_tad = 0.d0
  c3_tad = 0.d0
  cmax_tad = 0.d0
  cmin_tad = 0.d0
  dq_tad = 0.d0
  qm_tad = 0.d0
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  cmax_tad = cmax_tad+a4_tad(2,i,km)*(0.5+sign(0.5d0,a4(2,i,km)-cmax))
  a4_tad(2,i,km) = a4_tad(2,i,km)*(0.5-sign(0.5d0,a4(2,i,km)-cmax))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmin_tad = cmin_tad+a4_tad(2,i,km)*(0.5+sign(0.5d0,cmin-a4(2,i,km)))
  a4_tad(2,i,km) = a4_tad(2,i,km)*(0.5-sign(0.5d0,cmin-a4(2,i,km)))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_tad(1,i,km) = a4_tad(1,i,km)+cmin_tad*(0.5+sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+cmin_tad*(0.5-sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  cmin_tad = 0.d0
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_tad(1,i,km) = a4_tad(1,i,km)+cmax_tad*(0.5+sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+cmax_tad*(0.5-sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  cmax_tad = 0.d0
  a4_tad(3,i,km) = a4_tad(3,i,km)+dc_tad(i,km)
  a4_tad(1,i,km) = a4_tad(1,i,km)-dc_tad(i,km)
  dc_tad(i,km) = 0.d0
  c1_tad = c1_tad+8*a4_tad(3,i,km)*d1*d1**2
  c3_tad = c3_tad-a4_tad(3,i,km)*d1
  a4_tad(2,i,km) = a4_tad(2,i,km)+a4_tad(3,i,km)
  a4_tad(3,i,km) = 0.d0
  c1_tad = c1_tad-a4_tad(2,i,km)*d1*d2*(d2+3.*d1)
  qm_tad = qm_tad+a4_tad(2,i,km)
  a4_tad(2,i,km) = 0.d0
  c1_tad = c1_tad-2*c3_tad*(d2*(5.*d1+d2)-3.*d1**2)
  dq_tad = dq_tad+c3_tad
  c3_tad = 0.d0
  a4_tad(2,i,km1) = a4_tad(2,i,km1)+c1_tad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  dq_tad = dq_tad-c1_tad*(d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_tad = qm_tad-c1_tad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c1_tad = 0.d0
  a4_tad(1,i,km) = a4_tad(1,i,km)+dq_tad*((-2)/(d1+d2))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+dq_tad*(2/(d1+d2))
  dq_tad = 0.d0
  a4_tad(1,i,km) = a4_tad(1,i,km)+qm_tad*(d2/(d1+d2))
  a4_tad(1,i,km1) = a4_tad(1,i,km1)+qm_tad*(d1/(d1+d2))
  qm_tad = 0.d0
end do
a4(1,i1:i2,1) = ppm2m_a4_5h(:,1)
a4(2,i1:i2,1:2) = ppm2m_a4_6h(:,:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(3,i,1)
    a4_tad(3,i,1) = 0.d0
    a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(2,i,1)
    a4_tad(2,i,1) = 0.d0
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(3,i,1)
      a4_tad(3,i,1) = 0.d0
      a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(2,i,1)
      a4_tad(2,i,1) = 0.d0
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4_tad(2,i,1) = 0.d0
      else
        a4_tad(1,i,1) = a4_tad(1,i,1)+a4_tad(2,i,1)*(0.5+sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,&
&a4(1,i,1))*sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
        a4_tad(2,i,1) = a4_tad(2,i,1)*(0.5-sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(2,i,1))*&
&sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
      endif
    end do
  endif
endif
a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
do i = i1, i2
  c1_tad = 0.d0
  c3_tad = 0.d0
  cmax_tad = 0.d0
  cmin_tad = 0.d0
  dq_tad = 0.d0
  qm_tad = 0.d0
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  cmax_tad = cmax_tad+a4_tad(2,i,2)*(0.5+sign(0.5d0,a4(2,i,2)-cmax))
  a4_tad(2,i,2) = a4_tad(2,i,2)*(0.5-sign(0.5d0,a4(2,i,2)-cmax))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmin_tad = cmin_tad+a4_tad(2,i,2)*(0.5+sign(0.5d0,cmin-a4(2,i,2)))
  a4_tad(2,i,2) = a4_tad(2,i,2)*(0.5-sign(0.5d0,cmin-a4(2,i,2)))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_tad(1,i,2) = a4_tad(1,i,2)+cmin_tad*(0.5-sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  a4_tad(1,i,1) = a4_tad(1,i,1)+cmin_tad*(0.5+sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  cmin_tad = 0.d0
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_tad(1,i,2) = a4_tad(1,i,2)+cmax_tad*(0.5-sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  a4_tad(1,i,1) = a4_tad(1,i,1)+cmax_tad*(0.5+sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  cmax_tad = 0.d0
  a4_tad(2,i,1) = a4_tad(2,i,1)-dc_tad(i,1)
  a4_tad(1,i,1) = a4_tad(1,i,1)+dc_tad(i,1)
  dc_tad(i,1) = 0.d0
  c1_tad = c1_tad+2*a4_tad(2,i,1)*d1*d1**2
  c3_tad = c3_tad-a4_tad(2,i,1)*d1
  a4_tad(2,i,2) = a4_tad(2,i,2)+a4_tad(2,i,1)
  a4_tad(2,i,1) = 0.d0
  c1_tad = c1_tad-0.25*a4_tad(2,i,2)*d1*d2*(d2+3.*d1)
  qm_tad = qm_tad+a4_tad(2,i,2)
  a4_tad(2,i,2) = 0.d0
  c1_tad = c1_tad-0.5*c3_tad*(d2*(5.*d1+d2)-3.*d1**2)
  dq_tad = dq_tad+c3_tad
  c3_tad = 0.d0
  a4_tad(2,i,3) = a4_tad(2,i,3)+c1_tad*(4/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  dq_tad = dq_tad-c1_tad*(4.*d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_tad = qm_tad+c1_tad*((-4)/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  c1_tad = 0.d0
  a4_tad(1,i,2) = a4_tad(1,i,2)+dq_tad*(2/(d1+d2))
  a4_tad(1,i,1) = a4_tad(1,i,1)+dq_tad*((-2)/(d1+d2))
  dq_tad = 0.d0
  a4_tad(1,i,2) = a4_tad(1,i,2)+qm_tad*(d1/(d1+d2))
  a4_tad(1,i,1) = a4_tad(1,i,1)+qm_tad*(d2/(d1+d2))
  qm_tad = 0.d0
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
  end do
end do
a4(1:2,i1:i2,:) = ppm2m_a4_2h(:,:,:,1)
call steepz_tad( i1,i2,km,a4,a4_tad,df2,df2_tad,dc,dc_tad,delq,delq_tad,delp,d4 )
do k = 3, km1
  c1_tad = 0.d0
  do i = i1, i2
    c1_tad = 0.d0
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    c1_tad = c1_tad+a4_tad(2,i,k)*(1+2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*(a1-a2))
    dc_tad(i,k-1) = dc_tad(i,k-1)+a4_tad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*a2
    dc_tad(i,k) = dc_tad(i,k)-a4_tad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k-1)*a1
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+a4_tad(2,i,k)
    a4_tad(2,i,k) = 0.d0
    delq_tad(i,k-1) = delq_tad(i,k-1)+c1_tad*(delp(i,k-1)/d4(i,k))
    c1_tad = 0.d0
  end do
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  c1_tad = 0.d0
  qmax_tad = 0.d0
  qmin_tad = 0.d0
  tmp_tad = 0.d0
  do i = i1, i2
    c1_tad = 0.d0
    qmax_tad = 0.d0
    qmin_tad = 0.d0
    tmp_tad = 0.d0
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    tmp_tad = tmp_tad+df2_tad(i,k)
    df2_tad(i,k) = 0.d0
    dci = min(abs(tmp),qmax)
    dcj_tad = dc_tad(i,k)*sign(1.d0,min(dci,qmin))*sign(1.d0,tmp)
    dci_tae = dcj_tad*(0.5+sign(0.5d0,qmin-dci))
    qmin_tad = qmin_tad+dcj_tad*(0.5-sign(0.5d0,qmin-dci))
    qmax_tad = qmax_tad+dci_tae*(0.5-sign(0.5d0,qmax-abs(tmp)))
    tmp_tad = tmp_tad+dci_tae*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
    dc_tad(i,k) = 0.d0
    qminj = min(a4(1,i,k-1),a4(1,i,k))
    a4_tad(1,i,k) = a4_tad(1,i,k)+qmin_tad
    qmink_tad = -qmin_tad
    a4_tad(1,i,k+1) = a4_tad(1,i,k+1)+qmink_tad*(0.5-sign(0.5d0,a4(1,i,k+1)-qminj))
    qminj_tad = qmink_tad*(0.5+sign(0.5d0,a4(1,i,k+1)-qminj))
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+qminj_tad*(0.5+sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    a4_tad(1,i,k) = a4_tad(1,i,k)+qminj_tad*(0.5-sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    qmin_tad = 0.d0
    qmaxj = max(a4(1,i,k-1),a4(1,i,k))
    a4_tad(1,i,k) = a4_tad(1,i,k)-qmax_tad
    a4_tad(1,i,k+1) = a4_tad(1,i,k+1)+qmax_tad*(0.5-sign(0.5d0,qmaxj-a4(1,i,k+1)))
    qmaxj_tad = qmax_tad*(0.5+sign(0.5d0,qmaxj-a4(1,i,k+1)))
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+qmaxj_tad*(0.5+sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    a4_tad(1,i,k) = a4_tad(1,i,k)+qmaxj_tad*(0.5-sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    qmax_tad = 0.d0
    c1_tad = c1_tad+tmp_tad*(delp(i,k)*delq(i,k)/(d4(i,k)+delp(i,k+1)))
    delq_tad(i,k-1) = delq_tad(i,k-1)+tmp_tad*(delp(i,k)*c2/(d4(i,k)+delp(i,k+1)))
    delq_tad(i,k) = delq_tad(i,k)+tmp_tad*(delp(i,k)*c1/(d4(i,k)+delp(i,k+1)))
    tmp_tad = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)-delq_tad(i,k-1)
    a4_tad(1,i,k) = a4_tad(1,i,k)+delq_tad(i,k-1)
    delq_tad(i,k-1) = 0.d0
  end do
end do

!----------------------------------------------
! CLOSE TAPE ppm2m
!----------------------------------------------
if (allocated(ppm2m_a4_7h)) then
  deallocate( ppm2m_a4_7h )
endif
if (allocated(ppm2m_a4_8h)) then
  deallocate( ppm2m_a4_8h )
endif
if (allocated(ppm2m_a4_14h)) then
  deallocate( ppm2m_a4_14h )
endif


end subroutine ppm2m_tad


subroutine steepz_tad( i1, i2, km, a4, a4_tad, df2, df2_tad, dm, dm_tad, dq, dq_tad, dp, d4 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_tad(4,i1:i2,km)
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_tad(i1:i2,km)
real(kind=r8) :: dm(i1:i2,km)
real(kind=r8) :: dm_tad(i1:i2,km)
real(kind=r8) :: dp(i1:i2,km)
real(kind=r8) :: dq(i1:i2,km)
real(kind=r8) :: dq_tad(i1:i2,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alfa(i1:i2,km)
real(kind=r8) :: alfa_tad(i1:i2,km)
real(kind=r8) :: dg2
real(kind=r8) :: dg2_tad
real(kind=r8) :: f(i1:i2,km)
real(kind=r8) :: f_tad(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: rat(i1:i2,km)
real(kind=r8) :: rat_tad(i1:i2,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alfa_tad(:,:) = 0.d0
dg2_tad = 0.d0
f_tad(:,:) = 0.d0
rat_tad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    rat(i,k) = dq(i,k-1)/d4(i,k)
  end do
end do
do k = 2, km-1
  do i = i1, i2
    f(i,k) = (rat(i,k+1)-rat(i,k))/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
  end do
end do
do k = 3, km-2
  do i = i1, i2
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      alfa(i,k) = max(0._8,min(0.5_8,-(0.1875*dg2/df2(i,k))))
    else
      alfa(i,k) = 0.
    endif
  end do
end do
do k = 4, km-2
  do i = i1, i2
    alfa_tad(i,k-1) = alfa_tad(i,k-1)+a4_tad(2,i,k)*((-a4(2,i,k))+a4(1,i,k)-dm(i,k))
    alfa_tad(i,k) = alfa_tad(i,k)+a4_tad(2,i,k)*((-a4(2,i,k))+a4(1,i,k-1)+dm(i,k-1))
    dm_tad(i,k-1) = dm_tad(i,k-1)+a4_tad(2,i,k)*alfa(i,k)
    dm_tad(i,k) = dm_tad(i,k)-a4_tad(2,i,k)*alfa(i,k-1)
    a4_tad(1,i,k-1) = a4_tad(1,i,k-1)+a4_tad(2,i,k)*alfa(i,k)
    a4_tad(1,i,k) = a4_tad(1,i,k)+a4_tad(2,i,k)*alfa(i,k-1)
    a4_tad(2,i,k) = a4_tad(2,i,k)*(1.-alfa(i,k-1)-alfa(i,k))
  end do
end do
do k = 3, km-2
  dg2_tad = 0.d0
  do i = i1, i2
    dg2_tad = 0.d0
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      df2_tad(i,k) = df2_tad(i,k)+alfa_tad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*&
&dg2/df2(i,k)))-0.5_8))*(0.1875*dg2/(df2(i,k)*df2(i,k)))
      dg2_tad = dg2_tad-alfa_tad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*dg2/df2(i,&
&k)))-0.5_8))*(0.1875/df2(i,k))
      alfa_tad(i,k) = 0.d0
      f_tad(i,k-1) = f_tad(i,k-1)-dg2_tad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      f_tad(i,k+1) = f_tad(i,k+1)+dg2_tad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      dg2_tad = 0.d0
    else
      alfa_tad(i,k) = 0.d0
    endif
  end do
end do
do k = 2, km-1
  do i = i1, i2
    rat_tad(i,k+1) = rat_tad(i,k+1)+f_tad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    rat_tad(i,k) = rat_tad(i,k)-f_tad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    f_tad(i,k) = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    dq_tad(i,k-1) = dq_tad(i,k-1)+rat_tad(i,k)/d4(i,k)
    rat_tad(i,k) = 0.d0
  end do
end do

end subroutine steepz_tad


subroutine te_map_tad( ps, pe, im, jm, km, nx, jfirst, jlast, nq, u, v, q, q_tae, hs, kord, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use te_map_tad_store, only : te_map_tape_dz_8h,te_map_tape_te_9h,te_map_tape_te_map,te_map_tape_u_6h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: km
integer :: kord
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: q_tae(im,jfirst-ng_d:jlast+ng_d,km,nq)
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dz(im,jfirst:jlast,km)
integer :: help_h
integer :: help_i
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: te(im,jfirst:jlast,km)

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
u = te_map_tape_u_6h(:,:,:,te_map_tape_rec+1)
v = te_map_tape_v_7h(:,:,:,te_map_tape_rec+1)
dz = te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1)
te = te_map_tape_te_9h(:,:,:,te_map_tape_rec+1)
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do shared(ak,bk,dz,hs,im,it,jfirst,jlast,jm,jp,km,kord,ks,ng_d,ng_s,nq,nx,pe,ps,q,q_tae,te,u,v) private(help_h,&
!$omp& help_i,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
    endif
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    help_i = -1
    call map1_ppm_tad( km,pe0,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_i,kord )
  endif
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
  end do
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
    endif
    help_h = -1
    call map1_ppm_tad( km,pe0,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_h,kord )
  endif
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm_tad( km,pe1,q,q_tae,nq,km,pe2,q_tae,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  call map1_ppm_tad( km,pe1,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
end do

end subroutine te_map_tad


subroutine te_mapmd( consv, convt, ps, omga, pe, delp, pkz, pk, mdt, im, jm, km, nx, jfirst, jlast, nq, u, v, pt, q, hs, cp, akap, &
&kord, peln, te0, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use te_map_tad_store, only : te_map_tape_dz_8h,te_map_tape_te_9h,te_map_tape_te_map,te_map_tape_u_6h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: mdt
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: omga(im,km,jfirst:jlast)
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: dak
real(kind=r8) :: dlnp
real(kind=r8) :: dtmp
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
integer :: help_h
integer :: help_i
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te_np
real(kind=r8) :: te_sp
real(kind=r8) :: tsum
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: u2(im,jfirst:jlast+1)
real(kind=r8) :: v2(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: ysum

!**********************************************
! executable statements of routine
!**********************************************
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .false.  )
if ( .not. allocated(te_map_tape_u_6h)) then
  allocate( te_map_tape_u_6h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,te_map_tape_te_map) )
endif
te_map_tape_u_6h(:,:,:,te_map_tape_rec+1) = u
if ( .not. allocated(te_map_tape_v_7h)) then
  allocate( te_map_tape_v_7h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,te_map_tape_te_map) )
endif
te_map_tape_v_7h(:,:,:,te_map_tape_rec+1) = v
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,t2,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = 0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))+t2(i,j)*pkz(i,j,k)
    end do
    te(im,j,k) = 0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))+t2(im,j)*pkz(im,j,k)
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = 0.5*te_sp/float(im)+t2(1,1)*pkz(1,1,k)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = 0.5*te_np/float(im)+t2(1,jm)*pkz(1,jm,k)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
  do j = jfirst, jlast
    do i = 1, im
      dz(i,j,k) = t2(i,j)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do
if ( .not. allocated(te_map_tape_dz_8h)) then
  allocate( te_map_tape_dz_8h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1) = dz
if ( .not. allocated(te_map_tape_te_9h)) then
  allocate( te_map_tape_te_9h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_9h(:,:,:,te_map_tape_rec+1) = te
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do private(bkh,dak,help_h,help_i,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,pe2w,pe3,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    ps(i,j) = pe1(i,km+1)
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      dak = ak(k+1)-ak(k)
      do i = i1, i2
        delp(i,j,k) = dak
      end do
    end do
  endif
  do k = ks+1, km
    do i = i1, i2
      delp(i,j,k) = pe2(i,k+1)-pe2(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  call map1_ppm( km,pe1,te,km,pe2,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm( km,pe1,q,nq,km,pe2,q,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    endif
    help_h = -1
    call map1_ppm( km,pe0,u,km,pe3,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_h,kord )
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_i = -1
    call map1_ppm( km,pe0,v,km,pe3,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_i,kord )
  endif
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .true.  )
if (consv) then
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,xsum,ysum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = te_acap*cp*(ps(1,1)-2.*te_ptop-akap*te_ptop*(peln(1,km+1,1)-peln(1,1,1)))
    else if (j .eq. jm) then
      tte(jm) = te_acap*cp*(ps(1,jm)-akap*te_ptop*(peln(1,km+1,jm)-peln(1,1,jm)))
    else
      xsum = 0.
      ysum = 0.
      do i = 1, im
        xsum = xsum+ps(i,j)
        ysum = ysum+peln(i,km+1,j)
      end do
      tte(j) = cp*te_cosp(j)*(xsum-te_ptop*im-akap*te_ptop*(ysum-peln(1,1,j)*im))
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,tsum )
  dtmp = (te0-te1)/tsum
else
  dtmp = 0.
endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = te(i,j,k)-0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))
    end do
    te(im,j,k) = te(im,j,k)-0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = te(1,1,k)-0.5*te_sp/float(im)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = te(1,jm,k)-0.5*te_np/float(im)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
end do
#ifdef USE_OPENMP
!$omp parallel do private(dlnp,gz,i,i1,i2,ixj,j,k,rg,tvm) ! broadcast()
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)/pkz(i,j,k)
      end do
    endif
  end do
end do
end subroutine te_mapmd


end module     mapz_module_tad


#endif /* SPMD */
