#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     cd_core_do_tad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
integer :: cd_core_tape_cd_core_do
real(kind=8), allocatable :: cd_core_tape_delpf_3h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_pt_16h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_pt_5h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_u_12h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_u_1h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_uc_14h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_v_13h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_v_2h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_vc_15h(:,:,:,:)

end module     cd_core_do_tad_store


module     cd_core_tad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use cd_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine cd_core_do_tad( im, jm, km, jfirst, jlast, u, v, pt, ns, rcap, iord_c, jord_c, iord_d, jord_d, ng_c, ng_d, ng_s, ipe, &
&cosp, cose, acosp, sinlon, coslon, cosl5, sinl5, delpf, uc, vc )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use sw_core_tad
use tp_core
use tp_core_tad
use timingmodule
use mod_comm, only : gid,gsize,mp_barrier, mp_recv2_ns, mp_recv2_ns_ad, mp_recv2_s, mp_recv2_s_ad, mp_recv3d_ns, mp_recv3d_ns2, &
&mp_recv3d_ns_ad, mp_recv_n, mp_recv_n_ad, mp_send2_n, mp_send2_n_ad, mp_send2_ns, mp_send2_ns_ad, mp_send3d_ns, mp_send3d_ns2, &
&mp_send3d_ns_ad, mp_send_s, mp_send_s_ad
use cd_core_do_tad_store, only : cd_core_tape_cd_core_do,cd_core_tape_delpf_3h,cd_core_tape_pt_16h,cd_core_tape_pt_5h,&
&cd_core_tape_u_12h,cd_core_tape_u_1h,cd_core_tape_uc_14h,cd_core_tape_v_13h,cd_core_tape_v_2h,cd_core_tape_vc_15h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cose(jm)
integer :: im
real(kind=r8) :: cosl5(im)
real(kind=r8) :: coslon(im)
real(kind=r8) :: cosp(jm)
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
real(kind=r8) :: delpf(im,jfirst-ng_d:jlast+ng_d,km)
integer :: iord_c
integer :: iord_d
integer :: ipe
integer :: jord_c
integer :: jord_d
integer :: ng_c
integer :: ng_s
integer :: ns
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: rcap
real(kind=r8) :: sinl5(im)
real(kind=r8) :: sinlon(im)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uc(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: vc(im,jfirst-2:jlast+2,km)

!==============================================
! declare local variables
!==============================================
integer :: c_sw_tape_rec
integer :: d_sw_tape_rec
real(kind=r8) :: delpfh_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: delpfi_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: delpfj_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: delpfk_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
integer :: help_i
integer :: help_k
integer :: help_m
integer :: help_o
integer :: iord
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: jord
integer :: js2g0
integer :: js2gc
integer :: k
real(kind=r8) :: pkch_tad(im,2+1+jlast-jfirst,1+km)
real(kind=r8) :: pkci_tad(im,2+1+jlast-jfirst,1+km)
real(kind=r8) :: pkcj_tad(im,2+1+jlast-jfirst,1+km)
real(kind=r8) :: pkck_tad(im,2+1+jlast-jfirst,1+km)
real(kind=r8) :: pth_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: pti_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: ptj_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: ptl_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: uch_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: uci_tad(im,1+jlast+ng_d-(jfirst-ng_d),km)
real(kind=r8) :: uh_tad(im,1+jlast+ng_s-(jfirst-ng_d),km)
real(kind=r8) :: ui_tad(im,1+jlast+ng_s-(jfirst-ng_d),km)
real(kind=r8) :: vch_tad(im,3+2+jlast-jfirst,km)
real(kind=r8) :: vci_tad(im,3+2+jlast-jfirst,km)
real(kind=r8) :: vh_tad(im,1+jlast+ng_d-(jfirst-ng_s),km)
real(kind=r8) :: vi_tad(im,1+jlast+ng_d-(jfirst-ng_s),km)
real(kind=r8) :: wzh_tad(im,2+1+jlast-jfirst,1+km)
real(kind=r8) :: wzi_tad(im,2+1+jlast-jfirst,1+km)
real(kind=r8) :: wzj_tad(im,2+1+jlast-jfirst,1+km)
real(kind=r8) :: wzk_tad(im,2+1+jlast-jfirst,1+km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
delpfh_tad(:,:,:) = 0.d0
delpfi_tad(:,:,:) = 0.d0
delpfj_tad(:,:,:) = 0.d0
delpfk_tad(:,:,:) = 0.d0
pkch_tad(:,:,:) = 0.d0
pkci_tad(:,:,:) = 0.d0
pkcj_tad(:,:,:) = 0.d0
pkck_tad(:,:,:) = 0.d0
pth_tad(:,:,:) = 0.d0
pti_tad(:,:,:) = 0.d0
ptj_tad(:,:,:) = 0.d0
ptl_tad(:,:,:) = 0.d0
uch_tad(:,:,:) = 0.d0
uci_tad(:,:,:) = 0.d0
uh_tad(:,:,:) = 0.d0
ui_tad(:,:,:) = 0.d0
vch_tad(:,:,:) = 0.d0
vci_tad(:,:,:) = 0.d0
vh_tad(:,:,:) = 0.d0
vi_tad(:,:,:) = 0.d0
wzh_tad(:,:,:) = 0.d0
wzi_tad(:,:,:) = 0.d0
wzj_tad(:,:,:) = 0.d0
wzk_tad(:,:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
help_i = km+1
help_k = km+1
u = cd_core_tape_u_12h(:,:,:,cd_core_tape_rec+1)
v = cd_core_tape_v_13h(:,:,:,cd_core_tape_rec+1)
uc = cd_core_tape_uc_14h(:,:,:,cd_core_tape_rec+1)
vc = cd_core_tape_vc_15h(:,:,:,cd_core_tape_rec+1)
pt = cd_core_tape_pt_16h(:,:,:,cd_core_tape_rec+1)
help_m = km+1
help_o = km+1
if (ipe .ne. 1) then
  call adtiming_off( 'Recv_pt&delpf' )
  call mp_recv3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpfh_tad,2 )
  call mp_recv3d_ns_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pth_tad,1 )
  call adtiming_on( 'Recv_pt&delpf' )
endif
call adtiming_off( 'D-6000' )
call adtiming_on( 'D-6000' )
call adtiming_off( 'D-4500' )
call adtiming_on( 'D-4500' )
if (ipe .ne. 1) then
  call adtiming_off( 'Send_pt&delpf' )
  call mp_send3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpfi_tad,2 )
  call mp_send3d_ns_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pti_tad,1 )
  call adtiming_on( 'Send_pt&delpf' )
endif
call adtiming_off( 'Recv_pkc_wz' )
call mp_recv2_ns_ad( im,jm,jfirst,jlast,1,help_o,1,pkch_tad,wzh_tad )
call adtiming_on( 'Recv_pkc_wz' )
call adtiming_off( 'Send_pkc_wz' )
call mp_send2_ns_ad( im,jm,jfirst,jlast,1,help_m,1,pkci_tad,wzi_tad )
call adtiming_on( 'Send_pkc_wz' )
call adtiming_off( 'D_GEOP' )
call adtiming_on( 'D_GEOP' )
call adtiming_off( 'D_CORE' )
#ifdef USE_OPENMP
!$omp parallel do shared(acosp,cd_core_tape_rec,cose,cosl5,coslon,cosp,delpf,dtdx,dtdy,dtdy5,dtxe5,im,iord_d,jfirst,jlast,jm,jn1g1,&
!$omp& jord_d,js2g0,km,ng_d,ng_s,pt,rcap,sinl5,sinlon,u,uc,v,vc,zt_d) private(d_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    if (k .eq. 1) then
      iord = 1
      jord = 1
    else
      iord = min(2,iord_d)
      jord = min(2,jord_d)
    endif
  else
    iord = iord_d
    jord = jord_d
  endif
  d_sw_tape_rec = k-1+cd_core_tape_rec*km
  call d_sw_tad( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),pt(1,jfirst-ng_d,k),delpf(1,jfirst-&
&ng_d,k),dtdx,dtxe5,js2g0,jn1g1,im,jm,jfirst,jlast,ng_d,ng_s,iord,jord,zt_d,rcap,tiny,dtdy,dtdy5,cosp,acosp,cose,coslon,sinlon,&
&cosl5,sinl5,d_sw_tape_rec )
end do
call adtiming_on( 'D_CORE' )
call adtiming_off( 'Ghost_vc' )
call mp_recv_n_ad( im,jm,jfirst,jlast,1,km,2,2,vch_tad )
call mp_send_s_ad( im,jm,jfirst,jlast,1,km,2,2,vci_tad )
call adtiming_on( 'Ghost_vc' )
call adtiming_off( 'Recv_uc' )
call mp_recv3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uch_tad,2 )
call adtiming_on( 'Recv_uc' )
call adtiming_off( 'C_V_LOOP' )
call adtiming_on( 'C_V_LOOP' )
call adtiming_off( 'Send_uc' )
call mp_send3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uci_tad,2 )
call adtiming_on( 'Send_uc' )
call adtiming_off( 'Recv_pkc_wz' )
call mp_recv2_s_ad( im,jm,jfirst,jlast,1,help_k,1,1,pkcj_tad,wzj_tad )
call adtiming_on( 'Recv_pkc_wz' )
call adtiming_off( 'C_U_LOOP' )
call adtiming_on( 'C_U_LOOP' )
call adtiming_off( 'Send_pkc_wz' )
call mp_send2_n_ad( im,jm,jfirst,jlast,1,help_i,1,1,pkck_tad,wzk_tad )
call adtiming_on( 'Send_pkc_wz' )
call adtiming_off( 'C_GEOP' )
call adtiming_on( 'C_GEOP' )
call adtiming_off( 'C_CORE' )
u = cd_core_tape_u_1h(:,:,:,cd_core_tape_rec+1)
v = cd_core_tape_v_2h(:,:,:,cd_core_tape_rec+1)
delpf = cd_core_tape_delpf_3h(:,:,:,cd_core_tape_rec+1)
pt = cd_core_tape_pt_5h(:,:,:,cd_core_tape_rec+1)
#ifdef USE_OPENMP
!$omp parallel do shared(acosp,cd_core_tape_rec,cose,cosl5,coslon,cosp,delpf,dtdx2,dtdx4,dtdy5,im,iord_c,jfirst,jlast,jm,jn1gc,&
!$omp& jn2g0,jord_c,js2g0,js2gc,km,ng_c,ng_d,ng_s,pt,rcap,sinl5,sinlon,u,uc,v,vc,zt_c) private(c_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    iord = 1
    jord = 1
  else
    iord = iord_c
    jord = jord_c
  endif
  c_sw_tape_rec = k-1+cd_core_tape_rec*km
  call c_sw_tad( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),pt(1,jfirst-ng_d,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),delpf(1,jfirst-&
&ng_d,k),cosp,acosp,cose,coslon,sinlon,dtdx2,dtdx4,dtdy5,zt_c,tiny,rcap,im,jm,jfirst,jlast,ng_c,ng_d,ng_s,js2g0,jn2g0,js2gc,&
&jn1gc,iord,jord,cosl5,sinl5,c_sw_tape_rec )
end do
call adtiming_on( 'C_CORE' )
if (ipe .eq. (-1) .or. ns .eq. 1) then
  call adtiming_off( 'Ghost_pt&delpf' )
  call mp_recv3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpfj_tad,2 )
  call mp_recv3d_ns_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,ptj_tad,1 )
  call mp_send3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpfk_tad,2 )
  call mp_send3d_ns_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_d,ptl_tad,1 )
  call adtiming_on( 'Ghost_pt&delpf' )
endif
call adtiming_off( 'Recv_uv' )
call mp_recv3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_s,ng_d,vh_tad,2 )
call mp_recv3d_ns_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,uh_tad,1 )
call adtiming_on( 'Recv_uv' )
call adtiming_off( 'Send_uv' )
call mp_send3d_ns2_ad( im,jm,jfirst,jlast,1,km,ng_s,ng_d,vi_tad,2 )
call mp_send3d_ns_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,ui_tad,1 )
call adtiming_on( 'Send_uv' )

end subroutine cd_core_do_tad


subroutine cd_core_domd( im, jm, km, nq, nx, jfirst, jlast, u, v, pt, delp, pe, pk, ns, dt, ptop, umax, fill, filter, acap, ae, &
&rcap, cp, akap, iord_c, jord_c, iord_d, jord_d, ng_c, ng_d, ng_s, ipe, om, hs, sinp, cosp, cose, acosp, sinlon, coslon, cosl5, &
&sinl5, cx3, cy3, mfx, mfy, delpf, uc, vc, ptc, dpt, ptk, wz3, pkc, wz )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use tp_core
use timingmodule
use mod_comm, only : gid,gsize,mp_barrier, mp_recv2_ns, mp_recv2_s, mp_recv3d_ns, mp_recv3d_ns2, mp_recv_n, mp_send2_n, &
&mp_send2_ns, mp_send3d_ns, mp_send3d_ns2, mp_send_s
use sw_core_tad, only : c_swmd, d_swmd
use cd_core_do_tad_store, only : cd_core_tape_cd_core_do,cd_core_tape_delpf_3h,cd_core_tape_pt_16h,cd_core_tape_pt_5h,&
&cd_core_tape_u_12h,cd_core_tape_u_1h,cd_core_tape_uc_14h,cd_core_tape_v_13h,cd_core_tape_v_2h,cd_core_tape_vc_15h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: ae
real(kind=r8) :: akap
real(kind=r8) :: cose(jm)
integer :: im
real(kind=r8) :: cosl5(im)
real(kind=r8) :: coslon(im)
real(kind=r8) :: cosp(jm)
real(kind=r8) :: cp
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
real(kind=r8) :: cx3(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: cy3(im,jfirst:jlast+1,km)
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delpf(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: dpt(im,jfirst-1:jlast+1,km)
real(kind=r8) :: dt
logical :: fill
logical :: filter
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: iord_c
integer :: iord_d
integer :: ipe
integer :: jord_c
integer :: jord_d
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
integer :: ng_c
integer :: ng_s
integer :: nq
integer :: ns
integer :: nx
real(kind=r8) :: om
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkc(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: ptc(im,jfirst:jlast,km)
real(kind=r8) :: ptk(im,jfirst:jlast,km)
real(kind=r8) :: ptop
real(kind=r8) :: rcap
real(kind=r8) :: sinl5(im)
real(kind=r8) :: sinlon(im)
real(kind=r8) :: sinp(jm)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uc(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: umax
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: vc(im,jfirst-2:jlast+2,km)
real(kind=r8) :: wz(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: wz3(im,jfirst-1:jlast,km+1)

!==============================================
! declare local variables
!==============================================
integer :: c_sw_tape_rec
integer :: d_sw_tape_rec
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: help_l
integer :: help_m
integer :: help_n
integer :: help_o
integer :: help_p
integer :: help_q
integer :: i
integer :: iord
integer :: j
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: jord
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: js2gc
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: pk4
real(kind=r8) :: pkchelp(im,jfirst-1:jlast+1)
real(kind=r8) :: wk(im,jfirst:jlast+2)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk2(im,jfirst:jlast+1)
real(kind=r8) :: wk3(im,jfirst-1:jlast+1)

!**********************************************
! executable statements of routine
!**********************************************
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
wz3 = 0.
uc = 0.
vc = 0.
call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u,1 )
call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_s,ng_d,v,2 )
if (ipe .eq. (-1) .or. ns .eq. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_h,i,j,k,wk,wk2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_h = jn2g0-js2g0+1
    call pft2d( delpf(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,wk,wk2 )
  end do
endif
call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u,1 )
call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_s,ng_d,v,2 )
if (ipe .eq. (-1) .or. ns .eq. 1) then
  call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
  call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
endif
if ( .not. allocated(cd_core_tape_u_1h)) then
  allocate( cd_core_tape_u_1h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_u_1h(:,:,:,cd_core_tape_rec+1) = u
if ( .not. allocated(cd_core_tape_v_2h)) then
  allocate( cd_core_tape_v_2h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_v_2h(:,:,:,cd_core_tape_rec+1) = v
if ( .not. allocated(cd_core_tape_delpf_3h)) then
  allocate( cd_core_tape_delpf_3h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_delpf_3h(:,:,:,cd_core_tape_rec+1) = delpf
if ( .not. allocated(cd_core_tape_pt_5h)) then
  allocate( cd_core_tape_pt_5h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_pt_5h(:,:,:,cd_core_tape_rec+1) = pt
#ifdef USE_OPENMP
!$omp parallel do private(c_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    iord = 1
    jord = 1
  else
    iord = iord_c
    jord = jord_c
  endif
  c_sw_tape_rec = k-1+cd_core_tape_rec*km
  call c_swmd( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),pt(1,jfirst-ng_d,k),delp(1,jfirst,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),&
&ptc(1,jfirst,k),delpf(1,jfirst-ng_d,k),ptk(1:im,jfirst:jlast,k),cosp,acosp,cose,coslon,sinlon,dxdt,dxe,dtdx2,dtdx4,dtxe5,rdxe,&
&dycp,dydt,dtdy5,cye,fc,ifax,trigs,dc(1,js2g0),sc,zt_c,tiny,rcap,im,jm,jfirst,jlast,ng_c,ng_d,ng_s,js2g0,jn2g0,js2gc,jn1gc,iord,&
&jord,cosl5,sinl5,c_sw_tape_rec )
end do
call geopk( ptop,pe,ptk,pkc,wz,hs,ptc,im,jm,km,jfirst,jlast,0,cp,akap,nx,0, .false.  )
help_i = km+1
call mp_send2_n( im,jm,jfirst,jlast,1,help_i,1,1,pkc,wz )
#ifdef USE_OPENMP
!$omp parallel do private(help_j,i,j,k,p1d,wk,wk2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, jn2g0
    do i = 1, im
      p1d(i) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
    uc(1,j,k) = uc(1,j,k)+dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,k+1)-&
&pkc(1,j,k)))/(p1d(1)+p1d(im))
    do i = 2, im
      uc(i,j,k) = uc(i,j,k)+dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*(pkc(i-1,j,k+&
&1)-pkc(i,j,k)))/(p1d(i)+p1d(i-1))
    end do
  end do
  help_j = jn2g0-js2g0+1
  call pft2d( uc(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_j,ifax,trigs,wk,wk2 )
end do
help_k = km+1
call mp_recv2_s( im,jm,jfirst,jlast,1,help_k,1,1,pkc,wz )
call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uc,2 )
#ifdef USE_OPENMP
!$omp parallel do private(help_l,i,j,k,wk,wk1)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jlast
    do i = 1, im
      wk1(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      vc(i,j,k) = vc(i,j,k)+dtdy5/(wk1(i,j)+wk1(i,j-1))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-wz(i,j,&
&k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))
    end do
  end do
  help_l = jlast-js2g0+1
  call pft2d( vc(1,js2g0,k),se(js2g0),de(1,js2g0),im,help_l,ifax,trigs,wk,wk1 )
end do
call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,uc,2 )
call mp_send_s( im,jm,jfirst,jlast,1,km,2,2,vc )
call mp_recv_n( im,jm,jfirst,jlast,1,km,2,2,vc )
if ( .not. allocated(cd_core_tape_u_12h)) then
  allocate( cd_core_tape_u_12h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_u_12h(:,:,:,cd_core_tape_rec+1) = u
if ( .not. allocated(cd_core_tape_v_13h)) then
  allocate( cd_core_tape_v_13h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_v_13h(:,:,:,cd_core_tape_rec+1) = v
if ( .not. allocated(cd_core_tape_uc_14h)) then
  allocate( cd_core_tape_uc_14h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_uc_14h(:,:,:,cd_core_tape_rec+1) = uc
if ( .not. allocated(cd_core_tape_vc_15h)) then
  allocate( cd_core_tape_vc_15h(1:im,1:3+2+jlast-jfirst,1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_vc_15h(:,:,:,cd_core_tape_rec+1) = vc
if ( .not. allocated(cd_core_tape_pt_16h)) then
  allocate( cd_core_tape_pt_16h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_pt_16h(:,:,:,cd_core_tape_rec+1) = pt
#ifdef USE_OPENMP
!$omp parallel do private(d_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    if (k .eq. 1) then
      iord = 1
      jord = 1
    else
      iord = min(2,iord_d)
      jord = min(2,jord_d)
    endif
  else
    iord = iord_d
    jord = jord_d
  endif
  d_sw_tape_rec = k-1+cd_core_tape_rec*km
  call d_swmd( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),pt(1,jfirst-ng_d,k),delp(1,jfirst,k),&
&delpf(1,jfirst-ng_d,k),cx3(1,jfirst-ng_d,k),cy3(1,jfirst,k),mfx(1,jfirst,k),mfy(1,jfirst,k),cdx(js2g0,k),cdy(js2g0,k),dtdx,&
&dtdxe,dtxe5,txe5,dyce,rdx,cyy,dx,f0(jfirst-ng_d),js2g0,jn1g1,im,jm,jfirst,jlast,ng_d,ng_s,nq,iord,jord,zt_d,rcap,tiny,dtdy,&
&dtdy5,tdy5,rdy,cosp,acosp,cose,coslon,sinlon,cosl5,sinl5,d_sw_tape_rec )
end do
call geopk( ptop,pe,delp,pkc,wz,hs,pt,im,jm,km,jfirst,jlast,ng_d,cp,akap,nx,ipe, .true.  )
help_m = km+1
call mp_send2_ns( im,jm,jfirst,jlast,1,help_m,1,pkc,wz )
if (ipe .ne. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_n,i,j,k,wk,wk2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_n = jn2g0-js2g0+1
    call pft2d( delpf(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_n,ifax,trigs,wk,wk2 )
  end do
else
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km+1
    do j = jfirst, jlast
      do i = 1, im
        pk(i,j,k) = pkc(i,j,k)
      end do
    end do
  end do
endif
help_o = km+1
call mp_recv2_ns( im,jm,jfirst,jlast,1,help_o,1,pkc,wz )
if (ipe .ne. 1) then
  call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_send3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jn1g1
    do i = 1, im
      dpt(i,j,k) = (wz(i,j,k+1)+wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j,k))
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,pkchelp,wk1,wk3)
#endif /* ! USE_OPENMP */
do k = 2, km+1
  do j = js2g1, jn2g0
    wk3(1,j) = (wz(1,j,k)+wz(im,j,k))*(pkc(1,j,k)-pkc(im,j,k))
    do i = 2, im
      wk3(i,j) = (wz(i,j,k)+wz(i-1,j,k))*(pkc(i,j,k)-pkc(i-1,j,k))
    end do
  end do
  do j = js2g1, jn2g0
    do i = 1, im-1
      wk1(i,j) = wk3(i,j)+wk3(i+1,j)
    end do
    wk1(im,j) = wk3(im,j)+wk3(1,j)
  end do
  if (jfirst .eq. 1) then
    do i = 1, im
      wk1(i,1) = 0.
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im
      wk1(i,jm) = 0.
    end do
  endif
  do j = js2g0, jlast
    do i = 1, im
      wz3(i,j,k) = wk1(i,j)+wk1(i,j-1)
    end do
  end do
  do j = js2g0, jn1g1
    do i = 1, im
      wk1(i,j) = (wz(i,j,k)+wz(i,j-1,k))*(pkc(i,j,k)-pkc(i,j-1,k))
    end do
  end do
  do j = js2g0, jn1g1
    wk3(1,j) = wk1(1,j)+wk1(im,j)
    do i = 2, im
      wk3(i,j) = wk1(i,j)+wk1(i-1,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wz(i,j,k) = wk3(i,j)+wk3(i,j+1)
    end do
  end do
  do j = jfirst-1, jlast+1
    do i = 1, im
      pkchelp(i,j) = pkc(i,j,k)
    end do
  end do
  call avgc( pkchelp,pkc(1,jfirst,k),im,jm,jfirst,jlast,wk1 )
end do
do j = js2g0, jlast
  do i = 1, im
    wz3(i,j,1) = 0.
    wz(i,j,1) = 0.
  end do
end do
pk4 = 4.*ptop**akap
do j = js2g0, jn1g1
  do i = 1, im
    pkc(i,j,1) = pk4
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(help_p,help_q,i,j,k,wk,wk1,wk2,wk3)
#endif /* ! USE_OPENMP */
do k = 1, km
  call avgc( dpt(1,jfirst-1,k),wk2(1,jfirst),im,jm,jfirst,jlast,wk1 )
  do j = js2g0, jn1g1
    do i = 1, im
      wk(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im-1
      wk3(i,j) = uc(i,j,k)+dtdxe(j)/(wk(i,j)+wk(i+1,j))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-wz3(i,j,k))
    end do
    wk3(im,j) = uc(im,j,k)+dtdxe(j)/(wk(im,j)+wk(1,j))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-wz3(im,j,k))
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wk1(i,j) = vc(i,j,k)+dtdy/(wk(i,j)+wk(i,j+1))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,j,k))
    end do
  end do
  help_p = jlast-js2g0+1
  call pft2d( wk3(1,js2g0),se(js2g0),de(1,js2g0),im,help_p,ifax,trigs,wk,wk2 )
  help_q = jn2g0-js2g0+1
  call pft2d( wk1(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_q,ifax,trigs,wk,wk2 )
  do j = js2g0, jlast
    do i = 1, im
      u(i,j,k) = u(i,j,k)+wk3(i,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v(i,j,k) = v(i,j,k)+wk1(i,j)
    end do
  end do
end do
if (ipe .ne. 1) then
  call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng_d,ng_d,pt,1 )
  call mp_recv3d_ns2( im,jm,jfirst,jlast,1,km,ng_d,ng_d,delpf,2 )
endif
end subroutine cd_core_domd


end module     cd_core_tad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     cd_core_do_tad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
integer :: cd_core_tape_cd_core_do
real(kind=8), allocatable :: cd_core_tape_delpf_3h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_pt_16h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_pt_5h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_u_12h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_u_1h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_uc_14h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_v_13h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_v_2h(:,:,:,:)
real(kind=8), allocatable :: cd_core_tape_vc_15h(:,:,:,:)

end module     cd_core_do_tad_store


module     cd_core_tad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use cd_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine cd_core_do_tad( im, jm, km, jfirst, jlast, u, v, pt, rcap, iord_c, jord_c, iord_d, jord_d, ng_c, ng_d, ng_s, cosp, cose,&
& acosp, sinlon, coslon, cosl5, sinl5, delpf, uc, vc )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use sw_core_tad
use tp_core
use tp_core_tad
use timingmodule
use cd_core_do_tad_store, only : cd_core_tape_cd_core_do,cd_core_tape_delpf_3h,cd_core_tape_pt_16h,cd_core_tape_pt_5h,&
&cd_core_tape_u_12h,cd_core_tape_u_1h,cd_core_tape_uc_14h,cd_core_tape_v_13h,cd_core_tape_v_2h,cd_core_tape_vc_15h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cose(jm)
integer :: im
real(kind=r8) :: cosl5(im)
real(kind=r8) :: coslon(im)
real(kind=r8) :: cosp(jm)
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
real(kind=r8) :: delpf(im,jfirst-ng_d:jlast+ng_d,km)
integer :: iord_c
integer :: iord_d
integer :: jord_c
integer :: jord_d
integer :: ng_c
integer :: ng_s
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: rcap
real(kind=r8) :: sinl5(im)
real(kind=r8) :: sinlon(im)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uc(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: vc(im,jfirst-2:jlast+2,km)

!==============================================
! declare local variables
!==============================================
integer :: c_sw_tape_rec
integer :: d_sw_tape_rec
integer :: iord
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: jord
integer :: js2g0
integer :: js2gc
integer :: k

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
u = cd_core_tape_u_12h(:,:,:,cd_core_tape_rec+1)
v = cd_core_tape_v_13h(:,:,:,cd_core_tape_rec+1)
uc = cd_core_tape_uc_14h(:,:,:,cd_core_tape_rec+1)
vc = cd_core_tape_vc_15h(:,:,:,cd_core_tape_rec+1)
pt = cd_core_tape_pt_16h(:,:,:,cd_core_tape_rec+1)
call adtiming_off( 'D-6000' )
call adtiming_on( 'D-6000' )
call adtiming_off( 'D-4500' )
call adtiming_on( 'D-4500' )
call adtiming_off( 'D_GEOP' )
call adtiming_on( 'D_GEOP' )
call adtiming_off( 'D_CORE' )
#ifdef USE_OPENMP
!$omp parallel do shared(acosp,cd_core_tape_rec,cose,cosl5,coslon,cosp,delpf,dtdx,dtdy,dtdy5,dtxe5,im,iord_d,jfirst,jlast,jm,jn1g1,&
!$omp& jord_d,js2g0,km,ng_d,ng_s,pt,rcap,sinl5,sinlon,u,uc,v,vc,zt_d) private(d_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    if (k .eq. 1) then
      iord = 1
      jord = 1
    else
      iord = min(2,iord_d)
      jord = min(2,jord_d)
    endif
  else
    iord = iord_d
    jord = jord_d
  endif
  d_sw_tape_rec = k-1+cd_core_tape_rec*km
  call d_sw_tad( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),pt(1,jfirst-ng_d,k),delpf(1,jfirst-&
&ng_d,k),dtdx,dtxe5,js2g0,jn1g1,im,jm,jfirst,jlast,ng_d,ng_s,iord,jord,zt_d,rcap,tiny,dtdy,dtdy5,cosp,acosp,cose,coslon,sinlon,&
&cosl5,sinl5,d_sw_tape_rec )
end do
call adtiming_on( 'D_CORE' )
call adtiming_off( 'C_V_LOOP' )
call adtiming_on( 'C_V_LOOP' )
call adtiming_off( 'C_U_LOOP' )
call adtiming_on( 'C_U_LOOP' )
call adtiming_off( 'C_GEOP' )
call adtiming_on( 'C_GEOP' )
call adtiming_off( 'C_CORE' )
u = cd_core_tape_u_1h(:,:,:,cd_core_tape_rec+1)
v = cd_core_tape_v_2h(:,:,:,cd_core_tape_rec+1)
delpf = cd_core_tape_delpf_3h(:,:,:,cd_core_tape_rec+1)
pt = cd_core_tape_pt_5h(:,:,:,cd_core_tape_rec+1)
#ifdef USE_OPENMP
!$omp parallel do shared(acosp,cd_core_tape_rec,cose,cosl5,coslon,cosp,delpf,dtdx2,dtdx4,dtdy5,im,iord_c,jfirst,jlast,jm,jn1gc,&
!$omp& jn2g0,jord_c,js2g0,js2gc,km,ng_c,ng_d,ng_s,pt,rcap,sinl5,sinlon,u,uc,v,vc,zt_c) private(c_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    iord = 1
    jord = 1
  else
    iord = iord_c
    jord = jord_c
  endif
  c_sw_tape_rec = k-1+cd_core_tape_rec*km
  call c_sw_tad( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),pt(1,jfirst-ng_d,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),delpf(1,jfirst-&
&ng_d,k),cosp,acosp,cose,coslon,sinlon,dtdx2,dtdx4,dtdy5,zt_c,tiny,rcap,im,jm,jfirst,jlast,ng_c,ng_d,ng_s,js2g0,jn2g0,js2gc,&
&jn1gc,iord,jord,cosl5,sinl5,c_sw_tape_rec )
end do
call adtiming_on( 'C_CORE' )

end subroutine cd_core_do_tad


subroutine cd_core_domd( im, jm, km, nq, nx, jfirst, jlast, u, v, pt, delp, pe, pk, ns, dt, ptop, umax, fill, filter, acap, ae, &
&rcap, cp, akap, iord_c, jord_c, iord_d, jord_d, ng_c, ng_d, ng_s, ipe, om, hs, sinp, cosp, cose, acosp, sinlon, coslon, cosl5, &
&sinl5, cx3, cy3, mfx, mfy, delpf, uc, vc, ptc, dpt, ptk, wz3, pkc, wz )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use sw_core
use tp_core
use timingmodule
use sw_core_tad, only : c_swmd, d_swmd
use cd_core_do_tad_store, only : cd_core_tape_cd_core_do,cd_core_tape_delpf_3h,cd_core_tape_pt_16h,cd_core_tape_pt_5h,&
&cd_core_tape_u_12h,cd_core_tape_u_1h,cd_core_tape_uc_14h,cd_core_tape_v_13h,cd_core_tape_v_2h,cd_core_tape_vc_15h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: ae
real(kind=r8) :: akap
real(kind=r8) :: cose(jm)
integer :: im
real(kind=r8) :: cosl5(im)
real(kind=r8) :: coslon(im)
real(kind=r8) :: cosp(jm)
real(kind=r8) :: cp
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
real(kind=r8) :: cx3(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: cy3(im,jfirst:jlast+1,km)
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delpf(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: dpt(im,jfirst-1:jlast+1,km)
real(kind=r8) :: dt
logical :: fill
logical :: filter
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: iord_c
integer :: iord_d
integer :: ipe
integer :: jord_c
integer :: jord_d
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
integer :: ng_c
integer :: ng_s
integer :: nq
integer :: ns
integer :: nx
real(kind=r8) :: om
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkc(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: ptc(im,jfirst:jlast,km)
real(kind=r8) :: ptk(im,jfirst:jlast,km)
real(kind=r8) :: ptop
real(kind=r8) :: rcap
real(kind=r8) :: sinl5(im)
real(kind=r8) :: sinlon(im)
real(kind=r8) :: sinp(jm)
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: uc(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: umax
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: vc(im,jfirst-2:jlast+2,km)
real(kind=r8) :: wz(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: wz3(im,jfirst-1:jlast,km+1)

!==============================================
! declare local variables
!==============================================
integer :: c_sw_tape_rec
integer :: d_sw_tape_rec
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: help_l
integer :: help_m
integer :: i
integer :: iord
integer :: j
integer :: jn1g1
integer :: jn1gc
integer :: jn2g0
integer :: jord
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: js2gc
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: pk4
real(kind=r8) :: pkchelp(im,jfirst-1:jlast+1)
real(kind=r8) :: wk(im,jfirst:jlast+2)
real(kind=r8) :: wk1(im,jfirst-1:jlast+1)
real(kind=r8) :: wk2(im,jfirst:jlast+1)
real(kind=r8) :: wk3(im,jfirst-1:jlast+1)

!**********************************************
! executable statements of routine
!**********************************************
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gc = max(2,jfirst-ng_c)
if (ng_c .eq. 1 .and. ng_d .gt. 1) then
  js2gc = max(2,jfirst-2)
endif
jn1gc = min(jm,jlast+ng_c)
wz = 0.
wz3 = 0.
uc = 0.
vc = 0.
if (ipe .eq. (-1) .or. ns .eq. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_h,i,j,k,wk,wk2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_h = jn2g0-js2g0+1
    call pft2d( delpf(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_h,ifax,trigs,wk,wk2 )
  end do
endif
if ( .not. allocated(cd_core_tape_u_1h)) then
  allocate( cd_core_tape_u_1h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_u_1h(:,:,:,cd_core_tape_rec+1) = u
if ( .not. allocated(cd_core_tape_v_2h)) then
  allocate( cd_core_tape_v_2h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_v_2h(:,:,:,cd_core_tape_rec+1) = v
if ( .not. allocated(cd_core_tape_delpf_3h)) then
  allocate( cd_core_tape_delpf_3h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_delpf_3h(:,:,:,cd_core_tape_rec+1) = delpf
if ( .not. allocated(cd_core_tape_pt_5h)) then
  allocate( cd_core_tape_pt_5h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_pt_5h(:,:,:,cd_core_tape_rec+1) = pt
#ifdef USE_OPENMP
!$omp parallel do private(c_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    iord = 1
    jord = 1
  else
    iord = iord_c
    jord = jord_c
  endif
  c_sw_tape_rec = k-1+cd_core_tape_rec*km
  call c_swmd( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),pt(1,jfirst-ng_d,k),delp(1,jfirst,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),&
&ptc(1,jfirst,k),delpf(1,jfirst-ng_d,k),ptk(1:im,jfirst:jlast,k),cosp,acosp,cose,coslon,sinlon,dxdt,dxe,dtdx2,dtdx4,dtxe5,rdxe,&
&dycp,dydt,dtdy5,cye,fc,ifax,trigs,dc(1,js2g0),sc,zt_c,tiny,rcap,im,jm,jfirst,jlast,ng_c,ng_d,ng_s,js2g0,jn2g0,js2gc,jn1gc,iord,&
&jord,cosl5,sinl5,c_sw_tape_rec )
end do
call geopk( ptop,pe,ptk,pkc,wz,hs,ptc,im,jm,km,jfirst,jlast,0,cp,akap,nx,0, .false.  )
#ifdef USE_OPENMP
!$omp parallel do private(help_i,i,j,k,p1d,wk,wk2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, jn2g0
    do i = 1, im
      p1d(i) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
    uc(1,j,k) = uc(1,j,k)+dtdx2(j)*((wz(im,j,k+1)-wz(1,j,k))*(pkc(1,j,k+1)-pkc(im,j,k))+(wz(im,j,k)-wz(1,j,k+1))*(pkc(im,j,k+1)-&
&pkc(1,j,k)))/(p1d(1)+p1d(im))
    do i = 2, im
      uc(i,j,k) = uc(i,j,k)+dtdx2(j)*((wz(i-1,j,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i-1,j,k))+(wz(i-1,j,k)-wz(i,j,k+1))*(pkc(i-1,j,k+&
&1)-pkc(i,j,k)))/(p1d(i)+p1d(i-1))
    end do
  end do
  help_i = jn2g0-js2g0+1
  call pft2d( uc(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_i,ifax,trigs,wk,wk2 )
end do
#ifdef USE_OPENMP
!$omp parallel do private(help_j,i,j,k,wk,wk1)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jlast
    do i = 1, im
      wk1(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im
      vc(i,j,k) = vc(i,j,k)+dtdy5/(wk1(i,j)+wk1(i,j-1))*((wz(i,j-1,k+1)-wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j-1,k))+(wz(i,j-1,k)-wz(i,j,&
&k+1))*(pkc(i,j-1,k+1)-pkc(i,j,k)))
    end do
  end do
  help_j = jlast-js2g0+1
  call pft2d( vc(1,js2g0,k),se(js2g0),de(1,js2g0),im,help_j,ifax,trigs,wk,wk1 )
end do
if ( .not. allocated(cd_core_tape_u_12h)) then
  allocate( cd_core_tape_u_12h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_u_12h(:,:,:,cd_core_tape_rec+1) = u
if ( .not. allocated(cd_core_tape_v_13h)) then
  allocate( cd_core_tape_v_13h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_v_13h(:,:,:,cd_core_tape_rec+1) = v
if ( .not. allocated(cd_core_tape_uc_14h)) then
  allocate( cd_core_tape_uc_14h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_uc_14h(:,:,:,cd_core_tape_rec+1) = uc
if ( .not. allocated(cd_core_tape_vc_15h)) then
  allocate( cd_core_tape_vc_15h(1:im,1:3+2+jlast-jfirst,1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_vc_15h(:,:,:,cd_core_tape_rec+1) = vc
if ( .not. allocated(cd_core_tape_pt_16h)) then
  allocate( cd_core_tape_pt_16h(1:im,1:1+jlast+ng_d-(jfirst-ng_d),1:km,cd_core_tape_cd_core_do) )
endif
cd_core_tape_pt_16h(:,:,:,cd_core_tape_rec+1) = pt
#ifdef USE_OPENMP
!$omp parallel do private(d_sw_tape_rec,iord,jord,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  if (k .lt. km/8) then
    if (k .eq. 1) then
      iord = 1
      jord = 1
    else
      iord = min(2,iord_d)
      jord = min(2,jord_d)
    endif
  else
    iord = iord_d
    jord = jord_d
  endif
  d_sw_tape_rec = k-1+cd_core_tape_rec*km
  call d_swmd( u(1,jfirst-ng_d,k),v(1,jfirst-ng_s,k),uc(1,jfirst-ng_d,k),vc(1,jfirst-2,k),pt(1,jfirst-ng_d,k),delp(1,jfirst,k),&
&delpf(1,jfirst-ng_d,k),cx3(1,jfirst-ng_d,k),cy3(1,jfirst,k),mfx(1,jfirst,k),mfy(1,jfirst,k),cdx(js2g0,k),cdy(js2g0,k),dtdx,&
&dtdxe,dtxe5,txe5,dyce,rdx,cyy,dx,f0(jfirst-ng_d),js2g0,jn1g1,im,jm,jfirst,jlast,ng_d,ng_s,nq,iord,jord,zt_d,rcap,tiny,dtdy,&
&dtdy5,tdy5,rdy,cosp,acosp,cose,coslon,sinlon,cosl5,sinl5,d_sw_tape_rec )
end do
call geopk( ptop,pe,delp,pkc,wz,hs,pt,im,jm,km,jfirst,jlast,ng_d,cp,akap,nx,ipe, .true.  )
if (ipe .ne. 1) then
#ifdef USE_OPENMP
  !$omp parallel do private(help_k,i,j,k,wk,wk2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delpf(i,j,k) = delp(i,j,k)
      end do
    end do
    help_k = jn2g0-js2g0+1
    call pft2d( delpf(1,js2g0,k),sc(js2g0),dc(1,js2g0),im,help_k,ifax,trigs,wk,wk2 )
  end do
else
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km+1
    do j = jfirst, jlast
      do i = 1, im
        pk(i,j,k) = pkc(i,j,k)
      end do
    end do
  end do
endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js1g1, jn1g1
    do i = 1, im
      dpt(i,j,k) = (wz(i,j,k+1)+wz(i,j,k))*(pkc(i,j,k+1)-pkc(i,j,k))
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,pkchelp,wk1,wk3)
#endif /* ! USE_OPENMP */
do k = 2, km+1
  do j = js2g1, jn2g0
    wk3(1,j) = (wz(1,j,k)+wz(im,j,k))*(pkc(1,j,k)-pkc(im,j,k))
    do i = 2, im
      wk3(i,j) = (wz(i,j,k)+wz(i-1,j,k))*(pkc(i,j,k)-pkc(i-1,j,k))
    end do
  end do
  do j = js2g1, jn2g0
    do i = 1, im-1
      wk1(i,j) = wk3(i,j)+wk3(i+1,j)
    end do
    wk1(im,j) = wk3(im,j)+wk3(1,j)
  end do
  if (jfirst .eq. 1) then
    do i = 1, im
      wk1(i,1) = 0.
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im
      wk1(i,jm) = 0.
    end do
  endif
  do j = js2g0, jlast
    do i = 1, im
      wz3(i,j,k) = wk1(i,j)+wk1(i,j-1)
    end do
  end do
  do j = js2g0, jn1g1
    do i = 1, im
      wk1(i,j) = (wz(i,j,k)+wz(i,j-1,k))*(pkc(i,j,k)-pkc(i,j-1,k))
    end do
  end do
  do j = js2g0, jn1g1
    wk3(1,j) = wk1(1,j)+wk1(im,j)
    do i = 2, im
      wk3(i,j) = wk1(i,j)+wk1(i-1,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wz(i,j,k) = wk3(i,j)+wk3(i,j+1)
    end do
  end do
  do j = jfirst-1, jlast+1
    do i = 1, im
      pkchelp(i,j) = pkc(i,j,k)
    end do
  end do
  call avgc( pkchelp,pkc(1,jfirst,k),im,jm,jfirst,jlast,wk1 )
end do
do j = js2g0, jlast
  do i = 1, im
    wz3(i,j,1) = 0.
    wz(i,j,1) = 0.
  end do
end do
pk4 = 4.*ptop**akap
do j = js2g0, jn1g1
  do i = 1, im
    pkc(i,j,1) = pk4
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(help_l,help_m,i,j,k,wk,wk1,wk2,wk3)
#endif /* ! USE_OPENMP */
do k = 1, km
  call avgc( dpt(1,jfirst-1,k),wk2(1,jfirst),im,jm,jfirst,jlast,wk1 )
  do j = js2g0, jn1g1
    do i = 1, im
      wk(i,j) = pkc(i,j,k+1)-pkc(i,j,k)
    end do
  end do
  do j = js2g0, jlast
    do i = 1, im-1
      wk3(i,j) = uc(i,j,k)+dtdxe(j)/(wk(i,j)+wk(i+1,j))*(wk2(i,j)-wk2(i+1,j)+wz3(i,j,k+1)-wz3(i,j,k))
    end do
    wk3(im,j) = uc(im,j,k)+dtdxe(j)/(wk(im,j)+wk(1,j))*(wk2(im,j)-wk2(1,j)+wz3(im,j,k+1)-wz3(im,j,k))
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      wk1(i,j) = vc(i,j,k)+dtdy/(wk(i,j)+wk(i,j+1))*(wk2(i,j)-wk2(i,j+1)+wz(i,j,k+1)-wz(i,j,k))
    end do
  end do
  help_l = jlast-js2g0+1
  call pft2d( wk3(1,js2g0),se(js2g0),de(1,js2g0),im,help_l,ifax,trigs,wk,wk2 )
  help_m = jn2g0-js2g0+1
  call pft2d( wk1(1,js2g0),sc(js2g0),dc(1,js2g0),im,help_m,ifax,trigs,wk,wk2 )
  do j = js2g0, jlast
    do i = 1, im
      u(i,j,k) = u(i,j,k)+wk3(i,j)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v(i,j,k) = v(i,j,k)+wk1(i,j)
    end do
  end do
end do
end subroutine cd_core_domd


end module     cd_core_tad


#endif /* SPMD */
