#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine age_of_air_tad( im, km, jfirst, jlast, ng, time, pe, q_tae )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: p_source = 75000.
real(kind=r8), parameter :: tiny = 1.e-6

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: time

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: k
real(kind=r8) :: pm

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
#ifdef USE_OPENMP
!$omp parallel do shared(im,jfirst,jlast,km,pe,q_tae,time) private(i,j,k,pm)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = jfirst, jlast
    do i = 1, im
      pm = 0.5*(pe(i,k,j)+pe(i,k+1,j))
      if (time .lt. tiny) then
        q_tae(i,j,k) = 0.d0
      else if (pm .ge. p_source) then
        q_tae(i,j,k) = 0.d0
      endif
    end do
  end do
end do

end subroutine age_of_air_tad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine age_of_air_tad( im, km, jfirst, jlast, ng, time, pe, q_tae )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: p_source = 75000.
real(kind=r8), parameter :: tiny = 1.e-6

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: q_tae(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: time

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: k
real(kind=r8) :: pm

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
#ifdef USE_OPENMP
!$omp parallel do shared(im,jfirst,jlast,km,pe,q_tae,time) private(i,j,k,pm)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = jfirst, jlast
    do i = 1, im
      pm = 0.5*(pe(i,k,j)+pe(i,k+1,j))
      if (time .lt. tiny) then
        q_tae(i,j,k) = 0.d0
      else if (pm .ge. p_source) then
        q_tae(i,j,k) = 0.d0
      endif
    end do
  end do
end do

end subroutine age_of_air_tad


#endif /* SPMD */
