subroutine d2a2( u_tm, v_tm, ua_tl, va_tl, im, jm, jfirst, jlast, ng_d, ng_s, coslon, sinlon )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.5.2   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: coslon(im)
integer :: jfirst
integer :: jlast
integer :: jm
integer :: ng_d
integer :: ng_s
real(kind=r8) :: sinlon(im)
real(kind=r8) :: u_tm(im,jfirst:jlast+1)
real(kind=r8) :: ua_tl(im,jfirst:jlast)
real(kind=r8) :: v_tm(im,jfirst:jlast)
real(kind=r8) :: va_tl(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: imh
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: un
real(kind=r8) :: un_tl
real(kind=r8) :: us
real(kind=r8) :: us_tl
real(kind=r8) :: vn
real(kind=r8) :: vn_tl
real(kind=r8) :: vs
real(kind=r8) :: vs_tl

!----------------------------------------------
! TANGENT LINEAR AND FUNCTION STATEMENTS
!----------------------------------------------
imh = im/2
jn2g0 = min(jlast,jm-1)
js2g0 = max(jfirst,2)
do j = js2g0, jn2g0
  do i = 1, im
    ua_tl(i,j) = 0.5*u_tm(i,j+1)+0.5*u_tm(i,j)
  end do
end do
do j = js2g0, jn2g0
  do i = 1, im-1
    va_tl(i,j) = 0.5*v_tm(i+1,j)+0.5*v_tm(i,j)
  end do
  va_tl(im,j) = 0.5*v_tm(im,j)+0.5*v_tm(1,j)
end do
if (jfirst .eq. 1) then
  us_tl = 0.0d0
  vs_tl = 0.0d0
  do i = 1, imh
    us_tl = ua_tl(i+imh,2)*sinlon(i)-ua_tl(i,2)*sinlon(i)+us_tl-va_tl(i+imh,2)*coslon(i)+va_tl(i,2)*coslon(i)
    vs_tl = ua_tl(i+imh,2)*coslon(i)-ua_tl(i,2)*coslon(i)+va_tl(i+imh,2)*sinlon(i)-va_tl(i,2)*sinlon(i)+vs_tl
  end do
  us_tl = us_tl/dble(im)
  vs_tl = vs_tl/dble(im)
  do i = 1, imh
    ua_tl(i,1) = (-(us_tl*sinlon(i)))-vs_tl*coslon(i)
    va_tl(i,1) = us_tl*coslon(i)-vs_tl*sinlon(i)
    ua_tl(i+imh,1) = -ua_tl(i,1)
    va_tl(i+imh,1) = -va_tl(i,1)
  end do
endif
if (jlast .eq. jm) then
  un_tl = 0.0d0
  vn_tl = 0.0d0
  do i = 1, imh
    un_tl = ua_tl(i+imh,jm-1)*sinlon(i)-ua_tl(i,jm-1)*sinlon(i)+un_tl+va_tl(i+imh,jm-1)*coslon(i)-va_tl(i,jm-1)*coslon(i)
    vn_tl = (-(ua_tl(i+imh,jm-1)*coslon(i)))+ua_tl(i,jm-1)*coslon(i)+va_tl(i+imh,jm-1)*sinlon(i)-va_tl(i,jm-1)*sinlon(i)+vn_tl
  end do
  un_tl = un_tl/dble(im)
  vn_tl = vn_tl/dble(im)
  do i = 1, imh
    ua_tl(i,jm) = (-(un_tl*sinlon(i)))+vn_tl*coslon(i)
    va_tl(i,jm) = (-(un_tl*coslon(i)))-vn_tl*sinlon(i)
    ua_tl(i+imh,jm) = -ua_tl(i,jm)
    va_tl(i+imh,jm) = -va_tl(i,jm)
  end do
endif

end subroutine d2a2
