#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
! !REVISION HISTORY:
!
!   12Dec2009 Todling  Turned arrays trac2d_tape_ns_dp1_1h and
!                      trac2d_tape_ns_q_2h into allocatables
!
subroutine trac2d_ad( dp1, dp1_ad, q, q_ae, nq, cx, cx_ad, cy, cy_ad, mfx, mfx_ad, mfy, mfy_ad, iord, jord, ng, sine, cosp, acosp, &
&acap, rcap, fill, im, jm, km, jfirst, jlast, va, va_ad, flx, flx_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_ad
use fill_module
use fill_module_ad
use mod_comm, only : mp_barrier, mp_recv2_n, mp_recv2_n_ad, mp_recv3d_ns, mp_recv3d_ns_ad, mp_recv4d_ns, mp_recv4d_ns_ad, &
&mp_reduce_max, mp_send2_s, mp_send2_s_ad, mp_send3d_ns, mp_send3d_ns_ad, mp_send4d_ns, mp_send4d_ns_ad

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng
real(kind=r8) :: cx(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: cx_ad(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: cy(im,jfirst:jlast+1,km)
real(kind=r8) :: cy_ad(im,jfirst:jlast+1,km)
real(kind=r8) :: dp1(im,jfirst:jlast,km)
real(kind=r8) :: dp1_ad(im,jfirst:jlast,km)
logical :: fill
real(kind=r8) :: flx(im,jfirst:jlast,km)
real(kind=r8) :: flx_ad(im,jfirst:jlast,km)
integer :: iord
integer :: jord
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfx_ad(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
real(kind=r8) :: mfy_ad(im,jfirst:jlast+1,km)
integer :: nq
real(kind=r8) :: q(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: rcap
real(kind=r8) :: sine(jm)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_ad(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a2(im,jfirst:jlast)
real(kind=r8) :: a2_ad(im,jfirst:jlast)
real(kind=r8) :: cmax
real(kind=r8) :: cmax_ad
real(kind=r8) :: cy_global
real(kind=r8) :: cy_global_ad
real(kind=r8) :: cyh(im,jfirst:jlast+1,km)
real(kind=r8) :: cymax(km)
real(kind=r8) :: cymax_ad(km)
real(kind=r8) :: dp2(im,jfirst:jlast,km)
real(kind=r8) :: dp2_ad(im,jfirst:jlast,km)
logical :: ffsl(jm,km)
real(kind=r8) :: frac
real(kind=r8) :: frac_ad
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_ad(im,1+jlast-jfirst)
real(kind=r8) :: fxi_ad(im,1+jlast-jfirst)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fyh_ad(im,1+1+jlast-jfirst)
real(kind=r8) :: fyi_ad(im,1+1+jlast-jfirst)
integer :: i
integer :: iq
integer :: it
integer :: j
integer :: jn1g1
integer :: jn2g0
integer :: jn2gd
integer :: js2g0
integer :: js2gd
integer :: k
real(kind=r8) :: mfxh(im,jfirst:jlast,km)
integer :: nsplt
real(kind=r8) :: sum1
real(kind=r8) :: sum1_ad
real(kind=r8) :: sum2
real(kind=r8) :: sum2_ad
real(kind=r8) :: trac2d_tape_cx_1h(im,1+jlast+ng-(jfirst-ng),km,1)
real(kind=r8) :: trac2d_tape_cy_2h(im,1+1+jlast-jfirst,km,1)
real(kind=r8), allocatable :: trac2d_tape_cymax_4h(:,:)
real(kind=r8) :: trac2d_tape_flx_5h(im,1+jlast-jfirst,km,1)
real(kind=r8) :: trac2d_tape_mfy_3h(im,1+1+jlast-jfirst,km,1)
real(kind=r8),allocatable :: trac2d_tape_ns_dp1_1h(:,:,:,:)
real(kind=r8),allocatable :: trac2d_tape_ns_q_2h(:,:,:,:,:)
integer :: trac2d_tape_rec
integer :: trac2d_tape_trac2d

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
mfxh(:,:,:) = mfx(:,:,:)
cyh(:,:,:) = cy(:,:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a2_ad(:,:) = 0.d0
cmax_ad = 0.d0
cy_global_ad = 0.d0
cymax_ad(:) = 0.d0
dp2_ad(:,:,:) = 0.d0
frac_ad = 0.d0
fxh_ad(:,:) = 0.d0
fxi_ad(:,:) = 0.d0
fyh_ad(:,:) = 0.d0
fyi_ad(:,:) = 0.d0
sum1_ad = 0.d0
sum2_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
!----------------------------------------------
! OPEN TAPE trac2d_tape
!----------------------------------------------
trac2d_tape_trac2d = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
trac2d_tape_rec = 0
call mp_send3d_ns( im,jm,jfirst,jlast,1,km,ng,ng,cx,1 )
call mp_send2_s( im,jm,jfirst,jlast,1,km,0,1,cy,mfy )
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gd = max(2,jfirst-ng)
jn2gd = min(jm-1,jlast+ng)
#ifdef USE_OPENMP
!$omp parallel do private(cmax,i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  cymax(k) = 0.
  do j = js2g0, jlast
    cmax = 0.
    do i = 1, im
      cmax = max(abs(cy(i,j,k)),cmax)
    end do
    cymax(k) = max(cymax(k),cmax*(1.+sine(j)**16))
  end do
end do
call mp_recv3d_ns( im,jm,jfirst,jlast,1,km,ng,ng,cx,1 )
call mp_recv2_n( im,jm,jfirst,jlast,1,km,0,1,cy,mfy )
call mp_reduce_max( km,cymax )
trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1) = cx
trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1) = cy
trac2d_tape_mfy_3h(:,:,:,trac2d_tape_rec+1) = mfy
if ( .not. allocated(trac2d_tape_cymax_4h)) then
  allocate( trac2d_tape_cymax_4h(1:km,trac2d_tape_trac2d) )
endif
trac2d_tape_cymax_4h(:,trac2d_tape_rec+1) = cymax
call mp_send4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
cy_global = cymax(1)
if (km .ne. 1) then
  do k = 2, km
    cy_global = max(cymax(k),cy_global)
  end do
endif
nsplt = int(1.+cy_global)
if ( .not. allocated(trac2d_tape_ns_dp1_1h)) then
  allocate ( trac2d_tape_ns_dp1_1h(im,1+jlast-jfirst,km,nsplt+trac2d_tape_rec*nsplt) )
endif
if ( .not. allocated(trac2d_tape_ns_q_2h)) then
  allocate ( trac2d_tape_ns_q_2h(im,1+jlast+ng-(jfirst-ng),km,nq,nsplt+trac2d_tape_rec*nsplt) )
endif
frac = 1./float(nsplt)
do k = 1, km
  if (nsplt .ne. 1) then
    do j = js2gd, jn2gd
      do i = 1, im
        cx(i,j,k) = cx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        mfx(i,j,k) = mfx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn1g1
      do i = 1, im
        cy(i,j,k) = cy(i,j,k)*frac
        mfy(i,j,k) = mfy(i,j,k)*frac
      end do
    end do
  endif
  do j = js2g0, jn2g0
    do i = 1, im
      if (cy(i,j,k)*cy(i,j+1,k) .gt. 0.) then
        if (cy(i,j,k) .gt. 0.) then
          va(i,j,k) = cy(i,j,k)
        else
          va(i,j,k) = cy(i,j+1,k)
        endif
      else
        va(i,j,k) = 0.
      endif
    end do
  end do
  do j = js2gd, jn2gd
    ffsl(j,k) =  .false. 
    do i = 1, im
      if (abs(cx(i,j,k)) .gt. 1.) then
        ffsl(j,k) =  .true. 
        exit
      endif
    end do
  end do
  do j = js2g0, jn2g0
    if (ffsl(j,k)) then
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)/sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))
      end do
    else
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)
      end do
    endif
  end do
end do
trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1) = flx
do it = 1, nsplt-1
  if (it .ne. 1) then
    call mp_send4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
  endif
  trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  call mp_recv4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
  trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q
#ifdef USE_OPENMP
  !$omp parallel do private(a2,fx,fy,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy( q(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp,acosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
    end do
    if (it .ne. nsplt) then
      do j = jfirst, jlast
        do i = 1, im
          dp1(i,j,k) = dp2(i,j,k)
        end do
      end do
    endif
  end do
end do
it = nsplt
if (it .ne. 1) then
  call mp_send4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
endif
trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
call mp_recv4d_ns( im,jm,jfirst,jlast,1,km,nq,ng,ng,q )
trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
cymax = trac2d_tape_cymax_4h(:,trac2d_tape_rec+1)
cy_global = cymax(1)
flx = trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1)
do it = nsplt, 1, -1
  dp1 = trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
!$omp parallel do shared(acap,acosp,cosp,cx,cx_ad,cy,cy_ad,dp1,dp1_ad,dp2,dp2_ad,ffsl,fill,flx,flx_ad,im,iord,it,jfirst,jlast,jm,&
!$omp& jord,km,mfy,mfy_ad,ng,nq,nsplt,q,q_ae,rcap,va,va_ad) private(a2,a2_ad,fx,fxi_ad,fy,fyi_ad,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    a2_ad(:,:) = 0.d0
#ifdef USE_OPENMP
    fxi_ad(:,:) = 0.d0
    fyi_ad(:,:) = 0.d0
#endif /* ! USE_OPENMP */
    if (it .ne. nsplt) then
      do j = jfirst, jlast
        do i = 1, im
          dp2_ad(i,j,k) = dp2_ad(i,j,k)+dp1_ad(i,j,k)
          dp1_ad(i,j,k) = 0.d0
        end do
      end do
    endif
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy( q(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp,acosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          dp2_ad(i,j,k) = dp2_ad(i,j,k)-q_ae(i,j,k,iq)*(q(i,j,k,iq)/(dp2(i,j,k)*dp2(i,j,k)))
          q_ae(i,j,k,iq) = q_ae(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
!AOO      q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy_ad( q(1,jfirst,k,iq),q_ae(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp )
      endif
!AOO      q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      do j = jfirst, jlast
        do i = 1, im
          a2_ad(i,j) = a2_ad(i,j)+q_ae(i,j,k,iq)
          dp1_ad(i,j,k) = dp1_ad(i,j,k)+q_ae(i,j,k,iq)*q(i,j,k,iq)
          q_ae(i,j,k,iq) = q_ae(i,j,k,iq)*dp1(i,j,k)
        end do
      end do
!AOO      q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      call tp2c_ad( a2_ad,va(1,jfirst,k),va_ad(1,jfirst,k),q(1,jfirst-ng,k,iq),q_ae(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cx_ad(1,&
&jfirst-ng,k),cy(1,jfirst,k),cy_ad(1,jfirst,k),im,jm,iord,jord,ng,fx,fxi_ad,fy,fyi_ad,ffsl(1,k),rcap,acosp,flx(1,jfirst,k),&
&flx_ad(1,jfirst,k),mfy(1,jfirst,k),mfy_ad(1,jfirst,k),cosp,1,jfirst,jlast )
    end do
  end do
  call mp_recv4d_ns_ad( im,jm,jfirst,jlast,1,km,nq,ng,ng,q_ae )
#ifdef USE_OPENMP
  !$omp parallel do shared(acosp,dp1_ad,dp2_ad,im,jfirst,jlast,jm,jn2g0,js2g0,km,mfx_ad,mfy_ad,rcap) private(i,j,k,sum1_ad,sum2_ad)
#endif /* ! USE_OPENMP */
  do k = 1, km
    sum1_ad = 0.d0
    sum2_ad = 0.d0
    if (jlast .eq. jm) then
      do i = 1, im
        dp1_ad(i,jm,k) = dp1_ad(i,jm,k)+dp2_ad(i,jm,k)
        sum2_ad = sum2_ad+dp2_ad(i,jm,k)
        dp2_ad(i,jm,k) = 0.d0
      end do
      sum2_ad = sum2_ad*rcap
      do i = 1, im
        mfy_ad(i,jm,k) = mfy_ad(i,jm,k)+sum2_ad
      end do
      sum2_ad = 0.d0
    endif
    if (jfirst .eq. 1) then
      do i = 1, im
        dp1_ad(i,1,k) = dp1_ad(i,1,k)+dp2_ad(i,1,k)
        sum1_ad = sum1_ad+dp2_ad(i,1,k)
        dp2_ad(i,1,k) = 0.d0
      end do
      sum1_ad = -(sum1_ad*rcap)
      do i = 1, im
        mfy_ad(i,2,k) = mfy_ad(i,2,k)+sum1_ad
      end do
      sum1_ad = 0.d0
    endif
    do j = js2g0, jn2g0
      dp1_ad(im,j,k) = dp1_ad(im,j,k)+dp2_ad(im,j,k)
      mfx_ad(im,j,k) = mfx_ad(im,j,k)+dp2_ad(im,j,k)
      mfx_ad(1,j,k) = mfx_ad(1,j,k)-dp2_ad(im,j,k)
      mfy_ad(im,j+1,k) = mfy_ad(im,j+1,k)-dp2_ad(im,j,k)*acosp(j)
      mfy_ad(im,j,k) = mfy_ad(im,j,k)+dp2_ad(im,j,k)*acosp(j)
      dp2_ad(im,j,k) = 0.d0
      do i = 1, im-1
        dp1_ad(i,j,k) = dp1_ad(i,j,k)+dp2_ad(i,j,k)
        mfx_ad(i+1,j,k) = mfx_ad(i+1,j,k)-dp2_ad(i,j,k)
        mfx_ad(i,j,k) = mfx_ad(i,j,k)+dp2_ad(i,j,k)
        mfy_ad(i,j+1,k) = mfy_ad(i,j+1,k)-dp2_ad(i,j,k)*acosp(j)
        mfy_ad(i,j,k) = mfy_ad(i,j,k)+dp2_ad(i,j,k)*acosp(j)
        dp2_ad(i,j,k) = 0.d0
      end do
    end do
  end do
  if (it .ne. 1) then
    call mp_send4d_ns_ad( im,jm,jfirst,jlast,1,km,nq,ng,ng,q_ae )
  endif
end do
mfx(:,:,:) = mfxh(:,:,:)
cx = trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1)
cy = trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1)
mfy = trac2d_tape_mfy_3h(:,:,:,trac2d_tape_rec+1)
do k = 1, km
  if (nsplt .ne. 1) then
    do j = js2gd, jn2gd
      do i = 1, im
        cx(i,j,k) = cx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        mfx(i,j,k) = mfx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn1g1
      do i = 1, im
        cy(i,j,k) = cy(i,j,k)*frac
      end do
    end do
  endif
  do j = js2gd, jn2gd
    ffsl(j,k) =  .false. 
    do i = 1, im
      if (abs(cx(i,j,k)) .gt. 1.) then
        ffsl(j,k) =  .true. 
        exit
      endif
    end do
  end do
  do j = js2g0, jn2g0
    if (ffsl(j,k)) then
      do i = 1, im
        cx_ad(i,j,k) = cx_ad(i,j,k)-flx_ad(i,j,k)*(mfx(i,j,k)*(0.5+sign(0.5d0,abs(cx(i,j,k))-tiny))*sign(1.d0,cx(i,j,k))*sign(1.d0,&
&cx(i,j,k))*sign(1.d0,max(abs(cx(i,j,k)),tiny))/(sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))*sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))))
        mfx_ad(i,j,k) = mfx_ad(i,j,k)+flx_ad(i,j,k)/sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))
        flx_ad(i,j,k) = 0.d0
      end do
    else
      do i = 1, im
        mfx_ad(i,j,k) = mfx_ad(i,j,k)+flx_ad(i,j,k)
        flx_ad(i,j,k) = 0.d0
      end do
    endif
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      if (cy(i,j,k)*cy(i,j+1,k) .gt. 0.) then
        if (cy(i,j,k) .gt. 0.) then
          cy_ad(i,j,k) = cy_ad(i,j,k)+va_ad(i,j,k)
          va_ad(i,j,k) = 0.d0
        else
          cy_ad(i,j+1,k) = cy_ad(i,j+1,k)+va_ad(i,j,k)
          va_ad(i,j,k) = 0.d0
        endif
      else
        va_ad(i,j,k) = 0.d0
      endif
    end do
  end do
!AOO  mfx(:,:,:) = mfxh(:,:,:)
!AOO  cx = trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1)
!AOO  cy = trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1)
  mfx(:,:,k) = mfxh(:,:,k)
  cx(:,:,k) = trac2d_tape_cx_1h(:,:,k,trac2d_tape_rec+1)
  cy(:,:,k) = trac2d_tape_cy_2h(:,:,k,trac2d_tape_rec+1)
  if (nsplt .ne. 1) then
    do j = js2g0, jn1g1
      do i = 1, im
        frac_ad = frac_ad+mfy_ad(i,j,k)*mfy(i,j,k)
        mfy_ad(i,j,k) = mfy_ad(i,j,k)*frac
        frac_ad = frac_ad+cy_ad(i,j,k)*cy(i,j,k)
        cy_ad(i,j,k) = cy_ad(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        frac_ad = frac_ad+mfx_ad(i,j,k)*mfx(i,j,k)
        mfx_ad(i,j,k) = mfx_ad(i,j,k)*frac
      end do
    end do
    do j = js2gd, jn2gd
      do i = 1, im
        frac_ad = frac_ad+cx_ad(i,j,k)*cx(i,j,k)
        cx_ad(i,j,k) = cx_ad(i,j,k)*frac
      end do
    end do
  endif
end do
frac_ad = 0.d0
if (km .ne. 1) then
  do k = 2, km
    cymax_ad(k) = cymax_ad(k)+cy_global_ad*(0.5+sign(0.5d0,cymax(k)-cy_global))
    cy_global_ad = cy_global_ad*(0.5-sign(0.5d0,cymax(k)-cy_global))
  end do
endif
cymax_ad(1) = cymax_ad(1)+cy_global_ad
cy_global_ad = 0.d0
call mp_send4d_ns_ad( im,jm,jfirst,jlast,1,km,nq,ng,ng,q_ae )
cy(:,:,:) = cyh(:,:,:)
#ifdef USE_OPENMP
!$omp parallel do private(cmax,i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  cymax(k) = 0.
  do j = js2g0, jlast
    cmax = 0.
    do i = 1, im
      cmax = max(abs(cy(i,j,k)),cmax)
    end do
    cymax(k) = max(cymax(k),cmax*(1.+sine(j)**16))
  end do
end do
call admp_reduce_max( km,cymax,cymax_ad )
call mp_recv2_n_ad( im,jm,jfirst,jlast,1,km,0,1,cy_ad,mfy_ad )
call mp_recv3d_ns_ad( im,jm,jfirst,jlast,1,km,ng,ng,cx_ad,1 )
cy(:,:,:) = cyh(:,:,:)
#ifdef USE_OPENMP
!$omp parallel do shared(cy,cy_ad,cymax,cymax_ad,im,jlast,js2g0,km,sine) private(cmax,cmax_ad,i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  cmax_ad = 0.d0
  cymax(k) = 0.
  do j = js2g0, jlast
    cmax_ad = 0.d0
    cmax = 0.
    do i = 1, im
      cmax = max(abs(cy(i,j,k)),cmax)
    end do
    cmax_ad = cmax_ad+cymax_ad(k)*(0.5-sign(0.5d0,cymax(k)-cmax*(1.+sine(j)**16)))*(1+sine(j)**16)
    cymax_ad(k) = cymax_ad(k)*(0.5+sign(0.5d0,cymax(k)-cmax*(1.+sine(j)**16)))
    cmax = 0.
    do i = 1, im
      cy_ad(i,j,k) = cy_ad(i,j,k)+cmax_ad*(0.5+sign(0.5d0,abs(cy(i,j,k))-cmax))*sign(1.d0,cy(i,j,k))
      cmax_ad = cmax_ad*(0.5-sign(0.5d0,abs(cy(i,j,k))-cmax))
    end do
    cmax_ad = 0.d0
  end do
  cymax_ad(k) = 0.d0
end do
call mp_send2_s_ad( im,jm,jfirst,jlast,1,km,0,1,cy_ad,mfy_ad )
call mp_send3d_ns_ad( im,jm,jfirst,jlast,1,km,ng,ng,cx_ad,1 )

!----------------------------------------------
! CLOSE TAPE trac2d_tape
!----------------------------------------------
if (allocated(trac2d_tape_ns_q_2h)) then
  deallocate ( trac2d_tape_ns_q_2h )
endif
if (allocated(trac2d_tape_ns_dp1_1h)) then
  deallocate ( trac2d_tape_ns_dp1_1h )
endif
if (allocated(trac2d_tape_cymax_4h)) then
  deallocate( trac2d_tape_cymax_4h )
endif


!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine trac2d_ad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine trac2d_ad( dp1, dp1_ad, q, q_ae, nq, cx, cx_ad, cy, cy_ad, mfx, mfx_ad, mfy, mfy_ad, iord, jord, ng, sine, cosp, acosp, &
&acap, rcap, fill, im, jm, km, jfirst, jlast, va, va_ad, flx, flx_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tp_core
use tp_core_ad
use fill_module
use fill_module_ad

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-10

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng
real(kind=r8) :: cx(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: cx_ad(im,jfirst-ng:jlast+ng,km)
real(kind=r8) :: cy(im,jfirst:jlast+1,km)
real(kind=r8) :: cy_ad(im,jfirst:jlast+1,km)
real(kind=r8) :: dp1(im,jfirst:jlast,km)
real(kind=r8) :: dp1_ad(im,jfirst:jlast,km)
logical :: fill
real(kind=r8) :: flx(im,jfirst:jlast,km)
real(kind=r8) :: flx_ad(im,jfirst:jlast,km)
integer :: iord
integer :: jord
real(kind=r8) :: mfx(im,jfirst:jlast,km)
real(kind=r8) :: mfx_ad(im,jfirst:jlast,km)
real(kind=r8) :: mfy(im,jfirst:jlast+1,km)
real(kind=r8) :: mfy_ad(im,jfirst:jlast+1,km)
integer :: nq
real(kind=r8) :: q(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng,km,nq)
real(kind=r8) :: rcap
real(kind=r8) :: sine(jm)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_ad(im,jfirst:jlast,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a2(im,jfirst:jlast)
real(kind=r8) :: a2_ad(im,jfirst:jlast)
real(kind=r8) :: cmax
real(kind=r8) :: cmax_ad
real(kind=r8) :: cy_global
real(kind=r8) :: cy_global_ad
real(kind=r8) :: cyh(im,jfirst:jlast+1,km)
real(kind=r8) :: cymax(km)
real(kind=r8) :: cymax_ad(km)
real(kind=r8) :: dp2(im,jfirst:jlast,km)
real(kind=r8) :: dp2_ad(im,jfirst:jlast,km)
logical :: ffsl(jm,km)
real(kind=r8) :: frac
real(kind=r8) :: frac_ad
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fxh_ad(im,1+jlast-jfirst)
real(kind=r8) :: fxi_ad(im,1+jlast-jfirst)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fyh_ad(im,1+1+jlast-jfirst)
real(kind=r8) :: fyi_ad(im,1+1+jlast-jfirst)
integer :: i
integer :: iq
integer :: it
integer :: j
integer :: jn1g1
integer :: jn2g0
integer :: jn2gd
integer :: js2g0
integer :: js2gd
integer :: k
real(kind=r8) :: mfxh(im,jfirst:jlast,km)
integer :: nsplt
real(kind=r8) :: sum1
real(kind=r8) :: sum1_ad
real(kind=r8) :: sum2
real(kind=r8) :: sum2_ad
real(kind=r8) :: trac2d_tape_cx_1h(im,1+jlast+ng-(jfirst-ng),km,1)
real(kind=r8) :: trac2d_tape_cy_2h(im,1+1+jlast-jfirst,km,1)
real(kind=r8), allocatable :: trac2d_tape_cymax_4h(:,:)
real(kind=r8) :: trac2d_tape_flx_5h(im,1+jlast-jfirst,km,1)
real(kind=r8) :: trac2d_tape_mfy_3h(im,1+1+jlast-jfirst,km,1)
real(kind=r8) :: trac2d_tape_ns_dp1_1h(im,1+jlast-jfirst,km,5)
real(kind=r8) :: trac2d_tape_ns_q_2h(im,1+jlast+ng-(jfirst-ng),km,nq,5)
integer :: trac2d_tape_rec
integer :: trac2d_tape_trac2d

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
mfxh(:,:,:) = mfx(:,:,:)
cyh(:,:,:) = cy(:,:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a2_ad(:,:) = 0.d0
cmax_ad = 0.d0
cy_global_ad = 0.d0
cymax_ad(:) = 0.d0
dp2_ad(:,:,:) = 0.d0
frac_ad = 0.d0
fxh_ad(:,:) = 0.d0
fxi_ad(:,:) = 0.d0
fyh_ad(:,:) = 0.d0
fyi_ad(:,:) = 0.d0
sum1_ad = 0.d0
sum2_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
!----------------------------------------------
! OPEN TAPE trac2d_tape
!----------------------------------------------
trac2d_tape_trac2d = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
trac2d_tape_rec = 0
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
jn1g1 = min(jm,jlast+1)
js2gd = max(2,jfirst-ng)
jn2gd = min(jm-1,jlast+ng)
#ifdef USE_OPENMP
!$omp parallel do private(cmax,i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  cymax(k) = 0.
  do j = js2g0, jlast
    cmax = 0.
    do i = 1, im
      cmax = max(abs(cy(i,j,k)),cmax)
    end do
    cymax(k) = max(cymax(k),cmax*(1.+sine(j)**16))
  end do
end do
trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1) = cx
trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1) = cy
trac2d_tape_mfy_3h(:,:,:,trac2d_tape_rec+1) = mfy
if ( .not. allocated(trac2d_tape_cymax_4h)) then
  allocate( trac2d_tape_cymax_4h(1:km,trac2d_tape_trac2d) )
endif
trac2d_tape_cymax_4h(:,trac2d_tape_rec+1) = cymax
cy_global = cymax(1)
if (km .ne. 1) then
  do k = 2, km
    cy_global = max(cymax(k),cy_global)
  end do
endif
nsplt = int(1.+cy_global)
frac = 1./float(nsplt)
do k = 1, km
  if (nsplt .ne. 1) then
    do j = js2gd, jn2gd
      do i = 1, im
        cx(i,j,k) = cx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        mfx(i,j,k) = mfx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn1g1
      do i = 1, im
        cy(i,j,k) = cy(i,j,k)*frac
        mfy(i,j,k) = mfy(i,j,k)*frac
      end do
    end do
  endif
  do j = js2g0, jn2g0
    do i = 1, im
      if (cy(i,j,k)*cy(i,j+1,k) .gt. 0.) then
        if (cy(i,j,k) .gt. 0.) then
          va(i,j,k) = cy(i,j,k)
        else
          va(i,j,k) = cy(i,j+1,k)
        endif
      else
        va(i,j,k) = 0.
      endif
    end do
  end do
  do j = js2gd, jn2gd
    ffsl(j,k) =  .false. 
    do i = 1, im
      if (abs(cx(i,j,k)) .gt. 1.) then
        ffsl(j,k) =  .true. 
        exit
      endif
    end do
  end do
  do j = js2g0, jn2g0
    if (ffsl(j,k)) then
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)/sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))
      end do
    else
      do i = 1, im
        flx(i,j,k) = mfx(i,j,k)
      end do
    endif
  end do
end do
trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1) = flx
do it = 1, nsplt-1
  trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q
#ifdef USE_OPENMP
  !$omp parallel do private(a2,fx,fy,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy( q(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp,acosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
    end do
    if (it .ne. nsplt) then
      do j = jfirst, jlast
        do i = 1, im
          dp1(i,j,k) = dp2(i,j,k)
        end do
      end do
    endif
  end do
end do
it = nsplt
trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt) = dp1
trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt) = q

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
cymax = trac2d_tape_cymax_4h(:,trac2d_tape_rec+1)
cy_global = cymax(1)
flx = trac2d_tape_flx_5h(:,:,:,trac2d_tape_rec+1)
do it = nsplt, 1, -1
  dp1 = trac2d_tape_ns_dp1_1h(:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k,sum1,sum2)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = js2g0, jn2g0
      do i = 1, im-1
        dp2(i,j,k) = dp1(i,j,k)+mfx(i,j,k)-mfx(i+1,j,k)+(mfy(i,j,k)-mfy(i,j+1,k))*acosp(j)
      end do
      dp2(im,j,k) = dp1(im,j,k)+mfx(im,j,k)-mfx(1,j,k)+(mfy(im,j,k)-mfy(im,j+1,k))*acosp(j)
    end do
    if (jfirst .eq. 1) then
      sum1 = 0.
      do i = 1, im
        sum1 = sum1+mfy(i,2,k)
      end do
      sum1 = -(sum1*rcap)
      do i = 1, im
        dp2(i,1,k) = dp1(i,1,k)+sum1
      end do
    endif
    if (jlast .eq. jm) then
      sum2 = 0.
      do i = 1, im
        sum2 = sum2+mfy(i,jm,k)
      end do
      sum2 = sum2*rcap
      do i = 1, im
        dp2(i,jm,k) = dp1(i,jm,k)+sum2
      end do
    endif
  end do
  q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
#ifdef USE_OPENMP
  !$omp parallel do shared(acap,acosp,cosp,cx,cx_ad,cy,cy_ad,dp1,dp1_ad,dp2,dp2_ad,ffsl,fill,flx,flx_ad,im,iord,it,jfirst,jlast,jm,&
!$omp& jord,km,mfy,mfy_ad,ng,nq,nsplt,q,q_ae,rcap,va,va_ad) private(a2,a2_ad,fx,fxi_ad,fy,fyi_ad,i,iq,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    a2_ad(:,:) = 0.d0
#ifdef USE_OPENMP
    fxi_ad(:,:) = 0.d0
    fyi_ad(:,:) = 0.d0
#endif /* ! USE_OPENMP */
    if (it .ne. nsplt) then
      do j = jfirst, jlast
        do i = 1, im
          dp2_ad(i,j,k) = dp2_ad(i,j,k)+dp1_ad(i,j,k)
          dp1_ad(i,j,k) = 0.d0
        end do
      end do
    endif
    do iq = 1, nq
      call tp2c( a2,va(1,jfirst,k),q(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cy(1,jfirst,k),im,jm,iord,jord,ng,fx,fy,ffsl(1,k),rcap,&
&acosp,flx(1,jfirst,k),mfy(1,jfirst,k),cosp,1,jfirst,jlast )
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy( q(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp,acosp )
      endif
      do j = jfirst, jlast
        do i = 1, im
          dp2_ad(i,j,k) = dp2_ad(i,j,k)-q_ae(i,j,k,iq)*(q(i,j,k,iq)/(dp2(i,j,k)*dp2(i,j,k)))
          q_ae(i,j,k,iq) = q_ae(i,j,k,iq)/dp2(i,j,k)
        end do
      end do
!AOO      q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      do j = jfirst, jlast
        do i = 1, im
          q(i,j,k,iq) = q(i,j,k,iq)*dp1(i,j,k)+a2(i,j)
        end do
      end do
      if (fill) then
        call fillxy_ad( q(1,jfirst,k,iq),q_ae(1,jfirst,k,iq),im,jm,jfirst,jlast,acap,cosp )
      endif
!AOO      q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      do j = jfirst, jlast
        do i = 1, im
          a2_ad(i,j) = a2_ad(i,j)+q_ae(i,j,k,iq)
          dp1_ad(i,j,k) = dp1_ad(i,j,k)+q_ae(i,j,k,iq)*q(i,j,k,iq)
          q_ae(i,j,k,iq) = q_ae(i,j,k,iq)*dp1(i,j,k)
        end do
      end do
!AOO      q = trac2d_tape_ns_q_2h(:,:,:,:,it+trac2d_tape_rec*nsplt)
      q(:,:,k,iq) = trac2d_tape_ns_q_2h(:,:,k,iq,it+trac2d_tape_rec*nsplt)
      call tp2c_ad( a2_ad,va(1,jfirst,k),va_ad(1,jfirst,k),q(1,jfirst-ng,k,iq),q_ae(1,jfirst-ng,k,iq),cx(1,jfirst-ng,k),cx_ad(1,&
&jfirst-ng,k),cy(1,jfirst,k),cy_ad(1,jfirst,k),im,jm,iord,jord,ng,fx,fxi_ad,fy,fyi_ad,ffsl(1,k),rcap,acosp,flx(1,jfirst,k),&
&flx_ad(1,jfirst,k),mfy(1,jfirst,k),mfy_ad(1,jfirst,k),cosp,1,jfirst,jlast )
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do shared(acosp,dp1_ad,dp2_ad,im,jfirst,jlast,jm,jn2g0,js2g0,km,mfx_ad,mfy_ad,rcap) private(i,j,k,sum1_ad,sum2_ad)
#endif /* ! USE_OPENMP */
  do k = 1, km
    sum1_ad = 0.d0
    sum2_ad = 0.d0
    if (jlast .eq. jm) then
      do i = 1, im
        dp1_ad(i,jm,k) = dp1_ad(i,jm,k)+dp2_ad(i,jm,k)
        sum2_ad = sum2_ad+dp2_ad(i,jm,k)
        dp2_ad(i,jm,k) = 0.d0
      end do
      sum2_ad = sum2_ad*rcap
      do i = 1, im
        mfy_ad(i,jm,k) = mfy_ad(i,jm,k)+sum2_ad
      end do
      sum2_ad = 0.d0
    endif
    if (jfirst .eq. 1) then
      do i = 1, im
        dp1_ad(i,1,k) = dp1_ad(i,1,k)+dp2_ad(i,1,k)
        sum1_ad = sum1_ad+dp2_ad(i,1,k)
        dp2_ad(i,1,k) = 0.d0
      end do
      sum1_ad = -(sum1_ad*rcap)
      do i = 1, im
        mfy_ad(i,2,k) = mfy_ad(i,2,k)+sum1_ad
      end do
      sum1_ad = 0.d0
    endif
    do j = js2g0, jn2g0
      dp1_ad(im,j,k) = dp1_ad(im,j,k)+dp2_ad(im,j,k)
      mfx_ad(im,j,k) = mfx_ad(im,j,k)+dp2_ad(im,j,k)
      mfx_ad(1,j,k) = mfx_ad(1,j,k)-dp2_ad(im,j,k)
      mfy_ad(im,j+1,k) = mfy_ad(im,j+1,k)-dp2_ad(im,j,k)*acosp(j)
      mfy_ad(im,j,k) = mfy_ad(im,j,k)+dp2_ad(im,j,k)*acosp(j)
      dp2_ad(im,j,k) = 0.d0
      do i = 1, im-1
        dp1_ad(i,j,k) = dp1_ad(i,j,k)+dp2_ad(i,j,k)
        mfx_ad(i+1,j,k) = mfx_ad(i+1,j,k)-dp2_ad(i,j,k)
        mfx_ad(i,j,k) = mfx_ad(i,j,k)+dp2_ad(i,j,k)
        mfy_ad(i,j+1,k) = mfy_ad(i,j+1,k)-dp2_ad(i,j,k)*acosp(j)
        mfy_ad(i,j,k) = mfy_ad(i,j,k)+dp2_ad(i,j,k)*acosp(j)
        dp2_ad(i,j,k) = 0.d0
      end do
    end do
  end do
end do
mfx(:,:,:) = mfxh(:,:,:)
cx = trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1)
cy = trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1)
mfy = trac2d_tape_mfy_3h(:,:,:,trac2d_tape_rec+1)
do k = 1, km
  if (nsplt .ne. 1) then
    do j = js2gd, jn2gd
      do i = 1, im
        cx(i,j,k) = cx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        mfx(i,j,k) = mfx(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn1g1
      do i = 1, im
        cy(i,j,k) = cy(i,j,k)*frac
      end do
    end do
  endif
  do j = js2gd, jn2gd
    ffsl(j,k) =  .false. 
    do i = 1, im
      if (abs(cx(i,j,k)) .gt. 1.) then
        ffsl(j,k) =  .true. 
        exit
      endif
    end do
  end do
  do j = js2g0, jn2g0
    if (ffsl(j,k)) then
      do i = 1, im
        cx_ad(i,j,k) = cx_ad(i,j,k)-flx_ad(i,j,k)*(mfx(i,j,k)*(0.5+sign(0.5d0,abs(cx(i,j,k))-tiny))*sign(1.d0,cx(i,j,k))*sign(1.d0,&
&cx(i,j,k))*sign(1.d0,max(abs(cx(i,j,k)),tiny))/(sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))*sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))))
        mfx_ad(i,j,k) = mfx_ad(i,j,k)+flx_ad(i,j,k)/sign(max(abs(cx(i,j,k)),tiny),cx(i,j,k))
        flx_ad(i,j,k) = 0.d0
      end do
    else
      do i = 1, im
        mfx_ad(i,j,k) = mfx_ad(i,j,k)+flx_ad(i,j,k)
        flx_ad(i,j,k) = 0.d0
      end do
    endif
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      if (cy(i,j,k)*cy(i,j+1,k) .gt. 0.) then
        if (cy(i,j,k) .gt. 0.) then
          cy_ad(i,j,k) = cy_ad(i,j,k)+va_ad(i,j,k)
          va_ad(i,j,k) = 0.d0
        else
          cy_ad(i,j+1,k) = cy_ad(i,j+1,k)+va_ad(i,j,k)
          va_ad(i,j,k) = 0.d0
        endif
      else
        va_ad(i,j,k) = 0.d0
      endif
    end do
  end do
!AOO  mfx(:,:,:) = mfxh(:,:,:)
!AOO  cx = trac2d_tape_cx_1h(:,:,:,trac2d_tape_rec+1)
!AOO  cy = trac2d_tape_cy_2h(:,:,:,trac2d_tape_rec+1)
  mfx(:,:,k) = mfxh(:,:,k)
  cx(:,:,k) = trac2d_tape_cx_1h(:,:,k,trac2d_tape_rec+1)
  cy(:,:,k) = trac2d_tape_cy_2h(:,:,k,trac2d_tape_rec+1)
  if (nsplt .ne. 1) then
    do j = js2g0, jn1g1
      do i = 1, im
        frac_ad = frac_ad+mfy_ad(i,j,k)*mfy(i,j,k)
        mfy_ad(i,j,k) = mfy_ad(i,j,k)*frac
        frac_ad = frac_ad+cy_ad(i,j,k)*cy(i,j,k)
        cy_ad(i,j,k) = cy_ad(i,j,k)*frac
      end do
    end do
    do j = js2g0, jn2g0
      do i = 1, im
        frac_ad = frac_ad+mfx_ad(i,j,k)*mfx(i,j,k)
        mfx_ad(i,j,k) = mfx_ad(i,j,k)*frac
      end do
    end do
    do j = js2gd, jn2gd
      do i = 1, im
        frac_ad = frac_ad+cx_ad(i,j,k)*cx(i,j,k)
        cx_ad(i,j,k) = cx_ad(i,j,k)*frac
      end do
    end do
  endif
end do
frac_ad = 0.d0
if (km .ne. 1) then
  do k = 2, km
    cymax_ad(k) = cymax_ad(k)+cy_global_ad*(0.5+sign(0.5d0,cymax(k)-cy_global))
    cy_global_ad = cy_global_ad*(0.5-sign(0.5d0,cymax(k)-cy_global))
  end do
endif
cymax_ad(1) = cymax_ad(1)+cy_global_ad
cy_global_ad = 0.d0
cy(:,:,:) = cyh(:,:,:)
#ifdef USE_OPENMP
!$omp parallel do shared(cy,cy_ad,cymax,cymax_ad,im,jlast,js2g0,km,sine) private(cmax,cmax_ad,i,j,k)
#endif /* ! USE_OPENMP */
do k = 1, km
  cmax_ad = 0.d0
  cymax(k) = 0.
  do j = js2g0, jlast
    cmax_ad = 0.d0
    cmax = 0.
    do i = 1, im
      cmax = max(abs(cy(i,j,k)),cmax)
    end do
    cmax_ad = cmax_ad+cymax_ad(k)*(0.5-sign(0.5d0,cymax(k)-cmax*(1.+sine(j)**16)))*(1+sine(j)**16)
    cymax_ad(k) = cymax_ad(k)*(0.5+sign(0.5d0,cymax(k)-cmax*(1.+sine(j)**16)))
    cmax = 0.
    do i = 1, im
      cy_ad(i,j,k) = cy_ad(i,j,k)+cmax_ad*(0.5+sign(0.5d0,abs(cy(i,j,k))-cmax))*sign(1.d0,cy(i,j,k))
      cmax_ad = cmax_ad*(0.5-sign(0.5d0,abs(cy(i,j,k))-cmax))
    end do
    cmax_ad = 0.d0
  end do
  cymax_ad(k) = 0.d0
end do

!----------------------------------------------
! CLOSE TAPE trac2d_tape
!----------------------------------------------
if (allocated(trac2d_tape_cymax_4h)) then
  deallocate( trac2d_tape_cymax_4h )
endif


!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine trac2d_ad


#endif /* SPMD */
