#ifdef   SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tpcc_ad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: tpcc1_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc1_tape_dm_2h(:,:)
integer :: tpcc1_tape_tpcc
real(kind=8), allocatable :: tpcc2_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc2_tape_dm_2h(:,:)
integer :: tpcc2_tape_tpcc

end module     tpcc_ad_store


module     tp_core_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_ad( im, c, c_ad, mfx, mfx_ad, p, p_ad, dm, dm_ad, fx, fx_ad, iord, al, al_ad, ar, ar_ad, a6, a6_ad, iuw, iue, &
&ffsl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_ad(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_ad(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_ad(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ad(im)
integer :: iord
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_ad(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: a6h_ad
double precision :: a6i_ad
real(kind=r8) :: a6j(-(im/3):im+im/3)
double precision :: alh_ad
double precision :: ali_ad
double precision :: arh_ad
double precision :: ari_ad
real(kind=r8) :: dmh(-(im/3):im+im/3)
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
real(kind=r8) :: ru_ad
logical :: steep
logical :: c_adEQmfx_ad  ! .true. if c_ad and mfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
c_adEQmfx_ad = loc(c_ad) == loc(mfx_ad)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmh(:) = dm(:)
a6j(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
ru_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx( im,p,al(1),dm )
endif
do i = 1, im-1
  ar(i) = al(i+1)
end do
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh( im,ar(1),al(1),p(1),a6(1),dm(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm( dm(1),a6(1),ar(1),al(1),p(1),im,lmt )
endif
if (ffsl) then
  do i = iuw, 0
    al(i) = al(im+i)
    ar(i) = ar(im+i)
    a6(i) = a6(im+i)
  end do
  do i = im+1, iue
    al(i) = al(i-im)
    ar(i) = ar(i-im)
    a6(i) = a6(i-im)
  end do
  do i = 1, im
    ru_ad = 0.d0
    iu = c(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      a6_ad(itmp) = a6_ad(itmp)+0.5*fx_ad(i)*ru*ru*(1.-r23*ru)
      al_ad(itmp) = al_ad(itmp)+0.5*fx_ad(i)*ru*ru
      ar_ad(itmp) = ar_ad(itmp)+fx_ad(i)*ru*(1+(-0.5)*ru)
      ru_ad = ru_ad+fx_ad(i)*(ru*((-(0.5*ru*a6(itmp)*r23))+0.5*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))+ar(itmp)+0.5*ru*(al(itmp)-&
&ar(itmp)+a6(itmp)*(1.-r23*ru)))
      fx_ad(i) = 0.d0
    else
      itmp = i-iu
      a6_ad(itmp) = a6_ad(itmp)-0.5*fx_ad(i)*ru*ru*(1+r23*ru)
      al_ad(itmp) = al_ad(itmp)+fx_ad(i)*ru*(1-(-0.5)*ru)
      ar_ad(itmp) = ar_ad(itmp)-0.5*fx_ad(i)*ru*ru
      ru_ad = ru_ad+fx_ad(i)*((-(ru*(0.5*ru*a6(itmp)*r23+0.5*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))))+al(itmp)-0.5*ru*(ar(itmp)-&
&al(itmp)+a6(itmp)*(1.+r23*ru)))
      fx_ad(i) = 0.d0
    endif
    c_ad(i) = c_ad(i)+ru_ad
    ru_ad = 0.d0
  end do
  do i = iue, im+1, -1
    a6h_ad = a6_ad(i)
    a6_ad(i) = 0.d0
    a6_ad(i-im) = a6_ad(i-im)+a6h_ad
    arh_ad = ar_ad(i)
    ar_ad(i) = 0.d0
    ar_ad(i-im) = ar_ad(i-im)+arh_ad
    alh_ad = al_ad(i)
    al_ad(i) = 0.d0
    al_ad(i-im) = al_ad(i-im)+alh_ad
  end do
  do i = 0, iuw, -1
    a6i_ad = a6_ad(i)
    a6_ad(i) = 0.d0
    a6_ad(im+i) = a6_ad(im+i)+a6i_ad
    ari_ad = ar_ad(i)
    ar_ad(i) = 0.d0
    ar_ad(im+i) = ar_ad(im+i)+ari_ad
    ali_ad = al_ad(i)
    al_ad(i) = 0.d0
    al_ad(im+i) = al_ad(im+i)+ali_ad
  end do
else
  al(0) = al(im)
  ar(0) = ar(im)
  a6(0) = a6(im)
  do i = 1, im
    if (c(i) .gt. 0.) then
      fx(i) = ar(i-1)+0.5*c(i)*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i)))
    else
      fx(i) = al(i)-0.5*c(i)*(ar(i)-al(i)+a6(i)*(1.+r23*c(i)))
    endif
    if(c_adEQmfx_ad) then
      c_ad(i) = c_ad(i)+fx_ad(i)*fx(i)
    else
      mfx_ad(i) = mfx_ad(i)+fx_ad(i)*fx(i)
    endif
    fx_ad(i) = fx_ad(i)*mfx(i)
    if (c(i) .gt. 0.) then
      a6_ad(i-1) = a6_ad(i-1)+0.5*fx_ad(i)*c(i)*(1.-r23*c(i))
      al_ad(i-1) = al_ad(i-1)+0.5*fx_ad(i)*c(i)
      ar_ad(i-1) = ar_ad(i-1)+fx_ad(i)*(1+(-0.5)*c(i))
      c_ad(i) = c_ad(i)+fx_ad(i)*((-(0.5*c(i)*a6(i-1)*r23))+0.5*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i))))
      fx_ad(i) = 0.d0
    else
      a6_ad(i) = a6_ad(i)-0.5*fx_ad(i)*c(i)*(1+r23*c(i))
      al_ad(i) = al_ad(i)+fx_ad(i)*(1-(-0.5)*c(i))
      ar_ad(i) = ar_ad(i)-0.5*fx_ad(i)*c(i)
      c_ad(i) = c_ad(i)-fx_ad(i)*(0.5*c(i)*a6(i)*r23+0.5*(ar(i)-al(i)+a6(i)*(1.+r23*c(i))))
      fx_ad(i) = 0.d0
    endif
  end do
  a6_ad(im) = a6_ad(im)+a6_ad(0)
  a6_ad(0) = 0.d0
  ar_ad(im) = ar_ad(im)+ar_ad(0)
  ar_ad(0) = 0.d0
  al_ad(im) = al_ad(im)+al_ad(0)
  al_ad(0) = 0.d0
endif
a6(:) = a6j(:)
dm(:) = dmh(:)
do i = 1, im
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx( im,p,al(1),dm )
endif
do i = 1, im-1
  ar(i) = al(i+1)
end do
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh_ad( im,ar(1),ar_ad(1),al(1),al_ad(1),p(1),p_ad(1),a6(1),a6_ad(1),dm(1),dm_ad(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  call lmppm_ad( dm(1),dm_ad(1),a6(1),a6_ad(1),ar(1),ar_ad(1),al(1),al_ad(1),p(1),p_ad(1),im,lmt )
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      al_ad(i) = al_ad(i)-3*a6_ad(i)
      ar_ad(i) = ar_ad(i)-3*a6_ad(i)
      p_ad(i) = p_ad(i)+6*a6_ad(i)
      a6_ad(i) = 0.d0
    end do
  endif
endif
al_ad(1) = al_ad(1)+ar_ad(im)
ar_ad(im) = 0.d0
do i = 1, im-1
  al_ad(i+1) = al_ad(i+1)+ar_ad(i)
  ar_ad(i) = 0.d0
end do
dm(:) = dmh(:)
if (steep) then
  call steepx_ad( im,p,p_ad,al_ad(1),dm,dm_ad )
endif
do i = 1, im
  dm_ad(i-1) = dm_ad(i-1)+al_ad(i)*r3
  dm_ad(i) = dm_ad(i)-al_ad(i)*r3
  p_ad(i-1) = p_ad(i-1)+0.5*al_ad(i)
  p_ad(i) = p_ad(i)+0.5*al_ad(i)
  al_ad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine fxppm_ad


subroutine fyppm_ad( c, c_ad, q, q_ae, dm, dm_ad, flux_ad, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_ad(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux_ad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_ad(im,jfirst-1:jlast+1)
real(kind=r8) :: a6h(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_ad(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_ad(im,jfirst-1:jlast+1)
double precision :: arh_ad
double precision :: ari_ad
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
a6h(:,:) = a6(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_ad(:,:) = 0.d0
al_ad(:,:) = 0.d0
ar_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = al(i+imh,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = ar(i+imh,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = -al(i+imh,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = -ar(i+imh,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
call lmppm( dm(1,js1g1),a6(1,js1g1),ar(1,js1g1),al(1,js1g1),q(1,js1g1),help_h,lmt )
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      a6_ad(i,j-1) = a6_ad(i,j-1)+0.5*flux_ad(i,j)*c(i,j)*(1.-r23*c(i,j))
      al_ad(i,j-1) = al_ad(i,j-1)+0.5*flux_ad(i,j)*c(i,j)
      ar_ad(i,j-1) = ar_ad(i,j-1)+flux_ad(i,j)*(1+(-0.5)*c(i,j))
      c_ad(i,j) = c_ad(i,j)+flux_ad(i,j)*((-(0.5*c(i,j)*a6(i,j-1)*r23))+0.5*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j))))
      flux_ad(i,j) = 0.d0
    else
      a6_ad(i,j) = a6_ad(i,j)-0.5*flux_ad(i,j)*c(i,j)*(1+r23*c(i,j))
      al_ad(i,j) = al_ad(i,j)+flux_ad(i,j)*(1-(-0.5)*c(i,j))
      ar_ad(i,j) = ar_ad(i,j)-0.5*flux_ad(i,j)*c(i,j)
      c_ad(i,j) = c_ad(i,j)-flux_ad(i,j)*(0.5*c(i,j)*a6(i,j)*r23+0.5*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j))))
      flux_ad(i,j) = 0.d0
    endif
  end do
end do
a6(:,:) = a6h(:,:)
do j = js2g1, jn1g2
  do i = 1, im
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = al(i+imh,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = ar(i+imh,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = -al(i+imh,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = -ar(i+imh,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
call lmppm_ad( dm(1,js1g1),dm_ad(1,js1g1),a6(1,js1g1),a6_ad(1,js1g1),ar(1,js1g1),ar_ad(1,js1g1),al(1,js1g1),al_ad(1,js1g1),q(1,&
&js1g1),q_ae(1,js1g1),help_h,lmt )
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      al_ad(i,j) = al_ad(i,j)-3*a6_ad(i,j)
      ar_ad(i,j) = ar_ad(i,j)-3*a6_ad(i,j)
      q_ae(i,j) = q_ae(i,j)+6*a6_ad(i,j)
      a6_ad(i,j) = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_ad(i,jm1) = ar_ad(i,jm1)+ar_ad(i+imh,jm)
      ar_ad(i+imh,jm) = 0.d0
      arh_ad = ar_ad(i,jm)
      ar_ad(i,jm) = 0.d0
      ar_ad(i+imh,jm1) = ar_ad(i+imh,jm1)+arh_ad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ad(i,2) = al_ad(i,2)+al_ad(i+imh,1)
      al_ad(i+imh,1) = 0.d0
      al_ad(i+imh,2) = al_ad(i+imh,2)+al_ad(i,1)
      al_ad(i,1) = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_ad(i,jm1) = ar_ad(i,jm1)-ar_ad(i+imh,jm)
      ar_ad(i+imh,jm) = 0.d0
      ari_ad = ar_ad(i,jm)
      ar_ad(i,jm) = 0.d0
      ar_ad(i+imh,jm1) = ar_ad(i+imh,jm1)-ari_ad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ad(i,2) = al_ad(i,2)-al_ad(i+imh,1)
      al_ad(i+imh,1) = 0.d0
      al_ad(i+imh,2) = al_ad(i+imh,2)-al_ad(i,1)
      al_ad(i,1) = 0.d0
    end do
  endif
endif
do j = js1g1, jn2g1
  do i = 1, im
    al_ad(i,j+1) = al_ad(i,j+1)+ar_ad(i,j)
    ar_ad(i,j) = 0.d0
  end do
end do
do j = js2g1, jn1g2
  do i = 1, im
    dm_ad(i,j-1) = dm_ad(i,j-1)+al_ad(i,j)*r3
    dm_ad(i,j) = dm_ad(i,j)-al_ad(i,j)*r3
    q_ae(i,j-1) = q_ae(i,j-1)+0.5*al_ad(i,j)
    q_ae(i,j) = q_ae(i,j)+0.5*al_ad(i,j)
    al_ad(i,j) = 0.d0
  end do
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine fyppm_ad


subroutine huynh_ad( im, ar, ar_ad, al, al_ad, p, p_ad, d2, d2_ad, d1, d1_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_ad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ad(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_ad(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_ad(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_ad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh(im)
real(kind=r8) :: arh(im)
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_ad
real(kind=r8) :: pmax
real(kind=r8) :: pmax_ad
real(kind=r8) :: pmin
real(kind=r8) :: pmin_ad
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
arh(:) = ar(:)
alh(:) = al(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
lac_ad = 0.d0
pmax_ad = 0.d0
pmin_ad = 0.d0
pmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
d1(1) = p(1)-p(im)
do i = 2, im
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2(i) = d1(i+1)-d1(i)
end do
d2(im) = d1(1)-d1(im)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
ar(1) = min(pmax,max(ar(1),pmin))
do i = 1, im-1
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp = p(im)-2.*d1(1)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin = min(p(im),pmp,lac)
pmax = max(p(im),pmp,lac)
do i = 1, im
  al_ad(i) = al_ad(i)-3*d2_ad(i)
  ar_ad(i) = ar_ad(i)-3*d2_ad(i)
  p_ad(i) = p_ad(i)+6*d2_ad(i)
  d2_ad(i) = 0.d0
end do
pmax_ad = pmax_ad+al_ad(im)*(0.5+sign(0.5d0,max(al(im),pmin)-pmax))
pmin_ad = pmin_ad+al_ad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al_ad(im) = al_ad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))
p_ad(im) = p_ad(im)+pmax_ad*(0.5+sign(0.5d0,p(im)-pmp))
pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(im)-pmp))
pmax_ad = 0.d0
p_ad(im) = p_ad(im)+pmin_ad*(0.5+sign(0.5d0,pmp-p(im)))
pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(im)))
pmin_ad = 0.d0
d1_ad(1) = d1_ad(1)-0.5*lac_ad
d2_ad(1) = d2_ad(1)+1.5*lac_ad
p_ad(im) = p_ad(im)+lac_ad
lac_ad = 0.d0
d1_ad(1) = d1_ad(1)-2*pmp_ad
p_ad(im) = p_ad(im)+pmp_ad
pmp_ad = 0.d0
al(:) = alh(:)
do i = 1, im-1
  lac_ad = 0.d0
  pmax_ad = 0.d0
  pmin_ad = 0.d0
  pmp_ad = 0.d0
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_ad = pmax_ad+al_ad(i)*(0.5+sign(0.5d0,max(al(i),pmin)-pmax))
  pmin_ad = pmin_ad+al_ad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al_ad(i) = al_ad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))
  p_ad(i) = p_ad(i)+pmax_ad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_ad = 0.d0
  p_ad(i) = p_ad(i)+pmin_ad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_ad = 0.d0
  d1_ad(i+1) = d1_ad(i+1)-0.5*lac_ad
  d2_ad(i+1) = d2_ad(i+1)+1.5*lac_ad
  p_ad(i) = p_ad(i)+lac_ad
  lac_ad = 0.d0
  d1_ad(i+1) = d1_ad(i+1)-2*pmp_ad
  p_ad(i) = p_ad(i)+pmp_ad
  pmp_ad = 0.d0
end do
do i = 2, im
  lac_ad = 0.d0
  pmax_ad = 0.d0
  pmin_ad = 0.d0
  pmp_ad = 0.d0
  pmp = p(i)+2.*d1(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_ad = pmax_ad+ar_ad(i)*(0.5+sign(0.5d0,max(ar(i),pmin)-pmax))
  pmin_ad = pmin_ad+ar_ad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar_ad(i) = ar_ad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))
  p_ad(i) = p_ad(i)+pmax_ad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_ad = 0.d0
  p_ad(i) = p_ad(i)+pmin_ad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_ad = 0.d0
  d1_ad(i) = d1_ad(i)+0.5*lac_ad
  d2_ad(i-1) = d2_ad(i-1)+1.5*lac_ad
  p_ad(i) = p_ad(i)+lac_ad
  lac_ad = 0.d0
  d1_ad(i) = d1_ad(i)+2*pmp_ad
  p_ad(i) = p_ad(i)+pmp_ad
  pmp_ad = 0.d0
end do
ar(:) = arh(:)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
pmax_ad = pmax_ad+ar_ad(1)*(0.5+sign(0.5d0,max(ar(1),pmin)-pmax))
pmin_ad = pmin_ad+ar_ad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar_ad(1) = ar_ad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))
pmp = p(1)+2.*d1(1)
p_ad(1) = p_ad(1)+pmax_ad*(0.5+sign(0.5d0,p(1)-pmp))
pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(1)-pmp))
pmax_ad = 0.d0
pmp = p(1)+2.*d1(1)
p_ad(1) = p_ad(1)+pmin_ad*(0.5+sign(0.5d0,pmp-p(1)))
pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(1)))
pmin_ad = 0.d0
d1_ad(1) = d1_ad(1)+0.5*lac_ad
d2_ad(im) = d2_ad(im)+1.5*lac_ad
p_ad(1) = p_ad(1)+lac_ad
lac_ad = 0.d0
d1_ad(1) = d1_ad(1)+2*pmp_ad
p_ad(1) = p_ad(1)+pmp_ad
pmp_ad = 0.d0
d1_ad(im) = d1_ad(im)-d2_ad(im)
d1_ad(1) = d1_ad(1)+d2_ad(im)
d2_ad(im) = 0.d0
do i = 1, im-1
  d1_ad(i+1) = d1_ad(i+1)+d2_ad(i)
  d1_ad(i) = d1_ad(i)-d2_ad(i)
  d2_ad(i) = 0.d0
end do
do i = 2, im
  p_ad(i-1) = p_ad(i-1)-d1_ad(i)
  p_ad(i) = p_ad(i)+d1_ad(i)
  d1_ad(i) = 0.d0
end do
p_ad(im) = p_ad(im)-d1_ad(1)
p_ad(1) = p_ad(1)+d1_ad(1)
d1_ad(1) = 0.d0

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine huynh_ad


subroutine lmppm_ad( dm, dm_ad, a6, a6_ad, ar, ar_ad, al, al_ad, p, p_ad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_ad(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_ad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ad(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ad(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_ad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ad
real(kind=r8) :: da1
real(kind=r8) :: da1_ad
real(kind=r8) :: da2
real(kind=r8) :: da2_ad
real(kind=r8) :: dl_ad
real(kind=r8) :: dr_ad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ad
integer :: i

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_ad = 0.d0
da1_ad = 0.d0
da2_ad = 0.d0
dl_ad = 0.d0
dr_ad = 0.d0
fmin_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    a6da_ad = 0.d0
    da1_ad = 0.d0
    da2_ad = 0.d0
    if (dm(i) .eq. 0.) then
      a6_ad(i) = 0.d0
      p_ad(i) = p_ad(i)+al_ad(i)
      al_ad(i) = 0.d0
      p_ad(i) = p_ad(i)+ar_ad(i)
      ar_ad(i) = 0.d0
    else
      da1 = ar(i)-al(i)
      da2 = da1**2
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_ad(i) = a6_ad(i)-ar_ad(i)
        al_ad(i) = al_ad(i)+ar_ad(i)
        ar_ad(i) = 0.d0
        al_ad(i) = al_ad(i)+3*a6_ad(i)
        p_ad(i) = p_ad(i)-3*a6_ad(i)
        a6_ad(i) = 0.d0
      else if (a6da .gt. da2) then
        a6_ad(i) = a6_ad(i)-al_ad(i)
        ar_ad(i) = ar_ad(i)+al_ad(i)
        al_ad(i) = 0.d0
        ar_ad(i) = ar_ad(i)+3*a6_ad(i)
        p_ad(i) = p_ad(i)-3*a6_ad(i)
        a6_ad(i) = 0.d0
      endif
      a6_ad(i) = a6_ad(i)+a6da_ad*da1
      da1_ad = da1_ad+a6da_ad*a6(i)
      a6da_ad = 0.d0
      da1_ad = da1_ad+2*da2_ad*da1
      da2_ad = 0.d0
      al_ad(i) = al_ad(i)-da1_ad
      ar_ad(i) = ar_ad(i)+da1_ad
      da1_ad = 0.d0
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_ad = 0.d0
      dl_ad = 0.d0
      dr_ad = 0.d0
      da1 = dm(i)+dm(i)
      dl_ad = dl_ad+3*a6_ad(i)
      dr_ad = dr_ad-3*a6_ad(i)
      a6_ad(i) = 0.d0
      dl_ad = dl_ad-al_ad(i)
      p_ad(i) = p_ad(i)+al_ad(i)
      al_ad(i) = 0.d0
      dr_ad = dr_ad+ar_ad(i)
      p_ad(i) = p_ad(i)+ar_ad(i)
      ar_ad(i) = 0.d0
      ar_ad(i) = ar_ad(i)+dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      da1_ad = da1_ad+dr_ad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
      p_ad(i) = p_ad(i)-dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      dr_ad = 0.d0
      al_ad(i) = al_ad(i)+dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      da1_ad = da1_ad+dl_ad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
      p_ad(i) = p_ad(i)-dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      dl_ad = 0.d0
      dm_ad(i) = dm_ad(i)+2*da1_ad
      da1_ad = 0.d0
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im-1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar(i) = p(i)
              al(i) = p(i)
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6(i) = 3.*(al(i)-p(i))
              ar(i) = al(i)-a6(i)
            else
              a6(i) = 3.*(ar(i)-p(i))
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
      do i = im, 1, -1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              a6_ad(i) = 0.d0
              p_ad(i) = p_ad(i)+al_ad(i)
              al_ad(i) = 0.d0
              p_ad(i) = p_ad(i)+ar_ad(i)
              ar_ad(i) = 0.d0
            else if (ar(i) .gt. al(i)) then
              a6_ad(i) = a6_ad(i)-ar_ad(i)
              al_ad(i) = al_ad(i)+ar_ad(i)
              ar_ad(i) = 0.d0
              al_ad(i) = al_ad(i)+3*a6_ad(i)
              p_ad(i) = p_ad(i)-3*a6_ad(i)
              a6_ad(i) = 0.d0
            else
              a6_ad(i) = a6_ad(i)-al_ad(i)
              ar_ad(i) = ar_ad(i)+al_ad(i)
              al_ad(i) = 0.d0
              ar_ad(i) = ar_ad(i)+3*a6_ad(i)
              p_ad(i) = p_ad(i)-3*a6_ad(i)
              a6_ad(i) = 0.d0
            endif
          endif
          a6_ad(i) = a6_ad(i)+fmin_ad*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)
          al_ad(i) = al_ad(i)+fmin_ad*((-0.5)*(ar(i)-al(i))/a6(i))
          ar_ad(i) = ar_ad(i)+fmin_ad*(0.5*(ar(i)-al(i))/a6(i))
          p_ad(i) = p_ad(i)+fmin_ad
          fmin_ad = 0.d0
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_ad = 0.d0
          dl_ad = 0.d0
          dr_ad = 0.d0
          da1 = 4.*dm(i)
          dl_ad = dl_ad+3*a6_ad(i)
          dr_ad = dr_ad-3*a6_ad(i)
          a6_ad(i) = 0.d0
          dl_ad = dl_ad-al_ad(i)
          p_ad(i) = p_ad(i)+al_ad(i)
          al_ad(i) = 0.d0
          dr_ad = dr_ad+ar_ad(i)
          p_ad(i) = p_ad(i)+ar_ad(i)
          ar_ad(i) = 0.d0
          ar_ad(i) = ar_ad(i)+dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          da1_ad = da1_ad+dr_ad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
          p_ad(i) = p_ad(i)-dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          dr_ad = 0.d0
          al_ad(i) = al_ad(i)+dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          da1_ad = da1_ad+dl_ad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
          p_ad(i) = p_ad(i)-dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          dl_ad = 0.d0
          dm_ad(i) = dm_ad(i)+4*da1_ad
          da1_ad = 0.d0
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_ad


subroutine steepx_ad( im, p, p_ad, al_ad, dm, dm_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al_ad(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb_ad
real(kind=r8) :: ccc_ad
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_ad(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_ad(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_ad(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
bbb_ad = 0.d0
ccc_ad = 0.d0
d2_ad(:) = 0.d0
dh_ad(:) = 0.d0
eta_ad(:) = 0.d0
xxx_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do i = 0, im
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2(i) = dh(i)-dh(i-1)
end do
d2(0) = d2(im)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta(i) = 0.
  endif
end do
eta(0) = eta(im)
do i = 1, im
  bbb_ad = 0.d0
  ccc_ad = 0.d0
  bbb_ad = bbb_ad+al_ad(i)*r3
  ccc_ad = ccc_ad-al_ad(i)*r3
  dh_ad(i-1) = dh_ad(i-1)+0.5*al_ad(i)*(eta(i-1)-eta(i))
  eta_ad(i-1) = eta_ad(i-1)+0.5*al_ad(i)*dh(i-1)
  eta_ad(i) = eta_ad(i)-0.5*al_ad(i)*dh(i-1)
  dm_ad(i) = dm_ad(i)+ccc_ad*(2.*eta(i-1)-eta(i))
  eta_ad(i-1) = eta_ad(i-1)+2*ccc_ad*dm(i)
  eta_ad(i) = eta_ad(i)-ccc_ad*dm(i)
  ccc_ad = 0.d0
  dm_ad(i-1) = dm_ad(i-1)+bbb_ad*(2.*eta(i)-eta(i-1))
  eta_ad(i-1) = eta_ad(i-1)-bbb_ad*dm(i-1)
  eta_ad(i) = eta_ad(i)+2*bbb_ad*dm(i-1)
  bbb_ad = 0.d0
end do
eta_ad(im) = eta_ad(im)+eta_ad(0)
eta_ad(0) = 0.d0
do i = 1, im
  xxx_ad = 0.d0
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    xxx_ad = xxx_ad+eta_ad(i)*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta_ad(i) = 0.d0
    p_ad(i-2) = p_ad(i-2)-xxx_ad*((-0.5)/(p(i+1)-p(i-1)))
    p_ad(i-1) = p_ad(i-1)+xxx_ad*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    p_ad(i+2) = p_ad(i+2)-xxx_ad*(0.5/(p(i+1)-p(i-1)))
    p_ad(i+1) = p_ad(i+1)+xxx_ad*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx_ad = 0.d0
  else
    eta_ad(i) = 0.d0
  endif
end do
d2_ad(1) = d2_ad(1)+d2_ad(im+1)
d2_ad(im+1) = 0.d0
d2_ad(im) = d2_ad(im)+d2_ad(0)
d2_ad(0) = 0.d0
do i = 1, im
  dh_ad(i-1) = dh_ad(i-1)-d2_ad(i)
  dh_ad(i) = dh_ad(i)+d2_ad(i)
  d2_ad(i) = 0.d0
end do
do i = 0, im
  p_ad(i+1) = p_ad(i+1)+dh_ad(i)
  p_ad(i) = p_ad(i)-dh_ad(i)
  dh_ad(i) = 0.d0
end do

end subroutine steepx_ad


subroutine tp2c_ad( dh_ad, va, va_ad, h, h_ad, crx, crx_ad, cry, cry_ad, im, jm, iord, jord, ng, fx, fx_ad, fy, fy_ad, ffsl, rcap, &
&acosp, xfx, xfx_ad, yfx, yfx_ad, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_ad(im,jfirst:jlast+1)
real(kind=r8) :: dh_ad(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ad(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ad(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_ad(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_ad(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_ad(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_ad(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
sum1_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
if (jlast .eq. jm) then
  do i = 1, im
    sum1_ad = sum1_ad+dh_ad(i,jm)
    dh_ad(i,jm) = 0.d0
  end do
  sum1_ad = sum1_ad*rcap
  do i = 1, im
    fy_ad(i,jm) = fy_ad(i,jm)+sum1_ad
  end do
  sum1_ad = 0.d0
endif
if (jfirst .eq. 1) then
  do i = 1, im
    sum1_ad = sum1_ad+dh_ad(i,1)
    dh_ad(i,1) = 0.d0
  end do
  sum1_ad = -(sum1_ad*rcap)
  do i = 1, im
    fy_ad(i,2) = fy_ad(i,2)+sum1_ad
  end do
endif
do j = js2g0, jn2g0
  fx_ad(im,j) = fx_ad(im,j)+dh_ad(im,j)
  fx_ad(1,j) = fx_ad(1,j)-dh_ad(im,j)
  fy_ad(im,j+1) = fy_ad(im,j+1)-dh_ad(im,j)*acosp(j)
  fy_ad(im,j) = fy_ad(im,j)+dh_ad(im,j)*acosp(j)
  dh_ad(im,j) = 0.d0
end do
do j = js2g0, jn2g0
  do i = 1, im-1
    fx_ad(i+1,j) = fx_ad(i+1,j)-dh_ad(i,j)
    fx_ad(i,j) = fx_ad(i,j)+dh_ad(i,j)
    fy_ad(i,j+1) = fy_ad(i,j+1)-dh_ad(i,j)*acosp(j)
    fy_ad(i,j) = fy_ad(i,j)+dh_ad(i,j)*acosp(j)
    dh_ad(i,j) = 0.d0
  end do
end do
call tp2d_ad( va,va_ad,h,h_ad,crx,crx_ad,cry,cry_ad,im,jm,iord,jord,ng,fx,fx_ad,fy,fy_ad,ffsl,xfx,xfx_ad,yfx,yfx_ad,cosp,id,jfirst,&
&jlast )

end subroutine tp2c_ad


subroutine tp2d_ad( va, va_ad, q, q_ae, crx, crx_ad, cry, cry_ad, im, jm, iord, jord, ng, fx, fx_ad, fy, fy_ad, ffsl, xfx, xfx_ad, &
&yfx, yfx_ad, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_ad(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ad(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ad(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_ad(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_ad(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_ad(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_ad(1+im+2*(im/3))
real(kind=r8) :: dmi_ad(1+im+2*(im/3))
real(kind=r8) :: dmj_ad(1+im+2*(im/3))
real(kind=r8) :: dmk_ad(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpj_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpk_ad(1+im+2*(im/3))
real(kind=8), allocatable :: tp2d_tape1_a6_1h(:,:)
real(kind=8), allocatable :: tp2d_tape1_dm_2h(:,:)
integer :: tp2d_tape1_tp2d
real(kind=8), allocatable :: tp2d_tape2_a6_2h(:,:)
real(kind=8), allocatable :: tp2d_tape2_adx_1h(:,:,:)
real(kind=8), allocatable :: tp2d_tape2_dm_3h(:,:)
integer :: tp2d_tape2_tp2d
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_ad(im)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_ad(:) = 0.d0
adx_ad(:,:) = 0.d0
dmh_ad(:) = 0.d0
dmi_ad(:) = 0.d0
dmj_ad(:) = 0.d0
dmk_ad(:) = 0.d0
qtmph_ad(:) = 0.d0
qtmpi_ad(:) = 0.d0
qtmpj_ad(:) = 0.d0
qtmpk_ad(:) = 0.d0
wk1_ad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
!----------------------------------------------
! OPEN TAPE tp2d_tape1
!----------------------------------------------
tp2d_tape1_tp2d = jn2gng-js2gng+1

!----------------------------------------------
! OPEN TAPE tp2d_tape2
!----------------------------------------------
tp2d_tape2_tp2d = jn2g0-js2g0+1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do j = js2gng, jn2gng
  if ( .not. allocated(tp2d_tape1_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_a6_1h)) then
      allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_a6_1h(:,1+j-js2gng) = a6
  if ( .not. allocated(tp2d_tape1_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_dm_2h)) then
      allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_dm_2h(:,1+j-js2gng) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx(i,jm) = q(i,jm)
  end do
endif
if ( .not. allocated(tp2d_tape2_adx_1h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_adx_1h)) then
    allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_adx_1h(:,:,1) = adx
do j = js2g0, jn2g0-1
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_a6_2h)) then
      allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_dm_3h)) then
      allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_dm_3h(:,1+j-js2g0) = dm
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp( im,ffsl(j),fx(1,j),wk1,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,qtmp,al,ar,a6 )
end do
j = jn2g0
if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_dm_3h(:,1+j-js2g0) = dm

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
adx = tp2d_tape2_adx_1h(:,:,1)
do j = jn2g0, js2g0, -1
  a6 = tp2d_tape2_a6_2h(:,1+j-js2g0)
  dm = tp2d_tape2_dm_3h(:,1+j-js2g0)
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_ad( im,ffsl(j),fx(1,j),fx_ad(1,j),wk1,wk1_ad,crx(1,j),crx_ad(1,j),iord,xfx(1,j),xfx_ad(1,j),cosp(j),id,dm,dmj_ad,qtmp,&
&qtmpj_ad,al,ar,a6,a6_ad )
  do i = 1, im
    jp = j-va(i,j)
    q_ae(i,jp+1) = q_ae(i,jp+1)-0.5*wk1_ad(i)*va(i,j)
    q_ae(i,j) = q_ae(i,j)+wk1_ad(i)
    q_ae(i,jp) = q_ae(i,jp)+0.5*wk1_ad(i)*va(i,j)
    va_ad(i,j) = va_ad(i,j)+0.5*wk1_ad(i)*(q(i,jp)-q(i,jp+1))
    wk1_ad(i) = 0.d0
  end do
end do
call ytp_ad( im,jm,fy,fy_ad,adx,adx_ad,cry,cry_ad,yfx,yfx_ad,ng,jord,0,jfirst,jlast )
if (jlast .eq. jm) then
  do i = 1, im
    q_ae(i,jm) = q_ae(i,jm)+adx_ad(i,jm)
    adx_ad(i,jm) = 0.d0
  end do
endif
if (jfirst .eq. 1) then
  do i = 1, im
    q_ae(i,1) = q_ae(i,1)+adx_ad(i,1)
    adx_ad(i,1) = 0.d0
  end do
endif
do j = jn2gng, js2gng, -1
  a6 = tp2d_tape1_a6_1h(:,1+j-js2gng)
  dm = tp2d_tape1_dm_2h(:,1+j-js2gng)
  crx_ad(im,j) = crx_ad(im,j)-0.5*adx_ad(im,j)*q(im,j)
  crx_ad(1,j) = crx_ad(1,j)+0.5*adx_ad(im,j)*q(im,j)
  q_ae(im,j) = q_ae(im,j)+adx_ad(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))
  wk1_ad(im) = wk1_ad(im)+0.5*adx_ad(im,j)
  wk1_ad(1) = wk1_ad(1)-0.5*adx_ad(im,j)
  adx_ad(im,j) = 0.d0
  do i = 1, im-1
    crx_ad(i+1,j) = crx_ad(i+1,j)+0.5*adx_ad(i,j)*q(i,j)
    crx_ad(i,j) = crx_ad(i,j)-0.5*adx_ad(i,j)*q(i,j)
    q_ae(i,j) = q_ae(i,j)+adx_ad(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))
    wk1_ad(i+1) = wk1_ad(i+1)-0.5*adx_ad(i,j)
    wk1_ad(i) = wk1_ad(i)+0.5*adx_ad(i,j)
    adx_ad(i,j) = 0.d0
  end do
  call xtp_ad( im,ffsl(j),wk1,wk1_ad,q(1,j),q_ae(1,j),crx(1,j),crx_ad(1,j),iad,crx(1,j),crx_ad(1,j),cosp(j),0,dm,dmk_ad,qtmp,&
&qtmpk_ad,al,ar,a6,a6_ad )
end do

!----------------------------------------------
! CLOSE TAPE tp2d_tape1
!----------------------------------------------
if (allocated(tp2d_tape1_a6_1h)) then
  deallocate( tp2d_tape1_a6_1h )
endif
if (allocated(tp2d_tape1_dm_2h)) then
  deallocate( tp2d_tape1_dm_2h )
endif

!----------------------------------------------
! CLOSE TAPE tp2d_tape2
!----------------------------------------------
if (allocated(tp2d_tape2_adx_1h)) then
  deallocate( tp2d_tape2_adx_1h )
endif
if (allocated(tp2d_tape2_a6_2h)) then
  deallocate( tp2d_tape2_a6_2h )
endif
if (allocated(tp2d_tape2_dm_3h)) then
  deallocate( tp2d_tape2_dm_3h )
endif


end subroutine tp2d_ad


subroutine tpcc_ad( va, va_ad, ymass, ymass_ad, q, q_ae, crx, crx_ad, cry, cry_ad, im, jm, ng, iord, jord, fx, fx_ad, fy_ad, ffsl, &
&cose, jfirst, jlast, dm, qtmp, al, ar, a6, a6_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_ad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: crx_ad(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: cry_ad(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ad(im,jfirst:jlast)
real(kind=r8) :: fy_ad(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_ad(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)
real(kind=r8) :: ymass_ad(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adx_ad(im,jfirst-1:jlast+2)
real(kind=r8) :: dmh_ad(1+im+2*(im/3))
real(kind=r8) :: dmi_ad(1+im+2*(im/3))
real(kind=r8) :: fx1(im)
real(kind=r8) :: fx1_ad(im)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qh(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmph_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_ad(1+im+2*(im/3))
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_ad(im)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
qh(:,:) = q(:,:)
a6h(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
adx_ad(:,:) = 0.d0
dmh_ad(:) = 0.d0
dmi_ad(:) = 0.d0
fx1_ad(:) = 0.d0
qtmph_ad(:) = 0.d0
qtmpi_ad(:) = 0.d0
wk1_ad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = jn1g0, js2g0, -1
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  a6 = tpcc2_tape_a6_1h(:,irec)
  dm = tpcc2_tape_dm_2h(:,irec)
  call xtp_ad( im,ffsl(j),fx(1,j),fx_ad(1,j),adx(1,j),adx_ad(1,j),crx(1,j),crx_ad(1,j),iord,crx(1,j),crx_ad(1,j),cose(j),0,dm,&
&dmh_ad,qtmp,qtmph_ad,al,ar,a6,a6_ad )
end do
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    q_ae(i,jp+1) = q_ae(i,jp+1)-0.5*adx_ad(i,j)*va(i,j)
    q_ae(i,j) = q_ae(i,j)+adx_ad(i,j)
    q_ae(i,jp) = q_ae(i,jp)+0.5*adx_ad(i,j)*va(i,j)
    va_ad(i,j) = va_ad(i,j)+0.5*adx_ad(i,j)*(q(i,jp)-q(i,jp+1))
    adx_ad(i,j) = 0.d0
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      q_ae(i,jm-1) = q_ae(i,jm-1)+0.5*adx_ad(i,jm)*va(i,jm)
      q_ae(i,jm) = q_ae(i,jm)+adx_ad(i,jm)*(1+(-0.5)*va(i,jm))
      va_ad(i,jm) = va_ad(i,jm)+0.5*adx_ad(i,jm)*(q(i,jm-1)-q(i,jm))
      adx_ad(i,jm) = 0.d0
    else
      fx1_ad(i) = fx1_ad(i)-0.5*adx_ad(i,jm)*va(i,jm)
      q_ae(i,jm) = q_ae(i,jm)+adx_ad(i,jm)*(1+0.5*va(i,jm))
      va_ad(i,jm) = va_ad(i,jm)+0.5*adx_ad(i,jm)*(q(i,jm)-fx1(i))
      adx_ad(i,jm) = 0.d0
    endif
  end do
  do i = im2+1, im
    q_ae(i-im2,jm) = q_ae(i-im2,jm)+fx1_ad(i)
    fx1_ad(i) = 0.d0
  end do
  do i = 1, im2
    q_ae(i+im2,jm) = q_ae(i+im2,jm)+fx1_ad(i)
    fx1_ad(i) = 0.d0
  end do
endif
if (jfirst .eq. 1) then
  do i = im2+1, im
    q_ae(i-im2,2) = q_ae(i-im2,2)+q_ae(i,1)
    q_ae(i,1) = 0.d0
  end do
  do i = 1, im2
    q_ae(i+im2,2) = q_ae(i+im2,2)+q_ae(i,1)
    q_ae(i,1) = 0.d0
  end do
endif
a6(:) = a6h(:)
q(:,:) = qh(:,:)
do j = js2gs, jn1gn
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc_ad( im,jm,fy_ad,adx,adx_ad,cry,cry_ad,ymass,ymass_ad,jord,0,jfirst,jlast )
q(:,:) = qh(:,:)
do j = jn1gn, js2gs, -1
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  a6 = tpcc1_tape_a6_1h(:,irec)
  dm = tpcc1_tape_dm_2h(:,irec)
  crx_ad(im,j) = crx_ad(im,j)-0.5*adx_ad(im,j)*q(im,j)
  crx_ad(1,j) = crx_ad(1,j)+0.5*adx_ad(im,j)*q(im,j)
  q_ae(im,j) = q_ae(im,j)+adx_ad(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))
  wk1_ad(im) = wk1_ad(im)+0.5*adx_ad(im,j)
  wk1_ad(1) = wk1_ad(1)-0.5*adx_ad(im,j)
  adx_ad(im,j) = 0.d0
  do i = 1, im-1
    crx_ad(i+1,j) = crx_ad(i+1,j)+0.5*adx_ad(i,j)*q(i,j)
    crx_ad(i,j) = crx_ad(i,j)-0.5*adx_ad(i,j)*q(i,j)
    q_ae(i,j) = q_ae(i,j)+adx_ad(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))
    wk1_ad(i+1) = wk1_ad(i+1)-0.5*adx_ad(i,j)
    wk1_ad(i) = wk1_ad(i)+0.5*adx_ad(i,j)
    adx_ad(i,j) = 0.d0
  end do
  call xtp_ad( im,ffsl(j),wk1,wk1_ad,q(1,j),q_ae(1,j),crx(1,j),crx_ad(1,j),1,crx(1,j),crx_ad(1,j),cose(j),0,dm,dmi_ad,qtmp,&
&qtmpi_ad,al,ar,a6,a6_ad )
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine tpcc_ad


subroutine tpccmd( va, ymass, q, crx, cry, im, jm, ng, iord, jord, fx, fy, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_ad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: fx1(im)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
integer :: south
real(kind=r8) :: wk1(im)

!**********************************************
! executable statements of routine
!**********************************************
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  if ( .not. allocated(tpcc1_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_a6_1h)) then
      allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc1_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_dm_2h)) then
      allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc( im,jm,fy,adx,cry,ymass,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  if ( .not. allocated(tpcc2_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_a6_1h)) then
      allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc2_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_dm_2h)) then
      allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),fx(1,j),adx(1,j),crx(1,j),iord,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
end do
end subroutine tpccmd


subroutine xmist_ad( im, q, q_ae, dm, dm_ad, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_ae(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_ad
double precision :: dmi_ad
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_ad = 0.d0
qmin_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmax_ad = 0.d0
    qmin_ad = 0.d0
    qmax = max(q(i-1),q(i),q(i+1))-q(i)
    qmin = q(i)-min(q(i-1),q(i),q(i+1))
    dmh = min(abs(dm(i)),qmax)
    dmi_ad = dm_ad(i)*sign(1.d0,min(dmh,qmin))*sign(1.d0,dm(i))
    dmh_ad = dmi_ad*(0.5+sign(0.5d0,qmin-dmh))
    qmin_ad = qmin_ad+dmi_ad*(0.5-sign(0.5d0,qmin-dmh))
    qmax_ad = qmax_ad+dmh_ad*(0.5-sign(0.5d0,qmax-abs(dm(i))))
    dm_ad(i) = dmh_ad*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))
    qminh = min(q(i-1),q(i))
    q_ae(i) = q_ae(i)+qmin_ad
    qmini_ad = -qmin_ad
    q_ae(i+1) = q_ae(i+1)+qmini_ad*(0.5-sign(0.5d0,q(i+1)-qminh))
    qminh_ad = qmini_ad*(0.5+sign(0.5d0,q(i+1)-qminh))
    q_ae(i-1) = q_ae(i-1)+qminh_ad*(0.5+sign(0.5d0,q(i)-q(i-1)))
    q_ae(i) = q_ae(i)+qminh_ad*(0.5-sign(0.5d0,q(i)-q(i-1)))
    qmin_ad = 0.d0
    qmaxh = max(q(i-1),q(i))
    q_ae(i) = q_ae(i)-qmax_ad
    q_ae(i+1) = q_ae(i+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-q(i+1)))
    qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-q(i+1)))
    q_ae(i-1) = q_ae(i-1)+qmaxh_ad*(0.5+sign(0.5d0,q(i-1)-q(i)))
    q_ae(i) = q_ae(i)+qmaxh_ad*(0.5-sign(0.5d0,q(i-1)-q(i)))
    qmax_ad = 0.d0
  end do
endif
if (id .le. 2) then
  do i = 1, im
    q_ae(i-2) = q_ae(i-2)+dm_ad(i)*r24
    q_ae(i-1) = q_ae(i-1)-8*dm_ad(i)*r24
    q_ae(i+2) = q_ae(i+2)-dm_ad(i)*r24
    q_ae(i+1) = q_ae(i+1)+8*dm_ad(i)*r24
    dm_ad(i) = 0.d0
  end do
else
  do i = 1, im
    q_ae(i-1) = q_ae(i-1)-0.25*dm_ad(i)
    q_ae(i+1) = q_ae(i+1)+0.25*dm_ad(i)
    dm_ad(i) = 0.d0
  end do
endif

end subroutine xmist_ad


subroutine xtp_ad( im, ffsl, fx, fx_ad, q, q_ae, c, c_ad, iord, mfx, mfx_ad, cosa, id, dm, dm_ad, qtmp, qtmp_ad, al, ar, a6, a6_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_ad(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ad(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_ad(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_ae(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_ad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h(-(im/3):im+im/3)
real(kind=r8) :: alh_ad(1+im+2*(im/3))
real(kind=r8) :: ali_ad(1+im+2*(im/3))
real(kind=r8) :: arh_ad(1+im+2*(im/3))
real(kind=r8) :: ari_ad(1+im+2*(im/3))
double precision :: dmh_ad
double precision :: dmi_ad
double precision :: dmj
double precision :: dmj_ad
real(kind=r8) :: dmk(-(im/3):im+im/3)
double precision :: dmk_ad
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad
real(kind=r8) :: rut
real(kind=r8) :: rut_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad
logical :: c_adEQmfx_ad  ! .true. if c_ad and mfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
c_adEQmfx_ad = loc(c_ad) == loc(mfx_ad)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmk(:) = dm(:)
a6h(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alh_ad(:) = 0.d0
ali_ad(:) = 0.d0
arh_ad(:) = 0.d0
ari_ad(:) = 0.d0
qmax_ad = 0.d0
qmin_ad = 0.d0
rut_ad = 0.d0
tmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
      fx(i) = (c(i)-iu)*qtmp(itmp)
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm( im,c,mfx,qtmp,dm,fx,iord,al,ar,a6,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
          fx(i) = rut*(qtmp(itmp)-dm(itmp)*(1.+rut))
        else
          itmp = i-iu-1
          isave(i) = itmp+1
          fx(i) = rut*(qtmp(itmp)+dm(itmp)*(1.-rut))
        endif
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        fx(i) = fx(i)+qtmp(ist)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        fx(i) = fx(i)-qtmp(ist)
      end do
    endif
  end do
  if (id .ne. 0) then
    if(c_adEQmfx_ad) then
      do i = 1, im
        c_ad(i) = c_ad(i)+fx_ad(i)*fx(i)
        fx_ad(i) = fx_ad(i)*mfx(i)
      end do
    else
      do i = 1, im
        mfx_ad(i) = mfx_ad(i)+fx_ad(i)*fx(i)
        fx_ad(i) = fx_ad(i)*mfx(i)
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        qtmp_ad(ist) = qtmp_ad(ist)+fx_ad(i)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        qtmp_ad(ist) = qtmp_ad(ist)-fx_ad(i)
      end do
    endif
  end do
  a6(:) = a6h(:)
  dm(:) = dmk(:)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
      else
        itmp = i-iu-1
      endif
      c_ad(i) = c_ad(i)+fx_ad(i)*qtmp(itmp)
      qtmp_ad(itmp) = qtmp_ad(itmp)+fx_ad(i)*(c(i)-iu)
      fx_ad(i) = 0.d0
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_ad( im,c,c_ad,mfx,mfx_ad,qtmp,qtmp_ad,dm,dm_ad,fx,fx_ad,iord,al,alh_ad,ar,arh_ad,a6,a6_ad,iuw,iue,ffsl )
    else
      do i = 1, im
        rut_ad = 0.d0
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          dm_ad(itmp) = dm_ad(itmp)-fx_ad(i)*rut*(1+rut)
          qtmp_ad(itmp) = qtmp_ad(itmp)+fx_ad(i)*rut
          rut_ad = rut_ad+fx_ad(i)*((-(rut*dm(itmp)))+qtmp(itmp)-dm(itmp)*(1.+rut))
          fx_ad(i) = 0.d0
        else
          itmp = i-iu-1
          dm_ad(itmp) = dm_ad(itmp)+fx_ad(i)*rut*(1.-rut)
          qtmp_ad(itmp) = qtmp_ad(itmp)+fx_ad(i)*rut
          rut_ad = rut_ad+fx_ad(i)*((-(rut*dm(itmp)))+qtmp(itmp)+dm(itmp)*(1.-rut))
          fx_ad(i) = 0.d0
        endif
        c_ad(i) = c_ad(i)+rut_ad
        rut_ad = 0.d0
      end do
    endif
    do i = iue, imp, -1
      dmh_ad = dm_ad(i)
      dm_ad(i) = 0.d0
      dm_ad(i-im) = dm_ad(i-im)+dmh_ad
    end do
    do i = 0, iuw, -1
      dmi_ad = dm_ad(i)
      dm_ad(i) = 0.d0
      dm_ad(im+i) = dm_ad(im+i)+dmi_ad
    end do
    do i = 1, im
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dmj = min(abs(tmp),qmax)
      dmk_ad = dm_ad(i)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_ad = dmk_ad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_ad = qmin_ad+dmk_ad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_ad = qmax_ad+dmj_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmj_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i) = 0.d0
      qminh = min(qtmp(i-1),qtmp(i))
      qmini_ad = -qmin_ad
      qtmp_ad(i) = qtmp_ad(i)+qmin_ad
      qminh_ad = qmini_ad*(0.5+sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_ad(i+1) = qtmp_ad(i+1)+qmini_ad*(0.5-sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_ad(i-1) = qtmp_ad(i-1)+qminh_ad*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qtmp_ad(i) = qtmp_ad(i)+qminh_ad*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qmin_ad = 0.d0
      qmaxh = max(qtmp(i-1),qtmp(i))
      qtmp_ad(i) = qtmp_ad(i)-qmax_ad
      qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_ad(i+1) = qtmp_ad(i+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_ad(i-1) = qtmp_ad(i-1)+qmaxh_ad*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qtmp_ad(i) = qtmp_ad(i)+qmaxh_ad*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qmax_ad = 0.d0
      qtmp_ad(i-1) = qtmp_ad(i-1)-0.25*tmp_ad
      qtmp_ad(i+1) = qtmp_ad(i+1)+0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
  do i = imp, iue
    q_ae(i-im) = q_ae(i-im)+qtmp_ad(i)
    qtmp_ad(i) = 0.d0
  end do
  do i = iuw, 0
    q_ae(im+i) = q_ae(im+i)+qtmp_ad(i)
    qtmp_ad(i) = 0.d0
  end do
else
  qtmp(imp) = q(1)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    if(c_adEQmfx_ad) then
      do i = 1, im
        iu = float(i)-c(i)
        c_ad(i) = c_ad(i)+fx_ad(i)*qtmp(iu)
        qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
        fx_ad(i) = 0.d0
      end do
    else
      do i = 1, im
        iu = float(i)-c(i)
        mfx_ad(i) = mfx_ad(i)+fx_ad(i)*qtmp(iu)
        qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
        fx_ad(i) = 0.d0
      end do
    endif
  else
    qtmp(-1) = q(im-1)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist( im,qtmp,dm,2 )
    else
      call xmist( im,qtmp,dm,iord )
    endif
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      if(c_adEQmfx_ad) then
        do i = 1, im
          iu = float(i)-c(i)
          c_ad(i) = c_ad(i)-fx_ad(i)*mfx(i)*dm(iu)
          dm_ad(iu) = dm_ad(iu)+fx_ad(i)*mfx(i)*(sign(1.d0,c(i))-c(i))
          c_ad(i) = c_ad(i)+fx_ad(i)*(qtmp(iu)+dm(iu)*(sign(1.d0,c(i))-c(i)))
          qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
          fx_ad(i) = 0.d0
        end do
      else
        do i = 1, im
          iu = float(i)-c(i)
          c_ad(i) = c_ad(i)-fx_ad(i)*mfx(i)*dm(iu)
          dm_ad(iu) = dm_ad(iu)+fx_ad(i)*mfx(i)*(sign(1.d0,c(i))-c(i))
          mfx_ad(i) = mfx_ad(i)+fx_ad(i)*(qtmp(iu)+dm(iu)*(sign(1.d0,c(i))-c(i)))
          qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
          fx_ad(i) = 0.d0
        end do
      endif
    else
      call fxppm_ad( im,c,c_ad,mfx,mfx_ad,qtmp,qtmp_ad,dm,dm_ad,fx,fx_ad,iord,al,ali_ad,ar,ari_ad,a6,a6_ad,iuw,iue,ffsl )
    endif
    dm_ad(im) = dm_ad(im)+dm_ad(0)
    dm_ad(0) = 0.d0
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_ad( im,qtmp,qtmp_ad,dm,dm_ad,2 )
    else
      call xmist_ad( im,qtmp,qtmp_ad,dm,dm_ad,iord )
    endif
    q_ae(2) = q_ae(2)+qtmp_ad(imp+1)
    qtmp_ad(imp+1) = 0.d0
    q_ae(im-1) = q_ae(im-1)+qtmp_ad(-1)
    qtmp_ad(-1) = 0.d0
  endif
  q_ae(im) = q_ae(im)+qtmp_ad(0)
  qtmp_ad(0) = 0.d0
  q_ae(1) = q_ae(1)+qtmp_ad(imp)
  qtmp_ad(imp) = 0.d0
endif
do i = 1, im
  q_ae(i) = q_ae(i)+qtmp_ad(i)
  qtmp_ad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine xtp_ad


subroutine ycc_ad( im, jm, fy_ad, q, q_ae, vc, vc_ad, ymass, ymass_ad, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: iv
integer :: jfirst
integer :: jlast
real(kind=r8) :: fy_ad(im,jfirst-iv:jlast)
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: q_ae(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: vc(im,jfirst-iv:jlast)
real(kind=r8) :: vc_ad(im,jfirst-iv:jlast)
real(kind=r8) :: ymass(im,jfirst-iv:jlast)
real(kind=r8) :: ymass_ad(im,jfirst-iv:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dc(im,jfirst-iv:jlast+1)
real(kind=r8) :: dc_ad(im,jfirst-iv:jlast+1)
double precision :: dch
double precision :: dch_ad
double precision :: dci_ad
integer :: i
integer :: im2
integer :: j
integer :: jn2g0
integer :: jn2g1
integer :: js2giv
integer :: js3giv
integer :: jt
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad
logical :: vc_adEQymass_ad  ! .true. if c_ad and mfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
vc_adEQymass_ad = loc(vc_ad) == loc(ymass_ad)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dc_ad(:,:) = 0.d0
qmax_ad = 0.d0
qmin_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
im2 = im/2
js2giv = max(2,jfirst-iv)
js3giv = max(3,jfirst-iv)
jn2g1 = min(jm-1,jlast+1)
jn2g0 = min(jm-1,jlast)
if (jord .eq. 1) then
  if(vc_adEQymass_ad) then
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)+fy_ad(i,j)*q(i,jt)
        fy_ad(i,j) = 0.d0
      end do
    end do
  else
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        ymass_ad(i,j) = ymass_ad(i,j)+fy_ad(i,j)*q(i,jt)
        fy_ad(i,j) = 0.d0
      end do
    end do
  endif
else
  do j = js3giv, jn2g1
    do i = 1, im
      dc(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
    end do
  end do
  if (iv .eq. 0) then
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)-q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)-q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = 0.25*(q(i+im2,jm)-q(i,jm-1))
      end do
      do i = im2+1, im
        dc(i,jm) = 0.25*(q(i-im2,jm)-q(i,jm-1))
      end do
    endif
  else
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)+q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)+q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i+im2,jm)))
      end do
      do i = im2+1, im
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i-im2,jm)))
      end do
    endif
  endif
  if (jord .gt. 0) then
    do j = js3giv, jn2g1
      do i = 1, im
        qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
        qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
        dc(i,j) = sign(min(abs(dc(i,j)),qmin,qmax),dc(i,j))
      end do
    end do
    if (jfirst .eq. 1) then
      do i = 1, im
        dc(i,2) = 0.
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im
        dc(i,jm) = 0.
      end do
    endif
  endif
  if(vc_adEQymass_ad) then
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        dc_ad(i,jt) = dc_ad(i,jt)+fy_ad(i,j)*(sign(1.d0,vc(i,j))-vc(i,j))*ymass(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)-fy_ad(i,j)*dc(i,jt)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)+fy_ad(i,j)*(q(i,jt)+(sign(1.d0,vc(i,j))-vc(i,j))*dc(i,jt))
        fy_ad(i,j) = 0.d0
      end do
    end do
  else
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        dc_ad(i,jt) = dc_ad(i,jt)+fy_ad(i,j)*(sign(1.d0,vc(i,j))-vc(i,j))*ymass(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)-fy_ad(i,j)*dc(i,jt)*ymass(i,j)
        ymass_ad(i,j) = ymass_ad(i,j)+fy_ad(i,j)*(q(i,jt)+(sign(1.d0,vc(i,j))-vc(i,j))*dc(i,jt))
        fy_ad(i,j) = 0.d0
      end do
    end do
  endif
  do j = js3giv, jn2g1
    do i = 1, im
      dc(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
    end do
  end do
  if (iv .eq. 0) then
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)-q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)-q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = 0.25*(q(i+im2,jm)-q(i,jm-1))
      end do
      do i = im2+1, im
        dc(i,jm) = 0.25*(q(i-im2,jm)-q(i,jm-1))
      end do
    endif
  else
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)+q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)+q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i+im2,jm)))
      end do
      do i = im2+1, im
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i-im2,jm)))
      end do
    endif
  endif
  if (jord .gt. 0) then
    if (jlast .eq. jm) then
      do i = 1, im
        dc_ad(i,jm) = 0.d0
      end do
    endif
    if (jfirst .eq. 1) then
      do i = 1, im
        dc_ad(i,2) = 0.d0
      end do
    endif
    do j = js3giv, jn2g1
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      do i = 1, im
        qmax_ad = 0.d0
        qmin_ad = 0.d0
        qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
        qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
        dch = min(abs(dc(i,j)),qmin)
        dci_ad = dc_ad(i,j)*sign(1.d0,min(dch,qmax))*sign(1.d0,dc(i,j))
        dch_ad = dci_ad*(0.5+sign(0.5d0,qmax-dch))
        qmax_ad = qmax_ad+dci_ad*(0.5-sign(0.5d0,qmax-dch))
        qmin_ad = qmin_ad+dch_ad*(0.5-sign(0.5d0,qmin-abs(dc(i,j))))
        dc_ad(i,j) = dch_ad*(0.5+sign(0.5d0,qmin-abs(dc(i,j))))*sign(1.d0,dc(i,j))
        qminh = min(q(i,j-1),q(i,j))
        q_ae(i,j) = q_ae(i,j)+qmin_ad
        qmini_ad = -qmin_ad
        q_ae(i,j+1) = q_ae(i,j+1)+qmini_ad*(0.5-sign(0.5d0,q(i,j+1)-qminh))
        qminh_ad = qmini_ad*(0.5+sign(0.5d0,q(i,j+1)-qminh))
        q_ae(i,j-1) = q_ae(i,j-1)+qminh_ad*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))
        q_ae(i,j) = q_ae(i,j)+qminh_ad*(0.5-sign(0.5d0,q(i,j)-q(i,j-1)))
        qmin_ad = 0.d0
        qmaxh = max(q(i,j-1),q(i,j))
        q_ae(i,j) = q_ae(i,j)-qmax_ad
        q_ae(i,j+1) = q_ae(i,j+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-q(i,j+1)))
        qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-q(i,j+1)))
        q_ae(i,j-1) = q_ae(i,j-1)+qmaxh_ad*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))
        q_ae(i,j) = q_ae(i,j)+qmaxh_ad*(0.5-sign(0.5d0,q(i,j-1)-q(i,j)))
        qmax_ad = 0.d0
      end do
    end do
  endif
  if (iv .eq. 0) then
    if (jlast .eq. jm) then
      do i = im2+1, im
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i-im2,jm) = q_ae(i-im2,jm)+0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i+im2,jm) = q_ae(i+im2,jm)+0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
    endif
    if (jfirst .eq. 1) then
      do i = im2+1, im
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i-im2,2) = q_ae(i-im2,2)-0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i+im2,2) = q_ae(i+im2,2)-0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
    endif
  else
    if (jlast .eq. jm) then
      do i = im2+1, im
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i-im2,jm) = q_ae(i-im2,jm)-0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i+im2,jm) = q_ae(i+im2,jm)-0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
    endif
    if (jfirst .eq. 1) then
      do i = im2+1, im
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i-im2,2) = q_ae(i-im2,2)+0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i+im2,2) = q_ae(i+im2,2)+0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
    endif
  endif
  do j = js3giv, jn2g1
    do i = 1, im
      q_ae(i,j-1) = q_ae(i,j-1)-0.25*dc_ad(i,j)
      q_ae(i,j+1) = q_ae(i,j+1)+0.25*dc_ad(i,j)
      dc_ad(i,j) = 0.d0
    end do
  end do
endif

end subroutine ycc_ad


subroutine ymist_ad( im, jm, q, q_ae, dm, dm_ad, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ad(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_ad
double precision :: dmi_ad
double precision :: dmi_ae
double precision :: dmj
double precision :: dmj_ad
double precision :: dmk_ad
double precision :: dmk_ae
double precision :: dml
double precision :: dml_ad
double precision :: dmm_ad
double precision :: dmm_ae
double precision :: dmn
double precision :: dmn_ad
double precision :: dmo_ad
double precision :: dmo_ae
double precision :: dmp
double precision :: dmp_ad
double precision :: dmq_ad
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
double precision :: qmaxj
double precision :: qmaxj_ad
double precision :: qmaxl
double precision :: qmaxl_ad
double precision :: qmaxn
double precision :: qmaxn_ad
double precision :: qmaxp
double precision :: qmaxp_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad
double precision :: qminj
double precision :: qminj_ad
double precision :: qmink_ad
double precision :: qminl
double precision :: qminl_ad
double precision :: qminm_ad
double precision :: qminn
double precision :: qminn_ad
double precision :: qmino_ad
double precision :: qminp
double precision :: qminp_ad
double precision :: qminq_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_ad = 0.d0
qmin_ad = 0.d0
tmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    qmax_ad = 0.d0
    qmin_ad = 0.d0
    do i = 1, im
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
      qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
      dmh = min(abs(dm(i,j)),qmin)
      dmi_ad = dm_ad(i,j)*sign(1.d0,min(dmh,qmax))*sign(1.d0,dm(i,j))
      dmh_ad = dmi_ad*(0.5+sign(0.5d0,qmax-dmh))
      qmax_ad = qmax_ad+dmi_ad*(0.5-sign(0.5d0,qmax-dmh))
      qmin_ad = qmin_ad+dmh_ad*(0.5-sign(0.5d0,qmin-abs(dm(i,j))))
      dm_ad(i,j) = dmh_ad*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))
      qminh = min(q(i,j-1),q(i,j))
      q_ae(i,j) = q_ae(i,j)+qmin_ad
      qmini_ad = -qmin_ad
      q_ae(i,j+1) = q_ae(i,j+1)+qmini_ad*(0.5-sign(0.5d0,q(i,j+1)-qminh))
      qminh_ad = qmini_ad*(0.5+sign(0.5d0,q(i,j+1)-qminh))
      q_ae(i,j-1) = q_ae(i,j-1)+qminh_ad*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))
      q_ae(i,j) = q_ae(i,j)+qminh_ad*(0.5-sign(0.5d0,q(i,j)-q(i,j-1)))
      qmin_ad = 0.d0
      qmaxh = max(q(i,j-1),q(i,j))
      q_ae(i,j) = q_ae(i,j)-qmax_ad
      q_ae(i,j+1) = q_ae(i,j+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-q(i,j+1)))
      qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-q(i,j+1)))
      q_ae(i,j-1) = q_ae(i,j-1)+qmaxh_ad*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))
      q_ae(i,j) = q_ae(i,j)+qmaxh_ad*(0.5-sign(0.5d0,q(i,j-1)-q(i,j)))
      qmax_ad = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmi_ae = dm_ad(i,jm)
      dm_ad(i,jm) = 0.d0
      dm_ad(i-im2,jm) = dm_ad(i-im2,jm)-dmi_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmj = min(abs(tmp),qmax)
      dmk_ad = dm_ad(i,jm)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_ad = dmk_ad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_ad = qmin_ad+dmk_ad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_ad = qmax_ad+dmj_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmj_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,jm) = 0.d0
      qminj = min(q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)+qmin_ad
      qmink_ad = -qmin_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmink_ad*(0.5-sign(0.5d0,q(i,jm1)-qminj))
      qminj_ad = qmink_ad*(0.5+sign(0.5d0,q(i,jm1)-qminj))
      q_ae(i,jm) = q_ae(i,jm)+qminj_ad*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)+qminj_ad*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      qmin_ad = 0.d0
      qmaxj = max(q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)-qmax_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmax_ad*(0.5-sign(0.5d0,qmaxj-q(i,jm1)))
      qmaxj_ad = qmax_ad*(0.5+sign(0.5d0,qmaxj-q(i,jm1)))
      q_ae(i,jm) = q_ae(i,jm)+qmaxj_ad*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)+qmaxj_ad*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      qmax_ad = 0.d0
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)+0.25*tmp_ad
      q_ae(i,jm1) = q_ae(i,jm1)-0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmk_ae = dm_ad(i,1)
      dm_ad(i,1) = 0.d0
      dm_ad(i-im2,1) = dm_ad(i-im2,1)-dmk_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dml = min(abs(tmp),qmax)
      dmm_ad = dm_ad(i,1)*sign(1.d0,min(dml,qmin))*sign(1.d0,tmp)
      dml_ad = dmm_ad*(0.5+sign(0.5d0,qmin-dml))
      qmin_ad = qmin_ad+dmm_ad*(0.5-sign(0.5d0,qmin-dml))
      qmax_ad = qmax_ad+dml_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dml_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,1) = 0.d0
      qminl = min(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)+qmin_ad
      qminm_ad = -qmin_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)+qminm_ad*(0.5-sign(0.5d0,q(i+im2,2)-qminl))
      qminl_ad = qminm_ad*(0.5+sign(0.5d0,q(i+im2,2)-qminl))
      q_ae(i,2) = q_ae(i,2)+qminl_ad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_ae(i,1) = q_ae(i,1)+qminl_ad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_ad = 0.d0
      qmaxl = max(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)-qmax_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)+qmax_ad*(0.5-sign(0.5d0,qmaxl-q(i+im2,2)))
      qmaxl_ad = qmax_ad*(0.5+sign(0.5d0,qmaxl-q(i+im2,2)))
      q_ae(i,2) = q_ae(i,2)+qmaxl_ad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_ae(i,1) = q_ae(i,1)+qmaxl_ad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_ad = 0.d0
      q_ae(i+im2,2) = q_ae(i+im2,2)-0.25*tmp_ad
      q_ae(i,2) = q_ae(i,2)+0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmm_ae = dm_ad(i,jm)
      dm_ad(i,jm) = 0.d0
      dm_ad(i-im2,jm) = dm_ad(i-im2,jm)+dmm_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmn = min(abs(tmp),qmax)
      dmo_ad = dm_ad(i,jm)*sign(1.d0,min(dmn,qmin))*sign(1.d0,tmp)
      dmn_ad = dmo_ad*(0.5+sign(0.5d0,qmin-dmn))
      qmin_ad = qmin_ad+dmo_ad*(0.5-sign(0.5d0,qmin-dmn))
      qmax_ad = qmax_ad+dmn_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmn_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,jm) = 0.d0
      qminn = min(-q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)+qmin_ad
      qmino_ad = -qmin_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmino_ad*(0.5-sign(0.5d0,q(i,jm1)-qminn))
      qminn_ad = qmino_ad*(0.5+sign(0.5d0,q(i,jm1)-qminn))
      q_ae(i,jm) = q_ae(i,jm)+qminn_ad*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)-qminn_ad*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      qmin_ad = 0.d0
      qmaxn = max(-q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)-qmax_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmax_ad*(0.5-sign(0.5d0,qmaxn-q(i,jm1)))
      qmaxn_ad = qmax_ad*(0.5+sign(0.5d0,qmaxn-q(i,jm1)))
      q_ae(i,jm) = q_ae(i,jm)+qmaxn_ad*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)-qmaxn_ad*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      qmax_ad = 0.d0
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)-0.25*tmp_ad
      q_ae(i,jm1) = q_ae(i,jm1)-0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmo_ae = dm_ad(i,1)
      dm_ad(i,1) = 0.d0
      dm_ad(i-im2,1) = dm_ad(i-im2,1)+dmo_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dmp = min(abs(tmp),qmax)
      dmq_ad = dm_ad(i,1)*sign(1.d0,min(dmp,qmin))*sign(1.d0,tmp)
      dmp_ad = dmq_ad*(0.5+sign(0.5d0,qmin-dmp))
      qmin_ad = qmin_ad+dmq_ad*(0.5-sign(0.5d0,qmin-dmp))
      qmax_ad = qmax_ad+dmp_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmp_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,1) = 0.d0
      qminp = min(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)+qmin_ad
      qminq_ad = -qmin_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)-qminq_ad*(0.5-sign(0.5d0,(-q(i+im2,2))-qminp))
      qminp_ad = qminq_ad*(0.5+sign(0.5d0,(-q(i+im2,2))-qminp))
      q_ae(i,2) = q_ae(i,2)+qminp_ad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_ae(i,1) = q_ae(i,1)+qminp_ad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_ad = 0.d0
      qmaxp = max(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)-qmax_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)-qmax_ad*(0.5-sign(0.5d0,qmaxp-(-q(i+im2,2))))
      qmaxp_ad = qmax_ad*(0.5+sign(0.5d0,qmaxp-(-q(i+im2,2))))
      q_ae(i,2) = q_ae(i,2)+qmaxp_ad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_ae(i,1) = q_ae(i,1)+qmaxp_ad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_ad = 0.d0
      q_ae(i+im2,2) = q_ae(i+im2,2)+0.25*tmp_ad
      q_ae(i,2) = q_ae(i,2)+0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
endif
do j = js2gng1, jn2gng1
  do i = 1, im
    q_ae(i,j-1) = q_ae(i,j-1)-0.25*dm_ad(i,j)
    q_ae(i,j+1) = q_ae(i,j+1)+0.25*dm_ad(i,j)
    dm_ad(i,j) = 0.d0
  end do
end do

end subroutine ymist_ad


subroutine ytp_ad( im, jm, fy, fy_ad, q, q_ae, c, c_ad, yfx, yfx_ad, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_ad(im,jfirst:jlast+1)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_ad(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ad(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt
logical :: c_adEQyfx_ad  ! .true. if c_ad and yfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
c_adEQyfx_ad = loc(c_ad) == loc(yfx_ad)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dm_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      fy(i,j) = q(i,jt)
    end do
  end do
else
  call ymist( im,jm,q,dm,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm( c,q,dm,fy,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        fy(i,j) = q(i,jt)+(sign(1._8,c(i,j))-c(i,j))*dm(i,jt)
      end do
    end do
  endif
endif
if(c_adEQyfx_ad) then
  do j = js2g0, jn1g1
    do i = 1, im
      c_ad(i,j) = c_ad(i,j)+fy_ad(i,j)*fy(i,j)
      fy_ad(i,j) = fy_ad(i,j)*yfx(i,j)
    end do
  end do
else
  do j = js2g0, jn1g1
    do i = 1, im
      yfx_ad(i,j) = yfx_ad(i,j)+fy_ad(i,j)*fy(i,j)
      fy_ad(i,j) = fy_ad(i,j)*yfx(i,j)
    end do
  end do
endif
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)
      fy_ad(i,j) = 0.d0
    end do
  end do
else
  if (abs(jord) .ge. 3) then
    call fyppm_ad( c,c_ad,q,q_ae,dm,dm_ad,fy_ad,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        c_ad(i,j) = c_ad(i,j)-fy_ad(i,j)*dm(i,jt)
        dm_ad(i,jt) = dm_ad(i,jt)+fy_ad(i,j)*(sign(1.d0,c(i,j))-c(i,j))
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)
        fy_ad(i,j) = 0.d0
      end do
    end do
  endif
  call ymist_ad( im,jm,q,q_ae,dm,dm_ad,ng,jord,iv,jfirst,jlast )
endif

end subroutine ytp_ad


end module     tp_core_ad

#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     tpcc_ad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: tpcc1_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc1_tape_dm_2h(:,:)
integer :: tpcc1_tape_tpcc
real(kind=8), allocatable :: tpcc2_tape_a6_1h(:,:)
real(kind=8), allocatable :: tpcc2_tape_dm_2h(:,:)
integer :: tpcc2_tape_tpcc

end module     tpcc_ad_store


module     tp_core_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use tp_core

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine fxppm_ad( im, c, c_ad, mfx, mfx_ad, p, p_ad, dm, dm_ad, fx, fx_ad, iord, al, al_ad, ar, ar_ad, a6, a6_ad, iuw, iue, &
&ffsl )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: al_ad(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: ar_ad(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_ad(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ad(im)
integer :: iord
integer :: iue
integer :: iuw
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_ad(im)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: a6h_ad
double precision :: a6i_ad
real(kind=r8) :: a6j(-(im/3):im+im/3)
double precision :: alh_ad
double precision :: ali_ad
double precision :: arh_ad
double precision :: ari_ad
real(kind=r8) :: dmh(-(im/3):im+im/3)
integer :: i
integer :: itmp
integer :: iu
integer :: lmt
real(kind=r8) :: ru
real(kind=r8) :: ru_ad
logical :: steep
logical :: c_adEQmfx_ad  ! .true. if c_ad and mfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
c_adEQmfx_ad = loc(c_ad) == loc(mfx_ad)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmh(:) = dm(:)
a6j(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
ru_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (iord .eq. 6) then
  steep =  .true. 
else
  steep =  .false. 
endif
do i = 1, im
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx( im,p,al(1),dm )
endif
do i = 1, im-1
  ar(i) = al(i+1)
end do
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh( im,ar(1),al(1),p(1),a6(1),dm(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  lmt = iord-3
  call lmppm( dm(1),a6(1),ar(1),al(1),p(1),im,lmt )
endif
if (ffsl) then
  do i = iuw, 0
    al(i) = al(im+i)
    ar(i) = ar(im+i)
    a6(i) = a6(im+i)
  end do
  do i = im+1, iue
    al(i) = al(i-im)
    ar(i) = ar(i-im)
    a6(i) = a6(i-im)
  end do
  do i = 1, im
    ru_ad = 0.d0
    iu = c(i)
    ru = c(i)-iu
    if (c(i) .gt. 0.) then
      itmp = i-iu-1
      a6_ad(itmp) = a6_ad(itmp)+0.5*fx_ad(i)*ru*ru*(1.-r23*ru)
      al_ad(itmp) = al_ad(itmp)+0.5*fx_ad(i)*ru*ru
      ar_ad(itmp) = ar_ad(itmp)+fx_ad(i)*ru*(1+(-0.5)*ru)
      ru_ad = ru_ad+fx_ad(i)*(ru*((-(0.5*ru*a6(itmp)*r23))+0.5*(al(itmp)-ar(itmp)+a6(itmp)*(1.-r23*ru)))+ar(itmp)+0.5*ru*(al(itmp)-&
&ar(itmp)+a6(itmp)*(1.-r23*ru)))
      fx_ad(i) = 0.d0
    else
      itmp = i-iu
      a6_ad(itmp) = a6_ad(itmp)-0.5*fx_ad(i)*ru*ru*(1+r23*ru)
      al_ad(itmp) = al_ad(itmp)+fx_ad(i)*ru*(1-(-0.5)*ru)
      ar_ad(itmp) = ar_ad(itmp)-0.5*fx_ad(i)*ru*ru
      ru_ad = ru_ad+fx_ad(i)*((-(ru*(0.5*ru*a6(itmp)*r23+0.5*(ar(itmp)-al(itmp)+a6(itmp)*(1.+r23*ru)))))+al(itmp)-0.5*ru*(ar(itmp)-&
&al(itmp)+a6(itmp)*(1.+r23*ru)))
      fx_ad(i) = 0.d0
    endif
    c_ad(i) = c_ad(i)+ru_ad
    ru_ad = 0.d0
  end do
  do i = iue, im+1, -1
    a6h_ad = a6_ad(i)
    a6_ad(i) = 0.d0
    a6_ad(i-im) = a6_ad(i-im)+a6h_ad
    arh_ad = ar_ad(i)
    ar_ad(i) = 0.d0
    ar_ad(i-im) = ar_ad(i-im)+arh_ad
    alh_ad = al_ad(i)
    al_ad(i) = 0.d0
    al_ad(i-im) = al_ad(i-im)+alh_ad
  end do
  do i = 0, iuw, -1
    a6i_ad = a6_ad(i)
    a6_ad(i) = 0.d0
    a6_ad(im+i) = a6_ad(im+i)+a6i_ad
    ari_ad = ar_ad(i)
    ar_ad(i) = 0.d0
    ar_ad(im+i) = ar_ad(im+i)+ari_ad
    ali_ad = al_ad(i)
    al_ad(i) = 0.d0
    al_ad(im+i) = al_ad(im+i)+ali_ad
  end do
else
  al(0) = al(im)
  ar(0) = ar(im)
  a6(0) = a6(im)
  do i = 1, im
    if (c(i) .gt. 0.) then
      fx(i) = ar(i-1)+0.5*c(i)*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i)))
    else
      fx(i) = al(i)-0.5*c(i)*(ar(i)-al(i)+a6(i)*(1.+r23*c(i)))
    endif
    if(c_adEQmfx_ad) then
      c_ad(i) = c_ad(i)+fx_ad(i)*fx(i)
    else
      mfx_ad(i) = mfx_ad(i)+fx_ad(i)*fx(i)
    endif
    fx_ad(i) = fx_ad(i)*mfx(i)
    if (c(i) .gt. 0.) then
      a6_ad(i-1) = a6_ad(i-1)+0.5*fx_ad(i)*c(i)*(1.-r23*c(i))
      al_ad(i-1) = al_ad(i-1)+0.5*fx_ad(i)*c(i)
      ar_ad(i-1) = ar_ad(i-1)+fx_ad(i)*(1+(-0.5)*c(i))
      c_ad(i) = c_ad(i)+fx_ad(i)*((-(0.5*c(i)*a6(i-1)*r23))+0.5*(al(i-1)-ar(i-1)+a6(i-1)*(1.-r23*c(i))))
      fx_ad(i) = 0.d0
    else
      a6_ad(i) = a6_ad(i)-0.5*fx_ad(i)*c(i)*(1+r23*c(i))
      al_ad(i) = al_ad(i)+fx_ad(i)*(1-(-0.5)*c(i))
      ar_ad(i) = ar_ad(i)-0.5*fx_ad(i)*c(i)
      c_ad(i) = c_ad(i)-fx_ad(i)*(0.5*c(i)*a6(i)*r23+0.5*(ar(i)-al(i)+a6(i)*(1.+r23*c(i))))
      fx_ad(i) = 0.d0
    endif
  end do
  a6_ad(im) = a6_ad(im)+a6_ad(0)
  a6_ad(0) = 0.d0
  ar_ad(im) = ar_ad(im)+ar_ad(0)
  ar_ad(0) = 0.d0
  al_ad(im) = al_ad(im)+al_ad(0)
  al_ad(0) = 0.d0
endif
a6(:) = a6j(:)
dm(:) = dmh(:)
do i = 1, im
  al(i) = 0.5*(p(i-1)+p(i))+(dm(i-1)-dm(i))*r3
end do
if (steep) then
  call steepx( im,p,al(1),dm )
endif
do i = 1, im-1
  ar(i) = al(i+1)
end do
ar(im) = al(1)
if (iord .eq. 7) then
  call huynh_ad( im,ar(1),ar_ad(1),al(1),al_ad(1),p(1),p_ad(1),a6(1),a6_ad(1),dm(1),dm_ad(1) )
else
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      a6(i) = 3.*(p(i)+p(i)-(al(i)+ar(i)))
    end do
  endif
  call lmppm_ad( dm(1),dm_ad(1),a6(1),a6_ad(1),ar(1),ar_ad(1),al(1),al_ad(1),p(1),p_ad(1),im,lmt )
  if (iord .eq. 3 .or. iord .eq. 5) then
    do i = 1, im
      al_ad(i) = al_ad(i)-3*a6_ad(i)
      ar_ad(i) = ar_ad(i)-3*a6_ad(i)
      p_ad(i) = p_ad(i)+6*a6_ad(i)
      a6_ad(i) = 0.d0
    end do
  endif
endif
al_ad(1) = al_ad(1)+ar_ad(im)
ar_ad(im) = 0.d0
do i = 1, im-1
  al_ad(i+1) = al_ad(i+1)+ar_ad(i)
  ar_ad(i) = 0.d0
end do
dm(:) = dmh(:)
if (steep) then
  call steepx_ad( im,p,p_ad,al_ad(1),dm,dm_ad )
endif
do i = 1, im
  dm_ad(i-1) = dm_ad(i-1)+al_ad(i)*r3
  dm_ad(i) = dm_ad(i)-al_ad(i)*r3
  p_ad(i-1) = p_ad(i-1)+0.5*al_ad(i)
  p_ad(i) = p_ad(i)+0.5*al_ad(i)
  al_ad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine fxppm_ad


subroutine fyppm_ad( c, c_ad, q, q_ae, dm, dm_ad, flux_ad, im, jm, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_ad(im,jfirst:jlast+1)
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: flux_ad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(im,jfirst-1:jlast+1)
real(kind=r8) :: a6_ad(im,jfirst-1:jlast+1)
real(kind=r8) :: a6h(im,jfirst-1:jlast+1)
real(kind=r8) :: al(im,jfirst-1:jlast+2)
real(kind=r8) :: al_ad(im,jfirst-1:jlast+2)
real(kind=r8) :: ar(im,jfirst-1:jlast+1)
real(kind=r8) :: ar_ad(im,jfirst-1:jlast+1)
double precision :: arh_ad
double precision :: ari_ad
integer :: help_h
integer :: i
integer :: imh
integer :: j
integer :: jm1
integer :: jn1g1
integer :: jn1g2
integer :: jn2g1
integer :: js1g1
integer :: js2g0
integer :: js2g1
integer :: lmt

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
a6h(:,:) = a6(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_ad(:,:) = 0.d0
al_ad(:,:) = 0.d0
ar_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imh = im/2
jm1 = jm-1
js1g1 = max(1,jfirst-1)
js2g0 = max(2,jfirst)
js2g1 = max(2,jfirst-1)
jn1g1 = min(jm,jlast+1)
jn1g2 = min(jm,jlast+2)
jn2g1 = min(jm-1,jlast+1)
do j = js2g1, jn1g2
  do i = 1, im
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = al(i+imh,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = ar(i+imh,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = -al(i+imh,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = -ar(i+imh,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
lmt = jord-3
help_h = im*(jn1g1-js1g1+1)
call lmppm( dm(1,js1g1),a6(1,js1g1),ar(1,js1g1),al(1,js1g1),q(1,js1g1),help_h,lmt )
do j = js2g0, jn1g1
  do i = 1, im
    if (c(i,j) .gt. 0.) then
      a6_ad(i,j-1) = a6_ad(i,j-1)+0.5*flux_ad(i,j)*c(i,j)*(1.-r23*c(i,j))
      al_ad(i,j-1) = al_ad(i,j-1)+0.5*flux_ad(i,j)*c(i,j)
      ar_ad(i,j-1) = ar_ad(i,j-1)+flux_ad(i,j)*(1+(-0.5)*c(i,j))
      c_ad(i,j) = c_ad(i,j)+flux_ad(i,j)*((-(0.5*c(i,j)*a6(i,j-1)*r23))+0.5*(al(i,j-1)-ar(i,j-1)+a6(i,j-1)*(1.-r23*c(i,j))))
      flux_ad(i,j) = 0.d0
    else
      a6_ad(i,j) = a6_ad(i,j)-0.5*flux_ad(i,j)*c(i,j)*(1+r23*c(i,j))
      al_ad(i,j) = al_ad(i,j)+flux_ad(i,j)*(1-(-0.5)*c(i,j))
      ar_ad(i,j) = ar_ad(i,j)-0.5*flux_ad(i,j)*c(i,j)
      c_ad(i,j) = c_ad(i,j)-flux_ad(i,j)*(0.5*c(i,j)*a6(i,j)*r23+0.5*(ar(i,j)-al(i,j)+a6(i,j)*(1.+r23*c(i,j))))
      flux_ad(i,j) = 0.d0
    endif
  end do
end do
a6(:,:) = a6h(:,:)
do j = js2g1, jn1g2
  do i = 1, im
    al(i,j) = 0.5*(q(i,j-1)+q(i,j))+r3*(dm(i,j-1)-dm(i,j))
  end do
end do
do j = js1g1, jn2g1
  do i = 1, im
    ar(i,j) = al(i,j+1)
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = al(i+imh,2)
      al(i+imh,1) = al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = ar(i+imh,jm1)
      ar(i+imh,jm) = ar(i,jm1)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, imh
      al(i,1) = -al(i+imh,2)
      al(i+imh,1) = -al(i,2)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, imh
      ar(i,jm) = -ar(i+imh,jm1)
      ar(i+imh,jm) = -ar(i,jm1)
    end do
  endif
endif
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      a6(i,j) = 3.*(q(i,j)+q(i,j)-(al(i,j)+ar(i,j)))
    end do
  end do
endif
call lmppm_ad( dm(1,js1g1),dm_ad(1,js1g1),a6(1,js1g1),a6_ad(1,js1g1),ar(1,js1g1),ar_ad(1,js1g1),al(1,js1g1),al_ad(1,js1g1),q(1,&
&js1g1),q_ae(1,js1g1),help_h,lmt )
if (jord .eq. 3 .or. jord .eq. 5) then
  do j = js1g1, jn1g1
    do i = 1, im
      al_ad(i,j) = al_ad(i,j)-3*a6_ad(i,j)
      ar_ad(i,j) = ar_ad(i,j)-3*a6_ad(i,j)
      q_ae(i,j) = q_ae(i,j)+6*a6_ad(i,j)
      a6_ad(i,j) = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_ad(i,jm1) = ar_ad(i,jm1)+ar_ad(i+imh,jm)
      ar_ad(i+imh,jm) = 0.d0
      arh_ad = ar_ad(i,jm)
      ar_ad(i,jm) = 0.d0
      ar_ad(i+imh,jm1) = ar_ad(i+imh,jm1)+arh_ad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ad(i,2) = al_ad(i,2)+al_ad(i+imh,1)
      al_ad(i+imh,1) = 0.d0
      al_ad(i+imh,2) = al_ad(i+imh,2)+al_ad(i,1)
      al_ad(i,1) = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = imh, 1, -1
      ar_ad(i,jm1) = ar_ad(i,jm1)-ar_ad(i+imh,jm)
      ar_ad(i+imh,jm) = 0.d0
      ari_ad = ar_ad(i,jm)
      ar_ad(i,jm) = 0.d0
      ar_ad(i+imh,jm1) = ar_ad(i+imh,jm1)-ari_ad
    end do
  endif
  if (jfirst .eq. 1) then
    do i = 1, imh
      al_ad(i,2) = al_ad(i,2)-al_ad(i+imh,1)
      al_ad(i+imh,1) = 0.d0
      al_ad(i+imh,2) = al_ad(i+imh,2)-al_ad(i,1)
      al_ad(i,1) = 0.d0
    end do
  endif
endif
do j = js1g1, jn2g1
  do i = 1, im
    al_ad(i,j+1) = al_ad(i,j+1)+ar_ad(i,j)
    ar_ad(i,j) = 0.d0
  end do
end do
do j = js2g1, jn1g2
  do i = 1, im
    dm_ad(i,j-1) = dm_ad(i,j-1)+al_ad(i,j)*r3
    dm_ad(i,j) = dm_ad(i,j)-al_ad(i,j)*r3
    q_ae(i,j-1) = q_ae(i,j-1)+0.5*al_ad(i,j)
    q_ae(i,j) = q_ae(i,j)+0.5*al_ad(i,j)
    al_ad(i,j) = 0.d0
  end do
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine fyppm_ad


subroutine huynh_ad( im, ar, ar_ad, al, al_ad, p, p_ad, d2, d2_ad, d1, d1_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al(im)
real(kind=r8) :: al_ad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ad(im)
real(kind=r8) :: d1(im)
real(kind=r8) :: d1_ad(im)
real(kind=r8) :: d2(im)
real(kind=r8) :: d2_ad(im)
real(kind=r8) :: p(im)
real(kind=r8) :: p_ad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alh(im)
real(kind=r8) :: arh(im)
integer :: i
real(kind=r8) :: lac
real(kind=r8) :: lac_ad
real(kind=r8) :: pmax
real(kind=r8) :: pmax_ad
real(kind=r8) :: pmin
real(kind=r8) :: pmin_ad
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
arh(:) = ar(:)
alh(:) = al(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
lac_ad = 0.d0
pmax_ad = 0.d0
pmin_ad = 0.d0
pmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
d1(1) = p(1)-p(im)
do i = 2, im
  d1(i) = p(i)-p(i-1)
end do
do i = 1, im-1
  d2(i) = d1(i+1)-d1(i)
end do
d2(im) = d1(1)-d1(im)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
ar(1) = min(pmax,max(ar(1),pmin))
do i = 1, im-1
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  al(i) = min(pmax,max(al(i),pmin))
end do
pmp = p(im)-2.*d1(1)
lac = p(im)+0.5*(d2(1)-d1(1))+d2(1)
pmin = min(p(im),pmp,lac)
pmax = max(p(im),pmp,lac)
do i = 1, im
  al_ad(i) = al_ad(i)-3*d2_ad(i)
  ar_ad(i) = ar_ad(i)-3*d2_ad(i)
  p_ad(i) = p_ad(i)+6*d2_ad(i)
  d2_ad(i) = 0.d0
end do
pmax_ad = pmax_ad+al_ad(im)*(0.5+sign(0.5d0,max(al(im),pmin)-pmax))
pmin_ad = pmin_ad+al_ad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5-sign(0.5d0,al(im)-pmin))
al_ad(im) = al_ad(im)*(0.5-sign(0.5d0,max(al(im),pmin)-pmax))*(0.5+sign(0.5d0,al(im)-pmin))
p_ad(im) = p_ad(im)+pmax_ad*(0.5+sign(0.5d0,p(im)-pmp))
pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(im)-pmp))
pmax_ad = 0.d0
p_ad(im) = p_ad(im)+pmin_ad*(0.5+sign(0.5d0,pmp-p(im)))
pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(im)))
pmin_ad = 0.d0
d1_ad(1) = d1_ad(1)-0.5*lac_ad
d2_ad(1) = d2_ad(1)+1.5*lac_ad
p_ad(im) = p_ad(im)+lac_ad
lac_ad = 0.d0
d1_ad(1) = d1_ad(1)-2*pmp_ad
p_ad(im) = p_ad(im)+pmp_ad
pmp_ad = 0.d0
al(:) = alh(:)
do i = 1, im-1
  lac_ad = 0.d0
  pmax_ad = 0.d0
  pmin_ad = 0.d0
  pmp_ad = 0.d0
  pmp = p(i)-2.*d1(i+1)
  lac = p(i)+0.5*(d2(i+1)-d1(i+1))+d2(i+1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_ad = pmax_ad+al_ad(i)*(0.5+sign(0.5d0,max(al(i),pmin)-pmax))
  pmin_ad = pmin_ad+al_ad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5-sign(0.5d0,al(i)-pmin))
  al_ad(i) = al_ad(i)*(0.5-sign(0.5d0,max(al(i),pmin)-pmax))*(0.5+sign(0.5d0,al(i)-pmin))
  p_ad(i) = p_ad(i)+pmax_ad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_ad = 0.d0
  p_ad(i) = p_ad(i)+pmin_ad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_ad = 0.d0
  d1_ad(i+1) = d1_ad(i+1)-0.5*lac_ad
  d2_ad(i+1) = d2_ad(i+1)+1.5*lac_ad
  p_ad(i) = p_ad(i)+lac_ad
  lac_ad = 0.d0
  d1_ad(i+1) = d1_ad(i+1)-2*pmp_ad
  p_ad(i) = p_ad(i)+pmp_ad
  pmp_ad = 0.d0
end do
do i = 2, im
  lac_ad = 0.d0
  pmax_ad = 0.d0
  pmin_ad = 0.d0
  pmp_ad = 0.d0
  pmp = p(i)+2.*d1(i)
  lac = p(i)+0.5*(d1(i)+d2(i-1))+d2(i-1)
  pmin = min(p(i),pmp,lac)
  pmax = max(p(i),pmp,lac)
  pmax_ad = pmax_ad+ar_ad(i)*(0.5+sign(0.5d0,max(ar(i),pmin)-pmax))
  pmin_ad = pmin_ad+ar_ad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5-sign(0.5d0,ar(i)-pmin))
  ar_ad(i) = ar_ad(i)*(0.5-sign(0.5d0,max(ar(i),pmin)-pmax))*(0.5+sign(0.5d0,ar(i)-pmin))
  p_ad(i) = p_ad(i)+pmax_ad*(0.5+sign(0.5d0,p(i)-pmp))
  pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(i)-pmp))
  pmax_ad = 0.d0
  p_ad(i) = p_ad(i)+pmin_ad*(0.5+sign(0.5d0,pmp-p(i)))
  pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(i)))
  pmin_ad = 0.d0
  d1_ad(i) = d1_ad(i)+0.5*lac_ad
  d2_ad(i-1) = d2_ad(i-1)+1.5*lac_ad
  p_ad(i) = p_ad(i)+lac_ad
  lac_ad = 0.d0
  d1_ad(i) = d1_ad(i)+2*pmp_ad
  p_ad(i) = p_ad(i)+pmp_ad
  pmp_ad = 0.d0
end do
ar(:) = arh(:)
pmp = p(1)+2.*d1(1)
lac = p(1)+0.5*(d1(1)+d2(im))+d2(im)
pmin = min(p(1),pmp,lac)
pmax = max(p(1),pmp,lac)
pmax_ad = pmax_ad+ar_ad(1)*(0.5+sign(0.5d0,max(ar(1),pmin)-pmax))
pmin_ad = pmin_ad+ar_ad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5-sign(0.5d0,ar(1)-pmin))
ar_ad(1) = ar_ad(1)*(0.5-sign(0.5d0,max(ar(1),pmin)-pmax))*(0.5+sign(0.5d0,ar(1)-pmin))
pmp = p(1)+2.*d1(1)
p_ad(1) = p_ad(1)+pmax_ad*(0.5+sign(0.5d0,p(1)-pmp))
pmp_ad = pmp_ad+pmax_ad*(0.5-sign(0.5d0,p(1)-pmp))
pmax_ad = 0.d0
pmp = p(1)+2.*d1(1)
p_ad(1) = p_ad(1)+pmin_ad*(0.5+sign(0.5d0,pmp-p(1)))
pmp_ad = pmp_ad+pmin_ad*(0.5-sign(0.5d0,pmp-p(1)))
pmin_ad = 0.d0
d1_ad(1) = d1_ad(1)+0.5*lac_ad
d2_ad(im) = d2_ad(im)+1.5*lac_ad
p_ad(1) = p_ad(1)+lac_ad
lac_ad = 0.d0
d1_ad(1) = d1_ad(1)+2*pmp_ad
p_ad(1) = p_ad(1)+pmp_ad
pmp_ad = 0.d0
d1_ad(im) = d1_ad(im)-d2_ad(im)
d1_ad(1) = d1_ad(1)+d2_ad(im)
d2_ad(im) = 0.d0
do i = 1, im-1
  d1_ad(i+1) = d1_ad(i+1)+d2_ad(i)
  d1_ad(i) = d1_ad(i)-d2_ad(i)
  d2_ad(i) = 0.d0
end do
do i = 2, im
  p_ad(i-1) = p_ad(i-1)-d1_ad(i)
  p_ad(i) = p_ad(i)+d1_ad(i)
  d1_ad(i) = 0.d0
end do
p_ad(im) = p_ad(im)-d1_ad(1)
p_ad(1) = p_ad(1)+d1_ad(1)
d1_ad(1) = 0.d0

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine huynh_ad


subroutine lmppm_ad( dm, dm_ad, a6, a6_ad, ar, ar_ad, al, al_ad, p, p_ad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(im)
real(kind=r8) :: a6_ad(im)
real(kind=r8) :: al(im)
real(kind=r8) :: al_ad(im)
real(kind=r8) :: ar(im)
real(kind=r8) :: ar_ad(im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ad(im)
integer :: lmt
real(kind=r8) :: p(im)
real(kind=r8) :: p_ad(im)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ad
real(kind=r8) :: da1
real(kind=r8) :: da1_ad
real(kind=r8) :: da2
real(kind=r8) :: da2_ad
real(kind=r8) :: dl_ad
real(kind=r8) :: dr_ad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ad
integer :: i

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_ad = 0.d0
da1_ad = 0.d0
da2_ad = 0.d0
dl_ad = 0.d0
dr_ad = 0.d0
fmin_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .eq. 0) then
  do i = 1, im
    a6da_ad = 0.d0
    da1_ad = 0.d0
    da2_ad = 0.d0
    if (dm(i) .eq. 0.) then
      a6_ad(i) = 0.d0
      p_ad(i) = p_ad(i)+al_ad(i)
      al_ad(i) = 0.d0
      p_ad(i) = p_ad(i)+ar_ad(i)
      ar_ad(i) = 0.d0
    else
      da1 = ar(i)-al(i)
      da2 = da1**2
      a6da = a6(i)*da1
      if (a6da .lt. (-da2)) then
        a6_ad(i) = a6_ad(i)-ar_ad(i)
        al_ad(i) = al_ad(i)+ar_ad(i)
        ar_ad(i) = 0.d0
        al_ad(i) = al_ad(i)+3*a6_ad(i)
        p_ad(i) = p_ad(i)-3*a6_ad(i)
        a6_ad(i) = 0.d0
      else if (a6da .gt. da2) then
        a6_ad(i) = a6_ad(i)-al_ad(i)
        ar_ad(i) = ar_ad(i)+al_ad(i)
        al_ad(i) = 0.d0
        ar_ad(i) = ar_ad(i)+3*a6_ad(i)
        p_ad(i) = p_ad(i)-3*a6_ad(i)
        a6_ad(i) = 0.d0
      endif
      a6_ad(i) = a6_ad(i)+a6da_ad*da1
      da1_ad = da1_ad+a6da_ad*a6(i)
      a6da_ad = 0.d0
      da1_ad = da1_ad+2*da2_ad*da1
      da2_ad = 0.d0
      al_ad(i) = al_ad(i)-da1_ad
      ar_ad(i) = ar_ad(i)+da1_ad
      da1_ad = 0.d0
    endif
  end do
else
  if (lmt .eq. 1) then
    do i = 1, im
      da1_ad = 0.d0
      dl_ad = 0.d0
      dr_ad = 0.d0
      da1 = dm(i)+dm(i)
      dl_ad = dl_ad+3*a6_ad(i)
      dr_ad = dr_ad-3*a6_ad(i)
      a6_ad(i) = 0.d0
      dl_ad = dl_ad-al_ad(i)
      p_ad(i) = p_ad(i)+al_ad(i)
      al_ad(i) = 0.d0
      dr_ad = dr_ad+ar_ad(i)
      p_ad(i) = p_ad(i)+ar_ad(i)
      ar_ad(i) = 0.d0
      ar_ad(i) = ar_ad(i)+dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      da1_ad = da1_ad+dr_ad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
      p_ad(i) = p_ad(i)-dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
      dr_ad = 0.d0
      al_ad(i) = al_ad(i)+dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      da1_ad = da1_ad+dl_ad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
      p_ad(i) = p_ad(i)-dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
      dl_ad = 0.d0
      dm_ad(i) = dm_ad(i)+2*da1_ad
      da1_ad = 0.d0
    end do
  else
    if (lmt .eq. 2) then
      do i = 1, im-1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              ar(i) = p(i)
              al(i) = p(i)
              a6(i) = 0.
            else if (ar(i) .gt. al(i)) then
              a6(i) = 3.*(al(i)-p(i))
              ar(i) = al(i)-a6(i)
            else
              a6(i) = 3.*(ar(i)-p(i))
              al(i) = ar(i)-a6(i)
            endif
          endif
        endif
      end do
      do i = im, 1, -1
        if (abs(ar(i)-al(i)) .lt. (-a6(i))) then
          fmin = p(i)+0.25*(ar(i)-al(i))**2/a6(i)+a6(i)*r12
          if (fmin .lt. 0.) then
            if (p(i) .lt. ar(i) .and. p(i) .lt. al(i)) then
              a6_ad(i) = 0.d0
              p_ad(i) = p_ad(i)+al_ad(i)
              al_ad(i) = 0.d0
              p_ad(i) = p_ad(i)+ar_ad(i)
              ar_ad(i) = 0.d0
            else if (ar(i) .gt. al(i)) then
              a6_ad(i) = a6_ad(i)-ar_ad(i)
              al_ad(i) = al_ad(i)+ar_ad(i)
              ar_ad(i) = 0.d0
              al_ad(i) = al_ad(i)+3*a6_ad(i)
              p_ad(i) = p_ad(i)-3*a6_ad(i)
              a6_ad(i) = 0.d0
            else
              a6_ad(i) = a6_ad(i)-al_ad(i)
              ar_ad(i) = ar_ad(i)+al_ad(i)
              al_ad(i) = 0.d0
              ar_ad(i) = ar_ad(i)+3*a6_ad(i)
              p_ad(i) = p_ad(i)-3*a6_ad(i)
              a6_ad(i) = 0.d0
            endif
          endif
          a6_ad(i) = a6_ad(i)+fmin_ad*((-(0.25*(ar(i)-al(i))**2/(a6(i)*a6(i))))+r12)
          al_ad(i) = al_ad(i)+fmin_ad*((-0.5)*(ar(i)-al(i))/a6(i))
          ar_ad(i) = ar_ad(i)+fmin_ad*(0.5*(ar(i)-al(i))/a6(i))
          p_ad(i) = p_ad(i)+fmin_ad
          fmin_ad = 0.d0
        endif
      end do
    else
      if (lmt .eq. 3) then
        do i = 1, im
          da1_ad = 0.d0
          dl_ad = 0.d0
          dr_ad = 0.d0
          da1 = 4.*dm(i)
          dl_ad = dl_ad+3*a6_ad(i)
          dr_ad = dr_ad-3*a6_ad(i)
          a6_ad(i) = 0.d0
          dl_ad = dl_ad-al_ad(i)
          p_ad(i) = p_ad(i)+al_ad(i)
          al_ad(i) = 0.d0
          dr_ad = dr_ad+ar_ad(i)
          p_ad(i) = p_ad(i)+ar_ad(i)
          ar_ad(i) = 0.d0
          ar_ad(i) = ar_ad(i)+dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          da1_ad = da1_ad+dr_ad*(0.5+sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(ar(i)-p(i))))
          p_ad(i) = p_ad(i)-dr_ad*(0.5-sign(0.5d0,abs(ar(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,ar(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(ar(i)-p(i))))
          dr_ad = 0.d0
          al_ad(i) = al_ad(i)+dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          da1_ad = da1_ad+dl_ad*(0.5+sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,da1)*sign(1.d0,min(abs(da1),&
&abs(al(i)-p(i))))
          p_ad(i) = p_ad(i)-dl_ad*(0.5-sign(0.5d0,abs(al(i)-p(i))-abs(da1)))*sign(1.d0,da1)*sign(1.d0,al(i)-p(i))*sign(1.d0,&
&min(abs(da1),abs(al(i)-p(i))))
          dl_ad = 0.d0
          dm_ad(i) = dm_ad(i)+4*da1_ad
          da1_ad = 0.d0
        end do
      endif
    endif
  endif
endif

end subroutine lmppm_ad


subroutine steepx_ad( im, p, p_ad, al_ad, dm, dm_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: al_ad(im)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
real(kind=r8) :: p(-(im/3):im+im/3)
real(kind=r8) :: p_ad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bbb_ad
real(kind=r8) :: ccc_ad
real(kind=r8) :: d2(0:im+1)
real(kind=r8) :: d2_ad(0:im+1)
real(kind=r8) :: dh(0:im)
real(kind=r8) :: dh_ad(0:im)
real(kind=r8) :: eta(0:im)
real(kind=r8) :: eta_ad(0:im)
integer :: i
real(kind=r8) :: xxx
real(kind=r8) :: xxx_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
bbb_ad = 0.d0
ccc_ad = 0.d0
d2_ad(:) = 0.d0
dh_ad(:) = 0.d0
eta_ad(:) = 0.d0
xxx_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do i = 0, im
  dh(i) = p(i+1)-p(i)
end do
do i = 1, im
  d2(i) = dh(i)-dh(i-1)
end do
d2(0) = d2(im)
d2(im+1) = d2(1)
do i = 1, im
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    eta(i) = max(0._8,min(xxx,0.5_8))
  else
    eta(i) = 0.
  endif
end do
eta(0) = eta(im)
do i = 1, im
  bbb_ad = 0.d0
  ccc_ad = 0.d0
  bbb_ad = bbb_ad+al_ad(i)*r3
  ccc_ad = ccc_ad-al_ad(i)*r3
  dh_ad(i-1) = dh_ad(i-1)+0.5*al_ad(i)*(eta(i-1)-eta(i))
  eta_ad(i-1) = eta_ad(i-1)+0.5*al_ad(i)*dh(i-1)
  eta_ad(i) = eta_ad(i)-0.5*al_ad(i)*dh(i-1)
  dm_ad(i) = dm_ad(i)+ccc_ad*(2.*eta(i-1)-eta(i))
  eta_ad(i-1) = eta_ad(i-1)+2*ccc_ad*dm(i)
  eta_ad(i) = eta_ad(i)-ccc_ad*dm(i)
  ccc_ad = 0.d0
  dm_ad(i-1) = dm_ad(i-1)+bbb_ad*(2.*eta(i)-eta(i-1))
  eta_ad(i-1) = eta_ad(i-1)-bbb_ad*dm(i-1)
  eta_ad(i) = eta_ad(i)+2*bbb_ad*dm(i-1)
  bbb_ad = 0.d0
end do
eta_ad(im) = eta_ad(im)+eta_ad(0)
eta_ad(0) = 0.d0
do i = 1, im
  xxx_ad = 0.d0
  if (d2(i+1)*d2(i-1) .lt. 0. .and. p(i+1) .ne. p(i-1)) then
    xxx = 1.-0.5*(p(i+2)-p(i-2))/(p(i+1)-p(i-1))
    xxx_ad = xxx_ad+eta_ad(i)*(0.5-sign(0.5d0,0._8-min(xxx,0.5_8)))*(0.5+sign(0.5d0,0.5_8-xxx))
    eta_ad(i) = 0.d0
    p_ad(i-2) = p_ad(i-2)-xxx_ad*((-0.5)/(p(i+1)-p(i-1)))
    p_ad(i-1) = p_ad(i-1)+xxx_ad*((-0.5)*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    p_ad(i+2) = p_ad(i+2)-xxx_ad*(0.5/(p(i+1)-p(i-1)))
    p_ad(i+1) = p_ad(i+1)+xxx_ad*(0.5*(p(i+2)-p(i-2))/((p(i+1)-p(i-1))*(p(i+1)-p(i-1))))
    xxx_ad = 0.d0
  else
    eta_ad(i) = 0.d0
  endif
end do
d2_ad(1) = d2_ad(1)+d2_ad(im+1)
d2_ad(im+1) = 0.d0
d2_ad(im) = d2_ad(im)+d2_ad(0)
d2_ad(0) = 0.d0
do i = 1, im
  dh_ad(i-1) = dh_ad(i-1)-d2_ad(i)
  dh_ad(i) = dh_ad(i)+d2_ad(i)
  d2_ad(i) = 0.d0
end do
do i = 0, im
  p_ad(i+1) = p_ad(i+1)+dh_ad(i)
  p_ad(i) = p_ad(i)-dh_ad(i)
  dh_ad(i) = 0.d0
end do

end subroutine steepx_ad


subroutine tp2c_ad( dh_ad, va, va_ad, h, h_ad, crx, crx_ad, cry, cry_ad, im, jm, iord, jord, ng, fx, fx_ad, fy, fy_ad, ffsl, rcap, &
&acosp, xfx, xfx_ad, yfx, yfx_ad, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: acosp(jm)
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_ad(im,jfirst:jlast+1)
real(kind=r8) :: dh_ad(im,jfirst:jlast)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ad(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ad(im,jfirst:jlast+1)
real(kind=r8) :: h(im,jfirst-ng:jlast+ng)
real(kind=r8) :: h_ad(im,jfirst-ng:jlast+ng)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: rcap
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_ad(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_ad(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_ad(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
real(kind=r8) :: sum1_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
sum1_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
if (jlast .eq. jm) then
  do i = 1, im
    sum1_ad = sum1_ad+dh_ad(i,jm)
    dh_ad(i,jm) = 0.d0
  end do
  sum1_ad = sum1_ad*rcap
  do i = 1, im
    fy_ad(i,jm) = fy_ad(i,jm)+sum1_ad
  end do
  sum1_ad = 0.d0
endif
if (jfirst .eq. 1) then
  do i = 1, im
    sum1_ad = sum1_ad+dh_ad(i,1)
    dh_ad(i,1) = 0.d0
  end do
  sum1_ad = -(sum1_ad*rcap)
  do i = 1, im
    fy_ad(i,2) = fy_ad(i,2)+sum1_ad
  end do
endif
do j = js2g0, jn2g0
  fx_ad(im,j) = fx_ad(im,j)+dh_ad(im,j)
  fx_ad(1,j) = fx_ad(1,j)-dh_ad(im,j)
  fy_ad(im,j+1) = fy_ad(im,j+1)-dh_ad(im,j)*acosp(j)
  fy_ad(im,j) = fy_ad(im,j)+dh_ad(im,j)*acosp(j)
  dh_ad(im,j) = 0.d0
end do
do j = js2g0, jn2g0
  do i = 1, im-1
    fx_ad(i+1,j) = fx_ad(i+1,j)-dh_ad(i,j)
    fx_ad(i,j) = fx_ad(i,j)+dh_ad(i,j)
    fy_ad(i,j+1) = fy_ad(i,j+1)-dh_ad(i,j)*acosp(j)
    fy_ad(i,j) = fy_ad(i,j)+dh_ad(i,j)*acosp(j)
    dh_ad(i,j) = 0.d0
  end do
end do
call tp2d_ad( va,va_ad,h,h_ad,crx,crx_ad,cry,cry_ad,im,jm,iord,jord,ng,fx,fx_ad,fy,fy_ad,ffsl,xfx,xfx_ad,yfx,yfx_ad,cosp,id,jfirst,&
&jlast )

end subroutine tp2c_ad


subroutine tp2d_ad( va, va_ad, q, q_ae, crx, crx_ad, cry, cry_ad, im, jm, iord, jord, ng, fx, fx_ad, fy, fy_ad, ffsl, xfx, xfx_ad, &
&yfx, yfx_ad, cosp, id, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: crx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: crx_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: cry(im,jfirst:jlast+1)
real(kind=r8) :: cry_ad(im,jfirst:jlast+1)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ad(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ad(im,jfirst:jlast+1)
integer :: id
integer :: iord
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_ad(im,jfirst:jlast)
real(kind=r8) :: xfx(im,jfirst:jlast)
real(kind=r8) :: xfx_ad(im,jfirst:jlast)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_ad(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-ng:jlast+ng)
real(kind=r8) :: adx_ad(im,jfirst-ng:jlast+ng)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dmh_ad(1+im+2*(im/3))
real(kind=r8) :: dmi_ad(1+im+2*(im/3))
real(kind=r8) :: dmj_ad(1+im+2*(im/3))
real(kind=r8) :: dmk_ad(1+im+2*(im/3))
integer :: i
integer :: iad
integer :: j
integer :: jn2g0
integer :: jn2gng
integer :: jp
integer :: js2g0
integer :: js2gng
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmph_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpj_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpk_ad(1+im+2*(im/3))
real(kind=8), allocatable :: tp2d_tape1_a6_1h(:,:)
real(kind=8), allocatable :: tp2d_tape1_dm_2h(:,:)
integer :: tp2d_tape1_tp2d
real(kind=8), allocatable :: tp2d_tape2_a6_2h(:,:)
real(kind=8), allocatable :: tp2d_tape2_adx_1h(:,:,:)
real(kind=8), allocatable :: tp2d_tape2_dm_3h(:,:)
integer :: tp2d_tape2_tp2d
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_ad(im)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6_ad(:) = 0.d0
adx_ad(:,:) = 0.d0
dmh_ad(:) = 0.d0
dmi_ad(:) = 0.d0
dmj_ad(:) = 0.d0
dmk_ad(:) = 0.d0
qtmph_ad(:) = 0.d0
qtmpi_ad(:) = 0.d0
qtmpj_ad(:) = 0.d0
qtmpk_ad(:) = 0.d0
wk1_ad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gng = max(2,jfirst-ng)
jn2g0 = min(jm-1,jlast)
jn2gng = min(jm-1,jlast+ng)
iad = 1
!----------------------------------------------
! OPEN TAPE tp2d_tape1
!----------------------------------------------
tp2d_tape1_tp2d = jn2gng-js2gng+1

!----------------------------------------------
! OPEN TAPE tp2d_tape2
!----------------------------------------------
tp2d_tape2_tp2d = jn2g0-js2g0+1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do j = js2gng, jn2gng
  if ( .not. allocated(tp2d_tape1_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_a6_1h)) then
      allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_a6_1h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_a6_1h(:,1+j-js2gng) = a6
  if ( .not. allocated(tp2d_tape1_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape1_dm_2h)) then
      allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape1_dm_2h(1:1+im+2*(im/3),tp2d_tape1_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape1_dm_2h(:,1+j-js2gng) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),iad,crx(1,j),cosp(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im
    adx(i,1) = q(i,1)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im
    adx(i,jm) = q(i,jm)
  end do
endif
if ( .not. allocated(tp2d_tape2_adx_1h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_adx_1h)) then
    allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_adx_1h(1:im,1:1+jlast+ng-(jfirst-ng),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_adx_1h(:,:,1) = adx
do j = js2g0, jn2g0-1
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_a6_2h)) then
      allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tp2d_tape2_dm_3h)) then
      allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
  endif
  tp2d_tape2_dm_3h(:,1+j-js2g0) = dm
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp( im,ffsl(j),fx(1,j),wk1,crx(1,j),iord,xfx(1,j),cosp(j),id,dm,qtmp,al,ar,a6 )
end do
j = jn2g0
if ( .not. allocated(tp2d_tape2_a6_2h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_a6_2h)) then
    allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_a6_2h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_a6_2h(:,1+j-js2g0) = a6
if ( .not. allocated(tp2d_tape2_dm_3h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(tp2d_tape2_dm_3h)) then
    allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( tp2d_tape2_dm_3h(1:1+im+2*(im/3),tp2d_tape2_tp2d) )
#endif /* USE_OPENMP */
endif
tp2d_tape2_dm_3h(:,1+j-js2g0) = dm

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
adx = tp2d_tape2_adx_1h(:,:,1)
do j = jn2g0, js2g0, -1
  a6 = tp2d_tape2_a6_2h(:,1+j-js2g0)
  dm = tp2d_tape2_dm_3h(:,1+j-js2g0)
  do i = 1, im
    jp = j-va(i,j)
    wk1(i) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
  call xtp_ad( im,ffsl(j),fx(1,j),fx_ad(1,j),wk1,wk1_ad,crx(1,j),crx_ad(1,j),iord,xfx(1,j),xfx_ad(1,j),cosp(j),id,dm,dmj_ad,qtmp,&
&qtmpj_ad,al,ar,a6,a6_ad )
  do i = 1, im
    jp = j-va(i,j)
    q_ae(i,jp+1) = q_ae(i,jp+1)-0.5*wk1_ad(i)*va(i,j)
    q_ae(i,j) = q_ae(i,j)+wk1_ad(i)
    q_ae(i,jp) = q_ae(i,jp)+0.5*wk1_ad(i)*va(i,j)
    va_ad(i,j) = va_ad(i,j)+0.5*wk1_ad(i)*(q(i,jp)-q(i,jp+1))
    wk1_ad(i) = 0.d0
  end do
end do
call ytp_ad( im,jm,fy,fy_ad,adx,adx_ad,cry,cry_ad,yfx,yfx_ad,ng,jord,0,jfirst,jlast )
if (jlast .eq. jm) then
  do i = 1, im
    q_ae(i,jm) = q_ae(i,jm)+adx_ad(i,jm)
    adx_ad(i,jm) = 0.d0
  end do
endif
if (jfirst .eq. 1) then
  do i = 1, im
    q_ae(i,1) = q_ae(i,1)+adx_ad(i,1)
    adx_ad(i,1) = 0.d0
  end do
endif
do j = jn2gng, js2gng, -1
  a6 = tp2d_tape1_a6_1h(:,1+j-js2gng)
  dm = tp2d_tape1_dm_2h(:,1+j-js2gng)
  crx_ad(im,j) = crx_ad(im,j)-0.5*adx_ad(im,j)*q(im,j)
  crx_ad(1,j) = crx_ad(1,j)+0.5*adx_ad(im,j)*q(im,j)
  q_ae(im,j) = q_ae(im,j)+adx_ad(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))
  wk1_ad(im) = wk1_ad(im)+0.5*adx_ad(im,j)
  wk1_ad(1) = wk1_ad(1)-0.5*adx_ad(im,j)
  adx_ad(im,j) = 0.d0
  do i = 1, im-1
    crx_ad(i+1,j) = crx_ad(i+1,j)+0.5*adx_ad(i,j)*q(i,j)
    crx_ad(i,j) = crx_ad(i,j)-0.5*adx_ad(i,j)*q(i,j)
    q_ae(i,j) = q_ae(i,j)+adx_ad(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))
    wk1_ad(i+1) = wk1_ad(i+1)-0.5*adx_ad(i,j)
    wk1_ad(i) = wk1_ad(i)+0.5*adx_ad(i,j)
    adx_ad(i,j) = 0.d0
  end do
  call xtp_ad( im,ffsl(j),wk1,wk1_ad,q(1,j),q_ae(1,j),crx(1,j),crx_ad(1,j),iad,crx(1,j),crx_ad(1,j),cosp(j),0,dm,dmk_ad,qtmp,&
&qtmpk_ad,al,ar,a6,a6_ad )
end do

!----------------------------------------------
! CLOSE TAPE tp2d_tape1
!----------------------------------------------
if (allocated(tp2d_tape1_a6_1h)) then
  deallocate( tp2d_tape1_a6_1h )
endif
if (allocated(tp2d_tape1_dm_2h)) then
  deallocate( tp2d_tape1_dm_2h )
endif

!----------------------------------------------
! CLOSE TAPE tp2d_tape2
!----------------------------------------------
if (allocated(tp2d_tape2_adx_1h)) then
  deallocate( tp2d_tape2_adx_1h )
endif
if (allocated(tp2d_tape2_a6_2h)) then
  deallocate( tp2d_tape2_a6_2h )
endif
if (allocated(tp2d_tape2_dm_3h)) then
  deallocate( tp2d_tape2_dm_3h )
endif


end subroutine tp2d_ad


subroutine tpcc_ad( va, va_ad, ymass, ymass_ad, q, q_ae, crx, crx_ad, cry, cry_ad, im, jm, ng, iord, jord, fx, fx_ad, fy_ad, ffsl, &
&cose, jfirst, jlast, dm, qtmp, al, ar, a6, a6_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_ad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: crx_ad(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: cry_ad(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fx_ad(im,jfirst:jlast)
real(kind=r8) :: fy_ad(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: va_ad(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)
real(kind=r8) :: ymass_ad(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h(-(im/3):im+im/3)
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: adx_ad(im,jfirst-1:jlast+2)
real(kind=r8) :: dmh_ad(1+im+2*(im/3))
real(kind=r8) :: dmi_ad(1+im+2*(im/3))
real(kind=r8) :: fx1(im)
real(kind=r8) :: fx1_ad(im)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
real(kind=r8) :: qh(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmph_ad(1+im+2*(im/3))
real(kind=r8) :: qtmpi_ad(1+im+2*(im/3))
integer :: south
real(kind=r8) :: wk1(im)
real(kind=r8) :: wk1_ad(im)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
qh(:,:) = q(:,:)
a6h(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
adx_ad(:,:) = 0.d0
dmh_ad(:) = 0.d0
dmi_ad(:) = 0.d0
fx1_ad(:) = 0.d0
qtmph_ad(:) = 0.d0
qtmpi_ad(:) = 0.d0
wk1_ad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = jn1g0, js2g0, -1
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  a6 = tpcc2_tape_a6_1h(:,irec)
  dm = tpcc2_tape_dm_2h(:,irec)
  call xtp_ad( im,ffsl(j),fx(1,j),fx_ad(1,j),adx(1,j),adx_ad(1,j),crx(1,j),crx_ad(1,j),iord,crx(1,j),crx_ad(1,j),cose(j),0,dm,&
&dmh_ad,qtmp,qtmph_ad,al,ar,a6,a6_ad )
end do
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    q_ae(i,jp+1) = q_ae(i,jp+1)-0.5*adx_ad(i,j)*va(i,j)
    q_ae(i,j) = q_ae(i,j)+adx_ad(i,j)
    q_ae(i,jp) = q_ae(i,jp)+0.5*adx_ad(i,j)*va(i,j)
    va_ad(i,j) = va_ad(i,j)+0.5*adx_ad(i,j)*(q(i,jp)-q(i,jp+1))
    adx_ad(i,j) = 0.d0
  end do
end do
if (jlast .eq. jm) then
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      q_ae(i,jm-1) = q_ae(i,jm-1)+0.5*adx_ad(i,jm)*va(i,jm)
      q_ae(i,jm) = q_ae(i,jm)+adx_ad(i,jm)*(1+(-0.5)*va(i,jm))
      va_ad(i,jm) = va_ad(i,jm)+0.5*adx_ad(i,jm)*(q(i,jm-1)-q(i,jm))
      adx_ad(i,jm) = 0.d0
    else
      fx1_ad(i) = fx1_ad(i)-0.5*adx_ad(i,jm)*va(i,jm)
      q_ae(i,jm) = q_ae(i,jm)+adx_ad(i,jm)*(1+0.5*va(i,jm))
      va_ad(i,jm) = va_ad(i,jm)+0.5*adx_ad(i,jm)*(q(i,jm)-fx1(i))
      adx_ad(i,jm) = 0.d0
    endif
  end do
  do i = im2+1, im
    q_ae(i-im2,jm) = q_ae(i-im2,jm)+fx1_ad(i)
    fx1_ad(i) = 0.d0
  end do
  do i = 1, im2
    q_ae(i+im2,jm) = q_ae(i+im2,jm)+fx1_ad(i)
    fx1_ad(i) = 0.d0
  end do
endif
if (jfirst .eq. 1) then
  do i = im2+1, im
    q_ae(i-im2,2) = q_ae(i-im2,2)+q_ae(i,1)
    q_ae(i,1) = 0.d0
  end do
  do i = 1, im2
    q_ae(i+im2,2) = q_ae(i+im2,2)+q_ae(i,1)
    q_ae(i,1) = 0.d0
  end do
endif
a6(:) = a6h(:)
q(:,:) = qh(:,:)
do j = js2gs, jn1gn
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc_ad( im,jm,fy_ad,adx,adx_ad,cry,cry_ad,ymass,ymass_ad,jord,0,jfirst,jlast )
q(:,:) = qh(:,:)
do j = jn1gn, js2gs, -1
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  a6 = tpcc1_tape_a6_1h(:,irec)
  dm = tpcc1_tape_dm_2h(:,irec)
  crx_ad(im,j) = crx_ad(im,j)-0.5*adx_ad(im,j)*q(im,j)
  crx_ad(1,j) = crx_ad(1,j)+0.5*adx_ad(im,j)*q(im,j)
  q_ae(im,j) = q_ae(im,j)+adx_ad(im,j)*(1+0.5*(crx(1,j)-crx(im,j)))
  wk1_ad(im) = wk1_ad(im)+0.5*adx_ad(im,j)
  wk1_ad(1) = wk1_ad(1)-0.5*adx_ad(im,j)
  adx_ad(im,j) = 0.d0
  do i = 1, im-1
    crx_ad(i+1,j) = crx_ad(i+1,j)+0.5*adx_ad(i,j)*q(i,j)
    crx_ad(i,j) = crx_ad(i,j)-0.5*adx_ad(i,j)*q(i,j)
    q_ae(i,j) = q_ae(i,j)+adx_ad(i,j)*(1+0.5*(crx(i+1,j)-crx(i,j)))
    wk1_ad(i+1) = wk1_ad(i+1)-0.5*adx_ad(i,j)
    wk1_ad(i) = wk1_ad(i)+0.5*adx_ad(i,j)
    adx_ad(i,j) = 0.d0
  end do
  call xtp_ad( im,ffsl(j),wk1,wk1_ad,q(1,j),q_ae(1,j),crx(1,j),crx_ad(1,j),1,crx(1,j),crx_ad(1,j),cose(j),0,dm,dmi_ad,qtmp,&
&qtmpi_ad,al,ar,a6,a6_ad )
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine tpcc_ad


subroutine tpccmd( va, ymass, q, crx, cry, im, jm, ng, iord, jord, fx, fy, ffsl, cose, jfirst, jlast, dm, qtmp, al, ar, a6 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use tpcc_ad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
integer :: jm
real(kind=r8) :: cose(jm)
integer :: jfirst
integer :: jlast
real(kind=r8) :: crx(im,jfirst-1:jlast+2)
real(kind=r8) :: cry(im,jfirst:jlast)
real(kind=r8) :: dm(-(im/3):im+im/3)
logical :: ffsl(jm)
real(kind=r8) :: fx(im,jfirst:jlast)
real(kind=r8) :: fy(im,jfirst:jlast)
integer :: iord
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: va(im,jfirst:jlast)
real(kind=r8) :: ymass(im,jfirst:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: adx(im,jfirst-1:jlast+2)
real(kind=r8) :: fx1(im)
integer :: i
integer :: im2
integer :: irec
integer :: j
integer :: jn1g0
integer :: jn1gn
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: js2gs
integer :: north
integer :: south
real(kind=r8) :: wk1(im)

!**********************************************
! executable statements of routine
!**********************************************
im2 = im/2
north = min(2,abs(jord))
south = north-1
js2g0 = max(2,jfirst)
js2gs = max(2,jfirst-south)
jn2g0 = min(jm-1,jlast)
jn1gn = min(jm,jlast+north)
jn1g0 = min(jm,jlast)
do j = js2gs, jn1gn
  irec = 1+j-js2gs+tpcc_tape_rec*(jn1gn-js2gs)
  if ( .not. allocated(tpcc1_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_a6_1h)) then
      allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_a6_1h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc1_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc1_tape_dm_2h)) then
      allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc1_tape_dm_2h(1:1+im+2*(im/3),tpcc1_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc1_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),wk1,q(1,j),crx(1,j),1,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
  do i = 1, im-1
    adx(i,j) = q(i,j)+0.5*(wk1(i)-wk1(i+1)+q(i,j)*(crx(i+1,j)-crx(i,j)))
  end do
  adx(im,j) = q(im,j)+0.5*(wk1(im)-wk1(1)+q(im,j)*(crx(1,j)-crx(im,j)))
end do
call ycc( im,jm,fy,adx,cry,ymass,jord,0,jfirst,jlast )
if (jfirst .eq. 1) then
  do i = 1, im2
    q(i,1) = q(i+im2,2)
  end do
  do i = im2+1, im
    q(i,1) = q(i-im2,2)
  end do
endif
if (jlast .eq. jm) then
  do i = 1, im2
    fx1(i) = q(i+im2,jm)
  end do
  do i = im2+1, im
    fx1(i) = q(i-im2,jm)
  end do
  do i = 1, im
    if (va(i,jm) .gt. 0.) then
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm-1)-q(i,jm))
    else
      adx(i,jm) = q(i,jm)+0.5*va(i,jm)*(q(i,jm)-fx1(i))
    endif
  end do
endif
do j = js2g0, jn2g0
  do i = 1, im
    jp = j-va(i,j)
    adx(i,j) = q(i,j)+0.5*va(i,j)*(q(i,jp)-q(i,jp+1))
  end do
end do
do j = js2g0, jn1g0
  irec = 1+j-js2g0+tpcc_tape_rec*(jn1g0-js2g0)
  if ( .not. allocated(tpcc2_tape_a6_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_a6_1h)) then
      allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_a6_1h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_a6_1h(:,irec) = a6
  if ( .not. allocated(tpcc2_tape_dm_2h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(tpcc2_tape_dm_2h)) then
      allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( tpcc2_tape_dm_2h(1:1+im+2*(im/3),tpcc2_tape_tpcc) )
#endif /* USE_OPENMP */
  endif
  tpcc2_tape_dm_2h(:,irec) = dm
  call xtp( im,ffsl(j),fx(1,j),adx(1,j),crx(1,j),iord,crx(1,j),cose(j),0,dm,qtmp,al,ar,a6 )
end do
end subroutine tpccmd


subroutine xmist_ad( im, q, q_ae, dm, dm_ad, id )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r24 = 1./24.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
integer :: id
real(kind=r8) :: q(-(im/3):im+im/3)
real(kind=r8) :: q_ae(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_ad
double precision :: dmi_ad
integer :: i
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_ad = 0.d0
qmin_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (id .le. 2) then
  do i = 1, im
    dm(i) = r24*(8.*(q(i+1)-q(i-1))+q(i-2)-q(i+2))
  end do
else
  do i = 1, im
    dm(i) = 0.25*(q(i+1)-q(i-1))
  end do
endif
if (id .ge. 0) then
  do i = 1, im
    qmax_ad = 0.d0
    qmin_ad = 0.d0
    qmax = max(q(i-1),q(i),q(i+1))-q(i)
    qmin = q(i)-min(q(i-1),q(i),q(i+1))
    dmh = min(abs(dm(i)),qmax)
    dmi_ad = dm_ad(i)*sign(1.d0,min(dmh,qmin))*sign(1.d0,dm(i))
    dmh_ad = dmi_ad*(0.5+sign(0.5d0,qmin-dmh))
    qmin_ad = qmin_ad+dmi_ad*(0.5-sign(0.5d0,qmin-dmh))
    qmax_ad = qmax_ad+dmh_ad*(0.5-sign(0.5d0,qmax-abs(dm(i))))
    dm_ad(i) = dmh_ad*(0.5+sign(0.5d0,qmax-abs(dm(i))))*sign(1.d0,dm(i))
    qminh = min(q(i-1),q(i))
    q_ae(i) = q_ae(i)+qmin_ad
    qmini_ad = -qmin_ad
    q_ae(i+1) = q_ae(i+1)+qmini_ad*(0.5-sign(0.5d0,q(i+1)-qminh))
    qminh_ad = qmini_ad*(0.5+sign(0.5d0,q(i+1)-qminh))
    q_ae(i-1) = q_ae(i-1)+qminh_ad*(0.5+sign(0.5d0,q(i)-q(i-1)))
    q_ae(i) = q_ae(i)+qminh_ad*(0.5-sign(0.5d0,q(i)-q(i-1)))
    qmin_ad = 0.d0
    qmaxh = max(q(i-1),q(i))
    q_ae(i) = q_ae(i)-qmax_ad
    q_ae(i+1) = q_ae(i+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-q(i+1)))
    qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-q(i+1)))
    q_ae(i-1) = q_ae(i-1)+qmaxh_ad*(0.5+sign(0.5d0,q(i-1)-q(i)))
    q_ae(i) = q_ae(i)+qmaxh_ad*(0.5-sign(0.5d0,q(i-1)-q(i)))
    qmax_ad = 0.d0
  end do
endif
if (id .le. 2) then
  do i = 1, im
    q_ae(i-2) = q_ae(i-2)+dm_ad(i)*r24
    q_ae(i-1) = q_ae(i-1)-8*dm_ad(i)*r24
    q_ae(i+2) = q_ae(i+2)-dm_ad(i)*r24
    q_ae(i+1) = q_ae(i+1)+8*dm_ad(i)*r24
    dm_ad(i) = 0.d0
  end do
else
  do i = 1, im
    q_ae(i-1) = q_ae(i-1)-0.25*dm_ad(i)
    q_ae(i+1) = q_ae(i+1)+0.25*dm_ad(i)
    dm_ad(i) = 0.d0
  end do
endif

end subroutine xmist_ad


subroutine xtp_ad( im, ffsl, fx, fx_ad, q, q_ae, c, c_ad, iord, mfx, mfx_ad, cosa, id, dm, dm_ad, qtmp, qtmp_ad, al, ar, a6, a6_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: cos_ppm = 0.25
real(kind=r8), parameter :: cos_upw = 0.05
real(kind=r8), parameter :: cos_van = 0.25

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a6(-(im/3):im+im/3)
real(kind=r8) :: a6_ad(-(im/3):im+im/3)
real(kind=r8) :: al(-(im/3):im+im/3)
real(kind=r8) :: ar(-(im/3):im+im/3)
real(kind=r8) :: c(im)
real(kind=r8) :: c_ad(im)
real(kind=r8) :: cosa
real(kind=r8) :: dm(-(im/3):im+im/3)
real(kind=r8) :: dm_ad(-(im/3):im+im/3)
logical :: ffsl
real(kind=r8) :: fx(im)
real(kind=r8) :: fx_ad(im)
integer :: id
integer :: iord
real(kind=r8) :: mfx(im)
real(kind=r8) :: mfx_ad(im)
real(kind=r8) :: q(im)
real(kind=r8) :: q_ae(im)
real(kind=r8) :: qtmp(-(im/3):im+im/3)
real(kind=r8) :: qtmp_ad(-(im/3):im+im/3)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a6h(-(im/3):im+im/3)
real(kind=r8) :: alh_ad(1+im+2*(im/3))
real(kind=r8) :: ali_ad(1+im+2*(im/3))
real(kind=r8) :: arh_ad(1+im+2*(im/3))
real(kind=r8) :: ari_ad(1+im+2*(im/3))
double precision :: dmh_ad
double precision :: dmi_ad
double precision :: dmj
double precision :: dmj_ad
real(kind=r8) :: dmk(-(im/3):im+im/3)
double precision :: dmk_ad
integer :: i
integer :: imp
integer :: isave(im)
integer :: ist
integer :: itmp
integer :: iu
integer :: iue
integer :: iuw
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad
real(kind=r8) :: rut
real(kind=r8) :: rut_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad
logical :: c_adEQmfx_ad  ! .true. if c_ad and mfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
c_adEQmfx_ad = loc(c_ad) == loc(mfx_ad)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
dmk(:) = dm(:)
a6h(:) = a6(:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alh_ad(:) = 0.d0
ali_ad(:) = 0.d0
arh_ad(:) = 0.d0
ari_ad(:) = 0.d0
qmax_ad = 0.d0
qmin_ad = 0.d0
rut_ad = 0.d0
tmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
imp = im+1
do i = 1, im
  qtmp(i) = q(i)
end do
iuw = -c(1)
iuw = min(0,iuw)
iue = im-c(im)
iue = max(imp,iue)
if (ffsl) then
  do i = iuw, 0
    qtmp(i) = q(im+i)
  end do
  do i = imp, iue
    qtmp(i) = q(i-im)
  end do
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
        isave(i) = itmp-1
      else
        itmp = i-iu-1
        isave(i) = itmp+1
      endif
      fx(i) = (c(i)-iu)*qtmp(itmp)
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm( im,c,mfx,qtmp,dm,fx,iord,al,ar,a6,iuw,iue,ffsl,isave )
    else
      do i = 1, im
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          isave(i) = itmp-1
          fx(i) = rut*(qtmp(itmp)-dm(itmp)*(1.+rut))
        else
          itmp = i-iu-1
          isave(i) = itmp+1
          fx(i) = rut*(qtmp(itmp)+dm(itmp)*(1.-rut))
        endif
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        fx(i) = fx(i)+qtmp(ist)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        fx(i) = fx(i)-qtmp(ist)
      end do
    endif
  end do
  if (id .ne. 0) then
    if(c_adEQmfx_ad) then
      do i = 1, im
        c_ad(i) = c_ad(i)+fx_ad(i)*fx(i)
        fx_ad(i) = fx_ad(i)*mfx(i)
      end do
    else
      do i = 1, im
        mfx_ad(i) = mfx_ad(i)+fx_ad(i)*fx(i)
        fx_ad(i) = fx_ad(i)*mfx(i)
      end do
    endif
  endif
  do i = 1, im
    if (c(i) .ge. 1.) then
      do ist = isave(i), i-1
        qtmp_ad(ist) = qtmp_ad(ist)+fx_ad(i)
      end do
    else if (c(i) .le. (-1.)) then
      do ist = i, isave(i)
        qtmp_ad(ist) = qtmp_ad(ist)-fx_ad(i)
      end do
    endif
  end do
  a6(:) = a6h(:)
  dm(:) = dmk(:)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    do i = 1, im
      iu = c(i)
      if (c(i) .le. 0.) then
        itmp = i-iu
      else
        itmp = i-iu-1
      endif
      c_ad(i) = c_ad(i)+fx_ad(i)*qtmp(itmp)
      qtmp_ad(itmp) = qtmp_ad(itmp)+fx_ad(i)*(c(i)-iu)
      fx_ad(i) = 0.d0
    end do
  else
    do i = 1, im
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dm(i) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = iuw, 0
      dm(i) = dm(im+i)
    end do
    do i = imp, iue
      dm(i) = dm(i-im)
    end do
    if (iord .ge. 3 .and. cosa .gt. cos_ppm) then
      call fxppm_ad( im,c,c_ad,mfx,mfx_ad,qtmp,qtmp_ad,dm,dm_ad,fx,fx_ad,iord,al,alh_ad,ar,arh_ad,a6,a6_ad,iuw,iue,ffsl )
    else
      do i = 1, im
        rut_ad = 0.d0
        iu = c(i)
        rut = c(i)-iu
        if (c(i) .le. 0.) then
          itmp = i-iu
          dm_ad(itmp) = dm_ad(itmp)-fx_ad(i)*rut*(1+rut)
          qtmp_ad(itmp) = qtmp_ad(itmp)+fx_ad(i)*rut
          rut_ad = rut_ad+fx_ad(i)*((-(rut*dm(itmp)))+qtmp(itmp)-dm(itmp)*(1.+rut))
          fx_ad(i) = 0.d0
        else
          itmp = i-iu-1
          dm_ad(itmp) = dm_ad(itmp)+fx_ad(i)*rut*(1.-rut)
          qtmp_ad(itmp) = qtmp_ad(itmp)+fx_ad(i)*rut
          rut_ad = rut_ad+fx_ad(i)*((-(rut*dm(itmp)))+qtmp(itmp)+dm(itmp)*(1.-rut))
          fx_ad(i) = 0.d0
        endif
        c_ad(i) = c_ad(i)+rut_ad
        rut_ad = 0.d0
      end do
    endif
    do i = iue, imp, -1
      dmh_ad = dm_ad(i)
      dm_ad(i) = 0.d0
      dm_ad(i-im) = dm_ad(i-im)+dmh_ad
    end do
    do i = 0, iuw, -1
      dmi_ad = dm_ad(i)
      dm_ad(i) = 0.d0
      dm_ad(im+i) = dm_ad(im+i)+dmi_ad
    end do
    do i = 1, im
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(qtmp(i+1)-qtmp(i-1))
      qmax = max(qtmp(i-1),qtmp(i),qtmp(i+1))-qtmp(i)
      qmin = qtmp(i)-min(qtmp(i-1),qtmp(i),qtmp(i+1))
      dmj = min(abs(tmp),qmax)
      dmk_ad = dm_ad(i)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_ad = dmk_ad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_ad = qmin_ad+dmk_ad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_ad = qmax_ad+dmj_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmj_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i) = 0.d0
      qminh = min(qtmp(i-1),qtmp(i))
      qmini_ad = -qmin_ad
      qtmp_ad(i) = qtmp_ad(i)+qmin_ad
      qminh_ad = qmini_ad*(0.5+sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_ad(i+1) = qtmp_ad(i+1)+qmini_ad*(0.5-sign(0.5d0,qtmp(i+1)-qminh))
      qtmp_ad(i-1) = qtmp_ad(i-1)+qminh_ad*(0.5+sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qtmp_ad(i) = qtmp_ad(i)+qminh_ad*(0.5-sign(0.5d0,qtmp(i)-qtmp(i-1)))
      qmin_ad = 0.d0
      qmaxh = max(qtmp(i-1),qtmp(i))
      qtmp_ad(i) = qtmp_ad(i)-qmax_ad
      qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_ad(i+1) = qtmp_ad(i+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-qtmp(i+1)))
      qtmp_ad(i-1) = qtmp_ad(i-1)+qmaxh_ad*(0.5+sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qtmp_ad(i) = qtmp_ad(i)+qmaxh_ad*(0.5-sign(0.5d0,qtmp(i-1)-qtmp(i)))
      qmax_ad = 0.d0
      qtmp_ad(i-1) = qtmp_ad(i-1)-0.25*tmp_ad
      qtmp_ad(i+1) = qtmp_ad(i+1)+0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
  do i = imp, iue
    q_ae(i-im) = q_ae(i-im)+qtmp_ad(i)
    qtmp_ad(i) = 0.d0
  end do
  do i = iuw, 0
    q_ae(im+i) = q_ae(im+i)+qtmp_ad(i)
    qtmp_ad(i) = 0.d0
  end do
else
  qtmp(imp) = q(1)
  qtmp(0) = q(im)
  if (iord .eq. 1 .or. cosa .lt. cos_upw) then
    if(c_adEQmfx_ad) then
      do i = 1, im
        iu = float(i)-c(i)
        c_ad(i) = c_ad(i)+fx_ad(i)*qtmp(iu)
        qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
        fx_ad(i) = 0.d0
      end do
    else
      do i = 1, im
        iu = float(i)-c(i)
        mfx_ad(i) = mfx_ad(i)+fx_ad(i)*qtmp(iu)
        qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
        fx_ad(i) = 0.d0
      end do
    endif
  else
    qtmp(-1) = q(im-1)
    qtmp(imp+1) = q(2)
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist( im,qtmp,dm,2 )
    else
      call xmist( im,qtmp,dm,iord )
    endif
    dm(0) = dm(im)
    if (abs(iord) .eq. 2 .or. cosa .lt. cos_van) then
      if(c_adEQmfx_ad) then
        do i = 1, im
          iu = float(i)-c(i)
          c_ad(i) = c_ad(i)-fx_ad(i)*mfx(i)*dm(iu)
          dm_ad(iu) = dm_ad(iu)+fx_ad(i)*mfx(i)*(sign(1.d0,c(i))-c(i))
          c_ad(i) = c_ad(i)+fx_ad(i)*(qtmp(iu)+dm(iu)*(sign(1.d0,c(i))-c(i)))
          qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
          fx_ad(i) = 0.d0
        end do
      else
        do i = 1, im
          iu = float(i)-c(i)
          c_ad(i) = c_ad(i)-fx_ad(i)*mfx(i)*dm(iu)
          dm_ad(iu) = dm_ad(iu)+fx_ad(i)*mfx(i)*(sign(1.d0,c(i))-c(i))
          mfx_ad(i) = mfx_ad(i)+fx_ad(i)*(qtmp(iu)+dm(iu)*(sign(1.d0,c(i))-c(i)))
          qtmp_ad(iu) = qtmp_ad(iu)+fx_ad(i)*mfx(i)
          fx_ad(i) = 0.d0
        end do
      endif
    else
      call fxppm_ad( im,c,c_ad,mfx,mfx_ad,qtmp,qtmp_ad,dm,dm_ad,fx,fx_ad,iord,al,ali_ad,ar,ari_ad,a6,a6_ad,iuw,iue,ffsl )
    endif
    dm_ad(im) = dm_ad(im)+dm_ad(0)
    dm_ad(0) = 0.d0
    if (iord .gt. 0 .or. cosa .lt. cos_van) then
      call xmist_ad( im,qtmp,qtmp_ad,dm,dm_ad,2 )
    else
      call xmist_ad( im,qtmp,qtmp_ad,dm,dm_ad,iord )
    endif
    q_ae(2) = q_ae(2)+qtmp_ad(imp+1)
    qtmp_ad(imp+1) = 0.d0
    q_ae(im-1) = q_ae(im-1)+qtmp_ad(-1)
    qtmp_ad(-1) = 0.d0
  endif
  q_ae(im) = q_ae(im)+qtmp_ad(0)
  qtmp_ad(0) = 0.d0
  q_ae(1) = q_ae(1)+qtmp_ad(imp)
  qtmp_ad(imp) = 0.d0
endif
do i = 1, im
  q_ae(i) = q_ae(i)+qtmp_ad(i)
  qtmp_ad(i) = 0.d0
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine xtp_ad


subroutine ycc_ad( im, jm, fy_ad, q, q_ae, vc, vc_ad, ymass, ymass_ad, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: iv
integer :: jfirst
integer :: jlast
real(kind=r8) :: fy_ad(im,jfirst-iv:jlast)
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: q_ae(im,jfirst-1-iv:jlast+2)
real(kind=r8) :: vc(im,jfirst-iv:jlast)
real(kind=r8) :: vc_ad(im,jfirst-iv:jlast)
real(kind=r8) :: ymass(im,jfirst-iv:jlast)
real(kind=r8) :: ymass_ad(im,jfirst-iv:jlast)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dc(im,jfirst-iv:jlast+1)
real(kind=r8) :: dc_ad(im,jfirst-iv:jlast+1)
double precision :: dch
double precision :: dch_ad
double precision :: dci_ad
integer :: i
integer :: im2
integer :: j
integer :: jn2g0
integer :: jn2g1
integer :: js2giv
integer :: js3giv
integer :: jt
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad
logical :: vc_adEQymass_ad  ! .true. if c_ad and mfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
vc_adEQymass_ad = loc(vc_ad) == loc(ymass_ad)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dc_ad(:,:) = 0.d0
qmax_ad = 0.d0
qmin_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
im2 = im/2
js2giv = max(2,jfirst-iv)
js3giv = max(3,jfirst-iv)
jn2g1 = min(jm-1,jlast+1)
jn2g0 = min(jm-1,jlast)
if (jord .eq. 1) then
  if(vc_adEQymass_ad) then
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)+fy_ad(i,j)*q(i,jt)
        fy_ad(i,j) = 0.d0
      end do
    end do
  else
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        ymass_ad(i,j) = ymass_ad(i,j)+fy_ad(i,j)*q(i,jt)
        fy_ad(i,j) = 0.d0
      end do
    end do
  endif
else
  do j = js3giv, jn2g1
    do i = 1, im
      dc(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
    end do
  end do
  if (iv .eq. 0) then
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)-q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)-q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = 0.25*(q(i+im2,jm)-q(i,jm-1))
      end do
      do i = im2+1, im
        dc(i,jm) = 0.25*(q(i-im2,jm)-q(i,jm-1))
      end do
    endif
  else
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)+q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)+q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i+im2,jm)))
      end do
      do i = im2+1, im
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i-im2,jm)))
      end do
    endif
  endif
  if (jord .gt. 0) then
    do j = js3giv, jn2g1
      do i = 1, im
        qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
        qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
        dc(i,j) = sign(min(abs(dc(i,j)),qmin,qmax),dc(i,j))
      end do
    end do
    if (jfirst .eq. 1) then
      do i = 1, im
        dc(i,2) = 0.
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im
        dc(i,jm) = 0.
      end do
    endif
  endif
  if(vc_adEQymass_ad) then
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        dc_ad(i,jt) = dc_ad(i,jt)+fy_ad(i,j)*(sign(1.d0,vc(i,j))-vc(i,j))*ymass(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)-fy_ad(i,j)*dc(i,jt)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)+fy_ad(i,j)*(q(i,jt)+(sign(1.d0,vc(i,j))-vc(i,j))*dc(i,jt))
        fy_ad(i,j) = 0.d0
      end do
    end do
  else
    do j = js2giv, jn2g0
      do i = 1, im
        jt = float(j+1)-vc(i,j)
        dc_ad(i,jt) = dc_ad(i,jt)+fy_ad(i,j)*(sign(1.d0,vc(i,j))-vc(i,j))*ymass(i,j)
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)*ymass(i,j)
        vc_ad(i,j) = vc_ad(i,j)-fy_ad(i,j)*dc(i,jt)*ymass(i,j)
        ymass_ad(i,j) = ymass_ad(i,j)+fy_ad(i,j)*(q(i,jt)+(sign(1.d0,vc(i,j))-vc(i,j))*dc(i,jt))
        fy_ad(i,j) = 0.d0
      end do
    end do
  endif
  do j = js3giv, jn2g1
    do i = 1, im
      dc(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
    end do
  end do
  if (iv .eq. 0) then
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)-q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)-q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = 0.25*(q(i+im2,jm)-q(i,jm-1))
      end do
      do i = im2+1, im
        dc(i,jm) = 0.25*(q(i-im2,jm)-q(i,jm-1))
      end do
    endif
  else
    if (jfirst .eq. 1) then
      do i = 1, im2
        dc(i,2) = 0.25*(q(i,3)+q(i+im2,2))
      end do
      do i = im2+1, im
        dc(i,2) = 0.25*(q(i,3)+q(i-im2,2))
      end do
    endif
    if (jlast .eq. jm) then
      do i = 1, im2
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i+im2,jm)))
      end do
      do i = im2+1, im
        dc(i,jm) = -(0.25*(q(i,jm-1)+q(i-im2,jm)))
      end do
    endif
  endif
  if (jord .gt. 0) then
    if (jlast .eq. jm) then
      do i = 1, im
        dc_ad(i,jm) = 0.d0
      end do
    endif
    if (jfirst .eq. 1) then
      do i = 1, im
        dc_ad(i,2) = 0.d0
      end do
    endif
    do j = js3giv, jn2g1
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      do i = 1, im
        qmax_ad = 0.d0
        qmin_ad = 0.d0
        qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
        qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
        dch = min(abs(dc(i,j)),qmin)
        dci_ad = dc_ad(i,j)*sign(1.d0,min(dch,qmax))*sign(1.d0,dc(i,j))
        dch_ad = dci_ad*(0.5+sign(0.5d0,qmax-dch))
        qmax_ad = qmax_ad+dci_ad*(0.5-sign(0.5d0,qmax-dch))
        qmin_ad = qmin_ad+dch_ad*(0.5-sign(0.5d0,qmin-abs(dc(i,j))))
        dc_ad(i,j) = dch_ad*(0.5+sign(0.5d0,qmin-abs(dc(i,j))))*sign(1.d0,dc(i,j))
        qminh = min(q(i,j-1),q(i,j))
        q_ae(i,j) = q_ae(i,j)+qmin_ad
        qmini_ad = -qmin_ad
        q_ae(i,j+1) = q_ae(i,j+1)+qmini_ad*(0.5-sign(0.5d0,q(i,j+1)-qminh))
        qminh_ad = qmini_ad*(0.5+sign(0.5d0,q(i,j+1)-qminh))
        q_ae(i,j-1) = q_ae(i,j-1)+qminh_ad*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))
        q_ae(i,j) = q_ae(i,j)+qminh_ad*(0.5-sign(0.5d0,q(i,j)-q(i,j-1)))
        qmin_ad = 0.d0
        qmaxh = max(q(i,j-1),q(i,j))
        q_ae(i,j) = q_ae(i,j)-qmax_ad
        q_ae(i,j+1) = q_ae(i,j+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-q(i,j+1)))
        qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-q(i,j+1)))
        q_ae(i,j-1) = q_ae(i,j-1)+qmaxh_ad*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))
        q_ae(i,j) = q_ae(i,j)+qmaxh_ad*(0.5-sign(0.5d0,q(i,j-1)-q(i,j)))
        qmax_ad = 0.d0
      end do
    end do
  endif
  if (iv .eq. 0) then
    if (jlast .eq. jm) then
      do i = im2+1, im
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i-im2,jm) = q_ae(i-im2,jm)+0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i+im2,jm) = q_ae(i+im2,jm)+0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
    endif
    if (jfirst .eq. 1) then
      do i = im2+1, im
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i-im2,2) = q_ae(i-im2,2)-0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i+im2,2) = q_ae(i+im2,2)-0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
    endif
  else
    if (jlast .eq. jm) then
      do i = im2+1, im
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i-im2,jm) = q_ae(i-im2,jm)-0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,jm-1) = q_ae(i,jm-1)-0.25*dc_ad(i,jm)
        q_ae(i+im2,jm) = q_ae(i+im2,jm)-0.25*dc_ad(i,jm)
        dc_ad(i,jm) = 0.d0
      end do
    endif
    if (jfirst .eq. 1) then
      do i = im2+1, im
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i-im2,2) = q_ae(i-im2,2)+0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
      do i = 1, im2
        q_ae(i,3) = q_ae(i,3)+0.25*dc_ad(i,2)
        q_ae(i+im2,2) = q_ae(i+im2,2)+0.25*dc_ad(i,2)
        dc_ad(i,2) = 0.d0
      end do
    endif
  endif
  do j = js3giv, jn2g1
    do i = 1, im
      q_ae(i,j-1) = q_ae(i,j-1)-0.25*dc_ad(i,j)
      q_ae(i,j+1) = q_ae(i,j+1)+0.25*dc_ad(i,j)
      dc_ad(i,j) = 0.d0
    end do
  end do
endif

end subroutine ycc_ad


subroutine ymist_ad( im, jm, q, q_ae, dm, dm_ad, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
integer :: ng
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ad(im,jfirst-ng:jlast+ng)
integer :: iv
integer :: jm
integer :: jord
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)

!==============================================
! declare local variables
!==============================================
double precision :: dmh
double precision :: dmh_ad
double precision :: dmi_ad
double precision :: dmi_ae
double precision :: dmj
double precision :: dmj_ad
double precision :: dmk_ad
double precision :: dmk_ae
double precision :: dml
double precision :: dml_ad
double precision :: dmm_ad
double precision :: dmm_ae
double precision :: dmn
double precision :: dmn_ad
double precision :: dmo_ad
double precision :: dmo_ae
double precision :: dmp
double precision :: dmp_ad
double precision :: dmq_ad
integer :: i
integer :: im2
integer :: j
integer :: jm1
integer :: jn2gng1
integer :: js2gng1
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxh
double precision :: qmaxh_ad
double precision :: qmaxj
double precision :: qmaxj_ad
double precision :: qmaxl
double precision :: qmaxl_ad
double precision :: qmaxn
double precision :: qmaxn_ad
double precision :: qmaxp
double precision :: qmaxp_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminh
double precision :: qminh_ad
double precision :: qmini_ad
double precision :: qminj
double precision :: qminj_ad
double precision :: qmink_ad
double precision :: qminl
double precision :: qminl_ad
double precision :: qminm_ad
double precision :: qminn
double precision :: qminn_ad
double precision :: qmino_ad
double precision :: qminp
double precision :: qminp_ad
double precision :: qminq_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qmax_ad = 0.d0
qmin_ad = 0.d0
tmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2gng1 = max(2,jfirst-ng+1)
jn2gng1 = min(jm-1,jlast+ng-1)
jm1 = jm-1
im2 = im/2
do j = js2gng1, jn2gng1
  do i = 1, im
    dm(i,j) = 0.25*(q(i,j+1)-q(i,j-1))
  end do
end do
if (iv .eq. 0) then
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = -dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = -dm(i-im2,jm)
    end do
  endif
else
  if (jfirst .eq. 1) then
    do i = 1, im2
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dm(i,1) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,1) = dm(i-im2,1)
    end do
  endif
  if (jlast .eq. jm) then
    do i = 1, im2
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dm(i,jm) = sign(min(abs(tmp),qmax,qmin),tmp)
    end do
    do i = im2+1, im
      dm(i,jm) = dm(i-im2,jm)
    end do
  endif
endif
if (jord .gt. 0) then
  do j = js2gng1, jn2gng1
    qmax_ad = 0.d0
    qmin_ad = 0.d0
    do i = 1, im
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      qmax = max(q(i,j-1),q(i,j),q(i,j+1))-q(i,j)
      qmin = q(i,j)-min(q(i,j-1),q(i,j),q(i,j+1))
      dmh = min(abs(dm(i,j)),qmin)
      dmi_ad = dm_ad(i,j)*sign(1.d0,min(dmh,qmax))*sign(1.d0,dm(i,j))
      dmh_ad = dmi_ad*(0.5+sign(0.5d0,qmax-dmh))
      qmax_ad = qmax_ad+dmi_ad*(0.5-sign(0.5d0,qmax-dmh))
      qmin_ad = qmin_ad+dmh_ad*(0.5-sign(0.5d0,qmin-abs(dm(i,j))))
      dm_ad(i,j) = dmh_ad*(0.5+sign(0.5d0,qmin-abs(dm(i,j))))*sign(1.d0,dm(i,j))
      qminh = min(q(i,j-1),q(i,j))
      q_ae(i,j) = q_ae(i,j)+qmin_ad
      qmini_ad = -qmin_ad
      q_ae(i,j+1) = q_ae(i,j+1)+qmini_ad*(0.5-sign(0.5d0,q(i,j+1)-qminh))
      qminh_ad = qmini_ad*(0.5+sign(0.5d0,q(i,j+1)-qminh))
      q_ae(i,j-1) = q_ae(i,j-1)+qminh_ad*(0.5+sign(0.5d0,q(i,j)-q(i,j-1)))
      q_ae(i,j) = q_ae(i,j)+qminh_ad*(0.5-sign(0.5d0,q(i,j)-q(i,j-1)))
      qmin_ad = 0.d0
      qmaxh = max(q(i,j-1),q(i,j))
      q_ae(i,j) = q_ae(i,j)-qmax_ad
      q_ae(i,j+1) = q_ae(i,j+1)+qmax_ad*(0.5-sign(0.5d0,qmaxh-q(i,j+1)))
      qmaxh_ad = qmax_ad*(0.5+sign(0.5d0,qmaxh-q(i,j+1)))
      q_ae(i,j-1) = q_ae(i,j-1)+qmaxh_ad*(0.5+sign(0.5d0,q(i,j-1)-q(i,j)))
      q_ae(i,j) = q_ae(i,j)+qmaxh_ad*(0.5-sign(0.5d0,q(i,j-1)-q(i,j)))
      qmax_ad = 0.d0
    end do
  end do
endif
if (iv .eq. 0) then
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmi_ae = dm_ad(i,jm)
      dm_ad(i,jm) = 0.d0
      dm_ad(i-im2,jm) = dm_ad(i-im2,jm)-dmi_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(q(i+im2,jm1)-q(i,jm1))
      qmax = max(q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmj = min(abs(tmp),qmax)
      dmk_ad = dm_ad(i,jm)*sign(1.d0,min(dmj,qmin))*sign(1.d0,tmp)
      dmj_ad = dmk_ad*(0.5+sign(0.5d0,qmin-dmj))
      qmin_ad = qmin_ad+dmk_ad*(0.5-sign(0.5d0,qmin-dmj))
      qmax_ad = qmax_ad+dmj_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmj_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,jm) = 0.d0
      qminj = min(q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)+qmin_ad
      qmink_ad = -qmin_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmink_ad*(0.5-sign(0.5d0,q(i,jm1)-qminj))
      qminj_ad = qmink_ad*(0.5+sign(0.5d0,q(i,jm1)-qminj))
      q_ae(i,jm) = q_ae(i,jm)+qminj_ad*(0.5-sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)+qminj_ad*(0.5+sign(0.5d0,q(i,jm)-q(i+im2,jm1)))
      qmin_ad = 0.d0
      qmaxj = max(q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)-qmax_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmax_ad*(0.5-sign(0.5d0,qmaxj-q(i,jm1)))
      qmaxj_ad = qmax_ad*(0.5+sign(0.5d0,qmaxj-q(i,jm1)))
      q_ae(i,jm) = q_ae(i,jm)+qmaxj_ad*(0.5-sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)+qmaxj_ad*(0.5+sign(0.5d0,q(i+im2,jm1)-q(i,jm)))
      qmax_ad = 0.d0
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)+0.25*tmp_ad
      q_ae(i,jm1) = q_ae(i,jm1)-0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmk_ae = dm_ad(i,1)
      dm_ad(i,1) = 0.d0
      dm_ad(i-im2,1) = dm_ad(i-im2,1)-dmk_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(q(i,2)-q(i+im2,2))
      qmax = max(q(i,2),q(i,1),q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),q(i+im2,2))
      dml = min(abs(tmp),qmax)
      dmm_ad = dm_ad(i,1)*sign(1.d0,min(dml,qmin))*sign(1.d0,tmp)
      dml_ad = dmm_ad*(0.5+sign(0.5d0,qmin-dml))
      qmin_ad = qmin_ad+dmm_ad*(0.5-sign(0.5d0,qmin-dml))
      qmax_ad = qmax_ad+dml_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dml_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,1) = 0.d0
      qminl = min(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)+qmin_ad
      qminm_ad = -qmin_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)+qminm_ad*(0.5-sign(0.5d0,q(i+im2,2)-qminl))
      qminl_ad = qminm_ad*(0.5+sign(0.5d0,q(i+im2,2)-qminl))
      q_ae(i,2) = q_ae(i,2)+qminl_ad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_ae(i,1) = q_ae(i,1)+qminl_ad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_ad = 0.d0
      qmaxl = max(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)-qmax_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)+qmax_ad*(0.5-sign(0.5d0,qmaxl-q(i+im2,2)))
      qmaxl_ad = qmax_ad*(0.5+sign(0.5d0,qmaxl-q(i+im2,2)))
      q_ae(i,2) = q_ae(i,2)+qmaxl_ad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_ae(i,1) = q_ae(i,1)+qmaxl_ad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_ad = 0.d0
      q_ae(i+im2,2) = q_ae(i+im2,2)-0.25*tmp_ad
      q_ae(i,2) = q_ae(i,2)+0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
else
  if (jlast .eq. jm) then
    do i = im, im2+1, -1
      dmm_ae = dm_ad(i,jm)
      dm_ad(i,jm) = 0.d0
      dm_ad(i-im2,jm) = dm_ad(i-im2,jm)+dmm_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = -(0.25*(q(i+im2,jm1)+q(i,jm1)))
      qmax = max(-q(i+im2,jm1),q(i,jm),q(i,jm1))-q(i,jm)
      qmin = q(i,jm)-min(-q(i+im2,jm1),q(i,jm),q(i,jm1))
      dmn = min(abs(tmp),qmax)
      dmo_ad = dm_ad(i,jm)*sign(1.d0,min(dmn,qmin))*sign(1.d0,tmp)
      dmn_ad = dmo_ad*(0.5+sign(0.5d0,qmin-dmn))
      qmin_ad = qmin_ad+dmo_ad*(0.5-sign(0.5d0,qmin-dmn))
      qmax_ad = qmax_ad+dmn_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmn_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,jm) = 0.d0
      qminn = min(-q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)+qmin_ad
      qmino_ad = -qmin_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmino_ad*(0.5-sign(0.5d0,q(i,jm1)-qminn))
      qminn_ad = qmino_ad*(0.5+sign(0.5d0,q(i,jm1)-qminn))
      q_ae(i,jm) = q_ae(i,jm)+qminn_ad*(0.5-sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)-qminn_ad*(0.5+sign(0.5d0,q(i,jm)-(-q(i+im2,jm1))))
      qmin_ad = 0.d0
      qmaxn = max(-q(i+im2,jm1),q(i,jm))
      q_ae(i,jm) = q_ae(i,jm)-qmax_ad
      q_ae(i,jm1) = q_ae(i,jm1)+qmax_ad*(0.5-sign(0.5d0,qmaxn-q(i,jm1)))
      qmaxn_ad = qmax_ad*(0.5+sign(0.5d0,qmaxn-q(i,jm1)))
      q_ae(i,jm) = q_ae(i,jm)+qmaxn_ad*(0.5-sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)-qmaxn_ad*(0.5+sign(0.5d0,(-q(i+im2,jm1))-q(i,jm)))
      qmax_ad = 0.d0
      q_ae(i+im2,jm1) = q_ae(i+im2,jm1)-0.25*tmp_ad
      q_ae(i,jm1) = q_ae(i,jm1)-0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
  if (jfirst .eq. 1) then
    do i = im, im2+1, -1
      dmo_ae = dm_ad(i,1)
      dm_ad(i,1) = 0.d0
      dm_ad(i-im2,1) = dm_ad(i-im2,1)+dmo_ae
    end do
    do i = 1, im2
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      tmp_ad = 0.d0
      tmp = 0.25*(q(i,2)+q(i+im2,2))
      qmax = max(q(i,2),q(i,1),-q(i+im2,2))-q(i,1)
      qmin = q(i,1)-min(q(i,2),q(i,1),-q(i+im2,2))
      dmp = min(abs(tmp),qmax)
      dmq_ad = dm_ad(i,1)*sign(1.d0,min(dmp,qmin))*sign(1.d0,tmp)
      dmp_ad = dmq_ad*(0.5+sign(0.5d0,qmin-dmp))
      qmin_ad = qmin_ad+dmq_ad*(0.5-sign(0.5d0,qmin-dmp))
      qmax_ad = qmax_ad+dmp_ad*(0.5-sign(0.5d0,qmax-abs(tmp)))
      tmp_ad = tmp_ad+dmp_ad*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
      dm_ad(i,1) = 0.d0
      qminp = min(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)+qmin_ad
      qminq_ad = -qmin_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)-qminq_ad*(0.5-sign(0.5d0,(-q(i+im2,2))-qminp))
      qminp_ad = qminq_ad*(0.5+sign(0.5d0,(-q(i+im2,2))-qminp))
      q_ae(i,2) = q_ae(i,2)+qminp_ad*(0.5+sign(0.5d0,q(i,1)-q(i,2)))
      q_ae(i,1) = q_ae(i,1)+qminp_ad*(0.5-sign(0.5d0,q(i,1)-q(i,2)))
      qmin_ad = 0.d0
      qmaxp = max(q(i,2),q(i,1))
      q_ae(i,1) = q_ae(i,1)-qmax_ad
      q_ae(i+im2,2) = q_ae(i+im2,2)-qmax_ad*(0.5-sign(0.5d0,qmaxp-(-q(i+im2,2))))
      qmaxp_ad = qmax_ad*(0.5+sign(0.5d0,qmaxp-(-q(i+im2,2))))
      q_ae(i,2) = q_ae(i,2)+qmaxp_ad*(0.5+sign(0.5d0,q(i,2)-q(i,1)))
      q_ae(i,1) = q_ae(i,1)+qmaxp_ad*(0.5-sign(0.5d0,q(i,2)-q(i,1)))
      qmax_ad = 0.d0
      q_ae(i+im2,2) = q_ae(i+im2,2)+0.25*tmp_ad
      q_ae(i,2) = q_ae(i,2)+0.25*tmp_ad
      tmp_ad = 0.d0
    end do
  endif
endif
do j = js2gng1, jn2gng1
  do i = 1, im
    q_ae(i,j-1) = q_ae(i,j-1)-0.25*dm_ad(i,j)
    q_ae(i,j+1) = q_ae(i,j+1)+0.25*dm_ad(i,j)
    dm_ad(i,j) = 0.d0
  end do
end do

end subroutine ymist_ad


subroutine ytp_ad( im, jm, fy, fy_ad, q, q_ae, c, c_ad, yfx, yfx_ad, ng, jord, iv, jfirst, jlast )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: c(im,jfirst:jlast+1)
real(kind=r8) :: c_ad(im,jfirst:jlast+1)
real(kind=r8) :: fy(im,jfirst:jlast+1)
real(kind=r8) :: fy_ad(im,jfirst:jlast+1)
integer :: iv
integer :: jm
integer :: jord
integer :: ng
real(kind=r8) :: q(im,jfirst-ng:jlast+ng)
real(kind=r8) :: q_ae(im,jfirst-ng:jlast+ng)
real(kind=r8) :: yfx(im,jfirst:jlast+1)
real(kind=r8) :: yfx_ad(im,jfirst:jlast+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dm(im,jfirst-ng:jlast+ng)
real(kind=r8) :: dm_ad(im,jfirst-ng:jlast+ng)
integer :: i
integer :: j
integer :: jn1g1
integer :: js2g0
integer :: jt
logical :: c_adEQyfx_ad  ! .true. if c_ad and yfx_ad are aliased in calling routine

!----------------------------------------------
! Check for aliasing
!----------------------------------------------
c_adEQyfx_ad = loc(c_ad) == loc(yfx_ad)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dm_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn1g1 = min(jm,jlast+1)
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      fy(i,j) = q(i,jt)
    end do
  end do
else
  call ymist( im,jm,q,dm,ng,jord,iv,jfirst,jlast )
  if (abs(jord) .ge. 3) then
    call fyppm( c,q,dm,fy,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        fy(i,j) = q(i,jt)+(sign(1._8,c(i,j))-c(i,j))*dm(i,jt)
      end do
    end do
  endif
endif
if(c_adEQyfx_ad) then
  do j = js2g0, jn1g1
    do i = 1, im
      c_ad(i,j) = c_ad(i,j)+fy_ad(i,j)*fy(i,j)
      fy_ad(i,j) = fy_ad(i,j)*yfx(i,j)
    end do
  end do
else
  do j = js2g0, jn1g1
    do i = 1, im
      yfx_ad(i,j) = yfx_ad(i,j)+fy_ad(i,j)*fy(i,j)
      fy_ad(i,j) = fy_ad(i,j)*yfx(i,j)
    end do
  end do
endif
if (jord .eq. 1) then
  do j = js2g0, jn1g1
    do i = 1, im
      jt = float(j)-c(i,j)
      q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)
      fy_ad(i,j) = 0.d0
    end do
  end do
else
  if (abs(jord) .ge. 3) then
    call fyppm_ad( c,c_ad,q,q_ae,dm,dm_ad,fy_ad,im,jm,ng,jord,iv,jfirst,jlast )
  else
    do j = js2g0, jn1g1
      do i = 1, im
        jt = float(j)-c(i,j)
        c_ad(i,j) = c_ad(i,j)-fy_ad(i,j)*dm(i,jt)
        dm_ad(i,jt) = dm_ad(i,jt)+fy_ad(i,j)*(sign(1.d0,c(i,j))-c(i,j))
        q_ae(i,jt) = q_ae(i,jt)+fy_ad(i,j)
        fy_ad(i,j) = 0.d0
      end do
    end do
  endif
  call ymist_ad( im,jm,q,q_ae,dm,dm_ad,ng,jord,iv,jfirst,jlast )
endif

end subroutine ytp_ad


end module     tp_core_ad


#endif /* SPMD */
