#ifdef    SPMD
C                           DISCLAIMER
C
C   This file was generated by TAF version 1.6.1
C
C   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
C   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
C   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
C   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
C   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
C   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
C   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
C   OF THE POSSIBILITY OF SUCH DAMAGES.
C
C                           Haftungsbeschraenkung
C   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
C   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
C   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
C   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
C   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
C   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
C   Mitteilung darueber an FastOpt.
!
!  14May2007  Todling   Introduced dyn_prog; global change.
!  31May2007  Todling   Add transforms between g5 and g4 perts
!  26Sep2007  Todling   Q-internal traj major fix: missing updates
!  10Dec2009  Todling   Bug fix in Q-checkpoint when phys is on: add inner_q_10h
!  11Dec2009  Todling   Add adfirst/last to allow incremental and
!                       single-shot integrations to be the same
C
      module stepon_ad_store

      use precision
      implicit none

      integer, allocatable :: outer_time_nymd_1h(:)
      integer, allocatable :: outer_time_nhms_2h(:)
      integer, allocatable :: outer_time_nymd_trj_3h(:)
      integer, allocatable :: outer_time_nhms_trj_4h(:)

      real, allocatable :: inner_omega_8h(:)
      real(kind=r8), allocatable :: inner_delp_1h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pe_12h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pe_14h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pe_2h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pk_3h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pkz_13h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pkz_4h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pt_11h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pt_5h(:,:,:,:)
      real(kind=r8), allocatable :: inner_u_6h(:,:,:,:)
      real(kind=r8), allocatable :: inner_u_9h(:,:,:,:)
      real(kind=r8), allocatable :: inner_v_10h(:,:,:,:)
      real(kind=r8), allocatable :: inner_v_7h(:,:,:,:)
      real(kind=r8), allocatable :: inner_q_9h(:,:,:,:,:)
      real(kind=r8), allocatable :: inner_q_10h(:,:,:,:,:)

      integer :: inner_stepon_do
      integer :: outer_time_stepon_do

      end module stepon_ad_store

      module     stepon_ad
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use precision
      use prognostics
      use prognostics_ad
      use mod_comm, only : gid,mp_exit, mp_init, y_decomp
      use mod_comm, only : numcpu
      use m_strtemplate
#ifdef TIMING
      use timingmodule, only : timing_init, timing_off, timing_on
#endif
      use stepon

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

      PRIVATE
      PUBLIC stepon_do_ad
      PUBLIC stepon_set_ad
      PUBLIC stepon_final_ad
      PUBLIC stepon_domd

      real(r8), pointer ::    u_ad(:,:,:)   ! zonal wind on D-grid
      real(r8), pointer ::    v_ad(:,:,:)   ! meridional wind
      real(r8), pointer ::   pt_ad(:,:,:)   ! virtual potential temperature
      real(r8), pointer :: delp_ad(:,:,:)   ! pressure thickness (pascal)
      real(r8), pointer ::    q_ad(:,:,:,:) ! specific humidity & tracer mixing ratios

      logical :: checkpointed_= .false.     ! determines status of checkpointing
      contains
      subroutine stepon_do_ad ( g5pert, adfirst, adlast, checkpoint, prog, xpert, ypert )
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use m_iostate, only : getstate
      use m_zeit, only : zeit_ci, zeit_co

      use fvcore, only : ns,fvcore_do
      use fvcore, only : fvcore_tape_rec
      use fvcore, only : dynpkg_n2,dynpkg_nsplit
      use fvcore, only : ng_c
      use hswf, only : hswf_do
      use hswf_ad, only : hswf_do_ad
      use stepon_ad_store, only : inner_stepon_do, outer_time_stepon_do
      use stepon_ad_store, only : outer_time_nhms_2h, outer_time_nhms_trj_4h, outer_time_nymd_1h, outer_time_nymd_trj_3h
      use stepon_ad_store, only : inner_delp_1h, inner_pe_12h, inner_pe_14h, inner_pe_2h, inner_pk_3h, inner_pkz_13h,
     $                            inner_pkz_4h, inner_pt_11h, inner_pt_5h, inner_u_6h, inner_u_9h, inner_v_10h,
     $                            inner_v_7h, inner_q_9h, inner_omega_8h, inner_q_10h
      use fvcore_ad, only : fvcore_do_ad, fvcore_domd
      use c_sw_ad_store, only : c_sw_tape1_c_sw,c_sw_tape2_c_sw
      use cd_core_do_ad_store, only : cd_core_tape_cd_core_do
      use d_sw_ad_store, only : d_sw_tape1_d_sw,d_sw_tapej_d_sw
      use fvcore_do_ad_store, only :   dynpkg_1_fvcore_do,dynpkg_n2_fvcore_do
      use te_map_ad_store, only : te_map_tape_te_map
      use tpcc_ad_store, only : tpcc1_tape_tpcc,tpcc2_tape_tpcc
      use m_physdrv1_ad, only : physdrv1_ad
      use mapz_module, only: te_map

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none
      logical, intent(in)    :: g5pert     ! specifies whether or not i/o is GEOS-5 perturbation
      logical, intent(in)    :: adfirst    ! if g5pert=.t.: when .t. converts input vector to g5type
      logical, intent(in)    :: adlast     ! if g5pert=.t.: when .t. converts output to g5pert type
      integer, intent(in)    :: checkpoint ! determines (outer) checkpoint level: 0 = don't preserve checkpoint
                                           !                                      1 = preserve apprx checkpoint
                                           !                                      2 = preserve exact checkpoint
      type(dyn_prog)         :: prog
      type(dyn_prog)         :: xpert ! output perturbation
      type(dyn_prog)         :: ypert ! input  perturbation

C==============================================
C declare local variables
C==============================================
      real(kind=r8) :: ae
      real(kind=r8) :: akap
      real(kind=r8) :: cp
      character*255 :: fnametrj
      real(kind=r8) :: grav
      integer :: iinner
      integer :: iouter
      integer :: nhms_trj, nhms_first, nhms_last
      integer :: nymd_trj, nymd_first, nymd_last
      integer :: rmaptfrq
      integer :: nx
      integer :: nouter_for_checkpoint
      integer :: ierr
      real(kind=r8) :: om
      real(kind=r8) :: te0
      real(kind=r8) :: rg
      logical       :: doremap
      type(dyn_prog):: pert

      real(r8) :: ua_ad(imr,jfirst-ng_d:jlast,nl)
      real(r8) :: va_ad(imr,jfirst:jlast,nl)

C----------------------------------------------
C ROUTINE BODY
C----------------------------------------------


! Set pointers
! ------------
      call prognostics_initial ( pert )
      call prognostics_dup     ( ypert, pert )

       u_ad   => pert%u
       v_ad   => pert%v
      pt_ad   => pert%pt
      delp_ad => pert%delp
      q_ad    => pert%q


! Set pointers
! ------------
       u   => prog%u
       v   => prog%v
      pt   => prog%pt
      delp => prog%delp
      q    => prog%q

      if ( (jlast-jfirst+1)/numcpu >= 4 ) then
          nx = 1
      else
          nx = 4
      endif

C----------------------------------------------
C OPEN TAPE outer_time
C----------------------------------------------
      outer_time_stepon_do = nouter
      if (checkpoint==2) then
          nouter_for_checkpoint = nouter
      else
          nouter_for_checkpoint = 1
      endif
      nymd_last  = nymd
      nhms_last  = nhms

      if ( .not. allocated(outer_time_nymd_1h)) then
           allocate( outer_time_nymd_1h(outer_time_stepon_do) )
      endif
      if ( .not. allocated(outer_time_nhms_2h)) then
           allocate( outer_time_nhms_2h(outer_time_stepon_do) )
      endif
      if ( .not. allocated(outer_time_nymd_trj_3h)) then
           allocate( outer_time_nymd_trj_3h(outer_time_stepon_do) )
      endif
      if ( .not. allocated(outer_time_nhms_trj_4h)) then
           allocate( outer_time_nhms_trj_4h(outer_time_stepon_do) )
      endif

C----------------------------------------------
C TAPE COMPUTATIONS
C----------------------------------------------
      if (.not.checkpointed_) then

      do iouter = 1, nouter-1
        outer_time_nymd_1h(iouter) = nymd
        outer_time_nhms_2h(iouter) = nhms
        nymd_trj = nymd
        nhms_trj = nhms
        call tick( nymd_trj,nhms_trj,pdt )
        outer_time_nymd_trj_3h(iouter) = nymd_trj
        outer_time_nhms_trj_4h(iouter) = nhms_trj
        do iinner = 1, ninner
          call tick( nymd,nhms,pdt )
        end do
      end do
      if ( nouter>0 ) then
        iouter = nouter
        outer_time_nymd_1h(iouter) = nymd
        outer_time_nhms_2h(iouter) = nhms
        nymd_trj = nymd
        nhms_trj = nhms
        call tick( nymd_trj,nhms_trj,pdt )
        outer_time_nymd_trj_3h(iouter) = nymd_trj
        outer_time_nhms_trj_4h(iouter) = nhms_trj
!OUT    nymd_first = nymd_trj
!OUT    nhms_first = nhms_trj
!OUT  else
!OUT    nymd_trj   = nymd
!OUT    nhms_trj   = nhms
!OUT    nymd_first = nymd_trj
!OUT    nhms_first = nhms_trj
      endif

      endif ! <checkpointed>

      if ( nouter>0 ) then
        iouter = nouter
        nymd_first = outer_time_nymd_trj_3h(iouter)
        nhms_first = outer_time_nhms_trj_4h(iouter)
      else
        nymd_trj   = nymd
        nhms_trj   = nhms
        nymd_first = nymd_trj
        nhms_first = nhms_trj
      endif

C----------------------------------------------
C ADJOINT COMPUTATIONS
C----------------------------------------------
#ifdef TIMING
      call adtiming_off( 'TOTAL' )
#endif

!     If so, convert GEOS-5 perturbation to GEOS-4-type
!     -------------------------------------------------
      if ( g5pert .and. adlast .and. iouter==nouter ) then
           call prognostics_zero ( prog )
           call getstate( nymd_first, nhms_first, prog, doremap )
!          call delp2ps_ad ( im, jfirst, jlast, nl, delp_ad )
           call th2t_ad ( delp, pt, pt_ad, pkz_ad )
           ua_ad(:,jfirst-ng_d:jlast,:) = pert%u(:,jfirst-ng_d:jlast,:) 
           va_ad(:,jfirst     :jlast,:) = pert%v(:,jfirst     :jlast,:) 
           pert%u = 0._r8
           pert%v = 0._r8
           call d2a3d_ad( pert%u, pert%v, ua_ad, va_ad, imr, jnp, nl, jfirst, jlast, ng_d, ng_s, coslon, sinlon )
      endif

      do iouter = nouter, 1, -1

        nymd = outer_time_nymd_1h(iouter)
        nhms = outer_time_nhms_2h(iouter)
        nymd_trj = nymd
        nhms_trj = nhms

        call getstate( nymd_trj, nhms_trj, prog, doremap )

        if (doremap) then
           te0 = 1.0
           call te_map(.false., .false., ps, omga, pe, delp, pkz, pk, mpdt,
     &                  imr, jnp, nl, nx, jfirst, jlast, nq,  u,  v,
     &                  pt, q, phis,  cpair, cappa, kord, peln, te0,
     &                  ng_d, ng_s, 0 )
        endif


! Begin checkpointing 
! -------------------
        if (.not.checkpointed_) then

C----------------------------------------------
C OPEN TAPE c_sw_tape1
C----------------------------------------------
        c_sw_tape1_c_sw = nouter_for_checkpoint*ninner*dynpkg_nsplit*dynpkg_n2*nl*1

C----------------------------------------------
C OPEN TAPE c_sw_tape2
C----------------------------------------------
        c_sw_tape2_c_sw = nouter_for_checkpoint*ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C OPEN TAPE cd_core_tape
C----------------------------------------------
        cd_core_tape_cd_core_do = nouter_for_checkpoint*ninner*dynpkg_nsplit*dynpkg_n2

C----------------------------------------------
C OPEN TAPE d_sw_tape1
C----------------------------------------------
        d_sw_tape1_d_sw = nouter_for_checkpoint*ninner*dynpkg_nsplit*dynpkg_n2*nl*1

C----------------------------------------------
C OPEN TAPE d_sw_tapej
C----------------------------------------------
        d_sw_tapej_d_sw = nouter_for_checkpoint*ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C OPEN TAPE dynpkg_1
C----------------------------------------------
        dynpkg_1_fvcore_do = nouter_for_checkpoint*ninner

C----------------------------------------------
C OPEN TAPE dynpkg_n2
C----------------------------------------------
        dynpkg_n2_fvcore_do = nouter_for_checkpoint*ninner*dynpkg_n2

C----------------------------------------------
C OPEN TAPE inner
C----------------------------------------------
        inner_stepon_do = nouter_for_checkpoint*ninner

C----------------------------------------------
C OPEN TAPE te_map_tape
C----------------------------------------------
        te_map_tape_te_map = nouter_for_checkpoint*ninner

C----------------------------------------------
C OPEN TAPE tpcc1_tape
C----------------------------------------------
        tpcc1_tape_tpcc = nouter_for_checkpoint*ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C OPEN TAPE tpcc2_tape
C----------------------------------------------
        tpcc2_tape_tpcc = nouter_for_checkpoint*ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C TAPE COMPUTATIONS
C----------------------------------------------
        call zeit_ci('fvcore_domd')
        do iinner = 1, ninner-1
          nstep = iinner-1+(iouter-1)*ninner
          if(nouter_for_checkpoint==1) then
             fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
          else
             fvcore_tape_rec = iouter-1+(iinner-1)*ninner
          endif
          if ( .not. allocated(inner_delp_1h)) then
            allocate( inner_delp_1h(1:size(delp,1),1:size(delp,2),1:size(delp,3),inner_stepon_do) )
          endif
          inner_delp_1h(:,:,:,fvcore_tape_rec+1) = delp
          if ( .not. allocated(inner_pe_2h)) then
            allocate( inner_pe_2h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
          endif
          inner_pe_2h(:,:,:,fvcore_tape_rec+1) = pe
          if ( .not. allocated(inner_pk_3h)) then
            allocate( inner_pk_3h(1:size(pk,1),1:size(pk,2),1:size(pk,3),inner_stepon_do) )
          endif
          inner_pk_3h(:,:,:,fvcore_tape_rec+1) = pk
          if ( .not. allocated(inner_pkz_4h)) then
            allocate( inner_pkz_4h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
          endif
          inner_pkz_4h(:,:,:,fvcore_tape_rec+1) = pkz
          if ( .not. allocated(inner_pt_5h)) then
            allocate( inner_pt_5h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
          endif
          inner_pt_5h(:,:,:,fvcore_tape_rec+1) = pt
          if ( .not. allocated(inner_u_6h)) then
            allocate( inner_u_6h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
          endif
          inner_u_6h(:,:,:,fvcore_tape_rec+1) = u
          if ( .not. allocated(inner_v_7h)) then
            allocate( inner_v_7h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
          endif
          inner_v_7h(:,:,:,fvcore_tape_rec+1) = v
          if ( .not. allocated(inner_omega_8h)) then
            allocate( inner_omega_8h(inner_stepon_do) )
          endif
          inner_omega_8h(fvcore_tape_rec+1) = omega
          if ( .not. allocated(inner_q_9h)) then
            allocate( inner_q_9h(1:size(q,1),1:size(q,2),1:size(q,3),1:size(q,4),inner_stepon_do) )
          endif
          inner_q_9h(:,:,:,:,fvcore_tape_rec+1) = q
          om = omega
          cp = cpair
          rg = rair
          ae = rearth
          call fvcore_domd( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,ae,
     $iord,jord,kord,umax,omga,peln,consv,convt )
          if ( .not. allocated(inner_q_10h)) then
            allocate( inner_q_10h(1:size(q,1),1:size(q,2),1:size(q,3),1:size(q,4),inner_stepon_do) )
          endif
          inner_q_10h(:,:,:,:,fvcore_tape_rec+1) = q
          nstep = nstep+1
          if (force_dycore) then
            if ( .not. allocated(inner_u_9h)) then
              allocate( inner_u_9h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
            endif
            inner_u_9h(:,:,:,fvcore_tape_rec+1) = u
            if ( .not. allocated(inner_v_10h)) then
              allocate( inner_v_10h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
            endif
            inner_v_10h(:,:,:,fvcore_tape_rec+1) = v
            if ( .not. allocated(inner_pt_11h)) then
              allocate( inner_pt_11h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
            endif
            inner_pt_11h(:,:,:,fvcore_tape_rec+1) = pt
            if ( .not. allocated(inner_pe_12h)) then
              allocate( inner_pe_12h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
            endif
            inner_pe_12h(:,:,:,fvcore_tape_rec+1) = pe
            if ( .not. allocated(inner_pkz_13h)) then
              allocate( inner_pkz_13h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
            endif
            inner_pkz_13h(:,:,:,fvcore_tape_rec+1) = pkz
            akap = cappa
            call hswf_do( imr,jnp,nl,jfirst,jlast,u,v,pt,pe,pkz,pdt,akap,grav,rg,dcaf, .true. ,rayf,sinp,cosp,sine,cose,coslon,
     $sinlon,ng_s,ng_d )
          endif
          if (aoa) then
            if ( .not. allocated(inner_pe_14h)) then
              allocate( inner_pe_14h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
            endif
            inner_pe_14h(:,:,:,fvcore_tape_rec+1) = pe
            model_time = nstep*pdt
            call age_of_air( imr,jnp,nl,jfirst,jlast,ng_d,model_time,pe,q(1,jfirst-ng_d,1,nq) )
          endif
        end do
        iinner = ninner
        if (nouter_for_checkpoint==1) then
            fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
        else
            fvcore_tape_rec = iouter-1+(iinner-1)*ninner
        endif
        if ( .not. allocated(inner_delp_1h)) then
          allocate( inner_delp_1h(1:size(delp,1),1:size(delp,2),1:size(delp,3),inner_stepon_do) )
        endif
        inner_delp_1h(:,:,:,fvcore_tape_rec+1) = delp
        if ( .not. allocated(inner_pe_2h)) then
          allocate( inner_pe_2h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
        endif
        inner_pe_2h(:,:,:,fvcore_tape_rec+1) = pe
        if ( .not. allocated(inner_pk_3h)) then
          allocate( inner_pk_3h(1:size(pk,1),1:size(pk,2),1:size(pk,3),inner_stepon_do) )
        endif
        inner_pk_3h(:,:,:,fvcore_tape_rec+1) = pk
        if ( .not. allocated(inner_pkz_4h)) then
          allocate( inner_pkz_4h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
        endif
        inner_pkz_4h(:,:,:,fvcore_tape_rec+1) = pkz
        if ( .not. allocated(inner_pt_5h)) then
          allocate( inner_pt_5h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
        endif
        inner_pt_5h(:,:,:,fvcore_tape_rec+1) = pt
        if ( .not. allocated(inner_u_6h)) then
          allocate( inner_u_6h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
        endif
        inner_u_6h(:,:,:,fvcore_tape_rec+1) = u
        if ( .not. allocated(inner_v_7h)) then
          allocate( inner_v_7h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
        endif
        inner_v_7h(:,:,:,fvcore_tape_rec+1) = v
        if ( .not. allocated(inner_omega_8h)) then
          allocate( inner_omega_8h(inner_stepon_do) )
        endif
        inner_omega_8h(fvcore_tape_rec+1) = omega
        if ( .not. allocated(inner_q_9h)) then
          allocate( inner_q_9h(1:size(q,1),1:size(q,2),1:size(q,3),1:size(q,4),inner_stepon_do) )
        endif
        inner_q_9h(:,:,:,:,fvcore_tape_rec+1) = q
        om = omega
        cp = cpair
        rg = rair
        ae = rearth
        call fvcore_domd( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,ae,iord,
     $jord,kord,umax,omga,peln,consv,convt )
        if ( .not. allocated(inner_q_10h)) then
          allocate( inner_q_10h(1:size(q,1),1:size(q,2),1:size(q,3),1:size(q,4),inner_stepon_do) )
        endif
        inner_q_10h(:,:,:,:,fvcore_tape_rec+1) = q
        if (force_dycore) then
          if ( .not. allocated(inner_u_9h)) then
            allocate( inner_u_9h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
          endif
          inner_u_9h(:,:,:,fvcore_tape_rec+1) = u
          if ( .not. allocated(inner_v_10h)) then
            allocate( inner_v_10h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
          endif
          inner_v_10h(:,:,:,fvcore_tape_rec+1) = v
          if ( .not. allocated(inner_pt_11h)) then
            allocate( inner_pt_11h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
          endif
          inner_pt_11h(:,:,:,fvcore_tape_rec+1) = pt
          if ( .not. allocated(inner_pe_12h)) then
            allocate( inner_pe_12h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
          endif
          inner_pe_12h(:,:,:,fvcore_tape_rec+1) = pe
          if ( .not. allocated(inner_pkz_13h)) then
            allocate( inner_pkz_13h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
          endif
          inner_pkz_13h(:,:,:,fvcore_tape_rec+1) = pkz
        endif
        if (aoa) then
          if ( .not. allocated(inner_pe_14h)) then
            allocate( inner_pe_14h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
          endif
          inner_pe_14h(:,:,:,fvcore_tape_rec+1) = pe
        endif
        call zeit_co('fvcore_domd')

        endif ! <checkpointed>

C----------------------------------------------
C ADJOINT COMPUTATIONS
C----------------------------------------------
        call zeit_ci('fvcore_ad')
        do iinner = ninner, 1, -1
          nstep = iinner-1+(iouter-1)*ninner
          if (nouter_for_checkpoint==1) then
              fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
          else
              fvcore_tape_rec = iouter-1+(iinner-1)*ninner
          endif
          delp = inner_delp_1h(:,:,:,fvcore_tape_rec+1)
          pk = inner_pk_3h(:,:,:,fvcore_tape_rec+1)
          omega = inner_omega_8h(fvcore_tape_rec+1)
          om = omega
          cp = cpair
          rg = rair
          ae = rearth
          nstep = nstep+1
          if (aoa) then
            pe = inner_pe_14h(:,:,:,fvcore_tape_rec+1)
            model_time = nstep*pdt
            call age_of_air_ad( imr,nl,jfirst,jlast,ng_d,model_time,pe,pe_ad,q_ad(1,jfirst-ng_d,1,nq) )
          endif
          if (force_dycore) then
            u = inner_u_9h(:,:,:,fvcore_tape_rec+1)
            v = inner_v_10h(:,:,:,fvcore_tape_rec+1)
            pt = inner_pt_11h(:,:,:,fvcore_tape_rec+1)
            pe = inner_pe_12h(:,:,:,fvcore_tape_rec+1)
            pkz = inner_pkz_13h(:,:,:,fvcore_tape_rec+1)
            akap = cappa
            call hswf_do_ad( imr,jnp,nl,jfirst,jlast,u,u_ad,v,v_ad,pt,pt_ad,pe,pe_ad,pkz,pkz_ad,pdt,akap,dcaf, .true. ,rayf,cosp,
     $coslon,sinlon,ng_s,ng_d )
          endif
#ifdef TIMING
          call adtiming_off( 'FVCORE' )
#endif
          nymd_trj = outer_time_nymd_trj_3h(iouter)
          nhms_trj = outer_time_nhms_trj_4h(iouter)
          q = inner_q_10h(:,:,:,:,fvcore_tape_rec+1)
          call physdrv1_ad( ptrjtmpl,ptrjfrq,job,imr,jnp,nl,nc,jfirst,jlast, 
     $     coslon,sinlon,q,nymd_trj,nhms_trj,u_ad,v_ad,pt_ad,ng_d,ng_s)
          pe = inner_pe_2h(:,:,:,fvcore_tape_rec+1)
          pkz = inner_pkz_4h(:,:,:,fvcore_tape_rec+1)
          pt = inner_pt_5h(:,:,:,fvcore_tape_rec+1)
          u = inner_u_6h(:,:,:,fvcore_tape_rec+1)
          v = inner_v_7h(:,:,:,fvcore_tape_rec+1)
          q = inner_q_9h(:,:,:,:,fvcore_tape_rec+1)
          call fvcore_do_ad( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,ps_ad,pe,pe_ad,delp,delp_ad,u,u_ad,v,v_ad,pt,pt_ad,q,q_ad,
     $pk,pk_ad,pkz,pkz_ad,phis,ptop,om,cp,rg,ae,iord,jord,kord,umax,peln,consv,convt )
#ifdef TIMING
          call adtiming_on( 'FVCORE' )
#endif
        end do
        call zeit_co('fvcore_ad')

        if(checkpoint==0) call stepon_final_ad()

      end do
      if(checkpoint>0) checkpointed_ = .true.

!       If so, convert GEOS-4 perturbation to GEOS-5-type
!       -------------------------------------------------
        if ( g5pert .and. adfirst ) then
             call getstate( nymd_last, nhms_last, prog, doremap )
             call t2th_ad ( delp, pt, pkz_ad, pt_ad )
             ua_ad = 0._r8
             va_ad = 0._r8
             call a2d3d_ad( ua_ad, va_ad, pert%u, pert%v, imr, jnp, nl, jfirst, jlast, ng_d, ng_s )
             pert%u(:,jlast+1:jlast+ng_s,:) = 0._r8
             pert%v(:,jlast+1:jlast+ng_d,:) = 0._r8; pert%v(:,jfirst-ng_s:jfirst-1,:) = 0._r8
             pert%u(:,jfirst-ng_d:jlast,:) = ua_ad(:,jfirst-ng_d:jlast,:)
             pert%v(:,jfirst     :jlast,:) = va_ad(:,jfirst     :jlast,:)
!            call ps2delp_ad ( im, jfirst, jlast, nl, delp_ad )
        endif

      call prognostics_dup ( pert, xpert )

      call prognostics_final ( pert )

C----------------------------------------------
C CLOSE TAPE outer_time
C----------------------------------------------

      if (checkpoint==0) then

      if (allocated(outer_time_nymd_1h)) then
        deallocate( outer_time_nymd_1h )
      endif
      if (allocated(outer_time_nhms_2h)) then
        deallocate( outer_time_nhms_2h )
      endif
      if (allocated(outer_time_nymd_trj_3h)) then
        deallocate( outer_time_nymd_trj_3h )
      endif
      if (allocated(outer_time_nhms_trj_4h)) then
        deallocate( outer_time_nhms_trj_4h )
      endif

      endif ! < checkpoint >

      end subroutine stepon_do_ad


      subroutine stepon_domd ( prog )
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use m_iostate, only : getstate

      use fvcore, only : ns,fvcore_do
      use fvcore, only : fvcore_tape_rec
      use fvcore, only : dynpkg_n2,dynpkg_nsplit
      use fvcore, only : ng_c
      use hswf, only : hswf_do
      use mapz_module, only: te_map

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none
      type(dyn_prog)         :: prog

C==============================================
C declare local variables
C==============================================
      real(kind=r8) :: ae
      real(kind=r8) :: akap
      real(kind=r8) :: cp
      character*255 :: fnametrj
      real(kind=r8) :: grav
      integer :: iinner
      integer :: iouter
      integer :: nhms_trj
      integer :: nymd_trj
      integer :: rmaptfrq
      integer :: nx
      integer :: ierr
      real(kind=r8) :: om
      real(kind=r8) :: te0
      real(kind=r8) :: rg
      logical       :: doremap

! Set pointers
! ------------
       u   => prog%u
       v   => prog%v
      pt   => prog%pt
      delp => prog%delp
      q    => prog%q


C**********************************************
C executable statements of routine
C**********************************************

      do iouter = 1, nouter
        nymd_trj = nymd
        nhms_trj = nhms

        call getstate( nymd_trj, nhms_trj, prog, doremap )
        call tick( nymd_trj,nhms_trj,pdt )

        if (doremap) then
           nx = 4
           te0 = 1.0
           call te_map(.false., .false., ps, omga, pe, delp, pkz, pk, mpdt,
     &                  imr, jnp, nl, nx, jfirst, jlast, nq,  u,  v,
     &                  pt, q, phis,  cpair, cappa, kord, peln, te0,
     &                  ng_d, ng_s, 0 )
        endif


        do iinner = 1, ninner
          nstep = iinner-1+(iouter-1)*ninner
          fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
          om = omega
          cp = cpair
          rg = rair
          ae = rearth
          call fvcore_do( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,ae,iord,
     $jord,kord,umax,omga,peln,consv,convt )
          nstep = nstep+1
          call tick( nymd,nhms,pdt )
          mcsec = nsecf(nhms)
          if (force_dycore) then
            rg = rair
            akap = cappa
            call hswf_do( imr,jnp,nl,jfirst,jlast,u,v,pt,pe,pkz,pdt,akap,grav,rg,dcaf, .true. ,rayf,sinp,cosp,sine,cose,coslon,
     $sinlon,ng_s,ng_d )
          endif
          if (aoa) then
            model_time = nstep*pdt
            call age_of_air( imr,jnp,nl,jfirst,jlast,ng_d,model_time,pe,q(1,jfirst-ng_d,1,nq) )
          endif
        end do
      end do
      if (aoa) then
        model_time = nstep*pdt
      endif
      end subroutine stepon_domd


      subroutine stepon_set_ad ( prog_ad )
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none
      type(dyn_prog)         :: prog_ad

! Set pointers
! ------------
       u_ad   => prog_ad%u
       v_ad   => prog_ad%v
      pt_ad   => prog_ad%pt
      delp_ad => prog_ad%delp
      q_ad    => prog_ad%q

C----------------------------------------------
C RESET MODULE ADJOINT VARIABLES
C----------------------------------------------
      delp_ad(:,:,:) = 0._r8
      ps_ad(:,:) = 0._r8
      pt_ad(:,:,:) = 0._r8
      q_ad(:,:,:,:) = 0._r8
      u_ad(:,:,:) = 0._r8
      v_ad(:,:,:) = 0._r8

      end subroutine stepon_set_ad


      subroutine stepon_final_ad

      use c_sw_ad_store, only : c_sw_tape1_a6_5h,c_sw_tape1_c_sw,c_sw_tape1_crx_9h,c_sw_tape1_ptk_4h,c_sw_tape1_tm2_3h,
     $c_sw_tape1_tm2_7h,c_sw_tape1_v2_6h,c_sw_tape1_xfx_1h,c_sw_tape1_yfx_2h,c_sw_tape1_ymass_8h,c_sw_tape2_a6_1h,c_sw_tape2_c_sw,
     $c_sw_tape2_slope_2h
      use cd_core_do_ad_store, only : cd_core_tape_cd_core_do,cd_core_tape_delp_17h,cd_core_tape_delp_4h,cd_core_tape_delpf_3h,
     $cd_core_tape_pkc_10h,cd_core_tape_pkc_21h,cd_core_tape_pkc_23h,cd_core_tape_pkc_8h,cd_core_tape_pt_16h,cd_core_tape_pt_18h,
     $cd_core_tape_pt_5h,cd_core_tape_ptc_6h,cd_core_tape_ptk_7h,cd_core_tape_u_12h,cd_core_tape_u_1h,cd_core_tape_uc_14h,
     $cd_core_tape_v_13h,cd_core_tape_v_2h,cd_core_tape_vc_15h,cd_core_tape_wz3_25h,cd_core_tape_wz_11h,cd_core_tape_wz_22h,
     $cd_core_tape_wz_24h,cd_core_tape_wz_9h
      use d_sw_ad_store, only : d_sw_tape1_d_sw,d_sw_tape1_delp_5h,d_sw_tape1_delpf_1h,d_sw_tape1_ub_6h,d_sw_tape1_uc_7h,
     $d_sw_tape1_wk1_4h,d_sw_tape1_xfx_2h,d_sw_tape1_yfx_3h,d_sw_tapej_a6_1h,d_sw_tapej_d_sw,d_sw_tapej_slope_2h
      use fvcore_do_ad_store, only : dynpkg_1_fvcore_do,dynpkg_1_pe_4h,dynpkg_1_pk_2h,dynpkg_1_ps_5h,dynpkg_1_pt_6h,dynpkg_1_q_3h,
     $dynpkg_1_te0_1h,dynpkg_n2_cx_3h,dynpkg_n2_cy_4h,dynpkg_n2_dp0_1h,dynpkg_n2_fvcore_do,dynpkg_n2_mfx_5h,dynpkg_n2_mfy_6h,
     $dynpkg_n2_q_2h
      use te_map_ad_store, only : te_map_tape_delp_15h,te_map_tape_dtmp_18h,te_map_tape_dz_8h,te_map_tape_pe_14h,
     $te_map_tape_peln_12h,te_map_tape_pk_1h,te_map_tape_pkz_13h,te_map_tape_pkz_2h,te_map_tape_te_11h,te_map_tape_te_19h,
     $te_map_tape_te_9h,te_map_tape_te_map,te_map_tape_tsum_16h,te_map_tape_u_17h,te_map_tape_u_6h,te_map_tape_v_10h,
     $te_map_tape_v_7h
      use tpcc_ad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc
      use stepon_ad_store, only : inner_delp_1h, inner_pe_12h, inner_pe_14h, inner_pe_2h, inner_pk_3h, inner_pkz_13h,
     $                            inner_pkz_4h, inner_pt_11h, inner_pt_5h, inner_u_6h, inner_u_9h, inner_v_10h,
     $                            inner_v_7h, inner_q_9h, inner_omega_8h, inner_q_10h
      use stepon_ad_store, only : outer_time_nhms_2h, outer_time_nhms_trj_4h, outer_time_nymd_1h, outer_time_nymd_trj_3h

      implicit none

C----------------------------------------------
C CLOSE TAPE c_sw_tape1
C----------------------------------------------

        if (allocated(c_sw_tape1_xfx_1h)) then
          deallocate( c_sw_tape1_xfx_1h )
        endif
        if (allocated(c_sw_tape1_yfx_2h)) then
          deallocate( c_sw_tape1_yfx_2h )
        endif
        if (allocated(c_sw_tape1_tm2_3h)) then
          deallocate( c_sw_tape1_tm2_3h )
        endif
        if (allocated(c_sw_tape1_ptk_4h)) then
          deallocate( c_sw_tape1_ptk_4h )
        endif
        if (allocated(c_sw_tape1_a6_5h)) then
          deallocate( c_sw_tape1_a6_5h )
        endif
        if (allocated(c_sw_tape1_v2_6h)) then
          deallocate( c_sw_tape1_v2_6h )
        endif
        if (allocated(c_sw_tape1_tm2_7h)) then
          deallocate( c_sw_tape1_tm2_7h )
        endif
        if (allocated(c_sw_tape1_ymass_8h)) then
          deallocate( c_sw_tape1_ymass_8h )
        endif
        if (allocated(c_sw_tape1_crx_9h)) then
          deallocate( c_sw_tape1_crx_9h )
        endif

C----------------------------------------------
C CLOSE TAPE c_sw_tape2
C----------------------------------------------
        if (allocated(c_sw_tape2_a6_1h)) then
          deallocate( c_sw_tape2_a6_1h )
        endif
        if (allocated(c_sw_tape2_slope_2h)) then
          deallocate( c_sw_tape2_slope_2h )
        endif

C----------------------------------------------
C CLOSE TAPE cd_core_tape
C----------------------------------------------
        if (allocated(cd_core_tape_u_1h)) then
          deallocate( cd_core_tape_u_1h )
        endif
        if (allocated(cd_core_tape_v_2h)) then
          deallocate( cd_core_tape_v_2h )
        endif
        if (allocated(cd_core_tape_delpf_3h)) then
          deallocate( cd_core_tape_delpf_3h )
        endif
        if (allocated(cd_core_tape_delp_4h)) then
          deallocate( cd_core_tape_delp_4h )
        endif
        if (allocated(cd_core_tape_pt_5h)) then
          deallocate( cd_core_tape_pt_5h )
        endif
        if (allocated(cd_core_tape_ptc_6h)) then
          deallocate( cd_core_tape_ptc_6h )
        endif
        if (allocated(cd_core_tape_ptk_7h)) then
          deallocate( cd_core_tape_ptk_7h )
        endif
        if (allocated(cd_core_tape_pkc_8h)) then
          deallocate( cd_core_tape_pkc_8h )
        endif
        if (allocated(cd_core_tape_wz_9h)) then
          deallocate( cd_core_tape_wz_9h )
        endif
        if (allocated(cd_core_tape_pkc_10h)) then
          deallocate( cd_core_tape_pkc_10h )
        endif
        if (allocated(cd_core_tape_wz_11h)) then
          deallocate( cd_core_tape_wz_11h )
        endif
        if (allocated(cd_core_tape_u_12h)) then
          deallocate( cd_core_tape_u_12h )
        endif
        if (allocated(cd_core_tape_v_13h)) then
          deallocate( cd_core_tape_v_13h )
        endif
        if (allocated(cd_core_tape_uc_14h)) then
          deallocate( cd_core_tape_uc_14h )
        endif
        if (allocated(cd_core_tape_vc_15h)) then
          deallocate( cd_core_tape_vc_15h )
        endif
        if (allocated(cd_core_tape_pt_16h)) then
          deallocate( cd_core_tape_pt_16h )
        endif
        if (allocated(cd_core_tape_delp_17h)) then
          deallocate( cd_core_tape_delp_17h )
        endif
        if (allocated(cd_core_tape_pt_18h)) then
          deallocate( cd_core_tape_pt_18h )
        endif
        if (allocated(cd_core_tape_pkc_21h)) then
          deallocate( cd_core_tape_pkc_21h )
        endif
        if (allocated(cd_core_tape_wz_22h)) then
          deallocate( cd_core_tape_wz_22h )
        endif
        if (allocated(cd_core_tape_pkc_23h)) then
          deallocate( cd_core_tape_pkc_23h )
        endif
        if (allocated(cd_core_tape_wz_24h)) then
          deallocate( cd_core_tape_wz_24h )
        endif
        if (allocated(cd_core_tape_wz3_25h)) then
          deallocate( cd_core_tape_wz3_25h )
        endif

C----------------------------------------------
C CLOSE TAPE d_sw_tape1
C----------------------------------------------
        if (allocated(d_sw_tape1_delpf_1h)) then
          deallocate( d_sw_tape1_delpf_1h )
        endif
        if (allocated(d_sw_tape1_xfx_2h)) then
          deallocate( d_sw_tape1_xfx_2h )
        endif
        if (allocated(d_sw_tape1_yfx_3h)) then
          deallocate( d_sw_tape1_yfx_3h )
        endif
        if (allocated(d_sw_tape1_wk1_4h)) then
          deallocate( d_sw_tape1_wk1_4h )
        endif
        if (allocated(d_sw_tape1_delp_5h)) then
          deallocate( d_sw_tape1_delp_5h )
        endif
        if (allocated(d_sw_tape1_ub_6h)) then
          deallocate( d_sw_tape1_ub_6h )
        endif
        if (allocated(d_sw_tape1_uc_7h)) then
          deallocate( d_sw_tape1_uc_7h )
        endif

C----------------------------------------------
C CLOSE TAPE d_sw_tapej
C----------------------------------------------
        if (allocated(d_sw_tapej_a6_1h)) then
          deallocate( d_sw_tapej_a6_1h )
        endif
        if (allocated(d_sw_tapej_slope_2h)) then
          deallocate( d_sw_tapej_slope_2h )
        endif

C----------------------------------------------
C CLOSE TAPE dynpkg_1
C----------------------------------------------
        if (allocated(dynpkg_1_te0_1h)) then
          deallocate( dynpkg_1_te0_1h )
        endif
        if (allocated(dynpkg_1_pk_2h)) then
          deallocate( dynpkg_1_pk_2h )
        endif
        if (allocated(dynpkg_1_q_3h)) then
          deallocate( dynpkg_1_q_3h )
        endif
        if (allocated(dynpkg_1_pe_4h)) then
          deallocate( dynpkg_1_pe_4h )
        endif
        if (allocated(dynpkg_1_ps_5h)) then
          deallocate( dynpkg_1_ps_5h )
        endif
        if (allocated(dynpkg_1_pt_6h)) then
          deallocate( dynpkg_1_pt_6h )
        endif

C----------------------------------------------
C CLOSE TAPE dynpkg_n2
C----------------------------------------------
        if (allocated(dynpkg_n2_dp0_1h)) then
          deallocate( dynpkg_n2_dp0_1h )
        endif
        if (allocated(dynpkg_n2_q_2h)) then
          deallocate( dynpkg_n2_q_2h )
        endif
        if (allocated(dynpkg_n2_cx_3h)) then
          deallocate( dynpkg_n2_cx_3h )
        endif
        if (allocated(dynpkg_n2_cy_4h)) then
          deallocate( dynpkg_n2_cy_4h )
        endif
        if (allocated(dynpkg_n2_mfx_5h)) then
          deallocate( dynpkg_n2_mfx_5h )
        endif
        if (allocated(dynpkg_n2_mfy_6h)) then
          deallocate( dynpkg_n2_mfy_6h )
        endif

C----------------------------------------------
C CLOSE TAPE inner
C----------------------------------------------
        if (allocated(inner_delp_1h)) then
          deallocate( inner_delp_1h )
        endif
        if (allocated(inner_pe_2h)) then
          deallocate( inner_pe_2h )
        endif
        if (allocated(inner_pk_3h)) then
          deallocate( inner_pk_3h )
        endif
        if (allocated(inner_pkz_4h)) then
          deallocate( inner_pkz_4h )
        endif
        if (allocated(inner_pt_5h)) then
          deallocate( inner_pt_5h )
        endif
        if (allocated(inner_u_6h)) then
          deallocate( inner_u_6h )
        endif
        if (allocated(inner_v_7h)) then
          deallocate( inner_v_7h )
        endif
        if (allocated(inner_omega_8h)) then
          deallocate( inner_omega_8h )
        endif
        if (allocated(inner_q_9h)) then
          deallocate( inner_q_9h )
        endif
        if (allocated(inner_q_10h)) then
          deallocate( inner_q_10h )
        endif
        if (allocated(inner_u_9h)) then
          deallocate( inner_u_9h )
        endif
        if (allocated(inner_v_10h)) then
          deallocate( inner_v_10h )
        endif
        if (allocated(inner_pt_11h)) then
          deallocate( inner_pt_11h )
        endif
        if (allocated(inner_pe_12h)) then
          deallocate( inner_pe_12h )
        endif
        if (allocated(inner_pkz_13h)) then
          deallocate( inner_pkz_13h )
        endif
        if (allocated(inner_pe_14h)) then
          deallocate( inner_pe_14h )
        endif

C----------------------------------------------
C CLOSE TAPE te_map_tape
C----------------------------------------------
        if (allocated(te_map_tape_pk_1h)) then
          deallocate( te_map_tape_pk_1h )
        endif
        if (allocated(te_map_tape_pkz_2h)) then
          deallocate( te_map_tape_pkz_2h )
        endif
        if (allocated(te_map_tape_u_6h)) then
          deallocate( te_map_tape_u_6h )
        endif
        if (allocated(te_map_tape_v_7h)) then
          deallocate( te_map_tape_v_7h )
        endif
        if (allocated(te_map_tape_dz_8h)) then
          deallocate( te_map_tape_dz_8h )
        endif
        if (allocated(te_map_tape_te_9h)) then
          deallocate( te_map_tape_te_9h )
        endif
        if (allocated(te_map_tape_v_10h)) then
          deallocate( te_map_tape_v_10h )
        endif
        if (allocated(te_map_tape_te_11h)) then
          deallocate( te_map_tape_te_11h )
        endif
        if (allocated(te_map_tape_peln_12h)) then
          deallocate( te_map_tape_peln_12h )
        endif
        if (allocated(te_map_tape_pkz_13h)) then
          deallocate( te_map_tape_pkz_13h )
        endif
        if (allocated(te_map_tape_pe_14h)) then
          deallocate( te_map_tape_pe_14h )
        endif
        if (allocated(te_map_tape_delp_15h)) then
          deallocate( te_map_tape_delp_15h )
        endif
        if (allocated(te_map_tape_tsum_16h)) then
          deallocate( te_map_tape_tsum_16h )
        endif
        if (allocated(te_map_tape_u_17h)) then
          deallocate( te_map_tape_u_17h )
        endif
        if (allocated(te_map_tape_dtmp_18h)) then
          deallocate( te_map_tape_dtmp_18h )
        endif
        if (allocated(te_map_tape_te_19h)) then
          deallocate( te_map_tape_te_19h )
        endif

C----------------------------------------------
C CLOSE TAPE tpcc1_tape
C----------------------------------------------
        if (allocated(tpcc1_tape_a6_1h)) then
          deallocate( tpcc1_tape_a6_1h )
        endif
        if (allocated(tpcc1_tape_dm_2h)) then
          deallocate( tpcc1_tape_dm_2h )
        endif

C----------------------------------------------
C CLOSE TAPE tpcc2_tape
C----------------------------------------------
        if (allocated(tpcc2_tape_a6_1h)) then
          deallocate( tpcc2_tape_a6_1h )
        endif
        if (allocated(tpcc2_tape_dm_2h)) then
          deallocate( tpcc2_tape_dm_2h )
        endif

C----------------------------------------------
C CLOSE TAPE outer_time
C----------------------------------------------
!     if (allocated(outer_time_nymd_1h)) then
!       deallocate( outer_time_nymd_1h )
!     endif
!     if (allocated(outer_time_nhms_2h)) then
!       deallocate( outer_time_nhms_2h )
!     endif
!     if (allocated(outer_time_nymd_trj_3h)) then
!       deallocate( outer_time_nymd_trj_3h )
!     endif
!     if (allocated(outer_time_nhms_trj_4h)) then
!       deallocate( outer_time_nhms_trj_4h )
!     endif


      end subroutine stepon_final_ad


      end module     stepon_ad


#else  /* SPMD */
C                           DISCLAIMER
C
C   This file was generated by TAF version 1.6.1
C
C   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
C   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
C   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
C   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
C   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
C   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
C   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
C   OF THE POSSIBILITY OF SUCH DAMAGES.
C
C                           Haftungsbeschraenkung
C   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
C   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
C   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
C   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
C   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
C   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
C   Mitteilung darueber an FastOpt.
C
      module     stepon_ad
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use precision
      use prognostics
      use m_strtemplate
#ifdef TIMING
      use timingmodule, only : timing_init, timing_off, timing_on
#endif
      use stepon

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

      contains
      subroutine stepon_do_ad
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use m_iostate, only : getstate

      use m_trajmng, only : putpert

      use fvcore, only : ns,fvcore_do
      use fvcore, only : fvcore_tape_rec
      use fvcore, only : dynpkg_n2,dynpkg_nsplit
      use fvcore, only : ng_c
      use hswf, only : hswf_do
      use hswf_ad, only : hswf_do_ad
      use fvcore_ad, only : fvcore_do_ad, fvcore_domd
      use c_sw_ad_store, only : c_sw_tape1_a6_5h,c_sw_tape1_c_sw,c_sw_tape1_crx_9h,c_sw_tape1_ptk_4h,c_sw_tape1_tm2_3h,
     $c_sw_tape1_tm2_7h,c_sw_tape1_v2_6h,c_sw_tape1_xfx_1h,c_sw_tape1_yfx_2h,c_sw_tape1_ymass_8h,c_sw_tape2_a6_1h,c_sw_tape2_c_sw,
     $c_sw_tape2_slope_2h
      use cd_core_do_ad_store, only : cd_core_tape_cd_core_do,cd_core_tape_delp_17h,cd_core_tape_delp_4h,cd_core_tape_delpf_3h,
     $cd_core_tape_pkc_10h,cd_core_tape_pkc_19h,cd_core_tape_pkc_21h,cd_core_tape_pkc_8h,cd_core_tape_pt_16h,cd_core_tape_pt_18h,
     $cd_core_tape_pt_5h,cd_core_tape_ptc_6h,cd_core_tape_ptk_7h,cd_core_tape_u_12h,cd_core_tape_u_1h,cd_core_tape_uc_14h,
     $cd_core_tape_v_13h,cd_core_tape_v_2h,cd_core_tape_vc_15h,cd_core_tape_wz3_23h,cd_core_tape_wz_11h,cd_core_tape_wz_20h,
     $cd_core_tape_wz_22h,cd_core_tape_wz_9h
      use d_sw_ad_store, only : d_sw_tape1_d_sw,d_sw_tape1_delp_5h,d_sw_tape1_delpf_1h,d_sw_tape1_ub_6h,d_sw_tape1_uc_7h,
     $d_sw_tape1_wk1_4h,d_sw_tape1_xfx_2h,d_sw_tape1_yfx_3h,d_sw_tapej_a6_1h,d_sw_tapej_d_sw,d_sw_tapej_slope_2h
      use fvcore_do_ad_store, only : dynpkg_1_fvcore_do,dynpkg_1_pe_4h,dynpkg_1_pk_2h,dynpkg_1_ps_5h,dynpkg_1_pt_6h,dynpkg_1_q_3h,
     $dynpkg_1_te0_1h,dynpkg_n2_cx_3h,dynpkg_n2_cy_4h,dynpkg_n2_dp0_1h,dynpkg_n2_fvcore_do,dynpkg_n2_mfx_5h,dynpkg_n2_mfy_6h,
     $dynpkg_n2_q_2h
      use te_map_ad_store, only : te_map_tape_delp_15h,te_map_tape_dtmp_18h,te_map_tape_dz_8h,te_map_tape_pe_14h,
     $te_map_tape_peln_12h,te_map_tape_pk_1h,te_map_tape_pkz_13h,te_map_tape_pkz_2h,te_map_tape_te_11h,te_map_tape_te_19h,
     $te_map_tape_te_9h,te_map_tape_te_map,te_map_tape_tsum_16h,te_map_tape_u_17h,te_map_tape_u_6h,te_map_tape_v_10h,
     $te_map_tape_v_7h
      use tpcc_ad_store, only : tpcc1_tape_a6_1h,tpcc1_tape_dm_2h,tpcc1_tape_tpcc,tpcc2_tape_a6_1h,tpcc2_tape_dm_2h,tpcc2_tape_tpcc
      use m_physdrv1_ad, only : physdrv1_ad

!
!  RME added next line:  Add module for polar filter of SVs
      use m_pftSV
      use mapz_module, only: te_map

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

C==============================================
C declare local variables
C==============================================
      real(kind=r8) :: ae
      real(kind=r8) :: akap
      real(kind=r8) :: cp
      character*255 :: fnametrj
      real(kind=r8) :: grav
      integer :: iinner
      real(kind=r8), allocatable :: inner_delp_1h(:,:,:,:)
      real, allocatable :: inner_omega_8h(:)
      real(kind=r8), allocatable :: inner_pe_12h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pe_14h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pe_2h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pk_3h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pkz_13h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pkz_4h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pt_11h(:,:,:,:)
      real(kind=r8), allocatable :: inner_pt_5h(:,:,:,:)
      integer :: inner_stepon_do
      real(kind=r8), allocatable :: inner_q_6h(:,:,:,:,:)
      real(kind=r8), allocatable :: inner_u_6h(:,:,:,:)
      real(kind=r8), allocatable :: inner_u_9h(:,:,:,:)
      real(kind=r8), allocatable :: inner_v_10h(:,:,:,:)
      real(kind=r8), allocatable :: inner_v_7h(:,:,:,:)
      integer :: iouter

      integer :: nhms_trj
      integer :: nymd_trj
      integer :: rmaptfrq
      integer :: nx
      integer :: ierr
      real(kind=r8) :: om
      integer, allocatable :: outer_time_nhms_2h(:)
      integer, allocatable :: outer_time_nhms_trj_4h(:)
      integer, allocatable :: outer_time_nymd_1h(:)
      integer, allocatable :: outer_time_nymd_trj_3h(:)
      integer :: outer_time_stepon_do
      real(kind=r8) :: rg
      real(kind=r8) :: te0

      character(len=*), parameter :: diagnlmrc = 'nlmstatead.rc'
      character(len=*), parameter :: diagadmrc = 'admstate.rc'

      logical       :: doremap

!
!  RME added next line:  Add array  for polar filter of SVs
      real(kind=r8), allocatable :: fields_pft(:,:,:,:)

C----------------------------------------------
C ROUTINE BODY
C----------------------------------------------
C----------------------------------------------
C OPEN TAPE outer_time
C----------------------------------------------
      outer_time_stepon_do = nouter

C----------------------------------------------
C TAPE COMPUTATIONS
C----------------------------------------------
      do iouter = 1, nouter-1
        if ( .not. allocated(outer_time_nymd_1h)) then
          allocate( outer_time_nymd_1h(outer_time_stepon_do) )
        endif
        outer_time_nymd_1h(iouter) = nymd
        if ( .not. allocated(outer_time_nhms_2h)) then
          allocate( outer_time_nhms_2h(outer_time_stepon_do) )
        endif
        outer_time_nhms_2h(iouter) = nhms
        nymd_trj = nymd
        nhms_trj = nhms
        call tick( nymd_trj,nhms_trj,pdt )
        if ( .not. allocated(outer_time_nymd_trj_3h)) then
          allocate( outer_time_nymd_trj_3h(outer_time_stepon_do) )
        endif
        outer_time_nymd_trj_3h(iouter) = nymd_trj
        if ( .not. allocated(outer_time_nhms_trj_4h)) then
          allocate( outer_time_nhms_trj_4h(outer_time_stepon_do) )
        endif
        outer_time_nhms_trj_4h(iouter) = nhms_trj
        do iinner = 1, ninner
          call tick( nymd,nhms,pdt )
        end do
      end do
      iouter = nouter
      if ( .not. allocated(outer_time_nymd_1h)) then
        allocate( outer_time_nymd_1h(outer_time_stepon_do) )
      endif
      outer_time_nymd_1h(iouter) = nymd
      if ( .not. allocated(outer_time_nhms_2h)) then
        allocate( outer_time_nhms_2h(outer_time_stepon_do) )
      endif
      outer_time_nhms_2h(iouter) = nhms
      nymd_trj = nymd
      nhms_trj = nhms
      call tick( nymd_trj,nhms_trj,pdt )
      if ( .not. allocated(outer_time_nymd_trj_3h)) then
        allocate( outer_time_nymd_trj_3h(outer_time_stepon_do) )
      endif
      outer_time_nymd_trj_3h(iouter) = nymd_trj
      if ( .not. allocated(outer_time_nhms_trj_4h)) then
        allocate( outer_time_nhms_trj_4h(outer_time_stepon_do) )
      endif
      outer_time_nhms_trj_4h(iouter) = nhms_trj

C----------------------------------------------
C ADJOINT COMPUTATIONS
C----------------------------------------------
#ifdef TIMING
      call adtiming_off( 'TOTAL' )
#endif

      do iouter = nouter, 1, -1
        nymd = outer_time_nymd_1h(iouter)
        nhms = outer_time_nhms_2h(iouter)
        nymd_trj = nymd
        nhms_trj = nhms
        call tick( nymd_trj,nhms_trj,pdt )
        nymd_trj = outer_time_nymd_trj_3h(iouter)
        nhms_trj = outer_time_nhms_trj_4h(iouter)

        call getstate( nymd_trj, nhms_trj, prog, doremap )

        if (doremap) then
           nx = 4
           te0 = 1.0
           call te_map(.false., .false., ps, omga, pe, delp, pkz, pk, mpdt,
     &                     imr, jnp, nl, nx, jfirst, jlast, nq,  u,  v,
     &                     pt, q, phis,  cpair, cappa, kord, peln, te0,
     &                     ng_d, ng_s, 0 )
        endif

C----------------------------------------------
C OPEN TAPE c_sw_tape1
C----------------------------------------------
        c_sw_tape1_c_sw = ninner*dynpkg_nsplit*dynpkg_n2*nl*1

C----------------------------------------------
C OPEN TAPE c_sw_tape2
C----------------------------------------------
        c_sw_tape2_c_sw = ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C OPEN TAPE cd_core_tape
C----------------------------------------------
        cd_core_tape_cd_core_do = ninner*dynpkg_nsplit*dynpkg_n2

C----------------------------------------------
C OPEN TAPE d_sw_tape1
C----------------------------------------------
        d_sw_tape1_d_sw = ninner*dynpkg_nsplit*dynpkg_n2*nl*1

C----------------------------------------------
C OPEN TAPE d_sw_tapej
C----------------------------------------------
        d_sw_tapej_d_sw = ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C OPEN TAPE dynpkg_1
C----------------------------------------------
        dynpkg_1_fvcore_do = ninner

C----------------------------------------------
C OPEN TAPE dynpkg_n2
C----------------------------------------------
        dynpkg_n2_fvcore_do = ninner*dynpkg_n2

C----------------------------------------------
C OPEN TAPE inner
C----------------------------------------------
        inner_stepon_do = ninner

C----------------------------------------------
C OPEN TAPE te_map_tape
C----------------------------------------------
        te_map_tape_te_map = ninner

C----------------------------------------------
C OPEN TAPE tpcc1_tape
C----------------------------------------------
        tpcc1_tape_tpcc = ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C OPEN TAPE tpcc2_tape
C----------------------------------------------
        tpcc2_tape_tpcc = ninner*dynpkg_nsplit*dynpkg_n2*nl*(jnp-1)

C----------------------------------------------
C TAPE COMPUTATIONS
C----------------------------------------------
        do iinner = 1, ninner-1
          nstep = iinner-1+(iouter-1)*ninner
          fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
          if ( .not. allocated(inner_delp_1h)) then
            allocate( inner_delp_1h(1:size(delp,1),1:size(delp,2),1:size(delp,3),inner_stepon_do) )
          endif
          inner_delp_1h(:,:,:,fvcore_tape_rec+1) = delp
          if ( .not. allocated(inner_pe_2h)) then
            allocate( inner_pe_2h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
          endif
          inner_pe_2h(:,:,:,fvcore_tape_rec+1) = pe
          if ( .not. allocated(inner_pk_3h)) then
            allocate( inner_pk_3h(1:size(pk,1),1:size(pk,2),1:size(pk,3),inner_stepon_do) )
          endif
          inner_pk_3h(:,:,:,fvcore_tape_rec+1) = pk
          if ( .not. allocated(inner_pkz_4h)) then
            allocate( inner_pkz_4h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
          endif
          inner_pkz_4h(:,:,:,fvcore_tape_rec+1) = pkz
          if ( .not. allocated(inner_pt_5h)) then
            allocate( inner_pt_5h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
          endif
          inner_pt_5h(:,:,:,fvcore_tape_rec+1) = pt
          if ( .not. allocated(inner_q_6h)) then
            allocate( inner_q_6h(1:size(q,1),1:size(q,2),1:size(q,3),1:size(q,4),inner_stepon_do) )
          endif
          inner_q_6h(:,:,:,:,fvcore_tape_rec+1) = q
          if ( .not. allocated(inner_u_6h)) then
            allocate( inner_u_6h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
          endif
          inner_u_6h(:,:,:,fvcore_tape_rec+1) = u
          if ( .not. allocated(inner_v_7h)) then
            allocate( inner_v_7h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
          endif
          inner_v_7h(:,:,:,fvcore_tape_rec+1) = v
          if ( .not. allocated(inner_omega_8h)) then
            allocate( inner_omega_8h(inner_stepon_do) )
          endif
          inner_omega_8h(fvcore_tape_rec+1) = omega
          om = omega
          cp = cpair
          rg = rair
          ae = rearth
          call fvcore_domd( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,ae,
     $iord,jord,kord,umax,omga,peln,consv,convt )
          nstep = nstep+1
          if (force_dycore) then
            if ( .not. allocated(inner_u_9h)) then
              allocate( inner_u_9h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
            endif
            inner_u_9h(:,:,:,fvcore_tape_rec+1) = u
            if ( .not. allocated(inner_v_10h)) then
              allocate( inner_v_10h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
            endif
            inner_v_10h(:,:,:,fvcore_tape_rec+1) = v
            if ( .not. allocated(inner_pt_11h)) then
              allocate( inner_pt_11h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
            endif
            inner_pt_11h(:,:,:,fvcore_tape_rec+1) = pt
            if ( .not. allocated(inner_pe_12h)) then
              allocate( inner_pe_12h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
            endif
            inner_pe_12h(:,:,:,fvcore_tape_rec+1) = pe
            if ( .not. allocated(inner_pkz_13h)) then
              allocate( inner_pkz_13h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
            endif
            inner_pkz_13h(:,:,:,fvcore_tape_rec+1) = pkz
            akap = cappa
            call hswf_do( imr,jnp,nl,jfirst,jlast,u,v,pt,pe,pkz,pdt,akap,grav,rg,dcaf, .true. ,rayf,sinp,cosp,sine,cose,coslon,
     $sinlon,ng_s,ng_d )
          endif
          if (aoa) then
            if ( .not. allocated(inner_pe_14h)) then
              allocate( inner_pe_14h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
            endif
            inner_pe_14h(:,:,:,fvcore_tape_rec+1) = pe
            model_time = nstep*pdt
            call age_of_air( imr,jnp,nl,jfirst,jlast,ng_d,model_time,pe,q(1,jfirst-ng_d,1,nq) )
          endif
        end do
        iinner = ninner
        fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
        if ( .not. allocated(inner_delp_1h)) then
          allocate( inner_delp_1h(1:size(delp,1),1:size(delp,2),1:size(delp,3),inner_stepon_do) )
        endif
        inner_delp_1h(:,:,:,fvcore_tape_rec+1) = delp
        if ( .not. allocated(inner_pe_2h)) then
          allocate( inner_pe_2h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
        endif
        inner_pe_2h(:,:,:,fvcore_tape_rec+1) = pe
        if ( .not. allocated(inner_pk_3h)) then
          allocate( inner_pk_3h(1:size(pk,1),1:size(pk,2),1:size(pk,3),inner_stepon_do) )
        endif
        inner_pk_3h(:,:,:,fvcore_tape_rec+1) = pk
        if ( .not. allocated(inner_pkz_4h)) then
          allocate( inner_pkz_4h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
        endif
        inner_pkz_4h(:,:,:,fvcore_tape_rec+1) = pkz
        if ( .not. allocated(inner_pt_5h)) then
          allocate( inner_pt_5h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
        endif
        inner_pt_5h(:,:,:,fvcore_tape_rec+1) = pt
        if ( .not. allocated(inner_q_6h)) then
          allocate( inner_q_6h(1:size(q,1),1:size(q,2),1:size(q,3),1:size(q,4),inner_stepon_do) )
        endif
        inner_q_6h(:,:,:,:,fvcore_tape_rec+1) = q
        if ( .not. allocated(inner_u_6h)) then
          allocate( inner_u_6h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
        endif
        inner_u_6h(:,:,:,fvcore_tape_rec+1) = u
        if ( .not. allocated(inner_v_7h)) then
          allocate( inner_v_7h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
        endif
        inner_v_7h(:,:,:,fvcore_tape_rec+1) = v
        if ( .not. allocated(inner_omega_8h)) then
          allocate( inner_omega_8h(inner_stepon_do) )
        endif
        inner_omega_8h(fvcore_tape_rec+1) = omega
        om = omega
        cp = cpair
        rg = rair
        ae = rearth
        call fvcore_domd( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,ae,iord,
     $jord,kord,umax,omga,peln,consv,convt )
        if (force_dycore) then
          if ( .not. allocated(inner_u_9h)) then
            allocate( inner_u_9h(1:size(u,1),1:size(u,2),1:size(u,3),inner_stepon_do) )
          endif
          inner_u_9h(:,:,:,fvcore_tape_rec+1) = u
          if ( .not. allocated(inner_v_10h)) then
            allocate( inner_v_10h(1:size(v,1),1:size(v,2),1:size(v,3),inner_stepon_do) )
          endif
          inner_v_10h(:,:,:,fvcore_tape_rec+1) = v
          if ( .not. allocated(inner_pt_11h)) then
            allocate( inner_pt_11h(1:size(pt,1),1:size(pt,2),1:size(pt,3),inner_stepon_do) )
          endif
          inner_pt_11h(:,:,:,fvcore_tape_rec+1) = pt
          if ( .not. allocated(inner_pe_12h)) then
            allocate( inner_pe_12h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
          endif
          inner_pe_12h(:,:,:,fvcore_tape_rec+1) = pe
          if ( .not. allocated(inner_pkz_13h)) then
            allocate( inner_pkz_13h(1:size(pkz,1),1:size(pkz,2),1:size(pkz,3),inner_stepon_do) )
          endif
          inner_pkz_13h(:,:,:,fvcore_tape_rec+1) = pkz
        endif
        if (aoa) then
          if ( .not. allocated(inner_pe_14h)) then
            allocate( inner_pe_14h(1:size(pe,1),1:size(pe,2),1:size(pe,3),inner_stepon_do) )
          endif
          inner_pe_14h(:,:,:,fvcore_tape_rec+1) = pe
        endif

C----------------------------------------------
C ADJOINT COMPUTATIONS
C----------------------------------------------
        do iinner = ninner, 1, -1
          nstep = iinner-1+(iouter-1)*ninner
          fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
          delp = inner_delp_1h(:,:,:,fvcore_tape_rec+1)
          pk = inner_pk_3h(:,:,:,fvcore_tape_rec+1)
          omega = inner_omega_8h(fvcore_tape_rec+1)

!         For diagnostic purposes ...
!         ---------------------------
          call putstate ( job, nymd, nhms, nstep, ptop, ks, ak, bk, Ts, oro,
     &                    diagnlmrc, stat=ierr )
          call putpert  ( job, nymd, nhms, nstep, ptop, ks, ak, bk, Ts, oro,
     &                    diagadmrc, what='adm', stat=ierr )

          om = omega
          cp = cpair
          rg = rair
          ae = rearth
          nstep = nstep+1
          if (aoa) then
            pe = inner_pe_14h(:,:,:,fvcore_tape_rec+1)
            model_time = nstep*pdt
            call age_of_air_ad( imr,nl,jfirst,jlast,ng_d,model_time,pe,pe_ad,q_ad(1,jfirst-ng_d,1,nq) )
          endif
          if (force_dycore) then
            u = inner_u_9h(:,:,:,fvcore_tape_rec+1)
            v = inner_v_10h(:,:,:,fvcore_tape_rec+1)
            pt = inner_pt_11h(:,:,:,fvcore_tape_rec+1)
            pe = inner_pe_12h(:,:,:,fvcore_tape_rec+1)
            pkz = inner_pkz_13h(:,:,:,fvcore_tape_rec+1)
            akap = cappa
            call hswf_do_ad( imr,jnp,nl,jfirst,jlast,u,u_ad,v,v_ad,pt,pt_ad,pe,pe_ad,pkz,pkz_ad,pdt,akap,dcaf, .true. ,rayf,cosp,
     $coslon,sinlon,ng_s,ng_d )
          endif

          call physdrv1_ad( ptrjtmpl, ptrjfrq, job, imr,    jnp,    nl,  nc, jfirst,  jlast, 
     $                      coslon, sinlon,  q,  nymd_trj, nhms_trj, u_ad,   v_ad,   pt_ad, 0, 0 )

          pe = inner_pe_2h(:,:,:,fvcore_tape_rec+1)
          pkz = inner_pkz_4h(:,:,:,fvcore_tape_rec+1)
          pt = inner_pt_5h(:,:,:,fvcore_tape_rec+1)
          q = inner_q_6h(:,:,:,:,fvcore_tape_rec+1)
          u = inner_u_6h(:,:,:,fvcore_tape_rec+1)
          v = inner_v_7h(:,:,:,fvcore_tape_rec+1)
#ifdef TIMING
          call adtiming_off( 'FVCORE' )
#endif
          call fvcore_do_ad( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,ps_ad,pe,pe_ad,delp,delp_ad,u,u_ad,v,v_ad,pt,pt_ad,q,q_ad,
     $pk,pk_ad,pkz,pkz_ad,phis,ptop,om,cp,rg,ae,iord,jord,kord,umax,peln,consv,convt )
#ifdef TIMING
          call adtiming_on( 'FVCORE' )
#endif

!
!
! RME: added for polar filter of initial SV fields
! This should only be added when computing SVs
! The copying to the temperary work field fields_pft is so this
! works with MPI when only a subset of lats is to be passed
          if (iouter.eq.1 .and. iinner.eq.1) then
            allocate (fields_pft(imr,jfirst:jlast,nl,4))
            fields_pft(:,:,:,1)=  pt_ad(:,jfirst:jlast,:)
            fields_pft(:,:,:,2)=delp_ad(:,jfirst:jlast,:)
            fields_pft(:,:,:,3)=   u_ad(:,jfirst:jlast,:)
            fields_pft(:,:,:,4)=   v_ad(:,jfirst:jlast,:)
            call pftSV (imr,jnp,nl,jfirst,jlast,
     $                  cosp(jfirst:jlast),cose(jfirst:jlast),
     $                  fields_pft(:,:,:,1),fields_pft(:,:,:,2),
     $                  fields_pft(:,:,:,3),fields_pft(:,:,:,4) )
              pt_ad(:,jfirst:jlast,:)=fields_pft(:,:,:,1)
            delp_ad(:,jfirst:jlast,:)=fields_pft(:,:,:,2)
               u_ad(:,jfirst:jlast,:)=fields_pft(:,:,:,3)
               v_ad(:,jfirst:jlast,:)=fields_pft(:,:,:,4)
            deallocate (fields_pft)
          endif
!
! end of RME added code
!
!

        end do

C----------------------------------------------
C CLOSE TAPE c_sw_tape1
C----------------------------------------------
        if (allocated(c_sw_tape1_xfx_1h)) then
          deallocate( c_sw_tape1_xfx_1h )
        endif
        if (allocated(c_sw_tape1_yfx_2h)) then
          deallocate( c_sw_tape1_yfx_2h )
        endif
        if (allocated(c_sw_tape1_tm2_3h)) then
          deallocate( c_sw_tape1_tm2_3h )
        endif
        if (allocated(c_sw_tape1_ptk_4h)) then
          deallocate( c_sw_tape1_ptk_4h )
        endif
        if (allocated(c_sw_tape1_a6_5h)) then
          deallocate( c_sw_tape1_a6_5h )
        endif
        if (allocated(c_sw_tape1_v2_6h)) then
          deallocate( c_sw_tape1_v2_6h )
        endif
        if (allocated(c_sw_tape1_tm2_7h)) then
          deallocate( c_sw_tape1_tm2_7h )
        endif
        if (allocated(c_sw_tape1_ymass_8h)) then
          deallocate( c_sw_tape1_ymass_8h )
        endif
        if (allocated(c_sw_tape1_crx_9h)) then
          deallocate( c_sw_tape1_crx_9h )
        endif

C----------------------------------------------
C CLOSE TAPE c_sw_tape2
C----------------------------------------------
        if (allocated(c_sw_tape2_a6_1h)) then
          deallocate( c_sw_tape2_a6_1h )
        endif
        if (allocated(c_sw_tape2_slope_2h)) then
          deallocate( c_sw_tape2_slope_2h )
        endif

C----------------------------------------------
C CLOSE TAPE cd_core_tape
C----------------------------------------------
        if (allocated(cd_core_tape_u_1h)) then
          deallocate( cd_core_tape_u_1h )
        endif
        if (allocated(cd_core_tape_v_2h)) then
          deallocate( cd_core_tape_v_2h )
        endif
        if (allocated(cd_core_tape_delpf_3h)) then
          deallocate( cd_core_tape_delpf_3h )
        endif
        if (allocated(cd_core_tape_delp_4h)) then
          deallocate( cd_core_tape_delp_4h )
        endif
        if (allocated(cd_core_tape_pt_5h)) then
          deallocate( cd_core_tape_pt_5h )
        endif
        if (allocated(cd_core_tape_ptc_6h)) then
          deallocate( cd_core_tape_ptc_6h )
        endif
        if (allocated(cd_core_tape_ptk_7h)) then
          deallocate( cd_core_tape_ptk_7h )
        endif
        if (allocated(cd_core_tape_pkc_8h)) then
          deallocate( cd_core_tape_pkc_8h )
        endif
        if (allocated(cd_core_tape_wz_9h)) then
          deallocate( cd_core_tape_wz_9h )
        endif
        if (allocated(cd_core_tape_pkc_10h)) then
          deallocate( cd_core_tape_pkc_10h )
        endif
        if (allocated(cd_core_tape_wz_11h)) then
          deallocate( cd_core_tape_wz_11h )
        endif
        if (allocated(cd_core_tape_u_12h)) then
          deallocate( cd_core_tape_u_12h )
        endif
        if (allocated(cd_core_tape_v_13h)) then
          deallocate( cd_core_tape_v_13h )
        endif
        if (allocated(cd_core_tape_uc_14h)) then
          deallocate( cd_core_tape_uc_14h )
        endif
        if (allocated(cd_core_tape_vc_15h)) then
          deallocate( cd_core_tape_vc_15h )
        endif
        if (allocated(cd_core_tape_pt_16h)) then
          deallocate( cd_core_tape_pt_16h )
        endif
        if (allocated(cd_core_tape_delp_17h)) then
          deallocate( cd_core_tape_delp_17h )
        endif
        if (allocated(cd_core_tape_pt_18h)) then
          deallocate( cd_core_tape_pt_18h )
        endif
        if (allocated(cd_core_tape_pkc_19h)) then
          deallocate( cd_core_tape_pkc_19h )
        endif
        if (allocated(cd_core_tape_wz_20h)) then
          deallocate( cd_core_tape_wz_20h )
        endif
        if (allocated(cd_core_tape_pkc_21h)) then
          deallocate( cd_core_tape_pkc_21h )
        endif
        if (allocated(cd_core_tape_wz_22h)) then
          deallocate( cd_core_tape_wz_22h )
        endif
        if (allocated(cd_core_tape_wz3_23h)) then
          deallocate( cd_core_tape_wz3_23h )
        endif

C----------------------------------------------
C CLOSE TAPE d_sw_tape1
C----------------------------------------------
        if (allocated(d_sw_tape1_delpf_1h)) then
          deallocate( d_sw_tape1_delpf_1h )
        endif
        if (allocated(d_sw_tape1_xfx_2h)) then
          deallocate( d_sw_tape1_xfx_2h )
        endif
        if (allocated(d_sw_tape1_yfx_3h)) then
          deallocate( d_sw_tape1_yfx_3h )
        endif
        if (allocated(d_sw_tape1_wk1_4h)) then
          deallocate( d_sw_tape1_wk1_4h )
        endif
        if (allocated(d_sw_tape1_delp_5h)) then
          deallocate( d_sw_tape1_delp_5h )
        endif
        if (allocated(d_sw_tape1_ub_6h)) then
          deallocate( d_sw_tape1_ub_6h )
        endif
        if (allocated(d_sw_tape1_uc_7h)) then
          deallocate( d_sw_tape1_uc_7h )
        endif

C----------------------------------------------
C CLOSE TAPE d_sw_tapej
C----------------------------------------------
        if (allocated(d_sw_tapej_a6_1h)) then
          deallocate( d_sw_tapej_a6_1h )
        endif
        if (allocated(d_sw_tapej_slope_2h)) then
          deallocate( d_sw_tapej_slope_2h )
        endif

C----------------------------------------------
C CLOSE TAPE dynpkg_1
C----------------------------------------------
        if (allocated(dynpkg_1_te0_1h)) then
          deallocate( dynpkg_1_te0_1h )
        endif
        if (allocated(dynpkg_1_pk_2h)) then
          deallocate( dynpkg_1_pk_2h )
        endif
        if (allocated(dynpkg_1_q_3h)) then
          deallocate( dynpkg_1_q_3h )
        endif
        if (allocated(dynpkg_1_pe_4h)) then
          deallocate( dynpkg_1_pe_4h )
        endif
        if (allocated(dynpkg_1_ps_5h)) then
          deallocate( dynpkg_1_ps_5h )
        endif
        if (allocated(dynpkg_1_pt_6h)) then
          deallocate( dynpkg_1_pt_6h )
        endif

C----------------------------------------------
C CLOSE TAPE dynpkg_n2
C----------------------------------------------
        if (allocated(dynpkg_n2_dp0_1h)) then
          deallocate( dynpkg_n2_dp0_1h )
        endif
        if (allocated(dynpkg_n2_q_2h)) then
          deallocate( dynpkg_n2_q_2h )
        endif
        if (allocated(dynpkg_n2_cx_3h)) then
          deallocate( dynpkg_n2_cx_3h )
        endif
        if (allocated(dynpkg_n2_cy_4h)) then
          deallocate( dynpkg_n2_cy_4h )
        endif
        if (allocated(dynpkg_n2_mfx_5h)) then
          deallocate( dynpkg_n2_mfx_5h )
        endif
        if (allocated(dynpkg_n2_mfy_6h)) then
          deallocate( dynpkg_n2_mfy_6h )
        endif

C----------------------------------------------
C CLOSE TAPE inner
C----------------------------------------------
        if (allocated(inner_delp_1h)) then
          deallocate( inner_delp_1h )
        endif
        if (allocated(inner_pe_2h)) then
          deallocate( inner_pe_2h )
        endif
        if (allocated(inner_pk_3h)) then
          deallocate( inner_pk_3h )
        endif
        if (allocated(inner_pkz_4h)) then
          deallocate( inner_pkz_4h )
        endif
        if (allocated(inner_pt_5h)) then
          deallocate( inner_pt_5h )
        endif
        if (allocated(inner_q_6h)) then
          deallocate( inner_q_6h )
        endif
        if (allocated(inner_u_6h)) then
          deallocate( inner_u_6h )
        endif
        if (allocated(inner_v_7h)) then
          deallocate( inner_v_7h )
        endif
        if (allocated(inner_omega_8h)) then
          deallocate( inner_omega_8h )
        endif
        if (allocated(inner_u_9h)) then
          deallocate( inner_u_9h )
        endif
        if (allocated(inner_v_10h)) then
          deallocate( inner_v_10h )
        endif
        if (allocated(inner_pt_11h)) then
          deallocate( inner_pt_11h )
        endif
        if (allocated(inner_pe_12h)) then
          deallocate( inner_pe_12h )
        endif
        if (allocated(inner_pkz_13h)) then
          deallocate( inner_pkz_13h )
        endif
        if (allocated(inner_pe_14h)) then
          deallocate( inner_pe_14h )
        endif

C----------------------------------------------
C CLOSE TAPE te_map_tape
C----------------------------------------------
        if (allocated(te_map_tape_pk_1h)) then
          deallocate( te_map_tape_pk_1h )
        endif
        if (allocated(te_map_tape_pkz_2h)) then
          deallocate( te_map_tape_pkz_2h )
        endif
        if (allocated(te_map_tape_u_6h)) then
          deallocate( te_map_tape_u_6h )
        endif
        if (allocated(te_map_tape_v_7h)) then
          deallocate( te_map_tape_v_7h )
        endif
        if (allocated(te_map_tape_dz_8h)) then
          deallocate( te_map_tape_dz_8h )
        endif
        if (allocated(te_map_tape_te_9h)) then
          deallocate( te_map_tape_te_9h )
        endif
        if (allocated(te_map_tape_v_10h)) then
          deallocate( te_map_tape_v_10h )
        endif
        if (allocated(te_map_tape_te_11h)) then
          deallocate( te_map_tape_te_11h )
        endif
        if (allocated(te_map_tape_peln_12h)) then
          deallocate( te_map_tape_peln_12h )
        endif
        if (allocated(te_map_tape_pkz_13h)) then
          deallocate( te_map_tape_pkz_13h )
        endif
        if (allocated(te_map_tape_pe_14h)) then
          deallocate( te_map_tape_pe_14h )
        endif
        if (allocated(te_map_tape_delp_15h)) then
          deallocate( te_map_tape_delp_15h )
        endif
        if (allocated(te_map_tape_tsum_16h)) then
          deallocate( te_map_tape_tsum_16h )
        endif
        if (allocated(te_map_tape_u_17h)) then
          deallocate( te_map_tape_u_17h )
        endif
        if (allocated(te_map_tape_dtmp_18h)) then
          deallocate( te_map_tape_dtmp_18h )
        endif
        if (allocated(te_map_tape_te_19h)) then
          deallocate( te_map_tape_te_19h )
        endif

C----------------------------------------------
C CLOSE TAPE tpcc1_tape
C----------------------------------------------
        if (allocated(tpcc1_tape_a6_1h)) then
          deallocate( tpcc1_tape_a6_1h )
        endif
        if (allocated(tpcc1_tape_dm_2h)) then
          deallocate( tpcc1_tape_dm_2h )
        endif

C----------------------------------------------
C CLOSE TAPE tpcc2_tape
C----------------------------------------------
        if (allocated(tpcc2_tape_a6_1h)) then
          deallocate( tpcc2_tape_a6_1h )
        endif
        if (allocated(tpcc2_tape_dm_2h)) then
          deallocate( tpcc2_tape_dm_2h )
        endif

      end do

C----------------------------------------------
C CLOSE TAPE outer_time
C----------------------------------------------
      if (allocated(outer_time_nymd_1h)) then
        deallocate( outer_time_nymd_1h )
      endif
      if (allocated(outer_time_nhms_2h)) then
        deallocate( outer_time_nhms_2h )
      endif
      if (allocated(outer_time_nymd_trj_3h)) then
        deallocate( outer_time_nymd_trj_3h )
      endif
      if (allocated(outer_time_nhms_trj_4h)) then
        deallocate( outer_time_nhms_trj_4h )
      endif


      end subroutine stepon_do_ad


      subroutine stepon_domd
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use m_iostate, only : getstate

      use fvcore, only : ns,fvcore_do
      use fvcore, only : fvcore_tape_rec
      use fvcore, only : dynpkg_n2,dynpkg_nsplit
      use fvcore, only : ng_c
      use hswf, only : hswf_do
      use mapz_module, only: te_map

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

C==============================================
C declare local variables
C==============================================
      real(kind=r8) :: ae
      real(kind=r8) :: akap
      real(kind=r8) :: cp
      character*255 :: fnametrj
      real(kind=r8) :: grav
      integer :: iinner
      integer :: iouter
      integer :: nhms_trj
      integer :: nymd_trj
      integer :: rmaptfrq
      integer :: nx
      integer :: ierr
      real(kind=r8) :: om
      real(kind=r8) :: te0
      real(kind=r8) :: rg
      logical       :: doremap

C**********************************************
C executable statements of routine
C**********************************************

      do iouter = 1, nouter
        nymd_trj = nymd
        nhms_trj = nhms
        call tick( nymd_trj,nhms_trj,pdt )

        call getstate( nymd_trj, nhms_trj, prog, doremap )

        if (doremap) then
           nx = 4
           te0 = 1.0
           call te_map(.false., .false., ps, omga, pe, delp, pkz, pk, mpdt,
     &                  imr, jnp, nl, nx, jfirst, jlast, nq,  u,  v,
     &                  pt, q, phis,  cpair, cappa, kord, peln, te0,
     &                  ng_d, ng_s, 0 )
        endif

        do iinner = 1, ninner
          nstep = iinner-1+(iouter-1)*ninner
          fvcore_tape_rec = iinner-1+stepon_tape_rec*mstep
          om = omega
          cp = cpair
          rg = rair
          ae = rearth
          call fvcore_do( imr,jnp,nl,nc,jfirst,jlast,ng_d,ng_s,nq,ps,pe,delp,u,v,pt,q,pk,pkz,phis,nsplit,pdt,ptop,om,cp,rg,ae,iord,
     $jord,kord,umax,omga,peln,consv,convt )
          nstep = nstep+1
          call tick( nymd,nhms,pdt )
          mcsec = nsecf(nhms)
          if (force_dycore) then
            rg = rair
            akap = cappa
            call hswf_do( imr,jnp,nl,jfirst,jlast,u,v,pt,pe,pkz,pdt,akap,grav,rg,dcaf, .true. ,rayf,sinp,cosp,sine,cose,coslon,
     $sinlon,ng_s,ng_d )
          endif
          if (aoa) then
            model_time = nstep*pdt
            call age_of_air( imr,jnp,nl,jfirst,jlast,ng_d,model_time,pe,q(1,jfirst-ng_d,1,nq) )
          endif
        end do
      end do
      if (aoa) then
        model_time = nstep*pdt
      endif
      end subroutine stepon_domd


      subroutine stepon_set_ad
C******************************************************************
C******************************************************************
C** This routine was generated by Automatic differentiation.     **
C** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
C******************************************************************
C******************************************************************
C==============================================
C referencing used modules
C==============================================
      use prognostics_ad, only : delp_ad,ps_ad,pt_ad,q_ad,u_ad,v_ad

C==============================================
C all entries are defined explicitly
C==============================================
      implicit none

C----------------------------------------------
C RESET MODULE ADJOINT VARIABLES
C----------------------------------------------
      delp_ad(:,:,:) = 0.
      ps_ad(:,:) = 0.
      pt_ad(:,:,:) = 0.
      q_ad(:,:,:,:) = 0.
      u_ad(:,:,:) = 0.
      v_ad(:,:,:) = 0.

      end subroutine stepon_set_ad


      end module     stepon_ad


#endif /* SPMD */
