#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     te_map_ad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: te_map_tape_delp_15h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_dtmp_18h(:)
real(kind=8), allocatable :: te_map_tape_dz_8h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pe_14h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_peln_12h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pk_1h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pkz_13h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pkz_2h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_11h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_19h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_9h(:,:,:,:)
integer :: te_map_tape_te_map
real(kind=8), allocatable :: te_map_tape_tsum_16h(:)
real(kind=8), allocatable :: te_map_tape_u_17h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_u_6h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_v_10h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_v_7h(:,:,:,:)

end module     te_map_ad_store


module     mapz_module_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mapz_module

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=r8), allocatable :: pesouth_ad(:,:)

contains
subroutine kmppm_ad( dm, dm_ad, a4, a4_ad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a4(4,im)
real(kind=r8) :: a4_ad(4,im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ad(im)
integer :: lmt

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a4h(4,im)
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ad
real(kind=r8) :: da1
real(kind=r8) :: da1_ad
real(kind=r8) :: da2
real(kind=r8) :: da2_ad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ad
integer :: i
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
a4h(:,:) = a4(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_ad = 0.d0
da1_ad = 0.d0
da2_ad = 0.d0
fmin_ad = 0.d0
qmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .ne. 3) then
  if (lmt .eq. 0) then
    do i = 1, im
      a6da_ad = 0.d0
      da1_ad = 0.d0
      da2_ad = 0.d0
      if (dm(i) .eq. 0.) then
        a4_ad(4,i) = 0.d0
        a4_ad(1,i) = a4_ad(1,i)+a4_ad(3,i)
        a4_ad(3,i) = 0.d0
        a4_ad(1,i) = a4_ad(1,i)+a4_ad(2,i)
        a4_ad(2,i) = 0.d0
      else
        da1 = a4(3,i)-a4(2,i)
        da2 = da1**2
        a6da = a4(4,i)*da1
        if (a6da .lt. (-da2)) then
          a4_ad(4,i) = a4_ad(4,i)-a4_ad(3,i)
          a4_ad(2,i) = a4_ad(2,i)+a4_ad(3,i)
          a4_ad(3,i) = 0.d0
          a4_ad(2,i) = a4_ad(2,i)+3*a4_ad(4,i)
          a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
          a4_ad(4,i) = 0.d0
        else if (a6da .gt. da2) then
          a4_ad(4,i) = a4_ad(4,i)-a4_ad(2,i)
          a4_ad(3,i) = a4_ad(3,i)+a4_ad(2,i)
          a4_ad(2,i) = 0.d0
          a4_ad(3,i) = a4_ad(3,i)+3*a4_ad(4,i)
          a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
          a4_ad(4,i) = 0.d0
        endif
        a4_ad(4,i) = a4_ad(4,i)+a6da_ad*da1
        da1_ad = da1_ad+a6da_ad*a4(4,i)
        a6da_ad = 0.d0
        da1_ad = da1_ad+2*da2_ad*da1
        da2_ad = 0.d0
        a4_ad(3,i) = a4_ad(3,i)+da1_ad
        a4_ad(2,i) = a4_ad(2,i)-da1_ad
        da1_ad = 0.d0
      endif
    end do
  else if (lmt .eq. 1) then
    do i = 1, im
      qmp_ad = 0.d0
      qmp = 2.*dm(i)
      a4(2,i) = a4(1,i)-sign(min(abs(qmp),abs(a4(2,i)-a4(1,i))),qmp)
      a4_ad(3,i) = a4_ad(3,i)-3*a4_ad(4,i)
      a4_ad(2,i) = a4_ad(2,i)-3*a4_ad(4,i)
      a4_ad(1,i) = a4_ad(1,i)+6*a4_ad(4,i)
      a4_ad(4,i) = 0.d0
      qmp_ad = qmp_ad+a4_ad(3,i)*(0.5+sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4_ad(1,i) = a4_ad(1,i)+a4_ad(3,i)*(1-(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,&
&i))*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i)))))
      a4_ad(3,i) = a4_ad(3,i)*(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,i))*sign(1.d0,&
&min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4(:,:) = a4h(:,:)
      qmp_ad = qmp_ad-a4_ad(2,i)*(0.5+sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(2,i)-a4(1,i))))
      a4_ad(1,i) = a4_ad(1,i)+a4_ad(2,i)*(1+(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,&
&i))*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      a4_ad(2,i) = -(a4_ad(2,i)*(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      dm_ad(i) = dm_ad(i)+2*qmp_ad
      qmp_ad = 0.d0
    end do
  else if (lmt .eq. 2) then
    do i = 1, im
      fmin_ad = 0.d0
      if (abs(a4(3,i)-a4(2,i)) .lt. (-a4(4,i))) then
        fmin = a4(1,i)+0.25*(a4(3,i)-a4(2,i))**2/a4(4,i)+a4(4,i)*r12
        if (fmin .lt. 0.) then
          if (a4(1,i) .lt. a4(3,i) .and. a4(1,i) .lt. a4(2,i)) then
            a4_ad(4,i) = 0.d0
            a4_ad(1,i) = a4_ad(1,i)+a4_ad(2,i)
            a4_ad(2,i) = 0.d0
            a4_ad(1,i) = a4_ad(1,i)+a4_ad(3,i)
            a4_ad(3,i) = 0.d0
          else if (a4(3,i) .gt. a4(2,i)) then
            a4_ad(4,i) = a4_ad(4,i)-a4_ad(3,i)
            a4_ad(2,i) = a4_ad(2,i)+a4_ad(3,i)
            a4_ad(3,i) = 0.d0
            a4_ad(2,i) = a4_ad(2,i)+3*a4_ad(4,i)
            a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
            a4_ad(4,i) = 0.d0
          else
            a4_ad(4,i) = a4_ad(4,i)-a4_ad(2,i)
            a4_ad(3,i) = a4_ad(3,i)+a4_ad(2,i)
            a4_ad(2,i) = 0.d0
            a4_ad(3,i) = a4_ad(3,i)+3*a4_ad(4,i)
            a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
            a4_ad(4,i) = 0.d0
          endif
        endif
        a4_ad(4,i) = a4_ad(4,i)+fmin_ad*((-(0.25*(a4(3,i)-a4(2,i))**2/(a4(4,i)*a4(4,i))))+r12)
        a4_ad(3,i) = a4_ad(3,i)+fmin_ad*(0.5*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_ad(2,i) = a4_ad(2,i)+fmin_ad*((-0.5)*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_ad(1,i) = a4_ad(1,i)+fmin_ad
        fmin_ad = 0.d0
      endif
    end do
  endif
endif

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine kmppm_ad


subroutine map1_ppm_ad( km, pe1, pe1_ad, q1, q1_ad, kn, pe2, pe2_ad, q2_ad, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1_ad(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: pe2_ad(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km)
real(kind=r8) :: q1_ad(im,jfirst-ng_s:jlast+ng_n,km)
real(kind=r8) :: q2_ad(im,jfirst-ng_s:jlast+ng_n,kn)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: delp_ae
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: dp1_ad(i1:i2,km)
real(kind=r8) :: esl
real(kind=r8) :: esl_ad
integer :: i
integer :: ikind
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pl_ad
real(kind=r8) :: pr
real(kind=r8) :: pr_ad
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_ad(4,i1:i2,km)
real(kind=r8) :: qsum
real(kind=r8) :: qsum_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
delp_ae = 0.d0
dp1_ad(:,:) = 0.d0
esl_ad = 0.d0
pl_ad = 0.d0
pr_ad = 0.d0
q4_ad(:,:,:) = 0.d0
qsum_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
    q4(1,i,k) = q1(i,j,k)
  end do
end do
call ppm2m( q4,dp1,km,i1,i2,iv,kord )
do i = i1, i2
  k0 = 1
  do k = 1, kn
    ikind = 0
    do l = k0, km
      if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
        if (pe2(i,k+1) .le. pe1(i,l+1)) then
          ikind = 1
          exit
        else
          ikind = 2
          exit
        endif
      endif
    end do
    if (ikind .eq. 0) then
    else if (ikind .eq. 1) then
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
      pl_ad = pl_ad+q2_ad(i,j,k)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(pr+2*pl))
      pr_ad = pr_ad+q2_ad(i,j,k)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(2*pr+pl))
      q4_ad(4,i,l) = q4_ad(4,i,l)+q2_ad(i,j,k)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))
      q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*q2_ad(i,j,k)*(pr+pl)
      q4_ad(2,i,l) = q4_ad(2,i,l)+q2_ad(i,j,k)*(1+(-0.5)*(pr+pl))
      q2_ad(i,j,k) = 0.d0
      dp1_ad(i,l) = dp1_ad(i,l)-pr_ad*((pe2(i,k+1)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
      pe1_ad(i,l) = pe1_ad(i,l)-pr_ad/dp1(i,l)
      pe2_ad(i,k+1) = pe2_ad(i,k+1)+pr_ad/dp1(i,l)
      pr_ad = 0.d0
      dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
      pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
      pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
      pl_ad = 0.d0
    else
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      do ll = l+1, km
        if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
        else
          lf = ll
          exit
        endif
      end do
      if (lf .eq. 0) then
        do ll = l+1, km
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
      else
        do ll = l+1, lf-1
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
        ll = lf
        delp = pe2(i,k+1)-pe1(i,ll)
        esl = delp/dp1(i,ll)
        qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
      endif
      pe2_ad(i,k+1) = pe2_ad(i,k+1)-q2_ad(i,j,k)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
      pe2_ad(i,k) = pe2_ad(i,k)+q2_ad(i,j,k)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
      qsum_ad = qsum_ad+q2_ad(i,j,k)/(pe2(i,k+1)-pe2(i,k))
      q2_ad(i,j,k) = 0.d0
      if (lf .eq. 0) then
        do ll = l+1, km
          dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
          q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
        end do
      else
        delp_ae = delp_ae+qsum_ad*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        esl_ad = esl_ad+qsum_ad*delp*((-(0.5*esl*q4(4,i,ll)*r23))+0.5*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        q4_ad(4,i,ll) = q4_ad(4,i,ll)+0.5*qsum_ad*delp*esl*(1.-r23*esl)
        q4_ad(3,i,ll) = q4_ad(3,i,ll)+0.5*qsum_ad*delp*esl
        q4_ad(2,i,ll) = q4_ad(2,i,ll)+qsum_ad*delp*(1+(-0.5)*esl)
        delp_ae = delp_ae+esl_ad/dp1(i,ll)
        dp1_ad(i,ll) = dp1_ad(i,ll)-esl_ad*(delp/(dp1(i,ll)*dp1(i,ll)))
        esl_ad = 0.d0
        pe1_ad(i,ll) = pe1_ad(i,ll)-delp_ae
        pe2_ad(i,k+1) = pe2_ad(i,k+1)+delp_ae
        delp_ae = 0.d0
        do ll = l+1, lf-1
          dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
          q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
        end do
      endif
      pe1_ad(i,l+1) = pe1_ad(i,l+1)+qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      pe2_ad(i,k) = pe2_ad(i,k)-qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      pl_ad = pl_ad+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(1+2*pl))
      q4_ad(4,i,l) = q4_ad(4,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))
      q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1.+pl)
      q4_ad(2,i,l) = q4_ad(2,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
      qsum_ad = 0.d0
      dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
      pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
      pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
      pl_ad = 0.d0
    endif
  end do
end do
do k = 1, km
  do i = i1, i2
    q4(1,i,k) = q1(i,j,k)
  end do
end do
call ppm2m_ad( q4,q4_ad,dp1,dp1_ad,km,i1,i2,iv,kord )
do k = 1, km
  do i = i1, i2
    q1_ad(i,j,k) = q1_ad(i,j,k)+q4_ad(1,i,k)
    q4_ad(1,i,k) = 0.d0
    pe1_ad(i,k+1) = pe1_ad(i,k+1)+dp1_ad(i,k)
    pe1_ad(i,k) = pe1_ad(i,k)-dp1_ad(i,k)
    dp1_ad(i,k) = 0.d0
  end do
end do

end subroutine map1_ppm_ad


subroutine mapn_ppm_ad( km, pe1, pe1_ad, q1, q1_ad, nq, kn, pe2, pe2_ad, q2_ad, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
integer :: nq
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1_ad(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: pe2_ad(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q1_ad(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q2_ad(im,jfirst-ng_s:jlast+ng_n,kn,nq)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: delp_ae
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: dp1_ad(i1:i2,km)
real(kind=r8) :: esl
real(kind=r8) :: esl_ad
integer :: i
integer :: ikind
integer :: iq
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pl_ad
real(kind=r8) :: pr
real(kind=r8) :: pr_ad
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_ad(4,i1:i2,km)
real(kind=r8) :: qsum
real(kind=r8) :: qsum_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
delp_ae = 0.d0
dp1_ad(:,:) = 0.d0
esl_ad = 0.d0
pl_ad = 0.d0
pr_ad = 0.d0
q4_ad(:,:,:) = 0.d0
qsum_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
  end do
end do
do iq = nq, 1, -1
  do k = 1, km
    do i = i1, i2
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  call ppm2m( q4,dp1,km,i1,i2,iv,kord )
  do i = i1, i2
    k0 = 1
    do k = 1, kn
      ikind = 0
      do l = k0, km
        if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
          if (pe2(i,k+1) .le. pe1(i,l+1)) then
            ikind = 1
            exit
          else
            ikind = 2
            exit
          endif
        endif
      end do
      if (ikind .eq. 0) then
      else if (ikind .eq. 1) then
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
        pl_ad = pl_ad+q2_ad(i,j,k,iq)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(pr+2*pl))
        pr_ad = pr_ad+q2_ad(i,j,k,iq)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(2*pr+pl))
        q4_ad(4,i,l) = q4_ad(4,i,l)+q2_ad(i,j,k,iq)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))
        q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*q2_ad(i,j,k,iq)*(pr+pl)
        q4_ad(2,i,l) = q4_ad(2,i,l)+q2_ad(i,j,k,iq)*(1+(-0.5)*(pr+pl))
        q2_ad(i,j,k,iq) = 0.d0
        dp1_ad(i,l) = dp1_ad(i,l)-pr_ad*((pe2(i,k+1)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
        pe1_ad(i,l) = pe1_ad(i,l)-pr_ad/dp1(i,l)
        pe2_ad(i,k+1) = pe2_ad(i,k+1)+pr_ad/dp1(i,l)
        pr_ad = 0.d0
        dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
        pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
        pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
        pl_ad = 0.d0
      else
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        do ll = l+1, km
          if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
          else
            lf = ll
            exit
          endif
        end do
        if (lf .eq. 0) then
          do ll = l+1, km
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
        else
          do ll = l+1, lf-1
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
          ll = lf
          delp = pe2(i,k+1)-pe1(i,ll)
          esl = delp/dp1(i,ll)
          qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        endif
        pe2_ad(i,k+1) = pe2_ad(i,k+1)-q2_ad(i,j,k,iq)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
        pe2_ad(i,k) = pe2_ad(i,k)+q2_ad(i,j,k,iq)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
        qsum_ad = qsum_ad+q2_ad(i,j,k,iq)/(pe2(i,k+1)-pe2(i,k))
        q2_ad(i,j,k,iq) = 0.d0
        if (lf .eq. 0) then
          do ll = l+1, km
            dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
            q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
          end do
        else
          delp_ae = delp_ae+qsum_ad*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
          esl_ad = esl_ad+qsum_ad*delp*((-(0.5*esl*q4(4,i,ll)*r23))+0.5*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
          q4_ad(4,i,ll) = q4_ad(4,i,ll)+0.5*qsum_ad*delp*esl*(1.-r23*esl)
          q4_ad(3,i,ll) = q4_ad(3,i,ll)+0.5*qsum_ad*delp*esl
          q4_ad(2,i,ll) = q4_ad(2,i,ll)+qsum_ad*delp*(1+(-0.5)*esl)
          delp_ae = delp_ae+esl_ad/dp1(i,ll)
          dp1_ad(i,ll) = dp1_ad(i,ll)-esl_ad*(delp/(dp1(i,ll)*dp1(i,ll)))
          esl_ad = 0.d0
          pe1_ad(i,ll) = pe1_ad(i,ll)-delp_ae
          pe2_ad(i,k+1) = pe2_ad(i,k+1)+delp_ae
          delp_ae = 0.d0
          do ll = l+1, lf-1
            dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
            q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
          end do
        endif
        pe1_ad(i,l+1) = pe1_ad(i,l+1)+qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        pe2_ad(i,k) = pe2_ad(i,k)-qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        pl_ad = pl_ad+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(1+2*pl))
        q4_ad(4,i,l) = q4_ad(4,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))
        q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1.+pl)
        q4_ad(2,i,l) = q4_ad(2,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
        qsum_ad = 0.d0
        dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
        pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
        pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
        pl_ad = 0.d0
      endif
    end do
  end do
  do k = 1, km
    do i = i1, i2
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  call ppm2m_ad( q4,q4_ad,dp1,dp1_ad,km,i1,i2,iv,kord )
  do k = 1, km
    do i = i1, i2
      q1_ad(i,j,k,iq) = q1_ad(i,j,k,iq)+q4_ad(1,i,k)
      q4_ad(1,i,k) = 0.d0
    end do
  end do
end do
do k = 1, km
  do i = i1, i2
    pe1_ad(i,k+1) = pe1_ad(i,k+1)+dp1_ad(i,k)
    pe1_ad(i,k) = pe1_ad(i,k)-dp1_ad(i,k)
    dp1_ad(i,k) = 0.d0
  end do
end do

end subroutine mapn_ppm_ad


subroutine mapz_module_final_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!----------------------------------------------
! DEALLOCATE MODULE VARIABLES
!----------------------------------------------
if(allocated(pesouth_ad)) deallocate( pesouth_ad )

end subroutine mapz_module_final_ad


subroutine mapz_module_initial_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!----------------------------------------------
! ALLOCATE AND RESET MODULE VARIABLES
!----------------------------------------------
if(.not.allocated(pesouth_ad))then
  allocate( pesouth_ad(lbound(pesouth,1):ubound(pesouth,1),lbound(pesouth,2):ubound(pesouth,2)) )
  pesouth_ad(:,:) = 0.
endif

end subroutine mapz_module_initial_ad


subroutine ppm2m_ad( a4, a4_ad, delp, delp_ae, km, i1, i2, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ad(4,i1:i2,km)
real(kind=r8) :: delp(i1:i2,km)
real(kind=r8) :: delp_ae(i1:i2,km)
integer :: iv
integer :: kord

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a1
real(kind=r8) :: a1_ad
real(kind=r8) :: a2
real(kind=r8) :: a2_ad
real(kind=r8) :: c1
real(kind=r8) :: c1_ad
real(kind=r8) :: c2
real(kind=r8) :: c2_ad
real(kind=r8) :: c3
real(kind=r8) :: c3_ad
real(kind=r8) :: cmax
real(kind=r8) :: cmax_ad
real(kind=r8) :: cmin
real(kind=r8) :: cmin_ad
real(kind=r8) :: d1
real(kind=r8) :: d1_ad
real(kind=r8) :: d2
real(kind=r8) :: d2_ad
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: d4_ad(i1:i2,km)
real(kind=r8) :: dc(i1:i2,km)
real(kind=r8) :: dc_ad(i1:i2,km)
double precision :: dci
double precision :: dci_ae
double precision :: dcj_ad
real(kind=r8) :: delq(i1:i2,km)
real(kind=r8) :: delq_ad(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ad(i1:i2,km)
real(kind=r8) :: dq
real(kind=r8) :: dq_ad
real(kind=r8) :: fac
real(kind=r8) :: h2(i1:i2,km)
real(kind=r8) :: h2_ad(i1:i2,km)
integer :: i
integer :: it
integer :: k
integer :: km1
real(kind=r8) :: lac
real(kind=r8) :: lac_ad
integer :: lmt
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ad
real(kind=8) :: ppm2m_a4_10h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_11h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_12h(4,1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_13h(4,1+i2-i1,(-4)+km,1)
real(kind=8), allocatable :: ppm2m_a4_14h(:,:,:,:)
real(kind=8) :: ppm2m_a4_1h(1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_2h(2,1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_3h(1+i2-i1,3,1)
real(kind=8) :: ppm2m_a4_4h(1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_5h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_6h(1+i2-i1,2,1)
real(kind=8), allocatable :: ppm2m_a4_7h(:,:,:)
real(kind=8), allocatable :: ppm2m_a4_8h(:,:,:)
real(kind=8) :: ppm2m_a4_9h(1+i2-i1,1)
integer :: ppm2m_ppm2m
real(kind=r8) :: qm
real(kind=r8) :: qm_ad
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxj
double precision :: qmaxj_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminj
double precision :: qminj_ad
double precision :: qmink_ad
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a1_ad = 0.d0
a2_ad = 0.d0
c1_ad = 0.d0
c2_ad = 0.d0
c3_ad = 0.d0
cmax_ad = 0.d0
cmin_ad = 0.d0
d1_ad = 0.d0
d2_ad = 0.d0
d4_ad(:,:) = 0.d0
dc_ad(:,:) = 0.d0
delq_ad(:,:) = 0.d0
df2_ad(:,:) = 0.d0
dq_ad = 0.d0
h2_ad(:,:) = 0.d0
lac_ad = 0.d0
pmp_ad = 0.d0
qm_ad = 0.d0
qmax_ad = 0.d0
qmin_ad = 0.d0
qmp_ad = 0.d0
tmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
km1 = km-1
it = i2-i1+1
!----------------------------------------------
! OPEN TAPE ppm2m
!----------------------------------------------
ppm2m_ppm2m = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    delq(i,k-1) = a4(1,i,k)-a4(1,i,k-1)
    d4(i,k) = delp(i,k-1)+delp(i,k)
  end do
end do
ppm2m_a4_1h(:,:,1) = a4(1,i1:i2,:)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
    df2(i,k) = tmp
  end do
end do
do k = 3, km1
  do i = i1, i2
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a4(2,i,k) = a4(1,i,k-1)+c1+2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-delp(i,k-1)*a1*dc(i,k))
  end do
end do
ppm2m_a4_2h(:,:,:,1) = a4(1:2,i1:i2,:)
call steepz( i1,i2,km,a4,df2,dc,delq,delp,d4 )
ppm2m_a4_3h(:,:,1) = a4(2,i1:i2,1:3)
ppm2m_a4_4h(:,:,1) = a4(1,i1:i2,1:2)
do i = i1, i2
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  dc(i,1) = a4(1,i,1)-a4(2,i,1)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  a4(2,i,2) = min(cmax,a4(2,i,2))
end do
ppm2m_a4_5h(:,1) = a4(1,i1:i2,1)
ppm2m_a4_6h(:,:,1) = a4(2,i1:i2,1:2)
if (iv .eq. 0) then
  do i = i1, i2
    a4(2,i,1) = a4(1,i,1)
    a4(3,i,1) = a4(1,i,1)
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4(2,i,1) = a4(1,i,1)
      a4(3,i,1) = a4(1,i,1)
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4(2,i,1) = 0.
      else
        a4(2,i,1) = sign(min(abs(a4(1,i,1)),abs(a4(2,i,1))),a4(1,i,1))
      endif
    end do
  endif
endif
if ( .not. allocated(ppm2m_a4_7h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_7h)) then
    allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_7h(:,:,1) = a4(1,i1:i2,km1:km)
if ( .not. allocated(ppm2m_a4_8h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_8h)) then
    allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_8h(:,:,1) = a4(2,i1:i2,km1:km)
ppm2m_a4_9h(:,1) = a4(3,i1:i2,km)
do i = i1, i2
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  dc(i,km) = a4(3,i,km)-a4(1,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  a4(2,i,km) = min(cmax,a4(2,i,km))
end do
ppm2m_a4_10h(:,1) = a4(1,i1:i2,km)
ppm2m_a4_11h(:,1) = a4(3,i1:i2,km)
if (iv .eq. 0) then
  do i = i1, i2
    a4(3,i,km) = max(0._8,a4(3,i,km))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4(3,i,km) = 0.
    else
      a4(3,i,km) = sign(min(abs(a4(1,i,km)),abs(a4(3,i,km))),a4(1,i,km))
    endif
  end do
endif
do k = 1, km1
  do i = i1, i2
    a4(3,i,k) = a4(2,i,k+1)
  end do
end do
ppm2m_a4_12h(:,:,:,1) = a4(:,i1:i2,1:2)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm( dc(i1,k),a4(1,i1,k),it,0 )
end do
ppm2m_a4_13h(:,:,:,1) = a4(:,i1:i2,3:km-2)
if (kord .ge. 7) then
  do k = 2, km1
    do i = i1, i2
      h2(i,k) = dc(i,k+1)-dc(i,k-1)
    end do
  end do
  if (kord .eq. 7) then
    fac = 1.5
  else
    fac = 0.125
  endif
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm( dc(i1,k),a4(1,i1,k),it,2 )
    endif
  end do
else
  lmt = kord-3
  lmt = max(0,lmt)
  if (iv .eq. 0) then
    lmt = min(2,lmt)
  endif
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm( dc(i1,k),a4(1,i1,k),it,lmt )
  end do
endif
if ( .not. allocated(ppm2m_a4_14h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_14h)) then
    allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_14h(:,:,:,1) = a4(:,i1:i2,km1:km)

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
a4(:,i1:i2,km1:km) = ppm2m_a4_14h(:,:,:,1)
do k = km1, km
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,0 )
  do i = i1, i2
    a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
    a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
    a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
    a4_ad(4,i,k) = 0.d0
  end do
end do
a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
if (kord .ge. 7) then
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,2 )
    endif
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      lac_ad = 0.d0
      pmp_ad = 0.d0
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      qmp_ad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
      a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
      a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
      a4_ad(4,i,k) = 0.d0
      qmax_ad = qmax_ad+a4_ad(2,i,k)*(0.5-sign(0.5d0,qmax-max(a4(2,i,k),qmin)))
      qmin_ad = qmin_ad+a4_ad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5-sign(0.5d0,a4(2,i,k)-qmin))
      a4_ad(2,i,k) = a4_ad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5+sign(0.5d0,a4(2,i,k)-qmin))
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmax_ad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_ad = qmp_ad+qmax_ad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmin_ad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_ad = qmp_ad+qmin_ad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+lac_ad
      dc_ad(i,k) = dc_ad(i,k)-lac_ad
      h2_ad(i,k+1) = h2_ad(i,k+1)+lac_ad*fac
      lac_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmp_ad
      pmp_ad = pmp_ad-qmp_ad
      qmp_ad = 0.d0
      dc_ad(i,k) = dc_ad(i,k)+2*pmp_ad
      pmp_ad = 0.d0
    end do
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      lac_ad = 0.d0
      pmp_ad = 0.d0
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      qmp_ad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      qmax_ad = qmax_ad+a4_ad(3,i,k)*(0.5-sign(0.5d0,qmax-max(a4(3,i,k),qmin)))
      qmin_ad = qmin_ad+a4_ad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5-sign(0.5d0,a4(3,i,k)-qmin))
      a4_ad(3,i,k) = a4_ad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5+sign(0.5d0,a4(3,i,k)-qmin))
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmax_ad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_ad = qmp_ad+qmax_ad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmin_ad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_ad = qmp_ad+qmin_ad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+lac_ad
      dc_ad(i,k) = dc_ad(i,k)+lac_ad
      h2_ad(i,k-1) = h2_ad(i,k-1)+lac_ad*fac
      lac_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmp_ad
      pmp_ad = pmp_ad+qmp_ad
      qmp_ad = 0.d0
      dc_ad(i,k) = dc_ad(i,k)+2*pmp_ad
      pmp_ad = 0.d0
    end do
  end do
  do k = 2, km1
    do i = i1, i2
      dc_ad(i,k-1) = dc_ad(i,k-1)-h2_ad(i,k)
      dc_ad(i,k+1) = dc_ad(i,k+1)+h2_ad(i,k)
      h2_ad(i,k) = 0.d0
    end do
  end do
else
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,lmt )
    if (kord .ne. 4) then
      do i = i1, i2
        a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
        a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
        a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
        a4_ad(4,i,k) = 0.d0
      end do
    endif
  end do
endif
a4(:,i1:i2,1:2) = ppm2m_a4_12h(:,:,:,1)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,0 )
  do i = i1, i2
    a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
    a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
    a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
    a4_ad(4,i,k) = 0.d0
  end do
end do
do k = 1, km1
  do i = i1, i2
    a4_ad(2,i,k+1) = a4_ad(2,i,k+1)+a4_ad(3,i,k)
    a4_ad(3,i,k) = 0.d0
  end do
end do
a4(1,i1:i2,km) = ppm2m_a4_10h(:,1)
a4(3,i1:i2,km) = ppm2m_a4_11h(:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_ad(3,i,km) = a4_ad(3,i,km)*(0.5-sign(0.5d0,0._8-a4(3,i,km)))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4_ad(3,i,km) = 0.d0
    else
      a4_ad(1,i,km) = a4_ad(1,i,km)+a4_ad(3,i,km)*(0.5+sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*&
&sign(1.d0,a4(1,i,km))*sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
      a4_ad(3,i,km) = a4_ad(3,i,km)*(0.5-sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(3,i,km))*&
&sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
    endif
  end do
endif
a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
do i = i1, i2
  c1_ad = 0.d0
  c3_ad = 0.d0
  cmax_ad = 0.d0
  cmin_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  dq_ad = 0.d0
  qm_ad = 0.d0
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  cmax_ad = cmax_ad+a4_ad(2,i,km)*(0.5+sign(0.5d0,a4(2,i,km)-cmax))
  a4_ad(2,i,km) = a4_ad(2,i,km)*(0.5-sign(0.5d0,a4(2,i,km)-cmax))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmin_ad = cmin_ad+a4_ad(2,i,km)*(0.5+sign(0.5d0,cmin-a4(2,i,km)))
  a4_ad(2,i,km) = a4_ad(2,i,km)*(0.5-sign(0.5d0,cmin-a4(2,i,km)))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_ad(1,i,km) = a4_ad(1,i,km)+cmin_ad*(0.5+sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+cmin_ad*(0.5-sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  cmin_ad = 0.d0
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_ad(1,i,km) = a4_ad(1,i,km)+cmax_ad*(0.5+sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+cmax_ad*(0.5-sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  cmax_ad = 0.d0
  a4_ad(3,i,km) = a4_ad(3,i,km)+dc_ad(i,km)
  a4_ad(1,i,km) = a4_ad(1,i,km)-dc_ad(i,km)
  dc_ad(i,km) = 0.d0
  c1_ad = c1_ad+8*a4_ad(3,i,km)*d1*d1**2
  c3_ad = c3_ad-a4_ad(3,i,km)*d1
  d1_ad = d1_ad+a4_ad(3,i,km)*(16*d1*c1*d1+8.*c1*d1**2-c3)
  a4_ad(2,i,km) = a4_ad(2,i,km)+a4_ad(3,i,km)
  a4_ad(3,i,km) = 0.d0
  c1_ad = c1_ad-a4_ad(2,i,km)*d1*d2*(d2+3.*d1)
  d1_ad = d1_ad-a4_ad(2,i,km)*(3*c1*d1*d2+c1*d2*(d2+3.*d1))
  d2_ad = d2_ad-a4_ad(2,i,km)*c1*d1*(2*d2+3.*d1)
  qm_ad = qm_ad+a4_ad(2,i,km)
  a4_ad(2,i,km) = 0.d0
  c1_ad = c1_ad-2*c3_ad*(d2*(5.*d1+d2)-3.*d1**2)
  d1_ad = d1_ad-2.*c3_ad*c1*(5*d2-6*d1)
  d2_ad = d2_ad-2.*c3_ad*c1*(d2+5.*d1+d2)
  dq_ad = dq_ad+c3_ad
  c3_ad = 0.d0
  a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
  a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
  a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
  a4_ad(2,i,km1) = a4_ad(2,i,km1)+c1_ad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  d1_ad = d1_ad-c1_ad*((a4(2,i,km1)-qm-d2*dq)*d2*(3*d1+d2+3.*d1)/(d2*(2.*d2*d2+d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  d2_ad = d2_ad-c1_ad*(dq/(d2*(2.*d2*d2+d1*(d2+3.*d1)))+(a4(2,i,km1)-qm-d2*dq)*(d2*(4*d2+d1)+2.*d2*d2+d1*(d2+3.*d1))/(d2*(2.*d2*d2+&
&d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  dq_ad = dq_ad-c1_ad*(d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_ad = qm_ad-c1_ad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c1_ad = 0.d0
  a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
  a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
  a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
  a4_ad(1,i,km) = a4_ad(1,i,km)+dq_ad*((-2)/(d1+d2))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+dq_ad*(2/(d1+d2))
  d1_ad = d1_ad-dq_ad*(2*(a4(1,i,km1)-a4(1,i,km))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad-dq_ad*(2*(a4(1,i,km1)-a4(1,i,km))/((d1+d2)*(d1+d2)))
  dq_ad = 0.d0
  a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
  a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
  a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
  a4_ad(1,i,km) = a4_ad(1,i,km)+qm_ad*(d2/(d1+d2))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+qm_ad*(d1/(d1+d2))
  d1_ad = d1_ad+qm_ad*(a4(1,i,km1)/(d1+d2)-(d2*a4(1,i,km)+d1*a4(1,i,km1))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad+qm_ad*(a4(1,i,km)/(d1+d2)-(d2*a4(1,i,km)+d1*a4(1,i,km1))/((d1+d2)*(d1+d2)))
  qm_ad = 0.d0
  delp_ae(i,km1) = delp_ae(i,km1)+d2_ad
  d2_ad = 0.d0
  delp_ae(i,km) = delp_ae(i,km)+d1_ad
  d1_ad = 0.d0
end do
a4(1,i1:i2,1) = ppm2m_a4_5h(:,1)
a4(2,i1:i2,1:2) = ppm2m_a4_6h(:,:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(3,i,1)
    a4_ad(3,i,1) = 0.d0
    a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(2,i,1)
    a4_ad(2,i,1) = 0.d0
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(3,i,1)
      a4_ad(3,i,1) = 0.d0
      a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(2,i,1)
      a4_ad(2,i,1) = 0.d0
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4_ad(2,i,1) = 0.d0
      else
        a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(2,i,1)*(0.5+sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,&
&a4(1,i,1))*sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
        a4_ad(2,i,1) = a4_ad(2,i,1)*(0.5-sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(2,i,1))*&
&sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
      endif
    end do
  endif
endif
a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
do i = i1, i2
  c1_ad = 0.d0
  c3_ad = 0.d0
  cmax_ad = 0.d0
  cmin_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  dq_ad = 0.d0
  qm_ad = 0.d0
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  cmax_ad = cmax_ad+a4_ad(2,i,2)*(0.5+sign(0.5d0,a4(2,i,2)-cmax))
  a4_ad(2,i,2) = a4_ad(2,i,2)*(0.5-sign(0.5d0,a4(2,i,2)-cmax))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmin_ad = cmin_ad+a4_ad(2,i,2)*(0.5+sign(0.5d0,cmin-a4(2,i,2)))
  a4_ad(2,i,2) = a4_ad(2,i,2)*(0.5-sign(0.5d0,cmin-a4(2,i,2)))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_ad(1,i,2) = a4_ad(1,i,2)+cmin_ad*(0.5-sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  a4_ad(1,i,1) = a4_ad(1,i,1)+cmin_ad*(0.5+sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  cmin_ad = 0.d0
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_ad(1,i,2) = a4_ad(1,i,2)+cmax_ad*(0.5-sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  a4_ad(1,i,1) = a4_ad(1,i,1)+cmax_ad*(0.5+sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  cmax_ad = 0.d0
  a4_ad(2,i,1) = a4_ad(2,i,1)-dc_ad(i,1)
  a4_ad(1,i,1) = a4_ad(1,i,1)+dc_ad(i,1)
  dc_ad(i,1) = 0.d0
  c1_ad = c1_ad+2*a4_ad(2,i,1)*d1*d1**2
  c3_ad = c3_ad-a4_ad(2,i,1)*d1
  d1_ad = d1_ad+a4_ad(2,i,1)*(4*d1*c1*d1+2.*c1*d1**2-c3)
  a4_ad(2,i,2) = a4_ad(2,i,2)+a4_ad(2,i,1)
  a4_ad(2,i,1) = 0.d0
  c1_ad = c1_ad-0.25*a4_ad(2,i,2)*d1*d2*(d2+3.*d1)
  d1_ad = d1_ad-a4_ad(2,i,2)*(0.75*c1*d1*d2+0.25*c1*d2*(d2+3.*d1))
  d2_ad = d2_ad-a4_ad(2,i,2)*(0.25*c1*d1*d2+0.25*c1*d1*(d2+3.*d1))
  qm_ad = qm_ad+a4_ad(2,i,2)
  a4_ad(2,i,2) = 0.d0
  c1_ad = c1_ad-0.5*c3_ad*(d2*(5.*d1+d2)-3.*d1**2)
  d1_ad = d1_ad-0.5*c3_ad*c1*(5*d2-6*d1)
  d2_ad = d2_ad-0.5*c3_ad*c1*(d2+5.*d1+d2)
  dq_ad = dq_ad+c3_ad
  c3_ad = 0.d0
  a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
  a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
  a4_ad(2,i,3) = a4_ad(2,i,3)+c1_ad*(4/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  d1_ad = d1_ad-c1_ad*(4.*(a4(2,i,3)-qm-d2*dq)*d2*(3*d1+d2+3.*d1)/(d2*(2.*d2*d2+d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  d2_ad = d2_ad-c1_ad*(4.*dq/(d2*(2.*d2*d2+d1*(d2+3.*d1)))+4.*(a4(2,i,3)-qm-d2*dq)*(d2*(4*d2+d1)+2.*d2*d2+d1*(d2+3.*d1))/(d2*(2.*&
&d2*d2+d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  dq_ad = dq_ad-c1_ad*(4.*d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_ad = qm_ad+c1_ad*((-4)/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  c1_ad = 0.d0
  a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
  a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
  a4_ad(1,i,2) = a4_ad(1,i,2)+dq_ad*(2/(d1+d2))
  a4_ad(1,i,1) = a4_ad(1,i,1)+dq_ad*((-2)/(d1+d2))
  d1_ad = d1_ad-dq_ad*(2*(a4(1,i,2)-a4(1,i,1))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad-dq_ad*(2*(a4(1,i,2)-a4(1,i,1))/((d1+d2)*(d1+d2)))
  dq_ad = 0.d0
  a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
  a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
  a4_ad(1,i,2) = a4_ad(1,i,2)+qm_ad*(d1/(d1+d2))
  a4_ad(1,i,1) = a4_ad(1,i,1)+qm_ad*(d2/(d1+d2))
  d1_ad = d1_ad+qm_ad*(a4(1,i,2)/(d1+d2)-(d2*a4(1,i,1)+d1*a4(1,i,2))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad+qm_ad*(a4(1,i,1)/(d1+d2)-(d2*a4(1,i,1)+d1*a4(1,i,2))/((d1+d2)*(d1+d2)))
  qm_ad = 0.d0
  delp_ae(i,2) = delp_ae(i,2)+d2_ad
  d2_ad = 0.d0
  delp_ae(i,1) = delp_ae(i,1)+d1_ad
  d1_ad = 0.d0
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
  end do
end do
a4(1:2,i1:i2,:) = ppm2m_a4_2h(:,:,:,1)
call steepz_ad( i1,i2,km,a4,a4_ad,df2,df2_ad,dc,dc_ad,delq,delq_ad,delp,delp_ae,d4,d4_ad )
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
  end do
end do
do k = 3, km1
  a1_ad = 0.d0
  a2_ad = 0.d0
  c1_ad = 0.d0
  do i = i1, i2
    a1_ad = 0.d0
    a2_ad = 0.d0
    c1_ad = 0.d0
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a1_ad = a1_ad+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*c1-delp(i,k-1)*dc(i,k))
    a2_ad = a2_ad+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*((-c1)+dc(i,k-1))
    c1_ad = c1_ad+a4_ad(2,i,k)*(1+2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*(a1-a2))
    d4_ad(i,k-1) = d4_ad(i,k-1)-a4_ad(2,i,k)*2/((d4(i,k-1)+d4(i,k+1))*(d4(i,k-1)+d4(i,k+1)))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-&
&delp(i,k-1)*a1*dc(i,k))
    d4_ad(i,k+1) = d4_ad(i,k+1)-a4_ad(2,i,k)*2/((d4(i,k-1)+d4(i,k+1))*(d4(i,k-1)+d4(i,k+1)))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-&
&delp(i,k-1)*a1*dc(i,k))
    dc_ad(i,k-1) = dc_ad(i,k-1)+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*a2
    dc_ad(i,k) = dc_ad(i,k)-a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k-1)*a1
    delp_ae(i,k-1) = delp_ae(i,k-1)-a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*a1*dc(i,k)
    delp_ae(i,k) = delp_ae(i,k)+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*(c1*(a1-a2)+a2*dc(i,k-1))
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+a4_ad(2,i,k)
    a4_ad(2,i,k) = 0.d0
    d4_ad(i,k+1) = d4_ad(i,k+1)+a2_ad/(d4(i,k)+delp(i,k))
    d4_ad(i,k) = d4_ad(i,k)-a2_ad*(d4(i,k+1)/((d4(i,k)+delp(i,k))*(d4(i,k)+delp(i,k))))
    delp_ae(i,k) = delp_ae(i,k)-a2_ad*(d4(i,k+1)/((d4(i,k)+delp(i,k))*(d4(i,k)+delp(i,k))))
    a2_ad = 0.d0
    d4_ad(i,k-1) = d4_ad(i,k-1)+a1_ad/(d4(i,k)+delp(i,k-1))
    d4_ad(i,k) = d4_ad(i,k)-a1_ad*(d4(i,k-1)/((d4(i,k)+delp(i,k-1))*(d4(i,k)+delp(i,k-1))))
    delp_ae(i,k-1) = delp_ae(i,k-1)-a1_ad*(d4(i,k-1)/((d4(i,k)+delp(i,k-1))*(d4(i,k)+delp(i,k-1))))
    a1_ad = 0.d0
    d4_ad(i,k) = d4_ad(i,k)-c1_ad*(delq(i,k-1)*delp(i,k-1)/(d4(i,k)*d4(i,k)))
    delp_ae(i,k-1) = delp_ae(i,k-1)+c1_ad*(delq(i,k-1)/d4(i,k))
    delq_ad(i,k-1) = delq_ad(i,k-1)+c1_ad*(delp(i,k-1)/d4(i,k))
    c1_ad = 0.d0
  end do
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  c1_ad = 0.d0
  c2_ad = 0.d0
  qmax_ad = 0.d0
  qmin_ad = 0.d0
  tmp_ad = 0.d0
  do i = i1, i2
    c1_ad = 0.d0
    c2_ad = 0.d0
    qmax_ad = 0.d0
    qmin_ad = 0.d0
    tmp_ad = 0.d0
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    tmp_ad = tmp_ad+df2_ad(i,k)
    df2_ad(i,k) = 0.d0
    dci = min(abs(tmp),qmax)
    dcj_ad = dc_ad(i,k)*sign(1.d0,min(dci,qmin))*sign(1.d0,tmp)
    dci_ae = dcj_ad*(0.5+sign(0.5d0,qmin-dci))
    qmin_ad = qmin_ad+dcj_ad*(0.5-sign(0.5d0,qmin-dci))
    qmax_ad = qmax_ad+dci_ae*(0.5-sign(0.5d0,qmax-abs(tmp)))
    tmp_ad = tmp_ad+dci_ae*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
    dc_ad(i,k) = 0.d0
    qminj = min(a4(1,i,k-1),a4(1,i,k))
    a4_ad(1,i,k) = a4_ad(1,i,k)+qmin_ad
    qmink_ad = -qmin_ad
    a4_ad(1,i,k+1) = a4_ad(1,i,k+1)+qmink_ad*(0.5-sign(0.5d0,a4(1,i,k+1)-qminj))
    qminj_ad = qmink_ad*(0.5+sign(0.5d0,a4(1,i,k+1)-qminj))
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+qminj_ad*(0.5+sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    a4_ad(1,i,k) = a4_ad(1,i,k)+qminj_ad*(0.5-sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    qmin_ad = 0.d0
    qmaxj = max(a4(1,i,k-1),a4(1,i,k))
    a4_ad(1,i,k) = a4_ad(1,i,k)-qmax_ad
    a4_ad(1,i,k+1) = a4_ad(1,i,k+1)+qmax_ad*(0.5-sign(0.5d0,qmaxj-a4(1,i,k+1)))
    qmaxj_ad = qmax_ad*(0.5+sign(0.5d0,qmaxj-a4(1,i,k+1)))
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+qmaxj_ad*(0.5+sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    a4_ad(1,i,k) = a4_ad(1,i,k)+qmaxj_ad*(0.5-sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    qmax_ad = 0.d0
    c1_ad = c1_ad+tmp_ad*(delp(i,k)*delq(i,k)/(d4(i,k)+delp(i,k+1)))
    c2_ad = c2_ad+tmp_ad*(delp(i,k)*delq(i,k-1)/(d4(i,k)+delp(i,k+1)))
    d4_ad(i,k) = d4_ad(i,k)-tmp_ad*(delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/((d4(i,k)+delp(i,k+1))*(d4(i,k)+delp(i,k+1))))
    delp_ae(i,k+1) = delp_ae(i,k+1)-tmp_ad*(delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/((d4(i,k)+delp(i,k+1))*(d4(i,k)+delp(i,k+1))))
    delp_ae(i,k) = delp_ae(i,k)+tmp_ad*((c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1)))
    delq_ad(i,k-1) = delq_ad(i,k-1)+tmp_ad*(delp(i,k)*c2/(d4(i,k)+delp(i,k+1)))
    delq_ad(i,k) = delq_ad(i,k)+tmp_ad*(delp(i,k)*c1/(d4(i,k)+delp(i,k+1)))
    tmp_ad = 0.d0
    d4_ad(i,k) = d4_ad(i,k)-c2_ad*((delp(i,k+1)+0.5*delp(i,k))/(d4(i,k)*d4(i,k)))
    delp_ae(i,k+1) = delp_ae(i,k+1)+c2_ad/d4(i,k)
    delp_ae(i,k) = delp_ae(i,k)+c2_ad*(0.5/d4(i,k))
    c2_ad = 0.d0
    d4_ad(i,k+1) = d4_ad(i,k+1)-c1_ad*((delp(i,k-1)+0.5*delp(i,k))/(d4(i,k+1)*d4(i,k+1)))
    delp_ae(i,k-1) = delp_ae(i,k-1)+c1_ad/d4(i,k+1)
    delp_ae(i,k) = delp_ae(i,k)+c1_ad*(0.5/d4(i,k+1))
    c1_ad = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    delp_ae(i,k-1) = delp_ae(i,k-1)+d4_ad(i,k)
    delp_ae(i,k) = delp_ae(i,k)+d4_ad(i,k)
    d4_ad(i,k) = 0.d0
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)-delq_ad(i,k-1)
    a4_ad(1,i,k) = a4_ad(1,i,k)+delq_ad(i,k-1)
    delq_ad(i,k-1) = 0.d0
  end do
end do

!----------------------------------------------
! CLOSE TAPE ppm2m
!----------------------------------------------
if (allocated(ppm2m_a4_7h)) then
  deallocate( ppm2m_a4_7h )
endif
if (allocated(ppm2m_a4_8h)) then
  deallocate( ppm2m_a4_8h )
endif
if (allocated(ppm2m_a4_14h)) then
  deallocate( ppm2m_a4_14h )
endif


end subroutine ppm2m_ad


subroutine steepz_ad( i1, i2, km, a4, a4_ad, df2, df2_ad, dm, dm_ad, dq, dq_ad, dp, dp_ad, d4, d4_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ad(4,i1:i2,km)
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: d4_ad(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ad(i1:i2,km)
real(kind=r8) :: dm(i1:i2,km)
real(kind=r8) :: dm_ad(i1:i2,km)
real(kind=r8) :: dp(i1:i2,km)
real(kind=r8) :: dp_ad(i1:i2,km)
real(kind=r8) :: dq(i1:i2,km)
real(kind=r8) :: dq_ad(i1:i2,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alfa(i1:i2,km)
real(kind=r8) :: alfa_ad(i1:i2,km)
real(kind=r8) :: dg2
real(kind=r8) :: dg2_ad
real(kind=r8) :: f(i1:i2,km)
real(kind=r8) :: f_ad(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: rat(i1:i2,km)
real(kind=r8) :: rat_ad(i1:i2,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alfa_ad(:,:) = 0.d0
dg2_ad = 0.d0
f_ad(:,:) = 0.d0
rat_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    rat(i,k) = dq(i,k-1)/d4(i,k)
  end do
end do
do k = 2, km-1
  do i = i1, i2
    f(i,k) = (rat(i,k+1)-rat(i,k))/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
  end do
end do
do k = 3, km-2
  do i = i1, i2
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      alfa(i,k) = max(0._8,min(0.5_8,-(0.1875*dg2/df2(i,k))))
    else
      alfa(i,k) = 0.
    endif
  end do
end do
do k = 4, km-2
  do i = i1, i2
    alfa_ad(i,k-1) = alfa_ad(i,k-1)+a4_ad(2,i,k)*((-a4(2,i,k))+a4(1,i,k)-dm(i,k))
    alfa_ad(i,k) = alfa_ad(i,k)+a4_ad(2,i,k)*((-a4(2,i,k))+a4(1,i,k-1)+dm(i,k-1))
    dm_ad(i,k-1) = dm_ad(i,k-1)+a4_ad(2,i,k)*alfa(i,k)
    dm_ad(i,k) = dm_ad(i,k)-a4_ad(2,i,k)*alfa(i,k-1)
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+a4_ad(2,i,k)*alfa(i,k)
    a4_ad(1,i,k) = a4_ad(1,i,k)+a4_ad(2,i,k)*alfa(i,k-1)
    a4_ad(2,i,k) = a4_ad(2,i,k)*(1.-alfa(i,k-1)-alfa(i,k))
  end do
end do
do k = 3, km-2
  dg2_ad = 0.d0
  do i = i1, i2
    dg2_ad = 0.d0
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      df2_ad(i,k) = df2_ad(i,k)+alfa_ad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*&
&dg2/df2(i,k)))-0.5_8))*(0.1875*dg2/(df2(i,k)*df2(i,k)))
      dg2_ad = dg2_ad-alfa_ad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*dg2/df2(i,k))&
&)-0.5_8))*(0.1875/df2(i,k))
      alfa_ad(i,k) = 0.d0
      d4_ad(i,k+1) = d4_ad(i,k+1)+dg2_ad*(f(i,k+1)-f(i,k-1))*d4(i,k)
      d4_ad(i,k) = d4_ad(i,k)+dg2_ad*(f(i,k+1)-f(i,k-1))*d4(i,k+1)
      dp_ad(i,k-1) = dp_ad(i,k-1)-2*dg2_ad*(f(i,k+1)-f(i,k-1))*(dp(i,k+1)-dp(i,k-1))
      dp_ad(i,k+1) = dp_ad(i,k+1)+2*dg2_ad*(f(i,k+1)-f(i,k-1))*(dp(i,k+1)-dp(i,k-1))
      f_ad(i,k-1) = f_ad(i,k-1)-dg2_ad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      f_ad(i,k+1) = f_ad(i,k+1)+dg2_ad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      dg2_ad = 0.d0
    else
      alfa_ad(i,k) = 0.d0
    endif
  end do
end do
do k = 2, km-1
  do i = i1, i2
    dp_ad(i,k-1) = dp_ad(i,k-1)-f_ad(i,k)*((rat(i,k+1)-rat(i,k))/((dp(i,k-1)+dp(i,k)+dp(i,k+1))*(dp(i,k-1)+dp(i,k)+dp(i,k+1))))
    dp_ad(i,k+1) = dp_ad(i,k+1)-f_ad(i,k)*((rat(i,k+1)-rat(i,k))/((dp(i,k-1)+dp(i,k)+dp(i,k+1))*(dp(i,k-1)+dp(i,k)+dp(i,k+1))))
    dp_ad(i,k) = dp_ad(i,k)-f_ad(i,k)*((rat(i,k+1)-rat(i,k))/((dp(i,k-1)+dp(i,k)+dp(i,k+1))*(dp(i,k-1)+dp(i,k)+dp(i,k+1))))
    rat_ad(i,k+1) = rat_ad(i,k+1)+f_ad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    rat_ad(i,k) = rat_ad(i,k)-f_ad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    f_ad(i,k) = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    d4_ad(i,k) = d4_ad(i,k)-rat_ad(i,k)*(dq(i,k-1)/(d4(i,k)*d4(i,k)))
    dq_ad(i,k-1) = dq_ad(i,k-1)+rat_ad(i,k)/d4(i,k)
    rat_ad(i,k) = 0.d0
  end do
end do

end subroutine steepz_ad


subroutine te_map_ad( consv, convt, ps, ps_ae, pe, pe_ae, delp, delp_ae, pkz, pkz_ae, pk, pk_ae, im, jm, km, nx, jfirst, jlast, nq,&
& u, u_ae, v, v_ae, pt, pt_ae, q, q_ae, hs, cp, akap, kord, peln, peln_ad, te0, te0_ad, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mod_comm, only : mp_barrier, mp_recv_n, mp_recv_n_ad, mp_recv_pe, mp_recv_pe_ad, mp_send_pe, mp_send_pe_ad, mp_send_s, &
&mp_send_s_ad
use te_map_ad_store, only : te_map_tape_delp_15h,te_map_tape_dtmp_18h,te_map_tape_dz_8h,te_map_tape_pe_14h,te_map_tape_peln_12h,&
&te_map_tape_pk_1h,te_map_tape_pkz_13h,te_map_tape_pkz_2h,te_map_tape_te_11h,te_map_tape_te_19h,te_map_tape_te_9h,&
&te_map_tape_te_map,te_map_tape_tsum_16h,te_map_tape_u_17h,te_map_tape_u_6h,te_map_tape_v_10h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_ae(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_ae(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: peln_ad(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pk_ae(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_ae(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: ps_ae(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_ae(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: q_ae(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
real(kind=r8) :: te0_ad
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_ae(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_ae(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: bte_ad(im)
real(kind=r8) :: dlnp
real(kind=r8) :: dlnp_ad
real(kind=r8) :: dtmp
real(kind=r8) :: dtmp_ad
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: dz_ad(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
real(kind=r8) :: gz_ad(im)
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe0_ad(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1_ad(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe1w_ad(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2_ad(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe2w_ad(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: pe3_ad(im,km+1)
real(kind=r8) :: peh(im,km+1,jfirst:jlast)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: phis_ad(im,km+1)
#ifdef USE_OPENMP
real(kind=r8) :: pk_aeh(im,jfirst:jlast,km+1)
#endif /* ! USE_OPENMP */
real(kind=r8) :: pkh(im,jfirst:jlast,km+1)
real(kind=r8) :: pth(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: t2_ad(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te1_ad
real(kind=r8) :: te_ad(im,jfirst:jlast,km)
real(kind=8), allocatable :: te_map_gz_gz_1h(:,:)
integer :: te_map_gz_te_map
real(kind=r8) :: te_np_ad
real(kind=r8) :: te_sp_ad
real(kind=r8) :: tsum
real(kind=r8) :: tsum_ad
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tte_ad(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: tvm_ad
real(kind=r8) :: u2_ad(im,jfirst:jlast+1)
real(kind=r8) :: v2_ad(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: xsum_ad
real(kind=r8) :: ysum_ad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
pth(:,:,:) = pt(:,:,:)
pkh(:,:,:) = pk(:,:,:)
peh(:,:,:) = pe(:,:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
bte_ad(:) = 0.d0
dlnp_ad = 0.d0
dtmp_ad = 0.d0
dz_ad(:,:,:) = 0.d0
gz_ad(:) = 0.d0
pe0_ad(:,:) = 0.d0
pe1_ad(:,:) = 0.d0
pe1w_ad(:) = 0.d0
pe2_ad(:,:) = 0.d0
pe2w_ad(:) = 0.d0
pe3_ad(:,:) = 0.d0
phis_ad(:,:) = 0.d0
t2_ad(:,:) = 0.d0
te1_ad = 0.d0
te_ad(:,:,:) = 0.d0
te_np_ad = 0.d0
te_sp_ad = 0.d0
tsum_ad = 0.d0
tte_ad(:) = 0.d0
tvm_ad = 0.d0
u2_ad(:,:) = 0.d0
v2_ad(:,:) = 0.d0
xsum_ad = 0.d0
ysum_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
pk = te_map_tape_pk_1h(:,:,:,te_map_tape_rec+1)
help_h = km+1
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe )
help_i = km+1
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth )
it = im/nx
jp = nx*(jlast-jfirst+1)
v = te_map_tape_v_10h(:,:,:,te_map_tape_rec+1)
peln = te_map_tape_peln_12h(:,:,:,te_map_tape_rec+1)
pkz = te_map_tape_pkz_13h(:,:,:,te_map_tape_rec+1)
pe = te_map_tape_pe_14h(:,:,:,te_map_tape_rec+1)
delp = te_map_tape_delp_15h(:,:,:,te_map_tape_rec+1)
u = te_map_tape_u_17h(:,:,:,te_map_tape_rec+1)
dtmp = te_map_tape_dtmp_18h(te_map_tape_rec+1)
te = te_map_tape_te_19h(:,:,:,te_map_tape_rec+1)
#ifdef USE_OPENMP
!$omp parallel do shared(akap,consv,convt,cp,delp,delp_ae,dtmp,dtmp_ad,hs,it,jfirst,jp,km,nx,pe,pe_ae,peln,peln_ad,pkz,pkz_ae,pt,&
!$omp& pt_ae,te,te_ad) private(dlnp,dlnp_ad,gz,gz_ad,i,i1,i2,ixj,j,k,rg,te_map_gz_gz_1h,te_map_gz_te_map,tvm,tvm_ad)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  dlnp_ad = 0.d0
  gz_ad(:) = 0.d0
  tvm_ad = 0.d0
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
!----------------------------------------------
! OPEN TAPE te_map_gz
!----------------------------------------------
  te_map_gz_te_map = km

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 2, -1
    if ( .not. allocated(te_map_gz_gz_1h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(te_map_gz_gz_1h)) then
        allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
#endif /* USE_OPENMP */
    endif
    te_map_gz_gz_1h(:,1+km-k) = gz
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
    end do
  end do
  k = 1
  if ( .not. allocated(te_map_gz_gz_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(te_map_gz_gz_1h)) then
      allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
#endif /* USE_OPENMP */
  endif
  te_map_gz_gz_1h(:,1+km-k) = gz

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
  do k = 1, km
    gz = te_map_gz_gz_1h(:,1+km-k)
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-pt_ae(i,j,k)*(pt(i,j,k)/(pkz(i,j,k)*pkz(i,j,k)))
        pt_ae(i,j,k) = pt_ae(i,j,k)/pkz(i,j,k)
      end do
    endif
    if (consv) then
      do i = i1, i2
        dtmp_ad = dtmp_ad+pt_ae(i,j,k)
      end do
    endif
    do i = i1, i2
      dlnp_ad = 0.d0
      tvm_ad = 0.d0
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      tvm_ad = tvm_ad+pt_ae(i,j,k)
      pt_ae(i,j,k) = 0.d0
      dlnp_ad = dlnp_ad+gz_ad(i)*tvm
      tvm_ad = tvm_ad+gz_ad(i)*dlnp
      delp_ae(i,j,k) = delp_ae(i,j,k)+tvm_ad*((te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)-delp(i,j,k)*(te(i,j,k)-gz(i))*cp/&
&((cp*delp(i,j,k)-pe(i,k,j)*dlnp)*(cp*delp(i,j,k)-pe(i,k,j)*dlnp)))
      dlnp_ad = dlnp_ad+tvm_ad*(delp(i,j,k)*(te(i,j,k)-gz(i))*pe(i,k,j)/((cp*delp(i,j,k)-pe(i,k,j)*dlnp)*(cp*delp(i,j,k)-pe(i,k,j)*&
&dlnp)))
      gz_ad(i) = gz_ad(i)-tvm_ad*(delp(i,j,k)/(cp*delp(i,j,k)-pe(i,k,j)*dlnp))
      pe_ae(i,k,j) = pe_ae(i,k,j)+tvm_ad*(delp(i,j,k)*(te(i,j,k)-gz(i))*dlnp/((cp*delp(i,j,k)-pe(i,k,j)*dlnp)*(cp*delp(i,j,k)-pe(i,&
&k,j)*dlnp)))
      te_ad(i,j,k) = te_ad(i,j,k)+tvm_ad*(delp(i,j,k)/(cp*delp(i,j,k)-pe(i,k,j)*dlnp))
      tvm_ad = 0.d0
      peln_ad(i,k+1,j) = peln_ad(i,k+1,j)+dlnp_ad*rg
      peln_ad(i,k,j) = peln_ad(i,k,j)-dlnp_ad*rg
      dlnp_ad = 0.d0
    end do
  end do
  do i = i1, i2
    gz_ad(i) = 0.d0
  end do

!----------------------------------------------
! CLOSE TAPE te_map_gz
!----------------------------------------------
  if (allocated(te_map_gz_gz_1h)) then
    deallocate( te_map_gz_gz_1h )
  endif

end do
#ifdef USE_OPENMP
!$omp parallel do shared(im,jfirst,jlast,jm,jn2g0,js2g0,km,te_ad,u,u_ae,v,v_ae) private(i,j,k,te_np_ad,te_sp_ad,u2_ad,v2_ad)
#endif /* ! USE_OPENMP */
do k = 1, km
  te_np_ad = 0.d0
  te_sp_ad = 0.d0
  u2_ad(:,:) = 0.d0
  v2_ad(:,:) = 0.d0
  if (jlast .eq. jm) then
    do i = 1, im
      te_np_ad = te_np_ad+te_ad(i,jm,k)
      te_ad(i,jm,k) = 0.d0
    end do
    te_ad(1,jm,k) = te_ad(1,jm,k)+te_np_ad
    te_np_ad = -(te_np_ad*(0.5/float(im)))
    do i = 1, im
      u2_ad(i,jm) = u2_ad(i,jm)+te_np_ad
      v2_ad(i,jm-1) = v2_ad(i,jm-1)+te_np_ad
    end do
    te_np_ad = 0.d0
  endif
  if (jfirst .eq. 1) then
    do i = 1, im
      te_sp_ad = te_sp_ad+te_ad(i,1,k)
      te_ad(i,1,k) = 0.d0
    end do
    te_ad(1,1,k) = te_ad(1,1,k)+te_sp_ad
    te_sp_ad = -(te_sp_ad*(0.5/float(im)))
    do i = 1, im
      u2_ad(i,2) = u2_ad(i,2)+te_sp_ad
      v2_ad(i,2) = v2_ad(i,2)+te_sp_ad
    end do
    te_sp_ad = 0.d0
  endif
  do j = js2g0, jn2g0
    u2_ad(im,j+1) = u2_ad(im,j+1)-0.25*te_ad(im,j,k)
    u2_ad(im,j) = u2_ad(im,j)-0.25*te_ad(im,j,k)
    v2_ad(im,j) = v2_ad(im,j)-0.25*te_ad(im,j,k)
    v2_ad(1,j) = v2_ad(1,j)-0.25*te_ad(im,j,k)
    do i = 1, im-1
      u2_ad(i,j+1) = u2_ad(i,j+1)-0.25*te_ad(i,j,k)
      u2_ad(i,j) = u2_ad(i,j)-0.25*te_ad(i,j,k)
      v2_ad(i+1,j) = v2_ad(i+1,j)-0.25*te_ad(i,j,k)
      v2_ad(i,j) = v2_ad(i,j)-0.25*te_ad(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v_ae(i,j,k) = v_ae(i,j,k)+2*v2_ad(i,j)*v(i,j,k)
      v2_ad(i,j) = 0.d0
    end do
  end do
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u_ae(i,j,k) = u_ae(i,j,k)+2*u2_ad(i,j)*u(i,j,k)
      u2_ad(i,j) = 0.d0
    end do
  end do
end do
call mp_recv_n_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_ae )
te = te_map_tape_te_11h(:,:,:,te_map_tape_rec+1)
if (consv) then
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
  tsum = te_map_tape_tsum_16h(te_map_tape_rec+1)
  te0_ad = te0_ad+dtmp_ad/tsum
  te1_ad = te1_ad-dtmp_ad/tsum
  tsum_ad = tsum_ad-dtmp_ad*((te0-te1)/(tsum*tsum))
  dtmp_ad = 0.d0
  call par_vecsum_ad( jm,jfirst,jlast,tte_ad,tsum_ad )
#ifdef USE_OPENMP
  !$omp parallel do shared(akap,cp,im,jfirst,jlast,jm,km,peln_ad,ps_ae,te_acap,te_cosp,te_ptop,tte_ad) private(i,j,xsum_ad,ysum_ad)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    xsum_ad = 0.d0
    ysum_ad = 0.d0
    if (j .eq. 1) then
      peln_ad(1,km+1,1) = peln_ad(1,km+1,1)-tte_ad(1)*te_acap*cp*akap*te_ptop
      peln_ad(1,1,1) = peln_ad(1,1,1)+tte_ad(1)*te_acap*cp*akap*te_ptop
      ps_ae(1,1) = ps_ae(1,1)+tte_ad(1)*te_acap*cp
      tte_ad(1) = 0.d0
    else if (j .eq. jm) then
      peln_ad(1,km+1,jm) = peln_ad(1,km+1,jm)-tte_ad(jm)*te_acap*cp*akap*te_ptop
      peln_ad(1,1,jm) = peln_ad(1,1,jm)+tte_ad(jm)*te_acap*cp*akap*te_ptop
      ps_ae(1,jm) = ps_ae(1,jm)+tte_ad(jm)*te_acap*cp
      tte_ad(jm) = 0.d0
    else
      peln_ad(1,1,j) = peln_ad(1,1,j)+tte_ad(j)*cp*te_cosp(j)*akap*te_ptop*im
      xsum_ad = xsum_ad+tte_ad(j)*cp*te_cosp(j)
      ysum_ad = ysum_ad-tte_ad(j)*cp*te_cosp(j)*akap*te_ptop
      tte_ad(j) = 0.d0
      do i = 1, im
        peln_ad(i,km+1,j) = peln_ad(i,km+1,j)+ysum_ad
        ps_ae(i,j) = ps_ae(i,j)+xsum_ad
      end do
      ysum_ad = 0.d0
      xsum_ad = 0.d0
    endif
  end do
  call par_vecsum_ad( jm,jfirst,jlast,tte_ad,te1_ad )
#ifdef USE_OPENMP
  !$omp parallel do shared(dz_ad,im,jfirst,jlast,jm,km,te_acap,te_cosp,tte_ad) private(bte_ad,i,j,k,xsum_ad)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    bte_ad(:) = 0.d0
    xsum_ad = 0.d0
    if (j .eq. 1) then
      tte_ad(1) = tte_ad(1)*te_acap
      do k = 1, km
        dz_ad(1,1,k) = dz_ad(1,1,k)+tte_ad(1)
      end do
      tte_ad(1) = 0.d0
    else if (j .eq. jm) then
      tte_ad(jm) = tte_ad(jm)*te_acap
      do k = 1, km
        dz_ad(1,jm,k) = dz_ad(1,jm,k)+tte_ad(jm)
      end do
      tte_ad(jm) = 0.d0
    else
      xsum_ad = xsum_ad+tte_ad(j)*te_cosp(j)
      tte_ad(j) = 0.d0
      do i = 1, im
        bte_ad(i) = bte_ad(i)+xsum_ad
      end do
      xsum_ad = 0.d0
      do k = km, 1, -1
        do i = 1, im
          dz_ad(i,j,k) = dz_ad(i,j,k)+bte_ad(i)
        end do
      end do
      do i = 1, im
        bte_ad(i) = 0.d0
      end do
    endif
  end do
#ifdef USE_OPENMP
  !$omp parallel do shared(delp,delp_ae,dz_ad,im,jfirst,jlast,km,te,te_ad) private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delp_ae(i,j,k) = delp_ae(i,j,k)+dz_ad(i,j,k)*te(i,j,k)
        te_ad(i,j,k) = te_ad(i,j,k)+dz_ad(i,j,k)*delp(i,j,k)
        dz_ad(i,j,k) = 0.d0
      end do
    end do
  end do
endif
pe(:,:,:) = peh(:,:,:)
#ifdef USE_OPENMP
!$omp parallel do private(i,i1,i2,ixj,j,k,pe1,pe2)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe2(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
call pkez_ad( nx,im,km,jfirst,jlast,pe,pe_ae,pk,pk_ae,akap,ks,peln,peln_ad,pkz_ae, .true.  )
#ifdef USE_OPENMP
!$omp parallel do shared(im,jfirst,jlast,km,pe_ae,peln_ad) private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      peln_ad(i,k,j) = peln_ad(i,k,j)+pe_ae(i,k,j)
      pe_ae(i,k,j) = 0.d0
    end do
  end do
end do
call mp_send_s_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_ae )
pe(:,:,:) = peh(:,:,:)
u = te_map_tape_u_6h(:,:,:,te_map_tape_rec+1)
v = te_map_tape_v_7h(:,:,:,te_map_tape_rec+1)
dz = te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1)
te = te_map_tape_te_9h(:,:,:,te_map_tape_rec+1)
#ifdef USE_OPENMP
!$omp parallel do shared(ak,bk,delp_ae,dz,dz_ad,hs,im,it,jfirst,jlast,jm,jp,km,kord,ks,ng_d,ng_s,nq,nx,pe,pe_ae,peln_ad,pesouth,&
!$omp& pesouth_ad,ps,ps_ae,q,q_ae,te,te_ad,u,u_ae,v,v_ae) private(bkh,help_j,help_k,i,i1,i2,ixj,j,k,krd,pe0,pe0_ad,pe1,pe1_ad,pe1w,&
!$omp& pe1w_ad,pe2,pe2_ad,pe2w,pe2w_ad,pe3,pe3_ad,phis,phis_ad)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  pe0_ad(:,:) = 0.d0
  pe1_ad(:,:) = 0.d0
  pe1w_ad(:) = 0.d0
  pe2_ad(:,:) = 0.d0
  pe2w_ad(:) = 0.d0
  pe3_ad(:,:) = 0.d0
  phis_ad(:,:) = 0.d0
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    else
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pesouth(i,k))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pesouth(i,km+1))
        end do
      end do
    endif
  endif
  do k = 2, km
    do i = i1, i2
      pe2_ad(i,k) = pe2_ad(i,k)+peln_ad(i,k,j)
      peln_ad(i,k,j) = 0.d0
    end do
  end do
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_k = -1
    call map1_ppm_ad( km,pe0,pe0_ad,v,v_ae,km,pe3,pe3_ad,v_ae,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_k,kord )
    do k = ks+2, km+1
      do i = i1+1, i2
        pe2_ad(i-1,k) = pe2_ad(i-1,k)+0.5*pe3_ad(i,k)
        pe2_ad(i,k) = pe2_ad(i,k)+0.5*pe3_ad(i,k)
        pe3_ad(i,k) = 0.d0
      end do
      pe2_ad(i1,k) = pe2_ad(i1,k)+0.5*pe3_ad(i1,k)
      pe2w_ad(k) = pe2w_ad(k)+0.5*pe3_ad(i1,k)
      pe3_ad(i1,k) = 0.d0
    end do
    do k = 2, km+1
      do i = i1+1, i2
        pe1_ad(i-1,k) = pe1_ad(i-1,k)+0.5*pe0_ad(i,k)
        pe1_ad(i,k) = pe1_ad(i,k)+0.5*pe0_ad(i,k)
        pe0_ad(i,k) = 0.d0
      end do
      pe1_ad(i1,k) = pe1_ad(i1,k)+0.5*pe0_ad(i1,k)
      pe1w_ad(k) = pe1w_ad(k)+0.5*pe0_ad(i1,k)
      pe0_ad(i1,k) = 0.d0
    end do
  endif
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
  end do
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    else
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pesouth(i,k))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pesouth(i,km+1))
        end do
      end do
    endif
    help_j = -1
    call map1_ppm_ad( km,pe0,pe0_ad,u,u_ae,km,pe3,pe3_ad,u_ae,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_j,kord )
    if (j .gt. jfirst) then
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe_ae(i,km+1,j-1) = pe_ae(i,km+1,j-1)+pe3_ad(i,k)*bkh
          pe1_ad(i,km+1) = pe1_ad(i,km+1)+pe3_ad(i,k)*bkh
          pe3_ad(i,k) = 0.d0
        end do
      end do
      do k = 2, km+1
        do i = i1, i2
          pe_ae(i,k,j-1) = pe_ae(i,k,j-1)+0.5*pe0_ad(i,k)
          pe1_ad(i,k) = pe1_ad(i,k)+0.5*pe0_ad(i,k)
          pe0_ad(i,k) = 0.d0
        end do
      end do
    else
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe1_ad(i,km+1) = pe1_ad(i,km+1)+pe3_ad(i,k)*bkh
          pesouth_ad(i,km+1) = pesouth_ad(i,km+1)+pe3_ad(i,k)*bkh
          pe3_ad(i,k) = 0.d0
        end do
      end do
      do k = 2, km+1
        do i = i1, i2
          pe1_ad(i,k) = pe1_ad(i,k)+0.5*pe0_ad(i,k)
          pesouth_ad(i,k) = pesouth_ad(i,k)+0.5*pe0_ad(i,k)
          pe0_ad(i,k) = 0.d0
        end do
      end do
    endif
  endif
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm_ad( km,pe1,pe1_ad,q,q_ae,nq,km,pe2,pe2_ad,q_ae,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  call map1_ppm_ad( km,pe1,pe1_ad,te,te_ad,km,pe2,pe2_ad,te_ad,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  do k = 1, km
    do i = i1, i2
      pe1_ad(i,k+1) = pe1_ad(i,k+1)-te_ad(i,j,k)*((phis(i,k+1)-phis(i,k))/((pe1(i,k+1)-pe1(i,k))*(pe1(i,k+1)-pe1(i,k))))
      pe1_ad(i,k) = pe1_ad(i,k)+te_ad(i,j,k)*((phis(i,k+1)-phis(i,k))/((pe1(i,k+1)-pe1(i,k))*(pe1(i,k+1)-pe1(i,k))))
      phis_ad(i,k+1) = phis_ad(i,k+1)+te_ad(i,j,k)/(pe1(i,k+1)-pe1(i,k))
      phis_ad(i,k) = phis_ad(i,k)-te_ad(i,j,k)/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      pe1_ad(i,k) = pe1_ad(i,k)+phis_ad(i,k)*phis(i,k)
      phis_ad(i,k) = phis_ad(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      dz_ad(i,j,k) = dz_ad(i,j,k)+phis_ad(i,k)
      phis_ad(i,k+1) = phis_ad(i,k+1)+phis_ad(i,k)
      phis_ad(i,k) = 0.d0
    end do
  end do
  do i = i1, i2
    phis_ad(i,km+1) = 0.d0
  end do
  do k = ks+1, km
    do i = i1, i2
      pe2_ad(i,k+1) = pe2_ad(i,k+1)+delp_ae(i,j,k)
      pe2_ad(i,k) = pe2_ad(i,k)-delp_ae(i,j,k)
      delp_ae(i,j,k) = 0.d0
    end do
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      do i = i1, i2
        delp_ae(i,j,k) = 0.d0
      end do
    end do
  endif
  do i = i1, i2
    pe1_ad(i,km+1) = pe1_ad(i,km+1)+ps_ae(i,j)
    ps_ae(i,j) = 0.d0
  end do
  do k = 2, km+1
    do i = i1, i2
      pe1_ad(i,k) = pe1_ad(i,k)+pe0_ad(i,k)
      pe0_ad(i,k) = -pe0_ad(i,k)
    end do
  end do
  pe1w_ad(km+1) = pe1w_ad(km+1)+pe2w_ad(km+1)
  pe2w_ad(km+1) = 0.d0
  do k = ks+2, km
    pe1w_ad(km+1) = pe1w_ad(km+1)+pe2w_ad(k)*bk(k)
    pe2w_ad(k) = 0.d0
  end do
  do i = i1, i2
    pe1_ad(i,km+1) = pe1_ad(i,km+1)+pe2_ad(i,km+1)
    pe2_ad(i,km+1) = 0.d0
    ps_ae(i,j) = ps_ae(i,j)+pe0_ad(i,km+1)
    pe0_ad(i,km+1) = 0.d0
  end do
  do k = ks+2, km
    do i = i1, i2
      pe1_ad(i,km+1) = pe1_ad(i,km+1)+pe2_ad(i,k)*bk(k)
      pe2_ad(i,k) = 0.d0
      ps_ae(i,j) = ps_ae(i,j)+pe0_ad(i,k)*bk(k)
      pe0_ad(i,k) = 0.d0
    end do
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe3_ad(i,k) = 0.d0
      pe2_ad(i,k) = 0.d0
      pe0_ad(i,k) = 0.d0
    end do
  end do
  do k = 1, km+1
    if (i1 .eq. 1) then
      pe_ae(im,k,j) = pe_ae(im,k,j)+pe1w_ad(k)
      pe1w_ad(k) = 0.d0
    else
      pe_ae(i1-1,k,j) = pe_ae(i1-1,k,j)+pe1w_ad(k)
      pe1w_ad(k) = 0.d0
    endif
    do i = i1, i2
      pe_ae(i,k,j) = pe_ae(i,k,j)+pe1_ad(i,k)
      pe1_ad(i,k) = 0.d0
    end do
  end do
end do
call mp_recv_pe_ad( im,jm,jfirst,jlast,1,help_i,pesouth_ad )
pt(:,:,:) = pth(:,:,:)
pkz = te_map_tape_pkz_2h(:,:,:,te_map_tape_rec+1)
u = te_map_tape_u_6h(:,:,:,te_map_tape_rec+1)
v = te_map_tape_v_7h(:,:,:,te_map_tape_rec+1)
#ifdef USE_OPENMP
pk_aeh(:,:,:) = pk_ae(:,:,:)
!$omp parallel do shared(cp,dz_ad,im,jfirst,jlast,jm,jn2g0,js2g0,km,pk,pk_aeh,pkz,pkz_ae,pt,pt_ae,te_ad,u,u_ae,v,v_ae) private(i,j,&
!$omp& k,pk_ae,t2,t2_ad,te_np_ad,te_sp_ad,u2_ad,v2_ad)
#endif /* ! USE_OPENMP */
do k = 1, km
#ifdef USE_OPENMP
  pk_ae(:,:,:) = 0.d0
#endif /* ! USE_OPENMP */
  t2_ad(:,:) = 0.d0
  te_np_ad = 0.d0
  te_sp_ad = 0.d0
  u2_ad(:,:) = 0.d0
  v2_ad(:,:) = 0.d0
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      pk_ae(i,j,k+1) = pk_ae(i,j,k+1)+dz_ad(i,j,k)*t2(i,j)
      pk_ae(i,j,k) = pk_ae(i,j,k)-dz_ad(i,j,k)*t2(i,j)
      t2_ad(i,j) = t2_ad(i,j)+dz_ad(i,j,k)*(pk(i,j,k+1)-pk(i,j,k))
      dz_ad(i,j,k) = 0.d0
    end do
  end do
  if (jlast .eq. jm) then
    do i = 1, im
      te_np_ad = te_np_ad+te_ad(i,jm,k)
      te_ad(i,jm,k) = 0.d0
    end do
    pkz_ae(1,jm,k) = pkz_ae(1,jm,k)+te_np_ad*t2(1,jm)
    t2_ad(1,jm) = t2_ad(1,jm)+te_np_ad*pkz(1,jm,k)
    te_np_ad = te_np_ad*(0.5/float(im))
    do i = 1, im
      u2_ad(i,jm) = u2_ad(i,jm)+te_np_ad
      v2_ad(i,jm-1) = v2_ad(i,jm-1)+te_np_ad
    end do
    te_np_ad = 0.d0
  endif
  if (jfirst .eq. 1) then
    do i = 1, im
      te_sp_ad = te_sp_ad+te_ad(i,1,k)
      te_ad(i,1,k) = 0.d0
    end do
    pkz_ae(1,1,k) = pkz_ae(1,1,k)+te_sp_ad*t2(1,1)
    t2_ad(1,1) = t2_ad(1,1)+te_sp_ad*pkz(1,1,k)
    te_sp_ad = te_sp_ad*(0.5/float(im))
    do i = 1, im
      u2_ad(i,2) = u2_ad(i,2)+te_sp_ad
      v2_ad(i,2) = v2_ad(i,2)+te_sp_ad
    end do
    te_sp_ad = 0.d0
  endif
  do j = js2g0, jn2g0
    pkz_ae(im,j,k) = pkz_ae(im,j,k)+te_ad(im,j,k)*t2(im,j)
    t2_ad(im,j) = t2_ad(im,j)+te_ad(im,j,k)*pkz(im,j,k)
    u2_ad(im,j+1) = u2_ad(im,j+1)+0.25*te_ad(im,j,k)
    u2_ad(im,j) = u2_ad(im,j)+0.25*te_ad(im,j,k)
    v2_ad(im,j) = v2_ad(im,j)+0.25*te_ad(im,j,k)
    v2_ad(1,j) = v2_ad(1,j)+0.25*te_ad(im,j,k)
    te_ad(im,j,k) = 0.d0
    do i = 1, im-1
      pkz_ae(i,j,k) = pkz_ae(i,j,k)+te_ad(i,j,k)*t2(i,j)
      t2_ad(i,j) = t2_ad(i,j)+te_ad(i,j,k)*pkz(i,j,k)
      u2_ad(i,j+1) = u2_ad(i,j+1)+0.25*te_ad(i,j,k)
      u2_ad(i,j) = u2_ad(i,j)+0.25*te_ad(i,j,k)
      v2_ad(i+1,j) = v2_ad(i+1,j)+0.25*te_ad(i,j,k)
      v2_ad(i,j) = v2_ad(i,j)+0.25*te_ad(i,j,k)
      te_ad(i,j,k) = 0.d0
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      pt_ae(i,j,k) = pt_ae(i,j,k)+t2_ad(i,j)*cp
      t2_ad(i,j) = 0.d0
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v_ae(i,j,k) = v_ae(i,j,k)+2*v2_ad(i,j)*v(i,j,k)
      v2_ad(i,j) = 0.d0
    end do
  end do
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u_ae(i,j,k) = u_ae(i,j,k)+2*u2_ad(i,j)*u(i,j,k)
      u2_ad(i,j) = 0.d0
    end do
  end do
#ifdef USE_OPENMP
  !$omp critical  (adtaf)
  pk_aeh(:,:,:) = pk_aeh(:,:,:)+pk_ae(:,:,:)
  !$omp end critical (adtaf)
#endif /* ! USE_OPENMP */
end do
#ifdef USE_OPENMP
pk_ae(:,:,:) = pk_aeh(:,:,:)
#endif /* ! USE_OPENMP */
call mp_send_pe_ad( im,jm,jfirst,jlast,1,help_h,pe_ae )
call mp_recv_n_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_ae )
pe(:,:,:) = peh(:,:,:)
pk(:,:,:) = pkh(:,:,:)
call pkez_ad( nx,im,km,jfirst,jlast,pe,pe_ae,pk,pk_ae,akap,ks,peln,peln_ad,pkz_ae, .false.  )
call mp_send_s_ad( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u_ae )

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine te_map_ad


subroutine te_mapmd( consv, convt, ps, omga, pe, delp, pkz, pk, mdt, im, jm, km, nx, jfirst, jlast, nq, u, v, pt, q, hs, cp, akap, &
&kord, peln, te0, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mod_comm, only : mp_barrier, mp_recv_n, mp_recv_pe, mp_send_pe, mp_send_s
use te_map_ad_store, only : te_map_tape_delp_15h,te_map_tape_dtmp_18h,te_map_tape_dz_8h,te_map_tape_pe_14h,te_map_tape_peln_12h,&
&te_map_tape_pk_1h,te_map_tape_pkz_13h,te_map_tape_pkz_2h,te_map_tape_te_11h,te_map_tape_te_19h,te_map_tape_te_9h,&
&te_map_tape_te_map,te_map_tape_tsum_16h,te_map_tape_u_17h,te_map_tape_u_6h,te_map_tape_v_10h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: mdt
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: omga(im,km,jfirst:jlast)
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: dak
real(kind=r8) :: dlnp
real(kind=r8) :: dtmp
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
integer :: help_h
integer :: help_i
integer :: help_j
integer :: help_k
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te_np
real(kind=r8) :: te_sp
real(kind=r8) :: tsum
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: u2(im,jfirst:jlast+1)
real(kind=r8) :: v2(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: ysum

!**********************************************
! executable statements of routine
!**********************************************
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .false.  )
if ( .not. allocated(te_map_tape_pk_1h)) then
  allocate( te_map_tape_pk_1h(1:im,1:1+jlast-jfirst,1:1+km,te_map_tape_te_map) )
endif
te_map_tape_pk_1h(:,:,:,te_map_tape_rec+1) = pk
if ( .not. allocated(te_map_tape_pkz_2h)) then
  allocate( te_map_tape_pkz_2h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_pkz_2h(:,:,:,te_map_tape_rec+1) = pkz
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
help_h = km+1
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe )
if ( .not. allocated(te_map_tape_u_6h)) then
  allocate( te_map_tape_u_6h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,te_map_tape_te_map) )
endif
te_map_tape_u_6h(:,:,:,te_map_tape_rec+1) = u
if ( .not. allocated(te_map_tape_v_7h)) then
  allocate( te_map_tape_v_7h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,te_map_tape_te_map) )
endif
te_map_tape_v_7h(:,:,:,te_map_tape_rec+1) = v
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,t2,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = 0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))+t2(i,j)*pkz(i,j,k)
    end do
    te(im,j,k) = 0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))+t2(im,j)*pkz(im,j,k)
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = 0.5*te_sp/float(im)+t2(1,1)*pkz(1,1,k)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = 0.5*te_np/float(im)+t2(1,jm)*pkz(1,jm,k)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
  do j = jfirst, jlast
    do i = 1, im
      dz(i,j,k) = t2(i,j)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do
if ( .not. allocated(te_map_tape_dz_8h)) then
  allocate( te_map_tape_dz_8h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1) = dz
if ( .not. allocated(te_map_tape_te_9h)) then
  allocate( te_map_tape_te_9h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_9h(:,:,:,te_map_tape_rec+1) = te
help_i = km+1
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth )
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do private(bkh,dak,help_j,help_k,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,pe2w,pe3,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    ps(i,j) = pe1(i,km+1)
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      dak = ak(k+1)-ak(k)
      do i = i1, i2
        delp(i,j,k) = dak
      end do
    end do
  endif
  do k = ks+1, km
    do i = i1, i2
      delp(i,j,k) = pe2(i,k+1)-pe2(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  call map1_ppm( km,pe1,te,km,pe2,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm( km,pe1,q,nq,km,pe2,q,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    else
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pesouth(i,k))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pesouth(i,km+1))
        end do
      end do
    endif
    help_j = -1
    call map1_ppm( km,pe0,u,km,pe3,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_j,kord )
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_k = -1
    call map1_ppm( km,pe0,v,km,pe3,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_k,kord )
  endif
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
call mp_send_s( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
if ( .not. allocated(te_map_tape_v_10h)) then
  allocate( te_map_tape_v_10h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,te_map_tape_te_map) )
endif
te_map_tape_v_10h(:,:,:,te_map_tape_rec+1) = v
if ( .not. allocated(te_map_tape_te_11h)) then
  allocate( te_map_tape_te_11h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_11h(:,:,:,te_map_tape_rec+1) = te
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .true.  )
if ( .not. allocated(te_map_tape_peln_12h)) then
  allocate( te_map_tape_peln_12h(1:im,1:1+km,1:1+jlast-jfirst,te_map_tape_te_map) )
endif
te_map_tape_peln_12h(:,:,:,te_map_tape_rec+1) = peln
if ( .not. allocated(te_map_tape_pkz_13h)) then
  allocate( te_map_tape_pkz_13h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_pkz_13h(:,:,:,te_map_tape_rec+1) = pkz
if ( .not. allocated(te_map_tape_pe_14h)) then
  allocate( te_map_tape_pe_14h(1:im,1:1+km,1:1+jlast-jfirst,te_map_tape_te_map) )
endif
te_map_tape_pe_14h(:,:,:,te_map_tape_rec+1) = pe
if ( .not. allocated(te_map_tape_delp_15h)) then
  allocate( te_map_tape_delp_15h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_delp_15h(:,:,:,te_map_tape_rec+1) = delp
if (consv) then
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,xsum,ysum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = te_acap*cp*(ps(1,1)-2.*te_ptop-akap*te_ptop*(peln(1,km+1,1)-peln(1,1,1)))
    else if (j .eq. jm) then
      tte(jm) = te_acap*cp*(ps(1,jm)-akap*te_ptop*(peln(1,km+1,jm)-peln(1,1,jm)))
    else
      xsum = 0.
      ysum = 0.
      do i = 1, im
        xsum = xsum+ps(i,j)
        ysum = ysum+peln(i,km+1,j)
      end do
      tte(j) = cp*te_cosp(j)*(xsum-te_ptop*im-akap*te_ptop*(ysum-peln(1,1,j)*im))
    endif
  end do
  call par_vecsum( jm,jfirst,jlast,tte,tsum )
  if ( .not. allocated(te_map_tape_tsum_16h)) then
    allocate( te_map_tape_tsum_16h(te_map_tape_te_map) )
  endif
  te_map_tape_tsum_16h(te_map_tape_rec+1) = tsum
  dtmp = (te0-te1)/tsum
else
  dtmp = 0.
endif
call mp_recv_n( im,jm,jfirst,jlast,1,km,ng_d,ng_s,u )
if ( .not. allocated(te_map_tape_u_17h)) then
  allocate( te_map_tape_u_17h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,te_map_tape_te_map) )
endif
te_map_tape_u_17h(:,:,:,te_map_tape_rec+1) = u
if ( .not. allocated(te_map_tape_dtmp_18h)) then
  allocate( te_map_tape_dtmp_18h(te_map_tape_te_map) )
endif
te_map_tape_dtmp_18h(te_map_tape_rec+1) = dtmp
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = te(i,j,k)-0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))
    end do
    te(im,j,k) = te(im,j,k)-0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = te(1,1,k)-0.5*te_sp/float(im)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = te(1,jm,k)-0.5*te_np/float(im)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
end do
if ( .not. allocated(te_map_tape_te_19h)) then
  allocate( te_map_tape_te_19h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_19h(:,:,:,te_map_tape_rec+1) = te
#ifdef USE_OPENMP
!$omp parallel do private(dlnp,gz,i,i1,i2,ixj,j,k,rg,tvm) ! broadcast()
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)/pkz(i,j,k)
      end do
    endif
  end do
end do
end subroutine te_mapmd


end module     mapz_module_ad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     te_map_ad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real(kind=8), allocatable :: te_map_tape_delp_15h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_dtmp_18h(:)
real(kind=8), allocatable :: te_map_tape_dz_8h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pe_14h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_peln_12h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pk_1h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pkz_13h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_pkz_2h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_11h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_19h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_te_9h(:,:,:,:)
integer :: te_map_tape_te_map
real(kind=8), allocatable :: te_map_tape_tsum_16h(:)
real(kind=8), allocatable :: te_map_tape_u_17h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_u_6h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_v_10h(:,:,:,:)
real(kind=8), allocatable :: te_map_tape_v_7h(:,:,:,:)

end module     te_map_ad_store


module     mapz_module_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use mapz_module
!#ifdef TIMING
use timingmodule, only: timing_on, timing_off
!#endif

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine kmppm_ad( dm, dm_ad, a4, a4_ad, im, lmt )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r12 = 1./12.

!==============================================
! declare arguments
!==============================================
integer :: im
real(kind=r8) :: a4(4,im)
real(kind=r8) :: a4_ad(4,im)
real(kind=r8) :: dm(im)
real(kind=r8) :: dm_ad(im)
integer :: lmt

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a4h(4,im)
real(kind=r8) :: a6da
real(kind=r8) :: a6da_ad
real(kind=r8) :: da1
real(kind=r8) :: da1_ad
real(kind=r8) :: da2
real(kind=r8) :: da2_ad
real(kind=r8) :: fmin
real(kind=r8) :: fmin_ad
integer :: i
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
a4h(:,:) = a4(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a6da_ad = 0.d0
da1_ad = 0.d0
da2_ad = 0.d0
fmin_ad = 0.d0
qmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (lmt .ne. 3) then
  if (lmt .eq. 0) then
    do i = 1, im
      a6da_ad = 0.d0
      da1_ad = 0.d0
      da2_ad = 0.d0
      if (dm(i) .eq. 0.) then
        a4_ad(4,i) = 0.d0
        a4_ad(1,i) = a4_ad(1,i)+a4_ad(3,i)
        a4_ad(3,i) = 0.d0
        a4_ad(1,i) = a4_ad(1,i)+a4_ad(2,i)
        a4_ad(2,i) = 0.d0
      else
        da1 = a4(3,i)-a4(2,i)
        da2 = da1**2
        a6da = a4(4,i)*da1
        if (a6da .lt. (-da2)) then
          a4_ad(4,i) = a4_ad(4,i)-a4_ad(3,i)
          a4_ad(2,i) = a4_ad(2,i)+a4_ad(3,i)
          a4_ad(3,i) = 0.d0
          a4_ad(2,i) = a4_ad(2,i)+3*a4_ad(4,i)
          a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
          a4_ad(4,i) = 0.d0
        else if (a6da .gt. da2) then
          a4_ad(4,i) = a4_ad(4,i)-a4_ad(2,i)
          a4_ad(3,i) = a4_ad(3,i)+a4_ad(2,i)
          a4_ad(2,i) = 0.d0
          a4_ad(3,i) = a4_ad(3,i)+3*a4_ad(4,i)
          a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
          a4_ad(4,i) = 0.d0
        endif
        a4_ad(4,i) = a4_ad(4,i)+a6da_ad*da1
        da1_ad = da1_ad+a6da_ad*a4(4,i)
        a6da_ad = 0.d0
        da1_ad = da1_ad+2*da2_ad*da1
        da2_ad = 0.d0
        a4_ad(3,i) = a4_ad(3,i)+da1_ad
        a4_ad(2,i) = a4_ad(2,i)-da1_ad
        da1_ad = 0.d0
      endif
    end do
  else if (lmt .eq. 1) then
    do i = 1, im
      qmp_ad = 0.d0
      qmp = 2.*dm(i)
      a4(2,i) = a4(1,i)-sign(min(abs(qmp),abs(a4(2,i)-a4(1,i))),qmp)
      a4_ad(3,i) = a4_ad(3,i)-3*a4_ad(4,i)
      a4_ad(2,i) = a4_ad(2,i)-3*a4_ad(4,i)
      a4_ad(1,i) = a4_ad(1,i)+6*a4_ad(4,i)
      a4_ad(4,i) = 0.d0
      qmp_ad = qmp_ad+a4_ad(3,i)*(0.5+sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4_ad(1,i) = a4_ad(1,i)+a4_ad(3,i)*(1-(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,&
&i))*sign(1.d0,min(abs(qmp),abs(a4(3,i)-a4(1,i)))))
      a4_ad(3,i) = a4_ad(3,i)*(0.5-sign(0.5d0,abs(a4(3,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(3,i)-a4(1,i))*sign(1.d0,&
&min(abs(qmp),abs(a4(3,i)-a4(1,i))))
      a4(:,:) = a4h(:,:)
      qmp_ad = qmp_ad-a4_ad(2,i)*(0.5+sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,qmp)*sign(1.d0,&
&min(abs(qmp),abs(a4(2,i)-a4(1,i))))
      a4_ad(1,i) = a4_ad(1,i)+a4_ad(2,i)*(1+(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,&
&i))*sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      a4_ad(2,i) = -(a4_ad(2,i)*(0.5-sign(0.5d0,abs(a4(2,i)-a4(1,i))-abs(qmp)))*sign(1.d0,qmp)*sign(1.d0,a4(2,i)-a4(1,i))*&
&sign(1.d0,min(abs(qmp),abs(a4(2,i)-a4(1,i)))))
      dm_ad(i) = dm_ad(i)+2*qmp_ad
      qmp_ad = 0.d0
    end do
  else if (lmt .eq. 2) then
    do i = 1, im
      fmin_ad = 0.d0
      if (abs(a4(3,i)-a4(2,i)) .lt. (-a4(4,i))) then
        fmin = a4(1,i)+0.25*(a4(3,i)-a4(2,i))**2/a4(4,i)+a4(4,i)*r12
        if (fmin .lt. 0.) then
          if (a4(1,i) .lt. a4(3,i) .and. a4(1,i) .lt. a4(2,i)) then
            a4_ad(4,i) = 0.d0
            a4_ad(1,i) = a4_ad(1,i)+a4_ad(2,i)
            a4_ad(2,i) = 0.d0
            a4_ad(1,i) = a4_ad(1,i)+a4_ad(3,i)
            a4_ad(3,i) = 0.d0
          else if (a4(3,i) .gt. a4(2,i)) then
            a4_ad(4,i) = a4_ad(4,i)-a4_ad(3,i)
            a4_ad(2,i) = a4_ad(2,i)+a4_ad(3,i)
            a4_ad(3,i) = 0.d0
            a4_ad(2,i) = a4_ad(2,i)+3*a4_ad(4,i)
            a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
            a4_ad(4,i) = 0.d0
          else
            a4_ad(4,i) = a4_ad(4,i)-a4_ad(2,i)
            a4_ad(3,i) = a4_ad(3,i)+a4_ad(2,i)
            a4_ad(2,i) = 0.d0
            a4_ad(3,i) = a4_ad(3,i)+3*a4_ad(4,i)
            a4_ad(1,i) = a4_ad(1,i)-3*a4_ad(4,i)
            a4_ad(4,i) = 0.d0
          endif
        endif
        a4_ad(4,i) = a4_ad(4,i)+fmin_ad*((-(0.25*(a4(3,i)-a4(2,i))**2/(a4(4,i)*a4(4,i))))+r12)
        a4_ad(3,i) = a4_ad(3,i)+fmin_ad*(0.5*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_ad(2,i) = a4_ad(2,i)+fmin_ad*((-0.5)*(a4(3,i)-a4(2,i))/a4(4,i))
        a4_ad(1,i) = a4_ad(1,i)+fmin_ad
        fmin_ad = 0.d0
      endif
    end do
  endif
endif

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine kmppm_ad


subroutine map1_ppm_ad( km, pe1, pe1_ad, q1, q1_ad, kn, pe2, pe2_ad, q2_ad, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1_ad(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: pe2_ad(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km)
real(kind=r8) :: q1_ad(im,jfirst-ng_s:jlast+ng_n,km)
real(kind=r8) :: q2_ad(im,jfirst-ng_s:jlast+ng_n,kn)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: delp_ae
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: dp1_ad(i1:i2,km)
real(kind=r8) :: esl
real(kind=r8) :: esl_ad
integer :: i
integer :: ikind
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pl_ad
real(kind=r8) :: pr
real(kind=r8) :: pr_ad
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_ad(4,i1:i2,km)
real(kind=r8) :: qsum
real(kind=r8) :: qsum_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
delp_ae = 0.d0
dp1_ad(:,:) = 0.d0
esl_ad = 0.d0
pl_ad = 0.d0
pr_ad = 0.d0
q4_ad(:,:,:) = 0.d0
qsum_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
    q4(1,i,k) = q1(i,j,k)
  end do
end do
call ppm2m( q4,dp1,km,i1,i2,iv,kord )
do i = i1, i2
  k0 = 1
  do k = 1, kn
    ikind = 0
    do l = k0, km
      if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
        if (pe2(i,k+1) .le. pe1(i,l+1)) then
          ikind = 1
          exit
        else
          ikind = 2
          exit
        endif
      endif
    end do
    if (ikind .eq. 0) then
    else if (ikind .eq. 1) then
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
      pl_ad = pl_ad+q2_ad(i,j,k)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(pr+2*pl))
      pr_ad = pr_ad+q2_ad(i,j,k)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(2*pr+pl))
      q4_ad(4,i,l) = q4_ad(4,i,l)+q2_ad(i,j,k)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))
      q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*q2_ad(i,j,k)*(pr+pl)
      q4_ad(2,i,l) = q4_ad(2,i,l)+q2_ad(i,j,k)*(1+(-0.5)*(pr+pl))
      q2_ad(i,j,k) = 0.d0
      dp1_ad(i,l) = dp1_ad(i,l)-pr_ad*((pe2(i,k+1)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
      pe1_ad(i,l) = pe1_ad(i,l)-pr_ad/dp1(i,l)
      pe2_ad(i,k+1) = pe2_ad(i,k+1)+pr_ad/dp1(i,l)
      pr_ad = 0.d0
      dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
      pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
      pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
      pl_ad = 0.d0
    else
      pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
      qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      do ll = l+1, km
        if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
        else
          lf = ll
          exit
        endif
      end do
      if (lf .eq. 0) then
        do ll = l+1, km
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
      else
        do ll = l+1, lf-1
          qsum = qsum+dp1(i,ll)*q4(1,i,ll)
        end do
        ll = lf
        delp = pe2(i,k+1)-pe1(i,ll)
        esl = delp/dp1(i,ll)
        qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
      endif
      pe2_ad(i,k+1) = pe2_ad(i,k+1)-q2_ad(i,j,k)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
      pe2_ad(i,k) = pe2_ad(i,k)+q2_ad(i,j,k)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
      qsum_ad = qsum_ad+q2_ad(i,j,k)/(pe2(i,k+1)-pe2(i,k))
      q2_ad(i,j,k) = 0.d0
      if (lf .eq. 0) then
        do ll = l+1, km
          dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
          q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
        end do
      else
        delp_ae = delp_ae+qsum_ad*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        esl_ad = esl_ad+qsum_ad*delp*((-(0.5*esl*q4(4,i,ll)*r23))+0.5*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        q4_ad(4,i,ll) = q4_ad(4,i,ll)+0.5*qsum_ad*delp*esl*(1.-r23*esl)
        q4_ad(3,i,ll) = q4_ad(3,i,ll)+0.5*qsum_ad*delp*esl
        q4_ad(2,i,ll) = q4_ad(2,i,ll)+qsum_ad*delp*(1+(-0.5)*esl)
        delp_ae = delp_ae+esl_ad/dp1(i,ll)
        dp1_ad(i,ll) = dp1_ad(i,ll)-esl_ad*(delp/(dp1(i,ll)*dp1(i,ll)))
        esl_ad = 0.d0
        pe1_ad(i,ll) = pe1_ad(i,ll)-delp_ae
        pe2_ad(i,k+1) = pe2_ad(i,k+1)+delp_ae
        delp_ae = 0.d0
        do ll = l+1, lf-1
          dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
          q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
        end do
      endif
      pe1_ad(i,l+1) = pe1_ad(i,l+1)+qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      pe2_ad(i,k) = pe2_ad(i,k)-qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
      pl_ad = pl_ad+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(1+2*pl))
      q4_ad(4,i,l) = q4_ad(4,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))
      q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1.+pl)
      q4_ad(2,i,l) = q4_ad(2,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
      qsum_ad = 0.d0
      dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
      pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
      pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
      pl_ad = 0.d0
    endif
  end do
end do
do k = 1, km
  do i = i1, i2
    q4(1,i,k) = q1(i,j,k)
  end do
end do
call ppm2m_ad( q4,q4_ad,dp1,dp1_ad,km,i1,i2,iv,kord )
do k = 1, km
  do i = i1, i2
    q1_ad(i,j,k) = q1_ad(i,j,k)+q4_ad(1,i,k)
    q4_ad(1,i,k) = 0.d0
    pe1_ad(i,k+1) = pe1_ad(i,k+1)+dp1_ad(i,k)
    pe1_ad(i,k) = pe1_ad(i,k)-dp1_ad(i,k)
    dp1_ad(i,k) = 0.d0
  end do
end do

end subroutine map1_ppm_ad


subroutine mapn_ppm_ad( km, pe1, pe1_ad, q1, q1_ad, nq, kn, pe2, pe2_ad, q2_ad, ng_s, ng_n, im, i1, i2, j, jfirst, jlast, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: r23 = 2./3.
real(kind=r8), parameter :: r3 = 1./3.

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: im
integer :: iv
integer :: j
integer :: jfirst
integer :: jlast
integer :: km
integer :: kn
integer :: kord
integer :: ng_n
integer :: ng_s
integer :: nq
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1_ad(im,km+1)
real(kind=r8) :: pe2(im,kn+1)
real(kind=r8) :: pe2_ad(im,kn+1)
real(kind=r8) :: q1(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q1_ad(im,jfirst-ng_s:jlast+ng_n,km,nq)
real(kind=r8) :: q2_ad(im,jfirst-ng_s:jlast+ng_n,kn,nq)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: delp
real(kind=r8) :: delp_ae
real(kind=r8) :: dp1(i1:i2,km)
real(kind=r8) :: dp1_ad(i1:i2,km)
real(kind=r8) :: esl
real(kind=r8) :: esl_ad
integer :: i
integer :: ikind
integer :: iq
integer :: k
integer :: k0
integer :: l
integer :: lf
integer :: ll
real(kind=r8) :: pl
real(kind=r8) :: pl_ad
real(kind=r8) :: pr
real(kind=r8) :: pr_ad
real(kind=r8) :: q4(4,i1:i2,km)
real(kind=r8) :: q4_ad(4,i1:i2,km)
real(kind=r8) :: qsum
real(kind=r8) :: qsum_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
delp_ae = 0.d0
dp1_ad(:,:) = 0.d0
esl_ad = 0.d0
pl_ad = 0.d0
pr_ad = 0.d0
q4_ad(:,:,:) = 0.d0
qsum_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 1, km
  do i = i1, i2
    dp1(i,k) = pe1(i,k+1)-pe1(i,k)
  end do
end do
do iq = nq, 1, -1
  do k = 1, km
    do i = i1, i2
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  call ppm2m( q4,dp1,km,i1,i2,iv,kord )
  do i = i1, i2
    k0 = 1
    do k = 1, kn
      ikind = 0
      do l = k0, km
        if (pe2(i,k) .ge. pe1(i,l) .and. pe2(i,k) .le. pe1(i,l+1)) then
          if (pe2(i,k+1) .le. pe1(i,l+1)) then
            ikind = 1
            exit
          else
            ikind = 2
            exit
          endif
        endif
      end do
      if (ikind .eq. 0) then
      else if (ikind .eq. 1) then
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        pr = (pe2(i,k+1)-pe1(i,l))/dp1(i,l)
        pl_ad = pl_ad+q2_ad(i,j,k,iq)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(pr+2*pl))
        pr_ad = pr_ad+q2_ad(i,j,k,iq)*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(2*pr+pl))
        q4_ad(4,i,l) = q4_ad(4,i,l)+q2_ad(i,j,k,iq)*(0.5*(pr+pl)-r3*(pr*(pr+pl)+pl**2))
        q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*q2_ad(i,j,k,iq)*(pr+pl)
        q4_ad(2,i,l) = q4_ad(2,i,l)+q2_ad(i,j,k,iq)*(1+(-0.5)*(pr+pl))
        q2_ad(i,j,k,iq) = 0.d0
        dp1_ad(i,l) = dp1_ad(i,l)-pr_ad*((pe2(i,k+1)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
        pe1_ad(i,l) = pe1_ad(i,l)-pr_ad/dp1(i,l)
        pe2_ad(i,k+1) = pe2_ad(i,k+1)+pr_ad/dp1(i,l)
        pr_ad = 0.d0
        dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
        pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
        pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
        pl_ad = 0.d0
      else
        pl = (pe2(i,k)-pe1(i,l))/dp1(i,l)
        qsum = (pe1(i,l+1)-pe2(i,k))*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        do ll = l+1, km
          if (pe2(i,k+1) .gt. pe1(i,ll+1)) then
          else
            lf = ll
            exit
          endif
        end do
        if (lf .eq. 0) then
          do ll = l+1, km
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
        else
          do ll = l+1, lf-1
            qsum = qsum+dp1(i,ll)*q4(1,i,ll)
          end do
          ll = lf
          delp = pe2(i,k+1)-pe1(i,ll)
          esl = delp/dp1(i,ll)
          qsum = qsum+delp*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
        endif
        pe2_ad(i,k+1) = pe2_ad(i,k+1)-q2_ad(i,j,k,iq)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
        pe2_ad(i,k) = pe2_ad(i,k)+q2_ad(i,j,k,iq)*(qsum/((pe2(i,k+1)-pe2(i,k))*(pe2(i,k+1)-pe2(i,k))))
        qsum_ad = qsum_ad+q2_ad(i,j,k,iq)/(pe2(i,k+1)-pe2(i,k))
        q2_ad(i,j,k,iq) = 0.d0
        if (lf .eq. 0) then
          do ll = l+1, km
            dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
            q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
          end do
        else
          delp_ae = delp_ae+qsum_ad*(q4(2,i,ll)+0.5*esl*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
          esl_ad = esl_ad+qsum_ad*delp*((-(0.5*esl*q4(4,i,ll)*r23))+0.5*(q4(3,i,ll)-q4(2,i,ll)+q4(4,i,ll)*(1.-r23*esl)))
          q4_ad(4,i,ll) = q4_ad(4,i,ll)+0.5*qsum_ad*delp*esl*(1.-r23*esl)
          q4_ad(3,i,ll) = q4_ad(3,i,ll)+0.5*qsum_ad*delp*esl
          q4_ad(2,i,ll) = q4_ad(2,i,ll)+qsum_ad*delp*(1+(-0.5)*esl)
          delp_ae = delp_ae+esl_ad/dp1(i,ll)
          dp1_ad(i,ll) = dp1_ad(i,ll)-esl_ad*(delp/(dp1(i,ll)*dp1(i,ll)))
          esl_ad = 0.d0
          pe1_ad(i,ll) = pe1_ad(i,ll)-delp_ae
          pe2_ad(i,k+1) = pe2_ad(i,k+1)+delp_ae
          delp_ae = 0.d0
          do ll = l+1, lf-1
            dp1_ad(i,ll) = dp1_ad(i,ll)+qsum_ad*q4(1,i,ll)
            q4_ad(1,i,ll) = q4_ad(1,i,ll)+qsum_ad*dp1(i,ll)
          end do
        endif
        pe1_ad(i,l+1) = pe1_ad(i,l+1)+qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        pe2_ad(i,k) = pe2_ad(i,k)-qsum_ad*(q4(2,i,l)+0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))*(1.+pl)-q4(4,i,l)*r3*(1.+pl*(1.+pl)))
        pl_ad = pl_ad+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(q4(4,i,l)+q4(3,i,l)-q4(2,i,l))-q4(4,i,l)*r3*(1+2*pl))
        q4_ad(4,i,l) = q4_ad(4,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(0.5*(1.+pl)-r3*(1.+pl*(1.+pl)))
        q4_ad(3,i,l) = q4_ad(3,i,l)+0.5*qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1.+pl)
        q4_ad(2,i,l) = q4_ad(2,i,l)+qsum_ad*(pe1(i,l+1)-pe2(i,k))*(1+(-0.5)*(1.+pl))
        qsum_ad = 0.d0
        dp1_ad(i,l) = dp1_ad(i,l)-pl_ad*((pe2(i,k)-pe1(i,l))/(dp1(i,l)*dp1(i,l)))
        pe1_ad(i,l) = pe1_ad(i,l)-pl_ad/dp1(i,l)
        pe2_ad(i,k) = pe2_ad(i,k)+pl_ad/dp1(i,l)
        pl_ad = 0.d0
      endif
    end do
  end do
  do k = 1, km
    do i = i1, i2
      q4(1,i,k) = q1(i,j,k,iq)
    end do
  end do
  call ppm2m_ad( q4,q4_ad,dp1,dp1_ad,km,i1,i2,iv,kord )
  do k = 1, km
    do i = i1, i2
      q1_ad(i,j,k,iq) = q1_ad(i,j,k,iq)+q4_ad(1,i,k)
      q4_ad(1,i,k) = 0.d0
    end do
  end do
end do
do k = 1, km
  do i = i1, i2
    pe1_ad(i,k+1) = pe1_ad(i,k+1)+dp1_ad(i,k)
    pe1_ad(i,k) = pe1_ad(i,k)-dp1_ad(i,k)
    dp1_ad(i,k) = 0.d0
  end do
end do

end subroutine mapn_ppm_ad


subroutine ppm2m_ad( a4, a4_ad, delp, delp_ae, km, i1, i2, iv, kord )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ad(4,i1:i2,km)
real(kind=r8) :: delp(i1:i2,km)
real(kind=r8) :: delp_ae(i1:i2,km)
integer :: iv
integer :: kord

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: a1
real(kind=r8) :: a1_ad
real(kind=r8) :: a2
real(kind=r8) :: a2_ad
real(kind=r8) :: c1
real(kind=r8) :: c1_ad
real(kind=r8) :: c2
real(kind=r8) :: c2_ad
real(kind=r8) :: c3
real(kind=r8) :: c3_ad
real(kind=r8) :: cmax
real(kind=r8) :: cmax_ad
real(kind=r8) :: cmin
real(kind=r8) :: cmin_ad
real(kind=r8) :: d1
real(kind=r8) :: d1_ad
real(kind=r8) :: d2
real(kind=r8) :: d2_ad
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: d4_ad(i1:i2,km)
real(kind=r8) :: dc(i1:i2,km)
real(kind=r8) :: dc_ad(i1:i2,km)
double precision :: dci
double precision :: dci_ae
double precision :: dcj_ad
real(kind=r8) :: delq(i1:i2,km)
real(kind=r8) :: delq_ad(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ad(i1:i2,km)
real(kind=r8) :: dq
real(kind=r8) :: dq_ad
real(kind=r8) :: fac
real(kind=r8) :: h2(i1:i2,km)
real(kind=r8) :: h2_ad(i1:i2,km)
integer :: i
integer :: it
integer :: k
integer :: km1
real(kind=r8) :: lac
real(kind=r8) :: lac_ad
integer :: lmt
real(kind=r8) :: pmp
real(kind=r8) :: pmp_ad
real(kind=8) :: ppm2m_a4_10h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_11h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_12h(4,1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_13h(4,1+i2-i1,(-4)+km,1)
real(kind=8), allocatable :: ppm2m_a4_14h(:,:,:,:)
real(kind=8) :: ppm2m_a4_1h(1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_2h(2,1+i2-i1,km,1)
real(kind=8) :: ppm2m_a4_3h(1+i2-i1,3,1)
real(kind=8) :: ppm2m_a4_4h(1+i2-i1,2,1)
real(kind=8) :: ppm2m_a4_5h(1+i2-i1,1)
real(kind=8) :: ppm2m_a4_6h(1+i2-i1,2,1)
real(kind=8), allocatable :: ppm2m_a4_7h(:,:,:)
real(kind=8), allocatable :: ppm2m_a4_8h(:,:,:)
real(kind=8) :: ppm2m_a4_9h(1+i2-i1,1)
integer :: ppm2m_ppm2m
real(kind=r8) :: qm
real(kind=r8) :: qm_ad
real(kind=r8) :: qmax
real(kind=r8) :: qmax_ad
double precision :: qmaxj
double precision :: qmaxj_ad
real(kind=r8) :: qmin
real(kind=r8) :: qmin_ad
double precision :: qminj
double precision :: qminj_ad
double precision :: qmink_ad
real(kind=r8) :: qmp
real(kind=r8) :: qmp_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
a1_ad = 0.d0
a2_ad = 0.d0
c1_ad = 0.d0
c2_ad = 0.d0
c3_ad = 0.d0
cmax_ad = 0.d0
cmin_ad = 0.d0
d1_ad = 0.d0
d2_ad = 0.d0
d4_ad(:,:) = 0.d0
dc_ad(:,:) = 0.d0
delq_ad(:,:) = 0.d0
df2_ad(:,:) = 0.d0
dq_ad = 0.d0
h2_ad(:,:) = 0.d0
lac_ad = 0.d0
pmp_ad = 0.d0
qm_ad = 0.d0
qmax_ad = 0.d0
qmin_ad = 0.d0
qmp_ad = 0.d0
tmp_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
km1 = km-1
it = i2-i1+1
!----------------------------------------------
! OPEN TAPE ppm2m
!----------------------------------------------
ppm2m_ppm2m = 1

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    delq(i,k-1) = a4(1,i,k)-a4(1,i,k-1)
    d4(i,k) = delp(i,k-1)+delp(i,k)
  end do
end do
ppm2m_a4_1h(:,:,1) = a4(1,i1:i2,:)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
    df2(i,k) = tmp
  end do
end do
do k = 3, km1
  do i = i1, i2
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a4(2,i,k) = a4(1,i,k-1)+c1+2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-delp(i,k-1)*a1*dc(i,k))
  end do
end do
ppm2m_a4_2h(:,:,:,1) = a4(1:2,i1:i2,:)
call steepz( i1,i2,km,a4,df2,dc,delq,delp,d4 )
ppm2m_a4_3h(:,:,1) = a4(2,i1:i2,1:3)
ppm2m_a4_4h(:,:,1) = a4(1,i1:i2,1:2)
do i = i1, i2
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  dc(i,1) = a4(1,i,1)-a4(2,i,1)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  a4(2,i,2) = min(cmax,a4(2,i,2))
end do
ppm2m_a4_5h(:,1) = a4(1,i1:i2,1)
ppm2m_a4_6h(:,:,1) = a4(2,i1:i2,1:2)
if (iv .eq. 0) then
  do i = i1, i2
    a4(2,i,1) = a4(1,i,1)
    a4(3,i,1) = a4(1,i,1)
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4(2,i,1) = a4(1,i,1)
      a4(3,i,1) = a4(1,i,1)
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4(2,i,1) = 0.
      else
        a4(2,i,1) = sign(min(abs(a4(1,i,1)),abs(a4(2,i,1))),a4(1,i,1))
      endif
    end do
  endif
endif
if ( .not. allocated(ppm2m_a4_7h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_7h)) then
    allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_7h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_7h(:,:,1) = a4(1,i1:i2,km1:km)
if ( .not. allocated(ppm2m_a4_8h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_8h)) then
    allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_8h(1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_8h(:,:,1) = a4(2,i1:i2,km1:km)
ppm2m_a4_9h(:,1) = a4(3,i1:i2,km)
do i = i1, i2
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  dc(i,km) = a4(3,i,km)-a4(1,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  a4(2,i,km) = min(cmax,a4(2,i,km))
end do
ppm2m_a4_10h(:,1) = a4(1,i1:i2,km)
ppm2m_a4_11h(:,1) = a4(3,i1:i2,km)
if (iv .eq. 0) then
  do i = i1, i2
    a4(3,i,km) = max(0._8,a4(3,i,km))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4(3,i,km) = 0.
    else
      a4(3,i,km) = sign(min(abs(a4(1,i,km)),abs(a4(3,i,km))),a4(1,i,km))
    endif
  end do
endif
do k = 1, km1
  do i = i1, i2
    a4(3,i,k) = a4(2,i,k+1)
  end do
end do
ppm2m_a4_12h(:,:,:,1) = a4(:,i1:i2,1:2)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm( dc(i1,k),a4(1,i1,k),it,0 )
end do
ppm2m_a4_13h(:,:,:,1) = a4(:,i1:i2,3:km-2)
if (kord .ge. 7) then
  do k = 2, km1
    do i = i1, i2
      h2(i,k) = dc(i,k+1)-dc(i,k-1)
    end do
  end do
  if (kord .eq. 7) then
    fac = 1.5
  else
    fac = 0.125
  endif
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm( dc(i1,k),a4(1,i1,k),it,2 )
    endif
  end do
else
  lmt = kord-3
  lmt = max(0,lmt)
  if (iv .eq. 0) then
    lmt = min(2,lmt)
  endif
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm( dc(i1,k),a4(1,i1,k),it,lmt )
  end do
endif
if ( .not. allocated(ppm2m_a4_14h)) then
#ifdef USE_OPENMP
  !$omp critical  (store)
  if ( .not. allocated(ppm2m_a4_14h)) then
    allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
  endif
  !$omp end critical (store)
#else /* USE_OPENMP */
  allocate( ppm2m_a4_14h(1:4,1:1+i2-i1,1:1+km-km1,ppm2m_ppm2m) )
#endif /* USE_OPENMP */
endif
ppm2m_a4_14h(:,:,:,1) = a4(:,i1:i2,km1:km)

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
a4(:,i1:i2,km1:km) = ppm2m_a4_14h(:,:,:,1)
do k = km1, km
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,0 )
  do i = i1, i2
    a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
    a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
    a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
    a4_ad(4,i,k) = 0.d0
  end do
end do
a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
if (kord .ge. 7) then
  do k = 3, km-2
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(2,i,k) = min(max(a4(2,i,k),qmin),qmax)
      a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
    end do
    if (iv .eq. 0 .and. kord .eq. 7) then
      call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,2 )
    endif
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4(3,i,k) = min(max(a4(3,i,k),qmin),qmax)
    end do
    do i = i1, i2
      lac_ad = 0.d0
      pmp_ad = 0.d0
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      qmp_ad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)-pmp
      lac = a4(1,i,k)+fac*h2(i,k+1)-dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
      a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
      a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
      a4_ad(4,i,k) = 0.d0
      qmax_ad = qmax_ad+a4_ad(2,i,k)*(0.5-sign(0.5d0,qmax-max(a4(2,i,k),qmin)))
      qmin_ad = qmin_ad+a4_ad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5-sign(0.5d0,a4(2,i,k)-qmin))
      a4_ad(2,i,k) = a4_ad(2,i,k)*(0.5+sign(0.5d0,qmax-max(a4(2,i,k),qmin)))*(0.5+sign(0.5d0,a4(2,i,k)-qmin))
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmax_ad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_ad = qmp_ad+qmax_ad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmin_ad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_ad = qmp_ad+qmin_ad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+lac_ad
      dc_ad(i,k) = dc_ad(i,k)-lac_ad
      h2_ad(i,k+1) = h2_ad(i,k+1)+lac_ad*fac
      lac_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmp_ad
      pmp_ad = pmp_ad-qmp_ad
      qmp_ad = 0.d0
      dc_ad(i,k) = dc_ad(i,k)+2*pmp_ad
      pmp_ad = 0.d0
    end do
    a4(:,i1:i2,3:km-2) = ppm2m_a4_13h(:,:,:,1)
    do i = i1, i2
      lac_ad = 0.d0
      pmp_ad = 0.d0
      qmax_ad = 0.d0
      qmin_ad = 0.d0
      qmp_ad = 0.d0
      pmp = 2.*dc(i,k)
      qmp = a4(1,i,k)+pmp
      lac = a4(1,i,k)+fac*h2(i,k-1)+dc(i,k)
      qmin = min(a4(1,i,k),qmp,lac)
      qmax = max(a4(1,i,k),qmp,lac)
      qmax_ad = qmax_ad+a4_ad(3,i,k)*(0.5-sign(0.5d0,qmax-max(a4(3,i,k),qmin)))
      qmin_ad = qmin_ad+a4_ad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5-sign(0.5d0,a4(3,i,k)-qmin))
      a4_ad(3,i,k) = a4_ad(3,i,k)*(0.5+sign(0.5d0,qmax-max(a4(3,i,k),qmin)))*(0.5+sign(0.5d0,a4(3,i,k)-qmin))
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmax_ad*(0.5+sign(0.5d0,a4(1,i,k)-qmp))
      qmp_ad = qmp_ad+qmax_ad*(0.5-sign(0.5d0,a4(1,i,k)-qmp))
      qmax_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmin_ad*(0.5+sign(0.5d0,qmp-a4(1,i,k)))
      qmp_ad = qmp_ad+qmin_ad*(0.5-sign(0.5d0,qmp-a4(1,i,k)))
      qmin_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+lac_ad
      dc_ad(i,k) = dc_ad(i,k)+lac_ad
      h2_ad(i,k-1) = h2_ad(i,k-1)+lac_ad*fac
      lac_ad = 0.d0
      a4_ad(1,i,k) = a4_ad(1,i,k)+qmp_ad
      pmp_ad = pmp_ad+qmp_ad
      qmp_ad = 0.d0
      dc_ad(i,k) = dc_ad(i,k)+2*pmp_ad
      pmp_ad = 0.d0
    end do
  end do
  do k = 2, km1
    do i = i1, i2
      dc_ad(i,k-1) = dc_ad(i,k-1)-h2_ad(i,k)
      dc_ad(i,k+1) = dc_ad(i,k+1)+h2_ad(i,k)
      h2_ad(i,k) = 0.d0
    end do
  end do
else
  do k = 3, km-2
    if (kord .ne. 4) then
      do i = i1, i2
        a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
      end do
    endif
    call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,lmt )
    if (kord .ne. 4) then
      do i = i1, i2
        a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
        a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
        a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
        a4_ad(4,i,k) = 0.d0
      end do
    endif
  end do
endif
a4(:,i1:i2,1:2) = ppm2m_a4_12h(:,:,:,1)
do k = 1, 2
  do i = i1, i2
    a4(4,i,k) = 3.*(2.*a4(1,i,k)-(a4(2,i,k)+a4(3,i,k)))
  end do
  call kmppm_ad( dc(i1,k),dc_ad(i1,k),a4(1,i1,k),a4_ad(1,i1,k),it,0 )
  do i = i1, i2
    a4_ad(3,i,k) = a4_ad(3,i,k)-3*a4_ad(4,i,k)
    a4_ad(2,i,k) = a4_ad(2,i,k)-3*a4_ad(4,i,k)
    a4_ad(1,i,k) = a4_ad(1,i,k)+6*a4_ad(4,i,k)
    a4_ad(4,i,k) = 0.d0
  end do
end do
do k = 1, km1
  do i = i1, i2
    a4_ad(2,i,k+1) = a4_ad(2,i,k+1)+a4_ad(3,i,k)
    a4_ad(3,i,k) = 0.d0
  end do
end do
a4(1,i1:i2,km) = ppm2m_a4_10h(:,1)
a4(3,i1:i2,km) = ppm2m_a4_11h(:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_ad(3,i,km) = a4_ad(3,i,km)*(0.5-sign(0.5d0,0._8-a4(3,i,km)))
  end do
else if (iv .eq. (-1)) then
  do i = i1, i2
    if (a4(1,i,km)*a4(3,i,km) .le. 0.) then
      a4_ad(3,i,km) = 0.d0
    else
      a4_ad(1,i,km) = a4_ad(1,i,km)+a4_ad(3,i,km)*(0.5+sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*&
&sign(1.d0,a4(1,i,km))*sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
      a4_ad(3,i,km) = a4_ad(3,i,km)*(0.5-sign(0.5d0,abs(a4(3,i,km))-abs(a4(1,i,km))))*sign(1.d0,a4(1,i,km))*sign(1.d0,a4(3,i,km))*&
&sign(1.d0,min(abs(a4(1,i,km)),abs(a4(3,i,km))))
    endif
  end do
endif
a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
do i = i1, i2
  c1_ad = 0.d0
  c3_ad = 0.d0
  cmax_ad = 0.d0
  cmin_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  dq_ad = 0.d0
  qm_ad = 0.d0
  d1 = delp(i,km)
  d2 = delp(i,km1)
  qm = (d2*a4(1,i,km)+d1*a4(1,i,km1))/(d1+d2)
  dq = 2.*(a4(1,i,km1)-a4(1,i,km))/(d1+d2)
  c1 = (a4(2,i,km1)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-2.*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmax = max(a4(1,i,km),a4(1,i,km1))
  cmin = min(a4(1,i,km),a4(1,i,km1))
  a4(2,i,km) = max(cmin,a4(2,i,km))
  cmax_ad = cmax_ad+a4_ad(2,i,km)*(0.5+sign(0.5d0,a4(2,i,km)-cmax))
  a4_ad(2,i,km) = a4_ad(2,i,km)*(0.5-sign(0.5d0,a4(2,i,km)-cmax))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  cmin_ad = cmin_ad+a4_ad(2,i,km)*(0.5+sign(0.5d0,cmin-a4(2,i,km)))
  a4_ad(2,i,km) = a4_ad(2,i,km)*(0.5-sign(0.5d0,cmin-a4(2,i,km)))
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_ad(1,i,km) = a4_ad(1,i,km)+cmin_ad*(0.5+sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+cmin_ad*(0.5-sign(0.5d0,a4(1,i,km1)-a4(1,i,km)))
  cmin_ad = 0.d0
  a4(2,i,km) = qm-c1*d1*d2*(d2+3.*d1)
  a4(3,i,km) = d1*(8.*c1*d1**2-c3)+a4(2,i,km)
  a4_ad(1,i,km) = a4_ad(1,i,km)+cmax_ad*(0.5+sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+cmax_ad*(0.5-sign(0.5d0,a4(1,i,km)-a4(1,i,km1)))
  cmax_ad = 0.d0
  a4_ad(3,i,km) = a4_ad(3,i,km)+dc_ad(i,km)
  a4_ad(1,i,km) = a4_ad(1,i,km)-dc_ad(i,km)
  dc_ad(i,km) = 0.d0
  c1_ad = c1_ad+8*a4_ad(3,i,km)*d1*d1**2
  c3_ad = c3_ad-a4_ad(3,i,km)*d1
  d1_ad = d1_ad+a4_ad(3,i,km)*(16*d1*c1*d1+8.*c1*d1**2-c3)
  a4_ad(2,i,km) = a4_ad(2,i,km)+a4_ad(3,i,km)
  a4_ad(3,i,km) = 0.d0
  c1_ad = c1_ad-a4_ad(2,i,km)*d1*d2*(d2+3.*d1)
  d1_ad = d1_ad-a4_ad(2,i,km)*(3*c1*d1*d2+c1*d2*(d2+3.*d1))
  d2_ad = d2_ad-a4_ad(2,i,km)*c1*d1*(2*d2+3.*d1)
  qm_ad = qm_ad+a4_ad(2,i,km)
  a4_ad(2,i,km) = 0.d0
  c1_ad = c1_ad-2*c3_ad*(d2*(5.*d1+d2)-3.*d1**2)
  d1_ad = d1_ad-2.*c3_ad*c1*(5*d2-6*d1)
  d2_ad = d2_ad-2.*c3_ad*c1*(d2+5.*d1+d2)
  dq_ad = dq_ad+c3_ad
  c3_ad = 0.d0
  a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
  a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
  a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
  a4_ad(2,i,km1) = a4_ad(2,i,km1)+c1_ad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  d1_ad = d1_ad-c1_ad*((a4(2,i,km1)-qm-d2*dq)*d2*(3*d1+d2+3.*d1)/(d2*(2.*d2*d2+d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  d2_ad = d2_ad-c1_ad*(dq/(d2*(2.*d2*d2+d1*(d2+3.*d1)))+(a4(2,i,km1)-qm-d2*dq)*(d2*(4*d2+d1)+2.*d2*d2+d1*(d2+3.*d1))/(d2*(2.*d2*d2+&
&d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  dq_ad = dq_ad-c1_ad*(d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_ad = qm_ad-c1_ad/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c1_ad = 0.d0
  a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
  a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
  a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
  a4_ad(1,i,km) = a4_ad(1,i,km)+dq_ad*((-2)/(d1+d2))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+dq_ad*(2/(d1+d2))
  d1_ad = d1_ad-dq_ad*(2*(a4(1,i,km1)-a4(1,i,km))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad-dq_ad*(2*(a4(1,i,km1)-a4(1,i,km))/((d1+d2)*(d1+d2)))
  dq_ad = 0.d0
  a4(1,i1:i2,km1:km) = ppm2m_a4_7h(:,:,1)
  a4(2,i1:i2,km1:km) = ppm2m_a4_8h(:,:,1)
  a4(3,i1:i2,km) = ppm2m_a4_9h(:,1)
  a4_ad(1,i,km) = a4_ad(1,i,km)+qm_ad*(d2/(d1+d2))
  a4_ad(1,i,km1) = a4_ad(1,i,km1)+qm_ad*(d1/(d1+d2))
  d1_ad = d1_ad+qm_ad*(a4(1,i,km1)/(d1+d2)-(d2*a4(1,i,km)+d1*a4(1,i,km1))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad+qm_ad*(a4(1,i,km)/(d1+d2)-(d2*a4(1,i,km)+d1*a4(1,i,km1))/((d1+d2)*(d1+d2)))
  qm_ad = 0.d0
  delp_ae(i,km1) = delp_ae(i,km1)+d2_ad
  d2_ad = 0.d0
  delp_ae(i,km) = delp_ae(i,km)+d1_ad
  d1_ad = 0.d0
end do
a4(1,i1:i2,1) = ppm2m_a4_5h(:,1)
a4(2,i1:i2,1:2) = ppm2m_a4_6h(:,:,1)
if (iv .eq. 0) then
  do i = i1, i2
    a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(3,i,1)
    a4_ad(3,i,1) = 0.d0
    a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(2,i,1)
    a4_ad(2,i,1) = 0.d0
  end do
else if (iv .eq. (-1)) then
  if (km .gt. 32) then
    do i = i1, i2
      a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(3,i,1)
      a4_ad(3,i,1) = 0.d0
      a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(2,i,1)
      a4_ad(2,i,1) = 0.d0
    end do
  else
    do i = i1, i2
      if (a4(1,i,1)*a4(2,i,1) .le. 0.) then
        a4_ad(2,i,1) = 0.d0
      else
        a4_ad(1,i,1) = a4_ad(1,i,1)+a4_ad(2,i,1)*(0.5+sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,&
&a4(1,i,1))*sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
        a4_ad(2,i,1) = a4_ad(2,i,1)*(0.5-sign(0.5d0,abs(a4(2,i,1))-abs(a4(1,i,1))))*sign(1.d0,a4(1,i,1))*sign(1.d0,a4(2,i,1))*&
&sign(1.d0,min(abs(a4(1,i,1)),abs(a4(2,i,1))))
      endif
    end do
  endif
endif
a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
do i = i1, i2
  c1_ad = 0.d0
  c3_ad = 0.d0
  cmax_ad = 0.d0
  cmin_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  dq_ad = 0.d0
  qm_ad = 0.d0
  d1 = delp(i,1)
  d2 = delp(i,2)
  qm = (d2*a4(1,i,1)+d1*a4(1,i,2))/(d1+d2)
  dq = 2.*(a4(1,i,2)-a4(1,i,1))/(d1+d2)
  c1 = 4.*(a4(2,i,3)-qm-d2*dq)/(d2*(2.*d2*d2+d1*(d2+3.*d1)))
  c3 = dq-0.5*c1*(d2*(5.*d1+d2)-3.*d1**2)
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmax = max(a4(1,i,1),a4(1,i,2))
  cmin = min(a4(1,i,1),a4(1,i,2))
  a4(2,i,2) = max(cmin,a4(2,i,2))
  cmax_ad = cmax_ad+a4_ad(2,i,2)*(0.5+sign(0.5d0,a4(2,i,2)-cmax))
  a4_ad(2,i,2) = a4_ad(2,i,2)*(0.5-sign(0.5d0,a4(2,i,2)-cmax))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  cmin_ad = cmin_ad+a4_ad(2,i,2)*(0.5+sign(0.5d0,cmin-a4(2,i,2)))
  a4_ad(2,i,2) = a4_ad(2,i,2)*(0.5-sign(0.5d0,cmin-a4(2,i,2)))
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_ad(1,i,2) = a4_ad(1,i,2)+cmin_ad*(0.5-sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  a4_ad(1,i,1) = a4_ad(1,i,1)+cmin_ad*(0.5+sign(0.5d0,a4(1,i,2)-a4(1,i,1)))
  cmin_ad = 0.d0
  a4(2,i,2) = qm-0.25*c1*d1*d2*(d2+3.*d1)
  a4(2,i,1) = d1*(2.*c1*d1**2-c3)+a4(2,i,2)
  a4_ad(1,i,2) = a4_ad(1,i,2)+cmax_ad*(0.5-sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  a4_ad(1,i,1) = a4_ad(1,i,1)+cmax_ad*(0.5+sign(0.5d0,a4(1,i,1)-a4(1,i,2)))
  cmax_ad = 0.d0
  a4_ad(2,i,1) = a4_ad(2,i,1)-dc_ad(i,1)
  a4_ad(1,i,1) = a4_ad(1,i,1)+dc_ad(i,1)
  dc_ad(i,1) = 0.d0
  c1_ad = c1_ad+2*a4_ad(2,i,1)*d1*d1**2
  c3_ad = c3_ad-a4_ad(2,i,1)*d1
  d1_ad = d1_ad+a4_ad(2,i,1)*(4*d1*c1*d1+2.*c1*d1**2-c3)
  a4_ad(2,i,2) = a4_ad(2,i,2)+a4_ad(2,i,1)
  a4_ad(2,i,1) = 0.d0
  c1_ad = c1_ad-0.25*a4_ad(2,i,2)*d1*d2*(d2+3.*d1)
  d1_ad = d1_ad-a4_ad(2,i,2)*(0.75*c1*d1*d2+0.25*c1*d2*(d2+3.*d1))
  d2_ad = d2_ad-a4_ad(2,i,2)*(0.25*c1*d1*d2+0.25*c1*d1*(d2+3.*d1))
  qm_ad = qm_ad+a4_ad(2,i,2)
  a4_ad(2,i,2) = 0.d0
  c1_ad = c1_ad-0.5*c3_ad*(d2*(5.*d1+d2)-3.*d1**2)
  d1_ad = d1_ad-0.5*c3_ad*c1*(5*d2-6*d1)
  d2_ad = d2_ad-0.5*c3_ad*c1*(d2+5.*d1+d2)
  dq_ad = dq_ad+c3_ad
  c3_ad = 0.d0
  a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
  a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
  a4_ad(2,i,3) = a4_ad(2,i,3)+c1_ad*(4/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  d1_ad = d1_ad-c1_ad*(4.*(a4(2,i,3)-qm-d2*dq)*d2*(3*d1+d2+3.*d1)/(d2*(2.*d2*d2+d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  d2_ad = d2_ad-c1_ad*(4.*dq/(d2*(2.*d2*d2+d1*(d2+3.*d1)))+4.*(a4(2,i,3)-qm-d2*dq)*(d2*(4*d2+d1)+2.*d2*d2+d1*(d2+3.*d1))/(d2*(2.*&
&d2*d2+d1*(d2+3.*d1))*d2*(2.*d2*d2+d1*(d2+3.*d1))))
  dq_ad = dq_ad-c1_ad*(4.*d2/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  qm_ad = qm_ad+c1_ad*((-4)/(d2*(2.*d2*d2+d1*(d2+3.*d1))))
  c1_ad = 0.d0
  a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
  a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
  a4_ad(1,i,2) = a4_ad(1,i,2)+dq_ad*(2/(d1+d2))
  a4_ad(1,i,1) = a4_ad(1,i,1)+dq_ad*((-2)/(d1+d2))
  d1_ad = d1_ad-dq_ad*(2*(a4(1,i,2)-a4(1,i,1))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad-dq_ad*(2*(a4(1,i,2)-a4(1,i,1))/((d1+d2)*(d1+d2)))
  dq_ad = 0.d0
  a4(2,i1:i2,1:3) = ppm2m_a4_3h(:,:,1)
  a4(1,i1:i2,1:2) = ppm2m_a4_4h(:,:,1)
  a4_ad(1,i,2) = a4_ad(1,i,2)+qm_ad*(d1/(d1+d2))
  a4_ad(1,i,1) = a4_ad(1,i,1)+qm_ad*(d2/(d1+d2))
  d1_ad = d1_ad+qm_ad*(a4(1,i,2)/(d1+d2)-(d2*a4(1,i,1)+d1*a4(1,i,2))/((d1+d2)*(d1+d2)))
  d2_ad = d2_ad+qm_ad*(a4(1,i,1)/(d1+d2)-(d2*a4(1,i,1)+d1*a4(1,i,2))/((d1+d2)*(d1+d2)))
  qm_ad = 0.d0
  delp_ae(i,2) = delp_ae(i,2)+d2_ad
  d2_ad = 0.d0
  delp_ae(i,1) = delp_ae(i,1)+d1_ad
  d1_ad = 0.d0
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
  end do
end do
a4(1:2,i1:i2,:) = ppm2m_a4_2h(:,:,:,1)
call steepz_ad( i1,i2,km,a4,a4_ad,df2,df2_ad,dc,dc_ad,delq,delq_ad,delp,delp_ae,d4,d4_ad )
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  do i = i1, i2
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    dc(i,k) = sign(min(abs(tmp),qmax,qmin),tmp)
  end do
end do
do k = 3, km1
  a1_ad = 0.d0
  a2_ad = 0.d0
  c1_ad = 0.d0
  do i = i1, i2
    a1_ad = 0.d0
    a2_ad = 0.d0
    c1_ad = 0.d0
    c1 = delq(i,k-1)*delp(i,k-1)/d4(i,k)
    a1 = d4(i,k-1)/(d4(i,k)+delp(i,k-1))
    a2 = d4(i,k+1)/(d4(i,k)+delp(i,k))
    a1_ad = a1_ad+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*(delp(i,k)*c1-delp(i,k-1)*dc(i,k))
    a2_ad = a2_ad+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*((-c1)+dc(i,k-1))
    c1_ad = c1_ad+a4_ad(2,i,k)*(1+2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*(a1-a2))
    d4_ad(i,k-1) = d4_ad(i,k-1)-a4_ad(2,i,k)*2/((d4(i,k-1)+d4(i,k+1))*(d4(i,k-1)+d4(i,k+1)))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-&
&delp(i,k-1)*a1*dc(i,k))
    d4_ad(i,k+1) = d4_ad(i,k+1)-a4_ad(2,i,k)*2/((d4(i,k-1)+d4(i,k+1))*(d4(i,k-1)+d4(i,k+1)))*(delp(i,k)*(c1*(a1-a2)+a2*dc(i,k-1))-&
&delp(i,k-1)*a1*dc(i,k))
    dc_ad(i,k-1) = dc_ad(i,k-1)+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k)*a2
    dc_ad(i,k) = dc_ad(i,k)-a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*delp(i,k-1)*a1
    delp_ae(i,k-1) = delp_ae(i,k-1)-a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*a1*dc(i,k)
    delp_ae(i,k) = delp_ae(i,k)+a4_ad(2,i,k)*2./(d4(i,k-1)+d4(i,k+1))*(c1*(a1-a2)+a2*dc(i,k-1))
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+a4_ad(2,i,k)
    a4_ad(2,i,k) = 0.d0
    d4_ad(i,k+1) = d4_ad(i,k+1)+a2_ad/(d4(i,k)+delp(i,k))
    d4_ad(i,k) = d4_ad(i,k)-a2_ad*(d4(i,k+1)/((d4(i,k)+delp(i,k))*(d4(i,k)+delp(i,k))))
    delp_ae(i,k) = delp_ae(i,k)-a2_ad*(d4(i,k+1)/((d4(i,k)+delp(i,k))*(d4(i,k)+delp(i,k))))
    a2_ad = 0.d0
    d4_ad(i,k-1) = d4_ad(i,k-1)+a1_ad/(d4(i,k)+delp(i,k-1))
    d4_ad(i,k) = d4_ad(i,k)-a1_ad*(d4(i,k-1)/((d4(i,k)+delp(i,k-1))*(d4(i,k)+delp(i,k-1))))
    delp_ae(i,k-1) = delp_ae(i,k-1)-a1_ad*(d4(i,k-1)/((d4(i,k)+delp(i,k-1))*(d4(i,k)+delp(i,k-1))))
    a1_ad = 0.d0
    d4_ad(i,k) = d4_ad(i,k)-c1_ad*(delq(i,k-1)*delp(i,k-1)/(d4(i,k)*d4(i,k)))
    delp_ae(i,k-1) = delp_ae(i,k-1)+c1_ad*(delq(i,k-1)/d4(i,k))
    delq_ad(i,k-1) = delq_ad(i,k-1)+c1_ad*(delp(i,k-1)/d4(i,k))
    c1_ad = 0.d0
  end do
end do
a4(1,i1:i2,:) = ppm2m_a4_1h(:,:,1)
do k = 2, km1
  c1_ad = 0.d0
  c2_ad = 0.d0
  qmax_ad = 0.d0
  qmin_ad = 0.d0
  tmp_ad = 0.d0
  do i = i1, i2
    c1_ad = 0.d0
    c2_ad = 0.d0
    qmax_ad = 0.d0
    qmin_ad = 0.d0
    tmp_ad = 0.d0
    c1 = (delp(i,k-1)+0.5*delp(i,k))/d4(i,k+1)
    c2 = (delp(i,k+1)+0.5*delp(i,k))/d4(i,k)
    tmp = delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1))
    qmax = max(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))-a4(1,i,k)
    qmin = a4(1,i,k)-min(a4(1,i,k-1),a4(1,i,k),a4(1,i,k+1))
    tmp_ad = tmp_ad+df2_ad(i,k)
    df2_ad(i,k) = 0.d0
    dci = min(abs(tmp),qmax)
    dcj_ad = dc_ad(i,k)*sign(1.d0,min(dci,qmin))*sign(1.d0,tmp)
    dci_ae = dcj_ad*(0.5+sign(0.5d0,qmin-dci))
    qmin_ad = qmin_ad+dcj_ad*(0.5-sign(0.5d0,qmin-dci))
    qmax_ad = qmax_ad+dci_ae*(0.5-sign(0.5d0,qmax-abs(tmp)))
    tmp_ad = tmp_ad+dci_ae*(0.5+sign(0.5d0,qmax-abs(tmp)))*sign(1.d0,tmp)
    dc_ad(i,k) = 0.d0
    qminj = min(a4(1,i,k-1),a4(1,i,k))
    a4_ad(1,i,k) = a4_ad(1,i,k)+qmin_ad
    qmink_ad = -qmin_ad
    a4_ad(1,i,k+1) = a4_ad(1,i,k+1)+qmink_ad*(0.5-sign(0.5d0,a4(1,i,k+1)-qminj))
    qminj_ad = qmink_ad*(0.5+sign(0.5d0,a4(1,i,k+1)-qminj))
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+qminj_ad*(0.5+sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    a4_ad(1,i,k) = a4_ad(1,i,k)+qminj_ad*(0.5-sign(0.5d0,a4(1,i,k)-a4(1,i,k-1)))
    qmin_ad = 0.d0
    qmaxj = max(a4(1,i,k-1),a4(1,i,k))
    a4_ad(1,i,k) = a4_ad(1,i,k)-qmax_ad
    a4_ad(1,i,k+1) = a4_ad(1,i,k+1)+qmax_ad*(0.5-sign(0.5d0,qmaxj-a4(1,i,k+1)))
    qmaxj_ad = qmax_ad*(0.5+sign(0.5d0,qmaxj-a4(1,i,k+1)))
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+qmaxj_ad*(0.5+sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    a4_ad(1,i,k) = a4_ad(1,i,k)+qmaxj_ad*(0.5-sign(0.5d0,a4(1,i,k-1)-a4(1,i,k)))
    qmax_ad = 0.d0
    c1_ad = c1_ad+tmp_ad*(delp(i,k)*delq(i,k)/(d4(i,k)+delp(i,k+1)))
    c2_ad = c2_ad+tmp_ad*(delp(i,k)*delq(i,k-1)/(d4(i,k)+delp(i,k+1)))
    d4_ad(i,k) = d4_ad(i,k)-tmp_ad*(delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/((d4(i,k)+delp(i,k+1))*(d4(i,k)+delp(i,k+1))))
    delp_ae(i,k+1) = delp_ae(i,k+1)-tmp_ad*(delp(i,k)*(c1*delq(i,k)+c2*delq(i,k-1))/((d4(i,k)+delp(i,k+1))*(d4(i,k)+delp(i,k+1))))
    delp_ae(i,k) = delp_ae(i,k)+tmp_ad*((c1*delq(i,k)+c2*delq(i,k-1))/(d4(i,k)+delp(i,k+1)))
    delq_ad(i,k-1) = delq_ad(i,k-1)+tmp_ad*(delp(i,k)*c2/(d4(i,k)+delp(i,k+1)))
    delq_ad(i,k) = delq_ad(i,k)+tmp_ad*(delp(i,k)*c1/(d4(i,k)+delp(i,k+1)))
    tmp_ad = 0.d0
    d4_ad(i,k) = d4_ad(i,k)-c2_ad*((delp(i,k+1)+0.5*delp(i,k))/(d4(i,k)*d4(i,k)))
    delp_ae(i,k+1) = delp_ae(i,k+1)+c2_ad/d4(i,k)
    delp_ae(i,k) = delp_ae(i,k)+c2_ad*(0.5/d4(i,k))
    c2_ad = 0.d0
    d4_ad(i,k+1) = d4_ad(i,k+1)-c1_ad*((delp(i,k-1)+0.5*delp(i,k))/(d4(i,k+1)*d4(i,k+1)))
    delp_ae(i,k-1) = delp_ae(i,k-1)+c1_ad/d4(i,k+1)
    delp_ae(i,k) = delp_ae(i,k)+c1_ad*(0.5/d4(i,k+1))
    c1_ad = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    delp_ae(i,k-1) = delp_ae(i,k-1)+d4_ad(i,k)
    delp_ae(i,k) = delp_ae(i,k)+d4_ad(i,k)
    d4_ad(i,k) = 0.d0
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)-delq_ad(i,k-1)
    a4_ad(1,i,k) = a4_ad(1,i,k)+delq_ad(i,k-1)
    delq_ad(i,k-1) = 0.d0
  end do
end do

!----------------------------------------------
! CLOSE TAPE ppm2m
!----------------------------------------------
if (allocated(ppm2m_a4_7h)) then
  deallocate( ppm2m_a4_7h )
endif
if (allocated(ppm2m_a4_8h)) then
  deallocate( ppm2m_a4_8h )
endif
if (allocated(ppm2m_a4_14h)) then
  deallocate( ppm2m_a4_14h )
endif


end subroutine ppm2m_ad


subroutine steepz_ad( i1, i2, km, a4, a4_ad, df2, df2_ad, dm, dm_ad, dq, dq_ad, dp, dp_ad, d4, d4_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: i1
integer :: i2
integer :: km
real(kind=r8) :: a4(4,i1:i2,km)
real(kind=r8) :: a4_ad(4,i1:i2,km)
real(kind=r8) :: d4(i1:i2,km)
real(kind=r8) :: d4_ad(i1:i2,km)
real(kind=r8) :: df2(i1:i2,km)
real(kind=r8) :: df2_ad(i1:i2,km)
real(kind=r8) :: dm(i1:i2,km)
real(kind=r8) :: dm_ad(i1:i2,km)
real(kind=r8) :: dp(i1:i2,km)
real(kind=r8) :: dp_ad(i1:i2,km)
real(kind=r8) :: dq(i1:i2,km)
real(kind=r8) :: dq_ad(i1:i2,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: alfa(i1:i2,km)
real(kind=r8) :: alfa_ad(i1:i2,km)
real(kind=r8) :: dg2
real(kind=r8) :: dg2_ad
real(kind=r8) :: f(i1:i2,km)
real(kind=r8) :: f_ad(i1:i2,km)
integer :: i
integer :: k
real(kind=r8) :: rat(i1:i2,km)
real(kind=r8) :: rat_ad(i1:i2,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
alfa_ad(:,:) = 0.d0
dg2_ad = 0.d0
f_ad(:,:) = 0.d0
rat_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do k = 2, km
  do i = i1, i2
    rat(i,k) = dq(i,k-1)/d4(i,k)
  end do
end do
do k = 2, km-1
  do i = i1, i2
    f(i,k) = (rat(i,k+1)-rat(i,k))/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
  end do
end do
do k = 3, km-2
  do i = i1, i2
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      alfa(i,k) = max(0._8,min(0.5_8,-(0.1875*dg2/df2(i,k))))
    else
      alfa(i,k) = 0.
    endif
  end do
end do
do k = 4, km-2
  do i = i1, i2
    alfa_ad(i,k-1) = alfa_ad(i,k-1)+a4_ad(2,i,k)*((-a4(2,i,k))+a4(1,i,k)-dm(i,k))
    alfa_ad(i,k) = alfa_ad(i,k)+a4_ad(2,i,k)*((-a4(2,i,k))+a4(1,i,k-1)+dm(i,k-1))
    dm_ad(i,k-1) = dm_ad(i,k-1)+a4_ad(2,i,k)*alfa(i,k)
    dm_ad(i,k) = dm_ad(i,k)-a4_ad(2,i,k)*alfa(i,k-1)
    a4_ad(1,i,k-1) = a4_ad(1,i,k-1)+a4_ad(2,i,k)*alfa(i,k)
    a4_ad(1,i,k) = a4_ad(1,i,k)+a4_ad(2,i,k)*alfa(i,k-1)
    a4_ad(2,i,k) = a4_ad(2,i,k)*(1.-alfa(i,k-1)-alfa(i,k))
  end do
end do
do k = 3, km-2
  dg2_ad = 0.d0
  do i = i1, i2
    dg2_ad = 0.d0
    if (f(i,k+1)*f(i,k-1) .lt. 0. .and. df2(i,k) .ne. 0.) then
      dg2 = (f(i,k+1)-f(i,k-1))*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      df2_ad(i,k) = df2_ad(i,k)+alfa_ad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*&
&dg2/df2(i,k)))-0.5_8))*(0.1875*dg2/(df2(i,k)*df2(i,k)))
      dg2_ad = dg2_ad-alfa_ad(i,k)*(0.5-sign(0.5_8,0._8-min(0.5_8,-(0.1875*dg2/df2(i,k)))))*(0.5-sign(0.5d0,(-(0.1875*dg2/df2(i,k))&
&)-0.5_8))*(0.1875/df2(i,k))
      alfa_ad(i,k) = 0.d0
      d4_ad(i,k+1) = d4_ad(i,k+1)+dg2_ad*(f(i,k+1)-f(i,k-1))*d4(i,k)
      d4_ad(i,k) = d4_ad(i,k)+dg2_ad*(f(i,k+1)-f(i,k-1))*d4(i,k+1)
      dp_ad(i,k-1) = dp_ad(i,k-1)-2*dg2_ad*(f(i,k+1)-f(i,k-1))*(dp(i,k+1)-dp(i,k-1))
      dp_ad(i,k+1) = dp_ad(i,k+1)+2*dg2_ad*(f(i,k+1)-f(i,k-1))*(dp(i,k+1)-dp(i,k-1))
      f_ad(i,k-1) = f_ad(i,k-1)-dg2_ad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      f_ad(i,k+1) = f_ad(i,k+1)+dg2_ad*((dp(i,k+1)-dp(i,k-1))**2+d4(i,k)*d4(i,k+1))
      dg2_ad = 0.d0
    else
      alfa_ad(i,k) = 0.d0
    endif
  end do
end do
do k = 2, km-1
  do i = i1, i2
    dp_ad(i,k-1) = dp_ad(i,k-1)-f_ad(i,k)*((rat(i,k+1)-rat(i,k))/((dp(i,k-1)+dp(i,k)+dp(i,k+1))*(dp(i,k-1)+dp(i,k)+dp(i,k+1))))
    dp_ad(i,k+1) = dp_ad(i,k+1)-f_ad(i,k)*((rat(i,k+1)-rat(i,k))/((dp(i,k-1)+dp(i,k)+dp(i,k+1))*(dp(i,k-1)+dp(i,k)+dp(i,k+1))))
    dp_ad(i,k) = dp_ad(i,k)-f_ad(i,k)*((rat(i,k+1)-rat(i,k))/((dp(i,k-1)+dp(i,k)+dp(i,k+1))*(dp(i,k-1)+dp(i,k)+dp(i,k+1))))
    rat_ad(i,k+1) = rat_ad(i,k+1)+f_ad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    rat_ad(i,k) = rat_ad(i,k)-f_ad(i,k)/(dp(i,k-1)+dp(i,k)+dp(i,k+1))
    f_ad(i,k) = 0.d0
  end do
end do
do k = 2, km
  do i = i1, i2
    d4_ad(i,k) = d4_ad(i,k)-rat_ad(i,k)*(dq(i,k-1)/(d4(i,k)*d4(i,k)))
    dq_ad(i,k-1) = dq_ad(i,k-1)+rat_ad(i,k)/d4(i,k)
    rat_ad(i,k) = 0.d0
  end do
end do

end subroutine steepz_ad


subroutine te_map_ad( consv, convt, ps, ps_ae, pe, pe_ae, delp, delp_ae, pkz, pkz_ae, pk, pk_ae, im, jm, km, nx, jfirst, jlast, nq,&
& u, u_ae, v, v_ae, pt, pt_ae, q, q_ae, hs, cp, akap, kord, peln, peln_ad, te0, te0_ad, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use te_map_ad_store, only : te_map_tape_delp_15h,te_map_tape_dtmp_18h,te_map_tape_dz_8h,te_map_tape_pe_14h,te_map_tape_peln_12h,&
&te_map_tape_pk_1h,te_map_tape_pkz_13h,te_map_tape_pkz_2h,te_map_tape_te_11h,te_map_tape_te_19h,te_map_tape_te_9h,&
&te_map_tape_te_map,te_map_tape_tsum_16h,te_map_tape_u_17h,te_map_tape_u_6h,te_map_tape_v_10h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_ae(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_ae(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: peln_ad(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pk_ae(im,jfirst:jlast,km+1)
real(kind=r8) :: temp_pk_ae(im,jfirst:jlast,km+1,2)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_ae(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: ps_ae(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_ae(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: q_ae(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
real(kind=r8) :: te0_ad
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_ae(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_ae(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: bte_ad(im)
real(kind=r8) :: dlnp
real(kind=r8) :: dlnp_ad
real(kind=r8) :: dtmp
real(kind=r8) :: dtmp_ad
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: dz_ad(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
real(kind=r8) :: gz_ad(im)
integer :: help_h
integer :: help_i
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe0_ad(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1_ad(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe1w_ad(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2_ad(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe2w_ad(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: pe3_ad(im,km+1)
real(kind=r8) :: peh(im,km+1,jfirst:jlast)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: phis_ad(im,km+1)
#ifdef USE_OPENMP
real(kind=r8) :: pk_aeh(im,jfirst:jlast,km+1)
#endif /* ! USE_OPENMP */
real(kind=r8) :: pkh(im,jfirst:jlast,km+1)
real(kind=r8) :: pth(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: t2_ad(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te1_ad
real(kind=r8) :: te_ad(im,jfirst:jlast,km)
real(kind=8), allocatable :: te_map_gz_gz_1h(:,:)
integer :: te_map_gz_te_map
real(kind=r8) :: te_np_ad
real(kind=r8) :: te_sp_ad
real(kind=r8) :: tsum
real(kind=r8) :: tsum_ad
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tte_ad(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: tvm_ad
real(kind=r8) :: u2_ad(im,jfirst:jlast+1)
real(kind=r8) :: v2_ad(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: xsum_ad
real(kind=r8) :: ysum_ad

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
pth(:,:,:) = pt(:,:,:)
pkh(:,:,:) = pk(:,:,:)
peh(:,:,:) = pe(:,:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
bte_ad(:) = 0.d0
dlnp_ad = 0.d0
dtmp_ad = 0.d0
dz_ad(:,:,:) = 0.d0
gz_ad(:) = 0.d0
pe0_ad(:,:) = 0.d0
pe1_ad(:,:) = 0.d0
pe1w_ad(:) = 0.d0
pe2_ad(:,:) = 0.d0
pe2w_ad(:) = 0.d0
pe3_ad(:,:) = 0.d0
phis_ad(:,:) = 0.d0
t2_ad(:,:) = 0.d0
te1_ad = 0.d0
te_ad(:,:,:) = 0.d0
te_np_ad = 0.d0
te_sp_ad = 0.d0
tsum_ad = 0.d0
tte_ad(:) = 0.d0
tvm_ad = 0.d0
u2_ad(:,:) = 0.d0
v2_ad(:,:) = 0.d0
xsum_ad = 0.d0
ysum_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
pk = te_map_tape_pk_1h(:,:,:,te_map_tape_rec+1)
it = im/nx
jp = nx*(jlast-jfirst+1)
v = te_map_tape_v_10h(:,:,:,te_map_tape_rec+1)
peln = te_map_tape_peln_12h(:,:,:,te_map_tape_rec+1)
pkz = te_map_tape_pkz_13h(:,:,:,te_map_tape_rec+1)
pe = te_map_tape_pe_14h(:,:,:,te_map_tape_rec+1)
delp = te_map_tape_delp_15h(:,:,:,te_map_tape_rec+1)
u = te_map_tape_u_17h(:,:,:,te_map_tape_rec+1)
dtmp = te_map_tape_dtmp_18h(te_map_tape_rec+1)
te = te_map_tape_te_19h(:,:,:,te_map_tape_rec+1)
#ifdef TIMING
call timing_on("mapz_module_ad1")
#endif
#ifdef USE_OPENMP
!$omp parallel do shared(akap,consv,convt,cp,delp,delp_ae,dtmp,dtmp_ad,hs,it,jfirst,jp,km,nx,pe,pe_ae,peln,peln_ad,pkz,pkz_ae,pt,&
!$omp& pt_ae,te,te_ad) private(dlnp,dlnp_ad,gz,gz_ad,i,i1,i2,ixj,j,k,rg,te_map_gz_gz_1h,te_map_gz_te_map,tvm,tvm_ad)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  dlnp_ad = 0.d0
  gz_ad(:) = 0.d0
  tvm_ad = 0.d0
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
!----------------------------------------------
! OPEN TAPE te_map_gz
!----------------------------------------------
  te_map_gz_te_map = km

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 2, -1
    if ( .not. allocated(te_map_gz_gz_1h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(te_map_gz_gz_1h)) then
        allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
#endif /* USE_OPENMP */
    endif
    te_map_gz_gz_1h(:,1+km-k) = gz
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
    end do
  end do
  k = 1
  if ( .not. allocated(te_map_gz_gz_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(te_map_gz_gz_1h)) then
      allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( te_map_gz_gz_1h(1:im,te_map_gz_te_map) )
#endif /* USE_OPENMP */
  endif
  te_map_gz_gz_1h(:,1+km-k) = gz

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
  do k = 1, km
    gz = te_map_gz_gz_1h(:,1+km-k)
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-pt_ae(i,j,k)*(pt(i,j,k)/(pkz(i,j,k)*pkz(i,j,k)))
        pt_ae(i,j,k) = pt_ae(i,j,k)/pkz(i,j,k)
      end do
    endif
    if (consv) then
      do i = i1, i2
        dtmp_ad = dtmp_ad+pt_ae(i,j,k)
      end do
    endif
    do i = i1, i2
      dlnp_ad = 0.d0
      tvm_ad = 0.d0
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      tvm_ad = tvm_ad+pt_ae(i,j,k)
      pt_ae(i,j,k) = 0.d0
      dlnp_ad = dlnp_ad+gz_ad(i)*tvm
      tvm_ad = tvm_ad+gz_ad(i)*dlnp
      delp_ae(i,j,k) = delp_ae(i,j,k)+tvm_ad*((te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)-delp(i,j,k)*(te(i,j,k)-gz(i))*cp/&
&((cp*delp(i,j,k)-pe(i,k,j)*dlnp)*(cp*delp(i,j,k)-pe(i,k,j)*dlnp)))
      dlnp_ad = dlnp_ad+tvm_ad*(delp(i,j,k)*(te(i,j,k)-gz(i))*pe(i,k,j)/((cp*delp(i,j,k)-pe(i,k,j)*dlnp)*(cp*delp(i,j,k)-pe(i,k,j)*&
&dlnp)))
      gz_ad(i) = gz_ad(i)-tvm_ad*(delp(i,j,k)/(cp*delp(i,j,k)-pe(i,k,j)*dlnp))
      pe_ae(i,k,j) = pe_ae(i,k,j)+tvm_ad*(delp(i,j,k)*(te(i,j,k)-gz(i))*dlnp/((cp*delp(i,j,k)-pe(i,k,j)*dlnp)*(cp*delp(i,j,k)-pe(i,&
&k,j)*dlnp)))
      te_ad(i,j,k) = te_ad(i,j,k)+tvm_ad*(delp(i,j,k)/(cp*delp(i,j,k)-pe(i,k,j)*dlnp))
      tvm_ad = 0.d0
      peln_ad(i,k+1,j) = peln_ad(i,k+1,j)+dlnp_ad*rg
      peln_ad(i,k,j) = peln_ad(i,k,j)-dlnp_ad*rg
      dlnp_ad = 0.d0
    end do
  end do
  do i = i1, i2
    gz_ad(i) = 0.d0
  end do

!----------------------------------------------
! CLOSE TAPE te_map_gz
!----------------------------------------------
  if (allocated(te_map_gz_gz_1h)) then
    deallocate( te_map_gz_gz_1h )
  endif

end do
#ifdef TIMING
call timing_off("mapz_module_ad1")
call timing_on("mapz_module_ad2")
#endif
#ifdef USE_OPENMP
!$omp parallel do shared(im,jfirst,jlast,jm,jn2g0,js2g0,km,te_ad,u,u_ae,v,v_ae) private(i,j,k,te_np_ad,te_sp_ad,u2_ad,v2_ad)
#endif /* ! USE_OPENMP */
do k = 1, km
  te_np_ad = 0.d0
  te_sp_ad = 0.d0
  u2_ad(:,:) = 0.d0
  v2_ad(:,:) = 0.d0
  if (jlast .eq. jm) then
    do i = 1, im
      te_np_ad = te_np_ad+te_ad(i,jm,k)
      te_ad(i,jm,k) = 0.d0
    end do
    te_ad(1,jm,k) = te_ad(1,jm,k)+te_np_ad
    te_np_ad = -(te_np_ad*(0.5/float(im)))
    do i = 1, im
      u2_ad(i,jm) = u2_ad(i,jm)+te_np_ad
      v2_ad(i,jm-1) = v2_ad(i,jm-1)+te_np_ad
    end do
    te_np_ad = 0.d0
  endif
  if (jfirst .eq. 1) then
    do i = 1, im
      te_sp_ad = te_sp_ad+te_ad(i,1,k)
      te_ad(i,1,k) = 0.d0
    end do
    te_ad(1,1,k) = te_ad(1,1,k)+te_sp_ad
    te_sp_ad = -(te_sp_ad*(0.5/float(im)))
    do i = 1, im
      u2_ad(i,2) = u2_ad(i,2)+te_sp_ad
      v2_ad(i,2) = v2_ad(i,2)+te_sp_ad
    end do
    te_sp_ad = 0.d0
  endif
  do j = js2g0, jn2g0
    u2_ad(im,j+1) = u2_ad(im,j+1)-0.25*te_ad(im,j,k)
    u2_ad(im,j) = u2_ad(im,j)-0.25*te_ad(im,j,k)
    v2_ad(im,j) = v2_ad(im,j)-0.25*te_ad(im,j,k)
    v2_ad(1,j) = v2_ad(1,j)-0.25*te_ad(im,j,k)
    do i = 1, im-1
      u2_ad(i,j+1) = u2_ad(i,j+1)-0.25*te_ad(i,j,k)
      u2_ad(i,j) = u2_ad(i,j)-0.25*te_ad(i,j,k)
      v2_ad(i+1,j) = v2_ad(i+1,j)-0.25*te_ad(i,j,k)
      v2_ad(i,j) = v2_ad(i,j)-0.25*te_ad(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v_ae(i,j,k) = v_ae(i,j,k)+2*v2_ad(i,j)*v(i,j,k)
      v2_ad(i,j) = 0.d0
    end do
  end do
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u_ae(i,j,k) = u_ae(i,j,k)+2*u2_ad(i,j)*u(i,j,k)
      u2_ad(i,j) = 0.d0
    end do
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad2")
#endif
te = te_map_tape_te_11h(:,:,:,te_map_tape_rec+1)
if (consv) then
#ifdef TIMING
call timing_on("mapz_module_ad3")
#endif
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
#ifdef TIMING
call timing_off("mapz_module_ad3")
#endif
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
  tsum = te_map_tape_tsum_16h(te_map_tape_rec+1)
  te0_ad = te0_ad+dtmp_ad/tsum
  te1_ad = te1_ad-dtmp_ad/tsum
  tsum_ad = tsum_ad-dtmp_ad*((te0-te1)/(tsum*tsum))
  dtmp_ad = 0.d0
  call par_vecsum_ad( jm,jfirst,jlast,tte_ad,tsum_ad )
#ifdef TIMING
call timing_on("mapz_module_ad4")
#endif
#ifdef USE_OPENMP
  !$omp parallel do shared(akap,cp,im,jfirst,jlast,jm,km,peln_ad,ps_ae,te_acap,te_cosp,te_ptop,tte_ad) private(i,j,xsum_ad,ysum_ad)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    xsum_ad = 0.d0
    ysum_ad = 0.d0
    if (j .eq. 1) then
      peln_ad(1,km+1,1) = peln_ad(1,km+1,1)-tte_ad(1)*te_acap*cp*akap*te_ptop
      peln_ad(1,1,1) = peln_ad(1,1,1)+tte_ad(1)*te_acap*cp*akap*te_ptop
      ps_ae(1,1) = ps_ae(1,1)+tte_ad(1)*te_acap*cp
      tte_ad(1) = 0.d0
    else if (j .eq. jm) then
      peln_ad(1,km+1,jm) = peln_ad(1,km+1,jm)-tte_ad(jm)*te_acap*cp*akap*te_ptop
      peln_ad(1,1,jm) = peln_ad(1,1,jm)+tte_ad(jm)*te_acap*cp*akap*te_ptop
      ps_ae(1,jm) = ps_ae(1,jm)+tte_ad(jm)*te_acap*cp
      tte_ad(jm) = 0.d0
    else
      peln_ad(1,1,j) = peln_ad(1,1,j)+tte_ad(j)*cp*te_cosp(j)*akap*te_ptop*im
      xsum_ad = xsum_ad+tte_ad(j)*cp*te_cosp(j)
      ysum_ad = ysum_ad-tte_ad(j)*cp*te_cosp(j)*akap*te_ptop
      tte_ad(j) = 0.d0
      do i = 1, im
        peln_ad(i,km+1,j) = peln_ad(i,km+1,j)+ysum_ad
        ps_ae(i,j) = ps_ae(i,j)+xsum_ad
      end do
      ysum_ad = 0.d0
      xsum_ad = 0.d0
    endif
  end do
#ifdef TIMING
call timing_off("mapz_module_ad4")
#endif
  call par_vecsum_ad( jm,jfirst,jlast,tte_ad,te1_ad )
#ifdef TIMING
call timing_on("mapz_module_ad5")
#endif
#ifdef USE_OPENMP
  !$omp parallel do shared(dz_ad,im,jfirst,jlast,jm,km,te_acap,te_cosp,tte_ad) private(bte_ad,i,j,k,xsum_ad)
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    bte_ad(:) = 0.d0
    xsum_ad = 0.d0
    if (j .eq. 1) then
      tte_ad(1) = tte_ad(1)*te_acap
      do k = 1, km
        dz_ad(1,1,k) = dz_ad(1,1,k)+tte_ad(1)
      end do
      tte_ad(1) = 0.d0
    else if (j .eq. jm) then
      tte_ad(jm) = tte_ad(jm)*te_acap
      do k = 1, km
        dz_ad(1,jm,k) = dz_ad(1,jm,k)+tte_ad(jm)
      end do
      tte_ad(jm) = 0.d0
    else
      xsum_ad = xsum_ad+tte_ad(j)*te_cosp(j)
      tte_ad(j) = 0.d0
      do i = 1, im
        bte_ad(i) = bte_ad(i)+xsum_ad
      end do
      xsum_ad = 0.d0
      do k = km, 1, -1
        do i = 1, im
          dz_ad(i,j,k) = dz_ad(i,j,k)+bte_ad(i)
        end do
      end do
      do i = 1, im
        bte_ad(i) = 0.d0
      end do
    endif
  end do
#ifdef USE_OPENMP
  !$omp parallel do shared(delp,delp_ae,dz_ad,im,jfirst,jlast,km,te,te_ad) private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        delp_ae(i,j,k) = delp_ae(i,j,k)+dz_ad(i,j,k)*te(i,j,k)
        te_ad(i,j,k) = te_ad(i,j,k)+dz_ad(i,j,k)*delp(i,j,k)
        dz_ad(i,j,k) = 0.d0
      end do
    end do
  end do
#ifdef TIMING
call timing_off("mapz_module_ad5")
#endif
endif
pe(:,:,:) = peh(:,:,:)
#ifdef TIMING
call timing_on("mapz_module_ad6")
#endif
#ifdef USE_OPENMP
!$omp parallel do private(i,i1,i2,ixj,j,k,pe1,pe2)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe2(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad6")
#endif
call pkez_ad( nx,im,km,jfirst,jlast,pe,pe_ae,pk,pk_ae,akap,ks,peln,peln_ad,pkz_ae, .true.  )
#ifdef TIMING
call timing_on("mapz_module_ad7")
#endif
#ifdef USE_OPENMP
!$omp parallel do shared(im,jfirst,jlast,km,pe_ae,peln_ad) private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      peln_ad(i,k,j) = peln_ad(i,k,j)+pe_ae(i,k,j)
      pe_ae(i,k,j) = 0.d0
    end do
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad7")
#endif
pe(:,:,:) = peh(:,:,:)
u = te_map_tape_u_6h(:,:,:,te_map_tape_rec+1)
v = te_map_tape_v_7h(:,:,:,te_map_tape_rec+1)
dz = te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1)
te = te_map_tape_te_9h(:,:,:,te_map_tape_rec+1)
#ifdef TIMING
call timing_on("mapz_module_ad8")
#endif
#ifdef USE_OPENMP
!$omp parallel do shared(ak,bk,delp_ae,dz,dz_ad,hs,im,it,jfirst,jlast,jm,jp,km,kord,ks,ng_d,ng_s,nq,nx,pe,pe_ae,peln_ad,ps,ps_ae,q,&
!$omp& q_ae,te,te_ad,u,u_ae,v,v_ae) private(bkh,help_h,help_i,i,i1,i2,ixj,j,k,krd,pe0,pe0_ad,pe1,pe1_ad,pe1w,pe1w_ad,pe2,pe2_ad,&
!$omp& pe2w,pe2w_ad,pe3,pe3_ad,phis,phis_ad)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  pe0_ad(:,:) = 0.d0
  pe1_ad(:,:) = 0.d0
  pe1w_ad(:) = 0.d0
  pe2_ad(:,:) = 0.d0
  pe2w_ad(:) = 0.d0
  pe3_ad(:,:) = 0.d0
  phis_ad(:,:) = 0.d0
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    endif
  endif
  do k = 2, km
    do i = i1, i2
      pe2_ad(i,k) = pe2_ad(i,k)+peln_ad(i,k,j)
      peln_ad(i,k,j) = 0.d0
    end do
  end do
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_i = -1
    call map1_ppm_ad( km,pe0,pe0_ad,v,v_ae,km,pe3,pe3_ad,v_ae,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_i,kord )
    do k = ks+2, km+1
      do i = i1+1, i2
        pe2_ad(i-1,k) = pe2_ad(i-1,k)+0.5*pe3_ad(i,k)
        pe2_ad(i,k) = pe2_ad(i,k)+0.5*pe3_ad(i,k)
        pe3_ad(i,k) = 0.d0
      end do
      pe2_ad(i1,k) = pe2_ad(i1,k)+0.5*pe3_ad(i1,k)
      pe2w_ad(k) = pe2w_ad(k)+0.5*pe3_ad(i1,k)
      pe3_ad(i1,k) = 0.d0
    end do
    do k = 2, km+1
      do i = i1+1, i2
        pe1_ad(i-1,k) = pe1_ad(i-1,k)+0.5*pe0_ad(i,k)
        pe1_ad(i,k) = pe1_ad(i,k)+0.5*pe0_ad(i,k)
        pe0_ad(i,k) = 0.d0
      end do
      pe1_ad(i1,k) = pe1_ad(i1,k)+0.5*pe0_ad(i1,k)
      pe1w_ad(k) = pe1w_ad(k)+0.5*pe0_ad(i1,k)
      pe0_ad(i1,k) = 0.d0
    end do
  endif
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
  end do
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    endif
    help_h = -1
    call map1_ppm_ad( km,pe0,pe0_ad,u,u_ae,km,pe3,pe3_ad,u_ae,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_h,kord )
    if (j .gt. jfirst) then
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe_ae(i,km+1,j-1) = pe_ae(i,km+1,j-1)+pe3_ad(i,k)*bkh
          pe1_ad(i,km+1) = pe1_ad(i,km+1)+pe3_ad(i,k)*bkh
          pe3_ad(i,k) = 0.d0
        end do
      end do
      do k = 2, km+1
        do i = i1, i2
          pe_ae(i,k,j-1) = pe_ae(i,k,j-1)+0.5*pe0_ad(i,k)
          pe1_ad(i,k) = pe1_ad(i,k)+0.5*pe0_ad(i,k)
          pe0_ad(i,k) = 0.d0
        end do
      end do
    endif
  endif
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm_ad( km,pe1,pe1_ad,q,q_ae,nq,km,pe2,pe2_ad,q_ae,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  call map1_ppm_ad( km,pe1,pe1_ad,te,te_ad,km,pe2,pe2_ad,te_ad,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  do k = 1, km
    do i = i1, i2
      pe1_ad(i,k+1) = pe1_ad(i,k+1)-te_ad(i,j,k)*((phis(i,k+1)-phis(i,k))/((pe1(i,k+1)-pe1(i,k))*(pe1(i,k+1)-pe1(i,k))))
      pe1_ad(i,k) = pe1_ad(i,k)+te_ad(i,j,k)*((phis(i,k+1)-phis(i,k))/((pe1(i,k+1)-pe1(i,k))*(pe1(i,k+1)-pe1(i,k))))
      phis_ad(i,k+1) = phis_ad(i,k+1)+te_ad(i,j,k)/(pe1(i,k+1)-pe1(i,k))
      phis_ad(i,k) = phis_ad(i,k)-te_ad(i,j,k)/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      pe1_ad(i,k) = pe1_ad(i,k)+phis_ad(i,k)*phis(i,k)
      phis_ad(i,k) = phis_ad(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      dz_ad(i,j,k) = dz_ad(i,j,k)+phis_ad(i,k)
      phis_ad(i,k+1) = phis_ad(i,k+1)+phis_ad(i,k)
      phis_ad(i,k) = 0.d0
    end do
  end do
  do i = i1, i2
    phis_ad(i,km+1) = 0.d0
  end do
  do k = ks+1, km
    do i = i1, i2
      pe2_ad(i,k+1) = pe2_ad(i,k+1)+delp_ae(i,j,k)
      pe2_ad(i,k) = pe2_ad(i,k)-delp_ae(i,j,k)
      delp_ae(i,j,k) = 0.d0
    end do
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      do i = i1, i2
        delp_ae(i,j,k) = 0.d0
      end do
    end do
  endif
  do i = i1, i2
    pe1_ad(i,km+1) = pe1_ad(i,km+1)+ps_ae(i,j)
    ps_ae(i,j) = 0.d0
  end do
  do k = 2, km+1
    do i = i1, i2
      pe1_ad(i,k) = pe1_ad(i,k)+pe0_ad(i,k)
      pe0_ad(i,k) = -pe0_ad(i,k)
    end do
  end do
  pe1w_ad(km+1) = pe1w_ad(km+1)+pe2w_ad(km+1)
  pe2w_ad(km+1) = 0.d0
  do k = ks+2, km
    pe1w_ad(km+1) = pe1w_ad(km+1)+pe2w_ad(k)*bk(k)
    pe2w_ad(k) = 0.d0
  end do
  do i = i1, i2
    pe1_ad(i,km+1) = pe1_ad(i,km+1)+pe2_ad(i,km+1)
    pe2_ad(i,km+1) = 0.d0
    ps_ae(i,j) = ps_ae(i,j)+pe0_ad(i,km+1)
    pe0_ad(i,km+1) = 0.d0
  end do
  do k = ks+2, km
    do i = i1, i2
      pe1_ad(i,km+1) = pe1_ad(i,km+1)+pe2_ad(i,k)*bk(k)
      pe2_ad(i,k) = 0.d0
      ps_ae(i,j) = ps_ae(i,j)+pe0_ad(i,k)*bk(k)
      pe0_ad(i,k) = 0.d0
    end do
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe3_ad(i,k) = 0.d0
      pe2_ad(i,k) = 0.d0
      pe0_ad(i,k) = 0.d0
    end do
  end do
  do k = 1, km+1
    if (i1 .eq. 1) then
      pe_ae(im,k,j) = pe_ae(im,k,j)+pe1w_ad(k)
      pe1w_ad(k) = 0.d0
    else
      pe_ae(i1-1,k,j) = pe_ae(i1-1,k,j)+pe1w_ad(k)
      pe1w_ad(k) = 0.d0
    endif
    do i = i1, i2
      pe_ae(i,k,j) = pe_ae(i,k,j)+pe1_ad(i,k)
      pe1_ad(i,k) = 0.d0
    end do
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad8")
#endif
pt(:,:,:) = pth(:,:,:)
pkz = te_map_tape_pkz_2h(:,:,:,te_map_tape_rec+1)
u = te_map_tape_u_6h(:,:,:,te_map_tape_rec+1)
v = te_map_tape_v_7h(:,:,:,te_map_tape_rec+1)
!#ifdef TIMING
call timing_on("mapz_module_ad9")
!#endif
#ifdef USE_OPENMP
!oloso pk_aeh(:,:,:) = pk_ae(:,:,:)
!$omp parallel do shared(cp,dz_ad,im,jfirst,jlast,jm,jn2g0,js2g0,km,pk,temp_pk_ae,pkz,pkz_ae,pt,pt_ae,te_ad,u,u_ae,v,v_ae) private(i,j,&
!$omp& k,t2,t2_ad,te_np_ad,te_sp_ad,u2_ad,v2_ad)
#endif /* ! USE_OPENMP */
do k = 1, km
#ifdef USE_OPENMP
!oloso  pk_ae(:,:,k) = 0.d0
!oloso  pk_ae(:,:,k+1) = 0.d0
#endif /* ! USE_OPENMP */
  t2_ad(:,:) = 0.d0
  te_np_ad = 0.d0
  te_sp_ad = 0.d0
  u2_ad(:,:) = 0.d0
  v2_ad(:,:) = 0.d0
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
!oloso      pk_ae(i,j,k+1) = pk_ae(i,j,k+1)+dz_ad(i,j,k)*t2(i,j)
!oloso      pk_ae(i,j,k) = pk_ae(i,j,k)-dz_ad(i,j,k)*t2(i,j)
      temp_pk_ae(i,j,k,1) =  dz_ad(i,j,k)*t2(i,j)
      temp_pk_ae(i,j,k,2) = -dz_ad(i,j,k)*t2(i,j)
      t2_ad(i,j) = t2_ad(i,j)+dz_ad(i,j,k)*(pk(i,j,k+1)-pk(i,j,k))
      dz_ad(i,j,k) = 0.d0
    end do
  end do
  if (jlast .eq. jm) then
    do i = 1, im
      te_np_ad = te_np_ad+te_ad(i,jm,k)
      te_ad(i,jm,k) = 0.d0
    end do
    pkz_ae(1,jm,k) = pkz_ae(1,jm,k)+te_np_ad*t2(1,jm)
    t2_ad(1,jm) = t2_ad(1,jm)+te_np_ad*pkz(1,jm,k)
    te_np_ad = te_np_ad*(0.5/float(im))
    do i = 1, im
      u2_ad(i,jm) = u2_ad(i,jm)+te_np_ad
      v2_ad(i,jm-1) = v2_ad(i,jm-1)+te_np_ad
    end do
    te_np_ad = 0.d0
  endif
  if (jfirst .eq. 1) then
    do i = 1, im
      te_sp_ad = te_sp_ad+te_ad(i,1,k)
      te_ad(i,1,k) = 0.d0
    end do
    pkz_ae(1,1,k) = pkz_ae(1,1,k)+te_sp_ad*t2(1,1)
    t2_ad(1,1) = t2_ad(1,1)+te_sp_ad*pkz(1,1,k)
    te_sp_ad = te_sp_ad*(0.5/float(im))
    do i = 1, im
      u2_ad(i,2) = u2_ad(i,2)+te_sp_ad
      v2_ad(i,2) = v2_ad(i,2)+te_sp_ad
    end do
    te_sp_ad = 0.d0
  endif
  do j = js2g0, jn2g0
    pkz_ae(im,j,k) = pkz_ae(im,j,k)+te_ad(im,j,k)*t2(im,j)
    t2_ad(im,j) = t2_ad(im,j)+te_ad(im,j,k)*pkz(im,j,k)
    u2_ad(im,j+1) = u2_ad(im,j+1)+0.25*te_ad(im,j,k)
    u2_ad(im,j) = u2_ad(im,j)+0.25*te_ad(im,j,k)
    v2_ad(im,j) = v2_ad(im,j)+0.25*te_ad(im,j,k)
    v2_ad(1,j) = v2_ad(1,j)+0.25*te_ad(im,j,k)
    te_ad(im,j,k) = 0.d0
    do i = 1, im-1
      pkz_ae(i,j,k) = pkz_ae(i,j,k)+te_ad(i,j,k)*t2(i,j)
      t2_ad(i,j) = t2_ad(i,j)+te_ad(i,j,k)*pkz(i,j,k)
      u2_ad(i,j+1) = u2_ad(i,j+1)+0.25*te_ad(i,j,k)
      u2_ad(i,j) = u2_ad(i,j)+0.25*te_ad(i,j,k)
      v2_ad(i+1,j) = v2_ad(i+1,j)+0.25*te_ad(i,j,k)
      v2_ad(i,j) = v2_ad(i,j)+0.25*te_ad(i,j,k)
      te_ad(i,j,k) = 0.d0
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      pt_ae(i,j,k) = pt_ae(i,j,k)+t2_ad(i,j)*cp
      t2_ad(i,j) = 0.d0
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v_ae(i,j,k) = v_ae(i,j,k)+2*v2_ad(i,j)*v(i,j,k)
      v2_ad(i,j) = 0.d0
    end do
  end do
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u_ae(i,j,k) = u_ae(i,j,k)+2*u2_ad(i,j)*u(i,j,k)
      u2_ad(i,j) = 0.d0
    end do
  end do
#ifdef USE_OPENMP
!oloso  !$omp critical  (adtaf)
!oloso  pk_aeh(:,:,k+1) = pk_aeh(:,:,k+1)+pk_ae(:,:,k+1)
!oloso  pk_aeh(:,:,k) = pk_aeh(:,:,k)+pk_ae(:,:,k)
!oloso  !$omp end critical (adtaf)
#endif /* ! USE_OPENMP */
end do
!$omp parallel shared(pk_ae,temp_pk_ae) private (k)
!$omp do
do k = 1, km
   pk_ae(:,:,k+1) = pk_ae(:,:,k+1)+temp_pk_ae(:,:,k,1)
enddo
!$omp do
do k = 1, km
   pk_ae(:,:,k) = pk_ae(:,:,k)+temp_pk_ae(:,:,k,2)
enddo
!$omp end parallel
#ifdef USE_OPENMP
!oloso pk_ae(:,:,:) = pk_aeh(:,:,:)
#endif /* ! USE_OPENMP */
!#ifdef TIMING
call timing_off("mapz_module_ad9")
!#endif
pe(:,:,:) = peh(:,:,:)
pk(:,:,:) = pkh(:,:,:)
call pkez_ad( nx,im,km,jfirst,jlast,pe,pe_ae,pk,pk_ae,akap,ks,peln,peln_ad,pkz_ae, .false.  )

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine te_map_ad


subroutine te_mapmd( consv, convt, ps, omga, pe, delp, pkz, pk, mdt, im, jm, km, nx, jfirst, jlast, nq, u, v, pt, q, hs, cp, akap, &
&kord, peln, te0, ng_d, ng_s, te_map_tape_rec )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use te_map_ad_store, only : te_map_tape_delp_15h,te_map_tape_dtmp_18h,te_map_tape_dz_8h,te_map_tape_pe_14h,te_map_tape_peln_12h,&
&te_map_tape_pk_1h,te_map_tape_pkz_13h,te_map_tape_pkz_2h,te_map_tape_te_11h,te_map_tape_te_19h,te_map_tape_te_9h,&
&te_map_tape_te_map,te_map_tape_tsum_16h,te_map_tape_u_17h,te_map_tape_u_6h,te_map_tape_v_10h,te_map_tape_v_7h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
logical :: consv
logical :: convt
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: hs(im,jfirst:jlast)
integer :: jm
integer :: kord
integer :: mdt
integer :: ng_d
integer :: ng_s
integer :: nq
integer :: nx
real(kind=r8) :: omga(im,km,jfirst:jlast)
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: peln(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst:jlast,km+1)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: ps(im,jfirst:jlast)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: q(im,jfirst-ng_d:jlast+ng_d,km,nq)
real(kind=r8) :: te0
integer :: te_map_tape_rec
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: bkh
real(kind=r8) :: bte(im)
real(kind=r8) :: dak
real(kind=r8) :: dlnp
real(kind=r8) :: dtmp
real(kind=r8) :: dz(im,jfirst:jlast,km)
real(kind=r8) :: gz(im)
integer :: help_h
integer :: help_i
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jn2g0
integer :: jp
integer :: js2g0
integer :: k
integer :: krd
real(kind=r8) :: pe0(im,km+1)
real(kind=r8) :: pe1(im,km+1)
real(kind=r8) :: pe1w(km+1)
real(kind=r8) :: pe2(im,km+1)
real(kind=r8) :: pe2w(km+1)
real(kind=r8) :: pe3(im,km+1)
real(kind=r8) :: phis(im,km+1)
real(kind=r8) :: rg
real(kind=r8) :: t2(im,jfirst:jlast)
real(kind=r8) :: te(im,jfirst:jlast,km)
real(kind=r8) :: te1
real(kind=r8) :: te_np
real(kind=r8) :: te_sp
real(kind=r8) :: tsum
real(kind=r8) :: tte(jfirst:jlast)
real(kind=r8) :: tvm
real(kind=r8) :: u2(im,jfirst:jlast+1)
real(kind=r8) :: v2(im,jfirst:jlast)
real(kind=r8) :: xsum
real(kind=r8) :: ysum

!**********************************************
! executable statements of routine
!**********************************************
js2g0 = max(2,jfirst)
jn2g0 = min(jm-1,jlast)
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .false.  )
if ( .not. allocated(te_map_tape_pk_1h)) then
  allocate( te_map_tape_pk_1h(1:im,1:1+jlast-jfirst,1:1+km,te_map_tape_te_map) )
endif
te_map_tape_pk_1h(:,:,:,te_map_tape_rec+1) = pk
if ( .not. allocated(te_map_tape_pkz_2h)) then
  allocate( te_map_tape_pkz_2h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_pkz_2h(:,:,:,te_map_tape_rec+1) = pkz
if ( .not. allocated(te_map_tape_u_6h)) then
  allocate( te_map_tape_u_6h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,te_map_tape_te_map) )
endif
te_map_tape_u_6h(:,:,:,te_map_tape_rec+1) = u
if ( .not. allocated(te_map_tape_v_7h)) then
  allocate( te_map_tape_v_7h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,te_map_tape_te_map) )
endif
te_map_tape_v_7h(:,:,:,te_map_tape_rec+1) = v
#ifdef TIMING
call timing_on("mapz_module_ad10")
#endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,t2,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = jfirst, jlast
    do i = 1, im
      t2(i,j) = cp*pt(i,j,k)
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = 0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))+t2(i,j)*pkz(i,j,k)
    end do
    te(im,j,k) = 0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))+t2(im,j)*pkz(im,j,k)
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = 0.5*te_sp/float(im)+t2(1,1)*pkz(1,1,k)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = 0.5*te_np/float(im)+t2(1,jm)*pkz(1,jm,k)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
  do j = jfirst, jlast
    do i = 1, im
      dz(i,j,k) = t2(i,j)*(pk(i,j,k+1)-pk(i,j,k))
    end do
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad10")
#endif
if ( .not. allocated(te_map_tape_dz_8h)) then
  allocate( te_map_tape_dz_8h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_dz_8h(:,:,:,te_map_tape_rec+1) = dz
if ( .not. allocated(te_map_tape_te_9h)) then
  allocate( te_map_tape_te_9h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_9h(:,:,:,te_map_tape_rec+1) = te
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef TIMING
call timing_on("mapz_module_ad11")
#endif
#ifdef USE_OPENMP
!$omp parallel do private(bkh,dak,help_h,help_i,i,i1,i2,ixj,j,k,krd,pe0,pe1,pe1w,pe2,pe2w,pe3,phis)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do k = 1, km+1
    do i = i1, i2
      pe1(i,k) = pe(i,k,j)
    end do
    if (i1 .eq. 1) then
      pe1w(k) = pe(im,k,j)
    else
      pe1w(k) = pe(i1-1,k,j)
    endif
  end do
  do k = 1, ks+1
    do i = i1, i2
      pe0(i,k) = ak(k)
      pe2(i,k) = ak(k)
      pe3(i,k) = ak(k)
    end do
  end do
  do k = ks+2, km
    do i = i1, i2
      pe0(i,k) = ak(k)+bk(k)*ps(i,j)
      pe2(i,k) = ak(k)+bk(k)*pe1(i,km+1)
    end do
  end do
  do i = i1, i2
    pe0(i,km+1) = ps(i,j)
    pe2(i,km+1) = pe1(i,km+1)
  end do
  do k = ks+2, km
    pe2w(k) = ak(k)+bk(k)*pe1w(km+1)
  end do
  pe2w(km+1) = pe1w(km+1)
  do k = 2, km+1
    do i = i1, i2
      pe0(i,k) = pe1(i,k)-pe0(i,k)
    end do
  end do
  do i = i1, i2
    ps(i,j) = pe1(i,km+1)
  end do
  if (ks .ne. 0) then
    do k = 1, ks
      dak = ak(k+1)-ak(k)
      do i = i1, i2
        delp(i,j,k) = dak
      end do
    end do
  endif
  do k = ks+1, km
    do i = i1, i2
      delp(i,j,k) = pe2(i,k+1)-pe2(i,k)
    end do
  end do
  do i = i1, i2
    phis(i,km+1) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      phis(i,k) = phis(i,k+1)+dz(i,j,k)
    end do
  end do
  do k = 1, km+1
    do i = i1, i2
      phis(i,k) = phis(i,k)*pe1(i,k)
    end do
  end do
  do k = 1, km
    do i = i1, i2
      te(i,j,k) = te(i,j,k)+(phis(i,k+1)-phis(i,k))/(pe1(i,k+1)-pe1(i,k))
    end do
  end do
  call map1_ppm( km,pe1,te,km,pe2,te,0,0,im,i1,i2,j,jfirst,jlast,1,kord )
  if (nq .ne. 0) then
    if (kord .eq. 8) then
      krd = 8
    else
      krd = 7
    endif
    call mapn_ppm( km,pe1,q,nq,km,pe2,q,ng_d,ng_d,im,i1,i2,j,jfirst,jlast,0,krd )
  endif
  if (j .ne. 1) then
    if (j .gt. jfirst) then
      do k = 2, km+1
        do i = i1, i2
          pe0(i,k) = 0.5*(pe1(i,k)+pe(i,k,j-1))
        end do
      end do
      do k = ks+2, km+1
        bkh = 0.5*bk(k)
        do i = i1, i2
          pe3(i,k) = ak(k)+bkh*(pe1(i,km+1)+pe(i,km+1,j-1))
        end do
      end do
    endif
    help_h = -1
    call map1_ppm( km,pe0,u,km,pe3,u,ng_d,ng_s,im,i1,i2,j,jfirst,jlast,help_h,kord )
  endif
  if (j .ne. 1 .and. j .ne. jm) then
    do k = 2, km+1
      pe0(i1,k) = 0.5*(pe1(i1,k)+pe1w(k))
      do i = i1+1, i2
        pe0(i,k) = 0.5*(pe1(i,k)+pe1(i-1,k))
      end do
    end do
    do k = ks+2, km+1
      pe3(i1,k) = 0.5*(pe2(i1,k)+pe2w(k))
      do i = i1+1, i2
        pe3(i,k) = 0.5*(pe2(i,k)+pe2(i-1,k))
      end do
    end do
    help_i = -1
    call map1_ppm( km,pe0,v,km,pe3,v,ng_s,ng_d,im,i1,i2,j,jfirst,jlast,help_i,kord )
  endif
  do k = 2, km
    do i = i1, i2
      peln(i,k,j) = pe2(i,k)
    end do
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad11")
#endif
if ( .not. allocated(te_map_tape_v_10h)) then
  allocate( te_map_tape_v_10h(1:im,1:1+jlast+ng_d-(jfirst-ng_s),1:km,te_map_tape_te_map) )
endif
te_map_tape_v_10h(:,:,:,te_map_tape_rec+1) = v
if ( .not. allocated(te_map_tape_te_11h)) then
  allocate( te_map_tape_te_11h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_11h(:,:,:,te_map_tape_rec+1) = te
#ifdef TIMING
call timing_on("mapz_module_ad12")
#endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  do k = 2, km
    do i = 1, im
      pe(i,k,j) = peln(i,k,j)
    end do
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad12")
#endif
call pkez( nx,im,km,jfirst,jlast,pe,pk,akap,ks,peln,pkz, .true.  )
if ( .not. allocated(te_map_tape_peln_12h)) then
  allocate( te_map_tape_peln_12h(1:im,1:1+km,1:1+jlast-jfirst,te_map_tape_te_map) )
endif
te_map_tape_peln_12h(:,:,:,te_map_tape_rec+1) = peln
if ( .not. allocated(te_map_tape_pkz_13h)) then
  allocate( te_map_tape_pkz_13h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_pkz_13h(:,:,:,te_map_tape_rec+1) = pkz
if ( .not. allocated(te_map_tape_pe_14h)) then
  allocate( te_map_tape_pe_14h(1:im,1:1+km,1:1+jlast-jfirst,te_map_tape_te_map) )
endif
te_map_tape_pe_14h(:,:,:,te_map_tape_rec+1) = pe
if ( .not. allocated(te_map_tape_delp_15h)) then
  allocate( te_map_tape_delp_15h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_delp_15h(:,:,:,te_map_tape_rec+1) = delp
if (consv) then
#ifdef TIMING
call timing_on("mapz_module_ad13")
#endif
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,k)
#endif /* ! USE_OPENMP */
  do k = 1, km
    do j = jfirst, jlast
      do i = 1, im
        dz(i,j,k) = te(i,j,k)*delp(i,j,k)
      end do
    end do
  end do
#ifdef USE_OPENMP
  !$omp parallel do private(bte,i,j,k,xsum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = 0.
      do k = 1, km
        tte(1) = tte(1)+dz(1,1,k)
      end do
      tte(1) = te_acap*tte(1)
    else if (j .eq. jm) then
      tte(jm) = 0.
      do k = 1, km
        tte(jm) = tte(jm)+dz(1,jm,k)
      end do
      tte(jm) = te_acap*tte(jm)
    else
      do i = 1, im
        bte(i) = 0.
      end do
      do k = 1, km
        do i = 1, im
          bte(i) = bte(i)+dz(i,j,k)
        end do
      end do
      xsum = 0.
      do i = 1, im
        xsum = xsum+bte(i)
      end do
      tte(j) = xsum*te_cosp(j)
    endif
  end do
#ifdef TIMING
call timing_off("mapz_module_ad13")
#endif
  call par_vecsum( jm,jfirst,jlast,tte,te1 )
#ifdef TIMING
call timing_on("mapz_module_ad14")
#endif
#ifdef USE_OPENMP
  !$omp parallel do private(i,j,xsum,ysum) ! broadcast()
#endif /* ! USE_OPENMP */
  do j = jfirst, jlast
    if (j .eq. 1) then
      tte(1) = te_acap*cp*(ps(1,1)-2.*te_ptop-akap*te_ptop*(peln(1,km+1,1)-peln(1,1,1)))
    else if (j .eq. jm) then
      tte(jm) = te_acap*cp*(ps(1,jm)-akap*te_ptop*(peln(1,km+1,jm)-peln(1,1,jm)))
    else
      xsum = 0.
      ysum = 0.
      do i = 1, im
        xsum = xsum+ps(i,j)
        ysum = ysum+peln(i,km+1,j)
      end do
      tte(j) = cp*te_cosp(j)*(xsum-te_ptop*im-akap*te_ptop*(ysum-peln(1,1,j)*im))
    endif
  end do
#ifdef TIMING
call timing_off("mapz_module_ad14")
#endif
  call par_vecsum( jm,jfirst,jlast,tte,tsum )
  if ( .not. allocated(te_map_tape_tsum_16h)) then
    allocate( te_map_tape_tsum_16h(te_map_tape_te_map) )
  endif
  te_map_tape_tsum_16h(te_map_tape_rec+1) = tsum
  dtmp = (te0-te1)/tsum
else
  dtmp = 0.
endif
if ( .not. allocated(te_map_tape_u_17h)) then
  allocate( te_map_tape_u_17h(1:im,1:1+jlast+ng_s-(jfirst-ng_d),1:km,te_map_tape_te_map) )
endif
te_map_tape_u_17h(:,:,:,te_map_tape_rec+1) = u
if ( .not. allocated(te_map_tape_dtmp_18h)) then
  allocate( te_map_tape_dtmp_18h(te_map_tape_te_map) )
endif
te_map_tape_dtmp_18h(te_map_tape_rec+1) = dtmp
#ifdef TIMING
call timing_on("mapz_module_ad15")
#endif
#ifdef USE_OPENMP
!$omp parallel do private(i,j,k,te_np,te_sp,u2,v2)
#endif /* ! USE_OPENMP */
do k = 1, km
  do j = js2g0, min(jlast+1,jm)
    do i = 1, im
      u2(i,j) = u(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im
      v2(i,j) = v(i,j,k)**2
    end do
  end do
  do j = js2g0, jn2g0
    do i = 1, im-1
      te(i,j,k) = te(i,j,k)-0.25*(u2(i,j)+u2(i,j+1)+v2(i,j)+v2(i+1,j))
    end do
    te(im,j,k) = te(im,j,k)-0.25*(u2(im,j)+u2(im,j+1)+v2(im,j)+v2(1,j))
  end do
  if (jfirst .eq. 1) then
    te_sp = 0.
    do i = 1, im
      te_sp = te_sp+u2(i,2)+v2(i,2)
    end do
    te_sp = te(1,1,k)-0.5*te_sp/float(im)
    do i = 1, im
      te(i,1,k) = te_sp
    end do
  endif
  if (jlast .eq. jm) then
    te_np = 0.
    do i = 1, im
      te_np = te_np+u2(i,jm)+v2(i,jm-1)
    end do
    te_np = te(1,jm,k)-0.5*te_np/float(im)
    do i = 1, im
      te(i,jm,k) = te_np
    end do
  endif
end do
#ifdef TIMING
call timing_off("mapz_module_ad15")
#endif
if ( .not. allocated(te_map_tape_te_19h)) then
  allocate( te_map_tape_te_19h(1:im,1:1+jlast-jfirst,1:km,te_map_tape_te_map) )
endif
te_map_tape_te_19h(:,:,:,te_map_tape_rec+1) = te
#ifdef TIMING
call timing_on("mapz_module_ad16")
#endif
#ifdef USE_OPENMP
!$omp parallel do private(dlnp,gz,i,i1,i2,ixj,j,k,rg,tvm) ! broadcast()
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  rg = akap*cp
  do i = i1, i2
    gz(i) = hs(i,j)
  end do
  do k = km, 1, -1
    do i = i1, i2
      dlnp = rg*(peln(i,k+1,j)-peln(i,k,j))
      tvm = delp(i,j,k)*(te(i,j,k)-gz(i))/(cp*delp(i,j,k)-pe(i,k,j)*dlnp)
      gz(i) = gz(i)+dlnp*tvm
      pt(i,j,k) = tvm
    end do
    if (consv) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)+dtmp
      end do
    endif
    if ( .not. convt) then
      do i = i1, i2
        pt(i,j,k) = pt(i,j,k)/pkz(i,j,k)
      end do
    endif
  end do
end do
#ifdef TIMING
call timing_off("mapz_module_ad16")
#endif
end subroutine te_mapmd


end module     mapz_module_ad


#endif /* SPMD */
