#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     hswf_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use hswf

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine hswf_do_ad( im, jm, km, jfirst, jlast, u, u_ae, v, v_ae, pt, pt_ae, pe, pe_ae, pkz, pkz_ae, pdt, akap, dcaf, strat, &
&rayf, cosp, coslon, sinlon, ng_s, ng_d )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use mod_comm, only : gid,gsize,mp_barrier, mp_recv_n, mp_recv_pe, mp_recv_pe_ad, mp_recv_ua, mp_recv_ua_ad, mp_send_pe, &
&mp_send_pe_ad, mp_send_s, mp_send_ua, mp_send_ua_ad
use dry_adj_ad_store, only : dry_adj_tape_dp_2h,dry_adj_tape_dry_adj,dry_adj_tape_pt_1h,dry_adj_tape_u_3h,dry_adj_tape_v_4h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
integer :: im
real(kind=r8) :: coslon(im)
integer :: jm
real(kind=r8) :: cosp(jm)
logical :: dcaf
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
integer :: ng_s
integer :: pdt
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_ae(im,km+1,jfirst:jlast)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_ae(im,jfirst:jlast,km)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_ae(im,jfirst-ng_d:jlast+ng_d,km)
logical :: rayf
real(kind=r8) :: sinlon(im)
logical :: strat
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_ae(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_ae(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: algpk
real(kind=r8) :: ap0k
real(kind=r8) :: dp(im,km)
real(kind=r8) :: dp_ad(im,km)
real(kind=r8) :: dt_tropic
real(kind=r8) :: dt_tropic_ad
real(kind=r8) :: dz
real(kind=r8) :: dz_ad
real(kind=r8) :: f1
real(kind=r8) :: f1_ad
real(kind=r8) :: fac
real(kind=r8) :: fac_ad
real(kind=r8) :: frac(im,jm)
real(kind=r8) :: frac_ad(im,jm)
real(kind=r8) :: fu(im,km)
real(kind=r8) :: fu_ad(im,km)
real(kind=r8) :: fv(im,km)
real(kind=r8) :: fv_ad(im,km)
real(kind=r8) :: h0
integer :: help_h
integer :: help_i
integer :: hswf_tape_hswf_do
real(kind=4), allocatable :: hswf_tape_pt_2h(:,:)
real(kind=4), allocatable :: hswf_tape_teq_1h(:,:)
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
integer :: js2gm1
integer :: k
integer :: kb1
real(kind=r8) :: p0
#ifdef USE_OPENMP
real(kind=r8) :: pe_aeh(im,km+1,jfirst:jlast)
#endif /* ! USE_OPENMP */
real(kind=r8), allocatable :: pesouth(:,:)
real(kind=r8), allocatable :: pesouth_ae(:,:)
#ifdef USE_OPENMP
real(kind=r8), allocatable :: pesouth_aeh(:,:)
#endif /* ! USE_OPENMP */
real(kind=r8) :: pl(im,km+1)
real(kind=r8) :: pl_ad(im,km+1)
real(kind=r8) :: pth(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: rdt
real(kind=r8) :: relx
real(kind=r8) :: relx_ad
real(kind=r8) :: rka
real(kind=r8) :: rks
real(kind=r8) :: rkt
real(kind=r8) :: rkt_ad
real(kind=r8) :: rkv
real(kind=r8) :: rmr
real(kind=r8) :: rms
real(kind=r8) :: rsgb
real(kind=r8) :: sday
real(kind=r8) :: sigb
real(kind=r8) :: sigl
real(kind=r8) :: sigl_ad
real(kind=r8) :: t0
real(kind=r8) :: t2(im,km)
real(kind=r8) :: t2_ad(im,km)
real(kind=r8) :: t_ms
real(kind=r8) :: t_st
real(kind=r8) :: tau
real(kind=r8) :: teq(im,km)
real(kind=r8) :: teq_ad(im,km)
real(kind=r8) :: tey
real(kind=r8) :: tez
real(kind=r8) :: tmin
real(kind=r8) :: tmin_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad
real(kind=r8) :: u2(im,km)
real(kind=r8) :: u2_ad(im,km)
real(kind=r8) :: ua(im,jfirst:jlast,km)
real(kind=r8) :: ua_ad(im,jfirst:jlast,km)
real(kind=r8) :: uah(im,jfirst:jlast,km)
real(kind=r8), allocatable :: uasouth(:,:)
real(kind=r8), allocatable :: uasouth_ad(:,:)
real(kind=r8) :: uh(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v2(im,km)
real(kind=r8) :: v2_ad(im,km)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_ad(im,jfirst:jlast,km)
real(kind=r8) :: vah(im,jfirst:jlast,km)
real(kind=r8) :: vh(im,jfirst-ng_s:jlast+ng_d,km)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
vah(:,:,:) = va(:,:,:)
vh(:,:,:) = v(:,:,:)
uah(:,:,:) = ua(:,:,:)
uh(:,:,:) = u(:,:,:)
pth(:,:,:) = pt(:,:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dp_ad(:,:) = 0.d0
dt_tropic_ad = 0.d0
dz_ad = 0.d0
f1_ad = 0.d0
fac_ad = 0.d0
frac_ad(:,:) = 0.d0
fu_ad(:,:) = 0.d0
fv_ad(:,:) = 0.d0
pl_ad(:,:) = 0.d0
relx_ad = 0.d0
rkt_ad = 0.d0
sigl_ad = 0.d0
t2_ad(:,:) = 0.d0
teq_ad(:,:) = 0.d0
tmin_ad = 0.d0
tmp_ad = 0.d0
u2_ad(:,:) = 0.d0
ua_ad(:,:,:) = 0.d0
v2_ad(:,:) = 0.d0
va_ad(:,:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gm1 = max(2,jfirst+1)
jn2g0 = min(jm-1,jlast)
p0 = 1.e+5
t0 = 200.
h0 = 7.
sday = 24*3600
rkv = 0.5*pdt/sday
rka = pdt/(40.*sday)
rks = pdt/(4.*sday)
t_ms = 10.
t_st = 40.
tau = (t_st-t_ms)/log(100.)
rms = pdt/(t_ms*sday)
rmr = 1./(1.+rms)
sigb = 0.7
rsgb = 1./(1.-sigb)
ap0k = 1./p0**akap
algpk = log(ap0k)
if (dcaf) then
  call d2a3d( u,v,ua,va,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif
#ifdef USE_OPENMP
!$omp parallel do private(dp,dt_tropic,dz,f1,fu,fv,i,j,k,pl,rdt,relx,rkt,sigl,t2,teq,tey,tez,tmin,tmp,u2,v2)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl(i,km+1) = pl(i,km)
  end do
  teq = 0.
  do k = km, 1, -1
    do i = 1, im
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx = pdt/(relx*sday)
        dt_tropic = 2.25*cosp(j)*dz
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+relx*teq(i,k))/(1.+relx)
      else if (strat .and. pl(i,k) .le. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq(i,k) = tmp/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+rms*teq(i,k))*rmr
      else
        sigl = pl(i,k)/pe(i,km+1,j)
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin = t0/pkz(i,j,k)
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq(i,k) = max(tmin,teq(i,k))
        rkt = rka+(rks-rka)*f1*cosp4(j)
        pt(i,j,k) = (pt(i,j,k)+rkt*teq(i,k))/(1.+rkt)
      endif
    end do
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        dp(i,k) = pe(i,k+1,j)-pe(i,k,j)
        fu(i,k) = 0.
        fv(i,k) = 0.
        u2(i,k) = ua(i,j,k)
        v2(i,k) = va(i,j,k)
        t2(i,k) = pt(i,j,k)
      end do
    end do
    rdt = 1./pdt
    call dry_adj( im,km,rdt,t2,fu,fv,u2,v2,dp,j )
    do k = 1, km
      v(1,j,k) = v(1,j,k)+0.5*(fv(1,k)+fv(im,k))
      do i = 2, im
        v(i,j,k) = v(i,j,k)+0.5*(fv(i,k)+fv(i-1,k))
      end do
      do i = 1, im
        ua(i,j,k) = fu(i,k)
        pt(i,j,k) = t2(i,k)
      end do
    end do
  endif
end do
allocate( uasouth(im,km) )
allocate( pesouth(im,km+1) )
if (dcaf) then
  call mp_send_ua( im,jm,jfirst,jlast,1,km,ua )
  call mp_recv_ua( im,jm,jfirst,jlast,1,km,uasouth )
endif
help_h = km+1
call mp_send_pe( im,jm,jfirst,jlast,1,help_h,pe )
help_i = km+1
call mp_recv_pe( im,jm,jfirst,jlast,1,help_i,pesouth )
allocate( uasouth_ad(im,km) )
uasouth_ad = 0.
allocate( pesouth_ae(im,km+1) )
pesouth_ae = 0.
#ifdef USE_OPENMP
pe_aeh(:,:,:) = pe_ae(:,:,:)
pesouth_aeh(:,:) = pesouth_ae(:,:)
!$omp parallel do shared(dcaf,im,jfirst,jlast,jn2g0,js2g0,js2gm1,km,ks,pe,pe_aeh,pesouth,pesouth_aeh,rayf,rf,rkv,rsgb,sigb,u,u_ae,&
!$omp& ua,ua_ad,uasouth,uasouth_ad,v,v_ae) private(fac,fac_ad,frac,frac_ad,i,j,k,pe_ae,pesouth_ae,sigl,sigl_ad)
#endif /* ! USE_OPENMP */
do k = 1, km
#ifdef USE_OPENMP
  pe_ae(:,:,:) = 0.
  pesouth_ae(:,:) = 0.
#endif /* ! USE_OPENMP */
  fac_ad = 0.d0
  frac_ad(:,:) = 0.d0
  sigl_ad = 0.d0
  if (dcaf) then
    do j = js2gm1, jlast
      do i = 1, im
        u(i,j,k) = u(i,j,k)+0.5*(ua(i,j,k)+ua(i,j-1,k))
      end do
    end do
    if (jfirst .gt. 1) then
      do i = 1, im
        u(i,jfirst,k) = u(i,jfirst,k)+0.5*(ua(i,jfirst,k)+uasouth(i,k))
      end do
    endif
  endif
  if (rayf .and. k .le. ks) then
    do j = js2g0, jn2g0
      do i = 1, im
        v_ae(i,j,k) = v_ae(i,j,k)*rf(k)
      end do
    end do
    do j = js2g0, jlast
      do i = 1, im
        u_ae(i,j,k) = u_ae(i,j,k)*rf(k)
      end do
    end do
  else
    do j = jfirst, jlast
      do i = 1, im
        sigl = 0.5*(pe(i,k,j)+pe(i,k+1,j))/pe(i,km+1,j)
        frac(i,j) = max(0._8,(sigl-sigb)*rsgb)
      end do
    end do
    if (jfirst .gt. 1) then
      do i = 1, im
        sigl = 0.5*(pesouth(i,k)+pesouth(i,k+1))/pesouth(i,km+1)
        frac(i,jfirst-1) = max(0._8,(sigl-sigb)*rsgb)
      end do
    endif
    do j = js2g0, jn2g0
      do i = 2, im
        fac = frac(i,j)+frac(i-1,j)
        if (fac .gt. 0.) then
          v(i,j,k) = v(i,j,k)/(1.+rkv*fac)
        endif
      end do
    end do
    do j = js2g0, jn2g0
      fac_ad = 0.d0
      fac = frac(1,j)+frac(im,j)
      if (fac .gt. 0.) then
        fac_ad = fac_ad-v_ae(1,j,k)*(v(1,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))
        v_ae(1,j,k) = v_ae(1,j,k)/(1.+rkv*fac)
      endif
      frac_ad(im,j) = frac_ad(im,j)+fac_ad
      frac_ad(1,j) = frac_ad(1,j)+fac_ad
      fac_ad = 0.d0
    end do
    pt(:,:,:) = pth(:,:,:)
    v(:,:,:) = vh(:,:,:)
#ifdef USE_OPENMP
    !$omp parallel do private(dp,dt_tropic,dz,f1,fu,fv,i,j,k,pl,rdt,relx,rkt,sigl,t2,teq,tey,tez,tmin,tmp,u2,v2)
#endif /* ! USE_OPENMP */
    do j = jfirst, jlast
      tey = ap0k*(315.-60.*sinp2(j))
      tez = ap0k*10./akap*cosp2(j)
      do kb1 = 1, km
        do i = 1, im
          pl(i,kb1) = 0.5*(pe(i,kb1,j)+pe(i,kb1+1,j))
        end do
      end do
      do i = 1, im
        pl(i,km+1) = pl(i,km)
      end do
      teq = 0.
      do kb1 = km, 1, -1
        do i = 1, im
          if (strat .and. pl(i,kb1) .lt. 1.e+4 .and. pl(i,kb1) .gt. 100.) then
            dz = h0*log(pl(i,kb1+1)/pl(i,kb1))
            relx = t_ms+tau*log(0.01*pl(i,kb1))
            relx = pdt/(relx*sday)
            dt_tropic = 2.25*cosp(j)*dz
            teq(i,kb1) = (teq(i,kb1+1)*pkz(i,j,kb1+1)+dt_tropic)/pkz(i,j,kb1)
            pt(i,j,kb1) = (pt(i,j,kb1)+relx*teq(i,kb1))/(1.+relx)
          else if (strat .and. pl(i,kb1) .le. 100.) then
            dz = h0*log(pl(i,kb1+1)/pl(i,kb1))
            dt_tropic = -(2.25*cosp(j)*dz)
            tmp = teq(i,kb1+1)*pkz(i,j,kb1+1)+dt_tropic
            teq(i,kb1) = tmp/pkz(i,j,kb1)
            pt(i,j,kb1) = (pt(i,j,kb1)+rms*teq(i,kb1))*rmr
          else
            sigl = pl(i,kb1)/pe(i,km+1,j)
            f1 = max(0._8,(sigl-sigb)*rsgb)
            tmin = t0/pkz(i,j,kb1)
            teq(i,kb1) = tey-tez*(log(pkz(i,j,kb1))+algpk)
            teq(i,kb1) = max(tmin,teq(i,kb1))
            rkt = rka+(rks-rka)*f1*cosp4(j)
            pt(i,j,kb1) = (pt(i,j,kb1)+rkt*teq(i,kb1))/(1.+rkt)
          endif
        end do
      end do
      if (dcaf) then
        do kb1 = 1, km
          do i = 1, im
            dp(i,kb1) = pe(i,kb1+1,j)-pe(i,kb1,j)
            fu(i,kb1) = 0.
            fv(i,kb1) = 0.
            u2(i,kb1) = ua(i,j,kb1)
            v2(i,kb1) = va(i,j,kb1)
            t2(i,kb1) = pt(i,j,kb1)
          end do
        end do
        rdt = 1./pdt
        call dry_adj( im,km,rdt,t2,fu,fv,u2,v2,dp,j )
        do kb1 = 1, km
          v(1,j,kb1) = v(1,j,kb1)+0.5*(fv(1,kb1)+fv(im,kb1))
          do i = 2, im
            v(i,j,kb1) = v(i,j,kb1)+0.5*(fv(i,kb1)+fv(i-1,kb1))
          end do
          do i = 1, im
            pt(i,j,kb1) = t2(i,kb1)
          end do
        end do
      endif
    end do
    do j = js2g0, jn2g0
      fac_ad = 0.d0
      do i = 2, im
        fac_ad = 0.d0
        fac = frac(i,j)+frac(i-1,j)
        if (fac .gt. 0.) then
          fac_ad = fac_ad-v_ae(i,j,k)*(v(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))
          v_ae(i,j,k) = v_ae(i,j,k)/(1.+rkv*fac)
        endif
        frac_ad(i-1,j) = frac_ad(i-1,j)+fac_ad
        frac_ad(i,j) = frac_ad(i,j)+fac_ad
        fac_ad = 0.d0
      end do
    end do
    do j = js2g0, jlast
      fac_ad = 0.d0
      do i = 1, im
        fac_ad = 0.d0
        fac = frac(i,j)+frac(i,j-1)
        if (fac .gt. 0.) then
          fac_ad = fac_ad-u_ae(i,j,k)*(u(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))
          u_ae(i,j,k) = u_ae(i,j,k)/(1.+rkv*fac)
        endif
        frac_ad(i,j-1) = frac_ad(i,j-1)+fac_ad
        frac_ad(i,j) = frac_ad(i,j)+fac_ad
        fac_ad = 0.d0
      end do
    end do
    if (jfirst .gt. 1) then
      do i = 1, im
        sigl_ad = 0.d0
        sigl = 0.5*(pesouth(i,k)+pesouth(i,k+1))/pesouth(i,km+1)
        sigl_ad = sigl_ad+frac_ad(i,jfirst-1)*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        frac_ad(i,jfirst-1) = 0.d0
        pesouth_ae(i,k+1) = pesouth_ae(i,k+1)+sigl_ad*(0.5/pesouth(i,km+1))
        pesouth_ae(i,km+1) = pesouth_ae(i,km+1)-sigl_ad*(0.5*(pesouth(i,k)+pesouth(i,k+1))/(pesouth(i,km+1)*pesouth(i,km+1)))
        pesouth_ae(i,k) = pesouth_ae(i,k)+sigl_ad*(0.5/pesouth(i,km+1))
        sigl_ad = 0.d0
      end do
    endif
    do j = jfirst, jlast
      sigl_ad = 0.d0
      do i = 1, im
        sigl_ad = 0.d0
        sigl = 0.5*(pe(i,k,j)+pe(i,k+1,j))/pe(i,km+1,j)
        sigl_ad = sigl_ad+frac_ad(i,j)*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        frac_ad(i,j) = 0.d0
        pe_ae(i,k+1,j) = pe_ae(i,k+1,j)+sigl_ad*(0.5/pe(i,km+1,j))
        pe_ae(i,km+1,j) = pe_ae(i,km+1,j)-sigl_ad*(0.5*(pe(i,k,j)+pe(i,k+1,j))/(pe(i,km+1,j)*pe(i,km+1,j)))
        pe_ae(i,k,j) = pe_ae(i,k,j)+sigl_ad*(0.5/pe(i,km+1,j))
        sigl_ad = 0.d0
      end do
    end do
  endif
  if (dcaf) then
    if (jfirst .gt. 1) then
      do i = 1, im
        ua_ad(i,jfirst,k) = ua_ad(i,jfirst,k)+0.5*u_ae(i,jfirst,k)
        uasouth_ad(i,k) = uasouth_ad(i,k)+0.5*u_ae(i,jfirst,k)
      end do
    endif
    do j = js2gm1, jlast
      do i = 1, im
        ua_ad(i,j-1,k) = ua_ad(i,j-1,k)+0.5*u_ae(i,j,k)
        ua_ad(i,j,k) = ua_ad(i,j,k)+0.5*u_ae(i,j,k)
      end do
    end do
  endif
#ifdef USE_OPENMP
  !$omp critical  (adtaf)
  pe_aeh(:,:,:) = pe_aeh(:,:,:)+pe_ae(:,:,:)
  pesouth_aeh(:,:) = pesouth_aeh(:,:)+pesouth_ae(:,:)
  !$omp end critical (adtaf)
#endif /* ! USE_OPENMP */
end do
#ifdef USE_OPENMP
pe_ae(:,:,:) = pe_aeh(:,:,:)
pesouth_ae(:,:) = pesouth_aeh(:,:)
#endif /* ! USE_OPENMP */
call mp_recv_pe_ad( im,jm,jfirst,jlast,1,help_i,pesouth_ae )
call mp_send_pe_ad( im,jm,jfirst,jlast,1,help_h,pe_ae )
if (dcaf) then
  call mp_recv_ua_ad( im,jm,jfirst,jlast,1,km,uasouth_ad )
  call mp_send_ua_ad( im,jm,jfirst,jlast,1,km,ua_ad )
endif
deallocate( pesouth_ae )
deallocate( uasouth_ad )
pt(:,:,:) = pth(:,:,:)
u(:,:,:) = uh(:,:,:)
ua(:,:,:) = uah(:,:,:)
v(:,:,:) = vh(:,:,:)
va(:,:,:) = vah(:,:,:)
if (dcaf) then
  call d2a3d( u,v,ua,va,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif
#ifdef USE_OPENMP
!$omp parallel do shared(akap,algpk,ap0k,cosp,cosp2,cosp4,dcaf,h0,im,jfirst,jlast,km,pdt,pe,pe_ae,pkz,pkz_ae,pt,pt_ae,rka,rks,rmr,&
!$omp& rms,rsgb,sday,sigb,sinp2,strat,t0,t_ms,tau,ua,ua_ad,v_ae,va,va_ad) private(dp,dp_ad,dry_adj_tape_dry_adj,dt_tropic,&
!$omp& dt_tropic_ad,dz,dz_ad,f1,f1_ad,fu,fu_ad,fv,fv_ad,hswf_tape_hswf_do,hswf_tape_pt_2h,hswf_tape_teq_1h,i,j,k,pl,pl_ad,rdt,relx,&
!$omp& relx_ad,rkt,rkt_ad,sigl,sigl_ad,t2,t2_ad,teq,teq_ad,tey,tez,tmin,tmin_ad,tmp,tmp_ad,u2,u2_ad,v2,v2_ad)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  dp_ad(:,:) = 0.d0
  dt_tropic_ad = 0.d0
  dz_ad = 0.d0
  f1_ad = 0.d0
  fu_ad(:,:) = 0.d0
  fv_ad(:,:) = 0.d0
  pl_ad(:,:) = 0.d0
  relx_ad = 0.d0
  rkt_ad = 0.d0
  sigl_ad = 0.d0
  t2_ad(:,:) = 0.d0
  teq_ad(:,:) = 0.d0
  tmin_ad = 0.d0
  tmp_ad = 0.d0
  u2_ad(:,:) = 0.d0
  v2_ad(:,:) = 0.d0
!----------------------------------------------
! OPEN TAPE dry_adj_tape
!----------------------------------------------
  dry_adj_tape_dry_adj = im*klow

!----------------------------------------------
! OPEN TAPE hswf_tape
!----------------------------------------------
  hswf_tape_hswf_do = km

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl(i,km+1) = pl(i,km)
  end do
  teq = 0.
  do k = km, 1, -1
    if ( .not. allocated(hswf_tape_teq_1h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(hswf_tape_teq_1h)) then
        allocate( hswf_tape_teq_1h(1:im,hswf_tape_hswf_do) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( hswf_tape_teq_1h(1:im,hswf_tape_hswf_do) )
#endif /* USE_OPENMP */
    endif
    hswf_tape_teq_1h(:,k) = teq(:,k)
    if ( .not. allocated(hswf_tape_pt_2h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(hswf_tape_pt_2h)) then
        allocate( hswf_tape_pt_2h(1:im,hswf_tape_hswf_do) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( hswf_tape_pt_2h(1:im,hswf_tape_hswf_do) )
#endif /* USE_OPENMP */
    endif
    hswf_tape_pt_2h(:,k) = pt(:,j,k)
    do i = 1, im
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx = pdt/(relx*sday)
        dt_tropic = 2.25*cosp(j)*dz
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+relx*teq(i,k))/(1.+relx)
      else if (strat .and. pl(i,k) .le. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq(i,k) = tmp/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+rms*teq(i,k))*rmr
      else
        sigl = pl(i,k)/pe(i,km+1,j)
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin = t0/pkz(i,j,k)
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq(i,k) = max(tmin,teq(i,k))
        rkt = rka+(rks-rka)*f1*cosp4(j)
        pt(i,j,k) = (pt(i,j,k)+rkt*teq(i,k))/(1.+rkt)
      endif
    end do
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        dp(i,k) = pe(i,k+1,j)-pe(i,k,j)
        fu(i,k) = 0.
        fv(i,k) = 0.
        u2(i,k) = ua(i,j,k)
        v2(i,k) = va(i,j,k)
        t2(i,k) = pt(i,j,k)
      end do
    end do
    rdt = 1./pdt
    call dry_adjmd( im,km,rdt,t2,fu,fv,u2,v2,dp,j )
  endif

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl(i,km+1) = pl(i,km)
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        t2_ad(i,k) = t2_ad(i,k)+pt_ae(i,j,k)
        pt_ae(i,j,k) = 0.
        fu_ad(i,k) = fu_ad(i,k)+ua_ad(i,j,k)
        ua_ad(i,j,k) = 0.d0
      end do
      do i = 2, im
        fv_ad(i-1,k) = fv_ad(i-1,k)+0.5*v_ae(i,j,k)
        fv_ad(i,k) = fv_ad(i,k)+0.5*v_ae(i,j,k)
      end do
      fv_ad(im,k) = fv_ad(im,k)+0.5*v_ae(1,j,k)
      fv_ad(1,k) = fv_ad(1,k)+0.5*v_ae(1,j,k)
    end do
    call dry_adj_ad( im,km,rdt,t2,t2_ad,fu_ad,fv_ad,u2,u2_ad,v2,v2_ad,dp,dp_ad )
    do k = 1, km
      do i = 1, im
        pt_ae(i,j,k) = pt_ae(i,j,k)+t2_ad(i,k)
        t2_ad(i,k) = 0.d0
        va_ad(i,j,k) = va_ad(i,j,k)+v2_ad(i,k)
        v2_ad(i,k) = 0.d0
        ua_ad(i,j,k) = ua_ad(i,j,k)+u2_ad(i,k)
        u2_ad(i,k) = 0.d0
        fv_ad(i,k) = 0.d0
        fu_ad(i,k) = 0.d0
        pe_ae(i,k+1,j) = pe_ae(i,k+1,j)+dp_ad(i,k)
        pe_ae(i,k,j) = pe_ae(i,k,j)-dp_ad(i,k)
        dp_ad(i,k) = 0.d0
      end do
    end do
  endif
  do k = 1, km
    teq(:,k) = hswf_tape_teq_1h(:,k)
    pt(:,j,k) = hswf_tape_pt_2h(:,k)
    do i = 1, im
      dt_tropic_ad = 0.d0
      dz_ad = 0.d0
      f1_ad = 0.d0
      relx_ad = 0.d0
      rkt_ad = 0.d0
      sigl_ad = 0.d0
      tmin_ad = 0.d0
      tmp_ad = 0.d0
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx = pdt/(relx*sday)
        dt_tropic = 2.25*cosp(j)*dz
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        relx_ad = relx_ad+pt_ae(i,j,k)*(teq(i,k)/(1.+relx)-(pt(i,j,k)+relx*teq(i,k))/((1.+relx)*(1.+relx)))
        teq_ad(i,k) = teq_ad(i,k)+pt_ae(i,j,k)*(relx/(1.+relx))
        pt_ae(i,j,k) = pt_ae(i,j,k)/(1.+relx)
        teq(:,k) = hswf_tape_teq_1h(:,k)
        dt_tropic_ad = dt_tropic_ad+teq_ad(i,k)/pkz(i,j,k)
        pkz_ae(i,j,k+1) = pkz_ae(i,j,k+1)+teq_ad(i,k)*(teq(i,k+1)/pkz(i,j,k))
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-teq_ad(i,k)*((teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/(pkz(i,j,k)*pkz(i,j,k)))
        teq_ad(i,k+1) = teq_ad(i,k+1)+teq_ad(i,k)*(pkz(i,j,k+1)/pkz(i,j,k))
        teq_ad(i,k) = 0.d0
        dz_ad = dz_ad+2.25*dt_tropic_ad*cosp(j)
        dt_tropic_ad = 0.d0
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx_ad = -(relx_ad*(pdt*sday/(relx*sday*relx*sday)))
        pl_ad(i,k) = pl_ad(i,k)+0.01*relx_ad*tau*(1./(0.01*pl(i,k)))
        relx_ad = 0.d0
        pl_ad(i,k+1) = pl_ad(i,k+1)+dz_ad*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))
        pl_ad(i,k) = pl_ad(i,k)-dz_ad*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz_ad = 0.d0
      else if (strat .and. pl(i,k) .le. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq_ad(i,k) = teq_ad(i,k)+pt_ae(i,j,k)*rms*rmr
        pt_ae(i,j,k) = pt_ae(i,j,k)*rmr
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-teq_ad(i,k)*(tmp/(pkz(i,j,k)*pkz(i,j,k)))
        tmp_ad = tmp_ad+teq_ad(i,k)/pkz(i,j,k)
        teq_ad(i,k) = 0.d0
        dt_tropic_ad = dt_tropic_ad+tmp_ad
        pkz_ae(i,j,k+1) = pkz_ae(i,j,k+1)+tmp_ad*teq(i,k+1)
        teq_ad(i,k+1) = teq_ad(i,k+1)+tmp_ad*pkz(i,j,k+1)
        tmp_ad = 0.d0
        dz_ad = dz_ad-2.25*dt_tropic_ad*cosp(j)
        dt_tropic_ad = 0.d0
        pl_ad(i,k+1) = pl_ad(i,k+1)+dz_ad*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))
        pl_ad(i,k) = pl_ad(i,k)-dz_ad*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz_ad = 0.d0
      else
        sigl = pl(i,k)/pe(i,km+1,j)
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin = t0/pkz(i,j,k)
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq(i,k) = max(tmin,teq(i,k))
        rkt = rka+(rks-rka)*f1*cosp4(j)
        rkt_ad = rkt_ad+pt_ae(i,j,k)*(teq(i,k)/(1.+rkt)-(pt(i,j,k)+rkt*teq(i,k))/((1.+rkt)*(1.+rkt)))
        teq_ad(i,k) = teq_ad(i,k)+pt_ae(i,j,k)*(rkt/(1.+rkt))
        pt_ae(i,j,k) = pt_ae(i,j,k)/(1.+rkt)
        f1_ad = f1_ad+rkt_ad*(rks-rka)*cosp4(j)
        rkt_ad = 0.d0
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        tmin_ad = tmin_ad+teq_ad(i,k)*(0.5+sign(0.5d0,tmin-teq(i,k)))
        teq_ad(i,k) = teq_ad(i,k)*(0.5-sign(0.5d0,tmin-teq(i,k)))
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-teq_ad(i,k)*tez*(1./pkz(i,j,k))
        teq_ad(i,k) = 0.d0
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-tmin_ad*(t0/(pkz(i,j,k)*pkz(i,j,k)))
        tmin_ad = 0.d0
        sigl_ad = sigl_ad+f1_ad*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        f1_ad = 0.d0
        pe_ae(i,km+1,j) = pe_ae(i,km+1,j)-sigl_ad*(pl(i,k)/(pe(i,km+1,j)*pe(i,km+1,j)))
        pl_ad(i,k) = pl_ad(i,k)+sigl_ad/pe(i,km+1,j)
        sigl_ad = 0.d0
      endif
    end do
  end do
  teq_ad = 0.d0
  do i = 1, im
    pl_ad(i,km) = pl_ad(i,km)+pl_ad(i,km+1)
    pl_ad(i,km+1) = 0.d0
  end do
  do k = 1, km
    do i = 1, im
      pe_ae(i,k+1,j) = pe_ae(i,k+1,j)+0.5*pl_ad(i,k)
      pe_ae(i,k,j) = pe_ae(i,k,j)+0.5*pl_ad(i,k)
      pl_ad(i,k) = 0.d0
    end do
  end do

!----------------------------------------------
! CLOSE TAPE dry_adj_tape
!----------------------------------------------
  if (allocated(dry_adj_tape_pt_1h)) then
    deallocate( dry_adj_tape_pt_1h )
  endif
  if (allocated(dry_adj_tape_dp_2h)) then
    deallocate( dry_adj_tape_dp_2h )
  endif
  if (allocated(dry_adj_tape_u_3h)) then
    deallocate( dry_adj_tape_u_3h )
  endif
  if (allocated(dry_adj_tape_v_4h)) then
    deallocate( dry_adj_tape_v_4h )
  endif

!----------------------------------------------
! CLOSE TAPE hswf_tape
!----------------------------------------------
  if (allocated(hswf_tape_teq_1h)) then
    deallocate( hswf_tape_teq_1h )
  endif
  if (allocated(hswf_tape_pt_2h)) then
    deallocate( hswf_tape_pt_2h )
  endif

end do
if (dcaf) then
  call d2a3d_ad( u_ae,v_ae,ua_ad,va_ad,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif

!----------------------------------------------
! DEALLOCATE STATEMENTS
!----------------------------------------------
deallocate( pesouth )
deallocate( uasouth )

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine hswf_do_ad


end module     hswf_ad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     hswf_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use hswf

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine hswf_do_ad( im, jm, km, jfirst, jlast, u, u_ae, v, v_ae, pt, pt_ae, pe, pe_ae, pkz, pkz_ae, pdt, akap, dcaf, strat, &
&rayf, cosp, coslon, sinlon, ng_s, ng_d )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use dry_adj_ad_store, only : dry_adj_tape_dp_2h,dry_adj_tape_dry_adj,dry_adj_tape_pt_1h,dry_adj_tape_u_3h,dry_adj_tape_v_4h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
integer :: im
real(kind=r8) :: coslon(im)
integer :: jm
real(kind=r8) :: cosp(jm)
logical :: dcaf
integer :: jfirst
integer :: jlast
integer :: km
integer :: ng_d
integer :: ng_s
integer :: pdt
real(kind=r8) :: pe(im,km+1,jfirst:jlast)
real(kind=r8) :: pe_ae(im,km+1,jfirst:jlast)
real(kind=r8) :: pkz(im,jfirst:jlast,km)
real(kind=r8) :: pkz_ae(im,jfirst:jlast,km)
real(kind=r8) :: pt(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: pt_ae(im,jfirst-ng_d:jlast+ng_d,km)
logical :: rayf
real(kind=r8) :: sinlon(im)
logical :: strat
real(kind=r8) :: u(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: u_ae(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v(im,jfirst-ng_s:jlast+ng_d,km)
real(kind=r8) :: v_ae(im,jfirst-ng_s:jlast+ng_d,km)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: algpk
real(kind=r8) :: ap0k
real(kind=r8) :: dp(im,km)
real(kind=r8) :: dp_ad(im,km)
real(kind=r8) :: dt_tropic
real(kind=r8) :: dt_tropic_ad
real(kind=r8) :: dz
real(kind=r8) :: dz_ad
real(kind=r8) :: f1
real(kind=r8) :: f1_ad
real(kind=r8) :: fac
real(kind=r8) :: fac_ad
real(kind=r8) :: frac(im,jm)
real(kind=r8) :: frac_ad(im,jm)
real(kind=r8) :: fu(im,km)
real(kind=r8) :: fu_ad(im,km)
real(kind=r8) :: fv(im,km)
real(kind=r8) :: fv_ad(im,km)
real(kind=r8) :: h0
integer :: hswf_tape_hswf_do
real(kind=4), allocatable :: hswf_tape_pt_2h(:,:)
real(kind=4), allocatable :: hswf_tape_teq_1h(:,:)
integer :: i
integer :: j
integer :: jn2g0
integer :: js2g0
integer :: js2gm1
integer :: k
integer :: kb1
real(kind=r8) :: p0
#ifdef USE_OPENMP
real(kind=r8) :: pe_aeh(im,km+1,jfirst:jlast)
#endif /* ! USE_OPENMP */
real(kind=r8) :: pl(im,km+1)
real(kind=r8) :: pl_ad(im,km+1)
real(kind=r8) :: pth(im,jfirst-ng_d:jlast+ng_d,km)
real(kind=r8) :: rdt
real(kind=r8) :: relx
real(kind=r8) :: relx_ad
real(kind=r8) :: rka
real(kind=r8) :: rks
real(kind=r8) :: rkt
real(kind=r8) :: rkt_ad
real(kind=r8) :: rkv
real(kind=r8) :: rmr
real(kind=r8) :: rms
real(kind=r8) :: rsgb
real(kind=r8) :: sday
real(kind=r8) :: sigb
real(kind=r8) :: sigl
real(kind=r8) :: sigl_ad
real(kind=r8) :: t0
real(kind=r8) :: t2(im,km)
real(kind=r8) :: t2_ad(im,km)
real(kind=r8) :: t_ms
real(kind=r8) :: t_st
real(kind=r8) :: tau
real(kind=r8) :: teq(im,km)
real(kind=r8) :: teq_ad(im,km)
real(kind=r8) :: tey
real(kind=r8) :: tez
real(kind=r8) :: tmin
real(kind=r8) :: tmin_ad
real(kind=r8) :: tmp
real(kind=r8) :: tmp_ad
real(kind=r8) :: u2(im,km)
real(kind=r8) :: u2_ad(im,km)
real(kind=r8) :: ua(im,jfirst:jlast,km)
real(kind=r8) :: ua_ad(im,jfirst:jlast,km)
real(kind=r8) :: uah(im,jfirst:jlast,km)
real(kind=r8) :: uh(im,jfirst-ng_d:jlast+ng_s,km)
real(kind=r8) :: v2(im,km)
real(kind=r8) :: v2_ad(im,km)
real(kind=r8) :: va(im,jfirst:jlast,km)
real(kind=r8) :: va_ad(im,jfirst:jlast,km)
real(kind=r8) :: vah(im,jfirst:jlast,km)
real(kind=r8) :: vh(im,jfirst-ng_s:jlast+ng_d,km)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
vah(:,:,:) = va(:,:,:)
vh(:,:,:) = v(:,:,:)
uah(:,:,:) = ua(:,:,:)
uh(:,:,:) = u(:,:,:)
pth(:,:,:) = pt(:,:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dp_ad(:,:) = 0.d0
dt_tropic_ad = 0.d0
dz_ad = 0.d0
f1_ad = 0.d0
fac_ad = 0.d0
frac_ad(:,:) = 0.d0
fu_ad(:,:) = 0.d0
fv_ad(:,:) = 0.d0
pl_ad(:,:) = 0.d0
relx_ad = 0.d0
rkt_ad = 0.d0
sigl_ad = 0.d0
t2_ad(:,:) = 0.d0
teq_ad(:,:) = 0.d0
tmin_ad = 0.d0
tmp_ad = 0.d0
u2_ad(:,:) = 0.d0
ua_ad(:,:,:) = 0.d0
v2_ad(:,:) = 0.d0
va_ad(:,:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
js2g0 = max(2,jfirst)
js2gm1 = max(2,jfirst+1)
jn2g0 = min(jm-1,jlast)
p0 = 1.e+5
t0 = 200.
h0 = 7.
sday = 24*3600
rkv = 0.5*pdt/sday
rka = pdt/(40.*sday)
rks = pdt/(4.*sday)
t_ms = 10.
t_st = 40.
tau = (t_st-t_ms)/log(100.)
rms = pdt/(t_ms*sday)
rmr = 1./(1.+rms)
sigb = 0.7
rsgb = 1./(1.-sigb)
ap0k = 1./p0**akap
algpk = log(ap0k)
if (dcaf) then
  call d2a3d( u,v,ua,va,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif
#ifdef USE_OPENMP
!$omp parallel do private(dp,dt_tropic,dz,f1,fu,fv,i,j,k,pl,rdt,relx,rkt,sigl,t2,teq,tey,tez,tmin,tmp,u2,v2)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl(i,km+1) = pl(i,km)
  end do
  teq = 0.
  do k = km, 1, -1
    do i = 1, im
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx = pdt/(relx*sday)
        dt_tropic = 2.25*cosp(j)*dz
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+relx*teq(i,k))/(1.+relx)
      else if (strat .and. pl(i,k) .le. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq(i,k) = tmp/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+rms*teq(i,k))*rmr
      else
        sigl = pl(i,k)/pe(i,km+1,j)
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin = t0/pkz(i,j,k)
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq(i,k) = max(tmin,teq(i,k))
        rkt = rka+(rks-rka)*f1*cosp4(j)
        pt(i,j,k) = (pt(i,j,k)+rkt*teq(i,k))/(1.+rkt)
      endif
    end do
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        dp(i,k) = pe(i,k+1,j)-pe(i,k,j)
        fu(i,k) = 0.
        fv(i,k) = 0.
        u2(i,k) = ua(i,j,k)
        v2(i,k) = va(i,j,k)
        t2(i,k) = pt(i,j,k)
      end do
    end do
    rdt = 1./pdt
    call dry_adj( im,km,rdt,t2,fu,fv,u2,v2,dp,j )
    do k = 1, km
      v(1,j,k) = v(1,j,k)+0.5*(fv(1,k)+fv(im,k))
      do i = 2, im
        v(i,j,k) = v(i,j,k)+0.5*(fv(i,k)+fv(i-1,k))
      end do
      do i = 1, im
        ua(i,j,k) = fu(i,k)
        pt(i,j,k) = t2(i,k)
      end do
    end do
  endif
end do
#ifdef USE_OPENMP
pe_aeh(:,:,:) = pe_ae(:,:,:)
!$omp parallel do shared(dcaf,im,jfirst,jlast,jn2g0,js2g0,js2gm1,km,ks,pe,pe_aeh,rayf,rf,rkv,rsgb,sigb,u,u_ae,ua,ua_ad,v,v_ae) &
!$omp& private(fac,fac_ad,frac,frac_ad,i,j,k,pe_ae,sigl,sigl_ad)
#endif /* ! USE_OPENMP */
do k = 1, km
#ifdef USE_OPENMP
  pe_ae(:,:,:) = 0.
#endif /* ! USE_OPENMP */
  fac_ad = 0.d0
  frac_ad(:,:) = 0.d0
  sigl_ad = 0.d0
  if (dcaf) then
    do j = js2gm1, jlast
      do i = 1, im
        u(i,j,k) = u(i,j,k)+0.5*(ua(i,j,k)+ua(i,j-1,k))
      end do
    end do
  endif
  if (rayf .and. k .le. ks) then
    do j = js2g0, jn2g0
      do i = 1, im
        v_ae(i,j,k) = v_ae(i,j,k)*rf(k)
      end do
    end do
    do j = js2g0, jlast
      do i = 1, im
        u_ae(i,j,k) = u_ae(i,j,k)*rf(k)
      end do
    end do
  else
    do j = jfirst, jlast
      do i = 1, im
        sigl = 0.5*(pe(i,k,j)+pe(i,k+1,j))/pe(i,km+1,j)
        frac(i,j) = max(0._8,(sigl-sigb)*rsgb)
      end do
    end do
    do j = js2g0, jn2g0
      do i = 2, im
        fac = frac(i,j)+frac(i-1,j)
        if (fac .gt. 0.) then
          v(i,j,k) = v(i,j,k)/(1.+rkv*fac)
        endif
      end do
    end do
    do j = js2g0, jn2g0
      fac_ad = 0.d0
      fac = frac(1,j)+frac(im,j)
      if (fac .gt. 0.) then
        fac_ad = fac_ad-v_ae(1,j,k)*(v(1,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))
        v_ae(1,j,k) = v_ae(1,j,k)/(1.+rkv*fac)
      endif
      frac_ad(im,j) = frac_ad(im,j)+fac_ad
      frac_ad(1,j) = frac_ad(1,j)+fac_ad
      fac_ad = 0.d0
    end do
    pt(:,:,:) = pth(:,:,:)
    v(:,:,:) = vh(:,:,:)
#ifdef USE_OPENMP
    !$omp parallel do private(dp,dt_tropic,dz,f1,fu,fv,i,j,k,pl,rdt,relx,rkt,sigl,t2,teq,tey,tez,tmin,tmp,u2,v2)
#endif /* ! USE_OPENMP */
    do j = jfirst, jlast
      tey = ap0k*(315.-60.*sinp2(j))
      tez = ap0k*10./akap*cosp2(j)
      do kb1 = 1, km
        do i = 1, im
          pl(i,kb1) = 0.5*(pe(i,kb1,j)+pe(i,kb1+1,j))
        end do
      end do
      do i = 1, im
        pl(i,km+1) = pl(i,km)
      end do
      teq = 0.
      do kb1 = km, 1, -1
        do i = 1, im
          if (strat .and. pl(i,kb1) .lt. 1.e+4 .and. pl(i,kb1) .gt. 100.) then
            dz = h0*log(pl(i,kb1+1)/pl(i,kb1))
            relx = t_ms+tau*log(0.01*pl(i,kb1))
            relx = pdt/(relx*sday)
            dt_tropic = 2.25*cosp(j)*dz
            teq(i,kb1) = (teq(i,kb1+1)*pkz(i,j,kb1+1)+dt_tropic)/pkz(i,j,kb1)
            pt(i,j,kb1) = (pt(i,j,kb1)+relx*teq(i,kb1))/(1.+relx)
          else if (strat .and. pl(i,kb1) .le. 100.) then
            dz = h0*log(pl(i,kb1+1)/pl(i,kb1))
            dt_tropic = -(2.25*cosp(j)*dz)
            tmp = teq(i,kb1+1)*pkz(i,j,kb1+1)+dt_tropic
            teq(i,kb1) = tmp/pkz(i,j,kb1)
            pt(i,j,kb1) = (pt(i,j,kb1)+rms*teq(i,kb1))*rmr
          else
            sigl = pl(i,kb1)/pe(i,km+1,j)
            f1 = max(0._8,(sigl-sigb)*rsgb)
            tmin = t0/pkz(i,j,kb1)
            teq(i,kb1) = tey-tez*(log(pkz(i,j,kb1))+algpk)
            teq(i,kb1) = max(tmin,teq(i,kb1))
            rkt = rka+(rks-rka)*f1*cosp4(j)
            pt(i,j,kb1) = (pt(i,j,kb1)+rkt*teq(i,kb1))/(1.+rkt)
          endif
        end do
      end do
      if (dcaf) then
        do kb1 = 1, km
          do i = 1, im
            dp(i,kb1) = pe(i,kb1+1,j)-pe(i,kb1,j)
            fu(i,kb1) = 0.
            fv(i,kb1) = 0.
            u2(i,kb1) = ua(i,j,kb1)
            v2(i,kb1) = va(i,j,kb1)
            t2(i,kb1) = pt(i,j,kb1)
          end do
        end do
        rdt = 1./pdt
        call dry_adj( im,km,rdt,t2,fu,fv,u2,v2,dp,j )
        do kb1 = 1, km
          v(1,j,kb1) = v(1,j,kb1)+0.5*(fv(1,kb1)+fv(im,kb1))
          do i = 2, im
            v(i,j,kb1) = v(i,j,kb1)+0.5*(fv(i,kb1)+fv(i-1,kb1))
          end do
          do i = 1, im
            pt(i,j,kb1) = t2(i,kb1)
          end do
        end do
      endif
    end do
    do j = js2g0, jn2g0
      fac_ad = 0.d0
      do i = 2, im
        fac_ad = 0.d0
        fac = frac(i,j)+frac(i-1,j)
        if (fac .gt. 0.) then
          fac_ad = fac_ad-v_ae(i,j,k)*(v(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))
          v_ae(i,j,k) = v_ae(i,j,k)/(1.+rkv*fac)
        endif
        frac_ad(i-1,j) = frac_ad(i-1,j)+fac_ad
        frac_ad(i,j) = frac_ad(i,j)+fac_ad
        fac_ad = 0.d0
      end do
    end do
    do j = js2g0, jlast
      fac_ad = 0.d0
      do i = 1, im
        fac_ad = 0.d0
        fac = frac(i,j)+frac(i,j-1)
        if (fac .gt. 0.) then
          fac_ad = fac_ad-u_ae(i,j,k)*(u(i,j,k)*rkv/((1.+rkv*fac)*(1.+rkv*fac)))
          u_ae(i,j,k) = u_ae(i,j,k)/(1.+rkv*fac)
        endif
        frac_ad(i,j-1) = frac_ad(i,j-1)+fac_ad
        frac_ad(i,j) = frac_ad(i,j)+fac_ad
        fac_ad = 0.d0
      end do
    end do
    do j = jfirst, jlast
      sigl_ad = 0.d0
      do i = 1, im
        sigl_ad = 0.d0
        sigl = 0.5*(pe(i,k,j)+pe(i,k+1,j))/pe(i,km+1,j)
        sigl_ad = sigl_ad+frac_ad(i,j)*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        frac_ad(i,j) = 0.d0
        pe_ae(i,k+1,j) = pe_ae(i,k+1,j)+sigl_ad*(0.5/pe(i,km+1,j))
        pe_ae(i,km+1,j) = pe_ae(i,km+1,j)-sigl_ad*(0.5*(pe(i,k,j)+pe(i,k+1,j))/(pe(i,km+1,j)*pe(i,km+1,j)))
        pe_ae(i,k,j) = pe_ae(i,k,j)+sigl_ad*(0.5/pe(i,km+1,j))
        sigl_ad = 0.d0
      end do
    end do
  endif
  if (dcaf) then
    do j = js2gm1, jlast
      do i = 1, im
        ua_ad(i,j-1,k) = ua_ad(i,j-1,k)+0.5*u_ae(i,j,k)
        ua_ad(i,j,k) = ua_ad(i,j,k)+0.5*u_ae(i,j,k)
      end do
    end do
  endif
#ifdef USE_OPENMP
  !$omp critical  (adtaf)
  pe_aeh(:,:,:) = pe_aeh(:,:,:)+pe_ae(:,:,:)
  !$omp end critical (adtaf)
#endif /* ! USE_OPENMP */
end do
#ifdef USE_OPENMP
pe_ae(:,:,:) = pe_aeh(:,:,:)
#endif /* ! USE_OPENMP */
pt(:,:,:) = pth(:,:,:)
u(:,:,:) = uh(:,:,:)
ua(:,:,:) = uah(:,:,:)
v(:,:,:) = vh(:,:,:)
va(:,:,:) = vah(:,:,:)
if (dcaf) then
  call d2a3d( u,v,ua,va,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif
#ifdef USE_OPENMP
!$omp parallel do shared(akap,algpk,ap0k,cosp,cosp2,cosp4,dcaf,h0,im,jfirst,jlast,km,pdt,pe,pe_ae,pkz,pkz_ae,pt,pt_ae,rka,rks,rmr,&
!$omp& rms,rsgb,sday,sigb,sinp2,strat,t0,t_ms,tau,ua,ua_ad,v_ae,va,va_ad) private(dp,dp_ad,dry_adj_tape_dry_adj,dt_tropic,&
!$omp& dt_tropic_ad,dz,dz_ad,f1,f1_ad,fu,fu_ad,fv,fv_ad,hswf_tape_hswf_do,hswf_tape_pt_2h,hswf_tape_teq_1h,i,j,k,pl,pl_ad,rdt,relx,&
!$omp& relx_ad,rkt,rkt_ad,sigl,sigl_ad,t2,t2_ad,teq,teq_ad,tey,tez,tmin,tmin_ad,tmp,tmp_ad,u2,u2_ad,v2,v2_ad)
#endif /* ! USE_OPENMP */
do j = jfirst, jlast
  dp_ad(:,:) = 0.d0
  dt_tropic_ad = 0.d0
  dz_ad = 0.d0
  f1_ad = 0.d0
  fu_ad(:,:) = 0.d0
  fv_ad(:,:) = 0.d0
  pl_ad(:,:) = 0.d0
  relx_ad = 0.d0
  rkt_ad = 0.d0
  sigl_ad = 0.d0
  t2_ad(:,:) = 0.d0
  teq_ad(:,:) = 0.d0
  tmin_ad = 0.d0
  tmp_ad = 0.d0
  u2_ad(:,:) = 0.d0
  v2_ad(:,:) = 0.d0
!----------------------------------------------
! OPEN TAPE dry_adj_tape
!----------------------------------------------
  dry_adj_tape_dry_adj = im*klow

!----------------------------------------------
! OPEN TAPE hswf_tape
!----------------------------------------------
  hswf_tape_hswf_do = km

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl(i,km+1) = pl(i,km)
  end do
  teq = 0.
  do k = km, 1, -1
    if ( .not. allocated(hswf_tape_teq_1h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(hswf_tape_teq_1h)) then
        allocate( hswf_tape_teq_1h(1:im,hswf_tape_hswf_do) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( hswf_tape_teq_1h(1:im,hswf_tape_hswf_do) )
#endif /* USE_OPENMP */
    endif
    hswf_tape_teq_1h(:,k) = teq(:,k)
    if ( .not. allocated(hswf_tape_pt_2h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(hswf_tape_pt_2h)) then
        allocate( hswf_tape_pt_2h(1:im,hswf_tape_hswf_do) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( hswf_tape_pt_2h(1:im,hswf_tape_hswf_do) )
#endif /* USE_OPENMP */
    endif
    hswf_tape_pt_2h(:,k) = pt(:,j,k)
    do i = 1, im
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx = pdt/(relx*sday)
        dt_tropic = 2.25*cosp(j)*dz
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+relx*teq(i,k))/(1.+relx)
      else if (strat .and. pl(i,k) .le. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq(i,k) = tmp/pkz(i,j,k)
        pt(i,j,k) = (pt(i,j,k)+rms*teq(i,k))*rmr
      else
        sigl = pl(i,k)/pe(i,km+1,j)
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin = t0/pkz(i,j,k)
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq(i,k) = max(tmin,teq(i,k))
        rkt = rka+(rks-rka)*f1*cosp4(j)
        pt(i,j,k) = (pt(i,j,k)+rkt*teq(i,k))/(1.+rkt)
      endif
    end do
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        dp(i,k) = pe(i,k+1,j)-pe(i,k,j)
        fu(i,k) = 0.
        fv(i,k) = 0.
        u2(i,k) = ua(i,j,k)
        v2(i,k) = va(i,j,k)
        t2(i,k) = pt(i,j,k)
      end do
    end do
    rdt = 1./pdt
    call dry_adjmd( im,km,rdt,t2,fu,fv,u2,v2,dp,j )
  endif

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
  tey = ap0k*(315.-60.*sinp2(j))
  tez = ap0k*10./akap*cosp2(j)
  do k = 1, km
    do i = 1, im
      pl(i,k) = 0.5*(pe(i,k,j)+pe(i,k+1,j))
    end do
  end do
  do i = 1, im
    pl(i,km+1) = pl(i,km)
  end do
  if (dcaf) then
    do k = 1, km
      do i = 1, im
        t2_ad(i,k) = t2_ad(i,k)+pt_ae(i,j,k)
        pt_ae(i,j,k) = 0.
        fu_ad(i,k) = fu_ad(i,k)+ua_ad(i,j,k)
        ua_ad(i,j,k) = 0.d0
      end do
      do i = 2, im
        fv_ad(i-1,k) = fv_ad(i-1,k)+0.5*v_ae(i,j,k)
        fv_ad(i,k) = fv_ad(i,k)+0.5*v_ae(i,j,k)
      end do
      fv_ad(im,k) = fv_ad(im,k)+0.5*v_ae(1,j,k)
      fv_ad(1,k) = fv_ad(1,k)+0.5*v_ae(1,j,k)
    end do
    call dry_adj_ad( im,km,rdt,t2,t2_ad,fu_ad,fv_ad,u2,u2_ad,v2,v2_ad,dp,dp_ad )
    do k = 1, km
      do i = 1, im
        pt_ae(i,j,k) = pt_ae(i,j,k)+t2_ad(i,k)
        t2_ad(i,k) = 0.d0
        va_ad(i,j,k) = va_ad(i,j,k)+v2_ad(i,k)
        v2_ad(i,k) = 0.d0
        ua_ad(i,j,k) = ua_ad(i,j,k)+u2_ad(i,k)
        u2_ad(i,k) = 0.d0
        fv_ad(i,k) = 0.d0
        fu_ad(i,k) = 0.d0
        pe_ae(i,k+1,j) = pe_ae(i,k+1,j)+dp_ad(i,k)
        pe_ae(i,k,j) = pe_ae(i,k,j)-dp_ad(i,k)
        dp_ad(i,k) = 0.d0
      end do
    end do
  endif
  do k = 1, km
    teq(:,k) = hswf_tape_teq_1h(:,k)
    pt(:,j,k) = hswf_tape_pt_2h(:,k)
    do i = 1, im
      dt_tropic_ad = 0.d0
      dz_ad = 0.d0
      f1_ad = 0.d0
      relx_ad = 0.d0
      rkt_ad = 0.d0
      sigl_ad = 0.d0
      tmin_ad = 0.d0
      tmp_ad = 0.d0
      if (strat .and. pl(i,k) .lt. 1.e+4 .and. pl(i,k) .gt. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx = pdt/(relx*sday)
        dt_tropic = 2.25*cosp(j)*dz
        teq(i,k) = (teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/pkz(i,j,k)
        relx_ad = relx_ad+pt_ae(i,j,k)*(teq(i,k)/(1.+relx)-(pt(i,j,k)+relx*teq(i,k))/((1.+relx)*(1.+relx)))
        teq_ad(i,k) = teq_ad(i,k)+pt_ae(i,j,k)*(relx/(1.+relx))
        pt_ae(i,j,k) = pt_ae(i,j,k)/(1.+relx)
        teq(:,k) = hswf_tape_teq_1h(:,k)
        dt_tropic_ad = dt_tropic_ad+teq_ad(i,k)/pkz(i,j,k)
        pkz_ae(i,j,k+1) = pkz_ae(i,j,k+1)+teq_ad(i,k)*(teq(i,k+1)/pkz(i,j,k))
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-teq_ad(i,k)*((teq(i,k+1)*pkz(i,j,k+1)+dt_tropic)/(pkz(i,j,k)*pkz(i,j,k)))
        teq_ad(i,k+1) = teq_ad(i,k+1)+teq_ad(i,k)*(pkz(i,j,k+1)/pkz(i,j,k))
        teq_ad(i,k) = 0.d0
        dz_ad = dz_ad+2.25*dt_tropic_ad*cosp(j)
        dt_tropic_ad = 0.d0
        relx = t_ms+tau*log(0.01*pl(i,k))
        relx_ad = -(relx_ad*(pdt*sday/(relx*sday*relx*sday)))
        pl_ad(i,k) = pl_ad(i,k)+0.01*relx_ad*tau*(1./(0.01*pl(i,k)))
        relx_ad = 0.d0
        pl_ad(i,k+1) = pl_ad(i,k+1)+dz_ad*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))
        pl_ad(i,k) = pl_ad(i,k)-dz_ad*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz_ad = 0.d0
      else if (strat .and. pl(i,k) .le. 100.) then
        dz = h0*log(pl(i,k+1)/pl(i,k))
        dt_tropic = -(2.25*cosp(j)*dz)
        tmp = teq(i,k+1)*pkz(i,j,k+1)+dt_tropic
        teq_ad(i,k) = teq_ad(i,k)+pt_ae(i,j,k)*rms*rmr
        pt_ae(i,j,k) = pt_ae(i,j,k)*rmr
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-teq_ad(i,k)*(tmp/(pkz(i,j,k)*pkz(i,j,k)))
        tmp_ad = tmp_ad+teq_ad(i,k)/pkz(i,j,k)
        teq_ad(i,k) = 0.d0
        dt_tropic_ad = dt_tropic_ad+tmp_ad
        pkz_ae(i,j,k+1) = pkz_ae(i,j,k+1)+tmp_ad*teq(i,k+1)
        teq_ad(i,k+1) = teq_ad(i,k+1)+tmp_ad*pkz(i,j,k+1)
        tmp_ad = 0.d0
        dz_ad = dz_ad-2.25*dt_tropic_ad*cosp(j)
        dt_tropic_ad = 0.d0
        pl_ad(i,k+1) = pl_ad(i,k+1)+dz_ad*h0*(1./(pl(i,k+1)/pl(i,k))/pl(i,k))
        pl_ad(i,k) = pl_ad(i,k)-dz_ad*h0*1./(pl(i,k+1)/pl(i,k))*(pl(i,k+1)/(pl(i,k)*pl(i,k)))
        dz_ad = 0.d0
      else
        sigl = pl(i,k)/pe(i,km+1,j)
        f1 = max(0._8,(sigl-sigb)*rsgb)
        tmin = t0/pkz(i,j,k)
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        teq(i,k) = max(tmin,teq(i,k))
        rkt = rka+(rks-rka)*f1*cosp4(j)
        rkt_ad = rkt_ad+pt_ae(i,j,k)*(teq(i,k)/(1.+rkt)-(pt(i,j,k)+rkt*teq(i,k))/((1.+rkt)*(1.+rkt)))
        teq_ad(i,k) = teq_ad(i,k)+pt_ae(i,j,k)*(rkt/(1.+rkt))
        pt_ae(i,j,k) = pt_ae(i,j,k)/(1.+rkt)
        f1_ad = f1_ad+rkt_ad*(rks-rka)*cosp4(j)
        rkt_ad = 0.d0
        teq(i,k) = tey-tez*(log(pkz(i,j,k))+algpk)
        tmin_ad = tmin_ad+teq_ad(i,k)*(0.5+sign(0.5d0,tmin-teq(i,k)))
        teq_ad(i,k) = teq_ad(i,k)*(0.5-sign(0.5d0,tmin-teq(i,k)))
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-teq_ad(i,k)*tez*(1./pkz(i,j,k))
        teq_ad(i,k) = 0.d0
        pkz_ae(i,j,k) = pkz_ae(i,j,k)-tmin_ad*(t0/(pkz(i,j,k)*pkz(i,j,k)))
        tmin_ad = 0.d0
        sigl_ad = sigl_ad+f1_ad*(0.5-sign(0.5d0,0._8-(sigl-sigb)*rsgb))*rsgb
        f1_ad = 0.d0
        pe_ae(i,km+1,j) = pe_ae(i,km+1,j)-sigl_ad*(pl(i,k)/(pe(i,km+1,j)*pe(i,km+1,j)))
        pl_ad(i,k) = pl_ad(i,k)+sigl_ad/pe(i,km+1,j)
        sigl_ad = 0.d0
      endif
    end do
  end do
  teq_ad = 0.d0
  do i = 1, im
    pl_ad(i,km) = pl_ad(i,km)+pl_ad(i,km+1)
    pl_ad(i,km+1) = 0.d0
  end do
  do k = 1, km
    do i = 1, im
      pe_ae(i,k+1,j) = pe_ae(i,k+1,j)+0.5*pl_ad(i,k)
      pe_ae(i,k,j) = pe_ae(i,k,j)+0.5*pl_ad(i,k)
      pl_ad(i,k) = 0.d0
    end do
  end do

!----------------------------------------------
! CLOSE TAPE dry_adj_tape
!----------------------------------------------
  if (allocated(dry_adj_tape_pt_1h)) then
    deallocate( dry_adj_tape_pt_1h )
  endif
  if (allocated(dry_adj_tape_dp_2h)) then
    deallocate( dry_adj_tape_dp_2h )
  endif
  if (allocated(dry_adj_tape_u_3h)) then
    deallocate( dry_adj_tape_u_3h )
  endif
  if (allocated(dry_adj_tape_v_4h)) then
    deallocate( dry_adj_tape_v_4h )
  endif

!----------------------------------------------
! CLOSE TAPE hswf_tape
!----------------------------------------------
  if (allocated(hswf_tape_teq_1h)) then
    deallocate( hswf_tape_teq_1h )
  endif
  if (allocated(hswf_tape_pt_2h)) then
    deallocate( hswf_tape_pt_2h )
  endif

end do
if (dcaf) then
  call d2a3d_ad( u_ae,v_ae,ua_ad,va_ad,im,jm,km,jfirst,jlast,ng_d,ng_s,coslon,sinlon )
endif

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine hswf_do_ad


end module     hswf_ad


#endif /* SPMD */
