#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine geopk_ad( ptop, pe_ae, delp, delp_ae, pk, pk_ae, wz_ad, pt, pt_ae, im, km, jfirst, jlast, nd, cp, akap, nx, id, &
&dp_check )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: dpmin = 0.1

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_ae(im,jfirst:jlast,km)
logical :: dp_check
integer :: id
integer :: nd
integer :: nx
real(kind=r8) :: pe_ae(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pk_ae(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: pt_ae(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: ptop
real(kind=r8) :: wz_ad(im,jfirst-1:jlast+1,km+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dp
real(kind=r8) :: dp_ad
real(kind=8) :: geopk_tape_1_delp_1h(im,1)
real(kind=8) :: geopk_tape_1_pt_2h(im,2,1)
real(kind=8), allocatable :: geopk_tape_delp_1h(:,:)
integer :: geopk_tape_geopk
real(kind=8), allocatable :: geopk_tape_p1d_3h(:,:)
real(kind=8), allocatable :: geopk_tape_pt_2h(:,:,:)
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_ad(im)
#ifdef USE_OPENMP
double precision :: pti_ad
#endif /* ! USE_OPENMP */
real(kind=r8) :: ptk

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dp_ad = 0.d0
p1d_ad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do shared(akap,cp,delp,delp_ae,dp_check,id,it,jfirst,jp,km,nx,pe_ae,pk,pk_ae,pt,pt_ae,ptop,wz_ad) private(dp,dp_ad,&
!$omp& geopk_tape_delp_1h,geopk_tape_geopk,geopk_tape_p1d_3h,geopk_tape_pt_2h,i,i1,i2,ixj,j,k,p1d,p1d_ad,pti_ad,ptk)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  dp_ad = 0.d0
  p1d_ad(:) = 0.d0
!----------------------------------------------
! OPEN TAPE geopk_tape
!----------------------------------------------
  geopk_tape_geopk = km

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do i = i1, i2
    p1d(i) = ptop
  end do
  if (dp_check) then
    do k = 1, km-1
      if ( .not. allocated(geopk_tape_delp_1h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(geopk_tape_delp_1h)) then
          allocate( geopk_tape_delp_1h(1:im,geopk_tape_geopk) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( geopk_tape_delp_1h(1:im,geopk_tape_geopk) )
#endif /* USE_OPENMP */
      endif
      geopk_tape_delp_1h(:,k) = delp(:,j,k)
      if ( .not. allocated(geopk_tape_pt_2h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(geopk_tape_pt_2h)) then
          allocate( geopk_tape_pt_2h(1:im,1:2,geopk_tape_geopk) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( geopk_tape_pt_2h(1:im,1:2,geopk_tape_geopk) )
#endif /* USE_OPENMP */
      endif
      geopk_tape_pt_2h(:,:,k) = pt(:,j,k:k+1)
      do i = i1, i2
        if (delp(i,j,k) .lt. dpmin) then
          dp = dpmin-delp(i,j,k)
          pt(i,j,k) = (pt(i,j,k)*delp(i,j,k)+pt(i,j,k+1)*dp)/dpmin
          delp(i,j,k) = dpmin
          delp(i,j,k+1) = delp(i,j,k+1)-dp
        endif
      end do
    end do
    geopk_tape_1_delp_1h(:,1) = delp(:,j,k)
    geopk_tape_1_pt_2h(:,:,1) = pt(:,j,km-1:km)
    do i = i1, i2
      if (delp(i,j,km) .lt. dpmin) then
        dp = dpmin-delp(i,j,km)
        delp(i,j,km) = dpmin
        delp(i,j,km-1) = delp(i,j,km-1)-dp
      endif
    end do
  endif
  do k = 2, km
    if ( .not. allocated(geopk_tape_p1d_3h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(geopk_tape_p1d_3h)) then
        allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
#endif /* USE_OPENMP */
    endif
    geopk_tape_p1d_3h(:,(-1)+k) = p1d
    do i = i1, i2
      p1d(i) = p1d(i)+delp(i,j,k-1)
    end do
  end do
  k = km+1
  if ( .not. allocated(geopk_tape_p1d_3h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(geopk_tape_p1d_3h)) then
      allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
#endif /* USE_OPENMP */
  endif
  geopk_tape_p1d_3h(:,(-1)+k) = p1d

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
  ptk = ptop**akap
  do i = i1, i2
    p1d(i) = ptop
    pk(i,j,1) = ptk
  end do
  do k = 2, km+1
    do i = i1, i2
      p1d(i) = p1d(i)+delp(i,j,k-1)
      pk(i,j,k) = p1d(i)**akap
    end do
  end do
  do k = 1, km
    do i = i1, i2
      pk_ae(i,j,k+1) = pk_ae(i,j,k+1)+wz_ad(i,j,k)*cp*pt(i,j,k)
      pk_ae(i,j,k) = pk_ae(i,j,k)-wz_ad(i,j,k)*cp*pt(i,j,k)
      pt_ae(i,j,k) = pt_ae(i,j,k)+wz_ad(i,j,k)*cp*(pk(i,j,k+1)-pk(i,j,k))
      wz_ad(i,j,k+1) = wz_ad(i,j,k+1)+wz_ad(i,j,k)
      wz_ad(i,j,k) = 0.d0
    end do
  end do
  do k = km+1, 2, -1
    p1d = geopk_tape_p1d_3h(:,(-1)+k)
    if (id .eq. 1) then
      do i = i1, i2
        p1d_ad(i) = p1d_ad(i)+pe_ae(i,k,j)
        pe_ae(i,k,j) = 0.d0
      end do
    endif
    do i = i1, i2
      p1d(i) = p1d(i)+delp(i,j,k-1)
      p1d_ad(i) = p1d_ad(i)+pk_ae(i,j,k)*akap*p1d(i)**(akap-1)
      pk_ae(i,j,k) = 0.d0
      delp_ae(i,j,k-1) = delp_ae(i,j,k-1)+p1d_ad(i)
    end do
  end do
  if (dp_check) then
    delp(:,j,k) = geopk_tape_1_delp_1h(:,1)
    pt(:,j,km-1:km) = geopk_tape_1_pt_2h(:,:,1)
    do i = i1, i2
      dp_ad = 0.d0
      if (delp(i,j,km) .lt. dpmin) then
        dp = dpmin-delp(i,j,km)
        dp_ad = dp_ad-delp_ae(i,j,km-1)
        delp_ae(i,j,km) = 0.d0
#ifdef USE_OPENMP
        pti_ad = pt_ae(i,j,km)
        pt_ae(i,j,km) = 0.d0
        delp_ae(i,j,km) = delp_ae(i,j,km)+pti_ad*(pt(i,j,km)/dpmin)
        dp_ad = dp_ad+pti_ad*(pt(i,j,km-1)/dpmin)
        pt_ae(i,j,km-1) = pt_ae(i,j,km-1)+pti_ad*(dp/dpmin)
        pt_ae(i,j,km) = pt_ae(i,j,km)+pti_ad*(delp(i,j,km)/dpmin)
#else /* USE_OPENMP */
        delp_ae(i,j,km) = delp_ae(i,j,km)+pt_ae(i,j,km)*(pt(i,j,km)/dpmin)
        dp_ad = dp_ad+pt_ae(i,j,km)*(pt(i,j,km-1)/dpmin)
        pt_ae(i,j,km-1) = pt_ae(i,j,km-1)+pt_ae(i,j,km)*(dp/dpmin)
        pt_ae(i,j,km) = pt_ae(i,j,km)*(delp(i,j,km)/dpmin)
#endif /* USE_OPENMP */
        delp_ae(i,j,km) = delp_ae(i,j,km)-dp_ad
        dp_ad = 0.d0
      endif
    end do
    do k = km-1, 1, -1
      delp(:,j,k) = geopk_tape_delp_1h(:,k)
      pt(:,j,k:k+1) = geopk_tape_pt_2h(:,:,k)
      do i = i1, i2
        dp_ad = 0.d0
        if (delp(i,j,k) .lt. dpmin) then
          dp = dpmin-delp(i,j,k)
          dp_ad = dp_ad-delp_ae(i,j,k+1)
          delp_ae(i,j,k) = 0.d0
          delp_ae(i,j,k) = delp_ae(i,j,k)+pt_ae(i,j,k)*(pt(i,j,k)/dpmin)
          dp_ad = dp_ad+pt_ae(i,j,k)*(pt(i,j,k+1)/dpmin)
          pt_ae(i,j,k+1) = pt_ae(i,j,k+1)+pt_ae(i,j,k)*(dp/dpmin)
          pt_ae(i,j,k) = pt_ae(i,j,k)*(delp(i,j,k)/dpmin)
          delp_ae(i,j,k) = delp_ae(i,j,k)-dp_ad
          dp_ad = 0.d0
        endif
      end do
    end do
  endif
  if (id .eq. 1) then
    do i = i1, i2
      pe_ae(i,1,j) = 0.d0
    end do
  endif
  do i = i1, i2
    wz_ad(i,j,km+1) = 0.d0
    pk_ae(i,j,1) = 0.d0
    p1d_ad(i) = 0.d0
  end do

!----------------------------------------------
! CLOSE TAPE geopk_tape
!----------------------------------------------
  if (allocated(geopk_tape_delp_1h)) then
    deallocate( geopk_tape_delp_1h )
  endif
  if (allocated(geopk_tape_pt_2h)) then
    deallocate( geopk_tape_pt_2h )
  endif
  if (allocated(geopk_tape_p1d_3h)) then
    deallocate( geopk_tape_p1d_3h )
  endif

end do
do k = 1, km+1
  do j = jfirst-1, jlast+1
    do i = 1, im
      pk_ae(i,j,k) = 0.d0
    end do
  end do
end do

end subroutine geopk_ad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
subroutine geopk_ad( ptop, pe_ae, delp, delp_ae, pk, pk_ae, wz_ad, pt, pt_ae, im, km, jfirst, jlast, nd, cp, akap, nx, id, &
&dp_check )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: dpmin = 0.1

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: akap
real(kind=r8) :: cp
integer :: im
integer :: jfirst
integer :: jlast
integer :: km
real(kind=r8) :: delp(im,jfirst:jlast,km)
real(kind=r8) :: delp_ae(im,jfirst:jlast,km)
logical :: dp_check
integer :: id
integer :: nd
integer :: nx
real(kind=r8) :: pe_ae(im,km+1,jfirst:jlast)
real(kind=r8) :: pk(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pk_ae(im,jfirst-1:jlast+1,km+1)
real(kind=r8) :: pt(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: pt_ae(im,jfirst-nd:jlast+nd,km)
real(kind=r8) :: ptop
real(kind=r8) :: wz_ad(im,jfirst-1:jlast+1,km+1)

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: dp
real(kind=r8) :: dp_ad
real(kind=8) :: geopk_tape_1_delp_1h(im,1)
real(kind=8) :: geopk_tape_1_pt_2h(im,2,1)
real(kind=8), allocatable :: geopk_tape_delp_1h(:,:)
integer :: geopk_tape_geopk
real(kind=8), allocatable :: geopk_tape_p1d_3h(:,:)
real(kind=8), allocatable :: geopk_tape_pt_2h(:,:,:)
integer :: i
integer :: i1
integer :: i2
integer :: it
integer :: ixj
integer :: j
integer :: jp
integer :: k
real(kind=r8) :: p1d(im)
real(kind=r8) :: p1d_ad(im)
#ifdef USE_OPENMP
double precision :: pti_ad
#endif /* ! USE_OPENMP */
real(kind=r8) :: ptk

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dp_ad = 0.d0
p1d_ad(:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
it = im/nx
jp = nx*(jlast-jfirst+1)
#ifdef USE_OPENMP
!$omp parallel do shared(akap,cp,delp,delp_ae,dp_check,id,it,jfirst,jp,km,nx,pe_ae,pk,pk_ae,pt,pt_ae,ptop,wz_ad) private(dp,dp_ad,&
!$omp& geopk_tape_delp_1h,geopk_tape_geopk,geopk_tape_p1d_3h,geopk_tape_pt_2h,i,i1,i2,ixj,j,k,p1d,p1d_ad,pti_ad,ptk)
#endif /* ! USE_OPENMP */
do ixj = 1, jp
  dp_ad = 0.d0
  p1d_ad(:) = 0.d0
!----------------------------------------------
! OPEN TAPE geopk_tape
!----------------------------------------------
  geopk_tape_geopk = km

!----------------------------------------------
! TAPE COMPUTATIONS
!----------------------------------------------
  j = jfirst+(ixj-1)/nx
  i1 = 1+it*mod(ixj-1,nx)
  i2 = i1+it-1
  do i = i1, i2
    p1d(i) = ptop
  end do
  if (dp_check) then
    do k = 1, km-1
      if ( .not. allocated(geopk_tape_delp_1h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(geopk_tape_delp_1h)) then
          allocate( geopk_tape_delp_1h(1:im,geopk_tape_geopk) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( geopk_tape_delp_1h(1:im,geopk_tape_geopk) )
#endif /* USE_OPENMP */
      endif
      geopk_tape_delp_1h(:,k) = delp(:,j,k)
      if ( .not. allocated(geopk_tape_pt_2h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(geopk_tape_pt_2h)) then
          allocate( geopk_tape_pt_2h(1:im,1:2,geopk_tape_geopk) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( geopk_tape_pt_2h(1:im,1:2,geopk_tape_geopk) )
#endif /* USE_OPENMP */
      endif
      geopk_tape_pt_2h(:,:,k) = pt(:,j,k:k+1)
      do i = i1, i2
        if (delp(i,j,k) .lt. dpmin) then
          dp = dpmin-delp(i,j,k)
          pt(i,j,k) = (pt(i,j,k)*delp(i,j,k)+pt(i,j,k+1)*dp)/dpmin
          delp(i,j,k) = dpmin
          delp(i,j,k+1) = delp(i,j,k+1)-dp
        endif
      end do
    end do
    geopk_tape_1_delp_1h(:,1) = delp(:,j,k)
    geopk_tape_1_pt_2h(:,:,1) = pt(:,j,km-1:km)
    do i = i1, i2
      if (delp(i,j,km) .lt. dpmin) then
        dp = dpmin-delp(i,j,km)
        delp(i,j,km) = dpmin
        delp(i,j,km-1) = delp(i,j,km-1)-dp
      endif
    end do
  endif
  do k = 2, km
    if ( .not. allocated(geopk_tape_p1d_3h)) then
#ifdef USE_OPENMP
      !$omp critical  (store)
      if ( .not. allocated(geopk_tape_p1d_3h)) then
        allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
      endif
      !$omp end critical (store)
#else /* USE_OPENMP */
      allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
#endif /* USE_OPENMP */
    endif
    geopk_tape_p1d_3h(:,(-1)+k) = p1d
    do i = i1, i2
      p1d(i) = p1d(i)+delp(i,j,k-1)
    end do
  end do
  k = km+1
  if ( .not. allocated(geopk_tape_p1d_3h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(geopk_tape_p1d_3h)) then
      allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( geopk_tape_p1d_3h(1:im,geopk_tape_geopk) )
#endif /* USE_OPENMP */
  endif
  geopk_tape_p1d_3h(:,(-1)+k) = p1d

!----------------------------------------------
! ADJOINT COMPUTATIONS
!----------------------------------------------
  ptk = ptop**akap
  do i = i1, i2
    p1d(i) = ptop
    pk(i,j,1) = ptk
  end do
  do k = 2, km+1
    do i = i1, i2
      p1d(i) = p1d(i)+delp(i,j,k-1)
      pk(i,j,k) = p1d(i)**akap
    end do
  end do
  do k = 1, km
    do i = i1, i2
      pk_ae(i,j,k+1) = pk_ae(i,j,k+1)+wz_ad(i,j,k)*cp*pt(i,j,k)
      pk_ae(i,j,k) = pk_ae(i,j,k)-wz_ad(i,j,k)*cp*pt(i,j,k)
      pt_ae(i,j,k) = pt_ae(i,j,k)+wz_ad(i,j,k)*cp*(pk(i,j,k+1)-pk(i,j,k))
      wz_ad(i,j,k+1) = wz_ad(i,j,k+1)+wz_ad(i,j,k)
      wz_ad(i,j,k) = 0.d0
    end do
  end do
  do k = km+1, 2, -1
    p1d = geopk_tape_p1d_3h(:,(-1)+k)
    if (id .eq. 1) then
      do i = i1, i2
        p1d_ad(i) = p1d_ad(i)+pe_ae(i,k,j)
        pe_ae(i,k,j) = 0.d0
      end do
    endif
    do i = i1, i2
      p1d(i) = p1d(i)+delp(i,j,k-1)
      p1d_ad(i) = p1d_ad(i)+pk_ae(i,j,k)*akap*p1d(i)**(akap-1)
      pk_ae(i,j,k) = 0.d0
      delp_ae(i,j,k-1) = delp_ae(i,j,k-1)+p1d_ad(i)
    end do
  end do
  if (dp_check) then
    delp(:,j,k) = geopk_tape_1_delp_1h(:,1)
    pt(:,j,km-1:km) = geopk_tape_1_pt_2h(:,:,1)
    do i = i1, i2
      dp_ad = 0.d0
      if (delp(i,j,km) .lt. dpmin) then
        dp = dpmin-delp(i,j,km)
        dp_ad = dp_ad-delp_ae(i,j,km-1)
        delp_ae(i,j,km) = 0.d0
#ifdef USE_OPENMP
        pti_ad = pt_ae(i,j,km)
        pt_ae(i,j,km) = 0.d0
        delp_ae(i,j,km) = delp_ae(i,j,km)+pti_ad*(pt(i,j,km)/dpmin)
        dp_ad = dp_ad+pti_ad*(pt(i,j,km-1)/dpmin)
        pt_ae(i,j,km-1) = pt_ae(i,j,km-1)+pti_ad*(dp/dpmin)
        pt_ae(i,j,km) = pt_ae(i,j,km)+pti_ad*(delp(i,j,km)/dpmin)
#else /* USE_OPENMP */
        delp_ae(i,j,km) = delp_ae(i,j,km)+pt_ae(i,j,km)*(pt(i,j,km)/dpmin)
        dp_ad = dp_ad+pt_ae(i,j,km)*(pt(i,j,km-1)/dpmin)
        pt_ae(i,j,km-1) = pt_ae(i,j,km-1)+pt_ae(i,j,km)*(dp/dpmin)
        pt_ae(i,j,km) = pt_ae(i,j,km)*(delp(i,j,km)/dpmin)
#endif /* USE_OPENMP */
        delp_ae(i,j,km) = delp_ae(i,j,km)-dp_ad
        dp_ad = 0.d0
      endif
    end do
    do k = km-1, 1, -1
      delp(:,j,k) = geopk_tape_delp_1h(:,k)
      pt(:,j,k:k+1) = geopk_tape_pt_2h(:,:,k)
      do i = i1, i2
        dp_ad = 0.d0
        if (delp(i,j,k) .lt. dpmin) then
          dp = dpmin-delp(i,j,k)
          dp_ad = dp_ad-delp_ae(i,j,k+1)
          delp_ae(i,j,k) = 0.d0
          delp_ae(i,j,k) = delp_ae(i,j,k)+pt_ae(i,j,k)*(pt(i,j,k)/dpmin)
          dp_ad = dp_ad+pt_ae(i,j,k)*(pt(i,j,k+1)/dpmin)
          pt_ae(i,j,k+1) = pt_ae(i,j,k+1)+pt_ae(i,j,k)*(dp/dpmin)
          pt_ae(i,j,k) = pt_ae(i,j,k)*(delp(i,j,k)/dpmin)
          delp_ae(i,j,k) = delp_ae(i,j,k)-dp_ad
          dp_ad = 0.d0
        endif
      end do
    end do
  endif
  if (id .eq. 1) then
    do i = i1, i2
      pe_ae(i,1,j) = 0.d0
    end do
  endif
  do i = i1, i2
    wz_ad(i,j,km+1) = 0.d0
    pk_ae(i,j,1) = 0.d0
    p1d_ad(i) = 0.d0
  end do

!----------------------------------------------
! CLOSE TAPE geopk_tape
!----------------------------------------------
  if (allocated(geopk_tape_delp_1h)) then
    deallocate( geopk_tape_delp_1h )
  endif
  if (allocated(geopk_tape_pt_2h)) then
    deallocate( geopk_tape_pt_2h )
  endif
  if (allocated(geopk_tape_p1d_3h)) then
    deallocate( geopk_tape_p1d_3h )
  endif

end do
do k = 1, km+1
  do j = jfirst-1, jlast+1
    do i = 1, im
      pk_ae(i,j,k) = 0.d0
    end do
  end do
end do

end subroutine geopk_ad


#endif /* SPMD */
