#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     fill_module_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use fill_module

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine filew_ad( q, q_ae, im, jm, jfirst, jlast, acap, tiny, cosp2 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
real(kind=r8) :: cosp2
integer :: im
integer :: jfirst
integer :: jlast
integer :: jm
real(kind=r8) :: q(im,jfirst:jlast)
real(kind=r8) :: q_ae(im,jfirst:jlast)
real(kind=r8) :: tiny

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: d0
real(kind=r8) :: d0_ad
real(kind=r8) :: d1
real(kind=r8) :: d1_ad
real(kind=r8) :: d2
real(kind=r8) :: d2_ad
integer :: i
integer :: ib1
integer :: ib2
integer :: ip2
integer :: ipx
integer :: j
integer :: j1
integer :: j2
integer :: jb2
integer :: jb3
integer :: jb5
integer :: jb6
integer :: jb7
integer :: jb8
integer :: jm1
real(kind=r8) :: qh(im,jfirst:jlast)
real(kind=r8) :: qtmp(jfirst:jlast,im)
real(kind=r8) :: qtmp_ad(jfirst:jlast,im)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
qh(:,:) = q(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
d0_ad = 0.d0
d1_ad = 0.d0
d2_ad = 0.d0
qtmp_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
j1 = max(jfirst,2)
j2 = min(jlast,jm-1)
jm1 = jm-1
ipx = 0

! Copy & swap direction for vectorization.
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do

do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      ipx = 1
! west
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
! east
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do

i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
! west
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
! east
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do

i = im
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
! west
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
! east
    d0 = max(0._8,qtmp(j,1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,1) = qtmp(j,1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do

if (ipx .ne. 0) then

!-----------
! Final pass
!-----------
  do i = 1, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
! Take mass from east (essentially adjusting fx(i+1,j))
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = im, 2, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
! Take mass from west (essentially adjusting fx(i,j))
        qtmp(j,i-1) = qtmp(j,i-1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do

  do j = j1, j2
    do i = 1, im
      q(i,j) = qtmp(j,i)
    end do
  end do
endif

! Check Poles.

if (jfirst .eq. 1) then
  if (q(1,1) .lt. 0.) then
    call pfix( q(1,2),q(1,1),im,ipx,acap,cosp2 )
  else
!            Check j=2
    ip2 = 0
    do i = 1, im
      if (q(i,2) .lt. 0.) then
        ip2 = 1
        exit
      endif
    end do
    if (ip2 .ne. 0) then
      call pfix( q(1,2),q(1,1),im,ipx,acap,cosp2 )
    endif
  endif
endif

if (jlast .eq. jm) then
  if (q(1,jm) .lt. 0.) then
    call pfix_ad( q_ae(1,jm1),q_ae(1,jm),im,acap,cosp2 )
  else
!             Check j=jm1
    ip2 = 0
    do i = 1, im
      if (q(i,jm1) .lt. 0.) then
        ip2 = 1
        exit
      endif
    end do
    if (ip2 .ne. 0) then
      call pfix_ad( q_ae(1,jm1),q_ae(1,jm),im,acap,cosp2 )
    endif
  endif
endif


q(:,:) = qh(:,:)
ipx = 0
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      ipx = 1
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
i = im
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,1) = qtmp(j,1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
if (ipx .ne. 0) then
  do i = 1, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = im, 2, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i-1) = qtmp(j,i-1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do j = j1, j2
    do i = 1, im
      q(i,j) = qtmp(j,i)
    end do
  end do
endif
if (jfirst .eq. 1) then
  if (q(1,1) .lt. 0.) then
    call pfix_ad( q_ae(1,2),q_ae(1,1),im,acap,cosp2 )
  else
    ip2 = 0
    do i = 1, im
      if (q(i,2) .lt. 0.) then
        ip2 = 1
        exit
      endif
    end do
    if (ip2 .ne. 0) then
      call pfix_ad( q_ae(1,2),q_ae(1,1),im,acap,cosp2 )
    endif
  endif
endif
q(:,:) = qh(:,:)
ipx = 0
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      ipx = 1
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
i = im
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,1) = qtmp(j,1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
if (ipx .ne. 0) then
  do i = 1, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do j = j1, j2
    do i = 1, im
      qtmp_ad(j,i) = qtmp_ad(j,i)+q_ae(i,j)
      q_ae(i,j) = 0.d0
    end do
  end do
  do i = im, 3, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i-1) = qtmp(j,i-1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = 2, im
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp_ad(j,i) = 0.d0
        qtmp_ad(j,i) = qtmp_ad(j,i)+qtmp_ad(j,i-1)
      endif
    end do
  end do
  q(:,:) = qh(:,:)
  do i = 1, im
    do j = j1, j2
      qtmp(j,i) = q(i,j)
    end do
  end do
  do i = 2, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        d0 = max(0._8,qtmp(j,i-1))
        d1 = min(-qtmp(j,i),d0)
        qtmp(j,i-1) = qtmp(j,i-1)-d1
        qtmp(j,i) = qtmp(j,i)+d1
        d0 = max(0._8,qtmp(j,i+1))
        d2 = min(-qtmp(j,i),d0)
        qtmp(j,i+1) = qtmp(j,i+1)-d2
        qtmp(j,i) = qtmp(j,i)+d2+tiny
      endif
    end do
  end do
  i = 1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,im))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,im) = qtmp(j,im)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
  i = im
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,1) = qtmp(j,1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
  do i = 1, (-2)+im
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = im-1, 1, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp_ad(j,i) = 0.d0
        qtmp_ad(j,i) = qtmp_ad(j,i)+qtmp_ad(j,i+1)
      endif
    end do
  end do
endif
q(:,:) = qh(:,:)
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
do j = j1, j2
  i = im
  d0_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  if (qtmp(j,i) .lt. 0.) then
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,1))
    d2_ad = d2_ad+qtmp_ad(j,i)
    d2_ad = d2_ad-qtmp_ad(j,1)
    d0_ad = d0_ad+d2_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d2_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d2_ad = 0.d0
    qtmp_ad(j,1) = qtmp_ad(j,1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,1)))
    d0_ad = 0.d0
    d1_ad = d1_ad+qtmp_ad(j,i)
    d1_ad = d1_ad-qtmp_ad(j,i-1)
    do i = 1, im
      do jb2 = j1, j2
        qtmp(jb2,i) = q(i,jb2)
      end do
    end do
    do i = 2, im-1
      do jb2 = j1, j2
        if (qtmp(jb2,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb2,i-1))
          d1 = min(-qtmp(jb2,i),d0)
          qtmp(jb2,i-1) = qtmp(jb2,i-1)-d1
          qtmp(jb2,i) = qtmp(jb2,i)+d1
          d0 = max(0._8,qtmp(jb2,i+1))
          d2 = min(-qtmp(jb2,i),d0)
          qtmp(jb2,i+1) = qtmp(jb2,i+1)-d2
          qtmp(jb2,i) = qtmp(jb2,i)+d2+tiny
        endif
      end do
    end do
    i = 1
    do jb2 = j1, j2
      if (qtmp(jb2,i) .lt. 0.) then
        d0 = max(0._8,qtmp(jb2,im))
        d1 = min(-qtmp(jb2,i),d0)
        qtmp(jb2,im) = qtmp(jb2,im)-d1
        qtmp(jb2,i) = qtmp(jb2,i)+d1
        d0 = max(0._8,qtmp(jb2,i+1))
        d2 = min(-qtmp(jb2,i),d0)
        qtmp(jb2,i+1) = qtmp(jb2,i+1)-d2
        qtmp(jb2,i) = qtmp(jb2,i)+d2+tiny
      endif
    end do
    i = im
    d0 = max(0._8,qtmp(j,i-1))
    d0_ad = d0_ad+d1_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d1_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d1_ad = 0.d0
    do i = 1, im
      do jb3 = j1, j2
        qtmp(jb3,i) = q(i,jb3)
      end do
    end do
    do i = 2, im-1
      do jb3 = j1, j2
        if (qtmp(jb3,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb3,i-1))
          d1 = min(-qtmp(jb3,i),d0)
          qtmp(jb3,i-1) = qtmp(jb3,i-1)-d1
          qtmp(jb3,i) = qtmp(jb3,i)+d1
          d0 = max(0._8,qtmp(jb3,i+1))
          d2 = min(-qtmp(jb3,i),d0)
          qtmp(jb3,i+1) = qtmp(jb3,i+1)-d2
          qtmp(jb3,i) = qtmp(jb3,i)+d2+tiny
        endif
      end do
    end do
    i = 1
    do jb3 = j1, j2
      if (qtmp(jb3,i) .lt. 0.) then
        d0 = max(0._8,qtmp(jb3,im))
        d1 = min(-qtmp(jb3,i),d0)
        qtmp(jb3,im) = qtmp(jb3,im)-d1
        qtmp(jb3,i) = qtmp(jb3,i)+d1
        d0 = max(0._8,qtmp(jb3,i+1))
        d2 = min(-qtmp(jb3,i),d0)
        qtmp(jb3,i+1) = qtmp(jb3,i+1)-d2
        qtmp(jb3,i) = qtmp(jb3,i)+d2+tiny
      endif
    end do
    i = im
    qtmp_ad(j,i-1) = qtmp_ad(j,i-1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i-1)))
    d0_ad = 0.d0
  endif
end do
q(:,:) = qh(:,:)
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
do j = j1, j2
  i = 1
  d0_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  if (qtmp(j,i) .lt. 0.) then
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2_ad = d2_ad+qtmp_ad(j,i)
    d2_ad = d2_ad-qtmp_ad(j,i+1)
    d0_ad = d0_ad+d2_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d2_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d2_ad = 0.d0
    qtmp_ad(j,i+1) = qtmp_ad(j,i+1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i+1)))
    d0_ad = 0.d0
    d1_ad = d1_ad+qtmp_ad(j,i)
    d1_ad = d1_ad-qtmp_ad(j,im)
    do i = 1, im
      do jb5 = j1, j2
        qtmp(jb5,i) = q(i,jb5)
      end do
    end do
    do i = 2, im-1
      do jb5 = j1, j2
        if (qtmp(jb5,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb5,i-1))
          d1 = min(-qtmp(jb5,i),d0)
          qtmp(jb5,i-1) = qtmp(jb5,i-1)-d1
          qtmp(jb5,i) = qtmp(jb5,i)+d1
          d0 = max(0._8,qtmp(jb5,i+1))
          d2 = min(-qtmp(jb5,i),d0)
          qtmp(jb5,i+1) = qtmp(jb5,i+1)-d2
          qtmp(jb5,i) = qtmp(jb5,i)+d2+tiny
        endif
      end do
    end do
    i = 1
    d0 = max(0._8,qtmp(j,im))
    d0_ad = d0_ad+d1_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d1_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d1_ad = 0.d0
    do i = 1, im
      do jb6 = j1, j2
        qtmp(jb6,i) = q(i,jb6)
      end do
    end do
    do i = 2, im-1
      do jb6 = j1, j2
        if (qtmp(jb6,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb6,i-1))
          d1 = min(-qtmp(jb6,i),d0)
          qtmp(jb6,i-1) = qtmp(jb6,i-1)-d1
          qtmp(jb6,i) = qtmp(jb6,i)+d1
          d0 = max(0._8,qtmp(jb6,i+1))
          d2 = min(-qtmp(jb6,i),d0)
          qtmp(jb6,i+1) = qtmp(jb6,i+1)-d2
          qtmp(jb6,i) = qtmp(jb6,i)+d2+tiny
        endif
      end do
    end do
    qtmp_ad(j,im) = qtmp_ad(j,im)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,im)))
    d0_ad = 0.d0
  endif
end do
q(:,:) = qh(:,:)
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  d0_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  do j = j1, j2
    d0_ad = 0.d0
    d1_ad = 0.d0
    d2_ad = 0.d0
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2_ad = d2_ad+qtmp_ad(j,i)
      d2_ad = d2_ad-qtmp_ad(j,i+1)
      d0_ad = d0_ad+d2_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
      qtmp_ad(j,i) = qtmp_ad(j,i)-d2_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
      d2_ad = 0.d0
      qtmp_ad(j,i+1) = qtmp_ad(j,i+1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i+1)))
      d0_ad = 0.d0
      d1_ad = d1_ad+qtmp_ad(j,i)
      d1_ad = d1_ad-qtmp_ad(j,i-1)
      do ib1 = 1, im
        do jb7 = j1, j2
          qtmp(jb7,ib1) = q(ib1,jb7)
        end do
      end do
      d0 = max(0._8,qtmp(j,i-1))
      d0_ad = d0_ad+d1_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
      qtmp_ad(j,i) = qtmp_ad(j,i)-d1_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
      d1_ad = 0.d0
      do ib2 = 1, im
        do jb8 = j1, j2
          qtmp(jb8,ib2) = q(ib2,jb8)
        end do
      end do
      qtmp_ad(j,i-1) = qtmp_ad(j,i-1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i-1)))
      d0_ad = 0.d0
    endif
  end do
end do
do i = 1, im
  do j = j1, j2
    q_ae(i,j) = q_ae(i,j)+qtmp_ad(j,i)
    qtmp_ad(j,i) = 0.d0
  end do
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine filew_ad


subroutine fillxy_ad( q, q_ae, im, jm, jfirst, jlast, acap, cosp )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-20

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: q(im,jfirst:jlast)
real(kind=r8) :: q_ae(im,jfirst:jlast)

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
call filew_ad( q,q_ae,im,jm,jfirst,jlast,acap,tiny,cosp(2) )

end subroutine fillxy_ad


subroutine pfix_ad( q_ae, qp_ad, im, acap, cosp2 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
real(kind=r8) :: cosp2
integer :: im
real(kind=r8) :: q_ae(im)
real(kind=r8) :: qp_ad(im)

!==============================================
! declare local variables
!==============================================
integer :: i
real(kind=r8) :: pmean_ad
real(kind=r8) :: summ_ad
real(kind=r8) :: sump_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
pmean_ad = 0.d0
summ_ad = 0.d0
sump_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do i = 1, im
  pmean_ad = pmean_ad+qp_ad(i)
  qp_ad(i) = 0.d0
  pmean_ad = pmean_ad+q_ae(i)
  q_ae(i) = 0.d0
end do
summ_ad = summ_ad+pmean_ad*(cosp2/(acap+cosp2*im))
sump_ad = sump_ad+pmean_ad*(acap/(acap+cosp2*im))
pmean_ad = 0.d0
sump_ad = sump_ad/dble(im)
do i = 1, im
  qp_ad(i) = qp_ad(i)+sump_ad
  q_ae(i) = q_ae(i)+summ_ad
end do

end subroutine pfix_ad


end module     fill_module_ad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     fill_module_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use fill_module

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine filew_ad( q, q_ae, im, jm, jfirst, jlast, acap, tiny, cosp2 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
real(kind=r8) :: cosp2
integer :: im
integer :: jfirst
integer :: jlast
integer :: jm
real(kind=r8) :: q(im,jfirst:jlast)
real(kind=r8) :: q_ae(im,jfirst:jlast)
real(kind=r8) :: tiny

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: d0
real(kind=r8) :: d0_ad
real(kind=r8) :: d1
real(kind=r8) :: d1_ad
real(kind=r8) :: d2
real(kind=r8) :: d2_ad
integer :: i
integer :: ib1
integer :: ib2
integer :: ip2
integer :: ipx
integer :: j
integer :: j1
integer :: j2
integer :: jb2
integer :: jb3
integer :: jb5
integer :: jb6
integer :: jb7
integer :: jb8
integer :: jm1
real(kind=r8) :: qh(im,jfirst:jlast)
real(kind=r8) :: qtmp(jfirst:jlast,im)
real(kind=r8) :: qtmp_ad(jfirst:jlast,im)

!----------------------------------------------
! SAVE REQUIRED INPUT VARIABLES
!----------------------------------------------
qh(:,:) = q(:,:)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
d0_ad = 0.d0
d1_ad = 0.d0
d2_ad = 0.d0
qtmp_ad(:,:) = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
j1 = max(jfirst,2)
j2 = min(jlast,jm-1)
jm1 = jm-1
ipx = 0
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      ipx = 1
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
i = im
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,1) = qtmp(j,1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
if (ipx .ne. 0) then
  do i = 1, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = im, 2, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i-1) = qtmp(j,i-1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do j = j1, j2
    do i = 1, im
      q(i,j) = qtmp(j,i)
    end do
  end do
endif
if (jfirst .eq. 1) then
  if (q(1,1) .lt. 0.) then
    call pfix( q(1,2),q(1,1),im,ipx,acap,cosp2 )
  else
    ip2 = 0
    do i = 1, im
      if (q(i,2) .lt. 0.) then
        ip2 = 1
        exit
      endif
    end do
    if (ip2 .ne. 0) then
      call pfix( q(1,2),q(1,1),im,ipx,acap,cosp2 )
    endif
  endif
endif
if (jlast .eq. jm) then
  if (q(1,jm) .lt. 0.) then
    call pfix_ad( q_ae(1,jm1),q_ae(1,jm),im,acap,cosp2 )
  else
    ip2 = 0
    do i = 1, im
      if (q(i,jm1) .lt. 0.) then
        ip2 = 1
        exit
      endif
    end do
    if (ip2 .ne. 0) then
      call pfix_ad( q_ae(1,jm1),q_ae(1,jm),im,acap,cosp2 )
    endif
  endif
endif
q(:,:) = qh(:,:)
ipx = 0
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      ipx = 1
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
i = im
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,1) = qtmp(j,1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
if (ipx .ne. 0) then
  do i = 1, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = im, 2, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i-1) = qtmp(j,i-1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do j = j1, j2
    do i = 1, im
      q(i,j) = qtmp(j,i)
    end do
  end do
endif
if (jfirst .eq. 1) then
  if (q(1,1) .lt. 0.) then
    call pfix_ad( q_ae(1,2),q_ae(1,1),im,acap,cosp2 )
  else
    ip2 = 0
    do i = 1, im
      if (q(i,2) .lt. 0.) then
        ip2 = 1
        exit
      endif
    end do
    if (ip2 .ne. 0) then
      call pfix_ad( q_ae(1,2),q_ae(1,1),im,acap,cosp2 )
    endif
  endif
endif
q(:,:) = qh(:,:)
ipx = 0
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      ipx = 1
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
i = im
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    ipx = 1
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,1) = qtmp(j,1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
if (ipx .ne. 0) then
  do i = 1, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do j = j1, j2
    do i = 1, im
      qtmp_ad(j,i) = qtmp_ad(j,i)+q_ae(i,j)
      q_ae(i,j) = 0.d0
    end do
  end do
  do i = im, 3, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i-1) = qtmp(j,i-1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = 2, im
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp_ad(j,i) = 0.d0
        qtmp_ad(j,i) = qtmp_ad(j,i)+qtmp_ad(j,i-1)
      endif
    end do
  end do
  q(:,:) = qh(:,:)
  do i = 1, im
    do j = j1, j2
      qtmp(j,i) = q(i,j)
    end do
  end do
  do i = 2, im-1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        d0 = max(0._8,qtmp(j,i-1))
        d1 = min(-qtmp(j,i),d0)
        qtmp(j,i-1) = qtmp(j,i-1)-d1
        qtmp(j,i) = qtmp(j,i)+d1
        d0 = max(0._8,qtmp(j,i+1))
        d2 = min(-qtmp(j,i),d0)
        qtmp(j,i+1) = qtmp(j,i+1)-d2
        qtmp(j,i) = qtmp(j,i)+d2+tiny
      endif
    end do
  end do
  i = 1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,im))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,im) = qtmp(j,im)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
  i = im
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,1) = qtmp(j,1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
  do i = 1, (-2)+im
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp(j,i+1) = qtmp(j,i+1)+qtmp(j,i)
        qtmp(j,i) = 0.
      endif
    end do
  end do
  do i = im-1, 1, -1
    do j = j1, j2
      if (qtmp(j,i) .lt. 0.) then
        qtmp_ad(j,i) = 0.d0
        qtmp_ad(j,i) = qtmp_ad(j,i)+qtmp_ad(j,i+1)
      endif
    end do
  end do
endif
q(:,:) = qh(:,:)
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  if (qtmp(j,i) .lt. 0.) then
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2 = min(-qtmp(j,i),d0)
    qtmp(j,i+1) = qtmp(j,i+1)-d2
    qtmp(j,i) = qtmp(j,i)+d2+tiny
  endif
end do
i = im
do j = j1, j2
  d0_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  if (qtmp(j,i) .lt. 0.) then
    d0 = max(0._8,qtmp(j,i-1))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,i-1) = qtmp(j,i-1)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,1))
    d2_ad = d2_ad+qtmp_ad(j,i)
    d2_ad = d2_ad-qtmp_ad(j,1)
    d0_ad = d0_ad+d2_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d2_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d2_ad = 0.d0
    qtmp_ad(j,1) = qtmp_ad(j,1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,1)))
    d0_ad = 0.d0
    d1_ad = d1_ad+qtmp_ad(j,i)
    d1_ad = d1_ad-qtmp_ad(j,i-1)
    do i = 1, im
      do jb2 = j1, j2
        qtmp(jb2,i) = q(i,jb2)
      end do
    end do
    do i = 2, im-1
      do jb2 = j1, j2
        if (qtmp(jb2,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb2,i-1))
          d1 = min(-qtmp(jb2,i),d0)
          qtmp(jb2,i-1) = qtmp(jb2,i-1)-d1
          qtmp(jb2,i) = qtmp(jb2,i)+d1
          d0 = max(0._8,qtmp(jb2,i+1))
          d2 = min(-qtmp(jb2,i),d0)
          qtmp(jb2,i+1) = qtmp(jb2,i+1)-d2
          qtmp(jb2,i) = qtmp(jb2,i)+d2+tiny
        endif
      end do
    end do
    i = 1
    do jb2 = j1, j2
      if (qtmp(jb2,i) .lt. 0.) then
        d0 = max(0._8,qtmp(jb2,im))
        d1 = min(-qtmp(jb2,i),d0)
        qtmp(jb2,im) = qtmp(jb2,im)-d1
        qtmp(jb2,i) = qtmp(jb2,i)+d1
        d0 = max(0._8,qtmp(jb2,i+1))
        d2 = min(-qtmp(jb2,i),d0)
        qtmp(jb2,i+1) = qtmp(jb2,i+1)-d2
        qtmp(jb2,i) = qtmp(jb2,i)+d2+tiny
      endif
    end do
    i = im
    d0 = max(0._8,qtmp(j,i-1))
    d0_ad = d0_ad+d1_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d1_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d1_ad = 0.d0
    do i = 1, im
      do jb3 = j1, j2
        qtmp(jb3,i) = q(i,jb3)
      end do
    end do
    do i = 2, im-1
      do jb3 = j1, j2
        if (qtmp(jb3,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb3,i-1))
          d1 = min(-qtmp(jb3,i),d0)
          qtmp(jb3,i-1) = qtmp(jb3,i-1)-d1
          qtmp(jb3,i) = qtmp(jb3,i)+d1
          d0 = max(0._8,qtmp(jb3,i+1))
          d2 = min(-qtmp(jb3,i),d0)
          qtmp(jb3,i+1) = qtmp(jb3,i+1)-d2
          qtmp(jb3,i) = qtmp(jb3,i)+d2+tiny
        endif
      end do
    end do
    i = 1
    do jb3 = j1, j2
      if (qtmp(jb3,i) .lt. 0.) then
        d0 = max(0._8,qtmp(jb3,im))
        d1 = min(-qtmp(jb3,i),d0)
        qtmp(jb3,im) = qtmp(jb3,im)-d1
        qtmp(jb3,i) = qtmp(jb3,i)+d1
        d0 = max(0._8,qtmp(jb3,i+1))
        d2 = min(-qtmp(jb3,i),d0)
        qtmp(jb3,i+1) = qtmp(jb3,i+1)-d2
        qtmp(jb3,i) = qtmp(jb3,i)+d2+tiny
      endif
    end do
    i = im
    qtmp_ad(j,i-1) = qtmp_ad(j,i-1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i-1)))
    d0_ad = 0.d0
  endif
end do
q(:,:) = qh(:,:)
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  do j = j1, j2
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2 = min(-qtmp(j,i),d0)
      qtmp(j,i+1) = qtmp(j,i+1)-d2
      qtmp(j,i) = qtmp(j,i)+d2+tiny
    endif
  end do
end do
i = 1
do j = j1, j2
  d0_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  if (qtmp(j,i) .lt. 0.) then
    d0 = max(0._8,qtmp(j,im))
    d1 = min(-qtmp(j,i),d0)
    qtmp(j,im) = qtmp(j,im)-d1
    qtmp(j,i) = qtmp(j,i)+d1
    d0 = max(0._8,qtmp(j,i+1))
    d2_ad = d2_ad+qtmp_ad(j,i)
    d2_ad = d2_ad-qtmp_ad(j,i+1)
    d0_ad = d0_ad+d2_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d2_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d2_ad = 0.d0
    qtmp_ad(j,i+1) = qtmp_ad(j,i+1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i+1)))
    d0_ad = 0.d0
    d1_ad = d1_ad+qtmp_ad(j,i)
    d1_ad = d1_ad-qtmp_ad(j,im)
    do i = 1, im
      do jb5 = j1, j2
        qtmp(jb5,i) = q(i,jb5)
      end do
    end do
    do i = 2, im-1
      do jb5 = j1, j2
        if (qtmp(jb5,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb5,i-1))
          d1 = min(-qtmp(jb5,i),d0)
          qtmp(jb5,i-1) = qtmp(jb5,i-1)-d1
          qtmp(jb5,i) = qtmp(jb5,i)+d1
          d0 = max(0._8,qtmp(jb5,i+1))
          d2 = min(-qtmp(jb5,i),d0)
          qtmp(jb5,i+1) = qtmp(jb5,i+1)-d2
          qtmp(jb5,i) = qtmp(jb5,i)+d2+tiny
        endif
      end do
    end do
    i = 1
    d0 = max(0._8,qtmp(j,im))
    d0_ad = d0_ad+d1_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
    qtmp_ad(j,i) = qtmp_ad(j,i)-d1_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
    d1_ad = 0.d0
    do i = 1, im
      do jb6 = j1, j2
        qtmp(jb6,i) = q(i,jb6)
      end do
    end do
    do i = 2, im-1
      do jb6 = j1, j2
        if (qtmp(jb6,i) .lt. 0.) then
          d0 = max(0._8,qtmp(jb6,i-1))
          d1 = min(-qtmp(jb6,i),d0)
          qtmp(jb6,i-1) = qtmp(jb6,i-1)-d1
          qtmp(jb6,i) = qtmp(jb6,i)+d1
          d0 = max(0._8,qtmp(jb6,i+1))
          d2 = min(-qtmp(jb6,i),d0)
          qtmp(jb6,i+1) = qtmp(jb6,i+1)-d2
          qtmp(jb6,i) = qtmp(jb6,i)+d2+tiny
        endif
      end do
    end do
    qtmp_ad(j,im) = qtmp_ad(j,im)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,im)))
    d0_ad = 0.d0
  endif
end do
q(:,:) = qh(:,:)
do i = 1, im
  do j = j1, j2
    qtmp(j,i) = q(i,j)
  end do
end do
do i = 2, im-1
  d0_ad = 0.d0
  d1_ad = 0.d0
  d2_ad = 0.d0
  do j = j1, j2
    d0_ad = 0.d0
    d1_ad = 0.d0
    d2_ad = 0.d0
    if (qtmp(j,i) .lt. 0.) then
      d0 = max(0._8,qtmp(j,i-1))
      d1 = min(-qtmp(j,i),d0)
      qtmp(j,i-1) = qtmp(j,i-1)-d1
      qtmp(j,i) = qtmp(j,i)+d1
      d0 = max(0._8,qtmp(j,i+1))
      d2_ad = d2_ad+qtmp_ad(j,i)
      d2_ad = d2_ad-qtmp_ad(j,i+1)
      d0_ad = d0_ad+d2_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
      qtmp_ad(j,i) = qtmp_ad(j,i)-d2_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
      d2_ad = 0.d0
      qtmp_ad(j,i+1) = qtmp_ad(j,i+1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i+1)))
      d0_ad = 0.d0
      d1_ad = d1_ad+qtmp_ad(j,i)
      d1_ad = d1_ad-qtmp_ad(j,i-1)
      do ib1 = 1, im
        do jb7 = j1, j2
          qtmp(jb7,ib1) = q(ib1,jb7)
        end do
      end do
      d0 = max(0._8,qtmp(j,i-1))
      d0_ad = d0_ad+d1_ad*(0.5-sign(0.5d0,d0-(-qtmp(j,i))))
      qtmp_ad(j,i) = qtmp_ad(j,i)-d1_ad*(0.5+sign(0.5d0,d0-(-qtmp(j,i))))
      d1_ad = 0.d0
      do ib2 = 1, im
        do jb8 = j1, j2
          qtmp(jb8,ib2) = q(ib2,jb8)
        end do
      end do
      qtmp_ad(j,i-1) = qtmp_ad(j,i-1)+d0_ad*(0.5-sign(0.5d0,0._8-qtmp(j,i-1)))
      d0_ad = 0.d0
    endif
  end do
end do
do i = 1, im
  do j = j1, j2
    q_ae(i,j) = q_ae(i,j)+qtmp_ad(j,i)
    qtmp_ad(j,i) = 0.d0
  end do
end do

!----------------------------------------------
! FREE DYNAMIC MEMORY
!----------------------------------------------

end subroutine filew_ad


subroutine fillxy_ad( q, q_ae, im, jm, jfirst, jlast, acap, cosp )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare parameters
!==============================================
real(kind=r8), parameter :: tiny = 1.e-20

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
integer :: jm
real(kind=r8) :: cosp(jm)
integer :: im
integer :: jfirst
integer :: jlast
real(kind=r8) :: q(im,jfirst:jlast)
real(kind=r8) :: q_ae(im,jfirst:jlast)

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
call filew_ad( q,q_ae,im,jm,jfirst,jlast,acap,tiny,cosp(2) )

end subroutine fillxy_ad


subroutine pfix_ad( q_ae, qp_ad, im, acap, cosp2 )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
real(kind=r8) :: acap
real(kind=r8) :: cosp2
integer :: im
real(kind=r8) :: q_ae(im)
real(kind=r8) :: qp_ad(im)

!==============================================
! declare local variables
!==============================================
integer :: i
real(kind=r8) :: pmean_ad
real(kind=r8) :: summ_ad
real(kind=r8) :: sump_ad

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
pmean_ad = 0.d0
summ_ad = 0.d0
sump_ad = 0.d0

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
do i = 1, im
  pmean_ad = pmean_ad+qp_ad(i)
  qp_ad(i) = 0.d0
  pmean_ad = pmean_ad+q_ae(i)
  q_ae(i) = 0.d0
end do
summ_ad = summ_ad+pmean_ad*(cosp2/(acap+cosp2*im))
sump_ad = sump_ad+pmean_ad*(acap/(acap+cosp2*im))
pmean_ad = 0.d0
sump_ad = sump_ad/dble(im)
do i = 1, im
  qp_ad(i) = qp_ad(i)+sump_ad
  q_ae(i) = q_ae(i)+summ_ad
end do

end subroutine pfix_ad


end module     fill_module_ad


#endif /* SPMD */
