#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     dry_adj_ad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real, allocatable :: dry_adj_tape_dp_2h(:,:)
integer :: dry_adj_tape_dry_adj
real, allocatable :: dry_adj_tape_pt_1h(:,:,:)
real, allocatable :: dry_adj_tape_u_3h(:,:)
real, allocatable :: dry_adj_tape_v_4h(:,:)

end module     dry_adj_ad_store


subroutine dry_adj_ad( im, km, rdt, pt, pt_ae, fu_ad, fv_ad, u, u_ae, v, v_ae, dp, dp_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use dry_adj_ad_store, only : dry_adj_tape_dp_2h,dry_adj_tape_dry_adj,dry_adj_tape_pt_1h,dry_adj_tape_u_3h,dry_adj_tape_v_4h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: km
real :: dp(im,km)
real :: dp_ad(im,km)
real :: fu_ad(im,km)
real :: fv_ad(im,km)
real :: pt(im,km)
real :: pt_ae(im,km)
real :: rdt
real :: u(im,km)
real :: u_ae(im,km)
real :: v(im,km)
real :: v_ae(im,km)

!==============================================
! declare local variables
!==============================================
real :: dp1
real :: dp1_ad
real :: dp2
real :: dp2_ad
integer :: i
integer :: k
integer :: klow
logical :: mixm
real :: ptm
real :: ptm_ad
real :: um
real :: um_ad
real :: ut_ad(im,km)
real :: vm
real :: vm_ad
real :: vt_ad(im,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dp1_ad = 0.
dp2_ad = 0.
ptm_ad = 0.
um_ad = 0.
ut_ad(:,:) = 0.
vm_ad = 0.
vt_ad(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
mixm =  .true. 
klow = max(km/16,1)
if (mixm) then
  do k = 1, klow+3
    do i = 1, im
      v_ae(i,k) = v_ae(i,k)+fv_ad(i,k)*rdt
      vt_ad(i,k) = vt_ad(i,k)-fv_ad(i,k)*rdt
      u_ae(i,k) = u_ae(i,k)+fu_ad(i,k)*rdt
      ut_ad(i,k) = ut_ad(i,k)-fu_ad(i,k)*rdt
    end do
  end do
endif
do k = klow, 1, -1
  pt(:,k:k+1) = dry_adj_tape_pt_1h(:,:,k)
  do i = 1, im
    dp1_ad = 0.
    dp2_ad = 0.
    ptm_ad = 0.
    um_ad = 0.
    vm_ad = 0.
    if (pt(i,k) .lt. pt(i,k+1)) then
      dp(i,k:k+3) = dry_adj_tape_dp_2h(:,k)
      u(i,k:k+3) = dry_adj_tape_u_3h(:,k)
      v(i,k:k+3) = dry_adj_tape_v_4h(:,k)
      dp1 = dp(i,k)+dp(i,k+1)
      ptm = (pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/dp1
      pt(i,k) = ptm
      pt(i,k+1) = ptm
      if (mixm) then
        um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
        u(i,k) = um
        u(i,k+1) = um
        vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
        v(i,k) = vm
        v(i,k+1) = vm
      endif
      if (ptm .lt. pt(i,k+2)) then
        dp2 = dp1+dp(i,k+2)
        ptm = (ptm*dp1+pt(i,k+2)*dp(i,k+2))/dp2
        pt(i,k) = ptm
        pt(i,k+1) = ptm
        pt(i,k+2) = ptm
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
          u(i,k) = um
          u(i,k+1) = um
          u(i,k+2) = um
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
          v(i,k) = vm
          v(i,k+1) = vm
          v(i,k+2) = vm
        endif
        if (ptm .lt. pt(i,k+3)) then
          if (mixm) then
            um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
            um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
            vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
            vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
            vm_ad = vm_ad+v_ae(i,k+3)
            v_ae(i,k+3) = 0.
            vm_ad = vm_ad+v_ae(i,k+2)
            v_ae(i,k+2) = 0.
            vm_ad = vm_ad+v_ae(i,k+1)
            v_ae(i,k+1) = 0.
            vm_ad = vm_ad+v_ae(i,k)
            v_ae(i,k) = 0.
            dp_ad(i,k+3) = dp_ad(i,k+3)+vm_ad*(v(i,k+3)/(dp2+dp(i,k+3))-(vm*dp2+v(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3)&
&)))
            dp2_ad = dp2_ad+vm_ad*(vm/(dp2+dp(i,k+3))-(vm*dp2+v(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3))))
            v_ae(i,k+3) = v_ae(i,k+3)+vm_ad*(dp(i,k+3)/(dp2+dp(i,k+3)))
            vm_ad = vm_ad*(dp2/(dp2+dp(i,k+3)))
            vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
            dp_ad(i,k+2) = dp_ad(i,k+2)+vm_ad*(v(i,k+2)/dp2)
            dp1_ad = dp1_ad+vm_ad*(vm/dp2)
            dp2_ad = dp2_ad-vm_ad*((vm*dp1+v(i,k+2)*dp(i,k+2))/(dp2*dp2))
            v_ae(i,k+2) = v_ae(i,k+2)+vm_ad*(dp(i,k+2)/dp2)
            vm_ad = vm_ad*(dp1/dp2)
            dp_ad(i,k+1) = dp_ad(i,k+1)+vm_ad*(v(i,k+1)/dp1)
            dp_ad(i,k) = dp_ad(i,k)+vm_ad*(v(i,k)/dp1)
            dp1_ad = dp1_ad-vm_ad*((v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/(dp1*dp1))
            v_ae(i,k+1) = v_ae(i,k+1)+vm_ad*(dp(i,k+1)/dp1)
            v_ae(i,k) = v_ae(i,k)+vm_ad*(dp(i,k)/dp1)
            vm_ad = 0.
            um_ad = um_ad+u_ae(i,k+3)
            u_ae(i,k+3) = 0.
            um_ad = um_ad+u_ae(i,k+2)
            u_ae(i,k+2) = 0.
            um_ad = um_ad+u_ae(i,k+1)
            u_ae(i,k+1) = 0.
            um_ad = um_ad+u_ae(i,k)
            u_ae(i,k) = 0.
            dp_ad(i,k+3) = dp_ad(i,k+3)+um_ad*(u(i,k+3)/(dp2+dp(i,k+3))-(um*dp2+u(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3)&
&)))
            dp2_ad = dp2_ad+um_ad*(um/(dp2+dp(i,k+3))-(um*dp2+u(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3))))
            u_ae(i,k+3) = u_ae(i,k+3)+um_ad*(dp(i,k+3)/(dp2+dp(i,k+3)))
            um_ad = um_ad*(dp2/(dp2+dp(i,k+3)))
            um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
            dp_ad(i,k+2) = dp_ad(i,k+2)+um_ad*(u(i,k+2)/dp2)
            dp1_ad = dp1_ad+um_ad*(um/dp2)
            dp2_ad = dp2_ad-um_ad*((um*dp1+u(i,k+2)*dp(i,k+2))/(dp2*dp2))
            u_ae(i,k+2) = u_ae(i,k+2)+um_ad*(dp(i,k+2)/dp2)
            um_ad = um_ad*(dp1/dp2)
            dp_ad(i,k+1) = dp_ad(i,k+1)+um_ad*(u(i,k+1)/dp1)
            dp_ad(i,k) = dp_ad(i,k)+um_ad*(u(i,k)/dp1)
            dp1_ad = dp1_ad-um_ad*((u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/(dp1*dp1))
            u_ae(i,k+1) = u_ae(i,k+1)+um_ad*(dp(i,k+1)/dp1)
            u_ae(i,k) = u_ae(i,k)+um_ad*(dp(i,k)/dp1)
            um_ad = 0.
          endif
          ptm_ad = ptm_ad+pt_ae(i,k+3)
          pt_ae(i,k+3) = 0.
          ptm_ad = ptm_ad+pt_ae(i,k+2)
          pt_ae(i,k+2) = 0.
          ptm_ad = ptm_ad+pt_ae(i,k+1)
          pt_ae(i,k+1) = 0.
          ptm_ad = ptm_ad+pt_ae(i,k)
          pt_ae(i,k) = 0.
          dp_ad(i,k+3) = dp_ad(i,k+3)+ptm_ad*(pt(i,k+3)/(dp2+dp(i,k+3))-(ptm*dp2+pt(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+&
&3))))
          dp2_ad = dp2_ad+ptm_ad*(ptm/(dp2+dp(i,k+3))-(ptm*dp2+pt(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3))))
          pt_ae(i,k+3) = pt_ae(i,k+3)+ptm_ad*(dp(i,k+3)/(dp2+dp(i,k+3)))
          ptm_ad = ptm_ad*(dp2/(dp2+dp(i,k+3)))
        endif
        u(i,k:k+3) = dry_adj_tape_u_3h(:,k)
        v(i,k:k+3) = dry_adj_tape_v_4h(:,k)
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          u(i,k) = um
          u(i,k+1) = um
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          v(i,k) = vm
          v(i,k+1) = vm
        endif
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          vm_ad = vm_ad+v_ae(i,k+2)
          v_ae(i,k+2) = 0.
          vm_ad = vm_ad+v_ae(i,k+1)
          v_ae(i,k+1) = 0.
          vm_ad = vm_ad+v_ae(i,k)
          v_ae(i,k) = 0.
          dp_ad(i,k+2) = dp_ad(i,k+2)+vm_ad*(v(i,k+2)/dp2)
          dp1_ad = dp1_ad+vm_ad*(vm/dp2)
          dp2_ad = dp2_ad-vm_ad*((vm*dp1+v(i,k+2)*dp(i,k+2))/(dp2*dp2))
          v_ae(i,k+2) = v_ae(i,k+2)+vm_ad*(dp(i,k+2)/dp2)
          vm_ad = vm_ad*(dp1/dp2)
          dp_ad(i,k+1) = dp_ad(i,k+1)+vm_ad*(v(i,k+1)/dp1)
          dp_ad(i,k) = dp_ad(i,k)+vm_ad*(v(i,k)/dp1)
          dp1_ad = dp1_ad-vm_ad*((v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/(dp1*dp1))
          v_ae(i,k+1) = v_ae(i,k+1)+vm_ad*(dp(i,k+1)/dp1)
          v_ae(i,k) = v_ae(i,k)+vm_ad*(dp(i,k)/dp1)
          vm_ad = 0.
          um_ad = um_ad+u_ae(i,k+2)
          u_ae(i,k+2) = 0.
          um_ad = um_ad+u_ae(i,k+1)
          u_ae(i,k+1) = 0.
          um_ad = um_ad+u_ae(i,k)
          u_ae(i,k) = 0.
          dp_ad(i,k+2) = dp_ad(i,k+2)+um_ad*(u(i,k+2)/dp2)
          dp1_ad = dp1_ad+um_ad*(um/dp2)
          dp2_ad = dp2_ad-um_ad*((um*dp1+u(i,k+2)*dp(i,k+2))/(dp2*dp2))
          u_ae(i,k+2) = u_ae(i,k+2)+um_ad*(dp(i,k+2)/dp2)
          um_ad = um_ad*(dp1/dp2)
          dp_ad(i,k+1) = dp_ad(i,k+1)+um_ad*(u(i,k+1)/dp1)
          dp_ad(i,k) = dp_ad(i,k)+um_ad*(u(i,k)/dp1)
          dp1_ad = dp1_ad-um_ad*((u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/(dp1*dp1))
          u_ae(i,k+1) = u_ae(i,k+1)+um_ad*(dp(i,k+1)/dp1)
          u_ae(i,k) = u_ae(i,k)+um_ad*(dp(i,k)/dp1)
          um_ad = 0.
        endif
        ptm_ad = ptm_ad+pt_ae(i,k+2)
        pt_ae(i,k+2) = 0.
        ptm_ad = ptm_ad+pt_ae(i,k+1)
        pt_ae(i,k+1) = 0.
        ptm_ad = ptm_ad+pt_ae(i,k)
        pt_ae(i,k) = 0.
        pt(:,k:k+1) = dry_adj_tape_pt_1h(:,:,k)
        ptm = (pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/dp1
        pt(i,k) = ptm
        pt(i,k+1) = ptm
        dp_ad(i,k+2) = dp_ad(i,k+2)+ptm_ad*(pt(i,k+2)/dp2)
        dp1_ad = dp1_ad+ptm_ad*(ptm/dp2)
        dp2_ad = dp2_ad-ptm_ad*((ptm*dp1+pt(i,k+2)*dp(i,k+2))/(dp2*dp2))
        pt_ae(i,k+2) = pt_ae(i,k+2)+ptm_ad*(dp(i,k+2)/dp2)
        ptm_ad = ptm_ad*(dp1/dp2)
        dp_ad(i,k+2) = dp_ad(i,k+2)+dp2_ad
        dp1_ad = dp1_ad+dp2_ad
        dp2_ad = 0.
      endif
      u(i,k:k+3) = dry_adj_tape_u_3h(:,k)
      v(i,k:k+3) = dry_adj_tape_v_4h(:,k)
      if (mixm) then
        vm_ad = vm_ad+v_ae(i,k+1)
        v_ae(i,k+1) = 0.
        vm_ad = vm_ad+v_ae(i,k)
        v_ae(i,k) = 0.
        dp_ad(i,k+1) = dp_ad(i,k+1)+vm_ad*(v(i,k+1)/dp1)
        dp_ad(i,k) = dp_ad(i,k)+vm_ad*(v(i,k)/dp1)
        dp1_ad = dp1_ad-vm_ad*((v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/(dp1*dp1))
        v_ae(i,k+1) = v_ae(i,k+1)+vm_ad*(dp(i,k+1)/dp1)
        v_ae(i,k) = v_ae(i,k)+vm_ad*(dp(i,k)/dp1)
        vm_ad = 0.
        um_ad = um_ad+u_ae(i,k+1)
        u_ae(i,k+1) = 0.
        um_ad = um_ad+u_ae(i,k)
        u_ae(i,k) = 0.
        dp_ad(i,k+1) = dp_ad(i,k+1)+um_ad*(u(i,k+1)/dp1)
        dp_ad(i,k) = dp_ad(i,k)+um_ad*(u(i,k)/dp1)
        dp1_ad = dp1_ad-um_ad*((u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/(dp1*dp1))
        u_ae(i,k+1) = u_ae(i,k+1)+um_ad*(dp(i,k+1)/dp1)
        u_ae(i,k) = u_ae(i,k)+um_ad*(dp(i,k)/dp1)
        um_ad = 0.
      endif
      ptm_ad = ptm_ad+pt_ae(i,k+1)
      pt_ae(i,k+1) = 0.
      ptm_ad = ptm_ad+pt_ae(i,k)
      pt_ae(i,k) = 0.
      pt(:,k:k+1) = dry_adj_tape_pt_1h(:,:,k)
      dp_ad(i,k+1) = dp_ad(i,k+1)+ptm_ad*(pt(i,k+1)/dp1)
      dp_ad(i,k) = dp_ad(i,k)+ptm_ad*(pt(i,k)/dp1)
      dp1_ad = dp1_ad-ptm_ad*((pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/(dp1*dp1))
      pt_ae(i,k+1) = pt_ae(i,k+1)+ptm_ad*(dp(i,k+1)/dp1)
      pt_ae(i,k) = pt_ae(i,k)+ptm_ad*(dp(i,k)/dp1)
      ptm_ad = 0.
      dp_ad(i,k+1) = dp_ad(i,k+1)+dp1_ad
      dp_ad(i,k) = dp_ad(i,k)+dp1_ad
      dp1_ad = 0.
    endif
  end do
end do
do k = 1, klow+3
  do i = 1, im
    v_ae(i,k) = v_ae(i,k)+vt_ad(i,k)
    vt_ad(i,k) = 0.
    u_ae(i,k) = u_ae(i,k)+ut_ad(i,k)
    ut_ad(i,k) = 0.
  end do
end do

end subroutine dry_adj_ad


subroutine dry_adjmd( im, km, rdt, pt, fu, fv, u, v, dp, j )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use dry_adj_ad_store, only : dry_adj_tape_dp_2h,dry_adj_tape_dry_adj,dry_adj_tape_pt_1h,dry_adj_tape_u_3h,dry_adj_tape_v_4h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: km
real :: dp(im,km)
real :: fu(im,km)
real :: fv(im,km)
integer :: j
real :: pt(im,km)
real :: rdt
real :: u(im,km)
real :: v(im,km)

!==============================================
! declare local variables
!==============================================
real :: dp1
real :: dp2
integer :: i
integer :: k
integer :: klow
logical :: mixm
real :: ptm
real :: um
real :: ut(im,km)
real :: vm
real :: vt(im,km)

!**********************************************
! executable statements of routine
!**********************************************
mixm =  .true. 
klow = max(km/16,1)
do k = 1, klow+3
  do i = 1, im
    ut(i,k) = u(i,k)
    vt(i,k) = v(i,k)
  end do
end do
do k = 1, klow
  if ( .not. allocated(dry_adj_tape_pt_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(dry_adj_tape_pt_1h)) then
      allocate( dry_adj_tape_pt_1h(1:im,1:2,dry_adj_tape_dry_adj) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( dry_adj_tape_pt_1h(1:im,1:2,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
  endif
  dry_adj_tape_pt_1h(:,:,k) = pt(:,k:k+1)
  do i = 1, im
    if (pt(i,k) .lt. pt(i,k+1)) then
      if ( .not. allocated(dry_adj_tape_dp_2h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(dry_adj_tape_dp_2h)) then
          allocate( dry_adj_tape_dp_2h(1:4,dry_adj_tape_dry_adj) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( dry_adj_tape_dp_2h(1:4,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
      endif
      dry_adj_tape_dp_2h(:,k) = dp(i,k:k+3)
      if ( .not. allocated(dry_adj_tape_u_3h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(dry_adj_tape_u_3h)) then
          allocate( dry_adj_tape_u_3h(1:4,dry_adj_tape_dry_adj) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( dry_adj_tape_u_3h(1:4,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
      endif
      dry_adj_tape_u_3h(:,k) = u(i,k:k+3)
      if ( .not. allocated(dry_adj_tape_v_4h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(dry_adj_tape_v_4h)) then
          allocate( dry_adj_tape_v_4h(1:4,dry_adj_tape_dry_adj) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( dry_adj_tape_v_4h(1:4,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
      endif
      dry_adj_tape_v_4h(:,k) = v(i,k:k+3)
      dp1 = dp(i,k)+dp(i,k+1)
      ptm = (pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/dp1
      pt(i,k) = ptm
      pt(i,k+1) = ptm
      if (mixm) then
        um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
        u(i,k) = um
        u(i,k+1) = um
        vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
        v(i,k) = vm
        v(i,k+1) = vm
      endif
      if (ptm .lt. pt(i,k+2)) then
        dp2 = dp1+dp(i,k+2)
        ptm = (ptm*dp1+pt(i,k+2)*dp(i,k+2))/dp2
        pt(i,k) = ptm
        pt(i,k+1) = ptm
        pt(i,k+2) = ptm
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
          u(i,k) = um
          u(i,k+1) = um
          u(i,k+2) = um
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
          v(i,k) = vm
          v(i,k+1) = vm
          v(i,k+2) = vm
        endif
        if (ptm .lt. pt(i,k+3)) then
          ptm = (ptm*dp2+pt(i,k+3)*dp(i,k+3))/(dp2+dp(i,k+3))
          pt(i,k) = ptm
          pt(i,k+1) = ptm
          pt(i,k+2) = ptm
          pt(i,k+3) = ptm
          if (mixm) then
            um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
            um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
            um = (um*dp2+u(i,k+3)*dp(i,k+3))/(dp2+dp(i,k+3))
            u(i,k) = um
            u(i,k+1) = um
            u(i,k+2) = um
            u(i,k+3) = um
            vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
            vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
            vm = (vm*dp2+v(i,k+3)*dp(i,k+3))/(dp2+dp(i,k+3))
            v(i,k) = vm
            v(i,k+1) = vm
            v(i,k+2) = vm
            v(i,k+3) = vm
          endif
        endif
      endif
    endif
  end do
end do
if (mixm) then
  do k = 1, klow+3
    do i = 1, im
      fu(i,k) = fu(i,k)+(u(i,k)-ut(i,k))*rdt
      fv(i,k) = fv(i,k)+(v(i,k)-vt(i,k))*rdt
    end do
  end do
endif
end subroutine dry_adjmd


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     dry_adj_ad_store
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare local variables
!==============================================
real, allocatable :: dry_adj_tape_dp_2h(:,:)
integer :: dry_adj_tape_dry_adj
real, allocatable :: dry_adj_tape_pt_1h(:,:,:)
real, allocatable :: dry_adj_tape_u_3h(:,:)
real, allocatable :: dry_adj_tape_v_4h(:,:)

end module     dry_adj_ad_store


subroutine dry_adj_ad( im, km, rdt, pt, pt_ae, fu_ad, fv_ad, u, u_ae, v, v_ae, dp, dp_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use dry_adj_ad_store, only : dry_adj_tape_dp_2h,dry_adj_tape_dry_adj,dry_adj_tape_pt_1h,dry_adj_tape_u_3h,dry_adj_tape_v_4h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: km
real :: dp(im,km)
real :: dp_ad(im,km)
real :: fu_ad(im,km)
real :: fv_ad(im,km)
real :: pt(im,km)
real :: pt_ae(im,km)
real :: rdt
real :: u(im,km)
real :: u_ae(im,km)
real :: v(im,km)
real :: v_ae(im,km)

!==============================================
! declare local variables
!==============================================
real :: dp1
real :: dp1_ad
real :: dp2
real :: dp2_ad
integer :: i
integer :: k
integer :: klow
logical :: mixm
real :: ptm
real :: ptm_ad
real :: um
real :: um_ad
real :: ut_ad(im,km)
real :: vm
real :: vm_ad
real :: vt_ad(im,km)

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
dp1_ad = 0.
dp2_ad = 0.
ptm_ad = 0.
um_ad = 0.
ut_ad(:,:) = 0.
vm_ad = 0.
vt_ad(:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
mixm =  .true. 
klow = max(km/16,1)
if (mixm) then
  do k = 1, klow+3
    do i = 1, im
      v_ae(i,k) = v_ae(i,k)+fv_ad(i,k)*rdt
      vt_ad(i,k) = vt_ad(i,k)-fv_ad(i,k)*rdt
      u_ae(i,k) = u_ae(i,k)+fu_ad(i,k)*rdt
      ut_ad(i,k) = ut_ad(i,k)-fu_ad(i,k)*rdt
    end do
  end do
endif
do k = klow, 1, -1
  pt(:,k:k+1) = dry_adj_tape_pt_1h(:,:,k)
  do i = 1, im
    dp1_ad = 0.
    dp2_ad = 0.
    ptm_ad = 0.
    um_ad = 0.
    vm_ad = 0.
    if (pt(i,k) .lt. pt(i,k+1)) then
      dp(i,k:k+3) = dry_adj_tape_dp_2h(:,k)
      u(i,k:k+3) = dry_adj_tape_u_3h(:,k)
      v(i,k:k+3) = dry_adj_tape_v_4h(:,k)
      dp1 = dp(i,k)+dp(i,k+1)
      ptm = (pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/dp1
      pt(i,k) = ptm
      pt(i,k+1) = ptm
      if (mixm) then
        um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
        u(i,k) = um
        u(i,k+1) = um
        vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
        v(i,k) = vm
        v(i,k+1) = vm
      endif
      if (ptm .lt. pt(i,k+2)) then
        dp2 = dp1+dp(i,k+2)
        ptm = (ptm*dp1+pt(i,k+2)*dp(i,k+2))/dp2
        pt(i,k) = ptm
        pt(i,k+1) = ptm
        pt(i,k+2) = ptm
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
          u(i,k) = um
          u(i,k+1) = um
          u(i,k+2) = um
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
          v(i,k) = vm
          v(i,k+1) = vm
          v(i,k+2) = vm
        endif
        if (ptm .lt. pt(i,k+3)) then
          if (mixm) then
            um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
            um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
            vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
            vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
            vm_ad = vm_ad+v_ae(i,k+3)
            v_ae(i,k+3) = 0.
            vm_ad = vm_ad+v_ae(i,k+2)
            v_ae(i,k+2) = 0.
            vm_ad = vm_ad+v_ae(i,k+1)
            v_ae(i,k+1) = 0.
            vm_ad = vm_ad+v_ae(i,k)
            v_ae(i,k) = 0.
            dp_ad(i,k+3) = dp_ad(i,k+3)+vm_ad*(v(i,k+3)/(dp2+dp(i,k+3))-(vm*dp2+v(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3)&
&)))
            dp2_ad = dp2_ad+vm_ad*(vm/(dp2+dp(i,k+3))-(vm*dp2+v(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3))))
            v_ae(i,k+3) = v_ae(i,k+3)+vm_ad*(dp(i,k+3)/(dp2+dp(i,k+3)))
            vm_ad = vm_ad*(dp2/(dp2+dp(i,k+3)))
            vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
            dp_ad(i,k+2) = dp_ad(i,k+2)+vm_ad*(v(i,k+2)/dp2)
            dp1_ad = dp1_ad+vm_ad*(vm/dp2)
            dp2_ad = dp2_ad-vm_ad*((vm*dp1+v(i,k+2)*dp(i,k+2))/(dp2*dp2))
            v_ae(i,k+2) = v_ae(i,k+2)+vm_ad*(dp(i,k+2)/dp2)
            vm_ad = vm_ad*(dp1/dp2)
            dp_ad(i,k+1) = dp_ad(i,k+1)+vm_ad*(v(i,k+1)/dp1)
            dp_ad(i,k) = dp_ad(i,k)+vm_ad*(v(i,k)/dp1)
            dp1_ad = dp1_ad-vm_ad*((v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/(dp1*dp1))
            v_ae(i,k+1) = v_ae(i,k+1)+vm_ad*(dp(i,k+1)/dp1)
            v_ae(i,k) = v_ae(i,k)+vm_ad*(dp(i,k)/dp1)
            vm_ad = 0.
            um_ad = um_ad+u_ae(i,k+3)
            u_ae(i,k+3) = 0.
            um_ad = um_ad+u_ae(i,k+2)
            u_ae(i,k+2) = 0.
            um_ad = um_ad+u_ae(i,k+1)
            u_ae(i,k+1) = 0.
            um_ad = um_ad+u_ae(i,k)
            u_ae(i,k) = 0.
            dp_ad(i,k+3) = dp_ad(i,k+3)+um_ad*(u(i,k+3)/(dp2+dp(i,k+3))-(um*dp2+u(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3)&
&)))
            dp2_ad = dp2_ad+um_ad*(um/(dp2+dp(i,k+3))-(um*dp2+u(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3))))
            u_ae(i,k+3) = u_ae(i,k+3)+um_ad*(dp(i,k+3)/(dp2+dp(i,k+3)))
            um_ad = um_ad*(dp2/(dp2+dp(i,k+3)))
            um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
            dp_ad(i,k+2) = dp_ad(i,k+2)+um_ad*(u(i,k+2)/dp2)
            dp1_ad = dp1_ad+um_ad*(um/dp2)
            dp2_ad = dp2_ad-um_ad*((um*dp1+u(i,k+2)*dp(i,k+2))/(dp2*dp2))
            u_ae(i,k+2) = u_ae(i,k+2)+um_ad*(dp(i,k+2)/dp2)
            um_ad = um_ad*(dp1/dp2)
            dp_ad(i,k+1) = dp_ad(i,k+1)+um_ad*(u(i,k+1)/dp1)
            dp_ad(i,k) = dp_ad(i,k)+um_ad*(u(i,k)/dp1)
            dp1_ad = dp1_ad-um_ad*((u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/(dp1*dp1))
            u_ae(i,k+1) = u_ae(i,k+1)+um_ad*(dp(i,k+1)/dp1)
            u_ae(i,k) = u_ae(i,k)+um_ad*(dp(i,k)/dp1)
            um_ad = 0.
          endif
          ptm_ad = ptm_ad+pt_ae(i,k+3)
          pt_ae(i,k+3) = 0.
          ptm_ad = ptm_ad+pt_ae(i,k+2)
          pt_ae(i,k+2) = 0.
          ptm_ad = ptm_ad+pt_ae(i,k+1)
          pt_ae(i,k+1) = 0.
          ptm_ad = ptm_ad+pt_ae(i,k)
          pt_ae(i,k) = 0.
          dp_ad(i,k+3) = dp_ad(i,k+3)+ptm_ad*(pt(i,k+3)/(dp2+dp(i,k+3))-(ptm*dp2+pt(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+&
&3))))
          dp2_ad = dp2_ad+ptm_ad*(ptm/(dp2+dp(i,k+3))-(ptm*dp2+pt(i,k+3)*dp(i,k+3))/((dp2+dp(i,k+3))*(dp2+dp(i,k+3))))
          pt_ae(i,k+3) = pt_ae(i,k+3)+ptm_ad*(dp(i,k+3)/(dp2+dp(i,k+3)))
          ptm_ad = ptm_ad*(dp2/(dp2+dp(i,k+3)))
        endif
        u(i,k:k+3) = dry_adj_tape_u_3h(:,k)
        v(i,k:k+3) = dry_adj_tape_v_4h(:,k)
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          u(i,k) = um
          u(i,k+1) = um
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          v(i,k) = vm
          v(i,k+1) = vm
        endif
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          vm_ad = vm_ad+v_ae(i,k+2)
          v_ae(i,k+2) = 0.
          vm_ad = vm_ad+v_ae(i,k+1)
          v_ae(i,k+1) = 0.
          vm_ad = vm_ad+v_ae(i,k)
          v_ae(i,k) = 0.
          dp_ad(i,k+2) = dp_ad(i,k+2)+vm_ad*(v(i,k+2)/dp2)
          dp1_ad = dp1_ad+vm_ad*(vm/dp2)
          dp2_ad = dp2_ad-vm_ad*((vm*dp1+v(i,k+2)*dp(i,k+2))/(dp2*dp2))
          v_ae(i,k+2) = v_ae(i,k+2)+vm_ad*(dp(i,k+2)/dp2)
          vm_ad = vm_ad*(dp1/dp2)
          dp_ad(i,k+1) = dp_ad(i,k+1)+vm_ad*(v(i,k+1)/dp1)
          dp_ad(i,k) = dp_ad(i,k)+vm_ad*(v(i,k)/dp1)
          dp1_ad = dp1_ad-vm_ad*((v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/(dp1*dp1))
          v_ae(i,k+1) = v_ae(i,k+1)+vm_ad*(dp(i,k+1)/dp1)
          v_ae(i,k) = v_ae(i,k)+vm_ad*(dp(i,k)/dp1)
          vm_ad = 0.
          um_ad = um_ad+u_ae(i,k+2)
          u_ae(i,k+2) = 0.
          um_ad = um_ad+u_ae(i,k+1)
          u_ae(i,k+1) = 0.
          um_ad = um_ad+u_ae(i,k)
          u_ae(i,k) = 0.
          dp_ad(i,k+2) = dp_ad(i,k+2)+um_ad*(u(i,k+2)/dp2)
          dp1_ad = dp1_ad+um_ad*(um/dp2)
          dp2_ad = dp2_ad-um_ad*((um*dp1+u(i,k+2)*dp(i,k+2))/(dp2*dp2))
          u_ae(i,k+2) = u_ae(i,k+2)+um_ad*(dp(i,k+2)/dp2)
          um_ad = um_ad*(dp1/dp2)
          dp_ad(i,k+1) = dp_ad(i,k+1)+um_ad*(u(i,k+1)/dp1)
          dp_ad(i,k) = dp_ad(i,k)+um_ad*(u(i,k)/dp1)
          dp1_ad = dp1_ad-um_ad*((u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/(dp1*dp1))
          u_ae(i,k+1) = u_ae(i,k+1)+um_ad*(dp(i,k+1)/dp1)
          u_ae(i,k) = u_ae(i,k)+um_ad*(dp(i,k)/dp1)
          um_ad = 0.
        endif
        ptm_ad = ptm_ad+pt_ae(i,k+2)
        pt_ae(i,k+2) = 0.
        ptm_ad = ptm_ad+pt_ae(i,k+1)
        pt_ae(i,k+1) = 0.
        ptm_ad = ptm_ad+pt_ae(i,k)
        pt_ae(i,k) = 0.
        pt(:,k:k+1) = dry_adj_tape_pt_1h(:,:,k)
        ptm = (pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/dp1
        pt(i,k) = ptm
        pt(i,k+1) = ptm
        dp_ad(i,k+2) = dp_ad(i,k+2)+ptm_ad*(pt(i,k+2)/dp2)
        dp1_ad = dp1_ad+ptm_ad*(ptm/dp2)
        dp2_ad = dp2_ad-ptm_ad*((ptm*dp1+pt(i,k+2)*dp(i,k+2))/(dp2*dp2))
        pt_ae(i,k+2) = pt_ae(i,k+2)+ptm_ad*(dp(i,k+2)/dp2)
        ptm_ad = ptm_ad*(dp1/dp2)
        dp_ad(i,k+2) = dp_ad(i,k+2)+dp2_ad
        dp1_ad = dp1_ad+dp2_ad
        dp2_ad = 0.
      endif
      u(i,k:k+3) = dry_adj_tape_u_3h(:,k)
      v(i,k:k+3) = dry_adj_tape_v_4h(:,k)
      if (mixm) then
        vm_ad = vm_ad+v_ae(i,k+1)
        v_ae(i,k+1) = 0.
        vm_ad = vm_ad+v_ae(i,k)
        v_ae(i,k) = 0.
        dp_ad(i,k+1) = dp_ad(i,k+1)+vm_ad*(v(i,k+1)/dp1)
        dp_ad(i,k) = dp_ad(i,k)+vm_ad*(v(i,k)/dp1)
        dp1_ad = dp1_ad-vm_ad*((v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/(dp1*dp1))
        v_ae(i,k+1) = v_ae(i,k+1)+vm_ad*(dp(i,k+1)/dp1)
        v_ae(i,k) = v_ae(i,k)+vm_ad*(dp(i,k)/dp1)
        vm_ad = 0.
        um_ad = um_ad+u_ae(i,k+1)
        u_ae(i,k+1) = 0.
        um_ad = um_ad+u_ae(i,k)
        u_ae(i,k) = 0.
        dp_ad(i,k+1) = dp_ad(i,k+1)+um_ad*(u(i,k+1)/dp1)
        dp_ad(i,k) = dp_ad(i,k)+um_ad*(u(i,k)/dp1)
        dp1_ad = dp1_ad-um_ad*((u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/(dp1*dp1))
        u_ae(i,k+1) = u_ae(i,k+1)+um_ad*(dp(i,k+1)/dp1)
        u_ae(i,k) = u_ae(i,k)+um_ad*(dp(i,k)/dp1)
        um_ad = 0.
      endif
      ptm_ad = ptm_ad+pt_ae(i,k+1)
      pt_ae(i,k+1) = 0.
      ptm_ad = ptm_ad+pt_ae(i,k)
      pt_ae(i,k) = 0.
      pt(:,k:k+1) = dry_adj_tape_pt_1h(:,:,k)
      dp_ad(i,k+1) = dp_ad(i,k+1)+ptm_ad*(pt(i,k+1)/dp1)
      dp_ad(i,k) = dp_ad(i,k)+ptm_ad*(pt(i,k)/dp1)
      dp1_ad = dp1_ad-ptm_ad*((pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/(dp1*dp1))
      pt_ae(i,k+1) = pt_ae(i,k+1)+ptm_ad*(dp(i,k+1)/dp1)
      pt_ae(i,k) = pt_ae(i,k)+ptm_ad*(dp(i,k)/dp1)
      ptm_ad = 0.
      dp_ad(i,k+1) = dp_ad(i,k+1)+dp1_ad
      dp_ad(i,k) = dp_ad(i,k)+dp1_ad
      dp1_ad = 0.
    endif
  end do
end do
do k = 1, klow+3
  do i = 1, im
    v_ae(i,k) = v_ae(i,k)+vt_ad(i,k)
    vt_ad(i,k) = 0.
    u_ae(i,k) = u_ae(i,k)+ut_ad(i,k)
    ut_ad(i,k) = 0.
  end do
end do

end subroutine dry_adj_ad


subroutine dry_adjmd( im, km, rdt, pt, fu, fv, u, v, dp, j )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use dry_adj_ad_store, only : dry_adj_tape_dp_2h,dry_adj_tape_dry_adj,dry_adj_tape_pt_1h,dry_adj_tape_u_3h,dry_adj_tape_v_4h

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: im
integer :: km
real :: dp(im,km)
real :: fu(im,km)
real :: fv(im,km)
integer :: j
real :: pt(im,km)
real :: rdt
real :: u(im,km)
real :: v(im,km)

!==============================================
! declare local variables
!==============================================
real :: dp1
real :: dp2
integer :: i
integer :: k
integer :: klow
logical :: mixm
real :: ptm
real :: um
real :: ut(im,km)
real :: vm
real :: vt(im,km)

!**********************************************
! executable statements of routine
!**********************************************
mixm =  .true. 
klow = max(km/16,1)
do k = 1, klow+3
  do i = 1, im
    ut(i,k) = u(i,k)
    vt(i,k) = v(i,k)
  end do
end do
do k = 1, klow
  if ( .not. allocated(dry_adj_tape_pt_1h)) then
#ifdef USE_OPENMP
    !$omp critical  (store)
    if ( .not. allocated(dry_adj_tape_pt_1h)) then
      allocate( dry_adj_tape_pt_1h(1:im,1:2,dry_adj_tape_dry_adj) )
    endif
    !$omp end critical (store)
#else /* USE_OPENMP */
    allocate( dry_adj_tape_pt_1h(1:im,1:2,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
  endif
  dry_adj_tape_pt_1h(:,:,k) = pt(:,k:k+1)
  do i = 1, im
    if (pt(i,k) .lt. pt(i,k+1)) then
      if ( .not. allocated(dry_adj_tape_dp_2h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(dry_adj_tape_dp_2h)) then
          allocate( dry_adj_tape_dp_2h(1:4,dry_adj_tape_dry_adj) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( dry_adj_tape_dp_2h(1:4,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
      endif
      dry_adj_tape_dp_2h(:,k) = dp(i,k:k+3)
      if ( .not. allocated(dry_adj_tape_u_3h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(dry_adj_tape_u_3h)) then
          allocate( dry_adj_tape_u_3h(1:4,dry_adj_tape_dry_adj) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( dry_adj_tape_u_3h(1:4,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
      endif
      dry_adj_tape_u_3h(:,k) = u(i,k:k+3)
      if ( .not. allocated(dry_adj_tape_v_4h)) then
#ifdef USE_OPENMP
        !$omp critical  (store)
        if ( .not. allocated(dry_adj_tape_v_4h)) then
          allocate( dry_adj_tape_v_4h(1:4,dry_adj_tape_dry_adj) )
        endif
        !$omp end critical (store)
#else /* USE_OPENMP */
        allocate( dry_adj_tape_v_4h(1:4,dry_adj_tape_dry_adj) )
#endif /* USE_OPENMP */
      endif
      dry_adj_tape_v_4h(:,k) = v(i,k:k+3)
      dp1 = dp(i,k)+dp(i,k+1)
      ptm = (pt(i,k)*dp(i,k)+pt(i,k+1)*dp(i,k+1))/dp1
      pt(i,k) = ptm
      pt(i,k+1) = ptm
      if (mixm) then
        um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
        u(i,k) = um
        u(i,k+1) = um
        vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
        v(i,k) = vm
        v(i,k+1) = vm
      endif
      if (ptm .lt. pt(i,k+2)) then
        dp2 = dp1+dp(i,k+2)
        ptm = (ptm*dp1+pt(i,k+2)*dp(i,k+2))/dp2
        pt(i,k) = ptm
        pt(i,k+1) = ptm
        pt(i,k+2) = ptm
        if (mixm) then
          um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
          um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
          u(i,k) = um
          u(i,k+1) = um
          u(i,k+2) = um
          vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
          vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
          v(i,k) = vm
          v(i,k+1) = vm
          v(i,k+2) = vm
        endif
        if (ptm .lt. pt(i,k+3)) then
          ptm = (ptm*dp2+pt(i,k+3)*dp(i,k+3))/(dp2+dp(i,k+3))
          pt(i,k) = ptm
          pt(i,k+1) = ptm
          pt(i,k+2) = ptm
          pt(i,k+3) = ptm
          if (mixm) then
            um = (u(i,k)*dp(i,k)+u(i,k+1)*dp(i,k+1))/dp1
            um = (um*dp1+u(i,k+2)*dp(i,k+2))/dp2
            um = (um*dp2+u(i,k+3)*dp(i,k+3))/(dp2+dp(i,k+3))
            u(i,k) = um
            u(i,k+1) = um
            u(i,k+2) = um
            u(i,k+3) = um
            vm = (v(i,k)*dp(i,k)+v(i,k+1)*dp(i,k+1))/dp1
            vm = (vm*dp1+v(i,k+2)*dp(i,k+2))/dp2
            vm = (vm*dp2+v(i,k+3)*dp(i,k+3))/(dp2+dp(i,k+3))
            v(i,k) = vm
            v(i,k+1) = vm
            v(i,k+2) = vm
            v(i,k+3) = vm
          endif
        endif
      endif
    endif
  end do
end do
if (mixm) then
  do k = 1, klow+3
    do i = 1, im
      fu(i,k) = fu(i,k)+(u(i,k)-ut(i,k))*rdt
      fv(i,k) = fv(i,k)+(v(i,k)-vt(i,k))*rdt
    end do
  end do
endif
end subroutine dry_adjmd


#endif /* SPMD */
