#ifdef    SPMD
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
!  14May2007  Todling   Introduced dyn_prog; global change.
!
module     control_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use control, only:ibeg_tr,iend_tr,ibeg_delp,ibeg_q,ibeg_pt,ibeg_u,ibeg_v
use precision

!==============================================
! all entries are defined explicitly
!==============================================
implicit none
PRIVATE
PUBLIC cont2mod_ad

real(r8), pointer ::    u_ad(:,:,:)   ! zonal wind on D-grid
real(r8), pointer ::    v_ad(:,:,:)   ! meridional wind
real(r8), pointer ::   pt_ad(:,:,:)   ! virtual potential temperature
real(r8), pointer :: delp_ad(:,:,:)   ! pressure thickness (pascal)
real(r8), pointer ::    q_ad(:,:,:,:) ! specific humidity & tracer mixing ratios

contains
subroutine cont2mod_ad( n, x_ad, prog_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use prognostics
use stepon, only : ng_d,ng_s
use mod_comm, only : gid,mp_scatter4d, mp_scatter4d_ad

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: n, m_nc
real(kind=r8) :: x_ad(n)
type(dyn_prog) :: prog_ad

!==============================================
! declare local variables
!==============================================
real(kind=r8) :: qhelp_ad(imr,jfirst:jlast,nl)

! Set pointers
! ------------
delp_ad => prog_ad%delp
q_ad    => prog_ad%q
pt_ad   => prog_ad%pt
v_ad    => prog_ad%v
u_ad    => prog_ad%u

!----------------------------------------------
! RESET LOCAL ADJOINT VARIABLES
!----------------------------------------------
qhelp_ad(:,:,:) = 0.

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
if (nc .gt. 1) then
    do m_nc=nc,2,-1
       qhelp_ad(:,jfirst:jlast,:) = qhelp_ad(:,jfirst:jlast,:)+q_ad(:,jfirst:jlast,:,m_nc)
       q_ad(:,jfirst:jlast,:,m_nc) = 0.
       call mp_scatter4d_ad( x_ad(ibeg_tr(m_nc-1)),qhelp_ad,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
    enddo
endif

qhelp_ad(:,jfirst:jlast,:) = qhelp_ad(:,jfirst:jlast,:)+delp_ad(:,jfirst:jlast,:)
delp_ad(:,jfirst:jlast,:) = 0.
call mp_scatter4d_ad( x_ad(ibeg_delp),qhelp_ad,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )

qhelp_ad(:,jfirst:jlast,:) = qhelp_ad(:,jfirst:jlast,:)+q_ad(:,jfirst:jlast,:,1)
q_ad(:,jfirst:jlast,:,1) = 0.
call mp_scatter4d_ad( x_ad(ibeg_q),qhelp_ad,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )

qhelp_ad(:,jfirst:jlast,:) = qhelp_ad(:,jfirst:jlast,:)+pt_ad(:,jfirst:jlast,:)
pt_ad(:,jfirst:jlast,:) = 0.
call mp_scatter4d_ad( x_ad(ibeg_pt),qhelp_ad,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
qhelp_ad(:,jfirst:jlast,:) = qhelp_ad(:,jfirst:jlast,:)+v_ad(:,jfirst:jlast,:)
v_ad(:,jfirst:jlast,:) = 0.
call mp_scatter4d_ad( x_ad(ibeg_v),qhelp_ad,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )
qhelp_ad(:,jfirst:jlast,:) = qhelp_ad(:,jfirst:jlast,:)+u_ad(:,jfirst:jlast,:)
u_ad(:,jfirst:jlast,:) = 0.
call mp_scatter4d_ad( x_ad(ibeg_u),qhelp_ad,imr,jnp,nl,1,jfirst,jlast,kfirst,klast,0,0,0 )

end subroutine cont2mod_ad


end module     control_ad


#else  /* SPMD */
!                           DISCLAIMER
!
!   This file was generated by TAF version 1.6.1
!
!   FASTOPT DISCLAIMS  ALL  WARRANTIES,  EXPRESS  OR  IMPLIED,
!   INCLUDING (WITHOUT LIMITATION) ALL IMPLIED  WARRANTIES  OF
!   MERCHANTABILITY  OR FITNESS FOR A PARTICULAR PURPOSE, WITH
!   RESPECT TO THE SOFTWARE AND USER PROGRAMS.   IN  NO  EVENT
!   SHALL  FASTOPT BE LIABLE FOR ANY LOST OR ANTICIPATED PROF-
!   ITS, OR ANY INDIRECT, INCIDENTAL, EXEMPLARY,  SPECIAL,  OR
!   CONSEQUENTIAL  DAMAGES, WHETHER OR NOT FASTOPT WAS ADVISED
!   OF THE POSSIBILITY OF SUCH DAMAGES.
!
!                           Haftungsbeschraenkung
!   FastOpt gibt ausdruecklich keine Gewaehr, explizit oder indirekt,
!   bezueglich der Brauchbarkeit  der Software  fuer einen bestimmten
!   Zweck.   Unter  keinen  Umstaenden   ist  FastOpt   haftbar  fuer
!   irgendeinen Verlust oder nicht eintretenden erwarteten Gewinn und
!   allen indirekten,  zufaelligen,  exemplarischen  oder  speziellen
!   Schaeden  oder  Folgeschaeden  unabhaengig  von einer eventuellen
!   Mitteilung darueber an FastOpt.
!
module     control_ad
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use control

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

contains
subroutine cont2mod_ad( n, x_ad )
!******************************************************************
!******************************************************************
!** This routine was generated by Automatic differentiation.     **
!** FastOpt: Transformation of Algorithm in Fortran, TAF 1.6.1   **
!******************************************************************
!******************************************************************
!==============================================
! referencing used modules
!==============================================
use precision
use prognostics
use prognostics_ad
use stepon, only : ng_d,ng_s

!==============================================
! all entries are defined explicitly
!==============================================
implicit none

!==============================================
! declare arguments
!==============================================
integer :: n
real(kind=r8) :: x_ad(n)

!----------------------------------------------
! ROUTINE BODY
!----------------------------------------------
x_ad(ibeg_delp:iend_delp) = x_ad(ibeg_delp:iend_delp)+reshape(delp_ad(:,jfirst:jlast,:),(/1+iend_delp-ibeg_delp/))
delp_ad(:,jfirst:jlast,:) = 0.
x_ad(ibeg_q:iend_q) = x_ad(ibeg_q:iend_q)+reshape(q_ad(:,jfirst:jlast,:,1),(/1+iend_q-ibeg_q/))
q_ad(:,jfirst:jlast,:,1) = 0.
x_ad(ibeg_pt:iend_pt) = x_ad(ibeg_pt:iend_pt)+reshape(pt_ad(:,jfirst:jlast,:),(/1+iend_pt-ibeg_pt/))
pt_ad(:,jfirst:jlast,:) = 0.
x_ad(ibeg_v:iend_v) = x_ad(ibeg_v:iend_v)+reshape(v_ad(:,jfirst:jlast,:),(/1+iend_v-ibeg_v/))
v_ad(:,jfirst:jlast,:) = 0.
x_ad(ibeg_u:iend_u) = x_ad(ibeg_u:iend_u)+reshape(u_ad(:,jfirst:jlast,:),(/1+iend_u-ibeg_u/))
u_ad(:,jfirst:jlast,:) = 0.

end subroutine cont2mod_ad


end module     control_ad


#endif /* SPMD */
