module infnan
!-------------------------------------------------------------------------
!
! Purpose:
!
!	Set parameters for the floating point flags "inf" Infinity
!	and "nan" not-a-number. As well as "bigint" the point
!	at which integers start to overflow. These values are used
!	to initialize arrays with as a way to detect if arrays
!	are being used before being set.
!
! Author: CCM Core group
!
! $Id$
!
!-------------------------------------------------------------------------
  use precision

#if ( defined FORTRAN90_OCTAL )

#ifdef CRAY
  real(r8), parameter :: inf = O'0605054000037000000000'
  real(r8), parameter :: nan = O'0605054000037000000000'
  integer,  parameter :: bigint = 100000000
#else
  real(r8), parameter :: inf = O'0777600000000000000000'
  real(r8), parameter :: nan = O'0777700000000000000000'
  integer,  parameter :: bigint = O'17777777777'           ! largest possible 32-bit integer
#endif

#else   /* defined FORTRAN90_OCTAL */
  real(r8), parameter :: inf = 0.    ! FastOpt octal constant are not Fortran standard
  real(r8), parameter :: nan = 0.    ! FastOpt octal constant are not Fortran standard
#endif  /* defined FORTRAN90_OCTAL */

end module infnan

 
