!==========================================================================
elemental function gsw_t_deriv_chem_potential_water_t_exact (sa, t, p)
!==========================================================================
!
!  Calculates the temperature derivative of the chemical potential of water
!  in seawater so that it is valid at exactly SA = 0.
!
!  SA  =  Absolute Salinity                                        [ g/kg ]
!  t   =  in-situ temperature (ITS-90)                            [ deg C ]
!  p   =  sea pressure                                             [ dbar ]
!         ( i.e. absolute pressure - 10.1325 dbar ) 
!
!  chem_potential_water_dt  =  temperature derivative of the chemical 
!                           potential of water in seawater  [ J g^-1 K^-1 ]
!--------------------------------------------------------------------------

use gsw_mod_teos10_constants, only : gsw_sfac, rec_db2pa

use gsw_mod_kinds

implicit none

real (r8), intent(in) :: sa, t, p

real (r8) :: gsw_t_deriv_chem_potential_water_t_exact

real (r8) :: g03_t, g08_sa_t, x, x2, y, z, g08_t

real (r8), parameter :: kg2g = 1e-3_r8

! Note. The kg2g, a factor of 1e-3, is needed to convert the output of this
! function into units of J/g. See section (2.9) of the TEOS-10 Manual.

x2 = gsw_sfac*sa
x = sqrt(x2)
y = t*0.025_r8
z = p*rec_db2pa ! the input pressure (p) is sea pressure in units of dbar.

g03_t = 5.90578347909402_r8 + z*(-270.983805184062_r8 + &
        z*(776.153611613101_r8 + z*(-196.51255088122_r8 + (28.9796526294175_r8 - &
	2.13290083518327_r8*z)*z))) + &
        y*(-24715.571866078_r8 + z*(2910.0729080936_r8 + &
        z*(-1513.116771538718_r8 + z*(546.959324647056_r8 + &
	z*(-111.1208127634436_r8 + 8.68841343834394_r8*z)))) + &
        y*(2210.2236124548363_r8 + z*(-2017.52334943521_r8 + &
        z*(1498.081172457456_r8 + z*(-718.6359919632359_r8 + &
	(146.4037555781616_r8 - 4.9892131862671505_r8*z)*z))) + &
        y*(-592.743745734632_r8 + z*(1591.873781627888_r8 + &
        z*(-1207.261522487504_r8 + (608.785486935364_r8 - &
	105.4993508931208_r8*z)*z)) + &
        y*(290.12956292128547_r8 + z*(-973.091553087975_r8 + &
        z*(602.603274510125_r8 + z*(-276.361526170076_r8 + &
	32.40953340386105_r8*z))) + &
        y*(-113.90630790850321_r8 + y*(21.35571525415769_r8 - &
	67.41756835751434_r8*z) + &
        z*(381.06836198507096_r8 + z*(-133.7383902842754_r8 + &
	49.023632509086724_r8*z)))))))
    
g08_t = x2*(168.072408311545_r8 + &
        x*(-493.407510141682_r8 + x*(543.835333000098_r8 + &
	x*(-196.028306689776_r8 + 36.7571622995805_r8*x) + &
        y*(-137.1145018408982_r8 + y*(148.10030845687618_r8 + &
	y*(-68.5590309679152_r8 + 12.4848504784754_r8*y))) - &
        22.6683558512829_r8*z) + z*(-175.292041186547_r8 + &
	(83.1923927801819_r8 - 29.483064349429_r8*z)*z) + &
        y*(-86.1329351956084_r8 + z*(766.116132004952_r8 + &
	z*(-108.3834525034224_r8 + 51.2796974779828_r8*z)) + &
        y*(-30.0682112585625_r8 - 1380.9597954037708_r8*z + &
	y*(3.50240264723578_r8 + 938.26075044542_r8*z)))))
    
g08_sa_t = 1187.3715515697959_r8 + &
        x*(-1480.222530425046_r8 + x*(2175.341332000392_r8 + &
	x*(-980.14153344888_r8 + 220.542973797483_r8*x) + &
        y*(-548.4580073635929_r8 + y*(592.4012338275047_r8 + &
	y*(-274.2361238716608_r8 + 49.9394019139016_r8*y))) - &
        90.6734234051316_r8*z) + z*(-525.876123559641_r8 + &
	(249.57717834054571_r8 - 88.449193048287_r8*z)*z) + &
        y*(-258.3988055868252_r8 + z*(2298.348396014856_r8 + &
	z*(-325.1503575102672_r8 + 153.8390924339484_r8*z)) + &
        y*(-90.2046337756875_r8 - 4142.8793862113125_r8*z + &
	y*(10.50720794170734_r8 + 2814.78225133626_r8*z))))
    
gsw_t_deriv_chem_potential_water_t_exact = kg2g*((g03_t + g08_t)*0.025_r8 - &
                                           0.5_r8*gsw_sfac*0.025_r8*sa*g08_sa_t)
return
end function

!--------------------------------------------------------------------------
