!==========================================================================
elemental function gsw_gibbs (ns, nt, np, sa, t, p)
!==========================================================================
!
! seawater specific Gibbs free energy and derivatives up to order 2
!
! ns     : order of s derivative
! nt     : order of t derivative
! np     : order of p derivative
! sa     : Absolute Salinity                               [g/kg]
! t      : temperature                                     [deg C]
! p      : sea pressure                                    [dbar]
! 
! gsw_gibbs  : specific Gibbs energy or its derivative
!--------------------------------------------------------------------------

use gsw_mod_teos10_constants, only : gsw_sfac

use gsw_mod_kinds

implicit none

integer, intent(in) :: ns, nt, np
real (r8), intent(in) :: sa, t, p

real (r8) :: gsw_gibbs

real (r8) :: x2, x, y, z, g03, g08

x2 = gsw_sfac*sa
x = sqrt(x2)
y = t*0.025_r8
z = p*1e-4_r8

if(ns.eq.0 .and. nt.eq.0 .and. np.eq.0) then
          
  g03 = 101.342743139674_r8 + z*(100015.695367145_r8 + &
      z*(-2544.5765420363_r8 + z*(284.517778446287_r8 + &
      z*(-33.3146754253611_r8 + (4.20263108803084_r8 - 0.546428511471039_r8*z)*z)))) + &
      y*(5.90578347909402_r8 + z*(-270.983805184062_r8 + &
      z*(776.153611613101_r8 + z*(-196.51255088122_r8 + (28.9796526294175_r8 - 2.13290083518327_r8*z)*z))) + &
      y*(-12357.785933039_r8 + z*(1455.0364540468_r8 + &
      z*(-756.558385769359_r8 + z*(273.479662323528_r8 + z*(-55.5604063817218_r8 + 4.34420671917197_r8*z)))) + &
      y*(736.741204151612_r8 + z*(-672.50778314507_r8 + &
      z*(499.360390819152_r8 + z*(-239.545330654412_r8 + (48.8012518593872_r8 - 1.66307106208905_r8*z)*z))) + &
      y*(-148.185936433658_r8 + z*(397.968445406972_r8 + &
      z*(-301.815380621876_r8 + (152.196371733841_r8 - 26.3748377232802_r8*z)*z)) + &
      y*(58.0259125842571_r8 + z*(-194.618310617595_r8 + &
      z*(120.520654902025_r8 + z*(-55.2723052340152_r8 + 6.48190668077221_r8*z))) + &
      y*(-18.9843846514172_r8 + y*(3.05081646487967_r8 - 9.63108119393062_r8*z) + &
      z*(63.5113936641785_r8 + z*(-22.2897317140459_r8 + 8.17060541818112_r8*z))))))))
          
  g08 = x2*(1416.27648484197_r8 + z*(-3310.49154044839_r8 + &
        z*(384.794152978599_r8 + z*(-96.5324320107458_r8 + (15.8408172766824_r8 - 2.62480156590992_r8*z)*z))) + &
        x*(-2432.14662381794_r8 + x*(2025.80115603697_r8 + &
        y*(543.835333000098_r8 + y*(-68.5572509204491_r8 + &
        y*(49.3667694856254_r8 + y*(-17.1397577419788_r8 + 2.49697009569508_r8*y))) - 22.6683558512829_r8*z) + &
        x*(-1091.66841042967_r8 - 196.028306689776_r8*y + &
        x*(374.60123787784_r8 - 48.5891069025409_r8*x + 36.7571622995805_r8*y) + 36.0284195611086_r8*z) + &
        z*(-54.7919133532887_r8 + (-4.08193978912261_r8 - 30.1755111971161_r8*z)*z)) + &
        z*(199.459603073901_r8 + z*(-52.2940909281335_r8 + (68.0444942726459_r8 - 3.41251932441282_r8*z)*z)) + &
        y*(-493.407510141682_r8 + z*(-175.292041186547_r8 + (83.1923927801819_r8 - 29.483064349429_r8*z)*z) + &
        y*(-43.0664675978042_r8 + z*(383.058066002476_r8 + z*(-54.1917262517112_r8 + 25.6398487389914_r8*z)) + &
        y*(-10.0227370861875_r8 - 460.319931801257_r8*z + y*(0.875600661808945_r8 + 234.565187611355_r8*z))))) + &
        y*(168.072408311545_r8 + z*(729.116529735046_r8 + &
        z*(-343.956902961561_r8 + z*(124.687671116248_r8 + z*(-31.656964386073_r8 + 7.04658803315449_r8*z)))) + &
        y*(880.031352997204_r8 + y*(-225.267649263401_r8 + &
        y*(91.4260447751259_r8 + y*(-21.6603240875311_r8 + 2.13016970847183_r8*y) + &
        z*(-297.728741987187_r8 + (74.726141138756_r8 - 36.4872919001588_r8*z)*z)) + &
        z*(694.244814133268_r8 + z*(-204.889641964903_r8 + (113.561697840594_r8 - 11.1282734326413_r8*z)*z))) + &
        z*(-860.764303783977_r8 + z*(337.409530269367_r8 + &
        z*(-178.314556207638_r8 + (44.2040358308_r8 - 7.92001547211682_r8*z)*z))))))
        
  if(sa.gt.0.0_r8) &
        g08 = g08 + x2*(5812.81456626732_r8 + 851.226734946706_r8*y)*log(x)

  gsw_gibbs = g03 + g08
  
elseif(ns.eq.1 .and. nt.eq.0 .and. np.eq.0) then
        
  g08 = 8645.36753595126_r8 + z*(-6620.98308089678_r8 + &
       z*(769.588305957198_r8 + z*(-193.0648640214916_r8 + (31.6816345533648_r8 - 5.24960313181984_r8*z)*z))) + &
       x*(-7296.43987145382_r8 + x*(8103.20462414788_r8 + &
       y*(2175.341332000392_r8 + y*(-274.2290036817964_r8 + &
       y*(197.4670779425016_r8 + y*(-68.5590309679152_r8 + 9.98788038278032_r8*y))) - 90.6734234051316_r8*z) + &
       x*(-5458.34205214835_r8 - 980.14153344888_r8*y + &
       x*(2247.60742726704_r8 - 340.1237483177863_r8*x + 220.542973797483_r8*y) + 180.142097805543_r8*z) + &
       z*(-219.1676534131548_r8 + (-16.32775915649044_r8 - 120.7020447884644_r8*z)*z)) + &
       z*(598.378809221703_r8 + z*(-156.8822727844005_r8 + (204.1334828179377_r8 - 10.23755797323846_r8*z)*z)) + &
       y*(-1480.222530425046_r8 + z*(-525.876123559641_r8 + (249.57717834054571_r8 - 88.449193048287_r8*z)*z) + &
       y*(-129.1994027934126_r8 + z*(1149.174198007428_r8 + z*(-162.5751787551336_r8 + 76.9195462169742_r8*z)) + &
       y*(-30.0682112585625_r8 - 1380.9597954037708_r8*z + y*(2.626801985426835_r8 + 703.695562834065_r8*z))))) + &
       y*(1187.3715515697959_r8 + z*(1458.233059470092_r8 + &
       z*(-687.913805923122_r8 + z*(249.375342232496_r8 + z*(-63.313928772146_r8 + 14.09317606630898_r8*z)))) + &
       y*(1760.062705994408_r8 + y*(-450.535298526802_r8 + &
       y*(182.8520895502518_r8 + y*(-43.3206481750622_r8 + 4.26033941694366_r8*y) + &
       z*(-595.457483974374_r8 + (149.452282277512_r8 - 72.9745838003176_r8*z)*z)) + &
       z*(1388.489628266536_r8 + z*(-409.779283929806_r8 + (227.123395681188_r8 - 22.2565468652826_r8*z)*z))) + &
       z*(-1721.528607567954_r8 + z*(674.819060538734_r8 + &
       z*(-356.629112415276_r8 + (88.4080716616_r8 - 15.84003094423364_r8*z)*z)))))
  
  if(sa.gt.0_r8) then
    g08 = g08 + (11625.62913253464_r8 + 1702.453469893412_r8*y)*log(x)
  else
    g08 = 0.0_r8
  endif
  
  gsw_gibbs = 0.5*gsw_sfac*g08

elseif(ns.eq.0 .and. nt.eq.1 .and. np.eq.0) then
               
  g03 = 5.90578347909402_r8 + z*(-270.983805184062_r8 + &
       z*(776.153611613101_r8 + z*(-196.51255088122_r8 + (28.9796526294175_r8 - 2.13290083518327_r8*z)*z))) + &
       y*(-24715.571866078_r8 + z*(2910.0729080936_r8 + &
       z*(-1513.116771538718_r8 + z*(546.959324647056_r8 + z*(-111.1208127634436_r8 + 8.68841343834394_r8*z)))) + &
       y*(2210.2236124548363_r8 + z*(-2017.52334943521_r8 + &
       z*(1498.081172457456_r8 + z*(-718.6359919632359_r8 + (146.4037555781616_r8 - 4.9892131862671505_r8*z)*z))) + &
       y*(-592.743745734632_r8 + z*(1591.873781627888_r8 + &
       z*(-1207.261522487504_r8 + (608.785486935364_r8 - 105.4993508931208_r8*z)*z)) + &
       y*(290.12956292128547_r8 + z*(-973.091553087975_r8 + &
       z*(602.603274510125_r8 + z*(-276.361526170076_r8 + 32.40953340386105_r8*z))) + &
       y*(-113.90630790850321_r8 + y*(21.35571525415769_r8 - 67.41756835751434_r8*z) + &
       z*(381.06836198507096_r8 + z*(-133.7383902842754_r8 + 49.023632509086724_r8*z)))))))
              
  g08 = x2*(168.072408311545_r8 + z*(729.116529735046_r8 + &
        z*(-343.956902961561_r8 + z*(124.687671116248_r8 + z*(-31.656964386073_r8 + 7.04658803315449_r8*z)))) + &
        x*(-493.407510141682_r8 + x*(543.835333000098_r8 + x*(-196.028306689776_r8 + 36.7571622995805_r8*x) + &
        y*(-137.1145018408982_r8 + y*(148.10030845687618_r8 + y*(-68.5590309679152_r8 + 12.4848504784754_r8*y))) - &
        22.6683558512829_r8*z) + z*(-175.292041186547_r8 + (83.1923927801819_r8 - 29.483064349429_r8*z)*z) + &
        y*(-86.1329351956084_r8 + z*(766.116132004952_r8 + z*(-108.3834525034224_r8 + 51.2796974779828_r8*z)) + &
        y*(-30.0682112585625_r8 - 1380.9597954037708_r8*z + y*(3.50240264723578_r8 + 938.26075044542_r8*z)))) + &
        y*(1760.062705994408_r8 + y*(-675.802947790203_r8 + &
        y*(365.7041791005036_r8 + y*(-108.30162043765552_r8 + 12.78101825083098_r8*y) + &
        z*(-1190.914967948748_r8 + (298.904564555024_r8 - 145.9491676006352_r8*z)*z)) + &
        z*(2082.7344423998043_r8 + z*(-614.668925894709_r8 + (340.685093521782_r8 - 33.3848202979239_r8*z)*z))) + &
        z*(-1721.528607567954_r8 + z*(674.819060538734_r8 + &
        z*(-356.629112415276_r8 + (88.4080716616_r8 - 15.84003094423364_r8*z)*z)))))
      
  if(sa.gt.0_r8) g08 = g08 + 851.226734946706_r8*x2*log(x)
  
  gsw_gibbs = (g03 + g08)*0.025_r8

elseif(ns.eq.0 .and. nt.eq.0 .and. np.eq.1) then
    
  g03 = 100015.695367145_r8 + z*(-5089.1530840726_r8 + &
        z*(853.5533353388611_r8 + z*(-133.2587017014444_r8 + (21.0131554401542_r8 - 3.278571068826234_r8*z)*z))) + &
        y*(-270.983805184062_r8 + z*(1552.307223226202_r8 + &
        z*(-589.53765264366_r8 + (115.91861051767_r8 - 10.664504175916349_r8*z)*z)) + &
        y*(1455.0364540468_r8 + z*(-1513.116771538718_r8 + &
        z*(820.438986970584_r8 + z*(-222.2416255268872_r8 + 21.72103359585985_r8*z))) + &
        y*(-672.50778314507_r8 + z*(998.720781638304_r8 + &
        z*(-718.6359919632359_r8 + (195.2050074375488_r8 - 8.31535531044525_r8*z)*z)) + &
        y*(397.968445406972_r8 + z*(-603.630761243752_r8 + (456.589115201523_r8 - 105.4993508931208_r8*z)*z) + &
        y*(-194.618310617595_r8 + y*(63.5113936641785_r8 - 9.63108119393062_r8*y + &
        z*(-44.5794634280918_r8 + 24.511816254543362_r8*z)) + &
        z*(241.04130980405_r8 + z*(-165.8169157020456_r8 + &
        25.92762672308884_r8*z)))))))                                                           
  
  g08 = x2*(-3310.49154044839_r8 + z*(769.588305957198_r8 + &
        z*(-289.5972960322374_r8 + (63.3632691067296_r8 - 13.1240078295496_r8*z)*z)) + &
        x*(199.459603073901_r8 + x*(-54.7919133532887_r8 + 36.0284195611086_r8*x - 22.6683558512829_r8*y + &
        (-8.16387957824522_r8 - 90.52653359134831_r8*z)*z) + &
        z*(-104.588181856267_r8 + (204.1334828179377_r8 - 13.65007729765128_r8*z)*z) + &
        y*(-175.292041186547_r8 + (166.3847855603638_r8 - 88.449193048287_r8*z)*z + &
        y*(383.058066002476_r8 + y*(-460.319931801257_r8 + 234.565187611355_r8*y) + &
        z*(-108.3834525034224_r8 + 76.9195462169742_r8*z)))) + &
        y*(729.116529735046_r8 + z*(-687.913805923122_r8 + &
        z*(374.063013348744_r8 + z*(-126.627857544292_r8 + 35.23294016577245_r8*z))) + &
        y*(-860.764303783977_r8 + y*(694.244814133268_r8 + &
        y*(-297.728741987187_r8 + (149.452282277512_r8 - 109.46187570047641_r8*z)*z) + &
        z*(-409.779283929806_r8 + (340.685093521782_r8 - 44.5130937305652_r8*z)*z)) + &
        z*(674.819060538734_r8 + z*(-534.943668622914_r8 + (176.8161433232_r8 - 39.600077360584095_r8*z)*z)))))
     
  gsw_gibbs = (g03 + g08)*1e-8_r8

elseif(ns.eq.0 .and. nt.eq.2 .and. np.eq.0) then

  g03 = -24715.571866078_r8 + z*(2910.0729080936_r8 + z* &
       (-1513.116771538718_r8 + z*(546.959324647056_r8 + z*(-111.1208127634436_r8 + 8.68841343834394_r8*z)))) + &
       y*(4420.4472249096725_r8 + z*(-4035.04669887042_r8 + &
       z*(2996.162344914912_r8 + z*(-1437.2719839264719_r8 + (292.8075111563232_r8 - 9.978426372534301_r8*z)*z))) + &
       y*(-1778.231237203896_r8 + z*(4775.621344883664_r8 + &
       z*(-3621.784567462512_r8 + (1826.356460806092_r8 - 316.49805267936244_r8*z)*z)) + &
       y*(1160.5182516851419_r8 + z*(-3892.3662123519_r8 + &
       z*(2410.4130980405_r8 + z*(-1105.446104680304_r8 + 129.6381336154442_r8*z))) + &
       y*(-569.531539542516_r8 + y*(128.13429152494615_r8 - 404.50541014508605_r8*z) + &
       z*(1905.341809925355_r8 + z*(-668.691951421377_r8 + 245.11816254543362_r8*z))))))

  g08 = x2*(1760.062705994408_r8 + x*(-86.1329351956084_r8 + &
        x*(-137.1145018408982_r8 + y*(296.20061691375236_r8 + y*(-205.67709290374563_r8 + 49.9394019139016_r8*y))) + &
        z*(766.116132004952_r8 + z*(-108.3834525034224_r8 + 51.2796974779828_r8*z)) + &
        y*(-60.136422517125_r8 - 2761.9195908075417_r8*z + y*(10.50720794170734_r8 + 2814.78225133626_r8*z))) + &
        y*(-1351.605895580406_r8 + y*(1097.1125373015109_r8 + y*(-433.20648175062206_r8 + 63.905091254154904_r8*y) + &
        z*(-3572.7449038462437_r8 + (896.713693665072_r8 - 437.84750280190565_r8*z)*z)) + &
        z*(4165.4688847996085_r8 + z*(-1229.337851789418_r8 + (681.370187043564_r8 - 66.7696405958478_r8*z)*z))) + &
        z*(-1721.528607567954_r8 + z*(674.819060538734_r8 + &
        z*(-356.629112415276_r8 + (88.4080716616_r8 - 15.84003094423364_r8*z)*z))))
     
  gsw_gibbs = (g03 + g08)*0.000625_r8  

elseif(ns.eq.1 .and. nt.eq.0 .and. np.eq.1) then

  g08 = -6620.98308089678_r8 + z*(1539.176611914396_r8 + &
        z*(-579.1945920644748_r8 + (126.7265382134592_r8 - 26.2480156590992_r8*z)*z)) + &
        x*(598.378809221703_r8 + x*(-219.1676534131548_r8 + 180.142097805543_r8*x - 90.6734234051316_r8*y + &
        (-32.65551831298088_r8 - 362.10613436539325_r8*z)*z) + &
        z*(-313.764545568801_r8 + (612.4004484538132_r8 - 40.95023189295384_r8*z)*z) + &
        y*(-525.876123559641_r8 + (499.15435668109143_r8 - 265.347579144861_r8*z)*z + &
        y*(1149.174198007428_r8 + y*(-1380.9597954037708_r8 + 703.695562834065_r8*y) + &
        z*(-325.1503575102672_r8 + 230.7586386509226_r8*z)))) + &
        y*(1458.233059470092_r8 + z*(-1375.827611846244_r8 + &
        z*(748.126026697488_r8 + z*(-253.255715088584_r8 + 70.4658803315449_r8*z))) + &
        y*(-1721.528607567954_r8 + y*(1388.489628266536_r8 + &
        y*(-595.457483974374_r8 + (298.904564555024_r8 - 218.92375140095282_r8*z)*z) + &
        z*(-819.558567859612_r8 + (681.370187043564_r8 - 89.0261874611304_r8*z)*z)) + &
        z*(1349.638121077468_r8 + z*(-1069.887337245828_r8 + (353.6322866464_r8 - 79.20015472116819_r8*z)*z))))    
                                                          
  gsw_gibbs = g08*gsw_sfac*0.5e-8_r8
         
elseif(ns.eq.0 .and. nt.eq.1 .and. np.eq.1) then

  g03 = -270.983805184062_r8 + z*(1552.307223226202_r8 + z*(-589.53765264366_r8 + &
          (115.91861051767_r8 - 10.664504175916349_r8*z)*z)) + &
        y*(2910.0729080936_r8 + z*(-3026.233543077436_r8 + &
        z*(1640.877973941168_r8 + z*(-444.4832510537744_r8 + 43.4420671917197_r8*z))) + &
        y*(-2017.52334943521_r8 + z*(2996.162344914912_r8 + &
        z*(-2155.907975889708_r8 + (585.6150223126464_r8 - 24.946065931335752_r8*z)*z)) + &
        y*(1591.873781627888_r8 + z*(-2414.523044975008_r8 + (1826.356460806092_r8 - 421.9974035724832_r8*z)*z) + &
        y*(-973.091553087975_r8 + z*(1205.20654902025_r8 + z*(-829.084578510228_r8 + 129.6381336154442_r8*z)) + &
        y*(381.06836198507096_r8 - 67.41756835751434_r8*y + z*(-267.4767805685508_r8 + 147.07089752726017_r8*z))))))
    
  g08 = x2*(729.116529735046_r8 + z*(-687.913805923122_r8 + &
        z*(374.063013348744_r8 + z*(-126.627857544292_r8 + 35.23294016577245_r8*z))) + &
        x*(-175.292041186547_r8 - 22.6683558512829_r8*x + (166.3847855603638_r8 - 88.449193048287_r8*z)*z + &
        y*(766.116132004952_r8 + y*(-1380.9597954037708_r8 + 938.26075044542_r8*y) + &
        z*(-216.7669050068448_r8 + 153.8390924339484_r8*z))) + &
        y*(-1721.528607567954_r8 + y*(2082.7344423998043_r8 + &
        y*(-1190.914967948748_r8 + (597.809129110048_r8 - 437.84750280190565_r8*z)*z) + &
        z*(-1229.337851789418_r8 + (1022.055280565346_r8 - 133.5392811916956_r8*z)*z)) + &
        z*(1349.638121077468_r8 + z*(-1069.887337245828_r8 + (353.6322866464_r8 - 79.20015472116819_r8*z)*z))))
    
  gsw_gibbs = (g03 + g08)*2.5e-10_r8

elseif(ns.eq.1 .and. nt.eq.1 .and. np.eq.0) then

    g08 = 1187.3715515697959_r8 + z*(1458.233059470092_r8 + &
        z*(-687.913805923122_r8 + z*(249.375342232496_r8 + z*(-63.313928772146_r8 + 14.09317606630898_r8*z)))) + &
        x*(-1480.222530425046_r8 + x*(2175.341332000392_r8 + x*(-980.14153344888_r8 + 220.542973797483_r8*x) + &
        y*(-548.4580073635929_r8 + y*(592.4012338275047_r8 + y*(-274.2361238716608_r8 + 49.9394019139016_r8*y))) - &
        90.6734234051316_r8*z) + z*(-525.876123559641_r8 + (249.57717834054571_r8 - 88.449193048287_r8*z)*z) + &
        y*(-258.3988055868252_r8 + z*(2298.348396014856_r8 + z*(-325.1503575102672_r8 + 153.8390924339484_r8*z)) + &
        y*(-90.2046337756875_r8 - 4142.8793862113125_r8*z + y*(10.50720794170734_r8 + 2814.78225133626_r8*z)))) + &
        y*(3520.125411988816_r8 + y*(-1351.605895580406_r8 + &
        y*(731.4083582010072_r8 + y*(-216.60324087531103_r8 + 25.56203650166196_r8*y) + &
        z*(-2381.829935897496_r8 + (597.809129110048_r8 - 291.8983352012704_r8*z)*z)) + &
        z*(4165.4688847996085_r8 + z*(-1229.337851789418_r8 + (681.370187043564_r8 - 66.7696405958478_r8*z)*z))) + &
        z*(-3443.057215135908_r8 + z*(1349.638121077468_r8 + &
        z*(-713.258224830552_r8 + (176.8161433232_r8 - 31.68006188846728_r8*z)*z))))

    if(sa.gt.0_r8) g08 = g08 + 1702.453469893412_r8*log(x)

    gsw_gibbs = 0.5_r8*gsw_sfac*0.025_r8*g08

elseif(ns.eq.2 .and. nt.eq.0 .and. np.eq.0) then

    g08 = 2.0_r8*(8103.20462414788_r8 + &
        y*(2175.341332000392_r8 + y*(-274.2290036817964_r8 + &
        y*(197.4670779425016_r8 + y*(-68.5590309679152_r8 + 9.98788038278032_r8*y))) - 90.6734234051316_r8*z) + &
        1.5_r8*x*(-5458.34205214835_r8 - 980.14153344888_r8*y + &
        (4.0_r8/3.0_r8)*x*(2247.60742726704_r8 - 340.1237483177863_r8*1.25_r8*x + 220.542973797483_r8*y) + &
        180.142097805543_r8*z) + &
        z*(-219.1676534131548_r8 + (-16.32775915649044_r8 - 120.7020447884644_r8*z)*z))

    if (x.gt.0_r8) then
        g08 = g08 + (-7296.43987145382_r8 + z*(598.378809221703_r8 + &
            z*(-156.8822727844005_r8 + (204.1334828179377_r8 - 10.23755797323846_r8*z)*z)) + &
            y*(-1480.222530425046_r8 + z*(-525.876123559641_r8 + &
            (249.57717834054571_r8 - 88.449193048287_r8*z)*z) + &
            y*(-129.1994027934126_r8 + z*(1149.174198007428_r8 + &
            z*(-162.5751787551336_r8 + 76.9195462169742_r8*z)) + &
            y*(-30.0682112585625_r8 - 1380.9597954037708_r8*z + &
            y*(2.626801985426835_r8 + 703.695562834065_r8*z)))))/x + &
            (11625.62913253464_r8 + 1702.453469893412_r8*y)/x2
    else
        g08 = 0.0_r8
    end if

    gsw_gibbs = 0.25_r8*gsw_sfac*gsw_sfac*g08

elseif(ns.eq.0 .and. nt.eq.0 .and. np.eq.2) then
           
  g03 = -5089.1530840726_r8 + z*(1707.1066706777221_r8 + &
      z*(-399.7761051043332_r8 + (84.0526217606168_r8 - 16.39285534413117_r8*z)*z)) + &
     y*(1552.307223226202_r8 + z*(-1179.07530528732_r8 + (347.75583155301_r8 - 42.658016703665396_r8*z)*z) + &
      y*(-1513.116771538718_r8 + z*(1640.877973941168_r8 + z*(-666.7248765806615_r8 + 86.8841343834394_r8*z)) + &
        y*(998.720781638304_r8 + z*(-1437.2719839264719_r8 + (585.6150223126464_r8 - 33.261421241781_r8*z)*z) + &
         y*(-603.630761243752_r8 + (913.178230403046_r8 - 316.49805267936244_r8*z)*z + &
           y*(241.04130980405_r8 + y*(-44.5794634280918_r8 + 49.023632509086724_r8*z) + &
            z*(-331.6338314040912_r8 + 77.78288016926652_r8*z))))))
            
  g08 = x2*(769.588305957198_r8 + z*(-579.1945920644748_r8 + (190.08980732018878_r8 - 52.4960313181984_r8*z)*z) + &
      x*(-104.588181856267_r8 + x*(-8.16387957824522_r8 - 181.05306718269662_r8*z) + &
       (408.2669656358754_r8 - 40.95023189295384_r8*z)*z + &
       y*(166.3847855603638_r8 - 176.898386096574_r8*z + y*(-108.3834525034224_r8 + 153.8390924339484_r8*z))) + &
      y*(-687.913805923122_r8 + z*(748.126026697488_r8 + z*(-379.883572632876_r8 + 140.9317606630898_r8*z)) + &
       y*(674.819060538734_r8 + z*(-1069.887337245828_r8 + (530.4484299696_r8 - 158.40030944233638_r8*z)*z) + &
         y*(-409.779283929806_r8 + y*(149.452282277512_r8 - 218.92375140095282_r8*z) + &
          (681.370187043564_r8 - 133.5392811916956_r8*z)*z))))
    
  gsw_gibbs = (g03 + g08)*1e-16_r8 

end if

return
end function

!--------------------------------------------------------------------------
