!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb29
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg29, only : kao, kbo, selfrefo, forrefo, sfluxrefo, &
                            absh2oo, absco2o, rayl, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      real :: irradscl
      save

! Kurucz solar source function
      sfluxrefo(:) = (/ &
        & 1.32880    , 2.14018    , 1.97612    , 1.79000    , &
        & 1.51242    , 1.22977    , 1.06052    , 0.800996   , &
        & 0.748053   , 8.64369e-02, 7.10675e-02, 5.62425e-02, &
        & 4.46988e-02, 3.07441e-02, 1.16728e-02, 1.65573e-03 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:) = (/ &
        & 3.08203E+00, 1.16181E+00, 1.40910E+00, 1.72932E+00,&
        & 1.50993E+00, 1.22063E+00, 1.05521E+00, 8.60330E-01,&
        & 5.41746E-01, 5.88241E-02, 4.95311E-02, 3.91123E-02,&
        & 2.43242E-02, 1.50450E-02, 5.91303E-03, 8.86641E-04/)
! Apply scaling to irradnceo in this band to account for solar function 
! below 820 cm-1 (scaling quantities were derived from high-resolution data)
      irradscl = 13.221 / (13.221 - 0.455)
      irradnceo(:) = irradscl * irradnceo(:)
! Solar variability components: facular brightening
      facbrghto(:) = (/ &
        & 1.52123E-03, 9.54536E-04, 1.35866E-03, 1.60003E-03,&
        & 1.23938E-03, 8.92375E-04, 7.12962E-04, 5.35573E-04,&
        & 3.45092E-04, 3.73112E-05, 3.09799E-05, 2.40402E-05,&
        & 1.65222E-05, 1.02372E-05, 4.00345E-06, 6.10834E-07/)
! Solar variability components: sunspot darkening
      snsptdrko(:) = (/ &
        &-3.52049E-04,-1.39728E-04,-1.92648E-04,-2.37837E-04,&
        &-1.93491E-04,-1.45692E-04,-1.23179E-04,-9.89247E-05,&
        &-6.17934E-05,-6.69155E-06,-5.61746E-06,-4.40500E-06,&
        &-2.74223E-06,-1.68468E-06,-6.65633E-07,-1.00868E-07/)

      absco2o(:) = (/ &
        & 2.90073e-06, 2.12382e-05, 1.03032e-04, 1.86481e-04, &
        & 4.31997e-04, 6.08238e-04, 2.17603e-03, 4.64479e-02, &
        & 2.96956    , 14.9569    , 28.4831    , 61.3998    , &
        & 164.129    , 832.282    , 4995.02    , 12678.1     /)

      absh2oo(:) = (/ &
        & 2.99508e-04, 3.95012e-03, 1.49316e-02, 3.24384e-02, &
        & 6.92879e-02, 0.123523   , 0.360985   , 1.86434    , &
        & 10.38157   , 0.214129   , 0.213914   , 0.212781   , &
        & 0.215562   , 0.218087   , 0.220918   , 0.218546    /)
           
! Rayleigh extinction coefficient at v = 2200 cm-1.
      rayl = 9.30e-11

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.11565e-03,0.10123e-03,0.90804e-04,0.82282e-04,0.71083e-04 /)
      kao(:, 2, 1) = (/ &
        & 0.96434e-04,0.82830e-04,0.72366e-04,0.61803e-04,0.52497e-04 /)
      kao(:, 3, 1) = (/ &
        & 0.64539e-04,0.56659e-04,0.46605e-04,0.39815e-04,0.37118e-04 /)
      kao(:, 4, 1) = (/ &
        & 0.34417e-04,0.27113e-04,0.25362e-04,0.30345e-04,0.36275e-04 /)
      kao(:, 5, 1) = (/ &
        & 0.12260e-04,0.15856e-04,0.20834e-04,0.27363e-04,0.36114e-04 /)
      kao(:, 6, 1) = (/ &
        & 0.10221e-04,0.14598e-04,0.19695e-04,0.25976e-04,0.33702e-04 /)
      kao(:, 7, 1) = (/ &
        & 0.97563e-05,0.13809e-04,0.20231e-04,0.27238e-04,0.36110e-04 /)
      kao(:, 8, 1) = (/ &
        & 0.14062e-04,0.19587e-04,0.27069e-04,0.36937e-04,0.49415e-04 /)
      kao(:, 9, 1) = (/ &
        & 0.36371e-04,0.48122e-04,0.61586e-04,0.77647e-04,0.99897e-04 /)
      kao(:,10, 1) = (/ &
        & 0.99203e-04,0.12842e-03,0.16588e-03,0.20834e-03,0.26000e-03 /)
      kao(:,11, 1) = (/ &
        & 0.13233e-03,0.17318e-03,0.22059e-03,0.28904e-03,0.36062e-03 /)
      kao(:,12, 1) = (/ &
        & 0.13379e-03,0.17484e-03,0.23687e-03,0.30286e-03,0.37504e-03 /)
      kao(:,13, 1) = (/ &
        & 0.11740e-03,0.15667e-03,0.20962e-03,0.26768e-03,0.33485e-03 /)
      kao(:, 1, 2) = (/ &
        & 0.10246e-03,0.10450e-03,0.97383e-04,0.96398e-04,0.10549e-03 /)
      kao(:, 2, 2) = (/ &
        & 0.10589e-03,0.10240e-03,0.95801e-04,0.98509e-04,0.11993e-03 /)
      kao(:, 3, 2) = (/ &
        & 0.94054e-04,0.87009e-04,0.10941e-03,0.13486e-03,0.15918e-03 /)
      kao(:, 4, 2) = (/ &
        & 0.11883e-03,0.14236e-03,0.16636e-03,0.18235e-03,0.19785e-03 /)
      kao(:, 5, 2) = (/ &
        & 0.17800e-03,0.19347e-03,0.20977e-03,0.22730e-03,0.25111e-03 /)
      kao(:, 6, 2) = (/ &
        & 0.22243e-03,0.24157e-03,0.26567e-03,0.28549e-03,0.30723e-03 /)
      kao(:, 7, 2) = (/ &
        & 0.29248e-03,0.32242e-03,0.34635e-03,0.37915e-03,0.40803e-03 /)
      kao(:, 8, 2) = (/ &
        & 0.43386e-03,0.48611e-03,0.52681e-03,0.56812e-03,0.60642e-03 /)
      kao(:, 9, 2) = (/ &
        & 0.89109e-03,0.10345e-02,0.11794e-02,0.13045e-02,0.14303e-02 /)
      kao(:,10, 2) = (/ &
        & 0.21538e-02,0.24459e-02,0.27329e-02,0.30932e-02,0.35253e-02 /)
      kao(:,11, 2) = (/ &
        & 0.29272e-02,0.32676e-02,0.36353e-02,0.40062e-02,0.45441e-02 /)
      kao(:,12, 2) = (/ &
        & 0.30762e-02,0.34365e-02,0.38146e-02,0.41556e-02,0.47164e-02 /)
      kao(:,13, 2) = (/ &
        & 0.27808e-02,0.31114e-02,0.34383e-02,0.37954e-02,0.42576e-02 /)
      kao(:, 1, 3) = (/ &
        & 0.24042e-03,0.32719e-03,0.44370e-03,0.56836e-03,0.70357e-03 /)
      kao(:, 2, 3) = (/ &
        & 0.23303e-03,0.31901e-03,0.41926e-03,0.52400e-03,0.62365e-03 /)
      kao(:, 3, 3) = (/ &
        & 0.35050e-03,0.42158e-03,0.47490e-03,0.53390e-03,0.60411e-03 /)
      kao(:, 4, 3) = (/ &
        & 0.49954e-03,0.53067e-03,0.56338e-03,0.60859e-03,0.66569e-03 /)
      kao(:, 5, 3) = (/ &
        & 0.66908e-03,0.69727e-03,0.72898e-03,0.76756e-03,0.80358e-03 /)
      kao(:, 6, 3) = (/ &
        & 0.88634e-03,0.92853e-03,0.96856e-03,0.10101e-02,0.10556e-02 /)
      kao(:, 7, 3) = (/ &
        & 0.11659e-02,0.12355e-02,0.13238e-02,0.13889e-02,0.14491e-02 /)
      kao(:, 8, 3) = (/ &
        & 0.17485e-02,0.18223e-02,0.19411e-02,0.20705e-02,0.22025e-02 /)
      kao(:, 9, 3) = (/ &
        & 0.42442e-02,0.43561e-02,0.45061e-02,0.47505e-02,0.50358e-02 /)
      kao(:,10, 3) = (/ &
        & 0.10940e-01,0.11499e-01,0.11906e-01,0.12570e-01,0.12803e-01 /)
      kao(:,11, 3) = (/ &
        & 0.14287e-01,0.15010e-01,0.15581e-01,0.16054e-01,0.16609e-01 /)
      kao(:,12, 3) = (/ &
        & 0.14856e-01,0.15546e-01,0.16074e-01,0.16478e-01,0.17057e-01 /)
      kao(:,13, 3) = (/ &
        & 0.13257e-01,0.13834e-01,0.14155e-01,0.14723e-01,0.15095e-01 /)
      kao(:, 1, 4) = (/ &
        & 0.24391e-02,0.28720e-02,0.33497e-02,0.38926e-02,0.45054e-02 /)
      kao(:, 2, 4) = (/ &
        & 0.22506e-02,0.26004e-02,0.30002e-02,0.34490e-02,0.39579e-02 /)
      kao(:, 3, 4) = (/ &
        & 0.22153e-02,0.25711e-02,0.29320e-02,0.33330e-02,0.37728e-02 /)
      kao(:, 4, 4) = (/ &
        & 0.22483e-02,0.25445e-02,0.28745e-02,0.32484e-02,0.36554e-02 /)
      kao(:, 5, 4) = (/ &
        & 0.23388e-02,0.25985e-02,0.28914e-02,0.32377e-02,0.36113e-02 /)
      kao(:, 6, 4) = (/ &
        & 0.24669e-02,0.26579e-02,0.28834e-02,0.31538e-02,0.34593e-02 /)
      kao(:, 7, 4) = (/ &
        & 0.32536e-02,0.33413e-02,0.34375e-02,0.35905e-02,0.38010e-02 /)
      kao(:, 8, 4) = (/ &
        & 0.51228e-02,0.51967e-02,0.52820e-02,0.53446e-02,0.53797e-02 /)
      kao(:, 9, 4) = (/ &
        & 0.13029e-01,0.13065e-01,0.12891e-01,0.12848e-01,0.12777e-01 /)
      kao(:,10, 4) = (/ &
        & 0.29911e-01,0.30117e-01,0.28340e-01,0.27321e-01,0.27485e-01 /)
      kao(:,11, 4) = (/ &
        & 0.36663e-01,0.36877e-01,0.34688e-01,0.33004e-01,0.32437e-01 /)
      kao(:,12, 4) = (/ &
        & 0.37282e-01,0.37775e-01,0.34910e-01,0.33463e-01,0.33074e-01 /)
      kao(:,13, 4) = (/ &
        & 0.33412e-01,0.32961e-01,0.30323e-01,0.29437e-01,0.29572e-01 /)
      kao(:, 1, 5) = (/ &
        & 0.20792e-01,0.22727e-01,0.25207e-01,0.27650e-01,0.29866e-01 /)
      kao(:, 2, 5) = (/ &
        & 0.17515e-01,0.19421e-01,0.21509e-01,0.23389e-01,0.25418e-01 /)
      kao(:, 3, 5) = (/ &
        & 0.14912e-01,0.16535e-01,0.18159e-01,0.19873e-01,0.21718e-01 /)
      kao(:, 4, 5) = (/ &
        & 0.13498e-01,0.14786e-01,0.16253e-01,0.17812e-01,0.19494e-01 /)
      kao(:, 5, 5) = (/ &
        & 0.12840e-01,0.13983e-01,0.15257e-01,0.16617e-01,0.18015e-01 /)
      kao(:, 6, 5) = (/ &
        & 0.12557e-01,0.13714e-01,0.14939e-01,0.16145e-01,0.17356e-01 /)
      kao(:, 7, 5) = (/ &
        & 0.11839e-01,0.12951e-01,0.14090e-01,0.15237e-01,0.16396e-01 /)
      kao(:, 8, 5) = (/ &
        & 0.13190e-01,0.13998e-01,0.14783e-01,0.15641e-01,0.16632e-01 /)
      kao(:, 9, 5) = (/ &
        & 0.24479e-01,0.24660e-01,0.25206e-01,0.25571e-01,0.26098e-01 /)
      kao(:,10, 5) = (/ &
        & 0.62373e-01,0.60241e-01,0.61372e-01,0.61530e-01,0.60978e-01 /)
      kao(:,11, 5) = (/ &
        & 0.76394e-01,0.73727e-01,0.74701e-01,0.75649e-01,0.75608e-01 /)
      kao(:,12, 5) = (/ &
        & 0.76656e-01,0.73608e-01,0.75610e-01,0.76362e-01,0.76033e-01 /)
      kao(:,13, 5) = (/ &
        & 0.66025e-01,0.64890e-01,0.66873e-01,0.66992e-01,0.66685e-01 /)
      kao(:, 1, 6) = (/ &
        & 0.99799e-01,0.10479e+00,0.10918e+00,0.11347e+00,0.11767e+00 /)
      kao(:, 2, 6) = (/ &
        & 0.87946e-01,0.91820e-01,0.95208e-01,0.99071e-01,0.10286e+00 /)
      kao(:, 3, 6) = (/ &
        & 0.76753e-01,0.80377e-01,0.84204e-01,0.87924e-01,0.91370e-01 /)
      kao(:, 4, 6) = (/ &
        & 0.67002e-01,0.70630e-01,0.73736e-01,0.76764e-01,0.79671e-01 /)
      kao(:, 5, 6) = (/ &
        & 0.58933e-01,0.61857e-01,0.64756e-01,0.67323e-01,0.69871e-01 /)
      kao(:, 6, 6) = (/ &
        & 0.53143e-01,0.55386e-01,0.57507e-01,0.59715e-01,0.62263e-01 /)
      kao(:, 7, 6) = (/ &
        & 0.50856e-01,0.52603e-01,0.54414e-01,0.56230e-01,0.58483e-01 /)
      kao(:, 8, 6) = (/ &
        & 0.50528e-01,0.52598e-01,0.54634e-01,0.56710e-01,0.58872e-01 /)
      kao(:, 9, 6) = (/ &
        & 0.64616e-01,0.65915e-01,0.67210e-01,0.68742e-01,0.70092e-01 /)
      kao(:,10, 6) = (/ &
        & 0.11509e+00,0.11448e+00,0.11368e+00,0.11348e+00,0.11401e+00 /)
      kao(:,11, 6) = (/ &
        & 0.14266e+00,0.13997e+00,0.13810e+00,0.13688e+00,0.13622e+00 /)
      kao(:,12, 6) = (/ &
        & 0.14464e+00,0.14198e+00,0.13915e+00,0.13789e+00,0.13781e+00 /)
      kao(:,13, 6) = (/ &
        & 0.12550e+00,0.12328e+00,0.12173e+00,0.12127e+00,0.12078e+00 /)
      kao(:, 1, 7) = (/ &
        & 0.30825e+00,0.31119e+00,0.31335e+00,0.31641e+00,0.32024e+00 /)
      kao(:, 2, 7) = (/ &
        & 0.28100e+00,0.28660e+00,0.29192e+00,0.29680e+00,0.30014e+00 /)
      kao(:, 3, 7) = (/ &
        & 0.26374e+00,0.27129e+00,0.27887e+00,0.28626e+00,0.29478e+00 /)
      kao(:, 4, 7) = (/ &
        & 0.24539e+00,0.25325e+00,0.26070e+00,0.26955e+00,0.27794e+00 /)
      kao(:, 5, 7) = (/ &
        & 0.21737e+00,0.22642e+00,0.23531e+00,0.24408e+00,0.25322e+00 /)
      kao(:, 6, 7) = (/ &
        & 0.19066e+00,0.19913e+00,0.20834e+00,0.21782e+00,0.22698e+00 /)
      kao(:, 7, 7) = (/ &
        & 0.17386e+00,0.18325e+00,0.19211e+00,0.20024e+00,0.20881e+00 /)
      kao(:, 8, 7) = (/ &
        & 0.17625e+00,0.18236e+00,0.18905e+00,0.19574e+00,0.20193e+00 /)
      kao(:, 9, 7) = (/ &
        & 0.21820e+00,0.22416e+00,0.22986e+00,0.23737e+00,0.24518e+00 /)
      kao(:,10, 7) = (/ &
        & 0.33529e+00,0.34302e+00,0.35397e+00,0.36397e+00,0.37339e+00 /)
      kao(:,11, 7) = (/ &
        & 0.38474e+00,0.39863e+00,0.41168e+00,0.42115e+00,0.42917e+00 /)
      kao(:,12, 7) = (/ &
        & 0.38499e+00,0.39580e+00,0.40497e+00,0.41279e+00,0.42045e+00 /)
      kao(:,13, 7) = (/ &
        & 0.34291e+00,0.35180e+00,0.35970e+00,0.36697e+00,0.37460e+00 /)
      kao(:, 1, 8) = (/ &
        & 0.87131e+00,0.87876e+00,0.88509e+00,0.89061e+00,0.89432e+00 /)
      kao(:, 2, 8) = (/ &
        & 0.78963e+00,0.79236e+00,0.79978e+00,0.80959e+00,0.82163e+00 /)
      kao(:, 3, 8) = (/ &
        & 0.82479e+00,0.82842e+00,0.83069e+00,0.83679e+00,0.84334e+00 /)
      kao(:, 4, 8) = (/ &
        & 0.90877e+00,0.91962e+00,0.92466e+00,0.93139e+00,0.93904e+00 /)
      kao(:, 5, 8) = (/ &
        & 0.97131e+00,0.99301e+00,0.10095e+01,0.10270e+01,0.10371e+01 /)
      kao(:, 6, 8) = (/ &
        & 0.96984e+00,0.10040e+01,0.10393e+01,0.10670e+01,0.10990e+01 /)
      kao(:, 7, 8) = (/ &
        & 0.95686e+00,0.10029e+01,0.10449e+01,0.10923e+01,0.11334e+01 /)
      kao(:, 8, 8) = (/ &
        & 0.97227e+00,0.10380e+01,0.11014e+01,0.11624e+01,0.12218e+01 /)
      kao(:, 9, 8) = (/ &
        & 0.12290e+01,0.13071e+01,0.14005e+01,0.15005e+01,0.15980e+01 /)
      kao(:,10, 8) = (/ &
        & 0.17996e+01,0.19304e+01,0.20752e+01,0.22219e+01,0.23814e+01 /)
      kao(:,11, 8) = (/ &
        & 0.19289e+01,0.20656e+01,0.22166e+01,0.23715e+01,0.25386e+01 /)
      kao(:,12, 8) = (/ &
        & 0.18429e+01,0.19765e+01,0.21175e+01,0.22722e+01,0.24239e+01 /)
      kao(:,13, 8) = (/ &
        & 0.16420e+01,0.17464e+01,0.18635e+01,0.19773e+01,0.21012e+01 /)
      kao(:, 1, 9) = (/ &
        & 0.39892e+01,0.40153e+01,0.40324e+01,0.40465e+01,0.40524e+01 /)
      kao(:, 2, 9) = (/ &
        & 0.38871e+01,0.39035e+01,0.39123e+01,0.39056e+01,0.38966e+01 /)
      kao(:, 3, 9) = (/ &
        & 0.37883e+01,0.37950e+01,0.38080e+01,0.37991e+01,0.37826e+01 /)
      kao(:, 4, 9) = (/ &
        & 0.37778e+01,0.37663e+01,0.37745e+01,0.37709e+01,0.37556e+01 /)
      kao(:, 5, 9) = (/ &
        & 0.38757e+01,0.38404e+01,0.38539e+01,0.39228e+01,0.39777e+01 /)
      kao(:, 6, 9) = (/ &
        & 0.40990e+01,0.41407e+01,0.41745e+01,0.42258e+01,0.42574e+01 /)
      kao(:, 7, 9) = (/ &
        & 0.46288e+01,0.46726e+01,0.47096e+01,0.47165e+01,0.47374e+01 /)
      kao(:, 8, 9) = (/ &
        & 0.58432e+01,0.58474e+01,0.58608e+01,0.58935e+01,0.59261e+01 /)
      kao(:, 9, 9) = (/ &
        & 0.88685e+01,0.88567e+01,0.88137e+01,0.87653e+01,0.87262e+01 /)
      kao(:,10, 9) = (/ &
        & 0.10455e+02,0.10242e+02,0.10004e+02,0.97643e+01,0.95067e+01 /)
      kao(:,11, 9) = (/ &
        & 0.10240e+02,0.99968e+01,0.97347e+01,0.94750e+01,0.92006e+01 /)
      kao(:,12, 9) = (/ &
        & 0.10401e+02,0.10165e+02,0.99240e+01,0.96656e+01,0.94112e+01 /)
      kao(:,13, 9) = (/ &
        & 0.10764e+02,0.10580e+02,0.10381e+02,0.10188e+02,0.99802e+01 /)
      kao(:, 1,10) = (/ &
        & 0.10712e+02,0.10575e+02,0.10581e+02,0.10556e+02,0.10575e+02 /)
      kao(:, 2,10) = (/ &
        & 0.11144e+02,0.11109e+02,0.11034e+02,0.11107e+02,0.11138e+02 /)
      kao(:, 3,10) = (/ &
        & 0.12257e+02,0.12112e+02,0.11992e+02,0.11951e+02,0.12031e+02 /)
      kao(:, 4,10) = (/ &
        & 0.13040e+02,0.13085e+02,0.12882e+02,0.12756e+02,0.12737e+02 /)
      kao(:, 5,10) = (/ &
        & 0.13809e+02,0.13771e+02,0.13452e+02,0.12567e+02,0.12086e+02 /)
      kao(:, 6,10) = (/ &
        & 0.14608e+02,0.13942e+02,0.13365e+02,0.13494e+02,0.13762e+02 /)
      kao(:, 7,10) = (/ &
        & 0.14665e+02,0.14685e+02,0.15121e+02,0.15602e+02,0.15768e+02 /)
      kao(:, 8,10) = (/ &
        & 0.15612e+02,0.16507e+02,0.16644e+02,0.16706e+02,0.16696e+02 /)
      kao(:, 9,10) = (/ &
        & 0.15405e+02,0.15874e+02,0.16716e+02,0.17957e+02,0.17859e+02 /)
      kao(:,10,10) = (/ &
        & 0.19406e+00,0.17932e+00,0.16660e+00,0.15558e+00,0.14589e+00 /)
      kao(:,11,10) = (/ &
        & 0.27650e+00,0.25556e+00,0.23727e+00,0.22182e+00,0.20805e+00 /)
      kao(:,12,10) = (/ &
        & 0.29298e+00,0.27044e+00,0.25162e+00,0.23497e+00,0.22076e+00 /)
      kao(:,13,10) = (/ &
        & 0.24883e+00,0.22985e+00,0.21413e+00,0.20012e+00,0.18795e+00 /)
      kao(:, 1,11) = (/ &
        & 0.13650e+02,0.13767e+02,0.13771e+02,0.13650e+02,0.13663e+02 /)
      kao(:, 2,11) = (/ &
        & 0.15146e+02,0.15253e+02,0.15272e+02,0.15152e+02,0.15138e+02 /)
      kao(:, 3,11) = (/ &
        & 0.16834e+02,0.17107e+02,0.17158e+02,0.17187e+02,0.17057e+02 /)
      kao(:, 4,11) = (/ &
        & 0.19191e+02,0.19144e+02,0.19155e+02,0.19247e+02,0.19292e+02 /)
      kao(:, 5,11) = (/ &
        & 0.20953e+02,0.21248e+02,0.21186e+02,0.21027e+02,0.20703e+02 /)
      kao(:, 6,11) = (/ &
        & 0.22592e+02,0.22192e+02,0.22056e+02,0.20972e+02,0.19910e+02 /)
      kao(:, 7,11) = (/ &
        & 0.24652e+02,0.23679e+02,0.22339e+02,0.21302e+02,0.21697e+02 /)
      kao(:, 8,11) = (/ &
        & 0.22508e+02,0.20438e+02,0.20163e+02,0.20628e+02,0.20954e+02 /)
      kao(:, 9,11) = (/ &
        & 0.10264e+02,0.85820e+01,0.65270e+01,0.38883e+01,0.27974e+01 /)
      kao(:,10,11) = (/ &
        & 0.19324e+00,0.17913e+00,0.16619e+00,0.15516e+00,0.14524e+00 /)
      kao(:,11,11) = (/ &
        & 0.27573e+00,0.25425e+00,0.23627e+00,0.22036e+00,0.20639e+00 /)
      kao(:,12,11) = (/ &
        & 0.29224e+00,0.26998e+00,0.25055e+00,0.23380e+00,0.21908e+00 /)
      kao(:,13,11) = (/ &
        & 0.24964e+00,0.23056e+00,0.21391e+00,0.19980e+00,0.18698e+00 /)
      kao(:, 1,12) = (/ &
        & 0.17721e+02,0.17805e+02,0.17752e+02,0.17857e+02,0.17872e+02 /)
      kao(:, 2,12) = (/ &
        & 0.20222e+02,0.20161e+02,0.20267e+02,0.20335e+02,0.20254e+02 /)
      kao(:, 3,12) = (/ &
        & 0.23717e+02,0.23414e+02,0.23571e+02,0.23552e+02,0.23687e+02 /)
      kao(:, 4,12) = (/ &
        & 0.26876e+02,0.26972e+02,0.27155e+02,0.26947e+02,0.27025e+02 /)
      kao(:, 5,12) = (/ &
        & 0.30213e+02,0.29978e+02,0.30226e+02,0.30477e+02,0.30329e+02 /)
      kao(:, 6,12) = (/ &
        & 0.33660e+02,0.33482e+02,0.33159e+02,0.32959e+02,0.32299e+02 /)
      kao(:, 7,12) = (/ &
        & 0.35893e+02,0.35649e+02,0.35067e+02,0.34565e+02,0.32437e+02 /)
      kao(:, 8,12) = (/ &
        & 0.33426e+02,0.33323e+02,0.31984e+02,0.29587e+02,0.27505e+02 /)
      kao(:, 9,12) = (/ &
        & 0.46633e-01,0.43205e-01,0.40562e-01,0.38133e-01,0.35900e-01 /)
      kao(:,10,12) = (/ &
        & 0.19421e+00,0.18024e+00,0.16872e+00,0.15815e+00,0.14837e+00 /)
      kao(:,11,12) = (/ &
        & 0.27315e+00,0.25480e+00,0.23771e+00,0.22191e+00,0.20780e+00 /)
      kao(:,12,12) = (/ &
        & 0.29027e+00,0.26969e+00,0.25017e+00,0.23314e+00,0.21774e+00 /)
      kao(:,13,12) = (/ &
        & 0.24833e+00,0.22943e+00,0.21278e+00,0.19800e+00,0.18543e+00 /)
      kao(:, 1,13) = (/ &
        & 0.29672e+02,0.29291e+02,0.29191e+02,0.29170e+02,0.29116e+02 /)
      kao(:, 2,13) = (/ &
        & 0.24713e+02,0.24965e+02,0.25039e+02,0.25355e+02,0.25650e+02 /)
      kao(:, 3,13) = (/ &
        & 0.30510e+02,0.31166e+02,0.30663e+02,0.31021e+02,0.30901e+02 /)
      kao(:, 4,13) = (/ &
        & 0.38695e+02,0.38922e+02,0.38741e+02,0.39204e+02,0.38826e+02 /)
      kao(:, 5,13) = (/ &
        & 0.45118e+02,0.44337e+02,0.43664e+02,0.43267e+02,0.43524e+02 /)
      kao(:, 6,13) = (/ &
        & 0.34652e+02,0.35182e+02,0.35339e+02,0.35340e+02,0.35899e+02 /)
      kao(:, 7,13) = (/ &
        & 0.18801e+02,0.18598e+02,0.18855e+02,0.18819e+02,0.19052e+02 /)
      kao(:, 8,13) = (/ &
        & 0.12297e-01,0.11425e-01,0.10670e-01,0.99994e-02,0.94139e-02 /)
      kao(:, 9,13) = (/ &
        & 0.46821e-01,0.43361e-01,0.40368e-01,0.37752e-01,0.35493e-01 /)
      kao(:,10,13) = (/ &
        & 0.19817e+00,0.18303e+00,0.17002e+00,0.15883e+00,0.14933e+00 /)
      kao(:,11,13) = (/ &
        & 0.28145e+00,0.25995e+00,0.24181e+00,0.22660e+00,0.21326e+00 /)
      kao(:,12,13) = (/ &
        & 0.29510e+00,0.27294e+00,0.25519e+00,0.23947e+00,0.22551e+00 /)
      kao(:,13,13) = (/ &
        & 0.24830e+00,0.23074e+00,0.21556e+00,0.20226e+00,0.19029e+00 /)
      kao(:, 1,14) = (/ &
        & 0.47168e+02,0.46890e+02,0.46612e+02,0.46353e+02,0.46088e+02 /)
      kao(:, 2,14) = (/ &
        & 0.47771e+02,0.46980e+02,0.46445e+02,0.45828e+02,0.45437e+02 /)
      kao(:, 3,14) = (/ &
        & 0.42946e+02,0.42652e+02,0.43791e+02,0.43237e+02,0.44104e+02 /)
      kao(:, 4,14) = (/ &
        & 0.30957e+02,0.30098e+02,0.30055e+02,0.29555e+02,0.29902e+02 /)
      kao(:, 5,14) = (/ &
        & 0.28397e+01,0.38572e+01,0.42906e+01,0.47091e+01,0.48135e+01 /)
      kao(:, 6,14) = (/ &
        & 0.36978e-02,0.34591e-02,0.32524e-02,0.30649e-02,0.29018e-02 /)
      kao(:, 7,14) = (/ &
        & 0.61733e-02,0.57589e-02,0.53925e-02,0.50742e-02,0.47835e-02 /)
      kao(:, 8,14) = (/ &
        & 0.12390e-01,0.11526e-01,0.10766e-01,0.10096e-01,0.95010e-02 /)
      kao(:, 9,14) = (/ &
        & 0.47105e-01,0.43648e-01,0.40665e-01,0.38054e-01,0.35722e-01 /)
      kao(:,10,14) = (/ &
        & 0.19915e+00,0.18412e+00,0.17099e+00,0.15957e+00,0.14948e+00 /)
      kao(:,11,14) = (/ &
        & 0.28280e+00,0.26124e+00,0.24266e+00,0.22645e+00,0.21214e+00 /)
      kao(:,12,14) = (/ &
        & 0.29891e+00,0.27613e+00,0.25648e+00,0.23927e+00,0.22423e+00 /)
      kao(:,13,14) = (/ &
        & 0.25421e+00,0.23484e+00,0.21809e+00,0.20347e+00,0.19057e+00 /)
      kao(:, 1,15) = (/ &
        & 0.64994e+02,0.64283e+02,0.63755e+02,0.63407e+02,0.63287e+02 /)
      kao(:, 2,15) = (/ &
        & 0.78266e+02,0.77364e+02,0.76722e+02,0.76285e+02,0.75992e+02 /)
      kao(:, 3,15) = (/ &
        & 0.41710e+02,0.38379e+02,0.35076e+02,0.35418e+02,0.33306e+02 /)
      kao(:, 4,15) = (/ &
        & 0.14170e-02,0.13401e-02,0.12716e-02,0.12073e-02,0.11535e-02 /)
      kao(:, 5,15) = (/ &
        & 0.23659e-02,0.22261e-02,0.21042e-02,0.19950e-02,0.18970e-02 /)
      kao(:, 6,15) = (/ &
        & 0.37432e-02,0.35105e-02,0.33006e-02,0.31222e-02,0.29521e-02 /)
      kao(:, 7,15) = (/ &
        & 0.62408e-02,0.58258e-02,0.54782e-02,0.51594e-02,0.48767e-02 /)
      kao(:, 8,15) = (/ &
        & 0.12522e-01,0.11652e-01,0.10922e-01,0.10265e-01,0.96672e-02 /)
      kao(:, 9,15) = (/ &
        & 0.47545e-01,0.44152e-01,0.41251e-01,0.38666e-01,0.36358e-01 /)
      kao(:,10,15) = (/ &
        & 0.20097e+00,0.18592e+00,0.17341e+00,0.16203e+00,0.15235e+00 /)
      kao(:,11,15) = (/ &
        & 0.28499e+00,0.26428e+00,0.24585e+00,0.22980e+00,0.21575e+00 /)
      kao(:,12,15) = (/ &
        & 0.30172e+00,0.27929e+00,0.25980e+00,0.24306e+00,0.22789e+00 /)
      kao(:,13,15) = (/ &
        & 0.25655e+00,0.23731e+00,0.22092e+00,0.20639e+00,0.19367e+00 /)
      kao(:, 1,16) = (/ &
        & 0.80810e+02,0.81099e+02,0.81190e+02,0.81107e+02,0.80989e+02 /)
      kao(:, 2,16) = (/ &
        & 0.99319e+02,0.99708e+02,0.99822e+02,0.99871e+02,0.99993e+02 /)
      kao(:, 3,16) = (/ &
        & 0.46927e+02,0.54316e+02,0.57355e+02,0.53715e+02,0.52802e+02 /)
      kao(:, 4,16) = (/ &
        & 0.12802e-02,0.12027e-02,0.11386e-02,0.10866e-02,0.10525e-02 /)
      kao(:, 5,16) = (/ &
        & 0.21675e-02,0.20715e-02,0.19422e-02,0.18402e-02,0.17681e-02 /)
      kao(:, 6,16) = (/ &
        & 0.34707e-02,0.32796e-02,0.30986e-02,0.29246e-02,0.28034e-02 /)
      kao(:, 7,16) = (/ &
        & 0.58659e-02,0.55310e-02,0.51820e-02,0.48829e-02,0.46784e-02 /)
      kao(:, 8,16) = (/ &
        & 0.11875e-01,0.11183e-01,0.10438e-01,0.98038e-02,0.93665e-02 /)
      kao(:, 9,16) = (/ &
        & 0.45519e-01,0.42850e-01,0.39715e-01,0.37447e-01,0.35369e-01 /)
      kao(:,10,16) = (/ &
        & 0.19392e+00,0.18108e+00,0.16817e+00,0.15883e+00,0.14864e+00 /)
      kao(:,11,16) = (/ &
        & 0.27830e+00,0.25715e+00,0.24100e+00,0.22595e+00,0.21321e+00 /)
      kao(:,12,16) = (/ &
        & 0.29533e+00,0.27422e+00,0.25636e+00,0.23936e+00,0.22658e+00 /)
      kao(:,13,16) = (/ &
        & 0.25310e+00,0.23535e+00,0.21855e+00,0.20552e+00,0.19293e+00 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:,13, 1) = (/ &
        & 0.18379e-05,0.23296e-05,0.29007e-05,0.35902e-05,0.43437e-05 /)
      kbo(:,14, 1) = (/ &
        & 0.15919e-05,0.19832e-05,0.24720e-05,0.30683e-05,0.37253e-05 /)
      kbo(:,15, 1) = (/ &
        & 0.13850e-05,0.17115e-05,0.21225e-05,0.26292e-05,0.31945e-05 /)
      kbo(:,16, 1) = (/ &
        & 0.11896e-05,0.14680e-05,0.18142e-05,0.22537e-05,0.27284e-05 /)
      kbo(:,17, 1) = (/ &
        & 0.10228e-05,0.12597e-05,0.15532e-05,0.19272e-05,0.23163e-05 /)
      kbo(:,18, 1) = (/ &
        & 0.88243e-06,0.10835e-05,0.13316e-05,0.16603e-05,0.19808e-05 /)
      kbo(:,19, 1) = (/ &
        & 0.75677e-06,0.92925e-06,0.11401e-05,0.14107e-05,0.16901e-05 /)
      kbo(:,20, 1) = (/ &
        & 0.64614e-06,0.79361e-06,0.97353e-06,0.11964e-05,0.14414e-05 /)
      kbo(:,21, 1) = (/ &
        & 0.55323e-06,0.67580e-06,0.82647e-06,0.10137e-05,0.12318e-05 /)
      kbo(:,22, 1) = (/ &
        & 0.47719e-06,0.58149e-06,0.71060e-06,0.87005e-06,0.10605e-05 /)
      kbo(:,23, 1) = (/ &
        & 0.41128e-06,0.50080e-06,0.61104e-06,0.75347e-06,0.91200e-06 /)
      kbo(:,24, 1) = (/ &
        & 0.35306e-06,0.42860e-06,0.52320e-06,0.65156e-06,0.78122e-06 /)
      kbo(:,25, 1) = (/ &
        & 0.30363e-06,0.36731e-06,0.44673e-06,0.56097e-06,0.66791e-06 /)
      kbo(:,26, 1) = (/ &
        & 0.26073e-06,0.31537e-06,0.38738e-06,0.48210e-06,0.57382e-06 /)
      kbo(:,27, 1) = (/ &
        & 0.22303e-06,0.26986e-06,0.33628e-06,0.41161e-06,0.48722e-06 /)
      kbo(:,28, 1) = (/ &
        & 0.18954e-06,0.22952e-06,0.28797e-06,0.35166e-06,0.41440e-06 /)
      kbo(:,29, 1) = (/ &
        & 0.16106e-06,0.19430e-06,0.24661e-06,0.29815e-06,0.35151e-06 /)
      kbo(:,30, 1) = (/ &
        & 0.13630e-06,0.16528e-06,0.20922e-06,0.25193e-06,0.29913e-06 /)
      kbo(:,31, 1) = (/ &
        & 0.11504e-06,0.14276e-06,0.17807e-06,0.21482e-06,0.25451e-06 /)
      kbo(:,32, 1) = (/ &
        & 0.96980e-07,0.12215e-06,0.15159e-06,0.18179e-06,0.21515e-06 /)
      kbo(:,33, 1) = (/ &
        & 0.81598e-07,0.10315e-06,0.12730e-06,0.15190e-06,0.18093e-06 /)
      kbo(:,34, 1) = (/ &
        & 0.67700e-07,0.85970e-07,0.10559e-06,0.12608e-06,0.15006e-06 /)
      kbo(:,35, 1) = (/ &
        & 0.55177e-07,0.69519e-07,0.85967e-07,0.10223e-06,0.12147e-06 /)
      kbo(:,36, 1) = (/ &
        & 0.43924e-07,0.54395e-07,0.67998e-07,0.81142e-07,0.95717e-07 /)
      kbo(:,37, 1) = (/ &
        & 0.34469e-07,0.41036e-07,0.52575e-07,0.63117e-07,0.74301e-07 /)
      kbo(:,38, 1) = (/ &
        & 0.26777e-07,0.31734e-07,0.40555e-07,0.49032e-07,0.57653e-07 /)
      kbo(:,39, 1) = (/ &
        & 0.20670e-07,0.24721e-07,0.30685e-07,0.37873e-07,0.44555e-07 /)
      kbo(:,40, 1) = (/ &
        & 0.15860e-07,0.19032e-07,0.22612e-07,0.28845e-07,0.34246e-07 /)
      kbo(:,41, 1) = (/ &
        & 0.12129e-07,0.14603e-07,0.17357e-07,0.21851e-07,0.26346e-07 /)
      kbo(:,42, 1) = (/ &
        & 0.92319e-08,0.11199e-07,0.13365e-07,0.16174e-07,0.20019e-07 /)
      kbo(:,43, 1) = (/ &
        & 0.69289e-08,0.84537e-08,0.10159e-07,0.11992e-07,0.14940e-07 /)
      kbo(:,44, 1) = (/ &
        & 0.51546e-08,0.63380e-08,0.76593e-08,0.90562e-08,0.10716e-07 /)
      kbo(:,45, 1) = (/ &
        & 0.38335e-08,0.47085e-08,0.57219e-08,0.68148e-08,0.79518e-08 /)
      kbo(:,46, 1) = (/ &
        & 0.28583e-08,0.34724e-08,0.42447e-08,0.50888e-08,0.59494e-08 /)
      kbo(:,47, 1) = (/ &
        & 0.20945e-08,0.25418e-08,0.31058e-08,0.37494e-08,0.44274e-08 /)
      kbo(:,48, 1) = (/ &
        & 0.15164e-08,0.18560e-08,0.22628e-08,0.27371e-08,0.32773e-08 /)
      kbo(:,49, 1) = (/ &
        & 0.10916e-08,0.13465e-08,0.16387e-08,0.19740e-08,0.23865e-08 /)
      kbo(:,50, 1) = (/ &
        & 0.78324e-09,0.98361e-09,0.11977e-08,0.14517e-08,0.17457e-08 /)
      kbo(:,51, 1) = (/ &
        & 0.57263e-09,0.71786e-09,0.87689e-09,0.10705e-08,0.12881e-08 /)
      kbo(:,52, 1) = (/ &
        & 0.41574e-09,0.51264e-09,0.64152e-09,0.78315e-09,0.94705e-09 /)
      kbo(:,53, 1) = (/ &
        & 0.29940e-09,0.36836e-09,0.45886e-09,0.56405e-09,0.69166e-09 /)
      kbo(:,54, 1) = (/ &
        & 0.22617e-09,0.27395e-09,0.33754e-09,0.42095e-09,0.51544e-09 /)
      kbo(:,55, 1) = (/ &
        & 0.17483e-09,0.20845e-09,0.25546e-09,0.31817e-09,0.39119e-09 /)
      kbo(:,56, 1) = (/ &
        & 0.13496e-09,0.15930e-09,0.19380e-09,0.23861e-09,0.29770e-09 /)
      kbo(:,57, 1) = (/ &
        & 0.10406e-09,0.12247e-09,0.14749e-09,0.18078e-09,0.22597e-09 /)
      kbo(:,58, 1) = (/ &
        & 0.81345e-10,0.94816e-10,0.11329e-09,0.13832e-09,0.17161e-09 /)
      kbo(:,59, 1) = (/ &
        & 0.67159e-10,0.78312e-10,0.94745e-10,0.11544e-09,0.14442e-09 /)
      kbo(:,13, 2) = (/ &
        & 0.16654e-04,0.18728e-04,0.21238e-04,0.24491e-04,0.29038e-04 /)
      kbo(:,14, 2) = (/ &
        & 0.15636e-04,0.17574e-04,0.19918e-04,0.23671e-04,0.27237e-04 /)
      kbo(:,15, 2) = (/ &
        & 0.14853e-04,0.16629e-04,0.19700e-04,0.22604e-04,0.25586e-04 /)
      kbo(:,16, 2) = (/ &
        & 0.13519e-04,0.15923e-04,0.18289e-04,0.20530e-04,0.22799e-04 /)
      kbo(:,17, 2) = (/ &
        & 0.12411e-04,0.14439e-04,0.16431e-04,0.18235e-04,0.20109e-04 /)
      kbo(:,18, 2) = (/ &
        & 0.11267e-04,0.12880e-04,0.14429e-04,0.16005e-04,0.17538e-04 /)
      kbo(:,19, 2) = (/ &
        & 0.10025e-04,0.11332e-04,0.12550e-04,0.13853e-04,0.15103e-04 /)
      kbo(:,20, 2) = (/ &
        & 0.86342e-05,0.97455e-05,0.10778e-04,0.11898e-04,0.12789e-04 /)
      kbo(:,21, 2) = (/ &
        & 0.74004e-05,0.83107e-05,0.91633e-05,0.10071e-04,0.10674e-04 /)
      kbo(:,22, 2) = (/ &
        & 0.63700e-05,0.70549e-05,0.78271e-05,0.85170e-05,0.90022e-05 /)
      kbo(:,23, 2) = (/ &
        & 0.54404e-05,0.60156e-05,0.66393e-05,0.71320e-05,0.75007e-05 /)
      kbo(:,24, 2) = (/ &
        & 0.45997e-05,0.50718e-05,0.55713e-05,0.59455e-05,0.62118e-05 /)
      kbo(:,25, 2) = (/ &
        & 0.38745e-05,0.42617e-05,0.46479e-05,0.49297e-05,0.51638e-05 /)
      kbo(:,26, 2) = (/ &
        & 0.32488e-05,0.35592e-05,0.38685e-05,0.40759e-05,0.43092e-05 /)
      kbo(:,27, 2) = (/ &
        & 0.26995e-05,0.29601e-05,0.32065e-05,0.33666e-05,0.35609e-05 /)
      kbo(:,28, 2) = (/ &
        & 0.22359e-05,0.24429e-05,0.26408e-05,0.27752e-05,0.29293e-05 /)
      kbo(:,29, 2) = (/ &
        & 0.18487e-05,0.20089e-05,0.21668e-05,0.22793e-05,0.24029e-05 /)
      kbo(:,30, 2) = (/ &
        & 0.15291e-05,0.16589e-05,0.17733e-05,0.18706e-05,0.19584e-05 /)
      kbo(:,31, 2) = (/ &
        & 0.12554e-05,0.13589e-05,0.14436e-05,0.15195e-05,0.15928e-05 /)
      kbo(:,32, 2) = (/ &
        & 0.10248e-05,0.11046e-05,0.11716e-05,0.12288e-05,0.12916e-05 /)
      kbo(:,33, 2) = (/ &
        & 0.83272e-06,0.89120e-06,0.95036e-06,0.99040e-06,0.10409e-05 /)
      kbo(:,34, 2) = (/ &
        & 0.67518e-06,0.72097e-06,0.76854e-06,0.80246e-06,0.83912e-06 /)
      kbo(:,35, 2) = (/ &
        & 0.53577e-06,0.57870e-06,0.61715e-06,0.64987e-06,0.67220e-06 /)
      kbo(:,36, 2) = (/ &
        & 0.42402e-06,0.45825e-06,0.49307e-06,0.52005e-06,0.54029e-06 /)
      kbo(:,37, 2) = (/ &
        & 0.33419e-06,0.36213e-06,0.38911e-06,0.41359e-06,0.43177e-06 /)
      kbo(:,38, 2) = (/ &
        & 0.26240e-06,0.28355e-06,0.30530e-06,0.32881e-06,0.34617e-06 /)
      kbo(:,39, 2) = (/ &
        & 0.20468e-06,0.22245e-06,0.23980e-06,0.25776e-06,0.27424e-06 /)
      kbo(:,40, 2) = (/ &
        & 0.16070e-06,0.17478e-06,0.18856e-06,0.20230e-06,0.21801e-06 /)
      kbo(:,41, 2) = (/ &
        & 0.12583e-06,0.13680e-06,0.14851e-06,0.15917e-06,0.17184e-06 /)
      kbo(:,42, 2) = (/ &
        & 0.98494e-07,0.10639e-06,0.11634e-06,0.12500e-06,0.13490e-06 /)
      kbo(:,43, 2) = (/ &
        & 0.75196e-07,0.82809e-07,0.90095e-07,0.97952e-07,0.10509e-06 /)
      kbo(:,44, 2) = (/ &
        & 0.57305e-07,0.63787e-07,0.69227e-07,0.75635e-07,0.81687e-07 /)
      kbo(:,45, 2) = (/ &
        & 0.42965e-07,0.48245e-07,0.53346e-07,0.58061e-07,0.63120e-07 /)
      kbo(:,46, 2) = (/ &
        & 0.31048e-07,0.36457e-07,0.40514e-07,0.44557e-07,0.48550e-07 /)
      kbo(:,47, 2) = (/ &
        & 0.23094e-07,0.26356e-07,0.30443e-07,0.33954e-07,0.36789e-07 /)
      kbo(:,48, 2) = (/ &
        & 0.16858e-07,0.19402e-07,0.22449e-07,0.25401e-07,0.28254e-07 /)
      kbo(:,49, 2) = (/ &
        & 0.11413e-07,0.14055e-07,0.16046e-07,0.18927e-07,0.21080e-07 /)
      kbo(:,50, 2) = (/ &
        & 0.78650e-08,0.99879e-08,0.11846e-07,0.13654e-07,0.15871e-07 /)
      kbo(:,51, 2) = (/ &
        & 0.55417e-08,0.68977e-08,0.87006e-08,0.10108e-07,0.11829e-07 /)
      kbo(:,52, 2) = (/ &
        & 0.39143e-08,0.48025e-08,0.60180e-08,0.73762e-08,0.85851e-08 /)
      kbo(:,53, 2) = (/ &
        & 0.27637e-08,0.33397e-08,0.41996e-08,0.52787e-08,0.62923e-08 /)
      kbo(:,54, 2) = (/ &
        & 0.19691e-08,0.24529e-08,0.30071e-08,0.38041e-08,0.46981e-08 /)
      kbo(:,55, 2) = (/ &
        & 0.13034e-08,0.18257e-08,0.22359e-08,0.28210e-08,0.35386e-08 /)
      kbo(:,56, 2) = (/ &
        & 0.10026e-08,0.13422e-08,0.16687e-08,0.20793e-08,0.26054e-08 /)
      kbo(:,57, 2) = (/ &
        & 0.77730e-09,0.91190e-09,0.12468e-08,0.15302e-08,0.19418e-08 /)
      kbo(:,58, 2) = (/ &
        & 0.60359e-09,0.67848e-09,0.92414e-09,0.11511e-08,0.14401e-08 /)
      kbo(:,59, 2) = (/ &
        & 0.50441e-09,0.56797e-09,0.77369e-09,0.95612e-09,0.11957e-08 /)
      kbo(:,13, 3) = (/ &
        & 0.98124e-04,0.10149e-03,0.10303e-03,0.10669e-03,0.10870e-03 /)
      kbo(:,14, 3) = (/ &
        & 0.88110e-04,0.89730e-04,0.90679e-04,0.91892e-04,0.91413e-04 /)
      kbo(:,15, 3) = (/ &
        & 0.78555e-04,0.78633e-04,0.79145e-04,0.77689e-04,0.77791e-04 /)
      kbo(:,16, 3) = (/ &
        & 0.67245e-04,0.67743e-04,0.66690e-04,0.65765e-04,0.65950e-04 /)
      kbo(:,17, 3) = (/ &
        & 0.57553e-04,0.57490e-04,0.56012e-04,0.55634e-04,0.56016e-04 /)
      kbo(:,18, 3) = (/ &
        & 0.49729e-04,0.48302e-04,0.47418e-04,0.47262e-04,0.47732e-04 /)
      kbo(:,19, 3) = (/ &
        & 0.42101e-04,0.40906e-04,0.40541e-04,0.40229e-04,0.40671e-04 /)
      kbo(:,20, 3) = (/ &
        & 0.35046e-04,0.34193e-04,0.34032e-04,0.33881e-04,0.34691e-04 /)
      kbo(:,21, 3) = (/ &
        & 0.29192e-04,0.28813e-04,0.28525e-04,0.28485e-04,0.29764e-04 /)
      kbo(:,22, 3) = (/ &
        & 0.24212e-04,0.23970e-04,0.23804e-04,0.23947e-04,0.24310e-04 /)
      kbo(:,23, 3) = (/ &
        & 0.20167e-04,0.19961e-04,0.19837e-04,0.20528e-04,0.19887e-04 /)
      kbo(:,24, 3) = (/ &
        & 0.16817e-04,0.16624e-04,0.16525e-04,0.17263e-04,0.16481e-04 /)
      kbo(:,25, 3) = (/ &
        & 0.13896e-04,0.13806e-04,0.13810e-04,0.14348e-04,0.13634e-04 /)
      kbo(:,26, 3) = (/ &
        & 0.11515e-04,0.11474e-04,0.11553e-04,0.11705e-04,0.11167e-04 /)
      kbo(:,27, 3) = (/ &
        & 0.95004e-05,0.94543e-05,0.95650e-05,0.95316e-05,0.91651e-05 /)
      kbo(:,28, 3) = (/ &
        & 0.78135e-05,0.77862e-05,0.78715e-05,0.77825e-05,0.74877e-05 /)
      kbo(:,29, 3) = (/ &
        & 0.63615e-05,0.63601e-05,0.64198e-05,0.63507e-05,0.61200e-05 /)
      kbo(:,30, 3) = (/ &
        & 0.51738e-05,0.51781e-05,0.52250e-05,0.51709e-05,0.50243e-05 /)
      kbo(:,31, 3) = (/ &
        & 0.41825e-05,0.42240e-05,0.42510e-05,0.42241e-05,0.41058e-05 /)
      kbo(:,32, 3) = (/ &
        & 0.34024e-05,0.34302e-05,0.34514e-05,0.34436e-05,0.33474e-05 /)
      kbo(:,33, 3) = (/ &
        & 0.27510e-05,0.27828e-05,0.28059e-05,0.28125e-05,0.27394e-05 /)
      kbo(:,34, 3) = (/ &
        & 0.22195e-05,0.22517e-05,0.22743e-05,0.22728e-05,0.22254e-05 /)
      kbo(:,35, 3) = (/ &
        & 0.18029e-05,0.18238e-05,0.18432e-05,0.18461e-05,0.18241e-05 /)
      kbo(:,36, 3) = (/ &
        & 0.14477e-05,0.14734e-05,0.14936e-05,0.15116e-05,0.14874e-05 /)
      kbo(:,37, 3) = (/ &
        & 0.11637e-05,0.11929e-05,0.12098e-05,0.12265e-05,0.12076e-05 /)
      kbo(:,38, 3) = (/ &
        & 0.93292e-06,0.96246e-06,0.98169e-06,0.99435e-06,0.98749e-06 /)
      kbo(:,39, 3) = (/ &
        & 0.74927e-06,0.76742e-06,0.79020e-06,0.80604e-06,0.81415e-06 /)
      kbo(:,40, 3) = (/ &
        & 0.60479e-06,0.61743e-06,0.63973e-06,0.65295e-06,0.66261e-06 /)
      kbo(:,41, 3) = (/ &
        & 0.48450e-06,0.49742e-06,0.51366e-06,0.52876e-06,0.53813e-06 /)
      kbo(:,42, 3) = (/ &
        & 0.38298e-06,0.40088e-06,0.41192e-06,0.42651e-06,0.43595e-06 /)
      kbo(:,43, 3) = (/ &
        & 0.30310e-06,0.31905e-06,0.32907e-06,0.34154e-06,0.35007e-06 /)
      kbo(:,44, 3) = (/ &
        & 0.23745e-06,0.25035e-06,0.26224e-06,0.27145e-06,0.28146e-06 /)
      kbo(:,45, 3) = (/ &
        & 0.18653e-06,0.19510e-06,0.20644e-06,0.21510e-06,0.22354e-06 /)
      kbo(:,46, 3) = (/ &
        & 0.14759e-06,0.15322e-06,0.16145e-06,0.17034e-06,0.17744e-06 /)
      kbo(:,47, 3) = (/ &
        & 0.11410e-06,0.12007e-06,0.12507e-06,0.13237e-06,0.13995e-06 /)
      kbo(:,48, 3) = (/ &
        & 0.88327e-07,0.93967e-07,0.97683e-07,0.10257e-06,0.10921e-06 /)
      kbo(:,49, 3) = (/ &
        & 0.66715e-07,0.72172e-07,0.76442e-07,0.79214e-07,0.84006e-07 /)
      kbo(:,50, 3) = (/ &
        & 0.51458e-07,0.55761e-07,0.59239e-07,0.62292e-07,0.64470e-07 /)
      kbo(:,51, 3) = (/ &
        & 0.39957e-07,0.42400e-07,0.45870e-07,0.48592e-07,0.50287e-07 /)
      kbo(:,52, 3) = (/ &
        & 0.31150e-07,0.32725e-07,0.35598e-07,0.37633e-07,0.39607e-07 /)
      kbo(:,53, 3) = (/ &
        & 0.23783e-07,0.25415e-07,0.26634e-07,0.28885e-07,0.30620e-07 /)
      kbo(:,54, 3) = (/ &
        & 0.18531e-07,0.19938e-07,0.20988e-07,0.22678e-07,0.23867e-07 /)
      kbo(:,55, 3) = (/ &
        & 0.14810e-07,0.15772e-07,0.16651e-07,0.17727e-07,0.18861e-07 /)
      kbo(:,56, 3) = (/ &
        & 0.11652e-07,0.12557e-07,0.13319e-07,0.13930e-07,0.15077e-07 /)
      kbo(:,57, 3) = (/ &
        & 0.91523e-08,0.99835e-08,0.10603e-07,0.11081e-07,0.11999e-07 /)
      kbo(:,58, 3) = (/ &
        & 0.72383e-08,0.79060e-08,0.84489e-08,0.88615e-08,0.94456e-08 /)
      kbo(:,59, 3) = (/ &
        & 0.60315e-08,0.65931e-08,0.71001e-08,0.74012e-08,0.78761e-08 /)
      kbo(:,13, 4) = (/ &
        & 0.21882e-03,0.20968e-03,0.18648e-03,0.17505e-03,0.17320e-03 /)
      kbo(:,14, 4) = (/ &
        & 0.19140e-03,0.17026e-03,0.15903e-03,0.15552e-03,0.16009e-03 /)
      kbo(:,15, 4) = (/ &
        & 0.16003e-03,0.14531e-03,0.14007e-03,0.14511e-03,0.14619e-03 /)
      kbo(:,16, 4) = (/ &
        & 0.13387e-03,0.12423e-03,0.12444e-03,0.12743e-03,0.12749e-03 /)
      kbo(:,17, 4) = (/ &
        & 0.11266e-03,0.10780e-03,0.11110e-03,0.11051e-03,0.11075e-03 /)
      kbo(:,18, 4) = (/ &
        & 0.96156e-04,0.95617e-04,0.96775e-04,0.96220e-04,0.96078e-04 /)
      kbo(:,19, 4) = (/ &
        & 0.82712e-04,0.82946e-04,0.83265e-04,0.82827e-04,0.82044e-04 /)
      kbo(:,20, 4) = (/ &
        & 0.71080e-04,0.71167e-04,0.71040e-04,0.70443e-04,0.69069e-04 /)
      kbo(:,21, 4) = (/ &
        & 0.60110e-04,0.60836e-04,0.59994e-04,0.58992e-04,0.57237e-04 /)
      kbo(:,22, 4) = (/ &
        & 0.50688e-04,0.51296e-04,0.50271e-04,0.48889e-04,0.48471e-04 /)
      kbo(:,23, 4) = (/ &
        & 0.42706e-04,0.42628e-04,0.41764e-04,0.39999e-04,0.40893e-04 /)
      kbo(:,24, 4) = (/ &
        & 0.35803e-04,0.35316e-04,0.34535e-04,0.33229e-04,0.34127e-04 /)
      kbo(:,25, 4) = (/ &
        & 0.29906e-04,0.29201e-04,0.28336e-04,0.27455e-04,0.28044e-04 /)
      kbo(:,26, 4) = (/ &
        & 0.24659e-04,0.23926e-04,0.23159e-04,0.22827e-04,0.23266e-04 /)
      kbo(:,27, 4) = (/ &
        & 0.20221e-04,0.19578e-04,0.18838e-04,0.18853e-04,0.19067e-04 /)
      kbo(:,28, 4) = (/ &
        & 0.16345e-04,0.15913e-04,0.15327e-04,0.15412e-04,0.15560e-04 /)
      kbo(:,29, 4) = (/ &
        & 0.13195e-04,0.12870e-04,0.12430e-04,0.12518e-04,0.12639e-04 /)
      kbo(:,30, 4) = (/ &
        & 0.10622e-04,0.10384e-04,0.10068e-04,0.10151e-04,0.10256e-04 /)
      kbo(:,31, 4) = (/ &
        & 0.85785e-05,0.83523e-05,0.81227e-05,0.81998e-05,0.83313e-05 /)
      kbo(:,32, 4) = (/ &
        & 0.69114e-05,0.67093e-05,0.65758e-05,0.66222e-05,0.67679e-05 /)
      kbo(:,33, 4) = (/ &
        & 0.55456e-05,0.54342e-05,0.53229e-05,0.53610e-05,0.54819e-05 /)
      kbo(:,34, 4) = (/ &
        & 0.44461e-05,0.43891e-05,0.43112e-05,0.43632e-05,0.44560e-05 /)
      kbo(:,35, 4) = (/ &
        & 0.35725e-05,0.35192e-05,0.34703e-05,0.35075e-05,0.35919e-05 /)
      kbo(:,36, 4) = (/ &
        & 0.28842e-05,0.28362e-05,0.28143e-05,0.28097e-05,0.29057e-05 /)
      kbo(:,37, 4) = (/ &
        & 0.23374e-05,0.22987e-05,0.22934e-05,0.22812e-05,0.23451e-05 /)
      kbo(:,38, 4) = (/ &
        & 0.18966e-05,0.18679e-05,0.18613e-05,0.18437e-05,0.18894e-05 /)
      kbo(:,39, 4) = (/ &
        & 0.15300e-05,0.15180e-05,0.15096e-05,0.14915e-05,0.15107e-05 /)
      kbo(:,40, 4) = (/ &
        & 0.12426e-05,0.12357e-05,0.12171e-05,0.12170e-05,0.12227e-05 /)
      kbo(:,41, 4) = (/ &
        & 0.10102e-05,0.10077e-05,0.98593e-06,0.98478e-06,0.99213e-06 /)
      kbo(:,42, 4) = (/ &
        & 0.82201e-06,0.81050e-06,0.80313e-06,0.80181e-06,0.80361e-06 /)
      kbo(:,43, 4) = (/ &
        & 0.67318e-06,0.65347e-06,0.65478e-06,0.64360e-06,0.64722e-06 /)
      kbo(:,44, 4) = (/ &
        & 0.55598e-06,0.53355e-06,0.52778e-06,0.52097e-06,0.51997e-06 /)
      kbo(:,45, 4) = (/ &
        & 0.46157e-06,0.43457e-06,0.42412e-06,0.42137e-06,0.41750e-06 /)
      kbo(:,46, 4) = (/ &
        & 0.39156e-06,0.35690e-06,0.34498e-06,0.33995e-06,0.33614e-06 /)
      kbo(:,47, 4) = (/ &
        & 0.33392e-06,0.29746e-06,0.28074e-06,0.27344e-06,0.27079e-06 /)
      kbo(:,48, 4) = (/ &
        & 0.27066e-06,0.25369e-06,0.23115e-06,0.22213e-06,0.21766e-06 /)
      kbo(:,49, 4) = (/ &
        & 0.22198e-06,0.21395e-06,0.19274e-06,0.18040e-06,0.17542e-06 /)
      kbo(:,50, 4) = (/ &
        & 0.18070e-06,0.17367e-06,0.16473e-06,0.14916e-06,0.14306e-06 /)
      kbo(:,51, 4) = (/ &
        & 0.14595e-06,0.14287e-06,0.13847e-06,0.12418e-06,0.11697e-06 /)
      kbo(:,52, 4) = (/ &
        & 0.11819e-06,0.11588e-06,0.11225e-06,0.10604e-06,0.96269e-07 /)
      kbo(:,53, 4) = (/ &
        & 0.95028e-07,0.93094e-07,0.91303e-07,0.88900e-07,0.80262e-07 /)
      kbo(:,54, 4) = (/ &
        & 0.77005e-07,0.76238e-07,0.74228e-07,0.72526e-07,0.67965e-07 /)
      kbo(:,55, 4) = (/ &
        & 0.62979e-07,0.62692e-07,0.60930e-07,0.59579e-07,0.57700e-07 /)
      kbo(:,56, 4) = (/ &
        & 0.51571e-07,0.51196e-07,0.50031e-07,0.48916e-07,0.48127e-07 /)
      kbo(:,57, 4) = (/ &
        & 0.42602e-07,0.41678e-07,0.41006e-07,0.39709e-07,0.39283e-07 /)
      kbo(:,58, 4) = (/ &
        & 0.35155e-07,0.34052e-07,0.33561e-07,0.32395e-07,0.32057e-07 /)
      kbo(:,59, 4) = (/ &
        & 0.29318e-07,0.28516e-07,0.28097e-07,0.26888e-07,0.26840e-07 /)
      kbo(:,13, 5) = (/ &
        & 0.43718e-03,0.42279e-03,0.43200e-03,0.42910e-03,0.42775e-03 /)
      kbo(:,14, 5) = (/ &
        & 0.37902e-03,0.38090e-03,0.38058e-03,0.37637e-03,0.36798e-03 /)
      kbo(:,15, 5) = (/ &
        & 0.33222e-03,0.33597e-03,0.33205e-03,0.32000e-03,0.31310e-03 /)
      kbo(:,16, 5) = (/ &
        & 0.28736e-03,0.28700e-03,0.27853e-03,0.26891e-03,0.26391e-03 /)
      kbo(:,17, 5) = (/ &
        & 0.24534e-03,0.24098e-03,0.23072e-03,0.22519e-03,0.22013e-03 /)
      kbo(:,18, 5) = (/ &
        & 0.20645e-03,0.20019e-03,0.19266e-03,0.18716e-03,0.18139e-03 /)
      kbo(:,19, 5) = (/ &
        & 0.17271e-03,0.16642e-03,0.16064e-03,0.15556e-03,0.14951e-03 /)
      kbo(:,20, 5) = (/ &
        & 0.14266e-03,0.13766e-03,0.13239e-03,0.12767e-03,0.12305e-03 /)
      kbo(:,21, 5) = (/ &
        & 0.11797e-03,0.11256e-03,0.10880e-03,0.10424e-03,0.10062e-03 /)
      kbo(:,22, 5) = (/ &
        & 0.97085e-04,0.92101e-04,0.88420e-04,0.85535e-04,0.82201e-04 /)
      kbo(:,23, 5) = (/ &
        & 0.79380e-04,0.75312e-04,0.72177e-04,0.69710e-04,0.66966e-04 /)
      kbo(:,24, 5) = (/ &
        & 0.64591e-04,0.61520e-04,0.58891e-04,0.56626e-04,0.54603e-04 /)
      kbo(:,25, 5) = (/ &
        & 0.52423e-04,0.49934e-04,0.48122e-04,0.46331e-04,0.44875e-04 /)
      kbo(:,26, 5) = (/ &
        & 0.42528e-04,0.40739e-04,0.39218e-04,0.37806e-04,0.36631e-04 /)
      kbo(:,27, 5) = (/ &
        & 0.34453e-04,0.33104e-04,0.32009e-04,0.30764e-04,0.30000e-04 /)
      kbo(:,28, 5) = (/ &
        & 0.28076e-04,0.26948e-04,0.26097e-04,0.25065e-04,0.24596e-04 /)
      kbo(:,29, 5) = (/ &
        & 0.22814e-04,0.21902e-04,0.21222e-04,0.20350e-04,0.20152e-04 /)
      kbo(:,30, 5) = (/ &
        & 0.18551e-04,0.17731e-04,0.17162e-04,0.16614e-04,0.16461e-04 /)
      kbo(:,31, 5) = (/ &
        & 0.15020e-04,0.14383e-04,0.13922e-04,0.13548e-04,0.13388e-04 /)
      kbo(:,32, 5) = (/ &
        & 0.12091e-04,0.11653e-04,0.11308e-04,0.11033e-04,0.10954e-04 /)
      kbo(:,33, 5) = (/ &
        & 0.97901e-05,0.93570e-05,0.91428e-05,0.89594e-05,0.89614e-05 /)
      kbo(:,34, 5) = (/ &
        & 0.79439e-05,0.76095e-05,0.74365e-05,0.73099e-05,0.73269e-05 /)
      kbo(:,35, 5) = (/ &
        & 0.64505e-05,0.62326e-05,0.60921e-05,0.59939e-05,0.59799e-05 /)
      kbo(:,36, 5) = (/ &
        & 0.52745e-05,0.51017e-05,0.49658e-05,0.48988e-05,0.48773e-05 /)
      kbo(:,37, 5) = (/ &
        & 0.43522e-05,0.42053e-05,0.40681e-05,0.40176e-05,0.40058e-05 /)
      kbo(:,38, 5) = (/ &
        & 0.35676e-05,0.34559e-05,0.33446e-05,0.33017e-05,0.32771e-05 /)
      kbo(:,39, 5) = (/ &
        & 0.29238e-05,0.28445e-05,0.27512e-05,0.27095e-05,0.26825e-05 /)
      kbo(:,40, 5) = (/ &
        & 0.23985e-05,0.23437e-05,0.22756e-05,0.22251e-05,0.22009e-05 /)
      kbo(:,41, 5) = (/ &
        & 0.19763e-05,0.19311e-05,0.18886e-05,0.18370e-05,0.18072e-05 /)
      kbo(:,42, 5) = (/ &
        & 0.16256e-05,0.15918e-05,0.15558e-05,0.15108e-05,0.14861e-05 /)
      kbo(:,43, 5) = (/ &
        & 0.13290e-05,0.13116e-05,0.12833e-05,0.12550e-05,0.12262e-05 /)
      kbo(:,44, 5) = (/ &
        & 0.10777e-05,0.10760e-05,0.10566e-05,0.10365e-05,0.10136e-05 /)
      kbo(:,45, 5) = (/ &
        & 0.86690e-06,0.87981e-06,0.87044e-06,0.85428e-06,0.83627e-06 /)
      kbo(:,46, 5) = (/ &
        & 0.68706e-06,0.71088e-06,0.70939e-06,0.70110e-06,0.69032e-06 /)
      kbo(:,47, 5) = (/ &
        & 0.54665e-06,0.56934e-06,0.58033e-06,0.57830e-06,0.57105e-06 /)
      kbo(:,48, 5) = (/ &
        & 0.44874e-06,0.44653e-06,0.46650e-06,0.47090e-06,0.46732e-06 /)
      kbo(:,49, 5) = (/ &
        & 0.36869e-06,0.35456e-06,0.36842e-06,0.37978e-06,0.38217e-06 /)
      kbo(:,50, 5) = (/ &
        & 0.30489e-06,0.29229e-06,0.29104e-06,0.30430e-06,0.31068e-06 /)
      kbo(:,51, 5) = (/ &
        & 0.25290e-06,0.24012e-06,0.23271e-06,0.24366e-06,0.25149e-06 /)
      kbo(:,52, 5) = (/ &
        & 0.21148e-06,0.19715e-06,0.19121e-06,0.19177e-06,0.20148e-06 /)
      kbo(:,53, 5) = (/ &
        & 0.17334e-06,0.16335e-06,0.15574e-06,0.15266e-06,0.15921e-06 /)
      kbo(:,54, 5) = (/ &
        & 0.14189e-06,0.13650e-06,0.12781e-06,0.12535e-06,0.12749e-06 /)
      kbo(:,55, 5) = (/ &
        & 0.11763e-06,0.11398e-06,0.10627e-06,0.10373e-06,0.10268e-06 /)
      kbo(:,56, 5) = (/ &
        & 0.98316e-07,0.94892e-07,0.88799e-07,0.85036e-07,0.83393e-07 /)
      kbo(:,57, 5) = (/ &
        & 0.83049e-07,0.78499e-07,0.74140e-07,0.70137e-07,0.68774e-07 /)
      kbo(:,58, 5) = (/ &
        & 0.71768e-07,0.64682e-07,0.62012e-07,0.58149e-07,0.57037e-07 /)
      kbo(:,59, 5) = (/ &
        & 0.60166e-07,0.54824e-07,0.52042e-07,0.49198e-07,0.47862e-07 /)
      kbo(:,13, 6) = (/ &
        & 0.71254e-03,0.65708e-03,0.60824e-03,0.57965e-03,0.55389e-03 /)
      kbo(:,14, 6) = (/ &
        & 0.58852e-03,0.54811e-03,0.51125e-03,0.48557e-03,0.47730e-03 /)
      kbo(:,15, 6) = (/ &
        & 0.50599e-03,0.46869e-03,0.44362e-03,0.43503e-03,0.43705e-03 /)
      kbo(:,16, 6) = (/ &
        & 0.43493e-03,0.40996e-03,0.39680e-03,0.39623e-03,0.40784e-03 /)
      kbo(:,17, 6) = (/ &
        & 0.38028e-03,0.36175e-03,0.35696e-03,0.36547e-03,0.38127e-03 /)
      kbo(:,18, 6) = (/ &
        & 0.33113e-03,0.32205e-03,0.32458e-03,0.33502e-03,0.35577e-03 /)
      kbo(:,19, 6) = (/ &
        & 0.28886e-03,0.29134e-03,0.29799e-03,0.31134e-03,0.33676e-03 /)
      kbo(:,20, 6) = (/ &
        & 0.25113e-03,0.25555e-03,0.26535e-03,0.28470e-03,0.30677e-03 /)
      kbo(:,21, 6) = (/ &
        & 0.21640e-03,0.22152e-03,0.23323e-03,0.25467e-03,0.27764e-03 /)
      kbo(:,22, 6) = (/ &
        & 0.18601e-03,0.19217e-03,0.20696e-03,0.22593e-03,0.24729e-03 /)
      kbo(:,23, 6) = (/ &
        & 0.15978e-03,0.16833e-03,0.18229e-03,0.19994e-03,0.21913e-03 /)
      kbo(:,24, 6) = (/ &
        & 0.13748e-03,0.14696e-03,0.16025e-03,0.17620e-03,0.19459e-03 /)
      kbo(:,25, 6) = (/ &
        & 0.11841e-03,0.12828e-03,0.13998e-03,0.15487e-03,0.17174e-03 /)
      kbo(:,26, 6) = (/ &
        & 0.10209e-03,0.11175e-03,0.12193e-03,0.13590e-03,0.15125e-03 /)
      kbo(:,27, 6) = (/ &
        & 0.87003e-04,0.95681e-04,0.10499e-03,0.11744e-03,0.13086e-03 /)
      kbo(:,28, 6) = (/ &
        & 0.73110e-04,0.80653e-04,0.89103e-04,0.99988e-04,0.11120e-03 /)
      kbo(:,29, 6) = (/ &
        & 0.60620e-04,0.66736e-04,0.74222e-04,0.82863e-04,0.92471e-04 /)
      kbo(:,30, 6) = (/ &
        & 0.49831e-04,0.54602e-04,0.61288e-04,0.68281e-04,0.75599e-04 /)
      kbo(:,31, 6) = (/ &
        & 0.40315e-04,0.44435e-04,0.49703e-04,0.55140e-04,0.60140e-04 /)
      kbo(:,32, 6) = (/ &
        & 0.32490e-04,0.36020e-04,0.39894e-04,0.44068e-04,0.48080e-04 /)
      kbo(:,33, 6) = (/ &
        & 0.26085e-04,0.29063e-04,0.32003e-04,0.35074e-04,0.38662e-04 /)
      kbo(:,34, 6) = (/ &
        & 0.21201e-04,0.23256e-04,0.25636e-04,0.28140e-04,0.31273e-04 /)
      kbo(:,35, 6) = (/ &
        & 0.17022e-04,0.18534e-04,0.20322e-04,0.22464e-04,0.25109e-04 /)
      kbo(:,36, 6) = (/ &
        & 0.13427e-04,0.14606e-04,0.16055e-04,0.17783e-04,0.19877e-04 /)
      kbo(:,37, 6) = (/ &
        & 0.10630e-04,0.11559e-04,0.12731e-04,0.14118e-04,0.15831e-04 /)
      kbo(:,38, 6) = (/ &
        & 0.84365e-05,0.91300e-05,0.10077e-04,0.11171e-04,0.12568e-04 /)
      kbo(:,39, 6) = (/ &
        & 0.66762e-05,0.71770e-05,0.79359e-05,0.88044e-05,0.99043e-05 /)
      kbo(:,40, 6) = (/ &
        & 0.53561e-05,0.57216e-05,0.63210e-05,0.70080e-05,0.79213e-05 /)
      kbo(:,41, 6) = (/ &
        & 0.42954e-05,0.45692e-05,0.50356e-05,0.56102e-05,0.63394e-05 /)
      kbo(:,42, 6) = (/ &
        & 0.34409e-05,0.36788e-05,0.40124e-05,0.44898e-05,0.50645e-05 /)
      kbo(:,43, 6) = (/ &
        & 0.27453e-05,0.29361e-05,0.31651e-05,0.35498e-05,0.40058e-05 /)
      kbo(:,44, 6) = (/ &
        & 0.21863e-05,0.23320e-05,0.24965e-05,0.27915e-05,0.31593e-05 /)
      kbo(:,45, 6) = (/ &
        & 0.17409e-05,0.18472e-05,0.19801e-05,0.21812e-05,0.24741e-05 /)
      kbo(:,46, 6) = (/ &
        & 0.13903e-05,0.14639e-05,0.15660e-05,0.17042e-05,0.19243e-05 /)
      kbo(:,47, 6) = (/ &
        & 0.11229e-05,0.11661e-05,0.12377e-05,0.13335e-05,0.14898e-05 /)
      kbo(:,48, 6) = (/ &
        & 0.90528e-06,0.92962e-06,0.97799e-06,0.10483e-05,0.11575e-05 /)
      kbo(:,49, 6) = (/ &
        & 0.72877e-06,0.74278e-06,0.77380e-06,0.82564e-06,0.89736e-06 /)
      kbo(:,50, 6) = (/ &
        & 0.59358e-06,0.59955e-06,0.62170e-06,0.65720e-06,0.70771e-06 /)
      kbo(:,51, 6) = (/ &
        & 0.48783e-06,0.48769e-06,0.50300e-06,0.52655e-06,0.56377e-06 /)
      kbo(:,52, 6) = (/ &
        & 0.39834e-06,0.39922e-06,0.40604e-06,0.42316e-06,0.45057e-06 /)
      kbo(:,53, 6) = (/ &
        & 0.33019e-06,0.32505e-06,0.33011e-06,0.33917e-06,0.35858e-06 /)
      kbo(:,54, 6) = (/ &
        & 0.27829e-06,0.26763e-06,0.27219e-06,0.27714e-06,0.29159e-06 /)
      kbo(:,55, 6) = (/ &
        & 0.23259e-06,0.22250e-06,0.22510e-06,0.22855e-06,0.23937e-06 /)
      kbo(:,56, 6) = (/ &
        & 0.19401e-06,0.18605e-06,0.18566e-06,0.18937e-06,0.19605e-06 /)
      kbo(:,57, 6) = (/ &
        & 0.15908e-06,0.15649e-06,0.15396e-06,0.15754e-06,0.16039e-06 /)
      kbo(:,58, 6) = (/ &
        & 0.12892e-06,0.13132e-06,0.12793e-06,0.13093e-06,0.13273e-06 /)
      kbo(:,59, 6) = (/ &
        & 0.11177e-06,0.11165e-06,0.10875e-06,0.11132e-06,0.11431e-06 /)
      kbo(:,13, 7) = (/ &
        & 0.19357e-02,0.20341e-02,0.21760e-02,0.22982e-02,0.24550e-02 /)
      kbo(:,14, 7) = (/ &
        & 0.20343e-02,0.21709e-02,0.23192e-02,0.24854e-02,0.27026e-02 /)
      kbo(:,15, 7) = (/ &
        & 0.21108e-02,0.23009e-02,0.25488e-02,0.28048e-02,0.30159e-02 /)
      kbo(:,16, 7) = (/ &
        & 0.21016e-02,0.23581e-02,0.25958e-02,0.28093e-02,0.29839e-02 /)
      kbo(:,17, 7) = (/ &
        & 0.21350e-02,0.23722e-02,0.25718e-02,0.27703e-02,0.30036e-02 /)
      kbo(:,18, 7) = (/ &
        & 0.21493e-02,0.23550e-02,0.25593e-02,0.27827e-02,0.29722e-02 /)
      kbo(:,19, 7) = (/ &
        & 0.21677e-02,0.23602e-02,0.25446e-02,0.27267e-02,0.29542e-02 /)
      kbo(:,20, 7) = (/ &
        & 0.21009e-02,0.22669e-02,0.24261e-02,0.26095e-02,0.28436e-02 /)
      kbo(:,21, 7) = (/ &
        & 0.19811e-02,0.21249e-02,0.22790e-02,0.24716e-02,0.26844e-02 /)
      kbo(:,22, 7) = (/ &
        & 0.18393e-02,0.19585e-02,0.21127e-02,0.22962e-02,0.25211e-02 /)
      kbo(:,23, 7) = (/ &
        & 0.16905e-02,0.18032e-02,0.19594e-02,0.21280e-02,0.23466e-02 /)
      kbo(:,24, 7) = (/ &
        & 0.15327e-02,0.16542e-02,0.18047e-02,0.19642e-02,0.21591e-02 /)
      kbo(:,25, 7) = (/ &
        & 0.13831e-02,0.14932e-02,0.16391e-02,0.17921e-02,0.19606e-02 /)
      kbo(:,26, 7) = (/ &
        & 0.12298e-02,0.13325e-02,0.14676e-02,0.16086e-02,0.17628e-02 /)
      kbo(:,27, 7) = (/ &
        & 0.10692e-02,0.11652e-02,0.12858e-02,0.14124e-02,0.15514e-02 /)
      kbo(:,28, 7) = (/ &
        & 0.91706e-03,0.10034e-02,0.11100e-02,0.12231e-02,0.13481e-02 /)
      kbo(:,29, 7) = (/ &
        & 0.76824e-03,0.84492e-03,0.93654e-03,0.10377e-02,0.11448e-02 /)
      kbo(:,30, 7) = (/ &
        & 0.63841e-03,0.70573e-03,0.78553e-03,0.87197e-03,0.96607e-03 /)
      kbo(:,31, 7) = (/ &
        & 0.51979e-03,0.58056e-03,0.64728e-03,0.71891e-03,0.80875e-03 /)
      kbo(:,32, 7) = (/ &
        & 0.42659e-03,0.47686e-03,0.53347e-03,0.60016e-03,0.67592e-03 /)
      kbo(:,33, 7) = (/ &
        & 0.34820e-03,0.39030e-03,0.44004e-03,0.49875e-03,0.56492e-03 /)
      kbo(:,34, 7) = (/ &
        & 0.28753e-03,0.32477e-03,0.36831e-03,0.41989e-03,0.47708e-03 /)
      kbo(:,35, 7) = (/ &
        & 0.23568e-03,0.26716e-03,0.30618e-03,0.35062e-03,0.39934e-03 /)
      kbo(:,36, 7) = (/ &
        & 0.19116e-03,0.21863e-03,0.25180e-03,0.28983e-03,0.33082e-03 /)
      kbo(:,37, 7) = (/ &
        & 0.15437e-03,0.17829e-03,0.20646e-03,0.23900e-03,0.27320e-03 /)
      kbo(:,38, 7) = (/ &
        & 0.12397e-03,0.14462e-03,0.16847e-03,0.19621e-03,0.22528e-03 /)
      kbo(:,39, 7) = (/ &
        & 0.98930e-04,0.11647e-03,0.13711e-03,0.16057e-03,0.18549e-03 /)
      kbo(:,40, 7) = (/ &
        & 0.79845e-04,0.94437e-04,0.11202e-03,0.13217e-03,0.15346e-03 /)
      kbo(:,41, 7) = (/ &
        & 0.64260e-04,0.76439e-04,0.91253e-04,0.10837e-03,0.12691e-03 /)
      kbo(:,42, 7) = (/ &
        & 0.51561e-04,0.61686e-04,0.74044e-04,0.88504e-04,0.10431e-03 /)
      kbo(:,43, 7) = (/ &
        & 0.40906e-04,0.49267e-04,0.59361e-04,0.71417e-04,0.84751e-04 /)
      kbo(:,44, 7) = (/ &
        & 0.32247e-04,0.38955e-04,0.47246e-04,0.57199e-04,0.68540e-04 /)
      kbo(:,45, 7) = (/ &
        & 0.25243e-04,0.30790e-04,0.37490e-04,0.45754e-04,0.55394e-04 /)
      kbo(:,46, 7) = (/ &
        & 0.19604e-04,0.24131e-04,0.29598e-04,0.36431e-04,0.44419e-04 /)
      kbo(:,47, 7) = (/ &
        & 0.15116e-04,0.18785e-04,0.23180e-04,0.28780e-04,0.35381e-04 /)
      kbo(:,48, 7) = (/ &
        & 0.11550e-04,0.14451e-04,0.18039e-04,0.22545e-04,0.28005e-04 /)
      kbo(:,49, 7) = (/ &
        & 0.87452e-05,0.10992e-04,0.13863e-04,0.17498e-04,0.21949e-04 /)
      kbo(:,50, 7) = (/ &
        & 0.66768e-05,0.84974e-05,0.10835e-04,0.13777e-04,0.17448e-04 /)
      kbo(:,51, 7) = (/ &
        & 0.51359e-05,0.66277e-05,0.85196e-05,0.10905e-04,0.13933e-04 /)
      kbo(:,52, 7) = (/ &
        & 0.38737e-05,0.51001e-05,0.66347e-05,0.85842e-05,0.11033e-04 /)
      kbo(:,53, 7) = (/ &
        & 0.28793e-05,0.38820e-05,0.50987e-05,0.66800e-05,0.86846e-05 /)
      kbo(:,54, 7) = (/ &
        & 0.22250e-05,0.30528e-05,0.40721e-05,0.53813e-05,0.70529e-05 /)
      kbo(:,55, 7) = (/ &
        & 0.17548e-05,0.24455e-05,0.32962e-05,0.43877e-05,0.58071e-05 /)
      kbo(:,56, 7) = (/ &
        & 0.13740e-05,0.19413e-05,0.26523e-05,0.35566e-05,0.47512e-05 /)
      kbo(:,57, 7) = (/ &
        & 0.10745e-05,0.15242e-05,0.21190e-05,0.28679e-05,0.38612e-05 /)
      kbo(:,58, 7) = (/ &
        & 0.84271e-06,0.12117e-05,0.17039e-05,0.23246e-05,0.31564e-05 /)
      kbo(:,59, 7) = (/ &
        & 0.75625e-06,0.11002e-05,0.15376e-05,0.20855e-05,0.28548e-05 /)
      kbo(:,13, 8) = (/ &
        & 0.41133e-01,0.43585e-01,0.46448e-01,0.50156e-01,0.54607e-01 /)
      kbo(:,14, 8) = (/ &
        & 0.39162e-01,0.41636e-01,0.44649e-01,0.48118e-01,0.52078e-01 /)
      kbo(:,15, 8) = (/ &
        & 0.37770e-01,0.40048e-01,0.43090e-01,0.46524e-01,0.50698e-01 /)
      kbo(:,16, 8) = (/ &
        & 0.35235e-01,0.37712e-01,0.40429e-01,0.44092e-01,0.48470e-01 /)
      kbo(:,17, 8) = (/ &
        & 0.32748e-01,0.35232e-01,0.38049e-01,0.41536e-01,0.45596e-01 /)
      kbo(:,18, 8) = (/ &
        & 0.30656e-01,0.33078e-01,0.36084e-01,0.39403e-01,0.43319e-01 /)
      kbo(:,19, 8) = (/ &
        & 0.28887e-01,0.31462e-01,0.34348e-01,0.37660e-01,0.41532e-01 /)
      kbo(:,20, 8) = (/ &
        & 0.26521e-01,0.29153e-01,0.32006e-01,0.35368e-01,0.39083e-01 /)
      kbo(:,21, 8) = (/ &
        & 0.23988e-01,0.26537e-01,0.29508e-01,0.32666e-01,0.36356e-01 /)
      kbo(:,22, 8) = (/ &
        & 0.21655e-01,0.24205e-01,0.27193e-01,0.30346e-01,0.33820e-01 /)
      kbo(:,23, 8) = (/ &
        & 0.19724e-01,0.22257e-01,0.25021e-01,0.27997e-01,0.31309e-01 /)
      kbo(:,24, 8) = (/ &
        & 0.18094e-01,0.20464e-01,0.23167e-01,0.26069e-01,0.29357e-01 /)
      kbo(:,25, 8) = (/ &
        & 0.16666e-01,0.18896e-01,0.21422e-01,0.24282e-01,0.27401e-01 /)
      kbo(:,26, 8) = (/ &
        & 0.15252e-01,0.17451e-01,0.19828e-01,0.22565e-01,0.25604e-01 /)
      kbo(:,27, 8) = (/ &
        & 0.13902e-01,0.15940e-01,0.18143e-01,0.20720e-01,0.23727e-01 /)
      kbo(:,28, 8) = (/ &
        & 0.12642e-01,0.14401e-01,0.16467e-01,0.18975e-01,0.21740e-01 /)
      kbo(:,29, 8) = (/ &
        & 0.11177e-01,0.12765e-01,0.14750e-01,0.16957e-01,0.19575e-01 /)
      kbo(:,30, 8) = (/ &
        & 0.97810e-02,0.11281e-01,0.13066e-01,0.15112e-01,0.17581e-01 /)
      kbo(:,31, 8) = (/ &
        & 0.84562e-02,0.98553e-02,0.11427e-01,0.13312e-01,0.15536e-01 /)
      kbo(:,32, 8) = (/ &
        & 0.73434e-02,0.85939e-02,0.10020e-01,0.11770e-01,0.13758e-01 /)
      kbo(:,33, 8) = (/ &
        & 0.63801e-02,0.74957e-02,0.87874e-02,0.10375e-01,0.12145e-01 /)
      kbo(:,34, 8) = (/ &
        & 0.56002e-02,0.65926e-02,0.77964e-02,0.92186e-02,0.10768e-01 /)
      kbo(:,35, 8) = (/ &
        & 0.48489e-02,0.57164e-02,0.68333e-02,0.80886e-02,0.94500e-02 /)
      kbo(:,36, 8) = (/ &
        & 0.41428e-02,0.49220e-02,0.58884e-02,0.69905e-02,0.81862e-02 /)
      kbo(:,37, 8) = (/ &
        & 0.34967e-02,0.41841e-02,0.50244e-02,0.59657e-02,0.70167e-02 /)
      kbo(:,38, 8) = (/ &
        & 0.29333e-02,0.35364e-02,0.42644e-02,0.50719e-02,0.59938e-02 /)
      kbo(:,39, 8) = (/ &
        & 0.24443e-02,0.29647e-02,0.35953e-02,0.42898e-02,0.50972e-02 /)
      kbo(:,40, 8) = (/ &
        & 0.20439e-02,0.25046e-02,0.30512e-02,0.36459e-02,0.43466e-02 /)
      kbo(:,41, 8) = (/ &
        & 0.17068e-02,0.21107e-02,0.25838e-02,0.30959e-02,0.36971e-02 /)
      kbo(:,42, 8) = (/ &
        & 0.14199e-02,0.17705e-02,0.21755e-02,0.26204e-02,0.31356e-02 /)
      kbo(:,43, 8) = (/ &
        & 0.11616e-02,0.14584e-02,0.18069e-02,0.21876e-02,0.26286e-02 /)
      kbo(:,44, 8) = (/ &
        & 0.93807e-03,0.11864e-02,0.14851e-02,0.18080e-02,0.21849e-02 /)
      kbo(:,45, 8) = (/ &
        & 0.75026e-03,0.95460e-03,0.12092e-02,0.14831e-02,0.18037e-02 /)
      kbo(:,46, 8) = (/ &
        & 0.59319e-03,0.76134e-03,0.97292e-03,0.12059e-02,0.14787e-02 /)
      kbo(:,47, 8) = (/ &
        & 0.46546e-03,0.60113e-03,0.77762e-03,0.97379e-03,0.12030e-02 /)
      kbo(:,48, 8) = (/ &
        & 0.36131e-03,0.46999e-03,0.61292e-03,0.77778e-03,0.96667e-03 /)
      kbo(:,49, 8) = (/ &
        & 0.27490e-03,0.36153e-03,0.47561e-03,0.61173e-03,0.76634e-03 /)
      kbo(:,50, 8) = (/ &
        & 0.21403e-03,0.28416e-03,0.37592e-03,0.48994e-03,0.61812e-03 /)
      kbo(:,51, 8) = (/ &
        & 0.16745e-03,0.22425e-03,0.29943e-03,0.39474e-03,0.50310e-03 /)
      kbo(:,52, 8) = (/ &
        & 0.12927e-03,0.17496e-03,0.23541e-03,0.31434e-03,0.40442e-03 /)
      kbo(:,53, 8) = (/ &
        & 0.98512e-04,0.13503e-03,0.18276e-03,0.24681e-03,0.32086e-03 /)
      kbo(:,54, 8) = (/ &
        & 0.78150e-04,0.10819e-03,0.14843e-03,0.20243e-03,0.26646e-03 /)
      kbo(:,55, 8) = (/ &
        & 0.63455e-04,0.88570e-04,0.12297e-03,0.17015e-03,0.22626e-03 /)
      kbo(:,56, 8) = (/ &
        & 0.51095e-04,0.72223e-04,0.10144e-03,0.14188e-03,0.19132e-03 /)
      kbo(:,57, 8) = (/ &
        & 0.40866e-04,0.58631e-04,0.83096e-04,0.11753e-03,0.16055e-03 /)
      kbo(:,58, 8) = (/ &
        & 0.32890e-04,0.47893e-04,0.68644e-04,0.98156e-04,0.13564e-03 /)
      kbo(:,59, 8) = (/ &
        & 0.29702e-04,0.43928e-04,0.64217e-04,0.92621e-04,0.12965e-03 /)
      kbo(:,13, 9) = (/ &
        & 0.27690e+01,0.28644e+01,0.29696e+01,0.30850e+01,0.32162e+01 /)
      kbo(:,14, 9) = (/ &
        & 0.23162e+01,0.23973e+01,0.24876e+01,0.25913e+01,0.27107e+01 /)
      kbo(:,15, 9) = (/ &
        & 0.19377e+01,0.20096e+01,0.20909e+01,0.21846e+01,0.22904e+01 /)
      kbo(:,16, 9) = (/ &
        & 0.16221e+01,0.16854e+01,0.17596e+01,0.18440e+01,0.19374e+01 /)
      kbo(:,17, 9) = (/ &
        & 0.13581e+01,0.14147e+01,0.14813e+01,0.15562e+01,0.16364e+01 /)
      kbo(:,18, 9) = (/ &
        & 0.11494e+01,0.11995e+01,0.12558e+01,0.13168e+01,0.13828e+01 /)
      kbo(:,19, 9) = (/ &
        & 0.99857e+00,0.10422e+01,0.10890e+01,0.11391e+01,0.11917e+01 /)
      kbo(:,20, 9) = (/ &
        & 0.86585e+00,0.90292e+00,0.94341e+00,0.98616e+00,0.10332e+01 /)
      kbo(:,21, 9) = (/ &
        & 0.74752e+00,0.77983e+00,0.81433e+00,0.85283e+00,0.89462e+00 /)
      kbo(:,22, 9) = (/ &
        & 0.64494e+00,0.67286e+00,0.70277e+00,0.73658e+00,0.77352e+00 /)
      kbo(:,23, 9) = (/ &
        & 0.55485e+00,0.57897e+00,0.60654e+00,0.63699e+00,0.66979e+00 /)
      kbo(:,24, 9) = (/ &
        & 0.47664e+00,0.49869e+00,0.52329e+00,0.54973e+00,0.57955e+00 /)
      kbo(:,25, 9) = (/ &
        & 0.41114e+00,0.42988e+00,0.45044e+00,0.47447e+00,0.50163e+00 /)
      kbo(:,26, 9) = (/ &
        & 0.35513e+00,0.37142e+00,0.38942e+00,0.41045e+00,0.43493e+00 /)
      kbo(:,27, 9) = (/ &
        & 0.30546e+00,0.31995e+00,0.33673e+00,0.35597e+00,0.37742e+00 /)
      kbo(:,28, 9) = (/ &
        & 0.26188e+00,0.27552e+00,0.29117e+00,0.30879e+00,0.32839e+00 /)
      kbo(:,29, 9) = (/ &
        & 0.22377e+00,0.23654e+00,0.25102e+00,0.26735e+00,0.28587e+00 /)
      kbo(:,30, 9) = (/ &
        & 0.19129e+00,0.20332e+00,0.21691e+00,0.23233e+00,0.24924e+00 /)
      kbo(:,31, 9) = (/ &
        & 0.16347e+00,0.17463e+00,0.18745e+00,0.20165e+00,0.21712e+00 /)
      kbo(:,32, 9) = (/ &
        & 0.14037e+00,0.15075e+00,0.16282e+00,0.17567e+00,0.18973e+00 /)
      kbo(:,33, 9) = (/ &
        & 0.12095e+00,0.13081e+00,0.14161e+00,0.15337e+00,0.16632e+00 /)
      kbo(:,34, 9) = (/ &
        & 0.10468e+00,0.11371e+00,0.12351e+00,0.13423e+00,0.14632e+00 /)
      kbo(:,35, 9) = (/ &
        & 0.90259e-01,0.98421e-01,0.10717e+00,0.11695e+00,0.12831e+00 /)
      kbo(:,36, 9) = (/ &
        & 0.77272e-01,0.84599e-01,0.92464e-01,0.10140e+00,0.11193e+00 /)
      kbo(:,37, 9) = (/ &
        & 0.65606e-01,0.72029e-01,0.79063e-01,0.87174e-01,0.96643e-01 /)
      kbo(:,38, 9) = (/ &
        & 0.55528e-01,0.61268e-01,0.67613e-01,0.74898e-01,0.83456e-01 /)
      kbo(:,39, 9) = (/ &
        & 0.46985e-01,0.52085e-01,0.57765e-01,0.64303e-01,0.72021e-01 /)
      kbo(:,40, 9) = (/ &
        & 0.39626e-01,0.44094e-01,0.49150e-01,0.55005e-01,0.61884e-01 /)
      kbo(:,41, 9) = (/ &
        & 0.33376e-01,0.37326e-01,0.41783e-01,0.46997e-01,0.53158e-01 /)
      kbo(:,42, 9) = (/ &
        & 0.28074e-01,0.31535e-01,0.35493e-01,0.40112e-01,0.45645e-01 /)
      kbo(:,43, 9) = (/ &
        & 0.23419e-01,0.26419e-01,0.29889e-01,0.33982e-01,0.38867e-01 /)
      kbo(:,44, 9) = (/ &
        & 0.19437e-01,0.22035e-01,0.25042e-01,0.28622e-01,0.32930e-01 /)
      kbo(:,45, 9) = (/ &
        & 0.16083e-01,0.18329e-01,0.20937e-01,0.24027e-01,0.27786e-01 /)
      kbo(:,46, 9) = (/ &
        & 0.13236e-01,0.15146e-01,0.17420e-01,0.20094e-01,0.23328e-01 /)
      kbo(:,47, 9) = (/ &
        & 0.10820e-01,0.12455e-01,0.14377e-01,0.16656e-01,0.19464e-01 /)
      kbo(:,48, 9) = (/ &
        & 0.88043e-02,0.10190e-01,0.11813e-01,0.13745e-01,0.16141e-01 /)
      kbo(:,49, 9) = (/ &
        & 0.71234e-02,0.82775e-02,0.96453e-02,0.11284e-01,0.13310e-01 /)
      kbo(:,50, 9) = (/ &
        & 0.58127e-02,0.67802e-02,0.79379e-02,0.93254e-02,0.11078e-01 /)
      kbo(:,51, 9) = (/ &
        & 0.47494e-02,0.55659e-02,0.65602e-02,0.77407e-02,0.92288e-02 /)
      kbo(:,52, 9) = (/ &
        & 0.38618e-02,0.45424e-02,0.53925e-02,0.64011e-02,0.76645e-02 /)
      kbo(:,53, 9) = (/ &
        & 0.31264e-02,0.36823e-02,0.43952e-02,0.52615e-02,0.63311e-02 /)
      kbo(:,54, 9) = (/ &
        & 0.25794e-02,0.30481e-02,0.36548e-02,0.44037e-02,0.53380e-02 /)
      kbo(:,55, 9) = (/ &
        & 0.21508e-02,0.25472e-02,0.30665e-02,0.37188e-02,0.45472e-02 /)
      kbo(:,56, 9) = (/ &
        & 0.17938e-02,0.21263e-02,0.25713e-02,0.31411e-02,0.38667e-02 /)
      kbo(:,57, 9) = (/ &
        & 0.14949e-02,0.17755e-02,0.21510e-02,0.26439e-02,0.32830e-02 /)
      kbo(:,58, 9) = (/ &
        & 0.12521e-02,0.14938e-02,0.18137e-02,0.22426e-02,0.28028e-02 /)
      kbo(:,59, 9) = (/ &
        & 0.11302e-02,0.13552e-02,0.16582e-02,0.20691e-02,0.26051e-02 /)
      kbo(:,13,10) = (/ &
        & 0.14370e+02,0.14649e+02,0.14957e+02,0.15296e+02,0.15663e+02 /)
      kbo(:,14,10) = (/ &
        & 0.12178e+02,0.12411e+02,0.12682e+02,0.12978e+02,0.13316e+02 /)
      kbo(:,15,10) = (/ &
        & 0.10211e+02,0.10402e+02,0.10625e+02,0.10894e+02,0.11239e+02 /)
      kbo(:,16,10) = (/ &
        & 0.85974e+01,0.87539e+01,0.89410e+01,0.91849e+01,0.95108e+01 /)
      kbo(:,17,10) = (/ &
        & 0.72440e+01,0.73858e+01,0.75683e+01,0.78199e+01,0.81516e+01 /)
      kbo(:,18,10) = (/ &
        & 0.59680e+01,0.61054e+01,0.63108e+01,0.66074e+01,0.69367e+01 /)
      kbo(:,19,10) = (/ &
        & 0.47759e+01,0.49000e+01,0.51125e+01,0.53858e+01,0.56972e+01 /)
      kbo(:,20,10) = (/ &
        & 0.40682e+01,0.42060e+01,0.43988e+01,0.46035e+01,0.48052e+01 /)
      kbo(:,21,10) = (/ &
        & 0.35226e+01,0.36715e+01,0.38357e+01,0.40017e+01,0.41636e+01 /)
      kbo(:,22,10) = (/ &
        & 0.30730e+01,0.32059e+01,0.33607e+01,0.35055e+01,0.36621e+01 /)
      kbo(:,23,10) = (/ &
        & 0.26688e+01,0.27999e+01,0.29296e+01,0.30668e+01,0.32115e+01 /)
      kbo(:,24,10) = (/ &
        & 0.23228e+01,0.24338e+01,0.25510e+01,0.26866e+01,0.28223e+01 /)
      kbo(:,25,10) = (/ &
        & 0.19964e+01,0.21083e+01,0.22332e+01,0.23566e+01,0.24845e+01 /)
      kbo(:,26,10) = (/ &
        & 0.17097e+01,0.18190e+01,0.19420e+01,0.20663e+01,0.21952e+01 /)
      kbo(:,27,10) = (/ &
        & 0.14729e+01,0.15741e+01,0.16825e+01,0.17963e+01,0.19295e+01 /)
      kbo(:,28,10) = (/ &
        & 0.12788e+01,0.13609e+01,0.14562e+01,0.15668e+01,0.17032e+01 /)
      kbo(:,29,10) = (/ &
        & 0.11113e+01,0.11813e+01,0.12669e+01,0.13763e+01,0.15012e+01 /)
      kbo(:,30,10) = (/ &
        & 0.96661e+00,0.10287e+01,0.11081e+01,0.12093e+01,0.13273e+01 /)
      kbo(:,31,10) = (/ &
        & 0.83795e+00,0.89792e+00,0.97327e+00,0.10727e+01,0.11828e+01 /)
      kbo(:,32,10) = (/ &
        & 0.72634e+00,0.78480e+00,0.86071e+00,0.95503e+00,0.10615e+01 /)
      kbo(:,33,10) = (/ &
        & 0.63134e+00,0.68789e+00,0.76628e+00,0.85854e+00,0.96370e+00 /)
      kbo(:,34,10) = (/ &
        & 0.55172e+00,0.60863e+00,0.68672e+00,0.77637e+00,0.87664e+00 /)
      kbo(:,35,10) = (/ &
        & 0.48039e+00,0.53701e+00,0.61125e+00,0.69795e+00,0.79084e+00 /)
      kbo(:,36,10) = (/ &
        & 0.41819e+00,0.47188e+00,0.54096e+00,0.62096e+00,0.70693e+00 /)
      kbo(:,37,10) = (/ &
        & 0.36050e+00,0.40906e+00,0.47069e+00,0.54184e+00,0.62144e+00 /)
      kbo(:,38,10) = (/ &
        & 0.31156e+00,0.35409e+00,0.40958e+00,0.47371e+00,0.54611e+00 /)
      kbo(:,39,10) = (/ &
        & 0.26782e+00,0.30677e+00,0.35645e+00,0.41535e+00,0.48073e+00 /)
      kbo(:,40,10) = (/ &
        & 0.23006e+00,0.26273e+00,0.30670e+00,0.35934e+00,0.41871e+00 /)
      kbo(:,41,10) = (/ &
        & 0.19681e+00,0.22601e+00,0.26383e+00,0.31041e+00,0.36443e+00 /)
      kbo(:,42,10) = (/ &
        & 0.16794e+00,0.19457e+00,0.22757e+00,0.26875e+00,0.31708e+00 /)
      kbo(:,43,10) = (/ &
        & 0.14222e+00,0.16606e+00,0.19480e+00,0.23049e+00,0.27422e+00 /)
      kbo(:,44,10) = (/ &
        & 0.11907e+00,0.14059e+00,0.16567e+00,0.19741e+00,0.23557e+00 /)
      kbo(:,45,10) = (/ &
        & 0.99508e-01,0.11792e+00,0.14029e+00,0.16912e+00,0.20294e+00 /)
      kbo(:,46,10) = (/ &
        & 0.82787e-01,0.98729e-01,0.11783e+00,0.14344e+00,0.17433e+00 /)
      kbo(:,47,10) = (/ &
        & 0.68205e-01,0.81739e-01,0.98558e-01,0.12017e+00,0.14798e+00 /)
      kbo(:,48,10) = (/ &
        & 0.55907e-01,0.67050e-01,0.81465e-01,0.10030e+00,0.12506e+00 /)
      kbo(:,49,10) = (/ &
        & 0.45682e-01,0.54871e-01,0.66950e-01,0.83270e-01,0.10500e+00 /)
      kbo(:,50,10) = (/ &
        & 0.37515e-01,0.45259e-01,0.55584e-01,0.69475e-01,0.88432e-01 /)
      kbo(:,51,10) = (/ &
        & 0.31052e-01,0.37347e-01,0.46136e-01,0.58029e-01,0.74379e-01 /)
      kbo(:,52,10) = (/ &
        & 0.25697e-01,0.30758e-01,0.38027e-01,0.48169e-01,0.62340e-01 /)
      kbo(:,53,10) = (/ &
        & 0.21053e-01,0.25282e-01,0.31221e-01,0.39765e-01,0.52061e-01 /)
      kbo(:,54,10) = (/ &
        & 0.17506e-01,0.21171e-01,0.26181e-01,0.33450e-01,0.43837e-01 /)
      kbo(:,55,10) = (/ &
        & 0.14733e-01,0.17912e-01,0.22352e-01,0.28517e-01,0.37310e-01 /)
      kbo(:,56,10) = (/ &
        & 0.12382e-01,0.15138e-01,0.19031e-01,0.24337e-01,0.31780e-01 /)
      kbo(:,57,10) = (/ &
        & 0.10363e-01,0.12802e-01,0.16188e-01,0.20731e-01,0.27252e-01 /)
      kbo(:,58,10) = (/ &
        & 0.87632e-02,0.10863e-01,0.13823e-01,0.17907e-01,0.23570e-01 /)
      kbo(:,59,10) = (/ &
        & 0.79477e-02,0.99708e-02,0.12797e-01,0.16832e-01,0.22384e-01 /)
      kbo(:,13,11) = (/ &
        & 0.27028e+02,0.27753e+02,0.28483e+02,0.29219e+02,0.29909e+02 /)
      kbo(:,14,11) = (/ &
        & 0.23419e+02,0.24025e+02,0.24638e+02,0.25228e+02,0.25789e+02 /)
      kbo(:,15,11) = (/ &
        & 0.20150e+02,0.20660e+02,0.21151e+02,0.21642e+02,0.22118e+02 /)
      kbo(:,16,11) = (/ &
        & 0.17107e+02,0.17510e+02,0.17925e+02,0.18355e+02,0.18823e+02 /)
      kbo(:,17,11) = (/ &
        & 0.14361e+02,0.14686e+02,0.15035e+02,0.15422e+02,0.15903e+02 /)
      kbo(:,18,11) = (/ &
        & 0.12138e+02,0.12397e+02,0.12696e+02,0.13058e+02,0.13553e+02 /)
      kbo(:,19,11) = (/ &
        & 0.10135e+02,0.10395e+02,0.10708e+02,0.11115e+02,0.11638e+02 /)
      kbo(:,20,11) = (/ &
        & 0.81786e+01,0.84190e+01,0.87492e+01,0.92221e+01,0.97673e+01 /)
      kbo(:,21,11) = (/ &
        & 0.68203e+01,0.70074e+01,0.73249e+01,0.77062e+01,0.81227e+01 /)
      kbo(:,22,11) = (/ &
        & 0.58880e+01,0.61142e+01,0.64089e+01,0.67273e+01,0.70540e+01 /)
      kbo(:,23,11) = (/ &
        & 0.51482e+01,0.53972e+01,0.56613e+01,0.59190e+01,0.62039e+01 /)
      kbo(:,24,11) = (/ &
        & 0.45460e+01,0.47798e+01,0.50055e+01,0.52340e+01,0.54793e+01 /)
      kbo(:,25,11) = (/ &
        & 0.40038e+01,0.42162e+01,0.44356e+01,0.46519e+01,0.48861e+01 /)
      kbo(:,26,11) = (/ &
        & 0.35330e+01,0.37282e+01,0.39261e+01,0.41342e+01,0.43614e+01 /)
      kbo(:,27,11) = (/ &
        & 0.30918e+01,0.32790e+01,0.34783e+01,0.36774e+01,0.38933e+01 /)
      kbo(:,28,11) = (/ &
        & 0.27019e+01,0.28880e+01,0.30842e+01,0.32755e+01,0.34826e+01 /)
      kbo(:,29,11) = (/ &
        & 0.23567e+01,0.25399e+01,0.27237e+01,0.29118e+01,0.31184e+01 /)
      kbo(:,30,11) = (/ &
        & 0.20673e+01,0.22421e+01,0.24146e+01,0.26001e+01,0.28136e+01 /)
      kbo(:,31,11) = (/ &
        & 0.18233e+01,0.19796e+01,0.21491e+01,0.23275e+01,0.25391e+01 /)
      kbo(:,32,11) = (/ &
        & 0.16164e+01,0.17629e+01,0.19137e+01,0.20921e+01,0.23020e+01 /)
      kbo(:,33,11) = (/ &
        & 0.14325e+01,0.15691e+01,0.17171e+01,0.18965e+01,0.20991e+01 /)
      kbo(:,34,11) = (/ &
        & 0.12711e+01,0.14025e+01,0.15514e+01,0.17231e+01,0.19204e+01 /)
      kbo(:,35,11) = (/ &
        & 0.11251e+01,0.12478e+01,0.13948e+01,0.15591e+01,0.17428e+01 /)
      kbo(:,36,11) = (/ &
        & 0.98734e+00,0.11026e+01,0.12425e+01,0.13991e+01,0.15730e+01 /)
      kbo(:,37,11) = (/ &
        & 0.85152e+00,0.96327e+00,0.10911e+01,0.12398e+01,0.14045e+01 /)
      kbo(:,38,11) = (/ &
        & 0.73399e+00,0.83942e+00,0.95984e+00,0.10967e+01,0.12526e+01 /)
      kbo(:,39,11) = (/ &
        & 0.63468e+00,0.73175e+00,0.84488e+00,0.97279e+00,0.11163e+01 /)
      kbo(:,40,11) = (/ &
        & 0.54166e+00,0.63099e+00,0.73459e+00,0.85525e+00,0.98986e+00 /)
      kbo(:,41,11) = (/ &
        & 0.46341e+00,0.54185e+00,0.63786e+00,0.75041e+00,0.87557e+00 /)
      kbo(:,42,11) = (/ &
        & 0.39710e+00,0.46604e+00,0.55335e+00,0.65788e+00,0.77518e+00 /)
      kbo(:,43,11) = (/ &
        & 0.33809e+00,0.39845e+00,0.47656e+00,0.56991e+00,0.67763e+00 /)
      kbo(:,44,11) = (/ &
        & 0.28738e+00,0.33811e+00,0.40783e+00,0.49238e+00,0.58805e+00 /)
      kbo(:,45,11) = (/ &
        & 0.24372e+00,0.28787e+00,0.34858e+00,0.42338e+00,0.51131e+00 /)
      kbo(:,46,11) = (/ &
        & 0.20655e+00,0.24407e+00,0.29751e+00,0.36239e+00,0.44206e+00 /)
      kbo(:,47,11) = (/ &
        & 0.17359e+00,0.20653e+00,0.25158e+00,0.30900e+00,0.37888e+00 /)
      kbo(:,48,11) = (/ &
        & 0.14508e+00,0.17395e+00,0.21335e+00,0.26232e+00,0.32328e+00 /)
      kbo(:,49,11) = (/ &
        & 0.12016e+00,0.14523e+00,0.17928e+00,0.22128e+00,0.27412e+00 /)
      kbo(:,50,11) = (/ &
        & 0.99920e-01,0.12218e+00,0.15097e+00,0.18907e+00,0.23575e+00 /)
      kbo(:,51,11) = (/ &
        & 0.82909e-01,0.10226e+00,0.12737e+00,0.16132e+00,0.20378e+00 /)
      kbo(:,52,11) = (/ &
        & 0.68577e-01,0.85131e-01,0.10673e+00,0.13644e+00,0.17453e+00 /)
      kbo(:,53,11) = (/ &
        & 0.56302e-01,0.70491e-01,0.88684e-01,0.11469e+00,0.14786e+00 /)
      kbo(:,54,11) = (/ &
        & 0.47171e-01,0.59185e-01,0.74877e-01,0.97387e-01,0.12762e+00 /)
      kbo(:,55,11) = (/ &
        & 0.40028e-01,0.50199e-01,0.63960e-01,0.83211e-01,0.11104e+00 /)
      kbo(:,56,11) = (/ &
        & 0.33854e-01,0.42508e-01,0.54649e-01,0.71262e-01,0.95596e-01 /)
      kbo(:,57,11) = (/ &
        & 0.28590e-01,0.36142e-01,0.46409e-01,0.61269e-01,0.82012e-01 /)
      kbo(:,58,11) = (/ &
        & 0.24352e-01,0.30934e-01,0.39697e-01,0.52483e-01,0.71167e-01 /)
      kbo(:,59,11) = (/ &
        & 0.22598e-01,0.29152e-01,0.37468e-01,0.48573e-01,0.66434e-01 /)
      kbo(:,13,12) = (/ &
        & 0.57172e+02,0.59297e+02,0.61400e+02,0.63512e+02,0.65627e+02 /)
      kbo(:,14,12) = (/ &
        & 0.50361e+02,0.52086e+02,0.53828e+02,0.55595e+02,0.57346e+02 /)
      kbo(:,15,12) = (/ &
        & 0.44078e+02,0.45453e+02,0.46902e+02,0.48347e+02,0.49789e+02 /)
      kbo(:,16,12) = (/ &
        & 0.38395e+02,0.39554e+02,0.40754e+02,0.41955e+02,0.43150e+02 /)
      kbo(:,17,12) = (/ &
        & 0.33363e+02,0.34355e+02,0.35352e+02,0.36337e+02,0.37312e+02 /)
      kbo(:,18,12) = (/ &
        & 0.28599e+02,0.29463e+02,0.30307e+02,0.31155e+02,0.32043e+02 /)
      kbo(:,19,12) = (/ &
        & 0.24284e+02,0.24982e+02,0.25685e+02,0.26424e+02,0.27289e+02 /)
      kbo(:,20,12) = (/ &
        & 0.20576e+02,0.21117e+02,0.21693e+02,0.22370e+02,0.23304e+02 /)
      kbo(:,21,12) = (/ &
        & 0.17126e+02,0.17629e+02,0.18193e+02,0.18968e+02,0.20012e+02 /)
      kbo(:,22,12) = (/ &
        & 0.14084e+02,0.14526e+02,0.15112e+02,0.15986e+02,0.17086e+02 /)
      kbo(:,23,12) = (/ &
        & 0.11727e+02,0.12073e+02,0.12663e+02,0.13546e+02,0.14594e+02 /)
      kbo(:,24,12) = (/ &
        & 0.10116e+02,0.10483e+02,0.11087e+02,0.11839e+02,0.12630e+02 /)
      kbo(:,25,12) = (/ &
        & 0.89362e+01,0.93748e+01,0.99578e+01,0.10576e+02,0.11263e+02 /)
      kbo(:,26,12) = (/ &
        & 0.79574e+01,0.84325e+01,0.89960e+01,0.95862e+01,0.10135e+02 /)
      kbo(:,27,12) = (/ &
        & 0.71290e+01,0.76343e+01,0.81343e+01,0.86609e+01,0.91441e+01 /)
      kbo(:,28,12) = (/ &
        & 0.64441e+01,0.69081e+01,0.73340e+01,0.77892e+01,0.82579e+01 /)
      kbo(:,29,12) = (/ &
        & 0.57859e+01,0.61904e+01,0.65762e+01,0.69937e+01,0.74255e+01 /)
      kbo(:,30,12) = (/ &
        & 0.51602e+01,0.55338e+01,0.58953e+01,0.62766e+01,0.66823e+01 /)
      kbo(:,31,12) = (/ &
        & 0.45943e+01,0.49270e+01,0.52739e+01,0.56298e+01,0.60118e+01 /)
      kbo(:,32,12) = (/ &
        & 0.40881e+01,0.44095e+01,0.47450e+01,0.50839e+01,0.54488e+01 /)
      kbo(:,33,12) = (/ &
        & 0.36534e+01,0.39549e+01,0.42670e+01,0.46043e+01,0.49743e+01 /)
      kbo(:,34,12) = (/ &
        & 0.32874e+01,0.35667e+01,0.38571e+01,0.41872e+01,0.45862e+01 /)
      kbo(:,35,12) = (/ &
        & 0.29379e+01,0.31963e+01,0.34845e+01,0.38151e+01,0.42290e+01 /)
      kbo(:,36,12) = (/ &
        & 0.26101e+01,0.28628e+01,0.31405e+01,0.34760e+01,0.38927e+01 /)
      kbo(:,37,12) = (/ &
        & 0.23047e+01,0.25368e+01,0.28124e+01,0.31292e+01,0.35310e+01 /)
      kbo(:,38,12) = (/ &
        & 0.20413e+01,0.22603e+01,0.25129e+01,0.28252e+01,0.32149e+01 /)
      kbo(:,39,12) = (/ &
        & 0.18040e+01,0.20133e+01,0.22565e+01,0.25571e+01,0.29423e+01 /)
      kbo(:,40,12) = (/ &
        & 0.15898e+01,0.17862e+01,0.20189e+01,0.22992e+01,0.26576e+01 /)
      kbo(:,41,12) = (/ &
        & 0.14002e+01,0.15861e+01,0.18008e+01,0.20620e+01,0.24028e+01 /)
      kbo(:,42,12) = (/ &
        & 0.12302e+01,0.14049e+01,0.16015e+01,0.18444e+01,0.21658e+01 /)
      kbo(:,43,12) = (/ &
        & 0.10668e+01,0.12258e+01,0.14101e+01,0.16347e+01,0.19297e+01 /)
      kbo(:,44,12) = (/ &
        & 0.91800e+00,0.10642e+01,0.12324e+01,0.14347e+01,0.17074e+01 /)
      kbo(:,45,12) = (/ &
        & 0.78687e+00,0.91967e+00,0.10737e+01,0.12598e+01,0.15049e+01 /)
      kbo(:,46,12) = (/ &
        & 0.67148e+00,0.79041e+00,0.92761e+00,0.10973e+01,0.13177e+01 /)
      kbo(:,47,12) = (/ &
        & 0.57045e+00,0.67640e+00,0.80034e+00,0.94779e+00,0.11432e+01 /)
      kbo(:,48,12) = (/ &
        & 0.48142e+00,0.57646e+00,0.68676e+00,0.82116e+00,0.98898e+00 /)
      kbo(:,49,12) = (/ &
        & 0.40194e+00,0.48757e+00,0.58498e+00,0.70838e+00,0.85881e+00 /)
      kbo(:,50,12) = (/ &
        & 0.34095e+00,0.41499e+00,0.50425e+00,0.61464e+00,0.75451e+00 /)
      kbo(:,51,12) = (/ &
        & 0.29038e+00,0.35608e+00,0.43553e+00,0.53422e+00,0.66315e+00 /)
      kbo(:,52,12) = (/ &
        & 0.24615e+00,0.30360e+00,0.37359e+00,0.46378e+00,0.57808e+00 /)
      kbo(:,53,12) = (/ &
        & 0.20660e+00,0.25764e+00,0.31993e+00,0.39869e+00,0.50232e+00 /)
      kbo(:,54,12) = (/ &
        & 0.17518e+00,0.22280e+00,0.27852e+00,0.34881e+00,0.44243e+00 /)
      kbo(:,55,12) = (/ &
        & 0.14906e+00,0.19392e+00,0.24538e+00,0.31045e+00,0.39204e+00 /)
      kbo(:,56,12) = (/ &
        & 0.12564e+00,0.16748e+00,0.21535e+00,0.27386e+00,0.34816e+00 /)
      kbo(:,57,12) = (/ &
        & 0.10489e+00,0.14334e+00,0.18902e+00,0.24147e+00,0.30976e+00 /)
      kbo(:,58,12) = (/ &
        & 0.88415e-01,0.12250e+00,0.16566e+00,0.21499e+00,0.27515e+00 /)
      kbo(:,59,12) = (/ &
        & 0.80710e-01,0.11375e+00,0.15629e+00,0.20737e+00,0.26838e+00 /)
      kbo(:,13,13) = (/ &
        & 0.16465e+03,0.16298e+03,0.16413e+03,0.16796e+03,0.17425e+03 /)
      kbo(:,14,13) = (/ &
        & 0.14134e+03,0.14223e+03,0.14584e+03,0.15183e+03,0.15823e+03 /)
      kbo(:,15,13) = (/ &
        & 0.12334e+03,0.12642e+03,0.13170e+03,0.13719e+03,0.14248e+03 /)
      kbo(:,16,13) = (/ &
        & 0.10903e+03,0.11350e+03,0.11825e+03,0.12284e+03,0.12720e+03 /)
      kbo(:,17,13) = (/ &
        & 0.96744e+02,0.10077e+03,0.10473e+03,0.10856e+03,0.11225e+03 /)
      kbo(:,18,13) = (/ &
        & 0.85368e+02,0.88669e+02,0.91934e+02,0.95127e+02,0.98216e+02 /)
      kbo(:,19,13) = (/ &
        & 0.74865e+02,0.77560e+02,0.80263e+02,0.82912e+02,0.85499e+02 /)
      kbo(:,20,13) = (/ &
        & 0.65304e+02,0.67588e+02,0.69849e+02,0.72099e+02,0.74316e+02 /)
      kbo(:,21,13) = (/ &
        & 0.56704e+02,0.58616e+02,0.60541e+02,0.62457e+02,0.64444e+02 /)
      kbo(:,22,13) = (/ &
        & 0.49099e+02,0.50788e+02,0.52451e+02,0.54119e+02,0.55970e+02 /)
      kbo(:,23,13) = (/ &
        & 0.42076e+02,0.43646e+02,0.45230e+02,0.46888e+02,0.48798e+02 /)
      kbo(:,24,13) = (/ &
        & 0.35457e+02,0.36904e+02,0.38447e+02,0.40262e+02,0.42565e+02 /)
      kbo(:,25,13) = (/ &
        & 0.29832e+02,0.31036e+02,0.32508e+02,0.34502e+02,0.36979e+02 /)
      kbo(:,26,13) = (/ &
        & 0.25205e+02,0.26348e+02,0.27792e+02,0.29788e+02,0.32459e+02 /)
      kbo(:,27,13) = (/ &
        & 0.21486e+02,0.22586e+02,0.24162e+02,0.26260e+02,0.28944e+02 /)
      kbo(:,28,13) = (/ &
        & 0.18712e+02,0.19693e+02,0.21370e+02,0.23591e+02,0.26158e+02 /)
      kbo(:,29,13) = (/ &
        & 0.16630e+02,0.17716e+02,0.19369e+02,0.21565e+02,0.24102e+02 /)
      kbo(:,30,13) = (/ &
        & 0.14923e+02,0.16119e+02,0.17783e+02,0.19989e+02,0.22379e+02 /)
      kbo(:,31,13) = (/ &
        & 0.13532e+02,0.14853e+02,0.16576e+02,0.18745e+02,0.21084e+02 /)
      kbo(:,32,13) = (/ &
        & 0.12453e+02,0.13784e+02,0.15587e+02,0.17718e+02,0.20022e+02 /)
      kbo(:,33,13) = (/ &
        & 0.11580e+02,0.13038e+02,0.14851e+02,0.16892e+02,0.19192e+02 /)
      kbo(:,34,13) = (/ &
        & 0.10820e+02,0.12376e+02,0.14134e+02,0.16152e+02,0.18402e+02 /)
      kbo(:,35,13) = (/ &
        & 0.10116e+02,0.11686e+02,0.13402e+02,0.15346e+02,0.17556e+02 /)
      kbo(:,36,13) = (/ &
        & 0.93933e+01,0.10910e+02,0.12572e+02,0.14432e+02,0.16536e+02 /)
      kbo(:,37,13) = (/ &
        & 0.85160e+01,0.99755e+01,0.11554e+02,0.13358e+02,0.15350e+02 /)
      kbo(:,38,13) = (/ &
        & 0.77505e+01,0.91225e+01,0.10670e+02,0.12380e+02,0.14273e+02 /)
      kbo(:,39,13) = (/ &
        & 0.70897e+01,0.83885e+01,0.98694e+01,0.11502e+02,0.13343e+02 /)
      kbo(:,40,13) = (/ &
        & 0.63295e+01,0.75506e+01,0.89466e+01,0.10495e+02,0.12287e+02 /)
      kbo(:,41,13) = (/ &
        & 0.56302e+01,0.67988e+01,0.80957e+01,0.96013e+01,0.11280e+02 /)
      kbo(:,42,13) = (/ &
        & 0.50234e+01,0.61071e+01,0.73389e+01,0.87816e+01,0.10380e+02 /)
      kbo(:,43,13) = (/ &
        & 0.44225e+01,0.54282e+01,0.65963e+01,0.79433e+01,0.94666e+01 /)
      kbo(:,44,13) = (/ &
        & 0.38558e+01,0.47912e+01,0.58905e+01,0.71478e+01,0.86145e+01 /)
      kbo(:,45,13) = (/ &
        & 0.33575e+01,0.42351e+01,0.52475e+01,0.64292e+01,0.78296e+01 /)
      kbo(:,46,13) = (/ &
        & 0.29053e+01,0.37074e+01,0.46432e+01,0.57484e+01,0.70674e+01 /)
      kbo(:,47,13) = (/ &
        & 0.24706e+01,0.31851e+01,0.40524e+01,0.50837e+01,0.62990e+01 /)
      kbo(:,48,13) = (/ &
        & 0.20907e+01,0.27320e+01,0.35232e+01,0.44689e+01,0.55998e+01 /)
      kbo(:,49,13) = (/ &
        & 0.17652e+01,0.23397e+01,0.30525e+01,0.39130e+01,0.49641e+01 /)
      kbo(:,50,13) = (/ &
        & 0.14980e+01,0.19995e+01,0.26386e+01,0.34309e+01,0.43930e+01 /)
      kbo(:,51,13) = (/ &
        & 0.12883e+01,0.17229e+01,0.22808e+01,0.30058e+01,0.38921e+01 /)
      kbo(:,52,13) = (/ &
        & 0.11032e+01,0.14878e+01,0.19945e+01,0.26225e+01,0.34327e+01 /)
      kbo(:,53,13) = (/ &
        & 0.94256e+00,0.12803e+01,0.17436e+01,0.23095e+01,0.30258e+01 /)
      kbo(:,54,13) = (/ &
        & 0.80847e+00,0.11045e+01,0.15250e+01,0.20573e+01,0.27048e+01 /)
      kbo(:,55,13) = (/ &
        & 0.69972e+00,0.95008e+00,0.13215e+01,0.18178e+01,0.24326e+01 /)
      kbo(:,56,13) = (/ &
        & 0.60659e+00,0.81298e+00,0.11430e+01,0.15925e+01,0.21783e+01 /)
      kbo(:,57,13) = (/ &
        & 0.52664e+00,0.69670e+00,0.97998e+00,0.13891e+01,0.19333e+01 /)
      kbo(:,58,13) = (/ &
        & 0.45985e+00,0.60682e+00,0.84337e+00,0.12113e+01,0.17188e+01 /)
      kbo(:,59,13) = (/ &
        & 0.43853e+00,0.57879e+00,0.79018e+00,0.11130e+01,0.16039e+01 /)
      kbo(:,13,14) = (/ &
        & 0.86016e+03,0.84626e+03,0.83228e+03,0.81817e+03,0.80450e+03 /)
      kbo(:,14,14) = (/ &
        & 0.75981e+03,0.74663e+03,0.73345e+03,0.72104e+03,0.71224e+03 /)
      kbo(:,15,14) = (/ &
        & 0.66201e+03,0.64993e+03,0.63891e+03,0.63210e+03,0.62978e+03 /)
      kbo(:,16,14) = (/ &
        & 0.57014e+03,0.56027e+03,0.55466e+03,0.55378e+03,0.55721e+03 /)
      kbo(:,17,14) = (/ &
        & 0.48861e+03,0.48354e+03,0.48324e+03,0.48760e+03,0.49602e+03 /)
      kbo(:,18,14) = (/ &
        & 0.41987e+03,0.41964e+03,0.42411e+03,0.43291e+03,0.44575e+03 /)
      kbo(:,19,14) = (/ &
        & 0.36303e+03,0.36702e+03,0.37556e+03,0.38834e+03,0.40471e+03 /)
      kbo(:,20,14) = (/ &
        & 0.31651e+03,0.32421e+03,0.33627e+03,0.35219e+03,0.37072e+03 /)
      kbo(:,21,14) = (/ &
        & 0.27867e+03,0.28947e+03,0.30434e+03,0.32131e+03,0.33823e+03 /)
      kbo(:,22,14) = (/ &
        & 0.24916e+03,0.26251e+03,0.27768e+03,0.29296e+03,0.30844e+03 /)
      kbo(:,23,14) = (/ &
        & 0.22571e+03,0.23932e+03,0.25291e+03,0.26670e+03,0.28069e+03 /)
      kbo(:,24,14) = (/ &
        & 0.20503e+03,0.21765e+03,0.23029e+03,0.24291e+03,0.25575e+03 /)
      kbo(:,25,14) = (/ &
        & 0.18574e+03,0.19763e+03,0.20960e+03,0.22151e+03,0.23356e+03 /)
      kbo(:,26,14) = (/ &
        & 0.16825e+03,0.17945e+03,0.19085e+03,0.20242e+03,0.21406e+03 /)
      kbo(:,27,14) = (/ &
        & 0.15254e+03,0.16311e+03,0.17402e+03,0.18521e+03,0.19696e+03 /)
      kbo(:,28,14) = (/ &
        & 0.13815e+03,0.14857e+03,0.15913e+03,0.17022e+03,0.18238e+03 /)
      kbo(:,29,14) = (/ &
        & 0.12560e+03,0.13571e+03,0.14630e+03,0.15763e+03,0.17019e+03 /)
      kbo(:,30,14) = (/ &
        & 0.11497e+03,0.12476e+03,0.13550e+03,0.14719e+03,0.16044e+03 /)
      kbo(:,31,14) = (/ &
        & 0.10602e+03,0.11577e+03,0.12671e+03,0.13889e+03,0.15289e+03 /)
      kbo(:,32,14) = (/ &
        & 0.98519e+02,0.10855e+03,0.11978e+03,0.13265e+03,0.14744e+03 /)
      kbo(:,33,14) = (/ &
        & 0.92517e+02,0.10274e+03,0.11452e+03,0.12822e+03,0.14389e+03 /)
      kbo(:,34,14) = (/ &
        & 0.87441e+02,0.97936e+02,0.11044e+03,0.12495e+03,0.14148e+03 /)
      kbo(:,35,14) = (/ &
        & 0.82499e+02,0.93333e+02,0.10635e+03,0.12151e+03,0.13874e+03 /)
      kbo(:,36,14) = (/ &
        & 0.77442e+02,0.88493e+02,0.10184e+03,0.11740e+03,0.13513e+03 /)
      kbo(:,37,14) = (/ &
        & 0.71771e+02,0.82731e+02,0.96032e+02,0.11158e+03,0.12941e+03 /)
      kbo(:,38,14) = (/ &
        & 0.66727e+02,0.77610e+02,0.90795e+02,0.10632e+03,0.12415e+03 /)
      kbo(:,39,14) = (/ &
        & 0.62339e+02,0.73113e+02,0.86200e+02,0.10167e+03,0.11942e+03 /)
      kbo(:,40,14) = (/ &
        & 0.57601e+02,0.67999e+02,0.80724e+02,0.95858e+02,0.11323e+03 /)
      kbo(:,41,14) = (/ &
        & 0.53285e+02,0.63203e+02,0.75577e+02,0.90242e+02,0.10726e+03 /)
      kbo(:,42,14) = (/ &
        & 0.49392e+02,0.58908e+02,0.70834e+02,0.85045e+02,0.10163e+03 /)
      kbo(:,43,14) = (/ &
        & 0.45446e+02,0.54452e+02,0.65751e+02,0.79402e+02,0.95397e+02 /)
      kbo(:,44,14) = (/ &
        & 0.41620e+02,0.50184e+02,0.60777e+02,0.73786e+02,0.89076e+02 /)
      kbo(:,45,14) = (/ &
        & 0.38059e+02,0.46282e+02,0.56226e+02,0.68539e+02,0.83136e+02 /)
      kbo(:,46,14) = (/ &
        & 0.34554e+02,0.42501e+02,0.51829e+02,0.63383e+02,0.77220e+02 /)
      kbo(:,47,14) = (/ &
        & 0.31009e+02,0.38610e+02,0.47385e+02,0.58058e+02,0.71080e+02 /)
      kbo(:,48,14) = (/ &
        & 0.27715e+02,0.34934e+02,0.43319e+02,0.53190e+02,0.65347e+02 /)
      kbo(:,49,14) = (/ &
        & 0.24658e+02,0.31478e+02,0.39500e+02,0.48743e+02,0.59997e+02 /)
      kbo(:,50,14) = (/ &
        & 0.22034e+02,0.28437e+02,0.36093e+02,0.44894e+02,0.55346e+02 /)
      kbo(:,51,14) = (/ &
        & 0.19684e+02,0.25626e+02,0.32937e+02,0.41385e+02,0.51154e+02 /)
      kbo(:,52,14) = (/ &
        & 0.17504e+02,0.22995e+02,0.29925e+02,0.38057e+02,0.47307e+02 /)
      kbo(:,53,14) = (/ &
        & 0.15552e+02,0.20544e+02,0.27079e+02,0.34832e+02,0.43722e+02 /)
      kbo(:,54,14) = (/ &
        & 0.13886e+02,0.18476e+02,0.24607e+02,0.31966e+02,0.40540e+02 /)
      kbo(:,55,14) = (/ &
        & 0.12396e+02,0.16681e+02,0.22385e+02,0.29384e+02,0.37592e+02 /)
      kbo(:,56,14) = (/ &
        & 0.11028e+02,0.15006e+02,0.20297e+02,0.26955e+02,0.34780e+02 /)
      kbo(:,57,14) = (/ &
        & 0.97493e+01,0.13452e+02,0.18354e+02,0.24644e+02,0.32099e+02 /)
      kbo(:,58,14) = (/ &
        & 0.86411e+01,0.12068e+02,0.16627e+02,0.22569e+02,0.29684e+02 /)
      kbo(:,59,14) = (/ &
        & 0.80894e+01,0.11449e+02,0.15905e+02,0.21753e+02,0.28728e+02 /)
      kbo(:,13,15) = (/ &
        & 0.50046e+04,0.50034e+04,0.49950e+04,0.49781e+04,0.49542e+04 /)
      kbo(:,14,15) = (/ &
        & 0.51812e+04,0.51738e+04,0.51582e+04,0.51357e+04,0.51054e+04 /)
      kbo(:,15,15) = (/ &
        & 0.52793e+04,0.52645e+04,0.52450e+04,0.52172e+04,0.51836e+04 /)
      kbo(:,16,15) = (/ &
        & 0.53001e+04,0.52818e+04,0.52568e+04,0.52274e+04,0.51924e+04 /)
      kbo(:,17,15) = (/ &
        & 0.52448e+04,0.52242e+04,0.52004e+04,0.51715e+04,0.51377e+04 /)
      kbo(:,18,15) = (/ &
        & 0.51200e+04,0.51031e+04,0.50817e+04,0.50571e+04,0.50308e+04 /)
      kbo(:,19,15) = (/ &
        & 0.49389e+04,0.49284e+04,0.49153e+04,0.49007e+04,0.48819e+04 /)
      kbo(:,20,15) = (/ &
        & 0.47181e+04,0.47168e+04,0.47163e+04,0.47129e+04,0.47111e+04 /)
      kbo(:,21,15) = (/ &
        & 0.44718e+04,0.44865e+04,0.44990e+04,0.45153e+04,0.45403e+04 /)
      kbo(:,22,15) = (/ &
        & 0.42192e+04,0.42497e+04,0.42861e+04,0.43316e+04,0.43809e+04 /)
      kbo(:,23,15) = (/ &
        & 0.39727e+04,0.40275e+04,0.40936e+04,0.41646e+04,0.42404e+04 /)
      kbo(:,24,15) = (/ &
        & 0.37507e+04,0.38336e+04,0.39239e+04,0.40206e+04,0.41209e+04 /)
      kbo(:,25,15) = (/ &
        & 0.35606e+04,0.36694e+04,0.37826e+04,0.39026e+04,0.40244e+04 /)
      kbo(:,26,15) = (/ &
        & 0.34043e+04,0.35364e+04,0.36731e+04,0.38130e+04,0.39519e+04 /)
      kbo(:,27,15) = (/ &
        & 0.32803e+04,0.34346e+04,0.35912e+04,0.37476e+04,0.39014e+04 /)
      kbo(:,28,15) = (/ &
        & 0.31876e+04,0.33610e+04,0.35344e+04,0.37042e+04,0.38699e+04 /)
      kbo(:,29,15) = (/ &
        & 0.31239e+04,0.33137e+04,0.34995e+04,0.36813e+04,0.38573e+04 /)
      kbo(:,30,15) = (/ &
        & 0.30850e+04,0.32872e+04,0.34837e+04,0.36745e+04,0.38591e+04 /)
      kbo(:,31,15) = (/ &
        & 0.30674e+04,0.32795e+04,0.34848e+04,0.36826e+04,0.38724e+04 /)
      kbo(:,32,15) = (/ &
        & 0.30683e+04,0.32879e+04,0.34990e+04,0.37022e+04,0.38953e+04 /)
      kbo(:,33,15) = (/ &
        & 0.30831e+04,0.33087e+04,0.35243e+04,0.37303e+04,0.39250e+04 /)
      kbo(:,34,15) = (/ &
        & 0.31017e+04,0.33308e+04,0.35496e+04,0.37580e+04,0.39527e+04 /)
      kbo(:,35,15) = (/ &
        & 0.31057e+04,0.33387e+04,0.35601e+04,0.37700e+04,0.39654e+04 /)
      kbo(:,36,15) = (/ &
        & 0.30895e+04,0.33260e+04,0.35504e+04,0.37630e+04,0.39606e+04 /)
      kbo(:,37,15) = (/ &
        & 0.30400e+04,0.32811e+04,0.35096e+04,0.37263e+04,0.39277e+04 /)
      kbo(:,38,15) = (/ &
        & 0.29913e+04,0.32361e+04,0.34690e+04,0.36890e+04,0.38942e+04 /)
      kbo(:,39,15) = (/ &
        & 0.29441e+04,0.31926e+04,0.34294e+04,0.36526e+04,0.38612e+04 /)
      kbo(:,40,15) = (/ &
        & 0.28722e+04,0.31254e+04,0.33667e+04,0.35943e+04,0.38073e+04 /)
      kbo(:,41,15) = (/ &
        & 0.27971e+04,0.30548e+04,0.33004e+04,0.35326e+04,0.37505e+04 /)
      kbo(:,42,15) = (/ &
        & 0.27226e+04,0.29837e+04,0.32336e+04,0.34701e+04,0.36925e+04 /)
      kbo(:,43,15) = (/ &
        & 0.26332e+04,0.28981e+04,0.31525e+04,0.33944e+04,0.36223e+04 /)
      kbo(:,44,15) = (/ &
        & 0.25372e+04,0.28050e+04,0.30643e+04,0.33114e+04,0.35441e+04 /)
      kbo(:,45,15) = (/ &
        & 0.24417e+04,0.27113e+04,0.29748e+04,0.32268e+04,0.34651e+04 /)
      kbo(:,46,15) = (/ &
        & 0.23395e+04,0.26115e+04,0.28783e+04,0.31351e+04,0.33792e+04 /)
      kbo(:,47,15) = (/ &
        & 0.22243e+04,0.24998e+04,0.27694e+04,0.30313e+04,0.32810e+04 /)
      kbo(:,48,15) = (/ &
        & 0.21083e+04,0.23877e+04,0.26592e+04,0.29257e+04,0.31803e+04 /)
      kbo(:,49,15) = (/ &
        & 0.19925e+04,0.22741e+04,0.25488e+04,0.28180e+04,0.30783e+04 /)
      kbo(:,50,15) = (/ &
        & 0.18841e+04,0.21666e+04,0.24447e+04,0.27159e+04,0.29806e+04 /)
      kbo(:,51,15) = (/ &
        & 0.17798e+04,0.20618e+04,0.23428e+04,0.26160e+04,0.28839e+04 /)
      kbo(:,52,15) = (/ &
        & 0.16762e+04,0.19574e+04,0.22398e+04,0.25156e+04,0.27862e+04 /)
      kbo(:,53,15) = (/ &
        & 0.15731e+04,0.18530e+04,0.21358e+04,0.24152e+04,0.26872e+04 /)
      kbo(:,54,15) = (/ &
        & 0.14802e+04,0.17581e+04,0.20401e+04,0.23219e+04,0.25956e+04 /)
      kbo(:,55,15) = (/ &
        & 0.13915e+04,0.16675e+04,0.19488e+04,0.22318e+04,0.25080e+04 /)
      kbo(:,56,15) = (/ &
        & 0.13039e+04,0.15778e+04,0.18577e+04,0.21406e+04,0.24200e+04 /)
      kbo(:,57,15) = (/ &
        & 0.12167e+04,0.14890e+04,0.17672e+04,0.20493e+04,0.23313e+04 /)
      kbo(:,58,15) = (/ &
        & 0.11349e+04,0.14057e+04,0.16818e+04,0.19631e+04,0.22464e+04 /)
      kbo(:,59,15) = (/ &
        & 0.11025e+04,0.13721e+04,0.16476e+04,0.19283e+04,0.22117e+04 /)
      kbo(:,13,16) = (/ &
        & 0.12492e+05,0.12602e+05,0.12678e+05,0.12730e+05,0.12749e+05 /)
      kbo(:,14,16) = (/ &
        & 0.14696e+05,0.14792e+05,0.14862e+05,0.14890e+05,0.14889e+05 /)
      kbo(:,15,16) = (/ &
        & 0.17153e+05,0.17242e+05,0.17275e+05,0.17274e+05,0.17231e+05 /)
      kbo(:,16,16) = (/ &
        & 0.19843e+05,0.19894e+05,0.19898e+05,0.19845e+05,0.19747e+05 /)
      kbo(:,17,16) = (/ &
        & 0.22727e+05,0.22731e+05,0.22667e+05,0.22551e+05,0.22386e+05 /)
      kbo(:,18,16) = (/ &
        & 0.25761e+05,0.25684e+05,0.25544e+05,0.25342e+05,0.25070e+05 /)
      kbo(:,19,16) = (/ &
        & 0.28878e+05,0.28701e+05,0.28454e+05,0.28131e+05,0.27759e+05 /)
      kbo(:,20,16) = (/ &
        & 0.31981e+05,0.31695e+05,0.31314e+05,0.30871e+05,0.30360e+05 /)
      kbo(:,21,16) = (/ &
        & 0.35017e+05,0.34575e+05,0.34064e+05,0.33480e+05,0.32821e+05 /)
      kbo(:,22,16) = (/ &
        & 0.37854e+05,0.37264e+05,0.36589e+05,0.35840e+05,0.35046e+05 /)
      kbo(:,23,16) = (/ &
        & 0.40473e+05,0.39710e+05,0.38862e+05,0.37967e+05,0.37023e+05 /)
      kbo(:,24,16) = (/ &
        & 0.42796e+05,0.41864e+05,0.40869e+05,0.39817e+05,0.38718e+05 /)
      kbo(:,25,16) = (/ &
        & 0.44813e+05,0.43719e+05,0.42578e+05,0.41380e+05,0.40143e+05 /)
      kbo(:,26,16) = (/ &
        & 0.46504e+05,0.45263e+05,0.43973e+05,0.42641e+05,0.41294e+05 /)
      kbo(:,27,16) = (/ &
        & 0.47893e+05,0.46507e+05,0.45087e+05,0.43647e+05,0.42197e+05 /)
      kbo(:,28,16) = (/ &
        & 0.48993e+05,0.47480e+05,0.45952e+05,0.44417e+05,0.42878e+05 /)
      kbo(:,29,16) = (/ &
        & 0.49823e+05,0.48206e+05,0.46588e+05,0.44969e+05,0.43353e+05 /)
      kbo(:,30,16) = (/ &
        & 0.50415e+05,0.48716e+05,0.47025e+05,0.45339e+05,0.43659e+05 /)
      kbo(:,31,16) = (/ &
        & 0.50811e+05,0.49042e+05,0.47288e+05,0.45543e+05,0.43813e+05 /)
      kbo(:,32,16) = (/ &
        & 0.51032e+05,0.49203e+05,0.47400e+05,0.45610e+05,0.43841e+05 /)
      kbo(:,33,16) = (/ &
        & 0.51107e+05,0.49234e+05,0.47393e+05,0.45565e+05,0.43775e+05 /)
      kbo(:,34,16) = (/ &
        & 0.51130e+05,0.49228e+05,0.47350e+05,0.45497e+05,0.43688e+05 /)
      kbo(:,35,16) = (/ &
        & 0.51256e+05,0.49316e+05,0.47413e+05,0.45540e+05,0.43711e+05 /)
      kbo(:,36,16) = (/ &
        & 0.51519e+05,0.49555e+05,0.47626e+05,0.45731e+05,0.43885e+05 /)
      kbo(:,37,16) = (/ &
        & 0.52034e+05,0.50041e+05,0.48090e+05,0.46168e+05,0.44302e+05 /)
      kbo(:,38,16) = (/ &
        & 0.52529e+05,0.50511e+05,0.48535e+05,0.46595e+05,0.44706e+05 /)
      kbo(:,39,16) = (/ &
        & 0.52985e+05,0.50952e+05,0.48954e+05,0.46996e+05,0.45085e+05 /)
      kbo(:,40,16) = (/ &
        & 0.53633e+05,0.51575e+05,0.49556e+05,0.47578e+05,0.45648e+05 /)
      kbo(:,41,16) = (/ &
        & 0.54289e+05,0.52211e+05,0.50171e+05,0.48171e+05,0.46220e+05 /)
      kbo(:,42,16) = (/ &
        & 0.54932e+05,0.52836e+05,0.50778e+05,0.48759e+05,0.46785e+05 /)
      kbo(:,43,16) = (/ &
        & 0.55673e+05,0.53569e+05,0.51488e+05,0.49449e+05,0.47456e+05 /)
      kbo(:,44,16) = (/ &
        & 0.56461e+05,0.54346e+05,0.52247e+05,0.50190e+05,0.48178e+05 /)
      kbo(:,45,16) = (/ &
        & 0.57241e+05,0.55121e+05,0.53007e+05,0.50929e+05,0.48897e+05 /)
      kbo(:,46,16) = (/ &
        & 0.58063e+05,0.55933e+05,0.53806e+05,0.51710e+05,0.49656e+05 /)
      kbo(:,47,16) = (/ &
        & 0.58978e+05,0.56828e+05,0.54697e+05,0.52582e+05,0.50505e+05 /)
      kbo(:,48,16) = (/ &
        & 0.59891e+05,0.57720e+05,0.55586e+05,0.53459e+05,0.51367e+05 /)
      kbo(:,49,16) = (/ &
        & 0.60795e+05,0.58621e+05,0.56472e+05,0.54336e+05,0.52224e+05 /)
      kbo(:,50,16) = (/ &
        & 0.61639e+05,0.59466e+05,0.57298e+05,0.55162e+05,0.53034e+05 /)
      kbo(:,51,16) = (/ &
        & 0.62447e+05,0.60284e+05,0.58110e+05,0.55961e+05,0.53824e+05 /)
      kbo(:,52,16) = (/ &
        & 0.63240e+05,0.61098e+05,0.58916e+05,0.56760e+05,0.54612e+05 /)
      kbo(:,53,16) = (/ &
        & 0.64030e+05,0.61903e+05,0.59727e+05,0.57558e+05,0.55411e+05 /)
      kbo(:,54,16) = (/ &
        & 0.64735e+05,0.62637e+05,0.60471e+05,0.58287e+05,0.56138e+05 /)
      kbo(:,55,16) = (/ &
        & 0.65407e+05,0.63332e+05,0.61181e+05,0.59003e+05,0.56834e+05 /)
      kbo(:,56,16) = (/ &
        & 0.66069e+05,0.64015e+05,0.61881e+05,0.59702e+05,0.57529e+05 /)
      kbo(:,57,16) = (/ &
        & 0.66725e+05,0.64683e+05,0.62576e+05,0.60411e+05,0.58225e+05 /)
      kbo(:,58,16) = (/ &
        & 0.67327e+05,0.65315e+05,0.63232e+05,0.61078e+05,0.58891e+05 /)
      kbo(:,59,16) = (/ &
        & 0.67577e+05,0.65572e+05,0.63496e+05,0.61349e+05,0.59161e+05 /)

!     -----------------------------------------------------------------

      forrefo(:, 1) = (/ 0.299818e-05, 0.209282e-05, 0.988353e-04, 0.632178e-03 /)
      forrefo(:, 2) = (/ 0.633648e-05, 0.509214e-04, 0.650535e-03, 0.264019e-02 /)
      forrefo(:, 3) = (/ 0.636782e-04, 0.136577e-03, 0.166500e-02, 0.750821e-02 /)
      forrefo(:, 4) = (/ 0.472314e-03, 0.988296e-03, 0.585751e-02, 0.187352e-01 /)
      forrefo(:, 5) = (/ 0.558635e-02, 0.856489e-02, 0.157438e-01, 0.181471e-01 /)
      forrefo(:, 6) = (/ 0.217395e-01, 0.229156e-01, 0.230125e-01, 0.143821e-01 /)
      forrefo(:, 7) = (/ 0.277222e-01, 0.299252e-01, 0.208929e-01, 0.826748e-02 /)
      forrefo(:, 8) = (/ 0.252119e-01, 0.262911e-01, 0.187663e-01, 0.417110e-02 /)
      forrefo(:, 9) = (/ 0.304941e-01, 0.175545e-01, 0.971224e-02, 0.142023e-02 /)
      forrefo(:,10) = (/ 0.327200e-01, 0.215788e-01, 0.346831e-02, 0.157989e-02 /)
      forrefo(:,11) = (/ 0.324955e-01, 0.228571e-01, 0.171749e-02, 0.226853e-02 /)
      forrefo(:,12) = (/ 0.326588e-01, 0.198544e-01, 0.532339e-06, 0.279086e-02 /)
      forrefo(:,13) = (/ 0.345157e-01, 0.168679e-01, 0.505361e-06, 0.276647e-02 /)
      forrefo(:,14) = (/ 0.448765e-01, 0.123791e-02, 0.488367e-06, 0.122245e-02 /)
      forrefo(:,15) = (/ 0.486925e-01, 0.464371e-06, 0.464241e-06, 0.753846e-06 /)
      forrefo(:,16) = (/ 0.530511e-01, 0.376234e-06, 0.409824e-06, 0.470650e-06 /)

!     -----------------------------------------------------------------
!     The array SELFREFO contains the coefficient of the water vapor
!     self-continuum (including the energy term).  The first index
!     refers to temperature in 7.2 degree increments.  For instance,
!     JT = 1 refers to a temperature of 245.6, JT = 2 refers to 252.8,
!     etc.  The second index runs over the g-channel (1 to 16).

      selfrefo(:, 1) = (/ &
        &  0.118069e+00, 0.713523e-01, 0.431199e-01, 0.260584e-01, 0.157477e-01, &
        &  0.951675e-02, 0.575121e-02, 0.347560e-02, 0.210039e-02, 0.126932e-02 /)
      selfrefo(:, 2) = (/ &
        &  0.137081e-01, 0.139046e-01, 0.141040e-01, 0.143061e-01, 0.145112e-01, &
        &  0.147193e-01, 0.149303e-01, 0.151443e-01, 0.153614e-01, 0.155816e-01 /)
      selfrefo(:, 3) = (/ &
        &  0.166575e-01, 0.164916e-01, 0.163273e-01, 0.161647e-01, 0.160037e-01, &
        &  0.158443e-01, 0.156864e-01, 0.155302e-01, 0.153755e-01, 0.152224e-01 /)
      selfrefo(:, 4) = (/ &
        &  0.597379e-01, 0.509517e-01, 0.434579e-01, 0.370662e-01, 0.316145e-01, &
        &  0.269647e-01, 0.229988e-01, 0.196162e-01, 0.167311e-01, 0.142703e-01 /)
      selfrefo(:, 5) = (/ &
        &  0.227517e+00, 0.198401e+00, 0.173011e+00, 0.150870e+00, 0.131563e+00, &
        &  0.114726e+00, 0.100044e+00, 0.872415e-01, 0.760769e-01, 0.663411e-01 /)
      selfrefo(:, 6) = (/ &
        &  0.453235e+00, 0.414848e+00, 0.379712e+00, 0.347552e+00, 0.318116e+00, &
        &  0.291173e+00, 0.266512e+00, 0.243940e+00, 0.223279e+00, 0.204368e+00 /)
      selfrefo(:, 7) = (/ &
        &  0.569263e+00, 0.516415e+00, 0.468473e+00, 0.424982e+00, 0.385528e+00, &
        &  0.349737e+00, 0.317269e+00, 0.287815e+00, 0.261095e+00, 0.236856e+00 /)
      selfrefo(:, 8) = (/ &
        &  0.490314e+00, 0.448042e+00, 0.409413e+00, 0.374116e+00, 0.341861e+00, &
        &  0.312387e+00, 0.285455e+00, 0.260844e+00, 0.238355e+00, 0.217805e+00 /)
      selfrefo(:, 9) = (/ &
        &  0.258162e+00, 0.265085e+00, 0.272193e+00, 0.279493e+00, 0.286988e+00, &
        &  0.294684e+00, 0.302586e+00, 0.310701e+00, 0.319033e+00, 0.327588e+00 /)
      selfrefo(:,10) = (/ &
        &  0.332019e+00, 0.331902e+00, 0.331784e+00, 0.331666e+00, 0.331549e+00, &
        &  0.331431e+00, 0.331314e+00, 0.331197e+00, 0.331079e+00, 0.330962e+00 /)
      selfrefo(:,11) = (/ &
        &  0.357523e+00, 0.353154e+00, 0.348839e+00, 0.344576e+00, 0.340366e+00, &
        &  0.336207e+00, 0.332099e+00, 0.328041e+00, 0.324032e+00, 0.320073e+00 /)
      selfrefo(:,12) = (/ &
        &  0.294662e+00, 0.299043e+00, 0.303488e+00, 0.308000e+00, 0.312579e+00, &
        &  0.317226e+00, 0.321941e+00, 0.326727e+00, 0.331585e+00, 0.336514e+00 /)
      selfrefo(:,13) = (/ &
        &  0.227445e+00, 0.241545e+00, 0.256519e+00, 0.272422e+00, 0.289311e+00, &
        &  0.307247e+00, 0.326294e+00, 0.346523e+00, 0.368005e+00, 0.390820e+00 /)
      selfrefo(:,14) = (/ &
        &  0.616203e-02, 0.113523e-01, 0.209144e-01, 0.385307e-01, 0.709852e-01, &
        &  0.130776e+00, 0.240929e+00, 0.443865e+00, 0.817733e+00, 0.150651e+01 /)
      selfrefo(:,15) = (/ &
        &  0.279552e-03, 0.808472e-03, 0.233812e-02, 0.676192e-02, 0.195557e-01, &
        &  0.565555e-01, 0.163560e+00, 0.473020e+00, 0.136799e+01, 0.395626e+01 /)
      selfrefo(:,16) = (/ &
        &  0.261006e-03, 0.771043e-03, 0.227776e-02, 0.672879e-02, 0.198777e-01, &
        &  0.587212e-01, 0.173470e+00, 0.512452e+00, 0.151385e+01, 0.447209e+01 /)
     
      end subroutine sw_kgb29

