!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb28
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg28, only : kao, kbo, sfluxrefo, rayl, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:,1) = (/ &
        & 1.06156    , 0.599910   , 0.422462   , 0.400077   , &
        & 0.282221   , 0.187893   , 6.77357e-02, 3.04572e-02, &
        & 2.00442e-02, 2.30786e-03, 2.08824e-03, 1.42604e-03, &
        & 9.67384e-04, 6.35362e-04, 1.47727e-04, 6.87639e-06 /)
      sfluxrefo(:,2) = (/ &
        & 1.07598    , 0.585099   , 0.422852   , 0.400077   , &
        & 0.282221   , 0.187893   , 6.69686e-02, 3.09070e-02, &
        & 2.02400e-02, 2.47760e-03, 1.89411e-03, 1.41122e-03, &
        & 1.12449e-03, 5.73505e-04, 2.04160e-04, 1.58371e-05 /)
      sfluxrefo(:,3) = (/ &
        & 0.461647   , 0.406113   , 0.332506   , 0.307508   , &
        & 0.211167   , 0.235457   , 0.495886   , 0.363921   , &
        & 0.192700   , 2.04678e-02, 1.55407e-02, 1.03882e-02, &
        & 1.10778e-02, 1.00504e-02, 4.93497e-03, 5.73410e-04 /)
      sfluxrefo(:,4) = (/ &
        & 0.132669   , 0.175058   , 0.359263   , 0.388142   , &
        & 0.350359   , 0.475892   , 0.489593   , 0.408437   , &
        & 0.221049   , 1.94514e-02, 1.54848e-02, 1.44999e-02, &
        & 1.44568e-02, 1.00527e-02, 4.95897e-03, 5.73327e-04 /)
      sfluxrefo(:,5) = (/ &
        & 7.54800e-02, 0.232246   , 0.359263   , 0.388142   , &
        & 0.350359   , 0.426317   , 0.493485   , 0.432016   , &
        & 0.239203   , 1.74951e-02, 1.74477e-02, 1.83566e-02, &
        & 1.44818e-02, 1.01048e-02, 4.97487e-03, 5.66831e-04 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:,1) = (/ &
        & 9.07383E-01, 5.37775E-01, 4.22482E-01, 3.69359E-01,&
        & 2.57749E-01, 1.78219E-01, 5.73035E-02, 2.76551E-02,&
        & 1.79295E-02, 1.88887E-03, 2.27806E-03, 4.12725E-03,&
        & 5.33082E-03, 2.59712E-03, 2.60563E-04, 2.50225E-05/)
      irradnceo(:,2) = (/ &
        & 9.06133E-01, 5.04144E-01, 4.38272E-01, 3.81883E-01,&
        & 2.61401E-01, 1.77503E-01, 5.68636E-02, 2.76929E-02,&
        & 1.84592E-02, 2.34501E-03, 3.02949E-03, 5.59228E-03,&
        & 5.86033E-03, 2.88761E-03, 2.72104E-04, 2.50225E-05/)
      irradnceo(:,3) = (/ &
        & 4.35736E-01, 3.76471E-01, 3.06021E-01, 2.69023E-01,&
        & 1.65272E-01, 2.57586E-01, 4.84391E-01, 2.61161E-01,&
        & 1.81596E-01, 1.93819E-02, 1.49377E-02, 1.00317E-02,&
        & 7.09093E-03, 3.36316E-03, 2.76331E-04, 2.50225E-05/)
      irradnceo(:,4) = (/ &
        & 1.24783E-01, 1.70259E-01, 3.35267E-01, 3.55242E-01,&
        & 3.23879E-01, 4.33670E-01, 4.15873E-01, 3.73534E-01,&
        & 1.83517E-01, 2.56191E-02, 2.19227E-02, 1.47345E-02,&
        & 9.08306E-03, 4.52666E-03, 4.29098E-04, 2.50225E-05/)
      irradnceo(:,5) = (/ &
        & 6.78269E-02, 2.13269E-01, 3.35259E-01, 3.66552E-01,&
        & 3.23942E-01, 4.07399E-01, 3.94248E-01, 3.96335E-01,&
        & 2.06213E-01, 1.22173E-02, 1.93984E-02, 2.09580E-02,&
        & 1.69318E-02, 6.73835E-03, 4.41490E-03, 6.59772E-04/)
! Solar variability components: facular brightening
      facbrghto(:,1) = (/ &
        & 8.91083E-03, 6.84443E-03, 5.71469E-03, 5.25886E-03,&
        & 4.01843E-03, 2.67863E-03, 1.59003E-03, 8.87707E-04,&
        & 5.72727E-04, 6.26858E-05, 5.74131E-05, 6.48884E-05,&
        & 6.39183E-05, 3.43302E-05, 6.57289E-06, 7.60560E-07/)
      facbrghto(:,2) = (/ &
        & 8.88183E-03, 6.66773E-03, 5.86794E-03, 5.27225E-03,&
        & 4.02998E-03, 2.67997E-03, 1.56721E-03, 8.93159E-04,&
        & 5.83728E-04, 6.65573E-05, 6.50616E-05, 7.87391E-05,&
        & 6.92540E-05, 3.60978E-05, 6.64994E-06, 7.60560E-07/)
      facbrghto(:,3) = (/ &
        & 6.11926E-03, 5.51093E-03, 4.62766E-03, 4.06813E-03,&
        & 2.78474E-03, 3.40403E-03, 4.40433E-03, 3.16526E-03,&
        & 2.06720E-03, 2.09998E-04, 1.62499E-04, 1.15738E-04,&
        & 7.98177E-05, 3.98628E-05, 6.71483E-06, 7.60560E-07/)
      facbrghto(:,4) = (/ &
        & 2.62789E-03, 3.34884E-03, 5.04289E-03, 5.14489E-03,&
        & 4.60744E-03, 5.03800E-03, 4.80652E-03, 3.25168E-03,&
        & 2.13730E-03, 2.58043E-04, 2.01417E-04, 1.45555E-04,&
        & 9.88475E-05, 4.86660E-05, 8.18188E-06, 7.60560E-07/)
      facbrghto(:,5) = (/ &
        & 2.20399E-03, 3.63851E-03, 5.03885E-03, 5.20542E-03,&
        & 4.63369E-03, 4.70843E-03, 4.98380E-03, 3.37138E-03,&
        & 2.11721E-03, 2.36018E-04, 2.07222E-04, 1.77129E-04,&
        & 1.28754E-04, 8.20221E-05, 3.02731E-05, 4.21246E-06/)
! Solar variability components: sunspot darkening
      snsptdrko(:,1) = (/ &
        &-5.28062E-04,-2.83597E-04,-2.32372E-04,-2.58747E-04,&
        &-1.91129E-04,-1.29449E-04,-3.25204E-05,-1.69400E-05,&
        &-9.74093E-06,-1.07835E-06,-1.26181E-06,-2.16314E-06,&
        &-2.57283E-06,-1.15279E-06,-1.31837E-07,-1.17475E-08/)
      snsptdrko(:,2) = (/ &
        &-5.21927E-04,-2.63106E-04,-2.58798E-04,-2.57869E-04,&
        &-1.90618E-04,-1.29638E-04,-3.16669E-05,-1.72816E-05,&
        &-9.80625E-06,-1.25641E-06,-1.72169E-06,-2.93885E-06,&
        &-2.90100E-06,-1.25317E-06,-1.35435E-07,-1.17475E-08/)
      snsptdrko(:,3) = (/ &
        &-3.03741E-04,-2.48916E-04,-1.90259E-04,-1.78690E-04,&
        &-8.33300E-05,-1.30190E-04,-2.53327E-04,-1.64656E-04,&
        &-1.09880E-04,-1.02412E-05,-7.43813E-06,-5.12766E-06,&
        &-3.52154E-06,-1.46242E-06,-1.39075E-07,-1.17475E-08/)
      snsptdrko(:,4) = (/ &
        &-8.43784E-05,-1.13485E-04,-2.46730E-04,-2.48497E-04,&
        &-1.70458E-04,-2.32354E-04,-2.22118E-04,-2.02538E-04,&
        &-1.26094E-04,-1.77229E-05,-1.22901E-05,-7.39728E-06,&
        &-4.64782E-06,-1.99994E-06,-2.08533E-07,-1.17475E-08/)
      snsptdrko(:,5) = (/ &
        &-3.75562E-05,-1.51520E-04,-2.45761E-04,-2.53296E-04,&
        &-1.73440E-04,-2.17299E-04,-2.00193E-04,-2.27638E-04,&
        &-1.25297E-04,-1.37708E-05,-1.37472E-05,-1.33481E-05,&
        &-9.51791E-06,-6.06035E-06,-2.18137E-06,-3.03847E-07/)

! Rayleigh extinction coefficient at v = ????? cm-1.
      rayl = 2.02e-05

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1, 1) = (/ &
        & 0.46447e+02,0.18001e+03,0.31338e+03,0.44652e+03,0.54636e+03, &
        & 0.54173e+03,0.45707e+03,0.27363e+03,0.35000e+02 /)
      kao(:, 2, 1, 1) = (/ &
        & 0.45270e+02,0.17886e+03,0.31225e+03,0.44541e+03,0.54177e+03, &
        & 0.53436e+03,0.44932e+03,0.26748e+03,0.35000e+02 /)
      kao(:, 3, 1, 1) = (/ &
        & 0.44214e+02,0.17776e+03,0.31115e+03,0.44427e+03,0.53733e+03, &
        & 0.52756e+03,0.44224e+03,0.26195e+03,0.35000e+02 /)
      kao(:, 4, 1, 1) = (/ &
        & 0.43259e+02,0.17673e+03,0.31005e+03,0.44305e+03,0.53298e+03, &
        & 0.52129e+03,0.43574e+03,0.25696e+03,0.35000e+02 /)
      kao(:, 5, 1, 1) = (/ &
        & 0.42393e+02,0.17575e+03,0.30896e+03,0.44173e+03,0.52883e+03, &
        & 0.51548e+03,0.42976e+03,0.25242e+03,0.35000e+02 /)
      kao(:, 1, 2, 1) = (/ &
        & 0.42908e+02,0.17695e+03,0.31077e+03,0.44434e+03,0.53161e+03, &
        & 0.51895e+03,0.43332e+03,0.25512e+03,0.35000e+02 /)
      kao(:, 2, 2, 1) = (/ &
        & 0.41899e+02,0.17596e+03,0.30980e+03,0.44336e+03,0.52686e+03, &
        & 0.51213e+03,0.42632e+03,0.24984e+03,0.35000e+02 /)
      kao(:, 3, 2, 1) = (/ &
        & 0.40995e+02,0.17502e+03,0.30884e+03,0.44232e+03,0.52230e+03, &
        & 0.50592e+03,0.41995e+03,0.24511e+03,0.35000e+02 /)
      kao(:, 4, 2, 1) = (/ &
        & 0.40181e+02,0.17412e+03,0.30788e+03,0.44119e+03,0.51785e+03, &
        & 0.50025e+03,0.41414e+03,0.24085e+03,0.35000e+02 /)
      kao(:, 5, 2, 1) = (/ &
        & 0.39443e+02,0.17326e+03,0.30691e+03,0.43992e+03,0.51364e+03, &
        & 0.49503e+03,0.40882e+03,0.23699e+03,0.35000e+02 /)
      kao(:, 1, 3, 1) = (/ &
        & 0.40126e+02,0.17457e+03,0.30876e+03,0.44248e+03,0.51755e+03, &
        & 0.49986e+03,0.41375e+03,0.24056e+03,0.35000e+02 /)
      kao(:, 2, 3, 1) = (/ &
        & 0.39240e+02,0.17370e+03,0.30792e+03,0.44146e+03,0.51254e+03, &
        & 0.49358e+03,0.40735e+03,0.23593e+03,0.35000e+02 /)
      kao(:, 3, 3, 1) = (/ &
        & 0.38450e+02,0.17288e+03,0.30708e+03,0.44031e+03,0.50793e+03, &
        & 0.48786e+03,0.40155e+03,0.23179e+03,0.35000e+02 /)
      kao(:, 4, 3, 1) = (/ &
        & 0.37740e+02,0.17210e+03,0.30624e+03,0.43908e+03,0.50368e+03, &
        & 0.48264e+03,0.39629e+03,0.22808e+03,0.35000e+02 /)
      kao(:, 5, 3, 1) = (/ &
        & 0.37099e+02,0.17134e+03,0.30539e+03,0.43781e+03,0.49975e+03, &
        & 0.47787e+03,0.39149e+03,0.22473e+03,0.35000e+02 /)
      kao(:, 1, 4, 1) = (/ &
        & 0.37818e+02,0.17258e+03,0.30708e+03,0.43967e+03,0.50412e+03, &
        & 0.48321e+03,0.39687e+03,0.22848e+03,0.35000e+02 /)
      kao(:, 2, 4, 1) = (/ &
        & 0.37034e+02,0.17183e+03,0.30636e+03,0.43833e+03,0.49935e+03, &
        & 0.47738e+03,0.39100e+03,0.22439e+03,0.35000e+02 /)
      kao(:, 3, 4, 1) = (/ &
        & 0.36338e+02,0.17111e+03,0.30564e+03,0.43700e+03,0.49496e+03, &
        & 0.47212e+03,0.38572e+03,0.22075e+03,0.35000e+02 /)
      kao(:, 4, 4, 1) = (/ &
        & 0.35716e+02,0.17043e+03,0.30491e+03,0.43569e+03,0.49094e+03, &
        & 0.46732e+03,0.38094e+03,0.21749e+03,0.35000e+02 /)
      kao(:, 5, 4, 1) = (/ &
        & 0.35156e+02,0.16977e+03,0.30416e+03,0.43437e+03,0.48726e+03, &
        & 0.46294e+03,0.37660e+03,0.21456e+03,0.35000e+02 /)
      kao(:, 1, 5, 1) = (/ &
        & 0.35857e+02,0.17089e+03,0.30563e+03,0.43619e+03,0.49186e+03, &
        & 0.46841e+03,0.38202e+03,0.21822e+03,0.35000e+02 /)
      kao(:, 2, 5, 1) = (/ &
        & 0.35163e+02,0.17023e+03,0.30502e+03,0.43478e+03,0.48731e+03, &
        & 0.46300e+03,0.37666e+03,0.21460e+03,0.35000e+02 /)
      kao(:, 3, 5, 1) = (/ &
        & 0.34550e+02,0.16961e+03,0.30441e+03,0.43332e+03,0.48321e+03, &
        & 0.45813e+03,0.37186e+03,0.21139e+03,0.35000e+02 /)
      kao(:, 4, 5, 1) = (/ &
        & 0.34004e+02,0.16902e+03,0.30378e+03,0.43194e+03,0.47950e+03, &
        & 0.45375e+03,0.36755e+03,0.20853e+03,0.35000e+02 /)
      kao(:, 5, 5, 1) = (/ &
        & 0.33514e+02,0.16844e+03,0.30312e+03,0.43058e+03,0.47611e+03, &
        & 0.44977e+03,0.36365e+03,0.20597e+03,0.35000e+02 /)
      kao(:, 1, 6, 1) = (/ &
        & 0.34212e+02,0.16946e+03,0.30440e+03,0.43247e+03,0.48092e+03, &
        & 0.45542e+03,0.36920e+03,0.20962e+03,0.35000e+02 /)
      kao(:, 2, 6, 1) = (/ &
        & 0.33595e+02,0.16889e+03,0.30389e+03,0.43093e+03,0.47667e+03, &
        & 0.45043e+03,0.36430e+03,0.20639e+03,0.35000e+02 /)
      kao(:, 3, 6, 1) = (/ &
        & 0.33052e+02,0.16835e+03,0.30337e+03,0.42946e+03,0.47287e+03, &
        & 0.44599e+03,0.35993e+03,0.20355e+03,0.35000e+02 /)
      kao(:, 4, 6, 1) = (/ &
        & 0.32571e+02,0.16784e+03,0.30283e+03,0.42807e+03,0.46947e+03, &
        & 0.44201e+03,0.35602e+03,0.20103e+03,0.35000e+02 /)
      kao(:, 5, 6, 1) = (/ &
        & 0.32141e+02,0.16733e+03,0.30227e+03,0.42674e+03,0.46640e+03, &
        & 0.43842e+03,0.35250e+03,0.19879e+03,0.35000e+02 /)
      kao(:, 1, 7, 1) = (/ &
        & 0.32812e+02,0.16823e+03,0.30334e+03,0.42859e+03,0.47118e+03, &
        & 0.44401e+03,0.35799e+03,0.20230e+03,0.35000e+02 /)
      kao(:, 2, 7, 1) = (/ &
        & 0.32263e+02,0.16774e+03,0.30291e+03,0.42708e+03,0.46727e+03, &
        & 0.43944e+03,0.35350e+03,0.19942e+03,0.35000e+02 /)
      kao(:, 3, 7, 1) = (/ &
        & 0.31782e+02,0.16728e+03,0.30248e+03,0.42558e+03,0.46381e+03, &
        & 0.43539e+03,0.34954e+03,0.19691e+03,0.35000e+02 /)
      kao(:, 4, 7, 1) = (/ &
        & 0.31357e+02,0.16683e+03,0.30203e+03,0.42413e+03,0.46069e+03, &
        & 0.43177e+03,0.34599e+03,0.19468e+03,0.35000e+02 /)
      kao(:, 5, 7, 1) = (/ &
        & 0.30980e+02,0.16640e+03,0.30154e+03,0.42276e+03,0.45787e+03, &
        & 0.42852e+03,0.34280e+03,0.19271e+03,0.35000e+02 /)
      kao(:, 1, 8, 1) = (/ &
        & 0.31614e+02,0.16716e+03,0.30239e+03,0.42473e+03,0.46259e+03, &
        & 0.43397e+03,0.34814e+03,0.19603e+03,0.35000e+02 /)
      kao(:, 2, 8, 1) = (/ &
        & 0.31125e+02,0.16674e+03,0.30206e+03,0.42311e+03,0.45896e+03, &
        & 0.42978e+03,0.34403e+03,0.19347e+03,0.35000e+02 /)
      kao(:, 3, 8, 1) = (/ &
        & 0.30699e+02,0.16635e+03,0.30170e+03,0.42163e+03,0.45573e+03, &
        & 0.42608e+03,0.34039e+03,0.19124e+03,0.35000e+02 /)
      kao(:, 4, 8, 1) = (/ &
        & 0.30325e+02,0.16597e+03,0.30133e+03,0.42027e+03,0.45286e+03, &
        & 0.42281e+03,0.33716e+03,0.18928e+03,0.35000e+02 /)
      kao(:, 5, 8, 1) = (/ &
        & 0.29993e+02,0.16559e+03,0.30092e+03,0.41901e+03,0.45030e+03, &
        & 0.41988e+03,0.33427e+03,0.18755e+03,0.35000e+02 /)
      kao(:, 1, 9, 1) = (/ &
        & 0.30594e+02,0.16624e+03,0.30156e+03,0.42087e+03,0.45493e+03, &
        & 0.42517e+03,0.33949e+03,0.19069e+03,0.35000e+02 /)
      kao(:, 2, 9, 1) = (/ &
        & 0.30158e+02,0.16589e+03,0.30131e+03,0.41937e+03,0.45157e+03, &
        & 0.42134e+03,0.33570e+03,0.18841e+03,0.35000e+02 /)
      kao(:, 3, 9, 1) = (/ &
        & 0.29780e+02,0.16556e+03,0.30103e+03,0.41800e+03,0.44864e+03, &
        & 0.41799e+03,0.33239e+03,0.18643e+03,0.35000e+02 /)
      kao(:, 4, 9, 1) = (/ &
        & 0.29450e+02,0.16523e+03,0.30072e+03,0.41674e+03,0.44606e+03, &
        & 0.41504e+03,0.32946e+03,0.18471e+03,0.35000e+02 /)
      kao(:, 5, 9, 1) = (/ &
        & 0.29159e+02,0.16491e+03,0.30039e+03,0.41557e+03,0.44377e+03, &
        & 0.41242e+03,0.32686e+03,0.18318e+03,0.35000e+02 /)
      kao(:, 1,10, 1) = (/ &
        & 0.29691e+02,0.16541e+03,0.30081e+03,0.41722e+03,0.44795e+03, &
        & 0.41720e+03,0.33160e+03,0.18597e+03,0.35000e+02 /)
      kao(:, 2,10, 1) = (/ &
        & 0.29307e+02,0.16512e+03,0.30063e+03,0.41581e+03,0.44493e+03, &
        & 0.41375e+03,0.32818e+03,0.18396e+03,0.35000e+02 /)
      kao(:, 3,10, 1) = (/ &
        & 0.28975e+02,0.16485e+03,0.30042e+03,0.41454e+03,0.44231e+03, &
        & 0.41076e+03,0.32520e+03,0.18222e+03,0.35000e+02 /)
      kao(:, 4,10, 1) = (/ &
        & 0.28687e+02,0.16458e+03,0.30018e+03,0.41340e+03,0.44002e+03, &
        & 0.40814e+03,0.32259e+03,0.18071e+03,0.35000e+02 /)
      kao(:, 5,10, 1) = (/ &
        & 0.28434e+02,0.16431e+03,0.29989e+03,0.41235e+03,0.43799e+03, &
        & 0.40583e+03,0.32028e+03,0.17939e+03,0.35000e+02 /)
      kao(:, 1,11, 1) = (/ &
        & 0.28760e+02,0.16459e+03,0.30010e+03,0.41321e+03,0.44060e+03, &
        & 0.40880e+03,0.32325e+03,0.18109e+03,0.35000e+02 /)
      kao(:, 2,11, 1) = (/ &
        & 0.28444e+02,0.16436e+03,0.29997e+03,0.41200e+03,0.43807e+03, &
        & 0.40592e+03,0.32038e+03,0.17944e+03,0.35000e+02 /)
      kao(:, 3,11, 1) = (/ &
        & 0.28173e+02,0.16414e+03,0.29981e+03,0.41092e+03,0.43587e+03, &
        & 0.40342e+03,0.31788e+03,0.17802e+03,0.35000e+02 /)
      kao(:, 4,11, 1) = (/ &
        & 0.27937e+02,0.16392e+03,0.29960e+03,0.40994e+03,0.43395e+03, &
        & 0.40124e+03,0.31570e+03,0.17679e+03,0.35000e+02 /)
      kao(:, 5,11, 1) = (/ &
        & 0.27730e+02,0.16369e+03,0.29936e+03,0.40905e+03,0.43224e+03, &
        & 0.39931e+03,0.31377e+03,0.17571e+03,0.35000e+02 /)
      kao(:, 1,12, 1) = (/ &
        & 0.27995e+02,0.16391e+03,0.29951e+03,0.40970e+03,0.43443e+03, &
        & 0.40178e+03,0.31624e+03,0.17709e+03,0.35000e+02 /)
      kao(:, 2,12, 1) = (/ &
        & 0.27737e+02,0.16374e+03,0.29943e+03,0.40869e+03,0.43230e+03, &
        & 0.39938e+03,0.31384e+03,0.17574e+03,0.35000e+02 /)
      kao(:, 3,12, 1) = (/ &
        & 0.27515e+02,0.16356e+03,0.29930e+03,0.40779e+03,0.43046e+03, &
        & 0.39730e+03,0.31176e+03,0.17458e+03,0.35000e+02 /)
      kao(:, 4,12, 1) = (/ &
        & 0.27322e+02,0.16338e+03,0.29913e+03,0.40697e+03,0.42883e+03, &
        & 0.39548e+03,0.30994e+03,0.17357e+03,0.35000e+02 /)
      kao(:, 5,12, 1) = (/ &
        & 0.27152e+02,0.16318e+03,0.29892e+03,0.40622e+03,0.42740e+03, &
        & 0.39387e+03,0.30834e+03,0.17268e+03,0.35000e+02 /)
      kao(:, 1,13, 1) = (/ &
        & 0.27369e+02,0.16336e+03,0.29903e+03,0.40671e+03,0.42924e+03, &
        & 0.39593e+03,0.31039e+03,0.17382e+03,0.35000e+02 /)
      kao(:, 2,13, 1) = (/ &
        & 0.27158e+02,0.16323e+03,0.29898e+03,0.40587e+03,0.42745e+03, &
        & 0.39393e+03,0.30840e+03,0.17271e+03,0.35000e+02 /)
      kao(:, 3,13, 1) = (/ &
        & 0.26976e+02,0.16309e+03,0.29889e+03,0.40513e+03,0.42590e+03, &
        & 0.39221e+03,0.30667e+03,0.17176e+03,0.35000e+02 /)
      kao(:, 4,13, 1) = (/ &
        & 0.26818e+02,0.16293e+03,0.29875e+03,0.40445e+03,0.42455e+03, &
        & 0.39070e+03,0.30516e+03,0.17093e+03,0.35000e+02 /)
      kao(:, 5,13, 1) = (/ &
        & 0.26679e+02,0.16276e+03,0.29855e+03,0.40381e+03,0.42335e+03, &
        & 0.38937e+03,0.30384e+03,0.17021e+03,0.35000e+02 /)
      kao(:, 1, 1, 2) = (/ &
        & 0.17271e+03,0.27646e+03,0.38039e+03,0.48420e+03,0.56932e+03, &
        & 0.57534e+03,0.47873e+03,0.28147e+03,0.71840e+02 /)
      kao(:, 2, 1, 2) = (/ &
        & 0.16834e+03,0.27246e+03,0.37678e+03,0.48091e+03,0.56471e+03, &
        & 0.56734e+03,0.47005e+03,0.27593e+03,0.71840e+02 /)
      kao(:, 3, 1, 2) = (/ &
        & 0.16441e+03,0.26883e+03,0.37341e+03,0.47777e+03,0.56037e+03, &
        & 0.56003e+03,0.46210e+03,0.27096e+03,0.71840e+02 /)
      kao(:, 4, 1, 2) = (/ &
        & 0.16086e+03,0.26548e+03,0.37025e+03,0.47479e+03,0.55629e+03, &
        & 0.55327e+03,0.45481e+03,0.26647e+03,0.71840e+02 /)
      kao(:, 5, 1, 2) = (/ &
        & 0.15764e+03,0.26237e+03,0.36725e+03,0.47195e+03,0.55235e+03, &
        & 0.54701e+03,0.44810e+03,0.26239e+03,0.71840e+02 /)
      kao(:, 1, 2, 2) = (/ &
        & 0.15955e+03,0.26500e+03,0.37067e+03,0.47595e+03,0.55480e+03, &
        & 0.55074e+03,0.45210e+03,0.26482e+03,0.71840e+02 /)
      kao(:, 2, 2, 2) = (/ &
        & 0.15580e+03,0.26157e+03,0.36756e+03,0.47303e+03,0.55028e+03, &
        & 0.54339e+03,0.44423e+03,0.26007e+03,0.71840e+02 /)
      kao(:, 3, 2, 2) = (/ &
        & 0.15244e+03,0.25844e+03,0.36465e+03,0.47023e+03,0.54619e+03, &
        & 0.53664e+03,0.43708e+03,0.25581e+03,0.71840e+02 /)
      kao(:, 4, 2, 2) = (/ &
        & 0.14941e+03,0.25556e+03,0.36191e+03,0.46753e+03,0.54253e+03, &
        & 0.53041e+03,0.43052e+03,0.25198e+03,0.71840e+02 /)
      kao(:, 5, 2, 2) = (/ &
        & 0.14667e+03,0.25289e+03,0.35930e+03,0.46494e+03,0.53908e+03, &
        & 0.52470e+03,0.42448e+03,0.24851e+03,0.71840e+02 /)
      kao(:, 1, 3, 2) = (/ &
        & 0.14921e+03,0.25601e+03,0.36308e+03,0.46872e+03,0.54234e+03, &
        & 0.52999e+03,0.43007e+03,0.25172e+03,0.71840e+02 /)
      kao(:, 2, 3, 2) = (/ &
        & 0.14591e+03,0.25301e+03,0.36036e+03,0.46599e+03,0.53834e+03, &
        & 0.52313e+03,0.42280e+03,0.24755e+03,0.71840e+02 /)
      kao(:, 3, 3, 2) = (/ &
        & 0.14297e+03,0.25028e+03,0.35782e+03,0.46350e+03,0.53459e+03, &
        & 0.51696e+03,0.41619e+03,0.24383e+03,0.71840e+02 /)
      kao(:, 4, 3, 2) = (/ &
        & 0.14033e+03,0.24777e+03,0.35542e+03,0.46116e+03,0.53100e+03, &
        & 0.51122e+03,0.41016e+03,0.24049e+03,0.71840e+02 /)
      kao(:, 5, 3, 2) = (/ &
        & 0.13795e+03,0.24544e+03,0.35313e+03,0.45882e+03,0.52751e+03, &
        & 0.50591e+03,0.40463e+03,0.23747e+03,0.71840e+02 /)
      kao(:, 1, 4, 2) = (/ &
        & 0.14062e+03,0.24856e+03,0.35678e+03,0.46260e+03,0.53137e+03, &
        & 0.51186e+03,0.41082e+03,0.24086e+03,0.71840e+02 /)
      kao(:, 2, 4, 2) = (/ &
        & 0.13771e+03,0.24592e+03,0.35440e+03,0.46020e+03,0.52732e+03, &
        & 0.50537e+03,0.40407e+03,0.23717e+03,0.71840e+02 /)
      kao(:, 3, 4, 2) = (/ &
        & 0.13512e+03,0.24353e+03,0.35219e+03,0.45796e+03,0.52348e+03, &
        & 0.49954e+03,0.39798e+03,0.23389e+03,0.71840e+02 /)
      kao(:, 4, 4, 2) = (/ &
        & 0.13281e+03,0.24133e+03,0.35008e+03,0.45583e+03,0.51985e+03, &
        & 0.49431e+03,0.39246e+03,0.23096e+03,0.71840e+02 /)
      kao(:, 5, 4, 2) = (/ &
        & 0.13073e+03,0.23928e+03,0.34807e+03,0.45378e+03,0.51643e+03, &
        & 0.48957e+03,0.38745e+03,0.22833e+03,0.71840e+02 /)
      kao(:, 1, 5, 2) = (/ &
        & 0.13333e+03,0.24222e+03,0.35141e+03,0.45702e+03,0.52057e+03, &
        & 0.49550e+03,0.39372e+03,0.23163e+03,0.71840e+02 /)
      kao(:, 2, 5, 2) = (/ &
        & 0.13075e+03,0.23990e+03,0.34934e+03,0.45476e+03,0.51651e+03, &
        & 0.48963e+03,0.38752e+03,0.22836e+03,0.71840e+02 /)
      kao(:, 3, 5, 2) = (/ &
        & 0.12847e+03,0.23780e+03,0.34741e+03,0.45266e+03,0.51271e+03, &
        & 0.48438e+03,0.38196e+03,0.22548e+03,0.71840e+02 /)
      kao(:, 4, 5, 2) = (/ &
        & 0.12644e+03,0.23588e+03,0.34557e+03,0.45066e+03,0.50911e+03, &
        & 0.47962e+03,0.37696e+03,0.22291e+03,0.71840e+02 /)
      kao(:, 5, 5, 2) = (/ &
        & 0.12462e+03,0.23409e+03,0.34381e+03,0.44874e+03,0.50570e+03, &
        & 0.47526e+03,0.37245e+03,0.22060e+03,0.71840e+02 /)
      kao(:, 1, 6, 2) = (/ &
        & 0.12722e+03,0.23690e+03,0.34688e+03,0.45177e+03,0.51032e+03, &
        & 0.48144e+03,0.37887e+03,0.22389e+03,0.71840e+02 /)
      kao(:, 2, 6, 2) = (/ &
        & 0.12492e+03,0.23485e+03,0.34508e+03,0.44967e+03,0.50620e+03, &
        & 0.47598e+03,0.37319e+03,0.22098e+03,0.71840e+02 /)
      kao(:, 3, 6, 2) = (/ &
        & 0.12290e+03,0.23301e+03,0.34340e+03,0.44769e+03,0.50242e+03, &
        & 0.47108e+03,0.36815e+03,0.21843e+03,0.71840e+02 /)
      kao(:, 4, 6, 2) = (/ &
        & 0.12111e+03,0.23132e+03,0.34180e+03,0.44582e+03,0.49894e+03, &
        & 0.46668e+03,0.36363e+03,0.21616e+03,0.71840e+02 /)
      kao(:, 5, 6, 2) = (/ &
        & 0.11952e+03,0.22976e+03,0.34026e+03,0.44407e+03,0.49574e+03, &
        & 0.46270e+03,0.35956e+03,0.21414e+03,0.71840e+02 /)
      kao(:, 1, 7, 2) = (/ &
        & 0.12201e+03,0.23235e+03,0.34300e+03,0.44700e+03,0.50054e+03, &
        & 0.46889e+03,0.36590e+03,0.21730e+03,0.71840e+02 /)
      kao(:, 2, 7, 2) = (/ &
        & 0.11997e+03,0.23055e+03,0.34145e+03,0.44492e+03,0.49657e+03, &
        & 0.46383e+03,0.36071e+03,0.21471e+03,0.71840e+02 /)
      kao(:, 3, 7, 2) = (/ &
        & 0.11818e+03,0.22894e+03,0.33999e+03,0.44309e+03,0.49292e+03, &
        & 0.45934e+03,0.35613e+03,0.21245e+03,0.71840e+02 /)
      kao(:, 4, 7, 2) = (/ &
        & 0.11660e+03,0.22746e+03,0.33859e+03,0.44146e+03,0.48959e+03, &
        & 0.45533e+03,0.35208e+03,0.21045e+03,0.71840e+02 /)
      kao(:, 5, 7, 2) = (/ &
        & 0.11520e+03,0.22609e+03,0.33724e+03,0.43996e+03,0.48657e+03, &
        & 0.45175e+03,0.34847e+03,0.20867e+03,0.71840e+02 /)
      kao(:, 1, 8, 2) = (/ &
        & 0.11756e+03,0.22844e+03,0.33965e+03,0.44261e+03,0.49147e+03, &
        & 0.45776e+03,0.35454e+03,0.21166e+03,0.71840e+02 /)
      kao(:, 2, 8, 2) = (/ &
        & 0.11574e+03,0.22687e+03,0.33830e+03,0.44082e+03,0.48767e+03, &
        & 0.45313e+03,0.34986e+03,0.20936e+03,0.71840e+02 /)
      kao(:, 3, 8, 2) = (/ &
        & 0.11415e+03,0.22546e+03,0.33704e+03,0.43915e+03,0.48429e+03, &
        & 0.44908e+03,0.34579e+03,0.20735e+03,0.71840e+02 /)
      kao(:, 4, 8, 2) = (/ &
        & 0.11276e+03,0.22417e+03,0.33584e+03,0.43758e+03,0.48126e+03, &
        & 0.44549e+03,0.34220e+03,0.20559e+03,0.71840e+02 /)
      kao(:, 5, 8, 2) = (/ &
        & 0.11153e+03,0.22298e+03,0.33466e+03,0.43617e+03,0.47855e+03, &
        & 0.44228e+03,0.33902e+03,0.20403e+03,0.71840e+02 /)
      kao(:, 1, 9, 2) = (/ &
        & 0.11376e+03,0.22510e+03,0.33674e+03,0.43882e+03,0.48336e+03, &
        & 0.44807e+03,0.34479e+03,0.20686e+03,0.71840e+02 /)
      kao(:, 2, 9, 2) = (/ &
        & 0.11214e+03,0.22372e+03,0.33559e+03,0.43706e+03,0.47989e+03, &
        & 0.44388e+03,0.34060e+03,0.20480e+03,0.71840e+02 /)
      kao(:, 3, 9, 2) = (/ &
        & 0.11074e+03,0.22250e+03,0.33451e+03,0.43547e+03,0.47679e+03, &
        & 0.44020e+03,0.33697e+03,0.20303e+03,0.71840e+02 /)
      kao(:, 4, 9, 2) = (/ &
        & 0.10951e+03,0.22138e+03,0.33348e+03,0.43404e+03,0.47404e+03, &
        & 0.43694e+03,0.33379e+03,0.20147e+03,0.71840e+02 /)
      kao(:, 5, 9, 2) = (/ &
        & 0.10843e+03,0.22034e+03,0.33246e+03,0.43277e+03,0.47159e+03, &
        & 0.43405e+03,0.33096e+03,0.20010e+03,0.71840e+02 /)
      kao(:, 1,10, 2) = (/ &
        & 0.11041e+03,0.22214e+03,0.33414e+03,0.43517e+03,0.47604e+03, &
        & 0.43932e+03,0.33611e+03,0.20261e+03,0.71840e+02 /)
      kao(:, 2,10, 2) = (/ &
        & 0.10898e+03,0.22095e+03,0.33317e+03,0.43358e+03,0.47283e+03, &
        & 0.43552e+03,0.33239e+03,0.20080e+03,0.71840e+02 /)
      kao(:, 3,10, 2) = (/ &
        & 0.10774e+03,0.21989e+03,0.33226e+03,0.43213e+03,0.47002e+03, &
        & 0.43222e+03,0.32917e+03,0.19924e+03,0.71840e+02 /)
      kao(:, 4,10, 2) = (/ &
        & 0.10667e+03,0.21893e+03,0.33139e+03,0.43083e+03,0.46753e+03, &
        & 0.42932e+03,0.32634e+03,0.19788e+03,0.71840e+02 /)
      kao(:, 5,10, 2) = (/ &
        & 0.10573e+03,0.21803e+03,0.33053e+03,0.42965e+03,0.46532e+03, &
        & 0.42677e+03,0.32386e+03,0.19669e+03,0.71840e+02 /)
      kao(:, 1,11, 2) = (/ &
        & 0.10694e+03,0.21911e+03,0.33152e+03,0.43127e+03,0.46816e+03, &
        & 0.43005e+03,0.32706e+03,0.19822e+03,0.71840e+02 /)
      kao(:, 2,11, 2) = (/ &
        & 0.10577e+03,0.21815e+03,0.33074e+03,0.42984e+03,0.46541e+03, &
        & 0.42687e+03,0.32396e+03,0.19674e+03,0.71840e+02 /)
      kao(:, 3,11, 2) = (/ &
        & 0.10476e+03,0.21728e+03,0.33000e+03,0.42855e+03,0.46301e+03, &
        & 0.42411e+03,0.32130e+03,0.19546e+03,0.71840e+02 /)
      kao(:, 4,11, 2) = (/ &
        & 0.10388e+03,0.21649e+03,0.32928e+03,0.42741e+03,0.46089e+03, &
        & 0.42169e+03,0.31897e+03,0.19435e+03,0.71840e+02 /)
      kao(:, 5,11, 2) = (/ &
        & 0.10311e+03,0.21575e+03,0.32855e+03,0.42639e+03,0.45902e+03, &
        & 0.41954e+03,0.31692e+03,0.19338e+03,0.71840e+02 /)
      kao(:, 1,12, 2) = (/ &
        & 0.10410e+03,0.21663e+03,0.32937e+03,0.42778e+03,0.46141e+03, &
        & 0.42229e+03,0.31955e+03,0.19463e+03,0.71840e+02 /)
      kao(:, 2,12, 2) = (/ &
        & 0.10314e+03,0.21585e+03,0.32875e+03,0.42654e+03,0.45909e+03, &
        & 0.41961e+03,0.31700e+03,0.19341e+03,0.71840e+02 /)
      kao(:, 3,12, 2) = (/ &
        & 0.10231e+03,0.21515e+03,0.32815e+03,0.42544e+03,0.45707e+03, &
        & 0.41729e+03,0.31480e+03,0.19236e+03,0.71840e+02 /)
      kao(:, 4,12, 2) = (/ &
        & 0.10159e+03,0.21449e+03,0.32754e+03,0.42445e+03,0.45532e+03, &
        & 0.41526e+03,0.31288e+03,0.19145e+03,0.71840e+02 /)
      kao(:, 5,12, 2) = (/ &
        & 0.10096e+03,0.21387e+03,0.32692e+03,0.42356e+03,0.45377e+03, &
        & 0.41347e+03,0.31119e+03,0.19066e+03,0.71840e+02 /)
      kao(:, 1,13, 2) = (/ &
        & 0.10177e+03,0.21460e+03,0.32761e+03,0.42475e+03,0.45575e+03, &
        & 0.41576e+03,0.31335e+03,0.19168e+03,0.71840e+02 /)
      kao(:, 2,13, 2) = (/ &
        & 0.10099e+03,0.21397e+03,0.32712e+03,0.42368e+03,0.45383e+03, &
        & 0.41353e+03,0.31125e+03,0.19068e+03,0.71840e+02 /)
      kao(:, 3,13, 2) = (/ &
        & 0.10031e+03,0.21340e+03,0.32663e+03,0.42272e+03,0.45216e+03, &
        & 0.41160e+03,0.30943e+03,0.18983e+03,0.71840e+02 /)
      kao(:, 4,13, 2) = (/ &
        & 0.99720e+02,0.21286e+03,0.32612e+03,0.42187e+03,0.45071e+03, &
        & 0.40991e+03,0.30785e+03,0.18908e+03,0.71840e+02 /)
      kao(:, 5,13, 2) = (/ &
        & 0.99204e+02,0.21233e+03,0.32558e+03,0.42112e+03,0.44942e+03, &
        & 0.40842e+03,0.30646e+03,0.18843e+03,0.71840e+02 /)
      kao(:, 1, 1, 3) = (/ &
        & 0.44909e+03,0.47445e+03,0.49981e+03,0.52556e+03,0.59352e+03, &
        & 0.63011e+03,0.50440e+03,0.31793e+03,0.17829e+03 /)
      kao(:, 2, 1, 3) = (/ &
        & 0.43771e+03,0.46449e+03,0.49128e+03,0.51852e+03,0.58982e+03, &
        & 0.62155e+03,0.49364e+03,0.31383e+03,0.17829e+03 /)
      kao(:, 3, 1, 3) = (/ &
        & 0.42749e+03,0.45555e+03,0.48362e+03,0.51220e+03,0.58623e+03, &
        & 0.61324e+03,0.48379e+03,0.31014e+03,0.17829e+03 /)
      kao(:, 4, 1, 3) = (/ &
        & 0.41826e+03,0.44748e+03,0.47670e+03,0.50650e+03,0.58281e+03, &
        & 0.60555e+03,0.47483e+03,0.30681e+03,0.17829e+03 /)
      kao(:, 5, 1, 3) = (/ &
        & 0.40989e+03,0.44015e+03,0.47042e+03,0.50132e+03,0.57944e+03, &
        & 0.59846e+03,0.46657e+03,0.30379e+03,0.17829e+03 /)
      kao(:, 1, 2, 3) = (/ &
        & 0.41487e+03,0.44451e+03,0.47415e+03,0.50447e+03,0.58410e+03, &
        & 0.60269e+03,0.47150e+03,0.30559e+03,0.17829e+03 /)
      kao(:, 2, 2, 3) = (/ &
        & 0.40511e+03,0.43597e+03,0.46683e+03,0.49854e+03,0.58056e+03, &
        & 0.59434e+03,0.46181e+03,0.30207e+03,0.17829e+03 /)
      kao(:, 3, 2, 3) = (/ &
        & 0.39637e+03,0.42832e+03,0.46028e+03,0.49326e+03,0.57701e+03, &
        & 0.58648e+03,0.45298e+03,0.29892e+03,0.17829e+03 /)
      kao(:, 4, 2, 3) = (/ &
        & 0.38850e+03,0.42143e+03,0.45437e+03,0.48855e+03,0.57350e+03, &
        & 0.57914e+03,0.44500e+03,0.29608e+03,0.17829e+03 /)
      kao(:, 5, 2, 3) = (/ &
        & 0.38136e+03,0.41519e+03,0.44902e+03,0.48433e+03,0.57004e+03, &
        & 0.57245e+03,0.43774e+03,0.29351e+03,0.17829e+03 /)
      kao(:, 1, 3, 3) = (/ &
        & 0.38797e+03,0.42097e+03,0.45397e+03,0.48897e+03,0.57508e+03, &
        & 0.57865e+03,0.44446e+03,0.29589e+03,0.17829e+03 /)
      kao(:, 2, 3, 3) = (/ &
        & 0.37940e+03,0.41348e+03,0.44755e+03,0.48416e+03,0.57138e+03, &
        & 0.57059e+03,0.43573e+03,0.29280e+03,0.17829e+03 /)
      kao(:, 3, 3, 3) = (/ &
        & 0.37176e+03,0.40679e+03,0.44182e+03,0.47985e+03,0.56781e+03, &
        & 0.56324e+03,0.42791e+03,0.29005e+03,0.17829e+03 /)
      kao(:, 4, 3, 3) = (/ &
        & 0.36490e+03,0.40078e+03,0.43667e+03,0.47599e+03,0.56436e+03, &
        & 0.55656e+03,0.42088e+03,0.28757e+03,0.17829e+03 /)
      kao(:, 5, 3, 3) = (/ &
        & 0.35870e+03,0.39536e+03,0.43202e+03,0.47253e+03,0.56109e+03, &
        & 0.55041e+03,0.41448e+03,0.28534e+03,0.17829e+03 /)
      kao(:, 1, 4, 3) = (/ &
        & 0.36565e+03,0.40144e+03,0.43723e+03,0.47759e+03,0.56581e+03, &
        & 0.55729e+03,0.42164e+03,0.28784e+03,0.17829e+03 /)
      kao(:, 2, 4, 3) = (/ &
        & 0.35808e+03,0.39482e+03,0.43155e+03,0.47386e+03,0.56215e+03, &
        & 0.54978e+03,0.41381e+03,0.28511e+03,0.17829e+03 /)
      kao(:, 3, 4, 3) = (/ &
        & 0.35135e+03,0.38893e+03,0.42651e+03,0.47052e+03,0.55875e+03, &
        & 0.54295e+03,0.40683e+03,0.28269e+03,0.17829e+03 /)
      kao(:, 4, 4, 3) = (/ &
        & 0.34533e+03,0.38366e+03,0.42199e+03,0.46746e+03,0.55555e+03, &
        & 0.53669e+03,0.40055e+03,0.28052e+03,0.17829e+03 /)
      kao(:, 5, 4, 3) = (/ &
        & 0.33991e+03,0.37892e+03,0.41793e+03,0.46467e+03,0.55244e+03, &
        & 0.53093e+03,0.39488e+03,0.27856e+03,0.17829e+03 /)
      kao(:, 1, 5, 3) = (/ &
        & 0.34669e+03,0.38485e+03,0.42301e+03,0.46943e+03,0.55667e+03, &
        & 0.53812e+03,0.40197e+03,0.28101e+03,0.17829e+03 /)
      kao(:, 2, 5, 3) = (/ &
        & 0.33999e+03,0.37899e+03,0.41799e+03,0.46662e+03,0.55311e+03, &
        & 0.53101e+03,0.39496e+03,0.27859e+03,0.17829e+03 /)
      kao(:, 3, 5, 3) = (/ &
        & 0.33406e+03,0.37380e+03,0.41354e+03,0.46416e+03,0.54976e+03, &
        & 0.52459e+03,0.38873e+03,0.27645e+03,0.17829e+03 /)
      kao(:, 4, 5, 3) = (/ &
        & 0.32878e+03,0.36918e+03,0.40958e+03,0.46185e+03,0.54671e+03, &
        & 0.51881e+03,0.38326e+03,0.27455e+03,0.17829e+03 /)
      kao(:, 5, 5, 3) = (/ &
        & 0.32404e+03,0.36503e+03,0.40603e+03,0.45969e+03,0.54395e+03, &
        & 0.51356e+03,0.37844e+03,0.27284e+03,0.17829e+03 /)
      kao(:, 1, 6, 3) = (/ &
        & 0.33079e+03,0.37094e+03,0.41109e+03,0.46395e+03,0.54790e+03, &
        & 0.52101e+03,0.38534e+03,0.27527e+03,0.17829e+03 /)
      kao(:, 2, 6, 3) = (/ &
        & 0.32482e+03,0.36572e+03,0.40662e+03,0.46188e+03,0.54448e+03, &
        & 0.51443e+03,0.37923e+03,0.27312e+03,0.17829e+03 /)
      kao(:, 3, 6, 3) = (/ &
        & 0.31958e+03,0.36113e+03,0.40268e+03,0.45998e+03,0.54143e+03, &
        & 0.50857e+03,0.37397e+03,0.27123e+03,0.17829e+03 /)
      kao(:, 4, 6, 3) = (/ &
        & 0.31492e+03,0.35705e+03,0.39919e+03,0.45816e+03,0.53866e+03, &
        & 0.50335e+03,0.36939e+03,0.26955e+03,0.17829e+03 /)
      kao(:, 5, 6, 3) = (/ &
        & 0.31076e+03,0.35342e+03,0.39607e+03,0.45638e+03,0.53611e+03, &
        & 0.49868e+03,0.36537e+03,0.26805e+03,0.17829e+03 /)
      kao(:, 1, 7, 3) = (/ &
        & 0.31725e+03,0.35910e+03,0.40094e+03,0.45992e+03,0.53978e+03, &
        & 0.50597e+03,0.37168e+03,0.27039e+03,0.17829e+03 /)
      kao(:, 2, 7, 3) = (/ &
        & 0.31194e+03,0.35445e+03,0.39695e+03,0.45835e+03,0.53664e+03, &
        & 0.50000e+03,0.36650e+03,0.26848e+03,0.17829e+03 /)
      kao(:, 3, 7, 3) = (/ &
        & 0.30729e+03,0.35038e+03,0.39347e+03,0.45686e+03,0.53383e+03, &
        & 0.49465e+03,0.36205e+03,0.26680e+03,0.17829e+03 /)
      kao(:, 4, 7, 3) = (/ &
        & 0.30318e+03,0.34679e+03,0.39040e+03,0.45536e+03,0.53125e+03, &
        & 0.48979e+03,0.35818e+03,0.26532e+03,0.17829e+03 /)
      kao(:, 5, 7, 3) = (/ &
        & 0.29953e+03,0.34359e+03,0.38767e+03,0.45383e+03,0.52882e+03, &
        & 0.48543e+03,0.35479e+03,0.26401e+03,0.17829e+03 /)
      kao(:, 1, 8, 3) = (/ &
        & 0.30567e+03,0.34896e+03,0.39226e+03,0.45673e+03,0.53243e+03, &
        & 0.49274e+03,0.36052e+03,0.26622e+03,0.17829e+03 /)
      kao(:, 2, 8, 3) = (/ &
        & 0.30094e+03,0.34482e+03,0.38872e+03,0.45541e+03,0.52945e+03, &
        & 0.48711e+03,0.35609e+03,0.26451e+03,0.17829e+03 /)
      kao(:, 3, 8, 3) = (/ &
        & 0.29682e+03,0.34122e+03,0.38564e+03,0.45413e+03,0.52674e+03, &
        & 0.48217e+03,0.35231e+03,0.26303e+03,0.17829e+03 /)
      kao(:, 4, 8, 3) = (/ &
        & 0.29320e+03,0.33805e+03,0.38294e+03,0.45285e+03,0.52426e+03, &
        & 0.47779e+03,0.34904e+03,0.26172e+03,0.17829e+03 /)
      kao(:, 5, 8, 3) = (/ &
        & 0.29000e+03,0.33525e+03,0.38055e+03,0.45152e+03,0.52191e+03, &
        & 0.47388e+03,0.34618e+03,0.26057e+03,0.17829e+03 /)
      kao(:, 1, 9, 3) = (/ &
        & 0.29581e+03,0.34033e+03,0.38489e+03,0.45387e+03,0.52555e+03, &
        & 0.48095e+03,0.35139e+03,0.26266e+03,0.17829e+03 /)
      kao(:, 2, 9, 3) = (/ &
        & 0.29159e+03,0.33664e+03,0.38173e+03,0.45277e+03,0.52268e+03, &
        & 0.47582e+03,0.34759e+03,0.26114e+03,0.17829e+03 /)
      kao(:, 3, 9, 3) = (/ &
        & 0.28794e+03,0.33344e+03,0.37901e+03,0.45167e+03,0.52008e+03, &
        & 0.47135e+03,0.34436e+03,0.25982e+03,0.17829e+03 /)
      kao(:, 4, 9, 3) = (/ &
        & 0.28475e+03,0.33065e+03,0.37663e+03,0.45055e+03,0.51765e+03, &
        & 0.46738e+03,0.34157e+03,0.25867e+03,0.17829e+03 /)
      kao(:, 5, 9, 3) = (/ &
        & 0.28193e+03,0.32819e+03,0.37453e+03,0.44937e+03,0.51538e+03, &
        & 0.46382e+03,0.33916e+03,0.25766e+03,0.17829e+03 /)
      kao(:, 1,10, 3) = (/ &
        & 0.28708e+03,0.33269e+03,0.37836e+03,0.45121e+03,0.51885e+03, &
        & 0.47029e+03,0.34361e+03,0.25951e+03,0.17829e+03 /)
      kao(:, 2,10, 3) = (/ &
        & 0.28336e+03,0.32944e+03,0.37559e+03,0.45027e+03,0.51611e+03, &
        & 0.46563e+03,0.34037e+03,0.25817e+03,0.17829e+03 /)
      kao(:, 3,10, 3) = (/ &
        & 0.28016e+03,0.32664e+03,0.37320e+03,0.44932e+03,0.51361e+03, &
        & 0.46153e+03,0.33765e+03,0.25702e+03,0.17829e+03 /)
      kao(:, 4,10, 3) = (/ &
        & 0.27737e+03,0.32420e+03,0.37112e+03,0.44835e+03,0.51133e+03, &
        & 0.45793e+03,0.33532e+03,0.25601e+03,0.17829e+03 /)
      kao(:, 5,10, 3) = (/ &
        & 0.27492e+03,0.32206e+03,0.36930e+03,0.44735e+03,0.50922e+03, &
        & 0.45473e+03,0.33330e+03,0.25513e+03,0.17829e+03 /)
      kao(:, 1,11, 3) = (/ &
        & 0.27807e+03,0.32481e+03,0.37164e+03,0.44842e+03,0.51141e+03, &
        & 0.45884e+03,0.33590e+03,0.25627e+03,0.17829e+03 /)
      kao(:, 2,11, 3) = (/ &
        & 0.27502e+03,0.32214e+03,0.36937e+03,0.44764e+03,0.50894e+03, &
        & 0.45486e+03,0.33338e+03,0.25517e+03,0.17829e+03 /)
      kao(:, 3,11, 3) = (/ &
        & 0.27240e+03,0.31985e+03,0.36742e+03,0.44685e+03,0.50671e+03, &
        & 0.45139e+03,0.33123e+03,0.25422e+03,0.17829e+03 /)
      kao(:, 4,11, 3) = (/ &
        & 0.27012e+03,0.31785e+03,0.36572e+03,0.44602e+03,0.50464e+03, &
        & 0.44836e+03,0.32939e+03,0.25340e+03,0.17829e+03 /)
      kao(:, 5,11, 3) = (/ &
        & 0.26811e+03,0.31610e+03,0.36422e+03,0.44514e+03,0.50273e+03, &
        & 0.44569e+03,0.32779e+03,0.25268e+03,0.17829e+03 /)
      kao(:, 1,12, 3) = (/ &
        & 0.27068e+03,0.31834e+03,0.36613e+03,0.44605e+03,0.50476e+03, &
        & 0.44911e+03,0.32983e+03,0.25360e+03,0.17829e+03 /)
      kao(:, 2,12, 3) = (/ &
        & 0.26818e+03,0.31616e+03,0.36428e+03,0.44539e+03,0.50255e+03, &
        & 0.44579e+03,0.32784e+03,0.25270e+03,0.17829e+03 /)
      kao(:, 3,12, 3) = (/ &
        & 0.26603e+03,0.31428e+03,0.36268e+03,0.44471e+03,0.50054e+03, &
        & 0.44293e+03,0.32614e+03,0.25193e+03,0.17829e+03 /)
      kao(:, 4,12, 3) = (/ &
        & 0.26417e+03,0.31264e+03,0.36129e+03,0.44399e+03,0.49874e+03, &
        & 0.44043e+03,0.32468e+03,0.25125e+03,0.17829e+03 /)
      kao(:, 5,12, 3) = (/ &
        & 0.26252e+03,0.31121e+03,0.36005e+03,0.44322e+03,0.49710e+03, &
        & 0.43824e+03,0.32341e+03,0.25066e+03,0.17829e+03 /)
      kao(:, 1,13, 3) = (/ &
        & 0.26463e+03,0.31305e+03,0.36163e+03,0.44400e+03,0.49889e+03, &
        & 0.44105e+03,0.32504e+03,0.25142e+03,0.17829e+03 /)
      kao(:, 2,13, 3) = (/ &
        & 0.26258e+03,0.31126e+03,0.36010e+03,0.44348e+03,0.49698e+03, &
        & 0.43831e+03,0.32345e+03,0.25068e+03,0.17829e+03 /)
      kao(:, 3,13, 3) = (/ &
        & 0.26082e+03,0.30972e+03,0.35880e+03,0.44291e+03,0.49519e+03, &
        & 0.43595e+03,0.32210e+03,0.25005e+03,0.17829e+03 /)
      kao(:, 4,13, 3) = (/ &
        & 0.25929e+03,0.30838e+03,0.35766e+03,0.44229e+03,0.49360e+03, &
        & 0.43388e+03,0.32093e+03,0.24950e+03,0.17829e+03 /)
      kao(:, 5,13, 3) = (/ &
        & 0.25795e+03,0.30721e+03,0.35666e+03,0.44160e+03,0.49217e+03, &
        & 0.43204e+03,0.31991e+03,0.24901e+03,0.17829e+03 /)
      kao(:, 1, 1, 4) = (/ &
        & 0.86913e+03,0.80389e+03,0.73864e+03,0.67339e+03,0.62239e+03, &
        & 0.67741e+03,0.51596e+03,0.43641e+03,0.38437e+03 /)
      kao(:, 2, 1, 4) = (/ &
        & 0.84711e+03,0.78462e+03,0.72212e+03,0.65963e+03,0.61530e+03, &
        & 0.66963e+03,0.50564e+03,0.43387e+03,0.38437e+03 /)
      kao(:, 3, 1, 4) = (/ &
        & 0.82734e+03,0.76731e+03,0.70729e+03,0.64727e+03,0.60932e+03, &
        & 0.66251e+03,0.49688e+03,0.43160e+03,0.38437e+03 /)
      kao(:, 4, 1, 4) = (/ &
        & 0.80948e+03,0.75169e+03,0.69390e+03,0.63611e+03,0.60420e+03, &
        & 0.65531e+03,0.48930e+03,0.42954e+03,0.38437e+03 /)
      kao(:, 5, 1, 4) = (/ &
        & 0.79327e+03,0.73751e+03,0.68174e+03,0.62598e+03,0.59980e+03, &
        & 0.64776e+03,0.48275e+03,0.42767e+03,0.38437e+03 /)
      kao(:, 1, 2, 4) = (/ &
        & 0.80291e+03,0.74594e+03,0.68897e+03,0.63200e+03,0.60547e+03, &
        & 0.65273e+03,0.48660e+03,0.42878e+03,0.38437e+03 /)
      kao(:, 2, 2, 4) = (/ &
        & 0.78403e+03,0.72942e+03,0.67481e+03,0.62020e+03,0.60133e+03, &
        & 0.64384e+03,0.47915e+03,0.42661e+03,0.38437e+03 /)
      kao(:, 3, 2, 4) = (/ &
        & 0.76711e+03,0.71462e+03,0.66212e+03,0.60962e+03,0.59788e+03, &
        & 0.63506e+03,0.47284e+03,0.42466e+03,0.38437e+03 /)
      kao(:, 4, 2, 4) = (/ &
        & 0.75187e+03,0.70128e+03,0.65069e+03,0.60010e+03,0.59472e+03, &
        & 0.62679e+03,0.46742e+03,0.42291e+03,0.38437e+03 /)
      kao(:, 5, 2, 4) = (/ &
        & 0.73807e+03,0.68920e+03,0.64034e+03,0.59147e+03,0.59165e+03, &
        & 0.61864e+03,0.46272e+03,0.42132e+03,0.38437e+03 /)
      kao(:, 1, 3, 4) = (/ &
        & 0.75084e+03,0.70038e+03,0.64992e+03,0.59946e+03,0.59732e+03, &
        & 0.62621e+03,0.46707e+03,0.42279e+03,0.38437e+03 /)
      kao(:, 2, 3, 4) = (/ &
        & 0.73427e+03,0.68588e+03,0.63749e+03,0.58910e+03,0.59435e+03, &
        & 0.61627e+03,0.46147e+03,0.42088e+03,0.38437e+03 /)
      kao(:, 3, 3, 4) = (/ &
        & 0.71948e+03,0.67294e+03,0.62640e+03,0.57986e+03,0.59145e+03, &
        & 0.60690e+03,0.45675e+03,0.41918e+03,0.38437e+03 /)
      kao(:, 4, 3, 4) = (/ &
        & 0.70620e+03,0.66132e+03,0.61644e+03,0.57156e+03,0.58863e+03, &
        & 0.59842e+03,0.45269e+03,0.41765e+03,0.38437e+03 /)
      kao(:, 5, 3, 4) = (/ &
        & 0.69421e+03,0.65083e+03,0.60744e+03,0.56406e+03,0.58580e+03, &
        & 0.59032e+03,0.44923e+03,0.41627e+03,0.38437e+03 /)
      kao(:, 1, 4, 4) = (/ &
        & 0.70765e+03,0.66259e+03,0.61753e+03,0.57246e+03,0.59114e+03, &
        & 0.59936e+03,0.45313e+03,0.41781e+03,0.38437e+03 /)
      kao(:, 2, 4, 4) = (/ &
        & 0.69300e+03,0.64977e+03,0.60654e+03,0.56330e+03,0.58834e+03, &
        & 0.58949e+03,0.44892e+03,0.41613e+03,0.38437e+03 /)
      kao(:, 3, 4, 4) = (/ &
        & 0.67997e+03,0.63837e+03,0.59677e+03,0.55516e+03,0.58563e+03, &
        & 0.58057e+03,0.44538e+03,0.41463e+03,0.38437e+03 /)
      kao(:, 4, 4, 4) = (/ &
        & 0.66833e+03,0.62818e+03,0.58803e+03,0.54788e+03,0.58292e+03, &
        & 0.57257e+03,0.44238e+03,0.41329e+03,0.38437e+03 /)
      kao(:, 5, 4, 4) = (/ &
        & 0.65784e+03,0.61901e+03,0.58017e+03,0.54133e+03,0.58031e+03, &
        & 0.56522e+03,0.43982e+03,0.41208e+03,0.38437e+03 /)
      kao(:, 1, 5, 4) = (/ &
        & 0.67096e+03,0.63048e+03,0.59001e+03,0.54953e+03,0.58521e+03, &
        & 0.57438e+03,0.44304e+03,0.41359e+03,0.38437e+03 /)
      kao(:, 2, 5, 4) = (/ &
        & 0.65799e+03,0.61913e+03,0.58028e+03,0.54142e+03,0.58256e+03, &
        & 0.56532e+03,0.43984e+03,0.41210e+03,0.38437e+03 /)
      kao(:, 3, 5, 4) = (/ &
        & 0.64651e+03,0.60909e+03,0.57167e+03,0.53427e+03,0.57997e+03, &
        & 0.55705e+03,0.43718e+03,0.41077e+03,0.38437e+03 /)
      kao(:, 4, 5, 4) = (/ &
        & 0.63629e+03,0.60015e+03,0.56401e+03,0.52793e+03,0.57742e+03, &
        & 0.54959e+03,0.43482e+03,0.40960e+03,0.38437e+03 /)
      kao(:, 5, 5, 4) = (/ &
        & 0.62713e+03,0.59213e+03,0.55713e+03,0.52227e+03,0.57480e+03, &
        & 0.54282e+03,0.43271e+03,0.40854e+03,0.38437e+03 /)
      kao(:, 1, 6, 4) = (/ &
        & 0.64019e+03,0.60356e+03,0.56693e+03,0.53034e+03,0.57955e+03, &
        & 0.55244e+03,0.43572e+03,0.41005e+03,0.38437e+03 /)
      kao(:, 2, 6, 4) = (/ &
        & 0.62864e+03,0.59346e+03,0.55827e+03,0.52321e+03,0.57700e+03, &
        & 0.54395e+03,0.43306e+03,0.40872e+03,0.38437e+03 /)
      kao(:, 3, 6, 4) = (/ &
        & 0.61849e+03,0.58457e+03,0.55065e+03,0.51703e+03,0.57439e+03, &
        & 0.53634e+03,0.43072e+03,0.40755e+03,0.38437e+03 /)
      kao(:, 4, 6, 4) = (/ &
        & 0.60948e+03,0.57669e+03,0.54390e+03,0.51158e+03,0.57170e+03, &
        & 0.52946e+03,0.42865e+03,0.40651e+03,0.38437e+03 /)
      kao(:, 5, 6, 4) = (/ &
        & 0.60143e+03,0.56965e+03,0.53786e+03,0.50675e+03,0.56897e+03, &
        & 0.52321e+03,0.42679e+03,0.40558e+03,0.38437e+03 /)
      kao(:, 1, 7, 4) = (/ &
        & 0.61399e+03,0.58064e+03,0.54728e+03,0.51440e+03,0.57380e+03, &
        & 0.53292e+03,0.42969e+03,0.40703e+03,0.38437e+03 /)
      kao(:, 2, 7, 4) = (/ &
        & 0.60371e+03,0.57164e+03,0.53957e+03,0.50828e+03,0.57103e+03, &
        & 0.52498e+03,0.42732e+03,0.40585e+03,0.38437e+03 /)
      kao(:, 3, 7, 4) = (/ &
        & 0.59471e+03,0.56376e+03,0.53282e+03,0.50302e+03,0.56836e+03, &
        & 0.51802e+03,0.42525e+03,0.40481e+03,0.38437e+03 /)
      kao(:, 4, 7, 4) = (/ &
        & 0.58676e+03,0.55681e+03,0.52686e+03,0.49842e+03,0.56580e+03, &
        & 0.51197e+03,0.42342e+03,0.40389e+03,0.38437e+03 /)
      kao(:, 5, 7, 4) = (/ &
        & 0.57970e+03,0.55063e+03,0.52156e+03,0.49437e+03,0.56333e+03, &
        & 0.50656e+03,0.42179e+03,0.40308e+03,0.38437e+03 /)
      kao(:, 1, 8, 4) = (/ &
        & 0.59158e+03,0.56102e+03,0.53047e+03,0.50136e+03,0.56762e+03, &
        & 0.51564e+03,0.42452e+03,0.40445e+03,0.38437e+03 /)
      kao(:, 2, 8, 4) = (/ &
        & 0.58242e+03,0.55301e+03,0.52360e+03,0.49623e+03,0.56499e+03, &
        & 0.50866e+03,0.42242e+03,0.40339e+03,0.38437e+03 /)
      kao(:, 3, 8, 4) = (/ &
        & 0.57445e+03,0.54604e+03,0.51762e+03,0.49188e+03,0.56245e+03, &
        & 0.50238e+03,0.42058e+03,0.40248e+03,0.38437e+03 /)
      kao(:, 4, 8, 4) = (/ &
        & 0.56745e+03,0.53991e+03,0.51237e+03,0.48811e+03,0.55998e+03, &
        & 0.49675e+03,0.41897e+03,0.40167e+03,0.38437e+03 /)
      kao(:, 5, 8, 4) = (/ &
        & 0.56125e+03,0.53448e+03,0.50772e+03,0.48477e+03,0.55757e+03, &
        & 0.49178e+03,0.41754e+03,0.40096e+03,0.38437e+03 /)
      kao(:, 1, 9, 4) = (/ &
        & 0.57249e+03,0.54432e+03,0.51615e+03,0.49103e+03,0.56159e+03, &
        & 0.50080e+03,0.42013e+03,0.40225e+03,0.38437e+03 /)
      kao(:, 2, 9, 4) = (/ &
        & 0.56432e+03,0.53718e+03,0.51003e+03,0.48678e+03,0.55899e+03, &
        & 0.49424e+03,0.41825e+03,0.40131e+03,0.38437e+03 /)
      kao(:, 3, 9, 4) = (/ &
        & 0.55726e+03,0.53099e+03,0.50473e+03,0.48321e+03,0.55650e+03, &
        & 0.48858e+03,0.41662e+03,0.40050e+03,0.38437e+03 /)
      kao(:, 4, 9, 4) = (/ &
        & 0.55108e+03,0.52559e+03,0.50010e+03,0.48011e+03,0.55416e+03, &
        & 0.48367e+03,0.41520e+03,0.39978e+03,0.38437e+03 /)
      kao(:, 5, 9, 4) = (/ &
        & 0.54564e+03,0.52083e+03,0.49601e+03,0.47737e+03,0.55194e+03, &
        & 0.47938e+03,0.41394e+03,0.39916e+03,0.38437e+03 /)
      kao(:, 1,10, 4) = (/ &
        & 0.55559e+03,0.52954e+03,0.50348e+03,0.48256e+03,0.55544e+03, &
        & 0.48725e+03,0.41624e+03,0.40030e+03,0.38437e+03 /)
      kao(:, 2,10, 4) = (/ &
        & 0.54839e+03,0.52324e+03,0.49808e+03,0.47910e+03,0.55295e+03, &
        & 0.48155e+03,0.41458e+03,0.39948e+03,0.38437e+03 /)
      kao(:, 3,10, 4) = (/ &
        & 0.54220e+03,0.51781e+03,0.49343e+03,0.47621e+03,0.55067e+03, &
        & 0.47667e+03,0.41315e+03,0.39876e+03,0.38437e+03 /)
      kao(:, 4,10, 4) = (/ &
        & 0.53680e+03,0.51310e+03,0.48939e+03,0.47371e+03,0.54855e+03, &
        & 0.47238e+03,0.41191e+03,0.39814e+03,0.38437e+03 /)
      kao(:, 5,10, 4) = (/ &
        & 0.53207e+03,0.50895e+03,0.48584e+03,0.47148e+03,0.54655e+03, &
        & 0.46857e+03,0.41082e+03,0.39760e+03,0.38437e+03 /)
      kao(:, 1,11, 4) = (/ &
        & 0.53816e+03,0.51428e+03,0.49041e+03,0.47455e+03,0.54857e+03, &
        & 0.47346e+03,0.41222e+03,0.39830e+03,0.38437e+03 /)
      kao(:, 2,11, 4) = (/ &
        & 0.53226e+03,0.50912e+03,0.48598e+03,0.47200e+03,0.54640e+03, &
        & 0.46874e+03,0.41086e+03,0.39762e+03,0.38437e+03 /)
      kao(:, 3,11, 4) = (/ &
        & 0.52718e+03,0.50468e+03,0.48217e+03,0.46982e+03,0.54436e+03, &
        & 0.46486e+03,0.40969e+03,0.39703e+03,0.38437e+03 /)
      kao(:, 4,11, 4) = (/ &
        & 0.52277e+03,0.50081e+03,0.47886e+03,0.46790e+03,0.54248e+03, &
        & 0.46109e+03,0.40868e+03,0.39652e+03,0.38437e+03 /)
      kao(:, 5,11, 4) = (/ &
        & 0.51889e+03,0.49742e+03,0.47595e+03,0.46618e+03,0.54076e+03, &
        & 0.45793e+03,0.40778e+03,0.39608e+03,0.38437e+03 /)
      kao(:, 1,12, 4) = (/ &
        & 0.52385e+03,0.50177e+03,0.47968e+03,0.46863e+03,0.54244e+03, &
        & 0.46202e+03,0.40893e+03,0.39665e+03,0.38437e+03 /)
      kao(:, 2,12, 4) = (/ &
        & 0.51902e+03,0.49754e+03,0.47606e+03,0.46673e+03,0.54050e+03, &
        & 0.45805e+03,0.40782e+03,0.39609e+03,0.38437e+03 /)
      kao(:, 3,12, 4) = (/ &
        & 0.51487e+03,0.49390e+03,0.47294e+03,0.46509e+03,0.53868e+03, &
        & 0.45465e+03,0.40686e+03,0.39561e+03,0.38437e+03 /)
      kao(:, 4,12, 4) = (/ &
        & 0.51125e+03,0.49074e+03,0.47022e+03,0.46362e+03,0.53703e+03, &
        & 0.45171e+03,0.40602e+03,0.39520e+03,0.38437e+03 /)
      kao(:, 5,12, 4) = (/ &
        & 0.50807e+03,0.48796e+03,0.46784e+03,0.46227e+03,0.53558e+03, &
        & 0.44916e+03,0.40529e+03,0.39483e+03,0.38437e+03 /)
      kao(:, 1,13, 4) = (/ &
        & 0.51214e+03,0.49152e+03,0.47089e+03,0.46425e+03,0.53698e+03, &
        & 0.45243e+03,0.40623e+03,0.39530e+03,0.38437e+03 /)
      kao(:, 2,13, 4) = (/ &
        & 0.50819e+03,0.48806e+03,0.46793e+03,0.46281e+03,0.53522e+03, &
        & 0.44925e+03,0.40532e+03,0.39485e+03,0.38437e+03 /)
      kao(:, 3,13, 4) = (/ &
        & 0.50478e+03,0.48508e+03,0.46537e+03,0.46157e+03,0.53378e+03, &
        & 0.44654e+03,0.40453e+03,0.39445e+03,0.38437e+03 /)
      kao(:, 4,13, 4) = (/ &
        & 0.50182e+03,0.48249e+03,0.46315e+03,0.46044e+03,0.53251e+03, &
        & 0.44422e+03,0.40385e+03,0.39411e+03,0.38437e+03 /)
      kao(:, 5,13, 4) = (/ &
        & 0.49922e+03,0.48021e+03,0.46120e+03,0.45936e+03,0.53137e+03, &
        & 0.44221e+03,0.40325e+03,0.39381e+03,0.38437e+03 /)
      kao(:, 1, 1, 5) = (/ &
        & 0.13243e+04,0.11799e+04,0.10354e+04,0.89093e+03,0.74647e+03, &
        & 0.71044e+03,0.61021e+03,0.64069e+03,0.67118e+03 /)
      kao(:, 2, 1, 5) = (/ &
        & 0.12908e+04,0.11505e+04,0.10102e+04,0.86996e+03,0.72969e+03, &
        & 0.70292e+03,0.60750e+03,0.63934e+03,0.67118e+03 /)
      kao(:, 3, 1, 5) = (/ &
        & 0.12606e+04,0.11241e+04,0.98763e+03,0.85113e+03,0.71463e+03, &
        & 0.69451e+03,0.60507e+03,0.63812e+03,0.67118e+03 /)
      kao(:, 4, 1, 5) = (/ &
        & 0.12334e+04,0.11003e+04,0.96722e+03,0.83412e+03,0.70102e+03, &
        & 0.68564e+03,0.60287e+03,0.63703e+03,0.67118e+03 /)
      kao(:, 5, 1, 5) = (/ &
        & 0.12087e+04,0.10787e+04,0.94870e+03,0.81869e+03,0.68867e+03, &
        & 0.67724e+03,0.60088e+03,0.63603e+03,0.67118e+03 /)
      kao(:, 1, 2, 5) = (/ &
        & 0.12234e+04,0.10916e+04,0.95972e+03,0.82787e+03,0.69602e+03, &
        & 0.68345e+03,0.60207e+03,0.63662e+03,0.67118e+03 /)
      kao(:, 2, 2, 5) = (/ &
        & 0.11946e+04,0.10664e+04,0.93814e+03,0.80988e+03,0.68163e+03, &
        & 0.67225e+03,0.59975e+03,0.63546e+03,0.67118e+03 /)
      kao(:, 3, 2, 5) = (/ &
        & 0.11689e+04,0.10438e+04,0.91881e+03,0.79377e+03,0.66882e+03, &
        & 0.66165e+03,0.59767e+03,0.63442e+03,0.67118e+03 /)
      kao(:, 4, 2, 5) = (/ &
        & 0.11456e+04,0.10235e+04,0.90139e+03,0.77926e+03,0.65759e+03, &
        & 0.65058e+03,0.59579e+03,0.63348e+03,0.67118e+03 /)
      kao(:, 5, 2, 5) = (/ &
        & 0.11246e+04,0.10051e+04,0.88561e+03,0.76611e+03,0.64778e+03, &
        & 0.64016e+03,0.59410e+03,0.63264e+03,0.67118e+03 /)
      kao(:, 1, 3, 5) = (/ &
        & 0.11441e+04,0.10221e+04,0.90021e+03,0.77828e+03,0.65728e+03, &
        & 0.64981e+03,0.59567e+03,0.63342e+03,0.67118e+03 /)
      kao(:, 2, 3, 5) = (/ &
        & 0.11188e+04,0.10001e+04,0.88128e+03,0.76250e+03,0.64582e+03, &
        & 0.63739e+03,0.59363e+03,0.63240e+03,0.67118e+03 /)
      kao(:, 3, 3, 5) = (/ &
        & 0.10963e+04,0.98033e+03,0.86437e+03,0.74841e+03,0.63611e+03, &
        & 0.62581e+03,0.59181e+03,0.63149e+03,0.67118e+03 /)
      kao(:, 4, 3, 5) = (/ &
        & 0.10761e+04,0.96263e+03,0.84920e+03,0.73577e+03,0.62780e+03, &
        & 0.61513e+03,0.59018e+03,0.63068e+03,0.67118e+03 /)
      kao(:, 5, 3, 5) = (/ &
        & 0.10578e+04,0.94664e+03,0.83549e+03,0.72435e+03,0.62066e+03, &
        & 0.60588e+03,0.58871e+03,0.62994e+03,0.67118e+03 /)
      kao(:, 1, 4, 5) = (/ &
        & 0.10783e+04,0.96456e+03,0.85086e+03,0.73715e+03,0.62971e+03, &
        & 0.61628e+03,0.59036e+03,0.63077e+03,0.67118e+03 /)
      kao(:, 2, 4, 5) = (/ &
        & 0.10559e+04,0.94502e+03,0.83411e+03,0.72319e+03,0.62145e+03, &
        & 0.60490e+03,0.58856e+03,0.62987e+03,0.67118e+03 /)
      kao(:, 3, 4, 5) = (/ &
        & 0.10361e+04,0.92766e+03,0.81923e+03,0.71079e+03,0.61457e+03, &
        & 0.59452e+03,0.58696e+03,0.62907e+03,0.67118e+03 /)
      kao(:, 4, 4, 5) = (/ &
        & 0.10183e+04,0.91213e+03,0.80591e+03,0.69970e+03,0.60876e+03, &
        & 0.58559e+03,0.58552e+03,0.62835e+03,0.67118e+03 /)
      kao(:, 5, 4, 5) = (/ &
        & 0.10024e+04,0.89816e+03,0.79394e+03,0.68972e+03,0.60374e+03, &
        & 0.57800e+03,0.58424e+03,0.62771e+03,0.67118e+03 /)
      kao(:, 1, 5, 5) = (/ &
        & 0.10224e+04,0.91564e+03,0.80892e+03,0.70221e+03,0.61144e+03, &
        & 0.58757e+03,0.58585e+03,0.62851e+03,0.67118e+03 /)
      kao(:, 2, 5, 5) = (/ &
        & 0.10026e+04,0.89835e+03,0.79410e+03,0.68985e+03,0.60588e+03, &
        & 0.57810e+03,0.58425e+03,0.62772e+03,0.67118e+03 /)
      kao(:, 3, 5, 5) = (/ &
        & 0.98511e+03,0.88305e+03,0.78099e+03,0.67893e+03,0.60138e+03, &
        & 0.57034e+03,0.58284e+03,0.62701e+03,0.67118e+03 /)
      kao(:, 4, 5, 5) = (/ &
        & 0.96954e+03,0.86942e+03,0.76931e+03,0.66919e+03,0.59759e+03, &
        & 0.56378e+03,0.58159e+03,0.62638e+03,0.67118e+03 /)
      kao(:, 5, 5, 5) = (/ &
        & 0.95557e+03,0.85720e+03,0.75883e+03,0.66046e+03,0.59436e+03, &
        & 0.55823e+03,0.58046e+03,0.62582e+03,0.67118e+03 /)
      kao(:, 1, 6, 5) = (/ &
        & 0.97547e+03,0.87461e+03,0.77376e+03,0.67290e+03,0.60045e+03, &
        & 0.56624e+03,0.58207e+03,0.62662e+03,0.67118e+03 /)
      kao(:, 2, 6, 5) = (/ &
        & 0.95788e+03,0.85922e+03,0.76057e+03,0.66191e+03,0.59710e+03, &
        & 0.55912e+03,0.58065e+03,0.62591e+03,0.67118e+03 /)
      kao(:, 3, 6, 5) = (/ &
        & 0.94241e+03,0.84568e+03,0.74896e+03,0.65223e+03,0.59434e+03, &
        & 0.55328e+03,0.57940e+03,0.62529e+03,0.67118e+03 /)
      kao(:, 4, 6, 5) = (/ &
        & 0.92868e+03,0.83367e+03,0.73866e+03,0.64365e+03,0.59182e+03, &
        & 0.54839e+03,0.57829e+03,0.62473e+03,0.67118e+03 /)
      kao(:, 5, 6, 5) = (/ &
        & 0.91642e+03,0.82295e+03,0.72947e+03,0.63599e+03,0.58948e+03, &
        & 0.54428e+03,0.57730e+03,0.62424e+03,0.67118e+03 /)
      kao(:, 1, 7, 5) = (/ &
        & 0.93556e+03,0.83969e+03,0.74382e+03,0.64795e+03,0.59420e+03, &
        & 0.55081e+03,0.57885e+03,0.62501e+03,0.67118e+03 /)
      kao(:, 2, 7, 5) = (/ &
        & 0.91989e+03,0.82598e+03,0.73207e+03,0.63816e+03,0.59179e+03, &
        & 0.54542e+03,0.57758e+03,0.62438e+03,0.67118e+03 /)
      kao(:, 3, 7, 5) = (/ &
        & 0.90618e+03,0.81398e+03,0.72179e+03,0.62959e+03,0.58955e+03, &
        & 0.54102e+03,0.57648e+03,0.62383e+03,0.67118e+03 /)
      kao(:, 4, 7, 5) = (/ &
        & 0.89407e+03,0.80339e+03,0.71271e+03,0.62202e+03,0.58737e+03, &
        & 0.53729e+03,0.57550e+03,0.62334e+03,0.67118e+03 /)
      kao(:, 5, 7, 5) = (/ &
        & 0.88331e+03,0.79397e+03,0.70463e+03,0.61530e+03,0.58524e+03, &
        & 0.53413e+03,0.57463e+03,0.62290e+03,0.67118e+03 /)
      kao(:, 1, 8, 5) = (/ &
        & 0.90140e+03,0.80981e+03,0.71821e+03,0.62661e+03,0.58941e+03, &
        & 0.53953e+03,0.57609e+03,0.62363e+03,0.67118e+03 /)
      kao(:, 2, 8, 5) = (/ &
        & 0.88745e+03,0.79760e+03,0.70774e+03,0.61789e+03,0.58727e+03, &
        & 0.53533e+03,0.57497e+03,0.62307e+03,0.67118e+03 /)
      kao(:, 3, 8, 5) = (/ &
        & 0.87531e+03,0.78697e+03,0.69863e+03,0.61030e+03,0.58522e+03, &
        & 0.53203e+03,0.57399e+03,0.62258e+03,0.67118e+03 /)
      kao(:, 4, 8, 5) = (/ &
        & 0.86464e+03,0.77763e+03,0.69063e+03,0.60363e+03,0.58317e+03, &
        & 0.52938e+03,0.57313e+03,0.62215e+03,0.67118e+03 /)
      kao(:, 5, 8, 5) = (/ &
        & 0.85519e+03,0.76937e+03,0.68354e+03,0.59772e+03,0.58120e+03, &
        & 0.52712e+03,0.57236e+03,0.62177e+03,0.67118e+03 /)
      kao(:, 1, 9, 5) = (/ &
        & 0.87232e+03,0.78435e+03,0.69639e+03,0.60843e+03,0.58508e+03, &
        & 0.53128e+03,0.57375e+03,0.62246e+03,0.67118e+03 /)
      kao(:, 2, 9, 5) = (/ &
        & 0.85988e+03,0.77347e+03,0.68706e+03,0.60065e+03,0.58302e+03, &
        & 0.52823e+03,0.57274e+03,0.62196e+03,0.67118e+03 /)
      kao(:, 3, 9, 5) = (/ &
        & 0.84911e+03,0.76405e+03,0.67898e+03,0.59392e+03,0.58102e+03, &
        & 0.52572e+03,0.57187e+03,0.62153e+03,0.67118e+03 /)
      kao(:, 4, 9, 5) = (/ &
        & 0.83970e+03,0.75581e+03,0.67193e+03,0.58804e+03,0.57906e+03, &
        & 0.52364e+03,0.57111e+03,0.62115e+03,0.67118e+03 /)
      kao(:, 5, 9, 5) = (/ &
        & 0.83140e+03,0.74855e+03,0.66571e+03,0.58286e+03,0.57713e+03, &
        & 0.52190e+03,0.57045e+03,0.62081e+03,0.67118e+03 /)
      kao(:, 1,10, 5) = (/ &
        & 0.84657e+03,0.76183e+03,0.67708e+03,0.59234e+03,0.58061e+03, &
        & 0.52515e+03,0.57167e+03,0.62142e+03,0.67118e+03 /)
      kao(:, 2,10, 5) = (/ &
        & 0.83560e+03,0.75223e+03,0.66886e+03,0.58548e+03,0.57865e+03, &
        & 0.52276e+03,0.57078e+03,0.62098e+03,0.67118e+03 /)
      kao(:, 3,10, 5) = (/ &
        & 0.82616e+03,0.74397e+03,0.66177e+03,0.57958e+03,0.57663e+03, &
        & 0.52085e+03,0.57002e+03,0.62060e+03,0.67118e+03 /)
      kao(:, 4,10, 5) = (/ &
        & 0.81794e+03,0.73678e+03,0.65561e+03,0.57444e+03,0.57466e+03, &
        & 0.51933e+03,0.56936e+03,0.62027e+03,0.67118e+03 /)
      kao(:, 5,10, 5) = (/ &
        & 0.81073e+03,0.73047e+03,0.65020e+03,0.56994e+03,0.57276e+03, &
        & 0.51811e+03,0.56878e+03,0.61998e+03,0.67118e+03 /)
      kao(:, 1,11, 5) = (/ &
        & 0.82001e+03,0.73859e+03,0.65716e+03,0.57574e+03,0.57531e+03, &
        & 0.51970e+03,0.56953e+03,0.62035e+03,0.67118e+03 /)
      kao(:, 2,11, 5) = (/ &
        & 0.81102e+03,0.73072e+03,0.65042e+03,0.57012e+03,0.57326e+03, &
        & 0.51814e+03,0.56880e+03,0.61999e+03,0.67118e+03 /)
      kao(:, 3,11, 5) = (/ &
        & 0.80328e+03,0.72395e+03,0.64462e+03,0.56528e+03,0.57135e+03, &
        & 0.51670e+03,0.56818e+03,0.61968e+03,0.67118e+03 /)
      kao(:, 4,11, 5) = (/ &
        & 0.79655e+03,0.71806e+03,0.63957e+03,0.56108e+03,0.56956e+03, &
        & 0.51595e+03,0.56763e+03,0.61941e+03,0.67118e+03 /)
      kao(:, 5,11, 5) = (/ &
        & 0.79064e+03,0.71289e+03,0.63514e+03,0.55738e+03,0.56781e+03, &
        & 0.51517e+03,0.56716e+03,0.61917e+03,0.67118e+03 /)
      kao(:, 1,12, 5) = (/ &
        & 0.79821e+03,0.71951e+03,0.64081e+03,0.56211e+03,0.57002e+03, &
        & 0.51613e+03,0.56777e+03,0.61947e+03,0.67118e+03 /)
      kao(:, 2,12, 5) = (/ &
        & 0.79085e+03,0.71307e+03,0.63529e+03,0.55751e+03,0.56813e+03, &
        & 0.51519e+03,0.56717e+03,0.61918e+03,0.67118e+03 /)
      kao(:, 3,12, 5) = (/ &
        & 0.78452e+03,0.70753e+03,0.63054e+03,0.55355e+03,0.56648e+03, &
        & 0.51441e+03,0.56666e+03,0.61892e+03,0.67118e+03 /)
      kao(:, 4,12, 5) = (/ &
        & 0.77901e+03,0.70271e+03,0.62641e+03,0.55011e+03,0.56489e+03, &
        & 0.51374e+03,0.56622e+03,0.61870e+03,0.67118e+03 /)
      kao(:, 5,12, 5) = (/ &
        & 0.77417e+03,0.69847e+03,0.62278e+03,0.54708e+03,0.56325e+03, &
        & 0.51315e+03,0.56583e+03,0.61850e+03,0.67118e+03 /)
      kao(:, 1,13, 5) = (/ &
        & 0.78036e+03,0.70389e+03,0.62743e+03,0.55096e+03,0.56495e+03, &
        & 0.51390e+03,0.56633e+03,0.61875e+03,0.67118e+03 /)
      kao(:, 2,13, 5) = (/ &
        & 0.77434e+03,0.69862e+03,0.62291e+03,0.54719e+03,0.56343e+03, &
        & 0.51318e+03,0.56584e+03,0.61851e+03,0.67118e+03 /)
      kao(:, 3,13, 5) = (/ &
        & 0.76915e+03,0.69408e+03,0.61902e+03,0.54395e+03,0.56189e+03, &
        & 0.51255e+03,0.56542e+03,0.61830e+03,0.67118e+03 /)
      kao(:, 4,13, 5) = (/ &
        & 0.76464e+03,0.69014e+03,0.61563e+03,0.54113e+03,0.56027e+03, &
        & 0.51200e+03,0.56506e+03,0.61812e+03,0.67118e+03 /)
      kao(:, 5,13, 5) = (/ &
        & 0.76068e+03,0.68667e+03,0.61266e+03,0.53865e+03,0.55865e+03, &
        & 0.51152e+03,0.56474e+03,0.61796e+03,0.67118e+03 /)
      kao(:, 1, 1, 6) = (/ &
        & 0.16832e+04,0.14832e+04,0.12833e+04,0.10834e+04,0.88343e+03, &
        & 0.73047e+03,0.75923e+03,0.85568e+03,0.94989e+03 /)
      kao(:, 2, 1, 6) = (/ &
        & 0.16405e+04,0.14459e+04,0.12513e+04,0.10567e+04,0.86211e+03, &
        & 0.72257e+03,0.75791e+03,0.85457e+03,0.94915e+03 /)
      kao(:, 3, 1, 6) = (/ &
        & 0.16022e+04,0.14124e+04,0.12226e+04,0.10328e+04,0.84296e+03, &
        & 0.71182e+03,0.75643e+03,0.85315e+03,0.94805e+03 /)
      kao(:, 4, 1, 6) = (/ &
        & 0.15677e+04,0.13822e+04,0.11967e+04,0.10112e+04,0.82566e+03, &
        & 0.70003e+03,0.75475e+03,0.85145e+03,0.94659e+03 /)
      kao(:, 5, 1, 6) = (/ &
        & 0.15363e+04,0.13547e+04,0.11731e+04,0.99155e+03,0.80997e+03, &
        & 0.68802e+03,0.75277e+03,0.84941e+03,0.94478e+03 /)
      kao(:, 1, 2, 6) = (/ &
        & 0.15549e+04,0.13710e+04,0.11871e+04,0.10032e+04,0.81930e+03, &
        & 0.69644e+03,0.75599e+03,0.85402e+03,0.95009e+03 /)
      kao(:, 2, 2, 6) = (/ &
        & 0.15184e+04,0.13390e+04,0.11597e+04,0.98036e+03,0.80102e+03, &
        & 0.68214e+03,0.75486e+03,0.85308e+03,0.94950e+03 /)
      kao(:, 3, 2, 6) = (/ &
        & 0.14856e+04,0.13104e+04,0.11351e+04,0.95988e+03,0.78464e+03, &
        & 0.67032e+03,0.75359e+03,0.85186e+03,0.94855e+03 /)
      kao(:, 4, 2, 6) = (/ &
        & 0.14561e+04,0.12845e+04,0.11130e+04,0.94143e+03,0.76988e+03, &
        & 0.66240e+03,0.75215e+03,0.85037e+03,0.94724e+03 /)
      kao(:, 5, 2, 6) = (/ &
        & 0.14294e+04,0.12611e+04,0.10929e+04,0.92472e+03,0.75651e+03, &
        & 0.65660e+03,0.75042e+03,0.84857e+03,0.94557e+03 /)
      kao(:, 1, 3, 6) = (/ &
        & 0.14541e+04,0.12828e+04,0.11115e+04,0.94019e+03,0.76889e+03, &
        & 0.66226e+03,0.75340e+03,0.85268e+03,0.95029e+03 /)
      kao(:, 2, 3, 6) = (/ &
        & 0.14220e+04,0.12547e+04,0.10874e+04,0.92013e+03,0.75284e+03, &
        & 0.65611e+03,0.75249e+03,0.85200e+03,0.94990e+03 /)
      kao(:, 3, 3, 6) = (/ &
        & 0.13934e+04,0.12297e+04,0.10659e+04,0.90223e+03,0.73852e+03, &
        & 0.65222e+03,0.75143e+03,0.85101e+03,0.94916e+03 /)
      kao(:, 4, 3, 6) = (/ &
        & 0.13676e+04,0.12071e+04,0.10467e+04,0.88615e+03,0.72566e+03, &
        & 0.64945e+03,0.75024e+03,0.84977e+03,0.94807e+03 /)
      kao(:, 5, 3, 6) = (/ &
        & 0.13444e+04,0.11868e+04,0.10292e+04,0.87164e+03,0.71405e+03, &
        & 0.64733e+03,0.74880e+03,0.84822e+03,0.94662e+03 /)
      kao(:, 1, 4, 6) = (/ &
        & 0.13705e+04,0.12096e+04,0.10488e+04,0.88791e+03,0.72707e+03, &
        & 0.64976e+03,0.75119e+03,0.85151e+03,0.95037e+03 /)
      kao(:, 2, 4, 6) = (/ &
        & 0.13421e+04,0.11848e+04,0.10275e+04,0.87017e+03,0.71287e+03, &
        & 0.64785e+03,0.75047e+03,0.85104e+03,0.95019e+03 /)
      kao(:, 3, 4, 6) = (/ &
        & 0.13169e+04,0.11627e+04,0.10086e+04,0.85441e+03,0.70026e+03, &
        & 0.64696e+03,0.74964e+03,0.85031e+03,0.94968e+03 /)
      kao(:, 4, 4, 6) = (/ &
        & 0.12943e+04,0.11430e+04,0.99164e+03,0.84031e+03,0.68898e+03, &
        & 0.64601e+03,0.74865e+03,0.84930e+03,0.94882e+03 /)
      kao(:, 5, 4, 6) = (/ &
        & 0.12740e+04,0.11252e+04,0.97642e+03,0.82763e+03,0.67884e+03, &
        & 0.64496e+03,0.74747e+03,0.84802e+03,0.94760e+03 /)
      kao(:, 1, 5, 6) = (/ &
        & 0.12994e+04,0.11474e+04,0.99546e+03,0.84350e+03,0.69153e+03, &
        & 0.64599e+03,0.74922e+03,0.85040e+03,0.95032e+03 /)
      kao(:, 2, 5, 6) = (/ &
        & 0.12743e+04,0.11254e+04,0.97662e+03,0.82780e+03,0.67897e+03, &
        & 0.64529e+03,0.74869e+03,0.85015e+03,0.95034e+03 /)
      kao(:, 3, 5, 6) = (/ &
        & 0.12521e+04,0.11060e+04,0.95996e+03,0.81391e+03,0.66786e+03, &
        & 0.64458e+03,0.74805e+03,0.84965e+03,0.95004e+03 /)
      kao(:, 4, 5, 6) = (/ &
        & 0.12323e+04,0.10887e+04,0.94511e+03,0.80154e+03,0.65797e+03, &
        & 0.64380e+03,0.74727e+03,0.84886e+03,0.94940e+03 /)
      kao(:, 5, 5, 6) = (/ &
        & 0.12145e+04,0.10732e+04,0.93180e+03,0.79045e+03,0.64909e+03, &
        & 0.64294e+03,0.74629e+03,0.84781e+03,0.94841e+03 /)
      kao(:, 1, 6, 6) = (/ &
        & 0.12398e+04,0.10953e+04,0.95077e+03,0.80625e+03,0.66174e+03, &
        & 0.64362e+03,0.74747e+03,0.84935e+03,0.95014e+03 /)
      kao(:, 2, 6, 6) = (/ &
        & 0.12174e+04,0.10757e+04,0.93400e+03,0.79228e+03,0.65056e+03, &
        & 0.64308e+03,0.74712e+03,0.84932e+03,0.95036e+03 /)
      kao(:, 3, 6, 6) = (/ &
        & 0.11978e+04,0.10585e+04,0.91925e+03,0.77999e+03,0.64087e+03, &
        & 0.64253e+03,0.74666e+03,0.84902e+03,0.95027e+03 /)
      kao(:, 4, 6, 6) = (/ &
        & 0.11803e+04,0.10432e+04,0.90616e+03,0.76908e+03,0.63262e+03, &
        & 0.64192e+03,0.74606e+03,0.84847e+03,0.94985e+03 /)
      kao(:, 5, 6, 6) = (/ &
        & 0.11647e+04,0.10296e+04,0.89448e+03,0.75935e+03,0.62549e+03, &
        & 0.64122e+03,0.74529e+03,0.84763e+03,0.94909e+03 /)
      kao(:, 1, 7, 6) = (/ &
        & 0.11891e+04,0.10509e+04,0.91272e+03,0.77455e+03,0.63693e+03, &
        & 0.64154e+03,0.74584e+03,0.84830e+03,0.94975e+03 /)
      kao(:, 2, 7, 6) = (/ &
        & 0.11692e+04,0.10335e+04,0.89779e+03,0.76210e+03,0.62795e+03, &
        & 0.64115e+03,0.74575e+03,0.84848e+03,0.95025e+03 /)
      kao(:, 3, 7, 6) = (/ &
        & 0.11517e+04,0.10182e+04,0.88471e+03,0.75121e+03,0.62051e+03, &
        & 0.64074e+03,0.74542e+03,0.84840e+03,0.95037e+03 /)
      kao(:, 4, 7, 6) = (/ &
        & 0.11363e+04,0.10048e+04,0.87317e+03,0.74159e+03,0.61432e+03, &
        & 0.64028e+03,0.74499e+03,0.84806e+03,0.95015e+03 /)
      kao(:, 5, 7, 6) = (/ &
        & 0.11227e+04,0.99279e+03,0.86291e+03,0.73304e+03,0.60908e+03, &
        & 0.63974e+03,0.74440e+03,0.84744e+03,0.94961e+03 /)
      kao(:, 1, 8, 6) = (/ &
        & 0.11457e+04,0.10129e+04,0.88017e+03,0.74742e+03,0.61848e+03, &
        & 0.63968e+03,0.74433e+03,0.84725e+03,0.94927e+03 /)
      kao(:, 2, 8, 6) = (/ &
        & 0.11279e+04,0.99740e+03,0.86687e+03,0.73633e+03,0.61183e+03, &
        & 0.63944e+03,0.74439e+03,0.84765e+03,0.94999e+03 /)
      kao(:, 3, 8, 6) = (/ &
        & 0.11125e+04,0.98389e+03,0.85529e+03,0.72668e+03,0.60652e+03, &
        & 0.63917e+03,0.74428e+03,0.84777e+03,0.95034e+03 /)
      kao(:, 4, 8, 6) = (/ &
        & 0.10989e+04,0.97202e+03,0.84512e+03,0.71821e+03,0.60224e+03, &
        & 0.63885e+03,0.74401e+03,0.84763e+03,0.95032e+03 /)
      kao(:, 5, 8, 6) = (/ &
        & 0.10869e+04,0.96152e+03,0.83611e+03,0.71070e+03,0.59867e+03, &
        & 0.63844e+03,0.74359e+03,0.84721e+03,0.94997e+03 /)
      kao(:, 1, 9, 6) = (/ &
        & 0.11087e+04,0.98057e+03,0.85244e+03,0.72431e+03,0.60583e+03, &
        & 0.63802e+03,0.74290e+03,0.84619e+03,0.94868e+03 /)
      kao(:, 2, 9, 6) = (/ &
        & 0.10929e+04,0.96673e+03,0.84058e+03,0.71443e+03,0.60128e+03, &
        & 0.63792e+03,0.74318e+03,0.84681e+03,0.94962e+03 /)
      kao(:, 3, 9, 6) = (/ &
        & 0.10792e+04,0.95475e+03,0.83031e+03,0.70587e+03,0.59784e+03, &
        & 0.63778e+03,0.74323e+03,0.84713e+03,0.95019e+03 /)
      kao(:, 4, 9, 6) = (/ &
        & 0.10672e+04,0.94429e+03,0.82134e+03,0.69840e+03,0.59517e+03, &
        & 0.63759e+03,0.74313e+03,0.84718e+03,0.95037e+03 /)
      kao(:, 5, 9, 6) = (/ &
        & 0.10567e+04,0.93506e+03,0.81344e+03,0.69181e+03,0.59278e+03, &
        & 0.63730e+03,0.74285e+03,0.84695e+03,0.95021e+03 /)
      kao(:, 1,10, 6) = (/ &
        & 0.10760e+04,0.95193e+03,0.82790e+03,0.70386e+03,0.59768e+03, &
        & 0.63651e+03,0.74157e+03,0.84519e+03,0.94809e+03 /)
      kao(:, 2,10, 6) = (/ &
        & 0.10620e+04,0.93974e+03,0.81744e+03,0.69515e+03,0.59477e+03, &
        & 0.63656e+03,0.74203e+03,0.84600e+03,0.94921e+03 /)
      kao(:, 3,10, 6) = (/ &
        & 0.10500e+04,0.92923e+03,0.80844e+03,0.68764e+03,0.59242e+03, &
        & 0.63654e+03,0.74226e+03,0.84650e+03,0.94996e+03 /)
      kao(:, 4,10, 6) = (/ &
        & 0.10396e+04,0.92010e+03,0.80061e+03,0.68112e+03,0.59042e+03, &
        & 0.63645e+03,0.74230e+03,0.84672e+03,0.95033e+03 /)
      kao(:, 5,10, 6) = (/ &
        & 0.10304e+04,0.91207e+03,0.79373e+03,0.67539e+03,0.58849e+03, &
        & 0.63628e+03,0.74216e+03,0.84665e+03,0.95033e+03 /)
      kao(:, 1,11, 6) = (/ &
        & 0.10422e+04,0.92239e+03,0.80258e+03,0.68276e+03,0.59118e+03, &
        & 0.63525e+03,0.74065e+03,0.84470e+03,0.94808e+03 /)
      kao(:, 2,11, 6) = (/ &
        & 0.10308e+04,0.91240e+03,0.79401e+03,0.67562e+03,0.58920e+03, &
        & 0.63540e+03,0.74118e+03,0.84554e+03,0.94920e+03 /)
      kao(:, 3,11, 6) = (/ &
        & 0.10210e+04,0.90379e+03,0.78663e+03,0.66947e+03,0.58737e+03, &
        & 0.63545e+03,0.74147e+03,0.84609e+03,0.94995e+03 /)
      kao(:, 4,11, 6) = (/ &
        & 0.10124e+04,0.89631e+03,0.78022e+03,0.66413e+03,0.58569e+03, &
        & 0.63543e+03,0.74156e+03,0.84634e+03,0.95033e+03 /)
      kao(:, 5,11, 6) = (/ &
        & 0.10049e+04,0.88974e+03,0.77458e+03,0.65943e+03,0.58398e+03, &
        & 0.63532e+03,0.74146e+03,0.84628e+03,0.95033e+03 /)
      kao(:, 1,12, 6) = (/ &
        & 0.10145e+04,0.89815e+03,0.78180e+03,0.66544e+03,0.58616e+03, &
        & 0.63421e+03,0.73990e+03,0.84430e+03,0.94808e+03 /)
      kao(:, 2,12, 6) = (/ &
        & 0.10052e+04,0.88997e+03,0.77478e+03,0.65960e+03,0.58451e+03, &
        & 0.63444e+03,0.74048e+03,0.84518e+03,0.94921e+03 /)
      kao(:, 3,12, 6) = (/ &
        & 0.99710e+03,0.88292e+03,0.76874e+03,0.65457e+03,0.58265e+03, &
        & 0.63457e+03,0.74082e+03,0.84574e+03,0.94995e+03 /)
      kao(:, 4,12, 6) = (/ &
        & 0.99010e+03,0.87679e+03,0.76349e+03,0.65019e+03,0.58054e+03, &
        & 0.63460e+03,0.74095e+03,0.84600e+03,0.95033e+03 /)
      kao(:, 5,12, 6) = (/ &
        & 0.98395e+03,0.87141e+03,0.75888e+03,0.64634e+03,0.57844e+03, &
        & 0.63453e+03,0.74089e+03,0.84598e+03,0.95033e+03 /)
      kao(:, 1,13, 6) = (/ &
        & 0.99182e+03,0.87830e+03,0.76478e+03,0.65127e+03,0.58122e+03, &
        & 0.63336e+03,0.73928e+03,0.84397e+03,0.94808e+03 /)
      kao(:, 2,13, 6) = (/ &
        & 0.98416e+03,0.87160e+03,0.75904e+03,0.64648e+03,0.57888e+03, &
        & 0.63366e+03,0.73991e+03,0.84487e+03,0.94921e+03 /)
      kao(:, 3,13, 6) = (/ &
        & 0.97757e+03,0.86583e+03,0.75410e+03,0.64236e+03,0.57650e+03, &
        & 0.63384e+03,0.74029e+03,0.84546e+03,0.94996e+03 /)
      kao(:, 4,13, 6) = (/ &
        & 0.97184e+03,0.86082e+03,0.74980e+03,0.63878e+03,0.57428e+03, &
        & 0.63391e+03,0.74045e+03,0.84574e+03,0.95033e+03 /)
      kao(:, 5,13, 6) = (/ &
        & 0.96680e+03,0.85641e+03,0.74602e+03,0.63563e+03,0.57218e+03, &
        & 0.63388e+03,0.74043e+03,0.84574e+03,0.95033e+03 /)
      kao(:, 1, 1, 7) = (/ &
        & 0.18845e+04,0.16548e+04,0.14251e+04,0.11953e+04,0.96557e+03, &
        & 0.74301e+03,0.82697e+03,0.94964e+03,0.10740e+04 /)
      kao(:, 2, 1, 7) = (/ &
        & 0.18367e+04,0.16130e+04,0.13892e+04,0.11655e+04,0.94169e+03, &
        & 0.73101e+03,0.82533e+03,0.94833e+03,0.10730e+04 /)
      kao(:, 3, 1, 7) = (/ &
        & 0.17938e+04,0.15755e+04,0.13571e+04,0.11387e+04,0.92025e+03, &
        & 0.71894e+03,0.82353e+03,0.94679e+03,0.10715e+04 /)
      kao(:, 4, 1, 7) = (/ &
        & 0.17551e+04,0.15416e+04,0.13280e+04,0.11145e+04,0.90089e+03, &
        & 0.70691e+03,0.82149e+03,0.94487e+03,0.10696e+04 /)
      kao(:, 5, 1, 7) = (/ &
        & 0.17200e+04,0.15108e+04,0.13017e+04,0.10925e+04,0.88332e+03, &
        & 0.69946e+03,0.81920e+03,0.94260e+03,0.10672e+04 /)
      kao(:, 1, 2, 7) = (/ &
        & 0.17409e+04,0.15291e+04,0.13174e+04,0.11056e+04,0.89377e+03, &
        & 0.70556e+03,0.82545e+03,0.94918e+03,0.10743e+04 /)
      kao(:, 2, 2, 7) = (/ &
        & 0.16999e+04,0.14933e+04,0.12867e+04,0.10800e+04,0.87329e+03, &
        & 0.70177e+03,0.82404e+03,0.94806e+03,0.10734e+04 /)
      kao(:, 3, 2, 7) = (/ &
        & 0.16632e+04,0.14612e+04,0.12591e+04,0.10571e+04,0.85495e+03, &
        & 0.69985e+03,0.82245e+03,0.94668e+03,0.10721e+04 /)
      kao(:, 4, 2, 7) = (/ &
        & 0.16302e+04,0.14323e+04,0.12344e+04,0.10364e+04,0.83842e+03, &
        & 0.69778e+03,0.82061e+03,0.94495e+03,0.10705e+04 /)
      kao(:, 5, 2, 7) = (/ &
        & 0.16003e+04,0.14061e+04,0.12119e+04,0.10177e+04,0.82345e+03, &
        & 0.69549e+03,0.81853e+03,0.94286e+03,0.10683e+04 /)
      kao(:, 1, 3, 7) = (/ &
        & 0.16280e+04,0.14303e+04,0.12327e+04,0.10350e+04,0.83731e+03, &
        & 0.70164e+03,0.82440e+03,0.94900e+03,0.10748e+04 /)
      kao(:, 2, 3, 7) = (/ &
        & 0.15920e+04,0.13989e+04,0.12057e+04,0.10126e+04,0.81934e+03, &
        & 0.70016e+03,0.82323e+03,0.94804e+03,0.10740e+04 /)
      kao(:, 3, 3, 7) = (/ &
        & 0.15600e+04,0.13708e+04,0.11817e+04,0.99252e+03,0.80330e+03, &
        & 0.69850e+03,0.82187e+03,0.94688e+03,0.10730e+04 /)
      kao(:, 4, 3, 7) = (/ &
        & 0.15312e+04,0.13457e+04,0.11601e+04,0.97452e+03,0.78890e+03, &
        & 0.69669e+03,0.82029e+03,0.94542e+03,0.10716e+04 /)
      kao(:, 5, 3, 7) = (/ &
        & 0.15052e+04,0.13229e+04,0.11406e+04,0.95827e+03,0.77590e+03, &
        & 0.69468e+03,0.81844e+03,0.94358e+03,0.10697e+04 /)
      kao(:, 1, 4, 7) = (/ &
        & 0.15343e+04,0.13484e+04,0.11625e+04,0.97650e+03,0.79047e+03, &
        & 0.70005e+03,0.82352e+03,0.94883e+03,0.10751e+04 /)
      kao(:, 2, 4, 7) = (/ &
        & 0.15026e+04,0.13206e+04,0.11386e+04,0.95663e+03,0.77458e+03, &
        & 0.69884e+03,0.82260e+03,0.94808e+03,0.10745e+04 /)
      kao(:, 3, 4, 7) = (/ &
        & 0.14743e+04,0.12959e+04,0.11175e+04,0.93898e+03,0.76046e+03, &
        & 0.69743e+03,0.82145e+03,0.94711e+03,0.10737e+04 /)
      kao(:, 4, 4, 7) = (/ &
        & 0.14491e+04,0.12738e+04,0.10985e+04,0.92319e+03,0.74783e+03, &
        & 0.69586e+03,0.82010e+03,0.94588e+03,0.10725e+04 /)
      kao(:, 5, 4, 7) = (/ &
        & 0.14263e+04,0.12539e+04,0.10815e+04,0.90900e+03,0.73646e+03, &
        & 0.69412e+03,0.81852e+03,0.94430e+03,0.10710e+04 /)
      kao(:, 1, 5, 7) = (/ &
        & 0.14548e+04,0.12788e+04,0.11028e+04,0.92676e+03,0.75068e+03, &
        & 0.69862e+03,0.82271e+03,0.94860e+03,0.10753e+04 /)
      kao(:, 2, 5, 7) = (/ &
        & 0.14266e+04,0.12542e+04,0.10817e+04,0.90918e+03,0.73662e+03, &
        & 0.69765e+03,0.82202e+03,0.94804e+03,0.10749e+04 /)
      kao(:, 3, 5, 7) = (/ &
        & 0.14018e+04,0.12324e+04,0.10630e+04,0.89363e+03,0.72418e+03, &
        & 0.69649e+03,0.82110e+03,0.94729e+03,0.10743e+04 /)
      kao(:, 4, 5, 7) = (/ &
        & 0.13796e+04,0.12130e+04,0.10464e+04,0.87978e+03,0.71309e+03, &
        & 0.69515e+03,0.81992e+03,0.94623e+03,0.10733e+04 /)
      kao(:, 5, 5, 7) = (/ &
        & 0.13597e+04,0.11956e+04,0.10315e+04,0.86737e+03,0.70315e+03, &
        & 0.69363e+03,0.81858e+03,0.94492e+03,0.10720e+04 /)
      kao(:, 1, 6, 7) = (/ &
        & 0.13881e+04,0.12204e+04,0.10528e+04,0.88506e+03,0.71732e+03, &
        & 0.69732e+03,0.82195e+03,0.94833e+03,0.10753e+04 /)
      kao(:, 2, 6, 7) = (/ &
        & 0.13630e+04,0.11985e+04,0.10340e+04,0.86942e+03,0.70480e+03, &
        & 0.69661e+03,0.82150e+03,0.94796e+03,0.10752e+04 /)
      kao(:, 3, 6, 7) = (/ &
        & 0.13410e+04,0.11792e+04,0.10175e+04,0.85565e+03,0.69378e+03, &
        & 0.69568e+03,0.82079e+03,0.94739e+03,0.10747e+04 /)
      kao(:, 4, 6, 7) = (/ &
        & 0.13215e+04,0.11622e+04,0.10028e+04,0.84344e+03,0.68401e+03, &
        & 0.69456e+03,0.81984e+03,0.94655e+03,0.10740e+04 /)
      kao(:, 5, 6, 7) = (/ &
        & 0.13040e+04,0.11469e+04,0.98973e+03,0.83254e+03,0.67529e+03, &
        & 0.69326e+03,0.81868e+03,0.94544e+03,0.10729e+04 /)
      kao(:, 1, 7, 7) = (/ &
        & 0.13313e+04,0.11707e+04,0.10101e+04,0.84956e+03,0.68891e+03, &
        & 0.69611e+03,0.82122e+03,0.94800e+03,0.10754e+04 /)
      kao(:, 2, 7, 7) = (/ &
        & 0.13090e+04,0.11512e+04,0.99343e+03,0.83562e+03,0.67776e+03, &
        & 0.69564e+03,0.82091e+03,0.94785e+03,0.10753e+04 /)
      kao(:, 3, 7, 7) = (/ &
        & 0.12894e+04,0.11341e+04,0.97879e+03,0.82342e+03,0.66800e+03, &
        & 0.69494e+03,0.82048e+03,0.94742e+03,0.10750e+04 /)
      kao(:, 4, 7, 7) = (/ &
        & 0.12722e+04,0.11191e+04,0.96587e+03,0.81266e+03,0.65938e+03, &
        & 0.69403e+03,0.81973e+03,0.94677e+03,0.10745e+04 /)
      kao(:, 5, 7, 7) = (/ &
        & 0.12569e+04,0.11057e+04,0.95438e+03,0.80308e+03,0.65172e+03, &
        & 0.69293e+03,0.81874e+03,0.94587e+03,0.10736e+04 /)
      kao(:, 1, 8, 7) = (/ &
        & 0.12827e+04,0.11282e+04,0.97371e+03,0.81918e+03,0.66460e+03, &
        & 0.69497e+03,0.82050e+03,0.94762e+03,0.10753e+04 /)
      kao(:, 2, 8, 7) = (/ &
        & 0.12628e+04,0.11108e+04,0.95881e+03,0.80678e+03,0.65467e+03, &
        & 0.69473e+03,0.82044e+03,0.94765e+03,0.10754e+04 /)
      kao(:, 3, 8, 7) = (/ &
        & 0.12455e+04,0.10957e+04,0.94585e+03,0.79597e+03,0.64602e+03, &
        & 0.69425e+03,0.82014e+03,0.94746e+03,0.10752e+04 /)
      kao(:, 4, 8, 7) = (/ &
        & 0.12303e+04,0.10824e+04,0.93446e+03,0.78648e+03,0.63843e+03, &
        & 0.69354e+03,0.81959e+03,0.94691e+03,0.10748e+04 /)
      kao(:, 5, 8, 7) = (/ &
        & 0.12169e+04,0.10706e+04,0.92437e+03,0.77807e+03,0.63171e+03, &
        & 0.69262e+03,0.81878e+03,0.94618e+03,0.10741e+04 /)
      kao(:, 1, 9, 7) = (/ &
        & 0.12413e+04,0.10920e+04,0.94266e+03,0.79331e+03,0.64390e+03, &
        & 0.69387e+03,0.81977e+03,0.94713e+03,0.10750e+04 /)
      kao(:, 2, 9, 7) = (/ &
        & 0.12236e+04,0.10765e+04,0.92938e+03,0.78225e+03,0.63504e+03, &
        & 0.69385e+03,0.81989e+03,0.94741e+03,0.10753e+04 /)
      kao(:, 3, 9, 7) = (/ &
        & 0.12082e+04,0.10631e+04,0.91789e+03,0.77267e+03,0.62738e+03, &
        & 0.69359e+03,0.81979e+03,0.94732e+03,0.10754e+04 /)
      kao(:, 4, 9, 7) = (/ &
        & 0.11949e+04,0.10514e+04,0.90785e+03,0.76430e+03,0.62068e+03, &
        & 0.69307e+03,0.81942e+03,0.94698e+03,0.10751e+04 /)
      kao(:, 5, 9, 7) = (/ &
        & 0.11831e+04,0.10410e+04,0.89899e+03,0.75692e+03,0.61500e+03, &
        & 0.69235e+03,0.81879e+03,0.94641e+03,0.10746e+04 /)
      kao(:, 1,10, 7) = (/ &
        & 0.12046e+04,0.10599e+04,0.91518e+03,0.77041e+03,0.62557e+03, &
        & 0.69285e+03,0.81909e+03,0.94663e+03,0.10746e+04 /)
      kao(:, 2,10, 7) = (/ &
        & 0.11890e+04,0.10463e+04,0.90347e+03,0.76066e+03,0.61799e+03, &
        & 0.69301e+03,0.81937e+03,0.94709e+03,0.10752e+04 /)
      kao(:, 3,10, 7) = (/ &
        & 0.11756e+04,0.10345e+04,0.89339e+03,0.75225e+03,0.61189e+03, &
        & 0.69293e+03,0.81942e+03,0.94719e+03,0.10754e+04 /)
      kao(:, 4,10, 7) = (/ &
        & 0.11639e+04,0.10243e+04,0.88463e+03,0.74495e+03,0.60683e+03, &
        & 0.69260e+03,0.81922e+03,0.94698e+03,0.10753e+04 /)
      kao(:, 5,10, 7) = (/ &
        & 0.11536e+04,0.10153e+04,0.87693e+03,0.73853e+03,0.60268e+03, &
        & 0.69203e+03,0.81871e+03,0.94653e+03,0.10749e+04 /)
      kao(:, 1,11, 7) = (/ &
        & 0.11668e+04,0.10268e+04,0.88684e+03,0.74678e+03,0.60837e+03, &
        & 0.69208e+03,0.81864e+03,0.94642e+03,0.10746e+04 /)
      kao(:, 2,11, 7) = (/ &
        & 0.11540e+04,0.10157e+04,0.87724e+03,0.73879e+03,0.60335e+03, &
        & 0.69229e+03,0.81896e+03,0.94691e+03,0.10752e+04 /)
      kao(:, 3,11, 7) = (/ &
        & 0.11430e+04,0.10060e+04,0.86898e+03,0.73191e+03,0.59939e+03, &
        & 0.69226e+03,0.81904e+03,0.94700e+03,0.10754e+04 /)
      kao(:, 4,11, 7) = (/ &
        & 0.11335e+04,0.99764e+03,0.86180e+03,0.72592e+03,0.59585e+03, &
        & 0.69198e+03,0.81884e+03,0.94679e+03,0.10753e+04 /)
      kao(:, 5,11, 7) = (/ &
        & 0.11251e+04,0.99028e+03,0.85549e+03,0.72067e+03,0.59286e+03, &
        & 0.69146e+03,0.81839e+03,0.94639e+03,0.10749e+04 /)
      kao(:, 1,12, 7) = (/ &
        & 0.11358e+04,0.99970e+03,0.86357e+03,0.72739e+03,0.59707e+03, &
        & 0.69145e+03,0.81829e+03,0.94626e+03,0.10746e+04 /)
      kao(:, 2,12, 7) = (/ &
        & 0.11253e+04,0.99054e+03,0.85571e+03,0.72085e+03,0.59339e+03, &
        & 0.69172e+03,0.81863e+03,0.94675e+03,0.10752e+04 /)
      kao(:, 3,12, 7) = (/ &
        & 0.11163e+04,0.98265e+03,0.84895e+03,0.71521e+03,0.59030e+03, &
        & 0.69172e+03,0.81873e+03,0.94686e+03,0.10754e+04 /)
      kao(:, 4,12, 7) = (/ &
        & 0.11085e+04,0.97579e+03,0.84307e+03,0.71031e+03,0.58782e+03, &
        & 0.69148e+03,0.81855e+03,0.94672e+03,0.10753e+04 /)
      kao(:, 5,12, 7) = (/ &
        & 0.11016e+04,0.96977e+03,0.83790e+03,0.70601e+03,0.58538e+03, &
        & 0.69099e+03,0.81812e+03,0.94628e+03,0.10749e+04 /)
      kao(:, 1,13, 7) = (/ &
        & 0.11104e+04,0.97748e+03,0.84452e+03,0.71152e+03,0.58852e+03, &
        & 0.69093e+03,0.81799e+03,0.94612e+03,0.10746e+04 /)
      kao(:, 2,13, 7) = (/ &
        & 0.11018e+04,0.96998e+03,0.83809e+03,0.70616e+03,0.58570e+03, &
        & 0.69123e+03,0.81841e+03,0.94664e+03,0.10752e+04 /)
      kao(:, 3,13, 7) = (/ &
        & 0.10945e+04,0.96352e+03,0.83255e+03,0.70155e+03,0.58307e+03, &
        & 0.69128e+03,0.81849e+03,0.94675e+03,0.10754e+04 /)
      kao(:, 4,13, 7) = (/ &
        & 0.10880e+04,0.95790e+03,0.82774e+03,0.69753e+03,0.58045e+03, &
        & 0.69107e+03,0.81832e+03,0.94657e+03,0.10753e+04 /)
      kao(:, 5,13, 7) = (/ &
        & 0.10824e+04,0.95297e+03,0.82351e+03,0.69401e+03,0.57806e+03, &
        & 0.69061e+03,0.81788e+03,0.94614e+03,0.10749e+04 /)
      kao(:, 1, 1, 8) = (/ &
        & 0.19433e+04,0.17047e+04,0.14661e+04,0.12275e+04,0.98902e+03, &
        & 0.75120e+03,0.85754e+03,0.98845e+03,0.11206e+04 /)
      kao(:, 2, 1, 8) = (/ &
        & 0.18941e+04,0.16616e+04,0.14292e+04,0.11968e+04,0.96439e+03, &
        & 0.73548e+03,0.85594e+03,0.98707e+03,0.11193e+04 /)
      kao(:, 3, 1, 8) = (/ &
        & 0.18499e+04,0.16229e+04,0.13960e+04,0.11691e+04,0.94229e+03, &
        & 0.72448e+03,0.85413e+03,0.98549e+03,0.11177e+04 /)
      kao(:, 4, 1, 8) = (/ &
        & 0.18099e+04,0.15880e+04,0.13661e+04,0.11442e+04,0.92233e+03, &
        & 0.72225e+03,0.85214e+03,0.98373e+03,0.11158e+04 /)
      kao(:, 5, 1, 8) = (/ &
        & 0.17737e+04,0.15563e+04,0.13389e+04,0.11215e+04,0.90421e+03, &
        & 0.72001e+03,0.85005e+03,0.98175e+03,0.11138e+04 /)
      kao(:, 1, 2, 8) = (/ &
        & 0.17953e+04,0.15751e+04,0.13551e+04,0.11350e+04,0.91499e+03, &
        & 0.72569e+03,0.85649e+03,0.98821e+03,0.11210e+04 /)
      kao(:, 2, 2, 8) = (/ &
        & 0.17530e+04,0.15382e+04,0.13234e+04,0.11086e+04,0.89388e+03, &
        & 0.72424e+03,0.85509e+03,0.98698e+03,0.11198e+04 /)
      kao(:, 3, 2, 8) = (/ &
        & 0.17152e+04,0.15051e+04,0.12950e+04,0.10850e+04,0.87497e+03, &
        & 0.72267e+03,0.85348e+03,0.98553e+03,0.11184e+04 /)
      kao(:, 4, 2, 8) = (/ &
        & 0.16811e+04,0.14753e+04,0.12695e+04,0.10637e+04,0.85793e+03, &
        & 0.72084e+03,0.85163e+03,0.98389e+03,0.11166e+04 /)
      kao(:, 5, 2, 8) = (/ &
        & 0.16502e+04,0.14483e+04,0.12463e+04,0.10444e+04,0.84250e+03, &
        & 0.71877e+03,0.84969e+03,0.98204e+03,0.11147e+04 /)
      kao(:, 1, 3, 8) = (/ &
        & 0.16788e+04,0.14733e+04,0.12678e+04,0.10623e+04,0.85679e+03, &
        & 0.72434e+03,0.85588e+03,0.98822e+03,0.11216e+04 /)
      kao(:, 2, 3, 8) = (/ &
        & 0.16418e+04,0.14409e+04,0.12400e+04,0.10391e+04,0.83827e+03, &
        & 0.72306e+03,0.85466e+03,0.98716e+03,0.11206e+04 /)
      kao(:, 3, 3, 8) = (/ &
        & 0.16087e+04,0.14119e+04,0.12152e+04,0.10184e+04,0.82172e+03, &
        & 0.72165e+03,0.85327e+03,0.98590e+03,0.11193e+04 /)
      kao(:, 4, 3, 8) = (/ &
        & 0.15790e+04,0.13859e+04,0.11929e+04,0.99988e+03,0.80688e+03, &
        & 0.72007e+03,0.85161e+03,0.98438e+03,0.11177e+04 /)
      kao(:, 5, 3, 8) = (/ &
        & 0.15522e+04,0.13625e+04,0.11728e+04,0.98311e+03,0.79349e+03, &
        & 0.71824e+03,0.84982e+03,0.98270e+03,0.11159e+04 /)
      kao(:, 1, 4, 8) = (/ &
        & 0.15823e+04,0.13888e+04,0.11953e+04,0.10019e+04,0.80851e+03, &
        & 0.72326e+03,0.85540e+03,0.98823e+03,0.11221e+04 /)
      kao(:, 2, 4, 8) = (/ &
        & 0.15495e+04,0.13601e+04,0.11708e+04,0.98142e+03,0.79213e+03, &
        & 0.72214e+03,0.85436e+03,0.98737e+03,0.11213e+04 /)
      kao(:, 3, 4, 8) = (/ &
        & 0.15204e+04,0.13346e+04,0.11489e+04,0.96322e+03,0.77758e+03, &
        & 0.72091e+03,0.85317e+03,0.98628e+03,0.11202e+04 /)
      kao(:, 4, 4, 8) = (/ &
        & 0.14943e+04,0.13118e+04,0.11294e+04,0.94694e+03,0.76455e+03, &
        & 0.71952e+03,0.85175e+03,0.98496e+03,0.11188e+04 /)
      kao(:, 5, 4, 8) = (/ &
        & 0.14709e+04,0.12913e+04,0.11118e+04,0.93229e+03,0.75284e+03, &
        & 0.71792e+03,0.85010e+03,0.98342e+03,0.11171e+04 /)
      kao(:, 1, 5, 8) = (/ &
        & 0.15002e+04,0.13170e+04,0.11338e+04,0.95063e+03,0.76749e+03, &
        & 0.72234e+03,0.85495e+03,0.98821e+03,0.11224e+04 /)
      kao(:, 2, 5, 8) = (/ &
        & 0.14712e+04,0.12916e+04,0.11120e+04,0.93250e+03,0.75300e+03, &
        & 0.72139e+03,0.85409e+03,0.98753e+03,0.11218e+04 /)
      kao(:, 3, 5, 8) = (/ &
        & 0.14456e+04,0.12692e+04,0.10928e+04,0.91647e+03,0.74017e+03, &
        & 0.72031e+03,0.85307e+03,0.98657e+03,0.11209e+04 /)
      kao(:, 4, 5, 8) = (/ &
        & 0.14227e+04,0.12492e+04,0.10757e+04,0.90219e+03,0.72875e+03, &
        & 0.71909e+03,0.85186e+03,0.98546e+03,0.11197e+04 /)
      kao(:, 5, 5, 8) = (/ &
        & 0.14022e+04,0.12312e+04,0.10603e+04,0.88937e+03,0.71851e+03, &
        & 0.71769e+03,0.85037e+03,0.98406e+03,0.11182e+04 /)
      kao(:, 1, 6, 8) = (/ &
        & 0.14314e+04,0.12568e+04,0.10822e+04,0.90763e+03,0.73310e+03, &
        & 0.72155e+03,0.85452e+03,0.98813e+03,0.11226e+04 /)
      kao(:, 2, 6, 8) = (/ &
        & 0.14056e+04,0.12342e+04,0.10628e+04,0.89150e+03,0.72020e+03, &
        & 0.72077e+03,0.85386e+03,0.98765e+03,0.11222e+04 /)
      kao(:, 3, 6, 8) = (/ &
        & 0.13829e+04,0.12143e+04,0.10458e+04,0.87730e+03,0.70887e+03, &
        & 0.71986e+03,0.85300e+03,0.98688e+03,0.11215e+04 /)
      kao(:, 4, 6, 8) = (/ &
        & 0.13627e+04,0.11967e+04,0.10307e+04,0.86473e+03,0.69880e+03, &
        & 0.71879e+03,0.85197e+03,0.98590e+03,0.11205e+04 /)
      kao(:, 5, 6, 8) = (/ &
        & 0.13448e+04,0.11810e+04,0.10172e+04,0.85348e+03,0.68979e+03, &
        & 0.71757e+03,0.85073e+03,0.98469e+03,0.11192e+04 /)
      kao(:, 1, 7, 8) = (/ &
        & 0.13728e+04,0.12055e+04,0.10383e+04,0.87102e+03,0.70382e+03, &
        & 0.72081e+03,0.85410e+03,0.98799e+03,0.11227e+04 /)
      kao(:, 2, 7, 8) = (/ &
        & 0.13499e+04,0.11854e+04,0.10210e+04,0.85666e+03,0.69233e+03, &
        & 0.72022e+03,0.85362e+03,0.98768e+03,0.11225e+04 /)
      kao(:, 3, 7, 8) = (/ &
        & 0.13297e+04,0.11678e+04,0.10059e+04,0.84408e+03,0.68228e+03, &
        & 0.71945e+03,0.85293e+03,0.98711e+03,0.11220e+04 /)
      kao(:, 4, 7, 8) = (/ &
        & 0.13120e+04,0.11523e+04,0.99261e+03,0.83298e+03,0.67339e+03, &
        & 0.71854e+03,0.85205e+03,0.98632e+03,0.11212e+04 /)
      kao(:, 5, 7, 8) = (/ &
        & 0.12962e+04,0.11384e+04,0.98077e+03,0.82312e+03,0.66550e+03, &
        & 0.71746e+03,0.85098e+03,0.98523e+03,0.11200e+04 /)
      kao(:, 1, 8, 8) = (/ &
        & 0.13227e+04,0.11617e+04,0.10007e+04,0.83971e+03,0.67877e+03, &
        & 0.72007e+03,0.85366e+03,0.98779e+03,0.11227e+04 /)
      kao(:, 2, 8, 8) = (/ &
        & 0.13022e+04,0.11438e+04,0.98533e+03,0.82690e+03,0.66854e+03, &
        & 0.71969e+03,0.85334e+03,0.98763e+03,0.11227e+04 /)
      kao(:, 3, 8, 8) = (/ &
        & 0.12844e+04,0.11282e+04,0.97196e+03,0.81577e+03,0.65963e+03, &
        & 0.71908e+03,0.85283e+03,0.98717e+03,0.11223e+04 /)
      kao(:, 4, 8, 8) = (/ &
        & 0.12688e+04,0.11145e+04,0.96023e+03,0.80599e+03,0.65182e+03, &
        & 0.71830e+03,0.85210e+03,0.98659e+03,0.11217e+04 /)
      kao(:, 5, 8, 8) = (/ &
        & 0.12549e+04,0.11024e+04,0.94982e+03,0.79733e+03,0.64488e+03, &
        & 0.71736e+03,0.85118e+03,0.98569e+03,0.11208e+04 /)
      kao(:, 1, 9, 8) = (/ &
        & 0.12800e+04,0.11244e+04,0.96868e+03,0.81302e+03,0.65744e+03, &
        & 0.71936e+03,0.85323e+03,0.98761e+03,0.11226e+04 /)
      kao(:, 2, 9, 8) = (/ &
        & 0.12618e+04,0.11084e+04,0.95498e+03,0.80161e+03,0.64832e+03, &
        & 0.71916e+03,0.85306e+03,0.98751e+03,0.11227e+04 /)
      kao(:, 3, 9, 8) = (/ &
        & 0.12460e+04,0.10945e+04,0.94313e+03,0.79175e+03,0.64042e+03, &
        & 0.71874e+03,0.85269e+03,0.98731e+03,0.11226e+04 /)
      kao(:, 4, 9, 8) = (/ &
        & 0.12322e+04,0.10825e+04,0.93277e+03,0.78311e+03,0.63351e+03, &
        & 0.71809e+03,0.85213e+03,0.98681e+03,0.11221e+04 /)
      kao(:, 5, 9, 8) = (/ &
        & 0.12200e+04,0.10718e+04,0.92365e+03,0.77552e+03,0.62743e+03, &
        & 0.71728e+03,0.85134e+03,0.98607e+03,0.11214e+04 /)
      kao(:, 1,10, 8) = (/ &
        & 0.12423e+04,0.10913e+04,0.94034e+03,0.78942e+03,0.63856e+03, &
        & 0.71867e+03,0.85279e+03,0.98738e+03,0.11225e+04 /)
      kao(:, 2,10, 8) = (/ &
        & 0.12262e+04,0.10772e+04,0.92827e+03,0.77936e+03,0.63052e+03, &
        & 0.71863e+03,0.85274e+03,0.98738e+03,0.11227e+04 /)
      kao(:, 3,10, 8) = (/ &
        & 0.12123e+04,0.10651e+04,0.91788e+03,0.77071e+03,0.62359e+03, &
        & 0.71835e+03,0.85251e+03,0.98725e+03,0.11227e+04 /)
      kao(:, 4,10, 8) = (/ &
        & 0.12002e+04,0.10545e+04,0.90884e+03,0.76317e+03,0.61756e+03, &
        & 0.71785e+03,0.85203e+03,0.98691e+03,0.11224e+04 /)
      kao(:, 5,10, 8) = (/ &
        & 0.11897e+04,0.10453e+04,0.90090e+03,0.75655e+03,0.61227e+03, &
        & 0.71716e+03,0.85141e+03,0.98631e+03,0.11218e+04 /)
      kao(:, 1,11, 8) = (/ &
        & 0.12033e+04,0.10572e+04,0.91110e+03,0.76506e+03,0.61908e+03, &
        & 0.71809e+03,0.85242e+03,0.98721e+03,0.11225e+04 /)
      kao(:, 2,11, 8) = (/ &
        & 0.11901e+04,0.10456e+04,0.90123e+03,0.75682e+03,0.61248e+03, &
        & 0.71809e+03,0.85240e+03,0.98723e+03,0.11226e+04 /)
      kao(:, 3,11, 8) = (/ &
        & 0.11788e+04,0.10357e+04,0.89271e+03,0.74972e+03,0.60692e+03, &
        & 0.71785e+03,0.85217e+03,0.98712e+03,0.11227e+04 /)
      kao(:, 4,11, 8) = (/ &
        & 0.11689e+04,0.10271e+04,0.88529e+03,0.74355e+03,0.60253e+03, &
        & 0.71738e+03,0.85177e+03,0.98681e+03,0.11224e+04 /)
      kao(:, 5,11, 8) = (/ &
        & 0.11602e+04,0.10195e+04,0.87880e+03,0.73813e+03,0.59855e+03, &
        & 0.71672e+03,0.85114e+03,0.98618e+03,0.11218e+04 /)
      kao(:, 1,12, 8) = (/ &
        & 0.11713e+04,0.10292e+04,0.88712e+03,0.74507e+03,0.60379e+03, &
        & 0.71766e+03,0.85212e+03,0.98706e+03,0.11225e+04 /)
      kao(:, 2,12, 8) = (/ &
        & 0.11605e+04,0.10197e+04,0.87902e+03,0.73833e+03,0.59891e+03, &
        & 0.71764e+03,0.85212e+03,0.98710e+03,0.11227e+04 /)
      kao(:, 3,12, 8) = (/ &
        & 0.11512e+04,0.10116e+04,0.87205e+03,0.73251e+03,0.59502e+03, &
        & 0.71744e+03,0.85192e+03,0.98700e+03,0.11227e+04 /)
      kao(:, 4,12, 8) = (/ &
        & 0.11431e+04,0.10045e+04,0.86598e+03,0.72746e+03,0.59151e+03, &
        & 0.71699e+03,0.85153e+03,0.98663e+03,0.11224e+04 /)
      kao(:, 5,12, 8) = (/ &
        & 0.11360e+04,0.99832e+03,0.86067e+03,0.72302e+03,0.58868e+03, &
        & 0.71636e+03,0.85092e+03,0.98606e+03,0.11218e+04 /)
      kao(:, 1,13, 8) = (/ &
        & 0.11451e+04,0.10063e+04,0.86748e+03,0.72871e+03,0.59258e+03, &
        & 0.71726e+03,0.85187e+03,0.98696e+03,0.11225e+04 /)
      kao(:, 2,13, 8) = (/ &
        & 0.11363e+04,0.99855e+03,0.86085e+03,0.72320e+03,0.58896e+03, &
        & 0.71729e+03,0.85183e+03,0.98699e+03,0.11227e+04 /)
      kao(:, 3,13, 8) = (/ &
        & 0.11287e+04,0.99189e+03,0.85515e+03,0.71842e+03,0.58585e+03, &
        & 0.71710e+03,0.85169e+03,0.98691e+03,0.11227e+04 /)
      kao(:, 4,13, 8) = (/ &
        & 0.11220e+04,0.98609e+03,0.85017e+03,0.71429e+03,0.58380e+03, &
        & 0.71668e+03,0.85133e+03,0.98660e+03,0.11224e+04 /)
      kao(:, 5,13, 8) = (/ &
        & 0.11162e+04,0.98101e+03,0.84582e+03,0.71065e+03,0.58234e+03, &
        & 0.71606e+03,0.85074e+03,0.98601e+03,0.11218e+04 /)
      kao(:, 1, 1, 9) = (/ &
        & 0.19571e+04,0.17167e+04,0.14761e+04,0.12357e+04,0.99528e+03, &
        & 0.75488e+03,0.87315e+03,0.10086e+04,0.11441e+04 /)
      kao(:, 2, 1, 9) = (/ &
        & 0.19076e+04,0.16733e+04,0.14390e+04,0.12047e+04,0.97044e+03, &
        & 0.73841e+03,0.87146e+03,0.10070e+04,0.11425e+04 /)
      kao(:, 3, 1, 9) = (/ &
        & 0.18630e+04,0.16343e+04,0.14056e+04,0.11769e+04,0.94822e+03, &
        & 0.73460e+03,0.86967e+03,0.10052e+04,0.11407e+04 /)
      kao(:, 4, 1, 9) = (/ &
        & 0.18229e+04,0.15991e+04,0.13754e+04,0.11517e+04,0.92811e+03, &
        & 0.73269e+03,0.86788e+03,0.10033e+04,0.11387e+04 /)
      kao(:, 5, 1, 9) = (/ &
        & 0.17864e+04,0.15672e+04,0.13481e+04,0.11289e+04,0.90984e+03, &
        & 0.73091e+03,0.86616e+03,0.10016e+04,0.11368e+04 /)
      kao(:, 1, 2, 9) = (/ &
        & 0.18080e+04,0.15862e+04,0.13643e+04,0.11425e+04,0.92072e+03, &
        & 0.73694e+03,0.87246e+03,0.10086e+04,0.11448e+04 /)
      kao(:, 2, 2, 9) = (/ &
        & 0.17655e+04,0.15491e+04,0.13324e+04,0.11159e+04,0.89943e+03, &
        & 0.73525e+03,0.87092e+03,0.10070e+04,0.11432e+04 /)
      kao(:, 3, 2, 9) = (/ &
        & 0.17274e+04,0.15157e+04,0.13039e+04,0.10921e+04,0.88039e+03, &
        & 0.73343e+03,0.86922e+03,0.10053e+04,0.11415e+04 /)
      kao(:, 4, 2, 9) = (/ &
        & 0.16931e+04,0.14856e+04,0.12781e+04,0.10706e+04,0.86326e+03, &
        & 0.73166e+03,0.86752e+03,0.10036e+04,0.11395e+04 /)
      kao(:, 5, 2, 9) = (/ &
        & 0.16621e+04,0.14584e+04,0.12549e+04,0.10512e+04,0.84768e+03, &
        & 0.73000e+03,0.86583e+03,0.10018e+04,0.11376e+04 /)
      kao(:, 1, 3, 9) = (/ &
        & 0.16908e+04,0.14837e+04,0.12764e+04,0.10692e+04,0.86209e+03, &
        & 0.73591e+03,0.87213e+03,0.10088e+04,0.11456e+04 /)
      kao(:, 2, 3, 9) = (/ &
        & 0.16535e+04,0.14509e+04,0.12484e+04,0.10459e+04,0.84339e+03, &
        & 0.73450e+03,0.87080e+03,0.10075e+04,0.11442e+04 /)
      kao(:, 3, 3, 9) = (/ &
        & 0.16202e+04,0.14218e+04,0.12234e+04,0.10251e+04,0.82680e+03, &
        & 0.73291e+03,0.86926e+03,0.10059e+04,0.11426e+04 /)
      kao(:, 4, 3, 9) = (/ &
        & 0.15902e+04,0.13956e+04,0.12011e+04,0.10064e+04,0.81183e+03, &
        & 0.73120e+03,0.86761e+03,0.10042e+04,0.11407e+04 /)
      kao(:, 5, 3, 9) = (/ &
        & 0.15632e+04,0.13720e+04,0.11808e+04,0.98952e+03,0.79832e+03, &
        & 0.72957e+03,0.86594e+03,0.10024e+04,0.11387e+04 /)
      kao(:, 1, 4, 9) = (/ &
        & 0.15935e+04,0.13985e+04,0.12035e+04,0.10084e+04,0.81344e+03, &
        & 0.73513e+03,0.87195e+03,0.10092e+04,0.11463e+04 /)
      kao(:, 2, 4, 9) = (/ &
        & 0.15605e+04,0.13697e+04,0.11787e+04,0.98782e+03,0.79694e+03, &
        & 0.73394e+03,0.87080e+03,0.10079e+04,0.11451e+04 /)
      kao(:, 3, 4, 9) = (/ &
        & 0.15313e+04,0.13439e+04,0.11567e+04,0.96950e+03,0.78229e+03, &
        & 0.73257e+03,0.86942e+03,0.10065e+04,0.11436e+04 /)
      kao(:, 4, 4, 9) = (/ &
        & 0.15050e+04,0.13210e+04,0.11371e+04,0.95308e+03,0.76922e+03, &
        & 0.73104e+03,0.86787e+03,0.10049e+04,0.11419e+04 /)
      kao(:, 5, 4, 9) = (/ &
        & 0.14814e+04,0.13003e+04,0.11193e+04,0.93833e+03,0.75745e+03, &
        & 0.72946e+03,0.86622e+03,0.10032e+04,0.11400e+04 /)
      kao(:, 1, 5, 9) = (/ &
        & 0.15109e+04,0.13262e+04,0.11415e+04,0.95685e+03,0.77217e+03, &
        & 0.73443e+03,0.87177e+03,0.10094e+04,0.11470e+04 /)
      kao(:, 2, 5, 9) = (/ &
        & 0.14817e+04,0.13007e+04,0.11196e+04,0.93852e+03,0.75755e+03, &
        & 0.73343e+03,0.87078e+03,0.10083e+04,0.11459e+04 /)
      kao(:, 3, 5, 9) = (/ &
        & 0.14559e+04,0.12780e+04,0.11003e+04,0.92240e+03,0.74463e+03, &
        & 0.73229e+03,0.86958e+03,0.10071e+04,0.11446e+04 /)
      kao(:, 4, 5, 9) = (/ &
        & 0.14329e+04,0.12579e+04,0.10829e+04,0.90802e+03,0.73310e+03, &
        & 0.73095e+03,0.86817e+03,0.10056e+04,0.11430e+04 /)
      kao(:, 5, 5, 9) = (/ &
        & 0.14122e+04,0.12398e+04,0.10675e+04,0.89511e+03,0.72281e+03, &
        & 0.72946e+03,0.86664e+03,0.10039e+04,0.11412e+04 /)
      kao(:, 1, 6, 9) = (/ &
        & 0.14417e+04,0.12655e+04,0.10896e+04,0.91348e+03,0.73747e+03, &
        & 0.73386e+03,0.87165e+03,0.10096e+04,0.11475e+04 /)
      kao(:, 2, 6, 9) = (/ &
        & 0.14156e+04,0.12429e+04,0.10700e+04,0.89725e+03,0.72457e+03, &
        & 0.73304e+03,0.87078e+03,0.10087e+04,0.11466e+04 /)
      kao(:, 3, 6, 9) = (/ &
        & 0.13928e+04,0.12228e+04,0.10529e+04,0.88300e+03,0.71308e+03, &
        & 0.73207e+03,0.86977e+03,0.10076e+04,0.11455e+04 /)
      kao(:, 4, 6, 9) = (/ &
        & 0.13725e+04,0.12051e+04,0.10377e+04,0.87029e+03,0.70290e+03, &
        & 0.73093e+03,0.86853e+03,0.10063e+04,0.11441e+04 /)
      kao(:, 5, 6, 9) = (/ &
        & 0.13544e+04,0.11892e+04,0.10241e+04,0.85897e+03,0.69390e+03, &
        & 0.72961e+03,0.86706e+03,0.10048e+04,0.11424e+04 /)
      kao(:, 1, 7, 9) = (/ &
        & 0.13826e+04,0.12140e+04,0.10453e+04,0.87664e+03,0.70803e+03, &
        & 0.73339e+03,0.87155e+03,0.10098e+04,0.11480e+04 /)
      kao(:, 2, 7, 9) = (/ &
        & 0.13594e+04,0.11937e+04,0.10279e+04,0.86216e+03,0.69645e+03, &
        & 0.73269e+03,0.87079e+03,0.10090e+04,0.11472e+04 /)
      kao(:, 3, 7, 9) = (/ &
        & 0.13392e+04,0.11759e+04,0.10127e+04,0.84953e+03,0.68632e+03, &
        & 0.73188e+03,0.86990e+03,0.10081e+04,0.11462e+04 /)
      kao(:, 4, 7, 9) = (/ &
        & 0.13213e+04,0.11603e+04,0.99928e+03,0.83829e+03,0.67737e+03, &
        & 0.73090e+03,0.86884e+03,0.10069e+04,0.11450e+04 /)
      kao(:, 5, 7, 9) = (/ &
        & 0.13054e+04,0.11464e+04,0.98739e+03,0.82837e+03,0.66946e+03, &
        & 0.72975e+03,0.86756e+03,0.10055e+04,0.11435e+04 /)
      kao(:, 1, 8, 9) = (/ &
        & 0.13322e+04,0.11698e+04,0.10074e+04,0.84511e+03,0.68280e+03, &
        & 0.73302e+03,0.87145e+03,0.10099e+04,0.11483e+04 /)
      kao(:, 2, 8, 9) = (/ &
        & 0.13116e+04,0.11517e+04,0.99199e+03,0.83221e+03,0.67250e+03, &
        & 0.73244e+03,0.87079e+03,0.10093e+04,0.11477e+04 /)
      kao(:, 3, 8, 9) = (/ &
        & 0.12937e+04,0.11360e+04,0.97848e+03,0.82097e+03,0.66349e+03, &
        & 0.73170e+03,0.87002e+03,0.10085e+04,0.11469e+04 /)
      kao(:, 4, 8, 9) = (/ &
        & 0.12778e+04,0.11223e+04,0.96666e+03,0.81113e+03,0.65562e+03, &
        & 0.73087e+03,0.86909e+03,0.10075e+04,0.11458e+04 /)
      kao(:, 5, 8, 9) = (/ &
        & 0.12639e+04,0.11101e+04,0.95620e+03,0.80244e+03,0.64865e+03, &
        & 0.72985e+03,0.86796e+03,0.10062e+04,0.11444e+04 /)
      kao(:, 1, 9, 9) = (/ &
        & 0.12892e+04,0.11322e+04,0.97520e+03,0.81821e+03,0.66134e+03, &
        & 0.73274e+03,0.87135e+03,0.10099e+04,0.11485e+04 /)
      kao(:, 2, 9, 9) = (/ &
        & 0.12708e+04,0.11161e+04,0.96140e+03,0.80674e+03,0.65213e+03, &
        & 0.73213e+03,0.87079e+03,0.10095e+04,0.11481e+04 /)
      kao(:, 3, 9, 9) = (/ &
        & 0.12548e+04,0.11022e+04,0.94949e+03,0.79681e+03,0.64421e+03, &
        & 0.73152e+03,0.87011e+03,0.10088e+04,0.11474e+04 /)
      kao(:, 4, 9, 9) = (/ &
        & 0.12410e+04,0.10900e+04,0.93905e+03,0.78808e+03,0.63726e+03, &
        & 0.73083e+03,0.86928e+03,0.10079e+04,0.11464e+04 /)
      kao(:, 5, 9, 9) = (/ &
        & 0.12287e+04,0.10793e+04,0.92981e+03,0.78042e+03,0.63106e+03, &
        & 0.72995e+03,0.86831e+03,0.10068e+04,0.11452e+04 /)
      kao(:, 1,10, 9) = (/ &
        & 0.12511e+04,0.10989e+04,0.94665e+03,0.79449e+03,0.64227e+03, &
        & 0.73248e+03,0.87121e+03,0.10099e+04,0.11487e+04 /)
      kao(:, 2,10, 9) = (/ &
        & 0.12350e+04,0.10848e+04,0.93449e+03,0.78435e+03,0.63416e+03, &
        & 0.73188e+03,0.87073e+03,0.10095e+04,0.11483e+04 /)
      kao(:, 3,10, 9) = (/ &
        & 0.12209e+04,0.10725e+04,0.92407e+03,0.77565e+03,0.62724e+03, &
        & 0.73132e+03,0.87012e+03,0.10091e+04,0.11477e+04 /)
      kao(:, 4,10, 9) = (/ &
        & 0.12088e+04,0.10618e+04,0.91493e+03,0.76801e+03,0.62113e+03, &
        & 0.73072e+03,0.86943e+03,0.10082e+04,0.11469e+04 /)
      kao(:, 5,10, 9) = (/ &
        & 0.11981e+04,0.10526e+04,0.90691e+03,0.76134e+03,0.61583e+03, &
        & 0.72997e+03,0.86853e+03,0.10072e+04,0.11458e+04 /)
      kao(:, 1,11, 9) = (/ &
        & 0.12119e+04,0.10646e+04,0.91723e+03,0.76995e+03,0.62265e+03, &
        & 0.73201e+03,0.87093e+03,0.10098e+04,0.11487e+04 /)
      kao(:, 2,11, 9) = (/ &
        & 0.11986e+04,0.10529e+04,0.90727e+03,0.76161e+03,0.61603e+03, &
        & 0.73147e+03,0.87046e+03,0.10094e+04,0.11483e+04 /)
      kao(:, 3,11, 9) = (/ &
        & 0.11871e+04,0.10429e+04,0.89865e+03,0.75449e+03,0.61031e+03, &
        & 0.73094e+03,0.86988e+03,0.10088e+04,0.11477e+04 /)
      kao(:, 4,11, 9) = (/ &
        & 0.11772e+04,0.10342e+04,0.89122e+03,0.74824e+03,0.60537e+03, &
        & 0.73035e+03,0.86918e+03,0.10081e+04,0.11469e+04 /)
      kao(:, 5,11, 9) = (/ &
        & 0.11684e+04,0.10265e+04,0.88467e+03,0.74278e+03,0.60127e+03, &
        & 0.72963e+03,0.86831e+03,0.10071e+04,0.11458e+04 /)
      kao(:, 1,12, 9) = (/ &
        & 0.11796e+04,0.10363e+04,0.89308e+03,0.74980e+03,0.60664e+03, &
        & 0.73158e+03,0.87066e+03,0.10097e+04,0.11487e+04 /)
      kao(:, 2,12, 9) = (/ &
        & 0.11688e+04,0.10268e+04,0.88492e+03,0.74297e+03,0.60173e+03, &
        & 0.73111e+03,0.87023e+03,0.10093e+04,0.11483e+04 /)
      kao(:, 3,12, 9) = (/ &
        & 0.11594e+04,0.10186e+04,0.87787e+03,0.73715e+03,0.59711e+03, &
        & 0.73061e+03,0.86968e+03,0.10088e+04,0.11478e+04 /)
      kao(:, 4,12, 9) = (/ &
        & 0.11512e+04,0.10115e+04,0.87180e+03,0.73203e+03,0.59373e+03, &
        & 0.73004e+03,0.86900e+03,0.10080e+04,0.11469e+04 /)
      kao(:, 5,12, 9) = (/ &
        & 0.11441e+04,0.10053e+04,0.86640e+03,0.72756e+03,0.59149e+03, &
        & 0.72934e+03,0.86813e+03,0.10070e+04,0.11458e+04 /)
      kao(:, 1,13, 9) = (/ &
        & 0.11533e+04,0.10132e+04,0.87330e+03,0.73334e+03,0.59476e+03, &
        & 0.73130e+03,0.87046e+03,0.10096e+04,0.11487e+04 /)
      kao(:, 2,13, 9) = (/ &
        & 0.11444e+04,0.10055e+04,0.86659e+03,0.72770e+03,0.59240e+03, &
        & 0.73084e+03,0.87005e+03,0.10092e+04,0.11483e+04 /)
      kao(:, 3,13, 9) = (/ &
        & 0.11367e+04,0.99882e+03,0.86084e+03,0.72297e+03,0.59186e+03, &
        & 0.73036e+03,0.86950e+03,0.10087e+04,0.11478e+04 /)
      kao(:, 4,13, 9) = (/ &
        & 0.11300e+04,0.99294e+03,0.85585e+03,0.71880e+03,0.59143e+03, &
        & 0.72979e+03,0.86883e+03,0.10079e+04,0.11469e+04 /)
      kao(:, 5,13, 9) = (/ &
        & 0.11242e+04,0.98788e+03,0.85146e+03,0.71512e+03,0.59082e+03, &
        & 0.72910e+03,0.86797e+03,0.10069e+04,0.11459e+04 /)
      kao(:, 1, 1,10) = (/ &
        & 0.19609e+04,0.17196e+04,0.14787e+04,0.12373e+04,0.99636e+03, &
        & 0.75577e+03,0.88158e+03,0.10175e+04,0.11538e+04 /)
      kao(:, 2, 1,10) = (/ &
        & 0.19102e+04,0.16765e+04,0.14403e+04,0.12063e+04,0.97232e+03, &
        & 0.74406e+03,0.87986e+03,0.10152e+04,0.11513e+04 /)
      kao(:, 3, 1,10) = (/ &
        & 0.18658e+04,0.16364e+04,0.14075e+04,0.11783e+04,0.94916e+03, &
        & 0.74249e+03,0.87815e+03,0.10135e+04,0.11491e+04 /)
      kao(:, 4, 1,10) = (/ &
        & 0.18250e+04,0.16014e+04,0.13778e+04,0.11533e+04,0.92945e+03, &
        & 0.74050e+03,0.87640e+03,0.10114e+04,0.11477e+04 /)
      kao(:, 5, 1,10) = (/ &
        & 0.17888e+04,0.15692e+04,0.13504e+04,0.11313e+04,0.91134e+03, &
        & 0.73837e+03,0.87432e+03,0.10096e+04,0.11467e+04 /)
      kao(:, 1, 2,10) = (/ &
        & 0.18108e+04,0.15879e+04,0.13673e+04,0.11437e+04,0.92213e+03, &
        & 0.74428e+03,0.88077e+03,0.10175e+04,0.11547e+04 /)
      kao(:, 2, 2,10) = (/ &
        & 0.17684e+04,0.15508e+04,0.13352e+04,0.11178e+04,0.90099e+03, &
        & 0.74265e+03,0.87920e+03,0.10158e+04,0.11521e+04 /)
      kao(:, 3, 2,10) = (/ &
        & 0.17293e+04,0.15183e+04,0.13063e+04,0.10931e+04,0.88199e+03, &
        & 0.74117e+03,0.87755e+03,0.10136e+04,0.11500e+04 /)
      kao(:, 4, 2,10) = (/ &
        & 0.16960e+04,0.14887e+04,0.12799e+04,0.10727e+04,0.86433e+03, &
        & 0.73957e+03,0.87577e+03,0.10116e+04,0.11482e+04 /)
      kao(:, 5, 2,10) = (/ &
        & 0.16637e+04,0.14607e+04,0.12562e+04,0.10527e+04,0.84877e+03, &
        & 0.73748e+03,0.87409e+03,0.10096e+04,0.11470e+04 /)
      kao(:, 1, 3,10) = (/ &
        & 0.16939e+04,0.14847e+04,0.12786e+04,0.10705e+04,0.86372e+03, &
        & 0.74343e+03,0.88064e+03,0.10178e+04,0.11559e+04 /)
      kao(:, 2, 3,10) = (/ &
        & 0.16557e+04,0.14542e+04,0.12503e+04,0.10478e+04,0.84533e+03, &
        & 0.74182e+03,0.87906e+03,0.10163e+04,0.11537e+04 /)
      kao(:, 3, 3,10) = (/ &
        & 0.16218e+04,0.14239e+04,0.12249e+04,0.10266e+04,0.82819e+03, &
        & 0.74031e+03,0.87730e+03,0.10137e+04,0.11513e+04 /)
      kao(:, 4, 3,10) = (/ &
        & 0.15929e+04,0.13992e+04,0.12027e+04,0.10077e+04,0.81299e+03, &
        & 0.73896e+03,0.87590e+03,0.10123e+04,0.11493e+04 /)
      kao(:, 5, 3,10) = (/ &
        & 0.15654e+04,0.13740e+04,0.11824e+04,0.99136e+03,0.79933e+03, &
        & 0.73740e+03,0.87406e+03,0.10104e+04,0.11477e+04 /)
      kao(:, 1, 4,10) = (/ &
        & 0.15959e+04,0.14010e+04,0.12054e+04,0.10100e+04,0.81522e+03, &
        & 0.74271e+03,0.88040e+03,0.10180e+04,0.11570e+04 /)
      kao(:, 2, 4,10) = (/ &
        & 0.15637e+04,0.13710e+04,0.11804e+04,0.98920e+03,0.79803e+03, &
        & 0.74139e+03,0.87903e+03,0.10168e+04,0.11552e+04 /)
      kao(:, 3, 4,10) = (/ &
        & 0.15330e+04,0.13459e+04,0.11594e+04,0.97120e+03,0.78314e+03, &
        & 0.74000e+03,0.87753e+03,0.10151e+04,0.11528e+04 /)
      kao(:, 4, 4,10) = (/ &
        & 0.15077e+04,0.13229e+04,0.11386e+04,0.95486e+03,0.77029e+03, &
        & 0.73854e+03,0.87600e+03,0.10131e+04,0.11506e+04 /)
      kao(:, 5, 4,10) = (/ &
        & 0.14835e+04,0.13025e+04,0.11209e+04,0.94000e+03,0.75786e+03, &
        & 0.73717e+03,0.87438e+03,0.10111e+04,0.11486e+04 /)
      kao(:, 1, 5,10) = (/ &
        & 0.15126e+04,0.13285e+04,0.11431e+04,0.95745e+03,0.77284e+03, &
        & 0.74220e+03,0.88024e+03,0.10187e+04,0.11578e+04 /)
      kao(:, 2, 5,10) = (/ &
        & 0.14829e+04,0.13024e+04,0.11209e+04,0.94020e+03,0.75863e+03, &
        & 0.74099e+03,0.87909e+03,0.10174e+04,0.11564e+04 /)
      kao(:, 3, 5,10) = (/ &
        & 0.14582e+04,0.12806e+04,0.11014e+04,0.92377e+03,0.74596e+03, &
        & 0.73960e+03,0.87772e+03,0.10159e+04,0.11544e+04 /)
      kao(:, 4, 5,10) = (/ &
        & 0.14345e+04,0.12594e+04,0.10847e+04,0.90887e+03,0.73410e+03, &
        & 0.73828e+03,0.87622e+03,0.10139e+04,0.11518e+04 /)
      kao(:, 5, 5,10) = (/ &
        & 0.14140e+04,0.12418e+04,0.10683e+04,0.89661e+03,0.72364e+03, &
        & 0.73696e+03,0.87469e+03,0.10119e+04,0.11501e+04 /)
      kao(:, 1, 6,10) = (/ &
        & 0.14435e+04,0.12676e+04,0.10914e+04,0.91493e+03,0.73889e+03, &
        & 0.74179e+03,0.88024e+03,0.10190e+04,0.11586e+04 /)
      kao(:, 2, 6,10) = (/ &
        & 0.14184e+04,0.12443e+04,0.10722e+04,0.89834e+03,0.72535e+03, &
        & 0.74069e+03,0.87922e+03,0.10178e+04,0.11574e+04 /)
      kao(:, 3, 6,10) = (/ &
        & 0.13949e+04,0.12245e+04,0.10548e+04,0.88411e+03,0.71441e+03, &
        & 0.73951e+03,0.87792e+03,0.10164e+04,0.11554e+04 /)
      kao(:, 4, 6,10) = (/ &
        & 0.13745e+04,0.12070e+04,0.10388e+04,0.87157e+03,0.70381e+03, &
        & 0.73817e+03,0.87654e+03,0.10150e+04,0.11533e+04 /)
      kao(:, 5, 6,10) = (/ &
        & 0.13558e+04,0.11909e+04,0.10253e+04,0.86039e+03,0.69505e+03, &
        & 0.73669e+03,0.87508e+03,0.10128e+04,0.11510e+04 /)
      kao(:, 1, 7,10) = (/ &
        & 0.13849e+04,0.12154e+04,0.10465e+04,0.87809e+03,0.70922e+03, &
        & 0.74150e+03,0.88017e+03,0.10197e+04,0.11599e+04 /)
      kao(:, 2, 7,10) = (/ &
        & 0.13622e+04,0.11954e+04,0.10296e+04,0.86328e+03,0.69750e+03, &
        & 0.74031e+03,0.87926e+03,0.10184e+04,0.11581e+04 /)
      kao(:, 3, 7,10) = (/ &
        & 0.13407e+04,0.11775e+04,0.10144e+04,0.85098e+03,0.68710e+03, &
        & 0.73933e+03,0.87824e+03,0.10171e+04,0.11568e+04 /)
      kao(:, 4, 7,10) = (/ &
        & 0.13234e+04,0.11620e+04,0.10006e+04,0.83940e+03,0.67808e+03, &
        & 0.73818e+03,0.87693e+03,0.10157e+04,0.11549e+04 /)
      kao(:, 5, 7,10) = (/ &
        & 0.13077e+04,0.11481e+04,0.98850e+03,0.82952e+03,0.66976e+03, &
        & 0.73685e+03,0.87533e+03,0.10140e+04,0.11525e+04 /)
      kao(:, 1, 8,10) = (/ &
        & 0.13336e+04,0.11711e+04,0.10088e+04,0.84626e+03,0.68382e+03, &
        & 0.74131e+03,0.88025e+03,0.10205e+04,0.11609e+04 /)
      kao(:, 2, 8,10) = (/ &
        & 0.13133e+04,0.11535e+04,0.99382e+03,0.83328e+03,0.67355e+03, &
        & 0.73954e+03,0.87931e+03,0.10187e+04,0.11591e+04 /)
      kao(:, 3, 8,10) = (/ &
        & 0.12952e+04,0.11377e+04,0.97980e+03,0.82257e+03,0.66450e+03, &
        & 0.73910e+03,0.87831e+03,0.10177e+04,0.11576e+04 /)
      kao(:, 4, 8,10) = (/ &
        & 0.12798e+04,0.11238e+04,0.96848e+03,0.81189e+03,0.65672e+03, &
        & 0.73820e+03,0.87729e+03,0.10162e+04,0.11560e+04 /)
      kao(:, 5, 8,10) = (/ &
        & 0.12652e+04,0.11115e+04,0.95739e+03,0.80373e+03,0.64938e+03, &
        & 0.73712e+03,0.87584e+03,0.10149e+04,0.11541e+04 /)
      kao(:, 1, 9,10) = (/ &
        & 0.12921e+04,0.11338e+04,0.97649e+03,0.81965e+03,0.66193e+03, &
        & 0.74117e+03,0.88056e+03,0.10212e+04,0.11621e+04 /)
      kao(:, 2, 9,10) = (/ &
        & 0.12725e+04,0.11175e+04,0.96294e+03,0.80792e+03,0.65314e+03, &
        & 0.74018e+03,0.87944e+03,0.10196e+04,0.11602e+04 /)
      kao(:, 3, 9,10) = (/ &
        & 0.12569e+04,0.11032e+04,0.95038e+03,0.79825e+03,0.64471e+03, &
        & 0.73910e+03,0.87852e+03,0.10181e+04,0.11585e+04 /)
      kao(:, 4, 9,10) = (/ &
        & 0.12428e+04,0.10914e+04,0.94028e+03,0.78940e+03,0.63769e+03, &
        & 0.73816e+03,0.87758e+03,0.10170e+04,0.11569e+04 /)
      kao(:, 5, 9,10) = (/ &
        & 0.12310e+04,0.10815e+04,0.93149e+03,0.78151e+03,0.63218e+03, &
        & 0.73726e+03,0.87637e+03,0.10156e+04,0.11553e+04 /)
      kao(:, 1,10,10) = (/ &
        & 0.12531e+04,0.11009e+04,0.94808e+03,0.79569e+03,0.64353e+03, &
        & 0.74092e+03,0.88101e+03,0.10222e+04,0.11631e+04 /)
      kao(:, 2,10,10) = (/ &
        & 0.12357e+04,0.10861e+04,0.93599e+03,0.78490e+03,0.63564e+03, &
        & 0.74008e+03,0.87961e+03,0.10203e+04,0.11613e+04 /)
      kao(:, 3,10,10) = (/ &
        & 0.12227e+04,0.10738e+04,0.92501e+03,0.77680e+03,0.62842e+03, &
        & 0.73914e+03,0.87860e+03,0.10179e+04,0.11592e+04 /)
      kao(:, 4,10,10) = (/ &
        & 0.12109e+04,0.10632e+04,0.91605e+03,0.76920e+03,0.62177e+03, &
        & 0.73819e+03,0.87758e+03,0.10174e+04,0.11577e+04 /)
      kao(:, 5,10,10) = (/ &
        & 0.11998e+04,0.10537e+04,0.90813e+03,0.76232e+03,0.61616e+03, &
        & 0.73732e+03,0.87676e+03,0.10162e+04,0.11563e+04 /)
      kao(:, 1,11,10) = (/ &
        & 0.12137e+04,0.10654e+04,0.91884e+03,0.77105e+03,0.62358e+03, &
        & 0.74042e+03,0.88057e+03,0.10221e+04,0.11630e+04 /)
      kao(:, 2,11,10) = (/ &
        & 0.11999e+04,0.10545e+04,0.90854e+03,0.76253e+03,0.61715e+03, &
        & 0.73961e+03,0.87932e+03,0.10201e+04,0.11611e+04 /)
      kao(:, 3,11,10) = (/ &
        & 0.11890e+04,0.10445e+04,0.90019e+03,0.75537e+03,0.61109e+03, &
        & 0.73864e+03,0.87832e+03,0.10186e+04,0.11592e+04 /)
      kao(:, 4,11,10) = (/ &
        & 0.11789e+04,0.10359e+04,0.89280e+03,0.74928e+03,0.60622e+03, &
        & 0.73779e+03,0.87747e+03,0.10172e+04,0.11577e+04 /)
      kao(:, 5,11,10) = (/ &
        & 0.11709e+04,0.10287e+04,0.88607e+03,0.74401e+03,0.60247e+03, &
        & 0.73688e+03,0.87644e+03,0.10160e+04,0.11563e+04 /)
      kao(:, 1,12,10) = (/ &
        & 0.11820e+04,0.10383e+04,0.89456e+03,0.75081e+03,0.60714e+03, &
        & 0.74001e+03,0.88049e+03,0.10220e+04,0.11631e+04 /)
      kao(:, 2,12,10) = (/ &
        & 0.11713e+04,0.10290e+04,0.88623e+03,0.74407e+03,0.60058e+03, &
        & 0.73921e+03,0.87901e+03,0.10201e+04,0.11611e+04 /)
      kao(:, 3,12,10) = (/ &
        & 0.11605e+04,0.10200e+04,0.87951e+03,0.73788e+03,0.59769e+03, &
        & 0.73835e+03,0.87808e+03,0.10182e+04,0.11591e+04 /)
      kao(:, 4,12,10) = (/ &
        & 0.11533e+04,0.10132e+04,0.87284e+03,0.73305e+03,0.59795e+03, &
        & 0.73753e+03,0.87718e+03,0.10171e+04,0.11577e+04 /)
      kao(:, 5,12,10) = (/ &
        & 0.11467e+04,0.10071e+04,0.86739e+03,0.72890e+03,0.59711e+03, &
        & 0.73664e+03,0.87623e+03,0.10159e+04,0.11563e+04 /)
      kao(:, 1,13,10) = (/ &
        & 0.11553e+04,0.10149e+04,0.87419e+03,0.73470e+03,0.59975e+03, &
        & 0.73968e+03,0.88029e+03,0.10219e+04,0.11630e+04 /)
      kao(:, 2,13,10) = (/ &
        & 0.11455e+04,0.10072e+04,0.86782e+03,0.72873e+03,0.59921e+03, &
        & 0.73889e+03,0.87889e+03,0.10200e+04,0.11611e+04 /)
      kao(:, 3,13,10) = (/ &
        & 0.11380e+04,0.10000e+04,0.86190e+03,0.72452e+03,0.59831e+03, &
        & 0.73799e+03,0.87789e+03,0.10182e+04,0.11592e+04 /)
      kao(:, 4,13,10) = (/ &
        & 0.11318e+04,0.99472e+03,0.85697e+03,0.71950e+03,0.59744e+03, &
        & 0.73726e+03,0.87708e+03,0.10170e+04,0.11577e+04 /)
      kao(:, 5,13,10) = (/ &
        & 0.11253e+04,0.98825e+03,0.85273e+03,0.71635e+03,0.59683e+03, &
        & 0.73639e+03,0.87606e+03,0.10160e+04,0.11562e+04 /)
      kao(:, 1, 1,11) = (/ &
        & 0.19598e+04,0.17186e+04,0.14777e+04,0.12380e+04,0.99729e+03, &
        & 0.75567e+03,0.88469e+03,0.10202e+04,0.11560e+04 /)
      kao(:, 2, 1,11) = (/ &
        & 0.19102e+04,0.16743e+04,0.14414e+04,0.12066e+04,0.97117e+03, &
        & 0.74679e+03,0.88252e+03,0.10178e+04,0.11544e+04 /)
      kao(:, 3, 1,11) = (/ &
        & 0.18656e+04,0.16383e+04,0.14073e+04,0.11791e+04,0.94951e+03, &
        & 0.74505e+03,0.88029e+03,0.10159e+04,0.11530e+04 /)
      kao(:, 4, 1,11) = (/ &
        & 0.18261e+04,0.16025e+04,0.13782e+04,0.11540e+04,0.92917e+03, &
        & 0.74299e+03,0.87816e+03,0.10141e+04,0.11522e+04 /)
      kao(:, 5, 1,11) = (/ &
        & 0.17888e+04,0.15710e+04,0.13500e+04,0.11298e+04,0.91140e+03, &
        & 0.74109e+03,0.87588e+03,0.10122e+04,0.11510e+04 /)
      kao(:, 1, 2,11) = (/ &
        & 0.18117e+04,0.15887e+04,0.13651e+04,0.11459e+04,0.92177e+03, &
        & 0.74731e+03,0.88412e+03,0.10203e+04,0.11568e+04 /)
      kao(:, 2, 2,11) = (/ &
        & 0.17673e+04,0.15512e+04,0.13335e+04,0.11174e+04,0.90028e+03, &
        & 0.74546e+03,0.88203e+03,0.10179e+04,0.11551e+04 /)
      kao(:, 3, 2,11) = (/ &
        & 0.17317e+04,0.15193e+04,0.13050e+04,0.10955e+04,0.88112e+03, &
        & 0.74378e+03,0.87978e+03,0.10161e+04,0.11535e+04 /)
      kao(:, 4, 2,11) = (/ &
        & 0.16956e+04,0.14873e+04,0.12805e+04,0.10729e+04,0.86470e+03, &
        & 0.74189e+03,0.87768e+03,0.10142e+04,0.11524e+04 /)
      kao(:, 5, 2,11) = (/ &
        & 0.16657e+04,0.14596e+04,0.12568e+04,0.10531e+04,0.84904e+03, &
        & 0.73979e+03,0.87528e+03,0.10122e+04,0.11511e+04 /)
      kao(:, 1, 3,11) = (/ &
        & 0.16927e+04,0.14859e+04,0.12782e+04,0.10724e+04,0.86335e+03, &
        & 0.74646e+03,0.88392e+03,0.10211e+04,0.11579e+04 /)
      kao(:, 2, 3,11) = (/ &
        & 0.16581e+04,0.14524e+04,0.12540e+04,0.10466e+04,0.84448e+03, &
        & 0.74471e+03,0.88205e+03,0.10189e+04,0.11562e+04 /)
      kao(:, 3, 3,11) = (/ &
        & 0.16261e+04,0.14229e+04,0.12269e+04,0.10264e+04,0.82790e+03, &
        & 0.74305e+03,0.87988e+03,0.10167e+04,0.11544e+04 /)
      kao(:, 4, 3,11) = (/ &
        & 0.15929e+04,0.13986e+04,0.12038e+04,0.10084e+04,0.81266e+03, &
        & 0.74160e+03,0.87767e+03,0.10148e+04,0.11530e+04 /)
      kao(:, 5, 3,11) = (/ &
        & 0.15661e+04,0.13746e+04,0.11837e+04,0.99103e+03,0.79967e+03, &
        & 0.73929e+03,0.87586e+03,0.10132e+04,0.11521e+04 /)
      kao(:, 1, 4,11) = (/ &
        & 0.15973e+04,0.14004e+04,0.12065e+04,0.10106e+04,0.81385e+03, &
        & 0.74599e+03,0.88404e+03,0.10218e+04,0.11590e+04 /)
      kao(:, 2, 4,11) = (/ &
        & 0.15637e+04,0.13722e+04,0.11812e+04,0.98900e+03,0.79856e+03, &
        & 0.74428e+03,0.88217e+03,0.10197e+04,0.11572e+04 /)
      kao(:, 3, 4,11) = (/ &
        & 0.15340e+04,0.13469e+04,0.11576e+04,0.97012e+03,0.78412e+03, &
        & 0.74257e+03,0.88022e+03,0.10176e+04,0.11556e+04 /)
      kao(:, 4, 4,11) = (/ &
        & 0.15085e+04,0.13226e+04,0.11393e+04,0.95486e+03,0.76980e+03, &
        & 0.74114e+03,0.87815e+03,0.10155e+04,0.11538e+04 /)
      kao(:, 5, 4,11) = (/ &
        & 0.14836e+04,0.13020e+04,0.11212e+04,0.93957e+03,0.75824e+03, &
        & 0.73939e+03,0.87630e+03,0.10138e+04,0.11526e+04 /)
      kao(:, 1, 5,11) = (/ &
        & 0.15143e+04,0.13286e+04,0.11431e+04,0.95847e+03,0.77403e+03, &
        & 0.74572e+03,0.88418e+03,0.10223e+04,0.11603e+04 /)
      kao(:, 2, 5,11) = (/ &
        & 0.14842e+04,0.13025e+04,0.11230e+04,0.94028e+03,0.75881e+03, &
        & 0.74405e+03,0.88254e+03,0.10205e+04,0.11584e+04 /)
      kao(:, 3, 5,11) = (/ &
        & 0.14577e+04,0.12799e+04,0.11020e+04,0.92340e+03,0.74531e+03, &
        & 0.74244e+03,0.88060e+03,0.10185e+04,0.11566e+04 /)
      kao(:, 4, 5,11) = (/ &
        & 0.14365e+04,0.12603e+04,0.10859e+04,0.90939e+03,0.73467e+03, &
        & 0.74090e+03,0.87865e+03,0.10164e+04,0.11549e+04 /)
      kao(:, 5, 5,11) = (/ &
        & 0.14147e+04,0.12422e+04,0.10695e+04,0.89657e+03,0.72409e+03, &
        & 0.73938e+03,0.87659e+03,0.10145e+04,0.11530e+04 /)
      kao(:, 1, 6,11) = (/ &
        & 0.14426e+04,0.12686e+04,0.10911e+04,0.91528e+03,0.73914e+03, &
        & 0.74563e+03,0.88436e+03,0.10228e+04,0.11615e+04 /)
      kao(:, 2, 6,11) = (/ &
        & 0.14171e+04,0.12457e+04,0.10728e+04,0.89861e+03,0.72517e+03, &
        & 0.74402e+03,0.88280e+03,0.10215e+04,0.11596e+04 /)
      kao(:, 3, 6,11) = (/ &
        & 0.13943e+04,0.12252e+04,0.10539e+04,0.88362e+03,0.71333e+03, &
        & 0.74243e+03,0.88117e+03,0.10194e+04,0.11577e+04 /)
      kao(:, 4, 6,11) = (/ &
        & 0.13749e+04,0.12056e+04,0.10405e+04,0.87188e+03,0.70449e+03, &
        & 0.74089e+03,0.87923e+03,0.10173e+04,0.11560e+04 /)
      kao(:, 5, 6,11) = (/ &
        & 0.13580e+04,0.11907e+04,0.10258e+04,0.85998e+03,0.69473e+03, &
        & 0.73937e+03,0.87727e+03,0.10154e+04,0.11543e+04 /)
      kao(:, 1, 7,11) = (/ &
        & 0.13844e+04,0.12166e+04,0.10469e+04,0.87815e+03,0.70873e+03, &
        & 0.74560e+03,0.88449e+03,0.10233e+04,0.11626e+04 /)
      kao(:, 2, 7,11) = (/ &
        & 0.13610e+04,0.11962e+04,0.10291e+04,0.86318e+03,0.69730e+03, &
        & 0.74409e+03,0.88322e+03,0.10221e+04,0.11608e+04 /)
      kao(:, 3, 7,11) = (/ &
        & 0.13413e+04,0.11786e+04,0.10145e+04,0.85031e+03,0.68760e+03, &
        & 0.74253e+03,0.88154e+03,0.10203e+04,0.11589e+04 /)
      kao(:, 4, 7,11) = (/ &
        & 0.13235e+04,0.11630e+04,0.10007e+04,0.84004e+03,0.67864e+03, &
        & 0.74101e+03,0.87982e+03,0.10185e+04,0.11572e+04 /)
      kao(:, 5, 7,11) = (/ &
        & 0.13063e+04,0.11482e+04,0.98932e+03,0.82998e+03,0.67037e+03, &
        & 0.73955e+03,0.87796e+03,0.10167e+04,0.11554e+04 /)
      kao(:, 1, 8,11) = (/ &
        & 0.13361e+04,0.11714e+04,0.10092e+04,0.84627e+03,0.68340e+03, &
        & 0.74540e+03,0.88457e+03,0.10236e+04,0.11638e+04 /)
      kao(:, 2, 8,11) = (/ &
        & 0.13143e+04,0.11537e+04,0.99295e+03,0.83355e+03,0.67330e+03, &
        & 0.74420e+03,0.88339e+03,0.10225e+04,0.11619e+04 /)
      kao(:, 3, 8,11) = (/ &
        & 0.12952e+04,0.11377e+04,0.98075e+03,0.82213e+03,0.66496e+03, &
        & 0.74271e+03,0.88199e+03,0.10211e+04,0.11601e+04 /)
      kao(:, 4, 8,11) = (/ &
        & 0.12808e+04,0.11242e+04,0.96858e+03,0.81350e+03,0.65663e+03, &
        & 0.74121e+03,0.88037e+03,0.10192e+04,0.11582e+04 /)
      kao(:, 5, 8,11) = (/ &
        & 0.12664e+04,0.11113e+04,0.95757e+03,0.80317e+03,0.64978e+03, &
        & 0.73975e+03,0.87862e+03,0.10173e+04,0.11564e+04 /)
      kao(:, 1, 9,11) = (/ &
        & 0.12911e+04,0.11331e+04,0.97754e+03,0.81972e+03,0.66210e+03, &
        & 0.74501e+03,0.88462e+03,0.10244e+04,0.11652e+04 /)
      kao(:, 2, 9,11) = (/ &
        & 0.12743e+04,0.11193e+04,0.96288e+03,0.80865e+03,0.65325e+03, &
        & 0.74437e+03,0.88360e+03,0.10230e+04,0.11629e+04 /)
      kao(:, 3, 9,11) = (/ &
        & 0.12573e+04,0.11051e+04,0.95155e+03,0.79729e+03,0.64451e+03, &
        & 0.74294e+03,0.88237e+03,0.10218e+04,0.11610e+04 /)
      kao(:, 4, 9,11) = (/ &
        & 0.12441e+04,0.10920e+04,0.94089e+03,0.78911e+03,0.63797e+03, &
        & 0.74148e+03,0.88091e+03,0.10202e+04,0.11593e+04 /)
      kao(:, 5, 9,11) = (/ &
        & 0.12297e+04,0.10813e+04,0.93127e+03,0.78127e+03,0.63265e+03, &
        & 0.74003e+03,0.87926e+03,0.10184e+04,0.11573e+04 /)
      kao(:, 1,10,11) = (/ &
        & 0.12530e+04,0.11001e+04,0.94821e+03,0.79486e+03,0.64277e+03, &
        & 0.74454e+03,0.88447e+03,0.10249e+04,0.11664e+04 /)
      kao(:, 2,10,11) = (/ &
        & 0.12387e+04,0.10865e+04,0.93685e+03,0.78643e+03,0.63425e+03, &
        & 0.74423e+03,0.88371e+03,0.10234e+04,0.11637e+04 /)
      kao(:, 3,10,11) = (/ &
        & 0.12243e+04,0.10744e+04,0.92585e+03,0.77676e+03,0.62740e+03, &
        & 0.74307e+03,0.88260e+03,0.10221e+04,0.11620e+04 /)
      kao(:, 4,10,11) = (/ &
        & 0.12107e+04,0.10640e+04,0.91623e+03,0.76957e+03,0.62235e+03, &
        & 0.74168e+03,0.88129e+03,0.10208e+04,0.11602e+04 /)
      kao(:, 5,10,11) = (/ &
        & 0.12010e+04,0.10536e+04,0.90891e+03,0.76248e+03,0.61761e+03, &
        & 0.74025e+03,0.87965e+03,0.10191e+04,0.11583e+04 /)
      kao(:, 1,11,11) = (/ &
        & 0.12140e+04,0.10672e+04,0.91852e+03,0.77048e+03,0.62320e+03, &
        & 0.74401e+03,0.88413e+03,0.10249e+04,0.11664e+04 /)
      kao(:, 2,11,11) = (/ &
        & 0.12007e+04,0.10549e+04,0.90904e+03,0.76333e+03,0.61635e+03, &
        & 0.74367e+03,0.88337e+03,0.10233e+04,0.11639e+04 /)
      kao(:, 3,11,11) = (/ &
        & 0.11891e+04,0.10458e+04,0.90055e+03,0.75543e+03,0.61123e+03, &
        & 0.74262e+03,0.88229e+03,0.10219e+04,0.11620e+04 /)
      kao(:, 4,11,11) = (/ &
        & 0.11794e+04,0.10371e+04,0.89190e+03,0.74912e+03,0.60572e+03, &
        & 0.74128e+03,0.88110e+03,0.10207e+04,0.11602e+04 /)
      kao(:, 5,11,11) = (/ &
        & 0.11697e+04,0.10285e+04,0.88631e+03,0.74374e+03,0.60062e+03, &
        & 0.73987e+03,0.87958e+03,0.10191e+04,0.11583e+04 /)
      kao(:, 1,12,11) = (/ &
        & 0.11829e+04,0.10373e+04,0.89433e+03,0.75107e+03,0.60775e+03, &
        & 0.74357e+03,0.88385e+03,0.10247e+04,0.11664e+04 /)
      kao(:, 2,12,11) = (/ &
        & 0.11707e+04,0.10276e+04,0.88712e+03,0.74426e+03,0.60163e+03, &
        & 0.74327e+03,0.88309e+03,0.10231e+04,0.11639e+04 /)
      kao(:, 3,12,11) = (/ &
        & 0.11629e+04,0.10211e+04,0.88018e+03,0.73831e+03,0.60184e+03, &
        & 0.74224e+03,0.88203e+03,0.10219e+04,0.11620e+04 /)
      kao(:, 4,12,11) = (/ &
        & 0.11538e+04,0.10126e+04,0.87253e+03,0.73377e+03,0.60080e+03, &
        & 0.74101e+03,0.88067e+03,0.10205e+04,0.11602e+04 /)
      kao(:, 5,12,11) = (/ &
        & 0.11449e+04,0.10062e+04,0.86764e+03,0.72842e+03,0.59975e+03, &
        & 0.73955e+03,0.87926e+03,0.10190e+04,0.11583e+04 /)
      kao(:, 1,13,11) = (/ &
        & 0.11561e+04,0.10152e+04,0.87509e+03,0.73383e+03,0.60253e+03, &
        & 0.74321e+03,0.88362e+03,0.10246e+04,0.11664e+04 /)
      kao(:, 2,13,11) = (/ &
        & 0.11468e+04,0.10069e+04,0.86783e+03,0.72921e+03,0.60211e+03, &
        & 0.74294e+03,0.88286e+03,0.10230e+04,0.11639e+04 /)
      kao(:, 3,13,11) = (/ &
        & 0.11390e+04,0.10001e+04,0.86301e+03,0.72323e+03,0.60140e+03, &
        & 0.74194e+03,0.88181e+03,0.10218e+04,0.11621e+04 /)
      kao(:, 4,13,11) = (/ &
        & 0.11313e+04,0.99361e+03,0.85706e+03,0.72032e+03,0.60042e+03, &
        & 0.74065e+03,0.88048e+03,0.10204e+04,0.11602e+04 /)
      kao(:, 5,13,11) = (/ &
        & 0.11266e+04,0.99042e+03,0.85257e+03,0.71548e+03,0.59931e+03, &
        & 0.73930e+03,0.87908e+03,0.10187e+04,0.11583e+04 /)
      kao(:, 1, 1,12) = (/ &
        & 0.19596e+04,0.17200e+04,0.14802e+04,0.12370e+04,0.99641e+03, &
        & 0.75556e+03,0.88658e+03,0.10236e+04,0.11622e+04 /)
      kao(:, 2, 1,12) = (/ &
        & 0.19107e+04,0.16797e+04,0.14463e+04,0.12083e+04,0.97440e+03, &
        & 0.74935e+03,0.88455e+03,0.10223e+04,0.11611e+04 /)
      kao(:, 3, 1,12) = (/ &
        & 0.18687e+04,0.16368e+04,0.14091e+04,0.11809e+04,0.95100e+03, &
        & 0.74626e+03,0.88278e+03,0.10214e+04,0.11600e+04 /)
      kao(:, 4, 1,12) = (/ &
        & 0.18274e+04,0.15998e+04,0.13805e+04,0.11544e+04,0.92955e+03, &
        & 0.74432e+03,0.88029e+03,0.10193e+04,0.11572e+04 /)
      kao(:, 5, 1,12) = (/ &
        & 0.17908e+04,0.15685e+04,0.13492e+04,0.11303e+04,0.91228e+03, &
        & 0.74183e+03,0.87814e+03,0.10165e+04,0.11551e+04 /)
      kao(:, 1, 2,12) = (/ &
        & 0.18091e+04,0.15890e+04,0.13701e+04,0.11447e+04,0.92240e+03, &
        & 0.75031e+03,0.88580e+03,0.10236e+04,0.11628e+04 /)
      kao(:, 2, 2,12) = (/ &
        & 0.17702e+04,0.15507e+04,0.13346e+04,0.11179e+04,0.90072e+03, &
        & 0.74790e+03,0.88384e+03,0.10222e+04,0.11616e+04 /)
      kao(:, 3, 2,12) = (/ &
        & 0.17282e+04,0.15159e+04,0.13066e+04,0.10967e+04,0.88274e+03, &
        & 0.74530e+03,0.88241e+03,0.10213e+04,0.11606e+04 /)
      kao(:, 4, 2,12) = (/ &
        & 0.16964e+04,0.14887e+04,0.12816e+04,0.10711e+04,0.86387e+03, &
        & 0.74308e+03,0.88064e+03,0.10199e+04,0.11593e+04 /)
      kao(:, 5, 2,12) = (/ &
        & 0.16664e+04,0.14634e+04,0.12570e+04,0.10541e+04,0.84878e+03, &
        & 0.74105e+03,0.87802e+03,0.10170e+04,0.11559e+04 /)
      kao(:, 1, 3,12) = (/ &
        & 0.16969e+04,0.14893e+04,0.12806e+04,0.10686e+04,0.86200e+03, &
        & 0.74953e+03,0.88586e+03,0.10239e+04,0.11637e+04 /)
      kao(:, 2, 3,12) = (/ &
        & 0.16530e+04,0.14535e+04,0.12505e+04,0.10502e+04,0.84485e+03, &
        & 0.74734e+03,0.88380e+03,0.10224e+04,0.11623e+04 /)
      kao(:, 3, 3,12) = (/ &
        & 0.16258e+04,0.14316e+04,0.12308e+04,0.10274e+04,0.82737e+03, &
        & 0.74498e+03,0.88220e+03,0.10214e+04,0.11612e+04 /)
      kao(:, 4, 3,12) = (/ &
        & 0.15947e+04,0.13987e+04,0.12036e+04,0.10100e+04,0.81398e+03, &
        & 0.74250e+03,0.88073e+03,0.10203e+04,0.11601e+04 /)
      kao(:, 5, 3,12) = (/ &
        & 0.15659e+04,0.13745e+04,0.11827e+04,0.99357e+03,0.79945e+03, &
        & 0.74072e+03,0.87844e+03,0.10192e+04,0.11574e+04 /)
      kao(:, 1, 4,12) = (/ &
        & 0.15993e+04,0.14029e+04,0.12034e+04,0.10105e+04,0.81494e+03, &
        & 0.74898e+03,0.88604e+03,0.10246e+04,0.11648e+04 /)
      kao(:, 2, 4,12) = (/ &
        & 0.15603e+04,0.13717e+04,0.11803e+04,0.99158e+03,0.79797e+03, &
        & 0.74702e+03,0.88413e+03,0.10230e+04,0.11631e+04 /)
      kao(:, 3, 4,12) = (/ &
        & 0.15363e+04,0.13460e+04,0.11581e+04,0.97158e+03,0.78286e+03, &
        & 0.74488e+03,0.88249e+03,0.10215e+04,0.11618e+04 /)
      kao(:, 4, 4,12) = (/ &
        & 0.15069e+04,0.13248e+04,0.11397e+04,0.95515e+03,0.77185e+03, &
        & 0.74259e+03,0.88086e+03,0.10207e+04,0.11608e+04 /)
      kao(:, 5, 4,12) = (/ &
        & 0.14842e+04,0.13030e+04,0.11201e+04,0.94205e+03,0.75928e+03, &
        & 0.74072e+03,0.87912e+03,0.10193e+04,0.11593e+04 /)
      kao(:, 1, 5,12) = (/ &
        & 0.15161e+04,0.13293e+04,0.11434e+04,0.96071e+03,0.77366e+03, &
        & 0.74856e+03,0.88634e+03,0.10256e+04,0.11660e+04 /)
      kao(:, 2, 5,12) = (/ &
        & 0.14862e+04,0.13039e+04,0.11202e+04,0.93927e+03,0.75808e+03, &
        & 0.74678e+03,0.88432e+03,0.10237e+04,0.11641e+04 /)
      kao(:, 3, 5,12) = (/ &
        & 0.14569e+04,0.12812e+04,0.11040e+04,0.92477e+03,0.74608e+03, &
        & 0.74483e+03,0.88267e+03,0.10221e+04,0.11626e+04 /)
      kao(:, 4, 5,12) = (/ &
        & 0.14370e+04,0.12601e+04,0.10866e+04,0.91322e+03,0.73546e+03, &
        & 0.74282e+03,0.88106e+03,0.10210e+04,0.11614e+04 /)
      kao(:, 5, 5,12) = (/ &
        & 0.14157e+04,0.12432e+04,0.10692e+04,0.89766e+03,0.72371e+03, &
        & 0.74075e+03,0.87977e+03,0.10201e+04,0.11604e+04 /)
      kao(:, 1, 6,12) = (/ &
        & 0.14446e+04,0.12668e+04,0.10902e+04,0.91458e+03,0.73853e+03, &
        & 0.74800e+03,0.88683e+03,0.10267e+04,0.11674e+04 /)
      kao(:, 2, 6,12) = (/ &
        & 0.14180e+04,0.12442e+04,0.10729e+04,0.90054e+03,0.72712e+03, &
        & 0.74664e+03,0.88490e+03,0.10243e+04,0.11653e+04 /)
      kao(:, 3, 6,12) = (/ &
        & 0.13970e+04,0.12338e+04,0.10562e+04,0.88644e+03,0.71466e+03, &
        & 0.74490e+03,0.88299e+03,0.10228e+04,0.11635e+04 /)
      kao(:, 4, 6,12) = (/ &
        & 0.13772e+04,0.12092e+04,0.10403e+04,0.87191e+03,0.70566e+03, &
        & 0.74297e+03,0.88145e+03,0.10214e+04,0.11622e+04 /)
      kao(:, 5, 6,12) = (/ &
        & 0.13536e+04,0.11933e+04,0.10279e+04,0.85985e+03,0.69532e+03, &
        & 0.74091e+03,0.88002e+03,0.10207e+04,0.11611e+04 /)
      kao(:, 1, 7,12) = (/ &
        & 0.13872e+04,0.12173e+04,0.10473e+04,0.87779e+03,0.70929e+03, &
        & 0.74753e+03,0.88739e+03,0.10279e+04,0.11686e+04 /)
      kao(:, 2, 7,12) = (/ &
        & 0.13614e+04,0.11960e+04,0.10302e+04,0.86342e+03,0.69779e+03, &
        & 0.74649e+03,0.88535e+03,0.10254e+04,0.11666e+04 /)
      kao(:, 3, 7,12) = (/ &
        & 0.13423e+04,0.11779e+04,0.10152e+04,0.85120e+03,0.68669e+03, &
        & 0.74500e+03,0.88364e+03,0.10236e+04,0.11646e+04 /)
      kao(:, 4, 7,12) = (/ &
        & 0.13222e+04,0.11614e+04,0.10027e+04,0.84138e+03,0.67980e+03, &
        & 0.74324e+03,0.88194e+03,0.10219e+04,0.11628e+04 /)
      kao(:, 5, 7,12) = (/ &
        & 0.13077e+04,0.11487e+04,0.98870e+03,0.82923e+03,0.67117e+03, &
        & 0.74131e+03,0.88052e+03,0.10200e+04,0.11617e+04 /)
      kao(:, 1, 8,12) = (/ &
        & 0.13318e+04,0.11751e+04,0.10116e+04,0.84760e+03,0.68552e+03, &
        & 0.74755e+03,0.88764e+03,0.10284e+04,0.11697e+04 /)
      kao(:, 2, 8,12) = (/ &
        & 0.13123e+04,0.11533e+04,0.99316e+03,0.83364e+03,0.67452e+03, &
        & 0.74634e+03,0.88623e+03,0.10267e+04,0.11679e+04 /)
      kao(:, 3, 8,12) = (/ &
        & 0.12963e+04,0.11395e+04,0.98036e+03,0.82206e+03,0.66378e+03, &
        & 0.74528e+03,0.88422e+03,0.10245e+04,0.11657e+04 /)
      kao(:, 4, 8,12) = (/ &
        & 0.12799e+04,0.11235e+04,0.96838e+03,0.81175e+03,0.65688e+03, &
        & 0.74350e+03,0.88249e+03,0.10227e+04,0.11639e+04 /)
      kao(:, 5, 8,12) = (/ &
        & 0.12649e+04,0.11128e+04,0.95762e+03,0.80323e+03,0.64917e+03, &
        & 0.74172e+03,0.88089e+03,0.10213e+04,0.11624e+04 /)
      kao(:, 1, 9,12) = (/ &
        & 0.12892e+04,0.11353e+04,0.97529e+03,0.81997e+03,0.66439e+03, &
        & 0.74689e+03,0.88774e+03,0.10288e+04,0.11703e+04 /)
      kao(:, 2, 9,12) = (/ &
        & 0.12710e+04,0.11179e+04,0.96230e+03,0.80757e+03,0.65174e+03, &
        & 0.74606e+03,0.88671e+03,0.10277e+04,0.11691e+04 /)
      kao(:, 3, 9,12) = (/ &
        & 0.12556e+04,0.11026e+04,0.95506e+03,0.79904e+03,0.64512e+03, &
        & 0.74525e+03,0.88489e+03,0.10254e+04,0.11669e+04 /)
      kao(:, 4, 9,12) = (/ &
        & 0.12434e+04,0.10930e+04,0.94625e+03,0.79326e+03,0.63956e+03, &
        & 0.74375e+03,0.88308e+03,0.10236e+04,0.11649e+04 /)
      kao(:, 5, 9,12) = (/ &
        & 0.12362e+04,0.10807e+04,0.93519e+03,0.78318e+03,0.63176e+03, &
        & 0.74222e+03,0.88144e+03,0.10218e+04,0.11632e+04 /)
      kao(:, 1,10,12) = (/ &
        & 0.12560e+04,0.11008e+04,0.94819e+03,0.79713e+03,0.64289e+03, &
        & 0.74662e+03,0.88790e+03,0.10293e+04,0.11710e+04 /)
      kao(:, 2,10,12) = (/ &
        & 0.12370e+04,0.10868e+04,0.93614e+03,0.78750e+03,0.63591e+03, &
        & 0.74589e+03,0.88689e+03,0.10281e+04,0.11697e+04 /)
      kao(:, 3,10,12) = (/ &
        & 0.12228e+04,0.10745e+04,0.92565e+03,0.77586e+03,0.63013e+03, &
        & 0.74525e+03,0.88546e+03,0.10265e+04,0.11680e+04 /)
      kao(:, 4,10,12) = (/ &
        & 0.12130e+04,0.10629e+04,0.91805e+03,0.77218e+03,0.62214e+03, &
        & 0.74398e+03,0.88360e+03,0.10243e+04,0.11659e+04 /)
      kao(:, 5,10,12) = (/ &
        & 0.11990e+04,0.10561e+04,0.90990e+03,0.76234e+03,0.61782e+03, &
        & 0.74238e+03,0.88192e+03,0.10225e+04,0.11640e+04 /)
      kao(:, 1,11,12) = (/ &
        & 0.12160e+04,0.10660e+04,0.91756e+03,0.77092e+03,0.62410e+03, &
        & 0.74614e+03,0.88758e+03,0.10288e+04,0.11712e+04 /)
      kao(:, 2,11,12) = (/ &
        & 0.12001e+04,0.10573e+04,0.90897e+03,0.76187e+03,0.61778e+03, &
        & 0.74563e+03,0.88659e+03,0.10280e+04,0.11697e+04 /)
      kao(:, 3,11,12) = (/ &
        & 0.11883e+04,0.10436e+04,0.89901e+03,0.75711e+03,0.61087e+03, &
        & 0.74468e+03,0.88519e+03,0.10264e+04,0.11680e+04 /)
      kao(:, 4,11,12) = (/ &
        & 0.11791e+04,0.10338e+04,0.89462e+03,0.74974e+03,0.60740e+03, &
        & 0.74372e+03,0.88322e+03,0.10242e+04,0.11659e+04 /)
      kao(:, 5,11,12) = (/ &
        & 0.11736e+04,0.10284e+04,0.88610e+03,0.74386e+03,0.60256e+03, &
        & 0.74204e+03,0.88156e+03,0.10223e+04,0.11640e+04 /)
      kao(:, 1,12,12) = (/ &
        & 0.11783e+04,0.10408e+04,0.89462e+03,0.75034e+03,0.60838e+03, &
        & 0.74575e+03,0.88732e+03,0.10288e+04,0.11710e+04 /)
      kao(:, 2,12,12) = (/ &
        & 0.11693e+04,0.10333e+04,0.88486e+03,0.74467e+03,0.60420e+03, &
        & 0.74514e+03,0.88635e+03,0.10279e+04,0.11697e+04 /)
      kao(:, 3,12,12) = (/ &
        & 0.11597e+04,0.10197e+04,0.87845e+03,0.73901e+03,0.60371e+03, &
        & 0.74440e+03,0.88495e+03,0.10263e+04,0.11680e+04 /)
      kao(:, 4,12,12) = (/ &
        & 0.11554e+04,0.10154e+04,0.87390e+03,0.73209e+03,0.60310e+03, &
        & 0.74343e+03,0.88312e+03,0.10241e+04,0.11659e+04 /)
      kao(:, 5,12,12) = (/ &
        & 0.11463e+04,0.10081e+04,0.86768e+03,0.73113e+03,0.60226e+03, &
        & 0.74178e+03,0.88148e+03,0.10222e+04,0.11640e+04 /)
      kao(:, 1,13,12) = (/ &
        & 0.11576e+04,0.10172e+04,0.87697e+03,0.73496e+03,0.60442e+03, &
        & 0.74542e+03,0.88710e+03,0.10287e+04,0.11710e+04 /)
      kao(:, 2,13,12) = (/ &
        & 0.11489e+04,0.10121e+04,0.86787e+03,0.73038e+03,0.60369e+03, &
        & 0.74483e+03,0.88615e+03,0.10278e+04,0.11697e+04 /)
      kao(:, 3,13,12) = (/ &
        & 0.11408e+04,0.10003e+04,0.86069e+03,0.72468e+03,0.60332e+03, &
        & 0.74398e+03,0.88477e+03,0.10262e+04,0.11679e+04 /)
      kao(:, 4,13,12) = (/ &
        & 0.11353e+04,0.99812e+03,0.85805e+03,0.72010e+03,0.60276e+03, &
        & 0.74301e+03,0.88294e+03,0.10240e+04,0.11659e+04 /)
      kao(:, 5,13,12) = (/ &
        & 0.11276e+04,0.99093e+03,0.85424e+03,0.71851e+03,0.60186e+03, &
        & 0.74137e+03,0.88131e+03,0.10223e+04,0.11640e+04 /)
      kao(:, 1, 1,13) = (/ &
        & 0.19698e+04,0.17183e+04,0.14812e+04,0.12476e+04,0.10057e+04, &
        & 0.76142e+03,0.89076e+03,0.10305e+04,0.11701e+04 /)
      kao(:, 2, 1,13) = (/ &
        & 0.19138e+04,0.16790e+04,0.14471e+04,0.12079e+04,0.97024e+03, &
        & 0.74958e+03,0.88854e+03,0.10281e+04,0.11676e+04 /)
      kao(:, 3, 1,13) = (/ &
        & 0.18656e+04,0.16362e+04,0.14072e+04,0.11764e+04,0.95368e+03, &
        & 0.74756e+03,0.88578e+03,0.10247e+04,0.11642e+04 /)
      kao(:, 4, 1,13) = (/ &
        & 0.18274e+04,0.16076e+04,0.13744e+04,0.11522e+04,0.93101e+03, &
        & 0.74489e+03,0.88368e+03,0.10224e+04,0.11624e+04 /)
      kao(:, 5, 1,13) = (/ &
        & 0.18123e+04,0.15711e+04,0.13539e+04,0.11391e+04,0.91271e+03, &
        & 0.74309e+03,0.88194e+03,0.10210e+04,0.11601e+04 /)
      kao(:, 1, 2,13) = (/ &
        & 0.18136e+04,0.16074e+04,0.13682e+04,0.11455e+04,0.92152e+03, &
        & 0.75090e+03,0.89044e+03,0.10309e+04,0.11711e+04 /)
      kao(:, 2, 2,13) = (/ &
        & 0.17663e+04,0.15639e+04,0.13412e+04,0.11338e+04,0.90565e+03, &
        & 0.74892e+03,0.88842e+03,0.10286e+04,0.11690e+04 /)
      kao(:, 3, 2,13) = (/ &
        & 0.17473e+04,0.15168e+04,0.13179e+04,0.10933e+04,0.88564e+03, &
        & 0.74657e+03,0.88587e+03,0.10277e+04,0.11659e+04 /)
      kao(:, 4, 2,13) = (/ &
        & 0.16935e+04,0.14940e+04,0.12866e+04,0.10771e+04,0.86513e+03, &
        & 0.74388e+03,0.88292e+03,0.10226e+04,0.11621e+04 /)
      kao(:, 5, 2,13) = (/ &
        & 0.16796e+04,0.14587e+04,0.12610e+04,0.10625e+04,0.85051e+03, &
        & 0.74222e+03,0.88187e+03,0.10215e+04,0.11614e+04 /)
      kao(:, 1, 3,13) = (/ &
        & 0.16915e+04,0.14853e+04,0.12759e+04,0.10742e+04,0.87078e+03, &
        & 0.75040e+03,0.89056e+03,0.10314e+04,0.11723e+04 /)
      kao(:, 2, 3,13) = (/ &
        & 0.16685e+04,0.14695e+04,0.12569e+04,0.10522e+04,0.84369e+03, &
        & 0.74849e+03,0.88875e+03,0.10295e+04,0.11702e+04 /)
      kao(:, 3, 3,13) = (/ &
        & 0.16315e+04,0.14234e+04,0.12207e+04,0.10278e+04,0.83542e+03, &
        & 0.74665e+03,0.88665e+03,0.10272e+04,0.11677e+04 /)
      kao(:, 4, 3,13) = (/ &
        & 0.15936e+04,0.13973e+04,0.11983e+04,0.10068e+04,0.81253e+03, &
        & 0.74392e+03,0.88383e+03,0.10241e+04,0.11643e+04 /)
      kao(:, 5, 3,13) = (/ &
        & 0.15704e+04,0.13749e+04,0.11794e+04,0.99081e+03,0.79887e+03, &
        & 0.74214e+03,0.88216e+03,0.10204e+04,0.11625e+04 /)
      kao(:, 1, 4,13) = (/ &
        & 0.16005e+04,0.14146e+04,0.12141e+04,0.10096e+04,0.81830e+03, &
        & 0.74981e+03,0.89073e+03,0.10323e+04,0.11736e+04 /)
      kao(:, 2, 4,13) = (/ &
        & 0.15697e+04,0.13709e+04,0.11792e+04,0.98706e+03,0.80274e+03, &
        & 0.74843e+03,0.88917e+03,0.10304e+04,0.11716e+04 /)
      kao(:, 3, 4,13) = (/ &
        & 0.15342e+04,0.13528e+04,0.11633e+04,0.97494e+03,0.78298e+03, &
        & 0.74655e+03,0.88714e+03,0.10283e+04,0.11694e+04 /)
      kao(:, 4, 4,13) = (/ &
        & 0.15079e+04,0.13273e+04,0.11368e+04,0.95326e+03,0.76898e+03, &
        & 0.74477e+03,0.88522e+03,0.10258e+04,0.11666e+04 /)
      kao(:, 5, 4,13) = (/ &
        & 0.14904e+04,0.13050e+04,0.11274e+04,0.94133e+03,0.75918e+03, &
        & 0.74185e+03,0.88236e+03,0.10229e+04,0.11634e+04 /)
      kao(:, 1, 5,13) = (/ &
        & 0.15223e+04,0.13292e+04,0.11458e+04,0.96632e+03,0.77253e+03, &
        & 0.74931e+03,0.89080e+03,0.10327e+04,0.11744e+04 /)
      kao(:, 2, 5,13) = (/ &
        & 0.14887e+04,0.13100e+04,0.11308e+04,0.95564e+03,0.76318e+03, &
        & 0.74814e+03,0.88953e+03,0.10311e+04,0.11728e+04 /)
      kao(:, 3, 5,13) = (/ &
        & 0.14666e+04,0.12805e+04,0.10990e+04,0.92585e+03,0.74527e+03, &
        & 0.74662e+03,0.88788e+03,0.10293e+04,0.11708e+04 /)
      kao(:, 4, 5,13) = (/ &
        & 0.14380e+04,0.12615e+04,0.10805e+04,0.91192e+03,0.73306e+03, &
        & 0.74471e+03,0.88594e+03,0.10272e+04,0.11684e+04 /)
      kao(:, 5, 5,13) = (/ &
        & 0.14117e+04,0.12389e+04,0.10707e+04,0.89863e+03,0.72872e+03, &
        & 0.74254e+03,0.88356e+03,0.10243e+04,0.11652e+04 /)
      kao(:, 1, 6,13) = (/ &
        & 0.14428e+04,0.12661e+04,0.10990e+04,0.91605e+03,0.74645e+03, &
        & 0.74914e+03,0.89068e+03,0.10327e+04,0.11747e+04 /)
      kao(:, 2, 6,13) = (/ &
        & 0.14277e+04,0.12454e+04,0.10670e+04,0.90364e+03,0.72758e+03, &
        & 0.74802e+03,0.88983e+03,0.10318e+04,0.11738e+04 /)
      kao(:, 3, 6,13) = (/ &
        & 0.14072e+04,0.12244e+04,0.10539e+04,0.88576e+03,0.71342e+03, &
        & 0.74674e+03,0.88844e+03,0.10303e+04,0.11723e+04 /)
      kao(:, 4, 6,13) = (/ &
        & 0.13764e+04,0.12101e+04,0.10371e+04,0.87173e+03,0.70565e+03, &
        & 0.74519e+03,0.88672e+03,0.10284e+04,0.11700e+04 /)
      kao(:, 5, 6,13) = (/ &
        & 0.13559e+04,0.11928e+04,0.10275e+04,0.87202e+03,0.69916e+03, &
        & 0.74337e+03,0.88468e+03,0.10257e+04,0.11677e+04 /)
      kao(:, 1, 7,13) = (/ &
        & 0.13816e+04,0.12181e+04,0.10498e+04,0.87727e+03,0.70862e+03, &
        & 0.74879e+03,0.89032e+03,0.10324e+04,0.11748e+04 /)
      kao(:, 2, 7,13) = (/ &
        & 0.13746e+04,0.12007e+04,0.10368e+04,0.86700e+03,0.69742e+03, &
        & 0.74791e+03,0.88998e+03,0.10322e+04,0.11745e+04 /)
      kao(:, 3, 7,13) = (/ &
        & 0.13471e+04,0.11822e+04,0.10118e+04,0.85187e+03,0.69076e+03, &
        & 0.74684e+03,0.88891e+03,0.10311e+04,0.11732e+04 /)
      kao(:, 4, 7,13) = (/ &
        & 0.13306e+04,0.11625e+04,0.10055e+04,0.83687e+03,0.67946e+03, &
        & 0.74564e+03,0.88741e+03,0.10294e+04,0.11714e+04 /)
      kao(:, 5, 7,13) = (/ &
        & 0.13072e+04,0.11462e+04,0.98997e+03,0.82975e+03,0.67148e+03, &
        & 0.74390e+03,0.88544e+03,0.10275e+04,0.11691e+04 /)
      kao(:, 1, 8,13) = (/ &
        & 0.13342e+04,0.11738e+04,0.10072e+04,0.84777e+03,0.68336e+03, &
        & 0.74810e+03,0.89032e+03,0.10328e+04,0.11753e+04 /)
      kao(:, 2, 8,13) = (/ &
        & 0.13170e+04,0.11565e+04,0.99551e+03,0.83812e+03,0.67873e+03, &
        & 0.74767e+03,0.88984e+03,0.10325e+04,0.11747e+04 /)
      kao(:, 3, 8,13) = (/ &
        & 0.12961e+04,0.11348e+04,0.98531e+03,0.82142e+03,0.66767e+03, &
        & 0.74660e+03,0.88923e+03,0.10317e+04,0.11741e+04 /)
      kao(:, 4, 8,13) = (/ &
        & 0.12863e+04,0.11324e+04,0.96704e+03,0.81553e+03,0.65703e+03, &
        & 0.74590e+03,0.88815e+03,0.10305e+04,0.11725e+04 /)
      kao(:, 5, 8,13) = (/ &
        & 0.12689e+04,0.11113e+04,0.96142e+03,0.81188e+03,0.65150e+03, &
        & 0.74435e+03,0.88637e+03,0.10284e+04,0.11705e+04 /)
      kao(:, 1, 9,13) = (/ &
        & 0.12929e+04,0.11420e+04,0.97941e+03,0.82358e+03,0.66259e+03, &
        & 0.74862e+03,0.89046e+03,0.10332e+04,0.11761e+04 /)
      kao(:, 2, 9,13) = (/ &
        & 0.12739e+04,0.11222e+04,0.96918e+03,0.81141e+03,0.65436e+03, &
        & 0.74747e+03,0.88962e+03,0.10323e+04,0.11749e+04 /)
      kao(:, 3, 9,13) = (/ &
        & 0.12674e+04,0.11070e+04,0.94554e+03,0.79811e+03,0.64989e+03, &
        & 0.74671e+03,0.88937e+03,0.10320e+04,0.11746e+04 /)
      kao(:, 4, 9,13) = (/ &
        & 0.12536e+04,0.10974e+04,0.93180e+03,0.78881e+03,0.64048e+03, &
        & 0.74596e+03,0.88846e+03,0.10310e+04,0.11735e+04 /)
      kao(:, 5, 9,13) = (/ &
        & 0.12304e+04,0.10931e+04,0.92897e+03,0.78158e+03,0.63657e+03, &
        & 0.74461e+03,0.88706e+03,0.10294e+04,0.11717e+04 /)
      kao(:, 1,10,13) = (/ &
        & 0.12516e+04,0.11039e+04,0.96641e+03,0.80204e+03,0.64728e+03, &
        & 0.74871e+03,0.89043e+03,0.10331e+04,0.11761e+04 /)
      kao(:, 2,10,13) = (/ &
        & 0.12445e+04,0.10951e+04,0.94205e+03,0.78296e+03,0.63684e+03, &
        & 0.74738e+03,0.88974e+03,0.10326e+04,0.11754e+04 /)
      kao(:, 3,10,13) = (/ &
        & 0.12212e+04,0.10830e+04,0.92907e+03,0.78344e+03,0.62583e+03, &
        & 0.74649e+03,0.88924e+03,0.10320e+04,0.11747e+04 /)
      kao(:, 4,10,13) = (/ &
        & 0.12116e+04,0.10675e+04,0.91424e+03,0.76668e+03,0.62374e+03, &
        & 0.74589e+03,0.88889e+03,0.10314e+04,0.11741e+04 /)
      kao(:, 5,10,13) = (/ &
        & 0.12052e+04,0.10532e+04,0.90488e+03,0.76246e+03,0.61399e+03, &
        & 0.74500e+03,0.88754e+03,0.10301e+04,0.11727e+04 /)
      kao(:, 1,11,13) = (/ &
        & 0.12119e+04,0.10670e+04,0.92549e+03,0.77292e+03,0.62469e+03, &
        & 0.74822e+03,0.89015e+03,0.10331e+04,0.11759e+04 /)
      kao(:, 2,11,13) = (/ &
        & 0.12040e+04,0.10529e+04,0.90947e+03,0.76631e+03,0.61756e+03, &
        & 0.74680e+03,0.88950e+03,0.10325e+04,0.11754e+04 /)
      kao(:, 3,11,13) = (/ &
        & 0.11932e+04,0.10470e+04,0.90374e+03,0.75316e+03,0.61137e+03, &
        & 0.74625e+03,0.88901e+03,0.10319e+04,0.11747e+04 /)
      kao(:, 4,11,13) = (/ &
        & 0.11901e+04,0.10395e+04,0.89205e+03,0.75483e+03,0.60707e+03, &
        & 0.74529e+03,0.88868e+03,0.10313e+04,0.11742e+04 /)
      kao(:, 5,11,13) = (/ &
        & 0.11740e+04,0.10262e+04,0.88782e+03,0.74555e+03,0.60321e+03, &
        & 0.74456e+03,0.88735e+03,0.10302e+04,0.11727e+04 /)
      kao(:, 1,12,13) = (/ &
        & 0.11952e+04,0.10387e+04,0.90464e+03,0.75031e+03,0.60579e+03, &
        & 0.74809e+03,0.88993e+03,0.10330e+04,0.11761e+04 /)
      kao(:, 2,12,13) = (/ &
        & 0.11767e+04,0.10280e+04,0.89305e+03,0.74295e+03,0.60520e+03, &
        & 0.74658e+03,0.88930e+03,0.10324e+04,0.11754e+04 /)
      kao(:, 3,12,13) = (/ &
        & 0.11638e+04,0.10252e+04,0.88200e+03,0.74209e+03,0.60448e+03, &
        & 0.74580e+03,0.88883e+03,0.10318e+04,0.11747e+04 /)
      kao(:, 4,12,13) = (/ &
        & 0.11608e+04,0.10182e+04,0.87717e+03,0.73339e+03,0.60384e+03, &
        & 0.74474e+03,0.88834e+03,0.10314e+04,0.11742e+04 /)
      kao(:, 5,12,13) = (/ &
        & 0.11455e+04,0.10085e+04,0.86868e+03,0.72782e+03,0.60261e+03, &
        & 0.74417e+03,0.88752e+03,0.10299e+04,0.11727e+04 /)
      kao(:, 1,13,13) = (/ &
        & 0.11538e+04,0.10104e+04,0.87836e+03,0.74181e+03,0.60545e+03, &
        & 0.74747e+03,0.88975e+03,0.10329e+04,0.11763e+04 /)
      kao(:, 2,13,13) = (/ &
        & 0.11412e+04,0.10013e+04,0.88484e+03,0.73153e+03,0.60489e+03, &
        & 0.74629e+03,0.88914e+03,0.10323e+04,0.11754e+04 /)
      kao(:, 3,13,13) = (/ &
        & 0.11370e+04,0.10022e+04,0.86246e+03,0.73215e+03,0.60419e+03, &
        & 0.74569e+03,0.88867e+03,0.10317e+04,0.11747e+04 /)
      kao(:, 4,13,13) = (/ &
        & 0.11288e+04,0.99109e+03,0.86549e+03,0.72280e+03,0.60356e+03, &
        & 0.74480e+03,0.88820e+03,0.10312e+04,0.11742e+04 /)
      kao(:, 5,13,13) = (/ &
        & 0.11445e+04,0.99099e+03,0.85129e+03,0.71952e+03,0.60234e+03, &
        & 0.74410e+03,0.88705e+03,0.10299e+04,0.11727e+04 /)
      kao(:, 1, 1,14) = (/ &
        & 0.20185e+04,0.18044e+04,0.14758e+04,0.13047e+04,0.10029e+04, &
        & 0.77460e+03,0.89226e+03,0.10322e+04,0.11721e+04 /)
      kao(:, 2, 1,14) = (/ &
        & 0.19173e+04,0.17154e+04,0.14467e+04,0.12101e+04,0.99594e+03, &
        & 0.75026e+03,0.88974e+03,0.10295e+04,0.11713e+04 /)
      kao(:, 3, 1,14) = (/ &
        & 0.19468e+04,0.16851e+04,0.14136e+04,0.12474e+04,0.94959e+03, &
        & 0.74773e+03,0.88696e+03,0.10271e+04,0.11663e+04 /)
      kao(:, 4, 1,14) = (/ &
        & 0.18423e+04,0.16214e+04,0.13991e+04,0.11633e+04,0.94698e+03, &
        & 0.74507e+03,0.88457e+03,0.10239e+04,0.11632e+04 /)
      kao(:, 5, 1,14) = (/ &
        & 0.17538e+04,0.16376e+04,0.13645e+04,0.11303e+04,0.98877e+03, &
        & 0.74430e+03,0.88372e+03,0.10232e+04,0.11626e+04 /)
      kao(:, 1, 2,14) = (/ &
        & 0.18551e+04,0.16163e+04,0.13640e+04,0.12440e+04,0.97095e+03, &
        & 0.75153e+03,0.89202e+03,0.10323e+04,0.11731e+04 /)
      kao(:, 2, 2,14) = (/ &
        & 0.18136e+04,0.16209e+04,0.13887e+04,0.11127e+04,0.90845e+03, &
        & 0.74936e+03,0.88974e+03,0.10301e+04,0.11702e+04 /)
      kao(:, 3, 2,14) = (/ &
        & 0.17918e+04,0.15931e+04,0.13282e+04,0.11266e+04,0.93052e+03, &
        & 0.74732e+03,0.88725e+03,0.10243e+04,0.11672e+04 /)
      kao(:, 4, 2,14) = (/ &
        & 0.17507e+04,0.14791e+04,0.12865e+04,0.10818e+04,0.87901e+03, &
        & 0.74478e+03,0.88467e+03,0.10246e+04,0.11645e+04 /)
      kao(:, 5, 2,14) = (/ &
        & 0.16872e+04,0.14818e+04,0.12871e+04,0.10513e+04,0.88744e+03, &
        & 0.74325e+03,0.88337e+03,0.10230e+04,0.11625e+04 /)
      kao(:, 1, 3,14) = (/ &
        & 0.16919e+04,0.15533e+04,0.13337e+04,0.10831e+04,0.86308e+03, &
        & 0.75085e+03,0.89217e+03,0.10333e+04,0.11744e+04 /)
      kao(:, 2, 3,14) = (/ &
        & 0.17034e+04,0.15495e+04,0.12643e+04,0.11407e+04,0.84365e+03, &
        & 0.74929e+03,0.89025e+03,0.10312e+04,0.11722e+04 /)
      kao(:, 3, 3,14) = (/ &
        & 0.16844e+04,0.14282e+04,0.12585e+04,0.10790e+04,0.84114e+03, &
        & 0.74691e+03,0.88785e+03,0.10286e+04,0.11700e+04 /)
      kao(:, 4, 3,14) = (/ &
        & 0.16791e+04,0.14180e+04,0.12209e+04,0.10441e+04,0.85899e+03, &
        & 0.74519e+03,0.88544e+03,0.10259e+04,0.11667e+04 /)
      kao(:, 5, 3,14) = (/ &
        & 0.16063e+04,0.13774e+04,0.12181e+04,0.10006e+04,0.82020e+03, &
        & 0.74245e+03,0.88287e+03,0.10231e+04,0.11633e+04 /)
      kao(:, 1, 4,14) = (/ &
        & 0.15960e+04,0.13846e+04,0.12078e+04,0.10284e+04,0.81079e+03, &
        & 0.75078e+03,0.89233e+03,0.10336e+04,0.11751e+04 /)
      kao(:, 2, 4,14) = (/ &
        & 0.16237e+04,0.13919e+04,0.11906e+04,0.10115e+04,0.83009e+03, &
        & 0.74909e+03,0.89076e+03,0.10322e+04,0.11737e+04 /)
      kao(:, 3, 4,14) = (/ &
        & 0.16136e+04,0.13698e+04,0.12046e+04,0.98839e+03,0.80997e+03, &
        & 0.74745e+03,0.88871e+03,0.10300e+04,0.11712e+04 /)
      kao(:, 4, 4,14) = (/ &
        & 0.15739e+04,0.13753e+04,0.11394e+04,0.97871e+03,0.77029e+03, &
        & 0.74770e+03,0.88627e+03,0.10279e+04,0.11682e+04 /)
      kao(:, 5, 4,14) = (/ &
        & 0.14863e+04,0.13334e+04,0.11445e+04,0.95775e+03,0.78998e+03, &
        & 0.74317e+03,0.88387e+03,0.10246e+04,0.11653e+04 /)
      kao(:, 1, 5,14) = (/ &
        & 0.15101e+04,0.14006e+04,0.11513e+04,0.96783e+03,0.79581e+03, &
        & 0.75045e+03,0.89239e+03,0.10340e+04,0.11759e+04 /)
      kao(:, 2, 5,14) = (/ &
        & 0.15461e+04,0.13003e+04,0.11685e+04,0.92112e+03,0.77517e+03, &
        & 0.74927e+03,0.89114e+03,0.10330e+04,0.11749e+04 /)
      kao(:, 3, 5,14) = (/ &
        & 0.14676e+04,0.12966e+04,0.11042e+04,0.93875e+03,0.79645e+03, &
        & 0.74772e+03,0.88943e+03,0.10311e+04,0.11729e+04 /)
      kao(:, 4, 5,14) = (/ &
        & 0.14571e+04,0.12955e+04,0.11734e+04,0.89731e+03,0.76986e+03, &
        & 0.74578e+03,0.88723e+03,0.10287e+04,0.11702e+04 /)
      kao(:, 5, 5,14) = (/ &
        & 0.14311e+04,0.13054e+04,0.10738e+04,0.10079e+04,0.72704e+03, &
        & 0.74437e+03,0.88461e+03,0.10260e+04,0.11675e+04 /)
      kao(:, 1, 6,14) = (/ &
        & 0.14715e+04,0.12798e+04,0.11182e+04,0.92160e+03,0.75379e+03, &
        & 0.75023e+03,0.89251e+03,0.10348e+04,0.11771e+04 /)
      kao(:, 2, 6,14) = (/ &
        & 0.14479e+04,0.12414e+04,0.11222e+04,0.91289e+03,0.75013e+03, &
        & 0.74921e+03,0.89141e+03,0.10336e+04,0.11758e+04 /)
      kao(:, 3, 6,14) = (/ &
        & 0.14270e+04,0.12651e+04,0.10793e+04,0.91215e+03,0.74649e+03, &
        & 0.74796e+03,0.89005e+03,0.10321e+04,0.11739e+04 /)
      kao(:, 4, 6,14) = (/ &
        & 0.14058e+04,0.12702e+04,0.11005e+04,0.93809e+03,0.69854e+03, &
        & 0.74632e+03,0.88820e+03,0.10301e+04,0.11720e+04 /)
      kao(:, 5, 6,14) = (/ &
        & 0.14048e+04,0.12100e+04,0.10413e+04,0.84934e+03,0.69794e+03, &
        & 0.74429e+03,0.88588e+03,0.10284e+04,0.11701e+04 /)
      kao(:, 1, 7,14) = (/ &
        & 0.14325e+04,0.12413e+04,0.10595e+04,0.88906e+03,0.71717e+03, &
        & 0.75037e+03,0.89273e+03,0.10353e+04,0.11779e+04 /)
      kao(:, 2, 7,14) = (/ &
        & 0.13620e+04,0.12089e+04,0.10598e+04,0.89550e+03,0.73134e+03, &
        & 0.74911e+03,0.89161e+03,0.10341e+04,0.11766e+04 /)
      kao(:, 3, 7,14) = (/ &
        & 0.13346e+04,0.12111e+04,0.10262e+04,0.84775e+03,0.68161e+03, &
        & 0.74811e+03,0.89050e+03,0.10329e+04,0.11753e+04 /)
      kao(:, 4, 7,14) = (/ &
        & 0.13132e+04,0.11998e+04,0.99757e+03,0.86083e+03,0.70251e+03, &
        & 0.74653e+03,0.88899e+03,0.10312e+04,0.11735e+04 /)
      kao(:, 5, 7,14) = (/ &
        & 0.13232e+04,0.11634e+04,0.10230e+04,0.84353e+03,0.68339e+03, &
        & 0.74500e+03,0.88698e+03,0.10287e+04,0.11709e+04 /)
      kao(:, 1, 8,14) = (/ &
        & 0.13366e+04,0.11630e+04,0.10188e+04,0.86405e+03,0.71800e+03, &
        & 0.75008e+03,0.89285e+03,0.10357e+04,0.11785e+04 /)
      kao(:, 2, 8,14) = (/ &
        & 0.13647e+04,0.11518e+04,0.10110e+04,0.84719e+03,0.67819e+03, &
        & 0.74911e+03,0.89187e+03,0.10343e+04,0.11777e+04 /)
      kao(:, 3, 8,14) = (/ &
        & 0.13128e+04,0.11472e+04,0.99038e+03,0.82656e+03,0.66483e+03, &
        & 0.74815e+03,0.89080e+03,0.10335e+04,0.11761e+04 /)
      kao(:, 4, 8,14) = (/ &
        & 0.12817e+04,0.11127e+04,0.10092e+04,0.82047e+03,0.65442e+03, &
        & 0.74685e+03,0.88933e+03,0.10318e+04,0.11746e+04 /)
      kao(:, 5, 8,14) = (/ &
        & 0.13162e+04,0.11356e+04,0.98305e+03,0.84668e+03,0.66544e+03, &
        & 0.74558e+03,0.88790e+03,0.10302e+04,0.11725e+04 /)
      kao(:, 1, 9,14) = (/ &
        & 0.13174e+04,0.11399e+04,0.97696e+03,0.84117e+03,0.66145e+03, &
        & 0.75011e+03,0.89307e+03,0.10362e+04,0.11789e+04 /)
      kao(:, 2, 9,14) = (/ &
        & 0.13196e+04,0.11310e+04,0.99094e+03,0.80674e+03,0.67265e+03, &
        & 0.74915e+03,0.89213e+03,0.10351e+04,0.11781e+04 /)
      kao(:, 3, 9,14) = (/ &
        & 0.12950e+04,0.10983e+04,0.10229e+04,0.86051e+03,0.66007e+03, &
        & 0.74819e+03,0.89107e+03,0.10339e+04,0.11768e+04 /)
      kao(:, 4, 9,14) = (/ &
        & 0.12605e+04,0.10785e+04,0.10061e+04,0.79531e+03,0.63414e+03, &
        & 0.74728e+03,0.89004e+03,0.10328e+04,0.11756e+04 /)
      kao(:, 5, 9,14) = (/ &
        & 0.12553e+04,0.10628e+04,0.94908e+03,0.82074e+03,0.64983e+03, &
        & 0.74606e+03,0.88866e+03,0.10313e+04,0.11739e+04 /)
      kao(:, 1,10,14) = (/ &
        & 0.13413e+04,0.11632e+04,0.10048e+04,0.80476e+03,0.65189e+03, &
        & 0.75022e+03,0.89354e+03,0.10369e+04,0.11806e+04 /)
      kao(:, 2,10,14) = (/ &
        & 0.12838e+04,0.11017e+04,0.10173e+04,0.85213e+03,0.64367e+03, &
        & 0.74909e+03,0.89223e+03,0.10354e+04,0.11786e+04 /)
      kao(:, 3,10,14) = (/ &
        & 0.12657e+04,0.11229e+04,0.92134e+03,0.80214e+03,0.64195e+03, &
        & 0.74870e+03,0.89159e+03,0.10344e+04,0.11778e+04 /)
      kao(:, 4,10,14) = (/ &
        & 0.12310e+04,0.10594e+04,0.92792e+03,0.78251e+03,0.62401e+03, &
        & 0.74734e+03,0.89003e+03,0.10332e+04,0.11762e+04 /)
      kao(:, 5,10,14) = (/ &
        & 0.12088e+04,0.10663e+04,0.92275e+03,0.77707e+03,0.64354e+03, &
        & 0.74634e+03,0.88914e+03,0.10320e+04,0.11748e+04 /)
      kao(:, 1,11,14) = (/ &
        & 0.12205e+04,0.10982e+04,0.93349e+03,0.79899e+03,0.64961e+03, &
        & 0.74981e+03,0.89329e+03,0.10368e+04,0.11803e+04 /)
      kao(:, 2,11,14) = (/ &
        & 0.12266e+04,0.10977e+04,0.90836e+03,0.76723e+03,0.61851e+03, &
        & 0.74871e+03,0.89199e+03,0.10353e+04,0.11786e+04 /)
      kao(:, 3,11,14) = (/ &
        & 0.11876e+04,0.10750e+04,0.92258e+03,0.76849e+03,0.61349e+03, &
        & 0.74902e+03,0.89163e+03,0.10343e+04,0.11775e+04 /)
      kao(:, 4,11,14) = (/ &
        & 0.12363e+04,0.10327e+04,0.91965e+03,0.74736e+03,0.60206e+03, &
        & 0.74703e+03,0.88982e+03,0.10331e+04,0.11762e+04 /)
      kao(:, 5,11,14) = (/ &
        & 0.11827e+04,0.10266e+04,0.89018e+03,0.76668e+03,0.60360e+03, &
        & 0.74604e+03,0.88895e+03,0.10316e+04,0.11748e+04 /)
      kao(:, 1,12,14) = (/ &
        & 0.11808e+04,0.10792e+04,0.88334e+03,0.76947e+03,0.60663e+03, &
        & 0.74904e+03,0.89307e+03,0.10367e+04,0.11803e+04 /)
      kao(:, 2,12,14) = (/ &
        & 0.12120e+04,0.10402e+04,0.92096e+03,0.78880e+03,0.60609e+03, &
        & 0.74841e+03,0.89179e+03,0.10352e+04,0.11786e+04 /)
      kao(:, 3,12,14) = (/ &
        & 0.12016e+04,0.10899e+04,0.90018e+03,0.73017e+03,0.60527e+03, &
        & 0.75028e+03,0.89119e+03,0.10342e+04,0.11778e+04 /)
      kao(:, 4,12,14) = (/ &
        & 0.11901e+04,0.10101e+04,0.88929e+03,0.75342e+03,0.60426e+03, &
        & 0.74677e+03,0.88991e+03,0.10327e+04,0.11762e+04 /)
      kao(:, 5,12,14) = (/ &
        & 0.12404e+04,0.10285e+04,0.87283e+03,0.77029e+03,0.60316e+03, &
        & 0.74579e+03,0.88852e+03,0.10318e+04,0.11748e+04 /)
      kao(:, 1,13,14) = (/ &
        & 0.11819e+04,0.10465e+04,0.87588e+03,0.72550e+03,0.60649e+03, &
        & 0.74922e+03,0.89289e+03,0.10366e+04,0.11799e+04 /)
      kao(:, 2,13,14) = (/ &
        & 0.11759e+04,0.10245e+04,0.86816e+03,0.77411e+03,0.60565e+03, &
        & 0.74816e+03,0.89163e+03,0.10351e+04,0.11786e+04 /)
      kao(:, 3,13,14) = (/ &
        & 0.11354e+04,0.10124e+04,0.96299e+03,0.72358e+03,0.60486e+03, &
        & 0.74851e+03,0.89156e+03,0.10341e+04,0.11778e+04 /)
      kao(:, 4,13,14) = (/ &
        & 0.11811e+04,0.10736e+04,0.85638e+03,0.74549e+03,0.60366e+03, &
        & 0.74655e+03,0.88977e+03,0.10330e+04,0.11762e+04 /)
      kao(:, 5,13,14) = (/ &
        & 0.11332e+04,0.99282e+03,0.87259e+03,0.77082e+03,0.60280e+03, &
        & 0.74559e+03,0.88865e+03,0.10317e+04,0.11748e+04 /)
      kao(:, 1, 1,15) = (/ &
        & 0.19847e+04,0.16615e+04,0.16299e+04,0.11466e+04,0.10123e+04, &
        & 0.72871e+03,0.89405e+03,0.10334e+04,0.11734e+04 /)
      kao(:, 2, 1,15) = (/ &
        & 0.18867e+04,0.16470e+04,0.14051e+04,0.12848e+04,0.91870e+03, &
        & 0.75104e+03,0.89013e+03,0.10307e+04,0.11650e+04 /)
      kao(:, 3, 1,15) = (/ &
        & 0.17405e+04,0.16240e+04,0.14364e+04,0.10773e+04,0.10008e+04, &
        & 0.74790e+03,0.89023e+03,0.10382e+04,0.11720e+04 /)
      kao(:, 4, 1,15) = (/ &
        & 0.19099e+04,0.16930e+04,0.14454e+04,0.12410e+04,0.95925e+03, &
        & 0.74605e+03,0.88544e+03,0.10248e+04,0.11651e+04 /)
      kao(:, 5, 1,15) = (/ &
        & 0.19738e+04,0.13892e+04,0.14377e+04,0.12129e+04,0.77083e+03, &
        & 0.74496e+03,0.88458e+03,0.10242e+04,0.11638e+04 /)
      kao(:, 1, 2,15) = (/ &
        & 0.18788e+04,0.15414e+04,0.14391e+04,0.94831e+03,0.88384e+03, &
        & 0.75320e+03,0.89399e+03,0.10340e+04,0.11746e+04 /)
      kao(:, 2, 2,15) = (/ &
        & 0.16660e+04,0.14507e+04,0.12145e+04,0.11753e+04,0.91977e+03, &
        & 0.75003e+03,0.89113e+03,0.10308e+04,0.11712e+04 /)
      kao(:, 3, 2,15) = (/ &
        & 0.15746e+04,0.14551e+04,0.13375e+04,0.10698e+04,0.76931e+03, &
        & 0.74657e+03,0.88729e+03,0.10267e+04,0.11695e+04 /)
      kao(:, 4, 2,15) = (/ &
        & 0.16772e+04,0.16415e+04,0.13391e+04,0.10287e+04,0.88207e+03, &
        & 0.74593e+03,0.88530e+03,0.10252e+04,0.11661e+04 /)
      kao(:, 5, 2,15) = (/ &
        & 0.16581e+04,0.15452e+04,0.12479e+04,0.10067e+04,0.83698e+03, &
        & 0.74419e+03,0.88279e+03,0.10234e+04,0.11634e+04 /)
      kao(:, 1, 3,15) = (/ &
        & 0.17888e+04,0.13395e+04,0.12224e+04,0.11479e+04,0.91734e+03, &
        & 0.75291e+03,0.89358e+03,0.10348e+04,0.11761e+04 /)
      kao(:, 2, 3,15) = (/ &
        & 0.16146e+04,0.11805e+04,0.12709e+04,0.85911e+03,0.90210e+03, &
        & 0.75028e+03,0.89203e+03,0.10324e+04,0.11734e+04 /)
      kao(:, 3, 3,15) = (/ &
        & 0.14717e+04,0.15353e+04,0.12224e+04,0.96001e+03,0.77554e+03, &
        & 0.74753e+03,0.88823e+03,0.10297e+04,0.11678e+04 /)
      kao(:, 4, 3,15) = (/ &
        & 0.15479e+04,0.14535e+04,0.11756e+04,0.99609e+03,0.71892e+03, &
        & 0.74634e+03,0.88703e+03,0.10366e+04,0.11684e+04 /)
      kao(:, 5, 3,15) = (/ &
        & 0.15155e+04,0.14515e+04,0.11733e+04,0.10638e+04,0.80510e+03, &
        & 0.74461e+03,0.88580e+03,0.10240e+04,0.11652e+04 /)
      kao(:, 1, 4,15) = (/ &
        & 0.15848e+04,0.14083e+04,0.12006e+04,0.10439e+04,0.81336e+03, &
        & 0.75201e+03,0.89444e+03,0.10363e+04,0.11781e+04 /)
      kao(:, 2, 4,15) = (/ &
        & 0.13736e+04,0.13760e+04,0.12165e+04,0.94289e+03,0.75006e+03, &
        & 0.75167e+03,0.89210e+03,0.10337e+04,0.11753e+04 /)
      kao(:, 3, 4,15) = (/ &
        & 0.14353e+04,0.13702e+04,0.10217e+04,0.10119e+04,0.72585e+03, &
        & 0.74883e+03,0.88956e+03,0.10325e+04,0.11731e+04 /)
      kao(:, 4, 4,15) = (/ &
        & 0.14295e+04,0.12548e+04,0.12198e+04,0.96945e+03,0.84557e+03, &
        & 0.73846e+03,0.88641e+03,0.10258e+04,0.11703e+04 /)
      kao(:, 5, 4,15) = (/ &
        & 0.15742e+04,0.13268e+04,0.10395e+04,0.90301e+03,0.67604e+03, &
        & 0.74473e+03,0.88569e+03,0.10266e+04,0.11676e+04 /)
      kao(:, 1, 5,15) = (/ &
        & 0.15038e+04,0.11787e+04,0.11191e+04,0.96573e+03,0.74364e+03, &
        & 0.75161e+03,0.89373e+03,0.10358e+04,0.11780e+04 /)
      kao(:, 2, 5,15) = (/ &
        & 0.12972e+04,0.14157e+04,0.10073e+04,0.10120e+04,0.78829e+03, &
        & 0.75051e+03,0.89254e+03,0.10346e+04,0.11785e+04 /)
      kao(:, 3, 5,15) = (/ &
        & 0.15562e+04,0.12980e+04,0.11053e+04,0.96784e+03,0.68156e+03, &
        & 0.74938e+03,0.89063e+03,0.10325e+04,0.11743e+04 /)
      kao(:, 4, 5,15) = (/ &
        & 0.15203e+04,0.12953e+04,0.96757e+03,0.95061e+03,0.68480e+03, &
        & 0.74750e+03,0.88780e+03,0.10293e+04,0.11708e+04 /)
      kao(:, 5, 5,15) = (/ &
        & 0.14730e+04,0.11456e+04,0.11151e+04,0.68408e+03,0.76176e+03, &
        & 0.75307e+03,0.89322e+03,0.10317e+04,0.11682e+04 /)
      kao(:, 1, 6,15) = (/ &
        & 0.15240e+04,0.12794e+04,0.10826e+04,0.93131e+03,0.69525e+03, &
        & 0.75122e+03,0.89364e+03,0.10361e+04,0.11785e+04 /)
      kao(:, 2, 6,15) = (/ &
        & 0.13735e+04,0.12837e+04,0.10725e+04,0.91616e+03,0.69548e+03, &
        & 0.75041e+03,0.89279e+03,0.10360e+04,0.11776e+04 /)
      kao(:, 3, 6,15) = (/ &
        & 0.14287e+04,0.11366e+04,0.10240e+04,0.87529e+03,0.70795e+03, &
        & 0.75034e+03,0.89142e+03,0.10337e+04,0.11759e+04 /)
      kao(:, 4, 6,15) = (/ &
        & 0.12768e+04,0.11078e+04,0.98805e+03,0.76254e+03,0.77383e+03, &
        & 0.74782e+03,0.88921e+03,0.10312e+04,0.11732e+04 /)
      kao(:, 5, 6,15) = (/ &
        & 0.13045e+04,0.12087e+04,0.10585e+04,0.89185e+03,0.69378e+03, &
        & 0.74461e+03,0.88618e+03,0.10253e+04,0.11684e+04 /)
      kao(:, 1, 7,15) = (/ &
        & 0.13068e+04,0.11778e+04,0.10485e+04,0.87245e+03,0.70237e+03, &
        & 0.75029e+03,0.89358e+03,0.10363e+04,0.11790e+04 /)
      kao(:, 2, 7,15) = (/ &
        & 0.13988e+04,0.11525e+04,0.98924e+03,0.83779e+03,0.64617e+03, &
        & 0.75022e+03,0.89357e+03,0.10355e+04,0.11782e+04 /)
      kao(:, 3, 7,15) = (/ &
        & 0.14294e+04,0.11695e+04,0.10182e+04,0.91196e+03,0.69696e+03, &
        & 0.74932e+03,0.89330e+03,0.10353e+04,0.11780e+04 /)
      kao(:, 4, 7,15) = (/ &
        & 0.14082e+04,0.10640e+04,0.10540e+04,0.79295e+03,0.62688e+03, &
        & 0.74789e+03,0.89097e+03,0.10327e+04,0.11750e+04 /)
      kao(:, 5, 7,15) = (/ &
        & 0.13514e+04,0.12038e+04,0.10012e+04,0.83544e+03,0.67927e+03, &
        & 0.74629e+03,0.88843e+03,0.10298e+04,0.11718e+04 /)
      kao(:, 1, 8,15) = (/ &
        & 0.14761e+04,0.12412e+04,0.10429e+04,0.84370e+03,0.62388e+03, &
        & 0.75133e+03,0.89371e+03,0.10367e+04,0.11796e+04 /)
      kao(:, 2, 8,15) = (/ &
        & 0.12119e+04,0.11409e+04,0.10121e+04,0.85755e+03,0.70976e+03, &
        & 0.74998e+03,0.89216e+03,0.10357e+04,0.11786e+04 /)
      kao(:, 3, 8,15) = (/ &
        & 0.12581e+04,0.11663e+04,0.10198e+04,0.88649e+03,0.69509e+03, &
        & 0.74932e+03,0.89355e+03,0.10350e+04,0.11787e+04 /)
      kao(:, 4, 8,15) = (/ &
        & 0.12478e+04,0.12066e+04,0.87201e+03,0.84155e+03,0.70223e+03, &
        & 0.74886e+03,0.89098e+03,0.10337e+04,0.11764e+04 /)
      kao(:, 5, 8,15) = (/ &
        & 0.12322e+04,0.11048e+04,0.93070e+03,0.68296e+03,0.66022e+03, &
        & 0.74776e+03,0.88972e+03,0.10315e+04,0.11748e+04 /)
      kao(:, 1, 9,15) = (/ &
        & 0.13164e+04,0.12093e+04,0.10729e+04,0.80022e+03,0.68605e+03, &
        & 0.75075e+03,0.89396e+03,0.10372e+04,0.11804e+04 /)
      kao(:, 2, 9,15) = (/ &
        & 0.12738e+04,0.11851e+04,0.88381e+03,0.85846e+03,0.65813e+03, &
        & 0.74985e+03,0.89295e+03,0.10369e+04,0.11792e+04 /)
      kao(:, 3, 9,15) = (/ &
        & 0.12657e+04,0.12031e+04,0.79849e+03,0.64636e+03,0.60824e+03, &
        & 0.74924e+03,0.89227e+03,0.10353e+04,0.11783e+04 /)
      kao(:, 4, 9,15) = (/ &
        & 0.12866e+04,0.11531e+04,0.85958e+03,0.76890e+03,0.66204e+03, &
        & 0.74965e+03,0.89143e+03,0.10344e+04,0.11773e+04 /)
      kao(:, 5, 9,15) = (/ &
        & 0.11604e+04,0.11730e+04,0.87009e+03,0.73148e+03,0.58106e+03, &
        & 0.74723e+03,0.88998e+03,0.10327e+04,0.11755e+04 /)
      kao(:, 1,10,15) = (/ &
        & 0.11188e+04,0.99215e+03,0.73460e+03,0.83046e+03,0.68844e+03, &
        & 0.75085e+03,0.89429e+03,0.10377e+04,0.11803e+04 /)
      kao(:, 2,10,15) = (/ &
        & 0.12059e+04,0.10804e+04,0.70761e+03,0.65712e+03,0.66535e+03, &
        & 0.74980e+03,0.89311e+03,0.10364e+04,0.11807e+04 /)
      kao(:, 3,10,15) = (/ &
        & 0.11817e+04,0.10195e+04,0.95365e+03,0.71601e+03,0.59959e+03, &
        & 0.74791e+03,0.89228e+03,0.10355e+04,0.11778e+04 /)
      kao(:, 4,10,15) = (/ &
        & 0.11350e+04,0.11533e+04,0.91058e+03,0.81845e+03,0.64874e+03, &
        & 0.74908e+03,0.89233e+03,0.10356e+04,0.11779e+04 /)
      kao(:, 5,10,15) = (/ &
        & 0.12000e+04,0.10896e+04,0.93671e+03,0.81314e+03,0.60750e+03, &
        & 0.74754e+03,0.89053e+03,0.10335e+04,0.11765e+04 /)
      kao(:, 1,11,15) = (/ &
        & 0.12887e+04,0.10795e+04,0.92507e+03,0.76020e+03,0.61621e+03, &
        & 0.75046e+03,0.89404e+03,0.10376e+04,0.11812e+04 /)
      kao(:, 2,11,15) = (/ &
        & 0.11864e+04,0.99352e+03,0.96688e+03,0.81999e+03,0.65449e+03, &
        & 0.74944e+03,0.89287e+03,0.10363e+04,0.11797e+04 /)
      kao(:, 3,11,15) = (/ &
        & 0.11946e+04,0.10069e+04,0.91904e+03,0.81170e+03,0.65606e+03, &
        & 0.74582e+03,0.89066e+03,0.10354e+04,0.11787e+04 /)
      kao(:, 4,11,15) = (/ &
        & 0.10269e+04,0.10463e+04,0.82697e+03,0.81731e+03,0.61185e+03, &
        & 0.74876e+03,0.89142e+03,0.10347e+04,0.11779e+04 /)
      kao(:, 5,11,15) = (/ &
        & 0.11483e+04,0.10490e+04,0.91718e+03,0.72295e+03,0.60510e+03, &
        & 0.74783e+03,0.89173e+03,0.10334e+04,0.11765e+04 /)
      kao(:, 1,12,15) = (/ &
        & 0.12157e+04,0.94948e+03,0.89441e+03,0.76380e+03,0.60866e+03, &
        & 0.75013e+03,0.89382e+03,0.10375e+04,0.11812e+04 /)
      kao(:, 2,12,15) = (/ &
        & 0.10470e+04,0.10059e+04,0.83704e+03,0.70161e+03,0.60721e+03, &
        & 0.74914e+03,0.89267e+03,0.10370e+04,0.11807e+04 /)
      kao(:, 3,12,15) = (/ &
        & 0.10541e+04,0.86865e+03,0.86614e+03,0.79420e+03,0.60576e+03, &
        & 0.74144e+03,0.89117e+03,0.10353e+04,0.11778e+04 /)
      kao(:, 4,12,15) = (/ &
        & 0.11152e+04,0.10946e+04,0.91200e+03,0.75719e+03,0.60459e+03, &
        & 0.74791e+03,0.89124e+03,0.10346e+04,0.11788e+04 /)
      kao(:, 5,12,15) = (/ &
        & 0.10232e+04,0.97767e+03,0.95862e+03,0.62268e+03,0.60382e+03, &
        & 0.74758e+03,0.88947e+03,0.10333e+04,0.11765e+04 /)
      kao(:, 1,13,15) = (/ &
        & 0.11027e+04,0.93786e+03,0.84040e+03,0.77686e+03,0.60858e+03, &
        & 0.74987e+03,0.89364e+03,0.10374e+04,0.11812e+04 /)
      kao(:, 2,13,15) = (/ &
        & 0.10816e+04,0.10747e+04,0.88690e+03,0.66213e+03,0.60670e+03, &
        & 0.74889e+03,0.89251e+03,0.10369e+04,0.11797e+04 /)
      kao(:, 3,13,15) = (/ &
        & 0.11963e+04,0.98701e+03,0.69767e+03,0.73646e+03,0.60528e+03, &
        & 0.74531e+03,0.88962e+03,0.10352e+04,0.11778e+04 /)
      kao(:, 4,13,15) = (/ &
        & 0.10530e+04,0.78530e+03,0.91477e+03,0.71026e+03,0.60430e+03, &
        & 0.74770e+03,0.89110e+03,0.10345e+04,0.11779e+04 /)
      kao(:, 5,13,15) = (/ &
        & 0.11409e+04,0.10574e+04,0.83207e+03,0.61034e+03,0.60355e+03, &
        & 0.74679e+03,0.89073e+03,0.10333e+04,0.11765e+04 /)
      kao(:, 1, 1,16) = (/ &
        & 0.34848e+03,0.49670e+03,0.29569e+03,0.31627e+03,0.46514e+03, &
        & 0.42834e+03,0.88848e+03,0.10335e+04,0.11735e+04 /)
      kao(:, 2, 1,16) = (/ &
        & 0.18044e+04,0.87518e+03,0.11930e+04,0.45580e+03,0.83690e+03, &
        & 0.74631e+03,0.89022e+03,0.10242e+04,0.11632e+04 /)
      kao(:, 3, 1,16) = (/ &
        & 0.11196e+04,0.73658e+03,0.10480e+04,0.53695e+03,0.39566e+03, &
        & 0.74377e+03,0.86775e+03,0.94144e+03,0.11277e+04 /)
      kao(:, 4, 1,16) = (/ &
        & 0.72013e+03,0.40040e+03,0.39030e+03,0.31401e+03,0.31498e+03, &
        & 0.74613e+03,0.88553e+03,0.10249e+04,0.11579e+04 /)
      kao(:, 5, 1,16) = (/ &
        & 0.34789e+03,0.14911e+04,0.33003e+03,0.29522e+03,0.31385e+03, &
        & 0.74516e+03,0.88480e+03,0.10244e+04,0.11641e+04 /)
      kao(:, 1, 2,16) = (/ &
        & 0.41247e+03,0.81197e+03,0.68322e+03,0.50855e+03,0.24076e+03, &
        & 0.74851e+03,0.88842e+03,0.10341e+04,0.11748e+04 /)
      kao(:, 2, 2,16) = (/ &
        & 0.16209e+04,0.56884e+03,0.94156e+03,0.29182e+03,0.46039e+03, &
        & 0.75011e+03,0.88557e+03,0.10309e+04,0.11714e+04 /)
      kao(:, 3, 2,16) = (/ &
        & 0.11534e+04,0.51443e+03,0.23941e+03,0.44358e+03,0.58779e+03, &
        & 0.74720e+03,0.88237e+03,0.10275e+04,0.11547e+04 /)
      kao(:, 4, 2,16) = (/ &
        & 0.78193e+03,0.30585e+03,0.42670e+03,0.10365e+04,0.43225e+03, &
        & 0.74126e+03,0.88535e+03,0.10253e+04,0.11588e+04 /)
      kao(:, 5, 2,16) = (/ &
        & 0.67509e+03,0.40574e+03,0.57252e+03,0.10353e+04,0.15564e+03, &
        & 0.73954e+03,0.88360e+03,0.10236e+04,0.11636e+04 /)
      kao(:, 1, 3,16) = (/ &
        & 0.91257e+03,0.11144e+04,0.54685e+03,0.19037e+03,0.25900e+03, &
        & 0.74823e+03,0.89369e+03,0.10350e+04,0.11762e+04 /)
      kao(:, 2, 3,16) = (/ &
        & 0.67162e+03,0.10092e+04,0.40983e+03,0.37826e+03,0.42702e+03, &
        & 0.75035e+03,0.88647e+03,0.10325e+04,0.11736e+04 /)
      kao(:, 3, 3,16) = (/ &
        & 0.94657e+03,0.26107e+03,0.43567e+03,0.41065e+03,0.70838e+03, &
        & 0.74760e+03,0.88832e+03,0.10233e+04,0.11698e+04 /)
      kao(:, 4, 3,16) = (/ &
        & 0.10618e+03,0.45040e+03,0.10291e+04,0.30237e+03,0.57813e+03, &
        & 0.73277e+03,0.87582e+03,0.95203e+03,0.11472e+04 /)
      kao(:, 5, 3,16) = (/ &
        & 0.96551e+03,0.68706e+03,0.56500e+03,0.14865e+03,0.35532e+03, &
        & 0.73527e+03,0.86908e+03,0.10241e+04,0.11579e+04 /)
      kao(:, 1, 4,16) = (/ &
        & 0.13211e+04,0.11050e+04,0.91067e+03,0.34788e+03,0.76485e+03, &
        & 0.75213e+03,0.88892e+03,0.10299e+04,0.11709e+04 /)
      kao(:, 2, 4,16) = (/ &
        & 0.15543e+04,0.92211e+03,0.72798e+03,0.86839e+03,0.36802e+03, &
        & 0.74223e+03,0.89219e+03,0.10338e+04,0.11754e+04 /)
      kao(:, 3, 4,16) = (/ &
        & 0.53676e+03,0.46363e+03,0.10941e+04,0.19958e+03,0.68767e+03, &
        & 0.74416e+03,0.88965e+03,0.10195e+04,0.11658e+04 /)
      kao(:, 4, 4,16) = (/ &
        & 0.66992e+03,0.61007e+03,0.50612e+03,0.34999e+03,0.19685e+03, &
        & 0.74139e+03,0.88155e+03,0.10274e+04,0.11555e+04 /)
      kao(:, 5, 4,16) = (/ &
        & 0.55226e+03,0.42689e+03,0.10712e+04,0.69959e+03,0.69105e+03, &
        & 0.73534e+03,0.87452e+03,0.10137e+04,0.11529e+04 /)
      kao(:, 1, 5,16) = (/ &
        & 0.11854e+04,0.90025e+03,0.10734e+04,0.36732e+03,0.51551e+03, &
        & 0.75181e+03,0.89397e+03,0.10361e+04,0.11783e+04 /)
      kao(:, 2, 5,16) = (/ &
        & 0.13933e+04,0.23882e+03,0.71015e+03,0.29765e+03,0.88507e+02, &
        & 0.75060e+03,0.89266e+03,0.10347e+04,0.11637e+04 /)
      kao(:, 3, 5,16) = (/ &
        & 0.30783e+03,0.72533e+03,0.99782e+03,0.22581e+03,0.21957e+03, &
        & 0.74471e+03,0.89072e+03,0.10326e+04,0.11744e+04 /)
      kao(:, 4, 5,16) = (/ &
        & 0.12756e+03,0.23797e+03,0.16871e+03,0.60625e+03,0.35893e+03, &
        & 0.73811e+03,0.88789e+03,0.10294e+04,0.11709e+04 /)
      kao(:, 5, 5,16) = (/ &
        & 0.67577e+03,0.67606e+03,0.57612e+03,0.15439e+03,0.22922e+03, &
        & 0.66526e+03,0.82593e+03,0.98621e+03,0.11543e+04 /)
      kao(:, 1, 6,16) = (/ &
        & 0.35294e+03,0.92951e+03,0.39404e+03,0.59466e+03,0.46365e+03, &
        & 0.75155e+03,0.89403e+03,0.10365e+04,0.11790e+04 /)
      kao(:, 2, 6,16) = (/ &
        & 0.83494e+03,0.91972e+03,0.83351e+02,0.26459e+03,0.33053e+03, &
        & 0.75056e+03,0.89298e+03,0.10296e+04,0.11778e+04 /)
      kao(:, 3, 6,16) = (/ &
        & 0.77495e+02,0.67358e+03,0.71470e+03,0.28985e+03,0.12695e+03, &
        & 0.74093e+03,0.89153e+03,0.10338e+04,0.11761e+04 /)
      kao(:, 4, 6,16) = (/ &
        & 0.12524e+04,0.52300e+03,0.17321e+03,0.31958e+03,0.15643e+03, &
        & 0.74316e+03,0.88930e+03,0.10313e+04,0.11733e+04 /)
      kao(:, 5, 6,16) = (/ &
        & 0.79880e+03,0.54259e+03,0.31909e+03,0.47791e+03,0.45938e+03, &
        & 0.74468e+03,0.88626e+03,0.10278e+04,0.11499e+04 /)
      kao(:, 1, 7,16) = (/ &
        & 0.10078e+04,0.83081e+03,0.68047e+03,0.68284e+03,0.57904e+03, &
        & 0.75128e+03,0.89403e+03,0.10368e+04,0.11795e+04 /)
      kao(:, 2, 7,16) = (/ &
        & 0.67323e+03,0.10228e+04,0.49758e+03,0.33578e+03,0.38746e+03, &
        & 0.75047e+03,0.88822e+03,0.10359e+04,0.11786e+04 /)
      kao(:, 3, 7,16) = (/ &
        & 0.60358e+03,0.41876e+03,0.74942e+03,0.38757e+03,0.61092e+03, &
        & 0.74943e+03,0.88213e+03,0.10289e+04,0.11707e+04 /)
      kao(:, 4, 7,16) = (/ &
        & 0.69109e+03,0.11040e+04,0.46705e+03,0.74628e+03,0.47483e+03, &
        & 0.74797e+03,0.88542e+03,0.10328e+04,0.11752e+04 /)
      kao(:, 5, 7,16) = (/ &
        & 0.68277e+03,0.46564e+03,0.19228e+03,0.48854e+03,0.28304e+03, &
        & 0.74163e+03,0.88289e+03,0.10299e+04,0.11719e+04 /)
      kao(:, 1, 8,16) = (/ &
        & 0.26685e+03,0.60532e+03,0.51009e+03,0.40907e+03,0.39126e+03, &
        & 0.74682e+03,0.89396e+03,0.10369e+04,0.11799e+04 /)
      kao(:, 2, 8,16) = (/ &
        & 0.94869e+03,0.11471e+04,0.44706e+03,0.23151e+03,0.93532e+02, &
        & 0.75035e+03,0.89331e+03,0.10363e+04,0.11727e+04 /)
      kao(:, 3, 8,16) = (/ &
        & 0.11588e+04,0.74588e+03,0.28311e+03,0.27864e+03,0.32853e+03, &
        & 0.74950e+03,0.88246e+03,0.10352e+04,0.11716e+04 /)
      kao(:, 4, 8,16) = (/ &
        & 0.11874e+04,0.47456e+03,0.83368e+03,0.31591e+03,0.30274e+03, &
        & 0.74421e+03,0.89109e+03,0.10338e+04,0.11765e+04 /)
      kao(:, 5, 8,16) = (/ &
        & 0.45710e+03,0.66086e+03,0.55863e+03,0.58037e+03,0.20569e+03, &
        & 0.73836e+03,0.88417e+03,0.10316e+04,0.11675e+04 /)
      kao(:, 1, 9,16) = (/ &
        & 0.55233e+03,0.18269e+03,0.18991e+03,0.35964e+03,0.38998e+03, &
        & 0.75089e+03,0.89415e+03,0.10374e+04,0.11807e+04 /)
      kao(:, 2, 9,16) = (/ &
        & 0.31819e+03,0.14904e+03,0.79703e+03,0.32317e+03,0.20679e+03, &
        & 0.75021e+03,0.89337e+03,0.10308e+04,0.11797e+04 /)
      kao(:, 3, 9,16) = (/ &
        & 0.16059e+03,0.37409e+03,0.62337e+03,0.62951e+03,0.47662e+03, &
        & 0.74953e+03,0.89262e+03,0.10357e+04,0.11788e+04 /)
      kao(:, 4, 9,16) = (/ &
        & 0.15191e+03,0.63681e+03,0.25601e+03,0.65772e+03,0.38994e+03, &
        & 0.74029e+03,0.89158e+03,0.10346e+04,0.11775e+04 /)
      kao(:, 5, 9,16) = (/ &
        & 0.10392e+04,0.33629e+03,0.90538e+03,0.33435e+03,0.46694e+03, &
        & 0.74731e+03,0.89008e+03,0.10329e+04,0.11756e+04 /)
      kao(:, 1,10,16) = (/ &
        & 0.43161e+03,0.53194e+03,0.82168e+03,0.11050e+03,0.32159e+02, &
        & 0.75101e+03,0.89450e+03,0.10380e+04,0.11815e+04 /)
      kao(:, 2,10,16) = (/ &
        & 0.23362e+03,0.50697e+03,0.75913e+03,0.37965e+03,0.15877e+03, &
        & 0.75002e+03,0.89333e+03,0.10366e+04,0.11734e+04 /)
      kao(:, 3,10,16) = (/ &
        & 0.66577e+03,0.22676e+03,0.63752e+03,0.50488e+03,0.52339e+03, &
        & 0.74947e+03,0.88778e+03,0.10360e+04,0.11793e+04 /)
      kao(:, 4,10,16) = (/ &
        & 0.12040e+04,0.37222e+03,0.71269e+03,0.68368e+02,0.31445e+03, &
        & 0.74453e+03,0.88691e+03,0.10293e+04,0.11782e+04 /)
      kao(:, 5,10,16) = (/ &
        & 0.85334e+03,0.50951e+03,0.43397e+03,0.11861e+03,0.15074e+03, &
        & 0.74764e+03,0.89065e+03,0.10337e+04,0.11767e+04 /)
      kao(:, 1,11,16) = (/ &
        & 0.45853e+03,0.29024e+03,0.38275e+03,0.26130e+03,0.12124e+03, &
        & 0.75062e+03,0.89424e+03,0.10379e+04,0.11815e+04 /)
      kao(:, 2,11,16) = (/ &
        & 0.66691e+03,0.55656e+03,0.39879e+03,0.16526e+03,0.24675e+03, &
        & 0.74965e+03,0.89309e+03,0.10365e+04,0.11800e+04 /)
      kao(:, 3,11,16) = (/ &
        & 0.10239e+04,0.60930e+03,0.22001e+03,0.10914e+03,0.22748e+03, &
        & 0.74913e+03,0.89251e+03,0.10359e+04,0.11793e+04 /)
      kao(:, 4,11,16) = (/ &
        & 0.80567e+03,0.90344e+03,0.77356e+03,0.12489e+03,0.55902e+03, &
        & 0.74421e+03,0.89165e+03,0.10349e+04,0.11782e+04 /)
      kao(:, 5,11,16) = (/ &
        & 0.80619e+03,0.87963e+03,0.47254e+03,0.39261e+03,0.59752e+03, &
        & 0.74319e+03,0.88056e+03,0.10336e+04,0.11767e+04 /)
      kao(:, 1,12,16) = (/ &
        & 0.54479e+03,0.73809e+03,0.74534e+03,0.30870e+03,0.60893e+03, &
        & 0.75030e+03,0.89402e+03,0.10378e+04,0.11815e+04 /)
      kao(:, 2,12,16) = (/ &
        & 0.10600e+04,0.76559e+03,0.34957e+03,0.18602e+03,0.60736e+03, &
        & 0.74935e+03,0.89289e+03,0.10307e+04,0.11734e+04 /)
      kao(:, 3,12,16) = (/ &
        & 0.10515e+04,0.60079e+03,0.43472e+03,0.33220e+03,0.60582e+03, &
        & 0.74885e+03,0.89233e+03,0.10358e+04,0.11793e+04 /)
      kao(:, 4,12,16) = (/ &
        & 0.32670e+03,0.23075e+03,0.13581e+03,0.17106e+03,0.60474e+03, &
        & 0.74811e+03,0.89148e+03,0.10348e+04,0.11717e+04 /)
      kao(:, 5,12,16) = (/ &
        & 0.20371e+03,0.68798e+03,0.91592e+02,0.60316e+03,0.60390e+03, &
        & 0.74294e+03,0.89029e+03,0.10335e+04,0.11767e+04 /)
      kao(:, 1,13,16) = (/ &
        & 0.85988e+03,0.94717e+03,0.84544e+03,0.31415e+03,0.60500e+03, &
        & 0.75003e+03,0.89385e+03,0.10377e+04,0.11815e+04 /)
      kao(:, 2,13,16) = (/ &
        & 0.10379e+04,0.11189e+03,0.20733e+03,0.17410e+03,0.60685e+03, &
        & 0.74910e+03,0.89272e+03,0.10306e+04,0.11800e+04 /)
      kao(:, 3,13,16) = (/ &
        & 0.70206e+03,0.77801e+03,0.11974e+03,0.34591e+03,0.60534e+03, &
        & 0.74861e+03,0.89217e+03,0.10357e+04,0.11793e+04 /)
      kao(:, 4,13,16) = (/ &
        & 0.69165e+03,0.93369e+03,0.16190e+03,0.16396e+03,0.60445e+03, &
        & 0.74789e+03,0.89133e+03,0.10348e+04,0.11782e+04 /)
      kao(:, 5,13,16) = (/ &
        & 0.20016e+03,0.25832e+03,0.57797e+03,0.24270e+03,0.60363e+03, &
        & 0.74689e+03,0.88521e+03,0.10334e+04,0.11767e+04 /)
  
!     -----------------------------------------------------------------
!     The array KBO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels < ~100mb and temperatures. The first 
!     index in the array, JT, which runs from 1 to 5, corresponds to 
!     different temperatures.  More specifically, JT = 3 means that the 
!     data are for the reference temperature TREF for this pressure 
!     level, JT = 2 refers to the temperature TREF-15, JT = 1 is for
!     TREF-30, JT = 4 is for TREF+15, and JT = 5 is for TREF+30.  
!     The second index, JP, runs from 13 to 59 and refers to the JPth
!     reference pressure level (see taumol.f for the value of these
!     pressure levels in mb).  The third index, IG, goes from 1 to 16,
!     and tells us which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kbo(:, 1,13, 1) = (/ &
        & 0.27369e+02,0.29903e+03,0.42924e+03,0.31039e+03,0.35000e+02 /)
      kbo(:, 2,13, 1) = (/ &
        & 0.27158e+02,0.29898e+03,0.42745e+03,0.30840e+03,0.35000e+02 /)
      kbo(:, 3,13, 1) = (/ &
        & 0.26976e+02,0.29889e+03,0.42590e+03,0.30668e+03,0.35000e+02 /)
      kbo(:, 4,13, 1) = (/ &
        & 0.26818e+02,0.29875e+03,0.42455e+03,0.30517e+03,0.35000e+02 /)
      kbo(:, 5,13, 1) = (/ &
        & 0.26679e+02,0.29855e+03,0.42335e+03,0.30384e+03,0.35000e+02 /)
      kbo(:, 1,14, 1) = (/ &
        & 0.26840e+02,0.29863e+03,0.42474e+03,0.30538e+03,0.35000e+02 /)
      kbo(:, 2,14, 1) = (/ &
        & 0.26669e+02,0.29862e+03,0.42327e+03,0.30375e+03,0.35000e+02 /)
      kbo(:, 3,14, 1) = (/ &
        & 0.26522e+02,0.29854e+03,0.42199e+03,0.30234e+03,0.35000e+02 /)
      kbo(:, 4,14, 1) = (/ &
        & 0.26394e+02,0.29842e+03,0.42088e+03,0.30111e+03,0.35000e+02 /)
      kbo(:, 5,14, 1) = (/ &
        & 0.26282e+02,0.29824e+03,0.41990e+03,0.30002e+03,0.35000e+02 /)
      kbo(:, 1,15, 1) = (/ &
        & 0.26408e+02,0.29831e+03,0.42100e+03,0.30124e+03,0.35000e+02 /)
      kbo(:, 2,15, 1) = (/ &
        & 0.26271e+02,0.29832e+03,0.41980e+03,0.29991e+03,0.35000e+02 /)
      kbo(:, 3,15, 1) = (/ &
        & 0.26152e+02,0.29826e+03,0.41876e+03,0.29877e+03,0.35000e+02 /)
      kbo(:, 4,15, 1) = (/ &
        & 0.26049e+02,0.29814e+03,0.41785e+03,0.29776e+03,0.35000e+02 /)
      kbo(:, 5,15, 1) = (/ &
        & 0.25958e+02,0.29797e+03,0.41705e+03,0.29688e+03,0.35000e+02 /)
      kbo(:, 1,16, 1) = (/ &
        & 0.26057e+02,0.29806e+03,0.41793e+03,0.29784e+03,0.35000e+02 /)
      kbo(:, 2,16, 1) = (/ &
        & 0.25946e+02,0.29807e+03,0.41695e+03,0.29676e+03,0.35000e+02 /)
      kbo(:, 3,16, 1) = (/ &
        & 0.25851e+02,0.29803e+03,0.41610e+03,0.29583e+03,0.35000e+02 /)
      kbo(:, 4,16, 1) = (/ &
        & 0.25767e+02,0.29792e+03,0.41536e+03,0.29502e+03,0.35000e+02 /)
      kbo(:, 5,16, 1) = (/ &
        & 0.25694e+02,0.29776e+03,0.41470e+03,0.29430e+03,0.35000e+02 /)
      kbo(:, 1,17, 1) = (/ &
        & 0.25772e+02,0.29785e+03,0.41540e+03,0.29506e+03,0.35000e+02 /)
      kbo(:, 2,17, 1) = (/ &
        & 0.25683e+02,0.29787e+03,0.41460e+03,0.29419e+03,0.35000e+02 /)
      kbo(:, 3,17, 1) = (/ &
        & 0.25606e+02,0.29784e+03,0.41391e+03,0.29343e+03,0.35000e+02 /)
      kbo(:, 4,17, 1) = (/ &
        & 0.25538e+02,0.29774e+03,0.41331e+03,0.29277e+03,0.35000e+02 /)
      kbo(:, 5,17, 1) = (/ &
        & 0.25479e+02,0.29758e+03,0.41278e+03,0.29219e+03,0.35000e+02 /)
      kbo(:, 1,18, 1) = (/ &
        & 0.25541e+02,0.29768e+03,0.41334e+03,0.29280e+03,0.35000e+02 /)
      kbo(:, 2,18, 1) = (/ &
        & 0.25469e+02,0.29772e+03,0.41269e+03,0.29209e+03,0.35000e+02 /)
      kbo(:, 3,18, 1) = (/ &
        & 0.25407e+02,0.29768e+03,0.41213e+03,0.29147e+03,0.35000e+02 /)
      kbo(:, 4,18, 1) = (/ &
        & 0.25353e+02,0.29758e+03,0.41163e+03,0.29094e+03,0.35000e+02 /)
      kbo(:, 5,18, 1) = (/ &
        & 0.25305e+02,0.29743e+03,0.41120e+03,0.29046e+03,0.35000e+02 /)
      kbo(:, 1,19, 1) = (/ &
        & 0.25354e+02,0.29755e+03,0.41165e+03,0.29095e+03,0.35000e+02 /)
      kbo(:, 2,19, 1) = (/ &
        & 0.25296e+02,0.29758e+03,0.41112e+03,0.29037e+03,0.35000e+02 /)
      kbo(:, 3,19, 1) = (/ &
        & 0.25245e+02,0.29755e+03,0.41067e+03,0.28988e+03,0.35000e+02 /)
      kbo(:, 4,19, 1) = (/ &
        & 0.25201e+02,0.29746e+03,0.41027e+03,0.28944e+03,0.35000e+02 /)
      kbo(:, 5,19, 1) = (/ &
        & 0.25163e+02,0.29730e+03,0.40991e+03,0.28905e+03,0.35000e+02 /)
      kbo(:, 1,20, 1) = (/ &
        & 0.25201e+02,0.29744e+03,0.41026e+03,0.28943e+03,0.35000e+02 /)
      kbo(:, 2,20, 1) = (/ &
        & 0.25154e+02,0.29748e+03,0.40984e+03,0.28897e+03,0.35000e+02 /)
      kbo(:, 3,20, 1) = (/ &
        & 0.25113e+02,0.29745e+03,0.40947e+03,0.28856e+03,0.35000e+02 /)
      kbo(:, 4,20, 1) = (/ &
        & 0.25078e+02,0.29735e+03,0.40914e+03,0.28821e+03,0.35000e+02 /)
      kbo(:, 5,20, 1) = (/ &
        & 0.25047e+02,0.29719e+03,0.40886e+03,0.28790e+03,0.35000e+02 /)
      kbo(:, 1,21, 1) = (/ &
        & 0.25076e+02,0.29736e+03,0.40913e+03,0.28819e+03,0.35000e+02 /)
      kbo(:, 2,21, 1) = (/ &
        & 0.25039e+02,0.29739e+03,0.40879e+03,0.28782e+03,0.35000e+02 /)
      kbo(:, 3,21, 1) = (/ &
        & 0.25006e+02,0.29736e+03,0.40849e+03,0.28749e+03,0.35000e+02 /)
      kbo(:, 4,21, 1) = (/ &
        & 0.24978e+02,0.29726e+03,0.40823e+03,0.28722e+03,0.35000e+02 /)
      kbo(:, 5,21, 1) = (/ &
        & 0.24952e+02,0.29710e+03,0.40800e+03,0.28695e+03,0.35000e+02 /)
      kbo(:, 1,22, 1) = (/ &
        & 0.24973e+02,0.29729e+03,0.40819e+03,0.28717e+03,0.35000e+02 /)
      kbo(:, 2,22, 1) = (/ &
        & 0.24944e+02,0.29732e+03,0.40792e+03,0.28687e+03,0.35000e+02 /)
      kbo(:, 3,22, 1) = (/ &
        & 0.24917e+02,0.29728e+03,0.40768e+03,0.28661e+03,0.35000e+02 /)
      kbo(:, 4,22, 1) = (/ &
        & 0.24895e+02,0.29717e+03,0.40747e+03,0.28638e+03,0.35000e+02 /)
      kbo(:, 5,22, 1) = (/ &
        & 0.24874e+02,0.29700e+03,0.40728e+03,0.28618e+03,0.35000e+02 /)
      kbo(:, 1,23, 1) = (/ &
        & 0.24890e+02,0.29724e+03,0.40743e+03,0.28634e+03,0.35000e+02 /)
      kbo(:, 2,23, 1) = (/ &
        & 0.24866e+02,0.29726e+03,0.40721e+03,0.28610e+03,0.35000e+02 /)
      kbo(:, 3,23, 1) = (/ &
        & 0.24846e+02,0.29721e+03,0.40702e+03,0.28589e+03,0.35000e+02 /)
      kbo(:, 4,23, 1) = (/ &
        & 0.24827e+02,0.29710e+03,0.40685e+03,0.28571e+03,0.35000e+02 /)
      kbo(:, 5,23, 1) = (/ &
        & 0.24811e+02,0.29692e+03,0.40671e+03,0.28554e+03,0.35000e+02 /)
      kbo(:, 1,24, 1) = (/ &
        & 0.24823e+02,0.29721e+03,0.40681e+03,0.28566e+03,0.35000e+02 /)
      kbo(:, 2,24, 1) = (/ &
        & 0.24804e+02,0.29721e+03,0.40664e+03,0.28547e+03,0.35000e+02 /)
      kbo(:, 3,24, 1) = (/ &
        & 0.24787e+02,0.29715e+03,0.40649e+03,0.28530e+03,0.35000e+02 /)
      kbo(:, 4,24, 1) = (/ &
        & 0.24773e+02,0.29703e+03,0.40635e+03,0.28516e+03,0.35000e+02 /)
      kbo(:, 5,24, 1) = (/ &
        & 0.24760e+02,0.29684e+03,0.40623e+03,0.28503e+03,0.35000e+02 /)
      kbo(:, 1,25, 1) = (/ &
        & 0.24769e+02,0.29717e+03,0.40631e+03,0.28511e+03,0.35000e+02 /)
      kbo(:, 2,25, 1) = (/ &
        & 0.24753e+02,0.29717e+03,0.40618e+03,0.28496e+03,0.35000e+02 /)
      kbo(:, 3,25, 1) = (/ &
        & 0.24740e+02,0.29710e+03,0.40606e+03,0.28483e+03,0.35000e+02 /)
      kbo(:, 4,25, 1) = (/ &
        & 0.24729e+02,0.29696e+03,0.40595e+03,0.28472e+03,0.35000e+02 /)
      kbo(:, 5,25, 1) = (/ &
        & 0.24718e+02,0.29676e+03,0.40585e+03,0.28462e+03,0.35000e+02 /)
      kbo(:, 1,26, 1) = (/ &
        & 0.24724e+02,0.29715e+03,0.40591e+03,0.28467e+03,0.35000e+02 /)
      kbo(:, 2,26, 1) = (/ &
        & 0.24712e+02,0.29713e+03,0.40580e+03,0.28456e+03,0.35000e+02 /)
      kbo(:, 3,26, 1) = (/ &
        & 0.24702e+02,0.29704e+03,0.40570e+03,0.28445e+03,0.35000e+02 /)
      kbo(:, 4,26, 1) = (/ &
        & 0.24693e+02,0.29689e+03,0.40562e+03,0.28435e+03,0.35000e+02 /)
      kbo(:, 5,26, 1) = (/ &
        & 0.24684e+02,0.29668e+03,0.40554e+03,0.28427e+03,0.35000e+02 /)
      kbo(:, 1,27, 1) = (/ &
        & 0.24689e+02,0.29713e+03,0.40558e+03,0.28431e+03,0.35000e+02 /)
      kbo(:, 2,27, 1) = (/ &
        & 0.24679e+02,0.29709e+03,0.40550e+03,0.28422e+03,0.35000e+02 /)
      kbo(:, 3,27, 1) = (/ &
        & 0.24671e+02,0.29699e+03,0.40542e+03,0.28423e+03,0.35000e+02 /)
      kbo(:, 4,27, 1) = (/ &
        & 0.24664e+02,0.29683e+03,0.40535e+03,0.28405e+03,0.35000e+02 /)
      kbo(:, 5,27, 1) = (/ &
        & 0.24657e+02,0.29660e+03,0.40529e+03,0.28399e+03,0.35000e+02 /)
      kbo(:, 1,28, 1) = (/ &
        & 0.24660e+02,0.29710e+03,0.40532e+03,0.28404e+03,0.35000e+02 /)
      kbo(:, 2,28, 1) = (/ &
        & 0.24653e+02,0.29706e+03,0.40525e+03,0.28395e+03,0.35000e+02 /)
      kbo(:, 3,28, 1) = (/ &
        & 0.24646e+02,0.29694e+03,0.40519e+03,0.28389e+03,0.35000e+02 /)
      kbo(:, 4,28, 1) = (/ &
        & 0.24640e+02,0.29676e+03,0.40514e+03,0.28383e+03,0.35000e+02 /)
      kbo(:, 5,28, 1) = (/ &
        & 0.24635e+02,0.29651e+03,0.40509e+03,0.28376e+03,0.35000e+02 /)
      kbo(:, 1,29, 1) = (/ &
        & 0.24637e+02,0.29708e+03,0.40511e+03,0.28380e+03,0.35000e+02 /)
      kbo(:, 2,29, 1) = (/ &
        & 0.24631e+02,0.29702e+03,0.40505e+03,0.28374e+03,0.35000e+02 /)
      kbo(:, 3,29, 1) = (/ &
        & 0.24626e+02,0.29689e+03,0.40500e+03,0.28368e+03,0.35000e+02 /)
      kbo(:, 4,29, 1) = (/ &
        & 0.24621e+02,0.29669e+03,0.40496e+03,0.28364e+03,0.35000e+02 /)
      kbo(:, 5,29, 1) = (/ &
        & 0.24617e+02,0.29643e+03,0.40492e+03,0.28359e+03,0.35000e+02 /)
      kbo(:, 1,30, 1) = (/ &
        & 0.24619e+02,0.29706e+03,0.40494e+03,0.28360e+03,0.35000e+02 /)
      kbo(:, 2,30, 1) = (/ &
        & 0.24614e+02,0.29698e+03,0.40489e+03,0.28355e+03,0.35000e+02 /)
      kbo(:, 3,30, 1) = (/ &
        & 0.24610e+02,0.29683e+03,0.40485e+03,0.28351e+03,0.35000e+02 /)
      kbo(:, 4,30, 1) = (/ &
        & 0.24606e+02,0.29662e+03,0.40482e+03,0.28347e+03,0.35000e+02 /)
      kbo(:, 5,30, 1) = (/ &
        & 0.24603e+02,0.29634e+03,0.40479e+03,0.28344e+03,0.35000e+02 /)
      kbo(:, 1,31, 1) = (/ &
        & 0.24604e+02,0.29704e+03,0.40480e+03,0.28345e+03,0.35000e+02 /)
      kbo(:, 2,31, 1) = (/ &
        & 0.24600e+02,0.29694e+03,0.40477e+03,0.28341e+03,0.35000e+02 /)
      kbo(:, 3,31, 1) = (/ &
        & 0.24597e+02,0.29678e+03,0.40473e+03,0.28338e+03,0.35000e+02 /)
      kbo(:, 4,31, 1) = (/ &
        & 0.24594e+02,0.29655e+03,0.40471e+03,0.28336e+03,0.35000e+02 /)
      kbo(:, 5,31, 1) = (/ &
        & 0.24591e+02,0.29625e+03,0.40468e+03,0.28332e+03,0.35000e+02 /)
      kbo(:, 1,32, 1) = (/ &
        & 0.24592e+02,0.29701e+03,0.40469e+03,0.28333e+03,0.35000e+02 /)
      kbo(:, 2,32, 1) = (/ &
        & 0.24589e+02,0.29689e+03,0.40466e+03,0.28330e+03,0.35000e+02 /)
      kbo(:, 3,32, 1) = (/ &
        & 0.24586e+02,0.29672e+03,0.40464e+03,0.28328e+03,0.35000e+02 /)
      kbo(:, 4,32, 1) = (/ &
        & 0.24584e+02,0.29647e+03,0.40461e+03,0.28324e+03,0.35000e+02 /)
      kbo(:, 5,32, 1) = (/ &
        & 0.24582e+02,0.29615e+03,0.40459e+03,0.28325e+03,0.35000e+02 /)
      kbo(:, 1,33, 1) = (/ &
        & 0.24582e+02,0.29698e+03,0.40460e+03,0.28323e+03,0.35000e+02 /)
      kbo(:, 2,33, 1) = (/ &
        & 0.24580e+02,0.29685e+03,0.40458e+03,0.28321e+03,0.35000e+02 /)
      kbo(:, 3,33, 1) = (/ &
        & 0.24578e+02,0.29665e+03,0.40456e+03,0.28318e+03,0.35000e+02 /)
      kbo(:, 4,33, 1) = (/ &
        & 0.24576e+02,0.29639e+03,0.40454e+03,0.28317e+03,0.35000e+02 /)
      kbo(:, 5,33, 1) = (/ &
        & 0.24574e+02,0.29605e+03,0.40452e+03,0.28315e+03,0.35000e+02 /)
      kbo(:, 1,34, 1) = (/ &
        & 0.24574e+02,0.29695e+03,0.40453e+03,0.28315e+03,0.35000e+02 /)
      kbo(:, 2,34, 1) = (/ &
        & 0.24572e+02,0.29680e+03,0.40451e+03,0.28313e+03,0.35000e+02 /)
      kbo(:, 3,34, 1) = (/ &
        & 0.24571e+02,0.29659e+03,0.40449e+03,0.28312e+03,0.35000e+02 /)
      kbo(:, 4,34, 1) = (/ &
        & 0.24569e+02,0.29631e+03,0.40448e+03,0.28310e+03,0.35000e+02 /)
      kbo(:, 5,34, 1) = (/ &
        & 0.24568e+02,0.29596e+03,0.40447e+03,0.28308e+03,0.35000e+02 /)
      kbo(:, 1,35, 1) = (/ &
        & 0.24568e+02,0.29693e+03,0.40447e+03,0.28309e+03,0.35000e+02 /)
      kbo(:, 2,35, 1) = (/ &
        & 0.24567e+02,0.29678e+03,0.40446e+03,0.28308e+03,0.35000e+02 /)
      kbo(:, 3,35, 1) = (/ &
        & 0.24565e+02,0.29656e+03,0.40444e+03,0.28306e+03,0.35000e+02 /)
      kbo(:, 4,35, 1) = (/ &
        & 0.24564e+02,0.29627e+03,0.40443e+03,0.28305e+03,0.35000e+02 /)
      kbo(:, 5,35, 1) = (/ &
        & 0.24563e+02,0.29590e+03,0.40442e+03,0.28304e+03,0.35000e+02 /)
      kbo(:, 1,36, 1) = (/ &
        & 0.24563e+02,0.29692e+03,0.40443e+03,0.28305e+03,0.35000e+02 /)
      kbo(:, 2,36, 1) = (/ &
        & 0.24562e+02,0.29677e+03,0.40442e+03,0.28304e+03,0.35000e+02 /)
      kbo(:, 3,36, 1) = (/ &
        & 0.24561e+02,0.29655e+03,0.40440e+03,0.28301e+03,0.35000e+02 /)
      kbo(:, 4,36, 1) = (/ &
        & 0.24560e+02,0.29626e+03,0.40440e+03,0.28302e+03,0.35000e+02 /)
      kbo(:, 5,36, 1) = (/ &
        & 0.24559e+02,0.29589e+03,0.40439e+03,0.28301e+03,0.35000e+02 /)
      kbo(:, 1,37, 1) = (/ &
        & 0.24560e+02,0.29693e+03,0.40439e+03,0.28301e+03,0.35000e+02 /)
      kbo(:, 2,37, 1) = (/ &
        & 0.24559e+02,0.29679e+03,0.40438e+03,0.28299e+03,0.35000e+02 /)
      kbo(:, 3,37, 1) = (/ &
        & 0.24558e+02,0.29658e+03,0.40437e+03,0.28299e+03,0.35000e+02 /)
      kbo(:, 4,37, 1) = (/ &
        & 0.24557e+02,0.29630e+03,0.40437e+03,0.28297e+03,0.35000e+02 /)
      kbo(:, 5,37, 1) = (/ &
        & 0.24556e+02,0.29594e+03,0.40436e+03,0.28297e+03,0.35000e+02 /)
      kbo(:, 1,38, 1) = (/ &
        & 0.24557e+02,0.29695e+03,0.40436e+03,0.28297e+03,0.35000e+02 /)
      kbo(:, 2,38, 1) = (/ &
        & 0.24556e+02,0.29681e+03,0.40436e+03,0.28296e+03,0.35000e+02 /)
      kbo(:, 3,38, 1) = (/ &
        & 0.24555e+02,0.29661e+03,0.40435e+03,0.28297e+03,0.35000e+02 /)
      kbo(:, 4,38, 1) = (/ &
        & 0.24554e+02,0.29634e+03,0.40434e+03,0.28296e+03,0.35000e+02 /)
      kbo(:, 5,38, 1) = (/ &
        & 0.24554e+02,0.29599e+03,0.40434e+03,0.28294e+03,0.35000e+02 /)
      kbo(:, 1,39, 1) = (/ &
        & 0.24554e+02,0.29696e+03,0.40434e+03,0.28295e+03,0.35000e+02 /)
      kbo(:, 2,39, 1) = (/ &
        & 0.24553e+02,0.29683e+03,0.40433e+03,0.28294e+03,0.35000e+02 /)
      kbo(:, 3,39, 1) = (/ &
        & 0.24553e+02,0.29664e+03,0.40433e+03,0.28293e+03,0.35000e+02 /)
      kbo(:, 4,39, 1) = (/ &
        & 0.24552e+02,0.29638e+03,0.40432e+03,0.28292e+03,0.35000e+02 /)
      kbo(:, 5,39, 1) = (/ &
        & 0.24552e+02,0.29604e+03,0.40432e+03,0.28292e+03,0.35000e+02 /)
      kbo(:, 1,40, 1) = (/ &
        & 0.24552e+02,0.29698e+03,0.40432e+03,0.28292e+03,0.35000e+02 /)
      kbo(:, 2,40, 1) = (/ &
        & 0.24551e+02,0.29687e+03,0.40432e+03,0.28293e+03,0.35000e+02 /)
      kbo(:, 3,40, 1) = (/ &
        & 0.24551e+02,0.29669e+03,0.40431e+03,0.28292e+03,0.35000e+02 /)
      kbo(:, 4,40, 1) = (/ &
        & 0.24550e+02,0.29645e+03,0.40431e+03,0.28291e+03,0.35000e+02 /)
      kbo(:, 5,40, 1) = (/ &
        & 0.24550e+02,0.29613e+03,0.40430e+03,0.28291e+03,0.35000e+02 /)
      kbo(:, 1,41, 1) = (/ &
        & 0.24550e+02,0.29699e+03,0.40431e+03,0.28290e+03,0.35000e+02 /)
      kbo(:, 2,41, 1) = (/ &
        & 0.24550e+02,0.29690e+03,0.40430e+03,0.28291e+03,0.35000e+02 /)
      kbo(:, 3,41, 1) = (/ &
        & 0.24549e+02,0.29674e+03,0.40430e+03,0.28289e+03,0.35000e+02 /)
      kbo(:, 4,41, 1) = (/ &
        & 0.24549e+02,0.29651e+03,0.40429e+03,0.28290e+03,0.35000e+02 /)
      kbo(:, 5,41, 1) = (/ &
        & 0.24549e+02,0.29622e+03,0.40429e+03,0.28289e+03,0.35000e+02 /)
      kbo(:, 1,42, 1) = (/ &
        & 0.24549e+02,0.29700e+03,0.40429e+03,0.28289e+03,0.35000e+02 /)
      kbo(:, 2,42, 1) = (/ &
        & 0.24549e+02,0.29693e+03,0.40429e+03,0.28289e+03,0.35000e+02 /)
      kbo(:, 3,42, 1) = (/ &
        & 0.24548e+02,0.29679e+03,0.40429e+03,0.28289e+03,0.35000e+02 /)
      kbo(:, 4,42, 1) = (/ &
        & 0.24548e+02,0.29658e+03,0.40428e+03,0.28289e+03,0.35000e+02 /)
      kbo(:, 5,42, 1) = (/ &
        & 0.24547e+02,0.29630e+03,0.40428e+03,0.28288e+03,0.35000e+02 /)
      kbo(:, 1,43, 1) = (/ &
        & 0.24548e+02,0.29701e+03,0.40428e+03,0.28288e+03,0.35000e+02 /)
      kbo(:, 2,43, 1) = (/ &
        & 0.24547e+02,0.29696e+03,0.40428e+03,0.28288e+03,0.35000e+02 /)
      kbo(:, 3,43, 1) = (/ &
        & 0.24547e+02,0.29684e+03,0.40428e+03,0.28288e+03,0.35000e+02 /)
      kbo(:, 4,43, 1) = (/ &
        & 0.24547e+02,0.29665e+03,0.40427e+03,0.28288e+03,0.35000e+02 /)
      kbo(:, 5,43, 1) = (/ &
        & 0.24547e+02,0.29639e+03,0.40427e+03,0.28288e+03,0.35000e+02 /)
      kbo(:, 1,44, 1) = (/ &
        & 0.24547e+02,0.29702e+03,0.40427e+03,0.28287e+03,0.35000e+02 /)
      kbo(:, 2,44, 1) = (/ &
        & 0.24547e+02,0.29698e+03,0.40427e+03,0.28287e+03,0.35000e+02 /)
      kbo(:, 3,44, 1) = (/ &
        & 0.24546e+02,0.29688e+03,0.40427e+03,0.28287e+03,0.35000e+02 /)
      kbo(:, 4,44, 1) = (/ &
        & 0.24546e+02,0.29672e+03,0.40427e+03,0.28287e+03,0.35000e+02 /)
      kbo(:, 5,44, 1) = (/ &
        & 0.24546e+02,0.29649e+03,0.40426e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 1,45, 1) = (/ &
        & 0.24546e+02,0.29701e+03,0.40427e+03,0.28287e+03,0.35000e+02 /)
      kbo(:, 2,45, 1) = (/ &
        & 0.24546e+02,0.29700e+03,0.40426e+03,0.28287e+03,0.35000e+02 /)
      kbo(:, 3,45, 1) = (/ &
        & 0.24546e+02,0.29692e+03,0.40426e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 4,45, 1) = (/ &
        & 0.24545e+02,0.29678e+03,0.40426e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 5,45, 1) = (/ &
        & 0.24545e+02,0.29657e+03,0.40426e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 1,46, 1) = (/ &
        & 0.24545e+02,0.29699e+03,0.40426e+03,0.28287e+03,0.35000e+02 /)
      kbo(:, 2,46, 1) = (/ &
        & 0.24545e+02,0.29701e+03,0.40426e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 3,46, 1) = (/ &
        & 0.24545e+02,0.29696e+03,0.40426e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 4,46, 1) = (/ &
        & 0.24545e+02,0.29684e+03,0.40425e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 5,46, 1) = (/ &
        & 0.24545e+02,0.29665e+03,0.40425e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 1,47, 1) = (/ &
        & 0.24545e+02,0.29696e+03,0.40425e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 2,47, 1) = (/ &
        & 0.24545e+02,0.29701e+03,0.40425e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 3,47, 1) = (/ &
        & 0.24544e+02,0.29699e+03,0.40425e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 4,47, 1) = (/ &
        & 0.24544e+02,0.29690e+03,0.40425e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 5,47, 1) = (/ &
        & 0.24544e+02,0.29674e+03,0.40425e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 1,48, 1) = (/ &
        & 0.24544e+02,0.29691e+03,0.40425e+03,0.28286e+03,0.35000e+02 /)
      kbo(:, 2,48, 1) = (/ &
        & 0.24544e+02,0.29700e+03,0.40425e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 3,48, 1) = (/ &
        & 0.24544e+02,0.29701e+03,0.40425e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 4,48, 1) = (/ &
        & 0.24544e+02,0.29694e+03,0.40425e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 5,48, 1) = (/ &
        & 0.24544e+02,0.29681e+03,0.40425e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 1,49, 1) = (/ &
        & 0.24544e+02,0.29685e+03,0.40425e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 2,49, 1) = (/ &
        & 0.24544e+02,0.29698e+03,0.40425e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 3,49, 1) = (/ &
        & 0.24544e+02,0.29701e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 4,49, 1) = (/ &
        & 0.24544e+02,0.29697e+03,0.40424e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 5,49, 1) = (/ &
        & 0.24544e+02,0.29687e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 1,50, 1) = (/ &
        & 0.24544e+02,0.29678e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 2,50, 1) = (/ &
        & 0.24544e+02,0.29694e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 3,50, 1) = (/ &
        & 0.24543e+02,0.29701e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 4,50, 1) = (/ &
        & 0.24543e+02,0.29700e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 5,50, 1) = (/ &
        & 0.24543e+02,0.29692e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 1,51, 1) = (/ &
        & 0.24543e+02,0.29670e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 2,51, 1) = (/ &
        & 0.24543e+02,0.29689e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 3,51, 1) = (/ &
        & 0.24543e+02,0.29699e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 4,51, 1) = (/ &
        & 0.24543e+02,0.29701e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 5,51, 1) = (/ &
        & 0.24543e+02,0.29695e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 1,52, 1) = (/ &
        & 0.24543e+02,0.29660e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 2,52, 1) = (/ &
        & 0.24543e+02,0.29684e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 3,52, 1) = (/ &
        & 0.24543e+02,0.29697e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 4,52, 1) = (/ &
        & 0.24543e+02,0.29701e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 5,52, 1) = (/ &
        & 0.24543e+02,0.29698e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 1,53, 1) = (/ &
        & 0.24543e+02,0.29648e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 2,53, 1) = (/ &
        & 0.24543e+02,0.29676e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 3,53, 1) = (/ &
        & 0.24543e+02,0.29693e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 4,53, 1) = (/ &
        & 0.24543e+02,0.29701e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 5,53, 1) = (/ &
        & 0.24543e+02,0.29700e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 1,54, 1) = (/ &
        & 0.24543e+02,0.29635e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 2,54, 1) = (/ &
        & 0.24543e+02,0.29668e+03,0.40424e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 3,54, 1) = (/ &
        & 0.24543e+02,0.29688e+03,0.40424e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 4,54, 1) = (/ &
        & 0.24543e+02,0.29699e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 5,54, 1) = (/ &
        & 0.24543e+02,0.29701e+03,0.40423e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 1,55, 1) = (/ &
        & 0.24543e+02,0.29622e+03,0.40424e+03,0.28285e+03,0.35000e+02 /)
      kbo(:, 2,55, 1) = (/ &
        & 0.24543e+02,0.29659e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 3,55, 1) = (/ &
        & 0.24543e+02,0.29683e+03,0.40423e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 4,55, 1) = (/ &
        & 0.24543e+02,0.29696e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 5,55, 1) = (/ &
        & 0.24543e+02,0.29701e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 1,56, 1) = (/ &
        & 0.24543e+02,0.29607e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 2,56, 1) = (/ &
        & 0.24543e+02,0.29649e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 3,56, 1) = (/ &
        & 0.24543e+02,0.29676e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 4,56, 1) = (/ &
        & 0.24542e+02,0.29693e+03,0.40423e+03,0.28282e+03,0.35000e+02 /)
      kbo(:, 5,56, 1) = (/ &
        & 0.24542e+02,0.29700e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 1,57, 1) = (/ &
        & 0.24543e+02,0.29591e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 2,57, 1) = (/ &
        & 0.24542e+02,0.29637e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 3,57, 1) = (/ &
        & 0.24542e+02,0.29669e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 4,57, 1) = (/ &
        & 0.24542e+02,0.29689e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 5,57, 1) = (/ &
        & 0.24542e+02,0.29699e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 1,58, 1) = (/ &
        & 0.24542e+02,0.29574e+03,0.40423e+03,0.28282e+03,0.35000e+02 /)
      kbo(:, 2,58, 1) = (/ &
        & 0.24542e+02,0.29624e+03,0.40423e+03,0.28282e+03,0.35000e+02 /)
      kbo(:, 3,58, 1) = (/ &
        & 0.24542e+02,0.29660e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 4,58, 1) = (/ &
        & 0.24542e+02,0.29684e+03,0.40423e+03,0.28284e+03,0.35000e+02 /)
      kbo(:, 5,58, 1) = (/ &
        & 0.24542e+02,0.29697e+03,0.40423e+03,0.28282e+03,0.35000e+02 /)
      kbo(:, 1,59, 1) = (/ &
        & 0.24542e+02,0.29566e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 2,59, 1) = (/ &
        & 0.24542e+02,0.29619e+03,0.40423e+03,0.28282e+03,0.35000e+02 /)
      kbo(:, 3,59, 1) = (/ &
        & 0.24542e+02,0.29657e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 4,59, 1) = (/ &
        & 0.24542e+02,0.29682e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 5,59, 1) = (/ &
        & 0.24542e+02,0.29696e+03,0.40423e+03,0.28283e+03,0.35000e+02 /)
      kbo(:, 1,13, 2) = (/ &
        & 0.10177e+03,0.32761e+03,0.45575e+03,0.31335e+03,0.71839e+02 /)
      kbo(:, 2,13, 2) = (/ &
        & 0.10099e+03,0.32713e+03,0.45383e+03,0.31125e+03,0.71839e+02 /)
      kbo(:, 3,13, 2) = (/ &
        & 0.10031e+03,0.32663e+03,0.45216e+03,0.30943e+03,0.71839e+02 /)
      kbo(:, 4,13, 2) = (/ &
        & 0.99721e+02,0.32612e+03,0.45071e+03,0.30785e+03,0.71839e+02 /)
      kbo(:, 5,13, 2) = (/ &
        & 0.99204e+02,0.32558e+03,0.44942e+03,0.30646e+03,0.71839e+02 /)
      kbo(:, 1,14, 2) = (/ &
        & 0.99803e+02,0.32613e+03,0.45091e+03,0.30807e+03,0.71839e+02 /)
      kbo(:, 2,14, 2) = (/ &
        & 0.99169e+02,0.32574e+03,0.44934e+03,0.30636e+03,0.71839e+02 /)
      kbo(:, 3,14, 2) = (/ &
        & 0.98622e+02,0.32534e+03,0.44797e+03,0.30489e+03,0.71839e+02 /)
      kbo(:, 4,14, 2) = (/ &
        & 0.98146e+02,0.32491e+03,0.44677e+03,0.30362e+03,0.71839e+02 /)
      kbo(:, 5,14, 2) = (/ &
        & 0.97728e+02,0.32444e+03,0.44571e+03,0.30248e+03,0.71839e+02 /)
      kbo(:, 1,15, 2) = (/ &
        & 0.98198e+02,0.32493e+03,0.44690e+03,0.30375e+03,0.71839e+02 /)
      kbo(:, 2,15, 2) = (/ &
        & 0.97687e+02,0.32462e+03,0.44560e+03,0.30237e+03,0.71839e+02 /)
      kbo(:, 3,15, 2) = (/ &
        & 0.97245e+02,0.32429e+03,0.44448e+03,0.30119e+03,0.71839e+02 /)
      kbo(:, 4,15, 2) = (/ &
        & 0.96861e+02,0.32392e+03,0.44350e+03,0.30014e+03,0.71839e+02 /)
      kbo(:, 5,15, 2) = (/ &
        & 0.96523e+02,0.32350e+03,0.44263e+03,0.29923e+03,0.71839e+02 /)
      kbo(:, 1,16, 2) = (/ &
        & 0.96892e+02,0.32395e+03,0.44358e+03,0.30023e+03,0.71839e+02 /)
      kbo(:, 2,16, 2) = (/ &
        & 0.96480e+02,0.32371e+03,0.44252e+03,0.29912e+03,0.71839e+02 /)
      kbo(:, 3,16, 2) = (/ &
        & 0.96125e+02,0.32343e+03,0.44161e+03,0.29817e+03,0.71839e+02 /)
      kbo(:, 4,16, 2) = (/ &
        & 0.95814e+02,0.32311e+03,0.44081e+03,0.29733e+03,0.71839e+02 /)
      kbo(:, 5,16, 2) = (/ &
        & 0.95541e+02,0.32273e+03,0.44010e+03,0.29661e+03,0.71839e+02 /)
      kbo(:, 1,17, 2) = (/ &
        & 0.95833e+02,0.32316e+03,0.44086e+03,0.29737e+03,0.71839e+02 /)
      kbo(:, 2,17, 2) = (/ &
        & 0.95501e+02,0.32297e+03,0.44000e+03,0.29648e+03,0.71839e+02 /)
      kbo(:, 3,17, 2) = (/ &
        & 0.95214e+02,0.32274e+03,0.43925e+03,0.29569e+03,0.71839e+02 /)
      kbo(:, 4,17, 2) = (/ &
        & 0.94964e+02,0.32245e+03,0.43860e+03,0.29502e+03,0.71839e+02 /)
      kbo(:, 5,17, 2) = (/ &
        & 0.94743e+02,0.32210e+03,0.43803e+03,0.29442e+03,0.71839e+02 /)
      kbo(:, 1,18, 2) = (/ &
        & 0.94974e+02,0.32251e+03,0.43863e+03,0.29504e+03,0.71839e+02 /)
      kbo(:, 2,18, 2) = (/ &
        & 0.94707e+02,0.32236e+03,0.43793e+03,0.29432e+03,0.71839e+02 /)
      kbo(:, 3,18, 2) = (/ &
        & 0.94475e+02,0.32217e+03,0.43733e+03,0.29369e+03,0.71839e+02 /)
      kbo(:, 4,18, 2) = (/ &
        & 0.94272e+02,0.32191e+03,0.43680e+03,0.29315e+03,0.71839e+02 /)
      kbo(:, 5,18, 2) = (/ &
        & 0.94094e+02,0.32158e+03,0.43633e+03,0.29267e+03,0.71839e+02 /)
      kbo(:, 1,19, 2) = (/ &
        & 0.94277e+02,0.32199e+03,0.43681e+03,0.29316e+03,0.71839e+02 /)
      kbo(:, 2,19, 2) = (/ &
        & 0.94061e+02,0.32187e+03,0.43624e+03,0.29258e+03,0.71839e+02 /)
      kbo(:, 3,19, 2) = (/ &
        & 0.93874e+02,0.32170e+03,0.43575e+03,0.29207e+03,0.71839e+02 /)
      kbo(:, 4,19, 2) = (/ &
        & 0.93711e+02,0.32146e+03,0.43532e+03,0.29164e+03,0.71839e+02 /)
      kbo(:, 5,19, 2) = (/ &
        & 0.93566e+02,0.32115e+03,0.43494e+03,0.29125e+03,0.71839e+02 /)
      kbo(:, 1,20, 2) = (/ &
        & 0.93708e+02,0.32157e+03,0.43531e+03,0.29163e+03,0.71839e+02 /)
      kbo(:, 2,20, 2) = (/ &
        & 0.93534e+02,0.32147e+03,0.43485e+03,0.29117e+03,0.71839e+02 /)
      kbo(:, 3,20, 2) = (/ &
        & 0.93383e+02,0.32132e+03,0.43445e+03,0.29076e+03,0.71839e+02 /)
      kbo(:, 4,20, 2) = (/ &
        & 0.93251e+02,0.32109e+03,0.43411e+03,0.29041e+03,0.71839e+02 /)
      kbo(:, 5,20, 2) = (/ &
        & 0.93135e+02,0.32079e+03,0.43380e+03,0.29010e+03,0.71839e+02 /)
      kbo(:, 1,21, 2) = (/ &
        & 0.93246e+02,0.32122e+03,0.43409e+03,0.29040e+03,0.71839e+02 /)
      kbo(:, 2,21, 2) = (/ &
        & 0.93106e+02,0.32114e+03,0.43372e+03,0.29003e+03,0.71839e+02 /)
      kbo(:, 3,21, 2) = (/ &
        & 0.92985e+02,0.32100e+03,0.43340e+03,0.28970e+03,0.71839e+02 /)
      kbo(:, 4,21, 2) = (/ &
        & 0.92878e+02,0.32079e+03,0.43311e+03,0.28941e+03,0.71839e+02 /)
      kbo(:, 5,21, 2) = (/ &
        & 0.92784e+02,0.32049e+03,0.43286e+03,0.28917e+03,0.71839e+02 /)
      kbo(:, 1,22, 2) = (/ &
        & 0.92863e+02,0.32094e+03,0.43307e+03,0.28938e+03,0.71839e+02 /)
      kbo(:, 2,22, 2) = (/ &
        & 0.92751e+02,0.32087e+03,0.43278e+03,0.28908e+03,0.71839e+02 /)
      kbo(:, 3,22, 2) = (/ &
        & 0.92655e+02,0.32073e+03,0.43252e+03,0.28882e+03,0.71839e+02 /)
      kbo(:, 4,22, 2) = (/ &
        & 0.92569e+02,0.32051e+03,0.43229e+03,0.28860e+03,0.71839e+02 /)
      kbo(:, 5,22, 2) = (/ &
        & 0.92494e+02,0.32022e+03,0.43209e+03,0.28840e+03,0.71839e+02 /)
      kbo(:, 1,23, 2) = (/ &
        & 0.92553e+02,0.32072e+03,0.43225e+03,0.28855e+03,0.71839e+02 /)
      kbo(:, 2,23, 2) = (/ &
        & 0.92465e+02,0.32064e+03,0.43201e+03,0.28832e+03,0.71839e+02 /)
      kbo(:, 3,23, 2) = (/ &
        & 0.92387e+02,0.32050e+03,0.43180e+03,0.28811e+03,0.71839e+02 /)
      kbo(:, 4,23, 2) = (/ &
        & 0.92319e+02,0.32029e+03,0.43162e+03,0.28793e+03,0.71839e+02 /)
      kbo(:, 5,23, 2) = (/ &
        & 0.92259e+02,0.31998e+03,0.43146e+03,0.28778e+03,0.71839e+02 /)
      kbo(:, 1,24, 2) = (/ &
        & 0.92303e+02,0.32053e+03,0.43158e+03,0.28789e+03,0.71839e+02 /)
      kbo(:, 2,24, 2) = (/ &
        & 0.92233e+02,0.32046e+03,0.43139e+03,0.28770e+03,0.71839e+02 /)
      kbo(:, 3,24, 2) = (/ &
        & 0.92171e+02,0.32031e+03,0.43122e+03,0.28754e+03,0.71839e+02 /)
      kbo(:, 4,24, 2) = (/ &
        & 0.92117e+02,0.32009e+03,0.43108e+03,0.28740e+03,0.71839e+02 /)
      kbo(:, 5,24, 2) = (/ &
        & 0.92068e+02,0.31978e+03,0.43095e+03,0.28727e+03,0.71839e+02 /)
      kbo(:, 1,25, 2) = (/ &
        & 0.92101e+02,0.32038e+03,0.43103e+03,0.28736e+03,0.71839e+02 /)
      kbo(:, 2,25, 2) = (/ &
        & 0.92045e+02,0.32030e+03,0.43088e+03,0.28721e+03,0.71839e+02 /)
      kbo(:, 3,25, 2) = (/ &
        & 0.91996e+02,0.32015e+03,0.43075e+03,0.28708e+03,0.71839e+02 /)
      kbo(:, 4,25, 2) = (/ &
        & 0.91952e+02,0.31991e+03,0.43064e+03,0.28696e+03,0.71839e+02 /)
      kbo(:, 5,25, 2) = (/ &
        & 0.91914e+02,0.31959e+03,0.43053e+03,0.28684e+03,0.71839e+02 /)
      kbo(:, 1,26, 2) = (/ &
        & 0.91937e+02,0.32025e+03,0.43059e+03,0.28693e+03,0.71839e+02 /)
      kbo(:, 2,26, 2) = (/ &
        & 0.91892e+02,0.32016e+03,0.43047e+03,0.28680e+03,0.71839e+02 /)
      kbo(:, 3,26, 2) = (/ &
        & 0.91853e+02,0.32000e+03,0.43037e+03,0.28670e+03,0.71839e+02 /)
      kbo(:, 4,26, 2) = (/ &
        & 0.91819e+02,0.31975e+03,0.43028e+03,0.28661e+03,0.71839e+02 /)
      kbo(:, 5,26, 2) = (/ &
        & 0.91788e+02,0.31942e+03,0.43019e+03,0.28653e+03,0.71839e+02 /)
      kbo(:, 1,27, 2) = (/ &
        & 0.91805e+02,0.32015e+03,0.43024e+03,0.28658e+03,0.71839e+02 /)
      kbo(:, 2,27, 2) = (/ &
        & 0.91770e+02,0.32005e+03,0.43014e+03,0.28648e+03,0.71839e+02 /)
      kbo(:, 3,27, 2) = (/ &
        & 0.91738e+02,0.31986e+03,0.43006e+03,0.28630e+03,0.71839e+02 /)
      kbo(:, 4,27, 2) = (/ &
        & 0.91711e+02,0.31960e+03,0.42998e+03,0.28633e+03,0.71839e+02 /)
      kbo(:, 5,27, 2) = (/ &
        & 0.91687e+02,0.31925e+03,0.42992e+03,0.28626e+03,0.71839e+02 /)
      kbo(:, 1,28, 2) = (/ &
        & 0.91698e+02,0.32005e+03,0.42995e+03,0.28628e+03,0.71839e+02 /)
      kbo(:, 2,28, 2) = (/ &
        & 0.91670e+02,0.31994e+03,0.42987e+03,0.28622e+03,0.71839e+02 /)
      kbo(:, 3,28, 2) = (/ &
        & 0.91646e+02,0.31974e+03,0.42981e+03,0.28615e+03,0.71839e+02 /)
      kbo(:, 4,28, 2) = (/ &
        & 0.91624e+02,0.31946e+03,0.42975e+03,0.28609e+03,0.71839e+02 /)
      kbo(:, 5,28, 2) = (/ &
        & 0.91604e+02,0.31910e+03,0.42970e+03,0.28605e+03,0.71839e+02 /)
      kbo(:, 1,29, 2) = (/ &
        & 0.91613e+02,0.31997e+03,0.42972e+03,0.28605e+03,0.71839e+02 /)
      kbo(:, 2,29, 2) = (/ &
        & 0.91591e+02,0.31984e+03,0.42966e+03,0.28600e+03,0.71839e+02 /)
      kbo(:, 3,29, 2) = (/ &
        & 0.91571e+02,0.31963e+03,0.42960e+03,0.28595e+03,0.71839e+02 /)
      kbo(:, 4,29, 2) = (/ &
        & 0.91554e+02,0.31933e+03,0.42956e+03,0.28590e+03,0.71839e+02 /)
      kbo(:, 5,29, 2) = (/ &
        & 0.91538e+02,0.31895e+03,0.42952e+03,0.28586e+03,0.71839e+02 /)
      kbo(:, 1,30, 2) = (/ &
        & 0.91544e+02,0.31990e+03,0.42953e+03,0.28589e+03,0.71839e+02 /)
      kbo(:, 2,30, 2) = (/ &
        & 0.91526e+02,0.31975e+03,0.42948e+03,0.28584e+03,0.71839e+02 /)
      kbo(:, 3,30, 2) = (/ &
        & 0.91511e+02,0.31952e+03,0.42944e+03,0.28580e+03,0.71839e+02 /)
      kbo(:, 4,30, 2) = (/ &
        & 0.91497e+02,0.31920e+03,0.42940e+03,0.28577e+03,0.71839e+02 /)
      kbo(:, 5,30, 2) = (/ &
        & 0.91484e+02,0.31880e+03,0.42937e+03,0.28573e+03,0.71839e+02 /)
      kbo(:, 1,31, 2) = (/ &
        & 0.91488e+02,0.31983e+03,0.42938e+03,0.28574e+03,0.71839e+02 /)
      kbo(:, 2,31, 2) = (/ &
        & 0.91474e+02,0.31966e+03,0.42934e+03,0.28571e+03,0.71839e+02 /)
      kbo(:, 3,31, 2) = (/ &
        & 0.91462e+02,0.31941e+03,0.42931e+03,0.28567e+03,0.71839e+02 /)
      kbo(:, 4,31, 2) = (/ &
        & 0.91451e+02,0.31908e+03,0.42928e+03,0.28564e+03,0.71839e+02 /)
      kbo(:, 5,31, 2) = (/ &
        & 0.91441e+02,0.31866e+03,0.42925e+03,0.28562e+03,0.71839e+02 /)
      kbo(:, 1,32, 2) = (/ &
        & 0.91443e+02,0.31976e+03,0.42926e+03,0.28562e+03,0.71839e+02 /)
      kbo(:, 2,32, 2) = (/ &
        & 0.91432e+02,0.31958e+03,0.42923e+03,0.28559e+03,0.71839e+02 /)
      kbo(:, 3,32, 2) = (/ &
        & 0.91423e+02,0.31930e+03,0.42920e+03,0.28557e+03,0.71839e+02 /)
      kbo(:, 4,32, 2) = (/ &
        & 0.91414e+02,0.31895e+03,0.42918e+03,0.28555e+03,0.71839e+02 /)
      kbo(:, 5,32, 2) = (/ &
        & 0.91406e+02,0.31851e+03,0.42916e+03,0.28551e+03,0.71839e+02 /)
      kbo(:, 1,33, 2) = (/ &
        & 0.91407e+02,0.31970e+03,0.42916e+03,0.28553e+03,0.71839e+02 /)
      kbo(:, 2,33, 2) = (/ &
        & 0.91399e+02,0.31949e+03,0.42914e+03,0.28551e+03,0.71839e+02 /)
      kbo(:, 3,33, 2) = (/ &
        & 0.91391e+02,0.31920e+03,0.42912e+03,0.28549e+03,0.71839e+02 /)
      kbo(:, 4,33, 2) = (/ &
        & 0.91384e+02,0.31882e+03,0.42910e+03,0.28547e+03,0.71839e+02 /)
      kbo(:, 5,33, 2) = (/ &
        & 0.91378e+02,0.31837e+03,0.42908e+03,0.28546e+03,0.71839e+02 /)
      kbo(:, 1,34, 2) = (/ &
        & 0.91379e+02,0.31964e+03,0.42908e+03,0.28546e+03,0.71839e+02 /)
      kbo(:, 2,34, 2) = (/ &
        & 0.91372e+02,0.31941e+03,0.42906e+03,0.28544e+03,0.71839e+02 /)
      kbo(:, 3,34, 2) = (/ &
        & 0.91365e+02,0.31910e+03,0.42905e+03,0.28542e+03,0.71839e+02 /)
      kbo(:, 4,34, 2) = (/ &
        & 0.91360e+02,0.31871e+03,0.42903e+03,0.28541e+03,0.71839e+02 /)
      kbo(:, 5,34, 2) = (/ &
        & 0.91355e+02,0.31824e+03,0.42902e+03,0.28540e+03,0.71839e+02 /)
      kbo(:, 1,35, 2) = (/ &
        & 0.91356e+02,0.31960e+03,0.42902e+03,0.28539e+03,0.71839e+02 /)
      kbo(:, 2,35, 2) = (/ &
        & 0.91350e+02,0.31936e+03,0.42901e+03,0.28538e+03,0.71839e+02 /)
      kbo(:, 3,35, 2) = (/ &
        & 0.91345e+02,0.31904e+03,0.42899e+03,0.28537e+03,0.71839e+02 /)
      kbo(:, 4,35, 2) = (/ &
        & 0.91341e+02,0.31863e+03,0.42898e+03,0.28535e+03,0.71839e+02 /)
      kbo(:, 5,35, 2) = (/ &
        & 0.91337e+02,0.31816e+03,0.42897e+03,0.28535e+03,0.71839e+02 /)
      kbo(:, 1,36, 2) = (/ &
        & 0.91338e+02,0.31958e+03,0.42897e+03,0.28535e+03,0.71839e+02 /)
      kbo(:, 2,36, 2) = (/ &
        & 0.91334e+02,0.31934e+03,0.42896e+03,0.28533e+03,0.71839e+02 /)
      kbo(:, 3,36, 2) = (/ &
        & 0.91330e+02,0.31902e+03,0.42895e+03,0.28533e+03,0.71839e+02 /)
      kbo(:, 4,36, 2) = (/ &
        & 0.91326e+02,0.31862e+03,0.42894e+03,0.28530e+03,0.71839e+02 /)
      kbo(:, 5,36, 2) = (/ &
        & 0.91323e+02,0.31814e+03,0.42893e+03,0.28530e+03,0.71839e+02 /)
      kbo(:, 1,37, 2) = (/ &
        & 0.91324e+02,0.31959e+03,0.42894e+03,0.28531e+03,0.71839e+02 /)
      kbo(:, 2,37, 2) = (/ &
        & 0.91320e+02,0.31937e+03,0.42893e+03,0.28530e+03,0.71839e+02 /)
      kbo(:, 3,37, 2) = (/ &
        & 0.91317e+02,0.31906e+03,0.42892e+03,0.28529e+03,0.71839e+02 /)
      kbo(:, 4,37, 2) = (/ &
        & 0.91314e+02,0.31866e+03,0.42891e+03,0.28529e+03,0.71839e+02 /)
      kbo(:, 5,37, 2) = (/ &
        & 0.91311e+02,0.31819e+03,0.42890e+03,0.28527e+03,0.71839e+02 /)
      kbo(:, 1,38, 2) = (/ &
        & 0.91313e+02,0.31961e+03,0.42890e+03,0.28528e+03,0.71839e+02 /)
      kbo(:, 2,38, 2) = (/ &
        & 0.91310e+02,0.31939e+03,0.42890e+03,0.28528e+03,0.71839e+02 /)
      kbo(:, 3,38, 2) = (/ &
        & 0.91307e+02,0.31910e+03,0.42889e+03,0.28526e+03,0.71839e+02 /)
      kbo(:, 4,38, 2) = (/ &
        & 0.91304e+02,0.31871e+03,0.42888e+03,0.28525e+03,0.71839e+02 /)
      kbo(:, 5,38, 2) = (/ &
        & 0.91302e+02,0.31826e+03,0.42888e+03,0.28525e+03,0.71839e+02 /)
      kbo(:, 1,39, 2) = (/ &
        & 0.91303e+02,0.31962e+03,0.42888e+03,0.28525e+03,0.71839e+02 /)
      kbo(:, 2,39, 2) = (/ &
        & 0.91301e+02,0.31942e+03,0.42887e+03,0.28525e+03,0.71839e+02 /)
      kbo(:, 3,39, 2) = (/ &
        & 0.91298e+02,0.31914e+03,0.42886e+03,0.28525e+03,0.71839e+02 /)
      kbo(:, 4,39, 2) = (/ &
        & 0.91296e+02,0.31877e+03,0.42886e+03,0.28524e+03,0.71839e+02 /)
      kbo(:, 5,39, 2) = (/ &
        & 0.91294e+02,0.31832e+03,0.42885e+03,0.28523e+03,0.71839e+02 /)
      kbo(:, 1,40, 2) = (/ &
        & 0.91296e+02,0.31965e+03,0.42886e+03,0.28524e+03,0.71839e+02 /)
      kbo(:, 2,40, 2) = (/ &
        & 0.91293e+02,0.31947e+03,0.42885e+03,0.28522e+03,0.71839e+02 /)
      kbo(:, 3,40, 2) = (/ &
        & 0.91292e+02,0.31921e+03,0.42885e+03,0.28522e+03,0.71839e+02 /)
      kbo(:, 4,40, 2) = (/ &
        & 0.91290e+02,0.31886e+03,0.42884e+03,0.28522e+03,0.71839e+02 /)
      kbo(:, 5,40, 2) = (/ &
        & 0.91288e+02,0.31843e+03,0.42884e+03,0.28521e+03,0.71839e+02 /)
      kbo(:, 1,41, 2) = (/ &
        & 0.91289e+02,0.31968e+03,0.42884e+03,0.28523e+03,0.71839e+02 /)
      kbo(:, 2,41, 2) = (/ &
        & 0.91288e+02,0.31952e+03,0.42884e+03,0.28521e+03,0.71839e+02 /)
      kbo(:, 3,41, 2) = (/ &
        & 0.91286e+02,0.31928e+03,0.42883e+03,0.28522e+03,0.71839e+02 /)
      kbo(:, 4,41, 2) = (/ &
        & 0.91284e+02,0.31895e+03,0.42883e+03,0.28521e+03,0.71839e+02 /)
      kbo(:, 5,41, 2) = (/ &
        & 0.91283e+02,0.31854e+03,0.42882e+03,0.28521e+03,0.71839e+02 /)
      kbo(:, 1,42, 2) = (/ &
        & 0.91284e+02,0.31970e+03,0.42883e+03,0.28521e+03,0.71839e+02 /)
      kbo(:, 2,42, 2) = (/ &
        & 0.91283e+02,0.31957e+03,0.42882e+03,0.28521e+03,0.71839e+02 /)
      kbo(:, 3,42, 2) = (/ &
        & 0.91281e+02,0.31934e+03,0.42882e+03,0.28520e+03,0.71839e+02 /)
      kbo(:, 4,42, 2) = (/ &
        & 0.91280e+02,0.31904e+03,0.42882e+03,0.28519e+03,0.71839e+02 /)
      kbo(:, 5,42, 2) = (/ &
        & 0.91279e+02,0.31865e+03,0.42881e+03,0.28520e+03,0.71839e+02 /)
      kbo(:, 1,43, 2) = (/ &
        & 0.91280e+02,0.31972e+03,0.42882e+03,0.28520e+03,0.71839e+02 /)
      kbo(:, 2,43, 2) = (/ &
        & 0.91279e+02,0.31961e+03,0.42881e+03,0.28520e+03,0.71839e+02 /)
      kbo(:, 3,43, 2) = (/ &
        & 0.91277e+02,0.31942e+03,0.42881e+03,0.28519e+03,0.71839e+02 /)
      kbo(:, 4,43, 2) = (/ &
        & 0.91276e+02,0.31914e+03,0.42881e+03,0.28518e+03,0.71839e+02 /)
      kbo(:, 5,43, 2) = (/ &
        & 0.91275e+02,0.31878e+03,0.42880e+03,0.28518e+03,0.71839e+02 /)
      kbo(:, 1,44, 2) = (/ &
        & 0.91276e+02,0.31974e+03,0.42881e+03,0.28519e+03,0.71839e+02 /)
      kbo(:, 2,44, 2) = (/ &
        & 0.91275e+02,0.31966e+03,0.42880e+03,0.28519e+03,0.71839e+02 /)
      kbo(:, 3,44, 2) = (/ &
        & 0.91274e+02,0.31949e+03,0.42880e+03,0.28518e+03,0.71839e+02 /)
      kbo(:, 4,44, 2) = (/ &
        & 0.91273e+02,0.31924e+03,0.42880e+03,0.28518e+03,0.71839e+02 /)
      kbo(:, 5,44, 2) = (/ &
        & 0.91273e+02,0.31890e+03,0.42880e+03,0.28518e+03,0.71839e+02 /)
      kbo(:, 1,45, 2) = (/ &
        & 0.91274e+02,0.31974e+03,0.42880e+03,0.28518e+03,0.71839e+02 /)
      kbo(:, 2,45, 2) = (/ &
        & 0.91273e+02,0.31969e+03,0.42880e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 3,45, 2) = (/ &
        & 0.91272e+02,0.31955e+03,0.42879e+03,0.28518e+03,0.71839e+02 /)
      kbo(:, 4,45, 2) = (/ &
        & 0.91271e+02,0.31933e+03,0.42879e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 5,45, 2) = (/ &
        & 0.91270e+02,0.31903e+03,0.42879e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 1,46, 2) = (/ &
        & 0.91271e+02,0.31974e+03,0.42879e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 2,46, 2) = (/ &
        & 0.91270e+02,0.31972e+03,0.42879e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 3,46, 2) = (/ &
        & 0.91270e+02,0.31961e+03,0.42879e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 4,46, 2) = (/ &
        & 0.91269e+02,0.31942e+03,0.42879e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 5,46, 2) = (/ &
        & 0.91268e+02,0.31914e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 1,47, 2) = (/ &
        & 0.91269e+02,0.31973e+03,0.42879e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 2,47, 2) = (/ &
        & 0.91268e+02,0.31974e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 3,47, 2) = (/ &
        & 0.91268e+02,0.31966e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 4,47, 2) = (/ &
        & 0.91267e+02,0.31951e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 5,47, 2) = (/ &
        & 0.91267e+02,0.31926e+03,0.42878e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,48, 2) = (/ &
        & 0.91267e+02,0.31970e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 2,48, 2) = (/ &
        & 0.91267e+02,0.31974e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 3,48, 2) = (/ &
        & 0.91266e+02,0.31970e+03,0.42878e+03,0.28517e+03,0.71839e+02 /)
      kbo(:, 4,48, 2) = (/ &
        & 0.91266e+02,0.31958e+03,0.42878e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,48, 2) = (/ &
        & 0.91265e+02,0.31937e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 1,49, 2) = (/ &
        & 0.91266e+02,0.31966e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 2,49, 2) = (/ &
        & 0.91265e+02,0.31973e+03,0.42878e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 3,49, 2) = (/ &
        & 0.91265e+02,0.31973e+03,0.42877e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 4,49, 2) = (/ &
        & 0.91265e+02,0.31964e+03,0.42878e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,49, 2) = (/ &
        & 0.91264e+02,0.31946e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,50, 2) = (/ &
        & 0.91265e+02,0.31962e+03,0.42877e+03,0.28516e+03,0.71839e+02 /)
      kbo(:, 2,50, 2) = (/ &
        & 0.91264e+02,0.31972e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,50, 2) = (/ &
        & 0.91264e+02,0.31974e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,50, 2) = (/ &
        & 0.91264e+02,0.31968e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,50, 2) = (/ &
        & 0.91263e+02,0.31954e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,51, 2) = (/ &
        & 0.91264e+02,0.31958e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 2,51, 2) = (/ &
        & 0.91263e+02,0.31969e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,51, 2) = (/ &
        & 0.91263e+02,0.31974e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,51, 2) = (/ &
        & 0.91263e+02,0.31971e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,51, 2) = (/ &
        & 0.91262e+02,0.31960e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,52, 2) = (/ &
        & 0.91263e+02,0.31953e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 2,52, 2) = (/ &
        & 0.91263e+02,0.31965e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,52, 2) = (/ &
        & 0.91262e+02,0.31973e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,52, 2) = (/ &
        & 0.91262e+02,0.31973e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,52, 2) = (/ &
        & 0.91262e+02,0.31965e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,53, 2) = (/ &
        & 0.91262e+02,0.31948e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 2,53, 2) = (/ &
        & 0.91262e+02,0.31961e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,53, 2) = (/ &
        & 0.91262e+02,0.31971e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,53, 2) = (/ &
        & 0.91261e+02,0.31974e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,53, 2) = (/ &
        & 0.91261e+02,0.31969e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 1,54, 2) = (/ &
        & 0.91262e+02,0.31942e+03,0.42877e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 2,54, 2) = (/ &
        & 0.91261e+02,0.31957e+03,0.42877e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 3,54, 2) = (/ &
        & 0.91261e+02,0.31968e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,54, 2) = (/ &
        & 0.91261e+02,0.31973e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,54, 2) = (/ &
        & 0.91261e+02,0.31971e+03,0.42876e+03,0.28513e+03,0.71839e+02 /)
      kbo(:, 1,55, 2) = (/ &
        & 0.91261e+02,0.31937e+03,0.42876e+03,0.28513e+03,0.71839e+02 /)
      kbo(:, 2,55, 2) = (/ &
        & 0.91261e+02,0.31953e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,55, 2) = (/ &
        & 0.91261e+02,0.31965e+03,0.42876e+03,0.28513e+03,0.71839e+02 /)
      kbo(:, 4,55, 2) = (/ &
        & 0.91261e+02,0.31973e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 5,55, 2) = (/ &
        & 0.91260e+02,0.31973e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,56, 2) = (/ &
        & 0.91261e+02,0.31932e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 2,56, 2) = (/ &
        & 0.91260e+02,0.31947e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,56, 2) = (/ &
        & 0.91260e+02,0.31961e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,56, 2) = (/ &
        & 0.91260e+02,0.31971e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 5,56, 2) = (/ &
        & 0.91260e+02,0.31974e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,57, 2) = (/ &
        & 0.91260e+02,0.31927e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 2,57, 2) = (/ &
        & 0.91260e+02,0.31943e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 3,57, 2) = (/ &
        & 0.91260e+02,0.31957e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,57, 2) = (/ &
        & 0.91260e+02,0.31968e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 5,57, 2) = (/ &
        & 0.91260e+02,0.31974e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 1,58, 2) = (/ &
        & 0.91260e+02,0.31922e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 2,58, 2) = (/ &
        & 0.91260e+02,0.31938e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,58, 2) = (/ &
        & 0.91260e+02,0.31953e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 4,58, 2) = (/ &
        & 0.91260e+02,0.31965e+03,0.42876e+03,0.28513e+03,0.71839e+02 /)
      kbo(:, 5,58, 2) = (/ &
        & 0.91260e+02,0.31973e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 1,59, 2) = (/ &
        & 0.91260e+02,0.31920e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 2,59, 2) = (/ &
        & 0.91260e+02,0.31936e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 3,59, 2) = (/ &
        & 0.91259e+02,0.31952e+03,0.42876e+03,0.28515e+03,0.71839e+02 /)
      kbo(:, 4,59, 2) = (/ &
        & 0.91259e+02,0.31964e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 5,59, 2) = (/ &
        & 0.91259e+02,0.31972e+03,0.42876e+03,0.28514e+03,0.71839e+02 /)
      kbo(:, 1,13, 3) = (/ &
        & 0.26463e+03,0.36163e+03,0.49889e+03,0.32504e+03,0.17829e+03 /)
      kbo(:, 2,13, 3) = (/ &
        & 0.26258e+03,0.36010e+03,0.49695e+03,0.32345e+03,0.17829e+03 /)
      kbo(:, 3,13, 3) = (/ &
        & 0.26083e+03,0.35879e+03,0.49519e+03,0.32209e+03,0.17829e+03 /)
      kbo(:, 4,13, 3) = (/ &
        & 0.25930e+03,0.35766e+03,0.49360e+03,0.32093e+03,0.17829e+03 /)
      kbo(:, 5,13, 3) = (/ &
        & 0.25795e+03,0.35666e+03,0.49217e+03,0.31991e+03,0.17829e+03 /)
      kbo(:, 1,14, 3) = (/ &
        & 0.25951e+03,0.35782e+03,0.49358e+03,0.32109e+03,0.17829e+03 /)
      kbo(:, 2,14, 3) = (/ &
        & 0.25786e+03,0.35659e+03,0.49191e+03,0.31984e+03,0.17829e+03 /)
      kbo(:, 3,14, 3) = (/ &
        & 0.25644e+03,0.35554e+03,0.49043e+03,0.31877e+03,0.17829e+03 /)
      kbo(:, 4,14, 3) = (/ &
        & 0.25520e+03,0.35461e+03,0.48912e+03,0.31784e+03,0.17829e+03 /)
      kbo(:, 5,14, 3) = (/ &
        & 0.25411e+03,0.35381e+03,0.48795e+03,0.31704e+03,0.17829e+03 /)
      kbo(:, 1,15, 3) = (/ &
        & 0.25534e+03,0.35471e+03,0.48908e+03,0.31794e+03,0.17829e+03 /)
      kbo(:, 2,15, 3) = (/ &
        & 0.25401e+03,0.35373e+03,0.48771e+03,0.31695e+03,0.17829e+03 /)
      kbo(:, 3,15, 3) = (/ &
        & 0.25286e+03,0.35287e+03,0.48651e+03,0.31610e+03,0.17829e+03 /)
      kbo(:, 4,15, 3) = (/ &
        & 0.25186e+03,0.35213e+03,0.48543e+03,0.31537e+03,0.17829e+03 /)
      kbo(:, 5,15, 3) = (/ &
        & 0.25098e+03,0.35147e+03,0.48447e+03,0.31472e+03,0.17829e+03 /)
      kbo(:, 1,16, 3) = (/ &
        & 0.25194e+03,0.35219e+03,0.48538e+03,0.31543e+03,0.17829e+03 /)
      kbo(:, 2,16, 3) = (/ &
        & 0.25087e+03,0.35140e+03,0.48427e+03,0.31463e+03,0.17829e+03 /)
      kbo(:, 3,16, 3) = (/ &
        & 0.24994e+03,0.35071e+03,0.48328e+03,0.31395e+03,0.17829e+03 /)
      kbo(:, 4,16, 3) = (/ &
        & 0.24914e+03,0.35011e+03,0.48239e+03,0.31337e+03,0.17829e+03 /)
      kbo(:, 5,16, 3) = (/ &
        & 0.24843e+03,0.34958e+03,0.48159e+03,0.31282e+03,0.17829e+03 /)
      kbo(:, 1,17, 3) = (/ &
        & 0.24919e+03,0.35014e+03,0.48236e+03,0.31341e+03,0.17829e+03 /)
      kbo(:, 2,17, 3) = (/ &
        & 0.24832e+03,0.34950e+03,0.48145e+03,0.31278e+03,0.17829e+03 /)
      kbo(:, 3,17, 3) = (/ &
        & 0.24758e+03,0.34895e+03,0.48063e+03,0.31225e+03,0.17829e+03 /)
      kbo(:, 4,17, 3) = (/ &
        & 0.24693e+03,0.34847e+03,0.47989e+03,0.31178e+03,0.17829e+03 /)
      kbo(:, 5,17, 3) = (/ &
        & 0.24635e+03,0.34804e+03,0.47924e+03,0.31137e+03,0.17829e+03 /)
      kbo(:, 1,18, 3) = (/ &
        & 0.24695e+03,0.34848e+03,0.47988e+03,0.31180e+03,0.17829e+03 /)
      kbo(:, 2,18, 3) = (/ &
        & 0.24626e+03,0.34797e+03,0.47913e+03,0.31130e+03,0.17829e+03 /)
      kbo(:, 3,18, 3) = (/ &
        & 0.24565e+03,0.34752e+03,0.47845e+03,0.31086e+03,0.17829e+03 /)
      kbo(:, 4,18, 3) = (/ &
        & 0.24513e+03,0.34713e+03,0.47784e+03,0.31048e+03,0.17829e+03 /)
      kbo(:, 5,18, 3) = (/ &
        & 0.24466e+03,0.34679e+03,0.47731e+03,0.31015e+03,0.17829e+03 /)
      kbo(:, 1,19, 3) = (/ &
        & 0.24514e+03,0.34714e+03,0.47784e+03,0.31049e+03,0.17829e+03 /)
      kbo(:, 2,19, 3) = (/ &
        & 0.24458e+03,0.34672e+03,0.47721e+03,0.31009e+03,0.17829e+03 /)
      kbo(:, 3,19, 3) = (/ &
        & 0.24409e+03,0.34636e+03,0.47665e+03,0.30974e+03,0.17829e+03 /)
      kbo(:, 4,19, 3) = (/ &
        & 0.24367e+03,0.34605e+03,0.47616e+03,0.30943e+03,0.17829e+03 /)
      kbo(:, 5,19, 3) = (/ &
        & 0.24329e+03,0.34577e+03,0.47573e+03,0.30916e+03,0.17829e+03 /)
      kbo(:, 1,20, 3) = (/ &
        & 0.24366e+03,0.34604e+03,0.47615e+03,0.30943e+03,0.17829e+03 /)
      kbo(:, 2,20, 3) = (/ &
        & 0.24321e+03,0.34571e+03,0.47563e+03,0.30910e+03,0.17829e+03 /)
      kbo(:, 3,20, 3) = (/ &
        & 0.24282e+03,0.34542e+03,0.47518e+03,0.30882e+03,0.17829e+03 /)
      kbo(:, 4,20, 3) = (/ &
        & 0.24247e+03,0.34516e+03,0.47478e+03,0.30857e+03,0.17829e+03 /)
      kbo(:, 5,20, 3) = (/ &
        & 0.24217e+03,0.34494e+03,0.47443e+03,0.30835e+03,0.17829e+03 /)
      kbo(:, 1,21, 3) = (/ &
        & 0.24246e+03,0.34515e+03,0.47476e+03,0.30856e+03,0.17829e+03 /)
      kbo(:, 2,21, 3) = (/ &
        & 0.24210e+03,0.34488e+03,0.47434e+03,0.30830e+03,0.17829e+03 /)
      kbo(:, 3,21, 3) = (/ &
        & 0.24178e+03,0.34465e+03,0.47397e+03,0.30807e+03,0.17829e+03 /)
      kbo(:, 4,21, 3) = (/ &
        & 0.24150e+03,0.34444e+03,0.47364e+03,0.30787e+03,0.17829e+03 /)
      kbo(:, 5,21, 3) = (/ &
        & 0.24126e+03,0.34426e+03,0.47341e+03,0.30769e+03,0.17829e+03 /)
      kbo(:, 1,22, 3) = (/ &
        & 0.24146e+03,0.34441e+03,0.47360e+03,0.30784e+03,0.17829e+03 /)
      kbo(:, 2,22, 3) = (/ &
        & 0.24117e+03,0.34420e+03,0.47327e+03,0.30763e+03,0.17829e+03 /)
      kbo(:, 3,22, 3) = (/ &
        & 0.24092e+03,0.34401e+03,0.47296e+03,0.30745e+03,0.17829e+03 /)
      kbo(:, 4,22, 3) = (/ &
        & 0.24070e+03,0.34385e+03,0.47270e+03,0.30729e+03,0.17829e+03 /)
      kbo(:, 5,22, 3) = (/ &
        & 0.24050e+03,0.34370e+03,0.47246e+03,0.30715e+03,0.17829e+03 /)
      kbo(:, 1,23, 3) = (/ &
        & 0.24066e+03,0.34382e+03,0.47265e+03,0.30726e+03,0.17829e+03 /)
      kbo(:, 2,23, 3) = (/ &
        & 0.24043e+03,0.34365e+03,0.47237e+03,0.30709e+03,0.17829e+03 /)
      kbo(:, 3,23, 3) = (/ &
        & 0.24023e+03,0.34350e+03,0.47213e+03,0.30695e+03,0.17829e+03 /)
      kbo(:, 4,23, 3) = (/ &
        & 0.24005e+03,0.34336e+03,0.47191e+03,0.30682e+03,0.17829e+03 /)
      kbo(:, 5,23, 3) = (/ &
        & 0.23989e+03,0.34325e+03,0.47173e+03,0.30671e+03,0.17829e+03 /)
      kbo(:, 1,24, 3) = (/ &
        & 0.24001e+03,0.34333e+03,0.47187e+03,0.30679e+03,0.17829e+03 /)
      kbo(:, 2,24, 3) = (/ &
        & 0.23982e+03,0.34320e+03,0.47164e+03,0.30666e+03,0.17829e+03 /)
      kbo(:, 3,24, 3) = (/ &
        & 0.23966e+03,0.34308e+03,0.47145e+03,0.30654e+03,0.17829e+03 /)
      kbo(:, 4,24, 3) = (/ &
        & 0.23952e+03,0.34297e+03,0.47128e+03,0.30644e+03,0.17829e+03 /)
      kbo(:, 5,24, 3) = (/ &
        & 0.23940e+03,0.34288e+03,0.47113e+03,0.30635e+03,0.17829e+03 /)
      kbo(:, 1,25, 3) = (/ &
        & 0.23948e+03,0.34294e+03,0.47124e+03,0.30641e+03,0.17829e+03 /)
      kbo(:, 2,25, 3) = (/ &
        & 0.23934e+03,0.34284e+03,0.47105e+03,0.30631e+03,0.17829e+03 /)
      kbo(:, 3,25, 3) = (/ &
        & 0.23921e+03,0.34274e+03,0.47089e+03,0.30622e+03,0.17829e+03 /)
      kbo(:, 4,25, 3) = (/ &
        & 0.23910e+03,0.34266e+03,0.47075e+03,0.30613e+03,0.17829e+03 /)
      kbo(:, 5,25, 3) = (/ &
        & 0.23900e+03,0.34258e+03,0.47063e+03,0.30606e+03,0.17829e+03 /)
      kbo(:, 1,26, 3) = (/ &
        & 0.23906e+03,0.34263e+03,0.47070e+03,0.30610e+03,0.17829e+03 /)
      kbo(:, 2,26, 3) = (/ &
        & 0.23894e+03,0.34254e+03,0.47056e+03,0.30602e+03,0.17829e+03 /)
      kbo(:, 3,26, 3) = (/ &
        & 0.23884e+03,0.34247e+03,0.47044e+03,0.30595e+03,0.17829e+03 /)
      kbo(:, 4,26, 3) = (/ &
        & 0.23875e+03,0.34240e+03,0.47033e+03,0.30588e+03,0.17829e+03 /)
      kbo(:, 5,26, 3) = (/ &
        & 0.23867e+03,0.34234e+03,0.47023e+03,0.30583e+03,0.17829e+03 /)
      kbo(:, 1,27, 3) = (/ &
        & 0.23871e+03,0.34237e+03,0.47028e+03,0.30586e+03,0.17829e+03 /)
      kbo(:, 2,27, 3) = (/ &
        & 0.23862e+03,0.34230e+03,0.47017e+03,0.30579e+03,0.17829e+03 /)
      kbo(:, 3,27, 3) = (/ &
        & 0.23854e+03,0.34225e+03,0.47007e+03,0.30573e+03,0.17829e+03 /)
      kbo(:, 4,27, 3) = (/ &
        & 0.23847e+03,0.34219e+03,0.46998e+03,0.30568e+03,0.17829e+03 /)
      kbo(:, 5,27, 3) = (/ &
        & 0.23840e+03,0.34214e+03,0.46990e+03,0.30564e+03,0.17829e+03 /)
      kbo(:, 1,28, 3) = (/ &
        & 0.23844e+03,0.34217e+03,0.46994e+03,0.30566e+03,0.17829e+03 /)
      kbo(:, 2,28, 3) = (/ &
        & 0.23836e+03,0.34211e+03,0.46985e+03,0.30561e+03,0.17829e+03 /)
      kbo(:, 3,28, 3) = (/ &
        & 0.23830e+03,0.34207e+03,0.46977e+03,0.30556e+03,0.17829e+03 /)
      kbo(:, 4,28, 3) = (/ &
        & 0.23824e+03,0.34202e+03,0.46970e+03,0.30552e+03,0.17829e+03 /)
      kbo(:, 5,28, 3) = (/ &
        & 0.23819e+03,0.34198e+03,0.46964e+03,0.30548e+03,0.17829e+03 /)
      kbo(:, 1,29, 3) = (/ &
        & 0.23821e+03,0.34200e+03,0.46966e+03,0.30550e+03,0.17829e+03 /)
      kbo(:, 2,29, 3) = (/ &
        & 0.23815e+03,0.34196e+03,0.46959e+03,0.30546e+03,0.17829e+03 /)
      kbo(:, 3,29, 3) = (/ &
        & 0.23810e+03,0.34192e+03,0.46953e+03,0.30542e+03,0.17829e+03 /)
      kbo(:, 4,29, 3) = (/ &
        & 0.23806e+03,0.34189e+03,0.46948e+03,0.30539e+03,0.17829e+03 /)
      kbo(:, 5,29, 3) = (/ &
        & 0.23802e+03,0.34185e+03,0.46942e+03,0.30536e+03,0.17829e+03 /)
      kbo(:, 1,30, 3) = (/ &
        & 0.23803e+03,0.34187e+03,0.46944e+03,0.30537e+03,0.17829e+03 /)
      kbo(:, 2,30, 3) = (/ &
        & 0.23799e+03,0.34184e+03,0.46939e+03,0.30533e+03,0.17829e+03 /)
      kbo(:, 3,30, 3) = (/ &
        & 0.23795e+03,0.34180e+03,0.46934e+03,0.30531e+03,0.17829e+03 /)
      kbo(:, 4,30, 3) = (/ &
        & 0.23791e+03,0.34178e+03,0.46929e+03,0.30528e+03,0.17829e+03 /)
      kbo(:, 5,30, 3) = (/ &
        & 0.23788e+03,0.34175e+03,0.46925e+03,0.30526e+03,0.17829e+03 /)
      kbo(:, 1,31, 3) = (/ &
        & 0.23789e+03,0.34176e+03,0.46926e+03,0.30526e+03,0.17829e+03 /)
      kbo(:, 2,31, 3) = (/ &
        & 0.23785e+03,0.34173e+03,0.46922e+03,0.30524e+03,0.17829e+03 /)
      kbo(:, 3,31, 3) = (/ &
        & 0.23782e+03,0.34171e+03,0.46918e+03,0.30521e+03,0.17829e+03 /)
      kbo(:, 4,31, 3) = (/ &
        & 0.23779e+03,0.34169e+03,0.46914e+03,0.30519e+03,0.17829e+03 /)
      kbo(:, 5,31, 3) = (/ &
        & 0.23777e+03,0.34167e+03,0.46911e+03,0.30518e+03,0.17829e+03 /)
      kbo(:, 1,32, 3) = (/ &
        & 0.23777e+03,0.34168e+03,0.46912e+03,0.30518e+03,0.17829e+03 /)
      kbo(:, 2,32, 3) = (/ &
        & 0.23774e+03,0.34166e+03,0.46908e+03,0.30516e+03,0.17829e+03 /)
      kbo(:, 3,32, 3) = (/ &
        & 0.23772e+03,0.34163e+03,0.46905e+03,0.30514e+03,0.17829e+03 /)
      kbo(:, 4,32, 3) = (/ &
        & 0.23770e+03,0.34162e+03,0.46902e+03,0.30512e+03,0.17829e+03 /)
      kbo(:, 5,32, 3) = (/ &
        & 0.23767e+03,0.34160e+03,0.46900e+03,0.30511e+03,0.17829e+03 /)
      kbo(:, 1,33, 3) = (/ &
        & 0.23768e+03,0.34161e+03,0.46900e+03,0.30511e+03,0.17829e+03 /)
      kbo(:, 2,33, 3) = (/ &
        & 0.23766e+03,0.34159e+03,0.46897e+03,0.30510e+03,0.17829e+03 /)
      kbo(:, 3,33, 3) = (/ &
        & 0.23764e+03,0.34157e+03,0.46895e+03,0.30508e+03,0.17829e+03 /)
      kbo(:, 4,33, 3) = (/ &
        & 0.23762e+03,0.34156e+03,0.46893e+03,0.30507e+03,0.17829e+03 /)
      kbo(:, 5,33, 3) = (/ &
        & 0.23760e+03,0.34154e+03,0.46891e+03,0.30506e+03,0.17829e+03 /)
      kbo(:, 1,34, 3) = (/ &
        & 0.23760e+03,0.34155e+03,0.46891e+03,0.30506e+03,0.17829e+03 /)
      kbo(:, 2,34, 3) = (/ &
        & 0.23759e+03,0.34154e+03,0.46889e+03,0.30505e+03,0.17829e+03 /)
      kbo(:, 3,34, 3) = (/ &
        & 0.23757e+03,0.34152e+03,0.46887e+03,0.30503e+03,0.17829e+03 /)
      kbo(:, 4,34, 3) = (/ &
        & 0.23756e+03,0.34151e+03,0.46885e+03,0.30502e+03,0.17829e+03 /)
      kbo(:, 5,34, 3) = (/ &
        & 0.23754e+03,0.34150e+03,0.46883e+03,0.30501e+03,0.17829e+03 /)
      kbo(:, 1,35, 3) = (/ &
        & 0.23755e+03,0.34151e+03,0.46884e+03,0.30502e+03,0.17829e+03 /)
      kbo(:, 2,35, 3) = (/ &
        & 0.23753e+03,0.34150e+03,0.46882e+03,0.30501e+03,0.17829e+03 /)
      kbo(:, 3,35, 3) = (/ &
        & 0.23752e+03,0.34148e+03,0.46880e+03,0.30500e+03,0.17829e+03 /)
      kbo(:, 4,35, 3) = (/ &
        & 0.23751e+03,0.34147e+03,0.46879e+03,0.30499e+03,0.17829e+03 /)
      kbo(:, 5,35, 3) = (/ &
        & 0.23750e+03,0.34146e+03,0.46878e+03,0.30498e+03,0.17829e+03 /)
      kbo(:, 1,36, 3) = (/ &
        & 0.23750e+03,0.34147e+03,0.46878e+03,0.30498e+03,0.17829e+03 /)
      kbo(:, 2,36, 3) = (/ &
        & 0.23749e+03,0.34146e+03,0.46877e+03,0.30497e+03,0.17829e+03 /)
      kbo(:, 3,36, 3) = (/ &
        & 0.23748e+03,0.34145e+03,0.46875e+03,0.30497e+03,0.17829e+03 /)
      kbo(:, 4,36, 3) = (/ &
        & 0.23747e+03,0.34144e+03,0.46874e+03,0.30496e+03,0.17829e+03 /)
      kbo(:, 5,36, 3) = (/ &
        & 0.23746e+03,0.34144e+03,0.46873e+03,0.30495e+03,0.17829e+03 /)
      kbo(:, 1,37, 3) = (/ &
        & 0.23746e+03,0.34145e+03,0.46874e+03,0.30496e+03,0.17829e+03 /)
      kbo(:, 2,37, 3) = (/ &
        & 0.23745e+03,0.34144e+03,0.46872e+03,0.30495e+03,0.17829e+03 /)
      kbo(:, 3,37, 3) = (/ &
        & 0.23744e+03,0.34143e+03,0.46871e+03,0.30494e+03,0.17829e+03 /)
      kbo(:, 4,37, 3) = (/ &
        & 0.23744e+03,0.34142e+03,0.46870e+03,0.30494e+03,0.17829e+03 /)
      kbo(:, 5,37, 3) = (/ &
        & 0.23743e+03,0.34141e+03,0.46869e+03,0.30493e+03,0.17829e+03 /)
      kbo(:, 1,38, 3) = (/ &
        & 0.23743e+03,0.34143e+03,0.46870e+03,0.30493e+03,0.17829e+03 /)
      kbo(:, 2,38, 3) = (/ &
        & 0.23742e+03,0.34142e+03,0.46869e+03,0.30493e+03,0.17829e+03 /)
      kbo(:, 3,38, 3) = (/ &
        & 0.23742e+03,0.34141e+03,0.46868e+03,0.30492e+03,0.17829e+03 /)
      kbo(:, 4,38, 3) = (/ &
        & 0.23741e+03,0.34140e+03,0.46867e+03,0.30492e+03,0.17829e+03 /)
      kbo(:, 5,38, 3) = (/ &
        & 0.23740e+03,0.34140e+03,0.46866e+03,0.30491e+03,0.17829e+03 /)
      kbo(:, 1,39, 3) = (/ &
        & 0.23741e+03,0.34141e+03,0.46867e+03,0.30492e+03,0.17829e+03 /)
      kbo(:, 2,39, 3) = (/ &
        & 0.23740e+03,0.34140e+03,0.46866e+03,0.30491e+03,0.17829e+03 /)
      kbo(:, 3,39, 3) = (/ &
        & 0.23739e+03,0.34139e+03,0.46865e+03,0.30491e+03,0.17829e+03 /)
      kbo(:, 4,39, 3) = (/ &
        & 0.23739e+03,0.34139e+03,0.46865e+03,0.30490e+03,0.17829e+03 /)
      kbo(:, 5,39, 3) = (/ &
        & 0.23738e+03,0.34138e+03,0.46864e+03,0.30490e+03,0.17829e+03 /)
      kbo(:, 1,40, 3) = (/ &
        & 0.23739e+03,0.34139e+03,0.46864e+03,0.30490e+03,0.17829e+03 /)
      kbo(:, 2,40, 3) = (/ &
        & 0.23738e+03,0.34139e+03,0.46864e+03,0.30490e+03,0.17829e+03 /)
      kbo(:, 3,40, 3) = (/ &
        & 0.23738e+03,0.34138e+03,0.46863e+03,0.30489e+03,0.17829e+03 /)
      kbo(:, 4,40, 3) = (/ &
        & 0.23737e+03,0.34138e+03,0.46862e+03,0.30489e+03,0.17829e+03 /)
      kbo(:, 5,40, 3) = (/ &
        & 0.23737e+03,0.34137e+03,0.46862e+03,0.30489e+03,0.17829e+03 /)
      kbo(:, 1,41, 3) = (/ &
        & 0.23737e+03,0.34138e+03,0.46862e+03,0.30489e+03,0.17829e+03 /)
      kbo(:, 2,41, 3) = (/ &
        & 0.23737e+03,0.34138e+03,0.46862e+03,0.30489e+03,0.17829e+03 /)
      kbo(:, 3,41, 3) = (/ &
        & 0.23736e+03,0.34137e+03,0.46861e+03,0.30488e+03,0.17829e+03 /)
      kbo(:, 4,41, 3) = (/ &
        & 0.23736e+03,0.34137e+03,0.46861e+03,0.30488e+03,0.17829e+03 /)
      kbo(:, 5,41, 3) = (/ &
        & 0.23736e+03,0.34136e+03,0.46860e+03,0.30488e+03,0.17829e+03 /)
      kbo(:, 1,42, 3) = (/ &
        & 0.23736e+03,0.34137e+03,0.46861e+03,0.30488e+03,0.17829e+03 /)
      kbo(:, 2,42, 3) = (/ &
        & 0.23735e+03,0.34137e+03,0.46860e+03,0.30488e+03,0.17829e+03 /)
      kbo(:, 3,42, 3) = (/ &
        & 0.23735e+03,0.34136e+03,0.46860e+03,0.30488e+03,0.17829e+03 /)
      kbo(:, 4,42, 3) = (/ &
        & 0.23735e+03,0.34136e+03,0.46859e+03,0.30487e+03,0.17829e+03 /)
      kbo(:, 5,42, 3) = (/ &
        & 0.23734e+03,0.34135e+03,0.46859e+03,0.30487e+03,0.17829e+03 /)
      kbo(:, 1,43, 3) = (/ &
        & 0.23735e+03,0.34136e+03,0.46859e+03,0.30487e+03,0.17829e+03 /)
      kbo(:, 2,43, 3) = (/ &
        & 0.23734e+03,0.34136e+03,0.46859e+03,0.30487e+03,0.17829e+03 /)
      kbo(:, 3,43, 3) = (/ &
        & 0.23734e+03,0.34136e+03,0.46858e+03,0.30487e+03,0.17829e+03 /)
      kbo(:, 4,43, 3) = (/ &
        & 0.23734e+03,0.34135e+03,0.46858e+03,0.30487e+03,0.17829e+03 /)
      kbo(:, 5,43, 3) = (/ &
        & 0.23734e+03,0.34135e+03,0.46858e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 1,44, 3) = (/ &
        & 0.23734e+03,0.34136e+03,0.46858e+03,0.30487e+03,0.17829e+03 /)
      kbo(:, 2,44, 3) = (/ &
        & 0.23734e+03,0.34135e+03,0.46858e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 3,44, 3) = (/ &
        & 0.23733e+03,0.34135e+03,0.46857e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 4,44, 3) = (/ &
        & 0.23733e+03,0.34135e+03,0.46857e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 5,44, 3) = (/ &
        & 0.23733e+03,0.34134e+03,0.46857e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 1,45, 3) = (/ &
        & 0.23733e+03,0.34135e+03,0.46857e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 2,45, 3) = (/ &
        & 0.23733e+03,0.34135e+03,0.46857e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 3,45, 3) = (/ &
        & 0.23733e+03,0.34135e+03,0.46857e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 4,45, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46856e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 5,45, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46856e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 1,46, 3) = (/ &
        & 0.23732e+03,0.34135e+03,0.46856e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 2,46, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46856e+03,0.30486e+03,0.17829e+03 /)
      kbo(:, 3,46, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46856e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 4,46, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46856e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 5,46, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46856e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 1,47, 3) = (/ &
        & 0.23732e+03,0.34135e+03,0.46856e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 2,47, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46856e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 3,47, 3) = (/ &
        & 0.23732e+03,0.34134e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 4,47, 3) = (/ &
        & 0.23731e+03,0.34134e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 5,47, 3) = (/ &
        & 0.23731e+03,0.34133e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 1,48, 3) = (/ &
        & 0.23731e+03,0.34135e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 2,48, 3) = (/ &
        & 0.23731e+03,0.34134e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 3,48, 3) = (/ &
        & 0.23731e+03,0.34134e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 4,48, 3) = (/ &
        & 0.23731e+03,0.34134e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 5,48, 3) = (/ &
        & 0.23731e+03,0.34133e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 1,49, 3) = (/ &
        & 0.23731e+03,0.34135e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 2,49, 3) = (/ &
        & 0.23731e+03,0.34134e+03,0.46855e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 3,49, 3) = (/ &
        & 0.23731e+03,0.34133e+03,0.46854e+03,0.30485e+03,0.17829e+03 /)
      kbo(:, 4,49, 3) = (/ &
        & 0.23731e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,49, 3) = (/ &
        & 0.23731e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,50, 3) = (/ &
        & 0.23731e+03,0.34136e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,50, 3) = (/ &
        & 0.23731e+03,0.34134e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,50, 3) = (/ &
        & 0.23731e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,50, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,50, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,51, 3) = (/ &
        & 0.23731e+03,0.34136e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,51, 3) = (/ &
        & 0.23730e+03,0.34134e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,51, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,51, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,51, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,52, 3) = (/ &
        & 0.23730e+03,0.34136e+03,0.46852e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,52, 3) = (/ &
        & 0.23730e+03,0.34135e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,52, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,52, 3) = (/ &
        & 0.23730e+03,0.34132e+03,0.46854e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,52, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,53, 3) = (/ &
        & 0.23730e+03,0.34137e+03,0.46851e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,53, 3) = (/ &
        & 0.23730e+03,0.34135e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,53, 3) = (/ &
        & 0.23730e+03,0.34134e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,53, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,53, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,54, 3) = (/ &
        & 0.23730e+03,0.34137e+03,0.46849e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,54, 3) = (/ &
        & 0.23730e+03,0.34136e+03,0.46852e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,54, 3) = (/ &
        & 0.23730e+03,0.34134e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,54, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,54, 3) = (/ &
        & 0.23730e+03,0.34132e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,55, 3) = (/ &
        & 0.23730e+03,0.34138e+03,0.46847e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,55, 3) = (/ &
        & 0.23730e+03,0.34136e+03,0.46852e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,55, 3) = (/ &
        & 0.23730e+03,0.34134e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,55, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,55, 3) = (/ &
        & 0.23730e+03,0.34132e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,56, 3) = (/ &
        & 0.23730e+03,0.34139e+03,0.46844e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,56, 3) = (/ &
        & 0.23730e+03,0.34137e+03,0.46850e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,56, 3) = (/ &
        & 0.23730e+03,0.34135e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,56, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,56, 3) = (/ &
        & 0.23730e+03,0.34133e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,57, 3) = (/ &
        & 0.23730e+03,0.34140e+03,0.46840e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,57, 3) = (/ &
        & 0.23730e+03,0.34137e+03,0.46849e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,57, 3) = (/ &
        & 0.23730e+03,0.34135e+03,0.46852e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,57, 3) = (/ &
        & 0.23730e+03,0.34134e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,57, 3) = (/ &
        & 0.23729e+03,0.34132e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 1,58, 3) = (/ &
        & 0.23730e+03,0.34140e+03,0.46837e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,58, 3) = (/ &
        & 0.23729e+03,0.34138e+03,0.46847e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,58, 3) = (/ &
        & 0.23729e+03,0.34136e+03,0.46851e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 4,58, 3) = (/ &
        & 0.23729e+03,0.34134e+03,0.46853e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 5,58, 3) = (/ &
        & 0.23729e+03,0.34133e+03,0.46853e+03,0.30483e+03,0.17829e+03 /)
      kbo(:, 1,59, 3) = (/ &
        & 0.23729e+03,0.34141e+03,0.46835e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 2,59, 3) = (/ &
        & 0.23729e+03,0.34138e+03,0.46846e+03,0.30484e+03,0.17829e+03 /)
      kbo(:, 3,59, 3) = (/ &
        & 0.23729e+03,0.34136e+03,0.46851e+03,0.30483e+03,0.17829e+03 /)
      kbo(:, 4,59, 3) = (/ &
        & 0.23729e+03,0.34134e+03,0.46853e+03,0.30483e+03,0.17829e+03 /)
      kbo(:, 5,59, 3) = (/ &
        & 0.23729e+03,0.34133e+03,0.46853e+03,0.30483e+03,0.17829e+03 /)
      kbo(:, 1,13, 4) = (/ &
        & 0.51214e+03,0.47089e+03,0.53698e+03,0.40623e+03,0.38437e+03 /)
      kbo(:, 2,13, 4) = (/ &
        & 0.50819e+03,0.46793e+03,0.53525e+03,0.40532e+03,0.38437e+03 /)
      kbo(:, 3,13, 4) = (/ &
        & 0.50478e+03,0.46537e+03,0.53379e+03,0.40453e+03,0.38437e+03 /)
      kbo(:, 4,13, 4) = (/ &
        & 0.50182e+03,0.46315e+03,0.53251e+03,0.40385e+03,0.38437e+03 /)
      kbo(:, 5,13, 4) = (/ &
        & 0.49922e+03,0.46120e+03,0.53137e+03,0.40325e+03,0.38437e+03 /)
      kbo(:, 1,14, 4) = (/ &
        & 0.50224e+03,0.46346e+03,0.53224e+03,0.40395e+03,0.38437e+03 /)
      kbo(:, 2,14, 4) = (/ &
        & 0.49905e+03,0.46107e+03,0.53090e+03,0.40321e+03,0.38437e+03 /)
      kbo(:, 3,14, 4) = (/ &
        & 0.49629e+03,0.45901e+03,0.52974e+03,0.40258e+03,0.38437e+03 /)
      kbo(:, 4,14, 4) = (/ &
        & 0.49390e+03,0.45721e+03,0.52871e+03,0.40203e+03,0.38437e+03 /)
      kbo(:, 5,14, 4) = (/ &
        & 0.49179e+03,0.45563e+03,0.52774e+03,0.40154e+03,0.38437e+03 /)
      kbo(:, 1,15, 4) = (/ &
        & 0.49416e+03,0.45741e+03,0.52835e+03,0.40209e+03,0.38437e+03 /)
      kbo(:, 2,15, 4) = (/ &
        & 0.49159e+03,0.45548e+03,0.52725e+03,0.40149e+03,0.38437e+03 /)
      kbo(:, 3,15, 4) = (/ &
        & 0.48937e+03,0.45381e+03,0.52626e+03,0.40098e+03,0.38437e+03 /)
      kbo(:, 4,15, 4) = (/ &
        & 0.48743e+03,0.45236e+03,0.52534e+03,0.40054e+03,0.38437e+03 /)
      kbo(:, 5,15, 4) = (/ &
        & 0.48573e+03,0.45108e+03,0.52448e+03,0.40015e+03,0.38437e+03 /)
      kbo(:, 1,16, 4) = (/ &
        & 0.48759e+03,0.45248e+03,0.52492e+03,0.40057e+03,0.38437e+03 /)
      kbo(:, 2,16, 4) = (/ &
        & 0.48552e+03,0.45092e+03,0.52397e+03,0.40010e+03,0.38437e+03 /)
      kbo(:, 3,16, 4) = (/ &
        & 0.48373e+03,0.44958e+03,0.52310e+03,0.39968e+03,0.38437e+03 /)
      kbo(:, 4,16, 4) = (/ &
        & 0.48216e+03,0.44841e+03,0.52232e+03,0.39932e+03,0.38437e+03 /)
      kbo(:, 5,16, 4) = (/ &
        & 0.48079e+03,0.44738e+03,0.52159e+03,0.39901e+03,0.38437e+03 /)
      kbo(:, 1,17, 4) = (/ &
        & 0.48226e+03,0.44848e+03,0.52188e+03,0.39935e+03,0.38437e+03 /)
      kbo(:, 2,17, 4) = (/ &
        & 0.48059e+03,0.44723e+03,0.52110e+03,0.39896e+03,0.38437e+03 /)
      kbo(:, 3,17, 4) = (/ &
        & 0.47915e+03,0.44615e+03,0.52038e+03,0.39863e+03,0.38437e+03 /)
      kbo(:, 4,17, 4) = (/ &
        & 0.47788e+03,0.44520e+03,0.51974e+03,0.39834e+03,0.38437e+03 /)
      kbo(:, 5,17, 4) = (/ &
        & 0.47677e+03,0.44437e+03,0.51913e+03,0.39808e+03,0.38437e+03 /)
      kbo(:, 1,18, 4) = (/ &
        & 0.47794e+03,0.44524e+03,0.51928e+03,0.39835e+03,0.38437e+03 /)
      kbo(:, 2,18, 4) = (/ &
        & 0.47659e+03,0.44423e+03,0.51865e+03,0.39804e+03,0.38437e+03 /)
      kbo(:, 3,18, 4) = (/ &
        & 0.47542e+03,0.44336e+03,0.51808e+03,0.39777e+03,0.38437e+03 /)
      kbo(:, 4,18, 4) = (/ &
        & 0.47441e+03,0.44259e+03,0.51755e+03,0.39754e+03,0.38437e+03 /)
      kbo(:, 5,18, 4) = (/ &
        & 0.47351e+03,0.44192e+03,0.51705e+03,0.39733e+03,0.38437e+03 /)
      kbo(:, 1,19, 4) = (/ &
        & 0.47443e+03,0.44261e+03,0.51710e+03,0.39754e+03,0.38437e+03 /)
      kbo(:, 2,19, 4) = (/ &
        & 0.47334e+03,0.44179e+03,0.51660e+03,0.39729e+03,0.38437e+03 /)
      kbo(:, 3,19, 4) = (/ &
        & 0.47240e+03,0.44109e+03,0.51615e+03,0.39708e+03,0.38437e+03 /)
      kbo(:, 4,19, 4) = (/ &
        & 0.47158e+03,0.44047e+03,0.51573e+03,0.39689e+03,0.38437e+03 /)
      kbo(:, 5,19, 4) = (/ &
        & 0.47085e+03,0.43993e+03,0.51533e+03,0.39672e+03,0.38437e+03 /)
      kbo(:, 1,20, 4) = (/ &
        & 0.47156e+03,0.44046e+03,0.51527e+03,0.39688e+03,0.38437e+03 /)
      kbo(:, 2,20, 4) = (/ &
        & 0.47069e+03,0.43980e+03,0.51490e+03,0.39668e+03,0.38437e+03 /)
      kbo(:, 3,20, 4) = (/ &
        & 0.46993e+03,0.43924e+03,0.51455e+03,0.39651e+03,0.38437e+03 /)
      kbo(:, 4,20, 4) = (/ &
        & 0.46927e+03,0.43874e+03,0.51422e+03,0.39635e+03,0.38437e+03 /)
      kbo(:, 5,20, 4) = (/ &
        & 0.46868e+03,0.43830e+03,0.51389e+03,0.39622e+03,0.38437e+03 /)
      kbo(:, 1,21, 4) = (/ &
        & 0.46924e+03,0.43872e+03,0.51377e+03,0.39635e+03,0.38437e+03 /)
      kbo(:, 2,21, 4) = (/ &
        & 0.46853e+03,0.43819e+03,0.51350e+03,0.39619e+03,0.38437e+03 /)
      kbo(:, 3,21, 4) = (/ &
        & 0.46792e+03,0.43773e+03,0.51323e+03,0.39604e+03,0.38437e+03 /)
      kbo(:, 4,21, 4) = (/ &
        & 0.46739e+03,0.43733e+03,0.51296e+03,0.39592e+03,0.38437e+03 /)
      kbo(:, 5,21, 4) = (/ &
        & 0.46692e+03,0.43697e+03,0.51263e+03,0.39581e+03,0.38437e+03 /)
      kbo(:, 1,22, 4) = (/ &
        & 0.46731e+03,0.43727e+03,0.51254e+03,0.39590e+03,0.38437e+03 /)
      kbo(:, 2,22, 4) = (/ &
        & 0.46675e+03,0.43685e+03,0.51231e+03,0.39577e+03,0.38437e+03 /)
      kbo(:, 3,22, 4) = (/ &
        & 0.46626e+03,0.43648e+03,0.51212e+03,0.39566e+03,0.38437e+03 /)
      kbo(:, 4,22, 4) = (/ &
        & 0.46584e+03,0.43616e+03,0.51190e+03,0.39556e+03,0.38437e+03 /)
      kbo(:, 5,22, 4) = (/ &
        & 0.46546e+03,0.43588e+03,0.51168e+03,0.39548e+03,0.38437e+03 /)
      kbo(:, 1,23, 4) = (/ &
        & 0.46575e+03,0.43610e+03,0.51153e+03,0.39554e+03,0.38437e+03 /)
      kbo(:, 2,23, 4) = (/ &
        & 0.46531e+03,0.43577e+03,0.51138e+03,0.39544e+03,0.38437e+03 /)
      kbo(:, 3,23, 4) = (/ &
        & 0.46492e+03,0.43548e+03,0.51122e+03,0.39535e+03,0.38437e+03 /)
      kbo(:, 4,23, 4) = (/ &
        & 0.46458e+03,0.43522e+03,0.51104e+03,0.39527e+03,0.38437e+03 /)
      kbo(:, 5,23, 4) = (/ &
        & 0.46427e+03,0.43499e+03,0.51086e+03,0.39520e+03,0.38437e+03 /)
      kbo(:, 1,24, 4) = (/ &
        & 0.46450e+03,0.43516e+03,0.51071e+03,0.39525e+03,0.38437e+03 /)
      kbo(:, 2,24, 4) = (/ &
        & 0.46414e+03,0.43489e+03,0.51060e+03,0.39517e+03,0.38437e+03 /)
      kbo(:, 3,24, 4) = (/ &
        & 0.46383e+03,0.43466e+03,0.51047e+03,0.39510e+03,0.38437e+03 /)
      kbo(:, 4,24, 4) = (/ &
        & 0.46356e+03,0.43445e+03,0.51033e+03,0.39504e+03,0.38437e+03 /)
      kbo(:, 5,24, 4) = (/ &
        & 0.46331e+03,0.43427e+03,0.51019e+03,0.39498e+03,0.38437e+03 /)
      kbo(:, 1,25, 4) = (/ &
        & 0.46348e+03,0.43439e+03,0.51003e+03,0.39502e+03,0.38437e+03 /)
      kbo(:, 2,25, 4) = (/ &
        & 0.46319e+03,0.43418e+03,0.50997e+03,0.39496e+03,0.38437e+03 /)
      kbo(:, 3,25, 4) = (/ &
        & 0.46295e+03,0.43400e+03,0.50987e+03,0.39490e+03,0.38437e+03 /)
      kbo(:, 4,25, 4) = (/ &
        & 0.46273e+03,0.43383e+03,0.50976e+03,0.39485e+03,0.38437e+03 /)
      kbo(:, 5,25, 4) = (/ &
        & 0.46254e+03,0.43369e+03,0.50965e+03,0.39480e+03,0.38437e+03 /)
      kbo(:, 1,26, 4) = (/ &
        & 0.46265e+03,0.43378e+03,0.50951e+03,0.39483e+03,0.38437e+03 /)
      kbo(:, 2,26, 4) = (/ &
        & 0.46243e+03,0.43361e+03,0.50946e+03,0.39478e+03,0.38437e+03 /)
      kbo(:, 3,26, 4) = (/ &
        & 0.46223e+03,0.43346e+03,0.50938e+03,0.39473e+03,0.38437e+03 /)
      kbo(:, 4,26, 4) = (/ &
        & 0.46206e+03,0.43333e+03,0.50930e+03,0.39469e+03,0.38437e+03 /)
      kbo(:, 5,26, 4) = (/ &
        & 0.46190e+03,0.43321e+03,0.50921e+03,0.39466e+03,0.38437e+03 /)
      kbo(:, 1,27, 4) = (/ &
        & 0.46199e+03,0.43328e+03,0.50908e+03,0.39468e+03,0.38437e+03 /)
      kbo(:, 2,27, 4) = (/ &
        & 0.46181e+03,0.43314e+03,0.50904e+03,0.39464e+03,0.38437e+03 /)
      kbo(:, 3,27, 4) = (/ &
        & 0.46165e+03,0.43303e+03,0.50899e+03,0.39460e+03,0.38437e+03 /)
      kbo(:, 4,27, 4) = (/ &
        & 0.46152e+03,0.43292e+03,0.50892e+03,0.39457e+03,0.38437e+03 /)
      kbo(:, 5,27, 4) = (/ &
        & 0.46139e+03,0.43283e+03,0.50885e+03,0.39454e+03,0.38437e+03 /)
      kbo(:, 1,28, 4) = (/ &
        & 0.46145e+03,0.43288e+03,0.50873e+03,0.39455e+03,0.38437e+03 /)
      kbo(:, 2,28, 4) = (/ &
        & 0.46131e+03,0.43277e+03,0.50871e+03,0.39452e+03,0.38437e+03 /)
      kbo(:, 3,28, 4) = (/ &
        & 0.46119e+03,0.43268e+03,0.50867e+03,0.39449e+03,0.38437e+03 /)
      kbo(:, 4,28, 4) = (/ &
        & 0.46108e+03,0.43259e+03,0.50862e+03,0.39447e+03,0.38437e+03 /)
      kbo(:, 5,28, 4) = (/ &
        & 0.46098e+03,0.43252e+03,0.50856e+03,0.39445e+03,0.38437e+03 /)
      kbo(:, 1,29, 4) = (/ &
        & 0.46102e+03,0.43255e+03,0.50845e+03,0.39445e+03,0.38437e+03 /)
      kbo(:, 2,29, 4) = (/ &
        & 0.46091e+03,0.43247e+03,0.50844e+03,0.39443e+03,0.38437e+03 /)
      kbo(:, 3,29, 4) = (/ &
        & 0.46081e+03,0.43239e+03,0.50842e+03,0.39441e+03,0.38437e+03 /)
      kbo(:, 4,29, 4) = (/ &
        & 0.46072e+03,0.43233e+03,0.50837e+03,0.39439e+03,0.38437e+03 /)
      kbo(:, 5,29, 4) = (/ &
        & 0.46064e+03,0.43227e+03,0.50832e+03,0.39437e+03,0.38437e+03 /)
      kbo(:, 1,30, 4) = (/ &
        & 0.46067e+03,0.43229e+03,0.50823e+03,0.39437e+03,0.38437e+03 /)
      kbo(:, 2,30, 4) = (/ &
        & 0.46058e+03,0.43223e+03,0.50823e+03,0.39435e+03,0.38437e+03 /)
      kbo(:, 3,30, 4) = (/ &
        & 0.46051e+03,0.43217e+03,0.50821e+03,0.39434e+03,0.38437e+03 /)
      kbo(:, 4,30, 4) = (/ &
        & 0.46044e+03,0.43211e+03,0.50818e+03,0.39432e+03,0.38437e+03 /)
      kbo(:, 5,30, 4) = (/ &
        & 0.46037e+03,0.43207e+03,0.50813e+03,0.39431e+03,0.38437e+03 /)
      kbo(:, 1,31, 4) = (/ &
        & 0.46039e+03,0.43208e+03,0.50805e+03,0.39431e+03,0.38437e+03 /)
      kbo(:, 2,31, 4) = (/ &
        & 0.46032e+03,0.43203e+03,0.50805e+03,0.39429e+03,0.38437e+03 /)
      kbo(:, 3,31, 4) = (/ &
        & 0.46026e+03,0.43198e+03,0.50804e+03,0.39428e+03,0.38437e+03 /)
      kbo(:, 4,31, 4) = (/ &
        & 0.46021e+03,0.43194e+03,0.50801e+03,0.39427e+03,0.38437e+03 /)
      kbo(:, 5,31, 4) = (/ &
        & 0.46016e+03,0.43190e+03,0.50797e+03,0.39426e+03,0.38437e+03 /)
      kbo(:, 1,32, 4) = (/ &
        & 0.46017e+03,0.43191e+03,0.50790e+03,0.39426e+03,0.38437e+03 /)
      kbo(:, 2,32, 4) = (/ &
        & 0.46011e+03,0.43187e+03,0.50792e+03,0.39425e+03,0.38437e+03 /)
      kbo(:, 3,32, 4) = (/ &
        & 0.46006e+03,0.43183e+03,0.50791e+03,0.39423e+03,0.38437e+03 /)
      kbo(:, 4,32, 4) = (/ &
        & 0.46002e+03,0.43180e+03,0.50788e+03,0.39422e+03,0.38437e+03 /)
      kbo(:, 5,32, 4) = (/ &
        & 0.45998e+03,0.43177e+03,0.50784e+03,0.39421e+03,0.38437e+03 /)
      kbo(:, 1,33, 4) = (/ &
        & 0.45999e+03,0.43178e+03,0.50779e+03,0.39422e+03,0.38437e+03 /)
      kbo(:, 2,33, 4) = (/ &
        & 0.45994e+03,0.43174e+03,0.50781e+03,0.39421e+03,0.38437e+03 /)
      kbo(:, 3,33, 4) = (/ &
        & 0.45990e+03,0.43171e+03,0.50780e+03,0.39420e+03,0.38437e+03 /)
      kbo(:, 4,33, 4) = (/ &
        & 0.45987e+03,0.43169e+03,0.50777e+03,0.39419e+03,0.38437e+03 /)
      kbo(:, 5,33, 4) = (/ &
        & 0.45984e+03,0.43166e+03,0.50773e+03,0.39418e+03,0.38437e+03 /)
      kbo(:, 1,34, 4) = (/ &
        & 0.45984e+03,0.43167e+03,0.50770e+03,0.39418e+03,0.38437e+03 /)
      kbo(:, 2,34, 4) = (/ &
        & 0.45981e+03,0.43164e+03,0.50772e+03,0.39418e+03,0.38437e+03 /)
      kbo(:, 3,34, 4) = (/ &
        & 0.45978e+03,0.43162e+03,0.50771e+03,0.39417e+03,0.38437e+03 /)
      kbo(:, 4,34, 4) = (/ &
        & 0.45975e+03,0.43160e+03,0.50768e+03,0.39416e+03,0.38437e+03 /)
      kbo(:, 5,34, 4) = (/ &
        & 0.45972e+03,0.43158e+03,0.50764e+03,0.39416e+03,0.38437e+03 /)
      kbo(:, 1,35, 4) = (/ &
        & 0.45973e+03,0.43158e+03,0.50763e+03,0.39416e+03,0.38437e+03 /)
      kbo(:, 2,35, 4) = (/ &
        & 0.45970e+03,0.43156e+03,0.50764e+03,0.39415e+03,0.38437e+03 /)
      kbo(:, 3,35, 4) = (/ &
        & 0.45968e+03,0.43154e+03,0.50764e+03,0.39414e+03,0.38437e+03 /)
      kbo(:, 4,35, 4) = (/ &
        & 0.45965e+03,0.43153e+03,0.50761e+03,0.39414e+03,0.38437e+03 /)
      kbo(:, 5,35, 4) = (/ &
        & 0.45963e+03,0.43151e+03,0.50757e+03,0.39413e+03,0.38437e+03 /)
      kbo(:, 1,36, 4) = (/ &
        & 0.45964e+03,0.43152e+03,0.50757e+03,0.39414e+03,0.38437e+03 /)
      kbo(:, 2,36, 4) = (/ &
        & 0.45962e+03,0.43150e+03,0.50758e+03,0.39413e+03,0.38437e+03 /)
      kbo(:, 3,36, 4) = (/ &
        & 0.45960e+03,0.43148e+03,0.50758e+03,0.39413e+03,0.38437e+03 /)
      kbo(:, 4,36, 4) = (/ &
        & 0.45958e+03,0.43147e+03,0.50756e+03,0.39412e+03,0.38437e+03 /)
      kbo(:, 5,36, 4) = (/ &
        & 0.45956e+03,0.43146e+03,0.50752e+03,0.39412e+03,0.38437e+03 /)
      kbo(:, 1,37, 4) = (/ &
        & 0.45957e+03,0.43146e+03,0.50751e+03,0.39412e+03,0.38437e+03 /)
      kbo(:, 2,37, 4) = (/ &
        & 0.45955e+03,0.43145e+03,0.50753e+03,0.39412e+03,0.38437e+03 /)
      kbo(:, 3,37, 4) = (/ &
        & 0.45953e+03,0.43144e+03,0.50754e+03,0.39411e+03,0.38437e+03 /)
      kbo(:, 4,37, 4) = (/ &
        & 0.45952e+03,0.43142e+03,0.50752e+03,0.39411e+03,0.38437e+03 /)
      kbo(:, 5,37, 4) = (/ &
        & 0.45950e+03,0.43141e+03,0.50748e+03,0.39411e+03,0.38437e+03 /)
      kbo(:, 1,38, 4) = (/ &
        & 0.45951e+03,0.43142e+03,0.50746e+03,0.39411e+03,0.38437e+03 /)
      kbo(:, 2,38, 4) = (/ &
        & 0.45950e+03,0.43141e+03,0.50749e+03,0.39410e+03,0.38437e+03 /)
      kbo(:, 3,38, 4) = (/ &
        & 0.45948e+03,0.43140e+03,0.50750e+03,0.39410e+03,0.38437e+03 /)
      kbo(:, 4,38, 4) = (/ &
        & 0.45947e+03,0.43139e+03,0.50749e+03,0.39410e+03,0.38437e+03 /)
      kbo(:, 5,38, 4) = (/ &
        & 0.45946e+03,0.43138e+03,0.50745e+03,0.39409e+03,0.38437e+03 /)
      kbo(:, 1,39, 4) = (/ &
        & 0.45946e+03,0.43138e+03,0.50742e+03,0.39410e+03,0.38437e+03 /)
      kbo(:, 2,39, 4) = (/ &
        & 0.45945e+03,0.43137e+03,0.50746e+03,0.39409e+03,0.38437e+03 /)
      kbo(:, 3,39, 4) = (/ &
        & 0.45944e+03,0.43137e+03,0.50747e+03,0.39409e+03,0.38437e+03 /)
      kbo(:, 4,39, 4) = (/ &
        & 0.45943e+03,0.43136e+03,0.50746e+03,0.39409e+03,0.38437e+03 /)
      kbo(:, 5,39, 4) = (/ &
        & 0.45942e+03,0.43135e+03,0.50743e+03,0.39409e+03,0.38437e+03 /)
      kbo(:, 1,40, 4) = (/ &
        & 0.45943e+03,0.43136e+03,0.50738e+03,0.39409e+03,0.38437e+03 /)
      kbo(:, 2,40, 4) = (/ &
        & 0.45941e+03,0.43135e+03,0.50742e+03,0.39408e+03,0.38437e+03 /)
      kbo(:, 3,40, 4) = (/ &
        & 0.45940e+03,0.43134e+03,0.50744e+03,0.39408e+03,0.38437e+03 /)
      kbo(:, 4,40, 4) = (/ &
        & 0.45940e+03,0.43133e+03,0.50744e+03,0.39408e+03,0.38437e+03 /)
      kbo(:, 5,40, 4) = (/ &
        & 0.45939e+03,0.43133e+03,0.50742e+03,0.39408e+03,0.38437e+03 /)
      kbo(:, 1,41, 4) = (/ &
        & 0.45939e+03,0.43133e+03,0.50734e+03,0.39408e+03,0.38437e+03 /)
      kbo(:, 2,41, 4) = (/ &
        & 0.45938e+03,0.43133e+03,0.50739e+03,0.39408e+03,0.38437e+03 /)
      kbo(:, 3,41, 4) = (/ &
        & 0.45938e+03,0.43132e+03,0.50742e+03,0.39408e+03,0.38437e+03 /)
      kbo(:, 4,41, 4) = (/ &
        & 0.45937e+03,0.43131e+03,0.50742e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 5,41, 4) = (/ &
        & 0.45936e+03,0.43131e+03,0.50741e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 1,42, 4) = (/ &
        & 0.45937e+03,0.43131e+03,0.50731e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 2,42, 4) = (/ &
        & 0.45936e+03,0.43131e+03,0.50736e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 3,42, 4) = (/ &
        & 0.45935e+03,0.43130e+03,0.50739e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 4,42, 4) = (/ &
        & 0.45935e+03,0.43130e+03,0.50741e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 5,42, 4) = (/ &
        & 0.45934e+03,0.43129e+03,0.50740e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 1,43, 4) = (/ &
        & 0.45935e+03,0.43130e+03,0.50727e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 2,43, 4) = (/ &
        & 0.45934e+03,0.43129e+03,0.50733e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 3,43, 4) = (/ &
        & 0.45933e+03,0.43129e+03,0.50737e+03,0.39407e+03,0.38437e+03 /)
      kbo(:, 4,43, 4) = (/ &
        & 0.45933e+03,0.43128e+03,0.50739e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 5,43, 4) = (/ &
        & 0.45932e+03,0.43128e+03,0.50739e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 1,44, 4) = (/ &
        & 0.45933e+03,0.43128e+03,0.50723e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 2,44, 4) = (/ &
        & 0.45932e+03,0.43128e+03,0.50730e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 3,44, 4) = (/ &
        & 0.45932e+03,0.43128e+03,0.50735e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 4,44, 4) = (/ &
        & 0.45931e+03,0.43127e+03,0.50737e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 5,44, 4) = (/ &
        & 0.45931e+03,0.43127e+03,0.50738e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 1,45, 4) = (/ &
        & 0.45931e+03,0.43127e+03,0.50718e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 2,45, 4) = (/ &
        & 0.45931e+03,0.43127e+03,0.50727e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 3,45, 4) = (/ &
        & 0.45930e+03,0.43127e+03,0.50732e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 4,45, 4) = (/ &
        & 0.45930e+03,0.43126e+03,0.50736e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 5,45, 4) = (/ &
        & 0.45930e+03,0.43126e+03,0.50737e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 1,46, 4) = (/ &
        & 0.45930e+03,0.43126e+03,0.50714e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 2,46, 4) = (/ &
        & 0.45930e+03,0.43126e+03,0.50723e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 3,46, 4) = (/ &
        & 0.45929e+03,0.43126e+03,0.50730e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 4,46, 4) = (/ &
        & 0.45929e+03,0.43125e+03,0.50734e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 5,46, 4) = (/ &
        & 0.45929e+03,0.43125e+03,0.50736e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 1,47, 4) = (/ &
        & 0.45929e+03,0.43126e+03,0.50708e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 2,47, 4) = (/ &
        & 0.45929e+03,0.43125e+03,0.50719e+03,0.39406e+03,0.38437e+03 /)
      kbo(:, 3,47, 4) = (/ &
        & 0.45928e+03,0.43125e+03,0.50727e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,47, 4) = (/ &
        & 0.45928e+03,0.43125e+03,0.50732e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,47, 4) = (/ &
        & 0.45928e+03,0.43125e+03,0.50735e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,48, 4) = (/ &
        & 0.45928e+03,0.43125e+03,0.50701e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,48, 4) = (/ &
        & 0.45928e+03,0.43125e+03,0.50714e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,48, 4) = (/ &
        & 0.45928e+03,0.43124e+03,0.50723e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,48, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50729e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,48, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50733e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,49, 4) = (/ &
        & 0.45928e+03,0.43124e+03,0.50694e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,49, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50709e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,49, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50720e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,49, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50727e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,49, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50732e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,50, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50686e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,50, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50704e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,50, 4) = (/ &
        & 0.45927e+03,0.43124e+03,0.50716e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,50, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50724e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,50, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50730e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,51, 4) = (/ &
        & 0.45926e+03,0.43124e+03,0.50679e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,51, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50697e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,51, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50711e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,51, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50721e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,51, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50728e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,52, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50671e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,52, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50691e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,52, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50707e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,52, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50718e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,52, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50725e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,53, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50663e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,53, 4) = (/ &
        & 0.45926e+03,0.43123e+03,0.50684e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,53, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50701e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,53, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50714e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,53, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50722e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,54, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50655e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,54, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50677e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,54, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50696e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,54, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50710e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,54, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50720e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,55, 4) = (/ &
        & 0.45925e+03,0.43123e+03,0.50647e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,55, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50670e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,55, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50690e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,55, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50706e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,55, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50717e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,56, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50640e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,56, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50663e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,56, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50683e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,56, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50701e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,56, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50714e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,57, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50632e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,57, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50656e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,57, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50677e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,57, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50696e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,57, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50710e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,58, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50624e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,58, 4) = (/ &
        & 0.45925e+03,0.43122e+03,0.50648e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,58, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50671e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,58, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50690e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,58, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50706e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,59, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50622e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 2,59, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50645e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 3,59, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50668e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 4,59, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50688e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 5,59, 4) = (/ &
        & 0.45924e+03,0.43122e+03,0.50704e+03,0.39405e+03,0.38437e+03 /)
      kbo(:, 1,13, 5) = (/ &
        & 0.78037e+03,0.62743e+03,0.56495e+03,0.56633e+03,0.67117e+03 /)
      kbo(:, 2,13, 5) = (/ &
        & 0.77434e+03,0.62291e+03,0.56343e+03,0.56584e+03,0.67117e+03 /)
      kbo(:, 3,13, 5) = (/ &
        & 0.76915e+03,0.61902e+03,0.56189e+03,0.56542e+03,0.67117e+03 /)
      kbo(:, 4,13, 5) = (/ &
        & 0.76464e+03,0.61563e+03,0.56027e+03,0.56506e+03,0.67117e+03 /)
      kbo(:, 5,13, 5) = (/ &
        & 0.76068e+03,0.61266e+03,0.55865e+03,0.56474e+03,0.67117e+03 /)
      kbo(:, 1,14, 5) = (/ &
        & 0.76527e+03,0.61611e+03,0.56011e+03,0.56511e+03,0.67117e+03 /)
      kbo(:, 2,14, 5) = (/ &
        & 0.76041e+03,0.61246e+03,0.55859e+03,0.56472e+03,0.67117e+03 /)
      kbo(:, 3,14, 5) = (/ &
        & 0.75622e+03,0.60932e+03,0.55696e+03,0.56438e+03,0.67117e+03 /)
      kbo(:, 4,14, 5) = (/ &
        & 0.75257e+03,0.60658e+03,0.55539e+03,0.56408e+03,0.67117e+03 /)
      kbo(:, 5,14, 5) = (/ &
        & 0.74936e+03,0.60417e+03,0.55391e+03,0.56383e+03,0.67117e+03 /)
      kbo(:, 1,15, 5) = (/ &
        & 0.75296e+03,0.60688e+03,0.55521e+03,0.56412e+03,0.67117e+03 /)
      kbo(:, 2,15, 5) = (/ &
        & 0.74904e+03,0.60394e+03,0.55372e+03,0.56380e+03,0.67117e+03 /)
      kbo(:, 3,15, 5) = (/ &
        & 0.74566e+03,0.60140e+03,0.55235e+03,0.56353e+03,0.67117e+03 /)
      kbo(:, 4,15, 5) = (/ &
        & 0.74271e+03,0.59919e+03,0.55103e+03,0.56329e+03,0.67117e+03 /)
      kbo(:, 5,15, 5) = (/ &
        & 0.74012e+03,0.59724e+03,0.54977e+03,0.56308e+03,0.67117e+03 /)
      kbo(:, 1,16, 5) = (/ &
        & 0.74295e+03,0.59937e+03,0.55079e+03,0.56331e+03,0.67117e+03 /)
      kbo(:, 2,16, 5) = (/ &
        & 0.73979e+03,0.59700e+03,0.54953e+03,0.56305e+03,0.67117e+03 /)
      kbo(:, 3,16, 5) = (/ &
        & 0.73707e+03,0.59495e+03,0.54828e+03,0.56283e+03,0.67117e+03 /)
      kbo(:, 4,16, 5) = (/ &
        & 0.73469e+03,0.59317e+03,0.54708e+03,0.56264e+03,0.67117e+03 /)
      kbo(:, 5,16, 5) = (/ &
        & 0.73259e+03,0.59160e+03,0.54600e+03,0.56247e+03,0.67117e+03 /)
      kbo(:, 1,17, 5) = (/ &
        & 0.73483e+03,0.59328e+03,0.54695e+03,0.56265e+03,0.67117e+03 /)
      kbo(:, 2,17, 5) = (/ &
        & 0.73229e+03,0.59137e+03,0.54572e+03,0.56245e+03,0.67117e+03 /)
      kbo(:, 3,17, 5) = (/ &
        & 0.73009e+03,0.58972e+03,0.54462e+03,0.56227e+03,0.67117e+03 /)
      kbo(:, 4,17, 5) = (/ &
        & 0.72817e+03,0.58828e+03,0.54366e+03,0.56212e+03,0.67117e+03 /)
      kbo(:, 5,17, 5) = (/ &
        & 0.72647e+03,0.58701e+03,0.54281e+03,0.56198e+03,0.67117e+03 /)
      kbo(:, 1,18, 5) = (/ &
        & 0.72825e+03,0.58834e+03,0.54354e+03,0.56212e+03,0.67117e+03 /)
      kbo(:, 2,18, 5) = (/ &
        & 0.72619e+03,0.58680e+03,0.54253e+03,0.56196e+03,0.67117e+03 /)
      kbo(:, 3,18, 5) = (/ &
        & 0.72442e+03,0.58547e+03,0.54166e+03,0.56181e+03,0.67117e+03 /)
      kbo(:, 4,18, 5) = (/ &
        & 0.72286e+03,0.58430e+03,0.54091e+03,0.56169e+03,0.67117e+03 /)
      kbo(:, 5,18, 5) = (/ &
        & 0.72150e+03,0.58328e+03,0.54024e+03,0.56158e+03,0.67117e+03 /)
      kbo(:, 1,19, 5) = (/ &
        & 0.72290e+03,0.58433e+03,0.54075e+03,0.56169e+03,0.67117e+03 /)
      kbo(:, 2,19, 5) = (/ &
        & 0.72124e+03,0.58309e+03,0.53996e+03,0.56156e+03,0.67117e+03 /)
      kbo(:, 3,19, 5) = (/ &
        & 0.71981e+03,0.58201e+03,0.53928e+03,0.56144e+03,0.67117e+03 /)
      kbo(:, 4,19, 5) = (/ &
        & 0.71856e+03,0.58107e+03,0.53868e+03,0.56134e+03,0.67117e+03 /)
      kbo(:, 5,19, 5) = (/ &
        & 0.71745e+03,0.58024e+03,0.53816e+03,0.56125e+03,0.67117e+03 /)
      kbo(:, 1,20, 5) = (/ &
        & 0.71853e+03,0.58105e+03,0.53849e+03,0.56134e+03,0.67117e+03 /)
      kbo(:, 2,20, 5) = (/ &
        & 0.71720e+03,0.58006e+03,0.53788e+03,0.56123e+03,0.67117e+03 /)
      kbo(:, 3,20, 5) = (/ &
        & 0.71605e+03,0.57919e+03,0.53734e+03,0.56114e+03,0.67117e+03 /)
      kbo(:, 4,20, 5) = (/ &
        & 0.71504e+03,0.57843e+03,0.53687e+03,0.56106e+03,0.67117e+03 /)
      kbo(:, 5,20, 5) = (/ &
        & 0.71414e+03,0.57776e+03,0.53643e+03,0.56098e+03,0.67117e+03 /)
      kbo(:, 1,21, 5) = (/ &
        & 0.71499e+03,0.57840e+03,0.53667e+03,0.56105e+03,0.67117e+03 /)
      kbo(:, 2,21, 5) = (/ &
        & 0.71392e+03,0.57759e+03,0.53620e+03,0.56097e+03,0.67117e+03 /)
      kbo(:, 3,21, 5) = (/ &
        & 0.71299e+03,0.57690e+03,0.53578e+03,0.56089e+03,0.67117e+03 /)
      kbo(:, 4,21, 5) = (/ &
        & 0.71217e+03,0.57628e+03,0.53541e+03,0.56083e+03,0.67117e+03 /)
      kbo(:, 5,21, 5) = (/ &
        & 0.71145e+03,0.57574e+03,0.53506e+03,0.56077e+03,0.67117e+03 /)
      kbo(:, 1,22, 5) = (/ &
        & 0.71206e+03,0.57620e+03,0.53519e+03,0.56082e+03,0.67117e+03 /)
      kbo(:, 2,22, 5) = (/ &
        & 0.71120e+03,0.57555e+03,0.53482e+03,0.56075e+03,0.67117e+03 /)
      kbo(:, 3,22, 5) = (/ &
        & 0.71046e+03,0.57500e+03,0.53450e+03,0.56069e+03,0.67117e+03 /)
      kbo(:, 4,22, 5) = (/ &
        & 0.70981e+03,0.57451e+03,0.53420e+03,0.56064e+03,0.67117e+03 /)
      kbo(:, 5,22, 5) = (/ &
        & 0.70923e+03,0.57408e+03,0.53390e+03,0.56059e+03,0.67117e+03 /)
      kbo(:, 1,23, 5) = (/ &
        & 0.70968e+03,0.57442e+03,0.53396e+03,0.56063e+03,0.67117e+03 /)
      kbo(:, 2,23, 5) = (/ &
        & 0.70900e+03,0.57391e+03,0.53367e+03,0.56057e+03,0.67117e+03 /)
      kbo(:, 3,23, 5) = (/ &
        & 0.70841e+03,0.57346e+03,0.53341e+03,0.56052e+03,0.67117e+03 /)
      kbo(:, 4,23, 5) = (/ &
        & 0.70789e+03,0.57307e+03,0.53316e+03,0.56048e+03,0.67117e+03 /)
      kbo(:, 5,23, 5) = (/ &
        & 0.70743e+03,0.57272e+03,0.53290e+03,0.56044e+03,0.67117e+03 /)
      kbo(:, 1,24, 5) = (/ &
        & 0.70776e+03,0.57298e+03,0.53293e+03,0.56047e+03,0.67117e+03 /)
      kbo(:, 2,24, 5) = (/ &
        & 0.70722e+03,0.57257e+03,0.53269e+03,0.56043e+03,0.67117e+03 /)
      kbo(:, 3,24, 5) = (/ &
        & 0.70675e+03,0.57222e+03,0.53248e+03,0.56039e+03,0.67117e+03 /)
      kbo(:, 4,24, 5) = (/ &
        & 0.70633e+03,0.57190e+03,0.53228e+03,0.56036e+03,0.67117e+03 /)
      kbo(:, 5,24, 5) = (/ &
        & 0.70596e+03,0.57163e+03,0.53207e+03,0.56033e+03,0.67117e+03 /)
      kbo(:, 1,25, 5) = (/ &
        & 0.70621e+03,0.57181e+03,0.53206e+03,0.56035e+03,0.67117e+03 /)
      kbo(:, 2,25, 5) = (/ &
        & 0.70578e+03,0.57149e+03,0.53188e+03,0.56031e+03,0.67117e+03 /)
      kbo(:, 3,25, 5) = (/ &
        & 0.70541e+03,0.57121e+03,0.53172e+03,0.56028e+03,0.67117e+03 /)
      kbo(:, 4,25, 5) = (/ &
        & 0.70507e+03,0.57096e+03,0.53156e+03,0.56025e+03,0.67117e+03 /)
      kbo(:, 5,25, 5) = (/ &
        & 0.70478e+03,0.57074e+03,0.53138e+03,0.56023e+03,0.67117e+03 /)
      kbo(:, 1,26, 5) = (/ &
        & 0.70496e+03,0.57087e+03,0.53135e+03,0.56024e+03,0.67117e+03 /)
      kbo(:, 2,26, 5) = (/ &
        & 0.70461e+03,0.57061e+03,0.53122e+03,0.56022e+03,0.67117e+03 /)
      kbo(:, 3,26, 5) = (/ &
        & 0.70432e+03,0.57039e+03,0.53110e+03,0.56019e+03,0.67117e+03 /)
      kbo(:, 4,26, 5) = (/ &
        & 0.70405e+03,0.57019e+03,0.53097e+03,0.56017e+03,0.67117e+03 /)
      kbo(:, 5,26, 5) = (/ &
        & 0.70382e+03,0.57001e+03,0.53082e+03,0.56015e+03,0.67117e+03 /)
      kbo(:, 1,27, 5) = (/ &
        & 0.70394e+03,0.57011e+03,0.53077e+03,0.56016e+03,0.67117e+03 /)
      kbo(:, 2,27, 5) = (/ &
        & 0.70367e+03,0.56991e+03,0.53069e+03,0.56014e+03,0.67117e+03 /)
      kbo(:, 3,27, 5) = (/ &
        & 0.70343e+03,0.56973e+03,0.53060e+03,0.56012e+03,0.67117e+03 /)
      kbo(:, 4,27, 5) = (/ &
        & 0.70322e+03,0.56957e+03,0.53049e+03,0.56010e+03,0.67117e+03 /)
      kbo(:, 5,27, 5) = (/ &
        & 0.70304e+03,0.56943e+03,0.53036e+03,0.56009e+03,0.67117e+03 /)
      kbo(:, 1,28, 5) = (/ &
        & 0.70313e+03,0.56950e+03,0.53032e+03,0.56010e+03,0.67117e+03 /)
      kbo(:, 2,28, 5) = (/ &
        & 0.70291e+03,0.56934e+03,0.53026e+03,0.56008e+03,0.67117e+03 /)
      kbo(:, 3,28, 5) = (/ &
        & 0.70272e+03,0.56920e+03,0.53019e+03,0.56006e+03,0.67117e+03 /)
      kbo(:, 4,28, 5) = (/ &
        & 0.70256e+03,0.56907e+03,0.53010e+03,0.56005e+03,0.67117e+03 /)
      kbo(:, 5,28, 5) = (/ &
        & 0.70241e+03,0.56896e+03,0.52998e+03,0.56004e+03,0.67117e+03 /)
      kbo(:, 1,29, 5) = (/ &
        & 0.70247e+03,0.56901e+03,0.52995e+03,0.56004e+03,0.67117e+03 /)
      kbo(:, 2,29, 5) = (/ &
        & 0.70230e+03,0.56888e+03,0.52991e+03,0.56003e+03,0.67117e+03 /)
      kbo(:, 3,29, 5) = (/ &
        & 0.70215e+03,0.56877e+03,0.52985e+03,0.56002e+03,0.67117e+03 /)
      kbo(:, 4,29, 5) = (/ &
        & 0.70202e+03,0.56867e+03,0.52978e+03,0.56001e+03,0.67117e+03 /)
      kbo(:, 5,29, 5) = (/ &
        & 0.70190e+03,0.56858e+03,0.52967e+03,0.56000e+03,0.67117e+03 /)
      kbo(:, 1,30, 5) = (/ &
        & 0.70194e+03,0.56861e+03,0.52966e+03,0.56000e+03,0.67117e+03 /)
      kbo(:, 2,30, 5) = (/ &
        & 0.70181e+03,0.56851e+03,0.52963e+03,0.55999e+03,0.67117e+03 /)
      kbo(:, 3,30, 5) = (/ &
        & 0.70169e+03,0.56842e+03,0.52958e+03,0.55998e+03,0.67117e+03 /)
      kbo(:, 4,30, 5) = (/ &
        & 0.70158e+03,0.56834e+03,0.52951e+03,0.55997e+03,0.67117e+03 /)
      kbo(:, 5,30, 5) = (/ &
        & 0.70149e+03,0.56827e+03,0.52941e+03,0.55996e+03,0.67117e+03 /)
      kbo(:, 1,31, 5) = (/ &
        & 0.70151e+03,0.56829e+03,0.52942e+03,0.55997e+03,0.67117e+03 /)
      kbo(:, 2,31, 5) = (/ &
        & 0.70141e+03,0.56821e+03,0.52941e+03,0.55996e+03,0.67117e+03 /)
      kbo(:, 3,31, 5) = (/ &
        & 0.70131e+03,0.56814e+03,0.52936e+03,0.55995e+03,0.67117e+03 /)
      kbo(:, 4,31, 5) = (/ &
        & 0.70123e+03,0.56807e+03,0.52930e+03,0.55994e+03,0.67117e+03 /)
      kbo(:, 5,31, 5) = (/ &
        & 0.70115e+03,0.56802e+03,0.52920e+03,0.55994e+03,0.67117e+03 /)
      kbo(:, 1,32, 5) = (/ &
        & 0.70117e+03,0.56803e+03,0.52924e+03,0.55994e+03,0.67117e+03 /)
      kbo(:, 2,32, 5) = (/ &
        & 0.70109e+03,0.56797e+03,0.52922e+03,0.55993e+03,0.67117e+03 /)
      kbo(:, 3,32, 5) = (/ &
        & 0.70101e+03,0.56791e+03,0.52919e+03,0.55993e+03,0.67117e+03 /)
      kbo(:, 4,32, 5) = (/ &
        & 0.70094e+03,0.56786e+03,0.52912e+03,0.55992e+03,0.67117e+03 /)
      kbo(:, 5,32, 5) = (/ &
        & 0.70088e+03,0.56782e+03,0.52902e+03,0.55992e+03,0.67117e+03 /)
      kbo(:, 1,33, 5) = (/ &
        & 0.70090e+03,0.56782e+03,0.52908e+03,0.55992e+03,0.67117e+03 /)
      kbo(:, 2,33, 5) = (/ &
        & 0.70083e+03,0.56777e+03,0.52907e+03,0.55991e+03,0.67117e+03 /)
      kbo(:, 3,33, 5) = (/ &
        & 0.70077e+03,0.56773e+03,0.52904e+03,0.55991e+03,0.67117e+03 /)
      kbo(:, 4,33, 5) = (/ &
        & 0.70072e+03,0.56769e+03,0.52897e+03,0.55990e+03,0.67117e+03 /)
      kbo(:, 5,33, 5) = (/ &
        & 0.70067e+03,0.56765e+03,0.52887e+03,0.55990e+03,0.67117e+03 /)
      kbo(:, 1,34, 5) = (/ &
        & 0.70068e+03,0.56766e+03,0.52896e+03,0.55990e+03,0.67117e+03 /)
      kbo(:, 2,34, 5) = (/ &
        & 0.70062e+03,0.56762e+03,0.52895e+03,0.55989e+03,0.67117e+03 /)
      kbo(:, 3,34, 5) = (/ &
        & 0.70057e+03,0.56758e+03,0.52892e+03,0.55989e+03,0.67117e+03 /)
      kbo(:, 4,34, 5) = (/ &
        & 0.70053e+03,0.56755e+03,0.52885e+03,0.55989e+03,0.67117e+03 /)
      kbo(:, 5,34, 5) = (/ &
        & 0.70049e+03,0.56752e+03,0.52874e+03,0.55988e+03,0.67117e+03 /)
      kbo(:, 1,35, 5) = (/ &
        & 0.70050e+03,0.56753e+03,0.52886e+03,0.55988e+03,0.67117e+03 /)
      kbo(:, 2,35, 5) = (/ &
        & 0.70046e+03,0.56750e+03,0.52885e+03,0.55988e+03,0.67117e+03 /)
      kbo(:, 3,35, 5) = (/ &
        & 0.70042e+03,0.56747e+03,0.52883e+03,0.55988e+03,0.67117e+03 /)
      kbo(:, 4,35, 5) = (/ &
        & 0.70039e+03,0.56744e+03,0.52876e+03,0.55988e+03,0.67117e+03 /)
      kbo(:, 5,35, 5) = (/ &
        & 0.70035e+03,0.56742e+03,0.52864e+03,0.55987e+03,0.67117e+03 /)
      kbo(:, 1,36, 5) = (/ &
        & 0.70037e+03,0.56743e+03,0.52877e+03,0.55987e+03,0.67117e+03 /)
      kbo(:, 2,36, 5) = (/ &
        & 0.70033e+03,0.56740e+03,0.52878e+03,0.55987e+03,0.67117e+03 /)
      kbo(:, 3,36, 5) = (/ &
        & 0.70030e+03,0.56738e+03,0.52875e+03,0.55987e+03,0.67117e+03 /)
      kbo(:, 4,36, 5) = (/ &
        & 0.70027e+03,0.56736e+03,0.52869e+03,0.55987e+03,0.67117e+03 /)
      kbo(:, 5,36, 5) = (/ &
        & 0.70025e+03,0.56734e+03,0.52857e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 1,37, 5) = (/ &
        & 0.70026e+03,0.56735e+03,0.52870e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 2,37, 5) = (/ &
        & 0.70023e+03,0.56733e+03,0.52872e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 3,37, 5) = (/ &
        & 0.70020e+03,0.56731e+03,0.52870e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 4,37, 5) = (/ &
        & 0.70018e+03,0.56729e+03,0.52864e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 5,37, 5) = (/ &
        & 0.70016e+03,0.56727e+03,0.52854e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 1,38, 5) = (/ &
        & 0.70017e+03,0.56728e+03,0.52864e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 2,38, 5) = (/ &
        & 0.70015e+03,0.56726e+03,0.52866e+03,0.55986e+03,0.67117e+03 /)
      kbo(:, 3,38, 5) = (/ &
        & 0.70012e+03,0.56725e+03,0.52866e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 4,38, 5) = (/ &
        & 0.70010e+03,0.56723e+03,0.52860e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 5,38, 5) = (/ &
        & 0.70009e+03,0.56722e+03,0.52852e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 1,39, 5) = (/ &
        & 0.70010e+03,0.56723e+03,0.52860e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 2,39, 5) = (/ &
        & 0.70008e+03,0.56721e+03,0.52862e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 3,39, 5) = (/ &
        & 0.70006e+03,0.56720e+03,0.52861e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 4,39, 5) = (/ &
        & 0.70004e+03,0.56719e+03,0.52858e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 5,39, 5) = (/ &
        & 0.70003e+03,0.56717e+03,0.52850e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 1,40, 5) = (/ &
        & 0.70004e+03,0.56718e+03,0.52855e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 2,40, 5) = (/ &
        & 0.70002e+03,0.56717e+03,0.52858e+03,0.55985e+03,0.67117e+03 /)
      kbo(:, 3,40, 5) = (/ &
        & 0.70001e+03,0.56716e+03,0.52859e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 4,40, 5) = (/ &
        & 0.69999e+03,0.56715e+03,0.52856e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 5,40, 5) = (/ &
        & 0.69998e+03,0.56714e+03,0.52849e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 1,41, 5) = (/ &
        & 0.69999e+03,0.56715e+03,0.52850e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 2,41, 5) = (/ &
        & 0.69998e+03,0.56714e+03,0.52854e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 3,41, 5) = (/ &
        & 0.69996e+03,0.56713e+03,0.52856e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 4,41, 5) = (/ &
        & 0.69995e+03,0.56712e+03,0.52854e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 5,41, 5) = (/ &
        & 0.69994e+03,0.56711e+03,0.52848e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 1,42, 5) = (/ &
        & 0.69995e+03,0.56712e+03,0.52846e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 2,42, 5) = (/ &
        & 0.69994e+03,0.56711e+03,0.52851e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 3,42, 5) = (/ &
        & 0.69993e+03,0.56710e+03,0.52853e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 4,42, 5) = (/ &
        & 0.69992e+03,0.56709e+03,0.52853e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 5,42, 5) = (/ &
        & 0.69991e+03,0.56709e+03,0.52848e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 1,43, 5) = (/ &
        & 0.69992e+03,0.56709e+03,0.52843e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 2,43, 5) = (/ &
        & 0.69991e+03,0.56708e+03,0.52848e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 3,43, 5) = (/ &
        & 0.69990e+03,0.56708e+03,0.52851e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 4,43, 5) = (/ &
        & 0.69989e+03,0.56707e+03,0.52851e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 5,43, 5) = (/ &
        & 0.69988e+03,0.56707e+03,0.52848e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,44, 5) = (/ &
        & 0.69989e+03,0.56707e+03,0.52838e+03,0.55984e+03,0.67117e+03 /)
      kbo(:, 2,44, 5) = (/ &
        & 0.69988e+03,0.56707e+03,0.52844e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,44, 5) = (/ &
        & 0.69988e+03,0.56706e+03,0.52848e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,44, 5) = (/ &
        & 0.69987e+03,0.56705e+03,0.52850e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,44, 5) = (/ &
        & 0.69986e+03,0.56705e+03,0.52849e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,45, 5) = (/ &
        & 0.69987e+03,0.56706e+03,0.52834e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,45, 5) = (/ &
        & 0.69986e+03,0.56705e+03,0.52841e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,45, 5) = (/ &
        & 0.69986e+03,0.56704e+03,0.52846e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,45, 5) = (/ &
        & 0.69985e+03,0.56704e+03,0.52848e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,45, 5) = (/ &
        & 0.69984e+03,0.56704e+03,0.52848e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,46, 5) = (/ &
        & 0.69985e+03,0.56704e+03,0.52830e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,46, 5) = (/ &
        & 0.69984e+03,0.56704e+03,0.52837e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,46, 5) = (/ &
        & 0.69984e+03,0.56703e+03,0.52843e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,46, 5) = (/ &
        & 0.69983e+03,0.56703e+03,0.52847e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,46, 5) = (/ &
        & 0.69983e+03,0.56703e+03,0.52848e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,47, 5) = (/ &
        & 0.69984e+03,0.56703e+03,0.52826e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,47, 5) = (/ &
        & 0.69983e+03,0.56703e+03,0.52834e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,47, 5) = (/ &
        & 0.69982e+03,0.56702e+03,0.52840e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,47, 5) = (/ &
        & 0.69982e+03,0.56702e+03,0.52845e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,47, 5) = (/ &
        & 0.69982e+03,0.56702e+03,0.52847e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,48, 5) = (/ &
        & 0.69982e+03,0.56702e+03,0.52821e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,48, 5) = (/ &
        & 0.69982e+03,0.56702e+03,0.52830e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,48, 5) = (/ &
        & 0.69981e+03,0.56701e+03,0.52837e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,48, 5) = (/ &
        & 0.69981e+03,0.56701e+03,0.52842e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,48, 5) = (/ &
        & 0.69981e+03,0.56701e+03,0.52845e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,49, 5) = (/ &
        & 0.69981e+03,0.56701e+03,0.52817e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,49, 5) = (/ &
        & 0.69981e+03,0.56701e+03,0.52825e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,49, 5) = (/ &
        & 0.69980e+03,0.56701e+03,0.52833e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,49, 5) = (/ &
        & 0.69980e+03,0.56700e+03,0.52840e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,49, 5) = (/ &
        & 0.69980e+03,0.56700e+03,0.52844e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,50, 5) = (/ &
        & 0.69980e+03,0.56701e+03,0.52812e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,50, 5) = (/ &
        & 0.69980e+03,0.56700e+03,0.52821e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,50, 5) = (/ &
        & 0.69980e+03,0.56700e+03,0.52830e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,50, 5) = (/ &
        & 0.69979e+03,0.56700e+03,0.52837e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,50, 5) = (/ &
        & 0.69979e+03,0.56700e+03,0.52842e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,51, 5) = (/ &
        & 0.69979e+03,0.56700e+03,0.52807e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,51, 5) = (/ &
        & 0.69979e+03,0.56700e+03,0.52818e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,51, 5) = (/ &
        & 0.69979e+03,0.56699e+03,0.52827e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,51, 5) = (/ &
        & 0.69979e+03,0.56699e+03,0.52834e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,51, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52841e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,52, 5) = (/ &
        & 0.69979e+03,0.56699e+03,0.52802e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,52, 5) = (/ &
        & 0.69979e+03,0.56699e+03,0.52814e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,52, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52823e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,52, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52831e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,52, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52838e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,53, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52798e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,53, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52809e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,53, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52820e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,53, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52828e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,53, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52836e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,54, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52794e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,54, 5) = (/ &
        & 0.69978e+03,0.56699e+03,0.52804e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,54, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52816e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,54, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52825e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,54, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52833e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,55, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52790e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,55, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52801e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,55, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52812e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,55, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52822e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,55, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52830e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,56, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52786e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,56, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52797e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,56, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52808e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,56, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52819e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,56, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52827e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,57, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52781e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,57, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52794e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,57, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52805e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,57, 5) = (/ &
        & 0.69976e+03,0.56698e+03,0.52815e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 5,57, 5) = (/ &
        & 0.69976e+03,0.56698e+03,0.52825e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 1,58, 5) = (/ &
        & 0.69977e+03,0.56698e+03,0.52777e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,58, 5) = (/ &
        & 0.69976e+03,0.56698e+03,0.52790e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 3,58, 5) = (/ &
        & 0.69976e+03,0.56698e+03,0.52801e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 4,58, 5) = (/ &
        & 0.69976e+03,0.56698e+03,0.52812e+03,0.55982e+03,0.67117e+03 /)
      kbo(:, 5,58, 5) = (/ &
        & 0.69976e+03,0.56697e+03,0.52822e+03,0.55982e+03,0.67117e+03 /)
      kbo(:, 1,59, 5) = (/ &
        & 0.69976e+03,0.56698e+03,0.52775e+03,0.55983e+03,0.67117e+03 /)
      kbo(:, 2,59, 5) = (/ &
        & 0.69976e+03,0.56698e+03,0.52788e+03,0.55982e+03,0.67117e+03 /)
      kbo(:, 3,59, 5) = (/ &
        & 0.69976e+03,0.56697e+03,0.52801e+03,0.55982e+03,0.67117e+03 /)
      kbo(:, 4,59, 5) = (/ &
        & 0.69976e+03,0.56697e+03,0.52811e+03,0.55982e+03,0.67117e+03 /)
      kbo(:, 5,59, 5) = (/ &
        & 0.69976e+03,0.56697e+03,0.52821e+03,0.55982e+03,0.67117e+03 /)
      kbo(:, 1,13, 6) = (/ &
        & 0.99182e+03,0.76479e+03,0.58123e+03,0.73928e+03,0.94808e+03 /)
      kbo(:, 2,13, 6) = (/ &
        & 0.98417e+03,0.75904e+03,0.57888e+03,0.73991e+03,0.94920e+03 /)
      kbo(:, 3,13, 6) = (/ &
        & 0.97757e+03,0.75410e+03,0.57650e+03,0.74029e+03,0.94995e+03 /)
      kbo(:, 4,13, 6) = (/ &
        & 0.97184e+03,0.74980e+03,0.57428e+03,0.74046e+03,0.95033e+03 /)
      kbo(:, 5,13, 6) = (/ &
        & 0.96680e+03,0.74602e+03,0.57217e+03,0.74043e+03,0.95033e+03 /)
      kbo(:, 1,14, 6) = (/ &
        & 0.97264e+03,0.75040e+03,0.57482e+03,0.73884e+03,0.94820e+03 /)
      kbo(:, 2,14, 6) = (/ &
        & 0.96646e+03,0.74576e+03,0.57229e+03,0.73949e+03,0.94928e+03 /)
      kbo(:, 3,14, 6) = (/ &
        & 0.96113e+03,0.74177e+03,0.57016e+03,0.73988e+03,0.95000e+03 /)
      kbo(:, 4,14, 6) = (/ &
        & 0.95649e+03,0.73829e+03,0.56822e+03,0.74006e+03,0.95035e+03 /)
      kbo(:, 5,14, 6) = (/ &
        & 0.95242e+03,0.73523e+03,0.56635e+03,0.74003e+03,0.95032e+03 /)
      kbo(:, 1,15, 6) = (/ &
        & 0.95700e+03,0.73867e+03,0.56844e+03,0.73851e+03,0.94832e+03 /)
      kbo(:, 2,15, 6) = (/ &
        & 0.95201e+03,0.73493e+03,0.56632e+03,0.73916e+03,0.94937e+03 /)
      kbo(:, 3,15, 6) = (/ &
        & 0.94772e+03,0.73170e+03,0.56426e+03,0.73956e+03,0.95005e+03 /)
      kbo(:, 4,15, 6) = (/ &
        & 0.94397e+03,0.72889e+03,0.56242e+03,0.73973e+03,0.95035e+03 /)
      kbo(:, 5,15, 6) = (/ &
        & 0.94067e+03,0.72642e+03,0.56076e+03,0.73970e+03,0.95029e+03 /)
      kbo(:, 1,16, 6) = (/ &
        & 0.94427e+03,0.72912e+03,0.56257e+03,0.73826e+03,0.94846e+03 /)
      kbo(:, 2,16, 6) = (/ &
        & 0.94026e+03,0.72611e+03,0.56064e+03,0.73891e+03,0.94946e+03 /)
      kbo(:, 3,16, 6) = (/ &
        & 0.93679e+03,0.72351e+03,0.55906e+03,0.73929e+03,0.95011e+03 /)
      kbo(:, 4,16, 6) = (/ &
        & 0.93377e+03,0.72124e+03,0.55770e+03,0.73948e+03,0.95036e+03 /)
      kbo(:, 5,16, 6) = (/ &
        & 0.93110e+03,0.71925e+03,0.55641e+03,0.73943e+03,0.95027e+03 /)
      kbo(:, 1,17, 6) = (/ &
        & 0.93395e+03,0.72138e+03,0.55755e+03,0.73807e+03,0.94857e+03 /)
      kbo(:, 2,17, 6) = (/ &
        & 0.93072e+03,0.71896e+03,0.55622e+03,0.73871e+03,0.94955e+03 /)
      kbo(:, 3,17, 6) = (/ &
        & 0.92792e+03,0.71686e+03,0.55497e+03,0.73909e+03,0.95015e+03 /)
      kbo(:, 4,17, 6) = (/ &
        & 0.92548e+03,0.71503e+03,0.55372e+03,0.73925e+03,0.95038e+03 /)
      kbo(:, 5,17, 6) = (/ &
        & 0.92333e+03,0.71341e+03,0.55252e+03,0.73921e+03,0.95024e+03 /)
      kbo(:, 1,18, 6) = (/ &
        & 0.92558e+03,0.71510e+03,0.55360e+03,0.73792e+03,0.94869e+03 /)
      kbo(:, 2,18, 6) = (/ &
        & 0.92297e+03,0.71315e+03,0.55237e+03,0.73856e+03,0.94963e+03 /)
      kbo(:, 3,18, 6) = (/ &
        & 0.92072e+03,0.71146e+03,0.55114e+03,0.73892e+03,0.95019e+03 /)
      kbo(:, 4,18, 6) = (/ &
        & 0.91874e+03,0.70998e+03,0.55001e+03,0.73908e+03,0.95037e+03 /)
      kbo(:, 5,18, 6) = (/ &
        & 0.91700e+03,0.70867e+03,0.54903e+03,0.73903e+03,0.95021e+03 /)
      kbo(:, 1,19, 6) = (/ &
        & 0.91879e+03,0.71001e+03,0.55004e+03,0.73782e+03,0.94880e+03 /)
      kbo(:, 2,19, 6) = (/ &
        & 0.91668e+03,0.70843e+03,0.54889e+03,0.73844e+03,0.94970e+03 /)
      kbo(:, 3,19, 6) = (/ &
        & 0.91486e+03,0.70706e+03,0.54830e+03,0.73880e+03,0.95023e+03 /)
      kbo(:, 4,19, 6) = (/ &
        & 0.91327e+03,0.70587e+03,0.54705e+03,0.73894e+03,0.95037e+03 /)
      kbo(:, 5,19, 6) = (/ &
        & 0.91186e+03,0.70481e+03,0.54615e+03,0.73887e+03,0.95019e+03 /)
      kbo(:, 1,20, 6) = (/ &
        & 0.91324e+03,0.70585e+03,0.54718e+03,0.73776e+03,0.94893e+03 /)
      kbo(:, 2,20, 6) = (/ &
        & 0.91155e+03,0.70458e+03,0.54599e+03,0.73835e+03,0.94979e+03 /)
      kbo(:, 3,20, 6) = (/ &
        & 0.91008e+03,0.70348e+03,0.54519e+03,0.73870e+03,0.95026e+03 /)
      kbo(:, 4,20, 6) = (/ &
        & 0.90879e+03,0.70251e+03,0.54450e+03,0.73882e+03,0.95036e+03 /)
      kbo(:, 5,20, 6) = (/ &
        & 0.90766e+03,0.70166e+03,0.54390e+03,0.73874e+03,0.95013e+03 /)
      kbo(:, 1,21, 6) = (/ &
        & 0.90874e+03,0.70247e+03,0.54444e+03,0.73773e+03,0.94905e+03 /)
      kbo(:, 2,21, 6) = (/ &
        & 0.90737e+03,0.70145e+03,0.54370e+03,0.73831e+03,0.94986e+03 /)
      kbo(:, 3,21, 6) = (/ &
        & 0.90619e+03,0.70056e+03,0.54308e+03,0.73862e+03,0.95029e+03 /)
      kbo(:, 4,21, 6) = (/ &
        & 0.90515e+03,0.69978e+03,0.54255e+03,0.73872e+03,0.95035e+03 /)
      kbo(:, 5,21, 6) = (/ &
        & 0.90424e+03,0.69910e+03,0.54208e+03,0.73862e+03,0.95008e+03 /)
      kbo(:, 1,22, 6) = (/ &
        & 0.90500e+03,0.69967e+03,0.54240e+03,0.73776e+03,0.94923e+03 /)
      kbo(:, 2,22, 6) = (/ &
        & 0.90392e+03,0.69886e+03,0.54185e+03,0.73829e+03,0.94997e+03 /)
      kbo(:, 3,22, 6) = (/ &
        & 0.90297e+03,0.69815e+03,0.54138e+03,0.73857e+03,0.95033e+03 /)
      kbo(:, 4,22, 6) = (/ &
        & 0.90215e+03,0.69753e+03,0.54099e+03,0.73864e+03,0.95033e+03 /)
      kbo(:, 5,22, 6) = (/ &
        & 0.90141e+03,0.69698e+03,0.54066e+03,0.73851e+03,0.94999e+03 /)
      kbo(:, 1,23, 6) = (/ &
        & 0.90199e+03,0.69741e+03,0.54083e+03,0.73780e+03,0.94940e+03 /)
      kbo(:, 2,23, 6) = (/ &
        & 0.90112e+03,0.69676e+03,0.54044e+03,0.73828e+03,0.95007e+03 /)
      kbo(:, 3,23, 6) = (/ &
        & 0.90037e+03,0.69620e+03,0.54010e+03,0.73854e+03,0.95036e+03 /)
      kbo(:, 4,23, 6) = (/ &
        & 0.89971e+03,0.69570e+03,0.53983e+03,0.73858e+03,0.95029e+03 /)
      kbo(:, 5,23, 6) = (/ &
        & 0.89912e+03,0.69526e+03,0.53959e+03,0.73840e+03,0.94989e+03 /)
      kbo(:, 1,24, 6) = (/ &
        & 0.89955e+03,0.69558e+03,0.53965e+03,0.73787e+03,0.94957e+03 /)
      kbo(:, 2,24, 6) = (/ &
        & 0.89886e+03,0.69507e+03,0.53937e+03,0.73829e+03,0.95016e+03 /)
      kbo(:, 3,24, 6) = (/ &
        & 0.89826e+03,0.69461e+03,0.53914e+03,0.73851e+03,0.95038e+03 /)
      kbo(:, 4,24, 6) = (/ &
        & 0.89773e+03,0.69422e+03,0.53895e+03,0.73850e+03,0.95023e+03 /)
      kbo(:, 5,24, 6) = (/ &
        & 0.89726e+03,0.69387e+03,0.53876e+03,0.73829e+03,0.94977e+03 /)
      kbo(:, 1,25, 6) = (/ &
        & 0.89758e+03,0.69410e+03,0.53876e+03,0.73792e+03,0.94973e+03 /)
      kbo(:, 2,25, 6) = (/ &
        & 0.89703e+03,0.69369e+03,0.53857e+03,0.73831e+03,0.95024e+03 /)
      kbo(:, 3,25, 6) = (/ &
        & 0.89655e+03,0.69333e+03,0.53841e+03,0.73848e+03,0.95037e+03 /)
      kbo(:, 4,25, 6) = (/ &
        & 0.89613e+03,0.69302e+03,0.53826e+03,0.73843e+03,0.95016e+03 /)
      kbo(:, 5,25, 6) = (/ &
        & 0.89576e+03,0.69273e+03,0.53811e+03,0.73818e+03,0.94963e+03 /)
      kbo(:, 1,26, 6) = (/ &
        & 0.89598e+03,0.69290e+03,0.53808e+03,0.73799e+03,0.94987e+03 /)
      kbo(:, 2,26, 6) = (/ &
        & 0.89555e+03,0.69258e+03,0.53794e+03,0.73834e+03,0.95030e+03 /)
      kbo(:, 3,26, 6) = (/ &
        & 0.89517e+03,0.69229e+03,0.53782e+03,0.73845e+03,0.95035e+03 /)
      kbo(:, 4,26, 6) = (/ &
        & 0.89483e+03,0.69204e+03,0.53770e+03,0.73836e+03,0.95007e+03 /)
      kbo(:, 5,26, 6) = (/ &
        & 0.89453e+03,0.69182e+03,0.53759e+03,0.73806e+03,0.94946e+03 /)
      kbo(:, 1,27, 6) = (/ &
        & 0.89469e+03,0.69194e+03,0.53754e+03,0.73806e+03,0.95001e+03 /)
      kbo(:, 2,27, 6) = (/ &
        & 0.89435e+03,0.69168e+03,0.53744e+03,0.73835e+03,0.95034e+03 /)
      kbo(:, 3,27, 6) = (/ &
        & 0.89405e+03,0.69145e+03,0.53736e+03,0.73843e+03,0.95031e+03 /)
      kbo(:, 4,27, 6) = (/ &
        & 0.89378e+03,0.69125e+03,0.53727e+03,0.73828e+03,0.94995e+03 /)
      kbo(:, 5,27, 6) = (/ &
        & 0.89354e+03,0.69107e+03,0.53717e+03,0.73792e+03,0.94926e+03 /)
      kbo(:, 1,28, 6) = (/ &
        & 0.89366e+03,0.69116e+03,0.53711e+03,0.73814e+03,0.95012e+03 /)
      kbo(:, 2,28, 6) = (/ &
        & 0.89338e+03,0.69096e+03,0.53705e+03,0.73836e+03,0.95037e+03 /)
      kbo(:, 3,28, 6) = (/ &
        & 0.89314e+03,0.69078e+03,0.53699e+03,0.73838e+03,0.95026e+03 /)
      kbo(:, 4,28, 6) = (/ &
        & 0.89293e+03,0.69062e+03,0.53692e+03,0.73819e+03,0.94982e+03 /)
      kbo(:, 5,28, 6) = (/ &
        & 0.89274e+03,0.69047e+03,0.53684e+03,0.73778e+03,0.94904e+03 /)
      kbo(:, 1,29, 6) = (/ &
        & 0.89282e+03,0.69053e+03,0.53678e+03,0.73818e+03,0.95022e+03 /)
      kbo(:, 2,29, 6) = (/ &
        & 0.89261e+03,0.69037e+03,0.53674e+03,0.73837e+03,0.95037e+03 /)
      kbo(:, 3,29, 6) = (/ &
        & 0.89241e+03,0.69023e+03,0.53670e+03,0.73834e+03,0.95018e+03 /)
      kbo(:, 4,29, 6) = (/ &
        & 0.89224e+03,0.69010e+03,0.53663e+03,0.73810e+03,0.94966e+03 /)
      kbo(:, 5,29, 6) = (/ &
        & 0.89209e+03,0.68999e+03,0.53656e+03,0.73762e+03,0.94880e+03 /)
      kbo(:, 1,30, 6) = (/ &
        & 0.89215e+03,0.69003e+03,0.53652e+03,0.73823e+03,0.95029e+03 /)
      kbo(:, 2,30, 6) = (/ &
        & 0.89198e+03,0.68990e+03,0.53650e+03,0.73836e+03,0.95035e+03 /)
      kbo(:, 3,30, 6) = (/ &
        & 0.89183e+03,0.68979e+03,0.53646e+03,0.73828e+03,0.95008e+03 /)
      kbo(:, 4,30, 6) = (/ &
        & 0.89169e+03,0.68969e+03,0.53641e+03,0.73798e+03,0.94948e+03 /)
      kbo(:, 5,30, 6) = (/ &
        & 0.89157e+03,0.68960e+03,0.53634e+03,0.73744e+03,0.94852e+03 /)
      kbo(:, 1,31, 6) = (/ &
        & 0.89161e+03,0.68962e+03,0.53631e+03,0.73827e+03,0.95034e+03 /)
      kbo(:, 2,31, 6) = (/ &
        & 0.89147e+03,0.68952e+03,0.53629e+03,0.73835e+03,0.95031e+03 /)
      kbo(:, 3,31, 6) = (/ &
        & 0.89135e+03,0.68943e+03,0.53627e+03,0.73821e+03,0.94996e+03 /)
      kbo(:, 4,31, 6) = (/ &
        & 0.89124e+03,0.68935e+03,0.53622e+03,0.73786e+03,0.94927e+03 /)
      kbo(:, 5,31, 6) = (/ &
        & 0.89115e+03,0.68928e+03,0.53615e+03,0.73725e+03,0.94822e+03 /)
      kbo(:, 1,32, 6) = (/ &
        & 0.89117e+03,0.68930e+03,0.53614e+03,0.73830e+03,0.95037e+03 /)
      kbo(:, 2,32, 6) = (/ &
        & 0.89106e+03,0.68922e+03,0.53614e+03,0.73833e+03,0.95025e+03 /)
      kbo(:, 3,32, 6) = (/ &
        & 0.89097e+03,0.68914e+03,0.53611e+03,0.73813e+03,0.94981e+03 /)
      kbo(:, 4,32, 6) = (/ &
        & 0.89088e+03,0.68908e+03,0.53608e+03,0.73772e+03,0.94903e+03 /)
      kbo(:, 5,32, 6) = (/ &
        & 0.89081e+03,0.68902e+03,0.53600e+03,0.73703e+03,0.94789e+03 /)
      kbo(:, 1,33, 6) = (/ &
        & 0.89082e+03,0.68903e+03,0.53602e+03,0.73832e+03,0.95037e+03 /)
      kbo(:, 2,33, 6) = (/ &
        & 0.89073e+03,0.68897e+03,0.53601e+03,0.73829e+03,0.95017e+03 /)
      kbo(:, 3,33, 6) = (/ &
        & 0.89066e+03,0.68891e+03,0.53599e+03,0.73804e+03,0.94964e+03 /)
      kbo(:, 4,33, 6) = (/ &
        & 0.89059e+03,0.68886e+03,0.53595e+03,0.73756e+03,0.94877e+03 /)
      kbo(:, 5,33, 6) = (/ &
        & 0.89053e+03,0.68882e+03,0.53586e+03,0.73678e+03,0.94753e+03 /)
      kbo(:, 1,34, 6) = (/ &
        & 0.89054e+03,0.68882e+03,0.53592e+03,0.73832e+03,0.95035e+03 /)
      kbo(:, 2,34, 6) = (/ &
        & 0.89047e+03,0.68877e+03,0.53592e+03,0.73824e+03,0.95008e+03 /)
      kbo(:, 3,34, 6) = (/ &
        & 0.89041e+03,0.68873e+03,0.53589e+03,0.73795e+03,0.94947e+03 /)
      kbo(:, 4,34, 6) = (/ &
        & 0.89036e+03,0.68869e+03,0.53584e+03,0.73741e+03,0.94852e+03 /)
      kbo(:, 5,34, 6) = (/ &
        & 0.89031e+03,0.68865e+03,0.53575e+03,0.73655e+03,0.94719e+03 /)
      kbo(:, 1,35, 6) = (/ &
        & 0.89032e+03,0.68866e+03,0.53584e+03,0.73832e+03,0.95034e+03 /)
      kbo(:, 2,35, 6) = (/ &
        & 0.89027e+03,0.68862e+03,0.53584e+03,0.73821e+03,0.95002e+03 /)
      kbo(:, 3,35, 6) = (/ &
        & 0.89022e+03,0.68858e+03,0.53581e+03,0.73788e+03,0.94937e+03 /)
      kbo(:, 4,35, 6) = (/ &
        & 0.89017e+03,0.68855e+03,0.53576e+03,0.73731e+03,0.94836e+03 /)
      kbo(:, 5,35, 6) = (/ &
        & 0.89013e+03,0.68852e+03,0.53567e+03,0.73640e+03,0.94700e+03 /)
      kbo(:, 1,36, 6) = (/ &
        & 0.89015e+03,0.68853e+03,0.53577e+03,0.73831e+03,0.95033e+03 /)
      kbo(:, 2,36, 6) = (/ &
        & 0.89010e+03,0.68849e+03,0.53577e+03,0.73820e+03,0.95001e+03 /)
      kbo(:, 3,36, 6) = (/ &
        & 0.89006e+03,0.68846e+03,0.53575e+03,0.73787e+03,0.94935e+03 /)
      kbo(:, 4,36, 6) = (/ &
        & 0.89003e+03,0.68844e+03,0.53570e+03,0.73729e+03,0.94834e+03 /)
      kbo(:, 5,36, 6) = (/ &
        & 0.88999e+03,0.68841e+03,0.53561e+03,0.73637e+03,0.94696e+03 /)
      kbo(:, 1,37, 6) = (/ &
        & 0.89001e+03,0.68843e+03,0.53571e+03,0.73831e+03,0.95036e+03 /)
      kbo(:, 2,37, 6) = (/ &
        & 0.88997e+03,0.68840e+03,0.53572e+03,0.73823e+03,0.95007e+03 /)
      kbo(:, 3,37, 6) = (/ &
        & 0.88994e+03,0.68837e+03,0.53570e+03,0.73792e+03,0.94946e+03 /)
      kbo(:, 4,37, 6) = (/ &
        & 0.88991e+03,0.68835e+03,0.53566e+03,0.73738e+03,0.94849e+03 /)
      kbo(:, 5,37, 6) = (/ &
        & 0.88988e+03,0.68833e+03,0.53557e+03,0.73651e+03,0.94716e+03 /)
      kbo(:, 1,38, 6) = (/ &
        & 0.88990e+03,0.68834e+03,0.53566e+03,0.73830e+03,0.95036e+03 /)
      kbo(:, 2,38, 6) = (/ &
        & 0.88987e+03,0.68832e+03,0.53568e+03,0.73825e+03,0.95013e+03 /)
      kbo(:, 3,38, 6) = (/ &
        & 0.88984e+03,0.68830e+03,0.53566e+03,0.73798e+03,0.94957e+03 /)
      kbo(:, 4,38, 6) = (/ &
        & 0.88982e+03,0.68828e+03,0.53563e+03,0.73747e+03,0.94865e+03 /)
      kbo(:, 5,38, 6) = (/ &
        & 0.88979e+03,0.68826e+03,0.53555e+03,0.73665e+03,0.94737e+03 /)
      kbo(:, 1,39, 6) = (/ &
        & 0.88981e+03,0.68827e+03,0.53562e+03,0.73829e+03,0.95037e+03 /)
      kbo(:, 2,39, 6) = (/ &
        & 0.88978e+03,0.68825e+03,0.53564e+03,0.73826e+03,0.95018e+03 /)
      kbo(:, 3,39, 6) = (/ &
        & 0.88976e+03,0.68824e+03,0.53563e+03,0.73803e+03,0.94966e+03 /)
      kbo(:, 4,39, 6) = (/ &
        & 0.88974e+03,0.68822e+03,0.53560e+03,0.73755e+03,0.94880e+03 /)
      kbo(:, 5,39, 6) = (/ &
        & 0.88972e+03,0.68821e+03,0.53553e+03,0.73679e+03,0.94757e+03 /)
      kbo(:, 1,40, 6) = (/ &
        & 0.88973e+03,0.68822e+03,0.53558e+03,0.73826e+03,0.95037e+03 /)
      kbo(:, 2,40, 6) = (/ &
        & 0.88971e+03,0.68820e+03,0.53561e+03,0.73829e+03,0.95026e+03 /)
      kbo(:, 3,40, 6) = (/ &
        & 0.88969e+03,0.68819e+03,0.53561e+03,0.73810e+03,0.94982e+03 /)
      kbo(:, 4,40, 6) = (/ &
        & 0.88967e+03,0.68817e+03,0.53559e+03,0.73769e+03,0.94904e+03 /)
      kbo(:, 5,40, 6) = (/ &
        & 0.88966e+03,0.68816e+03,0.53553e+03,0.73700e+03,0.94790e+03 /)
      kbo(:, 1,41, 6) = (/ &
        & 0.88967e+03,0.68817e+03,0.53555e+03,0.73822e+03,0.95035e+03 /)
      kbo(:, 2,41, 6) = (/ &
        & 0.88965e+03,0.68816e+03,0.53558e+03,0.73830e+03,0.95031e+03 /)
      kbo(:, 3,41, 6) = (/ &
        & 0.88964e+03,0.68815e+03,0.53559e+03,0.73817e+03,0.94996e+03 /)
      kbo(:, 4,41, 6) = (/ &
        & 0.88962e+03,0.68813e+03,0.53558e+03,0.73782e+03,0.94927e+03 /)
      kbo(:, 5,41, 6) = (/ &
        & 0.88961e+03,0.68812e+03,0.53553e+03,0.73722e+03,0.94822e+03 /)
      kbo(:, 1,42, 6) = (/ &
        & 0.88962e+03,0.68813e+03,0.53551e+03,0.73816e+03,0.95029e+03 /)
      kbo(:, 2,42, 6) = (/ &
        & 0.88960e+03,0.68812e+03,0.53555e+03,0.73830e+03,0.95035e+03 /)
      kbo(:, 3,42, 6) = (/ &
        & 0.88959e+03,0.68811e+03,0.53557e+03,0.73822e+03,0.95008e+03 /)
      kbo(:, 4,42, 6) = (/ &
        & 0.88958e+03,0.68810e+03,0.53556e+03,0.73793e+03,0.94948e+03 /)
      kbo(:, 5,42, 6) = (/ &
        & 0.88957e+03,0.68809e+03,0.53553e+03,0.73739e+03,0.94853e+03 /)
      kbo(:, 1,43, 6) = (/ &
        & 0.88958e+03,0.68810e+03,0.53547e+03,0.73807e+03,0.95020e+03 /)
      kbo(:, 2,43, 6) = (/ &
        & 0.88957e+03,0.68809e+03,0.53552e+03,0.73828e+03,0.95037e+03 /)
      kbo(:, 3,43, 6) = (/ &
        & 0.88955e+03,0.68808e+03,0.53555e+03,0.73826e+03,0.95020e+03 /)
      kbo(:, 4,43, 6) = (/ &
        & 0.88954e+03,0.68808e+03,0.53555e+03,0.73804e+03,0.94970e+03 /)
      kbo(:, 5,43, 6) = (/ &
        & 0.88953e+03,0.68807e+03,0.53553e+03,0.73758e+03,0.94886e+03 /)
      kbo(:, 1,44, 6) = (/ &
        & 0.88954e+03,0.68808e+03,0.53544e+03,0.73795e+03,0.95005e+03 /)
      kbo(:, 2,44, 6) = (/ &
        & 0.88953e+03,0.68807e+03,0.53549e+03,0.73823e+03,0.95035e+03 /)
      kbo(:, 3,44, 6) = (/ &
        & 0.88952e+03,0.68806e+03,0.53553e+03,0.73829e+03,0.95030e+03 /)
      kbo(:, 4,44, 6) = (/ &
        & 0.88951e+03,0.68805e+03,0.53554e+03,0.73815e+03,0.94991e+03 /)
      kbo(:, 5,44, 6) = (/ &
        & 0.88951e+03,0.68805e+03,0.53553e+03,0.73776e+03,0.94919e+03 /)
      kbo(:, 1,45, 6) = (/ &
        & 0.88952e+03,0.68806e+03,0.53540e+03,0.73782e+03,0.94987e+03 /)
      kbo(:, 2,45, 6) = (/ &
        & 0.88951e+03,0.68805e+03,0.53547e+03,0.73816e+03,0.95030e+03 /)
      kbo(:, 3,45, 6) = (/ &
        & 0.88950e+03,0.68804e+03,0.53551e+03,0.73830e+03,0.95035e+03 /)
      kbo(:, 4,45, 6) = (/ &
        & 0.88949e+03,0.68804e+03,0.53553e+03,0.73821e+03,0.95008e+03 /)
      kbo(:, 5,45, 6) = (/ &
        & 0.88948e+03,0.68803e+03,0.53553e+03,0.73792e+03,0.94947e+03 /)
      kbo(:, 1,46, 6) = (/ &
        & 0.88949e+03,0.68804e+03,0.53537e+03,0.73763e+03,0.94962e+03 /)
      kbo(:, 2,46, 6) = (/ &
        & 0.88948e+03,0.68803e+03,0.53544e+03,0.73806e+03,0.95019e+03 /)
      kbo(:, 3,46, 6) = (/ &
        & 0.88948e+03,0.68803e+03,0.53549e+03,0.73827e+03,0.95037e+03 /)
      kbo(:, 4,46, 6) = (/ &
        & 0.88947e+03,0.68802e+03,0.53552e+03,0.73827e+03,0.95021e+03 /)
      kbo(:, 5,46, 6) = (/ &
        & 0.88946e+03,0.68802e+03,0.53552e+03,0.73805e+03,0.94973e+03 /)
      kbo(:, 1,47, 6) = (/ &
        & 0.88947e+03,0.68802e+03,0.53531e+03,0.73737e+03,0.94929e+03 /)
      kbo(:, 2,47, 6) = (/ &
        & 0.88947e+03,0.68802e+03,0.53539e+03,0.73792e+03,0.95000e+03 /)
      kbo(:, 3,47, 6) = (/ &
        & 0.88946e+03,0.68801e+03,0.53546e+03,0.73821e+03,0.95034e+03 /)
      kbo(:, 4,47, 6) = (/ &
        & 0.88945e+03,0.68801e+03,0.53550e+03,0.73829e+03,0.95032e+03 /)
      kbo(:, 5,47, 6) = (/ &
        & 0.88945e+03,0.68800e+03,0.53551e+03,0.73816e+03,0.94996e+03 /)
      kbo(:, 1,48, 6) = (/ &
        & 0.88946e+03,0.68801e+03,0.53528e+03,0.73708e+03,0.94889e+03 /)
      kbo(:, 2,48, 6) = (/ &
        & 0.88945e+03,0.68801e+03,0.53536e+03,0.73773e+03,0.94976e+03 /)
      kbo(:, 3,48, 6) = (/ &
        & 0.88944e+03,0.68800e+03,0.53543e+03,0.73812e+03,0.95025e+03 /)
      kbo(:, 4,48, 6) = (/ &
        & 0.88944e+03,0.68800e+03,0.53548e+03,0.73829e+03,0.95037e+03 /)
      kbo(:, 5,48, 6) = (/ &
        & 0.88944e+03,0.68800e+03,0.53551e+03,0.73824e+03,0.95014e+03 /)
      kbo(:, 1,49, 6) = (/ &
        & 0.88944e+03,0.68800e+03,0.53524e+03,0.73674e+03,0.94844e+03 /)
      kbo(:, 2,49, 6) = (/ &
        & 0.88944e+03,0.68800e+03,0.53533e+03,0.73750e+03,0.94945e+03 /)
      kbo(:, 3,49, 6) = (/ &
        & 0.88943e+03,0.68799e+03,0.53540e+03,0.73799e+03,0.95016e+03 /)
      kbo(:, 4,49, 6) = (/ &
        & 0.88943e+03,0.68799e+03,0.53546e+03,0.73825e+03,0.95036e+03 /)
      kbo(:, 5,49, 6) = (/ &
        & 0.88942e+03,0.68799e+03,0.53549e+03,0.73828e+03,0.95027e+03 /)
      kbo(:, 1,50, 6) = (/ &
        & 0.88943e+03,0.68799e+03,0.53521e+03,0.73638e+03,0.94796e+03 /)
      kbo(:, 2,50, 6) = (/ &
        & 0.88943e+03,0.68799e+03,0.53529e+03,0.73724e+03,0.94911e+03 /)
      kbo(:, 3,50, 6) = (/ &
        & 0.88942e+03,0.68798e+03,0.53537e+03,0.73783e+03,0.94990e+03 /)
      kbo(:, 4,50, 6) = (/ &
        & 0.88942e+03,0.68798e+03,0.53544e+03,0.73817e+03,0.95031e+03 /)
      kbo(:, 5,50, 6) = (/ &
        & 0.88942e+03,0.68798e+03,0.53548e+03,0.73829e+03,0.95034e+03 /)
      kbo(:, 1,51, 6) = (/ &
        & 0.88942e+03,0.68798e+03,0.53518e+03,0.73600e+03,0.94745e+03 /)
      kbo(:, 2,51, 6) = (/ &
        & 0.88942e+03,0.68798e+03,0.53525e+03,0.73696e+03,0.94873e+03 /)
      kbo(:, 3,51, 6) = (/ &
        & 0.88941e+03,0.68798e+03,0.53533e+03,0.73765e+03,0.94966e+03 /)
      kbo(:, 4,51, 6) = (/ &
        & 0.88941e+03,0.68798e+03,0.53541e+03,0.73807e+03,0.95020e+03 /)
      kbo(:, 5,51, 6) = (/ &
        & 0.88941e+03,0.68797e+03,0.53546e+03,0.73827e+03,0.95037e+03 /)
      kbo(:, 1,52, 6) = (/ &
        & 0.88941e+03,0.68798e+03,0.53513e+03,0.73556e+03,0.94688e+03 /)
      kbo(:, 2,52, 6) = (/ &
        & 0.88941e+03,0.68798e+03,0.53522e+03,0.73664e+03,0.94831e+03 /)
      kbo(:, 3,52, 6) = (/ &
        & 0.88941e+03,0.68797e+03,0.53531e+03,0.73743e+03,0.94936e+03 /)
      kbo(:, 4,52, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53538e+03,0.73795e+03,0.95005e+03 /)
      kbo(:, 5,52, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53545e+03,0.73822e+03,0.95036e+03 /)
      kbo(:, 1,53, 6) = (/ &
        & 0.88941e+03,0.68797e+03,0.53507e+03,0.73509e+03,0.94627e+03 /)
      kbo(:, 2,53, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53519e+03,0.73629e+03,0.94784e+03 /)
      kbo(:, 3,53, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53527e+03,0.73717e+03,0.94902e+03 /)
      kbo(:, 4,53, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53535e+03,0.73779e+03,0.94984e+03 /)
      kbo(:, 5,53, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53542e+03,0.73815e+03,0.95029e+03 /)
      kbo(:, 1,54, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53502e+03,0.73463e+03,0.94566e+03 /)
      kbo(:, 2,54, 6) = (/ &
        & 0.88940e+03,0.68797e+03,0.53516e+03,0.73592e+03,0.94735e+03 /)
      kbo(:, 3,54, 6) = (/ &
        & 0.88940e+03,0.68796e+03,0.53524e+03,0.73691e+03,0.94866e+03 /)
      kbo(:, 4,54, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53533e+03,0.73761e+03,0.94961e+03 /)
      kbo(:, 5,54, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53539e+03,0.73805e+03,0.95018e+03 /)
      kbo(:, 1,55, 6) = (/ &
        & 0.88940e+03,0.68796e+03,0.53495e+03,0.73415e+03,0.94503e+03 /)
      kbo(:, 2,55, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53513e+03,0.73554e+03,0.94685e+03 /)
      kbo(:, 3,55, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53521e+03,0.73662e+03,0.94828e+03 /)
      kbo(:, 4,55, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53530e+03,0.73742e+03,0.94934e+03 /)
      kbo(:, 5,55, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53537e+03,0.73794e+03,0.95004e+03 /)
      kbo(:, 1,56, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53489e+03,0.73364e+03,0.94437e+03 /)
      kbo(:, 2,56, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53507e+03,0.73512e+03,0.94631e+03 /)
      kbo(:, 3,56, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53519e+03,0.73631e+03,0.94787e+03 /)
      kbo(:, 4,56, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53527e+03,0.73719e+03,0.94904e+03 /)
      kbo(:, 5,56, 6) = (/ &
        & 0.88938e+03,0.68796e+03,0.53535e+03,0.73780e+03,0.94987e+03 /)
      kbo(:, 1,57, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53481e+03,0.73310e+03,0.94366e+03 /)
      kbo(:, 2,57, 6) = (/ &
        & 0.88939e+03,0.68796e+03,0.53502e+03,0.73469e+03,0.94573e+03 /)
      kbo(:, 3,57, 6) = (/ &
        & 0.88938e+03,0.68796e+03,0.53516e+03,0.73597e+03,0.94741e+03 /)
      kbo(:, 4,57, 6) = (/ &
        & 0.88938e+03,0.68796e+03,0.53524e+03,0.73694e+03,0.94871e+03 /)
      kbo(:, 5,57, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53532e+03,0.73764e+03,0.94964e+03 /)
      kbo(:, 1,58, 6) = (/ &
        & 0.88938e+03,0.68796e+03,0.53474e+03,0.73255e+03,0.94296e+03 /)
      kbo(:, 2,58, 6) = (/ &
        & 0.88938e+03,0.68796e+03,0.53496e+03,0.73423e+03,0.94515e+03 /)
      kbo(:, 3,58, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53512e+03,0.73561e+03,0.94695e+03 /)
      kbo(:, 4,58, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53522e+03,0.73667e+03,0.94836e+03 /)
      kbo(:, 5,58, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53530e+03,0.73745e+03,0.94939e+03 /)
      kbo(:, 1,59, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53470e+03,0.73233e+03,0.94266e+03 /)
      kbo(:, 2,59, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53494e+03,0.73405e+03,0.94490e+03 /)
      kbo(:, 3,59, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53510e+03,0.73546e+03,0.94675e+03 /)
      kbo(:, 4,59, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53521e+03,0.73657e+03,0.94820e+03 /)
      kbo(:, 5,59, 6) = (/ &
        & 0.88938e+03,0.68795e+03,0.53529e+03,0.73737e+03,0.94929e+03 /)
      kbo(:, 1,13, 7) = (/ &
        & 0.11104e+04,0.84453e+03,0.58852e+03,0.81799e+03,0.10746e+04 /)
      kbo(:, 2,13, 7) = (/ &
        & 0.11019e+04,0.83810e+03,0.58572e+03,0.81836e+03,0.10752e+04 /)
      kbo(:, 3,13, 7) = (/ &
        & 0.10945e+04,0.83257e+03,0.58306e+03,0.81848e+03,0.10754e+04 /)
      kbo(:, 4,13, 7) = (/ &
        & 0.10881e+04,0.82775e+03,0.58047e+03,0.81831e+03,0.10753e+04 /)
      kbo(:, 5,13, 7) = (/ &
        & 0.10824e+04,0.82352e+03,0.57809e+03,0.81788e+03,0.10749e+04 /)
      kbo(:, 1,14, 7) = (/ &
        & 0.10890e+04,0.82842e+03,0.58087e+03,0.81780e+03,0.10747e+04 /)
      kbo(:, 2,14, 7) = (/ &
        & 0.10820e+04,0.82323e+03,0.57803e+03,0.81816e+03,0.10753e+04 /)
      kbo(:, 3,14, 7) = (/ &
        & 0.10761e+04,0.81875e+03,0.57524e+03,0.81827e+03,0.10754e+04 /)
      kbo(:, 4,14, 7) = (/ &
        & 0.10709e+04,0.81486e+03,0.57281e+03,0.81809e+03,0.10752e+04 /)
      kbo(:, 5,14, 7) = (/ &
        & 0.10663e+04,0.81144e+03,0.57087e+03,0.81766e+03,0.10748e+04 /)
      kbo(:, 1,15, 7) = (/ &
        & 0.10714e+04,0.81529e+03,0.57324e+03,0.81765e+03,0.10748e+04 /)
      kbo(:, 2,15, 7) = (/ &
        & 0.10659e+04,0.81110e+03,0.57094e+03,0.81800e+03,0.10753e+04 /)
      kbo(:, 3,15, 7) = (/ &
        & 0.10611e+04,0.80749e+03,0.56926e+03,0.81809e+03,0.10754e+04 /)
      kbo(:, 4,15, 7) = (/ &
        & 0.10569e+04,0.80434e+03,0.56791e+03,0.81790e+03,0.10752e+04 /)
      kbo(:, 5,15, 7) = (/ &
        & 0.10532e+04,0.80157e+03,0.56672e+03,0.81746e+03,0.10748e+04 /)
      kbo(:, 1,16, 7) = (/ &
        & 0.10572e+04,0.80460e+03,0.56822e+03,0.81755e+03,0.10748e+04 /)
      kbo(:, 2,16, 7) = (/ &
        & 0.10527e+04,0.80122e+03,0.56701e+03,0.81788e+03,0.10753e+04 /)
      kbo(:, 3,16, 7) = (/ &
        & 0.10488e+04,0.79831e+03,0.56599e+03,0.81796e+03,0.10754e+04 /)
      kbo(:, 4,16, 7) = (/ &
        & 0.10454e+04,0.79577e+03,0.56505e+03,0.81773e+03,0.10752e+04 /)
      kbo(:, 5,16, 7) = (/ &
        & 0.10425e+04,0.79354e+03,0.56418e+03,0.81728e+03,0.10747e+04 /)
      kbo(:, 1,17, 7) = (/ &
        & 0.10456e+04,0.79593e+03,0.56540e+03,0.81747e+03,0.10749e+04 /)
      kbo(:, 2,17, 7) = (/ &
        & 0.10420e+04,0.79321e+03,0.56464e+03,0.81778e+03,0.10753e+04 /)
      kbo(:, 3,17, 7) = (/ &
        & 0.10389e+04,0.79086e+03,0.56406e+03,0.81783e+03,0.10754e+04 /)
      kbo(:, 4,17, 7) = (/ &
        & 0.10362e+04,0.78881e+03,0.56355e+03,0.81761e+03,0.10751e+04 /)
      kbo(:, 5,17, 7) = (/ &
        & 0.10337e+04,0.78701e+03,0.56298e+03,0.81712e+03,0.10746e+04 /)
      kbo(:, 1,18, 7) = (/ &
        & 0.10363e+04,0.78890e+03,0.56372e+03,0.81741e+03,0.10750e+04 /)
      kbo(:, 2,18, 7) = (/ &
        & 0.10334e+04,0.78671e+03,0.56351e+03,0.81771e+03,0.10753e+04 /)
      kbo(:, 3,18, 7) = (/ &
        & 0.10308e+04,0.78481e+03,0.56335e+03,0.81775e+03,0.10754e+04 /)
      kbo(:, 4,18, 7) = (/ &
        & 0.10286e+04,0.78316e+03,0.56306e+03,0.81749e+03,0.10751e+04 /)
      kbo(:, 5,18, 7) = (/ &
        & 0.10267e+04,0.78170e+03,0.56253e+03,0.81698e+03,0.10746e+04 /)
      kbo(:, 1,19, 7) = (/ &
        & 0.10287e+04,0.78319e+03,0.56306e+03,0.81737e+03,0.10751e+04 /)
      kbo(:, 2,19, 7) = (/ &
        & 0.10263e+04,0.78143e+03,0.56317e+03,0.81766e+03,0.10754e+04 /)
      kbo(:, 3,19, 7) = (/ &
        & 0.10243e+04,0.77990e+03,0.56256e+03,0.81764e+03,0.10753e+04 /)
      kbo(:, 4,19, 7) = (/ &
        & 0.10225e+04,0.77856e+03,0.56270e+03,0.81737e+03,0.10751e+04 /)
      kbo(:, 5,19, 7) = (/ &
        & 0.10209e+04,0.77738e+03,0.56230e+03,0.81685e+03,0.10745e+04 /)
      kbo(:, 1,20, 7) = (/ &
        & 0.10225e+04,0.77853e+03,0.56258e+03,0.81735e+03,0.10751e+04 /)
      kbo(:, 2,20, 7) = (/ &
        & 0.10206e+04,0.77711e+03,0.56304e+03,0.81761e+03,0.10754e+04 /)
      kbo(:, 3,20, 7) = (/ &
        & 0.10189e+04,0.77589e+03,0.56295e+03,0.81757e+03,0.10753e+04 /)
      kbo(:, 4,20, 7) = (/ &
        & 0.10175e+04,0.77480e+03,0.56264e+03,0.81728e+03,0.10750e+04 /)
      kbo(:, 5,20, 7) = (/ &
        & 0.10162e+04,0.77385e+03,0.56211e+03,0.81672e+03,0.10744e+04 /)
      kbo(:, 1,21, 7) = (/ &
        & 0.10174e+04,0.77475e+03,0.56279e+03,0.81734e+03,0.10752e+04 /)
      kbo(:, 2,21, 7) = (/ &
        & 0.10159e+04,0.77361e+03,0.56292e+03,0.81756e+03,0.10754e+04 /)
      kbo(:, 3,21, 7) = (/ &
        & 0.10146e+04,0.77262e+03,0.56281e+03,0.81751e+03,0.10753e+04 /)
      kbo(:, 4,21, 7) = (/ &
        & 0.10134e+04,0.77175e+03,0.56248e+03,0.81718e+03,0.10750e+04 /)
      kbo(:, 5,21, 7) = (/ &
        & 0.10124e+04,0.77098e+03,0.56193e+03,0.81661e+03,0.10743e+04 /)
      kbo(:, 1,22, 7) = (/ &
        & 0.10132e+04,0.77163e+03,0.56273e+03,0.81736e+03,0.10752e+04 /)
      kbo(:, 2,22, 7) = (/ &
        & 0.10120e+04,0.77071e+03,0.56281e+03,0.81753e+03,0.10754e+04 /)
      kbo(:, 3,22, 7) = (/ &
        & 0.10110e+04,0.76992e+03,0.56267e+03,0.81743e+03,0.10753e+04 /)
      kbo(:, 4,22, 7) = (/ &
        & 0.10100e+04,0.76922e+03,0.56230e+03,0.81706e+03,0.10749e+04 /)
      kbo(:, 5,22, 7) = (/ &
        & 0.10092e+04,0.76860e+03,0.56172e+03,0.81643e+03,0.10742e+04 /)
      kbo(:, 1,23, 7) = (/ &
        & 0.10099e+04,0.76909e+03,0.56267e+03,0.81738e+03,0.10753e+04 /)
      kbo(:, 2,23, 7) = (/ &
        & 0.10089e+04,0.76836e+03,0.56273e+03,0.81751e+03,0.10754e+04 /)
      kbo(:, 3,23, 7) = (/ &
        & 0.10080e+04,0.76773e+03,0.56254e+03,0.81734e+03,0.10752e+04 /)
      kbo(:, 4,23, 7) = (/ &
        & 0.10073e+04,0.76717e+03,0.56214e+03,0.81691e+03,0.10748e+04 /)
      kbo(:, 5,23, 7) = (/ &
        & 0.10067e+04,0.76668e+03,0.56152e+03,0.81625e+03,0.10740e+04 /)
      kbo(:, 1,24, 7) = (/ &
        & 0.10071e+04,0.76704e+03,0.56263e+03,0.81739e+03,0.10753e+04 /)
      kbo(:, 2,24, 7) = (/ &
        & 0.10064e+04,0.76647e+03,0.56264e+03,0.81747e+03,0.10754e+04 /)
      kbo(:, 3,24, 7) = (/ &
        & 0.10057e+04,0.76596e+03,0.56242e+03,0.81725e+03,0.10751e+04 /)
      kbo(:, 4,24, 7) = (/ &
        & 0.10051e+04,0.76551e+03,0.56198e+03,0.81678e+03,0.10746e+04 /)
      kbo(:, 5,24, 7) = (/ &
        & 0.10046e+04,0.76512e+03,0.56132e+03,0.81606e+03,0.10738e+04 /)
      kbo(:, 1,25, 7) = (/ &
        & 0.10049e+04,0.76538e+03,0.56260e+03,0.81741e+03,0.10754e+04 /)
      kbo(:, 2,25, 7) = (/ &
        & 0.10043e+04,0.76492e+03,0.56256e+03,0.81742e+03,0.10753e+04 /)
      kbo(:, 3,25, 7) = (/ &
        & 0.10038e+04,0.76453e+03,0.56229e+03,0.81717e+03,0.10750e+04 /)
      kbo(:, 4,25, 7) = (/ &
        & 0.10033e+04,0.76417e+03,0.56181e+03,0.81663e+03,0.10745e+04 /)
      kbo(:, 5,25, 7) = (/ &
        & 0.10029e+04,0.76385e+03,0.56111e+03,0.81585e+03,0.10736e+04 /)
      kbo(:, 1,26, 7) = (/ &
        & 0.10031e+04,0.76404e+03,0.56257e+03,0.81743e+03,0.10754e+04 /)
      kbo(:, 2,26, 7) = (/ &
        & 0.10026e+04,0.76368e+03,0.56248e+03,0.81736e+03,0.10753e+04 /)
      kbo(:, 3,26, 7) = (/ &
        & 0.10022e+04,0.76336e+03,0.56216e+03,0.81707e+03,0.10749e+04 /)
      kbo(:, 4,26, 7) = (/ &
        & 0.10018e+04,0.76308e+03,0.56163e+03,0.81645e+03,0.10743e+04 /)
      kbo(:, 5,26, 7) = (/ &
        & 0.10015e+04,0.76282e+03,0.56088e+03,0.81561e+03,0.10734e+04 /)
      kbo(:, 1,27, 7) = (/ &
        & 0.10017e+04,0.76296e+03,0.56253e+03,0.81743e+03,0.10754e+04 /)
      kbo(:, 2,27, 7) = (/ &
        & 0.10013e+04,0.76268e+03,0.56239e+03,0.81730e+03,0.10752e+04 /)
      kbo(:, 3,27, 7) = (/ &
        & 0.10010e+04,0.76242e+03,0.56202e+03,0.81696e+03,0.10748e+04 /)
      kbo(:, 4,27, 7) = (/ &
        & 0.10007e+04,0.76220e+03,0.56144e+03,0.81630e+03,0.10741e+04 /)
      kbo(:, 5,27, 7) = (/ &
        & 0.10004e+04,0.76200e+03,0.56064e+03,0.81536e+03,0.10731e+04 /)
      kbo(:, 1,28, 7) = (/ &
        & 0.10005e+04,0.76209e+03,0.56249e+03,0.81738e+03,0.10754e+04 /)
      kbo(:, 2,28, 7) = (/ &
        & 0.10002e+04,0.76186e+03,0.56229e+03,0.81724e+03,0.10752e+04 /)
      kbo(:, 3,28, 7) = (/ &
        & 0.99995e+03,0.76166e+03,0.56188e+03,0.81687e+03,0.10747e+04 /)
      kbo(:, 4,28, 7) = (/ &
        & 0.99971e+03,0.76148e+03,0.56124e+03,0.81607e+03,0.10739e+04 /)
      kbo(:, 5,28, 7) = (/ &
        & 0.99950e+03,0.76132e+03,0.56040e+03,0.81510e+03,0.10728e+04 /)
      kbo(:, 1,29, 7) = (/ &
        & 0.99960e+03,0.76139e+03,0.56244e+03,0.81739e+03,0.10753e+04 /)
      kbo(:, 2,29, 7) = (/ &
        & 0.99935e+03,0.76121e+03,0.56219e+03,0.81712e+03,0.10751e+04 /)
      kbo(:, 3,29, 7) = (/ &
        & 0.99914e+03,0.76105e+03,0.56172e+03,0.81663e+03,0.10745e+04 /)
      kbo(:, 4,29, 7) = (/ &
        & 0.99895e+03,0.76091e+03,0.56103e+03,0.81584e+03,0.10737e+04 /)
      kbo(:, 5,29, 7) = (/ &
        & 0.99878e+03,0.76078e+03,0.56014e+03,0.81482e+03,0.10725e+04 /)
      kbo(:, 1,30, 7) = (/ &
        & 0.99885e+03,0.76083e+03,0.56238e+03,0.81733e+03,0.10753e+04 /)
      kbo(:, 2,30, 7) = (/ &
        & 0.99865e+03,0.76069e+03,0.56207e+03,0.81703e+03,0.10750e+04 /)
      kbo(:, 3,30, 7) = (/ &
        & 0.99848e+03,0.76055e+03,0.56155e+03,0.81643e+03,0.10743e+04 /)
      kbo(:, 4,30, 7) = (/ &
        & 0.99833e+03,0.76044e+03,0.56081e+03,0.81561e+03,0.10734e+04 /)
      kbo(:, 5,30, 7) = (/ &
        & 0.99819e+03,0.76034e+03,0.55986e+03,0.81451e+03,0.10721e+04 /)
      kbo(:, 1,31, 7) = (/ &
        & 0.99824e+03,0.76037e+03,0.56231e+03,0.81727e+03,0.10752e+04 /)
      kbo(:, 2,31, 7) = (/ &
        & 0.99808e+03,0.76026e+03,0.56195e+03,0.81690e+03,0.10748e+04 /)
      kbo(:, 3,31, 7) = (/ &
        & 0.99794e+03,0.76015e+03,0.56137e+03,0.81625e+03,0.10741e+04 /)
      kbo(:, 4,31, 7) = (/ &
        & 0.99782e+03,0.76006e+03,0.56058e+03,0.81535e+03,0.10731e+04 /)
      kbo(:, 5,31, 7) = (/ &
        & 0.99772e+03,0.75998e+03,0.55958e+03,0.81419e+03,0.10717e+04 /)
      kbo(:, 1,32, 7) = (/ &
        & 0.99774e+03,0.76000e+03,0.56222e+03,0.81719e+03,0.10752e+04 /)
      kbo(:, 2,32, 7) = (/ &
        & 0.99763e+03,0.75991e+03,0.56181e+03,0.81675e+03,0.10747e+04 /)
      kbo(:, 3,32, 7) = (/ &
        & 0.99752e+03,0.75984e+03,0.56117e+03,0.81604e+03,0.10739e+04 /)
      kbo(:, 4,32, 7) = (/ &
        & 0.99742e+03,0.75976e+03,0.56033e+03,0.81507e+03,0.10728e+04 /)
      kbo(:, 5,32, 7) = (/ &
        & 0.99733e+03,0.75970e+03,0.55927e+03,0.81384e+03,0.10713e+04 /)
      kbo(:, 1,33, 7) = (/ &
        & 0.99735e+03,0.75971e+03,0.56212e+03,0.81709e+03,0.10751e+04 /)
      kbo(:, 2,33, 7) = (/ &
        & 0.99725e+03,0.75964e+03,0.56165e+03,0.81658e+03,0.10745e+04 /)
      kbo(:, 3,33, 7) = (/ &
        & 0.99717e+03,0.75957e+03,0.56096e+03,0.81581e+03,0.10736e+04 /)
      kbo(:, 4,33, 7) = (/ &
        & 0.99709e+03,0.75952e+03,0.56006e+03,0.81477e+03,0.10724e+04 /)
      kbo(:, 5,33, 7) = (/ &
        & 0.99703e+03,0.75946e+03,0.55896e+03,0.81347e+03,0.10709e+04 /)
      kbo(:, 1,34, 7) = (/ &
        & 0.99704e+03,0.75947e+03,0.56203e+03,0.81702e+03,0.10750e+04 /)
      kbo(:, 2,34, 7) = (/ &
        & 0.99696e+03,0.75942e+03,0.56151e+03,0.81642e+03,0.10743e+04 /)
      kbo(:, 3,34, 7) = (/ &
        & 0.99689e+03,0.75937e+03,0.56077e+03,0.81558e+03,0.10734e+04 /)
      kbo(:, 4,34, 7) = (/ &
        & 0.99683e+03,0.75932e+03,0.55982e+03,0.81449e+03,0.10721e+04 /)
      kbo(:, 5,34, 7) = (/ &
        & 0.99678e+03,0.75928e+03,0.55868e+03,0.81314e+03,0.10704e+04 /)
      kbo(:, 1,35, 7) = (/ &
        & 0.99679e+03,0.75929e+03,0.56197e+03,0.81693e+03,0.10749e+04 /)
      kbo(:, 2,35, 7) = (/ &
        & 0.99673e+03,0.75925e+03,0.56142e+03,0.81633e+03,0.10742e+04 /)
      kbo(:, 3,35, 7) = (/ &
        & 0.99667e+03,0.75920e+03,0.56065e+03,0.81545e+03,0.10733e+04 /)
      kbo(:, 4,35, 7) = (/ &
        & 0.99663e+03,0.75916e+03,0.55968e+03,0.81434e+03,0.10719e+04 /)
      kbo(:, 5,35, 7) = (/ &
        & 0.99658e+03,0.75913e+03,0.55851e+03,0.81294e+03,0.10702e+04 /)
      kbo(:, 1,36, 7) = (/ &
        & 0.99660e+03,0.75914e+03,0.56195e+03,0.81692e+03,0.10749e+04 /)
      kbo(:, 2,36, 7) = (/ &
        & 0.99655e+03,0.75911e+03,0.56140e+03,0.81631e+03,0.10742e+04 /)
      kbo(:, 3,36, 7) = (/ &
        & 0.99650e+03,0.75907e+03,0.56063e+03,0.81543e+03,0.10732e+04 /)
      kbo(:, 4,36, 7) = (/ &
        & 0.99646e+03,0.75904e+03,0.55965e+03,0.81430e+03,0.10719e+04 /)
      kbo(:, 5,36, 7) = (/ &
        & 0.99642e+03,0.75901e+03,0.55848e+03,0.81290e+03,0.10702e+04 /)
      kbo(:, 1,37, 7) = (/ &
        & 0.99645e+03,0.75903e+03,0.56200e+03,0.81697e+03,0.10749e+04 /)
      kbo(:, 2,37, 7) = (/ &
        & 0.99640e+03,0.75900e+03,0.56148e+03,0.81640e+03,0.10743e+04 /)
      kbo(:, 3,37, 7) = (/ &
        & 0.99636e+03,0.75897e+03,0.56074e+03,0.81556e+03,0.10734e+04 /)
      kbo(:, 4,37, 7) = (/ &
        & 0.99633e+03,0.75894e+03,0.55979e+03,0.81446e+03,0.10721e+04 /)
      kbo(:, 5,37, 7) = (/ &
        & 0.99630e+03,0.75892e+03,0.55864e+03,0.81313e+03,0.10704e+04 /)
      kbo(:, 1,38, 7) = (/ &
        & 0.99632e+03,0.75894e+03,0.56206e+03,0.81703e+03,0.10750e+04 /)
      kbo(:, 2,38, 7) = (/ &
        & 0.99628e+03,0.75891e+03,0.56157e+03,0.81650e+03,0.10744e+04 /)
      kbo(:, 3,38, 7) = (/ &
        & 0.99625e+03,0.75889e+03,0.56085e+03,0.81569e+03,0.10735e+04 /)
      kbo(:, 4,38, 7) = (/ &
        & 0.99623e+03,0.75887e+03,0.55993e+03,0.81464e+03,0.10723e+04 /)
      kbo(:, 5,38, 7) = (/ &
        & 0.99620e+03,0.75885e+03,0.55881e+03,0.81331e+03,0.10707e+04 /)
      kbo(:, 1,39, 7) = (/ &
        & 0.99622e+03,0.75886e+03,0.56210e+03,0.81708e+03,0.10751e+04 /)
      kbo(:, 2,39, 7) = (/ &
        & 0.99619e+03,0.75884e+03,0.56164e+03,0.81666e+03,0.10745e+04 /)
      kbo(:, 3,39, 7) = (/ &
        & 0.99617e+03,0.75882e+03,0.56096e+03,0.81582e+03,0.10737e+04 /)
      kbo(:, 4,39, 7) = (/ &
        & 0.99614e+03,0.75880e+03,0.56007e+03,0.81479e+03,0.10725e+04 /)
      kbo(:, 5,39, 7) = (/ &
        & 0.99612e+03,0.75878e+03,0.55897e+03,0.81351e+03,0.10709e+04 /)
      kbo(:, 1,40, 7) = (/ &
        & 0.99613e+03,0.75880e+03,0.56218e+03,0.81716e+03,0.10752e+04 /)
      kbo(:, 2,40, 7) = (/ &
        & 0.99611e+03,0.75878e+03,0.56177e+03,0.81672e+03,0.10747e+04 /)
      kbo(:, 3,40, 7) = (/ &
        & 0.99609e+03,0.75876e+03,0.56114e+03,0.81603e+03,0.10739e+04 /)
      kbo(:, 4,40, 7) = (/ &
        & 0.99607e+03,0.75875e+03,0.56030e+03,0.81506e+03,0.10728e+04 /)
      kbo(:, 5,40, 7) = (/ &
        & 0.99605e+03,0.75874e+03,0.55925e+03,0.81383e+03,0.10713e+04 /)
      kbo(:, 1,41, 7) = (/ &
        & 0.99606e+03,0.75874e+03,0.56225e+03,0.81724e+03,0.10752e+04 /)
      kbo(:, 2,41, 7) = (/ &
        & 0.99604e+03,0.75873e+03,0.56189e+03,0.81688e+03,0.10748e+04 /)
      kbo(:, 3,41, 7) = (/ &
        & 0.99602e+03,0.75871e+03,0.56132e+03,0.81623e+03,0.10741e+04 /)
      kbo(:, 4,41, 7) = (/ &
        & 0.99601e+03,0.75870e+03,0.56053e+03,0.81532e+03,0.10731e+04 /)
      kbo(:, 5,41, 7) = (/ &
        & 0.99600e+03,0.75869e+03,0.55954e+03,0.81416e+03,0.10717e+04 /)
      kbo(:, 1,42, 7) = (/ &
        & 0.99601e+03,0.75870e+03,0.56231e+03,0.81730e+03,0.10753e+04 /)
      kbo(:, 2,42, 7) = (/ &
        & 0.99599e+03,0.75869e+03,0.56200e+03,0.81698e+03,0.10750e+04 /)
      kbo(:, 3,42, 7) = (/ &
        & 0.99597e+03,0.75868e+03,0.56149e+03,0.81641e+03,0.10743e+04 /)
      kbo(:, 4,42, 7) = (/ &
        & 0.99596e+03,0.75867e+03,0.56075e+03,0.81559e+03,0.10734e+04 /)
      kbo(:, 5,42, 7) = (/ &
        & 0.99595e+03,0.75866e+03,0.55981e+03,0.81449e+03,0.10721e+04 /)
      kbo(:, 1,43, 7) = (/ &
        & 0.99596e+03,0.75867e+03,0.56235e+03,0.81734e+03,0.10754e+04 /)
      kbo(:, 2,43, 7) = (/ &
        & 0.99595e+03,0.75866e+03,0.56212e+03,0.81712e+03,0.10751e+04 /)
      kbo(:, 3,43, 7) = (/ &
        & 0.99594e+03,0.75865e+03,0.56167e+03,0.81662e+03,0.10746e+04 /)
      kbo(:, 4,43, 7) = (/ &
        & 0.99592e+03,0.75864e+03,0.56100e+03,0.81588e+03,0.10737e+04 /)
      kbo(:, 5,43, 7) = (/ &
        & 0.99591e+03,0.75863e+03,0.56012e+03,0.81487e+03,0.10726e+04 /)
      kbo(:, 1,44, 7) = (/ &
        & 0.99592e+03,0.75864e+03,0.56237e+03,0.81736e+03,0.10754e+04 /)
      kbo(:, 2,44, 7) = (/ &
        & 0.99591e+03,0.75863e+03,0.56222e+03,0.81722e+03,0.10752e+04 /)
      kbo(:, 3,44, 7) = (/ &
        & 0.99591e+03,0.75862e+03,0.56184e+03,0.81680e+03,0.10748e+04 /)
      kbo(:, 4,44, 7) = (/ &
        & 0.99589e+03,0.75861e+03,0.56125e+03,0.81614e+03,0.10741e+04 /)
      kbo(:, 5,44, 7) = (/ &
        & 0.99588e+03,0.75861e+03,0.56044e+03,0.81523e+03,0.10730e+04 /)
      kbo(:, 1,45, 7) = (/ &
        & 0.99589e+03,0.75861e+03,0.56237e+03,0.81733e+03,0.10754e+04 /)
      kbo(:, 2,45, 7) = (/ &
        & 0.99588e+03,0.75861e+03,0.56230e+03,0.81729e+03,0.10753e+04 /)
      kbo(:, 3,45, 7) = (/ &
        & 0.99587e+03,0.75860e+03,0.56199e+03,0.81699e+03,0.10750e+04 /)
      kbo(:, 4,45, 7) = (/ &
        & 0.99586e+03,0.75859e+03,0.56147e+03,0.81641e+03,0.10743e+04 /)
      kbo(:, 5,45, 7) = (/ &
        & 0.99585e+03,0.75859e+03,0.56074e+03,0.81557e+03,0.10734e+04 /)
      kbo(:, 1,46, 7) = (/ &
        & 0.99586e+03,0.75859e+03,0.56233e+03,0.81728e+03,0.10753e+04 /)
      kbo(:, 2,46, 7) = (/ &
        & 0.99585e+03,0.75859e+03,0.56235e+03,0.81734e+03,0.10754e+04 /)
      kbo(:, 3,46, 7) = (/ &
        & 0.99585e+03,0.75858e+03,0.56213e+03,0.81712e+03,0.10751e+04 /)
      kbo(:, 4,46, 7) = (/ &
        & 0.99584e+03,0.75858e+03,0.56169e+03,0.81663e+03,0.10746e+04 /)
      kbo(:, 5,46, 7) = (/ &
        & 0.99583e+03,0.75858e+03,0.56103e+03,0.81590e+03,0.10738e+04 /)
      kbo(:, 1,47, 7) = (/ &
        & 0.99585e+03,0.75858e+03,0.56226e+03,0.81718e+03,0.10753e+04 /)
      kbo(:, 2,47, 7) = (/ &
        & 0.99583e+03,0.75857e+03,0.56237e+03,0.81736e+03,0.10754e+04 /)
      kbo(:, 3,47, 7) = (/ &
        & 0.99583e+03,0.75857e+03,0.56224e+03,0.81723e+03,0.10752e+04 /)
      kbo(:, 4,47, 7) = (/ &
        & 0.99582e+03,0.75856e+03,0.56189e+03,0.81686e+03,0.10748e+04 /)
      kbo(:, 5,47, 7) = (/ &
        & 0.99581e+03,0.75856e+03,0.56132e+03,0.81626e+03,0.10741e+04 /)
      kbo(:, 1,48, 7) = (/ &
        & 0.99582e+03,0.75856e+03,0.56215e+03,0.81703e+03,0.10751e+04 /)
      kbo(:, 2,48, 7) = (/ &
        & 0.99582e+03,0.75856e+03,0.56235e+03,0.81732e+03,0.10754e+04 /)
      kbo(:, 3,48, 7) = (/ &
        & 0.99581e+03,0.75855e+03,0.56232e+03,0.81733e+03,0.10753e+04 /)
      kbo(:, 4,48, 7) = (/ &
        & 0.99580e+03,0.75855e+03,0.56206e+03,0.81704e+03,0.10750e+04 /)
      kbo(:, 5,48, 7) = (/ &
        & 0.99580e+03,0.75855e+03,0.56157e+03,0.81651e+03,0.10744e+04 /)
      kbo(:, 1,49, 7) = (/ &
        & 0.99581e+03,0.75855e+03,0.56199e+03,0.81684e+03,0.10748e+04 /)
      kbo(:, 2,49, 7) = (/ &
        & 0.99580e+03,0.75855e+03,0.56230e+03,0.81724e+03,0.10753e+04 /)
      kbo(:, 3,49, 7) = (/ &
        & 0.99580e+03,0.75854e+03,0.56236e+03,0.81736e+03,0.10753e+04 /)
      kbo(:, 4,49, 7) = (/ &
        & 0.99579e+03,0.75854e+03,0.56219e+03,0.81718e+03,0.10752e+04 /)
      kbo(:, 5,49, 7) = (/ &
        & 0.99579e+03,0.75854e+03,0.56179e+03,0.81678e+03,0.10747e+04 /)
      kbo(:, 1,50, 7) = (/ &
        & 0.99579e+03,0.75854e+03,0.56180e+03,0.81662e+03,0.10745e+04 /)
      kbo(:, 2,50, 7) = (/ &
        & 0.99579e+03,0.75854e+03,0.56221e+03,0.81713e+03,0.10752e+04 /)
      kbo(:, 3,50, 7) = (/ &
        & 0.99579e+03,0.75854e+03,0.56237e+03,0.81735e+03,0.10754e+04 /)
      kbo(:, 4,50, 7) = (/ &
        & 0.99579e+03,0.75854e+03,0.56228e+03,0.81728e+03,0.10753e+04 /)
      kbo(:, 5,50, 7) = (/ &
        & 0.99578e+03,0.75853e+03,0.56197e+03,0.81695e+03,0.10749e+04 /)
      kbo(:, 1,51, 7) = (/ &
        & 0.99578e+03,0.75853e+03,0.56158e+03,0.81637e+03,0.10741e+04 /)
      kbo(:, 2,51, 7) = (/ &
        & 0.99578e+03,0.75853e+03,0.56209e+03,0.81697e+03,0.10750e+04 /)
      kbo(:, 3,51, 7) = (/ &
        & 0.99578e+03,0.75853e+03,0.56234e+03,0.81729e+03,0.10753e+04 /)
      kbo(:, 4,51, 7) = (/ &
        & 0.99578e+03,0.75853e+03,0.56234e+03,0.81734e+03,0.10754e+04 /)
      kbo(:, 5,51, 7) = (/ &
        & 0.99577e+03,0.75852e+03,0.56211e+03,0.81712e+03,0.10751e+04 /)
      kbo(:, 1,52, 7) = (/ &
        & 0.99577e+03,0.75853e+03,0.56131e+03,0.81608e+03,0.10737e+04 /)
      kbo(:, 2,52, 7) = (/ &
        & 0.99577e+03,0.75852e+03,0.56194e+03,0.81678e+03,0.10748e+04 /)
      kbo(:, 3,52, 7) = (/ &
        & 0.99577e+03,0.75852e+03,0.56228e+03,0.81721e+03,0.10753e+04 /)
      kbo(:, 4,52, 7) = (/ &
        & 0.99577e+03,0.75852e+03,0.56237e+03,0.81738e+03,0.10754e+04 /)
      kbo(:, 5,52, 7) = (/ &
        & 0.99576e+03,0.75852e+03,0.56222e+03,0.81722e+03,0.10752e+04 /)
      kbo(:, 1,53, 7) = (/ &
        & 0.99577e+03,0.75852e+03,0.56102e+03,0.81574e+03,0.10731e+04 /)
      kbo(:, 2,53, 7) = (/ &
        & 0.99576e+03,0.75852e+03,0.56174e+03,0.81656e+03,0.10744e+04 /)
      kbo(:, 3,53, 7) = (/ &
        & 0.99576e+03,0.75852e+03,0.56218e+03,0.81709e+03,0.10752e+04 /)
      kbo(:, 4,53, 7) = (/ &
        & 0.99576e+03,0.75851e+03,0.56236e+03,0.81734e+03,0.10754e+04 /)
      kbo(:, 5,53, 7) = (/ &
        & 0.99576e+03,0.75852e+03,0.56230e+03,0.81736e+03,0.10753e+04 /)
      kbo(:, 1,54, 7) = (/ &
        & 0.99576e+03,0.75852e+03,0.56072e+03,0.81536e+03,0.10726e+04 /)
      kbo(:, 2,54, 7) = (/ &
        & 0.99576e+03,0.75851e+03,0.56153e+03,0.81633e+03,0.10740e+04 /)
      kbo(:, 3,54, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56207e+03,0.81694e+03,0.10750e+04 /)
      kbo(:, 4,54, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56233e+03,0.81728e+03,0.10753e+04 /)
      kbo(:, 5,54, 7) = (/ &
        & 0.99576e+03,0.75851e+03,0.56235e+03,0.81734e+03,0.10754e+04 /)
      kbo(:, 1,55, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56039e+03,0.81495e+03,0.10720e+04 /)
      kbo(:, 2,55, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56128e+03,0.81606e+03,0.10736e+04 /)
      kbo(:, 3,55, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56193e+03,0.81677e+03,0.10747e+04 /)
      kbo(:, 4,55, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56227e+03,0.81720e+03,0.10753e+04 /)
      kbo(:, 5,55, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56237e+03,0.81736e+03,0.10754e+04 /)
      kbo(:, 1,56, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56002e+03,0.81448e+03,0.10713e+04 /)
      kbo(:, 2,56, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56104e+03,0.81576e+03,0.10732e+04 /)
      kbo(:, 3,56, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.56175e+03,0.81659e+03,0.10744e+04 /)
      kbo(:, 4,56, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56219e+03,0.81709e+03,0.10752e+04 /)
      kbo(:, 5,56, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56236e+03,0.81734e+03,0.10754e+04 /)
      kbo(:, 1,57, 7) = (/ &
        & 0.99575e+03,0.75851e+03,0.55963e+03,0.81395e+03,0.10705e+04 /)
      kbo(:, 2,57, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56076e+03,0.81540e+03,0.10727e+04 /)
      kbo(:, 3,57, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56157e+03,0.81635e+03,0.10741e+04 /)
      kbo(:, 4,57, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56208e+03,0.81696e+03,0.10750e+04 /)
      kbo(:, 5,57, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56234e+03,0.81729e+03,0.10754e+04 /)
      kbo(:, 1,58, 7) = (/ &
        & 0.99575e+03,0.75850e+03,0.55922e+03,0.81340e+03,0.10697e+04 /)
      kbo(:, 2,58, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56044e+03,0.81503e+03,0.10721e+04 /)
      kbo(:, 3,58, 7) = (/ &
        & 0.99574e+03,0.75851e+03,0.56134e+03,0.81611e+03,0.10737e+04 /)
      kbo(:, 4,58, 7) = (/ &
        & 0.99574e+03,0.75851e+03,0.56195e+03,0.81681e+03,0.10748e+04 /)
      kbo(:, 5,58, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56228e+03,0.81722e+03,0.10753e+04 /)
      kbo(:, 1,59, 7) = (/ &
        & 0.99575e+03,0.75850e+03,0.55905e+03,0.81317e+03,0.10694e+04 /)
      kbo(:, 2,59, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56032e+03,0.81485e+03,0.10718e+04 /)
      kbo(:, 3,59, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56125e+03,0.81601e+03,0.10735e+04 /)
      kbo(:, 4,59, 7) = (/ &
        & 0.99574e+03,0.75850e+03,0.56189e+03,0.81673e+03,0.10747e+04 /)
      kbo(:, 5,59, 7) = (/ &
        & 0.99573e+03,0.75850e+03,0.56225e+03,0.81718e+03,0.10753e+04 /)
      kbo(:, 1,13, 8) = (/ &
        & 0.11451e+04,0.86748e+03,0.59259e+03,0.85187e+03,0.11225e+04 /)
      kbo(:, 2,13, 8) = (/ &
        & 0.11363e+04,0.86085e+03,0.58896e+03,0.85188e+03,0.11226e+04 /)
      kbo(:, 3,13, 8) = (/ &
        & 0.11286e+04,0.85515e+03,0.58586e+03,0.85170e+03,0.11227e+04 /)
      kbo(:, 4,13, 8) = (/ &
        & 0.11220e+04,0.85016e+03,0.58378e+03,0.85132e+03,0.11224e+04 /)
      kbo(:, 5,13, 8) = (/ &
        & 0.11162e+04,0.84582e+03,0.58229e+03,0.85074e+03,0.11218e+04 /)
      kbo(:, 1,14, 8) = (/ &
        & 0.11230e+04,0.85087e+03,0.58392e+03,0.85168e+03,0.11225e+04 /)
      kbo(:, 2,14, 8) = (/ &
        & 0.11158e+04,0.84552e+03,0.58280e+03,0.85169e+03,0.11227e+04 /)
      kbo(:, 3,14, 8) = (/ &
        & 0.11097e+04,0.84090e+03,0.58233e+03,0.85151e+03,0.11227e+04 /)
      kbo(:, 4,14, 8) = (/ &
        & 0.11043e+04,0.83689e+03,0.58194e+03,0.85113e+03,0.11223e+04 /)
      kbo(:, 5,14, 8) = (/ &
        & 0.10996e+04,0.83336e+03,0.58140e+03,0.85052e+03,0.11217e+04 /)
      kbo(:, 1,15, 8) = (/ &
        & 0.11049e+04,0.83731e+03,0.58207e+03,0.85153e+03,0.11225e+04 /)
      kbo(:, 2,15, 8) = (/ &
        & 0.10991e+04,0.83301e+03,0.58217e+03,0.85153e+03,0.11227e+04 /)
      kbo(:, 3,15, 8) = (/ &
        & 0.10942e+04,0.82928e+03,0.58200e+03,0.85134e+03,0.11226e+04 /)
      kbo(:, 4,15, 8) = (/ &
        & 0.10899e+04,0.82605e+03,0.58161e+03,0.85094e+03,0.11223e+04 /)
      kbo(:, 5,15, 8) = (/ &
        & 0.10860e+04,0.82320e+03,0.58108e+03,0.85034e+03,0.11216e+04 /)
      kbo(:, 1,16, 8) = (/ &
        & 0.10902e+04,0.82630e+03,0.58181e+03,0.85141e+03,0.11225e+04 /)
      kbo(:, 2,16, 8) = (/ &
        & 0.10856e+04,0.82283e+03,0.58190e+03,0.85139e+03,0.11227e+04 /)
      kbo(:, 3,16, 8) = (/ &
        & 0.10816e+04,0.81983e+03,0.58172e+03,0.85119e+03,0.11226e+04 /)
      kbo(:, 4,16, 8) = (/ &
        & 0.10781e+04,0.81721e+03,0.58133e+03,0.85078e+03,0.11222e+04 /)
      kbo(:, 5,16, 8) = (/ &
        & 0.10750e+04,0.81491e+03,0.58080e+03,0.85015e+03,0.11215e+04 /)
      kbo(:, 1,17, 8) = (/ &
        & 0.10783e+04,0.81738e+03,0.58160e+03,0.85131e+03,0.11225e+04 /)
      kbo(:, 2,17, 8) = (/ &
        & 0.10746e+04,0.81457e+03,0.58168e+03,0.85129e+03,0.11227e+04 /)
      kbo(:, 3,17, 8) = (/ &
        & 0.10713e+04,0.81215e+03,0.58149e+03,0.85108e+03,0.11226e+04 /)
      kbo(:, 4,17, 8) = (/ &
        & 0.10685e+04,0.81004e+03,0.58109e+03,0.85064e+03,0.11222e+04 /)
      kbo(:, 5,17, 8) = (/ &
        & 0.10660e+04,0.80818e+03,0.58056e+03,0.85000e+03,0.11214e+04 /)
      kbo(:, 1,18, 8) = (/ &
        & 0.10686e+04,0.81013e+03,0.58144e+03,0.85124e+03,0.11225e+04 /)
      kbo(:, 2,18, 8) = (/ &
        & 0.10656e+04,0.80786e+03,0.58150e+03,0.85119e+03,0.11227e+04 /)
      kbo(:, 3,18, 8) = (/ &
        & 0.10630e+04,0.80591e+03,0.58129e+03,0.85095e+03,0.11226e+04 /)
      kbo(:, 4,18, 8) = (/ &
        & 0.10607e+04,0.80419e+03,0.58089e+03,0.85052e+03,0.11221e+04 /)
      kbo(:, 5,18, 8) = (/ &
        & 0.10587e+04,0.80269e+03,0.58036e+03,0.84984e+03,0.11213e+04 /)
      kbo(:, 1,19, 8) = (/ &
        & 0.10608e+04,0.80424e+03,0.58130e+03,0.85117e+03,0.11226e+04 /)
      kbo(:, 2,19, 8) = (/ &
        & 0.10584e+04,0.80242e+03,0.58135e+03,0.85109e+03,0.11227e+04 /)
      kbo(:, 3,19, 8) = (/ &
        & 0.10562e+04,0.80084e+03,0.58113e+03,0.85087e+03,0.11225e+04 /)
      kbo(:, 4,19, 8) = (/ &
        & 0.10544e+04,0.79946e+03,0.58072e+03,0.85040e+03,0.11220e+04 /)
      kbo(:, 5,19, 8) = (/ &
        & 0.10528e+04,0.79825e+03,0.58019e+03,0.84971e+03,0.11212e+04 /)
      kbo(:, 1,20, 8) = (/ &
        & 0.10544e+04,0.79943e+03,0.58120e+03,0.85111e+03,0.11226e+04 /)
      kbo(:, 2,20, 8) = (/ &
        & 0.10524e+04,0.79797e+03,0.58122e+03,0.85103e+03,0.11227e+04 /)
      kbo(:, 3,20, 8) = (/ &
        & 0.10507e+04,0.79669e+03,0.58098e+03,0.85078e+03,0.11225e+04 /)
      kbo(:, 4,20, 8) = (/ &
        & 0.10492e+04,0.79558e+03,0.58056e+03,0.85028e+03,0.11220e+04 /)
      kbo(:, 5,20, 8) = (/ &
        & 0.10479e+04,0.79460e+03,0.58002e+03,0.84958e+03,0.11211e+04 /)
      kbo(:, 1,21, 8) = (/ &
        & 0.10492e+04,0.79553e+03,0.58112e+03,0.85107e+03,0.11227e+04 /)
      kbo(:, 2,21, 8) = (/ &
        & 0.10476e+04,0.79436e+03,0.58112e+03,0.85096e+03,0.11227e+04 /)
      kbo(:, 3,21, 8) = (/ &
        & 0.10462e+04,0.79334e+03,0.58085e+03,0.85069e+03,0.11224e+04 /)
      kbo(:, 4,21, 8) = (/ &
        & 0.10450e+04,0.79243e+03,0.58042e+03,0.85021e+03,0.11219e+04 /)
      kbo(:, 5,21, 8) = (/ &
        & 0.10440e+04,0.79165e+03,0.57987e+03,0.84945e+03,0.11210e+04 /)
      kbo(:, 1,22, 8) = (/ &
        & 0.10449e+04,0.79230e+03,0.58106e+03,0.85103e+03,0.11226e+04 /)
      kbo(:, 2,22, 8) = (/ &
        & 0.10436e+04,0.79136e+03,0.58100e+03,0.85090e+03,0.11227e+04 /)
      kbo(:, 3,22, 8) = (/ &
        & 0.10425e+04,0.79054e+03,0.58071e+03,0.85058e+03,0.11224e+04 /)
      kbo(:, 4,22, 8) = (/ &
        & 0.10416e+04,0.78983e+03,0.58026e+03,0.85002e+03,0.11217e+04 /)
      kbo(:, 5,22, 8) = (/ &
        & 0.10407e+04,0.78921e+03,0.57969e+03,0.84925e+03,0.11208e+04 /)
      kbo(:, 1,23, 8) = (/ &
        & 0.10414e+04,0.78969e+03,0.58100e+03,0.85099e+03,0.11227e+04 /)
      kbo(:, 2,23, 8) = (/ &
        & 0.10404e+04,0.78894e+03,0.58090e+03,0.85083e+03,0.11226e+04 /)
      kbo(:, 3,23, 8) = (/ &
        & 0.10395e+04,0.78829e+03,0.58058e+03,0.85047e+03,0.11223e+04 /)
      kbo(:, 4,23, 8) = (/ &
        & 0.10387e+04,0.78772e+03,0.58011e+03,0.84989e+03,0.11216e+04 /)
      kbo(:, 5,23, 8) = (/ &
        & 0.10381e+04,0.78721e+03,0.57952e+03,0.84905e+03,0.11206e+04 /)
      kbo(:, 1,24, 8) = (/ &
        & 0.10386e+04,0.78759e+03,0.58095e+03,0.85095e+03,0.11227e+04 /)
      kbo(:, 2,24, 8) = (/ &
        & 0.10378e+04,0.78698e+03,0.58081e+03,0.85075e+03,0.11226e+04 /)
      kbo(:, 3,24, 8) = (/ &
        & 0.10371e+04,0.78646e+03,0.58046e+03,0.85035e+03,0.11222e+04 /)
      kbo(:, 4,24, 8) = (/ &
        & 0.10365e+04,0.78601e+03,0.57995e+03,0.84971e+03,0.11214e+04 /)
      kbo(:, 5,24, 8) = (/ &
        & 0.10359e+04,0.78561e+03,0.57934e+03,0.84885e+03,0.11203e+04 /)
      kbo(:, 1,25, 8) = (/ &
        & 0.10363e+04,0.78588e+03,0.58090e+03,0.85090e+03,0.11227e+04 /)
      kbo(:, 2,25, 8) = (/ &
        & 0.10357e+04,0.78541e+03,0.58070e+03,0.85067e+03,0.11225e+04 /)
      kbo(:, 3,25, 8) = (/ &
        & 0.10351e+04,0.78498e+03,0.58032e+03,0.85020e+03,0.11220e+04 /)
      kbo(:, 4,25, 8) = (/ &
        & 0.10346e+04,0.78461e+03,0.57980e+03,0.84953e+03,0.11212e+04 /)
      kbo(:, 5,25, 8) = (/ &
        & 0.10342e+04,0.78430e+03,0.57916e+03,0.84863e+03,0.11201e+04 /)
      kbo(:, 1,26, 8) = (/ &
        & 0.10345e+04,0.78450e+03,0.58084e+03,0.85084e+03,0.11227e+04 /)
      kbo(:, 2,26, 8) = (/ &
        & 0.10339e+04,0.78411e+03,0.58059e+03,0.85057e+03,0.11224e+04 /)
      kbo(:, 3,26, 8) = (/ &
        & 0.10335e+04,0.78378e+03,0.58018e+03,0.85004e+03,0.11219e+04 /)
      kbo(:, 4,26, 8) = (/ &
        & 0.10331e+04,0.78349e+03,0.57964e+03,0.84934e+03,0.11210e+04 /)
      kbo(:, 5,26, 8) = (/ &
        & 0.10328e+04,0.78323e+03,0.57897e+03,0.84838e+03,0.11198e+04 /)
      kbo(:, 1,27, 8) = (/ &
        & 0.10329e+04,0.78338e+03,0.58078e+03,0.85078e+03,0.11227e+04 /)
      kbo(:, 2,27, 8) = (/ &
        & 0.10326e+04,0.78307e+03,0.58048e+03,0.85045e+03,0.11223e+04 /)
      kbo(:, 3,27, 8) = (/ &
        & 0.10322e+04,0.78282e+03,0.58003e+03,0.84982e+03,0.11217e+04 /)
      kbo(:, 4,27, 8) = (/ &
        & 0.10319e+04,0.78258e+03,0.57947e+03,0.84907e+03,0.11207e+04 /)
      kbo(:, 5,27, 8) = (/ &
        & 0.10316e+04,0.78237e+03,0.57877e+03,0.84811e+03,0.11194e+04 /)
      kbo(:, 1,28, 8) = (/ &
        & 0.10318e+04,0.78248e+03,0.58069e+03,0.85072e+03,0.11226e+04 /)
      kbo(:, 2,28, 8) = (/ &
        & 0.10314e+04,0.78225e+03,0.58037e+03,0.85030e+03,0.11222e+04 /)
      kbo(:, 3,28, 8) = (/ &
        & 0.10312e+04,0.78205e+03,0.57989e+03,0.84960e+03,0.11215e+04 /)
      kbo(:, 4,28, 8) = (/ &
        & 0.10309e+04,0.78185e+03,0.57929e+03,0.84888e+03,0.11204e+04 /)
      kbo(:, 5,28, 8) = (/ &
        & 0.10307e+04,0.78168e+03,0.57856e+03,0.84784e+03,0.11191e+04 /)
      kbo(:, 1,29, 8) = (/ &
        & 0.10308e+04,0.78175e+03,0.58061e+03,0.85062e+03,0.11225e+04 /)
      kbo(:, 2,29, 8) = (/ &
        & 0.10305e+04,0.78157e+03,0.58024e+03,0.85019e+03,0.11221e+04 /)
      kbo(:, 3,29, 8) = (/ &
        & 0.10303e+04,0.78140e+03,0.57974e+03,0.84950e+03,0.11213e+04 /)
      kbo(:, 4,29, 8) = (/ &
        & 0.10301e+04,0.78126e+03,0.57911e+03,0.84863e+03,0.11201e+04 /)
      kbo(:, 5,29, 8) = (/ &
        & 0.10300e+04,0.78112e+03,0.57834e+03,0.84752e+03,0.11188e+04 /)
      kbo(:, 1,30, 8) = (/ &
        & 0.10300e+04,0.78117e+03,0.58052e+03,0.85055e+03,0.11224e+04 /)
      kbo(:, 2,30, 8) = (/ &
        & 0.10298e+04,0.78102e+03,0.58011e+03,0.85001e+03,0.11219e+04 /)
      kbo(:, 3,30, 8) = (/ &
        & 0.10296e+04,0.78089e+03,0.57958e+03,0.84932e+03,0.11210e+04 /)
      kbo(:, 4,30, 8) = (/ &
        & 0.10295e+04,0.78077e+03,0.57892e+03,0.84838e+03,0.11198e+04 /)
      kbo(:, 5,30, 8) = (/ &
        & 0.10294e+04,0.78066e+03,0.57811e+03,0.84720e+03,0.11184e+04 /)
      kbo(:, 1,31, 8) = (/ &
        & 0.10294e+04,0.78070e+03,0.58042e+03,0.85041e+03,0.11223e+04 /)
      kbo(:, 2,31, 8) = (/ &
        & 0.10292e+04,0.78058e+03,0.57998e+03,0.84985e+03,0.11217e+04 /)
      kbo(:, 3,31, 8) = (/ &
        & 0.10291e+04,0.78049e+03,0.57941e+03,0.84908e+03,0.11207e+04 /)
      kbo(:, 4,31, 8) = (/ &
        & 0.10290e+04,0.78039e+03,0.57872e+03,0.84808e+03,0.11195e+04 /)
      kbo(:, 5,31, 8) = (/ &
        & 0.10289e+04,0.78030e+03,0.57786e+03,0.84686e+03,0.11179e+04 /)
      kbo(:, 1,32, 8) = (/ &
        & 0.10289e+04,0.78033e+03,0.58031e+03,0.85030e+03,0.11222e+04 /)
      kbo(:, 2,32, 8) = (/ &
        & 0.10288e+04,0.78024e+03,0.57984e+03,0.84967e+03,0.11215e+04 /)
      kbo(:, 3,32, 8) = (/ &
        & 0.10287e+04,0.78016e+03,0.57924e+03,0.84884e+03,0.11204e+04 /)
      kbo(:, 4,32, 8) = (/ &
        & 0.10286e+04,0.78009e+03,0.57851e+03,0.84778e+03,0.11191e+04 /)
      kbo(:, 5,32, 8) = (/ &
        & 0.10285e+04,0.78000e+03,0.57759e+03,0.84651e+03,0.11175e+04 /)
      kbo(:, 1,33, 8) = (/ &
        & 0.10285e+04,0.78003e+03,0.58019e+03,0.85016e+03,0.11220e+04 /)
      kbo(:, 2,33, 8) = (/ &
        & 0.10284e+04,0.77995e+03,0.57968e+03,0.84947e+03,0.11212e+04 /)
      kbo(:, 3,33, 8) = (/ &
        & 0.10283e+04,0.77988e+03,0.57905e+03,0.84858e+03,0.11201e+04 /)
      kbo(:, 4,33, 8) = (/ &
        & 0.10282e+04,0.77982e+03,0.57829e+03,0.84747e+03,0.11187e+04 /)
      kbo(:, 5,33, 8) = (/ &
        & 0.10282e+04,0.77978e+03,0.57730e+03,0.84615e+03,0.11170e+04 /)
      kbo(:, 1,34, 8) = (/ &
        & 0.10282e+04,0.77978e+03,0.58008e+03,0.84998e+03,0.11219e+04 /)
      kbo(:, 2,34, 8) = (/ &
        & 0.10281e+04,0.77972e+03,0.57954e+03,0.84930e+03,0.11210e+04 /)
      kbo(:, 3,34, 8) = (/ &
        & 0.10280e+04,0.77967e+03,0.57889e+03,0.84836e+03,0.11198e+04 /)
      kbo(:, 4,34, 8) = (/ &
        & 0.10280e+04,0.77962e+03,0.57808e+03,0.84718e+03,0.11184e+04 /)
      kbo(:, 5,34, 8) = (/ &
        & 0.10279e+04,0.77958e+03,0.57705e+03,0.84582e+03,0.11166e+04 /)
      kbo(:, 1,35, 8) = (/ &
        & 0.10279e+04,0.77958e+03,0.58001e+03,0.84995e+03,0.11218e+04 /)
      kbo(:, 2,35, 8) = (/ &
        & 0.10278e+04,0.77953e+03,0.57946e+03,0.84916e+03,0.11209e+04 /)
      kbo(:, 3,35, 8) = (/ &
        & 0.10278e+04,0.77951e+03,0.57880e+03,0.84823e+03,0.11196e+04 /)
      kbo(:, 4,35, 8) = (/ &
        & 0.10277e+04,0.77946e+03,0.57796e+03,0.84701e+03,0.11181e+04 /)
      kbo(:, 5,35, 8) = (/ &
        & 0.10277e+04,0.77943e+03,0.57689e+03,0.84563e+03,0.11163e+04 /)
      kbo(:, 1,36, 8) = (/ &
        & 0.10277e+04,0.77944e+03,0.58000e+03,0.84992e+03,0.11218e+04 /)
      kbo(:, 2,36, 8) = (/ &
        & 0.10277e+04,0.77940e+03,0.57944e+03,0.84917e+03,0.11208e+04 /)
      kbo(:, 3,36, 8) = (/ &
        & 0.10276e+04,0.77936e+03,0.57877e+03,0.84819e+03,0.11196e+04 /)
      kbo(:, 4,36, 8) = (/ &
        & 0.10276e+04,0.77933e+03,0.57793e+03,0.84697e+03,0.11181e+04 /)
      kbo(:, 5,36, 8) = (/ &
        & 0.10275e+04,0.77931e+03,0.57686e+03,0.84561e+03,0.11162e+04 /)
      kbo(:, 1,37, 8) = (/ &
        & 0.10275e+04,0.77932e+03,0.58006e+03,0.85002e+03,0.11219e+04 /)
      kbo(:, 2,37, 8) = (/ &
        & 0.10275e+04,0.77929e+03,0.57952e+03,0.84927e+03,0.11210e+04 /)
      kbo(:, 3,37, 8) = (/ &
        & 0.10275e+04,0.77926e+03,0.57886e+03,0.84832e+03,0.11198e+04 /)
      kbo(:, 4,37, 8) = (/ &
        & 0.10274e+04,0.77924e+03,0.57805e+03,0.84715e+03,0.11183e+04 /)
      kbo(:, 5,37, 8) = (/ &
        & 0.10274e+04,0.77921e+03,0.57701e+03,0.84575e+03,0.11165e+04 /)
      kbo(:, 1,38, 8) = (/ &
        & 0.10274e+04,0.77922e+03,0.58012e+03,0.85009e+03,0.11220e+04 /)
      kbo(:, 2,38, 8) = (/ &
        & 0.10274e+04,0.77920e+03,0.57959e+03,0.84938e+03,0.11211e+04 /)
      kbo(:, 3,38, 8) = (/ &
        & 0.10274e+04,0.77918e+03,0.57896e+03,0.84848e+03,0.11200e+04 /)
      kbo(:, 4,38, 8) = (/ &
        & 0.10273e+04,0.77915e+03,0.57818e+03,0.84731e+03,0.11185e+04 /)
      kbo(:, 5,38, 8) = (/ &
        & 0.10273e+04,0.77912e+03,0.57716e+03,0.84599e+03,0.11168e+04 /)
      kbo(:, 1,39, 8) = (/ &
        & 0.10273e+04,0.77914e+03,0.58018e+03,0.85016e+03,0.11221e+04 /)
      kbo(:, 2,39, 8) = (/ &
        & 0.10273e+04,0.77912e+03,0.57968e+03,0.84939e+03,0.11213e+04 /)
      kbo(:, 3,39, 8) = (/ &
        & 0.10273e+04,0.77911e+03,0.57905e+03,0.84861e+03,0.11201e+04 /)
      kbo(:, 4,39, 8) = (/ &
        & 0.10272e+04,0.77910e+03,0.57829e+03,0.84750e+03,0.11187e+04 /)
      kbo(:, 5,39, 8) = (/ &
        & 0.10272e+04,0.77907e+03,0.57732e+03,0.84617e+03,0.11171e+04 /)
      kbo(:, 1,40, 8) = (/ &
        & 0.10272e+04,0.77908e+03,0.58028e+03,0.85029e+03,0.11222e+04 /)
      kbo(:, 2,40, 8) = (/ &
        & 0.10272e+04,0.77906e+03,0.57981e+03,0.84968e+03,0.11215e+04 /)
      kbo(:, 3,40, 8) = (/ &
        & 0.10272e+04,0.77904e+03,0.57922e+03,0.84885e+03,0.11204e+04 /)
      kbo(:, 4,40, 8) = (/ &
        & 0.10272e+04,0.77904e+03,0.57849e+03,0.84779e+03,0.11191e+04 /)
      kbo(:, 5,40, 8) = (/ &
        & 0.10272e+04,0.77901e+03,0.57757e+03,0.84651e+03,0.11176e+04 /)
      kbo(:, 1,41, 8) = (/ &
        & 0.10272e+04,0.77903e+03,0.58037e+03,0.85041e+03,0.11224e+04 /)
      kbo(:, 2,41, 8) = (/ &
        & 0.10272e+04,0.77902e+03,0.57994e+03,0.84983e+03,0.11217e+04 /)
      kbo(:, 3,41, 8) = (/ &
        & 0.10271e+04,0.77900e+03,0.57937e+03,0.84906e+03,0.11207e+04 /)
      kbo(:, 4,41, 8) = (/ &
        & 0.10271e+04,0.77898e+03,0.57870e+03,0.84808e+03,0.11195e+04 /)
      kbo(:, 5,41, 8) = (/ &
        & 0.10271e+04,0.77898e+03,0.57782e+03,0.84685e+03,0.11180e+04 /)
      kbo(:, 1,42, 8) = (/ &
        & 0.10271e+04,0.77900e+03,0.58046e+03,0.85051e+03,0.11225e+04 /)
      kbo(:, 2,42, 8) = (/ &
        & 0.10271e+04,0.77898e+03,0.58006e+03,0.85002e+03,0.11219e+04 /)
      kbo(:, 3,42, 8) = (/ &
        & 0.10271e+04,0.77896e+03,0.57953e+03,0.84930e+03,0.11210e+04 /)
      kbo(:, 4,42, 8) = (/ &
        & 0.10271e+04,0.77895e+03,0.57888e+03,0.84835e+03,0.11198e+04 /)
      kbo(:, 5,42, 8) = (/ &
        & 0.10270e+04,0.77894e+03,0.57806e+03,0.84718e+03,0.11184e+04 /)
      kbo(:, 1,43, 8) = (/ &
        & 0.10271e+04,0.77895e+03,0.58056e+03,0.85062e+03,0.11226e+04 /)
      kbo(:, 2,43, 8) = (/ &
        & 0.10270e+04,0.77895e+03,0.58020e+03,0.85017e+03,0.11221e+04 /)
      kbo(:, 3,43, 8) = (/ &
        & 0.10270e+04,0.77892e+03,0.57970e+03,0.84954e+03,0.11213e+04 /)
      kbo(:, 4,43, 8) = (/ &
        & 0.10270e+04,0.77892e+03,0.57909e+03,0.84866e+03,0.11202e+04 /)
      kbo(:, 5,43, 8) = (/ &
        & 0.10270e+04,0.77891e+03,0.57834e+03,0.84756e+03,0.11188e+04 /)
      kbo(:, 1,44, 8) = (/ &
        & 0.10270e+04,0.77892e+03,0.58064e+03,0.85071e+03,0.11226e+04 /)
      kbo(:, 2,44, 8) = (/ &
        & 0.10270e+04,0.77891e+03,0.58034e+03,0.85036e+03,0.11223e+04 /)
      kbo(:, 3,44, 8) = (/ &
        & 0.10270e+04,0.77891e+03,0.57988e+03,0.84979e+03,0.11216e+04 /)
      kbo(:, 4,44, 8) = (/ &
        & 0.10270e+04,0.77890e+03,0.57931e+03,0.84899e+03,0.11206e+04 /)
      kbo(:, 5,44, 8) = (/ &
        & 0.10270e+04,0.77888e+03,0.57861e+03,0.84797e+03,0.11193e+04 /)
      kbo(:, 1,45, 8) = (/ &
        & 0.10270e+04,0.77889e+03,0.58069e+03,0.85078e+03,0.11227e+04 /)
      kbo(:, 2,45, 8) = (/ &
        & 0.10270e+04,0.77888e+03,0.58047e+03,0.85051e+03,0.11224e+04 /)
      kbo(:, 3,45, 8) = (/ &
        & 0.10270e+04,0.77888e+03,0.58005e+03,0.84999e+03,0.11219e+04 /)
      kbo(:, 4,45, 8) = (/ &
        & 0.10270e+04,0.77888e+03,0.57952e+03,0.84927e+03,0.11210e+04 /)
      kbo(:, 5,45, 8) = (/ &
        & 0.10269e+04,0.77886e+03,0.57890e+03,0.84837e+03,0.11198e+04 /)
      kbo(:, 1,46, 8) = (/ &
        & 0.10270e+04,0.77887e+03,0.58072e+03,0.85082e+03,0.11227e+04 /)
      kbo(:, 2,46, 8) = (/ &
        & 0.10270e+04,0.77886e+03,0.58056e+03,0.85063e+03,0.11226e+04 /)
      kbo(:, 3,46, 8) = (/ &
        & 0.10269e+04,0.77886e+03,0.58022e+03,0.85021e+03,0.11221e+04 /)
      kbo(:, 4,46, 8) = (/ &
        & 0.10270e+04,0.77885e+03,0.57972e+03,0.84957e+03,0.11213e+04 /)
      kbo(:, 5,46, 8) = (/ &
        & 0.10269e+04,0.77884e+03,0.57911e+03,0.84871e+03,0.11203e+04 /)
      kbo(:, 1,47, 8) = (/ &
        & 0.10269e+04,0.77885e+03,0.58070e+03,0.85086e+03,0.11227e+04 /)
      kbo(:, 2,47, 8) = (/ &
        & 0.10269e+04,0.77886e+03,0.58066e+03,0.85073e+03,0.11227e+04 /)
      kbo(:, 3,47, 8) = (/ &
        & 0.10269e+04,0.77885e+03,0.58037e+03,0.85041e+03,0.11223e+04 /)
      kbo(:, 4,47, 8) = (/ &
        & 0.10269e+04,0.77884e+03,0.57993e+03,0.84985e+03,0.11217e+04 /)
      kbo(:, 5,47, 8) = (/ &
        & 0.10269e+04,0.77883e+03,0.57937e+03,0.84903e+03,0.11207e+04 /)
      kbo(:, 1,48, 8) = (/ &
        & 0.10269e+04,0.77884e+03,0.58064e+03,0.85086e+03,0.11226e+04 /)
      kbo(:, 2,48, 8) = (/ &
        & 0.10269e+04,0.77883e+03,0.58071e+03,0.85080e+03,0.11227e+04 /)
      kbo(:, 3,48, 8) = (/ &
        & 0.10269e+04,0.77883e+03,0.58051e+03,0.85055e+03,0.11225e+04 /)
      kbo(:, 4,48, 8) = (/ &
        & 0.10269e+04,0.77883e+03,0.58013e+03,0.85010e+03,0.11220e+04 /)
      kbo(:, 5,48, 8) = (/ &
        & 0.10269e+04,0.77883e+03,0.57961e+03,0.84941e+03,0.11212e+04 /)
      kbo(:, 1,49, 8) = (/ &
        & 0.10269e+04,0.77884e+03,0.58054e+03,0.85082e+03,0.11225e+04 /)
      kbo(:, 2,49, 8) = (/ &
        & 0.10269e+04,0.77882e+03,0.58072e+03,0.85085e+03,0.11227e+04 /)
      kbo(:, 3,49, 8) = (/ &
        & 0.10269e+04,0.77883e+03,0.58061e+03,0.85068e+03,0.11226e+04 /)
      kbo(:, 4,49, 8) = (/ &
        & 0.10269e+04,0.77882e+03,0.58029e+03,0.85032e+03,0.11222e+04 /)
      kbo(:, 5,49, 8) = (/ &
        & 0.10269e+04,0.77881e+03,0.57983e+03,0.84969e+03,0.11215e+04 /)
      kbo(:, 1,50, 8) = (/ &
        & 0.10269e+04,0.77883e+03,0.58042e+03,0.85074e+03,0.11224e+04 /)
      kbo(:, 2,50, 8) = (/ &
        & 0.10269e+04,0.77881e+03,0.58068e+03,0.85085e+03,0.11226e+04 /)
      kbo(:, 3,50, 8) = (/ &
        & 0.10269e+04,0.77882e+03,0.58069e+03,0.85077e+03,0.11227e+04 /)
      kbo(:, 4,50, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58043e+03,0.85048e+03,0.11224e+04 /)
      kbo(:, 5,50, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58002e+03,0.84997e+03,0.11218e+04 /)
      kbo(:, 1,51, 8) = (/ &
        & 0.10269e+04,0.77881e+03,0.58027e+03,0.85064e+03,0.11224e+04 /)
      kbo(:, 2,51, 8) = (/ &
        & 0.10269e+04,0.77882e+03,0.58061e+03,0.85085e+03,0.11226e+04 /)
      kbo(:, 3,51, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58071e+03,0.85082e+03,0.11227e+04 /)
      kbo(:, 4,51, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58055e+03,0.85061e+03,0.11226e+04 /)
      kbo(:, 5,51, 8) = (/ &
        & 0.10269e+04,0.77881e+03,0.58020e+03,0.85015e+03,0.11221e+04 /)
      kbo(:, 1,52, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58011e+03,0.85051e+03,0.11222e+04 /)
      kbo(:, 2,52, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58051e+03,0.85080e+03,0.11225e+04 /)
      kbo(:, 3,52, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58071e+03,0.85085e+03,0.11227e+04 /)
      kbo(:, 4,52, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.58064e+03,0.85068e+03,0.11226e+04 /)
      kbo(:, 5,52, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.58034e+03,0.85037e+03,0.11223e+04 /)
      kbo(:, 1,53, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.57994e+03,0.85036e+03,0.11220e+04 /)
      kbo(:, 2,53, 8) = (/ &
        & 0.10269e+04,0.77879e+03,0.58038e+03,0.85072e+03,0.11224e+04 /)
      kbo(:, 3,53, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.58066e+03,0.85087e+03,0.11226e+04 /)
      kbo(:, 4,53, 8) = (/ &
        & 0.10269e+04,0.77880e+03,0.58069e+03,0.85078e+03,0.11227e+04 /)
      kbo(:, 5,53, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58047e+03,0.85044e+03,0.11225e+04 /)
      kbo(:, 1,54, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.57977e+03,0.85022e+03,0.11219e+04 /)
      kbo(:, 2,54, 8) = (/ &
        & 0.10269e+04,0.77879e+03,0.58026e+03,0.85061e+03,0.11223e+04 /)
      kbo(:, 3,54, 8) = (/ &
        & 0.10268e+04,0.77881e+03,0.58060e+03,0.85084e+03,0.11226e+04 /)
      kbo(:, 4,54, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.58072e+03,0.85083e+03,0.11227e+04 /)
      kbo(:, 5,54, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58058e+03,0.85063e+03,0.11226e+04 /)
      kbo(:, 1,55, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.57962e+03,0.85008e+03,0.11217e+04 /)
      kbo(:, 2,55, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58011e+03,0.85050e+03,0.11222e+04 /)
      kbo(:, 3,55, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.58050e+03,0.85080e+03,0.11225e+04 /)
      kbo(:, 4,55, 8) = (/ &
        & 0.10268e+04,0.77880e+03,0.58071e+03,0.85085e+03,0.11226e+04 /)
      kbo(:, 5,55, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58064e+03,0.85072e+03,0.11226e+04 /)
      kbo(:, 1,56, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.57945e+03,0.84993e+03,0.11216e+04 /)
      kbo(:, 2,56, 8) = (/ &
        & 0.10268e+04,0.77877e+03,0.57995e+03,0.85037e+03,0.11220e+04 /)
      kbo(:, 3,56, 8) = (/ &
        & 0.10268e+04,0.77877e+03,0.58039e+03,0.85071e+03,0.11224e+04 /)
      kbo(:, 4,56, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58067e+03,0.85086e+03,0.11226e+04 /)
      kbo(:, 5,56, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58069e+03,0.85078e+03,0.11227e+04 /)
      kbo(:, 1,57, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.57927e+03,0.84978e+03,0.11215e+04 /)
      kbo(:, 2,57, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.57979e+03,0.85024e+03,0.11219e+04 /)
      kbo(:, 3,57, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58025e+03,0.85063e+03,0.11223e+04 /)
      kbo(:, 4,57, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58060e+03,0.85084e+03,0.11226e+04 /)
      kbo(:, 5,57, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58071e+03,0.85083e+03,0.11227e+04 /)
      kbo(:, 1,58, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.57911e+03,0.84962e+03,0.11212e+04 /)
      kbo(:, 2,58, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.57964e+03,0.85010e+03,0.11218e+04 /)
      kbo(:, 3,58, 8) = (/ &
        & 0.10268e+04,0.77877e+03,0.58013e+03,0.85053e+03,0.11222e+04 /)
      kbo(:, 4,58, 8) = (/ &
        & 0.10268e+04,0.77877e+03,0.58052e+03,0.85080e+03,0.11225e+04 /)
      kbo(:, 5,58, 8) = (/ &
        & 0.10268e+04,0.77879e+03,0.58071e+03,0.85085e+03,0.11227e+04 /)
      kbo(:, 1,59, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.57904e+03,0.84955e+03,0.11212e+04 /)
      kbo(:, 2,59, 8) = (/ &
        & 0.10268e+04,0.77877e+03,0.57958e+03,0.85006e+03,0.11217e+04 /)
      kbo(:, 3,59, 8) = (/ &
        & 0.10268e+04,0.77877e+03,0.58007e+03,0.85048e+03,0.11222e+04 /)
      kbo(:, 4,59, 8) = (/ &
        & 0.10268e+04,0.77878e+03,0.58048e+03,0.85078e+03,0.11225e+04 /)
      kbo(:, 5,59, 8) = (/ &
        & 0.10268e+04,0.77877e+03,0.58070e+03,0.85086e+03,0.11227e+04 /)
      kbo(:, 1,13, 9) = (/ &
        & 0.11533e+04,0.87327e+03,0.59473e+03,0.87046e+03,0.11487e+04 /)
      kbo(:, 2,13, 9) = (/ &
        & 0.11444e+04,0.86660e+03,0.59240e+03,0.87005e+03,0.11483e+04 /)
      kbo(:, 3,13, 9) = (/ &
        & 0.11367e+04,0.86090e+03,0.59185e+03,0.86950e+03,0.11478e+04 /)
      kbo(:, 4,13, 9) = (/ &
        & 0.11301e+04,0.85587e+03,0.59143e+03,0.86883e+03,0.11469e+04 /)
      kbo(:, 5,13, 9) = (/ &
        & 0.11242e+04,0.85148e+03,0.59084e+03,0.86797e+03,0.11458e+04 /)
      kbo(:, 1,14, 9) = (/ &
        & 0.11310e+04,0.85656e+03,0.59238e+03,0.87026e+03,0.11487e+04 /)
      kbo(:, 2,14, 9) = (/ &
        & 0.11238e+04,0.85118e+03,0.59190e+03,0.86988e+03,0.11483e+04 /)
      kbo(:, 3,14, 9) = (/ &
        & 0.11176e+04,0.84654e+03,0.59149e+03,0.86931e+03,0.11477e+04 /)
      kbo(:, 4,14, 9) = (/ &
        & 0.11122e+04,0.84248e+03,0.59105e+03,0.86863e+03,0.11468e+04 /)
      kbo(:, 5,14, 9) = (/ &
        & 0.11074e+04,0.83890e+03,0.59046e+03,0.86777e+03,0.11457e+04 /)
      kbo(:, 1,15, 9) = (/ &
        & 0.11128e+04,0.84292e+03,0.59202e+03,0.87009e+03,0.11486e+04 /)
      kbo(:, 2,15, 9) = (/ &
        & 0.11070e+04,0.83857e+03,0.59157e+03,0.86969e+03,0.11482e+04 /)
      kbo(:, 3,15, 9) = (/ &
        & 0.11020e+04,0.83480e+03,0.59118e+03,0.86913e+03,0.11476e+04 /)
      kbo(:, 4,15, 9) = (/ &
        & 0.10976e+04,0.83151e+03,0.59076e+03,0.86843e+03,0.11467e+04 /)
      kbo(:, 5,15, 9) = (/ &
        & 0.10938e+04,0.82865e+03,0.59015e+03,0.86756e+03,0.11457e+04 /)
      kbo(:, 1,16, 9) = (/ &
        & 0.10980e+04,0.83182e+03,0.59172e+03,0.86994e+03,0.11486e+04 /)
      kbo(:, 2,16, 9) = (/ &
        & 0.10933e+04,0.82831e+03,0.59129e+03,0.86966e+03,0.11482e+04 /)
      kbo(:, 3,16, 9) = (/ &
        & 0.10893e+04,0.82527e+03,0.59092e+03,0.86898e+03,0.11475e+04 /)
      kbo(:, 4,16, 9) = (/ &
        & 0.10858e+04,0.82261e+03,0.59049e+03,0.86826e+03,0.11466e+04 /)
      kbo(:, 5,16, 9) = (/ &
        & 0.10827e+04,0.82037e+03,0.58989e+03,0.86738e+03,0.11455e+04 /)
      kbo(:, 1,17, 9) = (/ &
        & 0.10860e+04,0.82280e+03,0.59147e+03,0.86983e+03,0.11485e+04 /)
      kbo(:, 2,17, 9) = (/ &
        & 0.10822e+04,0.81997e+03,0.59107e+03,0.86941e+03,0.11481e+04 /)
      kbo(:, 3,17, 9) = (/ &
        & 0.10790e+04,0.81753e+03,0.59070e+03,0.86883e+03,0.11474e+04 /)
      kbo(:, 4,17, 9) = (/ &
        & 0.10761e+04,0.81539e+03,0.59027e+03,0.86811e+03,0.11465e+04 /)
      kbo(:, 5,17, 9) = (/ &
        & 0.10736e+04,0.81353e+03,0.58965e+03,0.86721e+03,0.11454e+04 /)
      kbo(:, 1,18, 9) = (/ &
        & 0.10762e+04,0.81555e+03,0.59126e+03,0.86969e+03,0.11485e+04 /)
      kbo(:, 2,18, 9) = (/ &
        & 0.10732e+04,0.81322e+03,0.59088e+03,0.86928e+03,0.11481e+04 /)
      kbo(:, 3,18, 9) = (/ &
        & 0.10706e+04,0.81128e+03,0.59052e+03,0.86870e+03,0.11474e+04 /)
      kbo(:, 4,18, 9) = (/ &
        & 0.10683e+04,0.80956e+03,0.59008e+03,0.86800e+03,0.11464e+04 /)
      kbo(:, 5,18, 9) = (/ &
        & 0.10663e+04,0.80808e+03,0.58945e+03,0.86705e+03,0.11452e+04 /)
      kbo(:, 1,19, 9) = (/ &
        & 0.10684e+04,0.80963e+03,0.59108e+03,0.86962e+03,0.11485e+04 /)
      kbo(:, 2,19, 9) = (/ &
        & 0.10659e+04,0.80774e+03,0.59072e+03,0.86917e+03,0.11480e+04 /)
      kbo(:, 3,19, 9) = (/ &
        & 0.10638e+04,0.80613e+03,0.59038e+03,0.86858e+03,0.11473e+04 /)
      kbo(:, 4,19, 9) = (/ &
        & 0.10619e+04,0.80481e+03,0.58991e+03,0.86784e+03,0.11463e+04 /)
      kbo(:, 5,19, 9) = (/ &
        & 0.10603e+04,0.80353e+03,0.58926e+03,0.86690e+03,0.11451e+04 /)
      kbo(:, 1,20, 9) = (/ &
        & 0.10619e+04,0.80474e+03,0.59092e+03,0.86952e+03,0.11484e+04 /)
      kbo(:, 2,20, 9) = (/ &
        & 0.10599e+04,0.80326e+03,0.59057e+03,0.86907e+03,0.11479e+04 /)
      kbo(:, 3,20, 9) = (/ &
        & 0.10582e+04,0.80198e+03,0.59022e+03,0.86845e+03,0.11472e+04 /)
      kbo(:, 4,20, 9) = (/ &
        & 0.10567e+04,0.80089e+03,0.58976e+03,0.86771e+03,0.11462e+04 /)
      kbo(:, 5,20, 9) = (/ &
        & 0.10554e+04,0.79986e+03,0.58910e+03,0.86674e+03,0.11449e+04 /)
      kbo(:, 1,21, 9) = (/ &
        & 0.10567e+04,0.80080e+03,0.59079e+03,0.86945e+03,0.11483e+04 /)
      kbo(:, 2,21, 9) = (/ &
        & 0.10550e+04,0.79960e+03,0.59045e+03,0.86897e+03,0.11478e+04 /)
      kbo(:, 3,21, 9) = (/ &
        & 0.10537e+04,0.79858e+03,0.59010e+03,0.86836e+03,0.11471e+04 /)
      kbo(:, 4,21, 9) = (/ &
        & 0.10525e+04,0.79770e+03,0.58962e+03,0.86752e+03,0.11460e+04 /)
      kbo(:, 5,21, 9) = (/ &
        & 0.10514e+04,0.79685e+03,0.58893e+03,0.86654e+03,0.11447e+04 /)
      kbo(:, 1,22, 9) = (/ &
        & 0.10523e+04,0.79754e+03,0.59066e+03,0.86933e+03,0.11483e+04 /)
      kbo(:, 2,22, 9) = (/ &
        & 0.10510e+04,0.79661e+03,0.59033e+03,0.86884e+03,0.11477e+04 /)
      kbo(:, 3,22, 9) = (/ &
        & 0.10500e+04,0.79577e+03,0.58997e+03,0.86819e+03,0.11469e+04 /)
      kbo(:, 4,22, 9) = (/ &
        & 0.10490e+04,0.79506e+03,0.58945e+03,0.86737e+03,0.11458e+04 /)
      kbo(:, 5,22, 9) = (/ &
        & 0.10482e+04,0.79443e+03,0.58872e+03,0.86635e+03,0.11444e+04 /)
      kbo(:, 1,23, 9) = (/ &
        & 0.10488e+04,0.79491e+03,0.59053e+03,0.86922e+03,0.11482e+04 /)
      kbo(:, 2,23, 9) = (/ &
        & 0.10478e+04,0.79417e+03,0.59023e+03,0.86872e+03,0.11476e+04 /)
      kbo(:, 3,23, 9) = (/ &
        & 0.10469e+04,0.79351e+03,0.58983e+03,0.86802e+03,0.11467e+04 /)
      kbo(:, 4,23, 9) = (/ &
        & 0.10461e+04,0.79293e+03,0.58929e+03,0.86717e+03,0.11456e+04 /)
      kbo(:, 5,23, 9) = (/ &
        & 0.10455e+04,0.79241e+03,0.58851e+03,0.86610e+03,0.11442e+04 /)
      kbo(:, 1,24, 9) = (/ &
        & 0.10460e+04,0.79285e+03,0.59042e+03,0.86910e+03,0.11481e+04 /)
      kbo(:, 2,24, 9) = (/ &
        & 0.10452e+04,0.79220e+03,0.59009e+03,0.86856e+03,0.11474e+04 /)
      kbo(:, 3,24, 9) = (/ &
        & 0.10445e+04,0.79170e+03,0.58968e+03,0.86785e+03,0.11465e+04 /)
      kbo(:, 4,24, 9) = (/ &
        & 0.10439e+04,0.79123e+03,0.58911e+03,0.86698e+03,0.11453e+04 /)
      kbo(:, 5,24, 9) = (/ &
        & 0.10433e+04,0.79086e+03,0.58830e+03,0.86584e+03,0.11439e+04 /)
      kbo(:, 1,25, 9) = (/ &
        & 0.10438e+04,0.79109e+03,0.59032e+03,0.86899e+03,0.11480e+04 /)
      kbo(:, 2,25, 9) = (/ &
        & 0.10430e+04,0.79059e+03,0.58999e+03,0.86841e+03,0.11473e+04 /)
      kbo(:, 3,25, 9) = (/ &
        & 0.10425e+04,0.79018e+03,0.58955e+03,0.86768e+03,0.11463e+04 /)
      kbo(:, 4,25, 9) = (/ &
        & 0.10420e+04,0.78985e+03,0.58893e+03,0.86674e+03,0.11450e+04 /)
      kbo(:, 5,25, 9) = (/ &
        & 0.10416e+04,0.78947e+03,0.58810e+03,0.86557e+03,0.11436e+04 /)
      kbo(:, 1,26, 9) = (/ &
        & 0.10418e+04,0.78966e+03,0.59022e+03,0.86886e+03,0.11478e+04 /)
      kbo(:, 2,26, 9) = (/ &
        & 0.10414e+04,0.78932e+03,0.58989e+03,0.86824e+03,0.11471e+04 /)
      kbo(:, 3,26, 9) = (/ &
        & 0.10409e+04,0.78898e+03,0.58940e+03,0.86743e+03,0.11460e+04 /)
      kbo(:, 4,26, 9) = (/ &
        & 0.10405e+04,0.78870e+03,0.58873e+03,0.86647e+03,0.11447e+04 /)
      kbo(:, 5,26, 9) = (/ &
        & 0.10401e+04,0.78842e+03,0.58782e+03,0.86527e+03,0.11432e+04 /)
      kbo(:, 1,27, 9) = (/ &
        & 0.10403e+04,0.78855e+03,0.59012e+03,0.86872e+03,0.11477e+04 /)
      kbo(:, 2,27, 9) = (/ &
        & 0.10399e+04,0.78827e+03,0.58977e+03,0.86806e+03,0.11468e+04 /)
      kbo(:, 3,27, 9) = (/ &
        & 0.10396e+04,0.78799e+03,0.58924e+03,0.86723e+03,0.11458e+04 /)
      kbo(:, 4,27, 9) = (/ &
        & 0.10392e+04,0.78776e+03,0.58850e+03,0.86619e+03,0.11444e+04 /)
      kbo(:, 5,27, 9) = (/ &
        & 0.10390e+04,0.78757e+03,0.58756e+03,0.86495e+03,0.11428e+04 /)
      kbo(:, 1,28, 9) = (/ &
        & 0.10391e+04,0.78770e+03,0.59002e+03,0.86856e+03,0.11475e+04 /)
      kbo(:, 2,28, 9) = (/ &
        & 0.10388e+04,0.78747e+03,0.58964e+03,0.86790e+03,0.11466e+04 /)
      kbo(:, 3,28, 9) = (/ &
        & 0.10385e+04,0.78719e+03,0.58908e+03,0.86701e+03,0.11455e+04 /)
      kbo(:, 4,28, 9) = (/ &
        & 0.10383e+04,0.78704e+03,0.58829e+03,0.86590e+03,0.11440e+04 /)
      kbo(:, 5,28, 9) = (/ &
        & 0.10381e+04,0.78687e+03,0.58729e+03,0.86461e+03,0.11423e+04 /)
      kbo(:, 1,29, 9) = (/ &
        & 0.10382e+04,0.78694e+03,0.58994e+03,0.86841e+03,0.11473e+04 /)
      kbo(:, 2,29, 9) = (/ &
        & 0.10379e+04,0.78677e+03,0.58950e+03,0.86767e+03,0.11463e+04 /)
      kbo(:, 3,29, 9) = (/ &
        & 0.10377e+04,0.78658e+03,0.58888e+03,0.86674e+03,0.11451e+04 /)
      kbo(:, 4,29, 9) = (/ &
        & 0.10375e+04,0.78645e+03,0.58805e+03,0.86559e+03,0.11436e+04 /)
      kbo(:, 5,29, 9) = (/ &
        & 0.10374e+04,0.78628e+03,0.58702e+03,0.86429e+03,0.11419e+04 /)
      kbo(:, 1,30, 9) = (/ &
        & 0.10373e+04,0.78632e+03,0.58983e+03,0.86822e+03,0.11471e+04 /)
      kbo(:, 2,30, 9) = (/ &
        & 0.10371e+04,0.78619e+03,0.58935e+03,0.86746e+03,0.11460e+04 /)
      kbo(:, 3,30, 9) = (/ &
        & 0.10370e+04,0.78613e+03,0.58869e+03,0.86647e+03,0.11448e+04 /)
      kbo(:, 4,30, 9) = (/ &
        & 0.10369e+04,0.78594e+03,0.58779e+03,0.86529e+03,0.11432e+04 /)
      kbo(:, 5,30, 9) = (/ &
        & 0.10367e+04,0.78585e+03,0.58673e+03,0.86393e+03,0.11414e+04 /)
      kbo(:, 1,31, 9) = (/ &
        & 0.10367e+04,0.78588e+03,0.58971e+03,0.86804e+03,0.11468e+04 /)
      kbo(:, 2,31, 9) = (/ &
        & 0.10365e+04,0.78574e+03,0.58919e+03,0.86720e+03,0.11457e+04 /)
      kbo(:, 3,31, 9) = (/ &
        & 0.10364e+04,0.78562e+03,0.58847e+03,0.86618e+03,0.11443e+04 /)
      kbo(:, 4,31, 9) = (/ &
        & 0.10363e+04,0.78557e+03,0.58752e+03,0.86495e+03,0.11427e+04 /)
      kbo(:, 5,31, 9) = (/ &
        & 0.10362e+04,0.78546e+03,0.58644e+03,0.86356e+03,0.11409e+04 /)
      kbo(:, 1,32, 9) = (/ &
        & 0.10362e+04,0.78556e+03,0.58958e+03,0.86784e+03,0.11466e+04 /)
      kbo(:, 2,32, 9) = (/ &
        & 0.10361e+04,0.78539e+03,0.58901e+03,0.86697e+03,0.11454e+04 /)
      kbo(:, 3,32, 9) = (/ &
        & 0.10360e+04,0.78539e+03,0.58824e+03,0.86587e+03,0.11440e+04 /)
      kbo(:, 4,32, 9) = (/ &
        & 0.10359e+04,0.78525e+03,0.58724e+03,0.86459e+03,0.11423e+04 /)
      kbo(:, 5,32, 9) = (/ &
        & 0.10358e+04,0.78516e+03,0.58615e+03,0.86318e+03,0.11404e+04 /)
      kbo(:, 1,33, 9) = (/ &
        & 0.10358e+04,0.78520e+03,0.58945e+03,0.86763e+03,0.11463e+04 /)
      kbo(:, 2,33, 9) = (/ &
        & 0.10357e+04,0.78510e+03,0.58883e+03,0.86670e+03,0.11450e+04 /)
      kbo(:, 3,33, 9) = (/ &
        & 0.10356e+04,0.78504e+03,0.58799e+03,0.86554e+03,0.11435e+04 /)
      kbo(:, 4,33, 9) = (/ &
        & 0.10356e+04,0.78500e+03,0.58695e+03,0.86422e+03,0.11418e+04 /)
      kbo(:, 5,33, 9) = (/ &
        & 0.10355e+04,0.78493e+03,0.58586e+03,0.86281e+03,0.11399e+04 /)
      kbo(:, 1,34, 9) = (/ &
        & 0.10355e+04,0.78495e+03,0.58932e+03,0.86743e+03,0.11460e+04 /)
      kbo(:, 2,34, 9) = (/ &
        & 0.10354e+04,0.78487e+03,0.58865e+03,0.86644e+03,0.11447e+04 /)
      kbo(:, 3,34, 9) = (/ &
        & 0.10354e+04,0.78485e+03,0.58776e+03,0.86524e+03,0.11432e+04 /)
      kbo(:, 4,34, 9) = (/ &
        & 0.10353e+04,0.78479e+03,0.58670e+03,0.86390e+03,0.11414e+04 /)
      kbo(:, 5,34, 9) = (/ &
        & 0.10352e+04,0.78474e+03,0.58560e+03,0.86249e+03,0.11395e+04 /)
      kbo(:, 1,35, 9) = (/ &
        & 0.10352e+04,0.78478e+03,0.58924e+03,0.86731e+03,0.11459e+04 /)
      kbo(:, 2,35, 9) = (/ &
        & 0.10352e+04,0.78472e+03,0.58855e+03,0.86632e+03,0.11445e+04 /)
      kbo(:, 3,35, 9) = (/ &
        & 0.10351e+04,0.78465e+03,0.58761e+03,0.86508e+03,0.11430e+04 /)
      kbo(:, 4,35, 9) = (/ &
        & 0.10350e+04,0.78465e+03,0.58655e+03,0.86369e+03,0.11412e+04 /)
      kbo(:, 5,35, 9) = (/ &
        & 0.10350e+04,0.78456e+03,0.58545e+03,0.86237e+03,0.11393e+04 /)
      kbo(:, 1,36, 9) = (/ &
        & 0.10350e+04,0.78465e+03,0.58922e+03,0.86729e+03,0.11458e+04 /)
      kbo(:, 2,36, 9) = (/ &
        & 0.10350e+04,0.78456e+03,0.58852e+03,0.86627e+03,0.11445e+04 /)
      kbo(:, 3,36, 9) = (/ &
        & 0.10350e+04,0.78452e+03,0.58759e+03,0.86505e+03,0.11429e+04 /)
      kbo(:, 4,36, 9) = (/ &
        & 0.10349e+04,0.78450e+03,0.58651e+03,0.86369e+03,0.11411e+04 /)
      kbo(:, 5,36, 9) = (/ &
        & 0.10348e+04,0.78444e+03,0.58544e+03,0.86227e+03,0.11392e+04 /)
      kbo(:, 1,37, 9) = (/ &
        & 0.10349e+04,0.78446e+03,0.58930e+03,0.86738e+03,0.11460e+04 /)
      kbo(:, 2,37, 9) = (/ &
        & 0.10348e+04,0.78444e+03,0.58863e+03,0.86642e+03,0.11447e+04 /)
      kbo(:, 3,37, 9) = (/ &
        & 0.10348e+04,0.78441e+03,0.58773e+03,0.86522e+03,0.11432e+04 /)
      kbo(:, 4,37, 9) = (/ &
        & 0.10348e+04,0.78439e+03,0.58667e+03,0.86387e+03,0.11414e+04 /)
      kbo(:, 5,37, 9) = (/ &
        & 0.10347e+04,0.78436e+03,0.58559e+03,0.86245e+03,0.11394e+04 /)
      kbo(:, 1,38, 9) = (/ &
        & 0.10348e+04,0.78440e+03,0.58936e+03,0.86753e+03,0.11462e+04 /)
      kbo(:, 2,38, 9) = (/ &
        & 0.10347e+04,0.78434e+03,0.58873e+03,0.86658e+03,0.11449e+04 /)
      kbo(:, 3,38, 9) = (/ &
        & 0.10347e+04,0.78432e+03,0.58786e+03,0.86537e+03,0.11434e+04 /)
      kbo(:, 4,38, 9) = (/ &
        & 0.10346e+04,0.78431e+03,0.58681e+03,0.86407e+03,0.11416e+04 /)
      kbo(:, 5,38, 9) = (/ &
        & 0.10347e+04,0.78428e+03,0.58573e+03,0.86265e+03,0.11397e+04 /)
      kbo(:, 1,39, 9) = (/ &
        & 0.10347e+04,0.78431e+03,0.58943e+03,0.86764e+03,0.11463e+04 /)
      kbo(:, 2,39, 9) = (/ &
        & 0.10346e+04,0.78431e+03,0.58882e+03,0.86672e+03,0.11451e+04 /)
      kbo(:, 3,39, 9) = (/ &
        & 0.10346e+04,0.78424e+03,0.58800e+03,0.86557e+03,0.11436e+04 /)
      kbo(:, 4,39, 9) = (/ &
        & 0.10346e+04,0.78421e+03,0.58697e+03,0.86426e+03,0.11419e+04 /)
      kbo(:, 5,39, 9) = (/ &
        & 0.10346e+04,0.78429e+03,0.58587e+03,0.86284e+03,0.11400e+04 /)
      kbo(:, 1,40, 9) = (/ &
        & 0.10346e+04,0.78426e+03,0.58957e+03,0.86785e+03,0.11466e+04 /)
      kbo(:, 2,40, 9) = (/ &
        & 0.10345e+04,0.78427e+03,0.58899e+03,0.86697e+03,0.11454e+04 /)
      kbo(:, 3,40, 9) = (/ &
        & 0.10345e+04,0.78422e+03,0.58822e+03,0.86585e+03,0.11440e+04 /)
      kbo(:, 4,40, 9) = (/ &
        & 0.10345e+04,0.78421e+03,0.58723e+03,0.86460e+03,0.11423e+04 /)
      kbo(:, 5,40, 9) = (/ &
        & 0.10344e+04,0.78416e+03,0.58614e+03,0.86319e+03,0.11403e+04 /)
      kbo(:, 1,41, 9) = (/ &
        & 0.10345e+04,0.78421e+03,0.58967e+03,0.86804e+03,0.11468e+04 /)
      kbo(:, 2,41, 9) = (/ &
        & 0.10345e+04,0.78418e+03,0.58916e+03,0.86720e+03,0.11457e+04 /)
      kbo(:, 3,41, 9) = (/ &
        & 0.10344e+04,0.78415e+03,0.58844e+03,0.86618e+03,0.11444e+04 /)
      kbo(:, 4,41, 9) = (/ &
        & 0.10344e+04,0.78413e+03,0.58748e+03,0.86492e+03,0.11428e+04 /)
      kbo(:, 5,41, 9) = (/ &
        & 0.10344e+04,0.78411e+03,0.58642e+03,0.86355e+03,0.11409e+04 /)
      kbo(:, 1,42, 9) = (/ &
        & 0.10345e+04,0.78414e+03,0.58976e+03,0.86830e+03,0.11471e+04 /)
      kbo(:, 2,42, 9) = (/ &
        & 0.10344e+04,0.78417e+03,0.58930e+03,0.86744e+03,0.11460e+04 /)
      kbo(:, 3,42, 9) = (/ &
        & 0.10344e+04,0.78411e+03,0.58863e+03,0.86645e+03,0.11448e+04 /)
      kbo(:, 4,42, 9) = (/ &
        & 0.10344e+04,0.78409e+03,0.58775e+03,0.86525e+03,0.11432e+04 /)
      kbo(:, 5,42, 9) = (/ &
        & 0.10344e+04,0.78408e+03,0.58670e+03,0.86391e+03,0.11414e+04 /)
      kbo(:, 1,43, 9) = (/ &
        & 0.10344e+04,0.78410e+03,0.58987e+03,0.86842e+03,0.11473e+04 /)
      kbo(:, 2,43, 9) = (/ &
        & 0.10344e+04,0.78408e+03,0.58947e+03,0.86769e+03,0.11464e+04 /)
      kbo(:, 3,43, 9) = (/ &
        & 0.10344e+04,0.78409e+03,0.58887e+03,0.86678e+03,0.11452e+04 /)
      kbo(:, 4,43, 9) = (/ &
        & 0.10344e+04,0.78410e+03,0.58806e+03,0.86567e+03,0.11437e+04 /)
      kbo(:, 5,43, 9) = (/ &
        & 0.10343e+04,0.78406e+03,0.58704e+03,0.86435e+03,0.11420e+04 /)
      kbo(:, 1,44, 9) = (/ &
        & 0.10344e+04,0.78409e+03,0.58998e+03,0.86862e+03,0.11476e+04 /)
      kbo(:, 2,44, 9) = (/ &
        & 0.10343e+04,0.78407e+03,0.58962e+03,0.86796e+03,0.11467e+04 /)
      kbo(:, 3,44, 9) = (/ &
        & 0.10343e+04,0.78406e+03,0.58910e+03,0.86711e+03,0.11456e+04 /)
      kbo(:, 4,44, 9) = (/ &
        & 0.10343e+04,0.78403e+03,0.58835e+03,0.86607e+03,0.11442e+04 /)
      kbo(:, 5,44, 9) = (/ &
        & 0.10343e+04,0.78403e+03,0.58738e+03,0.86483e+03,0.11426e+04 /)
      kbo(:, 1,45, 9) = (/ &
        & 0.10343e+04,0.78404e+03,0.59009e+03,0.86881e+03,0.11478e+04 /)
      kbo(:, 2,45, 9) = (/ &
        & 0.10343e+04,0.78405e+03,0.58975e+03,0.86821e+03,0.11471e+04 /)
      kbo(:, 3,45, 9) = (/ &
        & 0.10343e+04,0.78404e+03,0.58930e+03,0.86741e+03,0.11460e+04 /)
      kbo(:, 4,45, 9) = (/ &
        & 0.10342e+04,0.78400e+03,0.58862e+03,0.86644e+03,0.11447e+04 /)
      kbo(:, 5,45, 9) = (/ &
        & 0.10343e+04,0.78402e+03,0.58769e+03,0.86520e+03,0.11432e+04 /)
      kbo(:, 1,46, 9) = (/ &
        & 0.10343e+04,0.78403e+03,0.59019e+03,0.86899e+03,0.11481e+04 /)
      kbo(:, 2,46, 9) = (/ &
        & 0.10343e+04,0.78403e+03,0.58989e+03,0.86845e+03,0.11474e+04 /)
      kbo(:, 3,46, 9) = (/ &
        & 0.10343e+04,0.78403e+03,0.58947e+03,0.86773e+03,0.11464e+04 /)
      kbo(:, 4,46, 9) = (/ &
        & 0.10342e+04,0.78401e+03,0.58890e+03,0.86681e+03,0.11452e+04 /)
      kbo(:, 5,46, 9) = (/ &
        & 0.10343e+04,0.78405e+03,0.58808e+03,0.86568e+03,0.11438e+04 /)
      kbo(:, 1,47, 9) = (/ &
        & 0.10343e+04,0.78401e+03,0.59032e+03,0.86917e+03,0.11483e+04 /)
      kbo(:, 2,47, 9) = (/ &
        & 0.10342e+04,0.78398e+03,0.59001e+03,0.86868e+03,0.11477e+04 /)
      kbo(:, 3,47, 9) = (/ &
        & 0.10342e+04,0.78398e+03,0.58967e+03,0.86807e+03,0.11468e+04 /)
      kbo(:, 4,47, 9) = (/ &
        & 0.10343e+04,0.78397e+03,0.58916e+03,0.86720e+03,0.11457e+04 /)
      kbo(:, 5,47, 9) = (/ &
        & 0.10342e+04,0.78399e+03,0.58844e+03,0.86618e+03,0.11444e+04 /)
      kbo(:, 1,48, 9) = (/ &
        & 0.10342e+04,0.78399e+03,0.59046e+03,0.86932e+03,0.11485e+04 /)
      kbo(:, 2,48, 9) = (/ &
        & 0.10343e+04,0.78398e+03,0.59013e+03,0.86890e+03,0.11480e+04 /)
      kbo(:, 3,48, 9) = (/ &
        & 0.10342e+04,0.78402e+03,0.58982e+03,0.86829e+03,0.11472e+04 /)
      kbo(:, 4,48, 9) = (/ &
        & 0.10342e+04,0.78396e+03,0.58938e+03,0.86756e+03,0.11462e+04 /)
      kbo(:, 5,48, 9) = (/ &
        & 0.10342e+04,0.78400e+03,0.58875e+03,0.86661e+03,0.11449e+04 /)
      kbo(:, 1,49, 9) = (/ &
        & 0.10343e+04,0.78402e+03,0.59060e+03,0.86945e+03,0.11486e+04 /)
      kbo(:, 2,49, 9) = (/ &
        & 0.10342e+04,0.78398e+03,0.59025e+03,0.86908e+03,0.11482e+04 /)
      kbo(:, 3,49, 9) = (/ &
        & 0.10342e+04,0.78399e+03,0.58995e+03,0.86856e+03,0.11475e+04 /)
      kbo(:, 4,49, 9) = (/ &
        & 0.10342e+04,0.78399e+03,0.58958e+03,0.86790e+03,0.11466e+04 /)
      kbo(:, 5,49, 9) = (/ &
        & 0.10342e+04,0.78398e+03,0.58903e+03,0.86700e+03,0.11455e+04 /)
      kbo(:, 1,50, 9) = (/ &
        & 0.10343e+04,0.78395e+03,0.59074e+03,0.86956e+03,0.11487e+04 /)
      kbo(:, 2,50, 9) = (/ &
        & 0.10342e+04,0.78399e+03,0.59038e+03,0.86924e+03,0.11483e+04 /)
      kbo(:, 3,50, 9) = (/ &
        & 0.10342e+04,0.78394e+03,0.59006e+03,0.86878e+03,0.11478e+04 /)
      kbo(:, 4,50, 9) = (/ &
        & 0.10342e+04,0.78399e+03,0.58974e+03,0.86817e+03,0.11470e+04 /)
      kbo(:, 5,50, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.58927e+03,0.86736e+03,0.11460e+04 /)
      kbo(:, 1,51, 9) = (/ &
        & 0.10342e+04,0.78399e+03,0.59088e+03,0.86965e+03,0.11488e+04 /)
      kbo(:, 2,51, 9) = (/ &
        & 0.10342e+04,0.78393e+03,0.59051e+03,0.86937e+03,0.11485e+04 /)
      kbo(:, 3,51, 9) = (/ &
        & 0.10342e+04,0.78400e+03,0.59018e+03,0.86897e+03,0.11480e+04 /)
      kbo(:, 4,51, 9) = (/ &
        & 0.10342e+04,0.78396e+03,0.58987e+03,0.86840e+03,0.11473e+04 /)
      kbo(:, 5,51, 9) = (/ &
        & 0.10342e+04,0.78396e+03,0.58946e+03,0.86768e+03,0.11464e+04 /)
      kbo(:, 1,52, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.59100e+03,0.86971e+03,0.11490e+04 /)
      kbo(:, 2,52, 9) = (/ &
        & 0.10342e+04,0.78394e+03,0.59064e+03,0.86949e+03,0.11486e+04 /)
      kbo(:, 3,52, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.59029e+03,0.86915e+03,0.11482e+04 /)
      kbo(:, 4,52, 9) = (/ &
        & 0.10342e+04,0.78394e+03,0.58998e+03,0.86864e+03,0.11476e+04 /)
      kbo(:, 5,52, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.58963e+03,0.86796e+03,0.11468e+04 /)
      kbo(:, 1,53, 9) = (/ &
        & 0.10342e+04,0.78397e+03,0.59111e+03,0.86975e+03,0.11490e+04 /)
      kbo(:, 2,53, 9) = (/ &
        & 0.10342e+04,0.78394e+03,0.59078e+03,0.86960e+03,0.11488e+04 /)
      kbo(:, 3,53, 9) = (/ &
        & 0.10342e+04,0.78396e+03,0.59041e+03,0.86926e+03,0.11484e+04 /)
      kbo(:, 4,53, 9) = (/ &
        & 0.10341e+04,0.78393e+03,0.59010e+03,0.86884e+03,0.11479e+04 /)
      kbo(:, 5,53, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.58977e+03,0.86822e+03,0.11471e+04 /)
      kbo(:, 1,54, 9) = (/ &
        & 0.10343e+04,0.78394e+03,0.59121e+03,0.86979e+03,0.11491e+04 /)
      kbo(:, 2,54, 9) = (/ &
        & 0.10341e+04,0.78399e+03,0.59088e+03,0.86966e+03,0.11489e+04 /)
      kbo(:, 3,54, 9) = (/ &
        & 0.10341e+04,0.78394e+03,0.59052e+03,0.86939e+03,0.11485e+04 /)
      kbo(:, 4,54, 9) = (/ &
        & 0.10341e+04,0.78394e+03,0.59020e+03,0.86900e+03,0.11481e+04 /)
      kbo(:, 5,54, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.58987e+03,0.86845e+03,0.11474e+04 /)
      kbo(:, 1,55, 9) = (/ &
        & 0.10342e+04,0.78396e+03,0.59130e+03,0.86983e+03,0.11491e+04 /)
      kbo(:, 2,55, 9) = (/ &
        & 0.10341e+04,0.78393e+03,0.59100e+03,0.86971e+03,0.11490e+04 /)
      kbo(:, 3,55, 9) = (/ &
        & 0.10342e+04,0.78393e+03,0.59065e+03,0.86949e+03,0.11486e+04 /)
      kbo(:, 4,55, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.59029e+03,0.86914e+03,0.11483e+04 /)
      kbo(:, 5,55, 9) = (/ &
        & 0.10341e+04,0.78393e+03,0.59000e+03,0.86864e+03,0.11477e+04 /)
      kbo(:, 1,56, 9) = (/ &
        & 0.10342e+04,0.78393e+03,0.59137e+03,0.86987e+03,0.11492e+04 /)
      kbo(:, 2,56, 9) = (/ &
        & 0.10342e+04,0.78395e+03,0.59111e+03,0.86975e+03,0.11490e+04 /)
      kbo(:, 3,56, 9) = (/ &
        & 0.10342e+04,0.78392e+03,0.59077e+03,0.86958e+03,0.11488e+04 /)
      kbo(:, 4,56, 9) = (/ &
        & 0.10342e+04,0.78393e+03,0.59040e+03,0.86926e+03,0.11484e+04 /)
      kbo(:, 5,56, 9) = (/ &
        & 0.10341e+04,0.78393e+03,0.59009e+03,0.86883e+03,0.11479e+04 /)
      kbo(:, 1,57, 9) = (/ &
        & 0.10342e+04,0.78396e+03,0.59143e+03,0.86993e+03,0.11492e+04 /)
      kbo(:, 2,57, 9) = (/ &
        & 0.10342e+04,0.78392e+03,0.59122e+03,0.86979e+03,0.11491e+04 /)
      kbo(:, 3,57, 9) = (/ &
        & 0.10342e+04,0.78392e+03,0.59089e+03,0.86966e+03,0.11489e+04 /)
      kbo(:, 4,57, 9) = (/ &
        & 0.10341e+04,0.78395e+03,0.59052e+03,0.86938e+03,0.11485e+04 /)
      kbo(:, 5,57, 9) = (/ &
        & 0.10341e+04,0.78393e+03,0.59018e+03,0.86897e+03,0.11481e+04 /)
      kbo(:, 1,58, 9) = (/ &
        & 0.10341e+04,0.78395e+03,0.59147e+03,0.86996e+03,0.11493e+04 /)
      kbo(:, 2,58, 9) = (/ &
        & 0.10341e+04,0.78397e+03,0.59129e+03,0.86982e+03,0.11491e+04 /)
      kbo(:, 3,58, 9) = (/ &
        & 0.10341e+04,0.78393e+03,0.59099e+03,0.86970e+03,0.11489e+04 /)
      kbo(:, 4,58, 9) = (/ &
        & 0.10342e+04,0.78397e+03,0.59063e+03,0.86948e+03,0.11486e+04 /)
      kbo(:, 5,58, 9) = (/ &
        & 0.10342e+04,0.78390e+03,0.59028e+03,0.86913e+03,0.11482e+04 /)
      kbo(:, 1,59, 9) = (/ &
        & 0.10342e+04,0.78393e+03,0.59148e+03,0.86998e+03,0.11494e+04 /)
      kbo(:, 2,59, 9) = (/ &
        & 0.10342e+04,0.78396e+03,0.59132e+03,0.86982e+03,0.11492e+04 /)
      kbo(:, 3,59, 9) = (/ &
        & 0.10342e+04,0.78393e+03,0.59103e+03,0.86972e+03,0.11490e+04 /)
      kbo(:, 4,59, 9) = (/ &
        & 0.10341e+04,0.78394e+03,0.59067e+03,0.86951e+03,0.11487e+04 /)
      kbo(:, 5,59, 9) = (/ &
        & 0.10341e+04,0.78397e+03,0.59032e+03,0.86918e+03,0.11483e+04 /)
      kbo(:, 1,13,10) = (/ &
        & 0.11544e+04,0.87486e+03,0.59975e+03,0.88029e+03,0.11631e+04 /)
      kbo(:, 2,13,10) = (/ &
        & 0.11458e+04,0.86752e+03,0.59921e+03,0.87889e+03,0.11611e+04 /)
      kbo(:, 3,13,10) = (/ &
        & 0.11380e+04,0.86177e+03,0.59836e+03,0.87789e+03,0.11592e+04 /)
      kbo(:, 4,13,10) = (/ &
        & 0.11310e+04,0.85697e+03,0.59745e+03,0.87697e+03,0.11577e+04 /)
      kbo(:, 5,13,10) = (/ &
        & 0.11259e+04,0.85279e+03,0.59663e+03,0.87606e+03,0.11564e+04 /)
      kbo(:, 1,14,10) = (/ &
        & 0.11329e+04,0.85757e+03,0.59935e+03,0.88000e+03,0.11630e+04 /)
      kbo(:, 2,14,10) = (/ &
        & 0.11257e+04,0.85228e+03,0.59878e+03,0.87841e+03,0.11609e+04 /)
      kbo(:, 3,14,10) = (/ &
        & 0.11201e+04,0.84731e+03,0.59797e+03,0.87766e+03,0.11591e+04 /)
      kbo(:, 4,14,10) = (/ &
        & 0.11140e+04,0.84389e+03,0.59731e+03,0.87707e+03,0.11577e+04 /)
      kbo(:, 5,14,10) = (/ &
        & 0.11094e+04,0.84001e+03,0.59642e+03,0.87571e+03,0.11561e+04 /)
      kbo(:, 1,15,10) = (/ &
        & 0.11142e+04,0.84370e+03,0.59900e+03,0.87973e+03,0.11627e+04 /)
      kbo(:, 2,15,10) = (/ &
        & 0.11097e+04,0.84029e+03,0.59841e+03,0.87827e+03,0.11607e+04 /)
      kbo(:, 3,15,10) = (/ &
        & 0.11039e+04,0.83570e+03,0.59763e+03,0.87745e+03,0.11587e+04 /)
      kbo(:, 4,15,10) = (/ &
        & 0.10995e+04,0.83295e+03,0.59685e+03,0.87664e+03,0.11574e+04 /)
      kbo(:, 5,15,10) = (/ &
        & 0.10956e+04,0.82966e+03,0.59611e+03,0.87548e+03,0.11555e+04 /)
      kbo(:, 1,16,10) = (/ &
        & 0.11006e+04,0.83290e+03,0.59871e+03,0.87947e+03,0.11625e+04 /)
      kbo(:, 2,16,10) = (/ &
        & 0.10967e+04,0.82960e+03,0.59809e+03,0.87696e+03,0.11605e+04 /)
      kbo(:, 3,16,10) = (/ &
        & 0.10908e+04,0.82627e+03,0.59735e+03,0.87716e+03,0.11587e+04 /)
      kbo(:, 4,16,10) = (/ &
        & 0.10878e+04,0.82496e+03,0.59665e+03,0.87645e+03,0.11573e+04 /)
      kbo(:, 5,16,10) = (/ &
        & 0.10846e+04,0.82140e+03,0.59584e+03,0.87537e+03,0.11556e+04 /)
      kbo(:, 1,17,10) = (/ &
        & 0.10872e+04,0.82399e+03,0.59847e+03,0.87912e+03,0.11623e+04 /)
      kbo(:, 2,17,10) = (/ &
        & 0.10836e+04,0.82137e+03,0.59782e+03,0.87785e+03,0.11604e+04 /)
      kbo(:, 3,17,10) = (/ &
        & 0.10806e+04,0.81903e+03,0.59710e+03,0.87700e+03,0.11586e+04 /)
      kbo(:, 4,17,10) = (/ &
        & 0.10781e+04,0.81649e+03,0.59641e+03,0.87627e+03,0.11571e+04 /)
      kbo(:, 5,17,10) = (/ &
        & 0.10750e+04,0.81461e+03,0.59560e+03,0.87517e+03,0.11554e+04 /)
      kbo(:, 1,18,10) = (/ &
        & 0.10783e+04,0.81627e+03,0.59826e+03,0.87902e+03,0.11620e+04 /)
      kbo(:, 2,18,10) = (/ &
        & 0.10752e+04,0.81450e+03,0.59759e+03,0.87778e+03,0.11602e+04 /)
      kbo(:, 3,18,10) = (/ &
        & 0.10718e+04,0.81284e+03,0.59689e+03,0.87707e+03,0.11584e+04 /)
      kbo(:, 4,18,10) = (/ &
        & 0.10695e+04,0.81051e+03,0.59620e+03,0.87578e+03,0.11570e+04 /)
      kbo(:, 5,18,10) = (/ &
        & 0.10675e+04,0.80859e+03,0.59539e+03,0.87498e+03,0.11554e+04 /)
      kbo(:, 1,19,10) = (/ &
        & 0.10693e+04,0.81014e+03,0.59808e+03,0.87871e+03,0.11618e+04 /)
      kbo(:, 2,19,10) = (/ &
        & 0.10674e+04,0.80961e+03,0.59739e+03,0.87763e+03,0.11601e+04 /)
      kbo(:, 3,19,10) = (/ &
        & 0.10651e+04,0.80782e+03,0.59664e+03,0.87683e+03,0.11582e+04 /)
      kbo(:, 4,19,10) = (/ &
        & 0.10639e+04,0.80562e+03,0.59610e+03,0.87595e+03,0.11569e+04 /)
      kbo(:, 5,19,10) = (/ &
        & 0.10620e+04,0.80440e+03,0.59520e+03,0.87481e+03,0.11551e+04 /)
      kbo(:, 1,20,10) = (/ &
        & 0.10633e+04,0.80580e+03,0.59791e+03,0.87862e+03,0.11616e+04 /)
      kbo(:, 2,20,10) = (/ &
        & 0.10619e+04,0.80442e+03,0.59720e+03,0.87747e+03,0.11598e+04 /)
      kbo(:, 3,20,10) = (/ &
        & 0.10607e+04,0.80344e+03,0.59654e+03,0.87680e+03,0.11581e+04 /)
      kbo(:, 4,20,10) = (/ &
        & 0.10584e+04,0.80182e+03,0.59585e+03,0.87568e+03,0.11568e+04 /)
      kbo(:, 5,20,10) = (/ &
        & 0.10568e+04,0.80142e+03,0.59502e+03,0.87461e+03,0.11549e+04 /)
      kbo(:, 1,21,10) = (/ &
        & 0.10577e+04,0.80247e+03,0.59775e+03,0.87831e+03,0.11614e+04 /)
      kbo(:, 2,21,10) = (/ &
        & 0.10572e+04,0.80108e+03,0.59703e+03,0.87733e+03,0.11595e+04 /)
      kbo(:, 3,21,10) = (/ &
        & 0.10551e+04,0.79955e+03,0.59639e+03,0.87689e+03,0.11579e+04 /)
      kbo(:, 4,21,10) = (/ &
        & 0.10548e+04,0.79914e+03,0.59569e+03,0.87563e+03,0.11565e+04 /)
      kbo(:, 5,21,10) = (/ &
        & 0.10533e+04,0.79794e+03,0.59484e+03,0.87454e+03,0.11546e+04 /)
      kbo(:, 1,22,10) = (/ &
        & 0.10544e+04,0.79901e+03,0.59755e+03,0.87816e+03,0.11610e+04 /)
      kbo(:, 2,22,10) = (/ &
        & 0.10524e+04,0.79865e+03,0.59692e+03,0.87715e+03,0.11592e+04 /)
      kbo(:, 3,22,10) = (/ &
        & 0.10518e+04,0.79733e+03,0.59621e+03,0.87638e+03,0.11576e+04 /)
      kbo(:, 4,22,10) = (/ &
        & 0.10503e+04,0.79602e+03,0.59549e+03,0.87540e+03,0.11562e+04 /)
      kbo(:, 5,22,10) = (/ &
        & 0.10497e+04,0.79577e+03,0.59455e+03,0.87415e+03,0.11542e+04 /)
      kbo(:, 1,23,10) = (/ &
        & 0.10504e+04,0.79618e+03,0.59736e+03,0.87790e+03,0.11608e+04 /)
      kbo(:, 2,23,10) = (/ &
        & 0.10488e+04,0.79542e+03,0.59652e+03,0.87687e+03,0.11588e+04 /)
      kbo(:, 3,23,10) = (/ &
        & 0.10489e+04,0.79466e+03,0.59603e+03,0.87619e+03,0.11574e+04 /)
      kbo(:, 4,23,10) = (/ &
        & 0.10477e+04,0.79399e+03,0.59528e+03,0.87505e+03,0.11559e+04 /)
      kbo(:, 5,23,10) = (/ &
        & 0.10468e+04,0.79357e+03,0.59440e+03,0.87388e+03,0.11537e+04 /)
      kbo(:, 1,24,10) = (/ &
        & 0.10475e+04,0.79355e+03,0.59716e+03,0.87766e+03,0.11603e+04 /)
      kbo(:, 2,24,10) = (/ &
        & 0.10471e+04,0.79325e+03,0.59650e+03,0.87681e+03,0.11585e+04 /)
      kbo(:, 3,24,10) = (/ &
        & 0.10463e+04,0.79243e+03,0.59586e+03,0.87587e+03,0.11571e+04 /)
      kbo(:, 4,24,10) = (/ &
        & 0.10454e+04,0.79206e+03,0.59508e+03,0.87468e+03,0.11555e+04 /)
      kbo(:, 5,24,10) = (/ &
        & 0.10455e+04,0.79146e+03,0.59426e+03,0.87360e+03,0.11532e+04 /)
      kbo(:, 1,25,10) = (/ &
        & 0.10443e+04,0.79222e+03,0.59698e+03,0.87742e+03,0.11598e+04 /)
      kbo(:, 2,25,10) = (/ &
        & 0.10446e+04,0.79165e+03,0.59633e+03,0.87696e+03,0.11582e+04 /)
      kbo(:, 3,25,10) = (/ &
        & 0.10440e+04,0.79123e+03,0.59567e+03,0.87565e+03,0.11568e+04 /)
      kbo(:, 4,25,10) = (/ &
        & 0.10433e+04,0.79106e+03,0.59487e+03,0.87451e+03,0.11551e+04 /)
      kbo(:, 5,25,10) = (/ &
        & 0.10423e+04,0.79063e+03,0.59375e+03,0.87329e+03,0.11525e+04 /)
      kbo(:, 1,26,10) = (/ &
        & 0.10431e+04,0.79112e+03,0.59671e+03,0.87720e+03,0.11595e+04 /)
      kbo(:, 2,26,10) = (/ &
        & 0.10430e+04,0.79016e+03,0.59608e+03,0.87633e+03,0.11579e+04 /)
      kbo(:, 3,26,10) = (/ &
        & 0.10422e+04,0.78992e+03,0.59547e+03,0.87551e+03,0.11565e+04 /)
      kbo(:, 4,26,10) = (/ &
        & 0.10418e+04,0.78943e+03,0.59456e+03,0.87419e+03,0.11545e+04 /)
      kbo(:, 5,26,10) = (/ &
        & 0.10417e+04,0.78966e+03,0.59375e+03,0.87285e+03,0.11523e+04 /)
      kbo(:, 1,27,10) = (/ &
        & 0.10421e+04,0.78970e+03,0.59653e+03,0.87700e+03,0.11589e+04 /)
      kbo(:, 2,27,10) = (/ &
        & 0.10419e+04,0.78911e+03,0.59591e+03,0.87623e+03,0.11575e+04 /)
      kbo(:, 3,27,10) = (/ &
        & 0.10414e+04,0.78914e+03,0.59527e+03,0.87524e+03,0.11555e+04 /)
      kbo(:, 4,27,10) = (/ &
        & 0.10412e+04,0.78891e+03,0.59440e+03,0.87398e+03,0.11540e+04 /)
      kbo(:, 5,27,10) = (/ &
        & 0.10400e+04,0.78850e+03,0.59354e+03,0.87262e+03,0.11516e+04 /)
      kbo(:, 1,28,10) = (/ &
        & 0.10402e+04,0.78860e+03,0.59644e+03,0.87682e+03,0.11586e+04 /)
      kbo(:, 2,28,10) = (/ &
        & 0.10405e+04,0.78788e+03,0.59574e+03,0.87579e+03,0.11571e+04 /)
      kbo(:, 3,28,10) = (/ &
        & 0.10403e+04,0.78855e+03,0.59498e+03,0.87473e+03,0.11552e+04 /)
      kbo(:, 4,28,10) = (/ &
        & 0.10397e+04,0.78826e+03,0.59417e+03,0.87377e+03,0.11534e+04 /)
      kbo(:, 5,28,10) = (/ &
        & 0.10396e+04,0.78810e+03,0.59333e+03,0.87227e+03,0.11511e+04 /)
      kbo(:, 1,29,10) = (/ &
        & 0.10391e+04,0.78797e+03,0.59612e+03,0.87685e+03,0.11584e+04 /)
      kbo(:, 2,29,10) = (/ &
        & 0.10393e+04,0.78808e+03,0.59562e+03,0.87577e+03,0.11569e+04 /)
      kbo(:, 3,29,10) = (/ &
        & 0.10401e+04,0.78791e+03,0.59476e+03,0.87463e+03,0.11550e+04 /)
      kbo(:, 4,29,10) = (/ &
        & 0.10388e+04,0.78727e+03,0.59387e+03,0.87332e+03,0.11526e+04 /)
      kbo(:, 5,29,10) = (/ &
        & 0.10383e+04,0.78753e+03,0.59306e+03,0.87189e+03,0.11504e+04 /)
      kbo(:, 1,30,10) = (/ &
        & 0.10398e+04,0.78748e+03,0.59603e+03,0.87643e+03,0.11579e+04 /)
      kbo(:, 2,30,10) = (/ &
        & 0.10387e+04,0.78733e+03,0.59550e+03,0.87550e+03,0.11567e+04 /)
      kbo(:, 3,30,10) = (/ &
        & 0.10384e+04,0.78700e+03,0.59460e+03,0.87431e+03,0.11543e+04 /)
      kbo(:, 4,30,10) = (/ &
        & 0.10381e+04,0.78738e+03,0.59372e+03,0.87275e+03,0.11522e+04 /)
      kbo(:, 5,30,10) = (/ &
        & 0.10382e+04,0.78707e+03,0.59292e+03,0.87137e+03,0.11500e+04 /)
      kbo(:, 1,31,10) = (/ &
        & 0.10388e+04,0.78740e+03,0.59593e+03,0.87621e+03,0.11575e+04 /)
      kbo(:, 2,31,10) = (/ &
        & 0.10385e+04,0.78757e+03,0.59522e+03,0.87522e+03,0.11561e+04 /)
      kbo(:, 3,31,10) = (/ &
        & 0.10386e+04,0.78718e+03,0.59436e+03,0.87397e+03,0.11540e+04 /)
      kbo(:, 4,31,10) = (/ &
        & 0.10377e+04,0.78650e+03,0.59350e+03,0.87250e+03,0.11516e+04 /)
      kbo(:, 5,31,10) = (/ &
        & 0.10376e+04,0.78651e+03,0.59269e+03,0.87108e+03,0.11495e+04 /)
      kbo(:, 1,32,10) = (/ &
        & 0.10383e+04,0.78682e+03,0.59576e+03,0.87597e+03,0.11572e+04 /)
      kbo(:, 2,32,10) = (/ &
        & 0.10383e+04,0.78712e+03,0.59500e+03,0.87480e+03,0.11556e+04 /)
      kbo(:, 3,32,10) = (/ &
        & 0.10381e+04,0.78606e+03,0.59405e+03,0.87362e+03,0.11534e+04 /)
      kbo(:, 4,32,10) = (/ &
        & 0.10372e+04,0.78628e+03,0.59329e+03,0.87223e+03,0.11510e+04 /)
      kbo(:, 5,32,10) = (/ &
        & 0.10377e+04,0.78690e+03,0.59245e+03,0.87068e+03,0.11490e+04 /)
      kbo(:, 1,33,10) = (/ &
        & 0.10380e+04,0.78593e+03,0.59549e+03,0.87572e+03,0.11567e+04 /)
      kbo(:, 2,33,10) = (/ &
        & 0.10375e+04,0.78654e+03,0.59477e+03,0.87458e+03,0.11551e+04 /)
      kbo(:, 3,33,10) = (/ &
        & 0.10374e+04,0.78686e+03,0.59389e+03,0.87337e+03,0.11527e+04 /)
      kbo(:, 4,33,10) = (/ &
        & 0.10366e+04,0.78593e+03,0.59308e+03,0.87194e+03,0.11506e+04 /)
      kbo(:, 5,33,10) = (/ &
        & 0.10369e+04,0.78626e+03,0.59219e+03,0.87038e+03,0.11486e+04 /)
      kbo(:, 1,34,10) = (/ &
        & 0.10373e+04,0.78657e+03,0.59539e+03,0.87559e+03,0.11565e+04 /)
      kbo(:, 2,34,10) = (/ &
        & 0.10370e+04,0.78641e+03,0.59464e+03,0.87429e+03,0.11546e+04 /)
      kbo(:, 3,34,10) = (/ &
        & 0.10370e+04,0.78587e+03,0.59369e+03,0.87295e+03,0.11522e+04 /)
      kbo(:, 4,34,10) = (/ &
        & 0.10371e+04,0.78562e+03,0.59289e+03,0.87146e+03,0.11500e+04 /)
      kbo(:, 5,34,10) = (/ &
        & 0.10372e+04,0.78597e+03,0.59202e+03,0.86991e+03,0.11482e+04 /)
      kbo(:, 1,35,10) = (/ &
        & 0.10364e+04,0.78559e+03,0.59529e+03,0.87523e+03,0.11563e+04 /)
      kbo(:, 2,35,10) = (/ &
        & 0.10362e+04,0.78545e+03,0.59445e+03,0.87400e+03,0.11543e+04 /)
      kbo(:, 3,35,10) = (/ &
        & 0.10372e+04,0.78599e+03,0.59365e+03,0.87265e+03,0.11519e+04 /)
      kbo(:, 4,35,10) = (/ &
        & 0.10370e+04,0.78527e+03,0.59278e+03,0.87136e+03,0.11496e+04 /)
      kbo(:, 5,35,10) = (/ &
        & 0.10363e+04,0.78582e+03,0.59179e+03,0.86905e+03,0.11477e+04 /)
      kbo(:, 1,36,10) = (/ &
        & 0.10368e+04,0.78515e+03,0.59520e+03,0.87532e+03,0.11563e+04 /)
      kbo(:, 2,36,10) = (/ &
        & 0.10358e+04,0.78589e+03,0.59443e+03,0.87419e+03,0.11542e+04 /)
      kbo(:, 3,36,10) = (/ &
        & 0.10361e+04,0.78556e+03,0.59355e+03,0.87273e+03,0.11517e+04 /)
      kbo(:, 4,36,10) = (/ &
        & 0.10361e+04,0.78543e+03,0.59275e+03,0.87122e+03,0.11497e+04 /)
      kbo(:, 5,36,10) = (/ &
        & 0.10368e+04,0.78570e+03,0.59176e+03,0.86999e+03,0.11477e+04 /)
      kbo(:, 1,37,10) = (/ &
        & 0.10363e+04,0.78591e+03,0.59537e+03,0.87546e+03,0.11565e+04 /)
      kbo(:, 2,37,10) = (/ &
        & 0.10360e+04,0.78548e+03,0.59454e+03,0.87425e+03,0.11545e+04 /)
      kbo(:, 3,37,10) = (/ &
        & 0.10362e+04,0.78546e+03,0.59366e+03,0.87291e+03,0.11521e+04 /)
      kbo(:, 4,37,10) = (/ &
        & 0.10364e+04,0.78543e+03,0.59286e+03,0.87142e+03,0.11500e+04 /)
      kbo(:, 5,37,10) = (/ &
        & 0.10360e+04,0.78560e+03,0.59177e+03,0.86987e+03,0.11482e+04 /)
      kbo(:, 1,38,10) = (/ &
        & 0.10362e+04,0.78542e+03,0.59547e+03,0.87560e+03,0.11567e+04 /)
      kbo(:, 2,38,10) = (/ &
        & 0.10357e+04,0.78588e+03,0.59466e+03,0.87433e+03,0.11549e+04 /)
      kbo(:, 3,38,10) = (/ &
        & 0.10370e+04,0.78605e+03,0.59385e+03,0.87310e+03,0.11524e+04 /)
      kbo(:, 4,38,10) = (/ &
        & 0.10362e+04,0.78574e+03,0.59297e+03,0.87186e+03,0.11501e+04 /)
      kbo(:, 5,38,10) = (/ &
        & 0.10364e+04,0.78533e+03,0.59199e+03,0.87009e+03,0.11482e+04 /)
      kbo(:, 1,39,10) = (/ &
        & 0.10359e+04,0.78514e+03,0.59557e+03,0.87574e+03,0.11567e+04 /)
      kbo(:, 2,39,10) = (/ &
        & 0.10371e+04,0.78541e+03,0.59478e+03,0.87461e+03,0.11552e+04 /)
      kbo(:, 3,39,10) = (/ &
        & 0.10366e+04,0.78569e+03,0.59382e+03,0.87329e+03,0.11528e+04 /)
      kbo(:, 4,39,10) = (/ &
        & 0.10359e+04,0.78528e+03,0.59308e+03,0.87198e+03,0.11506e+04 /)
      kbo(:, 5,39,10) = (/ &
        & 0.10356e+04,0.78487e+03,0.59220e+03,0.87042e+03,0.11486e+04 /)
      kbo(:, 1,40,10) = (/ &
        & 0.10357e+04,0.78518e+03,0.59566e+03,0.87586e+03,0.11569e+04 /)
      kbo(:, 2,40,10) = (/ &
        & 0.10357e+04,0.78506e+03,0.59498e+03,0.87480e+03,0.11555e+04 /)
      kbo(:, 3,40,10) = (/ &
        & 0.10366e+04,0.78504e+03,0.59396e+03,0.87362e+03,0.11534e+04 /)
      kbo(:, 4,40,10) = (/ &
        & 0.10363e+04,0.78503e+03,0.59319e+03,0.87212e+03,0.11511e+04 /)
      kbo(:, 5,40,10) = (/ &
        & 0.10363e+04,0.78540e+03,0.59243e+03,0.87078e+03,0.11490e+04 /)
      kbo(:, 1,41,10) = (/ &
        & 0.10363e+04,0.78503e+03,0.59590e+03,0.87608e+03,0.11576e+04 /)
      kbo(:, 2,41,10) = (/ &
        & 0.10356e+04,0.78491e+03,0.59519e+03,0.87520e+03,0.11561e+04 /)
      kbo(:, 3,41,10) = (/ &
        & 0.10364e+04,0.78558e+03,0.59433e+03,0.87384e+03,0.11540e+04 /)
      kbo(:, 4,41,10) = (/ &
        & 0.10357e+04,0.78518e+03,0.59354e+03,0.87259e+03,0.11516e+04 /)
      kbo(:, 5,41,10) = (/ &
        & 0.10360e+04,0.78526e+03,0.59259e+03,0.87107e+03,0.11495e+04 /)
      kbo(:, 1,42,10) = (/ &
        & 0.10360e+04,0.78488e+03,0.59605e+03,0.87553e+03,0.11576e+04 /)
      kbo(:, 2,42,10) = (/ &
        & 0.10363e+04,0.78507e+03,0.59538e+03,0.87537e+03,0.11565e+04 /)
      kbo(:, 3,42,10) = (/ &
        & 0.10362e+04,0.78535e+03,0.59456e+03,0.87429e+03,0.11545e+04 /)
      kbo(:, 4,42,10) = (/ &
        & 0.10361e+04,0.78514e+03,0.59368e+03,0.87295e+03,0.11522e+04 /)
      kbo(:, 5,42,10) = (/ &
        & 0.10360e+04,0.78523e+03,0.59281e+03,0.87146e+03,0.11502e+04 /)
      kbo(:, 1,43,10) = (/ &
        & 0.10359e+04,0.78504e+03,0.59624e+03,0.87675e+03,0.11584e+04 /)
      kbo(:, 2,43,10) = (/ &
        & 0.10355e+04,0.78552e+03,0.59568e+03,0.87580e+03,0.11570e+04 /)
      kbo(:, 3,43,10) = (/ &
        & 0.10354e+04,0.78512e+03,0.59483e+03,0.87469e+03,0.11553e+04 /)
      kbo(:, 4,43,10) = (/ &
        & 0.10354e+04,0.78569e+03,0.59395e+03,0.87316e+03,0.11531e+04 /)
      kbo(:, 5,43,10) = (/ &
        & 0.10359e+04,0.78598e+03,0.59313e+03,0.87186e+03,0.11507e+04 /)
      kbo(:, 1,44,10) = (/ &
        & 0.10359e+04,0.78521e+03,0.59645e+03,0.87700e+03,0.11590e+04 /)
      kbo(:, 2,44,10) = (/ &
        & 0.10361e+04,0.78510e+03,0.59583e+03,0.87611e+03,0.11574e+04 /)
      kbo(:, 3,44,10) = (/ &
        & 0.10368e+04,0.78519e+03,0.59511e+03,0.87509e+03,0.11561e+04 /)
      kbo(:, 4,44,10) = (/ &
        & 0.10360e+04,0.78508e+03,0.59424e+03,0.87372e+03,0.11538e+04 /)
      kbo(:, 5,44,10) = (/ &
        & 0.10356e+04,0.78537e+03,0.59339e+03,0.87213e+03,0.11514e+04 /)
      kbo(:, 1,45,10) = (/ &
        & 0.10357e+04,0.78557e+03,0.59666e+03,0.87715e+03,0.11597e+04 /)
      kbo(:, 2,45,10) = (/ &
        & 0.10356e+04,0.78527e+03,0.59604e+03,0.87639e+03,0.11579e+04 /)
      kbo(:, 3,45,10) = (/ &
        & 0.10360e+04,0.78546e+03,0.59537e+03,0.87547e+03,0.11565e+04 /)
      kbo(:, 4,45,10) = (/ &
        & 0.10361e+04,0.78506e+03,0.59454e+03,0.87427e+03,0.11544e+04 /)
      kbo(:, 5,45,10) = (/ &
        & 0.10353e+04,0.78535e+03,0.59366e+03,0.87293e+03,0.11520e+04 /)
      kbo(:, 1,46,10) = (/ &
        & 0.10358e+04,0.78506e+03,0.59691e+03,0.87749e+03,0.11602e+04 /)
      kbo(:, 2,46,10) = (/ &
        & 0.10353e+04,0.78486e+03,0.59626e+03,0.87678e+03,0.11584e+04 /)
      kbo(:, 3,46,10) = (/ &
        & 0.10353e+04,0.78495e+03,0.59563e+03,0.87572e+03,0.11570e+04 /)
      kbo(:, 4,46,10) = (/ &
        & 0.10363e+04,0.78534e+03,0.59478e+03,0.87473e+03,0.11554e+04 /)
      kbo(:, 5,46,10) = (/ &
        & 0.10355e+04,0.78455e+03,0.59398e+03,0.87342e+03,0.11530e+04 /)
      kbo(:, 1,47,10) = (/ &
        & 0.10357e+04,0.78544e+03,0.59719e+03,0.87795e+03,0.11609e+04 /)
      kbo(:, 2,47,10) = (/ &
        & 0.10355e+04,0.78533e+03,0.59651e+03,0.87696e+03,0.11589e+04 /)
      kbo(:, 3,47,10) = (/ &
        & 0.10358e+04,0.78543e+03,0.59590e+03,0.87576e+03,0.11576e+04 /)
      kbo(:, 4,47,10) = (/ &
        & 0.10351e+04,0.78562e+03,0.59519e+03,0.87521e+03,0.11561e+04 /)
      kbo(:, 5,47,10) = (/ &
        & 0.10359e+04,0.78571e+03,0.59433e+03,0.87385e+03,0.11540e+04 /)
      kbo(:, 1,48,10) = (/ &
        & 0.10363e+04,0.78513e+03,0.59744e+03,0.87846e+03,0.11618e+04 /)
      kbo(:, 2,48,10) = (/ &
        & 0.10360e+04,0.78532e+03,0.59677e+03,0.87730e+03,0.11598e+04 /)
      kbo(:, 3,48,10) = (/ &
        & 0.10365e+04,0.78483e+03,0.59614e+03,0.87707e+03,0.11581e+04 /)
      kbo(:, 4,48,10) = (/ &
        & 0.10355e+04,0.78521e+03,0.59549e+03,0.87564e+03,0.11567e+04 /)
      kbo(:, 5,48,10) = (/ &
        & 0.10355e+04,0.78531e+03,0.59469e+03,0.87448e+03,0.11550e+04 /)
      kbo(:, 1,49,10) = (/ &
        & 0.10351e+04,0.78492e+03,0.59768e+03,0.87902e+03,0.11625e+04 /)
      kbo(:, 2,49,10) = (/ &
        & 0.10355e+04,0.78541e+03,0.59705e+03,0.87772e+03,0.11606e+04 /)
      kbo(:, 3,49,10) = (/ &
        & 0.10352e+04,0.78472e+03,0.59639e+03,0.87682e+03,0.11587e+04 /)
      kbo(:, 4,49,10) = (/ &
        & 0.10356e+04,0.78511e+03,0.59577e+03,0.87591e+03,0.11574e+04 /)
      kbo(:, 5,49,10) = (/ &
        & 0.10352e+04,0.78501e+03,0.59510e+03,0.87498e+03,0.11558e+04 /)
      kbo(:, 1,50,10) = (/ &
        & 0.10361e+04,0.78540e+03,0.59770e+03,0.87956e+03,0.11633e+04 /)
      kbo(:, 2,50,10) = (/ &
        & 0.10357e+04,0.78530e+03,0.59731e+03,0.87817e+03,0.11612e+04 /)
      kbo(:, 3,50,10) = (/ &
        & 0.10365e+04,0.78510e+03,0.59662e+03,0.87710e+03,0.11596e+04 /)
      kbo(:, 4,50,10) = (/ &
        & 0.10365e+04,0.78510e+03,0.59601e+03,0.87645e+03,0.11578e+04 /)
      kbo(:, 5,50,10) = (/ &
        & 0.10352e+04,0.78588e+03,0.59525e+03,0.87541e+03,0.11564e+04 /)
      kbo(:, 1,51,10) = (/ &
        & 0.10356e+04,0.78490e+03,0.59781e+03,0.88010e+03,0.11639e+04 /)
      kbo(:, 2,51,10) = (/ &
        & 0.10356e+04,0.78539e+03,0.59751e+03,0.87866e+03,0.11620e+04 /)
      kbo(:, 3,51,10) = (/ &
        & 0.10359e+04,0.78461e+03,0.59687e+03,0.87744e+03,0.11601e+04 /)
      kbo(:, 4,51,10) = (/ &
        & 0.10352e+04,0.78519e+03,0.59623e+03,0.87674e+03,0.11583e+04 /)
      kbo(:, 5,51,10) = (/ &
        & 0.10356e+04,0.78470e+03,0.59552e+03,0.87578e+03,0.11569e+04 /)
      kbo(:, 1,52,10) = (/ &
        & 0.10352e+04,0.78509e+03,0.59800e+03,0.88094e+03,0.11643e+04 /)
      kbo(:, 2,52,10) = (/ &
        & 0.10355e+04,0.78528e+03,0.59763e+03,0.87918e+03,0.11627e+04 /)
      kbo(:, 3,52,10) = (/ &
        & 0.10361e+04,0.78479e+03,0.59712e+03,0.87762e+03,0.11608e+04 /)
      kbo(:, 4,52,10) = (/ &
        & 0.10358e+04,0.78528e+03,0.59645e+03,0.87678e+03,0.11589e+04 /)
      kbo(:, 5,52,10) = (/ &
        & 0.10355e+04,0.78528e+03,0.59584e+03,0.87612e+03,0.11573e+04 /)
      kbo(:, 1,53,10) = (/ &
        & 0.10357e+04,0.78528e+03,0.59832e+03,0.88148e+03,0.11650e+04 /)
      kbo(:, 2,53,10) = (/ &
        & 0.10357e+04,0.78596e+03,0.59772e+03,0.87969e+03,0.11634e+04 /)
      kbo(:, 3,53,10) = (/ &
        & 0.10361e+04,0.78547e+03,0.59737e+03,0.87830e+03,0.11614e+04 /)
      kbo(:, 4,53,10) = (/ &
        & 0.10362e+04,0.78537e+03,0.59668e+03,0.87707e+03,0.11596e+04 /)
      kbo(:, 5,53,10) = (/ &
        & 0.10356e+04,0.78498e+03,0.59606e+03,0.87642e+03,0.11578e+04 /)
      kbo(:, 1,54,10) = (/ &
        & 0.10351e+04,0.78567e+03,0.59851e+03,0.88199e+03,0.11656e+04 /)
      kbo(:, 2,54,10) = (/ &
        & 0.10366e+04,0.78518e+03,0.59776e+03,0.88021e+03,0.11638e+04 /)
      kbo(:, 3,54,10) = (/ &
        & 0.10364e+04,0.78478e+03,0.59753e+03,0.87875e+03,0.11621e+04 /)
      kbo(:, 4,54,10) = (/ &
        & 0.10356e+04,0.78498e+03,0.59692e+03,0.87751e+03,0.11602e+04 /)
      kbo(:, 5,54,10) = (/ &
        & 0.10362e+04,0.78527e+03,0.59627e+03,0.87657e+03,0.11584e+04 /)
      kbo(:, 1,55,10) = (/ &
        & 0.10355e+04,0.78488e+03,0.59876e+03,0.88250e+03,0.11663e+04 /)
      kbo(:, 2,55,10) = (/ &
        & 0.10362e+04,0.78527e+03,0.59801e+03,0.88087e+03,0.11643e+04 /)
      kbo(:, 3,55,10) = (/ &
        & 0.10356e+04,0.78507e+03,0.59764e+03,0.87920e+03,0.11628e+04 /)
      kbo(:, 4,55,10) = (/ &
        & 0.10353e+04,0.78488e+03,0.59714e+03,0.87787e+03,0.11606e+04 /)
      kbo(:, 5,55,10) = (/ &
        & 0.10356e+04,0.78488e+03,0.59639e+03,0.87691e+03,0.11585e+04 /)
      kbo(:, 1,56,10) = (/ &
        & 0.10353e+04,0.78537e+03,0.59904e+03,0.88318e+03,0.11672e+04 /)
      kbo(:, 2,56,10) = (/ &
        & 0.10354e+04,0.78497e+03,0.59830e+03,0.88144e+03,0.11649e+04 /)
      kbo(:, 3,56,10) = (/ &
        & 0.10361e+04,0.78536e+03,0.59771e+03,0.87966e+03,0.11634e+04 /)
      kbo(:, 4,56,10) = (/ &
        & 0.10357e+04,0.78497e+03,0.59736e+03,0.87826e+03,0.11615e+04 /)
      kbo(:, 5,56,10) = (/ &
        & 0.10353e+04,0.78478e+03,0.59667e+03,0.87705e+03,0.11595e+04 /)
      kbo(:, 1,57,10) = (/ &
        & 0.10358e+04,0.78458e+03,0.59927e+03,0.88350e+03,0.11679e+04 /)
      kbo(:, 2,57,10) = (/ &
        & 0.10352e+04,0.78536e+03,0.59840e+03,0.88193e+03,0.11656e+04 /)
      kbo(:, 3,57,10) = (/ &
        & 0.10352e+04,0.78526e+03,0.59782e+03,0.88003e+03,0.11638e+04 /)
      kbo(:, 4,57,10) = (/ &
        & 0.10358e+04,0.78497e+03,0.59751e+03,0.87869e+03,0.11622e+04 /)
      kbo(:, 5,57,10) = (/ &
        & 0.10360e+04,0.78497e+03,0.59689e+03,0.87746e+03,0.11601e+04 /)
      kbo(:, 1,58,10) = (/ &
        & 0.10358e+04,0.78468e+03,0.59969e+03,0.88402e+03,0.11685e+04 /)
      kbo(:, 2,58,10) = (/ &
        & 0.10357e+04,0.78458e+03,0.59873e+03,0.88241e+03,0.11662e+04 /)
      kbo(:, 3,58,10) = (/ &
        & 0.10358e+04,0.78526e+03,0.59797e+03,0.88085e+03,0.11642e+04 /)
      kbo(:, 4,58,10) = (/ &
        & 0.10356e+04,0.78487e+03,0.59762e+03,0.87912e+03,0.11626e+04 /)
      kbo(:, 5,58,10) = (/ &
        & 0.10357e+04,0.78565e+03,0.59710e+03,0.87769e+03,0.11608e+04 /)
      kbo(:, 1,59,10) = (/ &
        & 0.10360e+04,0.78507e+03,0.59979e+03,0.88416e+03,0.11687e+04 /)
      kbo(:, 2,59,10) = (/ &
        & 0.10357e+04,0.78477e+03,0.59879e+03,0.88260e+03,0.11665e+04 /)
      kbo(:, 3,59,10) = (/ &
        & 0.10350e+04,0.78526e+03,0.59804e+03,0.88100e+03,0.11644e+04 /)
      kbo(:, 4,59,10) = (/ &
        & 0.10357e+04,0.78467e+03,0.59773e+03,0.87930e+03,0.11629e+04 /)
      kbo(:, 5,59,10) = (/ &
        & 0.10358e+04,0.78457e+03,0.59718e+03,0.87783e+03,0.11609e+04 /)
      kbo(:, 1,13,11) = (/ &
        & 0.11563e+04,0.87491e+03,0.60253e+03,0.88362e+03,0.11664e+04 /)
      kbo(:, 2,13,11) = (/ &
        & 0.11454e+04,0.86861e+03,0.60211e+03,0.88300e+03,0.11639e+04 /)
      kbo(:, 3,13,11) = (/ &
        & 0.11392e+04,0.86181e+03,0.60140e+03,0.88181e+03,0.11620e+04 /)
      kbo(:, 4,13,11) = (/ &
        & 0.11315e+04,0.85680e+03,0.60042e+03,0.88057e+03,0.11602e+04 /)
      kbo(:, 5,13,11) = (/ &
        & 0.11273e+04,0.85330e+03,0.59929e+03,0.87908e+03,0.11581e+04 /)
      kbo(:, 1,14,11) = (/ &
        & 0.11333e+04,0.85776e+03,0.60215e+03,0.88338e+03,0.11660e+04 /)
      kbo(:, 2,14,11) = (/ &
        & 0.11256e+04,0.85211e+03,0.60176e+03,0.88258e+03,0.11637e+04 /)
      kbo(:, 3,14,11) = (/ &
        & 0.11185e+04,0.84809e+03,0.60101e+03,0.88154e+03,0.11618e+04 /)
      kbo(:, 4,14,11) = (/ &
        & 0.11137e+04,0.84328e+03,0.59992e+03,0.87989e+03,0.11599e+04 /)
      kbo(:, 5,14,11) = (/ &
        & 0.11092e+04,0.83997e+03,0.59898e+03,0.87879e+03,0.11581e+04 /)
      kbo(:, 1,15,11) = (/ &
        & 0.11149e+04,0.84435e+03,0.60192e+03,0.88317e+03,0.11660e+04 /)
      kbo(:, 2,15,11) = (/ &
        & 0.11071e+04,0.83899e+03,0.60145e+03,0.88233e+03,0.11635e+04 /)
      kbo(:, 3,15,11) = (/ &
        & 0.11058e+04,0.83612e+03,0.60066e+03,0.88128e+03,0.11617e+04 /)
      kbo(:, 4,15,11) = (/ &
        & 0.10996e+04,0.83410e+03,0.59965e+03,0.88002e+03,0.11599e+04 /)
      kbo(:, 5,15,11) = (/ &
        & 0.10957e+04,0.83022e+03,0.59863e+03,0.87850e+03,0.11578e+04 /)
      kbo(:, 1,16,11) = (/ &
        & 0.10993e+04,0.83361e+03,0.60157e+03,0.88298e+03,0.11657e+04 /)
      kbo(:, 2,16,11) = (/ &
        & 0.10933e+04,0.82961e+03,0.60127e+03,0.88210e+03,0.11633e+04 /)
      kbo(:, 3,16,11) = (/ &
        & 0.10924e+04,0.82745e+03,0.60035e+03,0.88104e+03,0.11615e+04 /)
      kbo(:, 4,16,11) = (/ &
        & 0.10885e+04,0.82319e+03,0.59934e+03,0.87977e+03,0.11597e+04 /)
      kbo(:, 5,16,11) = (/ &
        & 0.10838e+04,0.82062e+03,0.59823e+03,0.87823e+03,0.11577e+04 /)
      kbo(:, 1,17,11) = (/ &
        & 0.10881e+04,0.82385e+03,0.60135e+03,0.88282e+03,0.11656e+04 /)
      kbo(:, 2,17,11) = (/ &
        & 0.10840e+04,0.82201e+03,0.60094e+03,0.88190e+03,0.11631e+04 /)
      kbo(:, 3,17,11) = (/ &
        & 0.10809e+04,0.81908e+03,0.60007e+03,0.88083e+03,0.11613e+04 /)
      kbo(:, 4,17,11) = (/ &
        & 0.10772e+04,0.81792e+03,0.59907e+03,0.87953e+03,0.11595e+04 /)
      kbo(:, 5,17,11) = (/ &
        & 0.10760e+04,0.81580e+03,0.59806e+03,0.87798e+03,0.11575e+04 /)
      kbo(:, 1,18,11) = (/ &
        & 0.10780e+04,0.81679e+03,0.60116e+03,0.88267e+03,0.11653e+04 /)
      kbo(:, 2,18,11) = (/ &
        & 0.10749e+04,0.81512e+03,0.60072e+03,0.88171e+03,0.11629e+04 /)
      kbo(:, 3,18,11) = (/ &
        & 0.10728e+04,0.81180e+03,0.59983e+03,0.88050e+03,0.11611e+04 /)
      kbo(:, 4,18,11) = (/ &
        & 0.10707e+04,0.81081e+03,0.59883e+03,0.87944e+03,0.11593e+04 /)
      kbo(:, 5,18,11) = (/ &
        & 0.10678e+04,0.80905e+03,0.59782e+03,0.87775e+03,0.11574e+04 /)
      kbo(:, 1,19,11) = (/ &
        & 0.10696e+04,0.81122e+03,0.60101e+03,0.88252e+03,0.11649e+04 /)
      kbo(:, 2,19,11) = (/ &
        & 0.10692e+04,0.80792e+03,0.60053e+03,0.88155e+03,0.11625e+04 /)
      kbo(:, 3,19,11) = (/ &
        & 0.10653e+04,0.80791e+03,0.59962e+03,0.88058e+03,0.11609e+04 /)
      kbo(:, 4,19,11) = (/ &
        & 0.10635e+04,0.80651e+03,0.59853e+03,0.87910e+03,0.11591e+04 /)
      kbo(:, 5,19,11) = (/ &
        & 0.10626e+04,0.80552e+03,0.59761e+03,0.87753e+03,0.11572e+04 /)
      kbo(:, 1,20,11) = (/ &
        & 0.10638e+04,0.80613e+03,0.60096e+03,0.88236e+03,0.11646e+04 /)
      kbo(:, 2,20,11) = (/ &
        & 0.10623e+04,0.80416e+03,0.60035e+03,0.88137e+03,0.11625e+04 /)
      kbo(:, 3,20,11) = (/ &
        & 0.10590e+04,0.80264e+03,0.59950e+03,0.88013e+03,0.11607e+04 /)
      kbo(:, 4,20,11) = (/ &
        & 0.10603e+04,0.80308e+03,0.59841e+03,0.87915e+03,0.11587e+04 /)
      kbo(:, 5,20,11) = (/ &
        & 0.10573e+04,0.80101e+03,0.59740e+03,0.87729e+03,0.11568e+04 /)
      kbo(:, 1,21,11) = (/ &
        & 0.10580e+04,0.80255e+03,0.60075e+03,0.88233e+03,0.11643e+04 /)
      kbo(:, 2,21,11) = (/ &
        & 0.10580e+04,0.80172e+03,0.60017e+03,0.88121e+03,0.11623e+04 /)
      kbo(:, 3,21,11) = (/ &
        & 0.10551e+04,0.80129e+03,0.59922e+03,0.87954e+03,0.11605e+04 /)
      kbo(:, 4,21,11) = (/ &
        & 0.10544e+04,0.79894e+03,0.59822e+03,0.87866e+03,0.11586e+04 /)
      kbo(:, 5,21,11) = (/ &
        & 0.10531e+04,0.79850e+03,0.59721e+03,0.87693e+03,0.11568e+04 /)
      kbo(:, 1,22,11) = (/ &
        & 0.10535e+04,0.79809e+03,0.60064e+03,0.88198e+03,0.11639e+04 /)
      kbo(:, 2,22,11) = (/ &
        & 0.10534e+04,0.79679e+03,0.59986e+03,0.88098e+03,0.11619e+04 /)
      kbo(:, 3,22,11) = (/ &
        & 0.10517e+04,0.79764e+03,0.59897e+03,0.87993e+03,0.11602e+04 /)
      kbo(:, 4,22,11) = (/ &
        & 0.10510e+04,0.79739e+03,0.59797e+03,0.87835e+03,0.11582e+04 /)
      kbo(:, 5,22,11) = (/ &
        & 0.10492e+04,0.79579e+03,0.59697e+03,0.87672e+03,0.11565e+04 /)
      kbo(:, 1,23,11) = (/ &
        & 0.10516e+04,0.79606e+03,0.60095e+03,0.88176e+03,0.11633e+04 /)
      kbo(:, 2,23,11) = (/ &
        & 0.10497e+04,0.79542e+03,0.59972e+03,0.88074e+03,0.11616e+04 /)
      kbo(:, 3,23,11) = (/ &
        & 0.10482e+04,0.79453e+03,0.59873e+03,0.87952e+03,0.11598e+04 /)
      kbo(:, 4,23,11) = (/ &
        & 0.10486e+04,0.79431e+03,0.59782e+03,0.87802e+03,0.11579e+04 /)
      kbo(:, 5,23,11) = (/ &
        & 0.10473e+04,0.79522e+03,0.59672e+03,0.87637e+03,0.11562e+04 /)
      kbo(:, 1,24,11) = (/ &
        & 0.10467e+04,0.79476e+03,0.60034e+03,0.88154e+03,0.11630e+04 /)
      kbo(:, 2,24,11) = (/ &
        & 0.10461e+04,0.79357e+03,0.59948e+03,0.88049e+03,0.11613e+04 /)
      kbo(:, 3,24,11) = (/ &
        & 0.10460e+04,0.79280e+03,0.59849e+03,0.87921e+03,0.11596e+04 /)
      kbo(:, 4,24,11) = (/ &
        & 0.10457e+04,0.79222e+03,0.59749e+03,0.87768e+03,0.11575e+04 /)
      kbo(:, 5,24,11) = (/ &
        & 0.10450e+04,0.79193e+03,0.59639e+03,0.87600e+03,0.11558e+04 /)
      kbo(:, 1,25,11) = (/ &
        & 0.10463e+04,0.79209e+03,0.60015e+03,0.88131e+03,0.11626e+04 /)
      kbo(:, 2,25,11) = (/ &
        & 0.10455e+04,0.79185e+03,0.59924e+03,0.87983e+03,0.11609e+04 /)
      kbo(:, 3,25,11) = (/ &
        & 0.10450e+04,0.79214e+03,0.59824e+03,0.87889e+03,0.11590e+04 /)
      kbo(:, 4,25,11) = (/ &
        & 0.10445e+04,0.79118e+03,0.59725e+03,0.87732e+03,0.11571e+04 /)
      kbo(:, 5,25,11) = (/ &
        & 0.10428e+04,0.79168e+03,0.59624e+03,0.87561e+03,0.11555e+04 /)
      kbo(:, 1,26,11) = (/ &
        & 0.10437e+04,0.79093e+03,0.59993e+03,0.88106e+03,0.11624e+04 /)
      kbo(:, 2,26,11) = (/ &
        & 0.10430e+04,0.79091e+03,0.59898e+03,0.87993e+03,0.11605e+04 /)
      kbo(:, 3,26,11) = (/ &
        & 0.10430e+04,0.79069e+03,0.59808e+03,0.87852e+03,0.11586e+04 /)
      kbo(:, 4,26,11) = (/ &
        & 0.10425e+04,0.79087e+03,0.59699e+03,0.87692e+03,0.11569e+04 /)
      kbo(:, 5,26,11) = (/ &
        & 0.10414e+04,0.78954e+03,0.59598e+03,0.87517e+03,0.11547e+04 /)
      kbo(:, 1,27,11) = (/ &
        & 0.10423e+04,0.79028e+03,0.59970e+03,0.88080e+03,0.11616e+04 /)
      kbo(:, 2,27,11) = (/ &
        & 0.10415e+04,0.78939e+03,0.59872e+03,0.87961e+03,0.11600e+04 /)
      kbo(:, 3,27,11) = (/ &
        & 0.10419e+04,0.78972e+03,0.59773e+03,0.87814e+03,0.11581e+04 /)
      kbo(:, 4,27,11) = (/ &
        & 0.10405e+04,0.78901e+03,0.59673e+03,0.87651e+03,0.11564e+04 /)
      kbo(:, 5,27,11) = (/ &
        & 0.10410e+04,0.78880e+03,0.59572e+03,0.87471e+03,0.11546e+04 /)
      kbo(:, 1,28,11) = (/ &
        & 0.10411e+04,0.78831e+03,0.59945e+03,0.88052e+03,0.11614e+04 /)
      kbo(:, 2,28,11) = (/ &
        & 0.10402e+04,0.78866e+03,0.59846e+03,0.87954e+03,0.11596e+04 /)
      kbo(:, 3,28,11) = (/ &
        & 0.10401e+04,0.78798e+03,0.59747e+03,0.87776e+03,0.11577e+04 /)
      kbo(:, 4,28,11) = (/ &
        & 0.10407e+04,0.78779e+03,0.59647e+03,0.87596e+03,0.11560e+04 /)
      kbo(:, 5,28,11) = (/ &
        & 0.10407e+04,0.78751e+03,0.59548e+03,0.87425e+03,0.11542e+04 /)
      kbo(:, 1,29,11) = (/ &
        & 0.10408e+04,0.78876e+03,0.59920e+03,0.87983e+03,0.11608e+04 /)
      kbo(:, 2,29,11) = (/ &
        & 0.10408e+04,0.78834e+03,0.59820e+03,0.87891e+03,0.11591e+04 /)
      kbo(:, 3,29,11) = (/ &
        & 0.10387e+04,0.78864e+03,0.59721e+03,0.87735e+03,0.11572e+04 /)
      kbo(:, 4,29,11) = (/ &
        & 0.10384e+04,0.78778e+03,0.59621e+03,0.87578e+03,0.11555e+04 /)
      kbo(:, 5,29,11) = (/ &
        & 0.10412e+04,0.78824e+03,0.59524e+03,0.87368e+03,0.11538e+04 /)
      kbo(:, 1,30,11) = (/ &
        & 0.10383e+04,0.78758e+03,0.59894e+03,0.87992e+03,0.11605e+04 /)
      kbo(:, 2,30,11) = (/ &
        & 0.10390e+04,0.78755e+03,0.59785e+03,0.87840e+03,0.11584e+04 /)
      kbo(:, 3,30,11) = (/ &
        & 0.10391e+04,0.78813e+03,0.59695e+03,0.87693e+03,0.11568e+04 /)
      kbo(:, 4,30,11) = (/ &
        & 0.10384e+04,0.78683e+03,0.59594e+03,0.87519e+03,0.11551e+04 /)
      kbo(:, 5,30,11) = (/ &
        & 0.10388e+04,0.78660e+03,0.59501e+03,0.87341e+03,0.11534e+04 /)
      kbo(:, 1,31,11) = (/ &
        & 0.10376e+04,0.78640e+03,0.59867e+03,0.87959e+03,0.11601e+04 /)
      kbo(:, 2,31,11) = (/ &
        & 0.10381e+04,0.78687e+03,0.59768e+03,0.87813e+03,0.11581e+04 /)
      kbo(:, 3,31,11) = (/ &
        & 0.10369e+04,0.78736e+03,0.59668e+03,0.87650e+03,0.11564e+04 /)
      kbo(:, 4,31,11) = (/ &
        & 0.10380e+04,0.78738e+03,0.59577e+03,0.87483e+03,0.11546e+04 /)
      kbo(:, 5,31,11) = (/ &
        & 0.10391e+04,0.78671e+03,0.59479e+03,0.87299e+03,0.11532e+04 /)
      kbo(:, 1,32,11) = (/ &
        & 0.10371e+04,0.78531e+03,0.59840e+03,0.87936e+03,0.11596e+04 /)
      kbo(:, 2,32,11) = (/ &
        & 0.10383e+04,0.78734e+03,0.59742e+03,0.87771e+03,0.11576e+04 /)
      kbo(:, 3,32,11) = (/ &
        & 0.10363e+04,0.78691e+03,0.59641e+03,0.87605e+03,0.11559e+04 /)
      kbo(:, 4,32,11) = (/ &
        & 0.10373e+04,0.78648e+03,0.59543e+03,0.87420e+03,0.11542e+04 /)
      kbo(:, 5,32,11) = (/ &
        & 0.10376e+04,0.78617e+03,0.59455e+03,0.87256e+03,0.11529e+04 /)
      kbo(:, 1,33,11) = (/ &
        & 0.10366e+04,0.78725e+03,0.59814e+03,0.87885e+03,0.11591e+04 /)
      kbo(:, 2,33,11) = (/ &
        & 0.10366e+04,0.78694e+03,0.59715e+03,0.87729e+03,0.11572e+04 /)
      kbo(:, 3,33,11) = (/ &
        & 0.10365e+04,0.78534e+03,0.59614e+03,0.87545e+03,0.11555e+04 /)
      kbo(:, 4,33,11) = (/ &
        & 0.10377e+04,0.78705e+03,0.59518e+03,0.87362e+03,0.11536e+04 /)
      kbo(:, 5,33,11) = (/ &
        & 0.10381e+04,0.78546e+03,0.59428e+03,0.87201e+03,0.11526e+04 /)
      kbo(:, 1,34,11) = (/ &
        & 0.10370e+04,0.78547e+03,0.59791e+03,0.87837e+03,0.11586e+04 /)
      kbo(:, 2,34,11) = (/ &
        & 0.10369e+04,0.78635e+03,0.59683e+03,0.87691e+03,0.11568e+04 /)
      kbo(:, 3,34,11) = (/ &
        & 0.10373e+04,0.78607e+03,0.59591e+03,0.87516e+03,0.11551e+04 /)
      kbo(:, 4,34,11) = (/ &
        & 0.10371e+04,0.78696e+03,0.59498e+03,0.87338e+03,0.11534e+04 /)
      kbo(:, 5,34,11) = (/ &
        & 0.10366e+04,0.78538e+03,0.59374e+03,0.87179e+03,0.11524e+04 /)
      kbo(:, 1,35,11) = (/ &
        & 0.10371e+04,0.78681e+03,0.59778e+03,0.87830e+03,0.11583e+04 /)
      kbo(:, 2,35,11) = (/ &
        & 0.10367e+04,0.78665e+03,0.59678e+03,0.87669e+03,0.11566e+04 /)
      kbo(:, 3,35,11) = (/ &
        & 0.10363e+04,0.78613e+03,0.59569e+03,0.87491e+03,0.11549e+04 /)
      kbo(:, 4,35,11) = (/ &
        & 0.10364e+04,0.78668e+03,0.59487e+03,0.87304e+03,0.11533e+04 /)
      kbo(:, 5,35,11) = (/ &
        & 0.10370e+04,0.78641e+03,0.59363e+03,0.87159e+03,0.11523e+04 /)
      kbo(:, 1,36,11) = (/ &
        & 0.10366e+04,0.78595e+03,0.59775e+03,0.87827e+03,0.11583e+04 /)
      kbo(:, 2,36,11) = (/ &
        & 0.10367e+04,0.78568e+03,0.59676e+03,0.87652e+03,0.11565e+04 /)
      kbo(:, 3,36,11) = (/ &
        & 0.10363e+04,0.78600e+03,0.59575e+03,0.87487e+03,0.11548e+04 /)
      kbo(:, 4,36,11) = (/ &
        & 0.10370e+04,0.78596e+03,0.59503e+03,0.87314e+03,0.11533e+04 /)
      kbo(:, 5,36,11) = (/ &
        & 0.10356e+04,0.78546e+03,0.59359e+03,0.87116e+03,0.11523e+04 /)
      kbo(:, 1,37,11) = (/ &
        & 0.10367e+04,0.78524e+03,0.59788e+03,0.87847e+03,0.11586e+04 /)
      kbo(:, 2,37,11) = (/ &
        & 0.10373e+04,0.78580e+03,0.59689e+03,0.87687e+03,0.11567e+04 /)
      kbo(:, 3,37,11) = (/ &
        & 0.10369e+04,0.78554e+03,0.59588e+03,0.87512e+03,0.11550e+04 /)
      kbo(:, 4,37,11) = (/ &
        & 0.10372e+04,0.78551e+03,0.59495e+03,0.87335e+03,0.11534e+04 /)
      kbo(:, 5,37,11) = (/ &
        & 0.10364e+04,0.78631e+03,0.59378e+03,0.87175e+03,0.11524e+04 /)
      kbo(:, 1,38,11) = (/ &
        & 0.10372e+04,0.78574e+03,0.59801e+03,0.87867e+03,0.11588e+04 /)
      kbo(:, 2,38,11) = (/ &
        & 0.10364e+04,0.78476e+03,0.59702e+03,0.87710e+03,0.11570e+04 /)
      kbo(:, 3,38,11) = (/ &
        & 0.10351e+04,0.78521e+03,0.59593e+03,0.87537e+03,0.11553e+04 /)
      kbo(:, 4,38,11) = (/ &
        & 0.10362e+04,0.78507e+03,0.59507e+03,0.87344e+03,0.11536e+04 /)
      kbo(:, 5,38,11) = (/ &
        & 0.10371e+04,0.78635e+03,0.59400e+03,0.87197e+03,0.11525e+04 /)
      kbo(:, 1,39,11) = (/ &
        & 0.10359e+04,0.78601e+03,0.59815e+03,0.87888e+03,0.11591e+04 /)
      kbo(:, 2,39,11) = (/ &
        & 0.10375e+04,0.78669e+03,0.59716e+03,0.87732e+03,0.11572e+04 /)
      kbo(:, 3,39,11) = (/ &
        & 0.10350e+04,0.78597e+03,0.59615e+03,0.87562e+03,0.11555e+04 /)
      kbo(:, 4,39,11) = (/ &
        & 0.10366e+04,0.78524e+03,0.59519e+03,0.87365e+03,0.11538e+04 /)
      kbo(:, 5,39,11) = (/ &
        & 0.10373e+04,0.78605e+03,0.59422e+03,0.87205e+03,0.11526e+04 /)
      kbo(:, 1,40,11) = (/ &
        & 0.10361e+04,0.78559e+03,0.59838e+03,0.87949e+03,0.11596e+04 /)
      kbo(:, 2,40,11) = (/ &
        & 0.10364e+04,0.78533e+03,0.59740e+03,0.87771e+03,0.11576e+04 /)
      kbo(:, 3,40,11) = (/ &
        & 0.10357e+04,0.78567e+03,0.59640e+03,0.87605e+03,0.11559e+04 /)
      kbo(:, 4,40,11) = (/ &
        & 0.10354e+04,0.78518e+03,0.59541e+03,0.87434e+03,0.11542e+04 /)
      kbo(:, 5,40,11) = (/ &
        & 0.10361e+04,0.78553e+03,0.59453e+03,0.87244e+03,0.11529e+04 /)
      kbo(:, 1,41,11) = (/ &
        & 0.10352e+04,0.78554e+03,0.59863e+03,0.87958e+03,0.11601e+04 /)
      kbo(:, 2,41,11) = (/ &
        & 0.10361e+04,0.78611e+03,0.59765e+03,0.87811e+03,0.11581e+04 /)
      kbo(:, 3,41,11) = (/ &
        & 0.10357e+04,0.78586e+03,0.59665e+03,0.87648e+03,0.11564e+04 /)
      kbo(:, 4,41,11) = (/ &
        & 0.10369e+04,0.78632e+03,0.59556e+03,0.87469e+03,0.11547e+04 /)
      kbo(:, 5,41,11) = (/ &
        & 0.10372e+04,0.78631e+03,0.59476e+03,0.87298e+03,0.11532e+04 /)
      kbo(:, 1,42,11) = (/ &
        & 0.10352e+04,0.78620e+03,0.59889e+03,0.87990e+03,0.11605e+04 /)
      kbo(:, 2,42,11) = (/ &
        & 0.10362e+04,0.78666e+03,0.59790e+03,0.87851e+03,0.11586e+04 /)
      kbo(:, 3,42,11) = (/ &
        & 0.10358e+04,0.78476e+03,0.59691e+03,0.87691e+03,0.11568e+04 /)
      kbo(:, 4,42,11) = (/ &
        & 0.10367e+04,0.78534e+03,0.59590e+03,0.87517e+03,0.11551e+04 /)
      kbo(:, 5,42,11) = (/ &
        & 0.10374e+04,0.78497e+03,0.59497e+03,0.87339e+03,0.11533e+04 /)
      kbo(:, 1,43,11) = (/ &
        & 0.10357e+04,0.78569e+03,0.59919e+03,0.88014e+03,0.11611e+04 /)
      kbo(:, 2,43,11) = (/ &
        & 0.10384e+04,0.78603e+03,0.59811e+03,0.87910e+03,0.11592e+04 /)
      kbo(:, 3,43,11) = (/ &
        & 0.10376e+04,0.78685e+03,0.59731e+03,0.87742e+03,0.11573e+04 /)
      kbo(:, 4,43,11) = (/ &
        & 0.10368e+04,0.78484e+03,0.59612e+03,0.87573e+03,0.11555e+04 /)
      kbo(:, 5,43,11) = (/ &
        & 0.10371e+04,0.78612e+03,0.59525e+03,0.87389e+03,0.11539e+04 /)
      kbo(:, 1,44,11) = (/ &
        & 0.10362e+04,0.78531e+03,0.59952e+03,0.88052e+03,0.11615e+04 /)
      kbo(:, 2,44,11) = (/ &
        & 0.10357e+04,0.78506e+03,0.59854e+03,0.87945e+03,0.11599e+04 /)
      kbo(:, 3,44,11) = (/ &
        & 0.10347e+04,0.78494e+03,0.59755e+03,0.87796e+03,0.11576e+04 /)
      kbo(:, 4,44,11) = (/ &
        & 0.10360e+04,0.78599e+03,0.59655e+03,0.87632e+03,0.11562e+04 /)
      kbo(:, 5,44,11) = (/ &
        & 0.10364e+04,0.78610e+03,0.59556e+03,0.87451e+03,0.11545e+04 /)
      kbo(:, 1,45,11) = (/ &
        & 0.10355e+04,0.78552e+03,0.59982e+03,0.88100e+03,0.11621e+04 /)
      kbo(:, 2,45,11) = (/ &
        & 0.10357e+04,0.78527e+03,0.59887e+03,0.87975e+03,0.11605e+04 /)
      kbo(:, 3,45,11) = (/ &
        & 0.10358e+04,0.78432e+03,0.59788e+03,0.87848e+03,0.11586e+04 /)
      kbo(:, 4,45,11) = (/ &
        & 0.10358e+04,0.78597e+03,0.59689e+03,0.87689e+03,0.11568e+04 /)
      kbo(:, 5,45,11) = (/ &
        & 0.10353e+04,0.78525e+03,0.59589e+03,0.87514e+03,0.11551e+04 /)
      kbo(:, 1,46,11) = (/ &
        & 0.10358e+04,0.78503e+03,0.60010e+03,0.88136e+03,0.11629e+04 /)
      kbo(:, 2,46,11) = (/ &
        & 0.10366e+04,0.78667e+03,0.59923e+03,0.88004e+03,0.11611e+04 /)
      kbo(:, 3,46,11) = (/ &
        & 0.10372e+04,0.78560e+03,0.59824e+03,0.87915e+03,0.11593e+04 /)
      kbo(:, 4,46,11) = (/ &
        & 0.10348e+04,0.78513e+03,0.59725e+03,0.87748e+03,0.11574e+04 /)
      kbo(:, 5,46,11) = (/ &
        & 0.10372e+04,0.78595e+03,0.59625e+03,0.87592e+03,0.11557e+04 /)
      kbo(:, 1,47,11) = (/ &
        & 0.10352e+04,0.78466e+03,0.60059e+03,0.88175e+03,0.11637e+04 /)
      kbo(:, 2,47,11) = (/ &
        & 0.10362e+04,0.78477e+03,0.59970e+03,0.88075e+03,0.11618e+04 /)
      kbo(:, 3,47,11) = (/ &
        & 0.10362e+04,0.78559e+03,0.59863e+03,0.87958e+03,0.11601e+04 /)
      kbo(:, 4,47,11) = (/ &
        & 0.10356e+04,0.78476e+03,0.59765e+03,0.87812e+03,0.11581e+04 /)
      kbo(:, 5,47,11) = (/ &
        & 0.10361e+04,0.78428e+03,0.59665e+03,0.87649e+03,0.11564e+04 /)
      kbo(:, 1,48,11) = (/ &
        & 0.10354e+04,0.78500e+03,0.60042e+03,0.88214e+03,0.11645e+04 /)
      kbo(:, 2,48,11) = (/ &
        & 0.10348e+04,0.78582e+03,0.59995e+03,0.88117e+03,0.11625e+04 /)
      kbo(:, 3,48,11) = (/ &
        & 0.10353e+04,0.78569e+03,0.59903e+03,0.87942e+03,0.11608e+04 /)
      kbo(:, 4,48,11) = (/ &
        & 0.10359e+04,0.78569e+03,0.59804e+03,0.87873e+03,0.11589e+04 /)
      kbo(:, 5,48,11) = (/ &
        & 0.10354e+04,0.78509e+03,0.59705e+03,0.87716e+03,0.11570e+04 /)
      kbo(:, 1,49,11) = (/ &
        & 0.10362e+04,0.78463e+03,0.60042e+03,0.88242e+03,0.11657e+04 /)
      kbo(:, 2,49,11) = (/ &
        & 0.10367e+04,0.78580e+03,0.60023e+03,0.88156e+03,0.11633e+04 /)
      kbo(:, 3,49,11) = (/ &
        & 0.10373e+04,0.78533e+03,0.59942e+03,0.88054e+03,0.11615e+04 /)
      kbo(:, 4,49,11) = (/ &
        & 0.10373e+04,0.78462e+03,0.59844e+03,0.87918e+03,0.11595e+04 /)
      kbo(:, 5,49,11) = (/ &
        & 0.10370e+04,0.78532e+03,0.59736e+03,0.87781e+03,0.11578e+04 /)
      kbo(:, 1,50,11) = (/ &
        & 0.10356e+04,0.78474e+03,0.60056e+03,0.88267e+03,0.11666e+04 /)
      kbo(:, 2,50,11) = (/ &
        & 0.10370e+04,0.78497e+03,0.60046e+03,0.88192e+03,0.11642e+04 /)
      kbo(:, 3,50,11) = (/ &
        & 0.10348e+04,0.78508e+03,0.59977e+03,0.88094e+03,0.11634e+04 /)
      kbo(:, 4,50,11) = (/ &
        & 0.10352e+04,0.78473e+03,0.59881e+03,0.87954e+03,0.11604e+04 /)
      kbo(:, 5,50,11) = (/ &
        & 0.10360e+04,0.78437e+03,0.59782e+03,0.87840e+03,0.11585e+04 /)
      kbo(:, 1,51,11) = (/ &
        & 0.10365e+04,0.78532e+03,0.60054e+03,0.88306e+03,0.11674e+04 /)
      kbo(:, 2,51,11) = (/ &
        & 0.10360e+04,0.78555e+03,0.60046e+03,0.88226e+03,0.11651e+04 /)
      kbo(:, 3,51,11) = (/ &
        & 0.10359e+04,0.78508e+03,0.60006e+03,0.88131e+03,0.11628e+04 /)
      kbo(:, 4,51,11) = (/ &
        & 0.10359e+04,0.78554e+03,0.59917e+03,0.88011e+03,0.11610e+04 /)
      kbo(:, 5,51,11) = (/ &
        & 0.10363e+04,0.78507e+03,0.59818e+03,0.87894e+03,0.11592e+04 /)
      kbo(:, 1,52,11) = (/ &
        & 0.10357e+04,0.78531e+03,0.60048e+03,0.88333e+03,0.11687e+04 /)
      kbo(:, 2,52,11) = (/ &
        & 0.10368e+04,0.78554e+03,0.60053e+03,0.88249e+03,0.11660e+04 /)
      kbo(:, 3,52,11) = (/ &
        & 0.10362e+04,0.78601e+03,0.60037e+03,0.88166e+03,0.11635e+04 /)
      kbo(:, 4,52,11) = (/ &
        & 0.10354e+04,0.78507e+03,0.59952e+03,0.88066e+03,0.11617e+04 /)
      kbo(:, 5,52,11) = (/ &
        & 0.10363e+04,0.78565e+03,0.59854e+03,0.87959e+03,0.11599e+04 /)
      kbo(:, 1,53,11) = (/ &
        & 0.10366e+04,0.78460e+03,0.60030e+03,0.88415e+03,0.11699e+04 /)
      kbo(:, 2,53,11) = (/ &
        & 0.10366e+04,0.78400e+03,0.60056e+03,0.88262e+03,0.11668e+04 /)
      kbo(:, 3,53,11) = (/ &
        & 0.10358e+04,0.78459e+03,0.60039e+03,0.88202e+03,0.11644e+04 /)
      kbo(:, 4,53,11) = (/ &
        & 0.10348e+04,0.78471e+03,0.59985e+03,0.88104e+03,0.11623e+04 /)
      kbo(:, 5,53,11) = (/ &
        & 0.10366e+04,0.78577e+03,0.59891e+03,0.87992e+03,0.11606e+04 /)
      kbo(:, 1,54,11) = (/ &
        & 0.10355e+04,0.78471e+03,0.60033e+03,0.88501e+03,0.11708e+04 /)
      kbo(:, 2,54,11) = (/ &
        & 0.10360e+04,0.78494e+03,0.60053e+03,0.88313e+03,0.11678e+04 /)
      kbo(:, 3,54,11) = (/ &
        & 0.10360e+04,0.78671e+03,0.60047e+03,0.88230e+03,0.11652e+04 /)
      kbo(:, 4,54,11) = (/ &
        & 0.10355e+04,0.78588e+03,0.60010e+03,0.88137e+03,0.11629e+04 /)
      kbo(:, 5,54,11) = (/ &
        & 0.10357e+04,0.78517e+03,0.59924e+03,0.88032e+03,0.11612e+04 /)
      kbo(:, 1,55,11) = (/ &
        & 0.10357e+04,0.78506e+03,0.60035e+03,0.88567e+03,0.11714e+04 /)
      kbo(:, 2,55,11) = (/ &
        & 0.10357e+04,0.78518e+03,0.60047e+03,0.88349e+03,0.11688e+04 /)
      kbo(:, 3,55,11) = (/ &
        & 0.10361e+04,0.78517e+03,0.60053e+03,0.88250e+03,0.11660e+04 /)
      kbo(:, 4,55,11) = (/ &
        & 0.10357e+04,0.78529e+03,0.60029e+03,0.88168e+03,0.11636e+04 /)
      kbo(:, 5,55,11) = (/ &
        & 0.10360e+04,0.78529e+03,0.59954e+03,0.88068e+03,0.11617e+04 /)
      kbo(:, 1,56,11) = (/ &
        & 0.10361e+04,0.78494e+03,0.60049e+03,0.88607e+03,0.11718e+04 /)
      kbo(:, 2,56,11) = (/ &
        & 0.10360e+04,0.78482e+03,0.60030e+03,0.88410e+03,0.11698e+04 /)
      kbo(:, 3,56,11) = (/ &
        & 0.10354e+04,0.78493e+03,0.60056e+03,0.88273e+03,0.11667e+04 /)
      kbo(:, 4,56,11) = (/ &
        & 0.10357e+04,0.78552e+03,0.60038e+03,0.88199e+03,0.11645e+04 /)
      kbo(:, 5,56,11) = (/ &
        & 0.10357e+04,0.78517e+03,0.59983e+03,0.88101e+03,0.11624e+04 /)
      kbo(:, 1,57,11) = (/ &
        & 0.10357e+04,0.78588e+03,0.60099e+03,0.88686e+03,0.11725e+04 /)
      kbo(:, 2,57,11) = (/ &
        & 0.10366e+04,0.78458e+03,0.60033e+03,0.88491e+03,0.11707e+04 /)
      kbo(:, 3,57,11) = (/ &
        & 0.10366e+04,0.78481e+03,0.60053e+03,0.88335e+03,0.11676e+04 /)
      kbo(:, 4,57,11) = (/ &
        & 0.10358e+04,0.78611e+03,0.60046e+03,0.88227e+03,0.11650e+04 /)
      kbo(:, 5,57,11) = (/ &
        & 0.10355e+04,0.78599e+03,0.60008e+03,0.88133e+03,0.11630e+04 /)
      kbo(:, 1,58,11) = (/ &
        & 0.10363e+04,0.78576e+03,0.60143e+03,0.88764e+03,0.11733e+04 /)
      kbo(:, 2,58,11) = (/ &
        & 0.10354e+04,0.78611e+03,0.60042e+03,0.88557e+03,0.11713e+04 /)
      kbo(:, 3,58,11) = (/ &
        & 0.10363e+04,0.78576e+03,0.60048e+03,0.88329e+03,0.11686e+04 /)
      kbo(:, 4,58,11) = (/ &
        & 0.10364e+04,0.78505e+03,0.60052e+03,0.88247e+03,0.11659e+04 /)
      kbo(:, 5,58,11) = (/ &
        & 0.10357e+04,0.78552e+03,0.60026e+03,0.88163e+03,0.11633e+04 /)
      kbo(:, 1,59,11) = (/ &
        & 0.10354e+04,0.78634e+03,0.60176e+03,0.88797e+03,0.11736e+04 /)
      kbo(:, 2,59,11) = (/ &
        & 0.10350e+04,0.78505e+03,0.60038e+03,0.88577e+03,0.11715e+04 /)
      kbo(:, 3,59,11) = (/ &
        & 0.10360e+04,0.78469e+03,0.60046e+03,0.88358e+03,0.11703e+04 /)
      kbo(:, 4,59,11) = (/ &
        & 0.10357e+04,0.78493e+03,0.60045e+03,0.88254e+03,0.11662e+04 /)
      kbo(:, 5,59,11) = (/ &
        & 0.10366e+04,0.78516e+03,0.60041e+03,0.88174e+03,0.11637e+04 /)
      kbo(:, 1,13,12) = (/ &
        & 0.11535e+04,0.87955e+03,0.60434e+03,0.88744e+03,0.11710e+04 /)
      kbo(:, 2,13,12) = (/ &
        & 0.11485e+04,0.86886e+03,0.60369e+03,0.88598e+03,0.11697e+04 /)
      kbo(:, 3,13,12) = (/ &
        & 0.11395e+04,0.86441e+03,0.60332e+03,0.88477e+03,0.11680e+04 /)
      kbo(:, 4,13,12) = (/ &
        & 0.11350e+04,0.86216e+03,0.60276e+03,0.88294e+03,0.11659e+04 /)
      kbo(:, 5,13,12) = (/ &
        & 0.11237e+04,0.85514e+03,0.60186e+03,0.88131e+03,0.11640e+04 /)
      kbo(:, 1,14,12) = (/ &
        & 0.11312e+04,0.85960e+03,0.60391e+03,0.88683e+03,0.11708e+04 /)
      kbo(:, 2,14,12) = (/ &
        & 0.11248e+04,0.85192e+03,0.60329e+03,0.88591e+03,0.11696e+04 /)
      kbo(:, 3,14,12) = (/ &
        & 0.11210e+04,0.84824e+03,0.60297e+03,0.88444e+03,0.11678e+04 /)
      kbo(:, 4,14,12) = (/ &
        & 0.11139e+04,0.84322e+03,0.60241e+03,0.88264e+03,0.11657e+04 /)
      kbo(:, 5,14,12) = (/ &
        & 0.11123e+04,0.84158e+03,0.60150e+03,0.88104e+03,0.11639e+04 /)
      kbo(:, 1,15,12) = (/ &
        & 0.11159e+04,0.84414e+03,0.60344e+03,0.88657e+03,0.11715e+04 /)
      kbo(:, 2,15,12) = (/ &
        & 0.11106e+04,0.84043e+03,0.60296e+03,0.88568e+03,0.11695e+04 /)
      kbo(:, 3,15,12) = (/ &
        & 0.11018e+04,0.83588e+03,0.60268e+03,0.88413e+03,0.11676e+04 /)
      kbo(:, 4,15,12) = (/ &
        & 0.10976e+04,0.83213e+03,0.60210e+03,0.88235e+03,0.11655e+04 /)
      kbo(:, 5,15,12) = (/ &
        & 0.10965e+04,0.83273e+03,0.60128e+03,0.88077e+03,0.11639e+04 /)
      kbo(:, 1,16,12) = (/ &
        & 0.11003e+04,0.83414e+03,0.60325e+03,0.88634e+03,0.11705e+04 /)
      kbo(:, 2,16,12) = (/ &
        & 0.10991e+04,0.82921e+03,0.60259e+03,0.88546e+03,0.11694e+04 /)
      kbo(:, 3,16,12) = (/ &
        & 0.10955e+04,0.82665e+03,0.60243e+03,0.88384e+03,0.11674e+04 /)
      kbo(:, 4,16,12) = (/ &
        & 0.10851e+04,0.82401e+03,0.60183e+03,0.88207e+03,0.11653e+04 /)
      kbo(:, 5,16,12) = (/ &
        & 0.10849e+04,0.82356e+03,0.60085e+03,0.88053e+03,0.11635e+04 /)
      kbo(:, 1,17,12) = (/ &
        & 0.10876e+04,0.82527e+03,0.60299e+03,0.88614e+03,0.11702e+04 /)
      kbo(:, 2,17,12) = (/ &
        & 0.10859e+04,0.82135e+03,0.60250e+03,0.88526e+03,0.11692e+04 /)
      kbo(:, 3,17,12) = (/ &
        & 0.10841e+04,0.81891e+03,0.60222e+03,0.88356e+03,0.11671e+04 /)
      kbo(:, 4,17,12) = (/ &
        & 0.10784e+04,0.81708e+03,0.60159e+03,0.88183e+03,0.11651e+04 /)
      kbo(:, 5,17,12) = (/ &
        & 0.10763e+04,0.81350e+03,0.60170e+03,0.88030e+03,0.11634e+04 /)
      kbo(:, 1,18,12) = (/ &
        & 0.10781e+04,0.81748e+03,0.60276e+03,0.88597e+03,0.11700e+04 /)
      kbo(:, 2,18,12) = (/ &
        & 0.10771e+04,0.81396e+03,0.60232e+03,0.88573e+03,0.11691e+04 /)
      kbo(:, 3,18,12) = (/ &
        & 0.10718e+04,0.81415e+03,0.60204e+03,0.88331e+03,0.11669e+04 /)
      kbo(:, 4,18,12) = (/ &
        & 0.10689e+04,0.81027e+03,0.60137e+03,0.88144e+03,0.11649e+04 /)
      kbo(:, 5,18,12) = (/ &
        & 0.10691e+04,0.80937e+03,0.60029e+03,0.88009e+03,0.11632e+04 /)
      kbo(:, 1,19,12) = (/ &
        & 0.10732e+04,0.81093e+03,0.60257e+03,0.88582e+03,0.11702e+04 /)
      kbo(:, 2,19,12) = (/ &
        & 0.10665e+04,0.81093e+03,0.60218e+03,0.88486e+03,0.11689e+04 /)
      kbo(:, 3,19,12) = (/ &
        & 0.10668e+04,0.80596e+03,0.60188e+03,0.88291e+03,0.11667e+04 /)
      kbo(:, 4,19,12) = (/ &
        & 0.10625e+04,0.80871e+03,0.60129e+03,0.88139e+03,0.11647e+04 /)
      kbo(:, 5,19,12) = (/ &
        & 0.10641e+04,0.80549e+03,0.60005e+03,0.87990e+03,0.11631e+04 /)
      kbo(:, 1,20,12) = (/ &
        & 0.10655e+04,0.80608e+03,0.60228e+03,0.88568e+03,0.11700e+04 /)
      kbo(:, 2,20,12) = (/ &
        & 0.10621e+04,0.80582e+03,0.60205e+03,0.88462e+03,0.11686e+04 /)
      kbo(:, 3,20,12) = (/ &
        & 0.10596e+04,0.80439e+03,0.60161e+03,0.88282e+03,0.11664e+04 /)
      kbo(:, 4,20,12) = (/ &
        & 0.10569e+04,0.80052e+03,0.60133e+03,0.88084e+03,0.11645e+04 /)
      kbo(:, 5,20,12) = (/ &
        & 0.10576e+04,0.80029e+03,0.59980e+03,0.87969e+03,0.11629e+04 /)
      kbo(:, 1,21,12) = (/ &
        & 0.10601e+04,0.80047e+03,0.60235e+03,0.88539e+03,0.11699e+04 /)
      kbo(:, 2,21,12) = (/ &
        & 0.10553e+04,0.80126e+03,0.60195e+03,0.88437e+03,0.11684e+04 /)
      kbo(:, 3,21,12) = (/ &
        & 0.10581e+04,0.79916e+03,0.60159e+03,0.88257e+03,0.11662e+04 /)
      kbo(:, 4,21,12) = (/ &
        & 0.10523e+04,0.79871e+03,0.60090e+03,0.88096e+03,0.11643e+04 /)
      kbo(:, 5,21,12) = (/ &
        & 0.10536e+04,0.79852e+03,0.59957e+03,0.87950e+03,0.11627e+04 /)
      kbo(:, 1,22,12) = (/ &
        & 0.10543e+04,0.79995e+03,0.60207e+03,0.88538e+03,0.11697e+04 /)
      kbo(:, 2,22,12) = (/ &
        & 0.10531e+04,0.79794e+03,0.60195e+03,0.88401e+03,0.11680e+04 /)
      kbo(:, 3,22,12) = (/ &
        & 0.10510e+04,0.79590e+03,0.60141e+03,0.88205e+03,0.11658e+04 /)
      kbo(:, 4,22,12) = (/ &
        & 0.10516e+04,0.79518e+03,0.60121e+03,0.88065e+03,0.11640e+04 /)
      kbo(:, 5,22,12) = (/ &
        & 0.10507e+04,0.79514e+03,0.59925e+03,0.87922e+03,0.11625e+04 /)
      kbo(:, 1,23,12) = (/ &
        & 0.10496e+04,0.79686e+03,0.60138e+03,0.88518e+03,0.11695e+04 /)
      kbo(:, 2,23,12) = (/ &
        & 0.10500e+04,0.79504e+03,0.60174e+03,0.88363e+03,0.11675e+04 /)
      kbo(:, 3,23,12) = (/ &
        & 0.10497e+04,0.79559e+03,0.60122e+03,0.88187e+03,0.11654e+04 /)
      kbo(:, 4,23,12) = (/ &
        & 0.10478e+04,0.79456e+03,0.60013e+03,0.88034e+03,0.11637e+04 /)
      kbo(:, 5,23,12) = (/ &
        & 0.10481e+04,0.79269e+03,0.59893e+03,0.87894e+03,0.11623e+04 /)
      kbo(:, 1,24,12) = (/ &
        & 0.10504e+04,0.79322e+03,0.60186e+03,0.88494e+03,0.11692e+04 /)
      kbo(:, 2,24,12) = (/ &
        & 0.10474e+04,0.79292e+03,0.60174e+03,0.88325e+03,0.11671e+04 /)
      kbo(:, 3,24,12) = (/ &
        & 0.10457e+04,0.79315e+03,0.60103e+03,0.88153e+03,0.11648e+04 /)
      kbo(:, 4,24,12) = (/ &
        & 0.10462e+04,0.79329e+03,0.59996e+03,0.88003e+03,0.11633e+04 /)
      kbo(:, 5,24,12) = (/ &
        & 0.10477e+04,0.79348e+03,0.59860e+03,0.87867e+03,0.11620e+04 /)
      kbo(:, 1,25,12) = (/ &
        & 0.10437e+04,0.79315e+03,0.60179e+03,0.88497e+03,0.11688e+04 /)
      kbo(:, 2,25,12) = (/ &
        & 0.10446e+04,0.79177e+03,0.60151e+03,0.88285e+03,0.11666e+04 /)
      kbo(:, 3,25,12) = (/ &
        & 0.10443e+04,0.79105e+03,0.60081e+03,0.88119e+03,0.11647e+04 /)
      kbo(:, 4,25,12) = (/ &
        & 0.10440e+04,0.79204e+03,0.59965e+03,0.87971e+03,0.11630e+04 /)
      kbo(:, 5,25,12) = (/ &
        & 0.10441e+04,0.79141e+03,0.59825e+03,0.87840e+03,0.11618e+04 /)
      kbo(:, 1,26,12) = (/ &
        & 0.10444e+04,0.79040e+03,0.60171e+03,0.88422e+03,0.11681e+04 /)
      kbo(:, 2,26,12) = (/ &
        & 0.10415e+04,0.78987e+03,0.60136e+03,0.88243e+03,0.11661e+04 /)
      kbo(:, 3,26,12) = (/ &
        & 0.10417e+04,0.79014e+03,0.60043e+03,0.88082e+03,0.11642e+04 /)
      kbo(:, 4,26,12) = (/ &
        & 0.10442e+04,0.78985e+03,0.59932e+03,0.87937e+03,0.11625e+04 /)
      kbo(:, 5,26,12) = (/ &
        & 0.10421e+04,0.79004e+03,0.59787e+03,0.87814e+03,0.11615e+04 /)
      kbo(:, 1,27,12) = (/ &
        & 0.10431e+04,0.78868e+03,0.60163e+03,0.88378e+03,0.11678e+04 /)
      kbo(:, 2,27,12) = (/ &
        & 0.10423e+04,0.79138e+03,0.60118e+03,0.88201e+03,0.11657e+04 /)
      kbo(:, 3,27,12) = (/ &
        & 0.10404e+04,0.78916e+03,0.60037e+03,0.88046e+03,0.11638e+04 /)
      kbo(:, 4,27,12) = (/ &
        & 0.10405e+04,0.78893e+03,0.59897e+03,0.87905e+03,0.11624e+04 /)
      kbo(:, 5,27,12) = (/ &
        & 0.10396e+04,0.78917e+03,0.59748e+03,0.87790e+03,0.11613e+04 /)
      kbo(:, 1,28,12) = (/ &
        & 0.10409e+04,0.79152e+03,0.60155e+03,0.88334e+03,0.11673e+04 /)
      kbo(:, 2,28,12) = (/ &
        & 0.10439e+04,0.78963e+03,0.60099e+03,0.88127e+03,0.11652e+04 /)
      kbo(:, 3,28,12) = (/ &
        & 0.10423e+04,0.78823e+03,0.60006e+03,0.88010e+03,0.11635e+04 /)
      kbo(:, 4,28,12) = (/ &
        & 0.10442e+04,0.78834e+03,0.59861e+03,0.87873e+03,0.11621e+04 /)
      kbo(:, 5,28,12) = (/ &
        & 0.10392e+04,0.79042e+03,0.59708e+03,0.87768e+03,0.11610e+04 /)
      kbo(:, 1,29,12) = (/ &
        & 0.10405e+04,0.79019e+03,0.60167e+03,0.88289e+03,0.11667e+04 /)
      kbo(:, 2,29,12) = (/ &
        & 0.10432e+04,0.78865e+03,0.60111e+03,0.88122e+03,0.11647e+04 /)
      kbo(:, 3,29,12) = (/ &
        & 0.10406e+04,0.78834e+03,0.59962e+03,0.87974e+03,0.11631e+04 /)
      kbo(:, 4,29,12) = (/ &
        & 0.10397e+04,0.78909e+03,0.59824e+03,0.87826e+03,0.11618e+04 /)
      kbo(:, 5,29,12) = (/ &
        & 0.10387e+04,0.78925e+03,0.59665e+03,0.87746e+03,0.11608e+04 /)
      kbo(:, 1,30,12) = (/ &
        & 0.10411e+04,0.78840e+03,0.60130e+03,0.88244e+03,0.11662e+04 /)
      kbo(:, 2,30,12) = (/ &
        & 0.10395e+04,0.79020e+03,0.60051e+03,0.88083e+03,0.11643e+04 /)
      kbo(:, 3,30,12) = (/ &
        & 0.10384e+04,0.78543e+03,0.59928e+03,0.87938e+03,0.11627e+04 /)
      kbo(:, 4,30,12) = (/ &
        & 0.10394e+04,0.78756e+03,0.59785e+03,0.87814e+03,0.11615e+04 /)
      kbo(:, 5,30,12) = (/ &
        & 0.10383e+04,0.78820e+03,0.59620e+03,0.87743e+03,0.11605e+04 /)
      kbo(:, 1,31,12) = (/ &
        & 0.10385e+04,0.78703e+03,0.60113e+03,0.88199e+03,0.11657e+04 /)
      kbo(:, 2,31,12) = (/ &
        & 0.10401e+04,0.79050e+03,0.60021e+03,0.88045e+03,0.11639e+04 /)
      kbo(:, 3,31,12) = (/ &
        & 0.10412e+04,0.78681e+03,0.59892e+03,0.87903e+03,0.11624e+04 /)
      kbo(:, 4,31,12) = (/ &
        & 0.10385e+04,0.78582e+03,0.59732e+03,0.87772e+03,0.11613e+04 /)
      kbo(:, 5,31,12) = (/ &
        & 0.10372e+04,0.78947e+03,0.59573e+03,0.87705e+03,0.11602e+04 /)
      kbo(:, 1,32,12) = (/ &
        & 0.10378e+04,0.78710e+03,0.60105e+03,0.88140e+03,0.11652e+04 /)
      kbo(:, 2,32,12) = (/ &
        & 0.10375e+04,0.78506e+03,0.59989e+03,0.88006e+03,0.11634e+04 /)
      kbo(:, 3,32,12) = (/ &
        & 0.10409e+04,0.78648e+03,0.59855e+03,0.87869e+03,0.11621e+04 /)
      kbo(:, 4,32,12) = (/ &
        & 0.10389e+04,0.78640e+03,0.59701e+03,0.87765e+03,0.11610e+04 /)
      kbo(:, 5,32,12) = (/ &
        & 0.10378e+04,0.78589e+03,0.59527e+03,0.87675e+03,0.11598e+04 /)
      kbo(:, 1,33,12) = (/ &
        & 0.10380e+04,0.78620e+03,0.60093e+03,0.88116e+03,0.11647e+04 /)
      kbo(:, 2,33,12) = (/ &
        & 0.10383e+04,0.78582e+03,0.59966e+03,0.87968e+03,0.11631e+04 /)
      kbo(:, 3,33,12) = (/ &
        & 0.10388e+04,0.78740e+03,0.59816e+03,0.87838e+03,0.11618e+04 /)
      kbo(:, 4,33,12) = (/ &
        & 0.10367e+04,0.78734e+03,0.59657e+03,0.87743e+03,0.11608e+04 /)
      kbo(:, 5,33,12) = (/ &
        & 0.10382e+04,0.78803e+03,0.59484e+03,0.87630e+03,0.11592e+04 /)
      kbo(:, 1,34,12) = (/ &
        & 0.10390e+04,0.78774e+03,0.60058e+03,0.88098e+03,0.11643e+04 /)
      kbo(:, 2,34,12) = (/ &
        & 0.10374e+04,0.78664e+03,0.59936e+03,0.87936e+03,0.11627e+04 /)
      kbo(:, 3,34,12) = (/ &
        & 0.10352e+04,0.78733e+03,0.59781e+03,0.87813e+03,0.11615e+04 /)
      kbo(:, 4,34,12) = (/ &
        & 0.10386e+04,0.78609e+03,0.59617e+03,0.87742e+03,0.11605e+04 /)
      kbo(:, 5,34,12) = (/ &
        & 0.10400e+04,0.78709e+03,0.59476e+03,0.87581e+03,0.11592e+04 /)
      kbo(:, 1,35,12) = (/ &
        & 0.10374e+04,0.78486e+03,0.60032e+03,0.88061e+03,0.11641e+04 /)
      kbo(:, 2,35,12) = (/ &
        & 0.10385e+04,0.78482e+03,0.59906e+03,0.87918e+03,0.11626e+04 /)
      kbo(:, 3,35,12) = (/ &
        & 0.10371e+04,0.78627e+03,0.59760e+03,0.87799e+03,0.11614e+04 /)
      kbo(:, 4,35,12) = (/ &
        & 0.10378e+04,0.78697e+03,0.59593e+03,0.87715e+03,0.11604e+04 /)
      kbo(:, 5,35,12) = (/ &
        & 0.10370e+04,0.78545e+03,0.59500e+03,0.87549e+03,0.11592e+04 /)
      kbo(:, 1,36,12) = (/ &
        & 0.10362e+04,0.78845e+03,0.60029e+03,0.88058e+03,0.11640e+04 /)
      kbo(:, 2,36,12) = (/ &
        & 0.10379e+04,0.78676e+03,0.59903e+03,0.87915e+03,0.11625e+04 /)
      kbo(:, 3,36,12) = (/ &
        & 0.10369e+04,0.78598e+03,0.59768e+03,0.87797e+03,0.11614e+04 /)
      kbo(:, 4,36,12) = (/ &
        & 0.10369e+04,0.78595e+03,0.59566e+03,0.87713e+03,0.11604e+04 /)
      kbo(:, 5,36,12) = (/ &
        & 0.10368e+04,0.78548e+03,0.59464e+03,0.87594e+03,0.11600e+04 /)
      kbo(:, 1,37,12) = (/ &
        & 0.10374e+04,0.78579e+03,0.60055e+03,0.88077e+03,0.11642e+04 /)
      kbo(:, 2,37,12) = (/ &
        & 0.10362e+04,0.78844e+03,0.59921e+03,0.87933e+03,0.11627e+04 /)
      kbo(:, 3,37,12) = (/ &
        & 0.10360e+04,0.78603e+03,0.59777e+03,0.87810e+03,0.11615e+04 /)
      kbo(:, 4,37,12) = (/ &
        & 0.10367e+04,0.78734e+03,0.59623e+03,0.87723e+03,0.11605e+04 /)
      kbo(:, 5,37,12) = (/ &
        & 0.10361e+04,0.78702e+03,0.59474e+03,0.87592e+03,0.11587e+04 /)
      kbo(:, 1,38,12) = (/ &
        & 0.10367e+04,0.78778e+03,0.60058e+03,0.88098e+03,0.11645e+04 /)
      kbo(:, 2,38,12) = (/ &
        & 0.10387e+04,0.78865e+03,0.59939e+03,0.87952e+03,0.11629e+04 /)
      kbo(:, 3,38,12) = (/ &
        & 0.10363e+04,0.78758e+03,0.59820e+03,0.87825e+03,0.11617e+04 /)
      kbo(:, 4,38,12) = (/ &
        & 0.10372e+04,0.78786e+03,0.59636e+03,0.87717e+03,0.11609e+04 /)
      kbo(:, 5,38,12) = (/ &
        & 0.10362e+04,0.78470e+03,0.59485e+03,0.87657e+03,0.11589e+04 /)
      kbo(:, 1,39,12) = (/ &
        & 0.10374e+04,0.78680e+03,0.60094e+03,0.88119e+03,0.11647e+04 /)
      kbo(:, 2,39,12) = (/ &
        & 0.10352e+04,0.78618e+03,0.60014e+03,0.87971e+03,0.11631e+04 /)
      kbo(:, 3,39,12) = (/ &
        & 0.10401e+04,0.78497e+03,0.59818e+03,0.87840e+03,0.11618e+04 /)
      kbo(:, 4,39,12) = (/ &
        & 0.10369e+04,0.78868e+03,0.59660e+03,0.87744e+03,0.11608e+04 /)
      kbo(:, 5,39,12) = (/ &
        & 0.10353e+04,0.78494e+03,0.59497e+03,0.87635e+03,0.11593e+04 /)
      kbo(:, 1,40,12) = (/ &
        & 0.10385e+04,0.78584e+03,0.60091e+03,0.88123e+03,0.11652e+04 /)
      kbo(:, 2,40,12) = (/ &
        & 0.10387e+04,0.78568e+03,0.59987e+03,0.88006e+03,0.11635e+04 /)
      kbo(:, 3,40,12) = (/ &
        & 0.10371e+04,0.78626e+03,0.59853e+03,0.87869e+03,0.11621e+04 /)
      kbo(:, 4,40,12) = (/ &
        & 0.10386e+04,0.78684e+03,0.59700e+03,0.87748e+03,0.11610e+04 /)
      kbo(:, 5,40,12) = (/ &
        & 0.10362e+04,0.78503e+03,0.59526e+03,0.87692e+03,0.11598e+04 /)
      kbo(:, 1,41,12) = (/ &
        & 0.10384e+04,0.78504e+03,0.60109e+03,0.88198e+03,0.11657e+04 /)
      kbo(:, 2,41,12) = (/ &
        & 0.10360e+04,0.78533e+03,0.60017e+03,0.88043e+03,0.11639e+04 /)
      kbo(:, 3,41,12) = (/ &
        & 0.10374e+04,0.78412e+03,0.59889e+03,0.87902e+03,0.11624e+04 /)
      kbo(:, 4,41,12) = (/ &
        & 0.10350e+04,0.78545e+03,0.59741e+03,0.87788e+03,0.11613e+04 /)
      kbo(:, 5,41,12) = (/ &
        & 0.10385e+04,0.78529e+03,0.59570e+03,0.87704e+03,0.11607e+04 /)
      kbo(:, 1,42,12) = (/ &
        & 0.10370e+04,0.78560e+03,0.60125e+03,0.88242e+03,0.11662e+04 /)
      kbo(:, 2,42,12) = (/ &
        & 0.10383e+04,0.78469e+03,0.60057e+03,0.88081e+03,0.11643e+04 /)
      kbo(:, 3,42,12) = (/ &
        & 0.10368e+04,0.78617e+03,0.59924e+03,0.87937e+03,0.11627e+04 /)
      kbo(:, 4,42,12) = (/ &
        & 0.10362e+04,0.78586e+03,0.59780e+03,0.87813e+03,0.11615e+04 /)
      kbo(:, 5,42,12) = (/ &
        & 0.10350e+04,0.78958e+03,0.59616e+03,0.87725e+03,0.11605e+04 /)
      kbo(:, 1,43,12) = (/ &
        & 0.10375e+04,0.78586e+03,0.60140e+03,0.88280e+03,0.11669e+04 /)
      kbo(:, 2,43,12) = (/ &
        & 0.10344e+04,0.78615e+03,0.60088e+03,0.88112e+03,0.11651e+04 /)
      kbo(:, 3,43,12) = (/ &
        & 0.10344e+04,0.78345e+03,0.59953e+03,0.87980e+03,0.11632e+04 /)
      kbo(:, 4,43,12) = (/ &
        & 0.10347e+04,0.78777e+03,0.59827e+03,0.87847e+03,0.11619e+04 /)
      kbo(:, 5,43,12) = (/ &
        & 0.10355e+04,0.78627e+03,0.59681e+03,0.87766e+03,0.11609e+04 /)
      kbo(:, 1,44,12) = (/ &
        & 0.10355e+04,0.78449e+03,0.60162e+03,0.88358e+03,0.11676e+04 /)
      kbo(:, 2,44,12) = (/ &
        & 0.10359e+04,0.78627e+03,0.60103e+03,0.88182e+03,0.11655e+04 /)
      kbo(:, 3,44,12) = (/ &
        & 0.10377e+04,0.78715e+03,0.60005e+03,0.88029e+03,0.11637e+04 /)
      kbo(:, 4,44,12) = (/ &
        & 0.10378e+04,0.78625e+03,0.59875e+03,0.87890e+03,0.11623e+04 /)
      kbo(:, 5,44,12) = (/ &
        & 0.10374e+04,0.78401e+03,0.59725e+03,0.87779e+03,0.11612e+04 /)
      kbo(:, 1,45,12) = (/ &
        & 0.10390e+04,0.78655e+03,0.60158e+03,0.88419e+03,0.11684e+04 /)
      kbo(:, 2,45,12) = (/ &
        & 0.10396e+04,0.78684e+03,0.60124e+03,0.88239e+03,0.11662e+04 /)
      kbo(:, 3,45,12) = (/ &
        & 0.10355e+04,0.78758e+03,0.60044e+03,0.88079e+03,0.11643e+04 /)
      kbo(:, 4,45,12) = (/ &
        & 0.10368e+04,0.78548e+03,0.59922e+03,0.87935e+03,0.11627e+04 /)
      kbo(:, 5,45,12) = (/ &
        & 0.10360e+04,0.78578e+03,0.59778e+03,0.87811e+03,0.11615e+04 /)
      kbo(:, 1,46,12) = (/ &
        & 0.10390e+04,0.78534e+03,0.60165e+03,0.88476e+03,0.11691e+04 /)
      kbo(:, 2,46,12) = (/ &
        & 0.10368e+04,0.78339e+03,0.60141e+03,0.88303e+03,0.11669e+04 /)
      kbo(:, 3,46,12) = (/ &
        & 0.10364e+04,0.78696e+03,0.60079e+03,0.88117e+03,0.11649e+04 /)
      kbo(:, 4,46,12) = (/ &
        & 0.10407e+04,0.78666e+03,0.59968e+03,0.87985e+03,0.11632e+04 /)
      kbo(:, 5,46,12) = (/ &
        & 0.10344e+04,0.78501e+03,0.59832e+03,0.87835e+03,0.11619e+04 /)
      kbo(:, 1,47,12) = (/ &
        & 0.10372e+04,0.78547e+03,0.60140e+03,0.88518e+03,0.11696e+04 /)
      kbo(:, 2,47,12) = (/ &
        & 0.10368e+04,0.78740e+03,0.60142e+03,0.88376e+03,0.11678e+04 /)
      kbo(:, 3,47,12) = (/ &
        & 0.10360e+04,0.78411e+03,0.60109e+03,0.88198e+03,0.11657e+04 /)
      kbo(:, 4,47,12) = (/ &
        & 0.10358e+04,0.78709e+03,0.60017e+03,0.88044e+03,0.11639e+04 /)
      kbo(:, 5,47,12) = (/ &
        & 0.10354e+04,0.78664e+03,0.59889e+03,0.87902e+03,0.11624e+04 /)
      kbo(:, 1,48,12) = (/ &
        & 0.10362e+04,0.78680e+03,0.60195e+03,0.88548e+03,0.11701e+04 /)
      kbo(:, 2,48,12) = (/ &
        & 0.10362e+04,0.78545e+03,0.60161e+03,0.88447e+03,0.11687e+04 /)
      kbo(:, 3,48,12) = (/ &
        & 0.10378e+04,0.78604e+03,0.60144e+03,0.88268e+03,0.11665e+04 /)
      kbo(:, 4,48,12) = (/ &
        & 0.10382e+04,0.78544e+03,0.60061e+03,0.88104e+03,0.11646e+04 /)
      kbo(:, 5,48,12) = (/ &
        & 0.10364e+04,0.78424e+03,0.59943e+03,0.87957e+03,0.11630e+04 /)
      kbo(:, 1,49,12) = (/ &
        & 0.10370e+04,0.78693e+03,0.60225e+03,0.88600e+03,0.11705e+04 /)
      kbo(:, 2,49,12) = (/ &
        & 0.10356e+04,0.78469e+03,0.60169e+03,0.88499e+03,0.11694e+04 /)
      kbo(:, 3,49,12) = (/ &
        & 0.10350e+04,0.78588e+03,0.60148e+03,0.88340e+03,0.11674e+04 /)
      kbo(:, 4,49,12) = (/ &
        & 0.10352e+04,0.78677e+03,0.60095e+03,0.88166e+03,0.11653e+04 /)
      kbo(:, 5,49,12) = (/ &
        & 0.10356e+04,0.78647e+03,0.59993e+03,0.88015e+03,0.11636e+04 /)
      kbo(:, 1,50,12) = (/ &
        & 0.10356e+04,0.78558e+03,0.60226e+03,0.88620e+03,0.11712e+04 /)
      kbo(:, 2,50,12) = (/ &
        & 0.10346e+04,0.78796e+03,0.60171e+03,0.88533e+03,0.11698e+04 /)
      kbo(:, 3,50,12) = (/ &
        & 0.10366e+04,0.78751e+03,0.60168e+03,0.88408e+03,0.11667e+04 /)
      kbo(:, 4,50,12) = (/ &
        & 0.10366e+04,0.78646e+03,0.60132e+03,0.88229e+03,0.11661e+04 /)
      kbo(:, 5,50,12) = (/ &
        & 0.10393e+04,0.78616e+03,0.60083e+03,0.88070e+03,0.11642e+04 /)
      kbo(:, 1,51,12) = (/ &
        & 0.10356e+04,0.78468e+03,0.60241e+03,0.88644e+03,0.11719e+04 /)
      kbo(:, 2,51,12) = (/ &
        & 0.10368e+04,0.78423e+03,0.60203e+03,0.88559e+03,0.11702e+04 /)
      kbo(:, 3,51,12) = (/ &
        & 0.10356e+04,0.78586e+03,0.60163e+03,0.88469e+03,0.11690e+04 /)
      kbo(:, 4,51,12) = (/ &
        & 0.10358e+04,0.78601e+03,0.60139e+03,0.88294e+03,0.11668e+04 /)
      kbo(:, 5,51,12) = (/ &
        & 0.10379e+04,0.78646e+03,0.60074e+03,0.88126e+03,0.11648e+04 /)
      kbo(:, 1,52,12) = (/ &
        & 0.10383e+04,0.78512e+03,0.60257e+03,0.88672e+03,0.11727e+04 /)
      kbo(:, 2,52,12) = (/ &
        & 0.10350e+04,0.78646e+03,0.60217e+03,0.88594e+03,0.11707e+04 /)
      kbo(:, 3,52,12) = (/ &
        & 0.10358e+04,0.78466e+03,0.60160e+03,0.88510e+03,0.11695e+04 /)
      kbo(:, 4,52,12) = (/ &
        & 0.10356e+04,0.78511e+03,0.60151e+03,0.88359e+03,0.11676e+04 /)
      kbo(:, 5,52,12) = (/ &
        & 0.10365e+04,0.78541e+03,0.60103e+03,0.88167e+03,0.11655e+04 /)
      kbo(:, 1,53,12) = (/ &
        & 0.10352e+04,0.78496e+03,0.60273e+03,0.88710e+03,0.11735e+04 /)
      kbo(:, 2,53,12) = (/ &
        & 0.10359e+04,0.78600e+03,0.60229e+03,0.88628e+03,0.11714e+04 /)
      kbo(:, 3,53,12) = (/ &
        & 0.10369e+04,0.78526e+03,0.60188e+03,0.88540e+03,0.11699e+04 /)
      kbo(:, 4,53,12) = (/ &
        & 0.10383e+04,0.78660e+03,0.60159e+03,0.88425e+03,0.11685e+04 /)
      kbo(:, 5,53,12) = (/ &
        & 0.10373e+04,0.78555e+03,0.60126e+03,0.88246e+03,0.11663e+04 /)
      kbo(:, 1,54,12) = (/ &
        & 0.10367e+04,0.78451e+03,0.60297e+03,0.88752e+03,0.11746e+04 /)
      kbo(:, 2,54,12) = (/ &
        & 0.10355e+04,0.78600e+03,0.60244e+03,0.88648e+03,0.11721e+04 /)
      kbo(:, 3,54,12) = (/ &
        & 0.10348e+04,0.78301e+03,0.60206e+03,0.88564e+03,0.11703e+04 /)
      kbo(:, 4,54,12) = (/ &
        & 0.10395e+04,0.78629e+03,0.60165e+03,0.88477e+03,0.11691e+04 /)
      kbo(:, 5,54,12) = (/ &
        & 0.10361e+04,0.78420e+03,0.60141e+03,0.88305e+03,0.11670e+04 /)
      kbo(:, 1,55,12) = (/ &
        & 0.10361e+04,0.78555e+03,0.60296e+03,0.88822e+03,0.11760e+04 /)
      kbo(:, 2,55,12) = (/ &
        & 0.10355e+04,0.78495e+03,0.60258e+03,0.88674e+03,0.11727e+04 /)
      kbo(:, 3,55,12) = (/ &
        & 0.10349e+04,0.78525e+03,0.60217e+03,0.88596e+03,0.11709e+04 /)
      kbo(:, 4,55,12) = (/ &
        & 0.10361e+04,0.78465e+03,0.60184e+03,0.88512e+03,0.11696e+04 /)
      kbo(:, 5,55,12) = (/ &
        & 0.10363e+04,0.78599e+03,0.60163e+03,0.88363e+03,0.11677e+04 /)
      kbo(:, 1,56,12) = (/ &
        & 0.10361e+04,0.78599e+03,0.60309e+03,0.88918e+03,0.11774e+04 /)
      kbo(:, 2,56,12) = (/ &
        & 0.10391e+04,0.78674e+03,0.60272e+03,0.88707e+03,0.11734e+04 /)
      kbo(:, 3,56,12) = (/ &
        & 0.10363e+04,0.78584e+03,0.60228e+03,0.88626e+03,0.11716e+04 /)
      kbo(:, 4,56,12) = (/ &
        & 0.10369e+04,0.78509e+03,0.60186e+03,0.88538e+03,0.11695e+04 /)
      kbo(:, 5,56,12) = (/ &
        & 0.10363e+04,0.78554e+03,0.60158e+03,0.88421e+03,0.11682e+04 /)
      kbo(:, 1,57,12) = (/ &
        & 0.10381e+04,0.78509e+03,0.60327e+03,0.89026e+03,0.11789e+04 /)
      kbo(:, 2,57,12) = (/ &
        & 0.10344e+04,0.78852e+03,0.60284e+03,0.88747e+03,0.11744e+04 /)
      kbo(:, 3,57,12) = (/ &
        & 0.10369e+04,0.78509e+03,0.60242e+03,0.88612e+03,0.11720e+04 /)
      kbo(:, 4,57,12) = (/ &
        & 0.10393e+04,0.78330e+03,0.60216e+03,0.88561e+03,0.11703e+04 /)
      kbo(:, 5,57,12) = (/ &
        & 0.10365e+04,0.78494e+03,0.60164e+03,0.88472e+03,0.11688e+04 /)
      kbo(:, 1,58,12) = (/ &
        & 0.10353e+04,0.78509e+03,0.60357e+03,0.89125e+03,0.11802e+04 /)
      kbo(:, 2,58,12) = (/ &
        & 0.10371e+04,0.78524e+03,0.60283e+03,0.88807e+03,0.11757e+04 /)
      kbo(:, 3,58,12) = (/ &
        & 0.10365e+04,0.78718e+03,0.60278e+03,0.88669e+03,0.11726e+04 /)
      kbo(:, 4,58,12) = (/ &
        & 0.10349e+04,0.78673e+03,0.60216e+03,0.88590e+03,0.11708e+04 /)
      kbo(:, 5,58,12) = (/ &
        & 0.10365e+04,0.78389e+03,0.60170e+03,0.88506e+03,0.11695e+04 /)
      kbo(:, 1,59,12) = (/ &
        & 0.10365e+04,0.78390e+03,0.60373e+03,0.89165e+03,0.11808e+04 /)
      kbo(:, 2,59,12) = (/ &
        & 0.10369e+04,0.78479e+03,0.60298e+03,0.88840e+03,0.11763e+04 /)
      kbo(:, 3,59,12) = (/ &
        & 0.10357e+04,0.78703e+03,0.60261e+03,0.88680e+03,0.11713e+04 /)
      kbo(:, 4,59,12) = (/ &
        & 0.10363e+04,0.78509e+03,0.60219e+03,0.88602e+03,0.11708e+04 /)
      kbo(:, 5,59,12) = (/ &
        & 0.10365e+04,0.78479e+03,0.60174e+03,0.88517e+03,0.11696e+04 /)
      kbo(:, 1,13,13) = (/ &
        & 0.11661e+04,0.87073e+03,0.60556e+03,0.88929e+03,0.11761e+04 /)
      kbo(:, 2,13,13) = (/ &
        & 0.11527e+04,0.87014e+03,0.60489e+03,0.88914e+03,0.11754e+04 /)
      kbo(:, 3,13,13) = (/ &
        & 0.11423e+04,0.85968e+03,0.60419e+03,0.88867e+03,0.11747e+04 /)
      kbo(:, 4,13,13) = (/ &
        & 0.11371e+04,0.85890e+03,0.60344e+03,0.88820e+03,0.11742e+04 /)
      kbo(:, 5,13,13) = (/ &
        & 0.11390e+04,0.85008e+03,0.60234e+03,0.88705e+03,0.11727e+04 /)
      kbo(:, 1,14,13) = (/ &
        & 0.11362e+04,0.85805e+03,0.60511e+03,0.88957e+03,0.11761e+04 /)
      kbo(:, 2,14,13) = (/ &
        & 0.11276e+04,0.85398e+03,0.60448e+03,0.88893e+03,0.11753e+04 /)
      kbo(:, 3,14,13) = (/ &
        & 0.11208e+04,0.84888e+03,0.60397e+03,0.88854e+03,0.11747e+04 /)
      kbo(:, 4,14,13) = (/ &
        & 0.11194e+04,0.85006e+03,0.60305e+03,0.88823e+03,0.11740e+04 /)
      kbo(:, 5,14,13) = (/ &
        & 0.11083e+04,0.84212e+03,0.60191e+03,0.88682e+03,0.11725e+04 /)
      kbo(:, 1,15,13) = (/ &
        & 0.11142e+04,0.84766e+03,0.60488e+03,0.88941e+03,0.11748e+04 /)
      kbo(:, 2,15,13) = (/ &
        & 0.11176e+04,0.84112e+03,0.60414e+03,0.88873e+03,0.11752e+04 /)
      kbo(:, 3,15,13) = (/ &
        & 0.11051e+04,0.84191e+03,0.60348e+03,0.88843e+03,0.11747e+04 /)
      kbo(:, 4,15,13) = (/ &
        & 0.11036e+04,0.83753e+03,0.60270e+03,0.88781e+03,0.11739e+04 /)
      kbo(:, 5,15,13) = (/ &
        & 0.10935e+04,0.82883e+03,0.60139e+03,0.88658e+03,0.11723e+04 /)
      kbo(:, 1,16,13) = (/ &
        & 0.11074e+04,0.83456e+03,0.60440e+03,0.88927e+03,0.11760e+04 /)
      kbo(:, 2,16,13) = (/ &
        & 0.11018e+04,0.83298e+03,0.60385e+03,0.88856e+03,0.11751e+04 /)
      kbo(:, 3,16,13) = (/ &
        & 0.10859e+04,0.83101e+03,0.60319e+03,0.88832e+03,0.11747e+04 /)
      kbo(:, 4,16,13) = (/ &
        & 0.10925e+04,0.82836e+03,0.60254e+03,0.88762e+03,0.11738e+04 /)
      kbo(:, 5,16,13) = (/ &
        & 0.10900e+04,0.82283e+03,0.60124e+03,0.88636e+03,0.11721e+04 /)
      kbo(:, 1,17,13) = (/ &
        & 0.10953e+04,0.82596e+03,0.60413e+03,0.88915e+03,0.11759e+04 /)
      kbo(:, 2,17,13) = (/ &
        & 0.10864e+04,0.82504e+03,0.60360e+03,0.88842e+03,0.11750e+04 /)
      kbo(:, 3,17,13) = (/ &
        & 0.10812e+04,0.81898e+03,0.60295e+03,0.88822e+03,0.11746e+04 /)
      kbo(:, 4,17,13) = (/ &
        & 0.10806e+04,0.81706e+03,0.60242e+03,0.88745e+03,0.11736e+04 /)
      kbo(:, 5,17,13) = (/ &
        & 0.10764e+04,0.81771e+03,0.59943e+03,0.88638e+03,0.11722e+04 /)
      kbo(:, 1,18,13) = (/ &
        & 0.10787e+04,0.82265e+03,0.60390e+03,0.88903e+03,0.11759e+04 /)
      kbo(:, 2,18,13) = (/ &
        & 0.10743e+04,0.81466e+03,0.60339e+03,0.88738e+03,0.11749e+04 /)
      kbo(:, 3,18,13) = (/ &
        & 0.10792e+04,0.81648e+03,0.60273e+03,0.88812e+03,0.11749e+04 /)
      kbo(:, 4,18,13) = (/ &
        & 0.10724e+04,0.81516e+03,0.60185e+03,0.88728e+03,0.11735e+04 /)
      kbo(:, 5,18,13) = (/ &
        & 0.10737e+04,0.81301e+03,0.60092e+03,0.88618e+03,0.11717e+04 /)
      kbo(:, 1,19,13) = (/ &
        & 0.10778e+04,0.81646e+03,0.60388e+03,0.88893e+03,0.11758e+04 /)
      kbo(:, 2,19,13) = (/ &
        & 0.10709e+04,0.81021e+03,0.60321e+03,0.88822e+03,0.11748e+04 /)
      kbo(:, 3,19,13) = (/ &
        & 0.10651e+04,0.80945e+03,0.60254e+03,0.88803e+03,0.11745e+04 /)
      kbo(:, 4,19,13) = (/ &
        & 0.10677e+04,0.80743e+03,0.60147e+03,0.88735e+03,0.11733e+04 /)
      kbo(:, 5,19,13) = (/ &
        & 0.10575e+04,0.80245e+03,0.60072e+03,0.88575e+03,0.11721e+04 /)
      kbo(:, 1,20,13) = (/ &
        & 0.10622e+04,0.81096e+03,0.60356e+03,0.88881e+03,0.11757e+04 /)
      kbo(:, 2,20,13) = (/ &
        & 0.10607e+04,0.80739e+03,0.60305e+03,0.88816e+03,0.11748e+04 /)
      kbo(:, 3,20,13) = (/ &
        & 0.10623e+04,0.80381e+03,0.60252e+03,0.88792e+03,0.11744e+04 /)
      kbo(:, 4,20,13) = (/ &
        & 0.10570e+04,0.80456e+03,0.60093e+03,0.88695e+03,0.11731e+04 /)
      kbo(:, 5,20,13) = (/ &
        & 0.10628e+04,0.80481e+03,0.60051e+03,0.88554e+03,0.11713e+04 /)
      kbo(:, 1,21,13) = (/ &
        & 0.10564e+04,0.80721e+03,0.60326e+03,0.88869e+03,0.11756e+04 /)
      kbo(:, 2,21,13) = (/ &
        & 0.10630e+04,0.79813e+03,0.60290e+03,0.88813e+03,0.11748e+04 /)
      kbo(:, 3,21,13) = (/ &
        & 0.10553e+04,0.80228e+03,0.60219e+03,0.88781e+03,0.11743e+04 /)
      kbo(:, 4,21,13) = (/ &
        & 0.10544e+04,0.79888e+03,0.60136e+03,0.88677e+03,0.11729e+04 /)
      kbo(:, 5,21,13) = (/ &
        & 0.10596e+04,0.81049e+03,0.60032e+03,0.88532e+03,0.11710e+04 /)
      kbo(:, 1,22,13) = (/ &
        & 0.10550e+04,0.80310e+03,0.60326e+03,0.88850e+03,0.11754e+04 /)
      kbo(:, 2,22,13) = (/ &
        & 0.10516e+04,0.80380e+03,0.60256e+03,0.88810e+03,0.11747e+04 /)
      kbo(:, 3,22,13) = (/ &
        & 0.10562e+04,0.80152e+03,0.60229e+03,0.88764e+03,0.11741e+04 /)
      kbo(:, 4,22,13) = (/ &
        & 0.10509e+04,0.80224e+03,0.60002e+03,0.88651e+03,0.11726e+04 /)
      kbo(:, 5,22,13) = (/ &
        & 0.10563e+04,0.79871e+03,0.59990e+03,0.88500e+03,0.11706e+04 /)
      kbo(:, 1,23,13) = (/ &
        & 0.10567e+04,0.79860e+03,0.60326e+03,0.88832e+03,0.11752e+04 /)
      kbo(:, 2,23,13) = (/ &
        & 0.10532e+04,0.79557e+03,0.60254e+03,0.88806e+03,0.11747e+04 /)
      kbo(:, 3,23,13) = (/ &
        & 0.10534e+04,0.79512e+03,0.60237e+03,0.88744e+03,0.11739e+04 /)
      kbo(:, 4,23,13) = (/ &
        & 0.10472e+04,0.79721e+03,0.60072e+03,0.88622e+03,0.11723e+04 /)
      kbo(:, 5,23,13) = (/ &
        & 0.10509e+04,0.79423e+03,0.59964e+03,0.88466e+03,0.11702e+04 /)
      kbo(:, 1,24,13) = (/ &
        & 0.10549e+04,0.79502e+03,0.60296e+03,0.88817e+03,0.11750e+04 /)
      kbo(:, 2,24,13) = (/ &
        & 0.10498e+04,0.80428e+03,0.60221e+03,0.88799e+03,0.11746e+04 /)
      kbo(:, 3,24,13) = (/ &
        & 0.10553e+04,0.79369e+03,0.60149e+03,0.88721e+03,0.11736e+04 /)
      kbo(:, 4,24,13) = (/ &
        & 0.10517e+04,0.79240e+03,0.60048e+03,0.88592e+03,0.11719e+04 /)
      kbo(:, 5,24,13) = (/ &
        & 0.10493e+04,0.79281e+03,0.59936e+03,0.88429e+03,0.11697e+04 /)
      kbo(:, 1,25,13) = (/ &
        & 0.10472e+04,0.79884e+03,0.60281e+03,0.88760e+03,0.11748e+04 /)
      kbo(:, 2,25,13) = (/ &
        & 0.10433e+04,0.79261e+03,0.60217e+03,0.88787e+03,0.11745e+04 /)
      kbo(:, 3,25,13) = (/ &
        & 0.10495e+04,0.79568e+03,0.60138e+03,0.88696e+03,0.11733e+04 /)
      kbo(:, 4,25,13) = (/ &
        & 0.10412e+04,0.79264e+03,0.60023e+03,0.88559e+03,0.11715e+04 /)
      kbo(:, 5,25,13) = (/ &
        & 0.10432e+04,0.79682e+03,0.59908e+03,0.88390e+03,0.11692e+04 /)
      kbo(:, 1,26,13) = (/ &
        & 0.10426e+04,0.79538e+03,0.60266e+03,0.88804e+03,0.11748e+04 /)
      kbo(:, 2,26,13) = (/ &
        & 0.10459e+04,0.79909e+03,0.60196e+03,0.88771e+03,0.11743e+04 /)
      kbo(:, 3,26,13) = (/ &
        & 0.10455e+04,0.79078e+03,0.60113e+03,0.88666e+03,0.11729e+04 /)
      kbo(:, 4,26,13) = (/ &
        & 0.10380e+04,0.79069e+03,0.60011e+03,0.88521e+03,0.11710e+04 /)
      kbo(:, 5,26,13) = (/ &
        & 0.10428e+04,0.79124e+03,0.59892e+03,0.88345e+03,0.11686e+04 /)
      kbo(:, 1,27,13) = (/ &
        & 0.10409e+04,0.79057e+03,0.60249e+03,0.88802e+03,0.11747e+04 /)
      kbo(:, 2,27,13) = (/ &
        & 0.10432e+04,0.78863e+03,0.60172e+03,0.88750e+03,0.11740e+04 /)
      kbo(:, 3,27,13) = (/ &
        & 0.10404e+04,0.79041e+03,0.60057e+03,0.88634e+03,0.11728e+04 /)
      kbo(:, 4,27,13) = (/ &
        & 0.10425e+04,0.78854e+03,0.59967e+03,0.88481e+03,0.11704e+04 /)
      kbo(:, 5,27,13) = (/ &
        & 0.10492e+04,0.78874e+03,0.59843e+03,0.88297e+03,0.11680e+04 /)
      kbo(:, 1,28,13) = (/ &
        & 0.10434e+04,0.79273e+03,0.60231e+03,0.88820e+03,0.11747e+04 /)
      kbo(:, 2,28,13) = (/ &
        & 0.10472e+04,0.78799e+03,0.60162e+03,0.88726e+03,0.11737e+04 /)
      kbo(:, 3,28,13) = (/ &
        & 0.10366e+04,0.79125e+03,0.60032e+03,0.88600e+03,0.11720e+04 /)
      kbo(:, 4,28,13) = (/ &
        & 0.10345e+04,0.78841e+03,0.59938e+03,0.88440e+03,0.11699e+04 /)
      kbo(:, 5,28,13) = (/ &
        & 0.10534e+04,0.78866e+03,0.59808e+03,0.88245e+03,0.11673e+04 /)
      kbo(:, 1,29,13) = (/ &
        & 0.10524e+04,0.78934e+03,0.60181e+03,0.88786e+03,0.11745e+04 /)
      kbo(:, 2,29,13) = (/ &
        & 0.10481e+04,0.78588e+03,0.60321e+03,0.88698e+03,0.11734e+04 /)
      kbo(:, 3,29,13) = (/ &
        & 0.10466e+04,0.79266e+03,0.60021e+03,0.88562e+03,0.11715e+04 /)
      kbo(:, 4,29,13) = (/ &
        & 0.10466e+04,0.79965e+03,0.59906e+03,0.88395e+03,0.11693e+04 /)
      kbo(:, 5,29,13) = (/ &
        & 0.10459e+04,0.78993e+03,0.59799e+03,0.88185e+03,0.11668e+04 /)
      kbo(:, 1,30,13) = (/ &
        & 0.10360e+04,0.78916e+03,0.60191e+03,0.88770e+03,0.11743e+04 /)
      kbo(:, 2,30,13) = (/ &
        & 0.10409e+04,0.78411e+03,0.60093e+03,0.88667e+03,0.11729e+04 /)
      kbo(:, 3,30,13) = (/ &
        & 0.10391e+04,0.79193e+03,0.59993e+03,0.88546e+03,0.11710e+04 /)
      kbo(:, 4,30,13) = (/ &
        & 0.10409e+04,0.78876e+03,0.59874e+03,0.88348e+03,0.11687e+04 /)
      kbo(:, 5,30,13) = (/ &
        & 0.10396e+04,0.78722e+03,0.59722e+03,0.88117e+03,0.11665e+04 /)
      kbo(:, 1,31,13) = (/ &
        & 0.10394e+04,0.79419e+03,0.60167e+03,0.88749e+03,0.11740e+04 /)
      kbo(:, 2,31,13) = (/ &
        & 0.10363e+04,0.79203e+03,0.60068e+03,0.88633e+03,0.11725e+04 /)
      kbo(:, 3,31,13) = (/ &
        & 0.10437e+04,0.78663e+03,0.59963e+03,0.88481e+03,0.11705e+04 /)
      kbo(:, 4,31,13) = (/ &
        & 0.10406e+04,0.79000e+03,0.59839e+03,0.88297e+03,0.11680e+04 /)
      kbo(:, 5,31,13) = (/ &
        & 0.10413e+04,0.79093e+03,0.59674e+03,0.88044e+03,0.11650e+04 /)
      kbo(:, 1,32,13) = (/ &
        & 0.10440e+04,0.79014e+03,0.60327e+03,0.88723e+03,0.11737e+04 /)
      kbo(:, 2,32,13) = (/ &
        & 0.10391e+04,0.79106e+03,0.60042e+03,0.88596e+03,0.11720e+04 /)
      kbo(:, 3,32,13) = (/ &
        & 0.10467e+04,0.78955e+03,0.59932e+03,0.88436e+03,0.11699e+04 /)
      kbo(:, 4,32,13) = (/ &
        & 0.10407e+04,0.79722e+03,0.59818e+03,0.88241e+03,0.11673e+04 /)
      kbo(:, 5,32,13) = (/ &
        & 0.10382e+04,0.78961e+03,0.59626e+03,0.87980e+03,0.11639e+04 /)
      kbo(:, 1,33,13) = (/ &
        & 0.10522e+04,0.78494e+03,0.60081e+03,0.88693e+03,0.11733e+04 /)
      kbo(:, 2,33,13) = (/ &
        & 0.10373e+04,0.79220e+03,0.59999e+03,0.88557e+03,0.11715e+04 /)
      kbo(:, 3,33,13) = (/ &
        & 0.10359e+04,0.78622e+03,0.59900e+03,0.88389e+03,0.11695e+04 /)
      kbo(:, 4,33,13) = (/ &
        & 0.10377e+04,0.78474e+03,0.59760e+03,0.88177e+03,0.11667e+04 /)
      kbo(:, 5,33,13) = (/ &
        & 0.10406e+04,0.78876e+03,0.59580e+03,0.87933e+03,0.11633e+04 /)
      kbo(:, 1,34,13) = (/ &
        & 0.10360e+04,0.79366e+03,0.60074e+03,0.88666e+03,0.11729e+04 /)
      kbo(:, 2,34,13) = (/ &
        & 0.10445e+04,0.78362e+03,0.59974e+03,0.88521e+03,0.11710e+04 /)
      kbo(:, 3,34,13) = (/ &
        & 0.10445e+04,0.78784e+03,0.59871e+03,0.88346e+03,0.11687e+04 /)
      kbo(:, 4,34,13) = (/ &
        & 0.10420e+04,0.78840e+03,0.59718e+03,0.88091e+03,0.11665e+04 /)
      kbo(:, 5,34,13) = (/ &
        & 0.10384e+04,0.79182e+03,0.59540e+03,0.87927e+03,0.11620e+04 /)
      kbo(:, 1,35,13) = (/ &
        & 0.10422e+04,0.79326e+03,0.60077e+03,0.88648e+03,0.11727e+04 /)
      kbo(:, 2,35,13) = (/ &
        & 0.10360e+04,0.79158e+03,0.59975e+03,0.88500e+03,0.11707e+04 /)
      kbo(:, 3,35,13) = (/ &
        & 0.10370e+04,0.78869e+03,0.59854e+03,0.88320e+03,0.11683e+04 /)
      kbo(:, 4,35,13) = (/ &
        & 0.10364e+04,0.79354e+03,0.59694e+03,0.88077e+03,0.11651e+04 /)
      kbo(:, 5,35,13) = (/ &
        & 0.10369e+04,0.78943e+03,0.59473e+03,0.87892e+03,0.11616e+04 /)
      kbo(:, 1,36,13) = (/ &
        & 0.10401e+04,0.78191e+03,0.60075e+03,0.88645e+03,0.11727e+04 /)
      kbo(:, 2,36,13) = (/ &
        & 0.10371e+04,0.78614e+03,0.59972e+03,0.88519e+03,0.11707e+04 /)
      kbo(:, 3,36,13) = (/ &
        & 0.10392e+04,0.78550e+03,0.59835e+03,0.88339e+03,0.11683e+04 /)
      kbo(:, 4,36,13) = (/ &
        & 0.10378e+04,0.78649e+03,0.59690e+03,0.88071e+03,0.11650e+04 /)
      kbo(:, 5,36,13) = (/ &
        & 0.10389e+04,0.79012e+03,0.59516e+03,0.87821e+03,0.11604e+04 /)
      kbo(:, 1,37,13) = (/ &
        & 0.10397e+04,0.78790e+03,0.60071e+03,0.88662e+03,0.11729e+04 /)
      kbo(:, 2,37,13) = (/ &
        & 0.10413e+04,0.78135e+03,0.59986e+03,0.88540e+03,0.11710e+04 /)
      kbo(:, 3,37,13) = (/ &
        & 0.10434e+04,0.78885e+03,0.59867e+03,0.88341e+03,0.11686e+04 /)
      kbo(:, 4,37,13) = (/ &
        & 0.10382e+04,0.79636e+03,0.59698e+03,0.88108e+03,0.11655e+04 /)
      kbo(:, 5,37,13) = (/ &
        & 0.10369e+04,0.78656e+03,0.59536e+03,0.87879e+03,0.11626e+04 /)
      kbo(:, 1,38,13) = (/ &
        & 0.10433e+04,0.78475e+03,0.60099e+03,0.88680e+03,0.11731e+04 /)
      kbo(:, 2,38,13) = (/ &
        & 0.10422e+04,0.78187e+03,0.60001e+03,0.88539e+03,0.11713e+04 /)
      kbo(:, 3,38,13) = (/ &
        & 0.10376e+04,0.78470e+03,0.59854e+03,0.88368e+03,0.11690e+04 /)
      kbo(:, 4,38,13) = (/ &
        & 0.10379e+04,0.78467e+03,0.59739e+03,0.88147e+03,0.11660e+04 /)
      kbo(:, 5,38,13) = (/ &
        & 0.10346e+04,0.79279e+03,0.59559e+03,0.87849e+03,0.11631e+04 /)
      kbo(:, 1,39,13) = (/ &
        & 0.10564e+04,0.79016e+03,0.60113e+03,0.88696e+03,0.11734e+04 /)
      kbo(:, 2,39,13) = (/ &
        & 0.10405e+04,0.78139e+03,0.59938e+03,0.88561e+03,0.11715e+04 /)
      kbo(:, 3,39,13) = (/ &
        & 0.10386e+04,0.79256e+03,0.59902e+03,0.88393e+03,0.11693e+04 /)
      kbo(:, 4,39,13) = (/ &
        & 0.10351e+04,0.78501e+03,0.59779e+03,0.88184e+03,0.11668e+04 /)
      kbo(:, 5,39,13) = (/ &
        & 0.10353e+04,0.78561e+03,0.59583e+03,0.87937e+03,0.11634e+04 /)
      kbo(:, 1,40,13) = (/ &
        & 0.10351e+04,0.78501e+03,0.60325e+03,0.88723e+03,0.11737e+04 /)
      kbo(:, 2,40,13) = (/ &
        & 0.10332e+04,0.78519e+03,0.60040e+03,0.88596e+03,0.11720e+04 /)
      kbo(:, 3,40,13) = (/ &
        & 0.10393e+04,0.78843e+03,0.59931e+03,0.88436e+03,0.11699e+04 /)
      kbo(:, 4,40,13) = (/ &
        & 0.10339e+04,0.78821e+03,0.59801e+03,0.88242e+03,0.11676e+04 /)
      kbo(:, 5,40,13) = (/ &
        & 0.10476e+04,0.78616e+03,0.59626e+03,0.87958e+03,0.11639e+04 /)
      kbo(:, 1,41,13) = (/ &
        & 0.10420e+04,0.78658e+03,0.60226e+03,0.88748e+03,0.11740e+04 /)
      kbo(:, 2,41,13) = (/ &
        & 0.10471e+04,0.78433e+03,0.60065e+03,0.88632e+03,0.11725e+04 /)
      kbo(:, 3,41,13) = (/ &
        & 0.10385e+04,0.78777e+03,0.59960e+03,0.88480e+03,0.11705e+04 /)
      kbo(:, 4,41,13) = (/ &
        & 0.10374e+04,0.79305e+03,0.59837e+03,0.88319e+03,0.11680e+04 /)
      kbo(:, 5,41,13) = (/ &
        & 0.10341e+04,0.79121e+03,0.59671e+03,0.88067e+03,0.11641e+04 /)
      kbo(:, 1,42,13) = (/ &
        & 0.10427e+04,0.78654e+03,0.60202e+03,0.88768e+03,0.11743e+04 /)
      kbo(:, 2,42,13) = (/ &
        & 0.10376e+04,0.78774e+03,0.60073e+03,0.88666e+03,0.11730e+04 /)
      kbo(:, 3,42,13) = (/ &
        & 0.10387e+04,0.78631e+03,0.59989e+03,0.88522e+03,0.11710e+04 /)
      kbo(:, 4,42,13) = (/ &
        & 0.10432e+04,0.79240e+03,0.59870e+03,0.88347e+03,0.11690e+04 /)
      kbo(:, 5,42,13) = (/ &
        & 0.10408e+04,0.78283e+03,0.59718e+03,0.88116e+03,0.11677e+04 /)
      kbo(:, 1,43,13) = (/ &
        & 0.10384e+04,0.78732e+03,0.60211e+03,0.88787e+03,0.11746e+04 /)
      kbo(:, 2,43,13) = (/ &
        & 0.10392e+04,0.79483e+03,0.60103e+03,0.88703e+03,0.11735e+04 /)
      kbo(:, 3,43,13) = (/ &
        & 0.10435e+04,0.79279e+03,0.60022e+03,0.88570e+03,0.11717e+04 /)
      kbo(:, 4,43,13) = (/ &
        & 0.10453e+04,0.78261e+03,0.59909e+03,0.88405e+03,0.11698e+04 /)
      kbo(:, 5,43,13) = (/ &
        & 0.10349e+04,0.78239e+03,0.59773e+03,0.88200e+03,0.11670e+04 /)
      kbo(:, 1,44,13) = (/ &
        & 0.10376e+04,0.78973e+03,0.60218e+03,0.88797e+03,0.11747e+04 /)
      kbo(:, 2,44,13) = (/ &
        & 0.10357e+04,0.79073e+03,0.60154e+03,0.88738e+03,0.11742e+04 /)
      kbo(:, 3,44,13) = (/ &
        & 0.10381e+04,0.78584e+03,0.60056e+03,0.88619e+03,0.11723e+04 /)
      kbo(:, 4,44,13) = (/ &
        & 0.10410e+04,0.78726e+03,0.59965e+03,0.88464e+03,0.11703e+04 /)
      kbo(:, 5,44,13) = (/ &
        & 0.10370e+04,0.78461e+03,0.59824e+03,0.88299e+03,0.11677e+04 /)
      kbo(:, 1,45,13) = (/ &
        & 0.10383e+04,0.78177e+03,0.60254e+03,0.88799e+03,0.11748e+04 /)
      kbo(:, 2,45,13) = (/ &
        & 0.10337e+04,0.78400e+03,0.60200e+03,0.88790e+03,0.11743e+04 /)
      kbo(:, 3,45,13) = (/ &
        & 0.10407e+04,0.78928e+03,0.60087e+03,0.88664e+03,0.11732e+04 /)
      kbo(:, 4,45,13) = (/ &
        & 0.10410e+04,0.79578e+03,0.59987e+03,0.88519e+03,0.11713e+04 /)
      kbo(:, 5,45,13) = (/ &
        & 0.10369e+04,0.78337e+03,0.59884e+03,0.88344e+03,0.11687e+04 /)
      kbo(:, 1,46,13) = (/ &
        & 0.10415e+04,0.79090e+03,0.60272e+03,0.88805e+03,0.11749e+04 /)
      kbo(:, 2,46,13) = (/ &
        & 0.10332e+04,0.79374e+03,0.60213e+03,0.88788e+03,0.11746e+04 /)
      kbo(:, 3,46,13) = (/ &
        & 0.10495e+04,0.78743e+03,0.60122e+03,0.88707e+03,0.11738e+04 /)
      kbo(:, 4,46,13) = (/ &
        & 0.10359e+04,0.78275e+03,0.60025e+03,0.88575e+03,0.11717e+04 /)
      kbo(:, 5,46,13) = (/ &
        & 0.10407e+04,0.79210e+03,0.59913e+03,0.88411e+03,0.11695e+04 /)
      kbo(:, 1,47,13) = (/ &
        & 0.10396e+04,0.78478e+03,0.60291e+03,0.88833e+03,0.11753e+04 /)
      kbo(:, 2,47,13) = (/ &
        & 0.10391e+04,0.78254e+03,0.60239e+03,0.88798e+03,0.11747e+04 /)
      kbo(:, 3,47,13) = (/ &
        & 0.10358e+04,0.79087e+03,0.60194e+03,0.88748e+03,0.11740e+04 /)
      kbo(:, 4,47,13) = (/ &
        & 0.10382e+04,0.78212e+03,0.60065e+03,0.88632e+03,0.11725e+04 /)
      kbo(:, 5,47,13) = (/ &
        & 0.10417e+04,0.78639e+03,0.59976e+03,0.88480e+03,0.11705e+04 /)
      kbo(:, 1,48,13) = (/ &
        & 0.10401e+04,0.78456e+03,0.60307e+03,0.88865e+03,0.11757e+04 /)
      kbo(:, 2,48,13) = (/ &
        & 0.10385e+04,0.78639e+03,0.60262e+03,0.88799e+03,0.11748e+04 /)
      kbo(:, 3,48,13) = (/ &
        & 0.10377e+04,0.78374e+03,0.60183e+03,0.88778e+03,0.11745e+04 /)
      kbo(:, 4,48,13) = (/ &
        & 0.10347e+04,0.78455e+03,0.60102e+03,0.88707e+03,0.11732e+04 /)
      kbo(:, 5,48,13) = (/ &
        & 0.10420e+04,0.79085e+03,0.60005e+03,0.88545e+03,0.11713e+04 /)
      kbo(:, 1,49,13) = (/ &
        & 0.10372e+04,0.78740e+03,0.60317e+03,0.88862e+03,0.11760e+04 /)
      kbo(:, 2,49,13) = (/ &
        & 0.10417e+04,0.78862e+03,0.60282e+03,0.88818e+03,0.11751e+04 /)
      kbo(:, 3,49,13) = (/ &
        & 0.10345e+04,0.78780e+03,0.60227e+03,0.88818e+03,0.11747e+04 /)
      kbo(:, 4,49,13) = (/ &
        & 0.10406e+04,0.78617e+03,0.60221e+03,0.88729e+03,0.11738e+04 /)
      kbo(:, 5,49,13) = (/ &
        & 0.10382e+04,0.79023e+03,0.60061e+03,0.88605e+03,0.11721e+04 /)
      kbo(:, 1,50,13) = (/ &
        & 0.10347e+04,0.79207e+03,0.60367e+03,0.88900e+03,0.11761e+04 /)
      kbo(:, 2,50,13) = (/ &
        & 0.10350e+04,0.78739e+03,0.60298e+03,0.88872e+03,0.11755e+04 /)
      kbo(:, 3,50,13) = (/ &
        & 0.10353e+04,0.78433e+03,0.60234e+03,0.88799e+03,0.11744e+04 /)
      kbo(:, 4,50,13) = (/ &
        & 0.10489e+04,0.79267e+03,0.60164e+03,0.88763e+03,0.11743e+04 /)
      kbo(:, 5,50,13) = (/ &
        & 0.10406e+04,0.78514e+03,0.60019e+03,0.88656e+03,0.11728e+04 /)
      kbo(:, 1,51,13) = (/ &
        & 0.10345e+04,0.78799e+03,0.60398e+03,0.88932e+03,0.11765e+04 /)
      kbo(:, 2,51,13) = (/ &
        & 0.10401e+04,0.78697e+03,0.60314e+03,0.88874e+03,0.11758e+04 /)
      kbo(:, 3,51,13) = (/ &
        & 0.10366e+04,0.78656e+03,0.60285e+03,0.88803e+03,0.11749e+04 /)
      kbo(:, 4,51,13) = (/ &
        & 0.10374e+04,0.78473e+03,0.60240e+03,0.88809e+03,0.11746e+04 /)
      kbo(:, 5,51,13) = (/ &
        & 0.10390e+04,0.78920e+03,0.60116e+03,0.88701e+03,0.11734e+04 /)
      kbo(:, 1,52,13) = (/ &
        & 0.10369e+04,0.78758e+03,0.60425e+03,0.88974e+03,0.11770e+04 /)
      kbo(:, 2,52,13) = (/ &
        & 0.10369e+04,0.78229e+03,0.60357e+03,0.88889e+03,0.11760e+04 /)
      kbo(:, 3,52,13) = (/ &
        & 0.10371e+04,0.78737e+03,0.60287e+03,0.88826e+03,0.11752e+04 /)
      kbo(:, 4,52,13) = (/ &
        & 0.10414e+04,0.78574e+03,0.60234e+03,0.88797e+03,0.11747e+04 /)
      kbo(:, 5,52,13) = (/ &
        & 0.10377e+04,0.78696e+03,0.60170e+03,0.88739e+03,0.11739e+04 /)
      kbo(:, 1,53,13) = (/ &
        & 0.10446e+04,0.78533e+03,0.60451e+03,0.89022e+03,0.11778e+04 /)
      kbo(:, 2,53,13) = (/ &
        & 0.10366e+04,0.78675e+03,0.60391e+03,0.88907e+03,0.11762e+04 /)
      kbo(:, 3,53,13) = (/ &
        & 0.10339e+04,0.78472e+03,0.60302e+03,0.88857e+03,0.11756e+04 /)
      kbo(:, 4,53,13) = (/ &
        & 0.10347e+04,0.78858e+03,0.60271e+03,0.88799e+03,0.11748e+04 /)
      kbo(:, 5,53,13) = (/ &
        & 0.10414e+04,0.78370e+03,0.60188e+03,0.88770e+03,0.11743e+04 /)
      kbo(:, 1,54,13) = (/ &
        & 0.10366e+04,0.78980e+03,0.60463e+03,0.89072e+03,0.11788e+04 /)
      kbo(:, 2,54,13) = (/ &
        & 0.10376e+04,0.78289e+03,0.60402e+03,0.88939e+03,0.11765e+04 /)
      kbo(:, 3,54,13) = (/ &
        & 0.10387e+04,0.78695e+03,0.60318e+03,0.88877e+03,0.11759e+04 /)
      kbo(:, 4,54,13) = (/ &
        & 0.10435e+04,0.78370e+03,0.60273e+03,0.88806e+03,0.11749e+04 /)
      kbo(:, 5,54,13) = (/ &
        & 0.10492e+04,0.79000e+03,0.60214e+03,0.88789e+03,0.11746e+04 /)
      kbo(:, 1,55,13) = (/ &
        & 0.10395e+04,0.78654e+03,0.60524e+03,0.89136e+03,0.11799e+04 /)
      kbo(:, 2,55,13) = (/ &
        & 0.10379e+04,0.78553e+03,0.60426e+03,0.88977e+03,0.11770e+04 /)
      kbo(:, 3,55,13) = (/ &
        & 0.10376e+04,0.78959e+03,0.60343e+03,0.88890e+03,0.11757e+04 /)
      kbo(:, 4,55,13) = (/ &
        & 0.10360e+04,0.78634e+03,0.60272e+03,0.88828e+03,0.11752e+04 /)
      kbo(:, 5,55,13) = (/ &
        & 0.10355e+04,0.78796e+03,0.60219e+03,0.88821e+03,0.11747e+04 /)
      kbo(:, 1,56,13) = (/ &
        & 0.10500e+04,0.78471e+03,0.60540e+03,0.89210e+03,0.11812e+04 /)
      kbo(:, 2,56,13) = (/ &
        & 0.10441e+04,0.78735e+03,0.60449e+03,0.89019e+03,0.11777e+04 /)
      kbo(:, 3,56,13) = (/ &
        & 0.10382e+04,0.78755e+03,0.60374e+03,0.88905e+03,0.11759e+04 /)
      kbo(:, 4,56,13) = (/ &
        & 0.10470e+04,0.78715e+03,0.60301e+03,0.88855e+03,0.11756e+04 /)
      kbo(:, 5,56,13) = (/ &
        & 0.10358e+04,0.78674e+03,0.60270e+03,0.88799e+03,0.11748e+04 /)
      kbo(:, 1,57,13) = (/ &
        & 0.10339e+04,0.78715e+03,0.60588e+03,0.89295e+03,0.11828e+04 /)
      kbo(:, 2,57,13) = (/ &
        & 0.10441e+04,0.78267e+03,0.60475e+03,0.89065e+03,0.11787e+04 /)
      kbo(:, 3,57,13) = (/ &
        & 0.10435e+04,0.78938e+03,0.60399e+03,0.88934e+03,0.11765e+04 /)
      kbo(:, 4,57,13) = (/ &
        & 0.10392e+04,0.79203e+03,0.60300e+03,0.88875e+03,0.11758e+04 /)
      kbo(:, 5,57,13) = (/ &
        & 0.10360e+04,0.78491e+03,0.60271e+03,0.88827e+03,0.11749e+04 /)
      kbo(:, 1,58,13) = (/ &
        & 0.10392e+04,0.78430e+03,0.60601e+03,0.89398e+03,0.11847e+04 /)
      kbo(:, 2,58,13) = (/ &
        & 0.10363e+04,0.78694e+03,0.60503e+03,0.89124e+03,0.11797e+04 /)
      kbo(:, 3,58,13) = (/ &
        & 0.10360e+04,0.78084e+03,0.60391e+03,0.88970e+03,0.11769e+04 /)
      kbo(:, 4,58,13) = (/ &
        & 0.10459e+04,0.78267e+03,0.60338e+03,0.88888e+03,0.11757e+04 /)
      kbo(:, 5,58,13) = (/ &
        & 0.10368e+04,0.79101e+03,0.60285e+03,0.88823e+03,0.11752e+04 /)
      kbo(:, 1,59,13) = (/ &
        & 0.10403e+04,0.78613e+03,0.60612e+03,0.89444e+03,0.11849e+04 /)
      kbo(:, 2,59,13) = (/ &
        & 0.10349e+04,0.78531e+03,0.60514e+03,0.89150e+03,0.11802e+04 /)
      kbo(:, 3,59,13) = (/ &
        & 0.10360e+04,0.78470e+03,0.60447e+03,0.88985e+03,0.11771e+04 /)
      kbo(:, 4,59,13) = (/ &
        & 0.10411e+04,0.78531e+03,0.60349e+03,0.88892e+03,0.11761e+04 /)
      kbo(:, 5,59,13) = (/ &
        & 0.10355e+04,0.78795e+03,0.60275e+03,0.88833e+03,0.11753e+04 /)
      kbo(:, 1,13,14) = (/ &
        & 0.12194e+04,0.91192e+03,0.60649e+03,0.89289e+03,0.11803e+04 /)
      kbo(:, 2,13,14) = (/ &
        & 0.11340e+04,0.93388e+03,0.60565e+03,0.89163e+03,0.11786e+04 /)
      kbo(:, 3,13,14) = (/ &
        & 0.11287e+04,0.93154e+03,0.60510e+03,0.89077e+03,0.11775e+04 /)
      kbo(:, 4,13,14) = (/ &
        & 0.11571e+04,0.89198e+03,0.60383e+03,0.88977e+03,0.11762e+04 /)
      kbo(:, 5,13,14) = (/ &
        & 0.11232e+04,0.85932e+03,0.60280e+03,0.88865e+03,0.11748e+04 /)
      kbo(:, 1,14,14) = (/ &
        & 0.11313e+04,0.85574e+03,0.60604e+03,0.89259e+03,0.11800e+04 /)
      kbo(:, 2,14,14) = (/ &
        & 0.11392e+04,0.85278e+03,0.60523e+03,0.89143e+03,0.11785e+04 /)
      kbo(:, 3,14,14) = (/ &
        & 0.11402e+04,0.86846e+03,0.60420e+03,0.89055e+03,0.11774e+04 /)
      kbo(:, 4,14,14) = (/ &
        & 0.11058e+04,0.85128e+03,0.60339e+03,0.88920e+03,0.11761e+04 /)
      kbo(:, 5,14,14) = (/ &
        & 0.11286e+04,0.84325e+03,0.60241e+03,0.88842e+03,0.11746e+04 /)
      kbo(:, 1,15,14) = (/ &
        & 0.11349e+04,0.84417e+03,0.60541e+03,0.89231e+03,0.11798e+04 /)
      kbo(:, 2,15,14) = (/ &
        & 0.11015e+04,0.88045e+03,0.60487e+03,0.89125e+03,0.11784e+04 /)
      kbo(:, 3,15,14) = (/ &
        & 0.11261e+04,0.83776e+03,0.60408e+03,0.89034e+03,0.11772e+04 /)
      kbo(:, 4,15,14) = (/ &
        & 0.10962e+04,0.86597e+03,0.60302e+03,0.88937e+03,0.11760e+04 /)
      kbo(:, 5,15,14) = (/ &
        & 0.10995e+04,0.86095e+03,0.60207e+03,0.88855e+03,0.11740e+04 /)
      kbo(:, 1,16,14) = (/ &
        & 0.11556e+04,0.89943e+03,0.60533e+03,0.89241e+03,0.11796e+04 /)
      kbo(:, 2,16,14) = (/ &
        & 0.10928e+04,0.87845e+03,0.60456e+03,0.89108e+03,0.11783e+04 /)
      kbo(:, 3,16,14) = (/ &
        & 0.11526e+04,0.84568e+03,0.60375e+03,0.89014e+03,0.11771e+04 /)
      kbo(:, 4,16,14) = (/ &
        & 0.11224e+04,0.82958e+03,0.60245e+03,0.88919e+03,0.11758e+04 /)
      kbo(:, 5,16,14) = (/ &
        & 0.11104e+04,0.83492e+03,0.60177e+03,0.88796e+03,0.11747e+04 /)
      kbo(:, 1,17,14) = (/ &
        & 0.11093e+04,0.86391e+03,0.60505e+03,0.89183e+03,0.11794e+04 /)
      kbo(:, 2,17,14) = (/ &
        & 0.10879e+04,0.83992e+03,0.60455e+03,0.89093e+03,0.11782e+04 /)
      kbo(:, 3,17,14) = (/ &
        & 0.11180e+04,0.83675e+03,0.60345e+03,0.88997e+03,0.11769e+04 /)
      kbo(:, 4,17,14) = (/ &
        & 0.11203e+04,0.81299e+03,0.60195e+03,0.88902e+03,0.11757e+04 /)
      kbo(:, 5,17,14) = (/ &
        & 0.10902e+04,0.84755e+03,0.60151e+03,0.88739e+03,0.11736e+04 /)
      kbo(:, 1,18,14) = (/ &
        & 0.10889e+04,0.82171e+03,0.60482e+03,0.89199e+03,0.11792e+04 /)
      kbo(:, 2,18,14) = (/ &
        & 0.10836e+04,0.85518e+03,0.60408e+03,0.89079e+03,0.11781e+04 /)
      kbo(:, 3,18,14) = (/ &
        & 0.10919e+04,0.82437e+03,0.60318e+03,0.88981e+03,0.11763e+04 /)
      kbo(:, 4,18,14) = (/ &
        & 0.11143e+04,0.86811e+03,0.60223e+03,0.88886e+03,0.11755e+04 /)
      kbo(:, 5,18,14) = (/ &
        & 0.10618e+04,0.80694e+03,0.60104e+03,0.88718e+03,0.11738e+04 /)
      kbo(:, 1,19,14) = (/ &
        & 0.10700e+04,0.81179e+03,0.60437e+03,0.89145e+03,0.11790e+04 /)
      kbo(:, 2,19,14) = (/ &
        & 0.11096e+04,0.84185e+03,0.60389e+03,0.89066e+03,0.11785e+04 /)
      kbo(:, 3,19,14) = (/ &
        & 0.10919e+04,0.82575e+03,0.60295e+03,0.89004e+03,0.11767e+04 /)
      kbo(:, 4,19,14) = (/ &
        & 0.10874e+04,0.81974e+03,0.60205e+03,0.88835e+03,0.11754e+04 /)
      kbo(:, 5,19,14) = (/ &
        & 0.11077e+04,0.86723e+03,0.60084e+03,0.88734e+03,0.11727e+04 /)
      kbo(:, 1,20,14) = (/ &
        & 0.10813e+04,0.82037e+03,0.60443e+03,0.89128e+03,0.11789e+04 /)
      kbo(:, 2,20,14) = (/ &
        & 0.10944e+04,0.83718e+03,0.60369e+03,0.89052e+03,0.11778e+04 /)
      kbo(:, 3,20,14) = (/ &
        & 0.10922e+04,0.81527e+03,0.60248e+03,0.88953e+03,0.11765e+04 /)
      kbo(:, 4,20,14) = (/ &
        & 0.10962e+04,0.82815e+03,0.60188e+03,0.88854e+03,0.11752e+04 /)
      kbo(:, 5,20,14) = (/ &
        & 0.10768e+04,0.81150e+03,0.60064e+03,0.88711e+03,0.11734e+04 /)
      kbo(:, 1,21,14) = (/ &
        & 0.10919e+04,0.79941e+03,0.60426e+03,0.89114e+03,0.11787e+04 /)
      kbo(:, 2,21,14) = (/ &
        & 0.10481e+04,0.83111e+03,0.60351e+03,0.89037e+03,0.11777e+04 /)
      kbo(:, 3,21,14) = (/ &
        & 0.10716e+04,0.81475e+03,0.60253e+03,0.88975e+03,0.11764e+04 /)
      kbo(:, 4,21,14) = (/ &
        & 0.11197e+04,0.80344e+03,0.60123e+03,0.88837e+03,0.11750e+04 /)
      kbo(:, 5,21,14) = (/ &
        & 0.10436e+04,0.80977e+03,0.60045e+03,0.88688e+03,0.11731e+04 /)
      kbo(:, 1,22,14) = (/ &
        & 0.11028e+04,0.82019e+03,0.60406e+03,0.89099e+03,0.11785e+04 /)
      kbo(:, 2,22,14) = (/ &
        & 0.10664e+04,0.84127e+03,0.60327e+03,0.89089e+03,0.11775e+04 /)
      kbo(:, 3,22,14) = (/ &
        & 0.10764e+04,0.83101e+03,0.60182e+03,0.88920e+03,0.11762e+04 /)
      kbo(:, 4,22,14) = (/ &
        & 0.10955e+04,0.82928e+03,0.60175e+03,0.88811e+03,0.11747e+04 /)
      kbo(:, 5,22,14) = (/ &
        & 0.10429e+04,0.82150e+03,0.60042e+03,0.88653e+03,0.11726e+04 /)
      kbo(:, 1,23,14) = (/ &
        & 0.10449e+04,0.79677e+03,0.60363e+03,0.89084e+03,0.11784e+04 /)
      kbo(:, 2,23,14) = (/ &
        & 0.10443e+04,0.81477e+03,0.60352e+03,0.88994e+03,0.11772e+04 /)
      kbo(:, 3,23,14) = (/ &
        & 0.10490e+04,0.84026e+03,0.60112e+03,0.88900e+03,0.11759e+04 /)
      kbo(:, 4,23,14) = (/ &
        & 0.10652e+04,0.80737e+03,0.60128e+03,0.88783e+03,0.11744e+04 /)
      kbo(:, 5,23,14) = (/ &
        & 0.10777e+04,0.80975e+03,0.60014e+03,0.88615e+03,0.11722e+04 /)
      kbo(:, 1,24,14) = (/ &
        & 0.10587e+04,0.83370e+03,0.60369e+03,0.89067e+03,0.11782e+04 /)
      kbo(:, 2,24,14) = (/ &
        & 0.10413e+04,0.79049e+03,0.60278e+03,0.88972e+03,0.11769e+04 /)
      kbo(:, 3,24,14) = (/ &
        & 0.10508e+04,0.83928e+03,0.60192e+03,0.88879e+03,0.11757e+04 /)
      kbo(:, 4,24,14) = (/ &
        & 0.10667e+04,0.80304e+03,0.60105e+03,0.88752e+03,0.11740e+04 /)
      kbo(:, 5,24,14) = (/ &
        & 0.10776e+04,0.78685e+03,0.59985e+03,0.88574e+03,0.11716e+04 /)
      kbo(:, 1,25,14) = (/ &
        & 0.10559e+04,0.78648e+03,0.60348e+03,0.89048e+03,0.11779e+04 /)
      kbo(:, 2,25,14) = (/ &
        & 0.10600e+04,0.81980e+03,0.60253e+03,0.88951e+03,0.11766e+04 /)
      kbo(:, 3,25,14) = (/ &
        & 0.10484e+04,0.79331e+03,0.60149e+03,0.88854e+03,0.11754e+04 /)
      kbo(:, 4,25,14) = (/ &
        & 0.11000e+04,0.80548e+03,0.60080e+03,0.88717e+03,0.11735e+04 /)
      kbo(:, 5,25,14) = (/ &
        & 0.11165e+04,0.79968e+03,0.59952e+03,0.88528e+03,0.11711e+04 /)
      kbo(:, 1,26,14) = (/ &
        & 0.10604e+04,0.79570e+03,0.60325e+03,0.89026e+03,0.11777e+04 /)
      kbo(:, 2,26,14) = (/ &
        & 0.10870e+04,0.78311e+03,0.60230e+03,0.88929e+03,0.11764e+04 /)
      kbo(:, 3,26,14) = (/ &
        & 0.10476e+04,0.79338e+03,0.60128e+03,0.88826e+03,0.11750e+04 /)
      kbo(:, 4,26,14) = (/ &
        & 0.10459e+04,0.80175e+03,0.60027e+03,0.88677e+03,0.11730e+04 /)
      kbo(:, 5,26,14) = (/ &
        & 0.10485e+04,0.81112e+03,0.59892e+03,0.88476e+03,0.11704e+04 /)
      kbo(:, 1,27,14) = (/ &
        & 0.10458e+04,0.79457e+03,0.60301e+03,0.89001e+03,0.11773e+04 /)
      kbo(:, 2,27,14) = (/ &
        & 0.10576e+04,0.79170e+03,0.60208e+03,0.88906e+03,0.11761e+04 /)
      kbo(:, 3,27,14) = (/ &
        & 0.10632e+04,0.79464e+03,0.60130e+03,0.88794e+03,0.11741e+04 /)
      kbo(:, 4,27,14) = (/ &
        & 0.10506e+04,0.80916e+03,0.60021e+03,0.88633e+03,0.11725e+04 /)
      kbo(:, 5,27,14) = (/ &
        & 0.10406e+04,0.79035e+03,0.59878e+03,0.88422e+03,0.11697e+04 /)
      kbo(:, 1,28,14) = (/ &
        & 0.10390e+04,0.79142e+03,0.60274e+03,0.88940e+03,0.11770e+04 /)
      kbo(:, 2,28,14) = (/ &
        & 0.10793e+04,0.84664e+03,0.60165e+03,0.88883e+03,0.11758e+04 /)
      kbo(:, 3,28,14) = (/ &
        & 0.10389e+04,0.81244e+03,0.60106e+03,0.88760e+03,0.11741e+04 /)
      kbo(:, 4,28,14) = (/ &
        & 0.10910e+04,0.82250e+03,0.59988e+03,0.88586e+03,0.11718e+04 /)
      kbo(:, 5,28,14) = (/ &
        & 0.10984e+04,0.79766e+03,0.59863e+03,0.88510e+03,0.11689e+04 /)
      kbo(:, 1,29,14) = (/ &
        & 0.10453e+04,0.79421e+03,0.60249e+03,0.88988e+03,0.11767e+04 /)
      kbo(:, 2,29,14) = (/ &
        & 0.10759e+04,0.85231e+03,0.59780e+03,0.88856e+03,0.11754e+04 /)
      kbo(:, 3,29,14) = (/ &
        & 0.10355e+04,0.83260e+03,0.60079e+03,0.88721e+03,0.11736e+04 /)
      kbo(:, 4,29,14) = (/ &
        & 0.10260e+04,0.78313e+03,0.59953e+03,0.88535e+03,0.11712e+04 /)
      kbo(:, 5,29,14) = (/ &
        & 0.10495e+04,0.79101e+03,0.59751e+03,0.88309e+03,0.11682e+04 /)
      kbo(:, 1,30,14) = (/ &
        & 0.10479e+04,0.78753e+03,0.60225e+03,0.88928e+03,0.11764e+04 /)
      kbo(:, 2,30,14) = (/ &
        & 0.10451e+04,0.80563e+03,0.60150e+03,0.88827e+03,0.11750e+04 /)
      kbo(:, 3,30,14) = (/ &
        & 0.10758e+04,0.79525e+03,0.60050e+03,0.88643e+03,0.11731e+04 /)
      kbo(:, 4,30,14) = (/ &
        & 0.10781e+04,0.79929e+03,0.59916e+03,0.88480e+03,0.11705e+04 /)
      kbo(:, 5,30,14) = (/ &
        & 0.10459e+04,0.81358e+03,0.59790e+03,0.88220e+03,0.11665e+04 /)
      kbo(:, 1,31,14) = (/ &
        & 0.10607e+04,0.80146e+03,0.60204e+03,0.88905e+03,0.11761e+04 /)
      kbo(:, 2,31,14) = (/ &
        & 0.10395e+04,0.78822e+03,0.60127e+03,0.88793e+03,0.11746e+04 /)
      kbo(:, 3,31,14) = (/ &
        & 0.10321e+04,0.80923e+03,0.60018e+03,0.88632e+03,0.11725e+04 /)
      kbo(:, 4,31,14) = (/ &
        & 0.11042e+04,0.80049e+03,0.59875e+03,0.88457e+03,0.11697e+04 /)
      kbo(:, 5,31,14) = (/ &
        & 0.10581e+04,0.80105e+03,0.59750e+03,0.88200e+03,0.11672e+04 /)
      kbo(:, 1,32,14) = (/ &
        & 0.10889e+04,0.84488e+03,0.59867e+03,0.88880e+03,0.11757e+04 /)
      kbo(:, 2,32,14) = (/ &
        & 0.10428e+04,0.79586e+03,0.60101e+03,0.88756e+03,0.11741e+04 /)
      kbo(:, 3,32,14) = (/ &
        & 0.10671e+04,0.82487e+03,0.59984e+03,0.88582e+03,0.11718e+04 /)
      kbo(:, 4,32,14) = (/ &
        & 0.10426e+04,0.83726e+03,0.59809e+03,0.88469e+03,0.11694e+04 /)
      kbo(:, 5,32,14) = (/ &
        & 0.10522e+04,0.80937e+03,0.59684e+03,0.88175e+03,0.11659e+04 /)
      kbo(:, 1,33,14) = (/ &
        & 0.10391e+04,0.79980e+03,0.60166e+03,0.88852e+03,0.11754e+04 /)
      kbo(:, 2,33,14) = (/ &
        & 0.10719e+04,0.78917e+03,0.60073e+03,0.88751e+03,0.11736e+04 /)
      kbo(:, 3,33,14) = (/ &
        & 0.10389e+04,0.82235e+03,0.59947e+03,0.88564e+03,0.11706e+04 /)
      kbo(:, 4,33,14) = (/ &
        & 0.10819e+04,0.81877e+03,0.59794e+03,0.88337e+03,0.11676e+04 /)
      kbo(:, 5,33,14) = (/ &
        & 0.10266e+04,0.78772e+03,0.59642e+03,0.88112e+03,0.11651e+04 /)
      kbo(:, 1,34,14) = (/ &
        & 0.10675e+04,0.78932e+03,0.60147e+03,0.88789e+03,0.11750e+04 /)
      kbo(:, 2,34,14) = (/ &
        & 0.10375e+04,0.79310e+03,0.60047e+03,0.88677e+03,0.11731e+04 /)
      kbo(:, 3,34,14) = (/ &
        & 0.10378e+04,0.82372e+03,0.59913e+03,0.88478e+03,0.11704e+04 /)
      kbo(:, 4,34,14) = (/ &
        & 0.10677e+04,0.78757e+03,0.59836e+03,0.88254e+03,0.11660e+04 /)
      kbo(:, 5,34,14) = (/ &
        & 0.10419e+04,0.77666e+03,0.59604e+03,0.87984e+03,0.11644e+04 /)
      kbo(:, 1,35,14) = (/ &
        & 0.10613e+04,0.80031e+03,0.60136e+03,0.88808e+03,0.11748e+04 /)
      kbo(:, 2,35,14) = (/ &
        & 0.11118e+04,0.80250e+03,0.60031e+03,0.88654e+03,0.11732e+04 /)
      kbo(:, 3,35,14) = (/ &
        & 0.10759e+04,0.83185e+03,0.59892e+03,0.88448e+03,0.11701e+04 /)
      kbo(:, 4,35,14) = (/ &
        & 0.11049e+04,0.77622e+03,0.59743e+03,0.88477e+03,0.11680e+04 /)
      kbo(:, 5,35,14) = (/ &
        & 0.10459e+04,0.78322e+03,0.59581e+03,0.87986e+03,0.11634e+04 /)
      kbo(:, 1,36,14) = (/ &
        & 0.10396e+04,0.79026e+03,0.60134e+03,0.88805e+03,0.11748e+04 /)
      kbo(:, 2,36,14) = (/ &
        & 0.10471e+04,0.80778e+03,0.60028e+03,0.88614e+03,0.11727e+04 /)
      kbo(:, 3,36,14) = (/ &
        & 0.10450e+04,0.79912e+03,0.59889e+03,0.88407e+03,0.11700e+04 /)
      kbo(:, 4,36,14) = (/ &
        & 0.10626e+04,0.80803e+03,0.59740e+03,0.88257e+03,0.11756e+04 /)
      kbo(:, 5,36,14) = (/ &
        & 0.10609e+04,0.81056e+03,0.59577e+03,0.87981e+03,0.11634e+04 /)
      kbo(:, 1,37,14) = (/ &
        & 0.10479e+04,0.79014e+03,0.60145e+03,0.88822e+03,0.11750e+04 /)
      kbo(:, 2,37,14) = (/ &
        & 0.10744e+04,0.81437e+03,0.60044e+03,0.88637e+03,0.11730e+04 /)
      kbo(:, 3,37,14) = (/ &
        & 0.10335e+04,0.79550e+03,0.59909e+03,0.88473e+03,0.11704e+04 /)
      kbo(:, 4,37,14) = (/ &
        & 0.10410e+04,0.77504e+03,0.59808e+03,0.88321e+03,0.11674e+04 /)
      kbo(:, 5,37,14) = (/ &
        & 0.10557e+04,0.79226e+03,0.59599e+03,0.88014e+03,0.11643e+04 /)
      kbo(:, 1,38,14) = (/ &
        & 0.10418e+04,0.80249e+03,0.60156e+03,0.88838e+03,0.11752e+04 /)
      kbo(:, 2,38,14) = (/ &
        & 0.10220e+04,0.82577e+03,0.60060e+03,0.88697e+03,0.11733e+04 /)
      kbo(:, 3,38,14) = (/ &
        & 0.10502e+04,0.80915e+03,0.59929e+03,0.88503e+03,0.11708e+04 /)
      kbo(:, 4,38,14) = (/ &
        & 0.10497e+04,0.81774e+03,0.59826e+03,0.88277e+03,0.11673e+04 /)
      kbo(:, 5,38,14) = (/ &
        & 0.10771e+04,0.81134e+03,0.59623e+03,0.88049e+03,0.11648e+04 /)
      kbo(:, 1,39,14) = (/ &
        & 0.10165e+04,0.77782e+03,0.60118e+03,0.88854e+03,0.11754e+04 /)
      kbo(:, 2,39,14) = (/ &
        & 0.10531e+04,0.80302e+03,0.60075e+03,0.88719e+03,0.11736e+04 /)
      kbo(:, 3,39,14) = (/ &
        & 0.10758e+04,0.78257e+03,0.59949e+03,0.88533e+03,0.11712e+04 /)
      kbo(:, 4,39,14) = (/ &
        & 0.10568e+04,0.79852e+03,0.59772e+03,0.88307e+03,0.11677e+04 /)
      kbo(:, 5,39,14) = (/ &
        & 0.11120e+04,0.79275e+03,0.59645e+03,0.88083e+03,0.11652e+04 /)
      kbo(:, 1,40,14) = (/ &
        & 0.10416e+04,0.79660e+03,0.59890e+03,0.88879e+03,0.11758e+04 /)
      kbo(:, 2,40,14) = (/ &
        & 0.10391e+04,0.79051e+03,0.60100e+03,0.88756e+03,0.11741e+04 /)
      kbo(:, 3,40,14) = (/ &
        & 0.10420e+04,0.78155e+03,0.59983e+03,0.88583e+03,0.11718e+04 /)
      kbo(:, 4,40,14) = (/ &
        & 0.10496e+04,0.79527e+03,0.59833e+03,0.88434e+03,0.11689e+04 /)
      kbo(:, 5,40,14) = (/ &
        & 0.10264e+04,0.78919e+03,0.59684e+03,0.88140e+03,0.11660e+04 /)
      kbo(:, 1,41,14) = (/ &
        & 0.10689e+04,0.80516e+03,0.60103e+03,0.88904e+03,0.11761e+04 /)
      kbo(:, 2,41,14) = (/ &
        & 0.10416e+04,0.82239e+03,0.60124e+03,0.88792e+03,0.11746e+04 /)
      kbo(:, 3,41,14) = (/ &
        & 0.10563e+04,0.81535e+03,0.60016e+03,0.88632e+03,0.11725e+04 /)
      kbo(:, 4,41,14) = (/ &
        & 0.10676e+04,0.82044e+03,0.59873e+03,0.88421e+03,0.11697e+04 /)
      kbo(:, 5,41,14) = (/ &
        & 0.10596e+04,0.78372e+03,0.59724e+03,0.88164e+03,0.11672e+04 /)
      kbo(:, 1,42,14) = (/ &
        & 0.10655e+04,0.80320e+03,0.60196e+03,0.88927e+03,0.11764e+04 /)
      kbo(:, 2,42,14) = (/ &
        & 0.10714e+04,0.78435e+03,0.60147e+03,0.88825e+03,0.11750e+04 /)
      kbo(:, 3,42,14) = (/ &
        & 0.10516e+04,0.79392e+03,0.60071e+03,0.88678e+03,0.11731e+04 /)
      kbo(:, 4,42,14) = (/ &
        & 0.10516e+04,0.77763e+03,0.59913e+03,0.88479e+03,0.11700e+04 /)
      kbo(:, 5,42,14) = (/ &
        & 0.10486e+04,0.79390e+03,0.59811e+03,0.88255e+03,0.11641e+04 /)
      kbo(:, 1,43,14) = (/ &
        & 0.10979e+04,0.83796e+03,0.60248e+03,0.88955e+03,0.11768e+04 /)
      kbo(:, 2,43,14) = (/ &
        & 0.11147e+04,0.76548e+03,0.60171e+03,0.88861e+03,0.11750e+04 /)
      kbo(:, 3,43,14) = (/ &
        & 0.10326e+04,0.79357e+03,0.60081e+03,0.88729e+03,0.11738e+04 /)
      kbo(:, 4,43,14) = (/ &
        & 0.10439e+04,0.86155e+03,0.59958e+03,0.88546e+03,0.11709e+04 /)
      kbo(:, 5,43,14) = (/ &
        & 0.10945e+04,0.81749e+03,0.59781e+03,0.88321e+03,0.11679e+04 /)
      kbo(:, 1,44,14) = (/ &
        & 0.10684e+04,0.83027e+03,0.60306e+03,0.88988e+03,0.11772e+04 /)
      kbo(:, 2,44,14) = (/ &
        & 0.10549e+04,0.78589e+03,0.60194e+03,0.88895e+03,0.11755e+04 /)
      kbo(:, 3,44,14) = (/ &
        & 0.10654e+04,0.79705e+03,0.60140e+03,0.88779e+03,0.11744e+04 /)
      kbo(:, 4,44,14) = (/ &
        & 0.10595e+04,0.79130e+03,0.59979e+03,0.88614e+03,0.11722e+04 /)
      kbo(:, 5,44,14) = (/ &
        & 0.10477e+04,0.80597e+03,0.59858e+03,0.88363e+03,0.11704e+04 /)
      kbo(:, 1,45,14) = (/ &
        & 0.10873e+04,0.79417e+03,0.60313e+03,0.89023e+03,0.11777e+04 /)
      kbo(:, 2,45,14) = (/ &
        & 0.10616e+04,0.78299e+03,0.60195e+03,0.88889e+03,0.11764e+04 /)
      kbo(:, 3,45,14) = (/ &
        & 0.10452e+04,0.80979e+03,0.60145e+03,0.88823e+03,0.11745e+04 /)
      kbo(:, 4,45,14) = (/ &
        & 0.10957e+04,0.80372e+03,0.60045e+03,0.88675e+03,0.11726e+04 /)
      kbo(:, 5,45,14) = (/ &
        & 0.10725e+04,0.79223e+03,0.59886e+03,0.88476e+03,0.11704e+04 /)
      kbo(:, 1,46,14) = (/ &
        & 0.10477e+04,0.79958e+03,0.60344e+03,0.89054e+03,0.11781e+04 /)
      kbo(:, 2,46,14) = (/ &
        & 0.10873e+04,0.80021e+03,0.60251e+03,0.88958e+03,0.11768e+04 /)
      kbo(:, 3,46,14) = (/ &
        & 0.10228e+04,0.78903e+03,0.60173e+03,0.88864e+03,0.11751e+04 /)
      kbo(:, 4,46,14) = (/ &
        & 0.10295e+04,0.83052e+03,0.60085e+03,0.88734e+03,0.11738e+04 /)
      kbo(:, 5,46,14) = (/ &
        & 0.10527e+04,0.80434e+03,0.59963e+03,0.88553e+03,0.11714e+04 /)
      kbo(:, 1,47,14) = (/ &
        & 0.10317e+04,0.78934e+03,0.60373e+03,0.89119e+03,0.11785e+04 /)
      kbo(:, 2,47,14) = (/ &
        & 0.10325e+04,0.79125e+03,0.60291e+03,0.88999e+03,0.11778e+04 /)
      kbo(:, 3,47,14) = (/ &
        & 0.10417e+04,0.79891e+03,0.60152e+03,0.88904e+03,0.11761e+04 /)
      kbo(:, 4,47,14) = (/ &
        & 0.10561e+04,0.78901e+03,0.60124e+03,0.88793e+03,0.11746e+04 /)
      kbo(:, 5,47,14) = (/ &
        & 0.10468e+04,0.79347e+03,0.59991e+03,0.88632e+03,0.11725e+04 /)
      kbo(:, 1,48,14) = (/ &
        & 0.10540e+04,0.78901e+03,0.60401e+03,0.89113e+03,0.11789e+04 /)
      kbo(:, 2,48,14) = (/ &
        & 0.10320e+04,0.80975e+03,0.60327e+03,0.89037e+03,0.11779e+04 /)
      kbo(:, 3,48,14) = (/ &
        & 0.10535e+04,0.79283e+03,0.60233e+03,0.88940e+03,0.11766e+04 /)
      kbo(:, 4,48,14) = (/ &
        & 0.10485e+04,0.81102e+03,0.60158e+03,0.88807e+03,0.11753e+04 /)
      kbo(:, 5,48,14) = (/ &
        & 0.10337e+04,0.82793e+03,0.60064e+03,0.88703e+03,0.11734e+04 /)
      kbo(:, 1,49,14) = (/ &
        & 0.10304e+04,0.83177e+03,0.60454e+03,0.89164e+03,0.11796e+04 /)
      kbo(:, 2,49,14) = (/ &
        & 0.10417e+04,0.78580e+03,0.60359e+03,0.89069e+03,0.11783e+04 /)
      kbo(:, 3,49,14) = (/ &
        & 0.10725e+04,0.82186e+03,0.60271e+03,0.88942e+03,0.11771e+04 /)
      kbo(:, 4,49,14) = (/ &
        & 0.10362e+04,0.80207e+03,0.60065e+03,0.88885e+03,0.11758e+04 /)
      kbo(:, 5,49,14) = (/ &
        & 0.10383e+04,0.79856e+03,0.60081e+03,0.88765e+03,0.11743e+04 /)
      kbo(:, 1,50,14) = (/ &
        & 0.10581e+04,0.78356e+03,0.60457e+03,0.89226e+03,0.11805e+04 /)
      kbo(:, 2,50,14) = (/ &
        & 0.10447e+04,0.80207e+03,0.60385e+03,0.89058e+03,0.11786e+04 /)
      kbo(:, 3,50,14) = (/ &
        & 0.10788e+04,0.82154e+03,0.60308e+03,0.89017e+03,0.11776e+04 /)
      kbo(:, 4,50,14) = (/ &
        & 0.10695e+04,0.79696e+03,0.60214e+03,0.88920e+03,0.11763e+04 /)
      kbo(:, 5,50,14) = (/ &
        & 0.10859e+04,0.79983e+03,0.60140e+03,0.88816e+03,0.11749e+04 /)
      kbo(:, 1,51,14) = (/ &
        & 0.10459e+04,0.79632e+03,0.60498e+03,0.89284e+03,0.11812e+04 /)
      kbo(:, 2,51,14) = (/ &
        & 0.10371e+04,0.78419e+03,0.60411e+03,0.89166e+03,0.11796e+04 /)
      kbo(:, 3,51,14) = (/ &
        & 0.10657e+04,0.82185e+03,0.60315e+03,0.89049e+03,0.11780e+04 /)
      kbo(:, 4,51,14) = (/ &
        & 0.10396e+04,0.78418e+03,0.60197e+03,0.88917e+03,0.11768e+04 /)
      kbo(:, 5,51,14) = (/ &
        & 0.10354e+04,0.78290e+03,0.60169e+03,0.88859e+03,0.11755e+04 /)
      kbo(:, 1,52,14) = (/ &
        & 0.10434e+04,0.78546e+03,0.60574e+03,0.89370e+03,0.11824e+04 /)
      kbo(:, 2,52,14) = (/ &
        & 0.10665e+04,0.78610e+03,0.60413e+03,0.89180e+03,0.11798e+04 /)
      kbo(:, 3,52,14) = (/ &
        & 0.10821e+04,0.78641e+03,0.60367e+03,0.89113e+03,0.11784e+04 /)
      kbo(:, 4,52,14) = (/ &
        & 0.10514e+04,0.79279e+03,0.60282e+03,0.88989e+03,0.11772e+04 /)
      kbo(:, 5,52,14) = (/ &
        & 0.10408e+04,0.77939e+03,0.60170e+03,0.88895e+03,0.11760e+04 /)
      kbo(:, 1,53,14) = (/ &
        & 0.10497e+04,0.80875e+03,0.60601e+03,0.89382e+03,0.11825e+04 /)
      kbo(:, 2,53,14) = (/ &
        & 0.10514e+04,0.81226e+03,0.60441e+03,0.89243e+03,0.11807e+04 /)
      kbo(:, 3,53,14) = (/ &
        & 0.11137e+04,0.80237e+03,0.60392e+03,0.89101e+03,0.11787e+04 /)
      kbo(:, 4,53,14) = (/ &
        & 0.10661e+04,0.79885e+03,0.60292e+03,0.89026e+03,0.11777e+04 /)
      kbo(:, 5,53,14) = (/ &
        & 0.10324e+04,0.82343e+03,0.60222e+03,0.88929e+03,0.11764e+04 /)
      kbo(:, 1,54,14) = (/ &
        & 0.10594e+04,0.86492e+03,0.60646e+03,0.89428e+03,0.11831e+04 /)
      kbo(:, 2,54,14) = (/ &
        & 0.10303e+04,0.85949e+03,0.60506e+03,0.89294e+03,0.11813e+04 /)
      kbo(:, 3,54,14) = (/ &
        & 0.10905e+04,0.84800e+03,0.60416e+03,0.89138e+03,0.11793e+04 /)
      kbo(:, 4,54,14) = (/ &
        & 0.10438e+04,0.78736e+03,0.60344e+03,0.89055e+03,0.11781e+04 /)
      kbo(:, 5,54,14) = (/ &
        & 0.10324e+04,0.83619e+03,0.60252e+03,0.88959e+03,0.11768e+04 /)
      kbo(:, 1,55,14) = (/ &
        & 0.10463e+04,0.78385e+03,0.60663e+03,0.89475e+03,0.11838e+04 /)
      kbo(:, 2,55,14) = (/ &
        & 0.10543e+04,0.79119e+03,0.60552e+03,0.89337e+03,0.11824e+04 /)
      kbo(:, 3,55,14) = (/ &
        & 0.10391e+04,0.80395e+03,0.60439e+03,0.89183e+03,0.11799e+04 /)
      kbo(:, 4,55,14) = (/ &
        & 0.10421e+04,0.79916e+03,0.60368e+03,0.89078e+03,0.11784e+04 /)
      kbo(:, 5,55,14) = (/ &
        & 0.10909e+04,0.78448e+03,0.60284e+03,0.88955e+03,0.11777e+04 /)
      kbo(:, 1,56,14) = (/ &
        & 0.10143e+04,0.81481e+03,0.60727e+03,0.89531e+03,0.11848e+04 /)
      kbo(:, 2,56,14) = (/ &
        & 0.10240e+04,0.81034e+03,0.60598e+03,0.89378e+03,0.11825e+04 /)
      kbo(:, 3,56,14) = (/ &
        & 0.10324e+04,0.78927e+03,0.60463e+03,0.89238e+03,0.11806e+04 /)
      kbo(:, 4,56,14) = (/ &
        & 0.10273e+04,0.78959e+03,0.60390e+03,0.89099e+03,0.11787e+04 /)
      kbo(:, 5,56,14) = (/ &
        & 0.10404e+04,0.80937e+03,0.60290e+03,0.89024e+03,0.11777e+04 /)
      kbo(:, 1,57,14) = (/ &
        & 0.10408e+04,0.79150e+03,0.60742e+03,0.89593e+03,0.11860e+04 /)
      kbo(:, 2,57,14) = (/ &
        & 0.10640e+04,0.82150e+03,0.60641e+03,0.89422e+03,0.11831e+04 /)
      kbo(:, 3,57,14) = (/ &
        & 0.10551e+04,0.79661e+03,0.60501e+03,0.89288e+03,0.11813e+04 /)
      kbo(:, 4,57,14) = (/ &
        & 0.10817e+04,0.79118e+03,0.60413e+03,0.89133e+03,0.11792e+04 /)
      kbo(:, 5,57,14) = (/ &
        & 0.10370e+04,0.79629e+03,0.60341e+03,0.89015e+03,0.11781e+04 /)
      kbo(:, 1,58,14) = (/ &
        & 0.10442e+04,0.84033e+03,0.60809e+03,0.89672e+03,0.11869e+04 /)
      kbo(:, 2,58,14) = (/ &
        & 0.10934e+04,0.79820e+03,0.60680e+03,0.89466e+03,0.11837e+04 /)
      kbo(:, 3,58,14) = (/ &
        & 0.10657e+04,0.80043e+03,0.60544e+03,0.89329e+03,0.11818e+04 /)
      kbo(:, 4,58,14) = (/ &
        & 0.10223e+04,0.78480e+03,0.60435e+03,0.89175e+03,0.11798e+04 /)
      kbo(:, 5,58,14) = (/ &
        & 0.10438e+04,0.81735e+03,0.60364e+03,0.89074e+03,0.11789e+04 /)
      kbo(:, 1,59,14) = (/ &
        & 0.10513e+04,0.80331e+03,0.60826e+03,0.89709e+03,0.11883e+04 /)
      kbo(:, 2,59,14) = (/ &
        & 0.10429e+04,0.81799e+03,0.60696e+03,0.89486e+03,0.11840e+04 /)
      kbo(:, 3,59,14) = (/ &
        & 0.10400e+04,0.80905e+03,0.60537e+03,0.89345e+03,0.11830e+04 /)
      kbo(:, 4,59,14) = (/ &
        & 0.10488e+04,0.79628e+03,0.60443e+03,0.89194e+03,0.11800e+04 /)
      kbo(:, 5,59,14) = (/ &
        & 0.10795e+04,0.78415e+03,0.60372e+03,0.89082e+03,0.11785e+04 /)
      kbo(:, 1,13,15) = (/ &
        & 0.98934e+03,0.75572e+03,0.60810e+03,0.89364e+03,0.11812e+04 /)
      kbo(:, 2,13,15) = (/ &
        & 0.12809e+04,0.72091e+03,0.60670e+03,0.89251e+03,0.11797e+04 /)
      kbo(:, 3,13,15) = (/ &
        & 0.11704e+04,0.77844e+03,0.60529e+03,0.89171e+03,0.11787e+04 /)
      kbo(:, 4,13,15) = (/ &
        & 0.11159e+04,0.83495e+03,0.60430e+03,0.89110e+03,0.11779e+04 /)
      kbo(:, 5,13,15) = (/ &
        & 0.11939e+04,0.93553e+03,0.60355e+03,0.89003e+03,0.11765e+04 /)
      kbo(:, 1,14,15) = (/ &
        & 0.11963e+04,0.95315e+03,0.60753e+03,0.89338e+03,0.11810e+04 /)
      kbo(:, 2,14,15) = (/ &
        & 0.11729e+04,0.92141e+03,0.60616e+03,0.89229e+03,0.11796e+04 /)
      kbo(:, 3,14,15) = (/ &
        & 0.11471e+04,0.85602e+03,0.60478e+03,0.89154e+03,0.11786e+04 /)
      kbo(:, 4,14,15) = (/ &
        & 0.11824e+04,0.88196e+03,0.60401e+03,0.89091e+03,0.11778e+04 /)
      kbo(:, 5,14,15) = (/ &
        & 0.11271e+04,0.87462e+03,0.60324e+03,0.89075e+03,0.11763e+04 /)
      kbo(:, 1,15,15) = (/ &
        & 0.10604e+04,0.90519e+03,0.60703e+03,0.89409e+03,0.11809e+04 /)
      kbo(:, 2,15,15) = (/ &
        & 0.11577e+04,0.75557e+03,0.60568e+03,0.89209e+03,0.11795e+04 /)
      kbo(:, 3,15,15) = (/ &
        & 0.11406e+04,0.81803e+03,0.60438e+03,0.89138e+03,0.11785e+04 /)
      kbo(:, 4,15,15) = (/ &
        & 0.11847e+04,0.71960e+03,0.60376e+03,0.89073e+03,0.11790e+04 /)
      kbo(:, 5,15,15) = (/ &
        & 0.11179e+04,0.81112e+03,0.60296e+03,0.88859e+03,0.11787e+04 /)
      kbo(:, 1,16,15) = (/ &
        & 0.10356e+04,0.71983e+03,0.60659e+03,0.89194e+03,0.11820e+04 /)
      kbo(:, 2,16,15) = (/ &
        & 0.11364e+04,0.76870e+03,0.60526e+03,0.89190e+03,0.11794e+04 /)
      kbo(:, 3,16,15) = (/ &
        & 0.96034e+03,0.83277e+03,0.60407e+03,0.89124e+03,0.11785e+04 /)
      kbo(:, 4,16,15) = (/ &
        & 0.10077e+04,0.87988e+03,0.60354e+03,0.89055e+03,0.11776e+04 /)
      kbo(:, 5,16,15) = (/ &
        & 0.10422e+04,0.83397e+03,0.60335e+03,0.88931e+03,0.11759e+04 /)
      kbo(:, 1,17,15) = (/ &
        & 0.10091e+04,0.77782e+03,0.60621e+03,0.89269e+03,0.11805e+04 /)
      kbo(:, 2,17,15) = (/ &
        & 0.11716e+04,0.80971e+03,0.60425e+03,0.89175e+03,0.11793e+04 /)
      kbo(:, 3,17,15) = (/ &
        & 0.10550e+04,0.78786e+03,0.60385e+03,0.89112e+03,0.11784e+04 /)
      kbo(:, 4,17,15) = (/ &
        & 0.99990e+03,0.88096e+03,0.60335e+03,0.89039e+03,0.11774e+04 /)
      kbo(:, 5,17,15) = (/ &
        & 0.11263e+04,0.73127e+03,0.60311e+03,0.88908e+03,0.11770e+04 /)
      kbo(:, 1,18,15) = (/ &
        & 0.11151e+04,0.85991e+03,0.60588e+03,0.89155e+03,0.11804e+04 /)
      kbo(:, 2,18,15) = (/ &
        & 0.10413e+04,0.70815e+03,0.60458e+03,0.89161e+03,0.11791e+04 /)
      kbo(:, 3,18,15) = (/ &
        & 0.11058e+04,0.82037e+03,0.60370e+03,0.89101e+03,0.11783e+04 /)
      kbo(:, 4,18,15) = (/ &
        & 0.10134e+04,0.64109e+03,0.60383e+03,0.89024e+03,0.11786e+04 /)
      kbo(:, 5,18,15) = (/ &
        & 0.11497e+04,0.88170e+03,0.60224e+03,0.88981e+03,0.11767e+04 /)
      kbo(:, 1,19,15) = (/ &
        & 0.10261e+04,0.82130e+03,0.60625e+03,0.89236e+03,0.11802e+04 /)
      kbo(:, 2,19,15) = (/ &
        & 0.10077e+04,0.78017e+03,0.60431e+03,0.89148e+03,0.11778e+04 /)
      kbo(:, 3,19,15) = (/ &
        & 0.10505e+04,0.75163e+03,0.60422e+03,0.88995e+03,0.11782e+04 /)
      kbo(:, 4,19,15) = (/ &
        & 0.10498e+04,0.84163e+03,0.60302e+03,0.89009e+03,0.11772e+04 /)
      kbo(:, 5,19,15) = (/ &
        & 0.94853e+03,0.71012e+03,0.60269e+03,0.88958e+03,0.11765e+04 /)
      kbo(:, 1,20,15) = (/ &
        & 0.11198e+04,0.83291e+03,0.60532e+03,0.89221e+03,0.11814e+04 /)
      kbo(:, 2,20,15) = (/ &
        & 0.10146e+04,0.70988e+03,0.60473e+03,0.89136e+03,0.11789e+04 /)
      kbo(:, 3,20,15) = (/ &
        & 0.98440e+03,0.83872e+03,0.60345e+03,0.89080e+03,0.11781e+04 /)
      kbo(:, 4,20,15) = (/ &
        & 0.10595e+04,0.75621e+03,0.60286e+03,0.88992e+03,0.11770e+04 /)
      kbo(:, 5,20,15) = (/ &
        & 0.10274e+04,0.81836e+03,0.60247e+03,0.88836e+03,0.11749e+04 /)
      kbo(:, 1,21,15) = (/ &
        & 0.10788e+04,0.78645e+03,0.60506e+03,0.89207e+03,0.11799e+04 /)
      kbo(:, 2,21,15) = (/ &
        & 0.10852e+04,0.74295e+03,0.60386e+03,0.89125e+03,0.11788e+04 /)
      kbo(:, 3,21,15) = (/ &
        & 0.10428e+04,0.82396e+03,0.60333e+03,0.88973e+03,0.11780e+04 /)
      kbo(:, 4,21,15) = (/ &
        & 0.10018e+04,0.87387e+03,0.60336e+03,0.89071e+03,0.11768e+04 /)
      kbo(:, 5,21,15) = (/ &
        & 0.11155e+04,0.79293e+03,0.60225e+03,0.88809e+03,0.11746e+04 /)
      kbo(:, 1,22,15) = (/ &
        & 0.10301e+04,0.79445e+03,0.60539e+03,0.89186e+03,0.11797e+04 /)
      kbo(:, 2,22,15) = (/ &
        & 0.11174e+04,0.68851e+03,0.60364e+03,0.88919e+03,0.11787e+04 /)
      kbo(:, 3,22,15) = (/ &
        & 0.10845e+04,0.72821e+03,0.60320e+03,0.89053e+03,0.11779e+04 /)
      kbo(:, 4,22,15) = (/ &
        & 0.94182e+03,0.74129e+03,0.60185e+03,0.88948e+03,0.11777e+04 /)
      kbo(:, 5,22,15) = (/ &
        & 0.11256e+04,0.74069e+03,0.60323e+03,0.88766e+03,0.11740e+04 /)
      kbo(:, 1,23,15) = (/ &
        & 0.11218e+04,0.85968e+03,0.60443e+03,0.89167e+03,0.11795e+04 /)
      kbo(:, 2,23,15) = (/ &
        & 0.10449e+04,0.80739e+03,0.60218e+03,0.89100e+03,0.11785e+04 /)
      kbo(:, 3,23,15) = (/ &
        & 0.11277e+04,0.69098e+03,0.60306e+03,0.89036e+03,0.11777e+04 /)
      kbo(:, 4,23,15) = (/ &
        & 0.10580e+04,0.81384e+03,0.60228e+03,0.88919e+03,0.11761e+04 /)
      kbo(:, 5,23,15) = (/ &
        & 0.10279e+04,0.82530e+03,0.60094e+03,0.88718e+03,0.11734e+04 /)
      kbo(:, 1,24,15) = (/ &
        & 0.10227e+04,0.68179e+03,0.60412e+03,0.89149e+03,0.11792e+04 /)
      kbo(:, 2,24,15) = (/ &
        & 0.11518e+04,0.80624e+03,0.60338e+03,0.89088e+03,0.11784e+04 /)
      kbo(:, 3,24,15) = (/ &
        & 0.10788e+04,0.70820e+03,0.60290e+03,0.89016e+03,0.11787e+04 /)
      kbo(:, 4,24,15) = (/ &
        & 0.10466e+04,0.82233e+03,0.60268e+03,0.88884e+03,0.11757e+04 /)
      kbo(:, 5,24,15) = (/ &
        & 0.10066e+04,0.82618e+03,0.60057e+03,0.88665e+03,0.11740e+04 /)
      kbo(:, 1,25,15) = (/ &
        & 0.10780e+04,0.80937e+03,0.60386e+03,0.89131e+03,0.11790e+04 /)
      kbo(:, 2,25,15) = (/ &
        & 0.10199e+04,0.81059e+03,0.60327e+03,0.89075e+03,0.11782e+04 /)
      kbo(:, 3,25,15) = (/ &
        & 0.11207e+04,0.80162e+03,0.60338e+03,0.88992e+03,0.11771e+04 /)
      kbo(:, 4,25,15) = (/ &
        & 0.97495e+03,0.78589e+03,0.60305e+03,0.88845e+03,0.11751e+04 /)
      kbo(:, 5,25,15) = (/ &
        & 0.95428e+03,0.80945e+03,0.60015e+03,0.88605e+03,0.11720e+04 /)
      kbo(:, 1,26,15) = (/ &
        & 0.10862e+04,0.78235e+03,0.60361e+03,0.89115e+03,0.11801e+04 /)
      kbo(:, 2,26,15) = (/ &
        & 0.91581e+03,0.82546e+03,0.60381e+03,0.89059e+03,0.11780e+04 /)
      kbo(:, 3,26,15) = (/ &
        & 0.10920e+04,0.84813e+03,0.60253e+03,0.88964e+03,0.11767e+04 /)
      kbo(:, 4,26,15) = (/ &
        & 0.11174e+04,0.83078e+03,0.60207e+03,0.88892e+03,0.11745e+04 /)
      kbo(:, 5,26,15) = (/ &
        & 0.11159e+04,0.75128e+03,0.59967e+03,0.88536e+03,0.11723e+04 /)
      kbo(:, 1,27,15) = (/ &
        & 0.10835e+04,0.80424e+03,0.60343e+03,0.89101e+03,0.11786e+04 /)
      kbo(:, 2,27,15) = (/ &
        & 0.10910e+04,0.86525e+03,0.60302e+03,0.89041e+03,0.11778e+04 /)
      kbo(:, 3,27,15) = (/ &
        & 0.10210e+04,0.77642e+03,0.60231e+03,0.89027e+03,0.11763e+04 /)
      kbo(:, 4,27,15) = (/ &
        & 0.10645e+04,0.80598e+03,0.60105e+03,0.88742e+03,0.11751e+04 /)
      kbo(:, 5,27,15) = (/ &
        & 0.10451e+04,0.82023e+03,0.59981e+03,0.88559e+03,0.11701e+04 /)
      kbo(:, 1,28,15) = (/ &
        & 0.10856e+04,0.83991e+03,0.60332e+03,0.89088e+03,0.11784e+04 /)
      kbo(:, 2,28,15) = (/ &
        & 0.93268e+03,0.70779e+03,0.60288e+03,0.89019e+03,0.11788e+04 /)
      kbo(:, 3,28,15) = (/ &
        & 0.11243e+04,0.76544e+03,0.60205e+03,0.88894e+03,0.11758e+04 /)
      kbo(:, 4,28,15) = (/ &
        & 0.10096e+04,0.72189e+03,0.60064e+03,0.88682e+03,0.11730e+04 /)
      kbo(:, 5,28,15) = (/ &
        & 0.88490e+03,0.83821e+03,0.59801e+03,0.88198e+03,0.11692e+04 /)
      kbo(:, 1,29,15) = (/ &
        & 0.10218e+04,0.78897e+03,0.60322e+03,0.88978e+03,0.11783e+04 /)
      kbo(:, 2,29,15) = (/ &
        & 0.97223e+03,0.70803e+03,0.60270e+03,0.88994e+03,0.11772e+04 /)
      kbo(:, 3,29,15) = (/ &
        & 0.10729e+04,0.71638e+03,0.60175e+03,0.88850e+03,0.11752e+04 /)
      kbo(:, 4,29,15) = (/ &
        & 0.10369e+04,0.79357e+03,0.60017e+03,0.88614e+03,0.11734e+04 /)
      kbo(:, 5,29,15) = (/ &
        & 0.10748e+04,0.83591e+03,0.59814e+03,0.88321e+03,0.11671e+04 /)
      kbo(:, 1,30,15) = (/ &
        & 0.10681e+04,0.78838e+03,0.60311e+03,0.89058e+03,0.11780e+04 /)
      kbo(:, 2,30,15) = (/ &
        & 0.10690e+04,0.81372e+03,0.60250e+03,0.88965e+03,0.11768e+04 /)
      kbo(:, 3,30,15) = (/ &
        & 0.10330e+04,0.79065e+03,0.60271e+03,0.88800e+03,0.11759e+04 /)
      kbo(:, 4,30,15) = (/ &
        & 0.99812e+03,0.80751e+03,0.60032e+03,0.88541e+03,0.11712e+04 /)
      kbo(:, 5,30,15) = (/ &
        & 0.10394e+04,0.71741e+03,0.59705e+03,0.88643e+03,0.11676e+04 /)
      kbo(:, 1,31,15) = (/ &
        & 0.10025e+04,0.73187e+03,0.60298e+03,0.89039e+03,0.11778e+04 /)
      kbo(:, 2,31,15) = (/ &
        & 0.11099e+04,0.74280e+03,0.60227e+03,0.88930e+03,0.11763e+04 /)
      kbo(:, 3,31,15) = (/ &
        & 0.10884e+04,0.79617e+03,0.60102e+03,0.88838e+03,0.11738e+04 /)
      kbo(:, 4,31,15) = (/ &
        & 0.90245e+03,0.76637e+03,0.59915e+03,0.88368e+03,0.11701e+04 /)
      kbo(:, 5,31,15) = (/ &
        & 0.10031e+04,0.78751e+03,0.59673e+03,0.89640e+03,0.11644e+04 /)
      kbo(:, 1,32,15) = (/ &
        & 0.87663e+03,0.68400e+03,0.60283e+03,0.89016e+03,0.11775e+04 /)
      kbo(:, 2,32,15) = (/ &
        & 0.10467e+04,0.83071e+03,0.60330e+03,0.88890e+03,0.11758e+04 /)
      kbo(:, 3,32,15) = (/ &
        & 0.97045e+03,0.72881e+03,0.60123e+03,0.88677e+03,0.11730e+04 /)
      kbo(:, 4,32,15) = (/ &
        & 0.11080e+04,0.69141e+03,0.59860e+03,0.88193e+03,0.11679e+04 /)
      kbo(:, 5,32,15) = (/ &
        & 0.10206e+04,0.73037e+03,0.59837e+03,0.88358e+03,0.11726e+04 /)
      kbo(:, 1,33,15) = (/ &
        & 0.10520e+04,0.78807e+03,0.60265e+03,0.89086e+03,0.11771e+04 /)
      kbo(:, 2,33,15) = (/ &
        & 0.98139e+03,0.81175e+03,0.60169e+03,0.88843e+03,0.11752e+04 /)
      kbo(:, 3,33,15) = (/ &
        & 0.11223e+04,0.75994e+03,0.60074e+03,0.88510e+03,0.11720e+04 /)
      kbo(:, 4,33,15) = (/ &
        & 0.10271e+04,0.75564e+03,0.59806e+03,0.88218e+03,0.11708e+04 /)
      kbo(:, 5,33,15) = (/ &
        & 0.10438e+04,0.78527e+03,0.59677e+03,0.88217e+03,0.11682e+04 /)
      kbo(:, 1,34,15) = (/ &
        & 0.10293e+04,0.82175e+03,0.60313e+03,0.88963e+03,0.11768e+04 /)
      kbo(:, 2,34,15) = (/ &
        & 0.11086e+04,0.80472e+03,0.60138e+03,0.88797e+03,0.11746e+04 /)
      kbo(:, 3,34,15) = (/ &
        & 0.10235e+04,0.72497e+03,0.60029e+03,0.88634e+03,0.11724e+04 /)
      kbo(:, 4,34,15) = (/ &
        & 0.10022e+04,0.79360e+03,0.59703e+03,0.88927e+03,0.11777e+04 /)
      kbo(:, 5,34,15) = (/ &
        & 0.11107e+04,0.84019e+03,0.59650e+03,0.88082e+03,0.11651e+04 /)
      kbo(:, 1,35,15) = (/ &
        & 0.10782e+04,0.81052e+03,0.60236e+03,0.89138e+03,0.11766e+04 /)
      kbo(:, 2,35,15) = (/ &
        & 0.89922e+03,0.74859e+03,0.60119e+03,0.88769e+03,0.11729e+04 /)
      kbo(:, 3,35,15) = (/ &
        & 0.10088e+04,0.71209e+03,0.59938e+03,0.88499e+03,0.11706e+04 /)
      kbo(:, 4,35,15) = (/ &
        & 0.96175e+03,0.77055e+03,0.60072e+03,0.87852e+03,0.11710e+04 /)
      kbo(:, 5,35,15) = (/ &
        & 0.10310e+04,0.84426e+03,0.59635e+03,0.88059e+03,0.11648e+04 /)
      kbo(:, 1,36,15) = (/ &
        & 0.10188e+04,0.85190e+03,0.60234e+03,0.88943e+03,0.11765e+04 /)
      kbo(:, 2,36,15) = (/ &
        & 0.10154e+04,0.76964e+03,0.60245e+03,0.88859e+03,0.11741e+04 /)
      kbo(:, 3,36,15) = (/ &
        & 0.10902e+04,0.77130e+03,0.59998e+03,0.88588e+03,0.11705e+04 /)
      kbo(:, 4,36,15) = (/ &
        & 0.98172e+03,0.79246e+03,0.59876e+03,0.89371e+03,0.11495e+04 /)
      kbo(:, 5,36,15) = (/ &
        & 0.10409e+04,0.75260e+03,0.59632e+03,0.88055e+03,0.11660e+04 /)
      kbo(:, 1,37,15) = (/ &
        & 0.10398e+04,0.81024e+03,0.60310e+03,0.88960e+03,0.11767e+04 /)
      kbo(:, 2,37,15) = (/ &
        & 0.94253e+03,0.72207e+03,0.60199e+03,0.88792e+03,0.11745e+04 /)
      kbo(:, 3,37,15) = (/ &
        & 0.11326e+04,0.78984e+03,0.60024e+03,0.88532e+03,0.11710e+04 /)
      kbo(:, 4,37,15) = (/ &
        & 0.10789e+04,0.84320e+03,0.59634e+03,0.88350e+03,0.11688e+04 /)
      kbo(:, 5,37,15) = (/ &
        & 0.10084e+04,0.82623e+03,0.59647e+03,0.88078e+03,0.11651e+04 /)
      kbo(:, 1,38,15) = (/ &
        & 0.99835e+03,0.77031e+03,0.60321e+03,0.88977e+03,0.11782e+04 /)
      kbo(:, 2,38,15) = (/ &
        & 0.11135e+04,0.73046e+03,0.60283e+03,0.88917e+03,0.11749e+04 /)
      kbo(:, 3,38,15) = (/ &
        & 0.10419e+04,0.72620e+03,0.59987e+03,0.88669e+03,0.11716e+04 /)
      kbo(:, 4,38,15) = (/ &
        & 0.10631e+04,0.75245e+03,0.59721e+03,0.88572e+03,0.11692e+04 /)
      kbo(:, 5,38,15) = (/ &
        & 0.10228e+04,0.73209e+03,0.59792e+03,0.88102e+03,0.11654e+04 /)
      kbo(:, 1,39,15) = (/ &
        & 0.10910e+04,0.86853e+03,0.60266e+03,0.88992e+03,0.11772e+04 /)
      kbo(:, 2,39,15) = (/ &
        & 0.10519e+04,0.73802e+03,0.60236e+03,0.88944e+03,0.11753e+04 /)
      kbo(:, 3,39,15) = (/ &
        & 0.90206e+03,0.82442e+03,0.60079e+03,0.88708e+03,0.11721e+04 /)
      kbo(:, 4,39,15) = (/ &
        & 0.10954e+04,0.83033e+03,0.59811e+03,0.88319e+03,0.11696e+04 /)
      kbo(:, 5,39,15) = (/ &
        & 0.92773e+03,0.79134e+03,0.59808e+03,0.88316e+03,0.11657e+04 /)
      kbo(:, 1,40,15) = (/ &
        & 0.10887e+04,0.78119e+03,0.60281e+03,0.89016e+03,0.11775e+04 /)
      kbo(:, 2,40,15) = (/ &
        & 0.10361e+04,0.78964e+03,0.60199e+03,0.88890e+03,0.11758e+04 /)
      kbo(:, 3,40,15) = (/ &
        & 0.10674e+04,0.81250e+03,0.60058e+03,0.88678e+03,0.11730e+04 /)
      kbo(:, 4,40,15) = (/ &
        & 0.11076e+04,0.76250e+03,0.59989e+03,0.88480e+03,0.11679e+04 /)
      kbo(:, 5,40,15) = (/ &
        & 0.11154e+04,0.83280e+03,0.59900e+03,0.88168e+03,0.11814e+04 /)
      kbo(:, 1,41,15) = (/ &
        & 0.10350e+04,0.79893e+03,0.60296e+03,0.89038e+03,0.11778e+04 /)
      kbo(:, 2,41,15) = (/ &
        & 0.10104e+04,0.69640e+03,0.60225e+03,0.88929e+03,0.11763e+04 /)
      kbo(:, 3,41,15) = (/ &
        & 0.10193e+04,0.78110e+03,0.60100e+03,0.88741e+03,0.11751e+04 /)
      kbo(:, 4,41,15) = (/ &
        & 0.10785e+04,0.73450e+03,0.59977e+03,0.88368e+03,0.11701e+04 /)
      kbo(:, 5,41,15) = (/ &
        & 0.96003e+03,0.80480e+03,0.59865e+03,0.90400e+03,0.11833e+04 /)
      kbo(:, 1,42,15) = (/ &
        & 0.97569e+03,0.77685e+03,0.60307e+03,0.89056e+03,0.11793e+04 /)
      kbo(:, 2,42,15) = (/ &
        & 0.98796e+03,0.83953e+03,0.60247e+03,0.88963e+03,0.11768e+04 /)
      kbo(:, 3,42,15) = (/ &
        & 0.10852e+04,0.82427e+03,0.60332e+03,0.88798e+03,0.11746e+04 /)
      kbo(:, 4,42,15) = (/ &
        & 0.10360e+04,0.83188e+03,0.59965e+03,0.88636e+03,0.11712e+04 /)
      kbo(:, 5,42,15) = (/ &
        & 0.10125e+04,0.74885e+03,0.59702e+03,0.88356e+03,0.11676e+04 /)
      kbo(:, 1,43,15) = (/ &
        & 0.91082e+03,0.72514e+03,0.60320e+03,0.89075e+03,0.11796e+04 /)
      kbo(:, 2,43,15) = (/ &
        & 0.82029e+03,0.80137e+03,0.60335e+03,0.88998e+03,0.11773e+04 /)
      kbo(:, 3,43,15) = (/ &
        & 0.11298e+04,0.78950e+03,0.60243e+03,0.88859e+03,0.11754e+04 /)
      kbo(:, 4,43,15) = (/ &
        & 0.10717e+04,0.65904e+03,0.60090e+03,0.88726e+03,0.11724e+04 /)
      kbo(:, 5,43,15) = (/ &
        & 0.89290e+03,0.78779e+03,0.59823e+03,0.88240e+03,0.11774e+04 /)
      kbo(:, 1,44,15) = (/ &
        & 0.10292e+04,0.72935e+03,0.60266e+03,0.89093e+03,0.11785e+04 /)
      kbo(:, 2,44,15) = (/ &
        & 0.10616e+04,0.76323e+03,0.60355e+03,0.89030e+03,0.11790e+04 /)
      kbo(:, 3,44,15) = (/ &
        & 0.10058e+04,0.82082e+03,0.60215e+03,0.88915e+03,0.11762e+04 /)
      kbo(:, 4,44,15) = (/ &
        & 0.96216e+03,0.76914e+03,0.60084e+03,0.88814e+03,0.11735e+04 /)
      kbo(:, 5,44,15) = (/ &
        & 0.10069e+04,0.76998e+03,0.59893e+03,0.88624e+03,0.11672e+04 /)
      kbo(:, 1,45,15) = (/ &
        & 0.92082e+03,0.79879e+03,0.60350e+03,0.89110e+03,0.11788e+04 /)
      kbo(:, 2,45,15) = (/ &
        & 0.96551e+03,0.79963e+03,0.60307e+03,0.89055e+03,0.11780e+04 /)
      kbo(:, 3,45,15) = (/ &
        & 0.10337e+04,0.76320e+03,0.60246e+03,0.88962e+03,0.11768e+04 /)
      kbo(:, 4,45,15) = (/ &
        & 0.97219e+03,0.72677e+03,0.60201e+03,0.88795e+03,0.11746e+04 /)
      kbo(:, 5,45,15) = (/ &
        & 0.10146e+04,0.80892e+03,0.59962e+03,0.88632e+03,0.11711e+04 /)
      kbo(:, 1,46,15) = (/ &
        & 0.10772e+04,0.81655e+03,0.60383e+03,0.89135e+03,0.11792e+04 /)
      kbo(:, 2,46,15) = (/ &
        & 0.98671e+03,0.73523e+03,0.60321e+03,0.89077e+03,0.11796e+04 /)
      kbo(:, 3,46,15) = (/ &
        & 0.10348e+04,0.84026e+03,0.60272e+03,0.89002e+03,0.11773e+04 /)
      kbo(:, 4,46,15) = (/ &
        & 0.11018e+04,0.66661e+03,0.60312e+03,0.88865e+03,0.11755e+04 /)
      kbo(:, 5,46,15) = (/ &
        & 0.10012e+04,0.71404e+03,0.60161e+03,0.88639e+03,0.11725e+04 /)
      kbo(:, 1,47,15) = (/ &
        & 0.10560e+04,0.78520e+03,0.60429e+03,0.89072e+03,0.11796e+04 /)
      kbo(:, 2,47,15) = (/ &
        & 0.10627e+04,0.82754e+03,0.60335e+03,0.89097e+03,0.11773e+04 /)
      kbo(:, 3,47,15) = (/ &
        & 0.10705e+04,0.76570e+03,0.60295e+03,0.89038e+03,0.11791e+04 /)
      kbo(:, 4,47,15) = (/ &
        & 0.11051e+04,0.83346e+03,0.60225e+03,0.89026e+03,0.11789e+04 /)
      kbo(:, 5,47,15) = (/ &
        & 0.10627e+04,0.79957e+03,0.60100e+03,0.88742e+03,0.11738e+04 /)
      kbo(:, 1,48,15) = (/ &
        & 0.10526e+04,0.83431e+03,0.60478e+03,0.89205e+03,0.11801e+04 /)
      kbo(:, 2,48,15) = (/ &
        & 0.11375e+04,0.74537e+03,0.60363e+03,0.89121e+03,0.11790e+04 /)
      kbo(:, 3,48,15) = (/ &
        & 0.10571e+04,0.77077e+03,0.60313e+03,0.89066e+03,0.11782e+04 /)
      kbo(:, 4,48,15) = (/ &
        & 0.10694e+04,0.73604e+03,0.60258e+03,0.88981e+03,0.11770e+04 /)
      kbo(:, 5,48,15) = (/ &
        & 0.11062e+04,0.66828e+03,0.60158e+03,0.88925e+03,0.11750e+04 /)
      kbo(:, 1,49,15) = (/ &
        & 0.10727e+04,0.73859e+03,0.60462e+03,0.89249e+03,0.11807e+04 /)
      kbo(:, 2,49,15) = (/ &
        & 0.11006e+04,0.84446e+03,0.60404e+03,0.89152e+03,0.11794e+04 /)
      kbo(:, 3,49,15) = (/ &
        & 0.96096e+03,0.73858e+03,0.60393e+03,0.89088e+03,0.11785e+04 /)
      kbo(:, 4,49,15) = (/ &
        & 0.11140e+04,0.80464e+03,0.60285e+03,0.89021e+03,0.11776e+04 /)
      kbo(:, 5,49,15) = (/ &
        & 0.10928e+04,0.75297e+03,0.60205e+03,0.88996e+03,0.11760e+04 /)
      kbo(:, 1,50,15) = (/ &
        & 0.10626e+04,0.84953e+03,0.60572e+03,0.89295e+03,0.11814e+04 /)
      kbo(:, 2,50,15) = (/ &
        & 0.11017e+04,0.71824e+03,0.60451e+03,0.89185e+03,0.11811e+04 /)
      kbo(:, 3,50,15) = (/ &
        & 0.10336e+04,0.71570e+03,0.60345e+03,0.89107e+03,0.11800e+04 /)
      kbo(:, 4,50,15) = (/ &
        & 0.95200e+03,0.76482e+03,0.60304e+03,0.89051e+03,0.11793e+04 /)
      kbo(:, 5,50,15) = (/ &
        & 0.96988e+03,0.83512e+03,0.60306e+03,0.88954e+03,0.11767e+04 /)
      kbo(:, 1,51,15) = (/ &
        & 0.11017e+04,0.77329e+03,0.60615e+03,0.89371e+03,0.11825e+04 /)
      kbo(:, 2,51,15) = (/ &
        & 0.10950e+04,0.81479e+03,0.60496e+03,0.89123e+03,0.11790e+04 /)
      kbo(:, 3,51,15) = (/ &
        & 0.99893e+03,0.69452e+03,0.60377e+03,0.89131e+03,0.11791e+04 /)
      kbo(:, 4,51,15) = (/ &
        & 0.10704e+04,0.82834e+03,0.60319e+03,0.89074e+03,0.11783e+04 /)
      kbo(:, 5,51,15) = (/ &
        & 0.10391e+04,0.80716e+03,0.60333e+03,0.89092e+03,0.11772e+04 /)
      kbo(:, 1,52,15) = (/ &
        & 0.10358e+04,0.83681e+03,0.60593e+03,0.89390e+03,0.11828e+04 /)
      kbo(:, 2,52,15) = (/ &
        & 0.95423e+03,0.78599e+03,0.60540e+03,0.89262e+03,0.11809e+04 /)
      kbo(:, 3,52,15) = (/ &
        & 0.98439e+03,0.83257e+03,0.60417e+03,0.89064e+03,0.11795e+04 /)
      kbo(:, 4,52,15) = (/ &
        & 0.10548e+04,0.77074e+03,0.60331e+03,0.89093e+03,0.11786e+04 /)
      kbo(:, 5,52,15) = (/ &
        & 0.10358e+04,0.81478e+03,0.60291e+03,0.89030e+03,0.11777e+04 /)
      kbo(:, 1,53,15) = (/ &
        & 0.96204e+03,0.74448e+03,0.60716e+03,0.89629e+03,0.11860e+04 /)
      kbo(:, 2,53,15) = (/ &
        & 0.10872e+04,0.75126e+03,0.60583e+03,0.89310e+03,0.11816e+04 /)
      kbo(:, 3,53,15) = (/ &
        & 0.90617e+03,0.75210e+03,0.60463e+03,0.89194e+03,0.11800e+04 /)
      kbo(:, 4,53,15) = (/ &
        & 0.97991e+03,0.76565e+03,0.60352e+03,0.89113e+03,0.11788e+04 /)
      kbo(:, 5,53,15) = (/ &
        & 0.10425e+04,0.76988e+03,0.60308e+03,0.89058e+03,0.11793e+04 /)
      kbo(:, 1,54,15) = (/ &
        & 0.10112e+04,0.55645e+03,0.60785e+03,0.89766e+03,0.11878e+04 /)
      kbo(:, 2,54,15) = (/ &
        & 0.10637e+04,0.66232e+03,0.60623e+03,0.89389e+03,0.11827e+04 /)
      kbo(:, 3,54,15) = (/ &
        & 0.88717e+03,0.63014e+03,0.60503e+03,0.89226e+03,0.11804e+04 /)
      kbo(:, 4,54,15) = (/ &
        & 0.10369e+04,0.84103e+03,0.60384e+03,0.89232e+03,0.11792e+04 /)
      kbo(:, 5,54,15) = (/ &
        & 0.10000e+04,0.70043e+03,0.60321e+03,0.89174e+03,0.11783e+04 /)
      kbo(:, 1,55,15) = (/ &
        & 0.10615e+04,0.77920e+03,0.60858e+03,0.89903e+03,0.11896e+04 /)
      kbo(:, 2,55,15) = (/ &
        & 0.10425e+04,0.78513e+03,0.60661e+03,0.89494e+03,0.11829e+04 /)
      kbo(:, 3,55,15) = (/ &
        & 0.10916e+04,0.73854e+03,0.60542e+03,0.89361e+03,0.11809e+04 /)
      kbo(:, 4,55,15) = (/ &
        & 0.10715e+04,0.78936e+03,0.60420e+03,0.89162e+03,0.11795e+04 /)
      kbo(:, 5,55,15) = (/ &
        & 0.96091e+03,0.82578e+03,0.60397e+03,0.89094e+03,0.11773e+04 /)
      kbo(:, 1,56,15) = (/ &
        & 0.10458e+04,0.77242e+03,0.60942e+03,0.90044e+03,0.11915e+04 /)
      kbo(:, 2,56,15) = (/ &
        & 0.11062e+04,0.77581e+03,0.60712e+03,0.89619e+03,0.11859e+04 /)
      kbo(:, 3,56,15) = (/ &
        & 0.10883e+04,0.80121e+03,0.60580e+03,0.89306e+03,0.11815e+04 /)
      kbo(:, 4,56,15) = (/ &
        & 0.10726e+04,0.82069e+03,0.60459e+03,0.89192e+03,0.11799e+04 /)
      kbo(:, 5,56,15) = (/ &
        & 0.11263e+04,0.78597e+03,0.60416e+03,0.89111e+03,0.11788e+04 /)
      kbo(:, 1,57,15) = (/ &
        & 0.11095e+04,0.76988e+03,0.61034e+03,0.90190e+03,0.11935e+04 /)
      kbo(:, 2,57,15) = (/ &
        & 0.97543e+03,0.72583e+03,0.60777e+03,0.89749e+03,0.11876e+04 /)
      kbo(:, 3,57,15) = (/ &
        & 0.98548e+03,0.78597e+03,0.60618e+03,0.89378e+03,0.11826e+04 /)
      kbo(:, 4,57,15) = (/ &
        & 0.98213e+03,0.81053e+03,0.60499e+03,0.89222e+03,0.11804e+04 /)
      kbo(:, 5,57,15) = (/ &
        & 0.10760e+04,0.81137e+03,0.60380e+03,0.89133e+03,0.11791e+04 /)
      kbo(:, 1,58,15) = (/ &
        & 0.10034e+04,0.71059e+03,0.61128e+03,0.90333e+03,0.11954e+04 /)
      kbo(:, 2,58,15) = (/ &
        & 0.97431e+03,0.80290e+03,0.60845e+03,0.89878e+03,0.11893e+04 /)
      kbo(:, 3,58,15) = (/ &
        & 0.95308e+03,0.77157e+03,0.60654e+03,0.89474e+03,0.11839e+04 /)
      kbo(:, 4,58,15) = (/ &
        & 0.10737e+04,0.87404e+03,0.60535e+03,0.89257e+03,0.11808e+04 /)
      kbo(:, 5,58,15) = (/ &
        & 0.10626e+04,0.67671e+03,0.60413e+03,0.89157e+03,0.11782e+04 /)
      kbo(:, 1,59,15) = (/ &
        & 0.98325e+03,0.78258e+03,0.61167e+03,0.90392e+03,0.11962e+04 /)
      kbo(:, 2,59,15) = (/ &
        & 0.10481e+04,0.74785e+03,0.60874e+03,0.89931e+03,0.11900e+04 /)
      kbo(:, 3,59,15) = (/ &
        & 0.11151e+04,0.73006e+03,0.60669e+03,0.89518e+03,0.11820e+04 /)
      kbo(:, 4,59,15) = (/ &
        & 0.10425e+04,0.79358e+03,0.60550e+03,0.89369e+03,0.11810e+04 /)
      kbo(:, 5,59,15) = (/ &
        & 0.97877e+03,0.79866e+03,0.60428e+03,0.89168e+03,0.11796e+04 /)
      kbo(:, 1,13,16) = (/ &
        & 0.75523e+03,0.86786e+03,0.60838e+03,0.89385e+03,0.11815e+04 /)
      kbo(:, 2,13,16) = (/ &
        & 0.10580e+03,0.52074e+03,0.60685e+03,0.89272e+03,0.11800e+04 /)
      kbo(:, 3,13,16) = (/ &
        & 0.88450e+03,0.99478e+02,0.60069e+03,0.89217e+03,0.11793e+04 /)
      kbo(:, 4,13,16) = (/ &
        & 0.47883e+03,0.85714e+02,0.60445e+03,0.89133e+03,0.11782e+04 /)
      kbo(:, 5,13,16) = (/ &
        & 0.30313e+03,0.39357e+02,0.60363e+03,0.89015e+03,0.11767e+04 /)
      kbo(:, 1,14,16) = (/ &
        & 0.59250e+03,0.12538e+03,0.60779e+03,0.89359e+03,0.11813e+04 /)
      kbo(:, 2,14,16) = (/ &
        & 0.45021e+03,0.30819e+03,0.60630e+03,0.89255e+03,0.11799e+04 /)
      kbo(:, 3,14,16) = (/ &
        & 0.38746e+03,0.31955e+03,0.60482e+03,0.89198e+03,0.11792e+04 /)
      kbo(:, 4,14,16) = (/ &
        & 0.59123e+03,0.24014e+03,0.60415e+03,0.89112e+03,0.11781e+04 /)
      kbo(:, 5,14,16) = (/ &
        & 0.47780e+03,0.41362e+03,0.60332e+03,0.88306e+03,0.11765e+04 /)
      kbo(:, 1,15,16) = (/ &
        & 0.10202e+04,0.29221e+03,0.60727e+03,0.88647e+03,0.11812e+04 /)
      kbo(:, 2,15,16) = (/ &
        & 0.55435e+03,0.58788e+03,0.60581e+03,0.89239e+03,0.11799e+04 /)
      kbo(:, 3,15,16) = (/ &
        & 0.31413e+03,0.75889e+03,0.60450e+03,0.89181e+03,0.11791e+04 /)
      kbo(:, 4,15,16) = (/ &
        & 0.41436e+03,0.80717e+03,0.60389e+03,0.89092e+03,0.11689e+04 /)
      kbo(:, 5,15,16) = (/ &
        & 0.84269e+03,0.27451e+03,0.60303e+03,0.88966e+03,0.11582e+04 /)
      kbo(:, 1,16,16) = (/ &
        & 0.19456e+03,0.24351e+03,0.60682e+03,0.89311e+03,0.11719e+04 /)
      kbo(:, 2,16,16) = (/ &
        & 0.43800e+03,0.21696e+03,0.60538e+03,0.89225e+03,0.11798e+04 /)
      kbo(:, 3,16,16) = (/ &
        & 0.73851e+03,0.22888e+03,0.60428e+03,0.89164e+03,0.11790e+04 /)
      kbo(:, 4,16,16) = (/ &
        & 0.83650e+03,0.13309e+03,0.60366e+03,0.89073e+03,0.11778e+04 /)
      kbo(:, 5,16,16) = (/ &
        & 0.65895e+03,0.36022e+03,0.59813e+03,0.88942e+03,0.11670e+04 /)
      kbo(:, 1,17,16) = (/ &
        & 0.97890e+03,0.27257e+03,0.60643e+03,0.89290e+03,0.11808e+04 /)
      kbo(:, 2,17,16) = (/ &
        & 0.21678e+03,0.36639e+03,0.60501e+03,0.89213e+03,0.11797e+04 /)
      kbo(:, 3,17,16) = (/ &
        & 0.36576e+03,0.64243e+03,0.60409e+03,0.89150e+03,0.11789e+04 /)
      kbo(:, 4,17,16) = (/ &
        & 0.71301e+03,0.32666e+03,0.60345e+03,0.89056e+03,0.11777e+04 /)
      kbo(:, 5,17,16) = (/ &
        & 0.30605e+03,0.68315e+03,0.59789e+03,0.88918e+03,0.11668e+04 /)
      kbo(:, 1,18,16) = (/ &
        & 0.52238e+03,0.17591e+03,0.60609e+03,0.89271e+03,0.11807e+04 /)
      kbo(:, 2,18,16) = (/ &
        & 0.10253e+04,0.75807e+03,0.60468e+03,0.89202e+03,0.11797e+04 /)
      kbo(:, 3,18,16) = (/ &
        & 0.23095e+03,0.31874e+03,0.60392e+03,0.89136e+03,0.11788e+04 /)
      kbo(:, 4,18,16) = (/ &
        & 0.55144e+03,0.80452e+03,0.59863e+03,0.89039e+03,0.11685e+04 /)
      kbo(:, 5,18,16) = (/ &
        & 0.36145e+03,0.21165e+03,0.60231e+03,0.88211e+03,0.11666e+04 /)
      kbo(:, 1,19,16) = (/ &
        & 0.10124e+04,0.51143e+03,0.60113e+03,0.89253e+03,0.11805e+04 /)
      kbo(:, 2,19,16) = (/ &
        & 0.54199e+03,0.26758e+03,0.60439e+03,0.89192e+03,0.11796e+04 /)
      kbo(:, 3,19,16) = (/ &
        & 0.61467e+03,0.78253e+03,0.59913e+03,0.89123e+03,0.11787e+04 /)
      kbo(:, 4,19,16) = (/ &
        & 0.58906e+03,0.74398e+02,0.60311e+03,0.89023e+03,0.11774e+04 /)
      kbo(:, 5,19,16) = (/ &
        & 0.98025e+03,0.28476e+03,0.59747e+03,0.88189e+03,0.11663e+04 /)
      kbo(:, 1,20,16) = (/ &
        & 0.25361e+03,0.16739e+03,0.60550e+03,0.89234e+03,0.11712e+04 /)
      kbo(:, 2,20,16) = (/ &
        & 0.70227e+03,0.71784e+03,0.59948e+03,0.89182e+03,0.11795e+04 /)
      kbo(:, 3,20,16) = (/ &
        & 0.89681e+03,0.24714e+03,0.60364e+03,0.89109e+03,0.11786e+04 /)
      kbo(:, 4,20,16) = (/ &
        & 0.30123e+03,0.54911e+03,0.60295e+03,0.89006e+03,0.11772e+04 /)
      kbo(:, 5,20,16) = (/ &
        & 0.68301e+03,0.36973e+03,0.59725e+03,0.88846e+03,0.11750e+04 /)
      kbo(:, 1,21,16) = (/ &
        & 0.25236e+03,0.80202e+03,0.60523e+03,0.89218e+03,0.11801e+04 /)
      kbo(:, 2,21,16) = (/ &
        & 0.77221e+03,0.62834e+03,0.60401e+03,0.89171e+03,0.11794e+04 /)
      kbo(:, 3,21,16) = (/ &
        & 0.70626e+03,0.20918e+03,0.60351e+03,0.89096e+03,0.11784e+04 /)
      kbo(:, 4,21,16) = (/ &
        & 0.16217e+03,0.14134e+03,0.59816e+03,0.88303e+03,0.11770e+04 /)
      kbo(:, 5,21,16) = (/ &
        & 0.51843e+03,0.20259e+03,0.59703e+03,0.88818e+03,0.11747e+04 /)
      kbo(:, 1,22,16) = (/ &
        & 0.21890e+03,0.24577e+03,0.60023e+03,0.89209e+03,0.11799e+04 /)
      kbo(:, 2,22,16) = (/ &
        & 0.30771e+03,0.55233e+03,0.60388e+03,0.89157e+03,0.11793e+04 /)
      kbo(:, 3,22,16) = (/ &
        & 0.17796e+03,0.48432e+03,0.60334e+03,0.89076e+03,0.11782e+04 /)
      kbo(:, 4,22,16) = (/ &
        & 0.88899e+03,0.36751e+03,0.60258e+03,0.88960e+03,0.11676e+04 /)
      kbo(:, 5,22,16) = (/ &
        & 0.37953e+03,0.56918e+03,0.58746e+03,0.88775e+03,0.11742e+04 /)
      kbo(:, 1,23,16) = (/ &
        & 0.42018e+03,0.21434e+03,0.60456e+03,0.89198e+03,0.11798e+04 /)
      kbo(:, 2,23,16) = (/ &
        & 0.10252e+04,0.32427e+03,0.60375e+03,0.89142e+03,0.11791e+04 /)
      kbo(:, 3,23,16) = (/ &
        & 0.25811e+03,0.61743e+03,0.60318e+03,0.89055e+03,0.11779e+04 /)
      kbo(:, 4,23,16) = (/ &
        & 0.60449e+03,0.28100e+03,0.60235e+03,0.88930e+03,0.11762e+04 /)
      kbo(:, 5,23,16) = (/ &
        & 0.43495e+03,0.18925e+03,0.60100e+03,0.88727e+03,0.11735e+04 /)
      kbo(:, 1,24,16) = (/ &
        & 0.68497e+03,0.77568e+03,0.60423e+03,0.89188e+03,0.11797e+04 /)
      kbo(:, 2,24,16) = (/ &
        & 0.27378e+03,0.43332e+03,0.60362e+03,0.89125e+03,0.11789e+04 /)
      kbo(:, 3,24,16) = (/ &
        & 0.44258e+03,0.48182e+03,0.60301e+03,0.89032e+03,0.11686e+04 /)
      kbo(:, 4,24,16) = (/ &
        & 0.38603e+03,0.34135e+03,0.59747e+03,0.88895e+03,0.11758e+04 /)
      kbo(:, 5,24,16) = (/ &
        & 0.39386e+03,0.54222e+03,0.60062e+03,0.88674e+03,0.11638e+04 /)
      kbo(:, 1,25,16) = (/ &
        & 0.55482e+03,0.53022e+03,0.60394e+03,0.89175e+03,0.11796e+04 /)
      kbo(:, 2,25,16) = (/ &
        & 0.90002e+03,0.91361e+02,0.60348e+03,0.89107e+03,0.11787e+04 /)
      kbo(:, 3,25,16) = (/ &
        & 0.17670e+03,0.51744e+03,0.59819e+03,0.89007e+03,0.11773e+04 /)
      kbo(:, 4,25,16) = (/ &
        & 0.44153e+03,0.41376e+03,0.59256e+03,0.88854e+03,0.11753e+04 /)
      kbo(:, 5,25,16) = (/ &
        & 0.24073e+03,0.21288e+03,0.60020e+03,0.88614e+03,0.11721e+04 /)
      kbo(:, 1,26,16) = (/ &
        & 0.37725e+03,0.61445e+03,0.60383e+03,0.89161e+03,0.11703e+04 /)
      kbo(:, 2,26,16) = (/ &
        & 0.10269e+04,0.42565e+03,0.59868e+03,0.89085e+03,0.11784e+04 /)
      kbo(:, 3,26,16) = (/ &
        & 0.49719e+03,0.26744e+03,0.60261e+03,0.88977e+03,0.11769e+04 /)
      kbo(:, 4,26,16) = (/ &
        & 0.41684e+03,0.19443e+03,0.59685e+03,0.88123e+03,0.11746e+04 /)
      kbo(:, 5,26,16) = (/ &
        & 0.32855e+03,0.57095e+03,0.59973e+03,0.88545e+03,0.11622e+04 /)
      kbo(:, 1,27,16) = (/ &
        & 0.60914e+03,0.57105e+03,0.60371e+03,0.89145e+03,0.11792e+04 /)
      kbo(:, 2,27,16) = (/ &
        & 0.26439e+03,0.15182e+03,0.60316e+03,0.89062e+03,0.11781e+04 /)
      kbo(:, 3,27,16) = (/ &
        & 0.73685e+03,0.69813e+03,0.60238e+03,0.88259e+03,0.11765e+04 /)
      kbo(:, 4,27,16) = (/ &
        & 0.64054e+03,0.28524e+03,0.60110e+03,0.88751e+03,0.11649e+04 /)
      kbo(:, 5,27,16) = (/ &
        & 0.75244e+03,0.50359e+03,0.59461e+03,0.87791e+03,0.11702e+04 /)
      kbo(:, 1,28,16) = (/ &
        & 0.64046e+03,0.15170e+03,0.60358e+03,0.89127e+03,0.11790e+04 /)
      kbo(:, 2,28,16) = (/ &
        & 0.70429e+03,0.23052e+03,0.60299e+03,0.89037e+03,0.11687e+04 /)
      kbo(:, 3,28,16) = (/ &
        & 0.44006e+03,0.41240e+03,0.60212e+03,0.88904e+03,0.11760e+04 /)
      kbo(:, 4,28,16) = (/ &
        & 0.22398e+03,0.59419e+03,0.60069e+03,0.88691e+03,0.11731e+04 /)
      kbo(:, 5,28,16) = (/ &
        & 0.55183e+03,0.13336e+03,0.59871e+03,0.87038e+03,0.11692e+04 /)
      kbo(:, 1,29,16) = (/ &
        & 0.59987e+03,0.49106e+03,0.60344e+03,0.89107e+03,0.11787e+04 /)
      kbo(:, 2,29,16) = (/ &
        & 0.34384e+03,0.96976e+02,0.60280e+03,0.89009e+03,0.11774e+04 /)
      kbo(:, 3,29,16) = (/ &
        & 0.54363e+03,0.20603e+03,0.60181e+03,0.88860e+03,0.11754e+04 /)
      kbo(:, 4,29,16) = (/ &
        & 0.10391e+04,0.38775e+03,0.60023e+03,0.88623e+03,0.11632e+04 /)
      kbo(:, 5,29,16) = (/ &
        & 0.22377e+03,0.17567e+03,0.59820e+03,0.88324e+03,0.11684e+04 /)
      kbo(:, 1,30,16) = (/ &
        & 0.63138e+03,0.68455e+03,0.60329e+03,0.89085e+03,0.11784e+04 /)
      kbo(:, 2,30,16) = (/ &
        & 0.58332e+03,0.21199e+03,0.60259e+03,0.88978e+03,0.11770e+04 /)
      kbo(:, 3,30,16) = (/ &
        & 0.33555e+03,0.46024e+03,0.59221e+03,0.88809e+03,0.11657e+04 /)
      kbo(:, 4,30,16) = (/ &
        & 0.44733e+03,0.32696e+03,0.59512e+03,0.88550e+03,0.11713e+04 /)
      kbo(:, 5,30,16) = (/ &
        & 0.79071e+03,0.72043e+03,0.59773e+03,0.85548e+03,0.11586e+04 /)
      kbo(:, 1,31,16) = (/ &
        & 0.81471e+03,0.68414e+03,0.60312e+03,0.89060e+03,0.11781e+04 /)
      kbo(:, 2,31,16) = (/ &
        & 0.44722e+03,0.73246e+03,0.60235e+03,0.88942e+03,0.11765e+04 /)
      kbo(:, 3,31,16) = (/ &
        & 0.48709e+03,0.24210e+03,0.60108e+03,0.88068e+03,0.11739e+04 /)
      kbo(:, 4,31,16) = (/ &
        & 0.63873e+03,0.56888e+03,0.59920e+03,0.88472e+03,0.11702e+04 /)
      kbo(:, 5,31,16) = (/ &
        & 0.72647e+03,0.26020e+03,0.59739e+03,0.78035e+03,0.11669e+04 /)
      kbo(:, 1,32,16) = (/ &
        & 0.10219e+04,0.29652e+03,0.60294e+03,0.89034e+03,0.11777e+04 /)
      kbo(:, 2,32,16) = (/ &
        & 0.75833e+03,0.13311e+03,0.59281e+03,0.88900e+03,0.11759e+04 /)
      kbo(:, 3,32,16) = (/ &
        & 0.54275e+03,0.31460e+03,0.59602e+03,0.88686e+03,0.11731e+04 /)
      kbo(:, 4,32,16) = (/ &
        & 0.28731e+03,0.15124e+03,0.59865e+03,0.87712e+03,0.11692e+04 /)
      kbo(:, 5,32,16) = (/ &
        & 0.79004e+03,0.63514e+03,0.58791e+03,0.86135e+03,0.11214e+04 /)
      kbo(:, 1,33,16) = (/ &
        & 0.42295e+03,0.52022e+03,0.60275e+03,0.88319e+03,0.11773e+04 /)
      kbo(:, 2,33,16) = (/ &
        & 0.72614e+03,0.33266e+03,0.60175e+03,0.88169e+03,0.11753e+04 /)
      kbo(:, 3,33,16) = (/ &
        & 0.36703e+03,0.22982e+03,0.59554e+03,0.88614e+03,0.11721e+04 /)
      kbo(:, 4,33,16) = (/ &
        & 0.23137e+03,0.32656e+03,0.59813e+03,0.88315e+03,0.11503e+04 /)
      kbo(:, 5,33,16) = (/ &
        & 0.98125e+03,0.60471e+03,0.59681e+03,0.86770e+03,0.11478e+04 /)
      kbo(:, 1,34,16) = (/ &
        & 0.44676e+03,0.16327e+03,0.59792e+03,0.88976e+03,0.11770e+04 /)
      kbo(:, 2,34,16) = (/ &
        & 0.27122e+03,0.52002e+03,0.60144e+03,0.88807e+03,0.11747e+04 /)
      kbo(:, 3,34,16) = (/ &
        & 0.89338e+03,0.37487e+03,0.59509e+03,0.87866e+03,0.11622e+04 /)
      kbo(:, 4,34,16) = (/ &
        & 0.43071e+03,0.56832e+03,0.58850e+03,0.83509e+03,0.10958e+04 /)
      kbo(:, 5,34,16) = (/ &
        & 0.20737e+03,0.35064e+03,0.59655e+03,0.88088e+03,0.11652e+04 /)
      kbo(:, 1,35,16) = (/ &
        & 0.79758e+02,0.10278e+03,0.60244e+03,0.87589e+03,0.11767e+04 /)
      kbo(:, 2,35,16) = (/ &
        & 0.52637e+03,0.56826e+03,0.60124e+03,0.88778e+03,0.11743e+04 /)
      kbo(:, 3,35,16) = (/ &
        & 0.43064e+03,0.29620e+03,0.59943e+03,0.88508e+03,0.11707e+04 /)
      kbo(:, 4,35,16) = (/ &
        & 0.21531e+03,0.74954e+03,0.57453e+03,0.86197e+03,0.11223e+04 /)
      kbo(:, 5,35,16) = (/ &
        & 0.85323e+03,0.27200e+03,0.59640e+03,0.88066e+03,0.11649e+04 /)
      kbo(:, 1,36,16) = (/ &
        & 0.99678e+03,0.21760e+03,0.60242e+03,0.88955e+03,0.11767e+04 /)
      kbo(:, 2,36,16) = (/ &
        & 0.90902e+03,0.40496e+03,0.59196e+03,0.88090e+03,0.11742e+04 /)
      kbo(:, 3,36,16) = (/ &
        & 0.38273e+03,0.60439e+03,0.59478e+03,0.87820e+03,0.11706e+04 /)
      kbo(:, 4,36,16) = (/ &
        & 0.84516e+03,0.25383e+03,0.58829e+03,0.79406e+03,0.11312e+04 /)
      kbo(:, 5,36,16) = (/ &
        & 0.45445e+03,0.41700e+03,0.59637e+03,0.88062e+03,0.11559e+04 /)
      kbo(:, 1,37,16) = (/ &
        & 0.62987e+03,0.44723e+03,0.59790e+03,0.88973e+03,0.11769e+04 /)
      kbo(:, 2,37,16) = (/ &
        & 0.80524e+03,0.68894e+03,0.59677e+03,0.88802e+03,0.11746e+04 /)
      kbo(:, 3,37,16) = (/ &
        & 0.18337e+03,0.45323e+03,0.59504e+03,0.88541e+03,0.11712e+04 /)
      kbo(:, 4,37,16) = (/ &
        & 0.50224e+03,0.16920e+03,0.59765e+03,0.86220e+03,0.11586e+04 /)
      kbo(:, 5,37,16) = (/ &
        & 0.85299e+03,0.22358e+03,0.59652e+03,0.88084e+03,0.11652e+04 /)
      kbo(:, 1,38,16) = (/ &
        & 0.91678e+03,0.47738e+03,0.59801e+03,0.88990e+03,0.11681e+04 /)
      kbo(:, 2,38,16) = (/ &
        & 0.47033e+03,0.39881e+03,0.59234e+03,0.88147e+03,0.11750e+04 /)
      kbo(:, 3,38,16) = (/ &
        & 0.69352e+03,0.66467e+03,0.59993e+03,0.87901e+03,0.11717e+04 /)
      kbo(:, 4,38,16) = (/ &
        & 0.48625e+03,0.32628e+03,0.59330e+03,0.86251e+03,0.11590e+04 /)
      kbo(:, 5,38,16) = (/ &
        & 0.31087e+03,0.44108e+03,0.58749e+03,0.88107e+03,0.11655e+04 /)
      kbo(:, 1,39,16) = (/ &
        & 0.35870e+03,0.11480e+03,0.60275e+03,0.89007e+03,0.11774e+04 /)
      kbo(:, 2,39,16) = (/ &
        & 0.37464e+03,0.78547e+03,0.59714e+03,0.88174e+03,0.11754e+04 /)
      kbo(:, 3,39,16) = (/ &
        & 0.10123e+04,0.30814e+03,0.59558e+03,0.87940e+03,0.11722e+04 /)
      kbo(:, 4,39,16) = (/ &
        & 0.17535e+03,0.96668e+02,0.59817e+03,0.88323e+03,0.11594e+04 /)
      kbo(:, 5,39,16) = (/ &
        & 0.36664e+03,0.56187e+03,0.58764e+03,0.86774e+03,0.11658e+04 /)
      kbo(:, 1,40,16) = (/ &
        & 0.48620e+03,0.57396e+03,0.60293e+03,0.89033e+03,0.11777e+04 /)
      kbo(:, 2,40,16) = (/ &
        & 0.94847e+03,0.62832e+03,0.60206e+03,0.88901e+03,0.11760e+04 /)
      kbo(:, 3,40,16) = (/ &
        & 0.54197e+03,0.51352e+03,0.60063e+03,0.88687e+03,0.11731e+04 /)
      kbo(:, 4,40,16) = (/ &
        & 0.21519e+03,0.61017e+03,0.58944e+03,0.86354e+03,0.11692e+04 /)
      kbo(:, 5,40,16) = (/ &
        & 0.27098e+03,0.33831e+03,0.58331e+03,0.88170e+03,0.10587e+04 /)
      kbo(:, 1,41,16) = (/ &
        & 0.14346e+03,0.26582e+03,0.60309e+03,0.89059e+03,0.11781e+04 /)
      kbo(:, 2,41,16) = (/ &
        & 0.76510e+03,0.70682e+03,0.60232e+03,0.88941e+03,0.11765e+04 /)
      kbo(:, 3,41,16) = (/ &
        & 0.62163e+03,0.16311e+03,0.60105e+03,0.88750e+03,0.11649e+04 /)
      kbo(:, 4,41,16) = (/ &
        & 0.87665e+02,0.19331e+03,0.59457e+03,0.88472e+03,0.11703e+04 /)
      kbo(:, 5,41,16) = (/ &
        & 0.10041e+04,0.44098e+03,0.58818e+03,0.72606e+03,0.10412e+04 /)
      kbo(:, 1,42,16) = (/ &
        & 0.66944e+03,0.41079e+03,0.60325e+03,0.89083e+03,0.11693e+04 /)
      kbo(:, 2,42,16) = (/ &
        & 0.51801e+03,0.25976e+03,0.60255e+03,0.88976e+03,0.11770e+04 /)
      kbo(:, 3,42,16) = (/ &
        & 0.23111e+03,0.27788e+03,0.58293e+03,0.88808e+03,0.11747e+04 /)
      kbo(:, 4,42,16) = (/ &
        & 0.44627e+03,0.35036e+03,0.59971e+03,0.87868e+03,0.11713e+04 /)
      kbo(:, 5,42,16) = (/ &
        & 0.75706e+03,0.77924e+03,0.59310e+03,0.87584e+03,0.11676e+04 /)
      kbo(:, 1,43,16) = (/ &
        & 0.60566e+03,0.10873e+03,0.60342e+03,0.89110e+03,0.11697e+04 /)
      kbo(:, 2,43,16) = (/ &
        & 0.92441e+03,0.64634e+03,0.59816e+03,0.89014e+03,0.11775e+04 /)
      kbo(:, 3,43,16) = (/ &
        & 0.18329e+03,0.35035e+03,0.59722e+03,0.88869e+03,0.11755e+04 /)
      kbo(:, 4,43,16) = (/ &
        & 0.34266e+03,0.17517e+03,0.59569e+03,0.87957e+03,0.11725e+04 /)
      kbo(:, 5,43,16) = (/ &
        & 0.92438e+03,0.90606e+02,0.59829e+03,0.88341e+03,0.11057e+04 /)
      kbo(:, 1,44,16) = (/ &
        & 0.38251e+03,0.19934e+03,0.60359e+03,0.89135e+03,0.11791e+04 /)
      kbo(:, 2,44,16) = (/ &
        & 0.48609e+03,0.71881e+03,0.59839e+03,0.89050e+03,0.11689e+04 /)
      kbo(:, 3,44,16) = (/ &
        & 0.54984e+03,0.19933e+03,0.59759e+03,0.88926e+03,0.11763e+04 /)
      kbo(:, 4,44,16) = (/ &
        & 0.85264e+03,0.64027e+03,0.60090e+03,0.88045e+03,0.11736e+04 /)
      kbo(:, 5,44,16) = (/ &
        & 0.88451e+03,0.49530e+03,0.59898e+03,0.87082e+03,0.11699e+04 /)
      kbo(:, 1,45,16) = (/ &
        & 0.66936e+03,0.51946e+03,0.60373e+03,0.89157e+03,0.11794e+04 /)
      kbo(:, 2,45,16) = (/ &
        & 0.95622e+03,0.66442e+03,0.60324e+03,0.89082e+03,0.11784e+04 /)
      kbo(:, 3,45,16) = (/ &
        & 0.70122e+03,0.25973e+03,0.60254e+03,0.88974e+03,0.11769e+04 /)
      kbo(:, 4,45,16) = (/ &
        & 0.13546e+03,0.47717e+03,0.59679e+03,0.88805e+03,0.11747e+04 /)
      kbo(:, 5,45,16) = (/ &
        & 0.44623e+03,0.47716e+03,0.59968e+03,0.87864e+03,0.11712e+04 /)
      kbo(:, 1,46,16) = (/ &
        & 0.16734e+03,0.11476e+03,0.60389e+03,0.89176e+03,0.11797e+04 /)
      kbo(:, 2,46,16) = (/ &
        & 0.41435e+03,0.59796e+03,0.60344e+03,0.89112e+03,0.11697e+04 /)
      kbo(:, 3,46,16) = (/ &
        & 0.78886e+03,0.13892e+03,0.60282e+03,0.89018e+03,0.11775e+04 /)
      kbo(:, 4,46,16) = (/ &
        & 0.48606e+03,0.76103e+03,0.59263e+03,0.88876e+03,0.11756e+04 /)
      kbo(:, 5,46,16) = (/ &
        & 0.77291e+03,0.68855e+03,0.59113e+03,0.88648e+03,0.11726e+04 /)
      kbo(:, 1,47,16) = (/ &
        & 0.80479e+03,0.70064e+03,0.60443e+03,0.89194e+03,0.11799e+04 /)
      kbo(:, 2,47,16) = (/ &
        & 0.74901e+03,0.35032e+03,0.60363e+03,0.89142e+03,0.11792e+04 /)
      kbo(:, 3,47,16) = (/ &
        & 0.62948e+03,0.48923e+03,0.60309e+03,0.89059e+03,0.11690e+04 /)
      kbo(:, 4,47,16) = (/ &
        & 0.87648e+02,0.36239e+03,0.60232e+03,0.88257e+03,0.11584e+04 /)
      kbo(:, 5,47,16) = (/ &
        & 0.44621e+03,0.42279e+03,0.60106e+03,0.88751e+03,0.11740e+04 /)
      kbo(:, 1,48,16) = (/ &
        & 0.39044e+03,0.31407e+03,0.60497e+03,0.89220e+03,0.11803e+04 /)
      kbo(:, 2,48,16) = (/ &
        & 0.28685e+03,0.50131e+03,0.60379e+03,0.89166e+03,0.11795e+04 /)
      kbo(:, 3,48,16) = (/ &
        & 0.38246e+03,0.70665e+03,0.60333e+03,0.89096e+03,0.11786e+04 /)
      kbo(:, 4,48,16) = (/ &
        & 0.47011e+03,0.61002e+03,0.60267e+03,0.88995e+03,0.11772e+04 /)
      kbo(:, 5,48,16) = (/ &
        & 0.36652e+03,0.63417e+03,0.60164e+03,0.88155e+03,0.11751e+04 /)
      kbo(:, 1,49,16) = (/ &
        & 0.76492e+03,0.96636e+02,0.60550e+03,0.89270e+03,0.11810e+04 /)
      kbo(:, 2,49,16) = (/ &
        & 0.23107e+03,0.19931e+03,0.60416e+03,0.89186e+03,0.11798e+04 /)
      kbo(:, 3,49,16) = (/ &
        & 0.86850e+03,0.30199e+03,0.59890e+03,0.89128e+03,0.11790e+04 /)
      kbo(:, 4,49,16) = (/ &
        & 0.27091e+03,0.22951e+03,0.60296e+03,0.89040e+03,0.11778e+04 /)
      kbo(:, 5,49,16) = (/ &
        & 0.45416e+03,0.53149e+03,0.60212e+03,0.88227e+03,0.11761e+04 /)
      kbo(:, 1,50,16) = (/ &
        & 0.39042e+03,0.12079e+03,0.60601e+03,0.89316e+03,0.11816e+04 /)
      kbo(:, 2,50,16) = (/ &
        & 0.38245e+03,0.73080e+03,0.60467e+03,0.89201e+03,0.11709e+04 /)
      kbo(:, 3,50,16) = (/ &
        & 0.19919e+03,0.50733e+03,0.60370e+03,0.89153e+03,0.11703e+04 /)
      kbo(:, 4,50,16) = (/ &
        & 0.52587e+03,0.41673e+03,0.60320e+03,0.89076e+03,0.11693e+04 /)
      kbo(:, 5,50,16) = (/ &
        & 0.25497e+03,0.90594e+02,0.59785e+03,0.88966e+03,0.11768e+04 /)
      kbo(:, 1,51,16) = (/ &
        & 0.35058e+03,0.56772e+03,0.60650e+03,0.89405e+03,0.11830e+04 /)
      kbo(:, 2,51,16) = (/ &
        & 0.39839e+03,0.52545e+03,0.60516e+03,0.89238e+03,0.11806e+04 /)
      kbo(:, 3,51,16) = (/ &
        & 0.69319e+03,0.65831e+03,0.60384e+03,0.89174e+03,0.11796e+04 /)
      kbo(:, 4,51,16) = (/ &
        & 0.66132e+03,0.42881e+03,0.60341e+03,0.89108e+03,0.11788e+04 /)
      kbo(:, 5,51,16) = (/ &
        & 0.80473e+03,0.49524e+03,0.59814e+03,0.88327e+03,0.11775e+04 /)
      kbo(:, 1,52,16) = (/ &
        & 0.75693e+03,0.32010e+03,0.60698e+03,0.89551e+03,0.11849e+04 /)
      kbo(:, 2,52,16) = (/ &
        & 0.98002e+03,0.74890e+03,0.60565e+03,0.89283e+03,0.11812e+04 /)
      kbo(:, 3,52,16) = (/ &
        & 0.42228e+03,0.32613e+03,0.60430e+03,0.89190e+03,0.11799e+04 /)
      kbo(:, 4,52,16) = (/ &
        & 0.43025e+03,0.70662e+03,0.60359e+03,0.89136e+03,0.11791e+04 /)
      kbo(:, 5,52,16) = (/ &
        & 0.81269e+03,0.56167e+03,0.60303e+03,0.89051e+03,0.11780e+04 /)
      kbo(:, 1,53,16) = (/ &
        & 0.98002e+03,0.61603e+03,0.60747e+03,0.89705e+03,0.11870e+04 /)
      kbo(:, 2,53,16) = (/ &
        & 0.28683e+03,0.42277e+03,0.60613e+03,0.89328e+03,0.11818e+04 /)
      kbo(:, 3,53,16) = (/ &
        & 0.45415e+03,0.68246e+03,0.60479e+03,0.89204e+03,0.11801e+04 /)
      kbo(:, 4,53,16) = (/ &
        & 0.78879e+03,0.48920e+03,0.60374e+03,0.89159e+03,0.11794e+04 /)
      kbo(:, 5,53,16) = (/ &
        & 0.76488e+03,0.14495e+03,0.60326e+03,0.89085e+03,0.11694e+04 /)
      kbo(:, 1,54,16) = (/ &
        & 0.67724e+03,0.76701e+03,0.60808e+03,0.89852e+03,0.11890e+04 /)
      kbo(:, 2,54,16) = (/ &
        & 0.81269e+03,0.24762e+03,0.60658e+03,0.89430e+03,0.11833e+04 /)
      kbo(:, 3,54,16) = (/ &
        & 0.94813e+03,0.63414e+03,0.60524e+03,0.89246e+03,0.11807e+04 /)
      kbo(:, 4,54,16) = (/ &
        & 0.49398e+03,0.28989e+03,0.60390e+03,0.88491e+03,0.11797e+04 /)
      kbo(:, 5,54,16) = (/ &
        & 0.89236e+03,0.27781e+03,0.60344e+03,0.88428e+03,0.11788e+04 /)
      kbo(:, 1,55,16) = (/ &
        & 0.52586e+03,0.77305e+03,0.60906e+03,0.89999e+03,0.11909e+04 /)
      kbo(:, 2,55,16) = (/ &
        & 0.54179e+03,0.64018e+03,0.60701e+03,0.89560e+03,0.11851e+04 /)
      kbo(:, 3,55,16) = (/ &
        & 0.50992e+03,0.60394e+03,0.60567e+03,0.88598e+03,0.11812e+04 /)
      kbo(:, 4,55,16) = (/ &
        & 0.63740e+03,0.44088e+03,0.60433e+03,0.89191e+03,0.11799e+04 /)
      kbo(:, 5,55,16) = (/ &
        & 0.49398e+03,0.37444e+03,0.59895e+03,0.89137e+03,0.11791e+04 /)
      kbo(:, 1,56,16) = (/ &
        & 0.90829e+03,0.27177e+03,0.61007e+03,0.90151e+03,0.11929e+04 /)
      kbo(:, 2,56,16) = (/ &
        & 0.35854e+03,0.24158e+03,0.60744e+03,0.89694e+03,0.11869e+04 /)
      kbo(:, 3,56,16) = (/ &
        & 0.59756e+03,0.47107e+03,0.60610e+03,0.89325e+03,0.11817e+04 /)
      kbo(:, 4,56,16) = (/ &
        & 0.52585e+03,0.35632e+03,0.60476e+03,0.89203e+03,0.11801e+04 /)
      kbo(:, 5,56,16) = (/ &
        & 0.27886e+03,0.24761e+03,0.59909e+03,0.89157e+03,0.11794e+04 /)
      kbo(:, 1,57,16) = (/ &
        & 0.34260e+03,0.66433e+03,0.61112e+03,0.90308e+03,0.11950e+04 /)
      kbo(:, 2,57,16) = (/ &
        & 0.66130e+03,0.45295e+03,0.60796e+03,0.89834e+03,0.11887e+04 /)
      kbo(:, 3,57,16) = (/ &
        & 0.69317e+03,0.42880e+03,0.60653e+03,0.89415e+03,0.11831e+04 /)
      kbo(:, 4,57,16) = (/ &
        & 0.27089e+03,0.28385e+03,0.60519e+03,0.89241e+03,0.11806e+04 /)
      kbo(:, 5,57,16) = (/ &
        & 0.66926e+03,0.34424e+03,0.60385e+03,0.89175e+03,0.11797e+04 /)
      kbo(:, 1,58,16) = (/ &
        & 0.96406e+03,0.25365e+03,0.61214e+03,0.90462e+03,0.11971e+04 /)
      kbo(:, 2,58,16) = (/ &
        & 0.31073e+03,0.28385e+03,0.60888e+03,0.89972e+03,0.11906e+04 /)
      kbo(:, 3,58,16) = (/ &
        & 0.96405e+03,0.57374e+03,0.60693e+03,0.89536e+03,0.11848e+04 /)
      kbo(:, 4,58,16) = (/ &
        & 0.69316e+03,0.13891e+03,0.60560e+03,0.89278e+03,0.11811e+04 /)
      kbo(:, 5,58,16) = (/ &
        & 0.59755e+03,0.75492e+03,0.60426e+03,0.89189e+03,0.11798e+04 /)
      kbo(:, 1,59,16) = (/ &
        & 0.92422e+03,0.39860e+03,0.61256e+03,0.90525e+03,0.11979e+04 /)
      kbo(:, 2,59,16) = (/ &
        & 0.78877e+03,0.42275e+03,0.60926e+03,0.90029e+03,0.11913e+04 /)
      kbo(:, 3,59,16) = (/ &
        & 0.35853e+03,0.65225e+03,0.60710e+03,0.89586e+03,0.11854e+04 /)
      kbo(:, 4,59,16) = (/ &
        & 0.54975e+03,0.50730e+03,0.60576e+03,0.88606e+03,0.11813e+04 /)
      kbo(:, 5,59,16) = (/ &
        & 0.52585e+03,0.62205e+03,0.60442e+03,0.89194e+03,0.11799e+04 /)
     
      end subroutine sw_kgb28
