!     path:      $Source$
!     author:    $Author$
!     revision:  $Revision$
!     created:   $Date$

!----------------------------------------------------------------------------
! Copyright (c) 2002-2016, Atmospheric & Environmental Research, Inc. (AER)
! All rights reserved.
!
! Redistribution and use in source and binary forms, with or without
! modification, are permitted provided that the following conditions are met:
!  * Redistributions of source code must retain the above copyright
!    notice, this list of conditions and the following disclaimer.
!  * Redistributions in binary form must reproduce the above copyright
!    notice, this list of conditions and the following disclaimer in the
!    documentation and/or other materials provided with the distribution.
!  * Neither the name of Atmospheric & Environmental Research, Inc., nor
!    the names of its contributors may be used to endorse or promote products
!    derived from this software without specific prior written permission.
!
! THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
! AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
! IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
! ARE DISCLAIMED. IN NO EVENT SHALL ATMOSPHERIC & ENVIRONMENTAL RESEARCH, INC., 
! BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
! CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
! SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
! INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
! CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
! ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
! THE POSSIBILITY OF SUCH DAMAGE.
!                        (http://www.rtweb.aer.com/)                        
!----------------------------------------------------------------------------

! **************************************************************************
!      subroutine sw_kgbnn
! **************************************************************************
!  RRTM Shortwave Radiative Transfer Model
!  Atmospheric and Environmental Research, Inc., Cambridge, MA
!
!  Original by J.Delamere, Atmospheric & Environmental Research.
!  Reformatted for F90: JJMorcrette, ECMWF
!  Further F90 and GCM revisions:  MJIacono, AER, July 2002
!  Solar variability revisions:  MJIacono, AER, November 2015
!
!  This file contains 14 subroutines that include the 
!  absorption coefficients and other data for each of the 14 shortwave
!  spectral bands used in RRTM_SW.  Here, the data are defined for 16
!  g-points, or sub-intervals, per band.  These data are combined and
!  weighted using a mapping procedure in routine RRTMG_SW_INIT to reduce
!  the total number of g-points from 224 to 112 for use in the GCM.
! **************************************************************************
      subroutine sw_kgb25
! **************************************************************************

      !use parkind, only : im => kind , rb => kind  
      use rrsw_kg25, only : kao, sfluxrefo, &
                            raylo, abso3ao, abso3bo, &
                            irradnceo, facbrghto, snsptdrko

      implicit none
      save

! Kurucz solar source function
      sfluxrefo(:) = (/ &
        & 42.6858 , 45.7720, 44.9872, 45.9662    , &
        & 46.5458 , 41.6926, 32.2893, 24.0928    , &
        & 16.7686 , 1.86048, 1.54057, 1.23503    , &
        & 0.915085,0.590099,0.218622, 3.21287e-02 /)

! Solar variability components: time-invariant baseline quiet sun irradiance
      irradnceo(:) = (/ &
        & 4.50862E+01, 4.53229E+01, 4.66453E+01, 4.85481E+01,&
        & 4.31689E+01, 3.74802E+01, 3.08809E+01, 2.43848E+01,&
        & 1.66307E+01, 1.82215E+00, 1.51046E+00, 1.19790E+00,&
        & 9.02913E-01, 5.79909E-01, 2.16922E-01, 3.17538E-02/)
! Solar variability components: facular brightening
      facbrghto(:) = (/ &
        & 2.89043E-02, 3.23890E-02, 3.29631E-02, 3.32879E-02,&
        & 3.01017E-02, 2.56200E-02, 2.09055E-02, 1.65318E-02,&
        & 1.12697E-02, 1.24066E-03, 1.03101E-03, 8.20302E-04,&
        & 6.05383E-04, 3.89241E-04, 1.46377E-04, 2.04616E-05/)
! Solar variability components: sunspot darkening
      snsptdrko(:) = (/ &
        &-2.49580E-02,-2.44274E-02,-2.38051E-02,-2.26940E-02,&
        &-2.02992E-02,-1.75466E-02,-1.44036E-02,-1.09606E-02,&
        &-7.44990E-03,-8.14537E-04,-6.74154E-04,-5.33676E-04,&
        &-3.91999E-04,-2.50130E-04,-9.43636E-05,-1.32350E-05/)

! Rayleigh extinction coefficient at v = 2925 cm-1.
      raylo(:) = (/ &
        & 9.81132e-07,8.25605e-07,6.71302e-07,5.53556e-07, & 
        & 3.97383e-07,3.68206e-07,4.42379e-07,4.57799e-07, &
        & 4.22683e-07,3.87113e-07,3.79810e-07,3.63192e-07, &
        & 3.51921e-07,3.34231e-07,3.34294e-07,3.32673e-07 /)
     
      abso3ao(:) = (/ &
        & 2.32664e-02,5.76154e-02,0.125389,0.250158, &
        & 0.378756   ,0.402196   ,0.352026,0.352036, &
        & 0.386253   ,0.414598   ,0.420079,0.435471, &
        & 0.445487   ,0.459549   ,0.452920,0.456838 /)

      abso3bo(:) = (/ &     
        & 1.76917e-02,4.64185e-02,1.03640e-01,0.189469, &
        & 0.303858   ,0.400248   ,0.447357   ,0.470009, &
        & 0.498673   ,0.515696   ,0.517053   ,0.517930, &
        & 0.518345   ,0.524952   ,0.508244   ,0.468981 /)

!     ------------------------------------------------------------------
!     The array KAO contains absorption coefs at the 16 chosen g-values 
!     for a range of pressure levels> ~100mb, temperatures, and binary
!     species parameters (see taumol.f for definition).  The first 
!     index in the array, JS, runs from 1 to 9, and corresponds to 
!     different values of the binary species parameter.  For instance, 
!     JS=1 refers to dry air, JS = 2 corresponds to the paramter value 1/8, 
!     JS = 3 corresponds to the parameter value 2/8, etc.  The second index
!     in the array, JT, which runs from 1 to 5, corresponds to different
!     temperatures.  More specifically, JT = 3 means that the data are for
!     the reference temperature TREF for this  pressure level, JT = 2 refers
!     to TREF-15, JT = 1 is for TREF-30, JT = 4 is for TREF+15, and JT = 5
!     is for TREF+30.  The third index, JP, runs from 1 to 13 and refers
!     to the JPth reference pressure level (see taumol.f for these levels
!     in mb).  The fourth index, IG, goes from 1 to 16, and indicates
!     which g-interval the absorption coefficients are for.
!     -----------------------------------------------------------------

      kao(:, 1, 1) = (/ &
        & 0.16461e-08,0.16782e-08,0.19339e-08,0.17100e-08,0.17045e-08 /)
      kao(:, 2, 1) = (/ &
        & 0.28759e-08,0.29469e-08,0.33789e-08,0.34357e-08,0.28833e-08 /)
      kao(:, 3, 1) = (/ &
        & 0.55148e-08,0.54808e-08,0.54190e-08,0.68260e-08,0.51972e-08 /)
      kao(:, 4, 1) = (/ &
        & 0.95336e-08,0.94552e-08,0.93001e-08,0.90961e-08,0.14451e-07 /)
      kao(:, 5, 1) = (/ &
        & 0.14930e-07,0.14736e-07,0.14432e-07,0.14074e-07,0.24102e-07 /)
      kao(:, 6, 1) = (/ &
        & 0.22770e-07,0.22301e-07,0.21778e-07,0.21194e-07,0.20569e-07 /)
      kao(:, 7, 1) = (/ &
        & 0.34699e-07,0.33951e-07,0.33124e-07,0.32144e-07,0.31220e-07 /)
      kao(:, 8, 1) = (/ &
        & 0.62339e-07,0.60405e-07,0.59548e-07,0.58214e-07,0.56977e-07 /)
      kao(:, 9, 1) = (/ &
        & 0.17411e-06,0.17654e-06,0.18315e-06,0.18100e-06,0.17839e-06 /)
      kao(:,10, 1) = (/ &
        & 0.23526e-06,0.22729e-06,0.21947e-06,0.21188e-06,0.20454e-06 /)
      kao(:,11, 1) = (/ &
        & 0.23535e-06,0.22737e-06,0.21956e-06,0.21196e-06,0.20461e-06 /)
      kao(:,12, 1) = (/ &
        & 0.23539e-06,0.22740e-06,0.21959e-06,0.21199e-06,0.20465e-06 /)
      kao(:,13, 1) = (/ &
        & 0.23543e-06,0.22744e-06,0.21962e-06,0.21202e-06,0.20467e-06 /)
      kao(:, 1, 2) = (/ &
        & 0.62912e-08,0.61559e-08,0.84640e-08,0.59240e-08,0.58217e-08 /)
      kao(:, 2, 2) = (/ &
        & 0.83749e-08,0.80756e-08,0.11623e-07,0.11272e-07,0.73636e-08 /)
      kao(:, 3, 2) = (/ &
        & 0.13304e-07,0.12795e-07,0.12343e-07,0.21235e-07,0.11577e-07 /)
      kao(:, 4, 2) = (/ &
        & 0.20704e-07,0.19736e-07,0.18900e-07,0.18228e-07,0.31601e-07 /)
      kao(:, 5, 2) = (/ &
        & 0.31149e-07,0.29669e-07,0.28318e-07,0.27101e-07,0.49649e-07 /)
      kao(:, 6, 2) = (/ &
        & 0.45713e-07,0.43519e-07,0.41488e-07,0.39918e-07,0.38291e-07 /)
      kao(:, 7, 2) = (/ &
        & 0.77265e-07,0.73848e-07,0.70437e-07,0.67945e-07,0.66127e-07 /)
      kao(:, 8, 2) = (/ &
        & 0.15754e-06,0.15664e-06,0.15378e-06,0.15027e-06,0.14633e-06 /)
      kao(:, 9, 2) = (/ &
        & 0.16439e-06,0.14678e-06,0.12610e-06,0.11532e-06,0.10591e-06 /)
      kao(:,10, 2) = (/ &
        & 0.14366e-06,0.13506e-06,0.12583e-06,0.11774e-06,0.11011e-06 /)
      kao(:,11, 2) = (/ &
        & 0.14521e-06,0.13766e-06,0.13072e-06,0.12218e-06,0.11400e-06 /)
      kao(:,12, 2) = (/ &
        & 0.14524e-06,0.13769e-06,0.13074e-06,0.12241e-06,0.11552e-06 /)
      kao(:,13, 2) = (/ &
        & 0.14525e-06,0.13770e-06,0.13075e-06,0.12252e-06,0.11553e-06 /)
      kao(:, 1, 3) = (/ &
        & 0.14060e-07,0.13587e-07,0.24644e-07,0.12716e-07,0.12367e-07 /)
      kao(:, 2, 3) = (/ &
        & 0.17055e-07,0.16577e-07,0.32443e-07,0.31273e-07,0.15381e-07 /)
      kao(:, 3, 3) = (/ &
        & 0.25414e-07,0.24672e-07,0.23874e-07,0.47281e-07,0.22346e-07 /)
      kao(:, 4, 3) = (/ &
        & 0.39536e-07,0.38124e-07,0.36836e-07,0.35587e-07,0.72260e-07 /)
      kao(:, 5, 3) = (/ &
        & 0.59488e-07,0.57630e-07,0.55623e-07,0.53878e-07,0.11230e-06 /)
      kao(:, 6, 3) = (/ &
        & 0.99996e-07,0.96206e-07,0.93184e-07,0.90812e-07,0.89206e-07 /)
      kao(:, 7, 3) = (/ &
        & 0.17678e-06,0.17554e-06,0.17358e-06,0.17091e-06,0.16830e-06 /)
      kao(:, 8, 3) = (/ &
        & 0.18672e-06,0.17850e-06,0.16967e-06,0.16275e-06,0.15875e-06 /)
      kao(:, 9, 3) = (/ &
        & 0.13558e-06,0.13493e-06,0.13633e-06,0.13799e-06,0.13932e-06 /)
      kao(:,10, 3) = (/ &
        & 0.18883e-06,0.20452e-06,0.22206e-06,0.24347e-06,0.26091e-06 /)
      kao(:,11, 3) = (/ &
        & 0.21296e-06,0.23580e-06,0.26439e-06,0.30148e-06,0.34942e-06 /)
      kao(:,12, 3) = (/ &
        & 0.22072e-06,0.25535e-06,0.28661e-06,0.34814e-06,0.39337e-06 /)
      kao(:,13, 3) = (/ &
        & 0.22515e-06,0.26161e-06,0.30833e-06,0.36527e-06,0.40123e-06 /)
      kao(:, 1, 4) = (/ &
        & 0.32735e-07,0.31345e-07,0.58846e-07,0.28258e-07,0.27022e-07 /)
      kao(:, 2, 4) = (/ &
        & 0.37754e-07,0.36873e-07,0.82776e-07,0.80947e-07,0.35190e-07 /)
      kao(:, 3, 4) = (/ &
        & 0.76368e-07,0.75292e-07,0.74075e-07,0.10820e-06,0.73183e-07 /)
      kao(:, 4, 4) = (/ &
        & 0.16392e-06,0.16130e-06,0.15926e-06,0.15700e-06,0.22041e-06 /)
      kao(:, 5, 4) = (/ &
        & 0.29704e-06,0.28924e-06,0.28301e-06,0.27633e-06,0.42284e-06 /)
      kao(:, 6, 4) = (/ &
        & 0.48466e-06,0.47240e-06,0.46143e-06,0.45012e-06,0.43867e-06 /)
      kao(:, 7, 4) = (/ &
        & 0.71637e-06,0.69847e-06,0.67384e-06,0.65368e-06,0.63375e-06 /)
      kao(:, 8, 4) = (/ &
        & 0.11904e-05,0.11714e-05,0.11524e-05,0.11354e-05,0.11172e-05 /)
      kao(:, 9, 4) = (/ &
        & 0.21976e-05,0.21606e-05,0.21332e-05,0.20944e-05,0.20536e-05 /)
      kao(:,10, 4) = (/ &
        & 0.21713e-05,0.21144e-05,0.20553e-05,0.19901e-05,0.19286e-05 /)
      kao(:,11, 4) = (/ &
        & 0.21443e-05,0.20785e-05,0.20048e-05,0.19232e-05,0.18295e-05 /)
      kao(:,12, 4) = (/ &
        & 0.21363e-05,0.20578e-05,0.19811e-05,0.18729e-05,0.17807e-05 /)
      kao(:,13, 4) = (/ &
        & 0.21319e-05,0.20513e-05,0.19580e-05,0.18546e-05,0.17725e-05 /)
      kao(:, 1, 5) = (/ &
        & 0.36050e-07,0.36125e-07,0.46253e-07,0.37280e-07,0.37359e-07 /)
      kao(:, 2, 5) = (/ &
        & 0.65102e-07,0.64266e-07,0.68896e-07,0.65925e-07,0.61190e-07 /)
      kao(:, 3, 5) = (/ &
        & 0.12173e-06,0.11889e-06,0.11625e-06,0.17574e-06,0.10921e-06 /)
      kao(:, 4, 5) = (/ &
        & 0.20555e-06,0.19853e-06,0.19068e-06,0.18313e-06,0.30241e-06 /)
      kao(:, 5, 5) = (/ &
        & 0.30900e-06,0.29996e-06,0.28857e-06,0.27772e-06,0.51631e-06 /)
      kao(:, 6, 5) = (/ &
        & 0.43774e-06,0.42465e-06,0.40920e-06,0.39315e-06,0.37901e-06 /)
      kao(:, 7, 5) = (/ &
        & 0.63869e-06,0.61654e-06,0.60324e-06,0.58966e-06,0.57948e-06 /)
      kao(:, 8, 5) = (/ &
        & 0.98362e-06,0.96271e-06,0.94180e-06,0.92206e-06,0.91105e-06 /)
      kao(:, 9, 5) = (/ &
        & 0.12061e-05,0.11895e-05,0.11564e-05,0.11296e-05,0.11110e-05 /)
      kao(:,10, 5) = (/ &
        & 0.12958e-05,0.12694e-05,0.12425e-05,0.12153e-05,0.11880e-05 /)
      kao(:,11, 5) = (/ &
        & 0.12962e-05,0.12698e-05,0.12429e-05,0.12156e-05,0.11883e-05 /)
      kao(:,12, 5) = (/ &
        & 0.12964e-05,0.12701e-05,0.12431e-05,0.12158e-05,0.11885e-05 /)
      kao(:,13, 5) = (/ &
        & 0.12966e-05,0.12702e-05,0.12433e-05,0.12160e-05,0.11886e-05 /)
      kao(:, 1, 6) = (/ &
        & 0.73925e-07,0.70231e-07,0.21454e-06,0.63477e-07,0.60912e-07 /)
      kao(:, 2, 6) = (/ &
        & 0.67794e-07,0.65807e-07,0.13854e-06,0.13061e-06,0.59361e-07 /)
      kao(:, 3, 6) = (/ &
        & 0.98353e-07,0.95275e-07,0.92426e-07,0.15768e-06,0.87986e-07 /)
      kao(:, 4, 6) = (/ &
        & 0.15855e-06,0.15394e-06,0.14948e-06,0.14655e-06,0.23172e-06 /)
      kao(:, 5, 6) = (/ &
        & 0.27764e-06,0.26941e-06,0.26299e-06,0.25975e-06,0.40526e-06 /)
      kao(:, 6, 6) = (/ &
        & 0.45469e-06,0.44417e-06,0.43276e-06,0.42440e-06,0.41489e-06 /)
      kao(:, 7, 6) = (/ &
        & 0.71540e-06,0.71291e-06,0.70656e-06,0.69823e-06,0.68342e-06 /)
      kao(:, 8, 6) = (/ &
        & 0.79651e-06,0.79807e-06,0.80621e-06,0.80941e-06,0.79835e-06 /)
      kao(:, 9, 6) = (/ &
        & 0.18716e-06,0.16713e-06,0.14725e-06,0.13728e-06,0.11763e-06 /)
      kao(:,10, 6) = (/ &
        & 0.92638e-07,0.86207e-07,0.80877e-07,0.70432e-07,0.64517e-07 /)
      kao(:,11, 6) = (/ &
        & 0.13396e-06,0.12820e-06,0.12387e-06,0.10427e-06,0.94091e-07 /)
      kao(:,12, 6) = (/ &
        & 0.14877e-06,0.14827e-06,0.14350e-06,0.12154e-06,0.10552e-06 /)
      kao(:,13, 6) = (/ &
        & 0.15437e-06,0.15323e-06,0.14992e-06,0.12715e-06,0.10933e-06 /)
      kao(:, 1, 7) = (/ &
        & 0.72717e-06,0.70656e-06,0.13933e-05,0.66449e-06,0.64269e-06 /)
      kao(:, 2, 7) = (/ &
        & 0.52595e-06,0.50791e-06,0.11171e-05,0.10538e-05,0.45644e-06 /)
      kao(:, 3, 7) = (/ &
        & 0.29919e-06,0.29227e-06,0.28284e-06,0.65215e-06,0.26347e-06 /)
      kao(:, 4, 7) = (/ &
        & 0.27961e-06,0.27579e-06,0.27068e-06,0.26343e-06,0.41265e-06 /)
      kao(:, 5, 7) = (/ &
        & 0.37031e-06,0.36318e-06,0.35475e-06,0.34488e-06,0.53740e-06 /)
      kao(:, 6, 7) = (/ &
        & 0.53195e-06,0.52692e-06,0.52224e-06,0.51934e-06,0.51146e-06 /)
      kao(:, 7, 7) = (/ &
        & 0.83043e-06,0.84552e-06,0.84833e-06,0.82800e-06,0.80930e-06 /)
      kao(:, 8, 7) = (/ &
        & 0.14910e-05,0.15179e-05,0.15248e-05,0.15091e-05,0.14853e-05 /)
      kao(:, 9, 7) = (/ &
        & 0.37340e-05,0.37823e-05,0.38311e-05,0.38453e-05,0.38567e-05 /)
      kao(:,10, 7) = (/ &
        & 0.86791e-05,0.89697e-05,0.92118e-05,0.93991e-05,0.95564e-05 /)
      kao(:,11, 7) = (/ &
        & 0.11878e-04,0.12201e-04,0.12588e-04,0.12897e-04,0.13151e-04 /)
      kao(:,12, 7) = (/ &
        & 0.13192e-04,0.13732e-04,0.14137e-04,0.14465e-04,0.14643e-04 /)
      kao(:,13, 7) = (/ &
        & 0.13716e-04,0.14229e-04,0.14617e-04,0.14944e-04,0.15182e-04 /)
      kao(:, 1, 8) = (/ &
        & 0.39538e-05,0.38949e-05,0.56188e-05,0.37475e-05,0.36648e-05 /)
      kao(:, 2, 8) = (/ &
        & 0.34231e-05,0.33633e-05,0.51877e-05,0.50048e-05,0.31425e-05 /)
      kao(:, 3, 8) = (/ &
        & 0.28073e-05,0.27497e-05,0.26875e-05,0.44405e-05,0.25492e-05 /)
      kao(:, 4, 8) = (/ &
        & 0.19229e-05,0.18818e-05,0.18382e-05,0.17896e-05,0.33073e-05 /)
      kao(:, 5, 8) = (/ &
        & 0.11453e-05,0.11293e-05,0.11095e-05,0.10866e-05,0.19344e-05 /)
      kao(:, 6, 8) = (/ &
        & 0.14565e-05,0.14517e-05,0.14369e-05,0.14141e-05,0.13944e-05 /)
      kao(:, 7, 8) = (/ &
        & 0.23228e-05,0.22753e-05,0.22395e-05,0.22124e-05,0.21731e-05 /)
      kao(:, 8, 8) = (/ &
        & 0.34877e-05,0.34362e-05,0.33796e-05,0.33389e-05,0.32924e-05 /)
      kao(:, 9, 8) = (/ &
        & 0.63448e-05,0.63701e-05,0.63619e-05,0.62632e-05,0.61645e-05 /)
      kao(:,10, 8) = (/ &
        & 0.12155e-04,0.11880e-04,0.11762e-04,0.11759e-04,0.11651e-04 /)
      kao(:,11, 8) = (/ &
        & 0.14093e-04,0.13835e-04,0.13547e-04,0.13205e-04,0.12690e-04 /)
      kao(:,12, 8) = (/ &
        & 0.14428e-04,0.14056e-04,0.13932e-04,0.13396e-04,0.12885e-04 /)
      kao(:,13, 8) = (/ &
        & 0.15229e-04,0.14534e-04,0.13849e-04,0.13292e-04,0.12704e-04 /)
      kao(:, 1, 9) = (/ &
        & 0.19250e-04,0.19148e-04,0.21702e-04,0.18906e-04,0.18761e-04 /)
      kao(:, 2, 9) = (/ &
        & 0.18132e-04,0.18040e-04,0.20884e-04,0.20523e-04,0.17656e-04 /)
      kao(:, 3, 9) = (/ &
        & 0.16928e-04,0.16843e-04,0.16742e-04,0.19715e-04,0.16470e-04 /)
      kao(:, 4, 9) = (/ &
        & 0.15526e-04,0.15463e-04,0.15377e-04,0.15268e-04,0.18367e-04 /)
      kao(:, 5, 9) = (/ &
        & 0.13545e-04,0.13511e-04,0.13455e-04,0.13362e-04,0.16722e-04 /)
      kao(:, 6, 9) = (/ &
        & 0.97183e-05,0.97218e-05,0.97084e-05,0.96717e-05,0.96030e-05 /)
      kao(:, 7, 9) = (/ &
        & 0.50307e-05,0.50984e-05,0.51628e-05,0.52093e-05,0.52354e-05 /)
      kao(:, 8, 9) = (/ &
        & 0.45837e-05,0.45939e-05,0.45938e-05,0.45639e-05,0.45109e-05 /)
      kao(:, 9, 9) = (/ &
        & 0.12254e-04,0.12319e-04,0.12397e-04,0.12584e-04,0.12620e-04 /)
      kao(:,10, 9) = (/ &
        & 0.21545e-04,0.21836e-04,0.21718e-04,0.21511e-04,0.21211e-04 /)
      kao(:,11, 9) = (/ &
        & 0.20079e-04,0.19539e-04,0.18859e-04,0.18393e-04,0.18181e-04 /)
      kao(:,12, 9) = (/ &
        & 0.17115e-04,0.16357e-04,0.15410e-04,0.15220e-04,0.15207e-04 /)
      kao(:,13, 9) = (/ &
        & 0.14935e-04,0.14679e-04,0.14593e-04,0.14448e-04,0.14436e-04 /)
      kao(:, 1,10) = (/ &
        & 0.53569e-04,0.53042e-04,0.55454e-04,0.52098e-04,0.51678e-04 /)
      kao(:, 2,10) = (/ &
        & 0.52196e-04,0.51739e-04,0.54777e-04,0.54075e-04,0.50624e-04 /)
      kao(:, 3,10) = (/ &
        & 0.50339e-04,0.50046e-04,0.49769e-04,0.53168e-04,0.49370e-04 /)
      kao(:, 4,10) = (/ &
        & 0.48505e-04,0.48316e-04,0.48143e-04,0.47993e-04,0.51621e-04 /)
      kao(:, 5,10) = (/ &
        & 0.46313e-04,0.46267e-04,0.46119e-04,0.46064e-04,0.50279e-04 /)
      kao(:, 6,10) = (/ &
        & 0.42662e-04,0.42818e-04,0.42935e-04,0.43007e-04,0.43099e-04 /)
      kao(:, 7,10) = (/ &
        & 0.35762e-04,0.36149e-04,0.36450e-04,0.36639e-04,0.36887e-04 /)
      kao(:, 8,10) = (/ &
        & 0.13516e-05,0.18607e-05,0.23061e-05,0.27339e-05,0.36516e-05 /)
      kao(:, 9,10) = (/ &
        & 0.36432e-05,0.40739e-05,0.43830e-05,0.41136e-05,0.43128e-05 /)
      kao(:,10,10) = (/ &
        & 0.62049e-05,0.69116e-05,0.73244e-05,0.65087e-05,0.78951e-05 /)
      kao(:,11,10) = (/ &
        & 0.32156e-05,0.38834e-05,0.41231e-05,0.43386e-05,0.43405e-05 /)
      kao(:,12,10) = (/ &
        & 0.22152e-05,0.26754e-05,0.31971e-05,0.34911e-05,0.37935e-05 /)
      kao(:,13,10) = (/ &
        & 0.19792e-05,0.26543e-05,0.31511e-05,0.34597e-05,0.40624e-05 /)
      kao(:, 1,11) = (/ &
        & 0.75384e-04,0.75103e-04,0.77406e-04,0.74222e-04,0.73734e-04 /)
      kao(:, 2,11) = (/ &
        & 0.75458e-04,0.75244e-04,0.77778e-04,0.77018e-04,0.73942e-04 /)
      kao(:, 3,11) = (/ &
        & 0.75023e-04,0.74844e-04,0.74477e-04,0.77271e-04,0.73633e-04 /)
      kao(:, 4,11) = (/ &
        & 0.73633e-04,0.73539e-04,0.73257e-04,0.72934e-04,0.76232e-04 /)
      kao(:, 5,11) = (/ &
        & 0.71348e-04,0.71322e-04,0.71227e-04,0.71069e-04,0.75258e-04 /)
      kao(:, 6,11) = (/ &
        & 0.67784e-04,0.67873e-04,0.67974e-04,0.67924e-04,0.67903e-04 /)
      kao(:, 7,11) = (/ &
        & 0.61855e-04,0.61922e-04,0.61973e-04,0.62206e-04,0.62496e-04 /)
      kao(:, 8,11) = (/ &
        & 0.36622e-04,0.37413e-04,0.38740e-04,0.40550e-04,0.41833e-04 /)
      kao(:, 9,11) = (/ &
        & 0.28544e-05,0.28831e-05,0.31445e-05,0.32900e-05,0.27967e-05 /)
      kao(:,10,11) = (/ &
        & 0.53755e-05,0.42123e-05,0.51154e-05,0.63481e-05,0.54219e-05 /)
      kao(:,11,11) = (/ &
        & 0.12605e-05,0.14078e-05,0.19167e-05,0.23729e-05,0.30161e-05 /)
      kao(:,12,11) = (/ &
        & 0.11370e-05,0.91524e-06,0.11150e-05,0.14746e-05,0.20128e-05 /)
      kao(:,13,11) = (/ &
        & 0.10511e-05,0.10014e-05,0.11405e-05,0.13852e-05,0.15576e-05 /)
      kao(:, 1,12) = (/ &
        & 0.11184e-03,0.11117e-03,0.11327e-03,0.10989e-03,0.10910e-03 /)
      kao(:, 2,12) = (/ &
        & 0.11379e-03,0.11322e-03,0.11555e-03,0.11462e-03,0.11135e-03 /)
      kao(:, 3,12) = (/ &
        & 0.11508e-03,0.11459e-03,0.11421e-03,0.11671e-03,0.11339e-03 /)
      kao(:, 4,12) = (/ &
        & 0.11596e-03,0.11563e-03,0.11538e-03,0.11511e-03,0.11770e-03 /)
      kao(:, 5,12) = (/ &
        & 0.11597e-03,0.11581e-03,0.11569e-03,0.11553e-03,0.11890e-03 /)
      kao(:, 6,12) = (/ &
        & 0.11443e-03,0.11445e-03,0.11443e-03,0.11443e-03,0.11438e-03 /)
      kao(:, 7,12) = (/ &
        & 0.10852e-03,0.10888e-03,0.10912e-03,0.10934e-03,0.10942e-03 /)
      kao(:, 8,12) = (/ &
        & 0.93194e-04,0.94766e-04,0.95355e-04,0.95090e-04,0.94926e-04 /)
      kao(:, 9,12) = (/ &
        & 0.11836e-05,0.16115e-05,0.12883e-05,0.14202e-05,0.16541e-05 /)
      kao(:,10,12) = (/ &
        & 0.18748e-05,0.34401e-05,0.39984e-05,0.44576e-05,0.33683e-05 /)
      kao(:,11,12) = (/ &
        & 0.29890e-06,0.48741e-06,0.66276e-06,0.99698e-06,0.19230e-05 /)
      kao(:,12,12) = (/ &
        & 0.15034e-06,0.39966e-06,0.56523e-06,0.70494e-06,0.10046e-05 /)
      kao(:,13,12) = (/ &
        & 0.15016e-06,0.25751e-06,0.48928e-06,0.63534e-06,0.93575e-06 /)
      kao(:, 1,13) = (/ &
        & 0.17305e-03,0.17234e-03,0.17389e-03,0.17055e-03,0.16974e-03 /)
      kao(:, 2,13) = (/ &
        & 0.18170e-03,0.18075e-03,0.18265e-03,0.18138e-03,0.17772e-03 /)
      kao(:, 3,13) = (/ &
        & 0.18990e-03,0.18892e-03,0.18776e-03,0.18950e-03,0.18494e-03 /)
      kao(:, 4,13) = (/ &
        & 0.19649e-03,0.19552e-03,0.19424e-03,0.19281e-03,0.19464e-03 /)
      kao(:, 5,13) = (/ &
        & 0.20197e-03,0.20109e-03,0.19993e-03,0.19856e-03,0.20092e-03 /)
      kao(:, 6,13) = (/ &
        & 0.20595e-03,0.20549e-03,0.20452e-03,0.20331e-03,0.20199e-03 /)
      kao(:, 7,13) = (/ &
        & 0.20703e-03,0.20710e-03,0.20649e-03,0.20552e-03,0.20428e-03 /)
      kao(:, 8,13) = (/ &
        & 0.19874e-03,0.19767e-03,0.19696e-03,0.19655e-03,0.19591e-03 /)
      kao(:, 9,13) = (/ &
        & 0.20434e-04,0.23398e-04,0.27400e-04,0.32409e-04,0.38451e-04 /)
      kao(:,10,13) = (/ &
        & 0.18617e-05,0.99513e-06,0.10554e-05,0.16516e-05,0.37792e-05 /)
      kao(:,11,13) = (/ &
        & 0.12517e-06,0.29518e-06,0.77058e-06,0.11660e-05,0.15349e-05 /)
      kao(:,12,13) = (/ &
        & 0.12734e-06,0.36524e-06,0.66699e-06,0.10362e-05,0.14158e-05 /)
      kao(:,13,13) = (/ &
        & 0.12431e-06,0.39389e-06,0.67331e-06,0.10292e-05,0.14448e-05 /)
      kao(:, 1,14) = (/ &
        & 0.29365e-03,0.29046e-03,0.29008e-03,0.28509e-03,0.28286e-03 /)
      kao(:, 2,14) = (/ &
        & 0.31990e-03,0.31668e-03,0.31617e-03,0.31332e-03,0.30885e-03 /)
      kao(:, 3,14) = (/ &
        & 0.34787e-03,0.34432e-03,0.34112e-03,0.34052e-03,0.33589e-03 /)
      kao(:, 4,14) = (/ &
        & 0.37401e-03,0.37027e-03,0.36696e-03,0.36394e-03,0.36355e-03 /)
      kao(:, 5,14) = (/ &
        & 0.39840e-03,0.39446e-03,0.39082e-03,0.38763e-03,0.38760e-03 /)
      kao(:, 6,14) = (/ &
        & 0.42165e-03,0.41729e-03,0.41335e-03,0.41006e-03,0.40721e-03 /)
      kao(:, 7,14) = (/ &
        & 0.44257e-03,0.43782e-03,0.43364e-03,0.43014e-03,0.42736e-03 /)
      kao(:, 8,14) = (/ &
        & 0.45299e-03,0.44953e-03,0.44586e-03,0.44260e-03,0.44006e-03 /)
      kao(:, 9,14) = (/ &
        & 0.40190e-03,0.39751e-03,0.39238e-03,0.38812e-03,0.38612e-03 /)
      kao(:,10,14) = (/ &
        & 0.64278e-05,0.18248e-05,0.16996e-05,0.31086e-06,0.16836e-06 /)
      kao(:,11,14) = (/ &
        & 0.14350e-05,0.94778e-06,0.41349e-06,0.20817e-06,0.20238e-06 /)
      kao(:,12,14) = (/ &
        & 0.16805e-05,0.15323e-05,0.62348e-06,0.99743e-07,0.12977e-06 /)
      kao(:,13,14) = (/ &
        & 0.16858e-05,0.17103e-05,0.80574e-06,0.15825e-06,0.15032e-06 /)
      kao(:, 1,15) = (/ &
        & 0.52181e-03,0.51578e-03,0.51251e-03,0.50356e-03,0.49731e-03 /)
      kao(:, 2,15) = (/ &
        & 0.59491e-03,0.58822e-03,0.58413e-03,0.57646e-03,0.56692e-03 /)
      kao(:, 3,15) = (/ &
        & 0.67653e-03,0.66881e-03,0.66126e-03,0.65540e-03,0.64461e-03 /)
      kao(:, 4,15) = (/ &
        & 0.76388e-03,0.75456e-03,0.74556e-03,0.73649e-03,0.72840e-03 /)
      kao(:, 5,15) = (/ &
        & 0.85507e-03,0.84417e-03,0.83378e-03,0.82338e-03,0.81349e-03 /)
      kao(:, 6,15) = (/ &
        & 0.95034e-03,0.93798e-03,0.92553e-03,0.91287e-03,0.89957e-03 /)
      kao(:, 7,15) = (/ &
        & 0.10496e-02,0.10352e-02,0.10206e-02,0.10054e-02,0.98958e-03 /)
      kao(:, 8,15) = (/ &
        & 0.11507e-02,0.11337e-02,0.11169e-02,0.10991e-02,0.10806e-02 /)
      kao(:, 9,15) = (/ &
        & 0.12408e-02,0.12207e-02,0.11996e-02,0.11773e-02,0.11531e-02 /)
      kao(:,10,15) = (/ &
        & 0.12042e-03,0.11501e-03,0.11424e-03,0.11450e-03,0.13219e-03 /)
      kao(:,11,15) = (/ &
        & 0.68914e-06,0.83960e-06,0.74591e-06,0.18660e-05,0.32503e-05 /)
      kao(:,12,15) = (/ &
        & 0.35963e-07,0.46256e-06,0.56223e-06,0.98816e-06,0.92366e-06 /)
      kao(:,13,15) = (/ &
        & 0.36605e-07,0.56591e-06,0.84008e-06,0.86042e-06,0.68452e-06 /)
      kao(:, 1,16) = (/ &
        & 0.76517e-03,0.75944e-03,0.76010e-03,0.76100e-03,0.76498e-03 /)
      kao(:, 2,16) = (/ &
        & 0.92375e-03,0.91357e-03,0.90997e-03,0.90997e-03,0.90993e-03 /)
      kao(:, 3,16) = (/ &
        & 0.11142e-02,0.10974e-02,0.10835e-02,0.10789e-02,0.10748e-02 /)
      kao(:, 4,16) = (/ &
        & 0.13278e-02,0.13025e-02,0.12802e-02,0.12631e-02,0.12539e-02 /)
      kao(:, 5,16) = (/ &
        & 0.15712e-02,0.15343e-02,0.15017e-02,0.14713e-02,0.14497e-02 /)
      kao(:, 6,16) = (/ &
        & 0.18525e-02,0.17982e-02,0.17525e-02,0.17101e-02,0.16714e-02 /)
      kao(:, 7,16) = (/ &
        & 0.21731e-02,0.20986e-02,0.20340e-02,0.19757e-02,0.19210e-02 /)
      kao(:, 8,16) = (/ &
        & 0.25325e-02,0.24346e-02,0.23473e-02,0.22687e-02,0.21950e-02 /)
      kao(:, 9,16) = (/ &
        & 0.29269e-02,0.28006e-02,0.26863e-02,0.25805e-02,0.24878e-02 /)
      kao(:,10,16) = (/ &
        & 0.29442e-02,0.27008e-02,0.23913e-02,0.21437e-02,0.18865e-02 /)
      kao(:,11,16) = (/ &
        & 0.23220e-05,0.22310e-04,0.48349e-04,0.67183e-04,0.88908e-04 /)
      kao(:,12,16) = (/ &
        & 0.22857e-05,0.11848e-04,0.42066e-04,0.67613e-04,0.86033e-04 /)
      kao(:,13,16) = (/ &
        & 0.22823e-05,0.69105e-05,0.36212e-04,0.66247e-04,0.85488e-04 /)
  
      end subroutine sw_kgb25
